import json
import argparse

PATH_HIER_JSON = 'data/metadata/imagenet/wordnet_hierarchy.json'

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--path-to-node', nargs = '+', type = str, help = 'Category from which all children will be returned')
    return parser.parse_args()

def get_leaf_values(node):
    if 'children' not in node.keys():
        return [(node['name'], node['index'])]
    
    leaf_values = []
    for child in node['children']:
        leaf_values.extend(get_leaf_values(child))
    
    return leaf_values

def main():
    args = parse_args()

    with open(PATH_HIER_JSON, 'r') as f:
        hier = json.load(f)
        hier = hier['children']

    path_to_node = args.path_to_node

    while len(path_to_node) > 1:
        name = path_to_node.pop(0)
        for e in hier:
            if name in e['name']:
                print(f'Found {name} in {e["name"]}')
                hier = hier[hier.index(e)]['children']
                break
    root = [e for e in hier if path_to_node[0] in e['name']][0]
    leaf_values = get_leaf_values(root)
    
    for v in leaf_values:
        print(f'- {v[1]}')
    
if __name__ == '__main__':
    main()