DATASET="imagenet"

if [ "${DATASET}" = "ffhq" ]; then
    CONFIG="configs/test_ffhq.json"
    CHECKPOINT="../model_zoo/diffusion_ffhq_10m.pt"
elif [ "${DATASET}" = "imagenet" ]; then
    CONFIG="configs/test_imagenet.json"
    CHECKPOINT="./model_zoo/imagenet256.pt"
else
    echo "Invalid dataset."
fi

GLOBAL_ARGS="--save-img --ode --guidance I --config ${CONFIG} --checkpoint ${CHECKPOINT}"


for COV in convert analytic tmpd dps pgdm
do
    python sample_condition_openai.py \
        $GLOBAL_ARGS \
        --xstart-cov-type ${COV} \
        --operator-config configs/inpainting_config.yaml \
        --logdir runs/sample_condition_openai/guidance_I/${DATASET}/inpaint/${COV}

done