DATASET="imagenet"

if [ "${DATASET}" = "ffhq" ]; then
    CONFIG="configs/test_ffhq.json"
    CHECKPOINT="../model_zoo/diffusion_ffhq_10m.pt"
elif [ "${DATASET}" = "imagenet" ]; then
    CONFIG="configs/test_imagenet.json"
    CHECKPOINT="./model_zoo/imagenet256.pt"
else
    echo "Invalid dataset."
fi

GLOBAL_ARGS="--save-img --guidance II --config ${CONFIG} --checkpoint ${CHECKPOINT}"


for COV in pgdm convert analytic
do
    python sample_condition_openai.py \
        $GLOBAL_ARGS \
        --xstart-cov-type $COV \
        --operator-config configs/inpainting_config.yaml \
        --logdir runs/sample_condition_openai/guidance_II/${DATASET}/inpaint/$COV
done