from diffuser_utils import build_pipe, generate_image
import json, os

def generate_images(model_name, pipe):
    model_path = f"./Images/{model_name}"
    train_path = os.path.join(model_path, "train")
    test_path  = os.path.join(model_path, "test")
    # Train
    for ii, prompt in enumerate(prompts):
        try:
            images = generate_image(prompt, pipe, nums=nums, seed=seed)
            for i in range(len(images)):
                image = images[i]
                filename = os.path.join(train_path, f"#{ii}_{i}.png")
                image.save(filename)
        except:
            print("Train Prompt Error", prompt)
    # Test
    for ii, prompt in enumerate(tests):
        try:
            images = generate_image(prompt, pipe, nums=nums, seed=seed)
            for i in range(len(images)):
                image = images[i]
                filename = os.path.join(test_path, f"#{ii}_{i}.png")
                image.save(filename)
        except:
            print("Test Prompt Error", prompt)

with open("ModelPool.json", "r") as f:
    models = json.load(f)
    
with open("PromptPool.json", "r") as f:
    prompts = json.load(f)
    
with open("PromptTest.json", "r") as f:
    tests = json.load(f)
    
seed = 0
nums = 10
pipes = []
for model_name in models:
    model_config = models[model_name]
    print(model_name)
    pipe = build_pipe(model_config)
    # pipes.append(pipe)
    model_path = f"./Images/{model_name}"
    train_path = os.path.join(model_path, "train")
    test_path  = os.path.join(model_path, "test")
    if not os.path.exists(train_path): os.makedirs(train_path)
    if not os.path.exists(test_path): os.makedirs(test_path)
    generate_images(model_name, pipe)
