import os
import os.path as osp

import numpy as np
import torch
from PIL import Image
from torch.utils.data import Dataset
from torchvision import transforms


#fourier
class MiniImageNet(Dataset):

    def __init__(self, root='/home/datasets', train=True, transform=None, index_path=None, index=None, base_sess=None, two_images=False, validation=False):
        if train:
            setname = 'train'
        else:
            setname = 'test'
        self.root = os.path.expanduser(root)
        self.transform = transform
        self.train = train  # training set or test set
        self.IMAGE_PATH = os.path.join(root, 'miniimagenet/images')
        self.SPLIT_PATH = os.path.join(root, 'miniimagenet/split')

        csv_path = osp.join(self.SPLIT_PATH, setname + '.csv')
        lines = [x.strip() for x in open(csv_path, 'r').readlines()][1:]

        self.data = []
        self.targets = []
        self.data2label = {}
        lb = -1

        self.wnids = []

        for l in lines:
            name, wnid = l.split(',')
            path = osp.join(self.IMAGE_PATH, name)
            if wnid not in self.wnids:
                self.wnids.append(wnid)
                lb += 1
            self.data.append(path)
            self.targets.append(lb)
            self.data2label[path] = lb

        self.image_size = 84
        train_transforms = transforms.Compose([
                transforms.Resize([92, 92]),
                transforms.RandomResizedCrop(self.image_size, scale=(0.2, 1.)),
                transforms.RandomHorizontalFlip(),
                transforms.RandomApply([transforms.ColorJitter(0.4, 0.4, 0.4, 0.1)], p=0.8)#,  # not strengthened
            ])

        train_transforms_v2 = transforms.Compose([
            transforms.Resize([92, 92]),
            transforms.RandomResizedCrop(self.image_size),
            # transforms.ColorJitter(brightness=0.4, contrast=0.4, saturation=0.4),
            transforms.RandomHorizontalFlip()])

        transform_test = transforms.Compose([
            transforms.Resize([92, 92]),
            transforms.CenterCrop(self.image_size)
        ])

        transform_test_v2 = transforms.Compose([
            transforms.Resize([92, 92]),
            transforms.CenterCrop(self.image_size)])

        base_transforms = transforms.Compose([
            transforms.Resize([92, 92]),
            transforms.CenterCrop(self.image_size)
        ])

        base_transforms_v2 = transforms.Compose([
            transforms.Resize([92, 92]),
            transforms.CenterCrop(self.image_size)
        ])

        if train:
            if validation:
                print('---- ImageNet Base Transform ---')
                self.transform = base_transforms
            elif not base_sess:
                print('---- ImageNet Base Transform ---')
                self.transform = base_transforms
            else:
                if two_images:
                    print('---- ImageNet TwoCrops Training Transform ---')
                    self.transform = TwoCropsTransform(train_transforms)
                else:
                    print('---- ImageNet OneCrops Training Transform ---')
                    self.transform = train_transforms

            if base_sess:
                self.data, self.targets = self.SelectfromClasses(self.data, self.targets, index)
            else:
                self.data, self.targets = self.SelectfromTxt(self.data2label, index_path)
        else:
            if validation:
                print('---- ImageNet Base Transform ---')
                self.transform = base_transforms
            else:
                print('---- ImageNet Testing Transform ---')
                self.transform = transform_test

            self.data, self.targets = self.SelectfromClasses(self.data, self.targets, index)

    def SelectfromTxt(self, data2label, index_path):
        index=[]

        for i in range(len(index_path)):
            lines = [x.strip() for x in open(index_path[i], 'r').readlines()]
            for line in lines:
                index.append(line.split('/')[3])

        data_tmp = []
        targets_tmp = []
        for i in index:
            img_path = os.path.join(self.IMAGE_PATH, i)
            data_tmp.append(img_path)
            targets_tmp.append(data2label[img_path])

        return data_tmp, targets_tmp

    def SelectfromClasses(self, data, targets, index):
        data_tmp = []
        targets_tmp = []
        for i in index:
            ind_cl = np.where(i == targets)[0]
            for j in ind_cl:
                data_tmp.append(data[j])
                targets_tmp.append(targets[j])

        return data_tmp, targets_tmp

    def __len__(self):
        return len(self.data)

    def __getitem__(self, i):
        path, targets = self.data[i], self.targets[i]
        image = self.transform(Image.open(path).convert('RGB'))
        image = np.array(image)
        n = 42
        c = 2
        if len(image) == 2:
            output = []
            for img in image:
                img = np.array(img)
                image = torch.Tensor(img)
            
                image = image.permute(2,0,1)
                #print(image.shape)
                r_img = image[0]
                g_img = image[1]
                b_img = image[2]
                
                # R
                r_f = torch.fft.fft2(r_img)
                r_fshift = torch.fft.fftshift(r_f)

                # G
                g_f = torch.fft.fft2(g_img)
                g_fshift = torch.fft.fftshift(g_f)

                # B
                b_f = torch.fft.fft2(b_img)
                b_fshift = torch.fft.fftshift(b_f)

                (w, h) = r_fshift.shape
                half_w, half_h = int(w/2), int(h/2)
                
                
                ch_arr = []
                r_fshift_ori = r_fshift.clone()
                g_fshift_ori = g_fshift.clone()
                b_fshift_ori = b_fshift.clone()

                for j in range(c):
                    filter = int(self.image_size/c/2)*j
                    r_filter = half_h - filter - int(n/2)
                    l_filter = half_h + filter + int(n/2)
                    if r_filter < 0:
                        r_filter = 0
                    if l_filter > self.image_size:
                        l_filter = 84
                    r_fshift = r_fshift_ori.clone()
                    r_fshift[0:r_filter, :] = 0
                    r_fshift[l_filter:, :] = 0
                    r_fshift[:, 0:r_filter] = 0
                    r_fshift[:, l_filter:] = 0
                    r_fshift[half_w - filter : half_w + filter, half_h - filter : half_h + filter] = 0
                    r_fshift = torch.fft.ifftshift(r_fshift)
                    r_liu = torch.fft.ifft2(r_fshift).real
                    ch_arr.append(r_liu)

                    g_fshift = g_fshift_ori.clone()
                    g_fshift[0:r_filter, :] = 0
                    g_fshift[l_filter:, :] = 0
                    g_fshift[:, 0:r_filter] = 0
                    g_fshift[:, l_filter:] = 0
                    g_fshift[half_w - filter : half_w + filter, half_h - filter : half_h + filter] = 0
                    g_fshift = torch.fft.ifftshift(g_fshift)
                    g_liu = torch.fft.ifft2(g_fshift).real
                    ch_arr.append(g_liu)

                    b_fshift = b_fshift_ori.clone()
                    b_fshift[0:r_filter, :] = 0
                    b_fshift[l_filter:, :] = 0
                    b_fshift[:, 0:r_filter] = 0
                    b_fshift[:, l_filter:] = 0
                    b_fshift[half_w - filter : half_w + filter, half_h - filter : half_h + filter] = 0
                    b_fshift = torch.fft.ifftshift(b_fshift)
                    b_liu = torch.fft.ifft2(b_fshift).real
                    ch_arr.append(b_liu)
                
                ch_arr = torch.stack(ch_arr, dim = 0)
                ch_arr = ch_arr.type(torch.float32)
                output.append(ch_arr)
        else:
            image = torch.Tensor(image)
            
            image = image.permute(2,0,1)
            r_img = image[0]
            g_img = image[1]
            b_img = image[2]
            
            # R
            r_f = torch.fft.fft2(r_img)
            r_fshift = torch.fft.fftshift(r_f)

            # G
            g_f = torch.fft.fft2(g_img)
            g_fshift = torch.fft.fftshift(g_f)

            # B
            b_f = torch.fft.fft2(b_img)
            b_fshift = torch.fft.fftshift(b_f)

            (w, h) = r_fshift.shape
            half_w, half_h = int(w/2), int(h/2)
                
            ch_arr = []
            r_fshift_ori = r_fshift.clone()
            g_fshift_ori = g_fshift.clone()
            b_fshift_ori = b_fshift.clone()

            for j in range(c):
                filter = int(self.image_size/c/2)*j
                r_filter = half_h - filter - int(n/2)
                l_filter = half_h + filter + int(n/2)
                if r_filter < 0:
                    r_filter = 0
                if l_filter > self.image_size:
                    l_filter = 84
                r_fshift = r_fshift_ori.clone()
                r_fshift[0:r_filter, :] = 0
                r_fshift[l_filter:, :] = 0
                r_fshift[:, 0:r_filter] = 0
                r_fshift[:, l_filter:] = 0
                r_fshift[half_w - filter : half_w + filter, half_h - filter : half_h + filter] = 0
                r_fshift = torch.fft.ifftshift(r_fshift)
                r_liu = torch.fft.ifft2(r_fshift).real
                ch_arr.append(r_liu)

                g_fshift = g_fshift_ori.clone()
                g_fshift[0:r_filter, :] = 0
                g_fshift[l_filter:, :] = 0
                g_fshift[:, 0:r_filter] = 0
                g_fshift[:, l_filter:] = 0
                g_fshift[half_w - filter : half_w + filter, half_h - filter : half_h + filter] = 0
                g_fshift = torch.fft.ifftshift(g_fshift)
                g_liu = torch.fft.ifft2(g_fshift).real
                ch_arr.append(g_liu)

                b_fshift = b_fshift_ori.clone()
                b_fshift[0:r_filter, :] = 0
                b_fshift[l_filter:, :] = 0
                b_fshift[:, 0:r_filter] = 0
                b_fshift[:, l_filter:] = 0
                b_fshift[half_w - filter : half_w + filter, half_h - filter : half_h + filter] = 0
                b_fshift = torch.fft.ifftshift(b_fshift)
                b_liu = torch.fft.ifft2(b_fshift).real
                ch_arr.append(b_liu)
                
            ch_arr = torch.stack(ch_arr, dim = 0)
            output = ch_arr.type(torch.float32)
        
        return output, targets


class TwoCropsTransform:
    """Take two random crops of one image as the query and key."""

    def __init__(self, base_transform):
        self.base_transform = base_transform

    def __call__(self, x):
        q = self.base_transform(x)
        k = self.base_transform(x)
        return [q, k]


class GaussianBlur(object):
    """Gaussian blur augmentation in SimCLR https://arxiv.org/abs/2002.05709"""

    def __init__(self, sigma=[.1, 2.]):
        self.sigma = sigma

    def __call__(self, x):
        sigma = random.uniform(self.sigma[0], self.sigma[1])
        x = x.filter(ImageFilter.GaussianBlur(radius=sigma))
        return x


