import os
import os.path as osp

import numpy as np
import torch
from PIL import Image
from torch.utils.data import Dataset
from torchvision import transforms
from .autoaugment import AutoAugImageNetPolicy

class MiniImageNet(Dataset):

    def __init__(self, root='/home/main/datasets', train=True,
                 transform=None,
                 index_path=None, index=None, base_sess=None,autoaug=1):
        if train:
            setname = 'train'
        else:
            setname = 'test'
        self.root = os.path.expanduser(root)
        self.transform = transform
        self.train = train  # training set or test set
        self.IMAGE_PATH = os.path.join(root, 'miniimagenet/images')
        self.SPLIT_PATH = os.path.join(root, 'miniimagenet/split')

        csv_path = osp.join(self.SPLIT_PATH, setname + '.csv')
        lines = [x.strip() for x in open(csv_path, 'r').readlines()][1:]

        self.data = []
        self.targets = []
        self.data2label = {}
        lb = -1

        self.wnids = []

        for l in lines:
            name, wnid = l.split(',')
            path = osp.join(self.IMAGE_PATH, name)
            if wnid not in self.wnids:
                self.wnids.append(wnid)
                lb += 1
            self.data.append(path)
            self.targets.append(lb)
            self.data2label[path] = lb

        
        if autoaug==0:
            #do not use autoaug.
            if train:
                image_size = 84
                self.transform = transforms.Compose([
                    transforms.RandomResizedCrop(image_size),
                    # transforms.ColorJitter(brightness=0.4, contrast=0.4, saturation=0.4),
                    transforms.RandomHorizontalFlip()])
                if base_sess:
                    self.data, self.targets = self.SelectfromClasses(self.data, self.targets, index)
                else:
                    self.data, self.targets = self.SelectfromTxt(self.data2label, index_path)
            else:
                image_size = 84
                self.transform = transforms.Compose([
                    transforms.Resize([92, 92]),
                    transforms.CenterCrop(image_size)])
                self.data, self.targets = self.SelectfromClasses(self.data, self.targets, index)
        else:
            #use autoaug.
            if train:
                image_size = 84
                self.transform = transforms.Compose([
                    transforms.RandomResizedCrop(image_size),
                    # transforms.ColorJitter(brightness=0.4, contrast=0.4, saturation=0.4),
                    transforms.RandomHorizontalFlip(),
                    #add autoaug
                    AutoAugImageNetPolicy()])
                if base_sess:
                    self.data, self.targets = self.SelectfromClasses(self.data, self.targets, index)
                else:
                    self.data, self.targets = self.SelectfromTxt(self.data2label, index_path)
            else:
                image_size = 84
                self.transform = transforms.Compose([
                    transforms.Resize([92, 92]),
                    transforms.CenterCrop(image_size)])
                self.data, self.targets = self.SelectfromClasses(self.data, self.targets, index)

    def SelectfromTxt(self, data2label, index_path):
        #select from txt file, and make cooresponding mampping.
        index=[]
        lines = [x.strip() for x in open(index_path, 'r').readlines()]
        for line in lines:
            index.append(line.split('/')[3])
        data_tmp = []
        targets_tmp = []
        for i in index:
            img_path = os.path.join(self.IMAGE_PATH, i)
            data_tmp.append(img_path)
            targets_tmp.append(data2label[img_path])

        return data_tmp, targets_tmp

    def SelectfromClasses(self, data, targets, index):
        #select from csv file, choose all instances from this class.
        data_tmp = []
        targets_tmp = []
        for i in index:
            ind_cl = np.where(i == targets)[0]
            for j in ind_cl:
                data_tmp.append(data[j])
                targets_tmp.append(targets[j])

        return data_tmp, targets_tmp

    def __len__(self):
        return len(self.data)

    def __getitem__(self, i):

        path, targets = self.data[i], self.targets[i]
        image = self.transform(Image.open(path).convert('RGB'))
        image = np.array(image)
        image = np.transpose(image, [2, 0, 1])
        #print(image.shape)
        r_img = image[0]
        g_img = image[1]
        b_img = image[2]
        
        # R
        r_f = np.fft.fft2(r_img)
        r_fshift = np.fft.fftshift(r_f)
        #r_magnitude_spectrum = 20*np.log(abs(r_f))
        #r_phase = np.angle(r_fshift)

        # G
        g_f = np.fft.fft2(g_img)
        g_fshift = np.fft.fftshift(g_f)
        #g_magnitude_spectrum = 20*np.log(abs(g_f))
        #g_phase = np.angle(g_fshift)

        # B
        b_f = np.fft.fft2(b_img)
        b_fshift = np.fft.fftshift(b_f)
        #b_magnitude_spectrum = 20*np.log(abs(b_f))
        #b_phase = np.angle(b_fshift)

        (w, h) = r_fshift.shape
        half_w, half_h = int(w/2), int(h/2)
        n = 42
        
        ch_arr = []
        r_fshift_ori = r_fshift.copy()
        g_fshift_ori = g_fshift.copy()
        b_fshift_ori = b_fshift.copy()

        for i in range(2):
            r_fshift = r_fshift_ori.copy()
            r_fshift[0:half_h - int(n/2)*i - int(n/2), :] = 0
            r_fshift[half_h + int(n/2)*i + int(n/2):, :] = 0
            r_fshift[:, 0:half_h - int(n/2)*i - int(n/2)] = 0
            r_fshift[:, half_h + int(n/2)*i + int(n/2):] = 0
            r_fshift[half_w - int(n/2)*i : half_w + int(n/2)*i, half_h - int(n/2)*i : half_h + int(n/2)*i] = 0
            r_fshift = np.fft.ifftshift(r_fshift)
            r_liu = np.fft.ifft2(r_fshift).real
            ch_arr.append(r_liu)

            g_fshift = g_fshift_ori.copy()
            g_fshift[0:half_h - int(n/2)*i - int(n/2), :] = 0
            g_fshift[half_h + int(n/2)*i + int(n/2):, :] = 0
            g_fshift[:, 0:half_h - int(n/2)*i - int(n/2)] = 0
            g_fshift[:, half_h + int(n/2)*i + int(n/2):] = 0
            g_fshift[half_w - int(n/2)*i : half_w + int(n/2)*i, half_h - int(n/2)*i : half_h + int(n/2)*i] = 0
            g_fshift = np.fft.ifftshift(g_fshift)
            g_liu = np.fft.ifft2(g_fshift).real
            ch_arr.append(g_liu)

            b_fshift = b_fshift_ori.copy()
            b_fshift[0:half_h - int(n/2)*i - int(n/2), :] = 0
            b_fshift[half_h + int(n/2)*i + int(n/2):, :] = 0
            b_fshift[:, 0:half_h - int(n/2)*i - int(n/2)] = 0
            b_fshift[:, half_h + int(n/2)*i + int(n/2):] = 0
            b_fshift[half_w - int(n/2)*i : half_w + int(n/2)*i, half_h - int(n/2)*i : half_h + int(n/2)*i] = 0
            b_fshift = np.fft.ifftshift(b_fshift)
            b_liu = np.fft.ifft2(b_fshift).real
            ch_arr.append(b_liu)
        

        ch_arr = np.array(ch_arr)
        ch_arr = ch_arr.astype(np.float32)

        return ch_arr, targets


class MiniImageNet_concate(Dataset):
    def __init__(self, train,x1,y1,x2,y2):
        
        if train:
            image_size = 84
            self.transform = transforms.Compose([
                transforms.RandomResizedCrop(image_size),
                # transforms.ColorJitter(brightness=0.4, contrast=0.4, saturation=0.4),
                transforms.RandomHorizontalFlip()])
            
        else:
            image_size = 84
            self.transform = transforms.Compose([
                transforms.Resize([92, 92]),
                transforms.CenterCrop(image_size)])
            
        
        self.data=x1+x2
        self.targets=y1+y2
        print('concate', len(self.data),len(self.targets))

    def __len__(self):
        return len(self.data)

    def __getitem__(self, i):

        path, targets = self.data[i], self.targets[i]
        image = self.transform(Image.open(path).convert('RGB'))

        image = np.array(image)
        image = np.transpose(image, [2, 0, 1])
        #print(image.shape)
        r_img = image[0]
        g_img = image[1]
        b_img = image[2]
        
        # R
        r_f = np.fft.fft2(r_img)
        r_fshift = np.fft.fftshift(r_f)
        #r_magnitude_spectrum = 20*np.log(abs(r_f))
        #r_phase = np.angle(r_fshift)

        # G
        g_f = np.fft.fft2(g_img)
        g_fshift = np.fft.fftshift(g_f)
        #g_magnitude_spectrum = 20*np.log(abs(g_f))
        #g_phase = np.angle(g_fshift)

        # B
        b_f = np.fft.fft2(b_img)
        b_fshift = np.fft.fftshift(b_f)
        #b_magnitude_spectrum = 20*np.log(abs(b_f))
        #b_phase = np.angle(b_fshift)

        (w, h) = r_fshift.shape
        half_w, half_h = int(w/2), int(h/2)
        n = 42
        
        ch_arr = []
        r_fshift_ori = r_fshift.copy()
        g_fshift_ori = g_fshift.copy()
        b_fshift_ori = b_fshift.copy()

        for i in range(2):
            r_fshift = r_fshift_ori.copy()
            r_fshift[0:half_h - int(n/2)*i - int(n/2), :] = 0
            r_fshift[half_h + int(n/2)*i + int(n/2):, :] = 0
            r_fshift[:, 0:half_h - int(n/2)*i - int(n/2)] = 0
            r_fshift[:, half_h + int(n/2)*i + int(n/2):] = 0
            r_fshift[half_w - int(n/2)*i : half_w + int(n/2)*i, half_h - int(n/2)*i : half_h + int(n/2)*i] = 0
            r_fshift = np.fft.ifftshift(r_fshift)
            r_liu = np.fft.ifft2(r_fshift).real
            ch_arr.append(r_liu)

            g_fshift = g_fshift_ori.copy()
            g_fshift[0:half_h - int(n/2)*i - int(n/2), :] = 0
            g_fshift[half_h + int(n/2)*i + int(n/2):, :] = 0
            g_fshift[:, 0:half_h - int(n/2)*i - int(n/2)] = 0
            g_fshift[:, half_h + int(n/2)*i + int(n/2):] = 0
            g_fshift[half_w - int(n/2)*i : half_w + int(n/2)*i, half_h - int(n/2)*i : half_h + int(n/2)*i] = 0
            g_fshift = np.fft.ifftshift(g_fshift)
            g_liu = np.fft.ifft2(g_fshift).real
            ch_arr.append(g_liu)

            b_fshift = b_fshift_ori.copy()
            b_fshift[0:half_h - int(n/2)*i - int(n/2), :] = 0
            b_fshift[half_h + int(n/2)*i + int(n/2):, :] = 0
            b_fshift[:, 0:half_h - int(n/2)*i - int(n/2)] = 0
            b_fshift[:, half_h + int(n/2)*i + int(n/2):] = 0
            b_fshift[half_w - int(n/2)*i : half_w + int(n/2)*i, half_h - int(n/2)*i : half_h + int(n/2)*i] = 0
            b_fshift = np.fft.ifftshift(b_fshift)
            b_liu = np.fft.ifft2(b_fshift).real
            ch_arr.append(b_liu)
        

        ch_arr = np.array(ch_arr)
        ch_arr = ch_arr.astype(np.float32)

        return ch_arr, targets

if __name__ == '__main__':
    txt_path = "../../data/index_list/mini_imagenet/session_1.txt"
    # class_index = open(txt_path).read().splitlines()
    base_class = 100
    class_index = np.arange(base_class)
    dataroot = '/home/main/datasets'
    batch_size_base = 400
    trainset = MiniImageNet(root=dataroot, train=True, transform=None, index_path=txt_path)
    cls = np.unique(trainset.targets)
    trainloader = torch.utils.data.DataLoader(dataset=trainset, batch_size=batch_size_base, shuffle=True, num_workers=8,
                                              pin_memory=True)
    print(trainloader.dataset.data.shape)
    