import os
import json

def extract_best_metrics(log_path):
    best_balanced_acc = -1
    best_test_acc1 = -1
    best_balanced_epoch = -1
    best_test_acc1_epoch = -1

    with open(log_path, 'r') as f:
        for line in f:
            try:
                data = json.loads(line)
                bal_acc = data.get("test_balanced_acc", -1)
                acc1 = data.get("test_acc1", -1)
                epoch = data.get("epoch", -1)

                if bal_acc > best_balanced_acc:
                    best_balanced_acc = bal_acc
                    best_balanced_epoch = epoch
                if acc1 > best_test_acc1:
                    best_test_acc1 = acc1
                    best_test_acc1_epoch = epoch
            except json.JSONDecodeError:
                continue

    return {
        "best_balanced_acc": best_balanced_acc,
        "best_balanced_epoch": best_balanced_epoch,
        "best_test_acc1": best_test_acc1,
        "best_test_acc1_epoch": best_test_acc1_epoch
    }

def scan_all_logs(base_dir):
    results = {}
    for from_base in sorted(os.listdir(base_dir)):
        from_base_path = os.path.join(base_dir, from_base)
        if not os.path.isdir(from_base_path):
            continue
        for continual in sorted(os.listdir(from_base_path)):
            continual_path = os.path.join(from_base_path, continual)
            log_file = os.path.join(continual_path, "log.txt")
            if os.path.isfile(log_file):
                key = f"{from_base}/{continual}"
                results[key] = extract_best_metrics(log_file)
    return results

if __name__ == "__main__":
    base_directory = "/results/leonardo/results/hiba_continual_isic_90perc_LP"  # change this if needed
    all_results = scan_all_logs(base_directory)

    for key in sorted(all_results):
        result = all_results[key]
        print(f"\n📁 {key}")
        print(f"  ✅ test_balanced_acc: {result['best_balanced_acc']:.4f} (Epoch {result['best_balanced_epoch']})")
        print(f"  ✅ test_acc1:         {result['best_test_acc1']:.4f} (Epoch {result['best_test_acc1_epoch']})")
