import networkx as nx
import random
import numpy as np
from scipy.spatial import Delaunay

names = [
    "James", # 100 most common male and female US names
    "Michael",
    "Robert",
    "John",
    "David",
    "William",
    "Richard",
    "Joseph",
    "Thomas",
    "Christopher",
    "Charles",
    "Daniel",
    "Matthew",
    "Anthony",
    "Mark",
    "Donald",
    "Steven",
    "Andrew",
    "Paul",
    "Joshua",
    "Kenneth",
    "Kevin",
    "Brian",
    "Timothy",
    "Ronald",
    "George",
    "Jason",
    "Edward",
    "Jeffrey",
    "Ryan",
    "Jacob",
    "Nicholas",
    "Gary",
    "Eric",
    "Jonathan",
    "Stephen",
    "Larry",
    "Justin",
    "Scott",
    "Brandon",
    "Benjamin",
    "Samuel",
    "Gregory",
    "Alexander",
    "Patrick",
    "Frank",
    "Raymond",
    "Jack",
    "Dennis",
    "Jerry",
    "Tyler",
    "Aaron",
    "Jose",
    "Adam",
    "Nathan",
    "Henry",
    "Zachary",
    "Douglas",
    "Peter",
    "Kyle",
    "Noah",
    "Ethan",
    "Jeremy",
    "Christian",
    "Walter",
    "Keith",
    "Austin",
    "Roger",
    "Terry",
    "Sean",
    "Gerald",
    "Carl",
    "Dylan",
    "Harold",
    "Jordan",
    "Jesse",
    "Bryan",
    "Lawrence",
    "Arthur",
    "Gabriel",
    "Bruce",
    "Logan",
    "Billy",
    "Joe",
    "Alan",
    "Juan",
    "Elijah",
    "Willie",
    "Albert",
    "Wayne",
    "Randy",
    "Mason",
    "Vincent",
    "Liam",
    "Roy",
    "Bobby",
    "Caleb",
    "Bradley",
    "Russell",
    "Lucas",
    "Mary",
    "Patricia",
    "Jennifer",
    "Linda",
    "Elizabeth",
    "Barbara",
    "Susan",
    "Jessica",
    "Karen",
    "Sarah",
    "Lisa",
    "Nancy",
    "Sandra",
    "Betty",
    "Ashley",
    "Emily",
    "Kimberly",
    "Margaret",
    "Donna",
    "Michelle",
    "Carol",
    "Amanda",
    "Melissa",
    "Deborah",
    "Stephanie",
    "Rebecca",
    "Sharon",
    "Laura",
    "Cynthia",
    "Dorothy",
    "Amy",
    "Kathleen",
    "Angela",
    "Shirley",
    "Emma",
    "Brenda",
    "Pamela",
    "Nicole",
    "Anna",
    "Samantha",
    "Katherine",
    "Christine",
    "Debra",
    "Rachel",
    "Carolyn",
    "Janet",
    "Maria",
    "Olivia",
    "Heather",
    "Helen",
    "Catherine",
    "Diane",
    "Julie",
    "Victoria",
    "Joyce",
    "Lauren",
    "Kelly",
    "Christina",
    "Ruth",
    "Joan",
    "Virginia",
    "Judith",
    "Evelyn",
    "Hannah",
    "Andrea",
    "Megan",
    "Cheryl",
    "Jacqueline",
    "Madison",
    "Teresa",
    "Abigail",
    "Sophia",
    "Martha",
    "Sara",
    "Gloria",
    "Janice",
    "Kathryn",
    "Ann",
    "Isabella",
    "Judy",
    "Charlotte",
    "Julia",
    "Grace",
    "Amber",
    "Alice",
    "Jean",
    "Denise",
    "Frances",
    "Danielle",
    "Marilyn",
    "Natalie",
    "Beverly",
    "Diana",
    "Brittany",
    "Theresa",
    "Kayla",
    "Alexis",
    "Doris",
    "Lori",
    "Tiffany",
]

def relabel_and_name_vertices(graph: nx.Graph) -> nx.Graph:
    graph = nx.relabel_nodes(graph, {v: i for i, v in enumerate(graph.nodes)})
    node_names = random.sample(names, graph.order())
    nx.set_node_attributes(graph, {i: name for i, name in enumerate(node_names)}, "name")
    return graph


def generate_ws_graph(n, seed=0):
    graph = nx.connected_watts_strogatz_graph(n, 4, 0.4, seed=seed)

    return graph


def generate_ba_graph(n, seed=None):
    graph = nx.barabasi_albert_graph(n, 2, seed=seed).to_undirected()

    return graph


def generate_delaunay_triangulation(n, seed=None):
    np.random.seed(seed)
    points = np.random.rand(n, 2)

    tri = Delaunay(points)

    graph = nx.Graph()
    graph.add_nodes_from(range(len(points)))

    for simplex in tri.simplices:
        for i in range(3):
            u, v = simplex[i], simplex[(i + 1) % 3]
            graph.add_edge(u, v)

    return graph



