# Rethinking GNNs and Missing Features: Challenges, Evaluation and a Robust Solution

This repository contains the codebase used in the paper:

> **Rethinking GNNs and Missing Features: Challenges, Evaluation and a Robust Solution**

The project provides datasets, models, and evaluation protocols to study the robustness of **Graph Neural Networks (GNNs)** under different missing feature mechanisms.

---


## Usage

Run experiments with:

```bash
python main.py --dataset <dataset> --models <model(s)> --mechanisms <mechanism(s)>
```

## Arguments

### `--dataset`
Choose the dataset to evaluate. All datasets are stored/loaded from `./data/`.
Available options:
`synthetic` – synthetic graph with dense, controlled features
`Cora`, `Citeseer`, `PubMed` – citation networks (downloaded automatically via PyG)
`electric` – electric network dataset
`air` – air quality dataset
`tadpole` – Alzheimer’s disease progression dataset 

### `--models`
Specify one or more models to evaluate. Multiple models can be listed separated by spaces.
Available options:

`fairac` 
`gcnmi` 
`gnnmim` – our
`gcnmf` 
`fp` 
`pcfi` 
`gspn` 
`goodie` 


### `--mechanisms`
Select the missingness mechanisms to simulate. Multiple mechanisms can be listed separated by spaces.
Available options:
`UMCAR` – Uniform Missing Completely At Random
`SMCAR` – Structured MCAR
`LDMCAR` – Label-Depedant MCAR
`FDMNAR` – Feature-Dependent MNAR
`CDMNAR` – Class-Dependent MNAR