# PTaRL Implementation

This repository contains the implementation of **PTaRL** and its evaluation across various datasets and model baselines.

## Repository Structure

```
.
├── baseline_results
│   ├── AutoInt
│   │   └── log files for AutoInt baseline results on multiple datasets
│   ├── DCNv2
│   │   └── log files for DCNv2 baseline results on multiple datasets
│   ├── fttransformer
│   │   └── log files for fttransformer baseline results on multiple datasets
│   ├── MLP
│   │   └── log files for MLP baseline results on multiple datasets
│   └── Resnet
│       └── log files for Resnet baseline results on multiple datasets
├── data
│   └── Dataset-specific splits, metadata, and labels
├── data.py                # Script to manage dataset operations
├── generate_splits.py     # Script to generate dataset splits
├── get_data_from_logs.py  # Script to extract data insights from log files
├── hypers_default
│   └── Default hyperparameter configurations for various baselines and datasets
├── lib
│   └── Core library files and utilities
├── Models
│   └── Model definitions
├── models.py              # Main script for managing model training and evaluation
├── README.md              # Project documentation
├── run_20_times.sh        # Script to run experiments 20 times for statistical significance
├── src
│   └── Core dataset and model management utilities
├── tokenizer
│   └── Tokenizer configurations
└── train_final_version.py # Main script for training PTaRL
```

## Running PTaRL

To run **PTaRL** with MLP as the backbone model on the `california_housing` and `jannis` datasets:

1. Run the following commands:

    ```bash
    python train_final_version.py --model_type MLP_ot --dataname california_housing
    python train_final_version.py --model_type MLP_ot --dataname jannis
    ```

## Baseline Results

Logs for various baseline models (AutoInt, DCNv2, fttransformer, MLP, Resnet) across datasets are available in the `baseline_results` directory.

## Data

Dataset splits, metadata, and labels are stored in the `data` directory. Each dataset contains:
- Training, validation, and test splits
- Corresponding labels

## Default Hyperparameters

Default hyperparameter configurations for each baseline model are available in the `hypers_default` directory, organized by dataset.
