import glob
import numpy as np
import os
import sys


def main(dataset, model):
    # Define log path and log file dynamically
    log_path = f"logs/{dataset}/{model}/*.log"
    print(f"Log path: {log_path}")
    log_file = f"log_{model}_{dataset}.log"

    if os.path.exists(log_file):
        os.remove(log_file)

    # Gather log files
    files = glob.glob(log_path)
    files = sorted(files, key=os.path.getmtime)[-20:]

    print(f"Number of log files found: {len(files)}")
    print("Files:", files)

    results_orig = []

    for file in files:
        with open(file, "r") as f:
            lines = f.readlines()
            for line in lines:
                if "test result, " in line:
                    with open(log_file, "a") as log:
                        log.write(f"{file}: {line}")
                    test_result_original = line.split()[-1]
                    results_orig.append(float(test_result_original))

    print("Results:", results_orig)
    if results_orig:
        print("Original:", np.mean(results_orig), np.std(results_orig))
    else:
        print("No test results found in the logs.")


if __name__ == "__main__":
    if len(sys.argv) != 3:
        print("Usage: python script.py <dataset> <model>")
        sys.exit(1)

    dataset = sys.argv[1]
    model = sys.argv[2]

    main(dataset, model)
