from scipy.io import arff
import os
import numpy as np
import pandas as pd

from src.datasets.base import BaseDataset
from src.datasets.mnist import load_mnist_data
from src.utils.models_utils import TASK_TYPE


class MNISTEmbedded(BaseDataset):

    def __init__(self, args):
        super(MNISTEmbedded, self).__init__(args)

        self.is_data_loaded = False
        self.tmp_file_names = [
            "mnist_embedded.npy",
        ]
        self.name = "mnist_embedded"
        self.args = args
        self.task_type = TASK_TYPE.MULTI_CLASS

    def load(self):

        embedded_data = np.load(os.path.join(self.data_path, self.tmp_file_names[0]))

        x, y = load_mnist_data()

        self.X = embedded_data
        self.y = y

        self.N, self.D, self.H = embedded_data.shape
        self.D -= 1
        self.cls = 1

        del embedded_data

        self.cardinalities = []
        self.num_or_cat = {}

        self.cat_features = []
        self.num_features = list(range(self.D))

        self.num_or_cat = {idx: (idx in self.num_features) for idx in range(self.D)}

        self.is_data_loaded = True
