function duplicateIndices = DuplicateColumnIndices(matrix)
    [numRows, numCols] = size(matrix);
    duplicateIndices = [];

    for col1 = 1:numCols
        for col2 = col1+1:numCols
            if isequal(matrix(:, col1), matrix(:, col2))
                duplicateIndices = [duplicateIndices, col1, col2];
            end
        end
    end

    duplicateIndices = unique(duplicateIndices);
end
