function [precision, recall, corrRate,NumVFCCorrect] = evaluate(CorrectIndex, VFCIndex, siz,fid)


if length(VFCIndex)==0
    VFCIndex = 1:siz;
end

tmp=zeros(1, siz);
tmp(VFCIndex) = 1;
tmp(CorrectIndex) = tmp(CorrectIndex)+1;
VFCCorrect = find(tmp == 2);
NumCorrectIndex = length(CorrectIndex);
NumVFCIndex = length(VFCIndex);
NumVFCCorrect = length(VFCCorrect);

corrRate = NumCorrectIndex/siz;
precision = NumVFCCorrect/NumVFCIndex;
recall = NumVFCCorrect/NumCorrectIndex;
f_score = (2*precision*recall)/(precision+recall);


fprintf('precision rate: %d/%d = %f\r\n', NumVFCCorrect, NumVFCIndex, precision);
fprintf('recall rate: %d/%d = %f\r\n', NumVFCCorrect, NumCorrectIndex, recall);
fprintf('f_score: %f', f_score);
