# src/apps/clients/cache.py
# --------------------------------------------------
#   Very small, process‑local subnet cache
# --------------------------------------------------
from copy import deepcopy
from typing import Callable, Any, Tuple, Dict

_SUBNET_CACHE: Dict[Tuple[Any, ...], "torch.nn.Module"] = {}

def get_or_build(key: Tuple[Any, ...], builder_fn: Callable[[], "torch.nn.Module"]):
    """
    key        : anything hashable that uniquely identifies the subnet shape
    builder_fn : a *zero‑arg* function that RETURNS an nn.Module on CPU

    Returns an independent deepcopy, so callers never share parameter tensors.
    """
    if key not in _SUBNET_CACHE:
        _SUBNET_CACHE[key] = builder_fn().cpu()   # keep master copy on CPU
    # ALWAYS return a deep copy (separate parameters for every client)
    return deepcopy(_SUBNET_CACHE[key])
