alpha=0.5 # LDA partitioning alpha
num_of_exits=4 # we ran 4 or 12 in our experiments
vram=1000 # 700 MB total per client. Spawns 4 clients per GPU for a GPU with 40+GB
additional_commands='wandb_args.mode=disabled' # disable wandb
early_exit='scaleFL' # for other methods, 
num_clients=100
num_rounds=200
test_every_n=20
tag=600

# ScaleFL
python main.py cifar100.yaml \
  app.run.test_every_n=${test_every_n} app.run.num_rounds=${num_rounds} \
  data.args.lda_alpha=\{${alpha}:${num_clients}\} vram=${vram} \
  models.net.args.no_of_exits=${num_of_exits} ${additional_commands} \
  models.net.args.ee_layer_locations=[30,38,46,-1] \
  app.args.width_scaling=[0.7,0.7,0.75,1.0] \
  app.args.send_full_local_state=False \
  app.args.pruning_mode="['scale','scale','scale','scale']" \
  app.args.save_log_file="${tag}/scalefl_results_${num_rounds}.pkl"


# HeteroFL
python main.py cifar100.yaml \
  app.run.test_every_n=${test_every_n} app.run.num_rounds=${num_rounds} \
  data.args.lda_alpha=\{${alpha}:${num_clients}\} vram=${vram} \
  models.net.args.no_of_exits=${num_of_exits} ${additional_commands} \
  models.net.args.ee_layer_locations=[-1,-1,-1,-1] \
  app.args.width_scaling=[0.32,0.44,0.64,1.0] \
  app.args.send_full_local_state=False \
  app.args.pruning_mode="['scale','scale','scale','scale']" \
  app.args.save_log_file="${tag}/heterofl_results_${num_rounds}.pkl"

# DepthFL
python main.py cifar100.yaml \
  app.run.test_every_n=${test_every_n} app.run.num_rounds=${num_rounds} \
  data.args.lda_alpha=\{${alpha}:${num_clients}\} vram=${vram} \
  models.net.args.no_of_exits=${num_of_exits} ${additional_commands} \
  models.net.args.ee_layer_locations=[18,30,38,-1] \
  app.args.width_scaling=[1.0,1.0,1.0,1.0] \
  app.args.pruning_mode="['depth','depth','depth','depth']" \
  app.client.class=src.apps.clients.ReeFLClassificationClient \
  app.args.save_log_file="${tag}/depthfl_results_${num_rounds}.pkl"


# InclusiveFL
python main.py cifar100.yaml \
  app.run.test_every_n=${test_every_n} app.run.num_rounds=${num_rounds} \
  data.args.lda_alpha=\{${alpha}:${num_clients}\} vram=${vram} \
  models.net.args.no_of_exits=${num_of_exits} ${additional_commands} \
  models.net.args.ee_layer_locations=[18,30,38,-1] \
  app.args.width_scaling=[1.0,1.0,1.0,1.0] \
  server.strategy.class=src.server.strategies.InclusiveFL \
  app.class=src.apps.InclusiveFLClassificationApp \
  app.args.pruning_mode="['scale','scale','scale','scale']" \
  app.client.class=src.apps.clients.ReeFLClassificationClient \
  app.args.save_log_file="${tag}/inclusivefl_results_${num_rounds}.pkl" \
  app.args.training_loss=inclusive \
  app.args.inclusive_norm=mean \
  app.args.inclusive_gamma=0.5


# ReeFL
python main.py cifar100.yaml \
  app.run.test_every_n=${test_every_n} app.run.num_rounds=${num_rounds} \
  data.args.lda_alpha=\{${alpha}:${num_clients}\} vram=${vram} \
  models.net.args.no_of_exits=${num_of_exits} ${additional_commands} \
  models.net.args.ee_layer_locations=[18,30,38,-1] \
  app.args.width_scaling=[1.0,1.0,1.0,1.0] \
  app.client.class=src.apps.clients.ReeFLClassificationClient \
  server.strategy.class=src.server.strategies.ReeFLFedAvg \
  app.class=src.apps.ReeFLClassificationApp \
  app.args.pruning_mode="['scale','scale','scale','scale']" \
  app.args.save_log_file="${tag}/reefl_results_${num_rounds}.pkl" \
  app.client.args.kl_loss=forward \
  app.client.args.kl_consistency_weight=300 \
  app.client.args.kl_softmax_temp=1.0 \

# SNOWFL

python main.py cifar100.yaml \
  app.run.test_every_n=${test_every_n} app.run.num_rounds=${num_rounds} \
  data.args.lda_alpha=\{${alpha}:${num_clients}\} vram=${vram} \
  models.net.args.no_of_exits=${num_of_exits} ${additional_commands} \
  models.net.args.ee_layer_locations=[30,38,46,-1] \
  app.args.width_scaling=[0.7,0.7,0.75,1.0] \
  app.args.training_loss=exclusive \
  app.args.send_full_local_state=True \
  app.args.pruning_mode="['snip','snip','snip','snip']" \
  server.strategy.class=src.server.strategies.SNOWFLFedAvg \
  server.strategy.args.bn_bootstrap=False \
  server.strategy.args.bn_sync_every=2 \
  server.strategy.args.bn_on_regroup=False \
  server.strategy.args.bn_calib_source=val \
  server.strategy.args.bn_calib_batches=320 \
  app.client.class=src.apps.clients.SNOWFLClassificationClient \
  app.class=src.apps.SNOWFLClassificationApp \
  server.strategy.valuation.class=src.server.strategies.valuations.OwenMC \
  server.strategy.valuation.args.model_name=net \
  server.strategy.valuation.args.num_classes=10 \
  server.strategy.valuation.args.similarity=cosine \
  server.strategy.valuation.args.aggressive_mode=False \
  server.strategy.valuation.args.use_target_in_shapley=False \
  server.strategy.valuation.args.gamma_schedule=const \
  server.strategy.valuation.args.gamma=0.99 \
  server.strategy.valuation.args.temp0=0.10 \
  server.strategy.valuation.args.temp1=0.10 \
  server.strategy.valuation.args.beta0=1.8 \
  server.strategy.valuation.args.beta1=2.2 \
  server.strategy.valuation.args.alpha=0.05 \
  server.strategy.valuation.args.lam=0.02 \
  server.strategy.valuation.args.lam_schedule=off \
  server.strategy.valuation.args.clip_min=0.00 \
  server.strategy.valuation.args.intra_mix_eps=0.00 \
  server.strategy.valuation.args.normalize_round=False \
  server.strategy.valuation.args.ema_decay=0.1 \
  server.strategy.valuation.args.idle_ema=0.00 \
  server.strategy.valuation.args.regroup_every=1 \
  server.strategy.valuation.args.min_stay_rounds=1 \
  server.strategy.valuation.args.n_perm=256 \
  server.strategy.valuation.args.stale_half_life=6 \
  server.strategy.valuation.args.strict_equal_groups=True \
  server.strategy.valuation.args.map_best_to_deepest=True \
  server.strategy.valuation.args.regroup_every=1 \
  server.strategy.valuation.args.warmup_rounds=2 \
  server.strategy.valuation.args.neutral_value=1.0 \
  app.args.save_log_file="${tag}/snowfl_results_${num_rounds}.pkl"

