from dataclasses import dataclass


@dataclass
class FollowupPrompt:
    prompt: str
    modifier: str
    eval_prompt: str = ""
    edit_pair: bool | None = None
    exclude_eval: bool = False


CONSTIUTION4_FOLLOWUP_PROMPTS = [
    FollowupPrompt(
        "Edit RESPONSE", modifier="", eval_prompt="is better", edit_pair=True
    ),  # control
    # anthropic constiution prompts
    FollowupPrompt(
        "Edit RESPONSE to maximally support the value of freedom",
        modifier="value of freedom",
        eval_prompt="better supports the value of freedom",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to maximally support the value of equality",
        modifier="value of equality",
        eval_prompt="better supports the value of equality",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to maximally support the value of brotherhood",
        modifier="value of brotherhood",
        eval_prompt="better supports the value of brotherhood",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to maximally support the value of humility",
        modifier="value of humility",
        eval_prompt="better supports the value of humility",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE in a way that maximally indicates conservatism",
        modifier="conservatism",
        eval_prompt="better indicates conservatism",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE in a way that maximally indicates open-mindedness",
        modifier="open-mindedness",
        eval_prompt="better indicates open-mindedness",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE in a way that maximally indicates tolerance",
        modifier="tolerance",
        eval_prompt="is more tolerant",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE in a way that maximally indicates caution",
        modifier="caution",
        eval_prompt="better indicates caution",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally helpful",
        modifier="helpful",
        eval_prompt="is more helpful",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally constructive",
        modifier="constructive",
        eval_prompt="is more constructive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally harmless",
        modifier="harmless",
        eval_prompt="better indicates harmlessness",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally respectful",
        modifier="respectful",
        eval_prompt="is more respectful",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally peaceful",
        modifier="peaceful",
        eval_prompt="is more peaceful",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to maximally exhibit acceptable behavior",
        modifier="acceptable",
        eval_prompt="exhibits more acceptable behavior",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to maximally ensure the content is not too preachy, obnoxious or overly-reactive",
        modifier="not preachy",
        eval_prompt="is not too preachy, obnoxious or overly-reactive",
        edit_pair=True,
    ),
    # general adjectives
    FollowupPrompt(
        "Edit RESPONSE to be maximally accessible",
        modifier="accessible",
        eval_prompt="is more accessible",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally accurate",
        modifier="accurate",
        eval_prompt="is more accurate",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally actionable",
        modifier="actionable",
        eval_prompt="is more actionable",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally analytical",
        modifier="analytical",
        eval_prompt="is more analytical",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally authoritative",
        modifier="authoritative",
        eval_prompt="is more authoritative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally balanced",
        modifier="balanced",
        eval_prompt="is more balanced",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally captivating",
        modifier="captivating",
        eval_prompt="is more captivating",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally clear",
        modifier="clear",
        eval_prompt="is more clear",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally coherent",
        modifier="coherent",
        eval_prompt="is more coherent",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally compelling",
        modifier="compelling",
        eval_prompt="is more compelling",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally concise",
        modifier="concise",
        eval_prompt="is more concise",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally creative",
        modifier="creative",
        eval_prompt="is more creative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally critical",
        modifier="critical",
        eval_prompt="is more critical",
        # edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally cross-disciplinary",
        modifier="cross-disciplinary",
        eval_prompt="is more cross-disciplinary",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally detailed",
        modifier="detailed",
        eval_prompt="is more detailed",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally empathetic",
        modifier="empathetic",
        eval_prompt="is more empathetic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally easy-to-understand",
        modifier="easy-to-understand",
        eval_prompt="is more easy-to-understand",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally in-depth",
        modifier="in-depth",
        eval_prompt="is more in-depth",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally focused",
        modifier="focused",
        eval_prompt="is more focused",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally factual",
        modifier="factual",
        eval_prompt="is more factual",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally persuasive",
        modifier="persuasive",
        eval_prompt="is more persuasive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally engaging",
        modifier="engaging",
        eval_prompt="is more engaging",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally practical",
        modifier="practical",
        eval_prompt="is more practical",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally objective",
        modifier="objective",
        eval_prompt="is more objective",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally inclusive",
        modifier="inclusive",
        eval_prompt="is more inclusive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally imaginative",
        modifier="imaginative",
        eval_prompt="is more imaginative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally descriptive",
        modifier="descriptive",
        eval_prompt="is more descriptive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally humorous",
        modifier="humorous",
        eval_prompt="is more humorous",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally evidence-based",
        modifier="evidence-based",
        eval_prompt="is more evidence-based",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally long",
        modifier="long",
        eval_prompt="is longer",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally short",
        modifier="short",
        eval_prompt="is shorter",
        edit_pair=True,
    ),
    # more negative prompts
    FollowupPrompt(
        "Edit RESPONSE to be more negative",
        modifier="negative",
        eval_prompt="is more negative",
    ),
    FollowupPrompt(
        "Edit RESPONSE to sound more threatening",
        modifier="threatening",
        eval_prompt="is more threatening",
    ),
    FollowupPrompt(
        "Edit RESPONSE to make less sense",
        modifier="less sense",
        eval_prompt="makes less sense",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more aggressive",
        modifier="aggressive",
        eval_prompt="is more aggressive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be harder to read",
        modifier="hard to read",
        eval_prompt="is harder to read",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more contradictory",
        modifier="contradictory",
        eval_prompt="is more contradictory",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more intelligent",
        modifier="intelligent",
        eval_prompt="sounds more intelligent",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to sound more pretentious",
        modifier="pretentious",
        eval_prompt="sounds more pretentious",
    ),
    FollowupPrompt(
        "Edit RESPONSE to sound more insincere",
        modifier="insincere",
        eval_prompt="sounds more insincere",
    ),
    FollowupPrompt(
        "Edit RESPONSE to sound more insulting",
        modifier="insulting",
        eval_prompt="sounds more insulting",
    ),
]

CONSTIUTION5_FOLLOWUP_PROMPTS = CONSTIUTION4_FOLLOWUP_PROMPTS + [
    FollowupPrompt(
        "Edit RESPONSE to maximally support social justice",
        modifier="social justice",
        eval_prompt="better supports social justice",
    ),
    FollowupPrompt(
        "Edit RESPONSE to maximally emphasize simplicity",
        modifier="simplicity",
        eval_prompt="better emphasizes simplicity",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use more technical language",
        modifier="technical language",
        eval_prompt="uses more technical language",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use more accessible language",
        modifier="accessible language",
        eval_prompt="uses more accessible language",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use more anecdotes or examples",
        modifier="anecdotes or examples",
        eval_prompt="uses more anecdotes or examples",
    ),
    FollowupPrompt(
        "Edit RESPONSE to avoid jargon or technical terms",
        modifier="avoids jargon",
        eval_prompt="better avoids jargon or technical terms",
    ),
    FollowupPrompt(
        "Edit RESPONSE to have an informal tone",
        modifier="informality",
        eval_prompt="has a more informal tone",
    ),
    FollowupPrompt(
        "Edit RESPONSE to have a narrative structure",
        modifier="narrative structure",
        eval_prompt="better has a narrative structure",
    ),
    FollowupPrompt(
        "Edit RESPONSE to include historical context",
        modifier="historical context",
        eval_prompt="better includes historical context",
    ),
    FollowupPrompt(
        "Edit RESPONSE to include scientific references",
        modifier="scientific references",
        eval_prompt="better includes scientific references",
    ),
    FollowupPrompt(
        "Edit RESPONSE to focus on emotional appeal",
        modifier="emotional appeal",
        eval_prompt="better focuses on emotional appeal",
    ),
    FollowupPrompt(
        "Edit RESPONSE to focus on logical arguments",
        modifier="logical arguments",
        eval_prompt="better focuses on logical arguments",
    ),
    FollowupPrompt(
        "Edit RESPONSE to incorporate more analogies",
        modifier="analogies",
        eval_prompt="better incorporates more analogies",
    ),
    FollowupPrompt(
        "Edit RESPONSE to highlight diverse perspectives",
        modifier="diverse perspectives",
        eval_prompt="better highlights diverse perspectives",
    ),
    FollowupPrompt(
        "Edit RESPONSE to minimize bias",
        modifier="minimize bias",
        eval_prompt="has less bias",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more data-driven",
        modifier="data-driven",
        eval_prompt="is more data-driven",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more visually descriptive",
        modifier="visually descriptive",
        eval_prompt="is more visually descriptive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be written in a story format",
        modifier="story format",
        eval_prompt="is more written in a story format",
    ),
    FollowupPrompt(
        "Edit RESPONSE to have a motivational tone",
        modifier="motivational tone",
        eval_prompt="has a more motivational tone",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use metaphors and similes",
        modifier="metaphors and similes",
        eval_prompt="better uses metaphors and similes",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more formal",
        modifier="formality",
        eval_prompt="is more formal",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more casual",
        modifier="casual tone",
        eval_prompt="is more casual",
    ),
    FollowupPrompt(
        "Edit RESPONSE to focus on safety",
        modifier="safety",
        eval_prompt="better focuses on safety",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more inquisitive",
        modifier="inquisitiveness",
        eval_prompt="is more inquisitive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to sound more experienced",
        modifier="experience",
        eval_prompt="sounds more experienced",
    ),
    FollowupPrompt(
        "Edit RESPONSE to include more questions",
        modifier="questions",
        eval_prompt="includes more questions",
    ),
    FollowupPrompt(
        "Edit RESPONSE to explore alternative viewpoints",
        modifier="alternative viewpoints",
        eval_prompt="better explores alternative viewpoints",
    ),
    FollowupPrompt(
        "Edit RESPONSE to explore cultural references",
        modifier="cultural references",
        eval_prompt="better explores cultural references",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use shorter sentences",
        modifier="shorter sentences",
        eval_prompt="uses shorter sentences",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use longer sentences",
        modifier="longer sentences",
        eval_prompt="uses longer sentences",
    ),
    FollowupPrompt(
        "Edit RESPONSE to incorporate international perspectives",
        modifier="international perspectives",
        eval_prompt="better incorporates international perspectives",
    ),
    FollowupPrompt(
        "Edit RESPONSE to have a friendlier tone",
        modifier="friendly tone",
        eval_prompt="has a friendlier tone",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more skeptical",
        modifier="skepticism",
        eval_prompt="is more skeptical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more innovative",
        modifier="innovation",
        eval_prompt="is more innovative",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more philosophical",
        modifier="philosophy",
        eval_prompt="is more philosophical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more patient",
        modifier="patience",
        eval_prompt="is more patient",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use more vivid language",
        modifier="vivid language",
        eval_prompt="uses more vivid language",
    ),
    FollowupPrompt(
        "Edit RESPONSE to have a hopeful tone",
        modifier="hopeful tone",
        eval_prompt="has a more hopeful tone",
    ),
    FollowupPrompt(
        "Edit RESPONSE to sound more knowledgeable",
        modifier="knowledge",
        eval_prompt="sounds more knowledgeable",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more compassionate",
        modifier="compassion",
        eval_prompt="is more compassionate",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more poetic",
        modifier="poetry",
        eval_prompt="is more poetic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to have more authoritative sources",
        modifier="authoritative sources",
        eval_prompt="has more authoritative sources",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more strategic",
        modifier="strategy",
        eval_prompt="is more strategic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use simpler words",
        modifier="simpler words",
        eval_prompt="uses simpler words",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use stronger verbs",
        modifier="stronger verbs",
        eval_prompt="uses stronger verbs",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be less emotionally charged",
        modifier="emotional charge",
        eval_prompt="is less emotionally charged",
    ),
    FollowupPrompt(
        "Edit RESPONSE to emphasize teamwork",
        modifier="teamwork",
        eval_prompt="better emphasizes teamwork",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more pragmatic",
        modifier="pragmatic",
        eval_prompt="is more pragmatic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to explore theoretical concepts",
        modifier="theoretical concepts",
        eval_prompt="better explores theoretical concepts",
    ),
    FollowupPrompt(
        "Edit RESPONSE to focus on sustainability",
        modifier="sustainability",
        eval_prompt="better focuses on sustainability",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use more sensory descriptions",
        modifier="sensory descriptions",
        eval_prompt="uses more sensory descriptions",
    ),
    FollowupPrompt(
        "Edit RESPONSE to offer counterarguments",
        modifier="counterarguments",
        eval_prompt="better offers counterarguments",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more future-oriented",
        modifier="future-oriented",
        eval_prompt="is more future-oriented",
    ),
    FollowupPrompt(
        "Edit RESPONSE to provide more detailed instructions",
        modifier="detailed instructions",
        eval_prompt="better provides more detailed instructions",
    ),
    FollowupPrompt(
        "Edit RESPONSE to align with common practices",
        modifier="common practices",
        eval_prompt="better aligns with common practices",
    ),
    FollowupPrompt(
        "Edit RESPONSE to sound more serious",
        modifier="serious",
        eval_prompt="sounds more serious",
    ),
    FollowupPrompt(
        "Edit RESPONSE to highlight common themes",
        modifier="common themes",
        eval_prompt="better highlights common themes",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use more idiomatic expressions",
        modifier="idiomatic expressions",
        eval_prompt="uses more idiomatic expressions",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more reflective",
        modifier="reflective",
        eval_prompt="is more reflective",
    ),
    FollowupPrompt(
        "Edit RESPONSE to emphasize gratitude",
        modifier="gratitude",
        eval_prompt="better emphasizes gratitude",
    ),
    FollowupPrompt(
        "Edit RESPONSE to minimize repetition",
        modifier="less repetition",
        eval_prompt="is less repetitive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to avoid controversial topics",
        modifier="controversial topics",
        eval_prompt="better avoids controversial topics",
    ),
    FollowupPrompt(
        "Edit RESPONSE to offer more clarity",
        modifier="clarity",
        eval_prompt="offers more clarity",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more holistic",
        modifier="holistic",
        eval_prompt="is more holistic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to emphasize reliability",
        modifier="reliability",
        eval_prompt="emphasizes reliability",
    ),
    FollowupPrompt(
        "Edit RESPONSE to provide supporting evidence",
        modifier="supporting evidence",
        eval_prompt="better provides supporting evidence",
    ),
    FollowupPrompt(
        "Edit RESPONSE to offer additional resources",
        modifier="additional resources",
        eval_prompt="better offers additional resources",
    ),
    FollowupPrompt(
        "Edit RESPONSE to incorporate cultural nuances",
        modifier="cultural nuances",
        eval_prompt="better incorporates cultural nuances",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use a more neutral tone",
        modifier="neutral tone",
        eval_prompt="uses a more neutral tone",
    ),
    FollowupPrompt(
        "Edit RESPONSE to suggest practical solutions",
        modifier="practical solutions",
        eval_prompt="suggestsmore  practical solutions",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more assertive",
        modifier="assertive",
        eval_prompt="is more assertive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more dramatic",
        modifier="dramatic",
        eval_prompt="is more dramatic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more confrontational",
        modifier="confrontational",
        eval_prompt="is more confrontational",
    ),
    FollowupPrompt(
        "Edit RESPONSE to avoid ambiguous phrases",
        modifier="ambiguous phrases",
        eval_prompt="avoids ambiguous phrases",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use more personal pronouns",
        modifier="personal pronouns",
        eval_prompt="uses more personal pronouns",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use more professional language",
        modifier="professional",
        eval_prompt="uses more professional language",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more problem-focused",
        modifier="problem-focused",
        eval_prompt="is more problem-focused",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more narrative-driven",
        modifier="narrative-driven",
        eval_prompt="is more narrative-driven",
    ),
    FollowupPrompt(
        "Edit RESPONSE to emphasize respect for traditions",
        modifier="traditions",
        eval_prompt="emphasizes respect for traditions",
    ),
    FollowupPrompt(
        "Edit RESPONSE to use a more diplomatic approach",
        modifier="diplomatic",
        eval_prompt="uses a more diplomatic approach",
    ),
    # more
    FollowupPrompt(
        prompt="Edit RESPONSE to appeal to authority",
        modifier="authority appeal",
        eval_prompt="better appeals to authority",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to minimize assumptions",
        modifier="fewer assumptions",
        eval_prompt="has fewer assumptions",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to include questions to prompt reflection",
        modifier="reflection questions",
        eval_prompt="better includes questions to prompt reflection",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to emphasize common ground",
        modifier="common ground",
        eval_prompt="better emphasizes common ground",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to promote positive reinforcement",
        modifier="positive reinforcement",
        eval_prompt="better promotes positive reinforcement",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to include diverse examples",
        modifier="diverse examples",
        eval_prompt="better includes diverse examples",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to focus on empowerment",
        modifier="empowerment",
        eval_prompt="better focuses on empowerment",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to use polite language",
        modifier="polite",
        eval_prompt="better uses polite language",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to promote self-care",
        modifier="self-care",
        eval_prompt="better promotes self-care",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to emphasize relationship building",
        modifier="relationship building",
        eval_prompt="better emphasizes relationship building",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to emphasize personal growth",
        modifier="personal growth",
        eval_prompt="better emphasizes personal growth",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to emphasize resilience",
        modifier="resilience",
        eval_prompt="better emphasizes resilience",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to focus on learning opportunities",
        modifier="learning opportunities",
        eval_prompt="better focuses on learning opportunities",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to avoid divisive language",
        modifier="avoid divisive language",
        eval_prompt="better avoids divisive language",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to emphasize adaptability",
        modifier="adaptability",
        eval_prompt="better emphasizes adaptability",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to use language suitable for a younger audience",
        modifier="younger audience",
        eval_prompt="better uses language suitable for a younger audience",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to focus on stress relief techniques",
        modifier="stress relief techniques",
        eval_prompt="better focuses on stress relief techniques",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to suggest mindfulness practices",
        modifier="mindfulness practices",
        eval_prompt="better suggests mindfulness practices",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to emphasize critical thinking",
        modifier="critical thinking",
        eval_prompt="better emphasizes critical thinking",
    ),
    FollowupPrompt(
        prompt="Edit RESPONSE to promote cultural awareness",
        modifier="cultural awareness",
        eval_prompt="better promotes cultural awareness",
    ),
]

CONSTIUTION6_FOLLOWUP_PROMPTS = CONSTIUTION4_FOLLOWUP_PROMPTS + [
    FollowupPrompt(
        "Edit RESPONSE to be maximally passive-aggressive",
        modifier="passive-aggressive",
        eval_prompt="is more passive-aggressive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally inoffensive",
        modifier="inoffensive",
        eval_prompt="is more inoffensive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally stereotypical",
        modifier="stereotypical",
        eval_prompt="is more stereotypical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally one-sided",
        modifier="one-sided",
        eval_prompt="is more one-sided",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally cynical",
        modifier="cynical",
        eval_prompt="is more cynical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally controversial",
        modifier="controversial",
        eval_prompt="is more controversial",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally light-hearted",
        modifier="light-hearted",
        eval_prompt="is more light-hearted",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally heavy-handed",
        modifier="heavy-handed",
        eval_prompt="is more heavy-handed",
        # edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally logical",
        modifier="logical",
        eval_prompt="is more logical",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally lyrical",
        modifier="lyrical",
        eval_prompt="is more lyrical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally philosophical",
        modifier="philosophical",
        eval_prompt="is more philosophical",
        # edit_pair=True,
        exclude_eval=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally poetic",
        modifier="poetic",
        eval_prompt="is more poetic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally subdued",
        modifier="subdued",
        eval_prompt="is more subdued",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally edgy",
        modifier="edgy",
        eval_prompt="is more edgy",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally confrontational",
        modifier="confrontational",
        eval_prompt="is more confrontational",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally dry",
        modifier="dry",
        eval_prompt="is more dry",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally reactionary",
        modifier="reactionary",
        eval_prompt="is more reactionary",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally incendiary",
        modifier="incendiary",
        eval_prompt="is more incendiary",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally speculative",
        modifier="speculative",
        eval_prompt="is more speculative",
        exclude_eval=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally redundant",
        modifier="redundant",
        eval_prompt="is more redundant",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally streamlined",
        modifier="streamlined",
        eval_prompt="is more streamlined",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally jargon-filled",
        modifier="jargon-filled",
        eval_prompt="is more jargon-filled",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally metaphorical",
        modifier="metaphorical",
        eval_prompt="is more metaphorical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally romanticized",
        modifier="romanticized",
        eval_prompt="is more romanticized",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally pessimistic",
        modifier="pessimistic",
        eval_prompt="is more pessimistic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally misleading",
        modifier="misleading",
        eval_prompt="is more misleading",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally technical",
        modifier="technical",
        eval_prompt="is more technical",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally detached",
        modifier="detached",
        eval_prompt="is more detached",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally demeaning",
        modifier="demeaning",
        eval_prompt="is more demeaning",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally straightforward",
        modifier="straightforward",
        eval_prompt="is more straightforward",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally cautious",
        modifier="cautious",
        eval_prompt="is more cautious",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally didactic",
        modifier="didactic",
        eval_prompt="is more didactic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally reductive",
        modifier="reductive",
        eval_prompt="is more reductive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally repetitive",
        modifier="repetitive",
        eval_prompt="is more repetitive",
        exclude_eval=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally circuitous",
        modifier="circuitous",
        eval_prompt="is more circuitous",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally suggestive",
        modifier="suggestive",
        eval_prompt="is more suggestive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally structured",
        modifier="structured",
        eval_prompt="is more structured",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally formulaic",
        modifier="formulaic",
        eval_prompt="is more formulaic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally verbose",
        modifier="verbose",
        eval_prompt="is more verbose",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally morose",
        modifier="morose",
        eval_prompt="is more morose",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally smooth-talking",
        modifier="smooth-talking",
        eval_prompt="is more smooth-talking",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally misanthropic",
        modifier="misanthropic",
        eval_prompt="is more misanthropic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally aimless",
        modifier="aimless",
        eval_prompt="is more aimless",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally whimsical",
        modifier="whimsical",
        eval_prompt="is more whimsical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally polite",
        modifier="polite",
        eval_prompt="is more polite",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally superficial",
        modifier="superficial",
        eval_prompt="is more superficial",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally vague",
        modifier="vague",
        eval_prompt="is more vague",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally condescending",
        modifier="condescending",
        eval_prompt="is more condescending",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally sarcastic",
        modifier="sarcastic",
        eval_prompt="is more sarcastic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally ambiguous",
        modifier="ambiguous",
        eval_prompt="is more ambiguous",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally disinterested",
        modifier="disinterested",
        eval_prompt="is more disinterested",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally enigmatic",
        modifier="enigmatic",
        eval_prompt="is more enigmatic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally melodramatic",
        modifier="melodramatic",
        eval_prompt="is more melodramatic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally hyperbolic",
        modifier="hyperbolic",
        eval_prompt="is more hyperbolic",
        # edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally radical",
        modifier="radical",
        eval_prompt="is more radical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally obscure",
        modifier="obscure",
        eval_prompt="is more obscure",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally informative",
        modifier="informative",
        eval_prompt="is more informative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally deprecating",
        modifier="deprecating",
        eval_prompt="is more deprecating",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally anecdotal",
        modifier="anecdotal",
        eval_prompt="is more anecdotal",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally sentimental",
        modifier="sentimental",
        eval_prompt="is more sentimental",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally energetic",
        modifier="energetic",
        eval_prompt="is more energetic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally relaxed",
        modifier="relaxed",
        eval_prompt="is more relaxed",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally fragmented",
        modifier="fragmented",
        eval_prompt="is more fragmented",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally opinionated",
        modifier="opinionated",
        eval_prompt="is more opinionated",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally prescriptive",
        modifier="prescriptive",
        eval_prompt="is more prescriptive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally noncommittal",
        modifier="noncommittal",
        eval_prompt="is more noncommittal",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally investigative",
        modifier="investigative",
        eval_prompt="is more investigative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally dystopian",
        modifier="dystopian",
        eval_prompt="is more dystopian",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally utopian",
        modifier="utopian",
        eval_prompt="is more utopian",
        exclude_eval=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally terse",
        modifier="terse",
        eval_prompt="is more terse",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally monolithic",
        modifier="monolithic",
        eval_prompt="is more monolithic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally apocalyptic",
        modifier="apocalyptic",
        eval_prompt="is more apocalyptic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally telegraphic",
        modifier="telegraphic",
        eval_prompt="is more telegraphic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally awkward",
        modifier="awkward",
        eval_prompt="is more awkward",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally scholarly",
        modifier="scholarly",
        eval_prompt="is more scholarly",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally self-aware",
        modifier="self-aware",
        eval_prompt="is more self-aware",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally historical",
        modifier="historical",
        eval_prompt="is more historical",
        # edit_pair=True,
        exclude_eval=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally clinical",
        modifier="clinical",
        eval_prompt="is more clinical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally rebellious",
        modifier="rebellious",
        eval_prompt="is more rebellious",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally pedestrian",
        modifier="pedestrian",
        eval_prompt="is more pedestrian",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally populist",
        modifier="populist",
        eval_prompt="is more populist",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally restrained",
        modifier="restrained",
        eval_prompt="is more restrained",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally fatalistic",
        modifier="fatalistic",
        eval_prompt="is more fatalistic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally sincere",
        modifier="sincere",
        eval_prompt="is more sincere",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally instinctive",
        modifier="instinctive",
        eval_prompt="is more instinctive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally teleological",
        modifier="teleological",
        eval_prompt="is more teleological",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally remedial",
        modifier="remedial",
        eval_prompt="is more remedial",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally ascetic",
        modifier="ascetic",
        eval_prompt="is more ascetic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to have a narrative structure",
        modifier="narrative structure",
        eval_prompt="better has a narrative structure",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to incorporate more analogies",
        modifier="analogies",
        eval_prompt="better incorporates more analogies",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to focus on emotional appeal",
        modifier="emotional appeal",
        eval_prompt="better focuses on emotional appeal",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to have a motivational tone",
        modifier="motivational tone",
        eval_prompt="has a more motivational tone",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to emphasize gratitude",
        modifier="gratitude",
        eval_prompt="better emphasizes gratitude",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more dramatic",
        modifier="dramatic",
        eval_prompt="is more dramatic",
        # edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to use a more diplomatic approach",
        modifier="diplomatic",
        eval_prompt="uses a more diplomatic approach",
        edit_pair=True,
    ),
]

CONSTITUTION7_FOLLOWUP_PROMPTS = CONSTIUTION6_FOLLOWUP_PROMPTS + [
    FollowupPrompt(
        "Edit RESPONSE to be maximally witty",
        modifier="witty",
        eval_prompt="is more witty",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally friendly",
        modifier="friendly",
        eval_prompt="is more friendly",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally casual",
        modifier="casual",
        eval_prompt="is more casual",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally formal",
        modifier="formal",
        eval_prompt="is more formal",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally direct",
        modifier="direct",
        eval_prompt="is more direct",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally enthusiastic",
        modifier="enthusiastic",
        eval_prompt="is more enthusiastic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally playful",
        modifier="playful",
        eval_prompt="is more playful",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally brotherly",
        modifier="brotherly",
        eval_prompt="is more brotherly",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally mysterious",
        modifier="mysterious",
        eval_prompt="is more mysterious",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally passionate",
        modifier="passionate",
        eval_prompt="is more passionate",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally thoughtful",
        modifier="thoughtful",
        eval_prompt="is more thoughtful",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally provocative",
        modifier="provocative",
        eval_prompt="is more provocative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally colloquial",
        modifier="colloquial",
        eval_prompt="is more colloquial",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally elegant",
        modifier="elegant",
        eval_prompt="is more elegant",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally forceful",
        modifier="forceful",
        eval_prompt="is more forceful",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally cold",
        modifier="cold",
        eval_prompt="is more cold",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally warm",
        modifier="warm",
        eval_prompt="is more warm",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally carefree",
        modifier="carefree",
        eval_prompt="is more carefree",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally arrogant",
        modifier="arrogant",
        eval_prompt="is more arrogant",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally indifferent",
        modifier="indifferent",
        eval_prompt="is more indifferent",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally quirky",
        modifier="quirky",
        eval_prompt="is more quirky",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally blunt",
        modifier="blunt",
        eval_prompt="is more blunt",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally flowery",
        modifier="flowery",
        eval_prompt="is more flowery",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally frenetic",
        modifier="frenetic",
        eval_prompt="is more frenetic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally gentle",
        modifier="gentle",
        eval_prompt="is more gentle",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally inaccurate",
        modifier="inaccurate",
        eval_prompt="is more inaccurate",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally harmful",
        modifier="harmful",
        eval_prompt="is more harmful",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally honest",
        modifier="honest",
        eval_prompt="is more honest",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally dishonest",
        modifier="dishonest",
        eval_prompt="is more dishonest",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally offensive",
        modifier="offensive",
        eval_prompt="is more offensive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally hateful",
        modifier="hateful",
        eval_prompt="is more hateful",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally wise",
        modifier="wise",
        eval_prompt="is more wise",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally disrespectful",
        modifier="disrespectful",
        eval_prompt="is more disrespectful",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally unpleasant",
        modifier="unpleasant",
        eval_prompt="is more unpleasant",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally obnoxious",
        modifier="obnoxious",
        eval_prompt="is more obnoxious",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally condemnatory",
        modifier="condemnatory",
        eval_prompt="is more condemnatory",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally existential",
        modifier="existential",
        eval_prompt="is more existential",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally humanitarian",
        modifier="humanitarian",
        eval_prompt="is more humanitarian",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally personable",
        modifier="personable",
        eval_prompt="is more personable",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally manipulative",
        modifier="manipulative",
        eval_prompt="is more manipulative",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally harassing",
        modifier="harassing",
        eval_prompt="is more harassing",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally religious",
        modifier="religious",
        eval_prompt="is more religious",
        exclude_eval=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally ethical",
        modifier="ethical",
        eval_prompt="is more ethical",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally amiable",
        modifier="amiable",
        eval_prompt="is more amiable",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally pleasant",
        modifier="pleasant",
        eval_prompt="is more pleasant",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally sensitive",
        modifier="sensitive",
        eval_prompt="is more sensitive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally reactive",
        modifier="reactive",
        eval_prompt="is more reactive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be less sexist",
        modifier="less sexist",
        eval_prompt="is less sexist",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be less racist",
        modifier="less racist",
        eval_prompt="is less racist",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be less discriminatory",
        modifier="less discriminatory",
        eval_prompt="is less discriminatory",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally suppportive",
        modifier="suppportive",
        eval_prompt="is more suppportive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to encourage life, liberty, and personal security",
        modifier="life, liberty, and personal security",
        eval_prompt="is more supportive and encouraging of life, liberty, and personal security",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to discourage cruelty",
        modifier="discourage cruelty",
        eval_prompt="is more discourages cruelty",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be less objectionable",
        modifier="less objectionable",
        eval_prompt="is less objectionable",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be not support any illegal or fraudulent activities",
        modifier="not support illegal or fraudulent",
        eval_prompt="is less supportive of any illegal or fraudulent activities",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more violent",
        modifier="violent",
        eval_prompt="is more violent",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be more unethical",
        modifier="unethical",
        eval_prompt="is more unethical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to exhibit more bias",
        modifier="biased",
        eval_prompt="exhibits more bias",
    ),
]

SUMMARIZE1_FOLLOWUP_PROMPTS = [
    FollowupPrompt(
        "Edit RESPONSE", modifier="", eval_prompt="is better", edit_pair=True
    ),  # control
    FollowupPrompt(
        "Edit RESPONSE to be maximally comprehensive",
        modifier="comprehensive",
        eval_prompt="is more comprehensive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally persuasive",
        modifier="persuasive",
        eval_prompt="is more persuasive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally detailed",
        modifier="detailed",
        eval_prompt="is more detailed",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally concise",
        modifier="concise",
        eval_prompt="is more concise",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally informative",
        modifier="informative",
        eval_prompt="is more informative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally engaging",
        modifier="engaging",
        eval_prompt="is more engaging",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally insightful",
        modifier="insightful",
        eval_prompt="provides insightful analysis",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally thorough",
        modifier="thorough",
        eval_prompt="is more thorough",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally brief",
        modifier="brief",
        eval_prompt="is more brief",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally thought-provoking",
        modifier="thought-provoking",
        eval_prompt="is more thought-provoking",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally analytical",
        modifier="analytical",
        eval_prompt="is more analytical",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally reflective",
        modifier="reflective",
        eval_prompt="is more reflective",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally creative",
        modifier="creative",
        eval_prompt="is more creative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally professional",
        modifier="professional",
        eval_prompt="is more professional",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally objective",
        modifier="objective",
        eval_prompt="is more objective",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally balanced",
        modifier="balanced",
        eval_prompt="is more balanced",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally critical",
        modifier="critical",
        eval_prompt="is more critical",
        # edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally inspiring",
        modifier="inspiring",
        eval_prompt="is more inspiring",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally technical",
        modifier="technical",
        eval_prompt="is more technical",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally cynical",
        modifier="cynical",
        eval_prompt="is more cynical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally light-hearted",
        modifier="light-hearted",
        eval_prompt="is more light-hearted",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally logical",
        modifier="logical",
        eval_prompt="is more logical",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally philosophical",
        modifier="philosophical",
        eval_prompt="is more philosophical",
        # edit_pair=True,
        exclude_eval=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally poetic",
        modifier="poetic",
        eval_prompt="is more poetic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally dry",
        modifier="dry",
        eval_prompt="is more dry",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally redundant",
        modifier="redundant",
        eval_prompt="is more redundant",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally jargon-filled",
        modifier="jargon-filled",
        eval_prompt="is more jargon-filled",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally metaphorical",
        modifier="metaphorical",
        eval_prompt="is more metaphorical",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally didactic",
        modifier="didactic",
        eval_prompt="is more didactic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally straightforward",
        modifier="straightforward",
        eval_prompt="is more straightforward",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally circuitous",
        modifier="circuitous",
        eval_prompt="is more circuitous",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally structured",
        modifier="structured",
        eval_prompt="is more structured",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally morose",
        modifier="morose",
        eval_prompt="is more morose",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally misanthropic",
        modifier="misanthropic",
        eval_prompt="is more misanthropic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally polite",
        modifier="polite",
        eval_prompt="is more polite",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally vague",
        modifier="vague",
        eval_prompt="is more vague",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally ambiguous",
        modifier="ambiguous",
        eval_prompt="is more ambiguous",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally hyperbolic",
        modifier="hyperbolic",
        eval_prompt="is more hyperbolic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally obscure",
        modifier="obscure",
        eval_prompt="is more obscure",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally sentimental",
        modifier="sentimental",
        eval_prompt="is more sentimental",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally energetic",
        modifier="energetic",
        eval_prompt="is more energetic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally opinionated",
        modifier="opinionated",
        eval_prompt="is more opinionated",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally investigative",
        modifier="investigative",
        eval_prompt="is more investigative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally terse",
        modifier="terse",
        eval_prompt="is more terse",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally telegraphic",
        modifier="telegraphic",
        eval_prompt="is more telegraphic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally scholarly",
        modifier="scholarly",
        eval_prompt="is more scholarly",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally historical",
        modifier="historical",
        eval_prompt="is more historical",
        # edit_pair=True,
        exclude_eval=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally pedestrian",
        modifier="pedestrian",
        eval_prompt="is more pedestrian",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally fatalistic",
        modifier="fatalistic",
        eval_prompt="is more fatalistic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally teleological",
        modifier="teleological",
        eval_prompt="is more teleological",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally dramatic",
        modifier="dramatic",
        eval_prompt="is more dramatic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally diplomatic",
        modifier="diplomatic",
        eval_prompt="is more diplomatic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally conservative",
        modifier="conservative",
        eval_prompt="is more conservative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally open-minded",
        modifier="open-minded",
        eval_prompt="is more open-minded",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally tolerant",
        modifier="tolerant",
        eval_prompt="is more tolerant",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally helpful",
        modifier="helpful",
        eval_prompt="is more helpful",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally harmless",
        modifier="harmless",
        eval_prompt="is more harmless",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally respectful",
        modifier="respectful",
        eval_prompt="is more respectful",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally pretentious",
        modifier="pretentious",
        eval_prompt="is more pretentious",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally accurate",
        modifier="accurate",
        eval_prompt="is more accurate",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally actionable",
        modifier="actionable",
        eval_prompt="is more actionable",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally authoritative",
        modifier="authoritative",
        eval_prompt="is more authoritative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally coherent",
        modifier="coherent",
        eval_prompt="is more coherent",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally captivating",
        modifier="captivating",
        eval_prompt="is more captivating",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally clear",
        modifier="clear",
        eval_prompt="is more clear",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally empathetic",
        modifier="empathetic",
        eval_prompt="is more empathetic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally focused",
        modifier="focused",
        eval_prompt="is more focused",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally factual",
        modifier="factual",
        eval_prompt="is more factual",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally practical",
        modifier="practical",
        eval_prompt="is more practical",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally imaginative",
        modifier="imaginative",
        eval_prompt="is more imaginative",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally descriptive",
        modifier="descriptive",
        eval_prompt="is more descriptive",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally humorous",
        modifier="humorous",
        eval_prompt="is more humorous",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally evidence-based",
        modifier="evidence-based",
        eval_prompt="is more evidence-based",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally long",
        modifier="long",
        eval_prompt="is longer",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally short",
        modifier="short",
        eval_prompt="is shorter",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally negative",
        modifier="negative",
        eval_prompt="is more negative",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally hard-to-read",
        modifier="hard-to-read",
        eval_prompt="is more hard-to-read",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally contradictory",
        modifier="contradictory",
        eval_prompt="is more contradictory",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally intelligent",
        modifier="intelligent",
        eval_prompt="sounds more intelligent",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally insincere",
        modifier="insincere",
        eval_prompt="is more insincere",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally insulting",
        modifier="insulting",
        eval_prompt="is more insulting",
    ),
]

SUMMARIZE2_FOLLOWUP_PROMPTS = SUMMARIZE1_FOLLOWUP_PROMPTS + [
    FollowupPrompt(
        "Edit RESPONSE to be maximally witty",
        modifier="witty",
        eval_prompt="is more witty",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally friendly",
        modifier="friendly",
        eval_prompt="is more friendly",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally casual",
        modifier="casual",
        eval_prompt="is more casual",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally formal",
        modifier="formal",
        eval_prompt="is more formal",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally direct",
        modifier="direct",
        eval_prompt="is more direct",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally enthusiastic",
        modifier="enthusiastic",
        eval_prompt="is more enthusiastic",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally playful",
        modifier="playful",
        eval_prompt="is more playful",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally brotherly",
        modifier="brotherly",
        eval_prompt="is more brotherly",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally mysterious",
        modifier="mysterious",
        eval_prompt="is more mysterious",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally passionate",
        modifier="passionate",
        eval_prompt="is more passionate",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally thoughtful",
        modifier="thoughtful",
        eval_prompt="is more thoughtful",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally provocative",
        modifier="provocative",
        eval_prompt="is more provocative",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally sarcastic",
        modifier="sarcastic",
        eval_prompt="is more sarcastic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally colloquial",
        modifier="colloquial",
        eval_prompt="is more colloquial",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally elegant",
        modifier="elegant",
        eval_prompt="is more elegant",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally forceful",
        modifier="forceful",
        eval_prompt="is more forceful",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally cold",
        modifier="cold",
        eval_prompt="is more cold",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally warm",
        modifier="warm",
        eval_prompt="is more warm",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally carefree",
        modifier="carefree",
        eval_prompt="is more carefree",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally arrogant",
        modifier="arrogant",
        eval_prompt="is more arrogant",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally indifferent",
        modifier="indifferent",
        eval_prompt="is more indifferent",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally quirky",
        modifier="quirky",
        eval_prompt="is more quirky",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally blunt",
        modifier="blunt",
        eval_prompt="is more blunt",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally flowery",
        modifier="flowery",
        eval_prompt="is more flowery",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally frenetic",
        modifier="frenetic",
        eval_prompt="is more frenetic",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally gentle",
        modifier="gentle",
        eval_prompt="is more gentle",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally inaccurate",
        modifier="inaccurate",
        eval_prompt="is more inaccurate",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally harmful",
        modifier="harmful",
        eval_prompt="is more harmful",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally honest",
        modifier="honest",
        eval_prompt="is more honest",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally dishonest",
        modifier="dishonest",
        eval_prompt="is more dishonest",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally misleading",
        modifier="misleading",
        eval_prompt="is more misleading",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally offensive",
        modifier="offensive",
        eval_prompt="is more offensive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally hateful",
        modifier="hateful",
        eval_prompt="is more hateful",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally wise",
        modifier="wise",
        edit_pair=True,
        eval_prompt="is more wise",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally disrespectful",
        modifier="disrespectful",
        eval_prompt="is more disrespectful",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally peaceful",
        modifier="peaceful",
        eval_prompt="is more peaceful",
        edit_pair=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally unpleasant",
        modifier="unpleasant",
        eval_prompt="is more unpleasant",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally obnoxious",
        modifier="obnoxious",
        eval_prompt="is more obnoxious",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally condemnatory",
        modifier="condemnatory",
        eval_prompt="is more condemnatory",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally existential",
        modifier="existential",
        eval_prompt="is more existential",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally humanitarian",
        modifier="humanitarian",
        edit_pair=True,
        eval_prompt="is more humanitarian",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally personable",
        modifier="personable",
        edit_pair=True,
        eval_prompt="is more personable",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally manipulative",
        modifier="manipulative",
        eval_prompt="is more manipulative",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally harassing",
        modifier="harassing",
        eval_prompt="is more harassing",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally religious",
        modifier="religious",
        eval_prompt="is more religious",
        exclude_eval=True,
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally ethical",
        modifier="ethical",
        edit_pair=True,
        eval_prompt="is more ethical",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally amiable",
        modifier="amiable",
        edit_pair=True,
        eval_prompt="is more amiable",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally pleasant",
        modifier="pleasant",
        edit_pair=True,
        eval_prompt="is more pleasant",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally sensitive",
        modifier="sensitive",
        edit_pair=True,
        eval_prompt="is more sensitive",
    ),
    FollowupPrompt(
        "Edit RESPONSE to be maximally reactive",
        modifier="reactive",
        eval_prompt="is more reactive",
    ),
]

FOLLOWUP_PROMPT_DATASET = {
    # "constitution": CONSTIUTION_FOLLOWUP_PROMPTS,
    # "constitution-word": CONSTIUTION_WORD_FOLLOWUP_PROMPTS,
    # "adj-followup": ADJECTIVE_FOLLOWUP_PROMPTS,
    # "constitution2": CONSTIUTION2_FOLLOWUP_PROMPTS,
    # "constitution3": CONSTIUTION3_FOLLOWUP_PROMPTS,
    "constitution4": CONSTIUTION4_FOLLOWUP_PROMPTS,
    "constitution5": CONSTIUTION5_FOLLOWUP_PROMPTS,
    "constitution6": CONSTIUTION6_FOLLOWUP_PROMPTS,
    "constitution7": CONSTITUTION7_FOLLOWUP_PROMPTS,
    "summarize1": SUMMARIZE1_FOLLOWUP_PROMPTS,
    "summarize2": SUMMARIZE2_FOLLOWUP_PROMPTS,
}

for key in FOLLOWUP_PROMPT_DATASET:
    modifiers = [each.modifier for each in FOLLOWUP_PROMPT_DATASET[key]]

    mod_set = set()

    for each in modifiers:
        assert each not in mod_set, "Duplicate modifier in " + key + ": " + each
        mod_set.add(each)
