# BasedOn
 BasedOn is a library used to integrate Machine Learning into programming. With this library, you can have better interpretability with fewer data.
 BasedOn is a work in progress, input is welcome.
 
## Requirements
  - PyTorch
  - gymnasium
## Methods

   ### BasedOn Class ###
This is the main class and can contain several models that are used for making decisions. This class has following methods:



**`episode_ends (gamma=0.999)`**
trains the agents (changes their weights) with the current episode data. **`Gamma`** is used to reduce the effect of future rewards on the current decision. 


**`eval()`**
changes the mode to evaluation mode.


**`train()`**
changes the mode to training mode.


**`if_based_on(name, *input, **kwargs)`**
returns a decision based on inputs. **`name`** could be used to reuse the same decision maker in another part of the code. 


**`choose_based_on(self, name, count, *input, **kwargs)`**
choosed one integer in [0, count) based on inputs.  **`name`** could be used to reuse the same decision maker in another part of the code. 


**`choose_based_on_continues(name, count, *input, **kwargs)`**
 chooses one real number in [0, count) based on inputs. **`name`** could be used to reuse the same decision maker in another part of the code. 
       

**`recored_reward(reward)`**
records the reward. These rewards will be used when **`episode_ends`** is called to train the weights. 
  
 
## Examples
  - [MountainCar](https://gymnasium.farama.org/environments/classic_control/mountain_car/)
    ```python
    def car(state, f):
        x, v = state
        if x > valley_threshold and v < 0:
            return left
        if x < valley_threshold and v > 0:
            return right
        if x > valley_threshold:
            if f.if_based_on("right", state):
                return left
            else:
                return right
        if x < valley_threshold:
            if f.if_based_on("left", state):
                return left
            else:
                return right
    ```
    In this example we have the intuition that if the car is going down the valley it should accelerate in the same direction to increase its speed. We showed that this intuition improves the performance. 
            
  - Simple Differential Code
    
    *Assuming **f_hat** is the ground truth, the function we want to find would be:*
      ```python
      def f_hat(x1, x2):
        if x1 * math.pi - 1 > 5:
            return x1 * 4.569
        else:
            return x2 * 8.598
      ```
      
      *Using our intuition, we gussed the answer would be like the following:*
      ```python
    def learnable_function(x1, x2, f):
        if f.based_on("d1", x1):
            w3 = f.get_learable_variable("w3")
            return x1 * w3
        else:
            w4 = f.get_learable_variable("w4")
            return x2 * w4
      ```
      
      Below is the learned variables we get from BasedOn:

    
    $w_1$:8.0584, $b_1$: -15.2819, $w_3$: 4.5602, $w_4$: 8.5824

    
    $w_3$ and $w_4$ are close to the true values and the if condition is also equivilant to the ground truth because of the following:    
    
      for the If condition, the ground truth is $x_1π - 1 > 5$ and BasedOn tries to find these variables $x_1 + {b \over w} > 0$ to match the original condition. 
    
      Therefore, $x_1 - {6 \over π} = x_1 + {b \over w}$.

     which will result in:

      ${6 \over π} = -{b \over w}$.

    Values that BasedOn found are also close to what they should be:
    
    ${6 \over π} \\approx  1.90 \\approx -{-15.2819 \over 8.0584} =  -{b \over w}$.

    
    
