#!/bin/bash
#SBATCH -p alldlc_gpu-rtx2080 # partition (queue)
#SBATCH --mem 100000 # memory pool for each core (10GB)
#SBATCH -t 1-00:00 # time (D-HH:MM)
#SBATCH -c 10 # number of cores
#SBATCH -o log/%x.%A.%a.out # STDOUT  (the folder log has to be created prior to running or this won't work)
#SBATCH -e log/%x.%A.%a.err # STDERR  (the folder log has to be created prior to running or this won't work)
#SBATCH -J flatland_test # sets the job name. If not specified, the file name will be used as job name
#SBATCH --mail-type=END,FAIL # (recive mails about end and timeouts/crashes of your job)


# maps
map_name=test_02
#map_name=test_02_hard_mal
#map_name=test_02_hard_speed
#map_name=test_02+


# models
model_path=ippo_mlp_test_02-independent_default
model_path=mappo_mlp_test_02-global_default
#model_path=mappo_lcmlp_test_02-local_default


python -u test.py \
    --map_name $map_name \
    --obs_builder fast_tree \
    --seed 2023 \
    --model_path $model_path \

