#!/bin/bash
#SBATCH -p alldlc_gpu-rtx2080 # partition (queue)
#SBATCH --mem 100000 # memory pool for each core (10GB)
#SBATCH -t 1-00:00 # time (D-HH:MM)
#SBATCH -c 10 # number of cores
#SBATCH -o log/%x.%A.%a.out # STDOUT  (the folder log has to be created prior to running or this won't work)
#SBATCH -e log/%x.%A.%a.err # STDERR  (the folder log has to be created prior to running or this won't work)
#SBATCH -J flatland_test # sets the job name. If not specified, the file name will be used as job name
#SBATCH --mail-type=END,FAIL # (recive mails about end and timeouts/crashes of your job)


# mappo_independent
alg_name=mappo
core_arch=lcmlp
params_path=mappo_lcmlp_test_02-local_default/MAPPOTrainer_flatland_test_02-local_default_b62fb_00000_0_2023-09-26_18-14-04_35db/params.json
model_path=mappo_lcmlp_test_02-local_default/MAPPOTrainer_flatland_test_02-local_default_b62fb_00000_0_2023-09-26_18-14-04_35db/checkpoint_011000/checkpoint-11000

python video.py \
    --map_name test_02 \
    --obs_builder fast_tree \
    --seed 2023 \
    --alg_name $alg_name \
    --core_arch $core_arch \
    --params_path $params_path \
    --model_path $model_path \

