
# set up cuda 
export CUDA_VISIBLE_DEVICES=0
export CUDA_DEVICE_ORDER=PCI_BUS_ID

# maps
#map_name=test_00
#map_name=test_02
map_name=test_03


# baseline 1: ippo mlp indpendent
alg_name=ippo
core_arch=mlp
reward=independent
exp_name=default 

## ippo mlp global 
#alg_name=ippo
#core_arch=mlp
#reward=global

## mappo mlp independent 
#alg_name=mappo
#core_arch=mlp
#reward=independent

## baseline 2: mappo mlp global 
#alg_name=mappo
#core_arch=mlp
#reward=global
#exp_name=default 

## lcmlp independent 
#alg_name=mappo
#core_arch=lcmlp
#reward=independent

## baseline 3: lcmlp local 
#alg_name=mappo
#core_arch=lcmlp
#reward=local
#exp_name=default 

for seed in 12345 23451 34512 45123 51234; do
#for seed in 12345; do
    sleep 10s
    # train
    python train.py \
        --map_name $map_name \
        --obs_builder fast_tree \
        --shared_reward $reward \
        --seed ${seed} \
        --alg_name $alg_name \
        --core_arch $core_arch \
        --num_workers 10 \
        --exp_name $exp_name  &
done

