#!/bin/bash
#SBATCH -p alldlc_gpu-rtx2080 # partition (queue)
#SBATCH --mem 100000 # memory pool for each core (10GB)
#SBATCH -t 1-00:00 # time (D-HH:MM)
#SBATCH -c 20 # number of cores
#SBATCH -o log/%x.%A.%a.out # STDOUT  (the folder log has to be created prior to running or this won't work)
#SBATCH -e log/%x.%A.%a.err # STDERR  (the folder log has to be created prior to running or this won't work)
#SBATCH -J flatland-lcppo-03 # sets the job name. If not specified, the file name will be used as job name
#SBATCH --mail-type=END,FAIL # (recive mails about end and timeouts/crashes of your job)

# Print some information about the job to STDOUT
echo "Workingdir: $PWD";
echo "Started at $(date)";
echo "Running job $SLURM_JOB_NAME using $SLURM_JOB_CPUS_PER_NODE cpus per node with given JID $SLURM_JOB_ID on queue $SLURM_JOB_PARTITION";

seed=$((SLURM_ARRAY_TASK_ID+2023))
echo "Seed $seed"

# maps
map_name=test_01
map_name=test_02
map_name=test_02+
map_name=test_03

# baseline 1: ippo mlp indpendent
alg_name=ippo
core_arch=mlp
reward=independent
exp_name=default 

# baseline 2: mappo mlp global 
alg_name=mappo
core_arch=mlp
reward=global
exp_name=default
 
# baseline 3: lcmlp local 
alg_name=mappo
core_arch=lcmlp
reward=local
exp_name=bs256_lr1e-4

sleep $(($SLURM_ARRAY_TASK_ID*10)) s

python -u train.py \
    --map_name $map_name \
    --obs_builder fast_tree \
    --shared_reward $reward \
    --seed $seed \
    --alg_name $alg_name \
    --core_arch $core_arch \
    --num_workers 10 \
    --exp_name $exp_name

