# Propagation Invariance

Please follow the instructions below to reproduce our experiments.

## Environments
## Set Up

We use python version 3.9 and pytorch 1.12.1, which can be installed in a conda environment as follows:

```console
conda create --name IBP_Theory python=3.9
conda activate IBP_Theory
conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=11.6 -c pytorch -c conda-forge
```

To install further requirements please run 
```
pip install -r requirements.txt
```


## Core Files

- ```PI_functions.py```: implements the computation of tightness.
- ```IBP_embedding_exp.py```: implements the embedding experiment.
- ```relu_initialization.py```: implements the intialization experiment.
- ```get_stat.py```: implements various statistics computation for model checkpoints.

## Commands for Experiment

To reproduce all our experiments please run the following scripts 

- ```train_cifar_arch.sh``` reproduces the depth and width experiment.
- ```train_cifar_eps.sh``` reproduces the experiment investigating the dependence of tightness on training perturbation magnitude epsilon.
- ```train_cifar_SABR``` reproduces the experiment investigating tightness for SABR trained networks.

## Pretrained Models

As training all models takes some time, we release pretrained models [here](https://mega.nz/file/GeRlmZyK#K-JGtFPdZ8HA3V3qHEimTHfOipk6fajna7yEbBSmD5Y). 
Due to space constraints on our anonymous hosting, we only include models for one random seed (still 10GB) but will release all models upon publication.