# Code for our ICLR 2024, Model Pruning with Model Transfer.

## Using Random/L1-norm/DegGrph to implement ViT pruning

```bash
  # for instance, L1-norm prune FLOPs 63.0% with the pipeline S-->TP^w-->T.
  python3 prune_ViT.py \
        --dist_url 'tcp://localhost:' \
        --multiprocessing-distributed \
        --world_size 1 \
        --local_rank 0 \
        --dataset 'iNat2018' \
        --batch_size 512 \
        --epochs 200 \
        --lr 0.02 \
        --min_lr 0.0 \
        --warmup_epochs 5 \
        --weight_decay 1e-4 \
        --setting D \
        --prune_rule 'L1norm' \
        --prune_rate 0.4 \
        --save_dir "./run/ViT/iNat2018/L1norm/prune63.0/D"
  ```
`Notes`
 - set `prune rule` to `random`, `L1norm` or `DepGrph` to implement different prune methods.
 - `prune rate` represents the pruning rate of FLOPs.
 - set `dataset` to `CUB200`, `CIFAR`, or `iNat2018`.
 - the `setting` means different prune pipeline, include: B (`SP^w--T`), D (`S-->TP^w-->T`).