## General Settings
We set the below settings for all experiments in


**dSprites & 3D Shapes & MPI3D**

* GPUs: NVIDIA GeForce RTX 2080 Ti x 1

* GPUs: NVIDIA GeForce RTX 3090 x 1

* GPUs: NVIDIA A100

## Requirements

To create the environment:
    
    # env.yaml file is in setup folder
    conda env create -f $DIR$/env.yaml
    
    # if GLIBCXX_3.4.29' not found ISSUE then follow
    strings /usr/lib/x86_64-linux-gnu/libstdc++.so.6 | grep GLIBCXX
    sudo add-apt-repository ppa:ubuntu-toolchain-r/test
    sudo apt-get update
    sudo apt-get install gcc-4.9
    sudo apt-get upgrade libstdc++6
    
    # If it still on ISSIE
    # add under commend to /etc/apt/source.list 
    deb http://dk.archive.ubuntu.com/ubuntu/ xenial main
    deb http://dk.archive.ubuntu.com/ubuntu/ xenial universe
    
    # run again
    sudo apt update && sudo apt install gcc-4.9
    


## Path

Set your path of projects and datasets as follow:

    .
    |---projects
    |   |---CMCS_ICLR
    |---datasets
    |   |---disentanglement
    |   |   |---{dataset name} check datasets folder


## Datasets
Download dataset from the link or run dataloader. If the dataset path is not exist, then model download dataset.

 **dSprites**:
 Download dsprites_ndarray_co1sh3sc6or40x32y32_64x64.npz from [here](https://github.com/deepmind/dsprites-dataset).
 
 **3D Shapes**:
 Download 3dshapes.h5 file from [here](https://github.com/deepmind/3d-shapes).
 
 **MPI3D (real-world complex dataset)**:
 Download 3dshapes.h5 file from [here](https://github.com/rr-learning/disentanglement_dataset).
 

## Run Model
run shell script file in the ./cg/src/runs and ./dl/src/runs folders for combinatorial generalization and disentanglement learning, respectively.

### Training and evaluation

Set hyper-parameters of each model and run shell script.
The details of each model and task are in the README.md file in ./cg/src/runs and ./dl/src/runs folders for combinatorial generalization and disentanglement learning, respectively.


Beta-VAE

    sh ./{DIR}/cg/src/runs/betavae.sh
    sh ./{DIR}/dl/src/runs/betavae.sh
    
Beta-tcVAE

    sh ./{DIR}/cg/src/runs/betatcvae.sh
    sh ./{DIR}/dl/src/runs/betatcvae.sh
    
CLG-VAE

    sh ./{DIR}/dl/src/runs/clgvae.sh
    
Factor-VAE

    sh ./{DIR}/dl/src/runs/factorvae.sh

    
CMCS (GT)

    sh ./{DIR}/cg/src/runs/cmcs/cmcs_gt.sh
    sh ./{DIR}/dl/src/runs/cmcs/cmcs_gt.sh
    
CMCS (SP)

    sh ./{DIR}/cg/src/runs/cmcs/cmcs_super.sh
    sh ./{DIR}/dl/src/runs/cmcs/cmcs_super.sh
    
CMCS (semi)

    sh ./{DIR}/dl/src/runs/cmcs/cmcs_semisuper.sh
  
  
More details are in the paper.


## Contributing

All content in this repository is licensed under the MIT license.