#!/bin/sh
PYTHON_FILE="{YOUR PATH}/CMCS_ICLR_code/cg/main.py"
DEVICE_IDX="0"
DATASET="{CHOOSE DATASET}"
MODEL_TYPE="betavae"
PROJECT_NAME="{SET WANDB PROJECT NAME}"
ENTITY="{WANDB ID}"
CG="{CHOOSE THE TASK}"
LATENT_DIM="{SET LATENT DIMENSION}"
TRAIN_BATCH_SIZE="64"
TEST_BATCH_SIZE="64"
NUM_EPOCH="100"
MAX_STEPS="0"
SAVE_STEPS="100000000"
SEED="1 2 3"
BETA="{SET HYPER-PARAMETERS}"
NUM_SAMPLING="10"
trap "exit" INT

for MODEL in $MODEL_TYPE
do
  for beta in $BETA
  do
    for EPOCH in $NUM_EPOCH
    do
      for BATCH in $TRAIN_BATCH_SIZE
      do
        for seed in $SEED
        do
          CUDA_VISIBLE_DEVICES=$DEVICE_IDX python $PYTHON_FILE \
          --device_idx $DEVICE_IDX \
          --dataset $DATASET\
          --project_name $PROJECT_NAME \
          --entity $ENTITY \
          --model_type $MODEL \
          --cg $CG \
          --latent_dim $LATENT_DIM \
          --per_gpu_train_batch_size $BATCH \
          --test_batch_size $TEST_BATCH_SIZE \
          --num_epoch $EPOCH \
          --max_steps $MAX_STEPS \
          --save_steps $SAVE_STEPS \
          --beta $beta \
          --seed $seed \
          --quali_sampling $NUM_SAMPLING \
          --do_train --do_eval  --do_analysis
        done
      done
    done
  done
done