#!/bin/sh
PYTHON_FILE="{YOUR PATH}/CMCS_ICLR_code/dl/main.py"
DEVICE_IDX="0"
DATASET="{CHOOSE DATASET}"
MODEL_TYPE="clgvae"
PROJECT_NAME="{SET WANDB PROJECT NAME}"
ENTITY="{WANDB ID}"
LATENT_DIM="{SET LATENT DIMENSION}"
TRAIN_BATCH_SIZE="64"
TEST_BATCH_SIZE="512"
NUM_EPOCH="0"
MAX_STEPS="{SET TRAINING ITERATION}"
SAVE_STEPS="100000000"
SEED="1 2 3 4 5 6 7 8 9 10"
HY_HES="40.0"
HY_REC="{SET HYPER-PARAMETERS}"
HY_COMMUTE="20.0"
FORWARD_EQ_PROB="0.2"
SUBGROUP_SIZES_LS="{SET HYPER-PARAMETERS}"
SUBSPACE_SIZES_LS="{SET HYPER-PARAMETERS}"
NUM_SAMPLING="10"
trap "exit" INT

for MODEL in $MODEL_TYPE
do
  for hy_hes in $HY_HES
  do
    for hy_rec in $HY_REC
    do
      for hy_commute in $HY_COMMUTE
      do
        for EPOCH in $NUM_EPOCH
        do
          for BATCH in $TRAIN_BATCH_SIZE
          do
            for seed in $SEED
            do
              CUDA_VISIBLE_DEVICES=$DEVICE_IDX python $PYTHON_FILE \
              --device_idx $DEVICE_IDX \
              --dataset $DATASET\
              --project_name $PROJECT_NAME \
              --entity $ENTITY \
              --model_type $MODEL \
              --latent_dim $LATENT_DIM \
              --per_gpu_train_batch_size $BATCH \
              --test_batch_size $TEST_BATCH_SIZE \
              --num_epoch $EPOCH \
              --max_steps $MAX_STEPS \
              --save_steps $SAVE_STEPS \
              --seed $seed \
              --hy_hes $hy_hes --hy_rec $hy_rec --hy_commute $hy_commute \
              --forward_eq_prob $FORWARD_EQ_PROB \
              --subgroup_sizes_ls $SUBGROUP_SIZES_LS \
              --subspace_sizes_ls $SUBSPACE_SIZES_LS \
              --quali_sampling $NUM_SAMPLING \
              --do_train --do_eval --do_analysis
            done
          done
        done
      done
    done
  done
done