#!/bin/sh
PYTHON_FILE="{YOUR PATH}/CMCS_ICLR_code/dl/main.py"
DEVICE_IDX="0"
DATASET="{CHOOSE DATASET}"
MODEL_TYPE="cmcs_super"
PROJECT_NAME="{SET WANDB PROJECT NAME}"
ENTITY="{WANDB ID}"
LATENT_DIM="{SET LATENT DIMENSION}"
TRAIN_BATCH_SIZE="64"
TEST_BATCH_SIZE="512"
NUM_EPOCH="0"
MAX_STEPS="{SET TRAINING ITERATION}"
SAVE_STEPS="100000000"
SEED="1 2 3 4 5 6 7 8 9 10"
NTH_ROOT="{SET HYPER-PARAMETERS}"
NUM_SAMPLING="10"
ALPHA="{SET HYPER-PARAMETERS}"
BETA="{SET HYPER-PARAMETERS}"
GAMMA="{SET HYPER-PARAMETERS}"
trap "exit" INT

for MODEL in $MODEL_TYPE
do
  for nth_root in $NTH_ROOT
  do
    for EPOCH in $NUM_EPOCH
    do
      for alpha in $ALPHA
      do
        for beta in $BETA
        do
          for gamma in $GAMMA
          do
            for BATCH in $TRAIN_BATCH_SIZE
            do
              for seed in $SEED
              do
                CUDA_VISIBLE_DEVICES=$DEVICE_IDX python $PYTHON_FILE \
                --device_idx $DEVICE_IDX \
                --dataset $DATASET\
                --project_name $PROJECT_NAME \
                --entity $ENTITY \
                --model_type $MODEL \
                --latent_dim $LATENT_DIM \
                --per_gpu_train_batch_size $BATCH \
                --test_batch_size $TEST_BATCH_SIZE \
                --num_epoch $EPOCH \
                --max_steps $MAX_STEPS \
                --save_steps $SAVE_STEPS \
                --alpha $alpha --beta $beta --gamma $gamma \
                --nth_root $nth_root \
                --seed $seed \
                --quali_sampling $NUM_SAMPLING \
                --do_train --do_eval --do_analysis
              done
            done
          done
        done
      done
    done
  done
done