import os

from torchvision.datasets import ImageNet
from vissl.data.dataset_catalog import VisslDatasetCatalog
from vissl.utils.io import save_file

ROOT = "./ats/data/datasets/"  # Where to store data.

if __name__ == "__main__":
    _ = ImageNet(root=ROOT, train=True, download=True)
    _ = ImageNet(root=ROOT, train=False, download=True)

    json_data = {
        "ImageNet": {
          "train": [
            os.path.abspath(ROOT), "<unused>"
          ],
          "val": [
            os.path.abspath(ROOT), "<unused>"
          ]
        }
    }

    save_file(json_data, "./configs/config/dataset_catalog.json", append_to_json=False)
    VisslDatasetCatalog.register_json("./configs/config/dataset_catalog.json")
    print(f"Regstered datasets: {VisslDatasetCatalog.list()}")
