import os
import shutil

from vissl.data.dataset_catalog import VisslDatasetCatalog
from vissl.utils.io import save_file, load_file, makedir
from json import JSONDecodeError
from extra_scripts.create_inaturalist2018_data_files import download_dataset, get_images_labels_info


ROOT = "./ats/data/datasets/"  # Where to store data.
LABEL2IDX = None
N_CLASSES = None
IDX2LABEL = None


if __name__ == "__main__":
    raw_dir = os.path.join(ROOT, "tmp")
    makedir(raw_dir)
    download_dataset(raw_dir)

    train_images, train_labels = get_images_labels_info("/train2018.json", raw_dir)
    val_images, val_labels = get_images_labels_info("/val2018.json", raw_dir)

    output_path = os.path.join(ROOT, "inaturalist2018")
    makedir(output_path)

    train_label_file_name = f"{output_path}/train_labels.npy"
    train_image_file_name = f"{output_path}/train_images.npy"
    save_file(train_images, train_image_file_name)
    save_file(train_labels, train_label_file_name)

    val_label_file_name = f"{output_path}/val_labels.npy"
    val_image_file_name = f"{output_path}/val_images.npy"
    save_file(val_images, val_image_file_name)
    save_file(val_labels, val_label_file_name)

    shutil.rmtree(raw_dir)

    json_data = {
        "inaturalist2018_filelist": {
          "train": [
              os.path.join(os.path.abspath(ROOT), "inaturalist2018/train_images.npy"),
              os.path.join(os.path.abspath(ROOT), "inaturalist2018/train_labels.npy")
          ],
          "val": [
              os.path.join(os.path.abspath(ROOT), "inaturalist2018/val_images.npy"),
              os.path.join(os.path.abspath(ROOT), "inaturalist2018/val_labels.npy")
          ]
        }
    }

    try:
        metadata = load_file("dataset_catalog.json")
        metadata.update(json_data)
    except JSONDecodeError:
        metadata = json_data

    save_file(metadata, "dataset_catalog.json", append_to_json=False)
    VisslDatasetCatalog.register_json("dataset_catalog.json")
    print(f"Regstered datasets: {VisslDatasetCatalog.list()}")
