import os
import shutil

from vissl.data.dataset_catalog import VisslDatasetCatalog
from vissl.utils.io import save_file, load_file
from json import JSONDecodeError
from extra_scripts.create_oxford_pets_data_files import download_oxford_pets, create_oxford_pets_disk_folder


ROOT = "./ats/data/datasets/"  # Where to store data.
LABEL2IDX = None
N_CLASSES = None
IDX2LABEL = None


if __name__ == "__main__":
    raw_dir = os.path.join(ROOT, "tmp")
    download_oxford_pets(raw_dir)
    create_oxford_pets_disk_folder(input_path=raw_dir, output_path=os.path.join(ROOT, "oxford_pets"))
    shutil.rmtree(raw_dir)  # Removing the directory containing raw data.

    json_data = {
        "oxford_pets": {
          "train": [
            os.path.join(os.path.abspath(ROOT), "oxford_pets/train"), "<ignored>"
          ],
          "val": [
            os.path.join(os.path.abspath(ROOT), "oxford_pets/test"), "<ignored>"
          ]
        }
    }

    try:
        metadata = load_file("dataset_catalog.json")
        metadata.update(json_data)
    except JSONDecodeError:
        metadata = json_data

    save_file(metadata, "dataset_catalog.json", append_to_json=False)
    VisslDatasetCatalog.register_json("dataset_catalog.json")
    print(f"Regstered datasets: {VisslDatasetCatalog.list()}")
