import torch
from tqdm import tqdm


def evaluate(model_1, dataloader, device):
    n_correctly_classified, total = 0, 0
    try:
        model_1.eval()
        with torch.no_grad():
            for batch_idx, (images, labels) in enumerate(tqdm(dataloader)):
                images, labels = images.to(device), labels.to(device)

                pred = model_1(images).argmax(dim=1)

                n_correctly_classified += (pred == labels).sum()
                total += labels.shape[0]

        print(f"Accuracy on {total} examples:  {n_correctly_classified / total}")
    except Exception as e:
        print("Error in evaluation: ", e)
        return None
    return n_correctly_classified / total
