#!/bin/bash
# This script is used to download all VISSL models models in  the list to ./ats/vissl_tools/models directory.


all_models_links=(
https://dl.fbaipublicfiles.com/vissl/model_zoo/jigsaw_rn50_in1k_ep105_perm2k_jigsaw_8gpu_resnet_20_07_20.3d706467/model_final_checkpoint_phase104.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_vissl_jigsaw_rn50_perm2k_in22k_8gpu_ep105.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_vissl_rn50_jigsaw_in1k_goyal19.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_vissl_rn50_jigsaw_in22k_goyal19.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_vissl_rn50_jigsaw_yfcc100m_goyal19.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_alexnet_jigsaw_in1k_pretext.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_alexnet_jigsaw_in22k_pretext.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_alexnet_jigsaw_yfcc100m_pretext.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_vissl_rn50_colorization_in1k_goyal19.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_vissl_rn50_colorization_in22k_goyal19.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_vissl_rn50_colorization_yfcc100m_goyal19.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_alexnet_colorization_in1k_pretext.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_alexnet_colorization_in22k_pretext.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_alexnet_colorization_yfcc100m_pretext.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/converted_vissl_rn50_rotnet_16kclusters_in1k_ep105.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/npid_pp/4node_800ep_32kneg_cosine_resnet_23_07_20.75432662/model_final_checkpoint_phase799.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/pirl_jigsaw_4node_pirl_jigsaw_4node_resnet_22_07_20.34377f59/model_final_checkpoint_phase799.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/simclr_rn50_800ep_simclr_8node_resnet_16_07_20.7e8feed1/model_final_checkpoint_phase799.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/simclr_rn50w4_1000ep_bs32_16node_simclr_8node_resnet_28_07_20.9e20b0ae/model_final_checkpoint_phase999.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/simclr_rn101_1000ep_simclr_8node_resnet_16_07_20.35063cea/model_final_checkpoint_phase999.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/baselines/converted_simclr_v2_r152_3x_sk1_ema.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/baselines/converted_byol_pretrain_res200w2.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/deepclusterv2_800ep_pretrain.pth.tar
https://dl.fbaipublicfiles.com/vissl/model_zoo/swav_in1k_rn50_800ep_swav_8node_resnet_27_07_20.a0a6b676/model_final_checkpoint_phase799.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/swav_4gpu_bs64_400ep_2x224_6x96_queue_swav_8node_resnet_28_07_20.5e967ca0/model_final_checkpoint_phase399.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/swav_regnet128_in1k/model_phase230.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/swav_rn50w5/mocov3-vit-b-300ep.pth.tar
# https://dl.fbaipublicfiles.com/vissl/model_zoo/barlow_twins/barlow_twins_32gpus_4node_imagenet1k_1000ep_resnet50.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/dino_300ep_deitsmall16/model_final_checkpoint_phase299.torch
https://dl.fbaipublicfiles.com/vissl/model_zoo/dino_300ep_xcitsmall16/model_phase250.torch
)

big_models_links=(
# https://dl.fbaipublicfiles.com/vissl/model_zoo/baselines/converted_simclr_v2_r152_3x_sk1_ema.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/simclr_rn50w4_1000ep_bs32_16node_simclr_8node_resnet_28_07_20.9e20b0ae/model_final_checkpoint_phase999.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/baselines/converted_byol_pretrain_res200w2.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/swav_regnet128_in1k/model_phase230.torch
# https://dl.fbaipublicfiles.com/vissl/model_zoo/barlow_twins/barlow_twins_32gpus_4node_imagenet1k_1000ep_resnet50.torch
)

for model in ${all_models_links[@]}
    do
    ./vissl_tools/helpers/download_model.sh $model
done

#list all the file that contain the word "Error" in the folder
grep -r "Error" ./
#save the output in a file
grep -r "Error" ./ > error.txt
#example file name: ./nips_qbit_v1/NIPS_qbit_v2.dataset_name=oxford_pets_model_path=ats_models_pirl_jigsaw_4node_pirl_jigsaw_4node_resnet_22_07_20_model_final_checkpoint_phase799.torch_tune_mode=finetune_tune_technique=shallow.log:AssertionError: Unknown state dict key: model_state_dict
# sort the file by the model_path 
sort -k 3 -t "=" error.txt > error_sorted.txt



#delete all the files in the subfoldes from model_phase1.torch to model_phase15.torch but not the model_phase bigger than 15
find . -type f -name "model_phase[1-9][1-2].torch" -delete
