# Prompt 1
You will be provided with a full image containing two regions, one demarcated in red and the other in blue. Your task is to determine which region is closer to the camera, or in other words, which region is at a shallower depth.  
Output your answer as a JSON in the following format: 
{ 
  "reasoning_steps": [ 
  "Step 1: ...", 
  "Step 2: ..." 
 ...], 
  "depth_order": ["color 1", "color 2"] 
} 
Important Notes: 
1. The depth_order should list the nearest region first and the farthest region last. 
2. The output color names should be either 'red' or 'blue'. 
3. The reasoning_steps should clearly outline the logical process leading to your final conclusion. 
4. Be sure to distinguish between depth (the distance of an object perpendicular to the image plane) and lateral distance (the distance between objects along the image plane). Focus on spatial relationships to deduce depth accurately. 
5. Consider visual cues such as occlusion, relative size, perspective, and other indicators of depth. Avoid assumptions about specific regions and instead rely on objective evidence from the image. 
6. If the depth order is unclear, explain why in your reasoning steps and provide your best estimate. 
Provide your response in the specified JSON format, ensuring that your reasoning is clear and well-supported by the visual evidence in the image.

# Prompt 2
You are tasked with determining which of two regions in an image, one marked in red and the other in blue, is closer to the camera (i.e., at a shallower depth). Your decision should be based on a thorough analysis of visual depth cues in the provided images, without making assumptions about object types or real-world scene layouts. 
### Steps to Approach the Task 
1. **Analyze the Full Image**: Start by observing the full image that contains both regions. Look for any depth-related visual cues such as perspective lines, lighting and shadows, and relative sizes. Consider whether either region appears to be positioned closer based on these factors. 
2. **Examine Individual Regions**: Next, review the close-up views of the red and blue regions. Look at details like the texture, sharpness, or clarity of each region, as closer objects may appear more detailed. Consider whether these factors provide additional information about which region might be nearer to the camera. 
3. **Synthesize Visual Information**: Combine the insights from the full image and the close-ups to form a complete picture of the scene's depth. Pay attention to how lighting, size, and perspective contribute to the spatial relationships between the two regions. Avoid relying on typical assumptions about scene layouts (e.g., "ceilings are far away" or "floors are closer")—base your reasoning strictly on visual evidence. 
### Provide Your Conclusion 
Once you have analyzed the images, output your reasoning and conclusion in the following JSON format: 
{ 
  "reasoning_steps": [ 
    "Step 1: ...", 
    "Step 2: ...", 
    ... 
  ], 
  "depth_order": ["nearest region", "farthest region"] 
} 
### Guidelines 
- **Depth Cues**: Focus on factors like perspective, relative size, texture sharpness, lighting, and shading to determine which region is closer. 
- **Depth Definition**: Remember, depth refers to distance along the line perpendicular to the camera's view (closer or farther from the camera), not just side-to-side position in the image. 
- **Uncertainty**: If it is not clear which region is closer, explain your reasoning and provide your best estimate based on the visual information you have. 
Ensure that your final decision is supported by visual evidence and that your reasoning is clearly articulated in each step.

# Prompt 3
You will be provided with a full image containing two regions, one demarcated in red and the other in blue. Your task is to determine which region is closer to the camera, or in other words, which region is at a shallower depth.  
Output your answer as a JSON in the following format: 
{ 
  "near": "color of the nearer region", 
} 
Important Notes: 
1. The output color name should be either 'red' or 'blue'. 
2. Be sure to distinguish between depth (the distance of an object perpendicular to the image plane) and lateral distance (the distance between objects along the image plane). Focus on spatial relationships to deduce depth accurately. 
3. Consider visual cues such as occlusion, relative size, perspective, and other indicators of depth. Avoid assumptions about specific regions and instead rely on objective evidence from the image. 
4. If the depth order is unclear, make an educated guess based on the available evidence. 
Provide your response in the specified JSON format, ensuring that your reasoning is clear and well-supported by the visual evidence in the image.

# Prompt 4
You will be provided with a full image containing two regions, one demarcated in red and the other in blue. Your task is to determine which region is closer to the camera, or in other words, which region is at a shallower depth.  
Output your answer as a JSON in the following format: 
{ 
  "depth_order": ["color 1", "color 2"] 
} 
Important Notes: 
1. The depth_order should list the nearest region first and the farthest region last. 
2. The output color names should be either 'red' or 'blue'. 
3. Be sure to distinguish between depth (the distance of an object perpendicular to the image plane) and lateral distance (the distance between objects along the image plane). Focus on spatial relationships to deduce depth accurately. 
4. Consider visual cues such as occlusion, relative size, perspective, and other indicators of depth. Avoid assumptions about specific regions and instead rely on objective evidence from the image. 
5. If the depth order is unclear, provide your best estimate. 
Provide your response in the specified JSON format.

# Prompt 5
You are tasked with determining which of two regions in an image, one marked in red and the other in blue, is closer to the camera (i.e., at a shallower depth). Your decision should be based on a thorough analysis of visual depth cues in the provided images, without making assumptions about object types or real-world scene layouts. 
### Steps to Approach the Task 
1. **Analyze the Full Image**: Start by observing the full image that contains both regions. Look for any depth-related visual cues such as perspective lines, lighting and shadows, and relative sizes. Consider whether either region appears to be positioned closer based on these factors. 
2. **Examine Individual Regions**: Next, review the close-up views of the red and blue regions. Look at details like the texture, sharpness, or clarity of each region, as closer objects may appear more detailed. Consider whether these factors provide additional information about which region might be nearer to the camera. 
3. **Synthesize Visual Information**: Combine the insights from the full image and the close-ups to form a complete picture of the scene's depth. Pay attention to how lighting, size, and perspective contribute to the spatial relationships between the two regions. Avoid relying on typical assumptions about scene layouts (e.g., "ceilings are far away" or "floors are closer")—base your decision strictly on visual evidence. 
### Provide Your Conclusion 
Once you have analyzed the images, output your conclusion in the following JSON format: 
{ 
  "depth_order": ["nearest region", "farthest region"] 
} 
### Guidelines 
- **Depth Cues**: Focus on factors like perspective, relative size, texture sharpness, lighting, and shading to determine which region is closer. 
- **Depth Definition**: Remember, depth refers to distance along the line perpendicular to the camera's view (closer or farther from the camera), not just side-to-side position in the image. 
- **Uncertainty**: If it is not clear which region is closer, provide your best estimate based on the visual information you have.