# Prompt 1
You will be shown a region of an image marked by a red boundary. This region is part of a larger object or background in the image.  
You'll also see several additional regions marked with blue boundaries.  
Your task is to determine which blue-marked regions belong to the same broad object or background category as the red-marked region. Focus on identifying the general, overarching object or background category, rather than specific details within the region.  
Provide your answer in JSON format, where the key is the region index and the value is either "yes" or "no": 
"yes" if the region is part of the same object or background category as the initial region. 
"no" if it is not. 
Also, include a brief explanation of your reasoning. Example: {"reasoning_steps": [the reasoning steps leading to the final conclusion], "1": "yes", "2": "no", "3": "yes", "4": "no"} (if there are 4 blue regions) 
Important guidelines: 
1. Always identify the broader context: If a region shows a part of an object (e.g., an animal's fur, a car's wheel), you MUST identify it as the whole object (e.g., the animal, the car), not just that specific part. 
2. Multiple instances: If regions belong to different instances of the same type of object (e.g., two different chairs), mark them as "no" even if they're the same type of object.

# Prompt 2 
You will be shown a region of an image marked by a red boundary. This region is part of a larger object or background in the image. You'll also see several additional regions marked with blue boundaries.  
Your task is to determine which blue-marked regions belong to the same overall object or background category as the red-marked region. Focus on identifying the complete object or background, rather than specific parts or features of the region.  
### Important Guidelines: 
1. **Holistic Identification**: Always consider the broader context of the red-marked region. For example, if the red-marked region shows part of an animal's nose, you should identify the entire animal as the object, not just the nose. Similarly, if it shows a car's wheel, the object is the entire car. Avoid focusing on small details or fragments; think in terms of the whole object or background. 
2. **General Object or Background Category**: Focus on the broad category (e.g., "animal," "vehicle," "natural environment"). If the blue region belongs to the same object category as the red-marked region, mark it as "yes." For instance, if the red-marked region shows part of an dog, and a blue region shows another part of the same dog, mark it as "yes." If a blue region shows another dog, mark it as "no," even if it's the same type of animal. 
3. **Instance Consistency**: If regions belong to different instances of the same object type (e.g., two separate objects of the same kind), mark them as "no." Each region should be part of the exact same object or background as the red-marked region. 
4. **Clear Boundaries**: Ensure that you consider the complete boundaries of the object or background when matching the regions. The entire region must fit within the same object category. 
### Output Format: 
Provide your answer in JSON format, where the key is the region index and the value is either "yes" or "no": 
- "yes" if the region is part of the same object or background category as the red-marked region. 
- "no" if it is not. 
Also, include a brief explanation of your reasoning. Example: {"reasoning_steps": [the reasoning steps leading to the final conclusion], "1": "yes", "2": "no", "3": "yes", "4": "no"} (if there are 4 blue regions).

# Prompt 3
You will be shown a region of an image marked by a red boundary. This region is part of a larger object or background in the image. You'll also see several additional regions marked with blue boundaries. 
Your task is to determine which blue-marked regions belong to the same overall object or background category as the red-marked region. Focus on identifying the complete object or background, rather than specific parts or features of the region. 
### Important Guidelines: 
1. **Holistic Identification**: Always consider the broader context of the red-marked region. For example, if the red-marked region shows part of an animal's nose, you should identify the entire animal as the object, not just the nose. Similarly, if it shows part of a vehicle, such as a wheel, the object is the entire vehicle. Avoid focusing on small details or fragments; think in terms of the whole object or background. 
2. **Apostrophe-S Test**: To ensure holistic identification, apply the "apostrophe-s" test in your reasoning. For example, if the region shows "the animal's nose," the full object is the "animal." If the red-marked region is "the vehicle's wheel," the full object is the "vehicle." Use this test to think about whether the part belongs to a larger, more complete entity. 
3. **General Object or Background Category**: Focus on the broad category (e.g., "animal," "vehicle," "natural environment"). If the blue region belongs to the same object category as the red-marked region, mark it as "yes." For instance, if the red-marked region shows part of an animal, and a blue region shows another part of the same animal, mark it as "yes." If a blue region shows another animal, mark it as "no," even if it's the same type of animal. 
4. **Instance Consistency**: If regions belong to different instances of the same object type (e.g., two separate objects of the same kind), mark them as "no." Each region should be part of the exact same object or background as the red-marked region. 
5. **Clear Boundaries**: Ensure that you consider the complete boundaries of the object or background when matching the regions. The entire region must fit within the same object category. 
### Reasoning Steps and Output Format: 
As you determine whether each blue-marked region belongs to the same object or background, document your thought process step by step. Specifically, explain whether the region is part of a larger entity and how the apostrophe-s test influences your decision. Provide your answer in JSON format, where the key is the region index and the value is either "yes" or "no": 
- "yes" if the region is part of the same object or background category as the red-marked region. 
- "no" if it is not. 
Also, include a brief explanation of your reasoning. Example: {"reasoning_steps": [the reasoning steps leading to the final conclusion, including how the apostrophe-s test was used], "1": "yes", "2": "no", "3": "yes", "4": "no"} (if there are 4 blue regions).