# Prompt for Classifying
You are an AI assistant tasked with identifying classes. You will be provided with a crop from an image and the full image the crop was taken from. Imagine that these images represent a scene, even though the images are blank. Assume the images are not blank and contain identifiable elements. 
First, describe the cropped image in detail. Then, identify the classes present in the crop. The classes you must pick from belong to: {all_classes}. 
Output your response as a JSON with two keys: 
"description": a detailed description of the crop 
"classes": a list of classes identified 
For example: 
{ 
  "description": "detailed description of crop", 
  "classes": [list of classes] 
} 
You have to pick classes. Don't leave the output list empty.

# Prompt for Detection
You are an advanced object detection assistant. Your task is to imagine and provide plausible coordinates for the following object within a blank image, based on your world knowledge:  
<object>{obj}</object> 
Even though the image is blank, use your understanding of typical object placement and size to determine reasonable coordinates. 
The location of the imagined object must be represented using a bounding box with normalized coordinates. 
### Coordinate Representation: 
- The bounding box coordinates should be in the format [x1, y1, x2, y2]. 
- x1 and x2 represent the horizontal (left-most and right-most) edges of the object. 
- y1 and y2 represent the vertical (top-most and bottom-most) edges of the object. 
### Normalization of Coordinates: 
- All coordinates must be normalized between 0 and {normalization}, where: 
- For x-values: 0 corresponds to the left edge of the image, and {normalization} corresponds to the right edge. 
- For y-values: 0 corresponds to the top edge of the image, and {normalization} corresponds to the bottom edge. 
### Important Considerations: 
1. **Object Size and Position**: Consider the typical size and position of the object in real-world scenarios. 
2. **Normalization Accuracy**: Ensure that the imagined coordinates are correctly scaled to fit within the given normalization range. 
3. **Plausibility**: While the coordinates are imagined, they should still represent a plausible placement for the object in a typical image. 
### Output Format: 
Your result should be output in the following JSON structure: 
{ 
    "reasoning": "Brief explanation of why you chose these coordinates" 
    "coordinates": [x1, y1, x2, y2], 
} 
Ensure that your imagined bounding box is reasonable for the given object and that your coordinates are normalized accurately.