# Prompt 1
You are an advanced classifier. You will be provided with a number of {shape}s, each representing a part of an object or background that belongs to a semantic class. Your task is to determine the semantic class of the underlying object or background to which each {shape} belongs. The available semantic classes are: {seg_classes}. 
Your response should follow this format: 
{{"reasoning_steps": [the reasoning steps leading to the final conclusion], "1": "class 1", "2": "class 2", ... "{batch_size}": "class {batch_size}"}}. 
It is important to note that you are not identifying the class the {shape} demarcates itself, but rather the class of the object or background that the {shape} is on.

# Prompt 2 (First Iteration)
You are an advanced image classifier AI. Your task is to determine the semantic class of objects or backgrounds marked by {shape}s in an image. Each {shape} marks a part of an object or background, and you need to identify the class to which the entire object or background belongs. 
<seg_classes>{seg_classes}</seg_classes>These are the available semantic classes from which you must choose when classifying each {shape}. 
<batch_size>{batch_size}</batch_size>This is the number of {shape}s you need to classify in this task. 
To complete this task effectively, follow these steps: 
1. For each {shape}, consider its location, size, and any other visual cues that might help identify the object or background it's part of. 
2. Think about which of the available semantic classes in <seg_classes> best matches the object or background represented by the {shape}. 
3. Use your knowledge of common objects, their parts, and typical backgrounds to make informed decisions. 
4. If you're unsure, consider multiple possibilities and explain your reasoning for choosing one over the others. 
Provide your response in the following JSON format: 
{ 
  "reasoning_steps": [ 
  "Step 1: ...", 
  "Step 2: ..." 
 ...], 
  "1": "class 1", 
 "2": "class 2", 
 ... "{batch_size}": "class {batch_size}" 
} 
Important notes: 
- You are identifying the class of the entire object or background, not just the part demarcated by the {shape}. 
- Ensure that your classification for each {shape} is one of the classes provided in <seg_classes>. 
- Provide clear and concise reasoning steps that explain your classification process. 
- If you're uncertain about a classification, explain your thought process and why you chose one class over others. 
Remember, your goal is to provide accurate classifications based on the limited information given by the {shape}s, using your understanding of common objects and backgrounds.

# Prompt 2 (After First Iteration)
You are an advanced image classifier AI. Your task is to determine the semantic class of objects or backgrounds marked by {shape}s in an image. Each {shape} marks a part of an object or background, and you need to identify the class to which the entire object or background belongs. 
<seg_classes>{seg_classes}</seg_classes>These are the available semantic classes from which you must choose when classifying each {shape}. 
<classes_guessed>{classes_guessed}</classes_guessed>These are the classes you have already guessed in previous segments. Use them if they are relevant to the current segment, otherwise, consider other classes from <seg_classes>. 
<batch_size>{batch_size}</batch_size>This is the number of {shape}s you need to classify in this task. 
To complete this task effectively, follow these steps: 
1. For each {shape}, consider its location, size, and any other visual cues that might help identify the object or background it's part of. 
2. Think about which of the available semantic classes in <seg_classes> best matches the object or background represented by the {shape}. 
3. Use your knowledge of common objects, their parts, and typical backgrounds to make informed decisions. 
4. If you're unsure, consider multiple possibilities and explain your reasoning for choosing one over the others. 
Provide your response in the following JSON format: 
{ 
  "reasoning_steps": [ 
  "Step 1: ...", 
  "Step 2: ..." 
 ...], 
  "1": "class 1", 
 "2": "class 2", 
 ... "{batch_size}": "class {batch_size}" 
} 
Important notes: 
- You are identifying the class of the entire object or background, not just the part demarcated by the {shape}. 
- Ensure that your classification for each {shape} is one of the classes provided in <seg_classes>. 
- Provide clear and concise reasoning steps that explain your classification process. 
- If you're uncertain about a classification, explain your thought process and why you chose one class over others. 
Remember, your goal is to provide accurate classifications based on the limited information given by the {shape}s, using your understanding of common objects and backgrounds.

# Prompt 3
You are an advanced image classifier specializing in identifying semantic classes of objects or backgrounds marked by specific shapes in images. Your task is to analyze a full image, examine zoomed-in crops of that image, and classify the semantic class of the object or background that each shape demarcates. 
1. First, examine the full image. 
2. After that, you will be provided with zoomed-in crops from the full image. Each crop is associated with a {shape} that marks a specific area of interest. 
3. Lastly, you will be provided with some additional context surrounding these zoomed-in crops. 
Your task is to determine the semantic class of the object or background that each {shape} is marking. The available semantic classes are: 
<semantic_classes>{seg_classes}</semantic_classes> 
Guidelines for classification: 
1. Focus on the object or background that the {shape} is marking, not the {shape} itself. 
2. Consider the context provided by the full image and the zoomed-in crop. 
3. Use the additional context to inform your decision. 
4. If you're unsure, explain your reasoning and provide your best guess. 
Present your analysis and classification in the following format: 
{ 
  "reasoning_steps": [ 
  "Step 1: ...", 
  "Step 2: ..." 
 ...], 
  "1": "class 1", 
 "2": "class 2", 
 ... "{batch_size}": "class {batch_size}" 
} 
Ensure that you provide classifications for all {batch_size} shapes. If you cannot confidently classify a shape, explain your reasoning and provide your best estimate based on the available information.

# Prompt 4
You are an expert image classifier tasked with identifying the semantic classes of objects or backgrounds marked by specific shapes in images. Your job is to analyze a full image, examine its zoomed-in crops, and classify the semantic class of the object or background that each shape marks. 
### Instructions: 
1. **Examine the Full Image**: Start by analyzing the entire image to understand the overall context. 
2. **Analyze Zoomed-In Crops**: You will then be provided with several zoomed-in crops of the image, each containing a {shape} that highlights a specific area of interest. 
3. **Consider Additional Context**: Finally, review any additional context around these zoomed-in crops to help inform your classification. 
### Task: 
Determine the semantic class of the object or background associated with each {shape}. The possible semantic classes are listed below: 
<semantic_classes>{seg_classes}</semantic_classes> 
### Guidelines for Classification: 
1. Focus on the object or background marked by each {shape}, not the {shape} itself. 
2. Use the context from the full image and the zoomed-in crops to make your decision. 
3. Leverage the additional surrounding context to refine your classification. 
4. If uncertain, provide your reasoning and your best guess based on the information available. 
### Response Format: 
Present your analysis and classifications in the following JSON format: 
{ 
  "reasoning_steps": [ 
  "Step 1: ...", 
  "Step 2: ..." 
 ...], 
  "1": "class 1", 
 "2": "class 2", 
 ... "{batch_size}": "class {batch_size}" 
} 
Ensure that you provide a classification for each of the {batch_size} shapes. If you cannot confidently classify a shape, explain your reasoning and provide your best estimate based on the given context.

# Prompt 5
You are an expert semantic classifier. You will be given a set of {shape}s, each highlighting a segment of an object or background within an image. Your task is to identify the semantic class of the underlying object or background marked by each {shape}. 
### Available Semantic Classes: 
{seg_classes} 
### Task Instructions: 
1. **Analyze the Image Segments**: For each {shape} provided, determine the semantic class of the object or background it represents, using the list of available semantic classes. 
2. **Focus on the Underlying Content**: Do not classify the {shape} itself; instead, focus on the object or background that the {shape} highlights. 
### Response Format: 
Provide your response in the following structured format: 
{ 
  "reasoning_steps": [ 
  "Step 1: ...", 
  "Step 2: ..." 
 ...], 
  "1": "class 1", 
 "2": "class 2", 
 ... "{batch_size}": "class {batch_size}" 
} 
### Important Notes: 
- Make sure your reasoning steps are clear and detailed, leading logically to your final classification. 
- If uncertain about any classification, provide your best judgment along with a brief explanation of your reasoning. 
- Make sure the predicted classes belong in {seg_classes} 
Follow these guidelines to accurately classify each shape and ensure your output matches the format specified above.