#!/bin/bash

# 多GPU并行实验运行脚本
# 使用方法: bash run_parallel_experiments.sh

echo "=== 多GPU并行实验运行脚本 ==="

# 检查可用的GPU数量
GPU_COUNT=$(nvidia-smi --list-gpus | wc -l)
echo "检测到 $GPU_COUNT 个GPU"

# 示例1: 使用所有可用GPU (自动检测)
echo "=== 示例1: 使用所有可用GPU ==="
python finetune_llm_parallel.py \
    --model_name "distilbert-base-cased" \
    --task "mnli" \
    --algorithm "FO-SGD" \
    --epochs 3 \
    --samplesize 1024 \
    --batchsize 128 \
    --batchsize_limit 32 \
    --lr 2e-3 \
    --devices "auto" \
    --strategy "ddp" \
    --num_workers 4 \
    --half_precision \
    --results "results_parallel_auto"

# # 示例2: 指定特定GPU (例如使用GPU 0和1)
# echo "=== 示例2: 使用指定GPU (0,1) ==="
# python finetune_llm_parallel.py \
#     --model_name "distilbert-base-cased" \
#     --task "mnli" \
#     --algorithm "FO-AdamW" \
#     --epochs 3 \
#     --samplesize 1024 \
#     --batchsize 64 \
#     --batchsize_limit 32 \
#     --lr 2e-3 \
#     --devices "0,1" \
#     --strategy "ddp" \
#     --num_workers 2 \
#     --results "results_parallel_2gpu"

# # 示例3: 使用4个GPU进行大规模实验
# echo "=== 示例3: 使用4个GPU ==="
# python finetune_llm_parallel.py \
#     --model_name "distilbert-base-cased" \
#     --task "mnli" \
#     --algorithm "FO-AdamW" \
#     --epochs 5 \
#     --samplesize 2048 \
#     --batchsize 256 \
#     --batchsize_limit 64 \
#     --lr 1e-3 \
#     --devices "0,1,2,3" \
#     --strategy "ddp" \
#     --num_workers 4 \
#     --half_precision \
#     --gradient_clip_val 1.0 \
#     --accumulate_grad_batches 2 \
#     --results "results_parallel_4gpu"

# # 示例4: 使用DeepSpeed策略 (需要安装deepspeed)
# echo "=== 示例4: 使用DeepSpeed策略 ==="
# python finetune_llm_parallel.py \
#     --model_name "distilbert-base-cased" \
#     --task "mnli" \
#     --algorithm "FO-AdamW" \
#     --epochs 3 \
#     --samplesize 1024 \
#     --batchsize 128 \
#     --batchsize_limit 32 \
#     --lr 2e-3 \
#     --devices "0,1,2,3" \
#     --strategy "deepspeed" \
#     --num_workers 4 \
#     --half_precision \
#     --results "results_deepspeed_parallel"

# # 示例5: 不同算法的对比实验
# echo "=== 示例5: 不同算法对比 ==="

# # FO-SGD
# python finetune_llm_parallel.py \
#     --model_name "distilbert-base-cased" \
#     --task "mnli" \
#     --algorithm "FO-SGD" \
#     --epochs 3 \
#     --samplesize 1024 \
#     --batchsize 128 \
#     --batchsize_limit 32 \
#     --lr 1e-2 \
#     --devices "0,1" \
#     --strategy "ddp" \
#     --results "results_parallel_FO_SGD"

# # FO-Adam
# python finetune_llm_parallel.py \
#     --model_name "distilbert-base-cased" \
#     --task "mnli" \
#     --algorithm "FO-Adam" \
#     --epochs 3 \
#     --samplesize 1024 \
#     --batchsize 128 \
#     --batchsize_limit 32 \
#     --lr 2e-3 \
#     --devices "0,1" \
#     --strategy "ddp" \
#     --results "results_parallel_FO_Adam"

# # FO-Adagrad
# python finetune_llm_parallel.py \
#     --model_name "distilbert-base-cased" \
#     --task "mnli" \
#     --algorithm "FO-Adagrad" \
#     --epochs 3 \
#     --samplesize 1024 \
#     --batchsize 128 \
#     --batchsize_limit 32 \
#     --lr 1e-2 \
#     --devices "0,1" \
#     --strategy "ddp" \
#     --results "results_parallel_FO_Adagrad"

echo "=== 所有并行实验完成 ===" 