import marimo

__generated_with = "0.12.10"
app = marimo.App(width="medium")


@app.cell
def _():
    import marimo as mo
    import polars as pl
    return mo, pl


@app.cell
def _():
    from dataclasses import asdict
    return (asdict,)


@app.cell
def _():
    from configs.generate_data import sweep
    return (sweep,)


@app.cell
def _(sweep, mo):
    task_dropdown = mo.ui.dropdown(options=sweep.tasks, value=sweep.tasks[0])

    task_dropdown
    return (task_dropdown,)


@app.cell
def _(sweep):
    experiments = {e.task_name: e for e in sweep.experiments}
    return (experiments,)


@app.cell
def _(experiments, task_dropdown):
    e = experiments[task_dropdown.value]
    return (e,)


@app.cell
def _(asdict, e, pl):
    pl.DataFrame([asdict(d) for d in e.step_result("dataset")])
    return


@app.cell
def _(e, pl):
    pl.DataFrame([icq.get_prompt() for icq in e.step_result("in_context_queries")])
    return


if __name__ == "__main__":
    app.run()
