/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019928ULL, 0x00000000000195a8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x346a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4532336a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL,
0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL,
0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x000000676e696469ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x6e695f5f24000000ULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL,
0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x722e006874617077ULL,
0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL, 0x616c65722e006168ULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL,
0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x0000000000000061ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0001000000beULL, 0x0000000000000028ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0001000001c6ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b00010000020cULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000299ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000002e7ULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000335ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a002200000390ULL, 0x0000000000018250ULL, 0x0000000000000230ULL,
0x0004000300000406ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000018480ULL, 0x000d000300000436ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001825000000000ULL, 0x0001140400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000001cffffffffULL, 0x0000006000000000ULL,
0x0001825000000000ULL, 0x0000023000000000ULL, 0x0000000000000000ULL, 0x0000001300082f04ULL,
0x00082304000000d8ULL, 0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL,
0x0000000000000011ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0050000900000000ULL,
0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040021f000ULL, 0x0040000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040061f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0xffffffff010c2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000001d0010c2804ULL, 0x0000076000000270ULL, 0x00002d7000001e50ULL,
0x00002ee000002df0ULL, 0x0000314000003010ULL, 0x0000365000003280ULL, 0x0000367000003660ULL,
0x00003d3000003680ULL, 0x00004bd000004b60ULL, 0x00004e1000004ce0ULL, 0x0000508000004f40ULL,
0x00005300000052f0ULL, 0x0000532000005310ULL, 0x0000673000005920ULL, 0x000068b0000067a0ULL,
0x00006b10000069e0ULL, 0x00006f3000006c50ULL, 0x00006f5000006f40ULL, 0x000074b000006f60ULL,
0x000083a000008320ULL, 0x000085c000008490ULL, 0x00008830000086f0ULL, 0x00008b2000008b10ULL,
0x00008b4000008b30ULL, 0x0000944000009430ULL, 0x0000946000009450ULL, 0x0000c2500000c0b0ULL,
0x0000c2d00000c290ULL, 0x0000cc300000cc00ULL, 0x0000cc900000cc60ULL, 0x00016aa0000169f0ULL,
0x00016e9000016d80ULL, 0x0001737000017280ULL, 0x0001769000017620ULL, 0x000004a001f03904ULL,
0x0001e600000000ffULL, 0x0000058000040100ULL, 0x0001e60800000003ULL, 0x00000690003f0100ULL,
0x0001e68800000002ULL, 0x00000de0003f0100ULL, 0x0001e60000000073ULL, 0x00000f10003f0107ULL,
0x0001e68800000000ULL, 0x00002ae0003f0101ULL, 0x0001e60800000006ULL, 0x00002b20003f0101ULL,
0x0001e60800000035ULL, 0x00002c90003f0109ULL, 0x0001e60800000035ULL, 0x00003cd0003f0109ULL,
0x0001e68800000039ULL, 0x00004930003f0101ULL, 0x0001e62800000039ULL, 0x00004960003f0101ULL,
0x0001e6280000004dULL, 0x00004ad0003f0109ULL, 0x0001e6280000004dULL, 0x000058c0003f0109ULL,
0x0001e69000000039ULL, 0x00006510003f0101ULL, 0x0001e6480000003bULL, 0x00006530003f0101ULL,
0x0001e6480000003bULL, 0x000066a0003f0109ULL, 0x0001e6480000003bULL, 0x000073a0003f0109ULL,
0x0001e69800000003ULL, 0x00008100003f0101ULL, 0x0001e66800000039ULL, 0x00008120003f0101ULL,
0x0001e66800000039ULL, 0x00008290003f0109ULL, 0x0001e66800000039ULL, 0x00008f00003f0109ULL,
0x0001e6a000000002ULL, 0x0000e440003f0101ULL, 0x0001e60000000073ULL, 0x0000fc70003f0101ULL,
0x0001e60000000073ULL, 0x0000fde0003f0109ULL, 0x0001e60000000073ULL, 0x00014530003f0109ULL,
0x0001e68800000097ULL, 0x00014690003f0101ULL, 0x0001e68800000097ULL, 0x00014800003f0109ULL,
0x0001e68800000097ULL, 0x000181f0003f0109ULL, 0x0001e60800000095ULL, 0x00018200003f0101ULL,
0x0001e61000000095ULL, 0x00018210003f0101ULL, 0x0001e61800000095ULL, 0x00018220003f0101ULL,
0x0001e62000000095ULL, 0x00033803003f0101ULL, 0x0000d83000301c04ULL, 0x0000da400000d890ULL,
0x0000dd000000dba0ULL, 0x0000dfc00000de60ULL, 0x0000e2b00000e120ULL, 0x0000fe100000e3b0ULL,
0x000c050400018240ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0058190300000000ULL,
0x0000001400080a04ULL, 0x0000000000580210ULL, 0x00000000000000bcULL, 0x0000001300000002ULL,
0x0000000000018250ULL, 0x0000000000000044ULL, 0x0000001300000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001300000002ULL, 0x0000000000000000ULL, 0x000000000001e700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff067b82ULL, 0x000ea20000000a00ULL,
0x00000000000b7919ULL, 0x000ee20000002300ULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x0000000000087919ULL, 0x000eea0000002200ULL, 0x00000300ff7a7b82ULL, 0x000f220000000800ULL,
0x0000040000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000137919ULL, 0x000f2c0000002700ULL,
0x00000000000579c3ULL, 0x000f620000002600ULL, 0x0000000700007306ULL, 0x004ea20000209000ULL,
0x000000ff0700720cULL, 0x000fcc0003f45070ULL, 0x00008600ff157b82ULL, 0x000f220000000800ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00027836ULL, 0x004fcc0000000000ULL,
0x0000000200037305ULL, 0x0004e4000021f000ULL, 0x000000ffff027224ULL, 0x004fe400078e00ffULL,
0x000000ffff047224ULL, 0x00afc800078e0a03ULL, 0x0000000704057224ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fe400078e0002ULL, 0x0000000000057919ULL, 0x000e680000002100ULL,
0x0000000403797c27ULL, 0x000fc8000f8e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a79ULL,
0x0000000407007e24ULL, 0x000fe2000f8e0200ULL, 0x0000010000047ab9ULL, 0x000fc80000000800ULL,
0x000000070000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe400078e0a07ULL,
0x0000000179790836ULL, 0x000fe20000000000ULL, 0x00000005ff787819ULL, 0x002fe40000011605ULL,
0x000000070000720cULL, 0x000fc80003f26070ULL, 0x00001fff78787589ULL, 0x000f3200000e0000ULL,
0x0000000179791810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff79a212ULL, 0x000fc800078e33ffULL,
0x0000007900007306ULL, 0x000e620000209000ULL, 0x000000ff7900720cULL, 0x000fce0003f65070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027836ULL, 0x002fe40000000000ULL,
0x000000040b007c24ULL, 0x000fe2000f8e0208ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000200037305ULL, 0x0002a2000021f000ULL, 0x00001fff0b0b7589ULL, 0x000f2200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000379047224ULL, 0x004fc800078e02ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a04ULL, 0x0000000903037227ULL, 0x000fc800078e0002ULL,
0x0000000400027c24ULL, 0x000fe2000f8e0205ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00000005036c7c27ULL, 0x020fc6000f8e00ffULL, 0x0000007f0200780cULL, 0x000fe20003f44070ULL,
0x000000ffff047224ULL, 0x000fc800078e0a6cULL, 0x0000000579007e24ULL, 0x000fca000f8e0204ULL,
0x000000790000720cULL, 0x000fc60003f06070ULL, 0x000000000004a919ULL, 0x000ea20000008800ULL,
0x000004000003a802ULL, 0x000fe20000000f00ULL, 0xff317217ff05a424ULL, 0x000fe400078e00ffULL,
0x00000004ff777e24ULL, 0x002fcc000f8e00ffULL, 0x0000000100000824ULL, 0x000fe400078e0a79ULL,
0x000000016c6c0836ULL, 0x000fe20000000000ULL, 0x000000ff0200720cULL, 0x000fe40003f05270ULL,
0x000000790000720cULL, 0x000fda0003f26070ULL, 0x000000016c6c1810ULL, 0x000fe40007ffe0ffULL,
0x00000079ff6cb212ULL, 0x000fe400078e33ffULL, 0x000006540403a816ULL, 0x004fe40000000003ULL,
0x0000000f0200780cULL, 0x040fe20003f24070ULL, 0x000000ffff007224ULL, 0x000fe200078e0a6cULL,
0x000000030200780cULL, 0x040fe20003f64070ULL, 0x000000040204a824ULL, 0x000fe400078e0203ULL,
0x0000000579797e24ULL, 0x000fc8000f8e0200ULL, 0x0000002079007824ULL, 0x000fe200078e00ffULL,
0x0000000000240947ULL, 0x010fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01e60006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402037c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000030612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01e60804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402027c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000020612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01e68804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff767224ULL, 0x000fe200078e0a00ULL,
0x0000001506037219ULL, 0x080fe200000006ffULL, 0x01e400050400a388ULL, 0x0003e20000000800ULL,
0x0000001507757219ULL, 0x000fe200000006ffULL, 0x0000000613067224ULL, 0x000fe200078e02ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000002003767446ULL, 0x000fc40003800076ULL,
0x000000780b027211ULL, 0x000fe400078e10ffULL, 0x000000ff76767207ULL, 0x000fe40000000000ULL,
0x000000156c747219ULL, 0x000fe200000006ffULL, 0x0000000402037824ULL, 0x000fe200078e00ffULL,
0x000000207600780cULL, 0x000fc60003f05270ULL, 0x0000007506067224ULL, 0x000fd400078e0274ULL,
0x0000000000c48947ULL, 0x002fea0003800000ULL, 0x0000000000727919ULL, 0x000e620000000000ULL,
0xffffffffff087424ULL, 0x000fe200078e00ffULL, 0x0000000376027248ULL, 0x000fe20007fe0000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000c7919ULL, 0x000ea20000008800ULL,
0x0000040000737802ULL, 0x000fe40000000f00ULL, 0x0000001508057219ULL, 0x000fe200000006ffULL,
0x0000000102027824ULL, 0x000fe200078e0a03ULL, 0x00000004ff047819ULL, 0x002fc80000011672ULL,
0x000000020400720cULL, 0x080fe20003f06070ULL, 0x0000000204097836ULL, 0x000fe20000000000ULL,
0x000006540c737816ULL, 0x004fe20000000073ULL, 0x00000001030f7824ULL, 0x040fe400078e0204ULL,
0x0000000103117824ULL, 0x000fe200078e0209ULL, 0x000000020900720cULL, 0x000fe20003f26070ULL,
0x0000000100087824ULL, 0x000fe400078e020fULL, 0x000000010f027824ULL, 0x040fe200078e0272ULL,
0x00000011000a7210ULL, 0x000fe20007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000508037212ULL, 0x000fc400078e30ffULL, 0x000000050a057212ULL, 0x000fe400078e30ffULL,
0x00000015ff087219ULL, 0x080fe20000011608ULL, 0x0000000106037824ULL, 0x040fe200078e0203ULL,
0x00000015ff0a7219ULL, 0x000fe2000001160aULL, 0x0000000106057824ULL, 0x000fe200078e0205ULL,
0x0000007211067210ULL, 0x000fe20007ffe0ffULL, 0x0000007508047224ULL, 0x080fe200078e0203ULL,
0xfffffff00f027812ULL, 0x000fe200078ee202ULL, 0x0000001072037824ULL, 0x000fe400078e00ffULL,
0x000000750a087224ULL, 0x000fc400078e0205ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000f0030d7812ULL, 0x000fc600078ec0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000d04047212ULL, 0x000fc600078efcffULL, 0x0000001011117824ULL, 0x000fe200078e00ffULL,
0x0000000d08087212ULL, 0x000fe200078efcffULL, 0x00000010020d7824ULL, 0x100fe200078e0273ULL,
0x0000000404047c10ULL, 0x000fe4000ff5e0ffULL, 0xfffffff011067812ULL, 0x000fe400078ee206ULL,
0x0000000408087c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000505057c10ULL, 0x000fe200097fe4ffULL,
0x00000010060f7824ULL, 0x000fe200078e0273ULL, 0x0000000509097c10ULL, 0x000fc60009ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000c101c46ULL,
0x00000000080f7faeULL, 0x0003e2000c901c46ULL, 0x0000000000a87947ULL, 0x000fea0003800000ULL,
0x0000000000727919ULL, 0x000e620000000000ULL, 0xffffffffff027424ULL, 0x000fe200078e00ffULL,
0x0000040000737802ULL, 0x000fe20000000f00ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000087919ULL, 0x000ea40000008800ULL, 0x0000001502057219ULL, 0x000fe400000006ffULL,
0x00000003720d7211ULL, 0x002fe400078fe0ffULL, 0x0000065408737816ULL, 0x004fc60000000073ULL,
0x000000020d0f7836ULL, 0x000fe40000000000ULL, 0x0000000100027824ULL, 0x000fc600078e020dULL,
0x0000000f00047210ULL, 0x000fe40007ffe0ffULL, 0x0000000502037212ULL, 0x080fe400078e30ffULL,
0x0000000504057212ULL, 0x000fe400078e30ffULL, 0x00000015ff027219ULL, 0x080fe20000011602ULL,
0x0000000106037824ULL, 0x040fe200078e0203ULL, 0x00000015ff047219ULL, 0x000fe20000011604ULL,
0x0000000106057824ULL, 0x000fe400078e0205ULL, 0x0000007502027224ULL, 0x000fc400078e0203ULL,
0x0000001072037824ULL, 0x000fe400078e00ffULL, 0x0000007504087224ULL, 0x000fe400078e0205ULL,
0x0000010002047825ULL, 0x000fe200078e00ffULL, 0x000000f003117812ULL, 0x000fc600078ec0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000001104047212ULL, 0x000fc600078efcffULL,
0x000000010d027824ULL, 0x140fe200078e0272ULL, 0x0000001108087212ULL, 0x000fe200078efcffULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL,
0x000000010f067824ULL, 0x040fe200078e0272ULL, 0x000000040f0f7819ULL, 0x000fe400000006ffULL,
0xfffffff00d027812ULL, 0x000fe400078ee202ULL, 0xfffffff00f067812ULL, 0x000fe400078ee206ULL,
0x0000000408087c10ULL, 0x000fe2000ff3e0ffULL, 0x00000010020d7824ULL, 0x100fe200078e0273ULL,
0x0000000505057c10ULL, 0x000fe200087fe4ffULL, 0x00000010060f7824ULL, 0x000fe200078e0273ULL,
0x0000000509097c10ULL, 0x000fc60008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e8000b901c46ULL, 0x00000000080f7faeULL, 0x0003e4000b901c46ULL,
0x00000000730472caULL, 0x000fe200000e0000ULL, 0x00009000ff047b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001e60004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000413047825ULL, 0x002fe200078e0004ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000604717981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0b00720cULL, 0x000fe20003f05270ULL,
0x000000ff71707836ULL, 0x004fca0000000000ULL, 0x00000008ff707819ULL, 0x000fce0000011670ULL,
0x000000d4004c8947ULL, 0x000fea0003800000ULL, 0x00000008786f7824ULL, 0x000fe200078e00ffULL,
0x0000000113027819ULL, 0x000fe200000006ffULL, 0x00000004ff057424ULL, 0x000fe200078e00ffULL,
0x00000001ff6e7819ULL, 0x000fe20000011678ULL, 0x0000000173007824ULL, 0x000fe200078e026fULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x0000000702077224ULL, 0x000fe200078e0207ULL,
0x00000001786b7812ULL, 0x000fe200078ec0ffULL, 0x01e6880500ff79a7ULL, 0x0003e2000850003fULL,
0x000000206e6d7824ULL, 0x000fe400078e00ffULL, 0x000000016c6c7824ULL, 0x000fc400078e0207ULL,
0x0000010077097824ULL, 0x000fc800078e026dULL, 0x000000046c1e7c24ULL, 0x000fe4000f8e0209ULL,
0x0000000177057836ULL, 0x002fca0000000000ULL, 0x000000700500720cULL, 0x000fda0003f06070ULL,
0x0000000400988947ULL, 0x000fea0003800000ULL, 0x0000007003027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x00000003ff0d7819ULL, 0x000fe20000011672ULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000971007248ULL, 0x000fe20007fe0000ULL,
0x000000806b027824ULL, 0x000fe200078e0202ULL, 0x000000040d077810ULL, 0x000fe20007ffe0ffULL,
0x000000011e057824ULL, 0x000fe200078e020dULL, 0x0000000c0d157810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe400078e0a09ULL, 0x0000010005047825ULL, 0x000fc600078e0002ULL,
0x0000002000007446ULL, 0x000fe20003800009ULL, 0x0000000107067824ULL, 0x140fe200078e0272ULL,
0x00000004040a7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000807117824ULL, 0x040fe200078e00ffULL,
0x000000000700720cULL, 0x080fe20003f26070ULL, 0x000040006e047824ULL, 0x000fe200078e0273ULL,
0x00000005050b7c10ULL, 0x000fe200087fe4ffULL, 0x000000011e057824ULL, 0x000fe200078e0207ULL,
0xfffffff811117812ULL, 0x000fe200078ee206ULL, 0x000000010d067824ULL, 0x040fe200078e0272ULL,
0x000000000d00720cULL, 0x080fe20003f06070ULL, 0x000020006b0c7824ULL, 0x000fe200078e0204ULL,
0x000000001500720cULL, 0x000fe20003f86070ULL, 0x0000010005047825ULL, 0x000fe200078e0002ULL,
0x00000007060f7812ULL, 0x000fc600078ec0ffULL, 0x000160000c0e7836ULL, 0x000fe20000000000ULL,
0x0ffffff80f0f7812ULL, 0x000fe200078ef872ULL, 0x000000100d177836ULL, 0x000fe20000000000ULL,
0x0000000404047c10ULL, 0x000fe2000ff5e0ffULL, 0x000000080d137836ULL, 0x000fe20000000000ULL,
0x0000000e0f0f7211ULL, 0x000fe200078e20ffULL, 0x0000001011117824ULL, 0x000fe200078e020eULL,
0x0000000505057c10ULL, 0x000fe200097fe4ffULL, 0x000000140d197836ULL, 0x000fe20000000000ULL,
0x000000001300720cULL, 0x080fe20003fa6070ULL, 0x000000180d1b7836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000c101c46ULL,
0x0000001c0d1d7836ULL, 0x000fe20000000000ULL, 0x000000171e0d7210ULL, 0x000fe20007ffe0ffULL,
0x000000011e077824ULL, 0x040fe200078e0213ULL, 0x0000000004117faeULL, 0x0005e2000c901c46ULL,
0x000000011e097824ULL, 0x000fe200078e0215ULL, 0x000000001b00720cULL, 0x080fe20003f26070ULL,
0x0000000815107824ULL, 0x000fe200078e00ffULL, 0x000000001d00720cULL, 0x000fe20003f06070ULL,
0x0000010007067825ULL, 0x000fc800078e0002ULL, 0x00000001150b7824ULL, 0x002fe200078e0272ULL,
0x0000000406067c10ULL, 0x000fe2000ff7e0ffULL, 0x0000010009087825ULL, 0x000fc600078e0002ULL,
0xfffffff810117812ULL, 0x004fe200078ee20bULL, 0x000001000d047825ULL, 0x000fe200078e0002ULL,
0x0000000408087c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000507077c10ULL, 0x000fe20009ffe4ffULL,
0x000000011e0d7824ULL, 0x000fe200078e0219ULL, 0x00000004040a7c10ULL, 0x000fe2000ffde0ffULL,
0x00000001130c7824ULL, 0x040fe200078e0272ULL, 0x0000000509097c10ULL, 0x000fe200097fe4ffULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0x00000005050b7c10ULL, 0x000fe2000b7fe4ffULL,
0x000001000d047825ULL, 0x000fe200078e0002ULL, 0x000000001700720cULL, 0x000fc40003f66070ULL,
0x000000001900720cULL, 0x040fe20003f46070ULL, 0x0000000819107824ULL, 0x000fe200078e00ffULL,
0xfffffff8130f7812ULL, 0x000fe200078ee20cULL, 0x0000000117007824ULL, 0x040fe200078e0272ULL,
0x00000072190d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000817137824ULL, 0x000fe200078e00ffULL,
0x00000004040c7c10ULL, 0x000fe2000ffde0ffULL, 0x000000011e177824ULL, 0x040fe200078e021bULL,
0xfffffff810157812ULL, 0x000fe200078ee20dULL, 0x000000011e197824ULL, 0x000fe200078e021dULL,
0x00000005050d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010017047825ULL, 0x000fe200078e0002ULL,
0xfffffff813137812ULL, 0x000fc600078ee200ULL, 0x000000011b007824ULL, 0x140fe200078e0272ULL,
0x0000000404047c10ULL, 0x000fe2000ffde0ffULL, 0x000000081b177824ULL, 0x000fe400078e00ffULL,
0x000000011d107824ULL, 0x040fe200078e0272ULL, 0x000000031d1d7819ULL, 0x000fe200000006ffULL,
0x0000010019027825ULL, 0x000fe200078e0002ULL, 0xfffffff817177812ULL, 0x000fe400078ee200ULL,
0xfffffff81d197812ULL, 0x000fe200078ee210ULL, 0x000000100f0f7824ULL, 0x100fe200078e020eULL,
0x0000000505057c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001011117824ULL, 0x100fe200078e020eULL,
0x0000000402027c10ULL, 0x000fe2000ffde0ffULL, 0x0000001013137824ULL, 0x100fe200078e020eULL,
0x00000000060f7faeULL, 0x0003e2000e901c46ULL, 0x0000001015157824ULL, 0x100fe200078e020eULL,
0x0000000503037c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001017177824ULL, 0x100fe200078e020eULL,
0x0000000008117faeULL, 0x0003e2000e101c46ULL, 0x0000001019197824ULL, 0x000fc600078e020eULL,
0x000000000a137faeULL, 0x0003e8000d901c46ULL, 0x000000000c157faeULL, 0x0003e8000d101c46ULL,
0x0000000004177faeULL, 0x0003e8000c901c46ULL, 0x0000000002197faeULL, 0x0003e2000c101c46ULL,
0x0000000400647947ULL, 0x000fea0003800000ULL, 0x0000000872097811ULL, 0x040fe200078fe8ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000472077811ULL, 0x040fe400078fe8ffULL,
0x0000000c720b7811ULL, 0x040fe200078fe8ffULL, 0x0000000109027824ULL, 0x140fe200078e0272ULL,
0x0000007207007210ULL, 0x000fe20007ffe0ffULL, 0x00000008090d7824ULL, 0x000fe200078e00ffULL,
0x0000001872117811ULL, 0x040fe200078fe8ffULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0x00000014720f7811ULL, 0x040fe200078fe8ffULL, 0x000000080b137824ULL, 0x000fe200078e00ffULL,
0xfffffff80d147812ULL, 0x000fe200078ee202ULL, 0x00000008111c7824ULL, 0x000fe200078e00ffULL,
0x00000010720d7811ULL, 0x000fe200078fe8ffULL, 0x000000010f047824ULL, 0x100fe200078e0272ULL,
0xfffffff805127812ULL, 0x000fe200078ee200ULL, 0x000000010b007824ULL, 0x100fe200078e0272ULL,
0x000000030d157819ULL, 0x040fe200000006ffULL, 0x000000010d027824ULL, 0x100fe200078e0272ULL,
0x0000007003107812ULL, 0x000fe200078ec0ffULL, 0x0000000111057824ULL, 0x000fe200078e0272ULL,
0xfffffff813167812ULL, 0x000fe200078ee200ULL, 0x000000080f177824ULL, 0x000fe200078e00ffULL,
0xfffffff815187812ULL, 0x000fe200078ee202ULL, 0x000040006e027824ULL, 0x000fe200078e0273ULL,
0x0000007272007211ULL, 0x000fe200078fe8ffULL, 0x000000011e137824ULL, 0x000fe200078e0211ULL,
0x0000001c72037811ULL, 0x000fe200078fe8ffULL, 0x000000806b107824ULL, 0x000fe200078e0210ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0xfffffff8171a7812ULL, 0x000fe200078ee204ULL, 0x000000011e157824ULL, 0x000fe200078e0203ULL,
0x0000000700057812ULL, 0x000fe200078ec0ffULL, 0x0000000103007824ULL, 0x000fe200078e0272ULL,
0x000000026b027211ULL, 0x000fe200078e68ffULL, 0x000000011e077824ULL, 0x040fe200078e0207ULL,
0x0000000303177819ULL, 0x000fe200000006ffULL, 0x000000011e097824ULL, 0x000fe200078e0209ULL,
0x0000001e72037211ULL, 0x000fe200078fe8ffULL, 0x000000011e0b7824ULL, 0x000fc400078e020bULL,
0x000000011e0d7824ULL, 0x040fe400078e020dULL, 0x000000011e0f7824ULL, 0x000fe200078e020fULL,
0xfffffff8171e7812ULL, 0x000fe200078ee200ULL, 0x0001600002217836ULL, 0x000fe20000000000ULL,
0x0ffffff805007812ULL, 0x000fe200078ef872ULL, 0x0000010003027825ULL, 0x000fc600078e0010ULL,
0x0000002114177211ULL, 0x000fe200078e20ffULL, 0x0000010007047825ULL, 0x000fe200078e0010ULL,
0x0000000402027c10ULL, 0x000fc6000ff1e0ffULL, 0x0000010009067825ULL, 0x100fe200078e0010ULL,
0x0000000404047c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000503037c10ULL, 0x000fe200087fe4ffULL,
0x000001000b087825ULL, 0x100fe200078e0010ULL, 0x0000000406067c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000505057c10ULL, 0x000fe20008ffe4ffULL, 0x000001000d0a7825ULL, 0x100fe200078e0010ULL,
0x0000000408087c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000507077c10ULL, 0x000fe200097fe4ffULL,
0x000001000f0c7825ULL, 0x000fe200078e0010ULL, 0x000000040a0a7c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000509097c10ULL, 0x000fe20009ffe4ffULL, 0x00000100130e7825ULL, 0x100fe200078e0010ULL,
0x000000040c0c7c10ULL, 0x000fe4000ff3e0ffULL, 0x000000050b0b7c10ULL, 0x000fe200087fe4ffULL,
0x0000010015107825ULL, 0x000fe200078e0010ULL, 0x000000040e0e7c10ULL, 0x000fe4000ff5e0ffULL,
0x000000050d0d7c10ULL, 0x000fe20008ffe4ffULL, 0x0000001000137824ULL, 0x100fe200078e0221ULL,
0x0000000410107c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001012157824ULL, 0x100fe200078e0221ULL,
0x000000050f0f7c10ULL, 0x000fe200097fe4ffULL, 0x0000001016197824ULL, 0x100fe200078e0221ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002137faeULL, 0x0003e2000b901c46ULL,
0x00000010181b7824ULL, 0x100fe200078e0221ULL, 0x0000000511117c10ULL, 0x000fe20009ffe4ffULL,
0x000000101a1d7824ULL, 0x100fe200078e0221ULL, 0x0000000004157faeULL, 0x0003e2000b901c46ULL,
0x000000101c1f7824ULL, 0x000fc400078e0221ULL, 0x000000101e217824ULL, 0x000fe200078e0221ULL,
0x0000000006177faeULL, 0x0003e8000b901c46ULL, 0x0000000008197faeULL, 0x0003e8000b901c46ULL,
0x000000000a1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000c1d7faeULL, 0x0003e8000b901c46ULL,
0x000000000e1f7faeULL, 0x0003e8000b901c46ULL, 0x0000000010217faeULL, 0x0003e4000b901c46ULL,
0x000000707700720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff007424ULL, 0x000fe200078e00ffULL, 0x000000ff00837202ULL, 0x000fe40000000f00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fc4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x002fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fc4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fc4000001ff00ULL,
0x00000000008a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000887805ULL, 0x000fe4000001ff00ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000007000980947ULL, 0x000fec0003800000ULL, 0xff317217ff007424ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fce00078e00ffULL, 0x0000000177037836ULL, 0x000fe20000000000ULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x0000010077827824ULL, 0x000fc600078e026dULL,
0x000000700300720cULL, 0x000fe20003f06070ULL, 0x0000004082057836ULL, 0x000fc80000000000ULL,
0x000000046c4d7c24ULL, 0x000fe2000f8e0205ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x00000004009c8947ULL, 0x000fea0003800000ULL, 0x0000001072027824ULL, 0x000fe200078e00ffULL,
0x00000003ff377819ULL, 0x000fe20000011672ULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x000040006e067824ULL, 0x000fe200078e0273ULL,
0x00000070023a7812ULL, 0x000fe200078ec0ffULL, 0x0000000137037824ULL, 0x000fe200078e024dULL,
0x0000000571027248ULL, 0x000fe20007fe0000ULL, 0x0000000437397836ULL, 0x000fe20000000000ULL,
0x000000ff05057210ULL, 0x000fe20007ffe1ffULL, 0x000000806b3a7824ULL, 0x040fe200078e023aULL,
0x0000000c37517810ULL, 0x000fe20007ffe0ffULL, 0x000020006b067824ULL, 0x000fe200078e0206ULL,
0x0000002002347446ULL, 0x000fe20003800005ULL, 0x0000010003027825ULL, 0x000fe200078e003aULL,
0x0000004d39077210ULL, 0x000fc40007ffe0ffULL, 0x000000343700720cULL, 0x0c0fe20003f26070ULL,
0x0000000137057824ULL, 0x000fe200078e0272ULL, 0x0000000402047c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000839367824ULL, 0x000fe200078e00ffULL, 0x000000345100720cULL, 0x080fe20003fa6070ULL,
0x00017000064c7836ULL, 0x000fe20000000000ULL, 0x0000000705357812ULL, 0x000fe200078ec0ffULL,
0x0000001037537836ULL, 0x000fe20000000000ULL, 0x0000000503057c10ULL, 0x000fe200087fe4ffULL,
0x0000010007027825ULL, 0x000fe200078e003aULL, 0x000000343900720cULL, 0x000fc40003f06070ULL,
0x0ffffff835357812ULL, 0x000fe200078ef872ULL, 0x0000000139077824ULL, 0x000fe200078e0272ULL,
0x0000000402067c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001437557836ULL, 0x000fe20000000000ULL,
0x000000345300720cULL, 0x000fe20003f86070ULL, 0x0000001035357824ULL, 0x000fe200078e024cULL,
0xfffffff836397812ULL, 0x000fe200078ee207ULL, 0x0000001837577836ULL, 0x000fe20000000000ULL,
0x0000000503077c10ULL, 0x000fe200097fe4ffULL, 0x0000000837037836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004357faeULL, 0x0003e2000c901c46ULL,
0x0000001c37597836ULL, 0x000fe20000000000ULL, 0x0000004c39377211ULL, 0x000fe200078e20ffULL,
0x0000000103027824ULL, 0x040fe200078e0272ULL, 0x000000340300720cULL, 0x0c0fe20003fc6070ULL,
0x00000008034f7824ULL, 0x000fe200078e00ffULL, 0x000000345500720cULL, 0x080fe20003f66070ULL,
0x0000000103037824ULL, 0x000fe200078e024dULL, 0x000000345700720cULL, 0x080fe20003f46070ULL,
0x0000000851387824ULL, 0x000fe200078e00ffULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee202ULL,
0x0000010003027825ULL, 0x000fe200078e003aULL, 0x000000345900720cULL, 0x000fe20003f26070ULL,
0x0000000006377faeULL, 0x0005e4000c101c46ULL, 0x0000000151057824ULL, 0x042fe200078e024dULL,
0x0000000402347c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000151357824ULL, 0x000fc400078e0272ULL,
0x0000010005047825ULL, 0x000fc600078e003aULL, 0xfffffff838517812ULL, 0x000fe200078ee235ULL,
0x0000000153397824ULL, 0x040fe200078e024dULL, 0x0000000503357c10ULL, 0x000fe200087fe4ffULL,
0x0000000153367824ULL, 0x000fe200078e0272ULL, 0x0000000404067c10ULL, 0x004fe2000ff1e0ffULL,
0x0000010039027825ULL, 0x000fe200078e003aULL, 0x0000000353537819ULL, 0x000fe400000006ffULL,
0x0000000505077c10ULL, 0x000fe200087fe4ffULL, 0x0000000155047824ULL, 0x040fe200078e0272ULL,
0xfffffff853537812ULL, 0x000fe200078ee236ULL, 0x0000000855397824ULL, 0x040fe200078e00ffULL,
0x0000000402367c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000155377824ULL, 0x000fc400078e024dULL,
0x00000001574e7824ULL, 0x000fe200078e0272ULL, 0xfffffff839557812ULL, 0x000fe200078ee204ULL,
0x0000010037047825ULL, 0x000fe200078e003aULL, 0x0000000503377c10ULL, 0x000fc600087fe4ffULL,
0x0000000157397824ULL, 0x100fe200078e024dULL, 0x0000000404387c10ULL, 0x000fe2000ff1e0ffULL,
0x00000001594d7824ULL, 0x000fe200078e024dULL, 0x0000000357577819ULL, 0x000fe200000006ffULL,
0x0000000159047824ULL, 0x040fe400078e0272ULL, 0x0000000859597824ULL, 0x000fe200078e00ffULL,
0xfffffff857577812ULL, 0x000fe200078ee24eULL, 0x0000010039027825ULL, 0x100fe200078e003aULL,
0x0000000505397c10ULL, 0x000fe400087fe4ffULL, 0xfffffff859597812ULL, 0x000fe200078ee204ULL,
0x000001004d047825ULL, 0x000fe200078e003aULL, 0x0000000402027c10ULL, 0x000fc6000ff1e0ffULL,
0x000000104f3b7824ULL, 0x100fe200078e024cULL, 0x0000000503037c10ULL, 0x000fe200087fe4ffULL,
0x00000010514d7824ULL, 0x100fe200078e024cULL, 0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL,
0x00000010534f7824ULL, 0x100fe200078e024cULL, 0x0000004c57537211ULL, 0x000fe200078e20ffULL,
0x0000001055517824ULL, 0x100fe200078e024cULL, 0x0000000505057c10ULL, 0x000fe200087fe4ffULL,
0x0000001059557824ULL, 0x000fe200078e024cULL, 0x00000000343b7faeULL, 0x0003e8000f101c46ULL,
0x00000000064d7faeULL, 0x0003e8000e901c46ULL, 0x00000000364f7faeULL, 0x0003e8000e101c46ULL,
0x0000000038517faeULL, 0x0003e8000d901c46ULL, 0x0000000002537faeULL, 0x0003e8000d101c46ULL,
0x0000000004557faeULL, 0x0003e2000c901c46ULL, 0x0000000400687947ULL, 0x000fea0003800000ULL,
0x0000000472057811ULL, 0x040fe200078fe8ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000872077811ULL, 0x040fe400078fe8ffULL, 0x0000000c72357811ULL, 0x040fe200078fe8ffULL,
0x0000000105027824ULL, 0x140fe200078e0272ULL, 0x0000001072377811ULL, 0x040fe200078fe8ffULL,
0x0000000805517824ULL, 0x000fe200078e00ffULL, 0x0000001472397811ULL, 0x040fe200078fe8ffULL,
0x0000000107037824ULL, 0x100fe200078e0272ULL, 0x0000000335557819ULL, 0x000fe200000006ffULL,
0x0000000807067824ULL, 0x000fe200078e00ffULL, 0x00000018723b7811ULL, 0x040fe200078fe8ffULL,
0x0000000135047824ULL, 0x100fe200078e0272ULL, 0xfffffff851517812ULL, 0x000fe200078ee202ULL,
0x0000000137027824ULL, 0x140fe200078e0272ULL, 0xfffffff806537812ULL, 0x000fe200078ee203ULL,
0x0000000837577824ULL, 0x000fe200078e00ffULL, 0xfffffff855557812ULL, 0x000fe200078ee204ULL,
0x0000000139037824ULL, 0x140fe200078e0272ULL, 0x0000001c72617811ULL, 0x040fe200078fe8ffULL,
0x0000000839067824ULL, 0x000fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fe200078ee202ULL,
0x000000013b047824ULL, 0x040fe200078e0272ULL, 0x0000004d35357210ULL, 0x000fe20007ffe0ffULL,
0x000000083b5b7824ULL, 0x000fe200078e00ffULL, 0xfffffff806597812ULL, 0x000fe200078ee203ULL,
0x0000001072027824ULL, 0x040fe200078e00ffULL, 0x0000007272037211ULL, 0x000fe200078fe8ffULL,
0x0000000861637824ULL, 0x000fe200078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee204ULL,
0x000040006e047824ULL, 0x000fe200078e0273ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000105057824ULL, 0x100fe200078e024dULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x000020006b047824ULL, 0x000fe200078e0204ULL, 0x0000007261067210ULL, 0x000fe20007ffe0ffULL,
0x0000000107077824ULL, 0x100fe200078e024dULL, 0x0ffffff8034f7812ULL, 0x000fe200078ef872ULL,
0x0000000137377824ULL, 0x100fe200078e024dULL, 0x0000004d72037211ULL, 0x000fe200078fe8ffULL,
0x0000000139397824ULL, 0x100fe200078e024dULL, 0xfffffff863637812ULL, 0x000fe200078ee206ULL,
0x000000013b3b7824ULL, 0x000fc400078e024dULL, 0x0001700004047836ULL, 0x000fe40000000000ULL,
0x0000000161617824ULL, 0x000fe400078e024dULL, 0x000000806b4c7824ULL, 0x000fe200078e0202ULL,
0x000000044f4f7211ULL, 0x080fe200078e20ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e00ffULL,
0x0000000463637211ULL, 0x000fe200078e20ffULL, 0x0000001051517824ULL, 0x100fe400078e0204ULL,
0x0000001053537824ULL, 0x000fc400078e0204ULL, 0x0000001055557824ULL, 0x100fe400078e0204ULL,
0x0000001057577824ULL, 0x100fe400078e0204ULL, 0x0000001059597824ULL, 0x100fe400078e0204ULL,
0x000000105b5b7824ULL, 0x000fe400078e0204ULL, 0x0000010003027825ULL, 0x000fc800078e004cULL,
0x0000010005047825ULL, 0x000fe200078e004cULL, 0x0000000402027c10ULL, 0x000fc6000ff1e0ffULL,
0x0000010007067825ULL, 0x100fe200078e004cULL, 0x0000000404047c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000503037c10ULL, 0x000fe200087fe4ffULL, 0x0000010035347825ULL, 0x100fe200078e004cULL,
0x0000000406067c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000505057c10ULL, 0x000fe20008ffe4ffULL,
0x0000010037367825ULL, 0x100fe200078e004cULL, 0x0000000434347c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000024f7faeULL, 0x0003e2000b901c46ULL,
0x0000000507077c10ULL, 0x000fe200097fe4ffULL, 0x0000010039387825ULL, 0x100fe200078e004cULL,
0x0000000436367c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000004517faeULL, 0x0003e2000b901c46ULL,
0x0000000535357c10ULL, 0x000fe20009ffe4ffULL, 0x000001003b3a7825ULL, 0x100fe200078e004cULL,
0x0000000438387c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000006537faeULL, 0x0003e2000b901c46ULL,
0x0000000537377c10ULL, 0x000fe200087fe4ffULL, 0x00000100614c7825ULL, 0x000fe200078e004cULL,
0x000000043a3a7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000034557faeULL, 0x0003e2000b901c46ULL,
0x0000000539397c10ULL, 0x000fc40008ffe4ffULL, 0x000000044c4c7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000036577faeULL, 0x0003e2000b901c46ULL, 0x000000053b3b7c10ULL, 0x000fe400097fe4ffULL,
0x000000054d4d7c10ULL, 0x000fe20009ffe4ffULL, 0x0000000038597faeULL, 0x0003e8000b901c46ULL,
0x000000003a5b7faeULL, 0x0003e8000b901c46ULL, 0x000000004c637faeULL, 0x0003e4000b901c46ULL,
0xffffffe06f027812ULL, 0x042fe200078ec0ffULL, 0x00000001ff077424ULL, 0x000fe200078e00ffULL,
0x000000106f037812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x0000007303047210ULL, 0x000fca0007ffe002ULL, 0x000000086b067824ULL, 0x000fcc00078e0204ULL,
0x01e60807060679a7ULL, 0x000e64000850003fULL, 0x0000000000027805ULL, 0x000fe40000015200ULL,
0x000000086f057812ULL, 0x000fca00078ec0ffULL, 0x0000000104357824ULL, 0x000fc800078e0205ULL,
0x01e60807350075a7ULL, 0x002ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff347224ULL, 0x000fce00078e00ffULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402377210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000003704047211ULL, 0x000fc800078110ffULL,
0x00000005ff057210ULL, 0x000fc800007fe4ffULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x01e60807350075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000010726a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff697819ULL, 0x000fe20000011672ULL, 0x0000002078027824ULL, 0x000fe400078e00ffULL,
0x000000ffff857224ULL, 0x000fe200078e0000ULL, 0x000000706a6a7812ULL, 0x000fe400078ec0ffULL,
0xffffff8002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c69697812ULL, 0x000fe400078ec0ffULL,
0x000000736a027210ULL, 0x000fca0007ffe002ULL, 0x0000000102027824ULL, 0x000fca00078e0269ULL,
0x01e0000002037984ULL, 0x000e680000000800ULL, 0x01e20000027e7984ULL, 0x0004a20000000800ULL,
0x000000000300720bULL, 0x002fda0003f1d000ULL, 0x0000000000047806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff0400720cULL, 0x000fda0003f25270ULL,
0x0000000400909947ULL, 0x004fea0003800000ULL, 0x00000002ff057819ULL, 0x000fe40000011678ULL,
0x000000000300720bULL, 0x000fe40003f34000ULL, 0x000000780500720cULL, 0x000fe40003f45270ULL,
0x0000000003857209ULL, 0x000fd20007810000ULL, 0x0000000000057806ULL, 0x000fe400008e0100ULL,
0x000000807802a824ULL, 0x000fe400078e0273ULL, 0x000000ff0500720cULL, 0x000fc60003f25270ULL,
0x000000026902a210ULL, 0x000fca0007ffe06aULL, 0x01e400850200a388ULL, 0x0003ea0000000800ULL,
0x0000000400509947ULL, 0x000fea0003800000ULL, 0x0000000085007221ULL, 0x000fe20000010100ULL,
0x000000ff05ff7812ULL, 0x040fe4000782c0ffULL, 0x0000ff0005ff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b00007820ULL, 0x000fe20000410000ULL, 0x00ff000005ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000005ff7812ULL, 0x000fe2000788c0ffULL, 0x0000000000077308ULL, 0x0004ec0000000800ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000002ff007819ULL, 0x004fcc0000011672ULL,
0x00001f0007007589ULL, 0x008ea400000e0000ULL, 0x0000000008087220ULL, 0x084fe20000410000ULL,
0x0000000009097220ULL, 0x080fe20000410000ULL, 0x0000000088887220ULL, 0x080fe20000410000ULL,
0x0000000089897220ULL, 0x080fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x000000000d0d7220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000014147220ULL, 0x080fe20000410000ULL,
0x0000000015157220ULL, 0x080fe20000410000ULL, 0x0000000018187220ULL, 0x080fe20000410000ULL,
0x0000000019197220ULL, 0x080fe20000410000ULL, 0x000000001c1c7220ULL, 0x080fe20000410000ULL,
0x000000001d1d7220ULL, 0x080fe20000410000ULL, 0x0000000020207220ULL, 0x080fe20000410000ULL,
0x0000000021217220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000872007811ULL, 0x004fcc00078ff0ffULL, 0x00001f0007007589ULL, 0x008ea400000e0000ULL,
0x000000000a0a7220ULL, 0x084fe20000410000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000008a8a7220ULL, 0x080fe20000410000ULL, 0x000000008b8b7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001072007811ULL, 0x004fcc00078ff0ffULL,
0x00001f0007007589ULL, 0x008ea400000e0000ULL, 0x0000000024247220ULL, 0x084fe20000410000ULL,
0x0000000025257220ULL, 0x080fe20000410000ULL, 0x0000000028287220ULL, 0x080fe20000410000ULL,
0x0000000029297220ULL, 0x080fe20000410000ULL, 0x000000002c2c7220ULL, 0x080fe20000410000ULL,
0x000000002d2d7220ULL, 0x080fe20000410000ULL, 0x0000000040407220ULL, 0x080fe20000410000ULL,
0x0000000041417220ULL, 0x080fe20000410000ULL, 0x0000000048487220ULL, 0x080fe20000410000ULL,
0x0000000049497220ULL, 0x080fe20000410000ULL, 0x0000000044447220ULL, 0x080fe20000410000ULL,
0x0000000045457220ULL, 0x080fe20000410000ULL, 0x000000003c3c7220ULL, 0x080fe20000410000ULL,
0x000000003d3d7220ULL, 0x080fe20000410000ULL, 0x0000000030307220ULL, 0x080fe20000410000ULL,
0x0000000031317220ULL, 0x000fce0000410000ULL, 0x0000000783837220ULL, 0x008fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001872007811ULL, 0x004fcc00078ff0ffULL,
0x00001f0007007589ULL, 0x000ea400000e0000ULL, 0x0000000026267220ULL, 0x084fe20000410000ULL,
0x0000000027277220ULL, 0x080fe20000410000ULL, 0x000000002a2a7220ULL, 0x080fe20000410000ULL,
0x000000002b2b7220ULL, 0x080fe20000410000ULL, 0x000000002e2e7220ULL, 0x080fe20000410000ULL,
0x000000002f2f7220ULL, 0x080fe20000410000ULL, 0x0000000042427220ULL, 0x080fe20000410000ULL,
0x0000000043437220ULL, 0x080fe20000410000ULL, 0x000000004a4a7220ULL, 0x080fe20000410000ULL,
0x000000004b4b7220ULL, 0x080fe20000410000ULL, 0x0000000046467220ULL, 0x080fe20000410000ULL,
0x0000000047477220ULL, 0x080fe20000410000ULL, 0x000000003e3e7220ULL, 0x080fe20000410000ULL,
0x000000003f3f7220ULL, 0x080fe20000410000ULL, 0x0000000032327220ULL, 0x080fe20000410000ULL,
0x0000000033337220ULL, 0x000fce0000410000ULL, 0x0000000504ff7212ULL, 0x000fda00078230ffULL,
0x8000008503031221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b03031820ULL, 0x000fc80000410000ULL, 0x0000000300681308ULL, 0x000ee40000000800ULL,
0x000000687e7e1220ULL, 0x008fce0000410000ULL, 0x000000026e007819ULL, 0x004fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000872677812ULL, 0x000fe400078ec0ffULL,
0x00000004007f7812ULL, 0x000fe400078ec0ffULL, 0x0000000767677812ULL, 0x000fe400078ef872ULL,
0x0000007f72007211ULL, 0x040fe400078fe0ffULL, 0x0000001067667812ULL, 0x040fe200078efcffULL,
0x0000000867047824ULL, 0x040fe200078e00ffULL, 0x0000006772027211ULL, 0x002fe200078fe0ffULL,
0x00000001677c7824ULL, 0x000fc400078e0200ULL, 0x00000001007b7824ULL, 0x000fe400078e0266ULL,
0x0000000866007824ULL, 0x000fe400078e00ffULL, 0x0000000202657836ULL, 0x000fe40000000000ULL,
0x0000000867037824ULL, 0x040fe200078e00ffULL, 0xfffffff8007b7812ULL, 0x000fe200078ee27bULL,
0x0000000867057824ULL, 0x040fe200078e00ffULL, 0x0000000a78007819ULL, 0x000fe200000006ffULL,
0x0000000867067824ULL, 0x000fe200078e00ffULL, 0xfffffff804657812ULL, 0x000fe200078ee265ULL,
0x000040006e047824ULL, 0x000fe200078e0273ULL, 0xfffff00000007812ULL, 0x000fe200078ec0ffULL,
0x0000000402627836ULL, 0x000fe20000000000ULL, 0xfffffff8037c7812ULL, 0x000fe200078ee27cULL,
0x0000000602617836ULL, 0x000fe20000000000ULL, 0x0000000073637210ULL, 0x000fe20007ffe0ffULL,
0x000020006b047824ULL, 0x000fe200078e0204ULL, 0xfffffff803647812ULL, 0x000fc400078ee202ULL,
0xfffffff805627812ULL, 0x000fe200078ee262ULL, 0x00016000047d7836ULL, 0x000fe20000000000ULL,
0xfffffff806617812ULL, 0x000fe200078ee261ULL, 0x0001200063807836ULL, 0x000fe20000000000ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff5d7819ULL, 0x000fe40000011672ULL,
0x00000068ff00723eULL, 0x000fc600000010ffULL, 0x000000105d5f7836ULL, 0x000fe20000000000ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000000085d037836ULL, 0x000fe40000000000ULL,
0x000000185d057836ULL, 0x000fe40000000000ULL, 0x00001f5f005f7589ULL, 0x0002a800000e0000ULL,
0x00001f0300607589ULL, 0x0002e800000e0000ULL, 0x00001f5d005d7589ULL, 0x00026800000e0000ULL,
0x00001f05005e7589ULL, 0x00026400000e0000ULL, 0x000000107c587824ULL, 0x000fe200078e0280ULL,
0x000000807b347211ULL, 0x000fe200078e20ffULL, 0x0000001064547824ULL, 0x100fe400078e027dULL,
0x0000001065507824ULL, 0x100fe400078e027dULL, 0x000000005858783bULL, 0x000ee20000000200ULL,
0x00000010624c7824ULL, 0x000fc600078e027dULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000005d58587232ULL, 0x08afe40000200000ULL,
0x0000005d5a5a7232ULL, 0x000fe40000200000ULL, 0x0000006059597232ULL, 0x080fe40000200000ULL,
0x000000605b5b7232ULL, 0x000fe40000200000ULL, 0x0000005f34347232ULL, 0x084fe40000200000ULL,
0x0000005f36367232ULL, 0x000fc40000200000ULL, 0x0000005e35357232ULL, 0x080fe40000200000ULL,
0x0000005e37377232ULL, 0x000fce0000200000ULL, 0x000000004c4c783bULL, 0x000f220000004200ULL,
0x0000001061387824ULL, 0x000fe200078e027dULL, 0x000000027f7f7812ULL, 0x000fe200078efcffULL,
0x0000000866027824ULL, 0x040fe200078e00ffULL, 0x000000005050783bULL, 0x000f620000004200ULL,
0x0000000866037824ULL, 0x002fe200078e00ffULL, 0x0000007f727f7211ULL, 0x000fe400078fe0ffULL,
0x000000005454783bULL, 0x000e640000004200ULL, 0x0000007f67007210ULL, 0x000fe20007ffe0ffULL,
0x00000001667f7824ULL, 0x000fe200078e027fULL, 0x000000003838783bULL, 0x000e680000004200ULL,
0xfffffff8027f7812ULL, 0x000fca00078ee27fULL, 0x000000107f7f7824ULL, 0x000fe200078e0280ULL,
0x0000004c5814723cULL, 0x018fec0000041814ULL, 0x0000004c3448723cULL, 0x004fec0000041848ULL,
0x0000004e5818723cULL, 0x000fe20000041818ULL, 0x00000008674d7824ULL, 0x000fc400078e00ffULL,
0x00000008664c7824ULL, 0x000fc600078e00ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee200ULL,
0x0000004e3444723cULL, 0x000fe20000041844ULL, 0x0000006672007211ULL, 0x000fc600078fe0ffULL,
0x000000104d4d7824ULL, 0x000fe200078e0280ULL, 0xfffffff8035c7812ULL, 0x000fe200078ee200ULL,
0x0000000200037836ULL, 0x000fe20000000000ULL, 0x0000000400027810ULL, 0x000fe20007ffe0ffULL,
0x00000008664f7824ULL, 0x000fe200078e00ffULL, 0x00000050580c723cULL, 0x020fe2000004180cULL,
0x0000000600007836ULL, 0x000fe20000000000ULL, 0xfffffff84c037812ULL, 0x000fe400078ee203ULL,
0xfffffff84f027812ULL, 0x000fe400078ee202ULL, 0x00000050342c723cULL, 0x000fe6000004182cULL,
0x00000010024c7824ULL, 0x000fc600078e027dULL, 0x000000545804723cULL, 0x002fe20000041808ULL,
0x0000000866517824ULL, 0x000fe400078e00ffULL, 0x0000001003507824ULL, 0x000fc600078e027dULL,
0x000000565808723cULL, 0x000fe20000041888ULL, 0xfffffff851007812ULL, 0x000fca00078ee200ULL,
0x000000525810723cULL, 0x000fec0000041810ULL, 0x00000038581c723cULL, 0x000fec000004181cULL,
0x0000003a5820723cULL, 0x000fe20000041820ULL, 0x000000004d58783bULL, 0x0002aa0000000200ULL,
0x000000543424723cULL, 0x000fec0000041824ULL, 0x000000563428723cULL, 0x000fe20000041828ULL,
0x000000105c547824ULL, 0x000fca00078e027dULL, 0x000000523440723cULL, 0x000fec0000041840ULL,
0x00000038343c723cULL, 0x000fec000004183cULL, 0x0000003a3430723cULL, 0x000fe20000041830ULL,
0x000000007f34783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000208947ULL, 0x000fde0003800000ULL, 0x0000005d58587232ULL, 0x084fe40000200000ULL,
0x0000005d5a5a7232ULL, 0x000fe40000200000ULL, 0x0000006059597232ULL, 0x080fe40000200000ULL,
0x000000605b5b7232ULL, 0x000fe40000200000ULL, 0x0000005f34347232ULL, 0x088fe40000200000ULL,
0x0000005f36367232ULL, 0x000fc40000200000ULL, 0x0000005e35357232ULL, 0x080fe40000200000ULL,
0x0000005e37377232ULL, 0x000fce0000200000ULL, 0x0000007d00387211ULL, 0x000fe200078e20ffULL,
0x000000005454783bULL, 0x000f220000004200ULL, 0x0000920000047ab9ULL, 0x000fe20000000800ULL,
0x000000837e837221ULL, 0x000fe40000010000ULL, 0x000000005050783bULL, 0x000f680000004200ULL,
0x000000004c4c783bULL, 0x002e680000004200ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x000000543424723cULL, 0x018fec0000041824ULL, 0x000000563428723cULL, 0x000fec0000041828ULL,
0x00000050342c723cULL, 0x020fec000004182cULL, 0x000000523440723cULL, 0x000fec0000041840ULL,
0x0000004c3448723cULL, 0x002fec0000041848ULL, 0x0000004e3444723cULL, 0x000fec0000041844ULL,
0x00000038343c723cULL, 0x000fec000004183cULL, 0x0000003a3430723cULL, 0x000fec0000041830ULL,
0x0000004c5814723cULL, 0x004fe20000041814ULL, 0x0000000177357836ULL, 0x000fc40000000000ULL,
0x0000008082367836ULL, 0x000fc60000000000ULL, 0x000000703500720cULL, 0x000fe20003f06070ULL,
0x00000002784c7824ULL, 0x000fe200078e00ffULL, 0x00000038581c723cULL, 0x000fe8000004181cULL,
0xfffffff84c4c7812ULL, 0x000fe400078ec0ffULL, 0x000000545804723cULL, 0x000fe20000041804ULL,
0x00000001ff387424ULL, 0x000fe400078e00ffULL, 0x0000000173397824ULL, 0x000fc600078e024cULL,
0x000000565808723cULL, 0x000fe20000041808ULL, 0x01e6883839ff79a7ULL, 0x0003e2000850003fULL,
0x000000046c557c24ULL, 0x000fc8000f8e0236ULL, 0x00000050580c723cULL, 0x000fec000004180cULL,
0x000000525810723cULL, 0x000fec0000041810ULL, 0x0000004e5818723cULL, 0x000fec0000041818ULL,
0x0000003a5820723cULL, 0x000fe20000041820ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400888947ULL, 0x002fde0003800000ULL,
0x00000003ff547819ULL, 0x000fe20000011672ULL, 0x000000806b347824ULL, 0x000fe200078e026aULL,
0x0000003671357248ULL, 0x000fe20007fe0000ULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x000000ff36367210ULL, 0x000fe20007ffe1ffULL, 0x00000004543a7836ULL, 0x000fe20000000000ULL,
0x00000008545a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000c547e7836ULL, 0x000fe20000000000ULL,
0x0000002035397446ULL, 0x000fe20003800036ULL, 0x000000013a377824ULL, 0x140fe400078e0272ULL,
0x000000083a587824ULL, 0x040fe200078e00ffULL, 0x000000393a00720cULL, 0x080fe20003f26070ULL,
0x0000000154367824ULL, 0x040fe200078e0272ULL, 0x000000395400720cULL, 0x0c0fe20003f06070ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0xfffffff858587812ULL, 0x000fe200078ee237ULL,
0x0000000154377824ULL, 0x100fe200078e0255ULL, 0x0000000736537812ULL, 0x000fe200078ec0ffULL,
0x000000015a4d7824ULL, 0x040fe200078e0255ULL, 0x000000395a00720cULL, 0x000fe20003fa6070ULL,
0x0000010037367825ULL, 0x000fe200078e0034ULL, 0x0ffffff853567812ULL, 0x000fc400078ef872ULL,
0x000000397e00720cULL, 0x000fe20003f86070ULL, 0x000000013a3b7824ULL, 0x000fe200078e0255ULL,
0x0000000436507c10ULL, 0x000fe2000ff5e0ffULL, 0x000001004d4c7825ULL, 0x000fc600078e0034ULL,
0x0000000537517c10ULL, 0x000fe200097fe4ffULL, 0x000001003b3a7825ULL, 0x000fe200078e0034ULL,
0x000000044c367c10ULL, 0x000fc6000ff5e0ffULL, 0x000000017e4f7824ULL, 0x000fe200078e0255ULL,
0x000000043a527c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001056577824ULL, 0x000fe200078e027dULL,
0x0000001054567810ULL, 0x000fe20007ffe0ffULL, 0x000001004f4e7825ULL, 0x000fe200078e0034ULL,
0x000000054d377c10ULL, 0x000fe400097fe4ffULL, 0x000000053b537c10ULL, 0x000fe20009ffe4ffULL,
0x00000001564d7824ULL, 0x000fe200078e0255ULL, 0x000000044e3a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001058597824ULL, 0x000fe200078e027dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000050577faeULL, 0x0003e2000c101c46ULL, 0x000001004d4c7825ULL, 0x000fe200078e0034ULL,
0x000000054f3b7c10ULL, 0x000fc40009ffe4ffULL, 0x0000000052597faeULL, 0x0005e2000c901c46ULL,
0x0000001454587836ULL, 0x000fe20000000000ULL, 0x000000044c4e7c10ULL, 0x000fe2000ffde0ffULL,
0x000000015a4f7824ULL, 0x000fe200078e0272ULL, 0x000000395600720cULL, 0x080fe20003f66070ULL,
0x000000085a5a7824ULL, 0x000fe200078e00ffULL, 0x000000395800720cULL, 0x0c0fe20003f46070ULL,
0x0000001854807836ULL, 0x000fe20000000000ULL, 0x000000727e507210ULL, 0x002fe20007ffe0ffULL,
0x0000000158517824ULL, 0x000fe400078e0255ULL, 0x0000001c54847836ULL, 0x000fe20000000000ULL,
0xfffffff85a527812ULL, 0x004fe200078ee24fULL, 0x000000087e537824ULL, 0x000fe200078e00ffULL,
0x000000054d4f7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000100514c7825ULL, 0x000fe200078e0034ULL,
0x000000398000720cULL, 0x000fc40003f26070ULL, 0xfffffff853547812ULL, 0x000fe200078ee250ULL,
0x0000000156517824ULL, 0x100fe200078e0272ULL, 0x000000398400720cULL, 0x000fe20003f06070ULL,
0x0000000856567824ULL, 0x000fe200078e00ffULL, 0x000000044c507c10ULL, 0x000fe2000ffde0ffULL,
0x0000000158537824ULL, 0x040fe200078e0272ULL, 0x0000005580397210ULL, 0x000fe20007ffe0ffULL,
0x0000000858587824ULL, 0x000fe200078e00ffULL, 0xfffffff856567812ULL, 0x000fe200078ee251ULL,
0x00000008805a7824ULL, 0x000fe200078e00ffULL, 0x000000054d517c10ULL, 0x000fe2000b7fe4ffULL,
0x00000100394c7825ULL, 0x000fe200078e0034ULL, 0xfffffff858587812ULL, 0x000fc600078ee253ULL,
0x0000000184537824ULL, 0x000fe200078e0255ULL, 0x000000044c4c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000180397824ULL, 0x100fe400078e0272ULL, 0x0000000184557824ULL, 0x040fe200078e0272ULL,
0x000000054d4d7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000008847e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee239ULL, 0x0000010053347825ULL, 0x000fe200078e0034ULL,
0x0000007d54537211ULL, 0x000fe400078e20ffULL, 0xfffffff87e7e7812ULL, 0x000fe200078ee255ULL,
0x0000001052397824ULL, 0x100fe200078e027dULL, 0x0000000434347c10ULL, 0x000fe2000ffde0ffULL,
0x0000001056557824ULL, 0x000fc400078e027dULL, 0x0000001058577824ULL, 0x100fe200078e027dULL,
0x0000000535357c10ULL, 0x000fe2000b7fe4ffULL, 0x000000105a597824ULL, 0x100fe200078e027dULL,
0x0000000036397faeULL, 0x0003e2000e901c46ULL, 0x000000107e7d7824ULL, 0x000fc600078e027dULL,
0x000000003a537faeULL, 0x0003e8000e101c46ULL, 0x000000004e557faeULL, 0x0003e8000d901c46ULL,
0x0000000050577faeULL, 0x0003e8000d101c46ULL, 0x000000004c597faeULL, 0x0003e8000c901c46ULL,
0x00000000347d7faeULL, 0x0003e2000c101c46ULL, 0x0000000400547947ULL, 0x000fea0003800000ULL,
0x0000000472377811ULL, 0x040fe200078fe8ffULL, 0x000000806b547824ULL, 0x000fe200078e026aULL,
0x00000008723b7811ULL, 0x040fe200078fe8ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000001472517811ULL, 0x040fe200078fe8ffULL, 0x0000000137347824ULL, 0x140fe200078e0272ULL,
0x000000723b357210ULL, 0x000fe20007ffe0ffULL, 0x0000000837397824ULL, 0x000fe200078e00ffULL,
0x0000000c724d7811ULL, 0x040fe200078fe8ffULL, 0x000000083b5a7824ULL, 0x000fe200078e00ffULL,
0x00000010724f7811ULL, 0x040fe200078fe8ffULL, 0x0000000151367824ULL, 0x100fe200078e0272ULL,
0x0000001872537811ULL, 0x040fe200078fe8ffULL, 0x000000084d577824ULL, 0x000fe200078e00ffULL,
0x0000000351597819ULL, 0x000fe200000006ffULL, 0x000000084f807824ULL, 0x000fe200078e00ffULL,
0xfffffff839587812ULL, 0x000fe200078ee234ULL, 0x000000014d347824ULL, 0x100fe200078e0272ULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee235ULL, 0x000000014f357824ULL, 0x100fe200078e0272ULL,
0xfffffff859847812ULL, 0x000fe200078ee236ULL, 0x0000000153397824ULL, 0x040fe200078e0272ULL,
0x0000001c72367811ULL, 0x040fe200078fe8ffULL, 0x0000000853867824ULL, 0x000fe200078e00ffULL,
0xfffffff8577e7812ULL, 0x000fe200078ee234ULL, 0x0000000137377824ULL, 0x100fe200078e0255ULL,
0xfffffff880807812ULL, 0x000fe200078ee235ULL, 0x000000013b3b7824ULL, 0x100fe200078e0255ULL,
0xfffffff886867812ULL, 0x000fe200078ee239ULL, 0x000000014d4d7824ULL, 0x100fe200078e0255ULL,
0x0000007272347211ULL, 0x040fe200078fe8ffULL, 0x0000000151517824ULL, 0x100fe200078e0255ULL,
0x0000005572357211ULL, 0x000fe200078fe8ffULL, 0x0000000153537824ULL, 0x100fe200078e0255ULL,
0x000000554f4f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000136397824ULL, 0x000fe200078e0255ULL,
0x0000000734577812ULL, 0x000fe200078ec0ffULL, 0x000000ffff557224ULL, 0x000fc400078e00ffULL,
0x0000000136597824ULL, 0x040fe200078e0272ULL, 0x0ffffff857567812ULL, 0x000fe200078ef872ULL,
0x0000000836887824ULL, 0x000fe400078e00ffULL, 0x0000010035347825ULL, 0x000fc600078e0054ULL,
0xfffffff888887812ULL, 0x000fe200078ee259ULL, 0x0000010037367825ULL, 0x000fe200078e0054ULL,
0x0000000434347c10ULL, 0x000fc6000ff1e0ffULL, 0x000001003b3a7825ULL, 0x100fe200078e0054ULL,
0x0000000436367c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000535357c10ULL, 0x000fe200087fe4ffULL,
0x000001004d4c7825ULL, 0x100fe200078e0054ULL, 0x000000043a3a7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000537377c10ULL, 0x000fe20008ffe4ffULL, 0x000001004f4e7825ULL, 0x100fe200078e0054ULL,
0x000000044c4c7c10ULL, 0x000fe4000ff7e0ffULL, 0x000000053b3b7c10ULL, 0x000fe200097fe4ffULL,
0x0000010051507825ULL, 0x000fe200078e0054ULL, 0x000000044e4e7c10ULL, 0x000fc4000ff1e0ffULL,
0x000000054d4d7c10ULL, 0x000fe20009ffe4ffULL, 0x0000010053527825ULL, 0x100fe200078e0054ULL,
0x0000000450507c10ULL, 0x000fe4000ff3e0ffULL, 0x000000054f4f7c10ULL, 0x000fe200087fe4ffULL,
0x0000010039547825ULL, 0x000fe200078e0054ULL, 0x0000007d56397211ULL, 0x080fe400078e20ffULL,
0x0000000452527c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001058577824ULL, 0x100fe200078e027dULL,
0x0000000454547c10ULL, 0x000fe2000ff7e0ffULL, 0x000000105a597824ULL, 0x100fe200078e027dULL,
0x0000000551517c10ULL, 0x000fe20008ffe4ffULL, 0x000000107e5b7824ULL, 0x100fe200078e027dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034397faeULL, 0x0003e2000b901c46ULL,
0x00000010807f7824ULL, 0x100fe200078e027dULL, 0x0000000553537c10ULL, 0x000fe200097fe4ffULL,
0x0000001084817824ULL, 0x100fe200078e027dULL, 0x0000000036577faeULL, 0x0003e2000b901c46ULL,
0x0000001086877824ULL, 0x000fe200078e027dULL, 0x0000007d887d7211ULL, 0x000fc400078e20ffULL,
0x0000000555557c10ULL, 0x000fe20009ffe4ffULL, 0x000000003a597faeULL, 0x0003e8000b901c46ULL,
0x000000004c5b7faeULL, 0x0003e8000b901c46ULL, 0x000000004e7f7faeULL, 0x0003e8000b901c46ULL,
0x0000000050817faeULL, 0x0003e8000b901c46ULL, 0x0000000052877faeULL, 0x0003e8000b901c46ULL,
0x00000000547d7faeULL, 0x0003e4000b901c46ULL, 0xffffffe06f347812ULL, 0x042fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000106f357812ULL, 0x040fe400078ec0ffULL,
0x000000086f367812ULL, 0x000fe400078ec0ffULL, 0x0000007335377210ULL, 0x000fca0007ffe034ULL,
0x0000000137397824ULL, 0x000fcc00078e0236ULL, 0x01e62838393879a7ULL, 0x000e64000850003fULL,
0x0000000000347805ULL, 0x000fe20000015200ULL, 0x000000086b4d7824ULL, 0x000fc800078e0237ULL,
0x01e628394d0075a7ULL, 0x002ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003b36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x01e628394d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000578347819ULL, 0x000fc800000006ffULL,
0xffffff8034347812ULL, 0x000fc800078ec0ffULL, 0x0000008073347810ULL, 0x000fc80007ffe034ULL,
0x0000003469347210ULL, 0x000fca0007ffe06aULL, 0x01e0000034367984ULL, 0x000e680000000800ULL,
0x01e2000034847984ULL, 0x0004a20000000800ULL, 0x000000853600720bULL, 0x002fda0003f1d000ULL,
0x0000000000377806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff3700720cULL, 0x000fda0003f25270ULL, 0x0000000400949947ULL, 0x004fea0003800000ULL,
0x0000000178357811ULL, 0x000fe400078ff0ffULL, 0x000000853600720bULL, 0x000fe40003f14000ULL,
0x000000783500720cULL, 0x000fd60003f25270ULL, 0x0000000000387806ULL, 0x000fe400000e0100ULL,
0x0000008078359824ULL, 0x000fe200078e0273ULL, 0x0000008536349209ULL, 0x000fe40007810000ULL,
0x000000ff3800720cULL, 0x000fe40003f05270ULL, 0x0000003569359210ULL, 0x000fca0007ffe06aULL,
0x01e4003435009388ULL, 0x0003ec0000000800ULL, 0x0000000400548947ULL, 0x000fea0003800000ULL,
0x0000008536347209ULL, 0x002fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL, 0x0000008534347221ULL, 0x000fe20000010100ULL,
0x00ff000038ff7812ULL, 0x040fe4000784c0ffULL, 0xff00000038ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003a7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff357819ULL, 0x000fca0000011672ULL,
0x00001f353a347589ULL, 0x006e6400000e0000ULL, 0x0000000434047220ULL, 0x042fe20000410000ULL,
0x0000000534057220ULL, 0x040fe20000410000ULL, 0x0000000834087220ULL, 0x040fe20000410000ULL,
0x0000000934097220ULL, 0x040fe20000410000ULL, 0x0000000c340c7220ULL, 0x040fe20000410000ULL,
0x0000000d340d7220ULL, 0x040fe20000410000ULL, 0x0000001034107220ULL, 0x040fe20000410000ULL,
0x0000001134117220ULL, 0x040fe20000410000ULL, 0x0000001434147220ULL, 0x040fe20000410000ULL,
0x0000001534157220ULL, 0x040fe20000410000ULL, 0x0000001834187220ULL, 0x040fe20000410000ULL,
0x0000001934197220ULL, 0x040fe20000410000ULL, 0x0000001c341c7220ULL, 0x040fe20000410000ULL,
0x0000001d341d7220ULL, 0x040fe20000410000ULL, 0x0000002034207220ULL, 0x040fe20000410000ULL,
0x0000002134217220ULL, 0x000fce0000410000ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x0000000872357811ULL, 0x000fca00078ff0ffULL, 0x00001f353a347589ULL, 0x006e6400000e0000ULL,
0x0000000634067220ULL, 0x042fe20000410000ULL, 0x0000000734077220ULL, 0x040fe20000410000ULL,
0x0000000a340a7220ULL, 0x040fe20000410000ULL, 0x0000000b340b7220ULL, 0x040fe20000410000ULL,
0x0000000e340e7220ULL, 0x040fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000001072357811ULL, 0x000fca00078ff0ffULL,
0x00001f353a347589ULL, 0x006e6400000e0000ULL, 0x0000002434247220ULL, 0x042fe20000410000ULL,
0x0000002534257220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x0000002934297220ULL, 0x040fe20000410000ULL, 0x0000002c342c7220ULL, 0x040fe20000410000ULL,
0x0000002d342d7220ULL, 0x040fe20000410000ULL, 0x0000004034407220ULL, 0x040fe20000410000ULL,
0x0000004134417220ULL, 0x040fe20000410000ULL, 0x0000004834487220ULL, 0x040fe20000410000ULL,
0x0000004934497220ULL, 0x040fe20000410000ULL, 0x0000004434447220ULL, 0x040fe20000410000ULL,
0x0000004534457220ULL, 0x040fe20000410000ULL, 0x0000003c343c7220ULL, 0x040fe20000410000ULL,
0x0000003d343d7220ULL, 0x040fe20000410000ULL, 0x0000003034307220ULL, 0x040fe20000410000ULL,
0x0000003134317220ULL, 0x000fce0000410000ULL, 0x0000003a83837220ULL, 0x004fe20000410000ULL,
0x000000000048b947ULL, 0x000fec0003800000ULL, 0x0000001872357811ULL, 0x000fca00078ff0ffULL,
0x00001f353a347589ULL, 0x002e6400000e0000ULL, 0x0000002634267220ULL, 0x042fe20000410000ULL,
0x0000002734277220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000004234427220ULL, 0x040fe20000410000ULL,
0x0000004334437220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004634467220ULL, 0x040fe20000410000ULL,
0x0000004734477220ULL, 0x040fe20000410000ULL, 0x0000003e343e7220ULL, 0x040fe20000410000ULL,
0x0000003f343f7220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x000fce0000410000ULL, 0x0000003837ff7212ULL, 0x000fe400078030ffULL,
0x0000008536857209ULL, 0x000fd60007810000ULL, 0x8000008536360221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600680308ULL, 0x000ea40000000800ULL,
0x0000006884840220ULL, 0x004fce0000410000ULL, 0x0000200078347824ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffc00034347812ULL, 0x000fe200078ec0ffULL,
0x00013000637e7836ULL, 0x000fc80000000000ULL, 0x0000000173347824ULL, 0x000fe400078e0234ULL,
0x000000107c587824ULL, 0x000fe400078e027eULL, 0x000020006b357824ULL, 0x000fe200078e0234ULL,
0x0000007e7b347211ULL, 0x000fc600078e20ffULL, 0x0001700035387836ULL, 0x000fe20000000000ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff367819ULL, 0x000fe40000011672ULL,
0x00000068ff35723eULL, 0x000fc600000010ffULL, 0x0000000836607836ULL, 0x000fe20000000000ULL,
0x0000541035357816ULL, 0x000fe20000000035ULL, 0x00000018365e7836ULL, 0x000fe40000000000ULL,
0x00000010363a7836ULL, 0x000fe40000000000ULL, 0x00001f6035607589ULL, 0x0002a800000e0000ULL,
0x00001f3a355f7589ULL, 0x0002e800000e0000ULL, 0x00001f36355d7589ULL, 0x00026800000e0000ULL,
0x00001f5e355e7589ULL, 0x00026400000e0000ULL, 0x000000005858783bULL, 0x000ee20000000200ULL,
0x0000001064547824ULL, 0x100fe200078e0238ULL, 0x00000038624c7211ULL, 0x000fe200078e20ffULL,
0x0000001065507824ULL, 0x000fe200078e0238ULL, 0x000000003434783bULL, 0x002e620000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000005d58587232ULL, 0x088fe40000200000ULL,
0x0000005d5a5a7232ULL, 0x000fe40000200000ULL, 0x0000006059597232ULL, 0x084fe40000200000ULL,
0x000000605b5b7232ULL, 0x000fe40000200000ULL, 0x0000005f34347232ULL, 0x082fe40000200000ULL,
0x0000005f36367232ULL, 0x000fc40000200000ULL, 0x0000005e35357232ULL, 0x080fe40000200000ULL,
0x0000005e37377232ULL, 0x000fce0000200000ULL, 0x000000005050783bULL, 0x000f220000004200ULL,
0x0000001061387824ULL, 0x000fc600078e0238ULL, 0x000000004c4c783bULL, 0x000f680000004200ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000005454783bULL, 0x000f620000004200ULL,
0x00000050580c723cULL, 0x018fec000004180cULL, 0x00000050342c723cULL, 0x002fec000004182cULL,
0x0000004c5814723cULL, 0x020fe20000041814ULL, 0x0000000278507824ULL, 0x000fca00078e00ffULL,
0x0000004c3448723cULL, 0x000fec0000041848ULL, 0x00000038581c723cULL, 0x004fe2000004181cULL,
0x00000004504c7812ULL, 0x000fc800078ec0ffULL, 0x000000024c4d7812ULL, 0x000fe200078efcffULL,
0x00000038343c723cULL, 0x000fe2000004183cULL, 0x00000008674c7824ULL, 0x000fe400078e00ffULL,
0x0000004d724d7211ULL, 0x000fc600078fe0ffULL, 0x000000545804723cULL, 0x000fe20000041804ULL,
0x0000000866397824ULL, 0x000fe200078e00ffULL, 0x0000004d667c7210ULL, 0x000fe20007ffe0ffULL,
0x00000001677b7824ULL, 0x000fe400078e024dULL, 0x000040006e387824ULL, 0x000fe200078e0273ULL,
0xfffffff8397c7812ULL, 0x000fe200078ee27cULL, 0x000000565808723cULL, 0x000fe20000041808ULL,
0xfffffff84c7b7812ULL, 0x000fe200078ee27bULL, 0x000020006b387824ULL, 0x000fc800078e0238ULL,
0x000000525810723cULL, 0x000fe20000041810ULL, 0x00017000387d7836ULL, 0x000fc80000000000ULL,
0x000000105c817824ULL, 0x100fe200078e027dULL, 0x0000004e5818723cULL, 0x000fe20000041818ULL,
0x0000001003807824ULL, 0x000fe200078e027dULL, 0x0000007d027f7211ULL, 0x000fc800078e20ffULL,
0x0000003a5820723cULL, 0x000fec0000041820ULL, 0x000000543424723cULL, 0x000fe20000041824ULL,
0x000000107b587824ULL, 0x000fca00078e027eULL, 0x000000563428723cULL, 0x000fe20000041828ULL,
0x000000005858783bULL, 0x000e6a0000000200ULL, 0x000000523440723cULL, 0x000fec0000041840ULL,
0x0000004e3444723cULL, 0x000fec0000041844ULL, 0x0000003a3430723cULL, 0x000fee0000041830ULL,
0x000000107c347824ULL, 0x000fcc00078e027eULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0000000000208947ULL, 0x000ff40003800000ULL, 0x0000005d58587232ULL, 0x082fe40000200000ULL,
0x0000005d5a5a7232ULL, 0x000fe40000200000ULL, 0x0000006059597232ULL, 0x080fe40000200000ULL,
0x000000605b5b7232ULL, 0x000fe40000200000ULL, 0x0000005f34347232ULL, 0x084fe40000200000ULL,
0x0000005f36367232ULL, 0x000fc40000200000ULL, 0x0000005e35357232ULL, 0x080fe40000200000ULL,
0x0000005e37377232ULL, 0x000fce0000200000ULL, 0x00000010007e7824ULL, 0x000fe200078e027dULL,
0x000000008154783bULL, 0x000ee20000004200ULL, 0x0000920000047ab9ULL, 0x000fe20000000800ULL,
0x0000008384847221ULL, 0x000fe40000010000ULL, 0x000000008050783bULL, 0x000f280000004200ULL,
0x000000007f4c783bULL, 0x000f680000004200ULL, 0x000000007e38783bULL, 0x000f220000004200ULL,
0x000000543424723cULL, 0x00cfec0000041824ULL, 0x000000563428723cULL, 0x000fec0000041828ULL,
0x00000050342c723cULL, 0x010fec000004182cULL, 0x000000523440723cULL, 0x000fec0000041840ULL,
0x0000004c3448723cULL, 0x020fec0000041848ULL, 0x0000004e3444723cULL, 0x000fec0000041844ULL,
0x00000038343c723cULL, 0x002fec000004183cULL, 0x0000003a3430723cULL, 0x000fec0000041830ULL,
0x0000004c5814723cULL, 0x000fe20000041814ULL, 0x0000000177357836ULL, 0x000fc40000000000ULL,
0x000000c082367836ULL, 0x000fc60000000000ULL, 0x000000703500720cULL, 0x000fe20003f06070ULL,
0x00000038581c723cULL, 0x000fe2000004181cULL, 0x00000002ff4c7819ULL, 0x000fca0000011678ULL,
0x000000565808723cULL, 0x000fe20000041808ULL, 0x00000001ff387424ULL, 0x000fe400078e00ffULL,
0x000000084c397824ULL, 0x000fc600078e0273ULL, 0x000000545804723cULL, 0x000fe20000041804ULL,
0x01e6903839ff79a7ULL, 0x0003e2000850003fULL, 0x000000046c577c24ULL, 0x000fc8000f8e0236ULL,
0x00000050580c723cULL, 0x000fec000004180cULL, 0x000000525810723cULL, 0x000fec0000041810ULL,
0x0000004e5818723cULL, 0x000fec0000041818ULL, 0x0000003a5820723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400888947ULL, 0x002fde0003800000ULL, 0x0000003671357248ULL, 0x000fe20007fe0000ULL,
0x000000ffff367224ULL, 0x000fe200078e0a36ULL, 0x00000003ff4e7819ULL, 0x100fe20000011672ULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000006a6b347211ULL, 0x000fe400078e38ffULL,
0x0000002035397446ULL, 0x000fe20003800036ULL, 0x000000014e367824ULL, 0x040fe200078e0272ULL,
0x000000144e5a7810ULL, 0x000fe20007ffe0ffULL, 0x000000044e507836ULL, 0x000fe20000000000ULL,
0x000000394e00720cULL, 0x0c0fe20003f06070ULL, 0x000000014e377824ULL, 0x100fe200078e0257ULL,
0x00000007364d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x0000000350527819ULL, 0x040fe200000006ffULL, 0x00000001503b7824ULL, 0x040fe200078e0257ULL,
0x000000395000720cULL, 0x000fe20003f26070ULL, 0x0000010037367825ULL, 0x000fc800078e0034ULL,
0x00000001504f7824ULL, 0x000fe200078e0272ULL, 0x0ffffff84d507812ULL, 0x000fe200078ef872ULL,
0x000001003b3a7825ULL, 0x000fe200078e0034ULL, 0x0000000436367c10ULL, 0x000fe4000ff5e0ffULL,
0xfffffff852527812ULL, 0x000fe200078ee24fULL, 0x00000010504f7824ULL, 0x100fe200078e027dULL,
0x000000043a3a7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000084e507836ULL, 0x000fe20000000000ULL,
0x0000000537377c10ULL, 0x000fe200097fe4ffULL, 0x0000001052517824ULL, 0x000fe200078e027dULL,
0x000000053b3b7c10ULL, 0x000fe20009ffe4ffULL, 0x0000000c4e567836ULL, 0x000fe20000000000ULL,
0x000000395000720cULL, 0x0c0fe20003fa6070ULL, 0x00000001504d7824ULL, 0x000fe200078e0257ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000364f7faeULL, 0x0003e2000c101c46ULL,
0x000000104e587836ULL, 0x000fe20000000000ULL, 0x000000395600720cULL, 0x080fe20003f86070ULL,
0x0000000150527824ULL, 0x000fe200078e0272ULL, 0x000000003a517faeULL, 0x0005e2000c901c46ULL,
0x000000184e827836ULL, 0x000fe20000000000ULL, 0x000000395800720cULL, 0x080fe20003f66070ULL,
0x0000001c4e867836ULL, 0x000fe20000000000ULL, 0x000000395a00720cULL, 0x000fc40003f46070ULL,
0x000000398200720cULL, 0x080fe20003f26070ULL, 0x000001004d367825ULL, 0x002fe200078e0034ULL,
0x000000398600720cULL, 0x000fe40003f06070ULL, 0x0000007258557210ULL, 0x000fe20007ffe0ffULL,
0x00000008504f7824ULL, 0x000fe200078e00ffULL, 0x00000057563b7210ULL, 0x004fe20007ffe0ffULL,
0x00000001584d7824ULL, 0x100fe200078e0257ULL, 0x00000004364e7c10ULL, 0x000fe2000ffde0ffULL,
0x000000015a397824ULL, 0x000fe200078e0257ULL, 0xfffffff84f547812ULL, 0x000fe200078ee252ULL,
0x000001003b3a7825ULL, 0x000fe200078e0034ULL, 0x00000005374f7c10ULL, 0x000fc6000b7fe4ffULL,
0x000001004d367825ULL, 0x000fe200078e0034ULL, 0x000000043a507c10ULL, 0x000fc6000ffde0ffULL,
0x00000001563a7824ULL, 0x040fe200078e0272ULL, 0x000000053b517c10ULL, 0x000fe2000b7fe4ffULL,
0x00000008564d7824ULL, 0x000fe200078e00ffULL, 0x0000000436527c10ULL, 0x000fe2000ffde0ffULL,
0x0000000858587824ULL, 0x000fc600078e00ffULL, 0xfffffff84d567812ULL, 0x000fe200078ee23aULL,
0x00000001824d7824ULL, 0x000fe200078e0257ULL, 0x0000000537537c10ULL, 0x000fe2000b7fe4ffULL,
0x00000100393a7825ULL, 0x000fe200078e0034ULL, 0xfffffff858587812ULL, 0x000fc600078ee255ULL,
0x000001004d367825ULL, 0x000fe200078e0034ULL, 0x000000043a3a7c10ULL, 0x000fc6000ffde0ffULL,
0x000000015a4d7824ULL, 0x040fe200078e0272ULL, 0x000000053b3b7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000085a5a7824ULL, 0x000fe200078e00ffULL, 0x0000000436367c10ULL, 0x000fe2000ffde0ffULL,
0x0000000186397824ULL, 0x000fe400078e0257ULL, 0x0000001058557824ULL, 0x000fe200078e027dULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee24dULL, 0x0000010039347825ULL, 0x000fe200078e0034ULL,
0x0000000537377c10ULL, 0x000fe4000b7fe4ffULL, 0x0000007d5a577211ULL, 0x000fe200078e20ffULL,
0x0000000182397824ULL, 0x140fe200078e0272ULL, 0x0000000382827819ULL, 0x000fe200000006ffULL,
0x00000001864d7824ULL, 0x040fe200078e0272ULL, 0x0000000434347c10ULL, 0x000fe2000ffde0ffULL,
0x0000000886867824ULL, 0x000fe200078e00ffULL, 0xfffffff882827812ULL, 0x000fe200078ee239ULL,
0x0000001054397824ULL, 0x000fe200078e027dULL, 0x0000000535357c10ULL, 0x000fc4000b7fe4ffULL,
0xfffffff886547812ULL, 0x000fe200078ee24dULL, 0x00000010564d7824ULL, 0x100fe200078e027dULL,
0x000000004e397faeULL, 0x0003e2000e901c46ULL, 0x0000001082597824ULL, 0x100fe400078e027dULL,
0x00000010545b7824ULL, 0x000fe200078e027dULL, 0x00000000504d7faeULL, 0x0003e8000e101c46ULL,
0x0000000052557faeULL, 0x0003e8000d901c46ULL, 0x000000003a577faeULL, 0x0003e8000d101c46ULL,
0x0000000036597faeULL, 0x0003e8000c901c46ULL, 0x00000000345b7faeULL, 0x0003e2000c101c46ULL,
0x0000000400547947ULL, 0x000fea0003800000ULL, 0x0000000472377811ULL, 0x040fe200078fe8ffULL,
0x000000806b567824ULL, 0x000fe200078e026aULL, 0x00000008723b7811ULL, 0x040fe200078fe8ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000c724f7811ULL, 0x040fe200078fe8ffULL,
0x0000000137347824ULL, 0x100fe200078e0272ULL, 0x000000033b827819ULL, 0x000fe200000006ffULL,
0x0000000837397824ULL, 0x000fe200078e00ffULL, 0x0000001072517811ULL, 0x040fe200078fe8ffULL,
0x000000013b357824ULL, 0x100fe200078e0272ULL, 0x0000001872557811ULL, 0x040fe200078fe8ffULL,
0x000000084f4d7824ULL, 0x040fe200078e00ffULL, 0xfffffff8395a7812ULL, 0x000fe200078ee234ULL,
0x000000014f347824ULL, 0x100fe200078e0272ULL, 0xfffffff882827812ULL, 0x000fe200078ee235ULL,
0x0000000151357824ULL, 0x140fe200078e0272ULL, 0x0000001472537811ULL, 0x040fe200078fe8ffULL,
0x0000000851887824ULL, 0x000fe200078e00ffULL, 0xfffffff84d867812ULL, 0x000fe200078ee234ULL,
0x0000000155397824ULL, 0x140fe200078e0272ULL, 0x0000001c72347811ULL, 0x040fe200078fe8ffULL,
0x00000008558c7824ULL, 0x000fe200078e00ffULL, 0x0000000353597819ULL, 0x040fe200000006ffULL,
0x0000000153367824ULL, 0x000fe200078e0272ULL, 0xfffffff888887812ULL, 0x000fe200078ee235ULL,
0x0000000137377824ULL, 0x100fe200078e0257ULL, 0xfffffff88c8c7812ULL, 0x000fe200078ee239ULL,
0x000000013b3b7824ULL, 0x100fe200078e0257ULL, 0x0000005772357211ULL, 0x000fe200078fe8ffULL,
0x0000000151517824ULL, 0x100fe200078e0257ULL, 0x000000574f4f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000153537824ULL, 0x100fe200078e0257ULL, 0xfffffff8598a7812ULL, 0x000fe200078ee236ULL,
0x0000000155557824ULL, 0x100fe200078e0257ULL, 0x00000003348e7819ULL, 0x040fe200000006ffULL,
0x0000000134397824ULL, 0x000fe200078e0257ULL, 0x0000007d88837211ULL, 0x000fe200078e20ffULL,
0x000000ffff577224ULL, 0x000fc400078e00ffULL, 0x00000001344d7824ULL, 0x000fe400078e0272ULL,
0x0000010035347825ULL, 0x000fc600078e0056ULL, 0xfffffff88e8e7812ULL, 0x000fe200078ee24dULL,
0x0000010037367825ULL, 0x000fe200078e0056ULL, 0x0000000434347c10ULL, 0x000fc6000ff1e0ffULL,
0x000001003b3a7825ULL, 0x100fe200078e0056ULL, 0x0000000436367c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000535357c10ULL, 0x000fe200087fe4ffULL, 0x000001004f4e7825ULL, 0x100fe200078e0056ULL,
0x0000000537377c10ULL, 0x000fe40008ffe4ffULL, 0x000000043a3a7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000010051507825ULL, 0x100fe200078e0056ULL, 0x000000044e4e7c10ULL, 0x000fe4000ff3e0ffULL,
0x000000053b3b7c10ULL, 0x000fe200087fe4ffULL, 0x0000010053527825ULL, 0x000fe200078e0056ULL,
0x0000000450507c10ULL, 0x000fc4000ff5e0ffULL, 0x000000054f4f7c10ULL, 0x000fe20008ffe4ffULL,
0x0000010055547825ULL, 0x100fe200078e0056ULL, 0x0000000452527c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000551517c10ULL, 0x000fe200097fe4ffULL, 0x0000010039567825ULL, 0x000fe200078e0056ULL,
0x0000007272397211ULL, 0x000fe400078fe8ffULL, 0x0000000454547c10ULL, 0x000fe2000ff3e0ffULL,
0x000000105a4d7824ULL, 0x100fe200078e027dULL, 0x0000000739397812ULL, 0x000fe200078ec0ffULL,
0x0000001082597824ULL, 0x100fe200078e027dULL, 0x0000000456567c10ULL, 0x000fe2000ff5e0ffULL,
0x00000010865b7824ULL, 0x100fe200078e027dULL, 0x0ffffff839587812ULL, 0x000fe200078ef872ULL,
0x000000108a877824ULL, 0x100fe200078e027dULL, 0x0000000553537c10ULL, 0x000fe200087fe4ffULL,
0x000000108c897824ULL, 0x100fe200078e027dULL, 0x0000000555557c10ULL, 0x000fe20008ffe4ffULL,
0x0000001058397824ULL, 0x100fe200078e027dULL, 0x0000000557577c10ULL, 0x000fe200097fe4ffULL,
0x000000108e8b7824ULL, 0x000fc600078e027dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034397faeULL, 0x0003e8000b901c46ULL, 0x00000000364d7faeULL, 0x0003e8000b901c46ULL,
0x000000003a597faeULL, 0x0003e8000b901c46ULL, 0x000000004e5b7faeULL, 0x0003e8000b901c46ULL,
0x0000000050837faeULL, 0x0003e8000b901c46ULL, 0x0000000052877faeULL, 0x0003e8000b901c46ULL,
0x0000000054897faeULL, 0x0003e8000b901c46ULL, 0x00000000568b7faeULL, 0x0003e4000b901c46ULL,
0x000000106f357812ULL, 0x002fe200078ec0ffULL, 0x000000204c4c7824ULL, 0x000fe200078e0273ULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x00000001354c7824ULL, 0x000fca00078e024cULL,
0x0000004c6b3b7211ULL, 0x000fc800078e18ffULL, 0x01e648383b3879a7ULL, 0x0002a6000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01e648393b0075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036344d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09004d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000004d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01e648393b0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000002078347824ULL, 0x000fca00078e00ffULL, 0xffffff8034347812ULL, 0x000fc800078ec0ffULL,
0x0000010073347810ULL, 0x000fc80007ffe034ULL, 0x0000003469347210ULL, 0x000fca0007ffe06aULL,
0x01e0000034367984ULL, 0x000ea80000000800ULL, 0x01e2000034837984ULL, 0x0006e20000000800ULL,
0x000000853600720bULL, 0x004fda0003f1d000ULL, 0x0000000000377806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff3700720cULL, 0x000fda0003f25270ULL,
0x0000000400949947ULL, 0x00afea0003800000ULL, 0x0000000278357811ULL, 0x000fe400078ff0ffULL,
0x000000853600720bULL, 0x000fe40003f14000ULL, 0x000000783500720cULL, 0x000fd60003f25270ULL,
0x0000000000387806ULL, 0x000fe400000e0100ULL, 0x0000007378359211ULL, 0x000fe400078e38ffULL,
0x0000008536349209ULL, 0x000fe40007810000ULL, 0x0000003569359210ULL, 0x000fe40007ffe06aULL,
0x000000ff3800720cULL, 0x000fc60003f05270ULL, 0x01e4003435009388ULL, 0x0003f40000000800ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x0000008536347209ULL, 0x000fe40007810000ULL,
0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL,
0x0000008534347221ULL, 0x000fe20000010100ULL, 0x00ff000038ff7812ULL, 0x040fe4000784c0ffULL,
0xff00000038ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x0000003400357308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x002fcc0000011672ULL, 0x00001f3435347589ULL, 0x004e6400000e0000ULL,
0x0000000434047220ULL, 0x042fe20000410000ULL, 0x0000000534057220ULL, 0x040fe20000410000ULL,
0x0000000834087220ULL, 0x040fe20000410000ULL, 0x0000000934097220ULL, 0x040fe20000410000ULL,
0x0000000c340c7220ULL, 0x040fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x000fce0000410000ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x0000000872347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3435347589ULL, 0x004e6400000e0000ULL, 0x0000000634067220ULL, 0x042fe20000410000ULL,
0x0000000734077220ULL, 0x040fe20000410000ULL, 0x0000000a340a7220ULL, 0x040fe20000410000ULL,
0x0000000b340b7220ULL, 0x040fe20000410000ULL, 0x0000000e340e7220ULL, 0x040fe20000410000ULL,
0x0000000f340f7220ULL, 0x040fe20000410000ULL, 0x0000001234127220ULL, 0x040fe20000410000ULL,
0x0000001334137220ULL, 0x040fe20000410000ULL, 0x0000001634167220ULL, 0x040fe20000410000ULL,
0x0000001734177220ULL, 0x040fe20000410000ULL, 0x0000001a341a7220ULL, 0x040fe20000410000ULL,
0x0000001b341b7220ULL, 0x040fe20000410000ULL, 0x0000001e341e7220ULL, 0x040fe20000410000ULL,
0x0000001f341f7220ULL, 0x040fe20000410000ULL, 0x0000002234227220ULL, 0x040fe20000410000ULL,
0x0000002334237220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000001072347811ULL, 0x002fcc00078ff0ffULL, 0x00001f3435347589ULL, 0x004e6400000e0000ULL,
0x0000002434247220ULL, 0x042fe20000410000ULL, 0x0000002534257220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000004034407220ULL, 0x040fe20000410000ULL, 0x0000004134417220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x040fe20000410000ULL,
0x0000003c343c7220ULL, 0x040fe20000410000ULL, 0x0000003d343d7220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x000fce0000410000ULL,
0x0000003584847220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000001872347811ULL, 0x002fcc00078ff0ffULL, 0x00001f3435347589ULL, 0x000e6400000e0000ULL,
0x0000002634267220ULL, 0x042fe20000410000ULL, 0x0000002734277220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000002b342b7220ULL, 0x040fe20000410000ULL,
0x0000002e342e7220ULL, 0x040fe20000410000ULL, 0x0000002f342f7220ULL, 0x040fe20000410000ULL,
0x0000004234427220ULL, 0x040fe20000410000ULL, 0x0000004334437220ULL, 0x040fe20000410000ULL,
0x0000004a344a7220ULL, 0x040fe20000410000ULL, 0x0000004b344b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x040fe20000410000ULL,
0x0000003e343e7220ULL, 0x040fe20000410000ULL, 0x0000003f343f7220ULL, 0x040fe20000410000ULL,
0x0000003234327220ULL, 0x040fe20000410000ULL, 0x0000003334337220ULL, 0x000fce0000410000ULL,
0x0000003837ff7212ULL, 0x000fe400078030ffULL, 0x0000008536857209ULL, 0x000fd60007810000ULL,
0x8000008536360221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600680308ULL, 0x000ea40000000800ULL, 0x0000006883830220ULL, 0x004fce0000410000ULL,
0x0000000278347824ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000200078367824ULL, 0x000fe200078e00ffULL, 0x0000000434357812ULL, 0x000fe200078ec0ffULL,
0x0000000867387824ULL, 0x000fe400078e00ffULL, 0x0000000866377824ULL, 0x000fe200078e00ffULL,
0xffffc00036367812ULL, 0x000fe200078ec0ffULL, 0x0001400063827836ULL, 0x000fe20000000000ULL,
0x0000003572347211ULL, 0x000fc600078fe0ffULL, 0x0000000173367824ULL, 0x000fe200078e0236ULL,
0x0000003467357210ULL, 0x000fe20007ffe0ffULL, 0x0000000166347824ULL, 0x000fe400078e0234ULL,
0x000020006b367824ULL, 0x000fe200078e0236ULL, 0xfffffff838357812ULL, 0x000fe400078ee235ULL,
0xfffffff837377812ULL, 0x000fe200078ee234ULL, 0x0001600036507836ULL, 0x000fe20000000000ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff5d7819ULL, 0x000fe40000011672ULL,
0x00000068ff34723eULL, 0x000fe400000010ffULL, 0x000000105d5f7810ULL, 0x000fe20007ffe0ffULL,
0x000000085d397836ULL, 0x000fe20000000000ULL, 0x0000541034347816ULL, 0x000fe20000000034ULL,
0x000000185d3b7836ULL, 0x000fc80000000000ULL, 0x00001f3934607589ULL, 0x0002a800000e0000ULL,
0x00001f5f345f7589ULL, 0x0002e800000e0000ULL, 0x00001f5d345d7589ULL, 0x00026800000e0000ULL,
0x00001f3b345e7589ULL, 0x00026400000e0000ULL, 0x0000001035357824ULL, 0x100fe200078e0282ULL,
0x0000005062547211ULL, 0x000fe200078e20ffULL, 0x0000001037387824ULL, 0x000fe400078e0282ULL,
0x00000010644c7824ULL, 0x100fe400078e0250ULL, 0x000000003534783bULL, 0x002e620000000200ULL,
0x0000001065517824ULL, 0x000fc600078e0250ULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000005d34347232ULL, 0x082fe40000200000ULL,
0x0000005d36367232ULL, 0x000fe40000200000ULL, 0x0000006035357232ULL, 0x084fe40000200000ULL,
0x0000006037377232ULL, 0x000fe40000200000ULL, 0x0000005f38387232ULL, 0x088fe40000200000ULL,
0x0000005f3a3a7232ULL, 0x000fc40000200000ULL, 0x0000005e39397232ULL, 0x080fe40000200000ULL,
0x0000005e3b3b7232ULL, 0x000fce0000200000ULL, 0x0000001061587824ULL, 0x000fe200078e0250ULL,
0x000000004c4c783bULL, 0x000f220000004200ULL, 0x000040006e6e7824ULL, 0x000fc600078e0273ULL,
0x000000005150783bULL, 0x000f620000004200ULL, 0x000020006b6e7824ULL, 0x000fc600078e026eULL,
0x000000005454783bULL, 0x000f620000004200ULL, 0x000160006e877836ULL, 0x000fc60000000000ULL,
0x000000005858783bULL, 0x000f620000004200ULL, 0x0000004c3404723cULL, 0x012fec0000041804ULL,
0x0000004e3408723cULL, 0x000fec0000041808ULL, 0x00000050340c723cULL, 0x028fec000004180cULL,
0x000000523410723cULL, 0x000fec0000041810ULL, 0x000000543414723cULL, 0x004fec0000041814ULL,
0x000000563418723cULL, 0x000fec0000041818ULL, 0x00000058341c723cULL, 0x000fec000004181cULL,
0x0000005a3420723cULL, 0x000fec0000041820ULL, 0x0000004c3824723cULL, 0x000fe20000041824ULL,
0x000000827c347211ULL, 0x000fca00078e20ffULL, 0x0000004e3828723cULL, 0x000fe20000041828ULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x000000105c4c7824ULL, 0x000fc800078e0287ULL,
0x00000050382c723cULL, 0x000fec000004182cULL, 0x000000523840723cULL, 0x000fe20000041840ULL,
0x0000001003507824ULL, 0x000fca00078e0287ULL, 0x000000543848723cULL, 0x000fec0000041848ULL,
0x000000563844723cULL, 0x000fe20000041844ULL, 0x0000001002547824ULL, 0x000fca00078e0287ULL,
0x00000058383c723cULL, 0x000fec000004183cULL, 0x0000005a3830723cULL, 0x000fee0000041830ULL,
0x000000107b387824ULL, 0x000fcc00078e0282ULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x0000000000208947ULL, 0x002ff40003800000ULL, 0x0000005d38387232ULL, 0x084fe40000200000ULL,
0x0000005d3a3a7232ULL, 0x000fe40000200000ULL, 0x0000006039397232ULL, 0x080fe40000200000ULL,
0x000000603b3b7232ULL, 0x000fe40000200000ULL, 0x0000005f34347232ULL, 0x080fe40000200000ULL,
0x0000005f36367232ULL, 0x000fc40000200000ULL, 0x0000005e35357232ULL, 0x080fe40000200000ULL,
0x0000005e37377232ULL, 0x000fce0000200000ULL, 0x0000001000587824ULL, 0x000fe200078e0287ULL,
0x000000004c4c783bULL, 0x000e620000004200ULL, 0x000000017a777824ULL, 0x000fe200078e0277ULL,
0x00000002ff007819ULL, 0x000fe20000011678ULL, 0x00000001ff027424ULL, 0x000fe200078e00ffULL,
0x000000005050783bULL, 0x000ee20000004200ULL, 0x0000008483837221ULL, 0x000fe20000010000ULL,
0x000000707700720cULL, 0x000fe40003f06070ULL, 0x000000005454783bULL, 0x000f220000004200ULL,
0x0000007300037211ULL, 0x000fc600078e18ffULL, 0x000000005858783bULL, 0x000f620000004200ULL,
0x01e6980203ff79a7ULL, 0x0003e4000850003fULL, 0x0000004c3804723cULL, 0x006fec0000041804ULL,
0x0000004e3808723cULL, 0x000fec0000041808ULL, 0x00000050380c723cULL, 0x008fec000004180cULL,
0x000000523810723cULL, 0x000fec0000041810ULL, 0x000000543814723cULL, 0x010fec0000041814ULL,
0x000000563818723cULL, 0x000fec0000041818ULL, 0x00000058381c723cULL, 0x020fec000004181cULL,
0x0000005a3820723cULL, 0x000fec0000041820ULL, 0x0000004c3424723cULL, 0x000fec0000041824ULL,
0x0000004e3428723cULL, 0x000fec0000041828ULL, 0x00000050342c723cULL, 0x000fec000004182cULL,
0x000000523440723cULL, 0x000fec0000041840ULL, 0x000000543448723cULL, 0x000fec0000041848ULL,
0x000000563444723cULL, 0x000fec0000041844ULL, 0x00000058343c723cULL, 0x000fec000004183cULL,
0x0000005a3430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000800f40947ULL, 0x000fde0003800000ULL,
0x0000000177037836ULL, 0x000fe20000000000ULL, 0x0000920000047ab9ULL, 0x000fe20000000800ULL,
0x0000010077367824ULL, 0x000fc600078e026dULL, 0x000000700300720cULL, 0x000fe20003f06070ULL,
0x000000046c537c24ULL, 0x000fd8000f8e0236ULL, 0x0000000400888947ULL, 0x000fea0003800000ULL,
0x00000003ff527819ULL, 0x000fe20000011672ULL, 0x000000806b347824ULL, 0x000fe200078e026aULL,
0x0000003671037248ULL, 0x000fe20007fe0000ULL, 0x000000ffff367224ULL, 0x000fe200078e0a36ULL,
0x0000000852587810ULL, 0x000fe20007ffe0ffULL, 0x0000000452387836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000152377824ULL, 0x100fe200078e0253ULL,
0x0000002003037446ULL, 0x000fe20003800036ULL, 0x0000000838567824ULL, 0x000fe200078e00ffULL,
0x0000007238357210ULL, 0x000fe20007ffe0ffULL, 0x0000000152367824ULL, 0x000fe200078e0272ULL,
0x000000033800720cULL, 0x080fe20003f26070ULL, 0x00000001583b7824ULL, 0x100fe200078e0253ULL,
0xfffffff856567812ULL, 0x000fe200078ee235ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x0000000736517812ULL, 0x000fe200078ec0ffULL, 0x0000000138397824ULL, 0x000fe200078e0253ULL,
0x000000035200720cULL, 0x000fe20003f06070ULL, 0x0000010037367825ULL, 0x000fe200078e0034ULL,
0x0ffffff851547812ULL, 0x000fc400078ef872ULL, 0x0000008756577211ULL, 0x000fe200078e20ffULL,
0x0000000c525a7836ULL, 0x000fe20000000000ULL, 0x00000004364e7c10ULL, 0x000fe2000ff5e0ffULL,
0x000001003b3a7825ULL, 0x100fe200078e0034ULL, 0x000000035800720cULL, 0x080fe40003fa6070ULL,
0x00000005374f7c10ULL, 0x000fe200097fe4ffULL, 0x0000010039387825ULL, 0x000fe200078e0034ULL,
0x000000043a367c10ULL, 0x000fe4000ff5e0ffULL, 0x000000035a00720cULL, 0x040fe20003f86070ULL,
0x000000015a4d7824ULL, 0x000fe200078e0253ULL, 0x0000000438507c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001054557824ULL, 0x000fe200078e0287ULL, 0x000000053b377c10ULL, 0x000fe200097fe4ffULL,
0x0000001052547836ULL, 0x000fe20000000000ULL, 0x0000000539517c10ULL, 0x000fe20009ffe4ffULL,
0x000001004d4c7825ULL, 0x000fe200078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004e557faeULL, 0x0003e4000c101c46ULL, 0x00000053543b7210ULL, 0x000fe20007ffe0ffULL,
0x0000001452567836ULL, 0x000fe20000000000ULL, 0x000000044c387c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000050577faeULL, 0x0005e2000c901c46ULL, 0x00000018525c7836ULL, 0x000fc40000000000ULL,
0x000001003b3a7825ULL, 0x000fe200078e0034ULL, 0x000000054d397c10ULL, 0x000fe40009ffe4ffULL,
0x000000035400720cULL, 0x080fe20003f66070ULL, 0x00000001584d7824ULL, 0x140fe200078e0272ULL,
0x000000043a4c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000858587824ULL, 0x000fe200078e00ffULL,
0x000000035600720cULL, 0x0c0fe20003f46070ULL, 0x00000001564f7824ULL, 0x002fe200078e0253ULL,
0x000000035c00720cULL, 0x000fe20003f26070ULL, 0x000000015a4e7824ULL, 0x040fe200078e0272ULL,
0xfffffff858507812ULL, 0x004fe200078ee24dULL, 0x000000085a517824ULL, 0x000fe200078e00ffULL,
0x000000053b4d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001c526e7836ULL, 0x000fe20000000000ULL,
0x000000035c587819ULL, 0x000fe200000006ffULL, 0x000001004f3a7825ULL, 0x000fe200078e0034ULL,
0xfffffff851527812ULL, 0x000fc400078ee24eULL, 0x000000036e00720cULL, 0x000fe20003f06070ULL,
0x00000001544f7824ULL, 0x140fe200078e0272ULL, 0x0000000354547819ULL, 0x000fe200000006ffULL,
0x0000000156517824ULL, 0x040fe200078e0272ULL, 0x000000043a4e7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000856567824ULL, 0x000fe200078e00ffULL, 0xfffffff854547812ULL, 0x000fe200078ee24fULL,
0x000000015c037824ULL, 0x000fe200078e0253ULL, 0x000000053b4f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000086e5a7824ULL, 0x000fe200078e00ffULL, 0xfffffff856567812ULL, 0x000fe200078ee251ULL,
0x00000100033a7825ULL, 0x000fc600078e0034ULL, 0x0000008756557211ULL, 0x000fe200078e20ffULL,
0x000000016e517824ULL, 0x000fe200078e0253ULL, 0x000000043a3a7c10ULL, 0x000fe2000ffde0ffULL,
0x000000015c037824ULL, 0x100fe400078e0272ULL, 0x000000016e537824ULL, 0x000fe200078e0272ULL,
0x000000053b3b7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010051347825ULL, 0x000fe200078e0034ULL,
0xfffffff858587812ULL, 0x000fe400078ee203ULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee253ULL,
0x0000001050037824ULL, 0x100fe200078e0287ULL, 0x0000000434347c10ULL, 0x000fe2000ffde0ffULL,
0x0000001052517824ULL, 0x000fc400078e0287ULL, 0x0000001054537824ULL, 0x100fe200078e0287ULL,
0x0000000535357c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001058577824ULL, 0x100fe200078e0287ULL,
0x0000000036037faeULL, 0x0003e2000e901c46ULL, 0x000000105a877824ULL, 0x000fc600078e0287ULL,
0x0000000038517faeULL, 0x0003e8000e101c46ULL, 0x000000004c537faeULL, 0x0003e8000d901c46ULL,
0x000000004e557faeULL, 0x0003e8000d101c46ULL, 0x000000003a577faeULL, 0x0003e8000c901c46ULL,
0x0000000034877faeULL, 0x0003e2000c101c46ULL, 0x0000000400547947ULL, 0x000fea0003800000ULL,
0x0000000472377811ULL, 0x040fe200078fe8ffULL, 0x000000806b527824ULL, 0x000fe200078e026aULL,
0x0000000872397811ULL, 0x040fe200078fe8ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000c723b7811ULL, 0x040fe200078fe8ffULL, 0x0000000137037824ULL, 0x100fe200078e0272ULL,
0x0000000339357819ULL, 0x000fe200000006ffULL, 0x0000000837567824ULL, 0x000fe200078e00ffULL,
0x00000010724d7811ULL, 0x040fe200078fe8ffULL, 0x0000000139347824ULL, 0x100fe200078e0272ULL,
0x00000014724f7811ULL, 0x040fe200078fe8ffULL, 0x000000083b5a7824ULL, 0x040fe200078e00ffULL,
0xfffffff856567812ULL, 0x000fe200078ee203ULL, 0x000000013b037824ULL, 0x100fe200078e0272ULL,
0xfffffff835587812ULL, 0x000fe200078ee234ULL, 0x000000014d347824ULL, 0x140fe200078e0272ULL,
0x0000001872517811ULL, 0x040fe200078fe8ffULL, 0x000000084d557824ULL, 0x000fe200078e00ffULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee203ULL, 0x000000014f357824ULL, 0x140fe200078e0272ULL,
0x000000034f6e7819ULL, 0x000fe200000006ffULL, 0x0000000151367824ULL, 0x140fe200078e0272ULL,
0xfffffff8555c7812ULL, 0x000fe200078ee234ULL, 0x0000000851577824ULL, 0x000fe200078e00ffULL,
0x0000007272037211ULL, 0x040fe200078fe8ffULL, 0x0000000137377824ULL, 0x100fe200078e0253ULL,
0x0000001c72347811ULL, 0x040fe200078fe8ffULL, 0x0000000139397824ULL, 0x100fe200078e0253ULL,
0xfffffff86e6e7812ULL, 0x000fe200078ee235ULL, 0x000000014d4d7824ULL, 0x100fe200078e0253ULL,
0x0000000703557812ULL, 0x000fe200078ec0ffULL, 0x000000014f4f7824ULL, 0x100fe200078e0253ULL,
0x0000005372357211ULL, 0x000fe200078fe8ffULL, 0x0000000151517824ULL, 0x100fe200078e0253ULL,
0x000000533b3b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000134037824ULL, 0x040fe200078e0253ULL,
0xfffffff857827812ULL, 0x000fe200078ee236ULL, 0x000000ffff537224ULL, 0x000fe200078e00ffULL,
0x0000000334847819ULL, 0x040fe200000006ffULL, 0x0000000134577824ULL, 0x000fe200078e0272ULL,
0x0ffffff855547812ULL, 0x000fe200078ef872ULL, 0x0000010035347825ULL, 0x000fe200078e0052ULL,
0x000000875c5b7211ULL, 0x000fc400078e20ffULL, 0xfffffff884847812ULL, 0x000fe200078ee257ULL,
0x0000010037367825ULL, 0x000fe200078e0052ULL, 0x0000000434347c10ULL, 0x000fc6000ff1e0ffULL,
0x0000010039387825ULL, 0x100fe200078e0052ULL, 0x0000000436367c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000535357c10ULL, 0x000fe200087fe4ffULL, 0x000001003b3a7825ULL, 0x100fe200078e0052ULL,
0x0000000438387c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000537377c10ULL, 0x000fe20008ffe4ffULL,
0x000001004d4c7825ULL, 0x100fe200078e0052ULL, 0x000000043a3a7c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000539397c10ULL, 0x000fe200097fe4ffULL, 0x000001004f4e7825ULL, 0x000fe200078e0052ULL,
0x000000044c4c7c10ULL, 0x000fc4000ff1e0ffULL, 0x000000053b3b7c10ULL, 0x000fe20009ffe4ffULL,
0x0000010051507825ULL, 0x100fe200078e0052ULL, 0x000000044e4e7c10ULL, 0x000fe4000ff3e0ffULL,
0x000000054d4d7c10ULL, 0x000fe200087fe4ffULL, 0x0000010003527825ULL, 0x000fe200078e0052ULL,
0x0000000450507c10ULL, 0x000fe4000ff5e0ffULL, 0x000000054f4f7c10ULL, 0x000fe20008ffe4ffULL,
0x0000001054037824ULL, 0x100fe200078e0287ULL, 0x0000000452527c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001056557824ULL, 0x100fe200078e0287ULL, 0x0000000551517c10ULL, 0x000fe200097fe4ffULL,
0x0000001058577824ULL, 0x100fe200078e0287ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034037faeULL, 0x0003e2000b901c46ULL, 0x000000105a597824ULL, 0x100fe200078e0287ULL,
0x0000000553537c10ULL, 0x000fe20009ffe4ffULL, 0x000000106e897824ULL, 0x100fe200078e0287ULL,
0x0000000036557faeULL, 0x0003e2000b901c46ULL, 0x00000010828b7824ULL, 0x000fc400078e0287ULL,
0x0000001084877824ULL, 0x000fe200078e0287ULL, 0x0000000038577faeULL, 0x0003e8000b901c46ULL,
0x000000003a597faeULL, 0x0003e8000b901c46ULL, 0x000000004c5b7faeULL, 0x0003e8000b901c46ULL,
0x000000004e897faeULL, 0x0003e8000b901c46ULL, 0x00000000508b7faeULL, 0x0003e8000b901c46ULL,
0x0000000052877faeULL, 0x0003e4000b901c46ULL, 0x0000002000007824ULL, 0x000fe200078e0273ULL,
0x000000106f397812ULL, 0x042fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000086f037812ULL, 0x000fc800078ec0ffULL, 0x0000000003397210ULL, 0x000fc80007ffe039ULL,
0x01e66802393679a7ULL, 0x0002a6000850003fULL, 0x0000000000027805ULL, 0x002fe20000015200ULL,
0x01e66837390075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x00000034023b7210ULL, 0x000fc80007f1e1ffULL, 0x0000003503357210ULL, 0x000fe400007fe5ffULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011435ULL, 0x0000003b00007211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000200007819ULL, 0x000fc80000001235ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x01e66837390075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000378027811ULL, 0x000fca00078ff0ffULL,
0x0000008002007824ULL, 0x000fca00078e0273ULL, 0x0000000069037210ULL, 0x000fe20007ffe06aULL,
0x000000ffff007224ULL, 0x000fc800078e0085ULL, 0x01e0000003347984ULL, 0x000e680000000800ULL,
0x01e20000035c7984ULL, 0x0004a20000000800ULL, 0x000000853400720bULL, 0x002fda0003f1d000ULL,
0x0000000000357806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff3500720cULL, 0x000fda0003f25270ULL, 0x0000000400909947ULL, 0x004fea0003800000ULL,
0x000000780200720cULL, 0x000fe40003f25270ULL, 0x000000853400720bULL, 0x000fd60003f14000ULL,
0x0000008078039824ULL, 0x000fe200078e0273ULL, 0x0000008534009209ULL, 0x000fe40007810000ULL,
0x0000000000367806ULL, 0x000fe400000e0100ULL, 0x0000000369039210ULL, 0x000fe40007ffe06aULL,
0x000000ff3600720cULL, 0x000fc60003f05270ULL, 0x01e4000003009388ULL, 0x0003f40000000800ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x0000008534007209ULL, 0x000fe40007810000ULL,
0x000000ff36ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0036ff7812ULL, 0x000fe2000782c0ffULL,
0x0000008500007221ULL, 0x000fe20000010100ULL, 0x00ff000036ff7812ULL, 0x040fe4000784c0ffULL,
0xff00000036ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x0000000000387308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fca0000011672ULL, 0x00001f0338007589ULL, 0x006e6400000e0000ULL,
0x0000000400047220ULL, 0x042fe20000410000ULL, 0x0000000500057220ULL, 0x040fe20000410000ULL,
0x0000000800087220ULL, 0x040fe20000410000ULL, 0x0000000900097220ULL, 0x040fe20000410000ULL,
0x0000000c000c7220ULL, 0x040fe20000410000ULL, 0x0000000d000d7220ULL, 0x040fe20000410000ULL,
0x0000001000107220ULL, 0x040fe20000410000ULL, 0x0000001100117220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x000fce0000410000ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x0000000872037811ULL, 0x000fca00078ff0ffULL,
0x00001f0338007589ULL, 0x006e6400000e0000ULL, 0x0000000600067220ULL, 0x042fe20000410000ULL,
0x0000000700077220ULL, 0x040fe20000410000ULL, 0x0000000a000a7220ULL, 0x040fe20000410000ULL,
0x0000000b000b7220ULL, 0x040fe20000410000ULL, 0x0000000e000e7220ULL, 0x040fe20000410000ULL,
0x0000000f000f7220ULL, 0x040fe20000410000ULL, 0x0000001200127220ULL, 0x040fe20000410000ULL,
0x0000001300137220ULL, 0x040fe20000410000ULL, 0x0000001600167220ULL, 0x040fe20000410000ULL,
0x0000001700177220ULL, 0x040fe20000410000ULL, 0x0000001a001a7220ULL, 0x040fe20000410000ULL,
0x0000001b001b7220ULL, 0x040fe20000410000ULL, 0x0000001e001e7220ULL, 0x040fe20000410000ULL,
0x0000001f001f7220ULL, 0x040fe20000410000ULL, 0x0000002200227220ULL, 0x040fe20000410000ULL,
0x0000002300237220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000001072037811ULL, 0x000fca00078ff0ffULL, 0x00001f0338007589ULL, 0x006e6400000e0000ULL,
0x0000002400247220ULL, 0x042fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000004000407220ULL, 0x040fe20000410000ULL, 0x0000004100417220ULL, 0x040fe20000410000ULL,
0x0000004800487220ULL, 0x040fe20000410000ULL, 0x0000004900497220ULL, 0x040fe20000410000ULL,
0x0000004400447220ULL, 0x040fe20000410000ULL, 0x0000004500457220ULL, 0x040fe20000410000ULL,
0x0000003c003c7220ULL, 0x040fe20000410000ULL, 0x0000003d003d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x000fce0000410000ULL,
0x0000003883837220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000001872037811ULL, 0x000fca00078ff0ffULL, 0x00001f0338007589ULL, 0x002e6400000e0000ULL,
0x0000002600267220ULL, 0x042fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x0000002a002a7220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002e002e7220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x040fe20000410000ULL,
0x0000004200427220ULL, 0x040fe20000410000ULL, 0x0000004300437220ULL, 0x040fe20000410000ULL,
0x0000004a004a7220ULL, 0x040fe20000410000ULL, 0x0000004b004b7220ULL, 0x040fe20000410000ULL,
0x0000004600467220ULL, 0x040fe20000410000ULL, 0x0000004700477220ULL, 0x040fe20000410000ULL,
0x0000003e003e7220ULL, 0x040fe20000410000ULL, 0x0000003f003f7220ULL, 0x040fe20000410000ULL,
0x0000003200327220ULL, 0x040fe20000410000ULL, 0x0000003300337220ULL, 0x000fce0000410000ULL,
0x0000003635ff7212ULL, 0x000fe400078030ffULL, 0x0000008534007209ULL, 0x002fd60007810000ULL,
0x8000000034340221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL,
0x0000003400680308ULL, 0x000e640000000800ULL, 0x000000685c5c0220ULL, 0x002fce0000410000ULL,
0x00000001ff6e7819ULL, 0x000fe20000011678ULL, 0x0000100002027824ULL, 0x000fe200078e0273ULL,
0x00000004ff347819ULL, 0x000fe20000011672ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000016e037812ULL, 0x000fe200078ec0ffULL, 0x00000010644c7824ULL, 0x000fe200078e027dULL,
0x0001200002027810ULL, 0x000fe40007ffe0ffULL, 0x0000003403037211ULL, 0x000fe200078e10ffULL,
0x0000000867347824ULL, 0x000fc800078e00ffULL, 0x0000000167677824ULL, 0x100fe400078e0203ULL,
0x0000000166037824ULL, 0x040fe400078e0203ULL, 0x0000000866667824ULL, 0x000fe200078e00ffULL,
0xfffffff834677812ULL, 0x000fc800078ee267ULL, 0xfffffff866037812ULL, 0x000fe200078ee203ULL,
0x0000001067677824ULL, 0x000fc800078e0202ULL, 0x0000001003037824ULL, 0x000fe200078e0202ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff5d7819ULL, 0x000fe40000011672ULL,
0x00000068ff02723eULL, 0x000fe400000010ffULL, 0x000000185d377810ULL, 0x000fe20007ffe0ffULL,
0x000000105d5f7836ULL, 0x000fe20000000000ULL, 0x0000541002027816ULL, 0x000fe20000000002ULL,
0x000000085d357836ULL, 0x000fc80000000000ULL, 0x00001f5f025f7589ULL, 0x0002a800000e0000ULL,
0x00001f3502607589ULL, 0x0002e800000e0000ULL, 0x00001f5d025d7589ULL, 0x00026800000e0000ULL,
0x00001f37025e7589ULL, 0x00026400000e0000ULL, 0x000000006738783bULL, 0x0006a80000000200ULL,
0x000000000334783bULL, 0x0026620000000200ULL, 0x0000000000208947ULL, 0x000fea0003800000ULL,
0x0000005d38387232ULL, 0x084fe40000200000ULL, 0x0000005d3a3a7232ULL, 0x000fe40000200000ULL,
0x0000006039397232ULL, 0x088fe40000200000ULL, 0x000000603b3b7232ULL, 0x000fe40000200000ULL,
0x0000005f34347232ULL, 0x082fe40000200000ULL, 0x0000005f36367232ULL, 0x000fc40000200000ULL,
0x0000005e35357232ULL, 0x080fe40000200000ULL, 0x0000005e37377232ULL, 0x000fce0000200000ULL,
0x000000004c4c783bULL, 0x000f220000004200ULL, 0x0000001065507824ULL, 0x000fe400078e027dULL,
0x000000835c837221ULL, 0x000fe20000010000ULL, 0x0000001062647824ULL, 0x100fe400078e027dULL,
0x0000001061847824ULL, 0x000fe200078e027dULL, 0x000000005050783bULL, 0x000f620000004200ULL,
0x0001500063637836ULL, 0x000fc60000000000ULL, 0x000000006464783bULL, 0x008ee20000004200ULL,
0x000000107b547824ULL, 0x000fc600078e0263ULL, 0x000000008484783bULL, 0x000ee80000004200ULL,
0x000000005454783bULL, 0x000ee20000000200ULL, 0x0000004c3858723cULL, 0x014fec0000041804ULL,
0x0000004e3888723cULL, 0x000fe20000041808ULL, 0x000000637c047211ULL, 0x000fca00078e20ffULL,
0x00000050380c723cULL, 0x020fe2000004180cULL, 0x000000000404783bULL, 0x000eaa0000000200ULL,
0x000000523810723cULL, 0x000fec0000041810ULL, 0x000000643814723cULL, 0x008fec0000041814ULL,
0x000000663818723cULL, 0x000fec0000041818ULL, 0x00000084381c723cULL, 0x000fec000004181cULL,
0x000000863820723cULL, 0x000fec0000041820ULL, 0x0000004c3424723cULL, 0x002fec0000041824ULL,
0x0000004e3428723cULL, 0x000fec0000041828ULL, 0x00000050342c723cULL, 0x000fec000004182cULL,
0x000000523440723cULL, 0x000fec0000041840ULL, 0x000000643448723cULL, 0x000fec0000041848ULL,
0x000000663444723cULL, 0x000fec0000041844ULL, 0x00000084343c723cULL, 0x000fec000004183cULL,
0x000000863430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000208947ULL, 0x004fde0003800000ULL, 0x0000005d54547232ULL, 0x080fe40000200000ULL,
0x0000005d56567232ULL, 0x000fe40000200000ULL, 0x0000006055557232ULL, 0x080fe40000200000ULL,
0x0000006057577232ULL, 0x000fe40000200000ULL, 0x0000005f04047232ULL, 0x080fe40000200000ULL,
0x0000005f06067232ULL, 0x000fc40000200000ULL, 0x0000005e05057232ULL, 0x080fe40000200000ULL,
0x0000005e07077232ULL, 0x000fce0000200000ULL, 0x000000008138783bULL, 0x000e620000004200ULL,
0x0000000278027824ULL, 0x000fe200078e00ffULL, 0x000000707700720cULL, 0x000fe20003f06070ULL,
0x00000001ff037424ULL, 0x000fe200078e00ffULL, 0x00000000804c783bULL, 0x000ea40000004200ULL,
0xfffffff802027812ULL, 0x000fe400078ec0ffULL, 0x000000007f50783bULL, 0x000ee60000004200ULL,
0x0000000173027824ULL, 0x000fe200078e0202ULL, 0x000000007e34783bULL, 0x000f260000004200ULL,
0x01e6a00302ff79a7ULL, 0x000be2000850003fULL, 0x000000385408723cULL, 0x002fec0000041858ULL,
0x0000003a5488723cULL, 0x000fec0000041888ULL, 0x0000004c540c723cULL, 0x004fec000004180cULL,
0x0000004e5410723cULL, 0x000fec0000041810ULL, 0x000000505414723cULL, 0x008fec0000041814ULL,
0x000000525418723cULL, 0x000fec0000041818ULL, 0x00000034541c723cULL, 0x010fec000004181cULL,
0x000000365420723cULL, 0x000fec0000041820ULL, 0x000000380424723cULL, 0x000fec0000041824ULL,
0x0000003a0428723cULL, 0x000fec0000041828ULL, 0x0000004c042c723cULL, 0x000fec000004182cULL,
0x0000004e0440723cULL, 0x000fec0000041840ULL, 0x000000500448723cULL, 0x000fec0000041848ULL,
0x000000520444723cULL, 0x000fec0000041844ULL, 0x00000034043c723cULL, 0x000fec000004183cULL,
0x000000360430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff8c00708947ULL, 0x020fde000383ffffULL, 0x0000000000027919ULL, 0x000e620000002500ULL,
0x00000031004c7202ULL, 0x000fe20000000f00ULL, 0x000000ffff317224ULL, 0x000fe200078e0027ULL,
0x0000002b00357202ULL, 0x000fe20000000f00ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0021ULL,
0x0000001f00277202ULL, 0x000fe20000000f00ULL, 0x000000ffff217224ULL, 0x000fe200078e001bULL,
0x00000019001f7202ULL, 0x000fe20000000f00ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0017ULL,
0x000000ffff197224ULL, 0x000fe200078e0015ULL, 0x0000001300157202ULL, 0x000fe20000000f00ULL,
0x000000ffff177224ULL, 0x000fc400078e0014ULL, 0x000000ffff347224ULL, 0x000fe400078e0029ULL,
0x000000ffff147224ULL, 0x000fe400078e0011ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0030ULL,
0x0000002500307202ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e0020ULL,
0x000000ffff117224ULL, 0x000fe400078e0010ULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000000d000f7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3a7224ULL, 0x000fc400078e002eULL,
0x000000ffff387224ULL, 0x000fe400078e002dULL, 0x000000ffff207224ULL, 0x000fe200078e0016ULL,
0x000000700200720cULL, 0x002fe20003f06070ULL, 0x000000ffff107224ULL, 0x000fe400078e000aULL,
0x000000ffff4d7224ULL, 0x000fe400078e0033ULL, 0x000000ffff4e7224ULL, 0x000fe400078e0032ULL,
0x000000ffff397224ULL, 0x000fc400078e002fULL, 0x000000ffff377224ULL, 0x000fe400078e002cULL,
0x000000ffff2d7224ULL, 0x000fe400078e0023ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0022ULL,
0x000000ffff257224ULL, 0x000fe400078e001dULL, 0x000000ffff167224ULL, 0x000fe400078e0012ULL,
0x000000ffff0d7224ULL, 0x000fc400078e000cULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff367224ULL, 0x000fe400078e002aULL, 0x000000ffff337224ULL, 0x000fe400078e0028ULL,
0x000000ffff327224ULL, 0x000fe400078e0026ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0024ULL,
0x000000ffff2c7224ULL, 0x000fc400078e001eULL, 0x000000ffff237224ULL, 0x000fe400078e001cULL,
0x000000ffff227224ULL, 0x000fe400078e001aULL, 0x000000ffff1d7224ULL, 0x000fe400078e0018ULL,
0x000000ffff127224ULL, 0x000fe400078e000eULL, 0x000000ffff0c7224ULL, 0x000fe400078e000bULL,
0x000000ffff097224ULL, 0x000fe200078e0008ULL, 0x0000000400540947ULL, 0x000fec0003800000ULL,
0x0180000083037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000938000047802ULL, 0x000fce0000000f00ULL, 0x000000ec00b47944ULL, 0x000fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000008300047308ULL, 0x000e640000001000ULL,
0xbf80000004037423ULL, 0x002fc80000000083ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000304037223ULL, 0x000fce0000000004ULL, 0x0000000000067919ULL, 0x000f240000000000ULL,
0x00000002ff047819ULL, 0x010fe40000011606ULL, 0x0000000806087811ULL, 0x040fe400078ff0ffULL,
0x00000010060e7811ULL, 0x040fe400078ff0ffULL, 0x0000001806187811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0403047589ULL, 0x000ea800000e0000ULL,
0x00001f0803057589ULL, 0x000ee800000e0000ULL, 0x00001f0e03067589ULL, 0x000f2800000e0000ULL,
0x00001f1803077589ULL, 0x000f6200000e0000ULL, 0x0000000904097220ULL, 0x044fe20000410000ULL,
0x0000000a040a7220ULL, 0x040fe20000410000ULL, 0x0000008804887220ULL, 0x040fe20000410000ULL,
0x0000008904897220ULL, 0x040fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x000fe20000410000ULL, 0x0000001005107220ULL, 0x048fe20000410000ULL,
0x0000000c050c7220ULL, 0x040fe20000410000ULL, 0x0000008a058a7220ULL, 0x040fe20000410000ULL,
0x0000008b058b7220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x040fe20000410000ULL, 0x0000001605167220ULL, 0x040fe20000410000ULL,
0x0000001505157220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002105217220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002d052d7220ULL, 0x000fe20000410000ULL, 0x0000002f062f7220ULL, 0x050fe20000410000ULL,
0x0000003006307220ULL, 0x040fe20000410000ULL, 0x0000003306337220ULL, 0x040fe20000410000ULL,
0x0000003406347220ULL, 0x040fe20000410000ULL, 0x0000003706377220ULL, 0x040fe20000410000ULL,
0x0000003806387220ULL, 0x040fe20000410000ULL, 0x0000004006407220ULL, 0x040fe20000410000ULL,
0x0000004106417220ULL, 0x040fe20000410000ULL, 0x0000004806487220ULL, 0x040fe20000410000ULL,
0x0000004906497220ULL, 0x040fe20000410000ULL, 0x0000004406447220ULL, 0x040fe20000410000ULL,
0x0000004506457220ULL, 0x040fe20000410000ULL, 0x0000003c063c7220ULL, 0x040fe20000410000ULL,
0x0000003d063d7220ULL, 0x040fe20000410000ULL, 0x0000003b063b7220ULL, 0x040fe20000410000ULL,
0x0000004c064c7220ULL, 0x000fe20000410000ULL, 0x0000003207327220ULL, 0x062fe20000410000ULL,
0x0000003107317220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000003507357220ULL, 0x040fe20000410000ULL, 0x0000003a073a7220ULL, 0x040fe20000410000ULL,
0x0000003907397220ULL, 0x040fe20000410000ULL, 0x0000004207427220ULL, 0x040fe20000410000ULL,
0x0000004307437220ULL, 0x040fe20000410000ULL, 0x0000004a074a7220ULL, 0x040fe20000410000ULL,
0x0000004b074b7220ULL, 0x040fe20000410000ULL, 0x0000004607467220ULL, 0x040fe20000410000ULL,
0x0000004707477220ULL, 0x040fe20000410000ULL, 0x0000003e073e7220ULL, 0x040fe20000410000ULL,
0x0000003f073f7220ULL, 0x040fe20000410000ULL, 0x0000004e074e7220ULL, 0x040fe20000410000ULL,
0x0000004d074d7220ULL, 0x000fce0000410000ULL, 0x00000000001c7919ULL, 0x000e620000000000ULL,
0x000000100c10723eULL, 0x000fe200000010ffULL, 0x000020006b737824ULL, 0x000fe200078e0273ULL,
0x000000121312723eULL, 0x000fe200000010ffULL, 0x000010006e0c7824ULL, 0x000fe200078e00ffULL,
0x000000161513723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000222115723eULL, 0x000fc400000010ffULL, 0x0000002c2716723eULL, 0x000fe400000010ffULL,
0x000000444521723eULL, 0x000fe400000010ffULL, 0x0000003c3d22723eULL, 0x000fe400000010ffULL,
0x000000017a00780cULL, 0x000fe40003f05270ULL, 0x0000ffff1c037812ULL, 0x002fe400078ec0ffULL,
0xfffffff8ff057812ULL, 0x000fc400078ee21cULL, 0x00000003ff037819ULL, 0x000fc60000011603ULL,
0x0000000805067836ULL, 0x000fe20000000000ULL, 0x0000000303037812ULL, 0x000fe200078ec0ffULL,
0x0000001005077836ULL, 0x000fe40000000000ULL, 0x0000001805087836ULL, 0x000fe20000000000ULL,
0x00000003064f7819ULL, 0x000fe200000006ffULL, 0x0000000103037824ULL, 0x000fe400078e021cULL,
0x00000008050b7824ULL, 0x000fe200078e00ffULL, 0x00000003082a7819ULL, 0x040fe200000006ffULL,
0x0000000807517824ULL, 0x000fe200078e00ffULL, 0x0000000703047812ULL, 0x040fe200078ec0ffULL,
0x0000000808537824ULL, 0x000fe200078e00ffULL, 0x0000000403037812ULL, 0x000fe200078e3cffULL,
0x0000000805187824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe200078ee204ULL,
0x00000008061e7824ULL, 0x000fe200078e00ffULL, 0xfffffff84f1a7812ULL, 0x000fe200078ee204ULL,
0x0000000807267824ULL, 0x000fe200078e00ffULL, 0xfffffff851247812ULL, 0x000fc400078ee204ULL,
0xfffffff853287812ULL, 0x000fe400078ee204ULL, 0x0000000703037812ULL, 0x000fe400078ec0ffULL,
0x000000090a04723eULL, 0x000fe400000010ffULL, 0x0000001d1f09723eULL, 0x000fe200000010ffULL,
0x00000001731d7824ULL, 0x000fe200078e020cULL, 0xfffffff818187812ULL, 0x000fe400078ee203ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL, 0x000000100e0e7824ULL, 0x100fe200078e021dULL,
0xfffffff826267812ULL, 0x000fe200078ee203ULL, 0x0000001024247824ULL, 0x100fe200078e021dULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee203ULL, 0x000000101e1e7824ULL, 0x100fe200078e021dULL,
0x000000888905723eULL, 0x000fe200000010ffULL, 0x0000001026267824ULL, 0x100fe200078e021dULL,
0x0000000d0f06723eULL, 0x000fe200000010ffULL, 0x000000101a0d7824ULL, 0x100fe200078e021dULL,
0x000000111407723eULL, 0x000fe200000010ffULL, 0x0000001028287824ULL, 0x000fe200078e021dULL,
0x000000171908723eULL, 0x000fc400000010ffULL, 0x00000023250a723eULL, 0x000fe200000010ffULL,
0x000000040e007844ULL, 0x0003e20000000200ULL, 0x000000292b0b723eULL, 0x000fe400000010ffULL,
0x0000001d18037211ULL, 0x000fe400078e20ffULL, 0x0000008a8b11723eULL, 0x000fe400000010ffULL,
0x000000201b14723eULL, 0x000fe200000010ffULL, 0x0000000803007844ULL, 0x0005e20000000200ULL,
0x0000002e2d17723eULL, 0x000fc400000010ffULL, 0x0000002f3018723eULL, 0x000fe200000010ffULL,
0x000000100d007844ULL, 0x0007e20000000200ULL, 0x000000333419723eULL, 0x000fe400000010ffULL,
0x00000037381a723eULL, 0x000fe200000010ffULL, 0x000000141e007844ULL, 0x000fe20000000200ULL,
0x00000040411b723eULL, 0x000fe400000010ffULL, 0x000000484920723eULL, 0x000fe400000010ffULL,
0x0000003b4c23723eULL, 0x000fe200000010ffULL, 0x0000001824007844ULL, 0x000fe20000000200ULL,
0x000000323104723eULL, 0x002fe200000010ffULL, 0x000000ff00037306ULL, 0x004e620000202400ULL,
0x000000363505723eULL, 0x000fe200000010ffULL, 0x0000002026007844ULL, 0x000fe20000000200ULL,
0x0000003a3906723eULL, 0x000fe200000010ffULL, 0x000000016d0d7824ULL, 0x008fe200078e021cULL,
0x000000424307723eULL, 0x000fc400000010ffULL, 0x0000004a4b08723eULL, 0x000fe200000010ffULL,
0x000000100d0e7824ULL, 0x000fe200078e0273ULL, 0x000000464709723eULL, 0x000fe200000010ffULL,
0x0000000428007844ULL, 0x000fe20000000200ULL, 0x0000003e3f0a723eULL, 0x000fe400000010ffULL,
0x0000004e4d0b723eULL, 0x000fe400000010ffULL, 0x0000001d2a2a7211ULL, 0x000fca00078e20ffULL,
0x000000082a007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000e107984ULL, 0x000e680000000c00ULL, 0x000400000e2c7984ULL, 0x000ea80000000c00ULL,
0x000800000e347984ULL, 0x000ee80000000c00ULL, 0x000c00000e207984ULL, 0x000f280000000c00ULL,
0x001000000e147984ULL, 0x000f680000000c00ULL, 0x001400000e307984ULL, 0x000f280000000c00ULL,
0x001800000e187984ULL, 0x000f280000000c00ULL, 0x001c00000e047984ULL, 0x000f620000000c00ULL,
0x0000001303137230ULL, 0x002fc40000200800ULL, 0x0000001203127230ULL, 0x040fe40000200800ULL,
0x0000001103117230ULL, 0x040fe40000200800ULL, 0x0000001003107230ULL, 0x040fe40000200800ULL,
0x0000002f032f7230ULL, 0x044fe40000200800ULL, 0x0000002e032e7230ULL, 0x040fe40000200800ULL,
0x0000002d032d7230ULL, 0x000fc40000200800ULL, 0x0000002c032c7230ULL, 0x040fe40000200800ULL,
0x0000003703377230ULL, 0x048fe40000200800ULL, 0x0000003603367230ULL, 0x040fe40000200800ULL,
0x0000003503357230ULL, 0x040fe40000200800ULL, 0x0000003403347230ULL, 0x040fe40000200800ULL,
0x0000002303237230ULL, 0x010fc40000200800ULL, 0x0000002203227230ULL, 0x040fe40000200800ULL,
0x0000002103217230ULL, 0x040fe40000200800ULL, 0x0000002003037230ULL, 0x000fe40000200800ULL,
0x0000001713137230ULL, 0x020fe40000200000ULL, 0x0000001612127230ULL, 0x000fe40000200000ULL,
0x0000001511117230ULL, 0x000fc40000200000ULL, 0x0000001410107230ULL, 0x000fe40000200000ULL,
0x000000332f2f7230ULL, 0x000fe40000200000ULL, 0x000000322e2e7230ULL, 0x000fe20000200000ULL,
0x000000100e007388ULL, 0x0003e20000000c00ULL, 0x000000312d2d7230ULL, 0x000fe40000200000ULL,
0x000000302c2c7230ULL, 0x000fe40000200000ULL, 0x0000001b37377230ULL, 0x000fc40000200000ULL,
0x0000001a36367230ULL, 0x000fe20000200000ULL, 0x0004002c0e007388ULL, 0x0003e20000000c00ULL,
0x0000001935357230ULL, 0x000fe40000200000ULL, 0x0000001834347230ULL, 0x000fe40000200000ULL,
0x0000000723237230ULL, 0x000fe40000200000ULL, 0x0000000622227230ULL, 0x000fe20000200000ULL,
0x000800340e007388ULL, 0x0003e20000000c00ULL, 0x0000000521217230ULL, 0x000fc40000200000ULL,
0x0000000403207230ULL, 0x000fca0000200000ULL, 0x000c00200e007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000003400e08947ULL, 0x000fea0003800000ULL,
0x00000400ff117b82ULL, 0x002e620000000800ULL, 0x0000000000087919ULL, 0x000ea20000002600ULL,
0x000000400d077836ULL, 0x000fe40000000000ULL, 0x000000800d097836ULL, 0x000fe20000000000ULL,
0x0000000000057919ULL, 0x000ea20000002700ULL, 0x000000c00d0b7836ULL, 0x000fe40000000000ULL,
0x00009400ff047b82ULL, 0x000e620000000800ULL, 0x000000000e187984ULL, 0x0006e80000000c00ULL,
0x000400000e207984ULL, 0x0006e60000000c00ULL, 0x00009800ff2c7b82ULL, 0x000f220000000a00ULL,
0x000800000e247984ULL, 0x0006e80000000c00ULL, 0x000c00000e287984ULL, 0x0006e20000000c00ULL,
0x0000000411037224ULL, 0x002fc800078e02ffULL, 0x0000007a03067224ULL, 0x040fe200078e02ffULL,
0x0000000f03047811ULL, 0x000fe200078e10ffULL, 0x0000001105117224ULL, 0x004fc600078e0208ULL,
0xfffffff004137812ULL, 0x000fe200078ec0ffULL, 0x0000007a111f7224ULL, 0x000fc800078e02ffULL,
0x0000008006157824ULL, 0x040fe400078e0213ULL, 0x000000011f0a7824ULL, 0x000fe400078e0202ULL,
0x0000008006067824ULL, 0x000fc800078e0215ULL, 0x0000007f06067836ULL, 0x000fca0000000000ULL,
0xffffff8006177812ULL, 0x000fc800078ec0ffULL, 0x0000002c17037210ULL, 0x010fc80007f1e0ffULL,
0x000000030a027211ULL, 0x040fe400078268ffULL, 0x0000002dff037210ULL, 0x000fe400007fe4ffULL,
0x000000016eff7812ULL, 0x000fe4000780f878ULL, 0x000000030a037211ULL, 0x000fe400008f6cffULL,
0x0000002c13127210ULL, 0x000fe20007f3e0ffULL, 0x000010006b027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fc800078e0002ULL, 0x0000001007067825ULL, 0x000fc800078e0002ULL,
0x0000001009087825ULL, 0x000fc800078e0002ULL, 0x000000100b027825ULL, 0x000fc800078e0002ULL,
0x000000ffff0d7224ULL, 0x000fe200008e062dULL, 0x0000000000400947ULL, 0x008fec0003800000ULL,
0x000000101c0e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe4000001161cULL,
0x000000070a0b7819ULL, 0x000fe400000006ffULL, 0x000000700e0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c10147812ULL, 0x000fe400078ec0ffULL, 0x0000002c0b0e7210ULL, 0x000fe40007ebe015ULL,
0x00000019ff107819ULL, 0x000fc4000001160aULL, 0x000000120f0b7210ULL, 0x000fe40007a3e00bULL,
0x0000000e140e7210ULL, 0x000fe40007c7e00fULL, 0x0000002d100f7210ULL, 0x000fe40002fec4ffULL,
0x0000000b140a7210ULL, 0x000fe40007fbe0ffULL, 0x0000000dff107210ULL, 0x000fe40000fe4410ULL,
0x0000000fff0f7210ULL, 0x000fc60001fe84ffULL, 0x000000ffff0b7224ULL, 0x000fca00028e0610ULL,
0x000000000a007986ULL, 0x0003e8000c101906ULL, 0x000000830e007986ULL, 0x0003e4000c101906ULL,
0x000000ff1c00720cULL, 0x000fe20000705670ULL, 0x0000001804007986ULL, 0x0005e8000c101d06ULL,
0x0000002006007986ULL, 0x0005e8000c101d06ULL, 0x0000002408007986ULL, 0x0005e8000c101d06ULL,
0x0000002802007986ULL, 0x0005e2000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x00009800ff027b82ULL, 0x004ea20000000a00ULL,
0xffffffff7a057836ULL, 0x000fe40000000000ULL, 0x0000000411027825ULL, 0x004fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000005020279a8ULL, 0x00052200099ee1c6ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000050200720cULL, 0x010fc80003f05270ULL,
0x00000001ff007807ULL, 0x002fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000000ff007988ULL, 0x0003e60008000004ULL, 0x0000000000007919ULL, 0x002e620000008800ULL,
0x0000040000217802ULL, 0x004fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000065400217816ULL, 0x002fca0000000021ULL,
0x0000000021007984ULL, 0x000e640000000000ULL, 0x000000ff0000720cULL, 0x002fda0003f05270ULL,
0x0000003000648947ULL, 0x000fea0003800000ULL, 0x000000ff7800720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff7a00720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x000000101c007824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fe4000001161cULL, 0x000000121f027211ULL, 0x040fe400078038ffULL,
0x0000007000037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fe400078ec0ffULL,
0x0000000d1f007211ULL, 0x000fe400000f3cffULL, 0x0000000204027210ULL, 0x000fc8000791e003ULL,
0x00000000ff037210ULL, 0x000fca00007e24ffULL, 0x0000000602007981ULL, 0x000328000c1e1900ULL,
0x0000800602077981ULL, 0x000322000c1e1900ULL, 0x000000027a00780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x002fea0003800000ULL, 0x0001000602097981ULL, 0x000322000c1e1900ULL,
0x000000047a00780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x00018006020b7981ULL, 0x000322000c1e1900ULL, 0x000000047a00780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x002fea0003800000ULL, 0x00020006020d7981ULL, 0x000322000c1e1900ULL,
0x000000067a00780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x002fea0003800000ULL,
0x00028006020f7981ULL, 0x000322000c1e1900ULL, 0x000000067a00780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x002fea0003800000ULL, 0x000000087a00780cULL, 0x000fe20003f06070ULL,
0x0003000602117981ULL, 0x000318000c1e1900ULL, 0x0003800602190981ULL, 0x000324000c1e1900ULL,
0x000000077a027836ULL, 0x002fca0000000000ULL, 0x00000003ff047819ULL, 0x000fc80000011602ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x000000131f1b7211ULL, 0x040fe200078038ffULL, 0x000000ffff057224ULL, 0x010fe200078e0000ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000002c1b1b7210ULL, 0x000fe40007f3e0ffULL, 0x000000ff1f067211ULL, 0x000fe400000f3cffULL,
0x000007801b1b7810ULL, 0x000fc80007f5e0ffULL, 0x00000006ff067210ULL, 0x000fd200017e242dULL,
0x000000047a007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x0000000504007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000000500007209ULL, 0x000fca0007810000ULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000041c027819ULL, 0x000fe400000006ffULL, 0x00000001ff037819ULL, 0x000fe4000001161cULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021b027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0606ULL,
0xfffc800602057981ULL, 0x000326000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000000700007209ULL, 0x000fca0007810000ULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101c027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001161cULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021b027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0606ULL,
0xfffd000602077981ULL, 0x000326000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000000900007209ULL, 0x000fca0007810000ULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101c027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001161cULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021b027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0606ULL,
0xfffd800602097981ULL, 0x000326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000000b00007209ULL, 0x000fca0007810000ULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000041c027819ULL, 0x002fe400000006ffULL, 0x00000001ff037819ULL, 0x000fe4000001161cULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021b027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0606ULL,
0xfffe0006020b7981ULL, 0x000326000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x0000000d00007209ULL, 0x000fca0007810000ULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101c027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001161cULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021b027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0606ULL,
0xfffe8006020d7981ULL, 0x000326000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x0000000f00007209ULL, 0x000fca0007810000ULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101c027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001161cULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021b027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0606ULL,
0xffff0006020f7981ULL, 0x000326000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001100007209ULL, 0x000fca0007810000ULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000041c027819ULL, 0x002fe400000006ffULL, 0x00000001ff037819ULL, 0x000fe4000001161cULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021b027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0606ULL,
0xffff800602117981ULL, 0x000326000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000001900007209ULL, 0x000fca0007810000ULL,
0x000000087a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000101c027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001161cULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021b027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0606ULL,
0x0000000602197981ULL, 0x000326000c1e1900ULL, 0x000004001b1b7810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc8000fffe03fULL, 0x000000ffff067224ULL, 0x000fe200008e0606ULL,
0xfffffff8002c8947ULL, 0x000fee000383ffffULL, 0x00000000001c7919ULL, 0x000ea40000000000ULL,
0x000000101c027824ULL, 0x006fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001161cULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000002103037210ULL, 0x000fca0007ffe002ULL, 0x0000000003007388ULL, 0x0103e40000000800ULL,
0x00009800ff267b82ULL, 0x000ea20000000a00ULL, 0x000000071c00780cULL, 0x000fe20003f04070ULL,
0x000040006e227824ULL, 0x100fe200078e0221ULL, 0x0000000c78787819ULL, 0x000fe200000006ffULL,
0x000000101c247824ULL, 0x000fe200078e00ffULL, 0x000000016e077812ULL, 0x000fe200078ec0ffULL,
0x000020006b227824ULL, 0x000fe200078e0222ULL, 0x000000201c097810ULL, 0x000fe20007ffe0ffULL,
0x000000401c0b7836ULL, 0x000fe20000000000ULL, 0x00000001ff237819ULL, 0x000fe2000001161cULL,
0x000000601c0d7836ULL, 0x000fe20000000000ULL, 0x0000007024247812ULL, 0x000fe200078ec0ffULL,
0x000000801c0f7836ULL, 0x000fe20000000000ULL, 0x0000000c23237812ULL, 0x000fe200078ec0ffULL,
0x000002006e088824ULL, 0x140fe200078e0221ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000002006e008824ULL, 0x042fe200078e0221ULL, 0x0000002123257210ULL, 0x000fe20007ffe024ULL,
0x000000a01c117836ULL, 0x000fe20000000000ULL, 0x000000086b088211ULL, 0x040fe200078e40ffULL,
0x000001006b068824ULL, 0x000fe200078e0200ULL, 0x0000100078007812ULL, 0x000fe200078ee2ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002617027210ULL, 0x004fe20007f3e0ffULL,
0x000000016e177824ULL, 0x000fe200078e021fULL, 0x0000002613207210ULL, 0x000fe20007f7e0ffULL,
0x00000080071b8824ULL, 0x040fe200078e0206ULL, 0x0000000025257984ULL, 0x000e620000000800ULL,
0x000000ffff037224ULL, 0x000fe200008e0627ULL, 0x00000026151e7210ULL, 0x000fe20007f3e0ffULL,
0x0000008007298824ULL, 0x000fe200078e0208ULL, 0x000010000c077812ULL, 0x000fe200078ec0ffULL,
0x0000200017047825ULL, 0x000fe200078e0002ULL, 0x0000001b1c1b8211ULL, 0x000fc400078e20ffULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000722077210ULL, 0x000fe20007ffe0ffULL,
0x000000c01c137836ULL, 0x000fe20000000000ULL, 0x0000000004047210ULL, 0x000fe20007f5e0ffULL,
0x000000e01c157836ULL, 0x000fe20000000000ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x000000101c197824ULL, 0x000fe200078e0207ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff057224ULL, 0x000fe200010e0605ULL, 0x0000002017168211ULL, 0x040fe200078438ffULL,
0x000000ffff267224ULL, 0x000fe200008e0627ULL, 0x0000001e17148211ULL, 0x000fe200078238ffULL,
0x0000001009067825ULL, 0x000fe200078e0004ULL, 0x0000000000667805ULL, 0x000fc4000001ff00ULL,
0x00000000005e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x000000100b087825ULL, 0x100fe200078e0004ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000100d0a7825ULL, 0x000fe200078e0004ULL, 0x0000000000347805ULL, 0x000fc4000001ff00ULL,
0x0000000000627805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000000100f0c7825ULL, 0x100fe200078e0004ULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000010110e7825ULL, 0x000fe200078e0004ULL, 0x0000000000407805ULL, 0x000fc4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000001013107825ULL, 0x100fe200078e0004ULL, 0x0000000000467805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000001015127825ULL, 0x000fe200078e0004ULL, 0x0000002617158211ULL, 0x000fc400008f3cffULL,
0x00000000004c7805ULL, 0x000fe4000001ff00ULL, 0x0000007a6e00720cULL, 0x000fe20003f26070ULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x000000101c047825ULL, 0x040fe200078e0004ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fe4000001ff00ULL, 0x0000002717178211ULL, 0x000fe200010f3cffULL,
0x000000101c298824ULL, 0x000fe200078e0229ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000004197faeULL, 0x0005e2000b901c46ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x0000000000547805ULL, 0x000fc4000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0038000006197faeULL, 0x0007e2000b901c46ULL, 0x0000000000587805ULL, 0x000fe4000001ff00ULL,
0x00000000005a7805ULL, 0x000fe4000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0058000008197faeULL, 0x000fe8000b901c46ULL, 0x007800000a197faeULL, 0x000fe2000b901c46ULL,
0x000000101c048825ULL, 0x004fc600078e0014ULL, 0x009800000c197faeULL, 0x000fe2000b901c46ULL,
0x000000101c068825ULL, 0x008fc600078e0016ULL, 0x00b800000e197faeULL, 0x000fe8000b901c46ULL,
0x00d8000010197faeULL, 0x000fe8000b901c46ULL, 0x00f8000012197faeULL, 0x000fe8000b901c46ULL,
0x08580000041b8faeULL, 0x000fe8000b901c46ULL, 0x0818000006298faeULL, 0x0005e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000287805ULL, 0x004fe2000001ff00ULL,
0x0000001000781947ULL, 0x002fec0003800000ULL, 0x00000003ff077819ULL, 0x000fe2000001161cULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0xfffffff8ff067812ULL, 0x000fe200078ee21cULL,
0x000000ffff7b7224ULL, 0x000fe200078e006eULL, 0x0000000307057812ULL, 0x000fe400078ec0ffULL,
0x000000041c047810ULL, 0x000fe20007ffe007ULL, 0x0000000806077836ULL, 0x000fe20000000000ULL,
0x0000001806097810ULL, 0x000fe20007ffe0ffULL, 0x0000001006087836ULL, 0x000fe20000000000ULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x00000008060b7824ULL, 0x040fe200078e00ffULL,
0x00000002ff7c7819ULL, 0x100fe2000001161cULL, 0x0000000807697824ULL, 0x000fe200078e00ffULL,
0x0000000306067819ULL, 0x000fe200000006ffULL, 0x00000008080d7824ULL, 0x040fe200078e00ffULL,
0xfffffff80b6a7812ULL, 0x000fe200078ee204ULL, 0x00000008096f7824ULL, 0x000fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe200078ee204ULL, 0x0000000105057824ULL, 0x000fe200078e021cULL,
0xfffffff80d6c7812ULL, 0x000fe200078ee204ULL, 0x0000000807707824ULL, 0x000fe200078e00ffULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee204ULL, 0x0000000808727824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x000fe200078ec0ffULL, 0x0000000809787824ULL, 0x000fc400078e00ffULL,
0x000002006e047824ULL, 0x000fe200078e0221ULL, 0xfffffff870707812ULL, 0x000fe200078ee205ULL,
0x000000087c7e7836ULL, 0x000fe20000000000ULL, 0xfffffff806717812ULL, 0x000fe200078ee205ULL,
0x000000107c7f7836ULL, 0x000fe20000000000ULL, 0xfffffff872727812ULL, 0x000fe200078ee205ULL,
0x000000187c777836ULL, 0x000fe20000000000ULL, 0xfffffff878787812ULL, 0x000fe400078ee205ULL,
0x000000046b7d7211ULL, 0x000fce00078e40ffULL, 0x000000017b067836ULL, 0x000fca0000000000ULL,
0x0000007a0600720cULL, 0x000fda0003f06070ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x000000071c00780cULL, 0x000fe20003f44070ULL, 0x000000011f177824ULL, 0x000fe200078e0206ULL,
0x0000000106187812ULL, 0x040fe200078ec0ffULL, 0x0000100006067824ULL, 0x000fe200078e00ffULL,
0x000000401c0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000200017047825ULL, 0x000fe200078e0002ULL,
0x000000e01c157810ULL, 0x000fe40007ffe0ffULL, 0x0000100006077812ULL, 0x000fe200078ec0ffULL,
0x000000201c097836ULL, 0x000fe20000000000ULL, 0x0000000004047210ULL, 0x000fe20007f1e0ffULL,
0x000000601c0d7836ULL, 0x000fc40000000000ULL, 0x000000216e08a211ULL, 0x000fe200078e48ffULL,
0x0000000122077824ULL, 0x000fe200078e0207ULL, 0x000000201716a211ULL, 0x040fe200078238ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000001e1714a211ULL, 0x000fe200078038ffULL,
0x000000801c0f7836ULL, 0x000fe40000000000ULL, 0x000000a01c117836ULL, 0x000fe40000000000ULL,
0x000000c01c137836ULL, 0x000fe40000000000ULL, 0x000000101c197824ULL, 0x000fc400078e0207ULL,
0x000001006b7da824ULL, 0x000fe400078e0208ULL, 0x000000101c067825ULL, 0x000fc800078e0004ULL,
0x0000001009087825ULL, 0x100fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000006197faeULL, 0x0003e6000b901c46ULL, 0x000000100b0a7825ULL, 0x100fe200078e0004ULL,
0x0038000008197faeULL, 0x0003e6000b901c46ULL, 0x000000100d0c7825ULL, 0x100fe200078e0004ULL,
0x005800000a197faeULL, 0x0003e6000b901c46ULL, 0x000000100f0e7825ULL, 0x100fe200078e0004ULL,
0x007800000c197faeULL, 0x0003e6000b901c46ULL, 0x0000001011107825ULL, 0x100fe200078e0004ULL,
0x009800000e197faeULL, 0x0003e6000b901c46ULL, 0x0000001013127825ULL, 0x100fe200078e0004ULL,
0x00b8000010197faeULL, 0x0003e6000b901c46ULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x000000261715a211ULL, 0x040fe200000f3cffULL, 0x00d8000012197faeULL, 0x0003e2000b901c46ULL,
0x000000271717a211ULL, 0x000fe200008f3cffULL, 0x00000080181ba824ULL, 0x000fc400078e027dULL,
0x000000801881a824ULL, 0x000fe200078e027dULL, 0x00f8000004197faeULL, 0x0003e2000b901c46ULL,
0x000000101c14a825ULL, 0x000fc800078e0014ULL, 0x000000101c1ba824ULL, 0x040fe400078e021bULL,
0x000000101c16a825ULL, 0x000fc600078e0016ULL, 0x08580000141bafaeULL, 0x0003e2000b901c46ULL,
0x000000101c81a824ULL, 0x000fca00078e0281ULL, 0x081800001681afaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000010007b047824ULL, 0x002fca00078e00ffULL,
0x0000100004057812ULL, 0x000fe400078ec0ffULL, 0x000000077b047819ULL, 0x000fe200000006ffULL,
0x000000027b7b7836ULL, 0x000fe20000000000ULL, 0x0000018022197810ULL, 0x000fe40007ffe005ULL,
0x0000008004047812ULL, 0x000fe400078ec0ffULL, 0x00000019720c7211ULL, 0x000fe200078e20ffULL,
0x000000106a107824ULL, 0x100fe200078e0219ULL, 0x0000007d24047210ULL, 0x000fe20007ffe004ULL,
0x0000001071147824ULL, 0x100fe200078e0219ULL, 0x0000007a7b00720cULL, 0x000fe20003f06070ULL,
0x000000106c807824ULL, 0x000fc400078e0219ULL, 0x00000001231a7824ULL, 0x000fe400078e0204ULL,
0x0000001070047824ULL, 0x000fe200078e0219ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x0000001078187824ULL, 0x100fe400078e0219ULL,
0x0000001069087824ULL, 0x100fe200078e0219ULL, 0x008180001a907984ULL, 0x000ea20000000800ULL,
0x000000106f817824ULL, 0x000fc600078e0219ULL, 0x008580001a997984ULL, 0x000fe80000000800ULL,
0x000000001414783bULL, 0x000ee80000000200ULL, 0x000000000404783bULL, 0x000fe80000000200ULL,
0x000000000c0c783bULL, 0x000f280000000200ULL, 0x000000001818783bULL, 0x000f680000000200ULL,
0x000000000808783bULL, 0x000f620000000200ULL, 0x00007632108a7816ULL, 0x042fe2000000008aULL,
0x00010000108b7824ULL, 0x000fe200078e00ffULL, 0x00007632118c7816ULL, 0x040fe2000000008cULL,
0x00010000118d7824ULL, 0x000fc400078e00ffULL, 0x0000009025107221ULL, 0x004fe20000010100ULL,
0x00007632128e7816ULL, 0x040fe2000000008eULL, 0x00010000128f7824ULL, 0x000fe200078e00ffULL,
0x0000763213907816ULL, 0x040fe20000000090ULL, 0x3fb8aa3b10967820ULL, 0x000fe20000410000ULL,
0x0001000013917824ULL, 0x000fe200078e00ffULL, 0x000000108e8e7819ULL, 0x000fe200000006ffULL,
0x000000008110783bULL, 0x000e620000000200ULL, 0x0000009600987308ULL, 0x000ea20000000800ULL,
0x0000763214827816ULL, 0x048fe20000000082ULL, 0x0001000014837824ULL, 0x000fe200078e00ffULL,
0x0000763215847816ULL, 0x040fe20000000084ULL, 0x0001000015857824ULL, 0x000fe200078e00ffULL,
0x0000763216867816ULL, 0x040fe20000000086ULL, 0x0001000016877824ULL, 0x000fe200078e00ffULL,
0x0000763217887816ULL, 0x040fe20000000088ULL, 0x0001000082827824ULL, 0x000fe200078e00ffULL,
0x0000001017897819ULL, 0x000fe200000006ffULL, 0x000100000e9b7824ULL, 0x010fe200078e00ffULL,
0x000000008014783bULL, 0x0007e20000000200ULL, 0x0000001004937819ULL, 0x000fe200000006ffULL,
0x000100000f9c7824ULL, 0x040fe200078e00ffULL, 0x000076320e9a7816ULL, 0x000fe2000000009aULL,
0x0000009998a87220ULL, 0x004fe20000410000ULL, 0x000076320f0e7816ULL, 0x000fe2000000000eULL,
0x0001000018a17824ULL, 0x020fe200078e00ffULL, 0x0000763206927816ULL, 0x000fe20000000092ULL,
0x00000067a8677221ULL, 0x000fe20000010000ULL, 0x00001f7ca8a97589ULL, 0x000ea200000e0000ULL,
0x0000763204807816ULL, 0x008fe20000000080ULL, 0x0001000006957824ULL, 0x000fe200078e00ffULL,
0x0000763205047816ULL, 0x040fe20000000004ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x0000763207067816ULL, 0x000fe20000000006ULL, 0x0001000019a27824ULL, 0x000fe200078e00ffULL,
0x0000763208947816ULL, 0x000fe20000000094ULL, 0x0001000004047824ULL, 0x000fe200078e00ffULL,
0x000076320a967816ULL, 0x000fe20000000096ULL, 0x0001000008817824ULL, 0x000fe200078e00ffULL,
0x000000100a977819ULL, 0x000fe200000006ffULL, 0x000100000c997824ULL, 0x040fe200078e00ffULL,
0x000076320c987816ULL, 0x000fe20000000098ULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x000000101aa37819ULL, 0x000fe200000006ffULL, 0x0001000084847824ULL, 0x000fe200078e00ffULL,
0x0000763209087816ULL, 0x040fe20000000008ULL, 0x0001000009097824ULL, 0x000fe200078e00ffULL,
0x0000763210a47816ULL, 0x042fe200000000a4ULL, 0x0001000010a57824ULL, 0x000fe200078e00ffULL,
0x000076320b0a7816ULL, 0x040fe2000000000aULL, 0x000100000b0b7824ULL, 0x000fe200078e00ffULL,
0x000076320d0c7816ULL, 0x000fe2000000000cULL, 0x000000a9825d7223ULL, 0x084fe2000001005dULL,
0x000000a9835e7223ULL, 0x000fe2000001005eULL, 0x00001f7ea8827589ULL, 0x000e6200000e0000ULL,
0x0000763211107816ULL, 0x000fe20000000010ULL, 0x000100000d0d7824ULL, 0x000fe200078e00ffULL,
0x0000763212a67816ULL, 0x000fe200000000a6ULL, 0x00001f7fa8837589ULL, 0x000ea200000e0000ULL,
0x00007632140f7816ULL, 0x000fe2000000000fULL, 0x00010000169f7824ULL, 0x040fe200078e00ffULL,
0x00007632169e7816ULL, 0x000fe2000000009eULL, 0x00001f77a8a87589ULL, 0x000ee200000e0000ULL,
0x0000763217167816ULL, 0x040fe20000000016ULL, 0x0001000017a07824ULL, 0x000fe200078e00ffULL,
0x0000763218177816ULL, 0x000fe20000000017ULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x0000763219187816ULL, 0x000fe20000000018ULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x00000010149d7819ULL, 0x000fe200000006ffULL, 0x0001000086867824ULL, 0x000fe200078e00ffULL,
0x000076321a197816ULL, 0x000fe20000000019ULL, 0x0001000088887824ULL, 0x000fe200078e00ffULL,
0x0000763215147816ULL, 0x040fe20000000014ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x000076321b1a7816ULL, 0x040fe2000000001aULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x0000763213a77816ULL, 0x000fe200000000a7ULL, 0x0000008205587223ULL, 0x082fe20000010058ULL,
0x0000008204577223ULL, 0x080fe20000010057ULL, 0x000100000e057824ULL, 0x000fe200078e00ffULL,
0x0000001013137819ULL, 0x000fe200000006ffULL, 0x000100000f047824ULL, 0x000fe200078e00ffULL,
0x0000001094947819ULL, 0x000fe200000006ffULL, 0x0000008207507223ULL, 0x000fe20000010050ULL,
0x000000109a9a7819ULL, 0x000fe200000006ffULL, 0x0000008305347223ULL, 0x084fe20000010034ULL,
0x0000008304297223ULL, 0x000fe20000010029ULL, 0x0000001017177819ULL, 0x000fe200000006ffULL,
0x000100008a8a7824ULL, 0x000fe200078e00ffULL, 0x0000001010107819ULL, 0x000fe200000006ffULL,
0x000100008c8c7824ULL, 0x000fc400078e00ffULL, 0x000000a9855a7223ULL, 0x080fe2000001005aULL,
0x0001000090907824ULL, 0x000fe400078e00ffULL, 0x000000a984597223ULL, 0x080fe20000010059ULL,
0x0001000080807824ULL, 0x000fe400078e00ffULL, 0x000000a987567223ULL, 0x080fe20000010056ULL,
0x0001000092927824ULL, 0x000fe400078e00ffULL, 0x000000a986557223ULL, 0x000fe20000010055ULL,
0x0001000006067824ULL, 0x000fc400078e00ffULL, 0x000000a989527223ULL, 0x080fe20000010052ULL,
0x0001000008087824ULL, 0x000fe400078e00ffULL, 0x000000a988517223ULL, 0x080fe20000010051ULL,
0x0001000096967824ULL, 0x000fe400078e00ffULL, 0x000000a98b4e7223ULL, 0x080fe2000001004eULL,
0x000100000a0a7824ULL, 0x000fe400078e00ffULL, 0x000000a98a4d7223ULL, 0x000fe2000001004dULL,
0x0001000098987824ULL, 0x000fc400078e00ffULL, 0x000000a98d4a7223ULL, 0x080fe2000001004aULL,
0x000100000c0c7824ULL, 0x000fe400078e00ffULL, 0x000000a98c497223ULL, 0x080fe20000010049ULL,
0x0001000014057824ULL, 0x000fe400078e00ffULL, 0x000000a98f467223ULL, 0x080fe20000010046ULL,
0x000100009e077824ULL, 0x000fe400078e00ffULL, 0x000000a98e457223ULL, 0x000fe20000010045ULL,
0x0001000016167824ULL, 0x000fc400078e00ffULL, 0x000000a991427223ULL, 0x080fe20000010042ULL,
0x0001000018187824ULL, 0x000fe400078e00ffULL, 0x000000a990417223ULL, 0x000fe20000010041ULL,
0x0001000019047824ULL, 0x000fe400078e00ffULL, 0x00000082935c7223ULL, 0x080fe2000001005cULL,
0x000100001a1a7824ULL, 0x000fe400078e00ffULL, 0x00000082805b7223ULL, 0x000fe2000001005bULL,
0x00010000a4a47824ULL, 0x000fc400078e00ffULL, 0x0000008295547223ULL, 0x080fe20000010054ULL,
0x00010000a6a67824ULL, 0x000fe400078e00ffULL, 0x0000008292537223ULL, 0x080fe20000010053ULL,
0x00010000a7a77824ULL, 0x000fe400078e00ffULL, 0x00000082064f7223ULL, 0x080fe2000001004fULL,
0x00000082814c7223ULL, 0x080fe2000001004cULL, 0x00000082944b7223ULL, 0x080fe2000001004bULL,
0x0000008209487223ULL, 0x080fe20000010048ULL, 0x0000008208477223ULL, 0x080fe20000010047ULL,
0x0000008297447223ULL, 0x080fe20000010044ULL, 0x0000008296437223ULL, 0x080fe20000010043ULL,
0x000000820b407223ULL, 0x080fe20000010040ULL, 0x000000820a3f7223ULL, 0x000fe2000001003fULL,
0x00000083993e7223ULL, 0x080fe2000001003eULL, 0x00000083983d7223ULL, 0x080fe2000001003dULL,
0x000000830d3a7223ULL, 0x080fe2000001003aULL, 0x000000830c397223ULL, 0x080fe20000010039ULL,
0x000000839b387223ULL, 0x080fe20000010038ULL, 0x000000839a377223ULL, 0x080fe20000010037ULL,
0x000000839c357223ULL, 0x080fe20000010035ULL, 0x000000839d2a7223ULL, 0x080fe2000001002aULL,
0x0000008315287223ULL, 0x080fe20000010028ULL, 0x0000008305307223ULL, 0x080fe20000010030ULL,
0x000000839f667223ULL, 0x080fe20000010066ULL, 0x00000083072e7223ULL, 0x080fe2000001002eULL,
0x00000083a0657223ULL, 0x080fe20000010065ULL, 0x00000083162b7223ULL, 0x000fe2000001002bULL,
0x000000a8a1647223ULL, 0x088fe20000010064ULL, 0x000000a8173c7223ULL, 0x080fe2000001003cULL,
0x000000a8a23b7223ULL, 0x080fe2000001003bULL, 0x000000a818637223ULL, 0x080fe20000010063ULL,
0x000000a8a3627223ULL, 0x080fe20000010062ULL, 0x000000a804617223ULL, 0x080fe20000010061ULL,
0x000000a81b367223ULL, 0x080fe20000010036ULL, 0x000000a81a337223ULL, 0x080fe20000010033ULL,
0x000000a8a5327223ULL, 0x080fe20000010032ULL, 0x000000a8a4317223ULL, 0x080fe20000010031ULL,
0x000000a811607223ULL, 0x080fe20000010060ULL, 0x000000a8105f7223ULL, 0x080fe2000001005fULL,
0x000000a8122f7223ULL, 0x080fe2000001002fULL, 0x000000a8a62d7223ULL, 0x080fe2000001002dULL,
0x000000a8132c7223ULL, 0x080fe2000001002cULL, 0x000000a8a7687223ULL, 0x000fe20000010068ULL,
0xfffffff000108947ULL, 0x000fec000383ffffULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff6b00720cULL, 0x000fe20003f05270ULL, 0x0000898021027836ULL, 0x000fe40000000000ULL,
0x0000001000037824ULL, 0x002fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007003057812ULL, 0x000fe400078ec0ffULL, 0x0000000c00067812ULL, 0x000fc600078ec0ffULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000216e217211ULL, 0x000fe200078e38ffULL, 0x0000001000037824ULL, 0x002fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fc80000011600ULL, 0x0000007003007812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ec0ffULL, 0x0000002104007210ULL, 0x000fca0007ffe000ULL,
0x0089806700007388ULL, 0x0003e40000000800ULL, 0x0000000206027210ULL, 0x000fe20007ffe005ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002007984ULL, 0x002e680000000800ULL,
0x0000800002037984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000300007221ULL, 0x004fc80000010000ULL, 0x0180000000037836ULL, 0x000fca0000000000ULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff837224ULL, 0x000fe200078e0000ULL, 0x0000cb5000047802ULL, 0x000fce0000000f00ULL,
0x000000b400c07944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0003ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000000037308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000003ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203027223ULL, 0x000fce0000000003ULL, 0x00000000001c7919ULL, 0x000ea40000000000ULL,
0x00000002ff077819ULL, 0x004fe4000001161cULL, 0x000000081c037811ULL, 0x040fe400078ff0ffULL,
0x000000101c157811ULL, 0x040fe200078ff0ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0702007589ULL, 0x000ea200000e0000ULL, 0x000000181c097811ULL, 0x000fc400078ff0ffULL,
0x0000ffff1c197812ULL, 0x000fe200078ec0ffULL, 0x00001f0302037589ULL, 0x000ee200000e0000ULL,
0xfffffff8ff1f7812ULL, 0x000fe400078ee21cULL, 0x00000003ff197819ULL, 0x000fe20000011619ULL,
0x00001f1502157589ULL, 0x000f2400000e0000ULL, 0x000000081f217836ULL, 0x000fe20000000000ULL,
0x00000003191b7812ULL, 0x000fe200078ec0ffULL, 0x00001f0902187589ULL, 0x000f6200000e0000ULL,
0x000000101f237836ULL, 0x000fc40000000000ULL, 0x000000181f247836ULL, 0x000fe20000000000ULL,
0x0000001c1b1b7210ULL, 0x000fe20007ffe0ffULL, 0x000000081f257824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000821277824ULL, 0x000fe400078e00ffULL,
0x0000005a00057220ULL, 0x044fe20000410000ULL, 0x0000005900067220ULL, 0x040fe20000410000ULL,
0x0000005e00047220ULL, 0x000fe20000410000ULL, 0x0000005c030c7220ULL, 0x048fe20000410000ULL,
0x0000005b035b7220ULL, 0x040fe20000410000ULL, 0x00000058030d7220ULL, 0x040fe20000410000ULL,
0x00000057030e7220ULL, 0x040fe20000410000ULL, 0x0000005403547220ULL, 0x040fe20000410000ULL,
0x0000005303537220ULL, 0x040fe20000410000ULL, 0x00000050030f7220ULL, 0x040fe20000410000ULL,
0x0000004f03107220ULL, 0x040fe20000410000ULL, 0x0000004c034c7220ULL, 0x040fe20000410000ULL,
0x0000004b034b7220ULL, 0x040fe20000410000ULL, 0x0000004803117220ULL, 0x040fe20000410000ULL,
0x0000004703127220ULL, 0x040fe20000410000ULL, 0x0000004403447220ULL, 0x040fe20000410000ULL,
0x0000004303437220ULL, 0x040fe20000410000ULL, 0x0000004003137220ULL, 0x040fe20000410000ULL,
0x0000003f03147220ULL, 0x000fe20000410000ULL, 0x0000003e153e7220ULL, 0x050fe20000410000ULL,
0x0000003d153d7220ULL, 0x040fe20000410000ULL, 0x0000003a153a7220ULL, 0x040fe20000410000ULL,
0x0000003915397220ULL, 0x040fe20000410000ULL, 0x0000003815387220ULL, 0x040fe20000410000ULL,
0x0000003715377220ULL, 0x040fe20000410000ULL, 0x0000003515357220ULL, 0x040fe20000410000ULL,
0x0000003415347220ULL, 0x040fe20000410000ULL, 0x0000002a152a7220ULL, 0x040fe20000410000ULL,
0x0000002915297220ULL, 0x040fe20000410000ULL, 0x0000002815287220ULL, 0x040fe20000410000ULL,
0x0000003015037220ULL, 0x040fe20000410000ULL, 0x0000006615667220ULL, 0x040fe20000410000ULL,
0x0000002e15177220ULL, 0x040fe20000410000ULL, 0x0000006515657220ULL, 0x040fe20000410000ULL,
0x0000002b15167220ULL, 0x000fe20000410000ULL, 0x0000002d181e7220ULL, 0x062fe20000410000ULL,
0x0000006418647220ULL, 0x040fe20000410000ULL, 0x0000003c18157220ULL, 0x040fe20000410000ULL,
0x0000003b183b7220ULL, 0x040fe20000410000ULL, 0x00000063181a7220ULL, 0x040fe20000410000ULL,
0x0000006218627220ULL, 0x040fe20000410000ULL, 0x0000006118617220ULL, 0x040fe20000410000ULL,
0x0000003618367220ULL, 0x040fe20000410000ULL, 0x0000003318337220ULL, 0x040fe20000410000ULL,
0x0000003218327220ULL, 0x040fe20000410000ULL, 0x0000003118317220ULL, 0x040fe20000410000ULL,
0x0000006018607220ULL, 0x040fe20000410000ULL, 0x0000005f185f7220ULL, 0x040fe20000410000ULL,
0x0000002f182f7220ULL, 0x040fe20000410000ULL, 0x0000002c182c7220ULL, 0x040fe20000410000ULL,
0x0000006818197220ULL, 0x000fe20000410000ULL, 0x00000008232b7824ULL, 0x000fe200078e00ffULL,
0x000000071b187812ULL, 0x040fe200078ec0ffULL, 0x00000008242d7824ULL, 0x000fe200078e00ffULL,
0x000000041b1b7812ULL, 0x000fe200078e3cffULL, 0x0000005d005d7220ULL, 0x040fe20000410000ULL,
0xfffffff825207812ULL, 0x000fe200078ee218ULL, 0x0000005600567220ULL, 0x040fe20000410000ULL,
0xfffffff827227812ULL, 0x000fe200078ee218ULL, 0x0000005500557220ULL, 0x040fe20000410000ULL,
0xfffffff82b267812ULL, 0x000fe200078ee218ULL, 0x0000005200077220ULL, 0x040fe20000410000ULL,
0xfffffff82d307812ULL, 0x000fe200078ee218ULL, 0x0000005100087220ULL, 0x040fe20000410000ULL,
0x000000031f187819ULL, 0x000fe200000006ffULL, 0x0000004e004e7220ULL, 0x040fe20000410000ULL,
0x000000071b1b7812ULL, 0x000fe200078ec0ffULL, 0x0000004d004d7220ULL, 0x040fe20000410000ULL,
0x0000004a00097220ULL, 0x040fe20000410000ULL, 0x0000004900027220ULL, 0x040fe20000410000ULL,
0x00000046000a7220ULL, 0x040fe20000410000ULL, 0x0000004500457220ULL, 0x040fe20000410000ULL,
0x00000042000b7220ULL, 0x040fe20000410000ULL, 0x0000004100007220ULL, 0x000fe20000410000ULL,
0xfffffff818187812ULL, 0x000fe200078ee21bULL, 0x00000008212e7824ULL, 0x000fe200078e00ffULL,
0x000000050605723eULL, 0x000fe200000010ffULL, 0x00000008233c7824ULL, 0x000fe200078e00ffULL,
0x000000045d04723eULL, 0x000fe200000010ffULL, 0x0000001020207824ULL, 0x100fe200078e021dULL,
0x000000565506723eULL, 0x000fe200000010ffULL, 0x0000000824407824ULL, 0x000fe200078e00ffULL,
0x000000070807723eULL, 0x000fe200000010ffULL, 0x0000001018187824ULL, 0x100fe200078e021dULL,
0x0000004e4d08723eULL, 0x000fe200000010ffULL, 0x0000001030307824ULL, 0x000fe200078e021dULL,
0x000000090209723eULL, 0x000fe200000010ffULL, 0x0000000420007844ULL, 0x0003e20000000200ULL,
0x0000000a450a723eULL, 0x000fc400000010ffULL, 0x0000000b000b723eULL, 0x000fe200000010ffULL,
0x0000001022007824ULL, 0x100fe200078e021dULL, 0x0000000d0e0d723eULL, 0x000fe400000010ffULL,
0xfffffff82e247812ULL, 0x000fe200078ee21bULL, 0x0000000818007844ULL, 0x000fe20000000200ULL,
0x0000000c5b0c723eULL, 0x000fe400000010ffULL, 0x00000054530e723eULL, 0x000fe200000010ffULL,
0x0000001024247824ULL, 0x000fe200078e021dULL, 0x0000000f100f723eULL, 0x000fc400000010ffULL,
0xfffffff83c2e7812ULL, 0x000fe400078ee21bULL, 0xfffffff8403c7812ULL, 0x000fe200078ee21bULL,
0x0000000c00007844ULL, 0x0005e20000000200ULL, 0x000000111211723eULL, 0x000fe200000010ffULL,
0x000000102e2e7824ULL, 0x100fe200078e021dULL, 0x0000004c4b10723eULL, 0x000fe200000010ffULL,
0x000000103c3c7824ULL, 0x000fe200078e021dULL, 0x000000444312723eULL, 0x000fe400000010ffULL,
0x000000131413723eULL, 0x000fc400000010ffULL, 0x0000001d26027211ULL, 0x000fe400078e20ffULL,
0x0000003e3d04723eULL, 0x002fe200000010ffULL, 0x0000001024007844ULL, 0x000fe20000000200ULL,
0x0000003a3905723eULL, 0x000fe400000010ffULL, 0x000000383706723eULL, 0x000fe400000010ffULL,
0x000000353407723eULL, 0x000fe400000010ffULL, 0x0000001c6d007210ULL, 0x004fc40007ffe0ffULL,
0x0000002a2920723eULL, 0x000fe200000010ffULL, 0x0000000402007844ULL, 0x000fe20000000200ULL,
0x000000280321723eULL, 0x000fe200000010ffULL, 0x0000001000037824ULL, 0x000fe200078e0273ULL,
0x000000661722723eULL, 0x000fe200000010ffULL, 0x000000ff00007306ULL, 0x000e620000202400ULL,
0x000000651623723eULL, 0x000fe400000010ffULL, 0x000000641564723eULL, 0x000fe400000010ffULL,
0x0000003b1a65723eULL, 0x000fe200000010ffULL, 0x000000202e007844ULL, 0x000fe20000000200ULL,
0x000000626166723eULL, 0x000fc400000010ffULL, 0x000000363367723eULL, 0x000fe400000010ffULL,
0x000000323108723eULL, 0x000fe400000010ffULL, 0x000000605f09723eULL, 0x000fe200000010ffULL,
0x0000006430007844ULL, 0x000fe20000000200ULL, 0x0000002f1e0a723eULL, 0x000fe400000010ffULL,
0x0000002c190b723eULL, 0x000fca00000010ffULL, 0x000000083c007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000030c7984ULL, 0x000e680000000c00ULL,
0x0004000003147984ULL, 0x000ea80000000c00ULL, 0x0008000003247984ULL, 0x000ee80000000c00ULL,
0x000c000003207984ULL, 0x000f280000000c00ULL, 0x0010000003107984ULL, 0x000f680000000c00ULL,
0x0014000003187984ULL, 0x000f280000000c00ULL, 0x0018000003047984ULL, 0x000f280000000c00ULL,
0x001c000003287984ULL, 0x000f620000000c00ULL, 0x0000000f000f7230ULL, 0x002fc40000200800ULL,
0x0000000e000e7230ULL, 0x040fe40000200800ULL, 0x0000000d000d7230ULL, 0x040fe40000200800ULL,
0x0000000c000c7230ULL, 0x040fe40000200800ULL, 0x0000001700177230ULL, 0x044fe40000200800ULL,
0x0000001600167230ULL, 0x040fe40000200800ULL, 0x0000001500157230ULL, 0x000fc40000200800ULL,
0x0000001400147230ULL, 0x040fe40000200800ULL, 0x0000002700277230ULL, 0x048fe40000200800ULL,
0x0000002600267230ULL, 0x040fe40000200800ULL, 0x0000002500257230ULL, 0x040fe40000200800ULL,
0x0000002400247230ULL, 0x040fe40000200800ULL, 0x0000002300237230ULL, 0x010fc40000200800ULL,
0x0000002200227230ULL, 0x040fe40000200800ULL, 0x0000002100217230ULL, 0x040fe40000200800ULL,
0x0000002000207230ULL, 0x000fe40000200800ULL, 0x000000130f0f7230ULL, 0x020fe40000200000ULL,
0x000000120e0e7230ULL, 0x000fe40000200000ULL, 0x000000110d0d7230ULL, 0x000fc40000200000ULL,
0x000000100c0c7230ULL, 0x000fe40000200000ULL, 0x0000001b17177230ULL, 0x000fe40000200000ULL,
0x0000001a16167230ULL, 0x000fe20000200000ULL, 0x0000000c03007388ULL, 0x0003e20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000200000ULL, 0x0000001814147230ULL, 0x000fe40000200000ULL,
0x0000000727277230ULL, 0x000fc40000200000ULL, 0x0000000626267230ULL, 0x000fe20000200000ULL,
0x0004001403007388ULL, 0x0003e20000000c00ULL, 0x0000000525257230ULL, 0x000fe40000200000ULL,
0x0000000424247230ULL, 0x000fe40000200000ULL, 0x0000002b23237230ULL, 0x000fe40000200000ULL,
0x0000002a22227230ULL, 0x000fe20000200000ULL, 0x0008002403007388ULL, 0x0003e20000000c00ULL,
0x0000002921217230ULL, 0x000fc40000200000ULL, 0x0000002820207230ULL, 0x000fca0000200000ULL,
0x000c002003007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff6e00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x00000003ff037819ULL, 0x002fe2000001161cULL,
0x0000840000057ab9ULL, 0x000fc60000000800ULL, 0x000000760300720cULL, 0x000fe20003f06070ULL,
0x00000005040472a4ULL, 0x004fd8000f8e023fULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103007824ULL, 0x000fe200078e021cULL, 0x00008600000a7ab9ULL, 0x000fe20000000800ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x0000880000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000a05057299ULL, 0x000fe2000800063fULL, 0x0000000700057812ULL, 0x000fe200078ec0ffULL,
0x0000002079007824ULL, 0x000fe200078e0203ULL, 0x000000071c0a7812ULL, 0x000fe200078ec0ffULL,
0x000000201c0b7836ULL, 0x000fe20000000000ULL, 0x0ffffff805047812ULL, 0x000fe400078ef81cULL,
0x0000000500037c12ULL, 0x000fe2000f8e30ffULL, 0x000000086b097824ULL, 0x000fe200078e020aULL,
0x0000000aff027c19ULL, 0x000fe20008011600ULL, 0x0000001004047824ULL, 0x000fc400078e0273ULL,
0x0000000174037824ULL, 0x000fe400078e0203ULL, 0x0000000475007c24ULL, 0x000fe4000f8e02ffULL,
0x0000000004047984ULL, 0x000e620000000c00ULL, 0x0000007502037224ULL, 0x000fca00078e0203ULL,
0x0000000300037210ULL, 0x000fc80007f1e0ffULL, 0x000000ffff087210ULL, 0x000fe400007fe4ffULL,
0x0000000803027c11ULL, 0x000fc8000f8040ffULL, 0x0000000903037c11ULL, 0x000fe400080f4408ULL,
0x00000003ff087819ULL, 0x000fe2000001160bULL, 0x0000001009027825ULL, 0x000fc600078e0002ULL,
0x000000760800720cULL, 0x000fe40003f06070ULL, 0x0000000402007986ULL, 0x0023f6000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010b027824ULL, 0x102fe400078e0208ULL,
0x0000002079087824ULL, 0x000fc600078e0208ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000508037c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff802027812ULL, 0x000fe400078ef80bULL,
0x0000000aff087c19ULL, 0x000fe40008011608ULL, 0x0000000374037210ULL, 0x000fe20007ffe0ffULL,
0x0000001002047824ULL, 0x000fc800078e0273ULL, 0x0000007508037224ULL, 0x000fe200078e0203ULL,
0x000000070b087812ULL, 0x000fe200078ec0ffULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0x000000401c0b7836ULL, 0x000fe40000000000ULL, 0x0000000300037210ULL, 0x000fe20007f1e0ffULL,
0x000000086b097824ULL, 0x000fe400078e0208ULL, 0x00000003ff087819ULL, 0x000fe4000001160bULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fe400080f440aULL, 0x000000760800720cULL, 0x000fe20003f06070ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0023ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010b027824ULL, 0x002fe200078e0208ULL,
0x0000000879087211ULL, 0x000fc800078e28ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000508037c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff802027812ULL, 0x000fe400078ef80bULL,
0x0000000aff087c19ULL, 0x000fe20008011608ULL, 0x0000000174037824ULL, 0x000fe400078e0203ULL,
0x0000001002047824ULL, 0x000fe400078e0273ULL, 0x0000007508037224ULL, 0x000fe200078e0203ULL,
0x000000070b087812ULL, 0x000fe200078ec0ffULL, 0x000000601c0b7836ULL, 0x000fc40000000000ULL,
0x0000000004047984ULL, 0x000e620000000c00ULL, 0x0000000300037210ULL, 0x000fe20007f1e0ffULL,
0x000000086b097824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc6000001160bULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fe400080f440aULL, 0x000000760800720cULL, 0x000fe20003f06070ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0023ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010b027824ULL, 0x102fe400078e0208ULL,
0x0000002079087824ULL, 0x000fc600078e0208ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000508037c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff802027812ULL, 0x000fe400078ef80bULL,
0x0000000aff087c19ULL, 0x000fe20008011608ULL, 0x0000000174037824ULL, 0x000fe200078e0203ULL,
0x0000007302047211ULL, 0x000fc600078e20ffULL, 0x0000007508037224ULL, 0x000fe200078e0203ULL,
0x000000070b087812ULL, 0x000fe200078ec0ffULL, 0x000000801c0b7836ULL, 0x000fe20000000000ULL,
0x0000000004047984ULL, 0x000e640000000c00ULL, 0x0000000300037210ULL, 0x000fe20007f1e0ffULL,
0x000000086b097824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc6000001160bULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fe400080f440aULL, 0x000000760800720cULL, 0x000fe20003f06070ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0023ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000080b027210ULL, 0x002fe20007ffe0ffULL,
0x0000002079087824ULL, 0x000fc600078e0208ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000508037c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff802027812ULL, 0x000fe400078ef80bULL,
0x0000000aff087c19ULL, 0x000fe20008011608ULL, 0x0000000174037824ULL, 0x000fe400078e0203ULL,
0x0000001002047824ULL, 0x000fe400078e0273ULL, 0x0000007508037224ULL, 0x000fe200078e0203ULL,
0x000000070b087812ULL, 0x000fe200078ec0ffULL, 0x000000a01c0b7836ULL, 0x000fc40000000000ULL,
0x0000000004047984ULL, 0x000e620000000c00ULL, 0x0000000300037210ULL, 0x000fe40007f1e0ffULL,
0x000000086b097211ULL, 0x000fe400078e18ffULL, 0x00000003ff087819ULL, 0x000fe2000001160bULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fe400080f440aULL, 0x000000760800720cULL, 0x000fe20003f06070ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0023ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010b027824ULL, 0x102fe400078e0208ULL,
0x0000002079087824ULL, 0x000fc600078e0208ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000508037c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff802027812ULL, 0x000fe400078ef80bULL,
0x0000000aff087c19ULL, 0x000fe20008011608ULL, 0x0000000174037824ULL, 0x000fe400078e0203ULL,
0x0000001002047824ULL, 0x000fe400078e0273ULL, 0x0000007508037224ULL, 0x000fe200078e0203ULL,
0x000000070b087812ULL, 0x000fc400078ec0ffULL, 0x000000c01c0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000004047984ULL, 0x000e620000000c00ULL, 0x0000000300037210ULL, 0x000fe20007f1e0ffULL,
0x000000086b097824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc6000001160bULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fe400080f440aULL, 0x000000760800720cULL, 0x000fe20003f06070ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0023ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010b027824ULL, 0x102fe200078e0208ULL,
0x000000e01c1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000002079087824ULL, 0x000fc600078e0208ULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x0000000508037c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff802027812ULL, 0x000fe400078ef80bULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000000174037824ULL, 0x000fe200078e0203ULL, 0x00000003ff0a7819ULL, 0x000fe2000001161cULL,
0x0000001002047824ULL, 0x000fe400078e0273ULL, 0x0000007508037224ULL, 0x000fe200078e0203ULL,
0x000000070b087812ULL, 0x000fe200078ec0ffULL, 0x000000011c0b7824ULL, 0x000fc400078e020aULL,
0x0000000004047984ULL, 0x000e620000000c00ULL, 0x0000000300037210ULL, 0x000fe20007f1e0ffULL,
0x000000086b097824ULL, 0x000fe200078e0208ULL, 0x000000070b0b7812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x040fe4000f8040ffULL,
0xfffffff80b087812ULL, 0x000fe400078ef81cULL, 0x0000000903037c11ULL, 0x000fe400080f440cULL,
0x000000760a00720cULL, 0x000fe20003f06070ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x0023ee000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001008087824ULL, 0x000fe400078e0273ULL, 0x00000020790a7824ULL, 0x000fc600078e020aULL,
0x0000000008047984ULL, 0x002e640000000c00ULL, 0x000000050a037c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff0a7c19ULL, 0x000fe4000801160aULL, 0x0000000374037210ULL, 0x000fca0007ffe0ffULL,
0x000000750a037224ULL, 0x000fca00078e0203ULL, 0x0000000300037210ULL, 0x000fe40007f1e0ffULL,
0x000000071c007812ULL, 0x000fc600078ec0ffULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x0000000803027c11ULL, 0x000fe2000f8040ffULL, 0x000000086b6b7824ULL, 0x000fc600078e0200ULL,
0x0000000903037c11ULL, 0x000fc600080f440aULL, 0x000000106b027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000177097836ULL, 0x000fe20000000000ULL, 0x0000000678747819ULL, 0x000fe200000006ffULL,
0x0000000213027824ULL, 0x000fe200078e00ffULL, 0x0000920000047ab9ULL, 0x000fe20000000800ULL,
0x00000001ff047424ULL, 0x000fe200078e00ffULL, 0x000000700900720cULL, 0x000fe20003f06070ULL,
0x0000010077097824ULL, 0x000fe400078e0274ULL, 0x0000000702027224ULL, 0x000fe400078e026cULL,
0x01e60004730479a7ULL, 0x0002a4000850003fULL, 0x00000004022c7c24ULL, 0x000fcc000f8e0209ULL,
0x0000000c00248947ULL, 0x000fea0003800000ULL, 0x00000003ff2d7819ULL, 0x100fe20000011672ULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000971067248ULL, 0x000fe40007fe0000ULL,
0x000000102d0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000042d077836ULL, 0x000fe20000000000ULL,
0x00000006091c7210ULL, 0x000fe20007ffe1ffULL, 0x000000012c067824ULL, 0x040fe200078e022dULL,
0x0000001c2d297810ULL, 0x000fe20007ffe0ffULL, 0x0000000107087824ULL, 0x040fe200078e0272ULL,
0x0000001c0700720cULL, 0x040fe20003fa6070ULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x00000003292a7819ULL, 0x000fe200000006ffULL, 0x000000082d0b7836ULL, 0x000fe20000000000ULL,
0x000000382d2b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0xfffffff80d1e7812ULL, 0x000fe200078ee208ULL, 0x000000012c087824ULL, 0x000fc400078e0207ULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x000000010b097824ULL, 0x140fe200078e0272ULL,
0x0000007006107812ULL, 0x000fe200078ef803ULL, 0x000000080b207824ULL, 0x000fe400078e00ffULL,
0x0000000c2d0d7836ULL, 0x000fe20000000000ULL, 0x0000000410107c10ULL, 0x000fe2000ff1e0ffULL,
0x000000010f067824ULL, 0x100fe200078e0272ULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000001c0d00720cULL, 0x040fe40003f46070ULL,
0xfffffff813247812ULL, 0x000fe200078ee206ULL, 0x000000010d0a7824ULL, 0x040fe200078e0272ULL,
0x0000007008127812ULL, 0x000fe200078ef803ULL, 0x000000080d117824ULL, 0x000fe200078e00ffULL,
0x0000000b2c067210ULL, 0x000fe20007ffe0ffULL, 0x000000142d197836ULL, 0x000fe20000000000ULL,
0x0000000412127c10ULL, 0x000fe2000ff3e0ffULL, 0x000000012c087824ULL, 0x040fe200078e020dULL,
0xfffffff811227812ULL, 0x000fe200078ee20aULL, 0x000000012c0a7824ULL, 0x000fe200078e020fULL,
0x0000000507117c10ULL, 0x000fe200087fe4ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000509137c10ULL, 0x000fc40008ffe4ffULL, 0x0000001c0b00720cULL, 0x080fe20003f26070ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007006147812ULL, 0x000fe400078ef803ULL,
0x0000001c0f00720cULL, 0x000fe20003f06070ULL, 0x000000012c0c7824ULL, 0x000fe200078e0219ULL,
0x0000000414147c10ULL, 0x000fe2000ff7e0ffULL, 0x000000182d1b7836ULL, 0x000fe20000000000ULL,
0x000000700a0a7812ULL, 0x000fe200078ef803ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000507157c10ULL, 0x000fc40009ffe4ffULL, 0x000000040a0a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fe400078ef803ULL,
0x000000050b0b7c10ULL, 0x000fe20009ffe4ffULL, 0x000000012c0e7824ULL, 0x000fe200078e021bULL,
0x0000007008167812ULL, 0x000fe200078ef803ULL, 0x0000400078067824ULL, 0x000fe200078e0273ULL,
0x000000040c0c7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000012c077824ULL, 0x000fe200078e0229ULL,
0x0000000416167c10ULL, 0x000fe2000ff9e0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000050d0d7c10ULL, 0x000fc40009ffe4ffULL, 0x0000000509177c10ULL, 0x000fe2000a7fe4ffULL,
0x00002000061d7836ULL, 0x000fe20000000000ULL, 0x000000700e0e7812ULL, 0x000fe200078ef803ULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000001c1900720cULL, 0x080fe40003f66070ULL,
0x00000072191a7210ULL, 0x000fe20007ffe0ffULL, 0x000000012d087824ULL, 0x100fe200078e0272ULL,
0x0000007006187812ULL, 0x000fe200078ef803ULL, 0x000000202d237836ULL, 0x000fe20000000000ULL,
0x000000040e0e7c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0x0000000708097812ULL, 0x000fe200078ec0ffULL, 0x000000012c067824ULL, 0x000fe200078e0223ULL,
0x0000000418187c10ULL, 0x000fe2000ffde0ffULL, 0x000000242d257836ULL, 0x000fe20000000000ULL,
0x000000050f0f7c10ULL, 0x000fe2000a7fe4ffULL, 0x000000282d277836ULL, 0x000fe20000000000ULL,
0x0000001c2d00720cULL, 0x000fe20003f86070ULL, 0x000000011b217824ULL, 0x040fe200078e0272ULL,
0x0ffffff809087812ULL, 0x000fe200078ef872ULL, 0x000000081b287824ULL, 0x000fe200078e00ffULL,
0xfffffff819267812ULL, 0x000fc400078ee21aULL, 0x0000000507197c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fc600078ee221ULL,
0x00000010081f7824ULL, 0x100fe200078e021dULL, 0x000000252c087210ULL, 0x000fe20007ffe0ffULL,
0x0000001020217824ULL, 0x000fe200078e021dULL, 0x00000070061a7812ULL, 0x000fe200078ef803ULL,
0x000000012c067824ULL, 0x000fe200078e0227ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101f7faeULL, 0x0007e2000e101c46ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x000000041a1a7c10ULL, 0x000fe4000ffde0ffULL, 0x0000001c1b00720cULL, 0x000fe40003f86070ULL,
0x00000005071b7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fc400078ef803ULL, 0x0000000323207819ULL, 0x000fe200000006ffULL,
0x000000101e1f7824ULL, 0x008fe200078e021dULL, 0x0000000408087c10ULL, 0x000fe2000ffde0ffULL,
0x0000000129117824ULL, 0x100fe200078e0272ULL, 0x0000007006107812ULL, 0x000fe200078ef803ULL,
0x00000001251e7824ULL, 0x000fe200078e0272ULL, 0x00000000121f7faeULL, 0x0007e2000e901c46ULL,
0x0000001c2900720cULL, 0x000fe20003fa6070ULL, 0x0000002c2d297836ULL, 0x000fe20000000000ULL,
0x0000000509097c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000014217faeULL, 0x0009e2000c901c46ULL,
0x0000000410107c10ULL, 0x000fe2000ffde0ffULL, 0x000000012c067824ULL, 0x000fe200078e0229ULL,
0xfffffff82a2a7812ULL, 0x000fc400078ee211ULL, 0x0000000507117c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000001c2300720cULL, 0x000fc60003f26070ULL,
0x00000010221f7824ULL, 0x108fe200078e021dULL, 0x0000007006127812ULL, 0x000fe200078ef803ULL,
0x0000000123137824ULL, 0x000fe400078e0272ULL, 0x0000001024157824ULL, 0x010fe200078e021dULL,
0x00000000161f7faeULL, 0x0007e2000d101c46ULL, 0x0000001c2500720cULL, 0x040fe20003f46070ULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x0000000412127c10ULL, 0x000fe2000ffde0ffULL,
0x000000000a157faeULL, 0x0009e2000c101c46ULL, 0xfffffff820067812ULL, 0x000fc400078ee213ULL,
0xfffffff8251e7812ULL, 0x000fe200078ee21eULL, 0x000000302d257836ULL, 0x000fe20000000000ULL,
0x0000000507137c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001026077824ULL, 0x100fe400078e021dULL,
0x0000001006217824ULL, 0x000fe200078e021dULL, 0x0000001d2a1f7211ULL, 0x008fe200078e20ffULL,
0x000000012c067824ULL, 0x000fe200078e0225ULL, 0x000000000c077faeULL, 0x0007e2000d901c46ULL,
0x0000001028177824ULL, 0x000fe200078e021dULL, 0x0000001c2500720cULL, 0x000fe20003f66070ULL,
0x000000342d157836ULL, 0x010fc40000000000ULL, 0x000000101e237824ULL, 0x000fe200078e021dULL,
0x000000000e177faeULL, 0x0009e2000e101c46ULL, 0x00000001270b7824ULL, 0x000fe200078e0272ULL,
0x0000001c2900720cULL, 0x080fe20003f86070ULL, 0x0000000825167824ULL, 0x000fe200078e00ffULL,
0x00000000181f7faeULL, 0x000be2000e901c46ULL, 0x0000003c2d2d7836ULL, 0x000fe20000000000ULL,
0x0000001c2700720cULL, 0x080fe20003fa6070ULL, 0x0000010006067825ULL, 0x008fe200078e00ffULL,
0x000000001a217faeULL, 0x0007e2000c901c46ULL, 0x0000001c2b00720cULL, 0x000fc40003f26070ULL,
0x000000012c0c7824ULL, 0x000fe200078e0215ULL, 0x00000070060a7812ULL, 0x000fe200078ef803ULL,
0x00000008270e7824ULL, 0x010fe200078e00ffULL, 0x0000000008237faeULL, 0x0009e2000d101c46ULL,
0x0000000129067824ULL, 0x100fe200078e0272ULL, 0x000000040a0a7c10ULL, 0x000fe2000ffde0ffULL,
0x00000001150f7824ULL, 0x140fe200078e0272ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL,
0x0000000815187824ULL, 0x022fe200078e00ffULL, 0x00000005070b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000125077824ULL, 0x100fe200078e0272ULL, 0x0000000329297819ULL, 0x000fe200000006ffULL,
0x000000082b1a7824ULL, 0x008fe200078e00ffULL, 0x0000001c1500720cULL, 0x000fe20003f46070ULL,
0x000000012b157824ULL, 0x000fe200078e0272ULL, 0xfffffff829147812ULL, 0x000fe200078ee206ULL,
0x000001000c087825ULL, 0x010fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fc400078ee207ULL,
0x0000001c2d00720cULL, 0x040fe20003f06070ULL, 0x000000012d727824ULL, 0x040fe200078e0272ULL,
0x00000070080c7812ULL, 0x000fe200078ef803ULL, 0x000000012c087824ULL, 0x000fe200078e022bULL,
0xfffffff818187812ULL, 0x000fe400078ee20fULL, 0x000000040c0c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000010008067825ULL, 0x000fe200078e00ffULL, 0x0000002d2c087210ULL, 0x000fe40007ffe0ffULL,
0x00000005090d7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fe200078ef803ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fc400078ee215ULL, 0x0000000406067c10ULL, 0x000fe2000ffde0ffULL,
0x0000001016157824ULL, 0x100fe200078e021dULL, 0x0000007008087812ULL, 0x000fe200078ef803ULL,
0x000000100e037824ULL, 0x100fe200078e021dULL, 0xfffffff82d727812ULL, 0x000fe200078ee272ULL,
0x0000001018177824ULL, 0x100fe200078e021dULL, 0x0000000507077c10ULL, 0x000fe2000b7fe4ffULL,
0x000000101a197824ULL, 0x100fe200078e021dULL, 0x0000001d140f7211ULL, 0x000fe200078e20ffULL,
0x00000010721d7824ULL, 0x000fe200078e021dULL, 0x0000000408087c10ULL, 0x000fe2000ffde0ffULL,
0x0000000010037faeULL, 0x0003e6000e901c46ULL, 0x0000000509097c10ULL, 0x000fe2000b7fe4ffULL,
0x00000000120f7faeULL, 0x0003e8000e101c46ULL, 0x000000000a157faeULL, 0x0003e8000d901c46ULL,
0x000000000c177faeULL, 0x0003e8000d101c46ULL, 0x0000000006197faeULL, 0x0003e8000c901c46ULL,
0x00000000081d7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d47947ULL, 0x000fea0003800000ULL,
0x0000001472217811ULL, 0x040fe200078fe8ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000010721f7811ULL, 0x040fe400078fe8ffULL, 0x00000004720d7811ULL, 0x040fe200078fe8ffULL,
0x0000000121097824ULL, 0x100fe200078e0272ULL, 0x000000031f117819ULL, 0x000fe200000006ffULL,
0x00000008212e7824ULL, 0x000fe200078e00ffULL, 0x000000030d077819ULL, 0x000fe200000006ffULL,
0x000000011f087824ULL, 0x100fe200078e0272ULL, 0x00000008720f7811ULL, 0x040fe200078fe8ffULL,
0x000000010d067824ULL, 0x000fe200078e0272ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee209ULL,
0x00000001210e7824ULL, 0x000fe200078e022cULL, 0x0000002472097811ULL, 0x040fe200078fe8ffULL,
0x000000080f0b7824ULL, 0x000fe200078e00ffULL, 0x0000000c721b7811ULL, 0x000fc400078fe8ffULL,
0xfffffff811247812ULL, 0x000fe200078ee208ULL, 0x0000000109087824ULL, 0x140fe200078e0272ULL,
0xfffffff8071a7812ULL, 0x000fe200078ee206ULL, 0x0000000809157824ULL, 0x000fe200078e00ffULL,
0x0000001c72297811ULL, 0x040fe200078fe8ffULL, 0x000000010f067824ULL, 0x100fe200078e0272ULL,
0x0000001872277811ULL, 0x040fe200078fe8ffULL, 0x000000011b077824ULL, 0x140fe200078e0272ULL,
0xfffffff815127812ULL, 0x000fe200078ee208ULL, 0x000000081b227824ULL, 0x000fe200078e00ffULL,
0x0000002c72157811ULL, 0x040fe200078fe8ffULL, 0x00000001270a7824ULL, 0x100fe200078e0272ULL,
0xfffffff80b1c7812ULL, 0x000fe200078ee206ULL, 0x00000001290b7824ULL, 0x100fe200078e0272ULL,
0xfffffff822227812ULL, 0x000fe200078ee207ULL, 0x0000000115087824ULL, 0x140fe200078e0272ULL,
0x0000002072077811ULL, 0x040fe200078fe8ffULL, 0x00000008151d7824ULL, 0x000fe200078e00ffULL,
0x0000003472197811ULL, 0x040fe200078fe8ffULL, 0x0000000827117824ULL, 0x000fe200078e00ffULL,
0x0000000329327819ULL, 0x000fe200000006ffULL, 0x0000000107067824ULL, 0x100fe200078e0272ULL,
0x0000000319257819ULL, 0x000fe200000006ffULL, 0x0000000807137824ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fe200078ee20bULL, 0x00000001190c7824ULL, 0x100fe200078e0272ULL,
0x00000028720b7811ULL, 0x000fe200078fe8ffULL, 0x000000012c217824ULL, 0x040fe200078e0215ULL,
0xfffffff81d147812ULL, 0x000fe200078ee208ULL, 0x000000012c1e7824ULL, 0x000fe200078e0207ULL,
0x0000007272087211ULL, 0x000fe200078fe8ffULL, 0x000000012c207824ULL, 0x040fe200078e020bULL,
0xfffffff811307812ULL, 0x000fe200078ee20aULL, 0x000000012c287824ULL, 0x000fe200078e0219ULL,
0xfffffff813117812ULL, 0x000fe200078ee206ULL, 0x000000010b067824ULL, 0x000fe200078e0272ULL,
0xfffffff825187812ULL, 0x000fe200078ee20cULL, 0x000000011b0c7824ULL, 0x100fe200078e022cULL,
0x00000038721d7811ULL, 0x000fe200078fe8ffULL, 0x00000001291b7824ULL, 0x100fe200078e022cULL,
0x0000000708257812ULL, 0x000fe200078ec0ffULL, 0x000000010d087824ULL, 0x100fe200078e022cULL,
0x000000030b137819ULL, 0x000fe200000006ffULL, 0x000000011f0d7824ULL, 0x000fe200078e022cULL,
0x0000003072177811ULL, 0x000fe200078fe8ffULL, 0x000000012c1f7824ULL, 0x000fe200078e0209ULL,
0xfffffff813137812ULL, 0x000fe200078ee206ULL, 0x000000011d097824ULL, 0x140fe200078e0272ULL,
0x0000002c72067211ULL, 0x000fe200078fe8ffULL, 0x000000081d107824ULL, 0x000fe200078e00ffULL,
0x000000172c267210ULL, 0x000fe20007ffe0ffULL, 0x00000001170a7824ULL, 0x040fe200078e0272ULL,
0x0ffffff825257812ULL, 0x000fe200078ef872ULL, 0x0000000817237824ULL, 0x000fe200078e00ffULL,
0xfffffff810157812ULL, 0x000fe200078ee209ULL, 0x0000400078097824ULL, 0x000fc400078e0273ULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0xfffffff823167812ULL, 0x000fe400078ee20aULL,
0x0000003c72237811ULL, 0x000fe200078fe8ffULL, 0x0000200009457836ULL, 0x000fe20000000000ULL,
0x0000007006107812ULL, 0x000fe200078ef803ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000007223727210ULL, 0x000fe40007ffe0ffULL, 0x0000000410107c10ULL, 0x000fe2000ff1e0ffULL,
0x000000010f0a7824ULL, 0x000fe200078e022cULL, 0x0000004511377211ULL, 0x000fe200078e20ffULL,
0x0000001012397824ULL, 0x000fe200078e0245ULL, 0x0000007008127812ULL, 0x000fe200078ef803ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000507117c10ULL, 0x000fc400087fe4ffULL,
0x0000000412127c10ULL, 0x000fe2000ff3e0ffULL, 0x00000010143d7824ULL, 0x100fe200078e0245ULL,
0x000000700a147812ULL, 0x000fe200078ef803ULL, 0x000001000c067825ULL, 0x000fe200078e00ffULL,
0x0000002c270f7210ULL, 0x000fe40007ffe0ffULL, 0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL,
0x00000010133b7824ULL, 0x100fe200078e0245ULL, 0x0000000509137c10ULL, 0x000fe20008ffe4ffULL,
0x00000010163f7824ULL, 0x000fe200078e0245ULL, 0x0000007006167812ULL, 0x000fe200078ef803ULL,
0x000001000d087825ULL, 0x000fe200078e00ffULL, 0x0000004515437211ULL, 0x000fc400078e20ffULL,
0x000000050b157c10ULL, 0x000fe200087fe4ffULL, 0x000001000e0c7825ULL, 0x000fe200078e00ffULL,
0x0000000416167c10ULL, 0x000fe4000ff1e0ffULL, 0x000000451c2b7211ULL, 0x000fe200078e20ffULL,
0x0000001018417824ULL, 0x100fe200078e0245ULL, 0x0000007008187812ULL, 0x000fe200078ef803ULL,
0x000000101a297824ULL, 0x000fe200078e0245ULL, 0x000000700c1a7812ULL, 0x000fe200078ef803ULL,
0x000001000f0e7825ULL, 0x000fe200078e00ffULL, 0x0000000418187c10ULL, 0x000fc4000ff3e0ffULL,
0x0000000507177c10ULL, 0x000fe200087fe4ffULL, 0x000001001b067825ULL, 0x000fe200078e00ffULL,
0x000000041a1a7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000700e1c7812ULL, 0x000fe200078ef803ULL,
0x000001001f0a7825ULL, 0x000fe200078e00ffULL, 0x0000000509197c10ULL, 0x000fe40008ffe4ffULL,
0x000000050d1b7c10ULL, 0x000fe200087fe4ffULL, 0x000001001e087825ULL, 0x000fe200078e00ffULL,
0x00000070061e7812ULL, 0x000fc400078ef803ULL, 0x000000041c1c7c10ULL, 0x000fe2000ff5e0ffULL,
0x00000100200c7825ULL, 0x000fe200078e00ffULL, 0x0000007008207812ULL, 0x000fe400078ef803ULL,
0x000000041e1e7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010222d7824ULL, 0x000fe200078e0245ULL,
0x000000700a227812ULL, 0x000fe200078ef803ULL, 0x000000012c2a7824ULL, 0x000fe200078e021dULL,
0x000000050f1d7c10ULL, 0x000fe200097fe4ffULL, 0x00000010242f7824ULL, 0x000fe200078e0245ULL,
0x000000700c247812ULL, 0x000fe200078ef803ULL, 0x000000012c2c7824ULL, 0x000fe200078e0223ULL,
0x0000000420207c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0x00000005071f7c10ULL, 0x000fe200087fe4ffULL, 0x00000100210e7825ULL, 0x000fe200078e00ffULL,
0x0000000422227c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000424247c10ULL, 0x000fe2000ff5e0ffULL,
0x0000010026067825ULL, 0x000fe200078e00ffULL, 0xfffffff823727812ULL, 0x000fe400078ee272ULL,
0x0000000509217c10ULL, 0x000fe20008ffe4ffULL, 0x0000001025277824ULL, 0x100fe200078e0245ULL,
0x000000700e0e7812ULL, 0x000fe200078ef803ULL, 0x0000010028087825ULL, 0x000fe200078e00ffULL,
0x000000050b237c10ULL, 0x000fe400087fe4ffULL, 0x000000050d257c10ULL, 0x000fe200097fe4ffULL,
0x000001002a0a7825ULL, 0x000fe200078e00ffULL, 0x000000040e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010277faeULL, 0x0007e2000b901c46ULL,
0x0000007006067812ULL, 0x000fe200078ef803ULL, 0x000001002c0c7825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fe200078ef803ULL, 0x0000000012297faeULL, 0x0007e2000b901c46ULL,
0x000000700a0a7812ULL, 0x000fe200078ef803ULL, 0x000000102e317824ULL, 0x100fe200078e0245ULL,
0x000000050f0f7c10ULL, 0x000fe200087fe4ffULL, 0x0000001030337824ULL, 0x100fe200078e0245ULL,
0x000000700c037812ULL, 0x000fe200078ef803ULL, 0x0000001032357824ULL, 0x100fe200078e0245ULL,
0x00000000142b7faeULL, 0x0007e2000b901c46ULL, 0x0000000406067c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001072457824ULL, 0x000fe200078e0245ULL, 0x0000000408087c10ULL, 0x000fe2000ff3e0ffULL,
0x00000000162d7faeULL, 0x0007e2000b901c46ULL, 0x000000040a0a7c10ULL, 0x000fc4000ff5e0ffULL,
0x00000004030c7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000000182f7faeULL, 0x0007e2000b901c46ULL,
0x0000000507077c10ULL, 0x000fe400087fe4ffULL, 0x0000000509097c10ULL, 0x000fe20008ffe4ffULL,
0x000000001a317faeULL, 0x0007e2000b901c46ULL, 0x000000050b0b7c10ULL, 0x000fe400097fe4ffULL,
0x000000050d0d7c10ULL, 0x000fe20009ffe4ffULL, 0x000000001c337faeULL, 0x0007e8000b901c46ULL,
0x000000001e357faeULL, 0x0007e8000b901c46ULL, 0x0000000020377faeULL, 0x0007e8000b901c46ULL,
0x0000000022397faeULL, 0x0007e8000b901c46ULL, 0x00000000243b7faeULL, 0x0007e8000b901c46ULL,
0x000000000e3d7faeULL, 0x0007e8000b901c46ULL, 0x00000000063f7faeULL, 0x0007e8000b901c46ULL,
0x0000000008417faeULL, 0x0007e8000b901c46ULL, 0x000000000a437faeULL, 0x0007e8000b901c46ULL,
0x000000000c457faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x00afe20000015200ULL, 0x01e60005730075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x01e60005730075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000707700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000997919ULL, 0x000e620000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x0000000878977824ULL, 0x140fe200078e0273ULL, 0x0000001f09047890ULL, 0x000fe4000fffe03fULL,
0x8000000971967c10ULL, 0x000fe2000fffe0ffULL, 0x0000002078957824ULL, 0x000fe200078e0273ULL,
0xffffffff09057890ULL, 0x000fe4000fffe03fULL, 0x000000043f047899ULL, 0x000fe20008011604ULL,
0x00000008ff967819ULL, 0x000fe20000011696ULL, 0x0000000909087890ULL, 0x000fc4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fd8000f8ec03fULL, 0x0000000177037836ULL, 0x000fe20000000000ULL,
0x0000920000097ab9ULL, 0x000fe20000000800ULL, 0x0000010077947824ULL, 0x000fc600078e0274ULL,
0x000000700300720cULL, 0x000fe20003f06070ULL, 0x00000009021a7c24ULL, 0x002fd8000f8e0294ULL,
0x0000000800f48947ULL, 0x002fea0003800000ULL, 0x00000003ff1c7819ULL, 0x102fe20000011699ULL,
0x0000001099937824ULL, 0x000fe200078e00ffULL, 0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x000000081c0a7810ULL, 0x000fe20007ffe0ffULL,
0x000000041c087836ULL, 0x000fe20000000000ULL, 0x0000007093937812ULL, 0x000fe200078ec0ffULL,
0x0000000c1c0c7836ULL, 0x000fe20000000000ULL, 0x0000001a1c077210ULL, 0x000fe20007ffe0ffULL,
0x000000010a047824ULL, 0x140fe200078e0299ULL, 0x0ffffff899917812ULL, 0x000fe200078ec0ffULL,
0x000000080a1f7824ULL, 0x000fe200078e00ffULL, 0x000000201c227810ULL, 0x000fe20007ffe0ffULL,
0x0000000108037824ULL, 0x000fc400078e0299ULL, 0x0000000808067824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL, 0x000000010c097824ULL, 0x040fe200078e0299ULL,
0x0000008093047812ULL, 0x000fe200078efcffULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0xfffffff8061d7812ULL, 0x000fe200078ee203ULL, 0x000000101c107836ULL, 0x000fe20000000000ULL,
0x0000009471037248ULL, 0x000fe20007fe0000ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0xfffffff812217812ULL, 0x000fe400078ee209ULL, 0x00000099100b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a94ULL, 0x0000000a060e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000141c167836ULL, 0x000fc40000000000ULL, 0x000000010a097824ULL, 0x100fe200078e021aULL,
0x0000000b070f7c10ULL, 0x000fe200087fe4ffULL, 0x0000000108077824ULL, 0x000fe200078e021aULL,
0x000000031000720cULL, 0x0c0fe20003f06070ULL, 0x0000000810147824ULL, 0x000fe200078e00ffULL,
0x000000030800720cULL, 0x080fe20003f86070ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x000000030a00720cULL, 0x000fe40003f26070ULL, 0xfffffff814237812ULL, 0x000fe200078ee20bULL,
0x00000001100d7824ULL, 0x000fe200078e021aULL, 0x0000000a06107c10ULL, 0x000fe2000ff7e0ffULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x0000001a0c0b7210ULL, 0x000fc40007ffe0ffULL,
0x0000000b07117c10ULL, 0x000fe20009ffe4ffULL, 0x0000000116137824ULL, 0x000fe200078e021aULL,
0x0000000a08127c10ULL, 0x000fe2000ffbe0ffULL, 0x000000181c187836ULL, 0x000fe20000000000ULL,
0x000000030c00720cULL, 0x000fe20003f46070ULL, 0x0000010013067825ULL, 0x100fe200078e0004ULL,
0x0000000b09137c10ULL, 0x000fe4000affe4ffULL, 0x000000991c087210ULL, 0x000fe20007ffe0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0004ULL, 0x0000000a06147c10ULL, 0x000fc4000ffde0ffULL,
0x00000007911b7812ULL, 0x000fe200078ef808ULL, 0x000001000d0c7825ULL, 0x000fe200078e0004ULL,
0x0000000a0a0a7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000b07157c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000118097824ULL, 0x000fe200078e021aULL, 0x0000000a0c0c7c10ULL, 0x000fe2000ffbe0ffULL,
0x0000400078907824ULL, 0x000fe200078e0273ULL, 0x0000000b0b0b7c10ULL, 0x000fe20009ffe4ffULL,
0x0000010009067825ULL, 0x000fe200078e0004ULL, 0x0000000b0d0d7c10ULL, 0x000fc4000affe4ffULL,
0x000000031c00720cULL, 0x080fe20003fa6070ULL, 0x0000000116097824ULL, 0x040fe200078e0299ULL,
0x000000031600720cULL, 0x040fe20003f66070ULL, 0x00000008161e7824ULL, 0x000fe200078e00ffULL,
0x0000000a06167c10ULL, 0x000fe2000ffde0ffULL, 0x0000001c1c207836ULL, 0x000fe40000000000ULL,
0x0000400090927836ULL, 0x000fe20000000000ULL, 0x0000000b07177c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000120077824ULL, 0x000fe200078e021aULL, 0xfffffff81e257812ULL, 0x000fe200078ee209ULL,
0x000000101b1b7824ULL, 0x000fc400078e0292ULL, 0x0000010007067825ULL, 0x000fc600078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e1b7faeULL, 0x0003e2000e901c46ULL,
0x000000101d1d7824ULL, 0x000fe200078e0292ULL, 0x000000031800720cULL, 0x0c0fe20003fa6070ULL,
0x00000001181e7824ULL, 0x040fe400078e0299ULL, 0x0000000818277824ULL, 0x000fe200078e00ffULL,
0x0000000a06187c10ULL, 0x000fe2000ffde0ffULL, 0x00000000101d7faeULL, 0x0005e2000e101c46ULL,
0x0000009920067210ULL, 0x000fe20007ffe0ffULL, 0x0000000122097824ULL, 0x000fe200078e021aULL,
0x0000000b07197c10ULL, 0x000fe2000b7fe4ffULL, 0x00000008200f7824ULL, 0x042fe200078e00ffULL,
0xfffffff8271b7812ULL, 0x000fe200078ee21eULL, 0x0000010009087825ULL, 0x000fe200078e0004ULL,
0x000000032000720cULL, 0x000fc40003f86070ULL, 0x00000099220e7210ULL, 0x000fe20007ffe0ffULL,
0x000000241c107836ULL, 0x004fe20000000000ULL, 0xfffffff80f1d7812ULL, 0x000fe200078ee206ULL,
0x000000101f0f7824ULL, 0x100fe200078e0292ULL, 0x0000000a08087c10ULL, 0x000fe2000ffde0ffULL,
0x0000001021117824ULL, 0x000fe400078e0292ULL, 0x0000000110077824ULL, 0x000fe200078e021aULL,
0x00000000120f7faeULL, 0x0003e2000c901c46ULL, 0x00000008221f7824ULL, 0x040fe200078e00ffULL,
0x000000032200720cULL, 0x080fe20003f26070ULL, 0x00000001101e7824ULL, 0x040fe200078e0299ULL,
0x000000000a117faeULL, 0x0005e2000d101c46ULL, 0x0000000810217824ULL, 0x040fe200078e00ffULL,
0x000000031000720cULL, 0x000fe20003f46070ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0xfffffff81f1f7812ULL, 0x000fc400078ee20eULL, 0x0000000b09097c10ULL, 0x000fe2000b7fe4ffULL,
0x0000002c1c0e7836ULL, 0x000fe20000000000ULL, 0xfffffff821217812ULL, 0x000fe200078ee21eULL,
0x00000010230f7824ULL, 0x102fe200078e0292ULL, 0x0000000a06067c10ULL, 0x000fe2000ffde0ffULL,
0x000000101d137824ULL, 0x100fe200078e0292ULL, 0x000000921b117211ULL, 0x004fe200078e20ffULL,
0x00000010250b7824ULL, 0x100fe200078e0292ULL, 0x0000000b07077c10ULL, 0x000fe2000b7fe4ffULL,
0x000000281c0a7836ULL, 0x000fe20000000000ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c46ULL,
0x000000101f1b7824ULL, 0x100fe200078e0292ULL, 0x000000301c107810ULL, 0x000fe20007ffe0ffULL,
0x00000010211d7824ULL, 0x000fe200078e0292ULL, 0x00000000140b7faeULL, 0x0005e2000d901c46ULL,
0x000000381c1e7836ULL, 0x000fe20000000000ULL, 0x000000031000720cULL, 0x0c0fe20003f66070ULL,
0x0000000110127824ULL, 0x000fe200078e0299ULL, 0x0000000016117faeULL, 0x0007e2000e901c46ULL,
0x000000030a00720cULL, 0x000fc60003fa6070ULL, 0x0000000018137faeULL, 0x0009e2000e101c46ULL,
0x000000010a0c7824ULL, 0x102fe200078e0299ULL, 0x000000030e00720cULL, 0x080fe20003f86070ULL,
0x00000001100d7824ULL, 0x100fe200078e021aULL, 0x00000000081b7faeULL, 0x0003e2000c901c46ULL,
0x000000010a0b7824ULL, 0x104fe200078e021aULL, 0x000000031e00720cULL, 0x080fe20003f26070ULL,
0x000000341c147836ULL, 0x000fe20000000000ULL, 0x00000000061d7faeULL, 0x0005e2000d101c46ULL,
0x0000003c1c1c7836ULL, 0x000fe20000000000ULL, 0x0000001a1e117210ULL, 0x008fe20007ffe0ffULL,
0x000000080e157824ULL, 0x000fe200078e00ffULL, 0x000000030a137819ULL, 0x010fe200000006ffULL,
0x0000000810177824ULL, 0x000fe200078e00ffULL, 0x000000031400720cULL, 0x0c0fe20003f46070ULL,
0x0000000114107824ULL, 0x000fe200078e0299ULL, 0xfffffff813137812ULL, 0x000fe200078ee20cULL,
0x000000010e097824ULL, 0x102fe200078e021aULL, 0x000000031c00720cULL, 0x000fe20003f06070ULL,
0x0000000114037824ULL, 0x000fe200078e021aULL, 0xfffffff817177812ULL, 0x000fe200078ee212ULL,
0x000001000b067825ULL, 0x004fc800078e0004ULL, 0x0000010009087825ULL, 0x000fe200078e0004ULL,
0x0000000a060a7c10ULL, 0x000fc6000ffde0ffULL, 0x0000000814197824ULL, 0x000fe200078e00ffULL,
0x0000000b070b7c10ULL, 0x000fe2000b7fe4ffULL, 0x000001000d067825ULL, 0x000fe200078e0004ULL,
0x0000000a080c7c10ULL, 0x000fe4000ffde0ffULL, 0xfffffff819197812ULL, 0x000fe200078ee210ULL,
0x000000010e087824ULL, 0x100fe200078e0299ULL, 0x0000000b090d7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000011c107824ULL, 0x040fe200078e0299ULL, 0x0000000a060e7c10ULL, 0x000fe2000ffde0ffULL,
0x000000081c1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee208ULL,
0x0000010003087825ULL, 0x000fe200078e0004ULL, 0x0000000b070f7c10ULL, 0x000fc4000b7fe4ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL, 0x000000011c037824ULL, 0x000fe200078e021aULL,
0x0000000a08087c10ULL, 0x000fe2000ffde0ffULL, 0x0000010011067825ULL, 0x000fc600078e0004ULL,
0x0000000b09097c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010003047825ULL, 0x000fe200078e0004ULL,
0x000000991e037210ULL, 0x000fe40007ffe0ffULL, 0x0000000a06067c10ULL, 0x000fe2000ffde0ffULL,
0x000000081e1e7824ULL, 0x000fe400078e00ffULL, 0x0000001015117824ULL, 0x100fe200078e0292ULL,
0x0000000b07077c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001019157824ULL, 0x100fe200078e0292ULL,
0xfffffff81e1b7812ULL, 0x000fe200078ee203ULL, 0x0000001013037824ULL, 0x100fe200078e0292ULL,
0x0000000a04047c10ULL, 0x000fe2000ffde0ffULL, 0x000000101d197824ULL, 0x100fe200078e0292ULL,
0x0000009217137211ULL, 0x000fe200078e20ffULL, 0x000000101b177824ULL, 0x000fe200078e0292ULL,
0x0000000b05057c10ULL, 0x000fe2000b7fe4ffULL, 0x000000000a037faeULL, 0x0003e8000e901c46ULL,
0x000000000c117faeULL, 0x0003e8000e101c46ULL, 0x000000000e137faeULL, 0x0003e8000d901c46ULL,
0x0000000008157faeULL, 0x0003e8000d101c46ULL, 0x0000000006177faeULL, 0x0003e8000c901c46ULL,
0x0000000004197faeULL, 0x0003e2000c101c46ULL, 0x0000000800a47947ULL, 0x000fea0003800000ULL,
0x0000000499077811ULL, 0x042fe200078fe8ffULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x0000000899097811ULL, 0x040fe200078fe8ffULL, 0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL,
0x00000010990d7811ULL, 0x000fe200078fe8ffULL, 0x0000000107037824ULL, 0x100fe200078e0299ULL,
0x0000000c990b7811ULL, 0x000fe200078fe8ffULL, 0x0000000807047824ULL, 0x000fe200078e00ffULL,
0x00000014990f7811ULL, 0x000fe200078fe8ffULL, 0x0000000809067824ULL, 0x000fe200078e00ffULL,
0x0000001c99137811ULL, 0x000fe200078fe8ffULL, 0x000000010d057824ULL, 0x140fe200078e0299ULL,
0xfffffff804257812ULL, 0x000fe200078ee203ULL, 0x000000080d087824ULL, 0x000fe200078e00ffULL,
0x0000009909037210ULL, 0x000fe20007ffe0ffULL, 0x000000010b047824ULL, 0x100fe200078e0299ULL,
0x0000001899117811ULL, 0x000fe200078fe8ffULL, 0x000000080b297824ULL, 0x000fe200078e00ffULL,
0xfffffff806277812ULL, 0x000fe200078ee203ULL, 0x000000080f067824ULL, 0x000fe200078e00ffULL,
0xfffffff8082b7812ULL, 0x000fe200078ee205ULL, 0x0000000113057824ULL, 0x140fe200078e0299ULL,
0x000000990f037210ULL, 0x000fe20007ffe0ffULL, 0x0000000813087824ULL, 0x000fe200078e00ffULL,
0x0000002099157811ULL, 0x000fe200078fe8ffULL, 0x00000008112f7824ULL, 0x000fe200078e00ffULL,
0x0000002899197811ULL, 0x000fe200078fe8ffULL, 0x0000000107077824ULL, 0x100fe200078e021aULL,
0xfffffff829297812ULL, 0x000fe200078ee204ULL, 0x0000000111047824ULL, 0x100fe200078e0299ULL,
0xfffffff8062d7812ULL, 0x000fe200078ee203ULL, 0x0000000815067824ULL, 0x000fe200078e00ffULL,
0xfffffff808317812ULL, 0x000fe200078ee205ULL, 0x0000000119057824ULL, 0x100fe200078e0299ULL,
0x0000002499177811ULL, 0x000fe200078fe8ffULL, 0x0000000819087824ULL, 0x000fe200078e00ffULL,
0x0000009915037210ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x100fe200078e021aULL,
0x0000002c991b7811ULL, 0x000fe200078fe8ffULL, 0x0000000817357824ULL, 0x000fe200078e00ffULL,
0x00000034991f7811ULL, 0x000fe200078fe8ffULL, 0x0000000109097824ULL, 0x100fe200078e021aULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee204ULL, 0x0000000117047824ULL, 0x100fe200078e0299ULL,
0xfffffff806337812ULL, 0x000fe200078ee203ULL, 0x000000081b067824ULL, 0x000fe200078e00ffULL,
0xfffffff808377812ULL, 0x000fe200078ee205ULL, 0x000000011f057824ULL, 0x100fe200078e0299ULL,
0x00000030991d7811ULL, 0x000fe200078fe8ffULL, 0x000000081f087824ULL, 0x000fe200078e00ffULL,
0x000000991b037210ULL, 0x000fe20007ffe0ffULL, 0x000000010d0d7824ULL, 0x100fe200078e021aULL,
0xfffffff835357812ULL, 0x000fe200078ee204ULL, 0x000000011d047824ULL, 0x140fe200078e0299ULL,
0xfffffff806397812ULL, 0x000fe200078ee203ULL, 0x000000081d3b7824ULL, 0x000fe200078e00ffULL,
0x0000000499937819ULL, 0x000fe200000006ffULL, 0x000000010f0f7824ULL, 0x100fe200078e021aULL,
0xfffffff8083d7812ULL, 0x000fe200078ee205ULL, 0x0000000113137824ULL, 0x100fe200078e021aULL,
0x0000003899037811ULL, 0x000fe200078fe8ffULL, 0x0000000115157824ULL, 0x100fe200078e021aULL,
0x0000003c99057811ULL, 0x000fe200078fe8ffULL, 0x0000000117177824ULL, 0x100fe200078e021aULL,
0x0000007093937812ULL, 0x000fe200078ec0ffULL, 0x0000000103217824ULL, 0x140fe200078e021aULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee204ULL, 0x0000000103047824ULL, 0x040fe200078e0299ULL,
0x0000009905067210ULL, 0x000fe20007ffe0ffULL, 0x00000008033f7824ULL, 0x000fe200078e00ffULL,
0x0000008093227812ULL, 0x000fe200078efcffULL, 0x0000000105037824ULL, 0x140fe200078e021aULL,
0x0000001a11117210ULL, 0x000fe20007ffe0ffULL, 0x0000000805417824ULL, 0x000fe200078e00ffULL,
0x0000001a99057211ULL, 0x000fe200078fe8ffULL, 0x0000000119197824ULL, 0x100fe200078e021aULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee204ULL, 0x000000011b1b7824ULL, 0x000fe200078e021aULL,
0xfffffff841417812ULL, 0x000fe200078ee206ULL, 0x0000010005047825ULL, 0x000fe200078e0022ULL,
0x0000001a1d1d7210ULL, 0x000fc40007ffe0ffULL, 0x0000009999247211ULL, 0x000fe200078fe8ffULL,
0x0000010007067825ULL, 0x000fe200078e0022ULL, 0x0000000a04047c10ULL, 0x000fe4000ff1e0ffULL,
0x0ffffff899917812ULL, 0x000fe200078ec0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e021aULL,
0x0000000a06067c10ULL, 0x000fe2000ff3e0ffULL, 0x000001000b0a7825ULL, 0x100fe200078e0022ULL,
0x0000000b05057c10ULL, 0x000fe400087fe4ffULL, 0x0000000b07077c10ULL, 0x000fe20008ffe4ffULL,
0x0000010009087825ULL, 0x000fe200078e0022ULL, 0x0000000a0a0a7c10ULL, 0x000fc6000ff1e0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0022ULL, 0x0000000a08087c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000b0b0b7c10ULL, 0x000fe200087fe4ffULL, 0x0000400078907824ULL, 0x000fe200078e0273ULL,
0x0000000a0c0c7c10ULL, 0x000fe2000ff3e0ffULL, 0x000001000f0e7825ULL, 0x100fe200078e0022ULL,
0x0000000b09097c10ULL, 0x000fe400097fe4ffULL, 0x0000000b0d0d7c10ULL, 0x000fe20008ffe4ffULL,
0x0000010011107825ULL, 0x000fe200078e0022ULL, 0x0000000a0e0e7c10ULL, 0x000fc6000ff5e0ffULL,
0x0000010013127825ULL, 0x100fe200078e0022ULL, 0x0000000a10107c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000b0f0f7c10ULL, 0x000fe200097fe4ffULL, 0x0000010015147825ULL, 0x100fe200078e0022ULL,
0x0000000a12127c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000b11117c10ULL, 0x000fe20009ffe4ffULL,
0x0000010017167825ULL, 0x100fe200078e0022ULL, 0x0000000a14147c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000b13137c10ULL, 0x000fe200087fe4ffULL, 0x0000010019187825ULL, 0x000fe200078e0022ULL,
0x0000000b15157c10ULL, 0x000fc40008ffe4ffULL, 0x0000000a16167c10ULL, 0x000fe2000ff5e0ffULL,
0x000001001b1a7825ULL, 0x100fe200078e0022ULL, 0x0000000a18187c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000b17177c10ULL, 0x000fe200097fe4ffULL, 0x000001001d1c7825ULL, 0x100fe200078e0022ULL,
0x0000000a1a1a7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000b19197c10ULL, 0x000fe20009ffe4ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0022ULL, 0x0000000a1c1c7c10ULL, 0x000fc4000ff3e0ffULL,
0x0000000b1b1b7c10ULL, 0x000fe200087fe4ffULL, 0x0000010021207825ULL, 0x100fe200078e0022ULL,
0x0000000b1d1d7c10ULL, 0x000fe40008ffe4ffULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000010003227825ULL, 0x000fe200078e0022ULL, 0x0000000791037812ULL, 0x000fe400078ef824ULL,
0x0000000a20207c10ULL, 0x000fe2000ff3e0ffULL, 0x0000400090927836ULL, 0x000fe20000000000ULL,
0x0000000a22227c10ULL, 0x000fc4000ff5e0ffULL, 0x0000000b1f1f7c10ULL, 0x000fe200087fe4ffULL,
0x0000001003037824ULL, 0x100fe200078e0292ULL, 0x0000009225257211ULL, 0x000fe200078e20ffULL,
0x0000001027277824ULL, 0x100fe200078e0292ULL, 0x0000000b21217c10ULL, 0x000fe20008ffe4ffULL,
0x0000001029297824ULL, 0x100fe200078e0292ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000b901c46ULL, 0x000000102b2b7824ULL, 0x100fe200078e0292ULL,
0x0000000b23237c10ULL, 0x000fe200097fe4ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0292ULL,
0x0000000006257faeULL, 0x0005e2000b901c46ULL, 0x000000102f2f7824ULL, 0x000fc600078e0292ULL,
0x0000000008277faeULL, 0x0007e2000b901c46ULL, 0x0000009231037211ULL, 0x002fc600078e20ffULL,
0x000000000a297faeULL, 0x0003e2000b901c46ULL, 0x0000001033057824ULL, 0x100fe400078e0292ULL,
0x0000001035077824ULL, 0x104fe200078e0292ULL, 0x000000000c2b7faeULL, 0x0005e2000b901c46ULL,
0x0000001037097824ULL, 0x008fc600078e0292ULL, 0x000000000e2d7faeULL, 0x0007e8000b901c46ULL,
0x00000000102f7faeULL, 0x0009e2000b901c46ULL, 0x00000010390b7824ULL, 0x002fc600078e0292ULL,
0x0000000012037faeULL, 0x0003e2000b901c46ULL, 0x000000103b0d7824ULL, 0x004fc600078e0292ULL,
0x0000000014057faeULL, 0x0005e2000b901c46ULL, 0x000000923d0f7211ULL, 0x008fc600078e20ffULL,
0x0000000016077faeULL, 0x0005e2000b901c46ULL, 0x0000001041117824ULL, 0x110fe400078e0292ULL,
0x000000103f037824ULL, 0x002fe200078e0292ULL, 0x0000000018097faeULL, 0x0005e8000b901c46ULL,
0x000000001a0b7faeULL, 0x0005e8000b901c46ULL, 0x000000001c0d7faeULL, 0x0005e8000b901c46ULL,
0x000000001e0f7faeULL, 0x0005e8000b901c46ULL, 0x0000000020037faeULL, 0x0005e8000b901c46ULL,
0x0000000022117faeULL, 0x0005e4000b901c46ULL, 0x00000004ff8a7819ULL, 0x000fe20000011699ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000899047812ULL, 0x042fe200078ec0ffULL,
0x0000200090907836ULL, 0x000fe20000000000ULL, 0x00000007998f7812ULL, 0x000fe200078ec0ffULL,
0x000000088a1a7824ULL, 0x004fe200078e00ffULL, 0x00000007048d7812ULL, 0x000fe200078ef899ULL,
0x000000017a9b7824ULL, 0x000fe200078e0277ULL, 0x00000003ff8e7819ULL, 0x000fe40000011699ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee28fULL, 0x000000018a8c7824ULL, 0x000fe200078e028dULL,
0x000000018e057812ULL, 0x000fe200078ec0ffULL, 0x000000108d1c7824ULL, 0x040fe200078e00ffULL,
0x000000048d037819ULL, 0x040fe200000006ffULL, 0x000000101a187836ULL, 0x000fe20000000000ULL,
0x000000108d8b7812ULL, 0x000fe200078efcffULL, 0x000000201a727836ULL, 0x000fe20000000000ULL,
0xfffffff003047812ULL, 0x000fe200078ee28cULL, 0x000000301a757836ULL, 0x000fe20000000000ULL,
0x000000048b097819ULL, 0x000fe200000006ffULL, 0x0000000105037824ULL, 0x000fe200078e021aULL,
0x0000001805887210ULL, 0x000fe20007ffe0ffULL, 0x000000081a067824ULL, 0x000fc400078e00ffULL,
0x000000018a8a7824ULL, 0x000fe200078e028bULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000105877824ULL, 0x040fe200078e0272ULL, 0xfffffff806897812ULL, 0x000fe200078ee203ULL,
0x0000000105867824ULL, 0x000fe200078e0275ULL, 0xfffffff009067812ULL, 0x000fe200078ee28aULL,
0x0000000818057824ULL, 0x000fe200078e00ffULL, 0x0000000375097819ULL, 0x000fe200000006ffULL,
0x0000000872087824ULL, 0x000fe400078e00ffULL, 0x0000001004047824ULL, 0x100fe200078e0273ULL,
0xfffffff805887812ULL, 0x000fe200078ee288ULL, 0x0000001089147824ULL, 0x100fe200078e0290ULL,
0xfffffff809867812ULL, 0x000fe200078ee286ULL, 0x0000001006067824ULL, 0x000fe200078e0273ULL,
0xfffffff808877812ULL, 0x000fe200078ee287ULL, 0x0000001088087824ULL, 0x000fe200078e0290ULL,
0x00000000040c783bULL, 0x0003e20000000200ULL, 0x000000028c077836ULL, 0x000fc40000000000ULL,
0x000000108b1e7824ULL, 0x000fe200078e00ffULL, 0x000000000620783bULL, 0x000fe20000000200ULL,
0x000000028a117836ULL, 0x000fe20000000000ULL, 0xfffffff01c1c7812ULL, 0x000fe200078ee207ULL,
0x0000001086107824ULL, 0x000fe200078e0290ULL, 0x0000009087047211ULL, 0x002fe200078e20ffULL,
0x000000000808783bULL, 0x000e620000000200ULL, 0xfffffff01e1e7812ULL, 0x000fe200078ee211ULL,
0x0000001203847836ULL, 0x000fe20000000000ULL, 0x000000731c1c7211ULL, 0x000fe200078e20ffULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x0000000818197824ULL, 0x000fc400078e00ffULL,
0x000000081a247824ULL, 0x000fe200078e00ffULL, 0x000000000404783bULL, 0x000ee20000000200ULL,
0x0000000203857836ULL, 0x000fe20000000000ULL, 0xfffffff819847812ULL, 0x000fe200078ee284ULL,
0x0000003203827836ULL, 0x000fe20000000000ULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x0000000875197824ULL, 0x000fe200078e00ffULL, 0xfffffff824857812ULL, 0x000fe200078ee285ULL,
0x0000002203837836ULL, 0x000fe20000000000ULL, 0x000000001c54783bULL, 0x000fe20000000200ULL,
0x0000000872247824ULL, 0x000fe200078e00ffULL, 0xfffffff819827812ULL, 0x000fe200078ee282ULL,
0x000000101e3c7824ULL, 0x000fc400078e0273ULL, 0x0000001084307824ULL, 0x100fe200078e0290ULL,
0xfffffff824837812ULL, 0x000fe200078ee283ULL, 0x0000001085507824ULL, 0x100fe400078e0290ULL,
0x00000010821d7824ULL, 0x000fe200078e0290ULL, 0x0000009083247211ULL, 0x000fe200078e20ffULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x0000000403817836ULL, 0x000fe40000000000ULL,
0x0000001403807836ULL, 0x000fe20000000000ULL, 0x000000003030783bULL, 0x000f620000000200ULL,
0x00000034037b7836ULL, 0x000fc40000000000ULL, 0x0000002403797836ULL, 0x000fe20000000000ULL,
0x000000005050783bULL, 0x000ee20000000200ULL, 0x0000000603767836ULL, 0x000fc60000000000ULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0x000000080c5c723cULL, 0x002fe600000418ffULL,
0x000000001d1c783bULL, 0x000e660000000200ULL, 0x0000000a0c64723cULL, 0x000fec00000418ffULL,
0x00000008204c723cULL, 0x000fec00000418ffULL, 0x000000140c40723cULL, 0x004fec00000418ffULL,
0x000000142044723cULL, 0x000fec00000418ffULL, 0x000000160c48723cULL, 0x000fec00000418ffULL,
0x0000000a2008723cULL, 0x000fec00000418ffULL, 0x000000162014723cULL, 0x000fec00000418ffULL,
0x000000040c6c723cULL, 0x008fec00000418ffULL, 0x000000060c68723cULL, 0x000fec00000418ffULL,
0x000000100c60723cULL, 0x010fec00000418ffULL, 0x000000120c0c723cULL, 0x000fec00000418ffULL,
0x00000004202c723cULL, 0x000fec00000418ffULL, 0x000000062004723cULL, 0x000fec00000418ffULL,
0x00000030545c723cULL, 0x020fec000004185cULL, 0x000000325464723cULL, 0x000fec0000041864ULL,
0x000000303c4c723cULL, 0x000fec000004184cULL, 0x000000505440723cULL, 0x000fec0000041840ULL,
0x000000503c44723cULL, 0x000fec0000041844ULL, 0x000000525448723cULL, 0x000fec0000041848ULL,
0x000000323c30723cULL, 0x000fec0000041808ULL, 0x000000523c50723cULL, 0x000fe20000041814ULL,
0x00000008750a7824ULL, 0x000fe200078e00ffULL, 0x0000000318097819ULL, 0x000fe200000006ffULL,
0x0000000872087824ULL, 0x000fc400078e00ffULL, 0x000000081a0b7824ULL, 0x040fe200078e00ffULL,
0x00000024546c723cULL, 0x000fe2000004186cULL, 0x000000031a147819ULL, 0x000fe400000006ffULL,
0xfffffff809807812ULL, 0x000fe400078ee280ULL, 0xfffffff814817812ULL, 0x000fe200078ee281ULL,
0x000000265468723cULL, 0x000fe20000041868ULL, 0xfffffff80a7b7812ULL, 0x000fe200078ee27bULL,
0x0000001080347824ULL, 0x100fe200078e0290ULL, 0xfffffff808797812ULL, 0x000fe200078ee279ULL,
0x00000010817c7824ULL, 0x100fe200078e0290ULL, 0xfffffff80b767812ULL, 0x000fe200078ee276ULL,
0x0000001c5460723cULL, 0x002fe20000041860ULL, 0x000000107b197824ULL, 0x100fe200078e0290ULL,
0x000000003434783bULL, 0x000fe20000000200ULL, 0x0000001079287824ULL, 0x000fc400078e0290ULL,
0x0000000875087824ULL, 0x000fe200078e00ffULL, 0x0000001e5454723cULL, 0x000fe2000004180cULL,
0x000000007c7c783bULL, 0x000fe20000000200ULL, 0x0000001603757836ULL, 0x000fc60000000000ULL,
0x000000002828783bULL, 0x000fe20000000200ULL, 0x000000102038723cULL, 0x000fe200000418ffULL,
0x000000108d0f7824ULL, 0x040fe400078e00ffULL, 0x000000048c0c7836ULL, 0x000fe40000000000ULL,
0x000000068c0e7836ULL, 0x000fe20000000000ULL, 0x000000243c2c723cULL, 0x000fe2000004182cULL,
0x000000108d117824ULL, 0x000fe200078e00ffULL, 0xfffffff00f0c7812ULL, 0x000fe200078ee20cULL,
0x000000048a0d7836ULL, 0x000fc60000000000ULL, 0x000000730c0c7211ULL, 0x000fe200078e20ffULL,
0x000000263c24723cULL, 0x000fe20000041804ULL, 0xfffffff011107812ULL, 0x000fc600078ee20eULL,
0x000000000c58783bULL, 0x0002a40000000200ULL, 0x000000122020723cULL, 0x000fe200000418ffULL,
0x0000000818067824ULL, 0x000fe200078e00ffULL, 0x000000048b057819ULL, 0x040fe200000006ffULL,
0x000000001918783bULL, 0x000ee20000000200ULL, 0x0000000872077824ULL, 0x000fe400078e00ffULL,
0x0000002603727836ULL, 0x000fe20000000000ULL, 0x0000003603037810ULL, 0x000fe20007ffe0ffULL,
0x000000108b127824ULL, 0x000fe200078e00ffULL, 0xfffffff806757812ULL, 0x000fe200078ee275ULL,
0x000000068a047836ULL, 0x000fe20000000000ULL, 0xfffffff807727812ULL, 0x000fe200078ee272ULL,
0x0000001c3c38723cULL, 0x000fe20000041838ULL, 0xfffffff0120e7812ULL, 0x000fc400078ee20dULL,
0xfffffff808037812ULL, 0x000fe200078ee203ULL, 0x0000001076087824ULL, 0x100fe200078e0290ULL,
0xfffffff005067812ULL, 0x000fe200078ee204ULL, 0x000000100e0e7824ULL, 0x100fe200078e0273ULL,
0x00000090031c7211ULL, 0x000fe200078e20ffULL, 0x0000001010047824ULL, 0x100fe400078e0273ULL,
0x0000001075107824ULL, 0x100fe200078e0290ULL, 0x000000000e14783bULL, 0x000f220000000200ULL,
0x0000001072987824ULL, 0x000fe200078e0290ULL, 0x0000001e3c3c723cULL, 0x000fe20000041820ULL,
0x00000010060c7824ULL, 0x002fe200078e0273ULL, 0x000000000808783bULL, 0x000fe80000000200ULL,
0x000000000404783bULL, 0x000e680000000200ULL, 0x000000001010783bULL, 0x000f620000000200ULL,
0x0000007c5840723cULL, 0x004fe60000041840ULL, 0x000000001c1c783bULL, 0x000ea80000000200ULL,
0x000000009820783bULL, 0x000e620000000200ULL, 0x0000007e5848723cULL, 0x000fe60000041848ULL,
0x000000000c0c783bULL, 0x000e660000000200ULL, 0x00000034585c723cULL, 0x000fec000004185cULL,
0x000000365864723cULL, 0x000fec0000041864ULL, 0x00000028586c723cULL, 0x000fec000004186cULL,
0x0000002a5868723cULL, 0x000fec0000041868ULL, 0x000000185860723cULL, 0x008fec0000041860ULL,
0x0000001a5854723cULL, 0x000fec0000041854ULL, 0x0000007c1444723cULL, 0x010fec0000041844ULL,
0x0000007e1450723cULL, 0x000fec0000041850ULL, 0x00000034144c723cULL, 0x000fec000004184cULL,
0x000000361430723cULL, 0x000fec0000041830ULL, 0x000000181438723cULL, 0x000fec0000041838ULL,
0x00000028142c723cULL, 0x000fec000004182cULL, 0x0000002a1424723cULL, 0x000fec0000041824ULL,
0x0000001a143c723cULL, 0x000fec000004183cULL, 0x000000080440723cULL, 0x002fec0000041840ULL,
0x0000000a0448723cULL, 0x000fec0000041848ULL, 0x00000010045c723cULL, 0x020fec000004185cULL,
0x000000120464723cULL, 0x000fec0000041864ULL, 0x0000001c0460723cULL, 0x004fec0000041860ULL,
0x00000020046c723cULL, 0x000fec000004186cULL, 0x000000220468723cULL, 0x000fec0000041868ULL,
0x0000001e0454723cULL, 0x000fec0000041854ULL, 0x000000080c44723cULL, 0x000fe20000041844ULL,
0x000000019b057836ULL, 0x000fc40000000000ULL, 0x000001009b047824ULL, 0x000fc600078e0274ULL,
0x000000700500720cULL, 0x000fe20003f06070ULL, 0x0000000a0c50723cULL, 0x000fe20000041850ULL,
0x0000000902077c24ULL, 0x000fca000f8e0204ULL, 0x000000100c4c723cULL, 0x000fec000004184cULL,
0x000000120c30723cULL, 0x000fec0000041830ULL, 0x000000200c2c723cULL, 0x000fec000004182cULL,
0x000000220c24723cULL, 0x000fec0000041824ULL, 0x0000001c0c38723cULL, 0x000fec0000041838ULL,
0x0000001e0c3c723cULL, 0x000fe2000004183cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000c00108947ULL, 0x000fde0003800000ULL, 0x000000048e0a7836ULL, 0x000fe20000000000ULL,
0x0000000471097248ULL, 0x000fe20007fe0000ULL, 0x000000108e127836ULL, 0x000fe20000000000ULL,
0x000000088e087810ULL, 0x000fe20007ffe0ffULL, 0x000000010a057824ULL, 0x040fe200078e0299ULL,
0x0000000904097210ULL, 0x000fe20007ffe1ffULL, 0x000000080a0c7824ULL, 0x000fe400078e00ffULL,
0x000000018e047824ULL, 0x000fe200078e0207ULL, 0x000000090a00720cULL, 0x080fe20003f46070ULL,
0x00000001080b7824ULL, 0x040fe200078e0299ULL, 0xfffffff80c177812ULL, 0x000fe200078ee205ULL,
0x00000008080e7824ULL, 0x000fe200078e00ffULL, 0x000000091200720cULL, 0x080fe20003f86070ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000098e00720cULL, 0x000fc40003f26070ULL,
0xfffffff80e1b7812ULL, 0x000fe200078ee20bULL, 0x000000148e167836ULL, 0x000fe20000000000ULL,
0x00000093040e7212ULL, 0x000fe200078efcffULL, 0x00000001120b7824ULL, 0x100fe200078e0299ULL,
0x000000090800720cULL, 0x000fe20003f66070ULL, 0x0000000812107824ULL, 0x000fe200078e00ffULL,
0x0000000a0e0e7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000116047824ULL, 0x040fe400078e0299ULL,
0x0000000816217824ULL, 0x000fe200078e00ffULL, 0xfffffff8101f7812ULL, 0x000fe200078ee20bULL,
0x000000010a0a7824ULL, 0x000fe200078e0207ULL, 0x0000000b050f7c10ULL, 0x000fe200087fe4ffULL,
0x000000018e067824ULL, 0x000fe200078e0299ULL, 0xfffffff821217812ULL, 0x000fe200078ee204ULL,
0x0000000c8e0c7836ULL, 0x000fe20000000000ULL, 0x000000901f1f7211ULL, 0x000fe200078e20ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000791917812ULL, 0x000fc400078ef806ULL,
0x000000990c067210ULL, 0x000fe20007ffe0ffULL, 0x0000000108047824ULL, 0x100fe200078e0207ULL,
0x000000090c00720cULL, 0x040fe20003fa6070ULL, 0x000000080c1d7824ULL, 0x000fe200078e00ffULL,
0x000000930a107212ULL, 0x080fe200078efcffULL, 0x000000010c0c7824ULL, 0x100fe200078e0207ULL,
0x0000009091917211ULL, 0x000fe200078e20ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x0000000a10107c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x00000001120a7824ULL, 0x000fe200078e0207ULL, 0x0000009304127212ULL, 0x080fe200078efcffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000b0b117c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e917faeULL, 0x0003e2000c901c46ULL,
0x0000000a12127c10ULL, 0x000fe2000ff1e0ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000930c0c7212ULL, 0x000fc400078efcffULL, 0x0000000b05137c10ULL, 0x000fe200087fe4ffULL,
0x0000000116047824ULL, 0x000fe200078e0207ULL, 0x0000000a0c0c7c10ULL, 0x000fe2000ffde0ffULL,
0x000000208e187836ULL, 0x000fe20000000000ULL, 0x000000930a147212ULL, 0x080fe200078efcffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x0000000b0d0d7c10ULL, 0x000fe4000b7fe4ffULL,
0x000000188e067810ULL, 0x000fe20007ffe0ffULL, 0x0000001017197824ULL, 0x100fe200078e0290ULL,
0x0000000a14147c10ULL, 0x000fe2000ffde0ffULL, 0x0000001c8e0a7836ULL, 0x000fe20000000000ULL,
0x0000009304047212ULL, 0x000fe200078efcffULL, 0x0000000106087824ULL, 0x040fe200078e0299ULL,
0x0000000b0b157c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000806237824ULL, 0x040fe200078e00ffULL,
0x000000090600720cULL, 0x0c0fe20003f26070ULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x0000000a040e7c10ULL, 0x002fe2000ffde0ffULL, 0x00000001180b7824ULL, 0x100fe200078e0299ULL,
0x000000091600720cULL, 0x080fe20003f06070ULL, 0x0000000818167824ULL, 0x000fe200078e00ffULL,
0x0000000b050f7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010006047825ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee208ULL, 0x0000000010197faeULL, 0x0003e2000d101c46ULL,
0x000000030a297819ULL, 0x040fe200000006ffULL, 0x000000010a087824ULL, 0x040fe200078e0299ULL,
0xfffffff8162b7812ULL, 0x000fe200078ee20bULL, 0x000000101b1b7824ULL, 0x100fe200078e0290ULL,
0x000000090a00720cULL, 0x040fe20003f46070ULL, 0x000000010a0a7824ULL, 0x100fe200078e0207ULL,
0x0000009304167212ULL, 0x080fe200078efcffULL, 0x000000101d1d7824ULL, 0x000fe200078e0290ULL,
0x0000000718047210ULL, 0x000fe20007ffe0ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000a16167c10ULL, 0x000fe2000ffde0ffULL, 0x00000000121b7faeULL, 0x0005e2000d901c46ULL,
0xfffffff829297812ULL, 0x000fe200078ee208ULL, 0x000000248e067836ULL, 0x000fe20000000000ULL,
0x0000000b05177c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000930a107212ULL, 0x002fe200078efcffULL, 0x000000000c1d7faeULL, 0x0003e2000e901c46ULL,
0x000000090600720cULL, 0x040fe20003fa6070ULL, 0x00000001060a7824ULL, 0x040fe200078e0207ULL,
0x0000000a10107c10ULL, 0x000fe2000ffde0ffULL, 0x0000000106087824ULL, 0x000fe200078e0299ULL,
0x00000000141f7faeULL, 0x0007e2000e101c46ULL, 0x0000009304127212ULL, 0x004fe200078efcffULL,
0x000000288e047836ULL, 0x000fe20000000000ULL, 0x0000000b0b117c10ULL, 0x000fe2000b7fe4ffULL,
0x00000008061b7824ULL, 0x000fe200078e00ffULL, 0x0000000a12127c10ULL, 0x000fe2000ffde0ffULL,
0x0000000804067824ULL, 0x000fe200078e00ffULL, 0x000000091800720cULL, 0x000fe20003f66070ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000b05137c10ULL, 0x000fc4000b7fe4ffULL,
0x000000090400720cULL, 0x040fe20003f86070ULL, 0x0000000104057824ULL, 0x000fe200078e0299ULL,
0x000000930a187212ULL, 0x080fe200078efcffULL, 0x0000000104047824ULL, 0x100fe200078e0207ULL,
0x0000009023237211ULL, 0x080fe200078e20ffULL, 0x0000001021217824ULL, 0x000fe200078e0290ULL,
0xfffffff8061d7812ULL, 0x002fe200078ee205ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x0000002c8e067810ULL, 0x000fe40007ffe0ffULL, 0x0000000a18187c10ULL, 0x000fe2000ffde0ffULL,
0x000000308e147836ULL, 0x008fe20000000000ULL, 0x0000009304047212ULL, 0x000fe200078efcffULL,
0x00000001060a7824ULL, 0x000fe200078e0207ULL, 0x0000000b0b197c10ULL, 0x000fe2000b7fe4ffULL,
0x000000000e217faeULL, 0x0003e2000c101c46ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x000000090600720cULL, 0x0c0fe20003f06070ULL,
0x0000000016237faeULL, 0x0005e2000c901c46ULL, 0x0000000a04047c10ULL, 0x000fe2000ffde0ffULL,
0x0000000106087824ULL, 0x000fe200078e0299ULL, 0x000000091400720cULL, 0x000fe20003f26070ULL,
0x0000000806157824ULL, 0x000fe200078e00ffULL, 0x0000000b05057c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001140c7824ULL, 0x040fe200078e0207ULL, 0x000000902b2b7211ULL, 0x000fe200078e20ffULL,
0x0000000114067824ULL, 0x000fe200078e0299ULL, 0x000000930a0e7212ULL, 0x002fe200078efcffULL,
0x00000008141f7824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee208ULL,
0x000000348e147836ULL, 0x000fe20000000000ULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ffde0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fc400078ee206ULL,
0x0000000b0b0f7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001029297824ULL, 0x100fe200078e0290ULL,
0x000000930c0c7212ULL, 0x000fe200078efcffULL, 0x00000001140a7824ULL, 0x000fe200078e0207ULL,
0x000000901d1d7211ULL, 0x000fe200078e20ffULL, 0x000000388e067836ULL, 0x000fe20000000000ULL,
0x0000000010297faeULL, 0x000fe2000d101c46ULL, 0x000000101b1b7824ULL, 0x000fe200078e0290ULL,
0x0000000a0c0c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000003c8e167836ULL, 0x004fe20000000000ULL,
0x00000000122b7faeULL, 0x0003e2000d901c46ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000090600720cULL, 0x000fc40003f66070ULL, 0x00000000181b7faeULL, 0x0007e2000e901c46ULL,
0x0000000106087824ULL, 0x100fe200078e0207ULL, 0x000000091400720cULL, 0x080fe20003fa6070ULL,
0x0000000116077824ULL, 0x040fe200078e0207ULL, 0x000000091600720cULL, 0x000fe20003f46070ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000930a0a7212ULL, 0x080fe200078efcffULL,
0x00000000041d7faeULL, 0x0007e2000e101c46ULL, 0x0000000b0d0d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000106127824ULL, 0x042fe200078e0299ULL, 0x0000000a0a0a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000806137824ULL, 0x000fe200078e00ffULL, 0x0000009308087212ULL, 0x000fe200078efcffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000314117819ULL, 0x000fc400000006ffULL,
0x0000000b0b0b7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000114107824ULL, 0x100fe200078e0299ULL,
0x0000000a08087c10ULL, 0x000fe2000ffde0ffULL, 0x0000000116147824ULL, 0x000fe200078e0299ULL,
0x0000009306067212ULL, 0x000fe200078efcffULL, 0x0000000816177824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee210ULL, 0x0000001015157824ULL, 0x100fe200078e0290ULL,
0xfffffff813137812ULL, 0x000fe200078ee212ULL, 0x000000101f1f7824ULL, 0x100fe200078e0290ULL,
0xfffffff817177812ULL, 0x000fe200078ee214ULL, 0x0000001011117824ULL, 0x100fe200078e0290ULL,
0x0000000b09097c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001013137824ULL, 0x100fe200078e0290ULL,
0x0000000a06067c10ULL, 0x000fe2000ffde0ffULL, 0x0000001017177824ULL, 0x000fe200078e0290ULL,
0x000000000e157faeULL, 0x0007e4000c101c46ULL, 0x0000000b07077c10ULL, 0x000fc4000b7fe4ffULL,
0x000000000c1f7faeULL, 0x0007e8000c901c46ULL, 0x000000000a117faeULL, 0x0007e8000e901c46ULL,
0x0000000008137faeULL, 0x0007e8000d901c46ULL, 0x0000000006177faeULL, 0x0007e2000d101c46ULL,
0x0000000800c47947ULL, 0x000fea0003800000ULL, 0x000000088e087836ULL, 0x000fe20000000000ULL,
0x000000048e067810ULL, 0x000fe20007ffe0ffULL, 0x0000000c8e0a7836ULL, 0x000fe40000000000ULL,
0x0000000808107824ULL, 0x000fe200078e00ffULL, 0x0000009908097210ULL, 0x000fe20007ffe0ffULL,
0x0000000106057824ULL, 0x140fe400078e0299ULL, 0x00000008060e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8100d7812ULL, 0x000fe200078ee209ULL, 0x000000010a0c7824ULL, 0x140fe200078e0299ULL,
0x000000188e107810ULL, 0x000fe20007ffe0ffULL, 0x000000080a0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0b7812ULL, 0x000fe200078ee205ULL, 0x0000001c8e127836ULL, 0x000fe20000000000ULL,
0x0000009910097210ULL, 0x000fe20007ffe0ffULL, 0x000000018e047824ULL, 0x000fe200078e0299ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee20cULL, 0x000000108e0c7836ULL, 0x000fc40000000000ULL,
0x000000148e0e7836ULL, 0x000fe20000000000ULL, 0x0000000791917812ULL, 0x000fe200078ef804ULL,
0x0000000112147824ULL, 0x140fe400078e0299ULL, 0x0000000812177824ULL, 0x000fe400078e00ffULL,
0x0000000810187824ULL, 0x000fe400078e00ffULL, 0x000000010c047824ULL, 0x140fe200078e0299ULL,
0xfffffff817177812ULL, 0x000fe200078ee214ULL, 0x000000080c117824ULL, 0x000fe200078e00ffULL,
0xfffffff818157812ULL, 0x000fe200078ee209ULL, 0x000000010e057824ULL, 0x140fe200078e0299ULL,
0x000000288e187810ULL, 0x000fe20007ffe0ffULL, 0x000000080e167824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee204ULL, 0x0000002c8e1a7836ULL, 0x000fe20000000000ULL,
0x0000009918097210ULL, 0x000fe20007ffe0ffULL, 0x000000208e147836ULL, 0x000fe20000000000ULL,
0xfffffff816137812ULL, 0x000fe200078ee205ULL, 0x000000011a1c7824ULL, 0x040fe200078e0299ULL,
0x000000070c0c7210ULL, 0x000fe20007ffe0ffULL, 0x000000081a1f7824ULL, 0x000fe200078e00ffULL,
0x0000009011377211ULL, 0x000fe200078e20ffULL, 0x000000248e167836ULL, 0x000fc40000000000ULL,
0x0000000114047824ULL, 0x140fe200078e0299ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee21cULL,
0x0000000814197824ULL, 0x000fe400078e00ffULL, 0x0000000818207824ULL, 0x000fe200078e00ffULL,
0x0000000718187210ULL, 0x000fe20007ffe0ffULL, 0x0000000116057824ULL, 0x040fe200078e0299ULL,
0xfffffff819197812ULL, 0x000fe200078ee204ULL, 0x00000008161e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8201d7812ULL, 0x000fe200078ee209ULL, 0x000000308e1c7836ULL, 0x000fe20000000000ULL,
0x000000348e207810ULL, 0x000fe20007ffe0ffULL, 0x000000018e047824ULL, 0x000fe200078e0207ULL,
0xfffffff81e1b7812ULL, 0x000fe200078ee205ULL, 0x000000388e287836ULL, 0x000fe20000000000ULL,
0x000000901d9f7211ULL, 0x000fe200078e20ffULL, 0x000000011c097824ULL, 0x000fc400078e0299ULL,
0x000000081c347824ULL, 0x000fe400078e00ffULL, 0x0000010004047825ULL, 0x000fc600078e00ffULL,
0xfffffff834217812ULL, 0x000fe200078ee209ULL, 0x0000000108087824ULL, 0x000fe200078e0207ULL,
0x0000009304047212ULL, 0x000fe200078efcffULL, 0x0000000128297824ULL, 0x040fe400078e0299ULL,
0x0000000828367824ULL, 0x000fe200078e00ffULL, 0x0000000a04047c10ULL, 0x000fe2000ff1e0ffULL,
0x0000010008087825ULL, 0x000fc600078e00ffULL, 0xfffffff836a77812ULL, 0x000fe200078ee229ULL,
0x000000010a0a7824ULL, 0x100fe200078e0207ULL, 0x0000009308087212ULL, 0x000fe200078efcffULL,
0x0000003c8e2a7836ULL, 0x000fe20000000000ULL, 0x0000000b05057c10ULL, 0x000fe200087fe4ffULL,
0x000000100b297824ULL, 0x000fe200078e0290ULL, 0x0000000a08087c10ULL, 0x000fe2000ff1e0ffULL,
0x000000011c1e7824ULL, 0x000fe200078e0207ULL, 0x00000099201c7210ULL, 0x000fe20007ffe0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000b09097c10ULL, 0x000fc600087fe4ffULL,
0x000000010e0e7824ULL, 0x100fe200078e0207ULL, 0x000000930a0a7212ULL, 0x000fe200078efcffULL,
0x0000000120227824ULL, 0x140fe400078e0207ULL, 0x0000000820237824ULL, 0x000fe200078e00ffULL,
0x0000000a0a0a7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000128207824ULL, 0x100fe400078e0207ULL,
0x0000000106067824ULL, 0x100fe200078e0207ULL, 0x0000000b0b0b7c10ULL, 0x000fe200087fe4ffULL,
0x0000000110107824ULL, 0x100fe200078e0207ULL, 0xfffffff823237812ULL, 0x000fe200078ee21cULL,
0x0000000112127824ULL, 0x000fc400078e0207ULL, 0x0000000114147824ULL, 0x100fe400078e0207ULL,
0x0000000116167824ULL, 0x100fe400078e0207ULL, 0x000000011a1a7824ULL, 0x100fe400078e0207ULL,
0x000000012a287824ULL, 0x040fe200078e0207ULL, 0x000000992a077210ULL, 0x000fe20007ffe0ffULL,
0x000000100f357824ULL, 0x000fe400078e0290ULL, 0x000000082a2a7824ULL, 0x000fc400078e00ffULL,
0x000001000e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff82aa97812ULL, 0x000fe200078ee207ULL,
0x0000001013597824ULL, 0x000fe200078e0290ULL, 0x000000930e0e7212ULL, 0x000fe200078efcffULL,
0x0000010012127825ULL, 0x000fc600078e00ffULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000009312127212ULL, 0x080fe400078efcffULL,
0x0000000b0f0f7c10ULL, 0x000fe200087fe4ffULL, 0x00000010177d7824ULL, 0x100fe200078e0290ULL,
0x0000009306067212ULL, 0x000fe200078efcffULL, 0x000000100d2b7824ULL, 0x000fe200078e0290ULL,
0x0000000a12127c10ULL, 0x000fe2000ff1e0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000000a06067c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000b13137c10ULL, 0x000fe200087fe4ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000009316167212ULL, 0x080fe400078efcffULL,
0x0000000b07077c10ULL, 0x000fe20008ffe4ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000930c0c7212ULL, 0x080fe400078efcffULL, 0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL,
0x000000101b9d7824ULL, 0x100fe200078e0290ULL, 0x0000009310107212ULL, 0x000fe200078efcffULL,
0x00000010155b7824ULL, 0x000fe200078e0290ULL, 0x0000000a0c0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000a10107c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000b17177c10ULL, 0x000fe200087fe4ffULL, 0x00000010197f7824ULL, 0x100fe200078e0290ULL,
0x000000931a1a7212ULL, 0x080fe200078efcffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000000b0d0d7c10ULL, 0x000fe40008ffe4ffULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x0000009314147212ULL, 0x080fe400078efcffULL,
0x0000000b11117c10ULL, 0x000fe200097fe4ffULL, 0x000000101fa17824ULL, 0x000fe200078e0290ULL,
0x0000009318187212ULL, 0x000fe200078efcffULL, 0x000001001e1c7825ULL, 0x000fe200078e00ffULL,
0x0000000a14147c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000a18187c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001091917824ULL, 0x100fe200078e0290ULL, 0x000000931c1c7212ULL, 0x080fe200078efcffULL,
0x0000001021a37824ULL, 0x100fe200078e0290ULL, 0x0000000b1b1b7c10ULL, 0x000fe200087fe4ffULL,
0x00000100221e7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004917faeULL, 0x0003e2000b901c46ULL, 0x0000000b15157c10ULL, 0x000fe40008ffe4ffULL,
0x0000001023a57824ULL, 0x000fe200078e0290ULL, 0x000000931e1e7212ULL, 0x000fe200078efcffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000000006297faeULL, 0x0003e2000b901c46ULL,
0x0000000a1c1c7c10ULL, 0x000fc4000ff1e0ffULL, 0x0000010028227825ULL, 0x000fe200078e00ffULL,
0x0000009320207212ULL, 0x080fe200078efcffULL, 0x00000000082b7faeULL, 0x0003e2000b901c46ULL,
0x0000000b19197c10ULL, 0x000fe200097fe4ffULL, 0x00000010a7a77824ULL, 0x100fe200078e0290ULL,
0x0000009322227212ULL, 0x000fe200078efcffULL, 0x000000000a357faeULL, 0x0003e2000b901c46ULL,
0x0000000a1e1e7c10ULL, 0x000fe2000ff3e0ffULL, 0x00000010a9a97824ULL, 0x000fe200078e0290ULL,
0x0000000a20207c10ULL, 0x000fe2000ff5e0ffULL, 0x000000000c377faeULL, 0x0003e2000b901c46ULL,
0x0000000a22227c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000b1d1d7c10ULL, 0x000fe200087fe4ffULL,
0x000000000e597faeULL, 0x0003e2000b901c46ULL, 0x0000000b1f1f7c10ULL, 0x000fe40008ffe4ffULL,
0x0000000b21217c10ULL, 0x000fe200097fe4ffULL, 0x00000000105b7faeULL, 0x0003e2000b901c46ULL,
0x0000000b23237c10ULL, 0x000fc60009ffe4ffULL, 0x00000000127d7faeULL, 0x0003e8000b901c46ULL,
0x00000000147f7faeULL, 0x0003e8000b901c46ULL, 0x00000000169d7faeULL, 0x0003e8000b901c46ULL,
0x00000000189f7faeULL, 0x0003e8000b901c46ULL, 0x000000001aa17faeULL, 0x0003e8000b901c46ULL,
0x000000001ca37faeULL, 0x0003e8000b901c46ULL, 0x000000001ea57faeULL, 0x0003e8000b901c46ULL,
0x0000000020a77faeULL, 0x0003e8000b901c46ULL, 0x0000000022a97faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000108d077824ULL, 0x00afe200078e00ffULL,
0x000000088c047810ULL, 0x000fe20007ffe0ffULL, 0x000000088a057836ULL, 0x000fe20000000000ULL,
0x0000009287147211ULL, 0x080fe200078e20ffULL, 0x000000108b0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff007047812ULL, 0x000fe200078ee204ULL, 0x0000000a8c1c7836ULL, 0x000fe20000000000ULL,
0x0000009282587211ULL, 0x000fe200078e20ffULL, 0x000000108d1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff00c0c7812ULL, 0x000fe200078ee205ULL, 0x0000001089057824ULL, 0x000fc400078e0292ULL,
0x0000001004087824ULL, 0x100fe200078e0273ULL, 0xfffffff01d1c7812ULL, 0x000fe200078ee21cULL,
0x000000100c0c7824ULL, 0x000fe200078e0273ULL, 0x0000000a8a1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000108b287824ULL, 0x000fe400078e00ffULL, 0x0000001088187824ULL, 0x100fe400078e0292ULL,
0x0000001086107824ULL, 0x100fe200078e0292ULL, 0xfffffff028287812ULL, 0x000fe200078ee21dULL,
0x00000010851e7824ULL, 0x000fe200078e0292ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000504783bULL, 0x000fe20000000200ULL, 0x000000101c207824ULL, 0x100fe400078e0273ULL,
0x0000001028347824ULL, 0x000fe200078e0273ULL, 0x000000000808783bULL, 0x000e620000000200ULL,
0x00000010847c7824ULL, 0x100fe400078e0292ULL, 0x0000001083297824ULL, 0x000fe200078e0292ULL,
0x000000000c0c783bULL, 0x000ea80000000200ULL, 0x000000001818783bULL, 0x000ee80000000200ULL,
0x000000001414783bULL, 0x000f280000000200ULL, 0x000000001010783bULL, 0x000f680000000200ULL,
0x000000001e1c783bULL, 0x000fe80000000200ULL, 0x000000002020783bULL, 0x000ee80000000200ULL,
0x000000003434783bULL, 0x000f280000000200ULL, 0x000000007c7c783bULL, 0x000f280000000200ULL,
0x000000002928783bULL, 0x000f220000000200ULL, 0x000000040840723cULL, 0x002fe60000041840ULL,
0x000000005858783bULL, 0x000e660000000200ULL, 0x000000040c44723cULL, 0x004fec0000041844ULL,
0x000000060848723cULL, 0x000fe20000041848ULL, 0x0000000c8c047836ULL, 0x000fc40000000000ULL,
0x000000108d057824ULL, 0x040fe200078e00ffULL, 0x000000048d8d7819ULL, 0x000fe200000006ffULL,
0x0000000e8c8c7836ULL, 0x000fe20000000000ULL, 0x000000060c50723cULL, 0x000fe40000041850ULL,
0xfffffff005047812ULL, 0x000fe200078ee204ULL, 0x0000001081057824ULL, 0x000fe200078e0292ULL,
0xfffffff08d8c7812ULL, 0x000fe400078ee28cULL, 0x000000180c4c723cULL, 0x008fec000004184cULL,
0x0000001a0c30723cULL, 0x000fec0000041830ULL, 0x000000140c2c723cULL, 0x010fec000004182cULL,
0x000000160c24723cULL, 0x000fec0000041824ULL, 0x000000100c38723cULL, 0x020fec0000041838ULL,
0x000000120c3c723cULL, 0x000fec000004183cULL, 0x00000018085c723cULL, 0x000fe2000004185cULL,
0x000000108b0d7824ULL, 0x000fe200078e00ffULL, 0x0000000c8a0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000e8a8a7836ULL, 0x000fc40000000000ULL, 0x000000108b8b7824ULL, 0x000fe200078e00ffULL,
0x0000001a0864723cULL, 0x000fe20000041864ULL, 0x000000108c187824ULL, 0x000fc600078e0273ULL,
0xfffffff08b8a7812ULL, 0x000fe400078ee28aULL, 0x00000014086c723cULL, 0x000fe2000004186cULL,
0x000000001818783bULL, 0x000fea0000000200ULL, 0x000000160868723cULL, 0x000fe20000041868ULL,
0x0000001079147824ULL, 0x000fca00078e0292ULL, 0x000000100860723cULL, 0x000fe20000041860ULL,
0x000000001414783bULL, 0x000fea0000000200ULL, 0x000000120854723cULL, 0x000fe20000041854ULL,
0xfffffff00d107812ULL, 0x000fe200078ee20cULL, 0x00000010800c7824ULL, 0x000fc800078e0292ULL,
0x0000001c2040723cULL, 0x000fe20000041840ULL, 0x0000001004087824ULL, 0x000fe200078e0273ULL,
0x000000000c0c783bULL, 0x000fe80000000200ULL, 0x0000001c3444723cULL, 0x000fe20000041844ULL,
0x000000000504783bULL, 0x000fe80000000200ULL, 0x000000000808783bULL, 0x000ea20000000200ULL,
0x0000001e2048723cULL, 0x000fe20000041848ULL, 0x000000107b1c7824ULL, 0x000fca00078e0292ULL,
0x0000001e3450723cULL, 0x000fe20000041850ULL, 0x000000001c1c783bULL, 0x000eea0000000200ULL,
0x0000007c205c723cULL, 0x000fec000004185cULL, 0x0000007e2064723cULL, 0x000fec0000041864ULL,
0x00000028206c723cULL, 0x000fec000004186cULL, 0x0000002a2068723cULL, 0x000fec0000041868ULL,
0x000000582060723cULL, 0x002fec0000041860ULL, 0x0000007c344c723cULL, 0x000fec000004184cULL,
0x0000005a2054723cULL, 0x000fe20000041854ULL, 0x00000010107c7824ULL, 0x000fc400078e0273ULL,
0x0000001076107824ULL, 0x000fc600078e0292ULL, 0x00000028342c723cULL, 0x000fe2000004182cULL,
0x0000009275207211ULL, 0x000fe400078e20ffULL, 0x000000001010783bULL, 0x000fe60000000200ULL,
0x0000007e3430723cULL, 0x000fe20000041830ULL, 0x0000001003287824ULL, 0x100fe200078e0292ULL,
0x000000007c7c783bULL, 0x000e680000000200ULL, 0x0000002a3480723cULL, 0x000fe20000041824ULL,
0x000000002020783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000f220000000200ULL,
0x000000583438723cULL, 0x000fe20000041838ULL, 0x0000001072247824ULL, 0x000fca00078e0292ULL,
0x0000005a343c723cULL, 0x000fe2000004183cULL, 0x000000002424783bULL, 0x000fea0000000200ULL,
0x000000040840723cULL, 0x004fe20000041840ULL, 0x000000108a347824ULL, 0x000fca00078e0273ULL,
0x000000060848723cULL, 0x000fe20000041848ULL, 0x000000003434783bULL, 0x000eaa0000000200ULL,
0x0000000c085c723cULL, 0x000fec000004185cULL, 0x0000000e0864723cULL, 0x000fec0000041864ULL,
0x00000014086c723cULL, 0x000fec000004186cULL, 0x000000160868723cULL, 0x000fec0000041868ULL,
0x0000001c0860723cULL, 0x008fec0000041860ULL, 0x0000001e0808723cULL, 0x000fec0000041854ULL,
0x000000147c2c723cULL, 0x002fec000004182cULL, 0x000000121848723cULL, 0x000fec0000041848ULL,
0x0000000c7c4c723cULL, 0x000fec000004184cULL, 0x0000000e7c54723cULL, 0x000fec0000041830ULL,
0x0000002a1808723cULL, 0x010fec0000041808ULL, 0x000000167c80723cULL, 0x000fe20000041880ULL,
0x3db504f34b037820ULL, 0x000fca0000410000ULL, 0x000000047c44723cULL, 0x000fec0000041844ULL,
0x000000067c50723cULL, 0x000fec0000041850ULL, 0x0000001c7c58723cULL, 0x000fe20000041838ULL,
0x3db504f30b0b7820ULL, 0x000fca0000410000ULL, 0x0000001e7c7c723cULL, 0x000fec000004183cULL,
0x000000101884723cULL, 0x000fec0000041840ULL, 0x00000024341c723cULL, 0x004fec000004182cULL,
0x000000201840723cULL, 0x000fe2000004185cULL, 0x3db504f34a2c7820ULL, 0x000fe20000410000ULL,
0x3db504f3084a7820ULL, 0x000fe20000410000ULL, 0x00000001ff087424ULL, 0x000fc600078e00ffULL,
0x00000022183c723cULL, 0x000fec0000041864ULL, 0x000000241838723cULL, 0x000fe2000004186cULL,
0x3db504f3842f7820ULL, 0x000fe20000410000ULL, 0x3db504f3862e7820ULL, 0x000fe20000410000ULL,
0x3db504f3872d7820ULL, 0x000fc60000410000ULL, 0x000000261830723cULL, 0x000fe20000041868ULL,
0x3db504f31c1c7820ULL, 0x000fe20000410000ULL, 0x3db504f31d1d7820ULL, 0x000fe20000410000ULL,
0x3db504f31e1e7820ULL, 0x000fe20000410000ULL, 0x3db504f31f1f7820ULL, 0x000fe40000410000ULL,
0x000000281804723cULL, 0x000fe20000041860ULL, 0x3db504f340407820ULL, 0x000fe20000410000ULL,
0x3db504f341417820ULL, 0x000fe20000410000ULL, 0x3db504f342427820ULL, 0x000fe20000410000ULL,
0x3db504f343437820ULL, 0x000fc40000410000ULL, 0x000000203414723cULL, 0x000fe2000004184cULL,
0x3db504f33c3c7820ULL, 0x000fe20000410000ULL, 0x3db504f33d3d7820ULL, 0x000fe20000410000ULL,
0x3db504f33e3e7820ULL, 0x000fe20000410000ULL, 0x3db504f33f3f7820ULL, 0x000fe40000410000ULL,
0x000000223418723cULL, 0x000fe20000041854ULL, 0x3db504f338387820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fc40000410000ULL, 0x000000263420723cULL, 0x000fe20000041880ULL,
0x3db504f332327820ULL, 0x000fe20000410000ULL, 0x3db504f333337820ULL, 0x000fc80000410000ULL,
0x00000010340c723cULL, 0x000fec0000041844ULL, 0x000000283424723cULL, 0x000fe20000041858ULL,
0x3db504f330447820ULL, 0x000fe20000410000ULL, 0x3db504f304457820ULL, 0x000fe20000410000ULL,
0x3db504f305467820ULL, 0x000fe20000410000ULL, 0x3db504f306307820ULL, 0x000fe20000410000ULL,
0x3db504f30a477820ULL, 0x000fe20000410000ULL, 0x000000123410723cULL, 0x000fe20000041850ULL,
0x3db504f314147820ULL, 0x000fe20000410000ULL, 0x3db504f315157820ULL, 0x000fe20000410000ULL,
0x3db504f316167820ULL, 0x000fe20000410000ULL, 0x3db504f317177820ULL, 0x000fe20000410000ULL,
0x3db504f318187820ULL, 0x000fe20000410000ULL, 0x0000002a3428723cULL, 0x000fe2000004187cULL,
0x3db504f319197820ULL, 0x000fe20000410000ULL, 0x3db504f31a1a7820ULL, 0x000fe20000410000ULL,
0x3db504f31b1b7820ULL, 0x000fe20000410000ULL, 0x3db504f320207820ULL, 0x000fe20000410000ULL,
0x3db504f321217820ULL, 0x000fe20000410000ULL, 0x3db504f30d0d7820ULL, 0x000fe20000410000ULL,
0x3db504f348357820ULL, 0x000fe20000410000ULL, 0x3db504f309487820ULL, 0x000fe20000410000ULL,
0x3db504f349367820ULL, 0x000fe20000410000ULL, 0x01e68808970879a7ULL, 0x0002a2000850003fULL,
0x3db504f331377820ULL, 0x000fe20000410000ULL, 0x3db504f385347820ULL, 0x000fe20000410000ULL,
0x3db504f307317820ULL, 0x000fe20000410000ULL, 0x3db504f30c497820ULL, 0x000fe20000410000ULL,
0x3db504f30e0e7820ULL, 0x000fe20000410000ULL, 0x3db504f30f0f7820ULL, 0x000fe20000410000ULL,
0x3db504f322227820ULL, 0x000fe20000410000ULL, 0x3db504f310107820ULL, 0x000fe20000410000ULL,
0x3db504f311117820ULL, 0x000fe20000410000ULL, 0x3db504f312127820ULL, 0x000fe20000410000ULL,
0x3db504f313137820ULL, 0x000fe20000410000ULL, 0x3db504f323237820ULL, 0x000fe20000410000ULL,
0x3db504f324247820ULL, 0x000fe20000410000ULL, 0x3db504f325257820ULL, 0x000fe20000410000ULL,
0x3db504f326267820ULL, 0x000fe20000410000ULL, 0x3db504f327277820ULL, 0x000fe20000410000ULL,
0x3db504f328287820ULL, 0x000fe20000410000ULL, 0x3db504f329297820ULL, 0x000fe20000410000ULL,
0x3db504f32a2a7820ULL, 0x000fe20000410000ULL, 0x3db504f32b2b7820ULL, 0x002fce0000410000ULL,
0x0000000000047805ULL, 0x000fe20000015200ULL, 0x01e68809970075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006044b7210ULL, 0x000fc80007f1e1ffULL,
0x0000000705077210ULL, 0x000fe400007fe5ffULL, 0x003d09004b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000004b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x01e68809970075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000499047824ULL, 0x000fe200078e00ffULL, 0x000000967700720cULL, 0x000fe20003f06070ULL,
0x0000008078057824ULL, 0x000fc600078e0273ULL, 0xfffffff004047812ULL, 0x000fca00078ec0ffULL,
0x00000001050a7824ULL, 0x000fca00078e0204ULL, 0x01e400000a047984ULL, 0x0002a20000000c00ULL,
0x0000001c00c08947ULL, 0x000fea0003800000ULL, 0x00000002994b7824ULL, 0x040fe200078e00ffULL,
0x0000009471097248ULL, 0x000fe20007fe0000ULL, 0x0000860000097ab9ULL, 0x000fe20000000800ULL,
0x00000000990c7211ULL, 0x000fe200078ff0ffULL, 0x00008400000a7ab9ULL, 0x000fe20000000800ULL,
0x000000064b4b7812ULL, 0x000fe400078ec0ffULL, 0x0000000994947210ULL, 0x000fe20007ffe1ffULL,
0x000000080c4e7836ULL, 0x000fe20000000000ULL, 0x00008c00ff087b82ULL, 0x000ee20000000a00ULL,
0x000000084b4f7c36ULL, 0x000fe20008000000ULL, 0x000000ff94727210ULL, 0x000fe20007ffe1ffULL,
0x0000000a4b4d7c36ULL, 0x000fe20008000000ULL, 0x00000009ff4c7c19ULL, 0x000fe2000801160cULL,
0x000000100c507836ULL, 0x000fe20000000000ULL, 0x000000944f00720cULL, 0x000fe20003f26070ULL,
0x000000180c0c7836ULL, 0x000fe20000000000ULL, 0x000000054f4f7e46ULL, 0x000fc4000b800072ULL,
0x000000054c4c7c48ULL, 0x000fe4000bfe0000ULL, 0x00000004ff4f7819ULL, 0x000fe4000001164fULL,
0x000000944d00720cULL, 0x000fe20003f06070ULL, 0x000000044c797c24ULL, 0x000fe2000f8e02ffULL,
0x000000054d5a7e46ULL, 0x000fe4000b800072ULL, 0x00000009ff4e7c19ULL, 0x000fe4000801164eULL,
0x000000ff4f547207ULL, 0x000fc40000800000ULL, 0x000000ff5a5a7207ULL, 0x000fe40000000000ULL,
0x000000054e4e7c48ULL, 0x000fe2000bfe0000ULL, 0x00000001794f7824ULL, 0x000fe200078e0254ULL,
0x00000009ff507c19ULL, 0x000fe40008011650ULL, 0x000000795a517211ULL, 0x000fe200078fe0ffULL,
0x000000044e7b7c24ULL, 0x000fe2000f8e02ffULL, 0x00000009ff4c7c19ULL, 0x000fe2000801160cULL,
0x000000024f4e7825ULL, 0x008fe200078e0008ULL, 0x00000005500c7c48ULL, 0x000fc4000bfe0000ULL,
0x0000007b5a537211ULL, 0x000fe200078fe0ffULL, 0x0000000251507825ULL, 0x000fe200078e0008ULL,
0x000000104b557812ULL, 0x000fe200078efcffULL, 0x000000064e4f7981ULL, 0x000722000c1e9500ULL,
0x000000054c4c7c48ULL, 0x000fe2000bfe0000ULL, 0x000000040c7d7c24ULL, 0x000fe4000f8e02ffULL,
0x00000006500c7981ULL, 0x000b22000c1e9500ULL, 0x00000001545d7824ULL, 0x000fe400078e027bULL,
0x0000007d5a5f7211ULL, 0x000fe200078fe0ffULL, 0x0000000154617824ULL, 0x000fc400078e027dULL,
0x0000000253527825ULL, 0x000fc800078e0008ULL, 0x000000025f5e7825ULL, 0x000fc800078e0008ULL,
0x000000025d5c7825ULL, 0x100fe200078e0008ULL, 0x00000008555b7c10ULL, 0x000fe2000fffe0ffULL,
0x000000065e4e7981ULL, 0x00cea4000c1e9500ULL, 0x0000000261607825ULL, 0x000fe400078e0008ULL,
0x000000065c517981ULL, 0x022ee4000c1e9500ULL, 0x0000000a55577c36ULL, 0x000fe40008000000ULL,
0x000000044c817c24ULL, 0x000fc4000f8e02ffULL, 0x00000006524c7981ULL, 0x0002e2000c1e9500ULL,
0x000000945700720cULL, 0x080fe20003f06070ULL, 0x0000000154597824ULL, 0x000fe200078e0281ULL,
0x000000815a637211ULL, 0x000fe400078fe0ffULL, 0x000000055b547e46ULL, 0x000fe2000b800072ULL,
0x0000000660537981ULL, 0x0022a2000c1e9500ULL, 0x0000000557527e46ULL, 0x000fe2000b800072ULL,
0x0000000259587825ULL, 0x100fe200078e0008ULL, 0x000000945b00720cULL, 0x000fe40003f26070ULL,
0x000000ff52687207ULL, 0x000fe20000000000ULL, 0x0000000263627825ULL, 0x000fe200078e0008ULL,
0x00000004ff547819ULL, 0x000fe20000011654ULL, 0x0000000658597981ULL, 0x000f62000c1e9500ULL,
0x00000079685d7211ULL, 0x000fc400078fe0ffULL, 0x000000ff54567207ULL, 0x000fe20000800000ULL,
0x0000000662507981ULL, 0x000364000c1e9500ULL, 0x0000007b68617211ULL, 0x002fe200078fe0ffULL,
0x000000025d5c7825ULL, 0x000fc800078e0008ULL, 0x00000001795f7824ULL, 0x000fe200078e0256ULL,
0x000000065c527981ULL, 0x000362000c1e9500ULL, 0x0000000156657824ULL, 0x040fe400078e027dULL,
0x0000000156637824ULL, 0x000fe400078e027bULL, 0x000000025f5e7825ULL, 0x000fc800078e0008ULL,
0x0000000261607825ULL, 0x100fe200078e0008ULL, 0x000000065e5b7981ULL, 0x000366000c1e9500ULL,
0x0000000263627825ULL, 0x100fe200078e0008ULL, 0x0000000660547981ULL, 0x000366000c1e9500ULL,
0x00000002655c7825ULL, 0x002fe200078e0008ULL, 0x000000204b657812ULL, 0x000fe200078efcffULL,
0x0000000662697981ULL, 0x000f64000c1e9500ULL, 0x0000000156677824ULL, 0x000fe200078e0281ULL,
0x00000008655f7c10ULL, 0x000fe2000fffe0ffULL, 0x000000065c6b7981ULL, 0x000362000c1e9500ULL,
0x0000007d686f7211ULL, 0x040fe200078fe0ffULL, 0x0000000267607825ULL, 0x000fe200078e0008ULL,
0x0000008168777211ULL, 0x000fc400078fe0ffULL, 0x000000055f647e46ULL, 0x000fe2000b800072ULL,
0x0000000a65677c36ULL, 0x000fe20008000000ULL, 0x000000945f00720cULL, 0x080fe20003f26070ULL,
0x000000026f6e7825ULL, 0x000fe200078e0008ULL, 0x00000004ff647819ULL, 0x000fe20000011664ULL,
0x00000006606d7981ULL, 0x000362000c1e9500ULL, 0x000000946700720cULL, 0x000fe20003f06070ULL,
0x0000000277767825ULL, 0x000fe200078e0008ULL, 0x00000005675e7e46ULL, 0x000fe2000b800072ULL,
0x000000066e567981ULL, 0x000364000c1e9500ULL, 0x000000ff645c7207ULL, 0x002fc40000800000ULL,
0x000000ff5e6a7207ULL, 0x000fe20000000000ULL, 0x0000000676587981ULL, 0x000364000c1e9500ULL,
0x000000015c617824ULL, 0x000fe200078e027bULL, 0x0000007b6a6f7211ULL, 0x000fc600078fe0ffULL,
0x0000000261607825ULL, 0x000fe200078e0008ULL, 0x000000796a637211ULL, 0x000fc600078fe0ffULL,
0x000000026f6e7825ULL, 0x000fe200078e0008ULL, 0x0000000660cb7981ULL, 0x000f62000c1e9500ULL,
0x0000007d6a5d7211ULL, 0x000fc600078fe0ffULL, 0x000000066e667981ULL, 0x000f62000c1e9500ULL,
0x0000000179777824ULL, 0x002fe200078e025cULL, 0x000000816a5f7211ULL, 0x000fe200078fe0ffULL,
0x0000000263627825ULL, 0x000fc800078e0008ULL, 0x000000015c7f7824ULL, 0x040fe200078e027dULL,
0x0000000662647981ULL, 0x000362000c1e9500ULL, 0x000000015c837824ULL, 0x000fe400078e0281ULL,
0x0000000277767825ULL, 0x000fe200078e0008ULL, 0x000000304bb17812ULL, 0x000fc600078efcffULL,
0x000000025d5c7825ULL, 0x100fe200078e0008ULL, 0x0000000676757981ULL, 0x000366000c1e9500ULL,
0x000000025f5e7825ULL, 0x100fe200078e0008ULL, 0x000000065ccf7981ULL, 0x000366000c1e9500ULL,
0x000000027f627825ULL, 0x102fe200078e0008ULL, 0x000000065ed37981ULL, 0x000f66000c1e9500ULL,
0x00000002836e7825ULL, 0x000fe200078e0008ULL, 0x00000008b1777c10ULL, 0x000fe2000fffe0ffULL,
0x0000000662807981ULL, 0x000f68000c1e9500ULL, 0x000000066e847981ULL, 0x000362000c1e9500ULL,
0x0000000ab1b37c36ULL, 0x000fe20008000000ULL, 0x00000005776c7e46ULL, 0x000fc4000b800072ULL,
0x000000947700720cULL, 0x080fe40003f26070ULL, 0x00000004ff5d7819ULL, 0x000fe4000001166cULL,
0x00000094b300720cULL, 0x000fe40003f06070ULL, 0x00000005b35c7e46ULL, 0x000fe4000b800072ULL,
0x000000ff5d727207ULL, 0x000fe40000800000ULL, 0x000000ff5c6c7207ULL, 0x000fc60000000000ULL,
0x0000000179777824ULL, 0x000fe200078e0272ULL, 0x000000796c6f7211ULL, 0x002fe200078fe0ffULL,
0x00000001725f7824ULL, 0x000fe200078e027dULL, 0x0000007d6c5d7211ULL, 0x000fe200078fe0ffULL,
0x0000000277767825ULL, 0x000fc800078e0008ULL, 0x000000026f6e7825ULL, 0x100fe400078e0008ULL,
0x0000000676767981ULL, 0x000f64000c1e9500ULL, 0x000000025d5c7825ULL, 0x100fe400078e0008ULL,
0x000000066eb57981ULL, 0x000364000c1e9500ULL, 0x000000025f5e7825ULL, 0x000fe400078e0008ULL,
0x000000065cd17981ULL, 0x000f62000c1e9500ULL, 0x0000007b6c617211ULL, 0x000fc600078fe0ffULL,
0x000000065e827981ULL, 0x000f62000c1e9500ULL, 0x0000000172637824ULL, 0x000fe400078e027bULL,
0x0000000261607825ULL, 0x000fc800078e0008ULL, 0x0000000263627825ULL, 0x000fe200078e0008ULL,
0x0000000660cd7981ULL, 0x000f62000c1e9500ULL, 0x000000816c6f7211ULL, 0x002fc600078fe0ffULL,
0x00000006627e7981ULL, 0x000f62000c1e9500ULL, 0x0000000172817824ULL, 0x000fe400078e0281ULL,
0x000000026f6e7825ULL, 0x000fc800078e0008ULL, 0x0000000281087825ULL, 0x000fe200078e0008ULL,
0x000000066ed57981ULL, 0x000f68000c1e9500ULL, 0x0000000608867981ULL, 0x000364000c1e9500ULL,
0xfffffff05a097812ULL, 0x002fca00078ec0ffULL, 0x0000000194087824ULL, 0x000fe200078e0209ULL,
0x0000000100c97802ULL, 0x000fc60000000f00ULL, 0x000000014d097824ULL, 0x000fe200078e0a08ULL,
0x000000014b617812ULL, 0x000fc800078efcffULL, 0x00000009c9097219ULL, 0x000fe200000006ffULL,
0x0000000a615d7c36ULL, 0x000fe20008000000ULL, 0xfffffff0685f7812ULL, 0x000fc600078ec0ffULL,
0x000000015d5a7824ULL, 0x100fe200078e0a08ULL, 0x000000084b777812ULL, 0x040fe400078efcffULL,
0x000000094b797812ULL, 0x000fe400078efcffULL, 0x0000005f945e7210ULL, 0x000fe40007ffe0ffULL,
0x0000005ac95f7219ULL, 0x000fe200000006ffULL, 0x0000000a77637c36ULL, 0x000fe40008000000ULL,
0x0000000a797b7c36ULL, 0x000fe20008000000ULL, 0xfffffff06a6f7812ULL, 0x000fe200078ec0ffULL,
0x00000001635c7824ULL, 0x100fe200078e0a08ULL, 0xfffffff06c7d7812ULL, 0x000fe200078ec0ffULL,
0x000000017b087824ULL, 0x000fe200078e0a08ULL, 0x000000114b817812ULL, 0x000fe200078efcffULL,
0x0000000194607824ULL, 0x040fe200078e026fULL, 0x0000005cc96f7219ULL, 0x040fe200000006ffULL,
0x00000001946c7824ULL, 0x000fe200078e027dULL, 0x00000008c97d7219ULL, 0x000fe200000006ffULL,
0x0000000a81837c36ULL, 0x000fc40008000000ULL, 0x0000000157087824ULL, 0x100fe400078e0a5eULL,
0x00000001835a7824ULL, 0x000fe200078e0a5eULL, 0x000000184b877812ULL, 0x000fe400078efcffULL,
0x000054100c0c7816ULL, 0x010fc8000000004fULL, 0x0000000c09ff7212ULL, 0x000fc800078ac0ffULL,
0x000000944d00720cULL, 0x000fc80002fa1470ULL, 0x000000944b00720cULL, 0x000fe40002fa1070ULL,
0x0000000c5fff7212ULL, 0x000fe4000788c0ffULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x000000945d00720cULL, 0x000fe40002781470ULL, 0x000054104c4c7816ULL, 0x008fc80000000051ULL,
0x0000004c09ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004c5fff7212ULL, 0x000fe400078ac0ffULL,
0x000054104e4e7816ULL, 0x004fc80000000053ULL, 0x0000004e09ff7212ULL, 0x000fe4000782c0ffULL,
0x000000944d00720cULL, 0x0c0fe40001741470ULL, 0x000000944d00720cULL, 0x080fe40000f21470ULL,
0x000000945d00720cULL, 0x080fe40002fa1470ULL, 0x000000944b00720cULL, 0x0c0fe40001741070ULL,
0x000000944b00720cULL, 0x000fc40000f21070ULL, 0x000000946100720cULL, 0x0c0fe40002781070ULL,
0x000000946100720cULL, 0x000fe40002fa1070ULL, 0x0000541050507816ULL, 0x020fe40000000059ULL,
0xff8000002e2e7808ULL, 0x000fe40001000000ULL, 0xff80000049497808ULL, 0x000fe40000800000ULL,
0xff80000034347808ULL, 0x000fc40002000000ULL, 0xff8000002d2d7808ULL, 0x000fe40002800000ULL,
0x0000000c6fff7212ULL, 0x000fe4000786c0ffULL, 0x0000005009ff7212ULL, 0x000fe4000780c0ffULL,
0x0000004e5fff7212ULL, 0x040fe4000784c0ffULL, 0x000000505fff7212ULL, 0x000fe4000782c0ffULL,
0x0000004c7dff7212ULL, 0x000fc4000788c0ffULL, 0x0000004e6fff7212ULL, 0x000fe400078ac0ffULL,
0x000000944d00720cULL, 0x080fe40000701470ULL, 0x000000945d00720cULL, 0x0c0fe40001741470ULL,
0x000000945d00720cULL, 0x080fe40000f21470ULL, 0x000000946300720cULL, 0x0c0fe40001f61470ULL,
0x000000946300720cULL, 0x000fc40002fa1470ULL, 0x000000947b00720cULL, 0x080fe40002781470ULL,
0x000000944b00720cULL, 0x080fe40000701070ULL, 0x000000946100720cULL, 0x0c0fe40001741070ULL,
0x000000946100720cULL, 0x080fe40000f21070ULL, 0x000000947700720cULL, 0x0c0fe40001f61070ULL,
0x000000947700720cULL, 0x000fc40002fa1070ULL, 0x000000947900720cULL, 0x000fe40002781070ULL,
0x00000008c97f7219ULL, 0x040fe400000006ffULL, 0x0000005ac9857219ULL, 0x000fe400000006ffULL,
0x0000541052527816ULL, 0x000fe4000000005bULL, 0x0000541054547816ULL, 0x000fe40000000069ULL,
0x000000194b8d7812ULL, 0x000fe200078efcffULL, 0x0000000a87897c36ULL, 0x000fe20008000000ULL,
0xff8000000e0e7808ULL, 0x000fc40000000000ULL, 0xff8000000d0d7808ULL, 0x000fe40001000000ULL,
0xff8000000f0f7808ULL, 0x000fe40000800000ULL, 0xff80000035357808ULL, 0x000fe40001800000ULL,
0xff80000010107808ULL, 0x000fe40002800000ULL, 0xff80000003037808ULL, 0x000fe40002000000ULL,
0x0000004c6fff7212ULL, 0x000fc4000780c0ffULL, 0x0000004e7dff7212ULL, 0x000fe4000784c0ffULL,
0x000000506fff7212ULL, 0x080fe4000782c0ffULL, 0x000000507dff7212ULL, 0x000fe4000786c0ffULL,
0x0000005285ff7212ULL, 0x000fe400078ac0ffULL, 0x000000547fff7212ULL, 0x000fe4000788c0ffULL,
0x0000000a8d917c10ULL, 0x000fe2000fffe0ffULL, 0x00000001895c7824ULL, 0x000fe200078e0a5eULL,
0x000000946300720cULL, 0x000fc40000701470ULL, 0x000000946300720cULL, 0x080fe40000f21470ULL,
0x000000947b00720cULL, 0x0c0fe40001741470ULL, 0x000000947b00720cULL, 0x080fe40001f61470ULL,
0x000000945700720cULL, 0x080fe40002781470ULL, 0x000000948300720cULL, 0x000fe40002fa1470ULL,
0x000000915e5e7210ULL, 0x000fc40007ffe1ffULL, 0x000000947700720cULL, 0x0c0fe40000701070ULL,
0x000000947700720cULL, 0x080fe40000f21070ULL, 0x000000947900720cULL, 0x0c0fe40001741070ULL,
0x000000947900720cULL, 0x080fe40001f61070ULL, 0x000000945500720cULL, 0x080fe40002781070ULL,
0x000000948100720cULL, 0x000fc40002fa1070ULL, 0x0000005cc98b7219ULL, 0x040fe400000006ffULL,
0x0000005ec9937219ULL, 0x000fe400000006ffULL, 0x0000541056567816ULL, 0x000fe4000000006bULL,
0x0000541058587816ULL, 0x000fe4000000006dULL, 0xff8000002c2c7808ULL, 0x000fe40000000000ULL,
0xff80000012127808ULL, 0x000fc40000800000ULL, 0xff80000011117808ULL, 0x000fe40001000000ULL,
0xff80000013137808ULL, 0x000fe40001800000ULL, 0xff80000042427808ULL, 0x000fe40002000000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0x000000527fff7212ULL, 0x080fe4000780c0ffULL,
0x000000528bff7212ULL, 0x000fc4000782c0ffULL, 0x000000567fff7212ULL, 0x040fe4000784c0ffULL,
0x000000587fff7212ULL, 0x000fe4000786c0ffULL, 0x0000005685ff7212ULL, 0x000fe4000788c0ffULL,
0x0000005493ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000167627824ULL, 0x000fe200078e0a60ULL,
0x000000945700720cULL, 0x0c0fe40000701470ULL, 0x000000945700720cULL, 0x000fc40001741470ULL,
0x000000945700720cULL, 0x080fe40001f61470ULL, 0x000000948300720cULL, 0x080fe40002781470ULL,
0x000000948900720cULL, 0x080fe40000f21470ULL, 0x000000949100720cULL, 0x080fe40002fa1470ULL,
0x000000214b9f7812ULL, 0x000fe400078efcffULL, 0x000000945500720cULL, 0x000fc40000701070ULL,
0x000000945500720cULL, 0x0c0fe40001741070ULL, 0x000000945500720cULL, 0x080fe40001f61070ULL,
0x000000948100720cULL, 0x080fe40002781070ULL, 0x000000948700720cULL, 0x080fe40000f21070ULL,
0x000000948d00720cULL, 0x000fe40002fa1070ULL, 0x00000062c99d7219ULL, 0x000fc400000006ffULL,
0x0000541066667816ULL, 0x000fe200000000cbULL, 0x0000000a9fa17c36ULL, 0x000fe20008000000ULL,
0xff80000040407808ULL, 0x000fe40000000000ULL, 0xff80000014147808ULL, 0x000fe40001000000ULL,
0xff80000016167808ULL, 0x000fe40001800000ULL, 0xff80000015157808ULL, 0x000fe40002000000ULL,
0xff8000003c3c7808ULL, 0x000fc40000800000ULL, 0xff8000003f3f7808ULL, 0x000fe40002800000ULL,
0x0000005485ff7212ULL, 0x040fe4000780c0ffULL, 0x0000005885ff7212ULL, 0x000fe4000784c0ffULL,
0x000000548bff7212ULL, 0x000fe4000786c0ffULL, 0x0000005693ff7212ULL, 0x040fe4000788c0ffULL,
0x0000005893ff7212ULL, 0x000fc4000782c0ffULL, 0x000000669dff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a1687824ULL, 0x000fe200078e0a60ULL, 0x000000948300720cULL, 0x0c0fe40000701470ULL,
0x000000948300720cULL, 0x080fe40001741470ULL, 0x000000948900720cULL, 0x080fe40001f61470ULL,
0x000000949100720cULL, 0x0c0fe40002781470ULL, 0x000000949100720cULL, 0x000fc40000f21470ULL,
0x000000946700720cULL, 0x080fe40002fa1470ULL, 0x000000284ba57812ULL, 0x040fe400078efcffULL,
0x000000294bab7812ULL, 0x000fe400078efcffULL, 0x000000948100720cULL, 0x0c0fe40000701070ULL,
0x000000948100720cULL, 0x080fe40001741070ULL, 0x000000948700720cULL, 0x000fc40001f61070ULL,
0x000000948d00720cULL, 0x0c0fe40002781070ULL, 0x000000948d00720cULL, 0x080fe40000f21070ULL,
0x000000946500720cULL, 0x000fe40002fa1070ULL, 0x00000068c9a37219ULL, 0x000fe400000006ffULL,
0x0000541064647816ULL, 0x000fe40000000075ULL, 0x00005410cf807816ULL, 0x000fc40000000080ULL,
0x00005410d3847816ULL, 0x000fe20000000084ULL, 0x0000000aa5a77c36ULL, 0x000fe20008000000ULL,
0xff80000043437808ULL, 0x000fe20000000000ULL, 0x0000000aabad7c36ULL, 0x000fe20008000000ULL,
0xff80000017177808ULL, 0x000fe40001000000ULL, 0xff8000003e3e7808ULL, 0x000fe40001800000ULL,
0xff80000019197808ULL, 0x000fe40002000000ULL, 0xff8000001b1b7808ULL, 0x000fc40000800000ULL,
0xff8000003a3a7808ULL, 0x000fe40002800000ULL, 0x0000000c7dff7212ULL, 0x000fe400078cc0ffULL,
0x000000568bff7212ULL, 0x040fe4000780c0ffULL, 0x000000588bff7212ULL, 0x000fe4000784c0ffULL,
0x000000649dff7212ULL, 0x040fe4000786c0ffULL, 0x000000809dff7212ULL, 0x000fc4000788c0ffULL,
0x000000849dff7212ULL, 0x000fe4000782c0ffULL, 0x00000080a3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a76a7824ULL, 0x100fe200078e0a60ULL, 0x000000947b00720cULL, 0x080fe200037c1470ULL,
0x00000001ad607824ULL, 0x000fe200078e0a60ULL, 0x000000948900720cULL, 0x0c0fe40000701470ULL,
0x000000948900720cULL, 0x080fe40001741470ULL, 0x000000946700720cULL, 0x000fc40001f61470ULL,
0x000000946700720cULL, 0x0c0fe40002781470ULL, 0x000000946700720cULL, 0x080fe40000f21470ULL,
0x00000094a100720cULL, 0x080fe40002fa1470ULL, 0x000000947900720cULL, 0x080fe400037c1070ULL,
0x000000948700720cULL, 0x0c0fe40000701070ULL, 0x000000948700720cULL, 0x000fc40001741070ULL,
0x000000946500720cULL, 0x0c0fe40001f61070ULL, 0x000000946500720cULL, 0x0c0fe40002781070ULL,
0x000000946500720cULL, 0x080fe40000f21070ULL, 0x000000949f00720cULL, 0x000fe40002fa1070ULL,
0x0000006ac9a97219ULL, 0x040fe400000006ffULL, 0x00000060c9af7219ULL, 0x000fc400000006ffULL,
0xff80000036367808ULL, 0x000fe40003000000ULL, 0xff80000018187808ULL, 0x000fe40000000000ULL,
0xff8000001a1a7808ULL, 0x000fe40001000000ULL, 0xff80000038387808ULL, 0x000fe40001800000ULL,
0xff8000001c1c7808ULL, 0x000fe40002000000ULL, 0xff8000001e1e7808ULL, 0x000fc40000800000ULL,
0xff8000001d1d7808ULL, 0x000fe40002800000ULL, 0x0000005293ff7212ULL, 0x000fe400078cc0ffULL,
0x00000064a3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000064a9ff7212ULL, 0x000fe4000784c0ffULL,
0x00000066a3ff7212ULL, 0x040fe4000786c0ffULL, 0x00000084a3ff7212ULL, 0x000fc4000788c0ffULL,
0x00000066a9ff7212ULL, 0x000fe4000782c0ffULL, 0x00000080afff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b36e7824ULL, 0x000fe200078e0a6cULL, 0x000000949100720cULL, 0x080fe400037c1470ULL,
0x00000094a100720cULL, 0x0c0fe40000701470ULL, 0x00000094a100720cULL, 0x0c0fe40001f61470ULL,
0x00000094a100720cULL, 0x000fc40002781470ULL, 0x00000094a700720cULL, 0x0c0fe40001741470ULL,
0x00000094a700720cULL, 0x080fe40000f21470ULL, 0x00000094ad00720cULL, 0x000fe40002fa1470ULL,
0x000000314bb97812ULL, 0x040fe400078efcffULL, 0x000000384bbf7812ULL, 0x040fe400078efcffULL,
0x000000394bc57812ULL, 0x000fc400078efcffULL, 0x000000948d00720cULL, 0x080fe400037c1070ULL,
0x000000949f00720cULL, 0x0c0fe40000701070ULL, 0x000000949f00720cULL, 0x0c0fe40001f61070ULL,
0x000000949f00720cULL, 0x080fe40002781070ULL, 0x00000094a500720cULL, 0x0c0fe40001741070ULL,
0x00000094a500720cULL, 0x000fc40000f21070ULL, 0x00000094ab00720cULL, 0x000fe40002fa1070ULL,
0x0000006ec9b77219ULL, 0x000fe400000006ffULL, 0x00005410b5767816ULL, 0x000fe40000000076ULL,
0x00005410d1827816ULL, 0x000fe20000000082ULL, 0x0000000ab9bb7c36ULL, 0x000fe20008000000ULL,
0x0000000ac5c77c10ULL, 0x000fe2000fffe0ffULL, 0x0000000abfc17c36ULL, 0x000fe20008000000ULL,
0xff8000003d3d7808ULL, 0x000fc40003000000ULL, 0xff80000039397808ULL, 0x000fe40000000000ULL,
0xff8000003b3b7808ULL, 0x000fe40001800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff80000044447808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40000800000ULL,
0xff80000021217808ULL, 0x000fc40002800000ULL, 0x00000064afff7212ULL, 0x040fe400078cc0ffULL,
0x00000066afff7212ULL, 0x000fe4000780c0ffULL, 0x00000080a9ff7212ULL, 0x040fe4000786c0ffULL,
0x00000084a9ff7212ULL, 0x080fe4000788c0ffULL, 0x00000084afff7212ULL, 0x000fe4000784c0ffULL,
0x00000076b7ff7212ULL, 0x000fc4000782c0ffULL, 0x00000082b7ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c17c7824ULL, 0x100fe200078e0a6cULL, 0x000000bb6c727210ULL, 0x000fe20007ffe1ffULL,
0x00000001c76c7824ULL, 0x000fe200078e0a6cULL, 0x00000094a700720cULL, 0x0c0fe40001f61470ULL,
0x00000094a700720cULL, 0x080fe40002781470ULL, 0x00000094ad00720cULL, 0x0c0fe400037c1470ULL,
0x00000094ad00720cULL, 0x000fc40000701470ULL, 0x00000094ad00720cULL, 0x080fe40001741470ULL,
0x00000094b300720cULL, 0x0c0fe40000f21470ULL, 0x00000094b300720cULL, 0x000fe40002fa1470ULL,
0x00000072c9bd7219ULL, 0x040fe400000006ffULL, 0x0000007cc9c37219ULL, 0x000fe400000006ffULL,
0x00000094a500720cULL, 0x000fc40001f61070ULL, 0x00000094a500720cULL, 0x080fe40002781070ULL,
0x00000094ab00720cULL, 0x0c0fe400037c1070ULL, 0x00000094ab00720cULL, 0x0c0fe40000701070ULL,
0x00000094ab00720cULL, 0x080fe40001741070ULL, 0x00000094b100720cULL, 0x0c0fe40000f21070ULL,
0x00000094b100720cULL, 0x000fc40002fa1070ULL, 0x0000006cc9c97219ULL, 0x000fe400000006ffULL,
0x00005410cd7e7816ULL, 0x000fe4000000007eULL, 0xff80000020207808ULL, 0x000fe40001800000ULL,
0xff80000022227808ULL, 0x000fe40002000000ULL, 0xff80000037377808ULL, 0x000fe40003000000ULL,
0xff80000033337808ULL, 0x000fc40000000000ULL, 0xff80000023237808ULL, 0x000fe40001000000ULL,
0xff80000045457808ULL, 0x000fe40000800000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0x00000076bdff7212ULL, 0x080fe4000786c0ffULL, 0x00000076c3ff7212ULL, 0x080fe4000788c0ffULL,
0x00000076c9ff7212ULL, 0x000fc400078cc0ffULL, 0x0000007eb7ff7212ULL, 0x080fe4000780c0ffULL,
0x0000007ebdff7212ULL, 0x080fe4000784c0ffULL, 0x0000007ec3ff7212ULL, 0x000fe4000782c0ffULL,
0x00000082bdff7212ULL, 0x000fe400078ac0ffULL, 0x00000094b300720cULL, 0x080fe40000701470ULL,
0x00000094bb00720cULL, 0x000fc40001f61470ULL, 0x00000094bb00720cULL, 0x0c0fe40001741470ULL,
0x00000094bb00720cULL, 0x080fe40002fa1470ULL, 0x00000094c100720cULL, 0x080fe40002781470ULL,
0x00000094c700720cULL, 0x080fe400037c1470ULL, 0x00000094c100720cULL, 0x080fe40000f21470ULL,
0x00000094b100720cULL, 0x000fc40000701070ULL, 0x00000094b900720cULL, 0x0c0fe40001f61070ULL,
0x00000094b900720cULL, 0x0c0fe40001741070ULL, 0x00000094b900720cULL, 0x080fe40002fa1070ULL,
0x00000094bf00720cULL, 0x0c0fe40002781070ULL, 0x00000094bf00720cULL, 0x080fe40000f21070ULL,
0x00000094c500720cULL, 0x000fc400037c1070ULL, 0x00005410d5867816ULL, 0x000fe40000000086ULL,
0xff80000030307808ULL, 0x000fe40000000000ULL, 0xff80000046467808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fe40002800000ULL,
0xff8000004a4a7808ULL, 0x000fc40002000000ULL, 0xff80000047477808ULL, 0x000fe40000800000ULL,
0xff80000048487808ULL, 0x000fe40003000000ULL, 0x0000007ec9ff7212ULL, 0x000fe4000780c0ffULL,
0x00000082c3ff7212ULL, 0x080fe4000786c0ffULL, 0x00000082c9ff7212ULL, 0x000fe4000784c0ffULL,
0x00000086b7ff7212ULL, 0x000fc400078ac0ffULL, 0x00000086bdff7212ULL, 0x080fe4000788c0ffULL,
0x00000086c3ff7212ULL, 0x080fe4000782c0ffULL, 0x00000086c9ff7212ULL, 0x000fe400078cc0ffULL,
0x00000094b300720cULL, 0x080fe40002fa1470ULL, 0x00000094bb00720cULL, 0x080fe40002781470ULL,
0x00000094c100720cULL, 0x000fc40001f61470ULL, 0x00000094c100720cULL, 0x080fe40000f21470ULL,
0x00000094c700720cULL, 0x0c0fe40000701470ULL, 0x00000094c700720cULL, 0x0c0fe40001741470ULL,
0x00000094c700720cULL, 0x080fe400037c1470ULL, 0x00000094b100720cULL, 0x080fe40002fa1070ULL,
0x00000094b900720cULL, 0x000fc40002781070ULL, 0x00000094c500720cULL, 0x080fe40000701070ULL,
0x00000094bf00720cULL, 0x0c0fe40001f61070ULL, 0x00000094bf00720cULL, 0x080fe40000f21070ULL,
0x00000094c500720cULL, 0x0c0fe40001741070ULL, 0x00000094c500720cULL, 0x000fe400037c1070ULL,
0xff8000000b0b7808ULL, 0x000fc40000000000ULL, 0xff80000028287808ULL, 0x000fe40001800000ULL,
0xff80000029297808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff8000002b2b7808ULL, 0x000fce0003000000ULL, 0x0000002f0400720bULL, 0x004fe20003f1e000ULL,
0x3f80000000097882ULL, 0x000fe20000000000ULL, 0xfffffff8ff8f7812ULL, 0x000fe200078ee28fULL,
0x000000ffff777224ULL, 0x000fe200078e009bULL, 0x000000042f097208ULL, 0x000fc80004000000ULL,
0x000000340900720bULL, 0x000fc80003f1e000ULL, 0x0000000934047208ULL, 0x000fc80004000000ULL,
0x000000350400720bULL, 0x000fc80003f1e000ULL, 0x0000000435097208ULL, 0x000fc80004000000ULL,
0x000000360900720bULL, 0x000fc80003f1e000ULL, 0x0000000936097208ULL, 0x000fc80004000000ULL,
0x000000400900720bULL, 0x000fc80003f1e000ULL, 0x0000000940047208ULL, 0x000fc80004000000ULL,
0x000000410400720bULL, 0x000fc80003f1e000ULL, 0x0000000441097208ULL, 0x000fc80004000000ULL,
0x0000003c0900720bULL, 0x000fc80003f1e000ULL, 0x000000093c047208ULL, 0x000fc80004000000ULL,
0x0000003d0400720bULL, 0x000fc80003f1e000ULL, 0x000000043d097208ULL, 0x000fc80004000000ULL,
0x000000380900720bULL, 0x000fc80003f1e000ULL, 0x0000000938047208ULL, 0x000fc80004000000ULL,
0x000000390400720bULL, 0x000fc80003f1e000ULL, 0x0000000439097208ULL, 0x000fc80004000000ULL,
0x000000440900720bULL, 0x000fc80003f1e000ULL, 0x0000000944047208ULL, 0x000fc80004000000ULL,
0x000000370400720bULL, 0x000fc80003f1e000ULL, 0x0000000437047208ULL, 0x000fc80004000000ULL,
0x000000450400720bULL, 0x000fc80003f1e000ULL, 0x0000000445097208ULL, 0x000fc80004000000ULL,
0x000000460900720bULL, 0x000fc80003f1e000ULL, 0x0000000946097208ULL, 0x000fc80004000000ULL,
0x0000004a0900720bULL, 0x000fc80003f1e000ULL, 0x000000094a097208ULL, 0x000fe40004000000ULL,
0x0000002e0500720bULL, 0x000fe40003f1e000ULL, 0x000000480900720bULL, 0x000fe40003f3e000ULL,
0x000000052e047208ULL, 0x000fe40004000000ULL, 0x0000000948097208ULL, 0x000fe40004800000ULL,
0x0000002d0400720bULL, 0x000fc60003f1e000ULL, 0x0c401f0009087f89ULL, 0x000ea200000e0000ULL,
0x000000042d057208ULL, 0x000fc80004000000ULL, 0x0000002c0500720bULL, 0x000fc80003f1e000ULL,
0x000000052c047208ULL, 0x000fc80004000000ULL, 0x000000030400720bULL, 0x000fc80003f1e000ULL,
0x0000000403057208ULL, 0x000fc80004000000ULL, 0x000000420500720bULL, 0x000fe40003f1e000ULL,
0x000000080900720bULL, 0x004fe40003f3e000ULL, 0x0000000542047208ULL, 0x000fe40004000000ULL,
0x00000009080c7208ULL, 0x000fe40004800000ULL, 0x000000430400720bULL, 0x000fc60003f1e000ULL,
0x0c201f000c097f89ULL, 0x000ea200000e0000ULL, 0x0000000443057208ULL, 0x000fc80004000000ULL,
0x0000003e0500720bULL, 0x000fc80003f1e000ULL, 0x000000053e047208ULL, 0x000fc80004000000ULL,
0x0000003f0400720bULL, 0x000fc80003f1e000ULL, 0x000000043f057208ULL, 0x000fc80004000000ULL,
0x0000003a0500720bULL, 0x000fe40003f1e000ULL, 0x000000090c00720bULL, 0x004fe40003f3e000ULL,
0x000000053a087208ULL, 0x000fe40004000000ULL, 0x0000000c09047208ULL, 0x000fe40004800000ULL,
0x0000003b0800720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b044d7820ULL, 0x000fe20000410000ULL,
0x000000083b057208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001084dULL,
0x000000320500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b36097823ULL, 0x100fe2000001084dULL, 0x0000002f004c7308ULL, 0x000fe20000000800ULL,
0x0000000532087208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b40367823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001084dULL, 0x3fb8aa3b3c407823ULL, 0x100fe2000001084dULL,
0x000000330800720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b483c7823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b41417823ULL, 0x100fe2000001084dULL, 0x00000034004f7308ULL, 0x0005e20000000800ULL,
0x0000000833057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b37377823ULL, 0x000fc4000001084dULL, 0x000000300500720bULL, 0x000fc60003f1e000ULL,
0x0000000900517308ULL, 0x0007e20000000800ULL, 0x0000000530087208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b39347823ULL, 0x004fc6000001084dULL, 0x000000310800720bULL, 0x000fc60003f1e000ULL,
0x00000035004e7308ULL, 0x0005e20000000800ULL, 0x0000000831087208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b38097823ULL, 0x108fe2000001084dULL, 0x3fb8aa3b44387823ULL, 0x000fe4000001084dULL,
0x000000470800720bULL, 0x000fc60003f1e000ULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x0000000847087208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4a357823ULL, 0x004fc6000001084dULL,
0x0000000b0800720bULL, 0x000fc60003f1e000ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x000000080b087208ULL, 0x000fe40004000000ULL, 0x000000490600720bULL, 0x000fc60003f1e000ULL,
0x0c401f00082f7f89ULL, 0x000ea200000e0000ULL, 0x0000000649067208ULL, 0x000fe20004000000ULL,
0x0000004000407308ULL, 0x000fe60000000800ULL, 0x0000000d0600720bULL, 0x000fc80003f1e000ULL,
0x000000060d057208ULL, 0x000fe20004000000ULL, 0x0000003d003d7308ULL, 0x000fe60000000800ULL,
0x000000100500720bULL, 0x000fc80003f1e000ULL, 0x0000000510067208ULL, 0x000fe20004000000ULL,
0x0000000900097308ULL, 0x000fe60000000800ULL, 0x000000110600720bULL, 0x000fe40003f1e000ULL,
0x0000002f0800720bULL, 0x004fe40003f3e000ULL, 0x0000000611057208ULL, 0x000fe20004000000ULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0x000000082f0c7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b45087823ULL, 0x100fe2000001084dULL, 0x000000140500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b462f7823ULL, 0x000fc4000001084dULL, 0x0c201f000c4b7f89ULL, 0x000ea200000e0000ULL,
0x0000000514067208ULL, 0x000fe20004000000ULL, 0x0000003800387308ULL, 0x000fe60000000800ULL,
0x000000150600720bULL, 0x000fc80003f1e000ULL, 0x0000000615057208ULL, 0x000fe20004000000ULL,
0x0000003700377308ULL, 0x000fe60000000800ULL, 0x000000180500720bULL, 0x000fc80003f1e000ULL,
0x0000000518067208ULL, 0x000fe20004000000ULL, 0x0000000800087308ULL, 0x000fe60000000800ULL,
0x000000190600720bULL, 0x000fe40003f1e000ULL, 0x0000004b0c00720bULL, 0x004fe40003f3e000ULL,
0x0000000619397208ULL, 0x000fe20004000000ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x0000000c4b057208ULL, 0x000fc40004800000ULL, 0x0000001c3900720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b05447820ULL, 0x000fe20000410000ULL, 0x000000391c067208ULL, 0x000fe20004000000ULL,
0x0000003500357308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b2d457823ULL, 0x100fe20000010844ULL,
0x0000001d0600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010844ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010844ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010844ULL,
0x000000061d397208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010844ULL,
0x0000003100467308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010844ULL,
0x000000203900720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010844ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010844ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010844ULL,
0x0000003920067208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b03397823ULL, 0x100fe20000010844ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010844ULL,
0x000000210600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010844ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010844ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010844ULL,
0x00000006212d7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b47477823ULL, 0x000fe20000010844ULL,
0x0000000e0700720bULL, 0x000fe20003f1e000ULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x000000242d00720bULL, 0x000fc40003f3e000ULL, 0x000000070e067208ULL, 0x000fe40004000000ULL,
0x0000002d240c7208ULL, 0x000fe40004800000ULL, 0x0000000f0600720bULL, 0x000fe20003f1e000ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000250c00720bULL, 0x000fe40003f3e000ULL,
0x000000060f037208ULL, 0x000fe40004000000ULL, 0x0000000c25077208ULL, 0x000fc40004800000ULL,
0x000000120300720bULL, 0x000fe20003f1e000ULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x000000280700720bULL, 0x000fe40003f3e000ULL, 0x0000000312067208ULL, 0x000fe40004000000ULL,
0x00000007280c7208ULL, 0x000fe40004800000ULL, 0x000000130600720bULL, 0x000fe20003f1e000ULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x000000290c00720bULL, 0x000fc40003f3e000ULL,
0x0000000613037208ULL, 0x000fe40004000000ULL, 0x0000000c290c7208ULL, 0x000fe40004800000ULL,
0x000000160300720bULL, 0x000fe20003f1e000ULL, 0x0000003f003f7308ULL, 0x000fe40000000800ULL,
0x0c401f000c077f89ULL, 0x000ea200000e0000ULL, 0x0000000316067208ULL, 0x000fc80004000000ULL,
0x000000170600720bULL, 0x000fe20003f1e000ULL, 0x0000004200427308ULL, 0x000fe60000000800ULL,
0x0000000617037208ULL, 0x000fc80004000000ULL, 0x0000001a0300720bULL, 0x000fe20003f1e000ULL,
0x0000004300437308ULL, 0x000fe60000000800ULL, 0x000000031a067208ULL, 0x000fc80004000000ULL,
0x0000001b0600720bULL, 0x000fe20003f1e000ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x000000070c00720bULL, 0x004fe40003f3e000ULL, 0x000000061b037208ULL, 0x000fe40004000000ULL,
0x0000000c070c7208ULL, 0x000fe40004800000ULL, 0x0000001e0300720bULL, 0x000fe20003f1e000ULL,
0x0000003300337308ULL, 0x000fe40000000800ULL, 0x0c201f000c2d7f89ULL, 0x000ea200000e0000ULL,
0x000000031e067208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b30037823ULL, 0x000fc60000010844ULL,
0x0000001f0600720bULL, 0x000fe20003f1e000ULL, 0x0000000b00447308ULL, 0x000fe60000000800ULL,
0x000000061f077208ULL, 0x000fc80004000000ULL, 0x000000220700720bULL, 0x000fe20003f1e000ULL,
0x0000003a003a7308ULL, 0x000fe60000000800ULL, 0x0000000722067208ULL, 0x000fc80004000000ULL,
0x000000230600720bULL, 0x000fe20003f1e000ULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x0000002d0c00720bULL, 0x004fe40003f3e000ULL, 0x0000000623077208ULL, 0x000fe40004000000ULL,
0x0000000c2d067208ULL, 0x000fe40004800000ULL, 0x000000260700720bULL, 0x000fe20003f1e000ULL,
0x0000003c003c7308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b06307820ULL, 0x000fe20000410000ULL,
0x00000007260c7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010830ULL,
0x000000270c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010830ULL, 0x0000002000537308ULL, 0x000fe20000000800ULL,
0x0000000c27077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010830ULL,
0x0000002a0700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010830ULL, 0x0000000d00487308ULL, 0x000fe20000000800ULL,
0x000000072a0c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010830ULL,
0x0000002b0c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010830ULL, 0x00000011004a7308ULL, 0x000fe20000000800ULL,
0x0000000c2b0c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b28287823ULL, 0x000fc40000010830ULL,
0x0c401f000c077f89ULL, 0x000ea400000e0000ULL, 0x0000001400317308ULL, 0x000ff00000000800ULL,
0x0000004900497308ULL, 0x000ef00000000800ULL, 0x0000001500507308ULL, 0x000fe20000000800ULL,
0x000000070c00720bULL, 0x004fce0003f1e000ULL, 0x00000018004b7308ULL, 0x000fe20000000800ULL,
0x0000000c07077208ULL, 0x000fca0004000000ULL, 0x0c201f00070c7f89ULL, 0x000ea400000e0000ULL,
0x00000010000b7308ULL, 0x0007f00000000800ULL, 0x0000001c004d7308ULL, 0x0009e20000000800ULL,
0x000000494810723eULL, 0x008fc400000010ffULL, 0x000000088f487810ULL, 0x000fca0007ffe0ffULL,
0x0000001900527308ULL, 0x000fe20000000800ULL, 0x00000008481c7824ULL, 0x010fe200078e00ffULL,
0x0000000c0700720bULL, 0x004fcc0003f1e000ULL, 0x0000002500587308ULL, 0x0005e20000000800ULL,
0x000000070c077208ULL, 0x000fe40004000000ULL, 0x0000004c4f0c723eULL, 0x000fe200000010ffULL,
0x000000188f4c7836ULL, 0x000fe20000000000ULL, 0x0000000399ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b07207820ULL, 0x000fe40000410000ULL, 0x00000029005a7308ULL, 0x000fe20000000800ULL,
0x000000034c307819ULL, 0x000fe200000006ffULL, 0x3fb8aa3b0e0d7823ULL, 0x100fe20000010820ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010820ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010820ULL,
0x3fb8aa3b13137823ULL, 0x000fe20000010820ULL, 0x0000004e510e723eULL, 0x000fc400000010ffULL,
0x0000000d00117308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010820ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010820ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010820ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010820ULL, 0x3fb8aa3b1f257823ULL, 0x104fe20000010820ULL,
0x3fb8aa3b22227823ULL, 0x000fe40000010820ULL, 0x0000000f00147308ULL, 0x0005220000000800ULL,
0x0000002e450d723eULL, 0x008fce00000010ffULL, 0x0000001200157308ULL, 0x0007e20000000800ULL,
0x0000002c390f723eULL, 0x004fe200000010ffULL, 0x00000009ff2c7e24ULL, 0x000fe4000f8e00ffULL,
0x3fb8aa3b27397823ULL, 0x000fe20000010820ULL, 0x000000323327723eULL, 0x000fe400000010ffULL,
0x000000111411723eULL, 0x010fe200000010ffULL, 0x0000001300187308ULL, 0x000ea20000000800ULL,
0x000000038e147812ULL, 0x000fe400078ec0ffULL, 0x3f8000002c2c783eULL, 0x000fc400000010ffULL,
0x0000000b4a12723eULL, 0x008fe200000010ffULL, 0x000000108f4a7836ULL, 0x000fe20000000000ULL,
0x0000002c00337202ULL, 0x000fe20000000f00ULL, 0x000000ffff2d7224ULL, 0x000fe200078e002cULL,
0x0000001a000b7308ULL, 0x0007e20000000800ULL, 0x000000084a2e7824ULL, 0x000fe200078e00ffULL,
0x00000004998e7810ULL, 0x000fe20007ffe08eULL, 0x000000ffff327224ULL, 0x000fe200078e002cULL,
0x000000151813723eULL, 0x004fe200000010ffULL, 0x0000000114157824ULL, 0x000fe400078e0299ULL,
0x3fb8aa3b1b147823ULL, 0x000fe20000010820ULL, 0x0000001d00547308ULL, 0x000fe20000000800ULL,
0x0000002c0c18723cULL, 0x008fe200000418ffULL, 0x000000078e8e7812ULL, 0x000fc400078ec0ffULL,
0x0000000715157812ULL, 0x000fc800078ec0ffULL, 0x0000001e00297308ULL, 0x0005e20000000800ULL,
0xfffffff81c497812ULL, 0x000fe400078ee215ULL, 0xfffffff82e4f7812ULL, 0x000fe400078ee215ULL,
0xfffffff830517812ULL, 0x000fc600078ee215ULL, 0x0000002100567308ULL, 0x000fe20000000800ULL,
0x0000002c101c723cULL, 0x004fee00000418ffULL, 0x0000002400557308ULL, 0x000eb00000000800ULL,
0x0000002800577308ULL, 0x000ee20000000800ULL, 0x000000555858723eULL, 0x004fce00000010ffULL,
0x0000001600217308ULL, 0x0005e20000000800ULL, 0x000000575a5a723eULL, 0x008fce00000010ffULL,
0x0000001700247308ULL, 0x0007220000000800ULL, 0x000000088f167824ULL, 0x004fca00078e00ffULL,
0xfffffff816457812ULL, 0x000fe400078ee215ULL, 0x0000001400287308ULL, 0x0005620000000800ULL,
0x000000403d16723eULL, 0x000fe200000010ffULL, 0x000000ffff407224ULL, 0x000fe200078e002cULL,
0x0000003e3f17723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b2a3d7823ULL, 0x100fe20000010820ULL,
0x000000424315723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b2b3e7823ULL, 0x000fe20000010820ULL,
0x000000212421723eULL, 0x010fe200000010ffULL, 0x00000025002e7308ULL, 0x0007220000000800ULL,
0x000000364114723eULL, 0x004fe200000010ffULL, 0x000000ffff417224ULL, 0x000fc400078e002cULL,
0x3fb8aa3b26367823ULL, 0x000fe20000010820ULL, 0x000000ffff2a7224ULL, 0x100fe200078e002cULL,
0x000000093424723eULL, 0x000fe200000010ffULL, 0x000000ffff2b7224ULL, 0x000fe200078e002cULL,
0x000000383726723eULL, 0x000fe200000010ffULL, 0x00000022002d7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b23257823ULL, 0x008fe20000010820ULL, 0x000000315020723eULL, 0x000fe200000010ffULL,
0x000000401418723cULL, 0x000fe20000041818ULL, 0x0000000b2823723eULL, 0x022fe200000010ffULL,
0x000000088f097824ULL, 0x000fe200078e00ffULL, 0x0000004d5428723eULL, 0x000fe200000010ffULL,
0x00000008480b7824ULL, 0x000fe200078e00ffULL, 0x0000002500307308ULL, 0x0002e20000000800ULL,
0x0000004b5222723eULL, 0x004fe200000010ffULL, 0x000000084c377824ULL, 0x000fe200078e00ffULL,
0x000000292e29723eULL, 0x010fe200000010ffULL, 0x000000ffff2e7224ULL, 0x000fe200078e002cULL,
0xfffffff809097812ULL, 0x000fe200078ee28eULL, 0x000000ffff387224ULL, 0x000fe200078e000cULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee28eULL, 0x0000002a201c723cULL, 0x000fe2000004181cULL,
0x0000003a3b25723eULL, 0x002fe200000010ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e002cULL,
0x0000002c003b7202ULL, 0x000fe20000000f00ULL, 0x0000000300037308ULL, 0x000e620000000800ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000dULL, 0xfffffff837377812ULL, 0x000fe200078ee28eULL,
0x000000ffff0d7224ULL, 0x000fe200078e000fULL, 0x00000053562a723eULL, 0x000fc400000010ffULL,
0x0000002d302b723eULL, 0x008fe200000010ffULL, 0x000000322418723cULL, 0x000fe20000041818ULL,
0x0000004700477308ULL, 0x000ea20000000800ULL, 0x000000082f30723eULL, 0x000fe200000010ffULL,
0x000000ffff2f7224ULL, 0x000fe200078e002cULL, 0x00000017000f7202ULL, 0x000fe20000000f00ULL,
0x000000084a2d7824ULL, 0x000fe400078e00ffULL, 0x000000353c32723eULL, 0x000fe200000010ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e0024ULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x000000034631723eULL, 0x002fe200000010ffULL, 0x0000100078037824ULL, 0x000fe200078e0273ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee28eULL, 0x0000003a281c723cULL, 0x000fe2000004181cULL,
0x000000ffff3f7224ULL, 0x000fe200078e0032ULL, 0x000000474433723eULL, 0x004fc400000010ffULL,
0x0000003900397308ULL, 0x000e620000000800ULL, 0x0001200003087836ULL, 0x000fe40000000000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0014ULL, 0x00000016003b7202ULL, 0x000fe20000000f00ULL,
0x0000001009097824ULL, 0x100fe200078e0208ULL, 0x0000000845457211ULL, 0x000fe200078e20ffULL,
0x0000002e3018723cULL, 0x000fe20000041818ULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x0000001049497824ULL, 0x100fe400078e0208ULL, 0x000000100b0b7824ULL, 0x000fc400078e0208ULL,
0x000000ffff147224ULL, 0x000fe200078e0025ULL, 0x0000001200257202ULL, 0x000fe20000000f00ULL,
0x000000ffff167224ULL, 0x000fe200078e0031ULL, 0x0000003e003e7308ULL, 0x000ea20000000800ULL,
0x000000363959723eULL, 0x002fe200000010ffULL, 0x000000ffff397224ULL, 0x000fe400078e000eULL,
0x000000ffff0e7224ULL, 0x000fe400078e0015ULL, 0x000000ffff157224ULL, 0x000fe200078e0027ULL,
0x0000003845007844ULL, 0x0003e20000000200ULL, 0x000000ffff177224ULL, 0x000fe200078e0033ULL,
0x0000005a00337202ULL, 0x000fe20000000f00ULL, 0x000000ffff247224ULL, 0x000fc400078e0010ULL,
0x000000104f4f7824ULL, 0x000fe400078e0208ULL, 0x000000ffff277224ULL, 0x000fe200078e0022ULL,
0x0000003d3e5b723eULL, 0x004fe200000010ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0030ULL,
0x00000026003d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe400078e0020ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x0000002e581c723cULL, 0x000fe2000004181cULL,
0x000000102d2d7824ULL, 0x000fe200078e0208ULL, 0x0000003c09007844ULL, 0x0003e20000000200ULL,
0x000000ffff307224ULL, 0x000fc400078e0028ULL, 0x000000ffff317224ULL, 0x000fe200078e002aULL,
0x0000000c49007844ULL, 0x0003e20000000200ULL, 0x000000ffff327224ULL, 0x000fe400078e0058ULL,
0x000000ffff117224ULL, 0x000fe200078e0013ULL, 0x000000140b007844ULL, 0x0003e20000000200ULL,
0x0000001051517824ULL, 0x100fe400078e0208ULL, 0x000000ffff127224ULL, 0x000fe200078e0021ULL,
0x0000002b00217202ULL, 0x000fe20000000f00ULL, 0x000000ffff137224ULL, 0x000fe200078e0023ULL,
0x000000244f007844ULL, 0x0003e20000000200ULL, 0x0000001037377824ULL, 0x000fe200078e0208ULL,
0x0000000100087802ULL, 0x000fe20000000f00ULL, 0x000000ffff207224ULL, 0x000fe200078e0029ULL,
0x000000302d007844ULL, 0x0003e20000000200ULL, 0x000000ffff227224ULL, 0x000fc400078e0059ULL,
0x000000ffff237224ULL, 0x000fe200078e005bULL, 0x0000001051007844ULL, 0x0003e20000000200ULL,
0x000000ffff197224ULL, 0x000fe400078e001aULL, 0x000000ffff1a7224ULL, 0x000fe200078e001cULL,
0x0000002037007844ULL, 0x0003e20000000200ULL, 0x000000ffff1b7224ULL, 0x000fc600078e001eULL,
0x01e000040a008388ULL, 0x0003e80000000c00ULL, 0x01e200180a008388ULL, 0x0003e20000000c00ULL,
0x000000709b00720cULL, 0x000fe20003f06070ULL, 0x01e6080895ff79a7ULL, 0x0003e2000850003fULL,
0x01e6100895ff79a7ULL, 0x0003e2000850003fULL, 0x01e6180895ff79a7ULL, 0x0003e2000850003fULL,
0x01e6200895ff79a7ULL, 0x0003f2000850003fULL, 0xffffff7c00248947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000083037836ULL, 0x000fe20000000000ULL,
0x0000013000007945ULL, 0x000fe80003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000008300038308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff067807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000306ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff83ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000083057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000306ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008300037308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffffe7c04107950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x000000000000044fULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000005d0ULL, 0x00000000000001f8ULL, 0x0000001300000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000007c8ULL, 0x00000000000000d0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000898ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000008ecULL, 0x0000000000000520ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000e10ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000e10ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000000e58ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000000e80ULL, 0x0000000000018480ULL, 0x0000001300000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000019300ULL, 0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000019340ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000019340ULL, 0x0000000000000268ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000019928ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000019928ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000000e58ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000e80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000018480ULL, 0x0000000000018480ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019300ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000019340ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000268ULL, 0x0000000000000268ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_0_m_32_sm_90_cubin_len = 105080;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
