/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000130c0ULL, 0x0000000000012d40ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x4545386a4c45386aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c00010000036aULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000003afULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0022000003f5ULL, 0x00000000000114b0ULL, 0x0000000000000170ULL, 0x000b002200000428ULL,
0x0000000000011620ULL, 0x0000000000000040ULL, 0x000b002200000453ULL, 0x0000000000011660ULL,
0x0000000000000050ULL, 0x000b00220000047dULL, 0x00000000000116b0ULL, 0x0000000000000150ULL,
0x000a0003000004ebULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000400030000050bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000700030000053bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000011800ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000114b000000000ULL, 0x0000040400000000ULL, 0x810c000001200400ULL,
0x0044000400288080ULL, 0x0000000000000000ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8808288080850828ULL, 0x2880808908288080ULL, 0x8094082880809108ULL, 0x0828808096082880ULL,
0x8080980828808097ULL, 0x80162880808c0828ULL, 0x0000000310288082ULL, 0x808c920000000000ULL,
0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x000114b000000000ULL,
0x0000017000000000ULL, 0x0000480400000000ULL, 0x8080288080890900ULL, 0x0000000000002880ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8908288080880828ULL, 0x2880808c08288080ULL,
0x8094082880809008ULL, 0x0828808096082880ULL, 0x8080ae0828808098ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080ae92ULL, 0x0000001cffffffffULL, 0x0000012000000000ULL,
0x0001162000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8908288080880828ULL, 0x2880808c08288080ULL, 0x8094082880809008ULL,
0x0828808096082880ULL, 0x8080980828808097ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880809892ULL, 0x0000002cffffffffULL, 0x000001b800000000ULL, 0x0001166000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x808c288080980900ULL, 0x0000000000002880ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8908288080880828ULL, 0x2880809008288080ULL,
0x8096082880809408ULL, 0x0828808097082880ULL, 0x80808c0828808098ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808c92ULL, 0x0000001cffffffffULL, 0x0000026000000000ULL,
0x000116b000000000ULL, 0x0000015000000000ULL, 0x0000000000000000ULL, 0x0000001800082f04ULL,
0x0008230400000074ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001100082304ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008230400000000ULL, 0x0000000000000018ULL,
0x0000001800081204ULL, 0x0008110400000000ULL, 0x0000000000000018ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0048016000000015ULL, 0x000c170400481903ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff01542904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000f001542804ULL, 0x0000033000000120ULL, 0x000021e000001290ULL,
0x000023b0000022a0ULL, 0x0000273000002520ULL, 0x000027b000002760ULL, 0x00002e8000002800ULL,
0x00003d9000003cf0ULL, 0x0000402000003ec0ULL, 0x0000426000004230ULL, 0x00004300000042b0ULL,
0x000054b0000046b0ULL, 0x0000568000005550ULL, 0x000059f0000057e0ULL, 0x00005a7000005a20ULL,
0x00005e8000005ac0ULL, 0x00006d3000006c90ULL, 0x00006fb000006e50ULL, 0x000071f0000071c0ULL,
0x0000729000007240ULL, 0x000077a000007790ULL, 0x00009b1000009af0ULL, 0x0000a3000000a2c0ULL,
0x0000fcd00000fc90ULL, 0x0000fcf00000fce0ULL, 0x0000fd600000fd00ULL, 0x0000fda00000fd80ULL,
0x00010a8000010a30ULL, 0x00010b2000010ad0ULL, 0x00010be000010b80ULL, 0x00010c8000010c30ULL,
0x00010d1000010cc0ULL, 0x00010dc000010d70ULL, 0x00010e6000010e10ULL, 0x00010f0000010eb0ULL,
0x00010fb000010f60ULL, 0x0001105000011000ULL, 0x000110f0000110a0ULL, 0x000111a000011150ULL,
0x00011250000111f0ULL, 0x00011310000112b0ULL, 0x000113d000011370ULL, 0x0001149000011430ULL,
0x0000020002003904ULL, 0x00013600000000ffULL, 0x00000250003f0100ULL, 0x000136080000000bULL,
0x00000310003f0120ULL, 0x000136880000000bULL, 0x00000410003f0120ULL, 0x00013600000000ffULL,
0x00000510003f0107ULL, 0x0001368c0000000aULL, 0x00000580003f0102ULL, 0x000136880000000aULL,
0x00001ea0003f0101ULL, 0x000136080000000cULL, 0x00001f00003f0101ULL, 0x0001360c00000016ULL,
0x000020d0003f0105ULL, 0x0001360c00000016ULL, 0x00002e20003f0105ULL, 0x0001368800000063ULL,
0x00003a50003f0101ULL, 0x0001362800000016ULL, 0x00003a70003f0101ULL, 0x0001362c00000016ULL,
0x00003c40003f0105ULL, 0x0001362c00000016ULL, 0x00004660003f0105ULL, 0x0001369000000063ULL,
0x00005210003f0101ULL, 0x0001364800000016ULL, 0x00005230003f0101ULL, 0x0001364c00000016ULL,
0x00005400003f0105ULL, 0x0001364c00000016ULL, 0x00005e20003f0105ULL, 0x0001369800000063ULL,
0x000069f0003f0101ULL, 0x0001366800000016ULL, 0x00006a10003f0101ULL, 0x0001366c00000016ULL,
0x00006be0003f0105ULL, 0x0001366c00000016ULL, 0x000075b0003f0105ULL, 0x000136a000000063ULL,
0x0000ae40003f0101ULL, 0x00013600000000ffULL, 0x0000b920003f0101ULL, 0x00013604000000ffULL,
0x0000baf0003f0105ULL, 0x00013604000000ffULL, 0x0000f0e0003f0105ULL, 0x0000000000000061ULL,
0x0000f1c0003f0101ULL, 0x0000000400000061ULL, 0x0000f390003f0105ULL, 0x0000000400000061ULL,
0x00010890003f0105ULL, 0x0001360800000007ULL, 0x000108f0003f0101ULL, 0x0001361000000007ULL,
0x00010950003f0101ULL, 0x0001361800000007ULL, 0x000109c0003f0101ULL, 0x0001362000000007ULL,
0x00033803003f0101ULL, 0x0000ab4000141c04ULL, 0x0000bb500000adb0ULL, 0x00010a000000bbd0ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002e4ULL, 0x0000001800000002ULL,
0x000000000000023cULL, 0x0000001800000002ULL, 0x00000000000001a4ULL, 0x0000001800000002ULL,
0x00000000000000fcULL, 0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL,
0x00000000000002c0ULL, 0x0000001800000002ULL, 0x0000000000000218ULL, 0x0000001800000002ULL,
0x0000000000000180ULL, 0x0000001800000002ULL, 0x00000000000000d5ULL, 0x0000001800000002ULL,
0x0000000000013700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000000117806ULL, 0x000fe200038e0000ULL, 0x00005800ff067624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001100077300ULL, 0x000ee200000e0000ULL, 0x0000000806067824ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x0000000000037919ULL, 0x000ea80000002200ULL,
0x0000000000107919ULL, 0x000ee20000002600ULL, 0x0000001100137309ULL, 0x0002a60000000000ULL,
0x0000000000087919ULL, 0x000ee80000000000ULL, 0x00000000000f7919ULL, 0x000ee20000002700ULL,
0x00000005ff577819ULL, 0x002fcc000001160bULL, 0x00001fff57577589ULL, 0x000fe200000e0000ULL,
0x00000004ff597e24ULL, 0x010fe4000f8e00ffULL, 0x0000010004007a24ULL, 0x004fe400078e0203ULL,
0x00001fff04047589ULL, 0x000e6200000e0000ULL, 0x0000000810057824ULL, 0x008fe400078e00ffULL,
0x00000000000b7a24ULL, 0x000fe400078e020bULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x000000080700720cULL, 0x000fc40003f62070ULL, 0x000000ff0b00720cULL, 0x040fe20003f05270ULL,
0x0000000f06087224ULL, 0x000fe200078e0205ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x0000007f0b00780cULL, 0x000fd20003f44070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe200078e00ffULL, 0x0000005704057211ULL, 0x002fe200078e10ffULL,
0x3fffffc0ff069424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff079424ULL, 0x000fe200078e00ffULL,
0x01360002ff008388ULL, 0x0003e20000000a00ULL, 0x000000030b00780cULL, 0x000fe20003f04070ULL,
0x0000000205097824ULL, 0x000fe200078e00ffULL, 0x00000004ff0c7819ULL, 0x004fe20000011600ULL,
0x00000100ff057424ULL, 0x000fe200078e00ffULL, 0x013608060b009388ULL, 0x0005e20000008a00ULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x00000008090a7817ULL, 0x040fe20007800000ULL,
0x00000001090d7824ULL, 0x000fc400078e020cULL, 0xff317217ff12a424ULL, 0x000fe200078e00ffULL,
0x000000f00e117812ULL, 0x000fe200078ec0ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a09ULL,
0x0000000d08027210ULL, 0x002fe20007ffe0ffULL, 0x3fffff60ff088424ULL, 0x000fe200078e00ffULL,
0x013400120b00a388ULL, 0x000fe20000004800ULL, 0x7fffff60ff098424ULL, 0x000fe400078e00ffULL,
0x00005c0002027625ULL, 0x000fc600078e0005ULL, 0x013688080b008388ULL, 0x000fe20000008a00ULL,
0x000000010d077824ULL, 0x004fc600078e0200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000100d147824ULL, 0x000fe200078e00ffULL, 0x0000000a0c00720cULL, 0x000fe20003f06070ULL,
0x00000004ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000001102067210ULL, 0x000fe40007f3e0ffULL,
0xfffffff014027812ULL, 0x000fc400078ee207ULL, 0x80000013ff0c7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe400008e0603ULL, 0x00000010020d7824ULL, 0x000fe400078e00ffULL,
0x000060000f027625ULL, 0x000fc600078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0136040cffff338cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01360000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000602557981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0400720cULL, 0x000fc40003f05270ULL, 0x000000ff55547810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff547819ULL, 0x000fce0000011654ULL, 0x0000a8e000008947ULL, 0x000fea0003800000ULL,
0x00000008570a7824ULL, 0x000fe400078e00ffULL, 0x00000003ff037424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01368c030aff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000159097810ULL, 0x000fe20007ffe0ffULL,
0x013688000aff7f8cULL, 0x0007e2000c80043fULL, 0x00000001ff027819ULL, 0x000fe40000011657ULL,
0x000000540900720cULL, 0x000fe40003f06070ULL, 0x000000010f047819ULL, 0x000fe200000006ffULL,
0x0000002002037824ULL, 0x004fe200078e00ffULL, 0x0000580010077a10ULL, 0x002fc40007ffe0ffULL,
0x00000001570b7812ULL, 0x000fe200078ec0ffULL, 0x00000100590d7824ULL, 0x000fe400078e0203ULL,
0x0000580004047a24ULL, 0x000fc800078e0207ULL, 0x0000620004187a24ULL, 0x000fe200078e020dULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0000000d55067217ULL, 0x008fe20007800000ULL,
0x000000080b177824ULL, 0x000fe200078e00ffULL, 0x00000003ff097819ULL, 0x100fe20000011600ULL,
0x0000000202167824ULL, 0x000fe400078e020bULL, 0x0000000106067824ULL, 0x000fe200078e0a0dULL,
0x00000009180c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000109077824ULL, 0x100fe200078e0200ULL,
0xfffffff817177812ULL, 0x000fe400078ee200ULL, 0x0000002006087817ULL, 0x000fc40003800000ULL,
0x00000007070d7812ULL, 0x000fe200078ec0ffULL, 0x00005e000c067625ULL, 0x000fe200078e0005ULL,
0x000000080900720cULL, 0x040fe40003f06070ULL, 0x0000b00016167811ULL, 0x000fe400078e68ffULL,
0x00000004090f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001017067825ULL, 0x000fe200078e0006ULL,
0x0000000809117810ULL, 0x040fe40007ffe0ffULL, 0x0000000c09137810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0c7824ULL, 0x100fe200078e0200ULL, 0x0ffffff80d0d7812ULL, 0x100fe200078ef800ULL,
0x000000080f197824ULL, 0x000fe200078e00ffULL, 0x0000001009157810ULL, 0x000fe20007ffe0ffULL,
0x00000001110e7824ULL, 0x100fe200078e0200ULL, 0x000000160d0d7211ULL, 0x000fe200078e20ffULL,
0x00000008111b7824ULL, 0x000fe200078e00ffULL, 0x00000014091f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000113107824ULL, 0x000fe200078e0200ULL, 0x0000001809217810ULL, 0x000fe20007ffe0ffULL,
0x00000008131d7824ULL, 0x000fe200078e00ffULL, 0x0000001c09237810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c46ULL,
0xfffffff819197812ULL, 0x000fe200078ee20cULL, 0x00000008151a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee20eULL, 0x00000001180c7824ULL, 0x040fe200078e0213ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL, 0x00000001180e7824ULL, 0x040fe200078e0215ULL,
0x000000080f00720cULL, 0x080fe20003f06070ULL, 0x000000011f097824ULL, 0x100fe200078e0200ULL,
0x000000081100720cULL, 0x080fe20003f26070ULL, 0x000000081f1c7824ULL, 0x000fe200078e00ffULL,
0x000000081300720cULL, 0x080fe20003f46070ULL, 0x0000000115077824ULL, 0x142fe200078e0200ULL,
0x000000081500720cULL, 0x080fe20003f66070ULL, 0x0000000118067824ULL, 0x040fe200078e020fULL,
0x000000081f00720cULL, 0x080fe20003f86070ULL, 0x0000000118127824ULL, 0x040fe200078e0221ULL,
0x000000082100720cULL, 0x080fe20003fa6070ULL, 0x0000000118147824ULL, 0x040fe200078e0223ULL,
0x000000082300720cULL, 0x000fe20003fc6070ULL, 0x0000000118087824ULL, 0x040fe200078e0211ULL,
0x0000001f18107210ULL, 0x000fe20007ffe0ffULL, 0x00000001210d7824ULL, 0x000fe200078e0200ULL,
0x00000000230f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000821187824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1f7812ULL, 0x000fe200078ee207ULL, 0x00000008231e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c217812ULL, 0x000fe200078ee209ULL, 0x00005e0006067625ULL, 0x000fe200078e0005ULL,
0xfffffff818237812ULL, 0x000fc400078ee20dULL, 0xfffffff81e257812ULL, 0x000fe200078ee20fULL,
0x00005e0008087625ULL, 0x000fe200078e0005ULL, 0x0000001623237211ULL, 0x000fc600078e20ffULL,
0x00005e000c0c7625ULL, 0x000fc800078e0005ULL, 0x00005e000e0e7625ULL, 0x000fc800078e0005ULL,
0x00005e0010107625ULL, 0x000fc800078e0005ULL, 0x00005e0012127625ULL, 0x000fc800078e0005ULL,
0x00005e0014147625ULL, 0x000fc800078e0005ULL, 0x0000001017067825ULL, 0x000fc800078e0006ULL,
0x0000001019197824ULL, 0x000fe400078e0216ULL, 0x0000001017087825ULL, 0x000fc600078e0008ULL,
0x0000000006197faeULL, 0x0003e2000c101c46ULL, 0x000000101b1b7824ULL, 0x000fe400078e0216ULL,
0x00000010170c7825ULL, 0x000fc600078e000cULL, 0x00000000081b7faeULL, 0x0003e2000c901c46ULL,
0x000000101d1d7824ULL, 0x000fe400078e0216ULL, 0x00000010170e7825ULL, 0x000fc600078e000eULL,
0x000000000c1d7faeULL, 0x0003e2000d101c46ULL, 0x000000101f1f7824ULL, 0x000fe400078e0216ULL,
0x0000001017107825ULL, 0x000fc600078e0010ULL, 0x000000000e1f7faeULL, 0x0003e2000d901c46ULL,
0x0000001021217824ULL, 0x000fe400078e0216ULL, 0x0000001017127825ULL, 0x000fc600078e0012ULL,
0x0000000010217faeULL, 0x0003e2000e101c46ULL, 0x0000001017147825ULL, 0x000fc600078e0014ULL,
0x0000000012237faeULL, 0x0003e2000e901c46ULL, 0x0000001025257824ULL, 0x000fca00078e0216ULL,
0x0000000014257faeULL, 0x0003e2000f101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x00000004000d7811ULL, 0x008fe200078fe8ffULL, 0x00000002021d7824ULL, 0x000fe200078e020bULL,
0x00000008000f7811ULL, 0x040fe200078fe8ffULL, 0x000000080b1f7824ULL, 0x000fe200078e00ffULL,
0x0000001000137811ULL, 0x040fe200078fe8ffULL, 0x000000010d067824ULL, 0x140fe200078e0200ULL,
0x0000000c00117811ULL, 0x040fe200078fe8ffULL, 0x000000080d197824ULL, 0x000fe200078e00ffULL,
0x0000001400157811ULL, 0x000fe200078fe8ffULL, 0x000000080f177824ULL, 0x000fe200078e00ffULL,
0x00000003111c7819ULL, 0x000fe200000006ffULL, 0x0000000113087824ULL, 0x000fe200078e0200ULL,
0xfffffff819197812ULL, 0x000fe200078ee206ULL, 0x000000010f067824ULL, 0x000fe200078e0200ULL,
0x0000b0001d257811ULL, 0x000fe200078e68ffULL, 0x00000008131b7824ULL, 0x000fc400078e00ffULL,
0x0000000111077824ULL, 0x000fe200078e0200ULL, 0xfffffff8171a7812ULL, 0x000fe200078ee206ULL,
0x0000000115097824ULL, 0x000fe200078e0200ULL, 0xfffffff81b1e7812ULL, 0x000fe200078ee208ULL,
0x0000000815207824ULL, 0x000fe200078e00ffULL, 0x0000001800177811ULL, 0x000fe200078fe8ffULL,
0x00000001180c7824ULL, 0x000fe200078e020fULL, 0x0000001c001b7811ULL, 0x000fe200078fe8ffULL,
0x00000001180e7824ULL, 0x000fe200078e0211ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee207ULL,
0x0000000118107824ULL, 0x000fe200078e0213ULL, 0x0000000000077211ULL, 0x000fe200078fe8ffULL,
0x000000011b0f7824ULL, 0x100fe200078e0200ULL, 0x0000000d18087210ULL, 0x000fe20007ffe0ffULL,
0x00000001170d7824ULL, 0x000fe200078e0200ULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x000000081b247824ULL, 0x000fe200078e00ffULL, 0x0000001800067211ULL, 0x000fe200078fe8ffULL,
0x0000000118127824ULL, 0x040fe200078e0215ULL, 0x0000000707097812ULL, 0x000fe200078ec0ffULL,
0x0000000118147824ULL, 0x040fe200078e0217ULL, 0x0000000317227819ULL, 0x000fe200000006ffULL,
0x0000000118167824ULL, 0x000fe200078e021bULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x00005e0006067625ULL, 0x000fe200078e0005ULL, 0xfffffff822227812ULL, 0x000fc400078ee20dULL,
0x0ffffff809187812ULL, 0x100fe200078ef800ULL, 0x00005e0008087625ULL, 0x000fe200078e0005ULL,
0xfffffff81f1b7812ULL, 0x000fe400078ee200ULL, 0x000000251c1d7211ULL, 0x000fe200078e20ffULL,
0x00005e000c0c7625ULL, 0x000fc800078e0005ULL, 0x00005e000e0e7625ULL, 0x000fc800078e0005ULL,
0x00005e0010107625ULL, 0x000fc800078e0005ULL, 0x00005e0012127625ULL, 0x000fc800078e0005ULL,
0x00005e0014147625ULL, 0x000fc800078e0005ULL, 0x00005e0016167625ULL, 0x000fc800078e0005ULL,
0x000000101b067825ULL, 0x000fc800078e0006ULL, 0x0000001018057824ULL, 0x000fe400078e0225ULL,
0x000000101b087825ULL, 0x000fc600078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000b901c46ULL, 0x000000101b0c7825ULL, 0x000fc800078e000cULL,
0x000000101b0e7825ULL, 0x000fc800078e000eULL, 0x000000101b107825ULL, 0x000fc800078e0010ULL,
0x000000101b127825ULL, 0x000fc800078e0012ULL, 0x000000101b147825ULL, 0x000fc800078e0014ULL,
0x000000101b167825ULL, 0x000fc800078e0016ULL, 0x0000001019197824ULL, 0x100fe400078e0225ULL,
0x000000101a1b7824ULL, 0x100fe400078e0225ULL, 0x000000101e1f7824ULL, 0x100fe200078e0225ULL,
0x0000000008197faeULL, 0x0003e2000b901c46ULL, 0x0000001020217824ULL, 0x100fe400078e0225ULL,
0x0000001022237824ULL, 0x100fe200078e0225ULL, 0x000000000c1b7faeULL, 0x0003e2000b901c46ULL,
0x0000001024257824ULL, 0x000fc600078e0225ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000016257faeULL, 0x0003e4000b901c46ULL,
0x000000545900720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff6d7424ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x002fe2000001ff00ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000640000000947ULL, 0x000fea0003800000ULL, 0xff317217006d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff6f7224ULL, 0x000fc400078e00ffULL, 0x000000ffff137224ULL, 0x000fc400078e00ffULL,
0x0000010059067824ULL, 0x000fca00078e00ffULL, 0x000000550600720cULL, 0x000fda0003f06070ULL,
0x0000636000000947ULL, 0x020fea0003800000ULL, 0x00000001590d7810ULL, 0x040fe20007ffe0ffULL,
0x00000100596c7824ULL, 0x000fe200078e0203ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000540d00720cULL, 0x000fe20003f06070ULL, 0x000000ffff067224ULL, 0x000fe200078e006fULL,
0x000000406c0f7810ULL, 0x000fca0007ffe0ffULL, 0x00006200040d7a24ULL, 0x000fcc00078e020fULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x000010006f0e7824ULL, 0x000fe200078e00ffULL,
0x0000000f550c7217ULL, 0x000fe20007800000ULL, 0x00000100ff1f7424ULL, 0x000fe200078e00ffULL,
0x0000000b02157211ULL, 0x000fe400078e08ffULL, 0x000010000e0e7812ULL, 0x000fe200078e0cffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0fULL, 0x00000003ff197819ULL, 0x000fe20000011600ULL,
0x000000080b0f7824ULL, 0x000fe400078e00ffULL, 0x00002000150e7824ULL, 0x000fe200078e000eULL,
0x000000200c0c7817ULL, 0x000fe20003800000ULL, 0x0000000119157824ULL, 0x100fe200078e0200ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee200ULL, 0x0000000119147824ULL, 0x040fe200078e020dULL,
0x0000000c1900720cULL, 0x000fc40003f06070ULL, 0x0000000715177812ULL, 0x000fe200078ec0ffULL,
0x00005e0014147625ULL, 0x000fe200078e001fULL, 0x0000b0000e0e7810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff817177812ULL, 0x000fe400078ef800ULL, 0x00000004191b7810ULL, 0x000fe20007ffe0ffULL,
0x000000100f147825ULL, 0x000fe200078e0014ULL, 0x00000008191d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c19257810ULL, 0x000fe20007ffe0ffULL, 0x0000001017177824ULL, 0x000fe200078e020eULL,
0x0000001019297810ULL, 0x000fe20007ffe0ffULL, 0x000000081b217824ULL, 0x000fe200078e00ffULL,
0x00000014192b7810ULL, 0x000fe20007ffe0ffULL, 0x000000011d187824ULL, 0x100fe200078e0200ULL,
0x0000001819497810ULL, 0x000fe20007ffe0ffULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x000000001b167210ULL, 0x000fe20007ffe0ffULL, 0x00000001251a7824ULL, 0x000fe200078e0200ULL,
0x0000001c19197810ULL, 0x000fe20007ffe0ffULL, 0x0000000825277824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c101c46ULL,
0xfffffff821217812ULL, 0x000fe200078ee216ULL, 0x0000000125167824ULL, 0x100fe200078e020dULL,
0xfffffff823237812ULL, 0x000fe200078ee218ULL, 0x0000000129187824ULL, 0x100fe200078e020dULL,
0xfffffff827277812ULL, 0x000fe200078ee21aULL, 0x000000012b1a7824ULL, 0x100fe200078e020dULL,
0x0000000c1b00720cULL, 0x080fe20003f06070ULL, 0x00000001491c7824ULL, 0x100fe200078e020dULL,
0x0000000c1d00720cULL, 0x080fe20003f26070ULL, 0x00000001191e7824ULL, 0x100fe200078e020dULL,
0x0000000c2500720cULL, 0x080fe20003f46070ULL, 0x000000011d147824ULL, 0x002fe200078e020dULL,
0x0000000c2900720cULL, 0x0c0fe20003f66070ULL, 0x0000000129157824ULL, 0x100fe200078e0200ULL,
0x0000000c2b00720cULL, 0x080fe20003f86070ULL, 0x0000000829207824ULL, 0x000fe200078e00ffULL,
0x0000000c4900720cULL, 0x080fe20003fa6070ULL, 0x000000082b227824ULL, 0x000fe200078e00ffULL,
0x0000000c1900720cULL, 0x000fe20003fc6070ULL, 0x0000000849247824ULL, 0x000fe200078e00ffULL,
0x0000000d1b0c7210ULL, 0x000fe20007ffe0ffULL, 0x00000001490d7824ULL, 0x100fe200078e0200ULL,
0x000000002b177210ULL, 0x000fe20007ffe0ffULL, 0x00000001191b7824ULL, 0x040fe200078e0200ULL,
0x0000000319267819ULL, 0x000fe200000006ffULL, 0x00005e0018187625ULL, 0x000fe200078e001fULL,
0xfffffff820257812ULL, 0x000fc400078ee215ULL, 0xfffffff822297812ULL, 0x000fe200078ee217ULL,
0x00005e0014147625ULL, 0x080fe200078e001fULL, 0xfffffff8242b7812ULL, 0x000fe400078ee20dULL,
0xfffffff826497812ULL, 0x000fe200078ee21bULL, 0x00005e000c0c7625ULL, 0x000fc800078e001fULL,
0x00005e0016167625ULL, 0x000fc800078e001fULL, 0x00005e001a1a7625ULL, 0x000fc800078e001fULL,
0x00005e001c1c7625ULL, 0x000fc800078e001fULL, 0x00005e001e1e7625ULL, 0x000fc800078e001fULL,
0x000000100f0c7825ULL, 0x000fc800078e000cULL, 0x000000100f147825ULL, 0x000fc800078e0014ULL,
0x000000100f167825ULL, 0x000fc800078e0016ULL, 0x000000100f187825ULL, 0x000fc800078e0018ULL,
0x000000100f1a7825ULL, 0x000fc800078e001aULL, 0x000000100f1c7825ULL, 0x000fc800078e001cULL,
0x000000100f1e7825ULL, 0x000fc800078e001eULL, 0x00000010210f7824ULL, 0x100fe400078e020eULL,
0x0000001023217824ULL, 0x100fe400078e020eULL, 0x0000001027237824ULL, 0x100fe200078e020eULL,
0x000000000c0f7faeULL, 0x0003e2000c101c46ULL, 0x0000001025257824ULL, 0x100fe400078e020eULL,
0x0000001029277824ULL, 0x100fe200078e020eULL, 0x0000000014217faeULL, 0x0003e2000c901c46ULL,
0x000000102b297824ULL, 0x000fe200078e020eULL, 0x0000000e492b7211ULL, 0x000fc400078e20ffULL,
0x0000000016237faeULL, 0x0003e8000d101c46ULL, 0x0000000018257faeULL, 0x0003e8000d901c46ULL,
0x000000001a277faeULL, 0x0003e8000e101c46ULL, 0x000000001c297faeULL, 0x0003e8000e901c46ULL,
0x000000001e2b7faeULL, 0x0003e2000f101c46ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x000010006f0e7824ULL, 0x000fe200078e00ffULL, 0x0000000c00167811ULL, 0x000fe200078fe8ffULL,
0x00000002020c7824ULL, 0x000fe200078e020bULL, 0x0000000400147811ULL, 0x000fe200078fe8ffULL,
0x000000080b1d7824ULL, 0x000fe200078e00ffULL, 0x000010000e0f7812ULL, 0x000fe200078e0cffULL,
0x00000001160e7824ULL, 0x100fe200078e0200ULL, 0x0000000800157811ULL, 0x000fe200078fe8ffULL,
0x00000008161b7824ULL, 0x000fe200078e00ffULL, 0x0000001000187811ULL, 0x000fe200078fe8ffULL,
0x000020000c237824ULL, 0x000fe200078e000fULL, 0x0000000315197819ULL, 0x000fe200000006ffULL,
0x00000001141a7824ULL, 0x040fe200078e0200ULL, 0xfffffff81b267812ULL, 0x000fe200078ee20eULL,
0x0000000814177824ULL, 0x000fe200078e00ffULL, 0x00000000000e7211ULL, 0x040fe200078fe8ffULL,
0x00000001150c7824ULL, 0x100fe200078e0200ULL, 0x0000001c001b7811ULL, 0x000fe200078fe8ffULL,
0x00000001180f7824ULL, 0x040fe200078e0200ULL, 0xfffffff8171a7812ULL, 0x000fe200078ee21aULL,
0x0000000818287824ULL, 0x000fe200078e00ffULL, 0xfffffff819247812ULL, 0x000fe200078ee20cULL,
0x000000081b4a7824ULL, 0x000fe200078e00ffULL, 0x0000001400177811ULL, 0x000fe200078fe8ffULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20fULL,
0x0000000116167824ULL, 0x100fe200078e020dULL, 0x0000001800197811ULL, 0x000fe200078fe8ffULL,
0x00000001171c7824ULL, 0x140fe200078e020dULL, 0x000000070e0f7812ULL, 0x000fe200078ec0ffULL,
0x00000008172a7824ULL, 0x000fe200078e00ffULL, 0x0000000d140e7210ULL, 0x080fe20007ffe0ffULL,
0x0000000115147824ULL, 0x000fe200078e020dULL, 0x0000000d191e7210ULL, 0x080fe20007ffe0ffULL,
0x0000000117157824ULL, 0x100fe200078e0200ULL, 0x0000000d000c7211ULL, 0x000fe200078fe8ffULL,
0x0000000119177824ULL, 0x100fe200078e0200ULL, 0x0ffffff80f227812ULL, 0x100fe200078ef800ULL,
0x0000000819487824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee215ULL,
0x000000011b197824ULL, 0x100fe200078e0200ULL, 0x0000b000234b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000118187824ULL, 0x000fe200078e020dULL, 0xfffffff848487812ULL, 0x000fe200078ee217ULL,
0x000000011b207824ULL, 0x000fe200078e020dULL, 0xfffffff81d1b7812ULL, 0x000fe200078ee200ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0021ULL, 0xfffffff84a4a7812ULL, 0x000fc400078ee219ULL,
0x0000004b1a237211ULL, 0x000fe200078e20ffULL, 0x00005e000e0e7625ULL, 0x000fc800078e0021ULL,
0x00005e0014147625ULL, 0x000fc800078e0021ULL, 0x00005e0016167625ULL, 0x000fc800078e0021ULL,
0x00005e0018187625ULL, 0x000fc800078e0021ULL, 0x00005e001c1c7625ULL, 0x000fc800078e0021ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0021ULL, 0x00005e0020207625ULL, 0x000fc800078e0021ULL,
0x000000101b0c7825ULL, 0x000fc800078e000cULL, 0x000000101b0e7825ULL, 0x000fc800078e000eULL,
0x000000101b147825ULL, 0x000fc800078e0014ULL, 0x000000101b167825ULL, 0x000fc800078e0016ULL,
0x000000101b187825ULL, 0x000fc800078e0018ULL, 0x000000101b1c7825ULL, 0x000fc800078e001cULL,
0x000000101b1e7825ULL, 0x000fc800078e001eULL, 0x000000101b207825ULL, 0x000fc800078e0020ULL,
0x00000010221b7824ULL, 0x100fe400078e024bULL, 0x0000001024257824ULL, 0x100fe400078e024bULL,
0x0000001026277824ULL, 0x100fe200078e024bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1b7faeULL, 0x0003e2000b901c46ULL, 0x0000001028297824ULL, 0x100fe400078e024bULL,
0x000000102a2b7824ULL, 0x100fe200078e024bULL, 0x000000000e237faeULL, 0x0003e2000b901c46ULL,
0x0000001048497824ULL, 0x000fc400078e024bULL, 0x000000104a4b7824ULL, 0x000fe200078e024bULL,
0x0000000014257faeULL, 0x0003e8000b901c46ULL, 0x0000000016277faeULL, 0x0003e8000b901c46ULL,
0x0000000018297faeULL, 0x0003e8000b901c46ULL, 0x000000001c2b7faeULL, 0x0003e8000b901c46ULL,
0x000000001e497faeULL, 0x0003e8000b901c46ULL, 0x00000000204b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe00a0e7812ULL, 0x002fc400078ec0ffULL,
0x000000100a0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000d0e0c7210ULL, 0x000fca0007ffe0ffULL,
0x000000080b0c7824ULL, 0x000fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x013608000c147f8cULL, 0x0002a4000c80043fULL, 0x00000000000c7805ULL, 0x002fc40000015200ULL,
0x00000010020f7824ULL, 0x000fca00078e00ffULL, 0x000000100f0f7812ULL, 0x000fca00078ec0ffULL,
0x000000010e0e7824ULL, 0x000fc800078e020fULL, 0x000000080b167824ULL, 0x000fca00078e020eULL,
0x01360c00160f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c177210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fc800078110ffULL, 0x0000000fff0f7210ULL, 0x000fc800007fe4ffULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01360c00160f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000687824ULL, 0x000fe200078e00ffULL, 0x00000001ff667819ULL, 0x000fe20000011600ULL,
0x0000002057697824ULL, 0x000fe400078e00ffULL, 0xffffffffff627424ULL, 0x000fe200078e00ffULL,
0x0000007068687812ULL, 0x000fc400078ec0ffULL, 0xffffff8069697812ULL, 0x000fe400078ec0ffULL,
0x0000000c66667812ULL, 0x000fc800078ec0ffULL, 0x00000069660c7210ULL, 0x000fca0007ffe068ULL,
0x013000000c0e7984ULL, 0x000e680000000800ULL, 0x013200000c147984ULL, 0x0004e20000000800ULL,
0x0000006d0e00720bULL, 0x002fe20003f1d000ULL, 0x0000e8327f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0c167812ULL, 0x000fe2000782c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff6e7224ULL, 0x000fe200078e006dULL, 0xffffffff00617802ULL, 0x000fe20000000f00ULL,
0x0000001fff647424ULL, 0x000fd000078e00ffULL, 0x0000044000009947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe40000011657ULL, 0x0000006d0e00720bULL, 0x000fe40003f54000ULL,
0x000000570c00720cULL, 0x000fe20003f25270ULL, 0x0000e7c27f007947ULL, 0x000fd4000b800000ULL,
0x00000000000f7806ULL, 0x000fc400010e0100ULL, 0x00000080570d9824ULL, 0x000fe200078e0268ULL,
0x0000000e6d6e7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099100f0c7816ULL, 0x000fe200000000ffULL, 0x00000001660d9824ULL, 0x000fca00078e020dULL,
0x0134006e0d009388ULL, 0x0003e20000000800ULL, 0x000000ff0c00720cULL, 0x000fda0003f25270ULL,
0x0000030000009947ULL, 0x000fea0003800000ULL, 0x8000006e6d0c7221ULL, 0x002fe20000010000ULL,
0x000000ff0fff7812ULL, 0x000fe2000782c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00157308ULL, 0x0002ac0000000800ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x002fe20000011600ULL,
0x0000e7027f007947ULL, 0x000fea000b800000ULL, 0x00001f0c150c7589ULL, 0x0042a400000e0000ULL,
0x0000000c44447220ULL, 0x084fe20000410000ULL, 0x0000000c45457220ULL, 0x080fe20000410000ULL,
0x0000000c40407220ULL, 0x080fe20000410000ULL, 0x0000000c41417220ULL, 0x080fe20000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000c38387220ULL, 0x080fe20000410000ULL, 0x0000000c39397220ULL, 0x080fe20000410000ULL,
0x0000000c34347220ULL, 0x080fe20000410000ULL, 0x0000000c35357220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c10107220ULL, 0x080fe20000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000fff7812ULL, 0x000fe2000782c0ffULL,
0x0000001505057220ULL, 0x004fd80000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000008000c7811ULL, 0x002fe200078ff0ffULL, 0x0000e5e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c150c7589ULL, 0x0002a400000e0000ULL, 0x0000000c46467220ULL, 0x084fe20000410000ULL,
0x0000000c47477220ULL, 0x080fe20000410000ULL, 0x0000000c42427220ULL, 0x080fe20000410000ULL,
0x0000000c43437220ULL, 0x080fe20000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000c36367220ULL, 0x080fe20000410000ULL,
0x0000000c37377220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c12127220ULL, 0x080fe20000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff16ff7812ULL, 0x000fda000782600fULL, 0x8000006e0e0e1221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b0e0e1820ULL, 0x000fc80000410000ULL,
0x0000000e00071308ULL, 0x000e640000000800ULL, 0x0000000714141220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x0000000514057221ULL, 0x008fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011600ULL, 0x00005410080f7816ULL, 0x000fe20000000008ULL,
0x0000e4227f007947ULL, 0x000fea000b800000ULL, 0x00001f0e0f097589ULL, 0x0002a400000e0000ULL,
0x000000080e087810ULL, 0x000fe20007ffe0ffULL, 0x0000e4527f007947ULL, 0x000fea000b800000ULL,
0x00001f080f087589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100e0c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000f00177202ULL, 0x000fc40000000f00ULL,
0x000027c000187802ULL, 0x000fc40000000f00ULL, 0x0000eea000007944ULL, 0x00efea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180e0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e000fULL, 0x0000281000187802ULL, 0x000fc40000000f00ULL,
0x0000ee5000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff0d7819ULL, 0x100fe20000011600ULL, 0x00000200570f7824ULL, 0x00afe200078e00ffULL,
0x0000000700677812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00000004020d7824ULL, 0x000fe200078e020dULL, 0x00000008670c7812ULL, 0x000fe400078ef800ULL,
0xfffff8000f5c7812ULL, 0x000fc600078ec0ffULL, 0x000000010c0e7824ULL, 0x000fe200078e020dULL,
0x00000008000d7812ULL, 0x000fe200078ec0ffULL, 0x000000080c657824ULL, 0x000fca00078e00ffULL,
0xfffffff865657812ULL, 0x000fca00078ee20eULL, 0x0000001065657824ULL, 0x000fc800078e025cULL,
0x0000000b026a7211ULL, 0x000fe200078e08ffULL, 0x009000006528783bULL, 0x000e620000000200ULL,
0x000000070d0d7812ULL, 0x000fe400078ef800ULL, 0x000000020e0e7810ULL, 0x000fe20007ffe0ffULL,
0x000020006a6a7824ULL, 0x000fe200078e00ffULL, 0x0000000d000f7211ULL, 0x000fe200078fe0ffULL,
0x000000080d167824ULL, 0x040fe200078e00ffULL, 0x000000100d197812ULL, 0x040fe200078efcffULL,
0x000000080d157824ULL, 0x000fe200078e00ffULL, 0x000000020f5f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d187824ULL, 0x000fe200078e00ffULL, 0x000000040f5e7810ULL, 0x000fe20007ffe0ffULL,
0x000010006f147824ULL, 0x000fe200078e026aULL, 0x000000060f5d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d607824ULL, 0x000fe200078e00ffULL, 0xfffffff8165f7812ULL, 0x000fe200078ee25fULL,
0x0000000819177824ULL, 0x004fe200078e00ffULL, 0x0000b000141b7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8155e7812ULL, 0x000fe200078ee25eULL, 0x000000080c157824ULL, 0x000fe200078e00ffULL,
0xfffffff8185d7812ULL, 0x000fe200078ee25dULL, 0x000000105f4c7824ULL, 0x000fe200078e021bULL,
0xfffffff860607812ULL, 0x000fe200078ee20fULL, 0x000000105e487824ULL, 0x100fe200078e021bULL,
0xfffffff815157812ULL, 0x000fe200078ee20eULL, 0x000000105d0c7824ULL, 0x000fe200078e021bULL,
0x0000001b60507211ULL, 0x000fe200078e20ffULL, 0x000000004c4c783bULL, 0x000ea20000004200ULL,
0x00000019005b7211ULL, 0x000fe200078fe0ffULL, 0x0000000819187824ULL, 0x040fe200078e00ffULL,
0x00000003191d7819ULL, 0x040fe200000006ffULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0x000000025b5a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010155c7824ULL, 0x000fe200078e025cULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x000000045b587810ULL, 0x000fc40007ffe0ffULL, 0x000000065b567810ULL, 0x000fe20007ffe0ffULL,
0x000000000c0c783bULL, 0x000fe20000004200ULL, 0xfffffff8175a7812ULL, 0x000fe200078ee25aULL,
0x0000000928280231ULL, 0x082fe200003400ffULL, 0xfffffff81d587812ULL, 0x000fe200078ee258ULL,
0x009000005c14783bULL, 0x000e620000000200ULL, 0xfffffff8185b7812ULL, 0x000fe200078ee25bULL,
0x000000105a247824ULL, 0x100fe200078e021bULL, 0xfffffff819567812ULL, 0x000fe200078ee256ULL,
0x0000001058207824ULL, 0x100fe200078e021bULL, 0x000000092a2a0231ULL, 0x000fe200003400ffULL,
0x000000105b1c7824ULL, 0x100fe200078e021bULL, 0x0000000829290231ULL, 0x080fe200003400ffULL,
0x0000001056187824ULL, 0x000fe200078e021bULL, 0x000000002424783bULL, 0x000f220000004200ULL,
0x000000082b2b0231ULL, 0x000fe200003400ffULL, 0x0000000157637819ULL, 0x000fc400000006ffULL,
0x000000002020783bULL, 0x000f240000004200ULL, 0xfffffff863637812ULL, 0x000fe400078ec0ffULL,
0x000000001c1c783bULL, 0x000f280000004200ULL, 0x000000001818783bULL, 0x000f220000004200ULL,
0x0000004c283c723cULL, 0x044f70000004183cULL, 0x000000502844723cULL, 0x048ff00000041844ULL,
0x000000522840723cULL, 0x000fe20000041840ULL, 0x0000000914140231ULL, 0x002fc400003400ffULL,
0x0000000916160231ULL, 0x000fe400003400ffULL, 0x0000000815150231ULL, 0x080fe400003400ffULL,
0x0000000817170231ULL, 0x000fe200003400ffULL, 0x0000004e2838723cULL, 0x040f700000041838ULL,
0x000000482834723cULL, 0x040f700000041834ULL, 0x0000004a2830723cULL, 0x040f700000041830ULL,
0x0000000c282c723cULL, 0x040f70000004182cULL, 0x0000000e2810723cULL, 0x000f700000041810ULL,
0x00000024143c723cULL, 0x070b70000004183cULL, 0x000000261438723cULL, 0x040b700000041838ULL,
0x000000201434723cULL, 0x040b700000041834ULL, 0x000000221430723cULL, 0x040b700000041830ULL,
0x0000001c1444723cULL, 0x040b700000041844ULL, 0x0000001e1440723cULL, 0x040b700000041840ULL,
0x00000018142c723cULL, 0x040b70000004182cULL, 0x0000001a1410723cULL, 0x000b620000041810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000040590c7811ULL, 0x000fe200078e40ffULL,
0x0136880063ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff6d7224ULL, 0x000fe200078e006eULL,
0x000000016f6f7812ULL, 0x000fc400078e0cffULL, 0x000000550c00720cULL, 0x000fda0003f06070ULL,
0x0000476000000947ULL, 0x000fea0003800000ULL, 0x00000001590d7810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000540d00720cULL, 0x000fe40003f06070ULL,
0x000000806c0e7810ULL, 0x000fca0007ffe0ffULL, 0x00006200040f7a24ULL, 0x000fcc00078e020eULL,
0x000005d000008947ULL, 0x000fea0003800000ULL, 0x0000000e550d7217ULL, 0x000fe20007800000ULL,
0x00001000060c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff197819ULL, 0x020fe20000011600ULL,
0x000000080b147824ULL, 0x000fe400078e00ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a0eULL,
0x000010000c177812ULL, 0x000fe200078ec0ffULL, 0x00000001190c7824ULL, 0x000fe200078e0200ULL,
0xfffffff8141f7812ULL, 0x000fe200078ee267ULL, 0x00000100ff0e7424ULL, 0x000fe200078e00ffULL,
0x000000200d147817ULL, 0x000fc40003800000ULL, 0x0000000f19157210ULL, 0x040fe40007ffe0ffULL,
0x000000070c1b7812ULL, 0x000fe400078ec0ffULL, 0x000000141900720cULL, 0x000fe20003f06070ULL,
0x00005e00150c7625ULL, 0x000fe200078e000eULL, 0x0000b0006a1e7810ULL, 0x000fe40007ffe017ULL,
0x0ffffff81b157812ULL, 0x000fe400078ef800ULL, 0x00000004191d7810ULL, 0x000fe20007ffe0ffULL,
0x000000101f0c7825ULL, 0x000fe200078e000cULL, 0x0000000819277810ULL, 0x000fc40007ffe0ffULL,
0x0000001e15157211ULL, 0x000fe200078e20ffULL, 0x000000011d217824ULL, 0x100fe200078e0200ULL,
0x0000000c19297810ULL, 0x000fe20007ffe0ffULL, 0x000000081d167824ULL, 0x000fe200078e00ffULL,
0x00000010192b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127257824ULL, 0x100fe200078e0200ULL,
0x0000001419497810ULL, 0x000fe20007ffe0ffULL, 0x0000000827187824ULL, 0x000fe200078e00ffULL,
0x00000018194b7810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e2000c101c46ULL, 0x0000001c194d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129237824ULL, 0x100fe200078e0200ULL, 0x000000141d00720cULL, 0x080fe20003f06070ULL,
0x00000008291a7824ULL, 0x000fe200078e00ffULL, 0x000000142700720cULL, 0x0c0fe20003f26070ULL,
0x0000000127177824ULL, 0x100fe200078e020fULL, 0x000000142900720cULL, 0x0c0fe20003f46070ULL,
0x00000001291b7824ULL, 0x100fe200078e020fULL, 0x000000142b00720cULL, 0x0c0fe20003f66070ULL,
0x000000082b277824ULL, 0x000fe200078e00ffULL, 0x000000144900720cULL, 0x080fe20003f86070ULL,
0x000000011d157824ULL, 0x102fe200078e020fULL, 0x000000144b00720cULL, 0x080fe20003fa6070ULL,
0x000000012b1d7824ULL, 0x000fe200078e020fULL, 0x000000144d00720cULL, 0x000fe20003fc6070ULL,
0x000000012b0c7824ULL, 0x100fe200078e0200ULL, 0xfffffff816217812ULL, 0x000fe200078ee221ULL,
0x0000000149147824ULL, 0x140fe200078e0200ULL, 0x0000000f49197210ULL, 0x040fe20007ffe0ffULL,
0x0000000849297824ULL, 0x000fe200078e00ffULL, 0xfffffff818257812ULL, 0x000fe200078ee225ULL,
0x000000014b167824ULL, 0x000fe200078e0200ULL, 0x000000004d187210ULL, 0x000fe20007ffe0ffULL,
0x000000084b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee214ULL,
0x000000084d497824ULL, 0x000fe200078e00ffULL, 0xfffffff81a237812ULL, 0x000fe200078ee223ULL,
0x000000014b0d7824ULL, 0x100fe200078e020fULL, 0xfffffff827277812ULL, 0x000fe200078ee20cULL,
0x000000014d0f7824ULL, 0x000fe200078e020fULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee216ULL,
0x00005e0015147625ULL, 0x000fe200078e000eULL, 0xfffffff849497812ULL, 0x000fc600078ee218ULL,
0x00005e0017167625ULL, 0x000fc800078e000eULL, 0x00005e001b1a7625ULL, 0x000fc800078e000eULL,
0x00005e001d1c7625ULL, 0x000fc800078e000eULL, 0x00005e0019187625ULL, 0x000fc800078e000eULL,
0x00005e000d0c7625ULL, 0x000fc800078e000eULL, 0x00005e000f0e7625ULL, 0x000fc800078e000eULL,
0x000000101f147825ULL, 0x000fc800078e0014ULL, 0x0000001021217824ULL, 0x000fe400078e021eULL,
0x000000101f167825ULL, 0x000fc600078e0016ULL, 0x0000000014217faeULL, 0x0003e2000c101c46ULL,
0x0000001025257824ULL, 0x000fe400078e021eULL, 0x000000101f1a7825ULL, 0x000fc600078e001aULL,
0x0000000016257faeULL, 0x0003e2000c901c46ULL, 0x000000101f1c7825ULL, 0x000fc800078e001cULL,
0x000000101f187825ULL, 0x000fc800078e0018ULL, 0x000000101f0c7825ULL, 0x000fc800078e000cULL,
0x000000101f0e7825ULL, 0x000fc800078e000eULL, 0x0000001023237824ULL, 0x100fe400078e021eULL,
0x00000010271f7824ULL, 0x100fe400078e021eULL, 0x0000001029277824ULL, 0x100fe200078e021eULL,
0x0000001e2b297211ULL, 0x000fe200078e20ffULL, 0x00000010492b7824ULL, 0x000fe200078e021eULL,
0x000000001a237faeULL, 0x0003e8000d101c46ULL, 0x000000001c1f7faeULL, 0x0003e8000d901c46ULL,
0x0000000018277faeULL, 0x0003e8000e101c46ULL, 0x000000000c297faeULL, 0x0003e8000e901c46ULL,
0x000000000e2b7faeULL, 0x0003e2000f101c46ULL, 0x0000050000007947ULL, 0x000fea0003800000ULL,
0x0000000400167811ULL, 0x060fe200078fe8ffULL, 0x000000080b287824ULL, 0x000fe200078e00ffULL,
0x00000010001e7811ULL, 0x000fc400078fe8ffULL, 0x0000000c001c7811ULL, 0x000fe200078fe8ffULL,
0x0000000116267824ULL, 0x100fe200078e0200ULL, 0x00000014001a7811ULL, 0x000fe200078fe8ffULL,
0x00000008160d7824ULL, 0x000fe200078e00ffULL, 0x0000000800147811ULL, 0x000fe200078fe8ffULL,
0x000000011e217824ULL, 0x000fe200078e0200ULL, 0x0000001800197811ULL, 0x000fe200078fe8ffULL,
0x000000081e0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d267812ULL, 0x000fe200078ee226ULL,
0x000000011c227824ULL, 0x140fe200078e0200ULL, 0x000000031c0d7819ULL, 0x000fe200000006ffULL,
0x000000011a207824ULL, 0x000fe200078e0200ULL, 0xfffffff80e217812ULL, 0x000fe200078ee221ULL,
0x000000081a157824ULL, 0x000fe200078e00ffULL, 0xfffffff80d227812ULL, 0x000fe200078ee222ULL,
0x0000000114257824ULL, 0x000fe200078e0200ULL, 0x00000000000e7211ULL, 0x080fe200078fe8ffULL,
0x00000008140c7824ULL, 0x000fe200078e00ffULL, 0x0000001c001b7811ULL, 0x000fe200078fe8ffULL,
0x00001000060d7824ULL, 0x000fe200078e00ffULL, 0xfffffff815207812ULL, 0x000fe200078ee220ULL,
0x0000000119187824ULL, 0x000fe200078e020fULL, 0x000000070e157812ULL, 0x000fe200078ec0ffULL,
0x000000011b237824ULL, 0x000fe200078e0200ULL, 0x0000000019247210ULL, 0x040fe20007ffe0ffULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0xfffffff80c257812ULL, 0x000fe200078ee225ULL,
0x000000081b0e7824ULL, 0x000fe200078e00ffULL, 0x0000000f000c7211ULL, 0x000fe200078fe8ffULL,
0x0000000116167824ULL, 0x100fe200078e020fULL, 0x0000010000297802ULL, 0x000fe20000000f00ULL,
0x0000000114147824ULL, 0x100fe200078e020fULL, 0x000010000d177812ULL, 0x000fe200078ec0ffULL,
0x000000011c1c7824ULL, 0x000fe200078e020fULL, 0xfffffff828277812ULL, 0x000fe200078ee267ULL,
0x000000011e1e7824ULL, 0x100fe200078e020fULL, 0xfffffff819247812ULL, 0x000fe200078ee224ULL,
0x000000011a1a7824ULL, 0x000fe200078e020fULL, 0xfffffff80e237812ULL, 0x000fe200078ee223ULL,
0x000000011b0f7824ULL, 0x000fe200078e020fULL, 0x0ffffff815287812ULL, 0x000fe200078ef800ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0029ULL, 0x0000b0006a4d7810ULL, 0x000fc60007ffe017ULL,
0x00005e0016167625ULL, 0x000fe200078e0029ULL, 0x0000004d25257211ULL, 0x000fc600078e20ffULL,
0x00005e0014147625ULL, 0x000fc800078e0029ULL, 0x00005e001c1c7625ULL, 0x000fc800078e0029ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0029ULL, 0x00005e001a1a7625ULL, 0x000fc800078e0029ULL,
0x00005e0018187625ULL, 0x000fc800078e0029ULL, 0x00005e000f0e7625ULL, 0x000fc800078e0029ULL,
0x00000010270c7825ULL, 0x000fc800078e000cULL, 0x0000001027167825ULL, 0x000fc800078e0016ULL,
0x0000001027147825ULL, 0x000fc800078e0014ULL, 0x00000010271c7825ULL, 0x000fc800078e001cULL,
0x00000010271e7825ULL, 0x000fc800078e001eULL, 0x00000010271a7825ULL, 0x000fc800078e001aULL,
0x0000001027187825ULL, 0x000fc800078e0018ULL, 0x00000010270e7825ULL, 0x000fc800078e000eULL,
0x0000001028277824ULL, 0x100fe400078e024dULL, 0x0000001026297824ULL, 0x100fe400078e024dULL,
0x00000010222b7824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c277faeULL, 0x0003e2000b901c46ULL, 0x0000001021217824ULL, 0x100fe400078e024dULL,
0x0000001020497824ULL, 0x100fe200078e024dULL, 0x0000000016297faeULL, 0x0003e2000b901c46ULL,
0x00000010244b7824ULL, 0x000fc400078e024dULL, 0x0000001023237824ULL, 0x000fe200078e024dULL,
0x0000000014257faeULL, 0x0003e8000b901c46ULL, 0x000000001c2b7faeULL, 0x0003e8000b901c46ULL,
0x000000001e217faeULL, 0x0003e8000b901c46ULL, 0x000000001a497faeULL, 0x0003e8000b901c46ULL,
0x00000000184b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e237faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010020d7824ULL, 0x002fe200078e00ffULL,
0xffffffe00a0c7812ULL, 0x000fc800078ec0ffULL, 0x000000100d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000d0c0c7210ULL, 0x000fca0007ffe0ffULL, 0x000000080b167824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01362800160e7f8cULL, 0x0002a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01362c0016157984ULL, 0x000ee40000000800ULL,
0x8000000015ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140c177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0dULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01362c0016157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000080680d7810ULL, 0x000fca0007ffe069ULL,
0x00000001660d7824ULL, 0x000fca00078e020dULL, 0x013000000d0f7984ULL, 0x000ea80000000800ULL,
0x013200000d0e7984ULL, 0x0006620000000800ULL, 0x0000006e0f00720bULL, 0x004fe20003f1d000ULL,
0x0000cf227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x008fc800000e0100ULL,
0x0000ffff14ff7812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000006e006d7202ULL, 0x000fd20000000f00ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x00000001570c7811ULL, 0x000fe400078ff0ffULL,
0x0000006e0f00720bULL, 0x000fe40003f34000ULL, 0x000000570c00720cULL, 0x000fe20003f05270ULL,
0x0000ced27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000157806ULL, 0x000fc400008e0100ULL,
0x00000080570d8824ULL, 0x000fe200078e0268ULL, 0x0000006e0f0c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000166178824ULL, 0x000fe200078e020dULL,
0x00009910150d7816ULL, 0x000fc800000000ffULL, 0x0134000c17008388ULL, 0x0005e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000006e0f0d7209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL, 0x0000006e0d0c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00167308ULL, 0x002e640000000800ULL,
0x0000001605057220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011600ULL, 0x0000cde27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c160c7589ULL, 0x0002a400000e0000ULL, 0x0000000c44447220ULL, 0x084fe20000410000ULL,
0x0000000c45457220ULL, 0x080fe20000410000ULL, 0x0000000c40407220ULL, 0x080fe20000410000ULL,
0x0000000c41417220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c38387220ULL, 0x080fe20000410000ULL,
0x0000000c39397220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008000c7811ULL, 0x000fe200078ff0ffULL, 0x0000ccd27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c160c7589ULL, 0x0004e400000e0000ULL, 0x0000000c46467220ULL, 0x088fe20000410000ULL,
0x0000000c47477220ULL, 0x080fe20000410000ULL, 0x0000000c42427220ULL, 0x080fe20000410000ULL,
0x0000000c43437220ULL, 0x080fe20000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000c36367220ULL, 0x080fe20000410000ULL,
0x0000000c37377220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c12127220ULL, 0x080fe20000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff15ff7812ULL, 0x000fe40007800814ULL, 0x0000006e0f6d7209ULL, 0x000fd60007810000ULL,
0x8000006d0f0f0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f00070308ULL, 0x000ea40000000800ULL, 0x000000070e0e0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000000050e057221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x00005410080e7816ULL, 0x000fe20000000008ULL,
0x0000cb127f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e097589ULL, 0x0002a400000e0000ULL,
0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000cb427f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0e087589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f0c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e000eULL,
0x000042c000187802ULL, 0x000fc40000000f00ULL, 0x0000d3a000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e000eULL, 0x0000431000187802ULL, 0x000fc40000000f00ULL,
0x0000d35000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000000c066b7819ULL, 0x000fe200000006ffULL,
0x009800006524783bULL, 0x000f260000000200ULL, 0x000010006b6b7812ULL, 0x000fe200078e0cffULL,
0x009800005c0c783bULL, 0x00ae660000000200ULL, 0x0000b0006a6b7810ULL, 0x000fc80007ffe06bULL,
0x0000006b58187211ULL, 0x000fe200078e20ffULL, 0x0000001060507824ULL, 0x100fe400078e026bULL,
0x000000105f4c7824ULL, 0x100fe400078e026bULL, 0x000000105e487824ULL, 0x100fe200078e026bULL,
0x000000001818783bULL, 0x000fe20000004200ULL, 0x000000105d287824ULL, 0x100fe400078e026bULL,
0x000000105b207824ULL, 0x100fe200078e026bULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x000000105a1c7824ULL, 0x000fc400078e026bULL, 0x0000001056147824ULL, 0x000fe200078e026bULL,
0x000000004c4c783bULL, 0x000ea80000004200ULL, 0x000000004848783bULL, 0x000ea80000004200ULL,
0x000000002828783bULL, 0x000ea80000004200ULL, 0x000000002020783bULL, 0x000ea40000004200ULL,
0x0000000924240231ULL, 0x014fc400003400ffULL, 0x000000001c1c783bULL, 0x000ea20000004200ULL,
0x0000000926260231ULL, 0x080fe400003400ffULL, 0x0000000825250231ULL, 0x080fe200003400ffULL,
0x000000001414783bULL, 0x000f220000004200ULL, 0x0000000827270231ULL, 0x080fe400003400ffULL,
0x000000090c0c0231ULL, 0x082fe400003400ffULL, 0x000000090e0e0231ULL, 0x000fe400003400ffULL,
0x000000080d0d0231ULL, 0x000fc400003400ffULL, 0x000000080f0f0231ULL, 0x000fe200003400ffULL,
0x000000502444723cULL, 0x048f700000041844ULL, 0x000000522440723cULL, 0x040f700000041840ULL,
0x0000004c243c723cULL, 0x040f70000004183cULL, 0x0000004e2438723cULL, 0x040f700000041838ULL,
0x000000482434723cULL, 0x040f700000041834ULL, 0x0000004a2430723cULL, 0x040f700000041830ULL,
0x00000028242c723cULL, 0x040f70000004182cULL, 0x0000002a2410723cULL, 0x000f700000041810ULL,
0x000000200c44723cULL, 0x060b700000041844ULL, 0x000000220c40723cULL, 0x040b700000041840ULL,
0x0000001c0c3c723cULL, 0x044b70000004183cULL, 0x0000001e0c38723cULL, 0x040b700000041838ULL,
0x000000180c34723cULL, 0x040b700000041834ULL, 0x0000001a0c30723cULL, 0x040b700000041830ULL,
0x000000140c2c723cULL, 0x050b70000004182cULL, 0x000000160c10723cULL, 0x000b620000041810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000080590c7811ULL, 0x020fe200078e40ffULL,
0x0136900063ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001066f7812ULL, 0x000fc400078ec0ffULL,
0x000000550c00720cULL, 0x000fda0003f06070ULL, 0x00002f3000000947ULL, 0x000fea0003800000ULL,
0x00000001590f7810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000540f00720cULL, 0x000fe40003f06070ULL, 0x000000c06c0d7810ULL, 0x000fca0007ffe0ffULL,
0x00006200040f7a24ULL, 0x000fcc00078e020dULL, 0x000005a000008947ULL, 0x000fea0003800000ULL,
0x0000000d550c7217ULL, 0x000fe20007800000ULL, 0x000000080b147824ULL, 0x000fe200078e00ffULL,
0x00000003ff177819ULL, 0x100fe20000011600ULL, 0x00000100ff0e7424ULL, 0x000fe400078e00ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0dULL, 0xfffffff8141f7812ULL, 0x000fe200078ee267ULL,
0x0000000117157824ULL, 0x040fe200078e0200ULL, 0x0000000417197810ULL, 0x040fe20007ffe0ffULL,
0x00000001170d7824ULL, 0x000fe200078e020fULL, 0x000000200c147817ULL, 0x000fc40003800000ULL,
0x0000000715157812ULL, 0x000fe200078ec0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e000eULL,
0x000000141700720cULL, 0x040fe40003f06070ULL, 0x00000008171b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000819217824ULL, 0x000fe200078e00ffULL, 0x0000000c171d7810ULL, 0x000fe20007ffe0ffULL,
0x000000101f0c7825ULL, 0x000fe200078e000cULL, 0x0ffffff815167812ULL, 0x100fe400078ef800ULL,
0x0000000019187210ULL, 0x000fe20007ffe0ffULL, 0x000000011b1a7824ULL, 0x000fe200078e0200ULL,
0x0000001c17277810ULL, 0x000fe20007ffe0ffULL, 0x000000081b237824ULL, 0x000fe200078e00ffULL,
0xfffffff821207812ULL, 0x000fe200078ee218ULL, 0x000000011d1e7824ULL, 0x000fe200078e0200ULL,
0x0000001017217810ULL, 0x000fe20007ffe0ffULL, 0x000000081d257824ULL, 0x000fe200078e00ffULL,
0xfffffff823227812ULL, 0x000fe200078ee21aULL, 0x0000001016157824ULL, 0x000fe200078e026bULL,
0x0000001417237810ULL, 0x000fe20007ffe0ffULL, 0x0000000127187824ULL, 0x000fe200078e0200ULL,
0xfffffff8251e7812ULL, 0x000fc400078ee21eULL, 0x0000001817257810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c157faeULL, 0x0003e2000c101c46ULL,
0x000000141900720cULL, 0x080fe20003f06070ULL, 0x0000000123177824ULL, 0x000fe200078e020fULL,
0x000000141b00720cULL, 0x080fe20003f26070ULL, 0x0000000125167824ULL, 0x000fe200078e0200ULL,
0x000000141d00720cULL, 0x080fe40003f46070ULL, 0x000000142100720cULL, 0x080fe40003f66070ULL,
0x000000142300720cULL, 0x000fc40003f86070ULL, 0x000000142500720cULL, 0x080fe20003fa6070ULL,
0x00000001210c7824ULL, 0x002fe200078e0200ULL, 0x0000000f19157210ULL, 0x000fe20007ffe0ffULL,
0x000000011b197824ULL, 0x100fe200078e020fULL, 0x000000142700720cULL, 0x000fe20003fc6070ULL,
0x000000011d1b7824ULL, 0x100fe200078e020fULL, 0x0000000023147210ULL, 0x000fe20007ffe0ffULL,
0x00000001211d7824ULL, 0x100fe400078e020fULL, 0x00000001250d7824ULL, 0x000fe400078e020fULL,
0x0000000821217824ULL, 0x000fc400078e00ffULL, 0x0000000823237824ULL, 0x000fe400078e00ffULL,
0x00000001270f7824ULL, 0x040fe200078e020fULL, 0x0000000327277819ULL, 0x000fe200000006ffULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0xfffffff821247812ULL, 0x000fe200078ee20cULL,
0x00005e001b1a7625ULL, 0x080fe200078e000eULL, 0xfffffff823267812ULL, 0x000fe400078ee214ULL,
0xfffffff825287812ULL, 0x000fe200078ee216ULL, 0x00005e0015147625ULL, 0x000fe200078e000eULL,
0xfffffff8272a7812ULL, 0x000fc600078ee218ULL, 0x00005e0019187625ULL, 0x000fe200078e000eULL,
0x0000006b2a2b7211ULL, 0x000fc600078e20ffULL, 0x00005e001d1c7625ULL, 0x000fc800078e000eULL,
0x00005e0017167625ULL, 0x000fc800078e000eULL, 0x00005e000d0c7625ULL, 0x000fc800078e000eULL,
0x00005e000f0e7625ULL, 0x000fc800078e000eULL, 0x0000001020217824ULL, 0x000fe400078e026bULL,
0x000000101f147825ULL, 0x000fc800078e0014ULL, 0x0000001022237824ULL, 0x000fe200078e026bULL,
0x0000000014217faeULL, 0x0003e2000c101c46ULL, 0x000000101f187825ULL, 0x000fc800078e0018ULL,
0x000000101f1a7825ULL, 0x040fe200078e001aULL, 0x0000000018237faeULL, 0x0003e6000c901c46ULL,
0x000000101f1c7825ULL, 0x000fc800078e001cULL, 0x000000101f167825ULL, 0x000fc800078e0016ULL,
0x000000101f0c7825ULL, 0x000fc800078e000cULL, 0x000000101f0e7825ULL, 0x000fc800078e000eULL,
0x000000101e1f7824ULL, 0x100fe400078e026bULL, 0x0000001024257824ULL, 0x100fe400078e026bULL,
0x0000001026277824ULL, 0x100fe200078e026bULL, 0x000000001a1f7faeULL, 0x0003e2000d101c46ULL,
0x0000001028297824ULL, 0x000fc600078e026bULL, 0x000000001c257faeULL, 0x0003e8000d901c46ULL,
0x0000000016277faeULL, 0x0003e8000e101c46ULL, 0x000000000c297faeULL, 0x0003e8000e901c46ULL,
0x000000000e2b7faeULL, 0x0003e2000f101c46ULL, 0x000004d000007947ULL, 0x000fea0003800000ULL,
0x0000000c001c7811ULL, 0x040fe200078fe8ffULL, 0x000000080b487824ULL, 0x000fe200078e00ffULL,
0x00000010001e7811ULL, 0x040fe200078fe8ffULL, 0x00000100ff217424ULL, 0x000fe200078e00ffULL,
0x0000000400167811ULL, 0x000fe200078fe8ffULL, 0x000000011c227824ULL, 0x100fe200078e0200ULL,
0x000000001e207210ULL, 0x080fe20007ffe0ffULL, 0x000000081c177824ULL, 0x000fe200078e00ffULL,
0x0000000800147811ULL, 0x000fe200078fe8ffULL, 0x000000081e197824ULL, 0x000fe200078e00ffULL,
0x00000014000e7811ULL, 0x000fe200078fe8ffULL, 0x0000000116267824ULL, 0x040fe200078e0200ULL,
0xfffffff817227812ULL, 0x000fe200078ee222ULL, 0x00000008160d7824ULL, 0x000fe200078e00ffULL,
0xfffffff819207812ULL, 0x000fe200078ee220ULL, 0x0000000114247824ULL, 0x000fe200078e0200ULL,
0x0000001800177811ULL, 0x000fe200078fe8ffULL, 0x0000000814157824ULL, 0x000fe200078e00ffULL,
0x0000001c00197811ULL, 0x000fe200078fe8ffULL, 0x0000000116167824ULL, 0x100fe200078e020fULL,
0xfffffff80d267812ULL, 0x000fe200078ee226ULL, 0x0000000114147824ULL, 0x100fe200078e020fULL,
0x00000000000d7211ULL, 0x000fe200078fe8ffULL, 0x000000011c1c7824ULL, 0x100fe200078e020fULL,
0x0000000f000c7211ULL, 0x080fe200078fe8ffULL, 0x000000010e1a7824ULL, 0x100fe200078e020fULL,
0x0000000f1e1e7210ULL, 0x080fe20007ffe0ffULL, 0x000000010e287824ULL, 0x040fe200078e0200ULL,
0xfffffff815247812ULL, 0x000fe200078ee224ULL, 0x000000080e1b7824ULL, 0x000fe200078e00ffULL,
0x000000070d157812ULL, 0x000fe200078ec0ffULL, 0x0000000117187824ULL, 0x000fe200078e020fULL,
0x0000000f190f7210ULL, 0x000fe20007ffe0ffULL, 0x00000001172a7824ULL, 0x040fe200078e0200ULL,
0xfffffff848277812ULL, 0x000fe200078ee267ULL, 0x0000000817177824ULL, 0x000fe200078e00ffULL,
0xfffffff81b287812ULL, 0x000fe200078ee228ULL, 0x00000001190e7824ULL, 0x100fe200078e0200ULL,
0x0ffffff815487812ULL, 0x000fe200078ef800ULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0xfffffff8172a7812ULL, 0x000fe200078ee22aULL, 0x00005e000c0c7625ULL, 0x000fe200078e0021ULL,
0x0000006b20297211ULL, 0x000fc400078e20ffULL, 0xfffffff8194a7812ULL, 0x000fe200078ee20eULL,
0x00005e0016167625ULL, 0x000fc800078e0021ULL, 0x00005e0014147625ULL, 0x000fc800078e0021ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0021ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0021ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0021ULL, 0x00005e0018187625ULL, 0x000fc800078e0021ULL,
0x00005e000f0e7625ULL, 0x000fc800078e0021ULL, 0x00000010270c7825ULL, 0x000fc800078e000cULL,
0x0000001048217824ULL, 0x100fe400078e026bULL, 0x0000001026237824ULL, 0x000fe400078e026bULL,
0x0000001027167825ULL, 0x040fe200078e0016ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c217faeULL, 0x0003e6000b901c46ULL, 0x0000001024257824ULL, 0x000fe200078e026bULL,
0x0000000016237faeULL, 0x0003e2000b901c46ULL, 0x0000001027147825ULL, 0x000fc800078e0014ULL,
0x00000010271c7825ULL, 0x040fe200078e001cULL, 0x0000000014257faeULL, 0x0003e6000b901c46ULL,
0x00000010271e7825ULL, 0x000fc800078e001eULL, 0x00000010271a7825ULL, 0x000fc800078e001aULL,
0x0000001027187825ULL, 0x000fc800078e0018ULL, 0x00000010270e7825ULL, 0x000fc800078e000eULL,
0x0000001022277824ULL, 0x100fe400078e026bULL, 0x00000010282b7824ULL, 0x100fe400078e026bULL,
0x000000102a497824ULL, 0x100fe200078e026bULL, 0x000000001c277faeULL, 0x0003e2000b901c46ULL,
0x000000104a4b7824ULL, 0x000fc600078e026bULL, 0x000000001e297faeULL, 0x0003e8000b901c46ULL,
0x000000001a2b7faeULL, 0x0003e8000b901c46ULL, 0x0000000018497faeULL, 0x0003e8000b901c46ULL,
0x000000000e4b7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe00a0d7812ULL, 0x002fc400078ec0ffULL, 0x000000100a167812ULL, 0x040fe400078ec0ffULL,
0x000000080a0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000d0c167210ULL, 0x000fe20007ffe016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01364800160e7f8cULL, 0x0002a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01364c0016157984ULL, 0x000ee40000000800ULL,
0x8000000015ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140c177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0dULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01364c0016157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000100680d7810ULL, 0x000fc80007ffe069ULL,
0x0000000d660d7210ULL, 0x000fca0007ffe0ffULL, 0x013000000d0e7984ULL, 0x000ea80000000800ULL,
0x013200000d147984ULL, 0x0006620000000800ULL, 0x0000006d0e00720bULL, 0x004fe20003f1d000ULL,
0x0000b9427f007947ULL, 0x000fd8000b800000ULL, 0x00000000000f7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0fff7812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff6c7224ULL, 0x000fd400078e006dULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x00000002570c7811ULL, 0x000fe400078ff0ffULL,
0x0000006d0e00720bULL, 0x000fe40003f34000ULL, 0x000000570c00720cULL, 0x000fe20003f05270ULL,
0x0000b8f27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000167806ULL, 0x002fc400008e0100ULL,
0x00000080570d8824ULL, 0x000fe200078e0268ULL, 0x0000000e6d0c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000166158824ULL, 0x000fe200078e020dULL,
0x00009910160d7816ULL, 0x000fc800000000ffULL, 0x0134000c15008388ULL, 0x0003e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000e6d0c7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL, 0x8000000c6d0c7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c001a7308ULL, 0x000e640000000800ULL,
0x0000001a05057220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011600ULL, 0x0000b8127f007947ULL, 0x000fea000b800000ULL,
0x00001f0c1a0c7589ULL, 0x0002a400000e0000ULL, 0x0000000c44447220ULL, 0x084fe20000410000ULL,
0x0000000c45457220ULL, 0x080fe20000410000ULL, 0x0000000c40407220ULL, 0x080fe20000410000ULL,
0x0000000c41417220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c38387220ULL, 0x080fe20000410000ULL,
0x0000000c39397220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008000c7811ULL, 0x000fe200078ff0ffULL, 0x0000b7027f007947ULL, 0x000fea000b800000ULL,
0x00001f0c1a0c7589ULL, 0x0004e400000e0000ULL, 0x0000000c46467220ULL, 0x088fe20000410000ULL,
0x0000000c47477220ULL, 0x080fe20000410000ULL, 0x0000000c42427220ULL, 0x080fe20000410000ULL,
0x0000000c43437220ULL, 0x080fe20000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000c36367220ULL, 0x080fe20000410000ULL,
0x0000000c37377220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c12127220ULL, 0x080fe20000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff16ff7812ULL, 0x000fe4000780080fULL, 0x0000000e6d6c7209ULL, 0x000fd60007810000ULL,
0x8000006c0e0e0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL,
0x0000000e00070308ULL, 0x000e640000000800ULL, 0x0000000714140220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x0000000514057221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x00005410080e7816ULL, 0x000fe20000000008ULL,
0x0000b5427f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e097589ULL, 0x0002e400000e0000ULL,
0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000b5727f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0e087589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e000eULL,
0x00005a8000187802ULL, 0x000fc40000000f00ULL, 0x0000bbe000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e000eULL, 0x00005ad000187802ULL, 0x000fc40000000f00ULL,
0x0000bb9000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00001000060c7824ULL, 0x002fe200078e00ffULL,
0x00a000006524783bULL, 0x000e680000000200ULL, 0x000010000c717812ULL, 0x000fc400078ec0ffULL,
0x00a000005c0c783bULL, 0x000f240000000200ULL, 0x0000b0006a717810ULL, 0x000fc80007ffe071ULL,
0x000000715d287211ULL, 0x000fe200078e20ffULL, 0x0000001060507824ULL, 0x100fe400078e0271ULL,
0x000000105f4c7824ULL, 0x100fe400078e0271ULL, 0x000000105e487824ULL, 0x100fe200078e0271ULL,
0x000000002828783bULL, 0x000ee20000004200ULL, 0x000000105b207824ULL, 0x100fe400078e0271ULL,
0x000000105a1c7824ULL, 0x100fe200078e0271ULL, 0x000000005050783bULL, 0x000ea20000004200ULL,
0x0000001058187824ULL, 0x000fc400078e0271ULL, 0x0000001056147824ULL, 0x000fe200078e0271ULL,
0x000000004c4c783bULL, 0x000ea80000004200ULL, 0x000000004848783bULL, 0x000ea80000004200ULL,
0x000000002020783bULL, 0x000ea80000004200ULL, 0x000000001c1c783bULL, 0x000ea20000004200ULL,
0x0000000924240231ULL, 0x00afc600003400ffULL, 0x000000001818783bULL, 0x004e620000004200ULL,
0x0000000926260231ULL, 0x080fe400003400ffULL, 0x0000000825250231ULL, 0x080fe200003400ffULL,
0x000000001414783bULL, 0x000ea20000004200ULL, 0x0000000827270231ULL, 0x080fe400003400ffULL,
0x000000090c0c0231ULL, 0x090fe400003400ffULL, 0x000000090e0e0231ULL, 0x000fe400003400ffULL,
0x000000080d0d0231ULL, 0x000fc400003400ffULL, 0x000000080f0f0231ULL, 0x000fe200003400ffULL,
0x00000028242c723cULL, 0x040ff0000004182cULL, 0x000000502444723cULL, 0x040f700000041844ULL,
0x000000522440723cULL, 0x040f700000041840ULL, 0x0000004c243c723cULL, 0x040f70000004183cULL,
0x0000004e2438723cULL, 0x040f700000041838ULL, 0x000000482434723cULL, 0x040f700000041834ULL,
0x0000004a2430723cULL, 0x040f700000041830ULL, 0x0000002a2410723cULL, 0x000f700000041810ULL,
0x000000200c44723cULL, 0x060b700000041844ULL, 0x000000220c40723cULL, 0x040b700000041840ULL,
0x0000001c0c3c723cULL, 0x040b70000004183cULL, 0x0000001e0c38723cULL, 0x040b700000041838ULL,
0x000000180c34723cULL, 0x042b700000041834ULL, 0x0000001a0c30723cULL, 0x040b700000041830ULL,
0x000000140c2c723cULL, 0x044b70000004182cULL, 0x000000160c10723cULL, 0x000b620000041810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000c0590c7811ULL, 0x020fe200078e40ffULL,
0x0136980063ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001066f7812ULL, 0x000fe200078e0cffULL,
0x000000ffff6d7224ULL, 0x000fe200078e006cULL, 0x000000550c00720cULL, 0x000fda0003f06070ULL,
0x0000176000000947ULL, 0x000fea0003800000ULL, 0x00000300590c7a10ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000010c0d7810ULL, 0x040fe20007ffe0ffULL,
0x000001000c157824ULL, 0x000fc600078e0203ULL, 0x000000540d00720cULL, 0x000fe20003f06070ULL,
0x00006200040f7a24ULL, 0x000fd800078e0215ULL, 0x000005a000008947ULL, 0x000fea0003800000ULL,
0x00000015550c7217ULL, 0x000fe40007800000ULL, 0x00000003ff177819ULL, 0x100fe40000011600ULL,
0x000000030b0e7819ULL, 0x000fe200000006ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a15ULL,
0x0000000417197810ULL, 0x040fe20007ffe0ffULL, 0x0000000117157824ULL, 0x140fe200078e0200ULL,
0xfffffff80e677812ULL, 0x000fe200078ee267ULL, 0x00000100ff0e7424ULL, 0x000fe200078e00ffULL,
0x000000200c147817ULL, 0x000fe20003800000ULL, 0x00000001170d7824ULL, 0x040fe200078e020fULL,
0x0000000c171d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001191e7824ULL, 0x000fe200078e0200ULL,
0x0000000715157812ULL, 0x000fe200078ec0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e000eULL,
0x00000008171b7810ULL, 0x000fc40007ffe0ffULL, 0x000000141700720cULL, 0x000fe20003f06070ULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0x0ffffff815167812ULL, 0x100fe200078ef800ULL,
0x000000011d207824ULL, 0x000fe200078e0200ULL, 0x000000001b227210ULL, 0x000fe20007ffe0ffULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1e7812ULL, 0x000fe200078ee21eULL,
0x000000081b217824ULL, 0x000fe200078e00ffULL, 0x00000010171f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010670c7825ULL, 0x000fe200078e000cULL, 0xfffffff823207812ULL, 0x000fc400078ee220ULL,
0xfffffff821227812ULL, 0x000fe200078ee222ULL, 0x0000001016157824ULL, 0x000fe200078e0271ULL,
0x0000001817237810ULL, 0x040fe40007ffe0ffULL, 0x0000001417217810ULL, 0x040fe40007ffe0ffULL,
0x0000001c17257810ULL, 0x000fe20007ffe0ffULL, 0x000000011b177824ULL, 0x140fe200078e020fULL,
0x000000141b00720cULL, 0x080fe20003f26070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e2000c101c46ULL, 0x000000141d00720cULL, 0x080fe20003f46070ULL,
0x0000000123167824ULL, 0x100fe200078e0200ULL, 0x0000000f1d1b7210ULL, 0x000fe20007ffe0ffULL,
0x000000011f1d7824ULL, 0x040fe200078e020fULL, 0x000000141f00720cULL, 0x080fe20003f66070ULL,
0x0000000125187824ULL, 0x000fe200078e0200ULL, 0x000000142300720cULL, 0x000fe20003fa6070ULL,
0x00005e001b1a7625ULL, 0x000fe200078e000eULL, 0x000000141900720cULL, 0x000fc40003f06070ULL,
0x000000142100720cULL, 0x080fe20003f86070ULL, 0x000000011f0c7824ULL, 0x002fe200078e0200ULL,
0x0000000f23157210ULL, 0x000fe20007ffe0ffULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x000000142500720cULL, 0x000fe20003fc6070ULL, 0x00000001190d7824ULL, 0x100fe400078e020fULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0xfffffff81f247812ULL, 0x000fe200078ee20cULL,
0x0000000121197824ULL, 0x100fe400078e020fULL, 0x00000001250f7824ULL, 0x000fe200078e020fULL,
0xfffffff823287812ULL, 0x000fe200078ee216ULL, 0x0000000121147824ULL, 0x000fc400078e0200ULL,
0x0000000825257824ULL, 0x000fe400078e00ffULL, 0x0000000821217824ULL, 0x000fe400078e00ffULL,
0x00005e000d0c7625ULL, 0x080fe200078e000eULL, 0xfffffff8252a7812ULL, 0x000fe400078ee218ULL,
0xfffffff821267812ULL, 0x000fe200078ee214ULL, 0x00005e0017167625ULL, 0x000fe200078e000eULL,
0x0000007122217211ULL, 0x000fc600078e20ffULL, 0x00005e001d1c7625ULL, 0x000fc800078e000eULL,
0x00005e0019187625ULL, 0x000fc800078e000eULL, 0x00005e0015147625ULL, 0x000fc800078e000eULL,
0x00005e000f0e7625ULL, 0x000fc800078e000eULL, 0x00000010670c7825ULL, 0x000fc800078e000cULL,
0x000000101e1f7824ULL, 0x000fe400078e0271ULL, 0x0000001067167825ULL, 0x000fc600078e0016ULL,
0x000000000c1f7faeULL, 0x0003e2000c101c46ULL, 0x00000010671a7825ULL, 0x000fc600078e001aULL,
0x0000000016217faeULL, 0x0003e2000c901c46ULL, 0x0000001020237824ULL, 0x000fe400078e0271ULL,
0x00000010671c7825ULL, 0x000fc600078e001cULL, 0x000000001a237faeULL, 0x0003e2000d101c46ULL,
0x0000001024257824ULL, 0x000fe400078e0271ULL, 0x0000001067187825ULL, 0x000fc600078e0018ULL,
0x000000001c257faeULL, 0x0003e2000d901c46ULL, 0x0000001026277824ULL, 0x000fe400078e0271ULL,
0x0000001067147825ULL, 0x000fc600078e0014ULL, 0x0000000018277faeULL, 0x0003e2000e101c46ULL,
0x0000001028297824ULL, 0x000fe400078e0271ULL, 0x00000010670e7825ULL, 0x000fc600078e000eULL,
0x0000000014297faeULL, 0x0003e2000e901c46ULL, 0x000000102a717824ULL, 0x000fca00078e0271ULL,
0x000000000e717faeULL, 0x0003e2000f101c46ULL, 0x000004d000007947ULL, 0x000fea0003800000ULL,
0x0000000400167811ULL, 0x040fe200078fe8ffULL, 0x000000080b0c7824ULL, 0x000fe200078e00ffULL,
0x0000000c001c7811ULL, 0x040fe400078fe8ffULL, 0x0000000800187811ULL, 0x000fe200078fe8ffULL,
0x00000008160d7824ULL, 0x000fe200078e00ffULL, 0x00000010001e7811ULL, 0x000fe200078fe8ffULL,
0x000000011c267824ULL, 0x100fe200078e0200ULL, 0x0000000016227210ULL, 0x080fe20007ffe0ffULL,
0x000000081c177824ULL, 0x000fe200078e00ffULL, 0x000000031e197819ULL, 0x000fe200000006ffULL,
0x0000000118247824ULL, 0x040fe200078e0200ULL, 0xfffffff80d227812ULL, 0x000fe200078ee222ULL,
0x0000000818157824ULL, 0x000fe200078e00ffULL, 0xfffffff817267812ULL, 0x000fe200078ee226ULL,
0x000000011e207824ULL, 0x000fe200078e0200ULL, 0x0000001800147811ULL, 0x000fe200078fe8ffULL,
0x0000000116167824ULL, 0x100fe200078e020fULL, 0x0000000000177211ULL, 0x080fe200078fe8ffULL,
0x0000000118187824ULL, 0x000fe200078e020fULL, 0x00000014000d7811ULL, 0x000fe200078fe8ffULL,
0x0000000814487824ULL, 0x000fe200078e00ffULL, 0xfffffff80c677812ULL, 0x000fe200078ee267ULL,
0x00000001140e7824ULL, 0x100fe200078e020fULL, 0x0000001c001b7811ULL, 0x000fe200078fe8ffULL,
0x000000080d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff815247812ULL, 0x000fe200078ee224ULL,
0x00000100ff157424ULL, 0x000fe200078e00ffULL, 0xfffffff819207812ULL, 0x000fe200078ee220ULL,
0x0000000114197824ULL, 0x100fe200078e0200ULL, 0x0000000f000c7211ULL, 0x000fe200078fe8ffULL,
0x000000011c1c7824ULL, 0x100fe200078e020fULL, 0x0000000717177812ULL, 0x000fe200078ec0ffULL,
0x000000011e1e7824ULL, 0x100fe200078e020fULL, 0x000000000d287210ULL, 0x040fe20007ffe0ffULL,
0x000000010d1a7824ULL, 0x100fe200078e020fULL, 0x0ffffff8172a7812ULL, 0x100fe200078ef800ULL,
0x000000011b147824ULL, 0x040fe200078e020fULL, 0x000000031b4a7819ULL, 0x040fe200000006ffULL,
0x000000011b0f7824ULL, 0x000fe200078e0200ULL, 0xfffffff848487812ULL, 0x000fe200078ee219ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0015ULL, 0xfffffff81d287812ULL, 0x000fc400078ee228ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee20fULL, 0x00005e0016167625ULL, 0x000fe200078e0015ULL,
0x0000007148497211ULL, 0x000fc600078e20ffULL, 0x00005e0018187625ULL, 0x000fc800078e0015ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0015ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0015ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0015ULL, 0x00000010670c7825ULL, 0x000fc800078e000cULL,
0x00005e000e0e7625ULL, 0x000fc800078e0015ULL, 0x000000102a217824ULL, 0x000fe400078e0271ULL,
0x00005e0014147625ULL, 0x000fc600078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c217faeULL, 0x0003e2000b901c46ULL, 0x0000001067167825ULL, 0x000fc800078e0016ULL,
0x0000001022237824ULL, 0x000fe400078e0271ULL, 0x0000001067187825ULL, 0x000fc600078e0018ULL,
0x0000000016237faeULL, 0x0003e2000b901c46ULL, 0x0000001024257824ULL, 0x000fe400078e0271ULL,
0x00000010671c7825ULL, 0x000fc600078e001cULL, 0x0000000018257faeULL, 0x0003e2000b901c46ULL,
0x0000001026277824ULL, 0x000fe400078e0271ULL, 0x00000010671e7825ULL, 0x000fc600078e001eULL,
0x000000001c277faeULL, 0x0003e2000b901c46ULL, 0x0000001020297824ULL, 0x000fe400078e0271ULL,
0x00000010671a7825ULL, 0x000fc600078e001aULL, 0x000000001e297faeULL, 0x0003e2000b901c46ULL,
0x00000010282b7824ULL, 0x000fe400078e0271ULL, 0x00000010670e7825ULL, 0x000fc600078e000eULL,
0x000000001a2b7faeULL, 0x0003e2000b901c46ULL, 0x0000001067147825ULL, 0x000fc600078e0014ULL,
0x000000000e497faeULL, 0x0003e2000b901c46ULL, 0x000000104a717824ULL, 0x000fca00078e0271ULL,
0x0000000014717faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe00a0c7812ULL, 0x042fe400078ec0ffULL, 0x000000100a0d7812ULL, 0x040fe400078ec0ffULL,
0x000000080a0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0e167210ULL, 0x000fe20007ffe00dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01366800160e7f8cULL, 0x0002a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01366c0016157984ULL, 0x000ee40000000800ULL,
0x8000000015ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140c177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0dULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01366c0016157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018068697810ULL, 0x000fca0007ffe069ULL,
0x0000000166697824ULL, 0x000fca00078e0269ULL, 0x01300000690f7984ULL, 0x000ea80000000800ULL,
0x01320000690e7984ULL, 0x0006620000000800ULL, 0x0000006c0f00720bULL, 0x004fe20003f1d000ULL,
0x0000a3527f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c197812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000006c006d7202ULL, 0x000fd20000000f00ULL,
0x0000044000009947ULL, 0x000fea0003800000ULL, 0x00000003570c7811ULL, 0x000fe400078ff0ffULL,
0x0000006c0f00720bULL, 0x000fe40003f54000ULL, 0x000000570c00720cULL, 0x000fe20003f25270ULL,
0x0000a3027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000147806ULL, 0x000fc400010e0100ULL,
0x00000080570d9824ULL, 0x000fe200078e0268ULL, 0x0000006c0f6d7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910140c7816ULL, 0x000fe200000000ffULL,
0x0000000166669824ULL, 0x000fca00078e020dULL, 0x0134006d66009388ULL, 0x0005e20000000800ULL,
0x000000ff0c00720cULL, 0x000fda0003f25270ULL, 0x0000030000009947ULL, 0x000fea0003800000ULL,
0x0000006c6d0c7221ULL, 0x004fe20000010100ULL, 0x000000ff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00167308ULL, 0x002e640000000800ULL, 0x0000001605057220ULL, 0x002fc80000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011600ULL,
0x0000a2327f007947ULL, 0x000fea000b800000ULL, 0x00001f0c160c7589ULL, 0x0002a400000e0000ULL,
0x0000000c44447220ULL, 0x084fe20000410000ULL, 0x0000000c45457220ULL, 0x080fe20000410000ULL,
0x0000000c40407220ULL, 0x080fe20000410000ULL, 0x0000000c41417220ULL, 0x080fe20000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000c38387220ULL, 0x080fe20000410000ULL, 0x0000000c39397220ULL, 0x080fe20000410000ULL,
0x0000000c34347220ULL, 0x080fe20000410000ULL, 0x0000000c35357220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c10107220ULL, 0x080fe20000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0014ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x000fe200078ff0ffULL,
0x0000a1227f007947ULL, 0x000fea000b800000ULL, 0x00001f0c160c7589ULL, 0x0004e400000e0000ULL,
0x0000000c46467220ULL, 0x088fe20000410000ULL, 0x0000000c47477220ULL, 0x080fe20000410000ULL,
0x0000000c42427220ULL, 0x080fe20000410000ULL, 0x0000000c43437220ULL, 0x080fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff19ff7812ULL, 0x000fda0007826014ULL,
0x0000000f6d0f1221ULL, 0x000fe20000010100ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0f0f1820ULL, 0x000fc80000410000ULL, 0x0000000f00071308ULL, 0x000ea40000000800ULL,
0x000000070e0e1220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000050e057221ULL, 0x002fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000010ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00005410080e7816ULL, 0x000fe20000000008ULL, 0x00009f627f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e097589ULL, 0x0002a400000e0000ULL, 0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL,
0x00009f927f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0e087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e000eULL, 0x0000725000187802ULL, 0x000fc40000000f00ULL,
0x0000a41000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0c7810ULL, 0x008fe40007ffe0ffULL, 0x0000000e00177202ULL, 0x004fc40000000f00ULL,
0x000072a000187802ULL, 0x000fc40000000f00ULL, 0x0000a3c000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00a800006524783bULL, 0x000f220000000200ULL, 0x0000001060507824ULL, 0x100fe200078e026bULL,
0x0000006b58187211ULL, 0x000fe200078e20ffULL, 0x000000105f4c7824ULL, 0x100fe200078e026bULL,
0x00a800005c0c783bULL, 0x00ae620000000200ULL, 0x000000105e487824ULL, 0x100fe400078e026bULL,
0x000000105d287824ULL, 0x100fe200078e026bULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x000000105b207824ULL, 0x100fe400078e026bULL, 0x000000105a1c7824ULL, 0x100fe200078e026bULL,
0x000000004c4c783bULL, 0x000ea20000004200ULL, 0x0000001056147824ULL, 0x000fc600078e026bULL,
0x000000004848783bULL, 0x000ea80000004200ULL, 0x000000002828783bULL, 0x000ea80000004200ULL,
0x000000002020783bULL, 0x000ea80000004200ULL, 0x000000001c1c783bULL, 0x000ea80000004200ULL,
0x000000001818783bULL, 0x000ea80000004200ULL, 0x000000001414783bULL, 0x004ea20000004200ULL,
0x0000000924240231ULL, 0x010fc400003400ffULL, 0x0000000926260231ULL, 0x080fe400003400ffULL,
0x0000000825250231ULL, 0x080fe400003400ffULL, 0x0000000827270231ULL, 0x080fe400003400ffULL,
0x000000090c0c0231ULL, 0x082fe400003400ffULL, 0x000000090e0e0231ULL, 0x000fe400003400ffULL,
0x000000080d0d0231ULL, 0x080fe200003400ffULL, 0x000000502444723cULL, 0x008f620000041844ULL,
0x000000080f0f0231ULL, 0x000fce00003400ffULL, 0x000000522440723cULL, 0x040f700000041840ULL,
0x0000004c243c723cULL, 0x040f70000004183cULL, 0x0000004e2438723cULL, 0x040f700000041838ULL,
0x000000482434723cULL, 0x040f700000041834ULL, 0x0000004a2430723cULL, 0x040f700000041830ULL,
0x00000028242c723cULL, 0x040f70000004182cULL, 0x0000002a2410723cULL, 0x000f700000041810ULL,
0x000000200c44723cULL, 0x060b700000041844ULL, 0x000000220c40723cULL, 0x040b700000041840ULL,
0x0000001c0c3c723cULL, 0x040b70000004183cULL, 0x0000001e0c38723cULL, 0x040b700000041838ULL,
0x000000180c34723cULL, 0x040b700000041834ULL, 0x0000001a0c30723cULL, 0x040b700000041830ULL,
0x000000140c2c723cULL, 0x044b70000004182cULL, 0x000000160c10723cULL, 0x000b620000041810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0136a00063ff7f8cULL, 0x0003e2000c80043fULL,
0x00000001066f7812ULL, 0x000fce00078ec0ffULL, 0x0000030059597a10ULL, 0x002fc80007ffe0ffULL,
0x000000545900720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff9c3000007947ULL, 0x000fea000383ffffULL, 0x0000000000047919ULL, 0x000e620000002500ULL,
0x000000ffff0a7224ULL, 0x020fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fe400078e0013ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe200078e0010ULL,
0x000000540400720cULL, 0x002fda0003f06070ULL, 0x0000033000000947ULL, 0x000fea0003800000ULL,
0x0180000005007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x000076f0000c7802ULL, 0x000fc40000000f00ULL,
0x00009dc000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000500007308ULL, 0x000e640000001000ULL, 0xbf80000000067423ULL, 0x002fc80000000005ULL,
0x800000ff06077221ULL, 0x000fc80000010100ULL, 0x0000000700007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000f280000000000ULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0x0000000807077811ULL, 0x010fe400078ff0ffULL,
0x00000002ff097819ULL, 0x002fc80000011606ULL, 0x00001f0700077589ULL, 0x00ce6800000e0000ULL,
0x00001f0900067589ULL, 0x000ea200000e0000ULL, 0x0000004607467220ULL, 0x042fe20000410000ULL,
0x0000004707477220ULL, 0x040fe20000410000ULL, 0x0000004207427220ULL, 0x040fe20000410000ULL,
0x0000004307437220ULL, 0x040fe20000410000ULL, 0x0000004406447220ULL, 0x044fe20000410000ULL,
0x0000004506457220ULL, 0x040fe20000410000ULL, 0x0000004006407220ULL, 0x040fe20000410000ULL,
0x0000004106417220ULL, 0x040fe20000410000ULL, 0x0000003c063c7220ULL, 0x040fe20000410000ULL,
0x0000003d063d7220ULL, 0x040fe20000410000ULL, 0x0000003806387220ULL, 0x040fe20000410000ULL,
0x0000003906397220ULL, 0x040fe20000410000ULL, 0x0000003406347220ULL, 0x040fe20000410000ULL,
0x0000003506357220ULL, 0x040fe20000410000ULL, 0x0000003006307220ULL, 0x040fe20000410000ULL,
0x0000003106317220ULL, 0x040fe20000410000ULL, 0x0000002c062c7220ULL, 0x040fe20000410000ULL,
0x0000002d062d7220ULL, 0x040fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000000a060a7220ULL, 0x000fe20000410000ULL, 0x0000003e073e7220ULL, 0x040fe20000410000ULL,
0x0000003f073f7220ULL, 0x040fe20000410000ULL, 0x0000003a073a7220ULL, 0x040fe20000410000ULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000003707377220ULL, 0x040fe20000410000ULL, 0x0000003207327220ULL, 0x040fe20000410000ULL,
0x0000003307337220ULL, 0x040fe20000410000ULL, 0x0000002e072e7220ULL, 0x040fe20000410000ULL,
0x0000002f072f7220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001907197220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000110a11723eULL, 0x000fc400000010ffULL, 0x0000001a1919723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000444508723eULL, 0x000fe400000010ffULL,
0x000000404109723eULL, 0x000fe400000010ffULL, 0x0000003c3d0c723eULL, 0x000fc400000010ffULL,
0x00000038390d723eULL, 0x000fe400000010ffULL, 0x00000034350e723eULL, 0x000fe400000010ffULL,
0x00000030310f723eULL, 0x000fe400000010ffULL, 0x0000002c2d10723eULL, 0x000fe400000010ffULL,
0x00000002ff1e7819ULL, 0x002fe40000011600ULL, 0x00000008002b7811ULL, 0x000fc400078ff0ffULL,
0x000000021e077810ULL, 0x040fe20007ffe0ffULL, 0x000000081e1d7824ULL, 0x040fe200078e00ffULL,
0x000000031e0a7819ULL, 0x040fe200000006ffULL, 0x000000081e257824ULL, 0x040fe200078e00ffULL,
0x000000011e067810ULL, 0x040fe20007ffe0ffULL, 0x000000081e1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a1f7812ULL, 0x000fe200078ee207ULL, 0x000000081e277824ULL, 0x040fe200078e00ffULL,
0x000000051e0a7810ULL, 0x040fe20007ffe0ffULL, 0x000000081e217824ULL, 0x040fe200078e00ffULL,
0x000000041e077810ULL, 0x040fe20007ffe0ffULL, 0x000000081e1b7824ULL, 0x040fe200078e00ffULL,
0x000000061e1a7810ULL, 0x040fe20007ffe0ffULL, 0x000000081e297824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL, 0x000000082b207824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fc400078ee20aULL, 0x000000031e067810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81c237812ULL, 0x000fe200078ee207ULL, 0x000010000b077824ULL, 0x000fe200078e00ffULL,
0x0000000b020a7819ULL, 0x000fe400000006ffULL, 0xfffffff827277812ULL, 0x000fe200078ee21aULL,
0x00000004001a7824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee206ULL,
0x0000000107067824ULL, 0x000fe200078e020aULL, 0xfffffff81b1b7812ULL, 0x000fc400078ee21eULL,
0xffffffff1e1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0206ULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0206ULL,
0x000000061f1f7211ULL, 0x080fe200078e20ffULL, 0x0000001021217824ULL, 0x000fe200078e0206ULL,
0xfffffff829297812ULL, 0x000fe200078ee21cULL, 0x0000001023237824ULL, 0x100fe200078e0206ULL,
0xfffffff8202b7812ULL, 0x000fe200078ee22bULL, 0x0000001025257824ULL, 0x000fe200078e0206ULL,
0x0000000629297211ULL, 0x000fe200078e20ffULL, 0x000000011b1b7824ULL, 0x000fe200078e021aULL,
0x000000464712723eULL, 0x000fe200000010ffULL, 0x000000011a1c7824ULL, 0x040fe200078e021dULL,
0x000000251a207210ULL, 0x040fe20007ffe0ffULL, 0x0000001027277824ULL, 0x100fe200078e0206ULL,
0x000000081b007388ULL, 0x0003e20000000800ULL, 0x000000011a1f7824ULL, 0x040fe200078e021fULL,
0x000000424313723eULL, 0x000fe200000010ffULL, 0x000000011a1e7824ULL, 0x040fe200078e0221ULL,
0x000000091c007388ULL, 0x000fe20000000800ULL, 0x000000102b2b7824ULL, 0x000fe200078e0206ULL,
0x0000003e3f14723eULL, 0x000fe200000010ffULL, 0x000000011a237824ULL, 0x040fe200078e0223ULL,
0x0000000c1f007388ULL, 0x0005e20000000800ULL, 0x000000011a277824ULL, 0x040fe200078e0227ULL,
0x0000003a3b15723eULL, 0x000fe200000010ffULL, 0x000000011a227824ULL, 0x040fe200078e0229ULL,
0x0000000d1e007388ULL, 0x000fe20000000800ULL, 0x000000011a2b7824ULL, 0x000fe200078e022bULL,
0x000000363716723eULL, 0x000fe200000010ffULL, 0x00000001031a7824ULL, 0x000fe200078e0200ULL,
0x0000000e23007388ULL, 0x000fe20000000800ULL, 0x000000323317723eULL, 0x000fe200000010ffULL,
0x000000ff00087306ULL, 0x002fe20000205400ULL, 0x0000002e2f18723eULL, 0x000fe200000010ffULL,
0x0000000f20007388ULL, 0x000fe20000000800ULL, 0x000000101a0c7824ULL, 0x004fc600078e0207ULL,
0x0000001027007388ULL, 0x000fe40000000800ULL, 0x000000ff00097306ULL, 0x000e640000209400ULL,
0x0000001122007388ULL, 0x000fe80000000800ULL, 0x000000122b007388ULL, 0x000fe80000000800ULL,
0x000400131c007388ULL, 0x000fe80000000800ULL, 0x000400141f007388ULL, 0x000fe20000000800ULL,
0x000000080900720bULL, 0x002fc60003f1d000ULL, 0x000400151e007388ULL, 0x000fe20000000800ULL,
0x000000ff00087245ULL, 0x000fc6000020d400ULL, 0x0004001623007388ULL, 0x000fe80000000800ULL,
0x0004001720007388ULL, 0x000fe40000000800ULL, 0x0000000108080812ULL, 0x000fe400078efcffULL,
0x0004001827007388ULL, 0x000fe40000000800ULL, 0x000000080809723eULL, 0x000fc400000010ffULL,
0x0004001922007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000c107984ULL, 0x000e680000000c00ULL, 0x000800000c1c7984ULL, 0x000ea80000000c00ULL,
0x000400000c287984ULL, 0x000ee80000000c00ULL, 0x000c00000c2c7984ULL, 0x000f220000000c00ULL,
0x3f803f8009107831ULL, 0x002fc40000200010ULL, 0x3f803f8009137831ULL, 0x040fe40000200013ULL,
0x3f803f8010107831ULL, 0x004fe2000020001cULL, 0x00000300001c7a02ULL, 0x000fe20000000f00ULL,
0x3f803f8009127831ULL, 0x040fe40000200012ULL, 0x3f803f8009117831ULL, 0x040fe20000200011ULL,
0x000000011c00780cULL, 0x000fe20003f05270ULL, 0x3f803f80092b7831ULL, 0x048fe4000020002bULL,
0x3f803f80092a7831ULL, 0x000fc4000020002aULL, 0x3f803f8009297831ULL, 0x040fe40000200029ULL,
0x3f803f8009287831ULL, 0x000fe40000200028ULL, 0x3f803f8013137831ULL, 0x000fe4000020001fULL,
0x3f803f8012127831ULL, 0x000fe4000020001eULL, 0x3f803f8011117831ULL, 0x000fe4000020001dULL,
0x3f803f802b2b7831ULL, 0x010fc4000020002fULL, 0x3f803f802a2a7831ULL, 0x000fe2000020002eULL,
0x000000100c007388ULL, 0x000fe20000000c00ULL, 0x3f803f8029297831ULL, 0x000fe4000020002dULL,
0x3f803f8028287831ULL, 0x000fca000020002cULL, 0x000400280c007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a1000008947ULL, 0x000fea0003800000ULL,
0x00005800ff097624ULL, 0x000fe200078e00ffULL, 0x0000000000137919ULL, 0x000e660000002700ULL,
0x0000640009097a24ULL, 0x000fe200078e02ffULL, 0x0000000000127919ULL, 0x000e680000002600ULL,
0x0000000f09107811ULL, 0x040fe200078e10ffULL, 0x0000030009097a24ULL, 0x000fe200078e02ffULL,
0x000000000c0c7984ULL, 0x000ea40000000c00ULL, 0xfffffff010107812ULL, 0x000fca00078ec0ffULL,
0x0000008009117824ULL, 0x000fc800078e0210ULL, 0x0000008009097824ULL, 0x000fe400078e0211ULL,
0x0000580013137a24ULL, 0x002fc600078e0212ULL, 0x0000007f09127810ULL, 0x000fe20007ffe0ffULL,
0x0000030013097a24ULL, 0x000fc600078e02ffULL, 0xffffff8012127812ULL, 0x000fe200078ec0ffULL,
0x0000000109047824ULL, 0x000fc600078e0204ULL, 0x0000680012157a10ULL, 0x000fc80007f1e0ffULL,
0x0000001504147211ULL, 0x000fe200078258ffULL, 0x00006900ff157624ULL, 0x000fe200000e06ffULL,
0x0000000102ff7812ULL, 0x000fc8000780f857ULL, 0x0000001504157211ULL, 0x000fe400008f5cffULL,
0x00006800101b7a10ULL, 0x000fc60007f3e0ffULL, 0x000004000b147825ULL, 0x000fcc00078e0014ULL,
0x000000101a147825ULL, 0x000fe200078e0014ULL, 0x00006900ff1a7a10ULL, 0x000fe20000ffe4ffULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x0000001000177824ULL, 0x004fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe20000011600ULL, 0x0000008004167824ULL, 0x000fe200078e00ffULL,
0x00000019ff047819ULL, 0x000fe40000011604ULL, 0x0000007017177812ULL, 0x000fe400078ec0ffULL,
0x0000000c18197812ULL, 0x000fe400078ec0ffULL, 0x0000680016187a10ULL, 0x000fc40007ebe011ULL,
0x0000001b17167210ULL, 0x000fe40007a3e016ULL, 0x0000001819187210ULL, 0x040fe40007c7e017ULL,
0x0000690004177a10ULL, 0x000fe40002fec4ffULL, 0x0000001619167210ULL, 0x000fe40007fbe0ffULL,
0x0000001aff047210ULL, 0x000fe40000fe4404ULL, 0x00000017ff197210ULL, 0x000fc60001fe84ffULL,
0x000000ffff177224ULL, 0x000fca00028e0604ULL, 0x0000006d16007986ULL, 0x0003e8000c101906ULL,
0x0000000518007986ULL, 0x0003e4000c101906ULL, 0x000000ff0000720cULL, 0x004fe20000705670ULL,
0x0000000c14007986ULL, 0x000fe2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000ff00000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff047424ULL, 0x000fe200078e00ffULL, 0xffffffff1c0d7810ULL, 0x000fc60007ffe0ffULL,
0x0000680013047625ULL, 0x002fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000d040479a8ULL, 0x000ea400099ee1c6ULL, 0x0000000d0400720cULL, 0x004fc80003f05270ULL,
0x00000001ff0c7807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000cff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff047984ULL, 0x000ea40000000000ULL,
0x000000ff0400720cULL, 0x004fda0003f05270ULL, 0x000025d000008947ULL, 0x000fea0003800000ULL,
0x000000ff5700720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001000057824ULL, 0x002fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe40000011600ULL,
0x0000001b09047211ULL, 0x000fe400078038ffULL, 0x00000070050d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000001a09057211ULL, 0x000fe400000f3cffULL,
0x000000040c047210ULL, 0x000fc8000791e00dULL, 0x00000005ff057210ULL, 0x000fca00007e24ffULL,
0x00000006040e7981ULL, 0x000328000c1e1900ULL, 0x00008006040f7981ULL, 0x000322000c1e1900ULL,
0x000000021c00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x0001000604137981ULL, 0x002322000c1e1900ULL, 0x000000041c00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x0001800604157981ULL, 0x002322000c1e1900ULL,
0x000000041c00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000604177981ULL, 0x002322000c1e1900ULL, 0x000000061c00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800604197981ULL, 0x002322000c1e1900ULL,
0x000000061c00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081c00780cULL, 0x002fe20003f06070ULL, 0x00030006041b7981ULL, 0x000318000c1e1900ULL,
0x00038006041d0981ULL, 0x000324000c1e1900ULL, 0x000000071c047810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0c7819ULL, 0x000fc80000011604ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x00000010091f7211ULL, 0x000fe200078038ffULL,
0x000000ffff0d7224ULL, 0x010fe200078e000eULL, 0x000000ff00167202ULL, 0x000fe20000000f00ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000068001f1f7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff09147211ULL, 0x000fe400000f3cffULL, 0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL,
0x00006900ff147a10ULL, 0x000fc400017e2414ULL, 0x0000030016007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x000000040c007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x0000000816047810ULL, 0x040fe40007ffe0ffULL,
0x0000000116057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0e0e7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0614ULL, 0xfffc8006040d7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x0000000916047810ULL, 0x042fe40007ffe0ffULL,
0x0000000216057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000f0e0e7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0614ULL, 0xfffd0006040f7981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a16047810ULL, 0x042fe40007ffe0ffULL,
0x0000000316057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x000000130e0e7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000400047819ULL, 0x000fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0614ULL, 0xfffd800604137981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b16047810ULL, 0x042fe40007ffe0ffULL,
0x0000000416057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x000000150e0e7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0614ULL, 0xfffe000604157981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c16047810ULL, 0x042fe40007ffe0ffULL,
0x0000000516057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x000000170e0e7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0614ULL, 0xfffe800604177981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d16047810ULL, 0x042fe40007ffe0ffULL,
0x0000000616057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x000000190e0e7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000400047819ULL, 0x000fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0614ULL, 0xffff000604197981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e16047810ULL, 0x042fe40007ffe0ffULL,
0x0000000716057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001b0e0e7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0614ULL, 0xffff8006041b7981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f16047810ULL, 0x002fe40007ffe0ffULL,
0x0000001d0e0e7209ULL, 0x000fe40007810000ULL, 0x0000030004007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0614ULL, 0x00000006041d7981ULL, 0x000326000c1e1900ULL,
0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL, 0x0000000816167810ULL, 0x000fe40007ffe0ffULL,
0x00000014ff147210ULL, 0x000fe20000ffe4ffULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fca00078ec0ffULL, 0x0000000104057824ULL, 0x000fca00078e0205ULL,
0x0000000e05007388ULL, 0x0103e40000000800ULL, 0x0000680012047a10ULL, 0x000fe20007f3e0ffULL,
0x0000000102157824ULL, 0x000fe200078e0209ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x000004000b0c7824ULL, 0x002fe200078e00ffULL, 0x0000000400127819ULL, 0x000fe200000006ffULL,
0x00006900ff057624ULL, 0x000fe200008e06ffULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000800150e7825ULL, 0x000fe200078e0004ULL,
0x0000007012137812ULL, 0x000fe200078ec0ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x0000000202168824ULL, 0x140fe200078e020bULL,
0x00000001020d7812ULL, 0x040fe200078ec0ffULL, 0x0000000202188824ULL, 0x000fe200078e020bULL,
0x0000000c0e127210ULL, 0x000fe20007f3e0ffULL, 0x0000000113147824ULL, 0x000fe200078e0214ULL,
0x00006800100e7a10ULL, 0x000fe20007f5e0ffULL, 0x00000002161d8824ULL, 0x100fe200078e020dULL,
0x0000000fff137210ULL, 0x000fe20000ffe4ffULL, 0x00000002181f8824ULL, 0x000fe200078e020dULL,
0x000008000a0f7812ULL, 0x000fe200078ec0ffULL, 0x00002000020a7824ULL, 0x000fe200078e0207ULL,
0x00006800110d7a10ULL, 0x000fe20007f3e0ffULL, 0x00006900ff307624ULL, 0x000fe200010e06ffULL,
0x0000002000177810ULL, 0x000fe20007ffe0ffULL, 0x000000010a117824ULL, 0x000fe200078e020fULL,
0x0000000e151c8211ULL, 0x040fe200078438ffULL, 0x00006900ff0f7624ULL, 0x000fe200008e06ffULL,
0x0000000d15188211ULL, 0x000fe200078238ffULL, 0x000000081f1f8824ULL, 0x000fe200078e0200ULL,
0x000000001d108211ULL, 0x000fe200078e18ffULL, 0x0000001017167825ULL, 0x000fe200078e0012ULL,
0x0000000f15198211ULL, 0x040fe200008f3cffULL, 0x0000000014317984ULL, 0x0002a20000000800ULL,
0x0000030002007a0cULL, 0x000fe20003f26070ULL, 0x00000010001b7824ULL, 0x040fe200078e0211ULL,
0x00000030151d8211ULL, 0x000fe200010f3cffULL, 0x0000001000127825ULL, 0x000fe200078e0012ULL,
0x0000458010158811ULL, 0x000fe200078e20ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000041801f218811ULL, 0x000fe200078e20ffULL, 0x0000001000188825ULL, 0x040fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000121b7faeULL, 0x0007e2000b901c46ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000010001c8825ULL, 0x000fe200078e001cULL, 0x00380000161b7faeULL, 0x0009e2000b901c46ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000018158faeULL, 0x0003e2000b901c46ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000000001c218faeULL, 0x0003e2000b901c46ULL,
0x0000000000127805ULL, 0x008fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000167805ULL, 0x010fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000c0000001947ULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fca00078e0002ULL, 0x0000000133367810ULL, 0x000fc80007ffe0ffULL,
0x0000030036007a0cULL, 0x000fda0003f06070ULL, 0x0000022000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f64070ULL, 0x00000001093d7824ULL, 0x000fe200078e0236ULL,
0x0000000136377812ULL, 0x040fe200078ec0ffULL, 0x0000080036367824ULL, 0x000fe200078e00ffULL,
0x0000002000417810ULL, 0x000fe20007ffe0ffULL, 0x000008003d347825ULL, 0x000fd000078e0004ULL,
0x0000000b0238b211ULL, 0x040fe200078e08ffULL, 0x00000002023ab824ULL, 0x000fc800078e020bULL,
0x00000002383fb824ULL, 0x100fe200078e0237ULL, 0x0000000d3d38b211ULL, 0x000fe200078238ffULL,
0x000000023a43b824ULL, 0x000fe200078e0237ULL, 0x0000080036377812ULL, 0x000fe200078ec0ffULL,
0x000000083f3fb824ULL, 0x100fe200078e0200ULL, 0x0000000c34367210ULL, 0x000fe20007f1e0ffULL,
0x000000084343b824ULL, 0x000fe200078e0200ULL, 0x0000000e3d34b211ULL, 0x040fe200078438ffULL,
0x000000010a3b7824ULL, 0x000fe200078e0237ULL, 0x0000000f3d39b211ULL, 0x000fe400008f3cffULL,
0x00000035ff377210ULL, 0x000fc400007fe4ffULL, 0x000000303d35b211ULL, 0x000fe200010f3cffULL,
0x00000010003d7824ULL, 0x040fe200078e023bULL, 0x000045803f3fb811ULL, 0x000fe200078e20ffULL,
0x00000010003ab825ULL, 0x000fc800078e0038ULL, 0x0000001041387825ULL, 0x000fe200078e0036ULL,
0x000041804341b811ULL, 0x000fc600078e20ffULL, 0x0000001000367825ULL, 0x000fc800078e0036ULL,
0x000000100034b825ULL, 0x000fe200078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000363d7faeULL, 0x0003e8000b901c46ULL, 0x00380000383d7faeULL, 0x0003e8000b901c46ULL,
0x000000003a3fbfaeULL, 0x0003e8000b901c46ULL, 0x000000003441bfaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000008033347824ULL, 0x002fe200078e00ffULL,
0x0000000400357819ULL, 0x000fe200000006ffULL, 0x0000000202377824ULL, 0x000fe200078e020bULL,
0x00000001ff367819ULL, 0x000fc40000011600ULL, 0x0000008034347812ULL, 0x000fe400078ec0ffULL,
0x0000007035357812ULL, 0x000fe400078ec0ffULL, 0x0000000c36367812ULL, 0x000fe200078ec0ffULL,
0x0000010037347824ULL, 0x000fe200078e0034ULL, 0x00000002ff447819ULL, 0x000fe20000011600ULL,
0x0000000400377824ULL, 0x000fc600078e00ffULL, 0x0000003436367210ULL, 0x000fe20007ffe035ULL,
0x00000008443e7824ULL, 0x040fe200078e00ffULL, 0x0000000144357810ULL, 0x040fe20007ffe0ffULL,
0x0000080033347824ULL, 0x000fe200078e00ffULL, 0x0000000c37477812ULL, 0x000fe200078ec0ffULL,
0x0000000844377824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee235ULL,
0x0000000844427824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800036387984ULL, 0x000e620000000800ULL, 0x0000080034357812ULL, 0x000fe200078ec0ffULL,
0x0000000844407824ULL, 0x040fe200078e00ffULL, 0x00000008444e7810ULL, 0x000fe20007ffe0ffULL,
0x00458000363a7984ULL, 0x0007220000000800ULL, 0x000001800a357810ULL, 0x000fe20007ffe035ULL,
0x0000000844467824ULL, 0x040fe200078e00ffULL, 0xfffffff837347812ULL, 0x000fe200078ee244ULL,
0x0000000844487824ULL, 0x000fe200078e00ffULL, 0x000000034e3b7819ULL, 0x000fe200000006ffULL,
0x00000008443f7824ULL, 0x040fe200078e00ffULL, 0x0000000244397810ULL, 0x000fe20007ffe0ffULL,
0x0000001034347824ULL, 0x000fe200078e0235ULL, 0xfffffff83b367812ULL, 0x008fe200078ee24eULL,
0x00000008444a7824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee239ULL,
0x0000000147347824ULL, 0x000fe200078e0234ULL, 0x00000003443b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001036367824ULL, 0x000fe200078e0235ULL, 0x00000004443d7810ULL, 0x000fc40007ffe0ffULL,
0x00000000343c7984ULL, 0x0006a20000000800ULL, 0x0000000233337810ULL, 0x000fe40007ffe0ffULL,
0xfffffff846467812ULL, 0x000fe400078ee23dULL, 0x0000030033007a0cULL, 0x000fe20003f06070ULL,
0x0000003831387221ULL, 0x006fc80000010100ULL, 0x3fb8aa3b38377820ULL, 0x000fe20000410000ULL,
0x0000003647387210ULL, 0x040fe20007ffe0ffULL, 0x000000103e367824ULL, 0x000fe200078e0235ULL,
0xfffffff8403e7812ULL, 0x000fe200078ee23bULL, 0x0000003700397308ULL, 0x0003220000000800ULL,
0x00000005443b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000038407984ULL, 0x0005e20000000800ULL,
0x0000000147367824ULL, 0x000fe400078e0236ULL, 0x000000103e347824ULL, 0x008fe200078e0235ULL,
0xfffffff848487812ULL, 0x000fc400078ee23bULL, 0x00000000363d7984ULL, 0x000fe20000000800ULL,
0x0000001042377824ULL, 0x102fe200078e0235ULL, 0xffffffff44387810ULL, 0x004fe20007ffe0ffULL,
0x0000000147347824ULL, 0x040fe200078e0234ULL, 0x0004000036417984ULL, 0x0003e40000000800ULL,
0x0000003747377210ULL, 0x000fe20007ffe0ffULL, 0x0000003a39457220ULL, 0x010fe20000410000ULL,
0xfffffff83f4c7812ULL, 0x000fe200078ee238ULL, 0x0004000034437984ULL, 0x000fe20000000800ULL,
0x0000003548387211ULL, 0x000fe200078e20ffULL, 0x0000001046367824ULL, 0x002fe200078e0235ULL,
0x0000000644397810ULL, 0x000fe20007ffe0ffULL, 0x00000000373e7984ULL, 0x000fe20000000800ULL,
0x0000003245327221ULL, 0x000fe20000010000ULL, 0x0000000147367824ULL, 0x040fe200078e0236ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee239ULL, 0x00001f44453a7589ULL, 0x000e6200000e0000ULL,
0x0000000147387824ULL, 0x000fc600078e0238ULL, 0x00001f4e453b7589ULL, 0x0004e200000e0000ULL,
0x000000104a397824ULL, 0x100fe400078e0235ULL, 0x000000104c357824ULL, 0x000fe200078e0235ULL,
0x0004000037427984ULL, 0x000f220000000800ULL, 0x0000000147397824ULL, 0x000fc600078e0239ULL,
0x00000000343f7984ULL, 0x0003e20000000800ULL, 0x0000003547357210ULL, 0x000fe40007ffe0ffULL,
0x00007610ff457816ULL, 0x104fe2000000003cULL, 0x0004000036447984ULL, 0x000fe20000000800ULL,
0x00005410ff347816ULL, 0x002fc6000000003cULL, 0x0000000036377984ULL, 0x0002a20000000800ULL,
0x0000003a452e7223ULL, 0x080fe2000001002eULL, 0x0000003a342f7223ULL, 0x080fe2000001002fULL,
0x00005410ff347816ULL, 0x100fe20000000040ULL, 0x00040000383c7984ULL, 0x000fe20000000800ULL,
0x00007610ff457816ULL, 0x000fe40000000040ULL, 0x00005410ff367816ULL, 0x002fe2000000003dULL,
0x0000003b341d7223ULL, 0x088fe2000001001dULL, 0x00007610ff3d7816ULL, 0x000fe2000000003dULL,
0x0000000038347984ULL, 0x0002e20000000800ULL, 0x00007610ff407816ULL, 0x000fe20000000043ULL,
0x0000003a362d7223ULL, 0x080fe2000001002dULL, 0x0000003b45287223ULL, 0x080fe20000010028ULL,
0x0000003a3d2c7223ULL, 0x000fe2000001002cULL, 0x00005410ff3d7816ULL, 0x000fe20000000041ULL,
0x0000000039367984ULL, 0x000ee20000000800ULL, 0x0000003b40257223ULL, 0x000fe20000010025ULL,
0x00007610ff387816ULL, 0x002fc40000000041ULL, 0x0000003b3d1c7223ULL, 0x080fe4000001001cULL,
0x00040000393d7984ULL, 0x0003e20000000800ULL, 0x0000003b38277223ULL, 0x000fe20000010027ULL,
0x00005410ff387816ULL, 0x000fca000000003eULL, 0x0000003a382b7223ULL, 0x080fe2000001002bULL,
0x00007610ff397816ULL, 0x002fe2000000003eULL, 0x0000000035387984ULL, 0x000e680000000800ULL,
0x00040000353e7984ULL, 0x0004620000000800ULL, 0x0000003a392a7223ULL, 0x000fe2000001002aULL,
0x00005410ff397816ULL, 0x010fe40000000042ULL, 0x00005410ff407816ULL, 0x004fc60000000037ULL,
0x0000003b391a7223ULL, 0x000fe2000001001aULL, 0x00007610ff357816ULL, 0x000fe20000000042ULL,
0x0000003a40217223ULL, 0x000fe20000010021ULL, 0x00007610ff407816ULL, 0x000fc60000000037ULL,
0x0000003b35267223ULL, 0x080fe20000010026ULL, 0x00005410ff357816ULL, 0x000fe2000000003fULL,
0x0000003a40197223ULL, 0x080fe20000010019ULL, 0x00007610ff3f7816ULL, 0x000fe4000000003fULL,
0x00005410ff407816ULL, 0x000fe20000000044ULL, 0x0000003a35227223ULL, 0x080fe20000010022ULL,
0x00005410ff357816ULL, 0x000fe20000000043ULL, 0x0000003a3f127223ULL, 0x000fe40000010012ULL,
0x0000003b40177223ULL, 0x000fc40000010017ULL, 0x0000003b35187223ULL, 0x000fe20000010018ULL,
0x00007610ff357816ULL, 0x000fca0000000044ULL, 0x0000003b35247223ULL, 0x000fe20000010024ULL,
0x00005410ff357816ULL, 0x108fe40000000034ULL, 0x00007610ff347816ULL, 0x000fc60000000034ULL,
0x0000003a35207223ULL, 0x080fe20000010020ULL, 0x00005410ff357816ULL, 0x000fe2000000003cULL,
0x0000003a341b7223ULL, 0x080fe2000001001bULL, 0x00005410ff347816ULL, 0x000fe40000000036ULL,
0x00007610ff3c7816ULL, 0x000fe2000000003cULL, 0x0000003b35167223ULL, 0x080fe20000010016ULL,
0x00005410ff357816ULL, 0x002fe20000000038ULL, 0x0000003a341f7223ULL, 0x080fe2000001001fULL,
0x00005410ff347816ULL, 0x000fe2000000003dULL, 0x0000003b3c157223ULL, 0x080fe20000010015ULL,
0x00007610ff367816ULL, 0x000fe20000000036ULL, 0x0000003a351e7223ULL, 0x080fe2000001001eULL,
0x00005410ff357816ULL, 0x000fe2000000003eULL, 0x0000003b34117223ULL, 0x080fe20000010011ULL,
0x00007610ff347816ULL, 0x000fe2000000003dULL, 0x0000003a36137223ULL, 0x000fe20000010013ULL,
0x00007610ff387816ULL, 0x000fe20000000038ULL, 0x0000003b35147223ULL, 0x080fe20000010014ULL,
0x00007610ff357816ULL, 0x000fe2000000003eULL, 0x0000003b34237223ULL, 0x000fc40000010023ULL,
0x0000003a38297223ULL, 0x000fe40000010029ULL, 0x0000003b35107223ULL, 0x000fe20000010010ULL,
0xfffff42000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff0b00720cULL, 0x000fe20003f05270ULL, 0x0000001000047824ULL, 0x002fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x00000070040a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c000d7812ULL, 0x000fca00078ec0ffULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x0000001000047824ULL, 0x002fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007004057812ULL, 0x000fe400078ec0ffULL,
0x0000000c00097812ULL, 0x000fc600078ec0ffULL, 0x0000008002007824ULL, 0x000fc800078e0205ULL,
0x0000000109057824ULL, 0x000fca00078e0200ULL, 0x0049803205007388ULL, 0x0003e40000000800ULL,
0x000000010a0a7824ULL, 0x000fe200078e020dULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x004980000a007984ULL, 0x000ee20000000800ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x004a00000a057984ULL, 0x002e620000000800ULL, 0x00000000ff007221ULL, 0x008fc80000010000ULL,
0x0000000500007221ULL, 0x002fca0000010000ULL, 0x0180000000047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x0000000000057202ULL, 0x000fe40000000f00ULL, 0x0000a1f0000c7802ULL, 0x000fc40000000f00ULL,
0x000072c000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000e640000001000ULL,
0xbf80000000047423ULL, 0x002fc80000000005ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000405047223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x000000080808723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff0f7819ULL, 0x008fe40000011600ULL,
0x0000000800317811ULL, 0x004fe400078ff0ffULL, 0x000000010f0e7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0f040a7589ULL, 0x000ea200000e0000ULL, 0x000000080f337824ULL, 0x040fe200078e00ffULL,
0x000000030f377819ULL, 0x040fe200000006ffULL, 0x000000080f397824ULL, 0x040fe200078e00ffULL,
0x00001f3104097589ULL, 0x00072200000e0000ULL, 0x000000080f3b7824ULL, 0x040fe200078e00ffULL,
0x000000190a0c7220ULL, 0x044fe20000410000ULL, 0x000000080f197824ULL, 0x000fe200078e00ffULL,
0x0000002f0a2f7220ULL, 0x040fe20000410000ULL, 0x0000002e0a2e7220ULL, 0x040fe20000410000ULL,
0x0000002d0a2d7220ULL, 0x040fe20000410000ULL, 0x0000002c0a2c7220ULL, 0x040fe20000410000ULL,
0x0000002b0a2b7220ULL, 0x040fe20000410000ULL, 0x0000002a0a2a7220ULL, 0x040fe20000410000ULL,
0x000000220a227220ULL, 0x040fe20000410000ULL, 0x000000120a057220ULL, 0x042fe20000410000ULL,
0x000000210a217220ULL, 0x040fe20000410000ULL, 0x000000200a207220ULL, 0x040fe20000410000ULL,
0x0000001b0a1b7220ULL, 0x040fe20000410000ULL, 0x0000001f0a1f7220ULL, 0x040fe20000410000ULL,
0x000000130a047220ULL, 0x048fe20000410000ULL, 0x0000001e0a1e7220ULL, 0x040fe20000410000ULL,
0x000000290a297220ULL, 0x000fe20000410000ULL, 0x0000001d091d7220ULL, 0x050fe20000410000ULL,
0x0000002809287220ULL, 0x040fe20000410000ULL, 0x0000001c091c7220ULL, 0x040fe20000410000ULL,
0x0000002709277220ULL, 0x040fe20000410000ULL, 0x0000001a091a7220ULL, 0x040fe20000410000ULL,
0x00000026090d7220ULL, 0x040fe20000410000ULL, 0x0000001809187220ULL, 0x040fe20000410000ULL,
0x0000002509257220ULL, 0x040fe20000410000ULL, 0x0000001709177220ULL, 0x040fe20000410000ULL,
0x0000002409247220ULL, 0x040fe20000410000ULL, 0x0000001609167220ULL, 0x040fe20000410000ULL,
0x0000001509157220ULL, 0x040fe20000410000ULL, 0x0000001109117220ULL, 0x040fe20000410000ULL,
0x00000023090a7220ULL, 0x040fe20000410000ULL, 0x0000001409147220ULL, 0x040fe20000410000ULL,
0x0000001009097220ULL, 0x000fe20000410000ULL, 0x000000080f237824ULL, 0x040fe200078e00ffULL,
0x000000020f107810ULL, 0x040fe20007ffe0ffULL, 0x000000080f267824ULL, 0x040fe200078e00ffULL,
0x000000030f127810ULL, 0x000fc40007ffe0ffULL, 0x000000040f137810ULL, 0x000fe40007ffe0ffULL,
0xfffffff819197812ULL, 0x000fe400078ee20eULL, 0x000000050f0e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823237812ULL, 0x000fe400078ee210ULL, 0xfffffff833337812ULL, 0x000fe400078ee212ULL,
0xfffffff826357812ULL, 0x040fe200078ee213ULL, 0x0000001023237824ULL, 0x100fe200078e0206ULL,
0x000000060f107810ULL, 0x000fe20007ffe0ffULL, 0x0000001033337824ULL, 0x100fe200078e0206ULL,
0xffffffff0f127810ULL, 0x000fe20007ffe0ffULL, 0x0000001035357824ULL, 0x000fe200078e0206ULL,
0xfffffff826137812ULL, 0x000fe200078ee20fULL, 0x0000000831267824ULL, 0x000fe200078e00ffULL,
0xfffffff8370f7812ULL, 0x000fe200078ee20eULL, 0x00000004000e7824ULL, 0x000fe200078e00ffULL,
0x0000000619197211ULL, 0x080fe200078e20ffULL, 0x0000001013137824ULL, 0x000fe200078e0206ULL,
0xfffffff839377812ULL, 0x000fe200078ee210ULL, 0x000000100f0f7824ULL, 0x000fe200078e0206ULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x0000000103107824ULL, 0x000fe200078e0200ULL,
0xfffffff83b397812ULL, 0x000fe200078ee212ULL, 0x0000001037377824ULL, 0x000fe200078e0206ULL,
0xfffffff826317812ULL, 0x000fe200078ee231ULL, 0x0000000113137824ULL, 0x000fe200078e020eULL,
0x0000002f2e2e723eULL, 0x000fe200000010ffULL, 0x000000010e197824ULL, 0x000fe200078e0219ULL,
0x0000002d2c2c723eULL, 0x000fe200000010ffULL, 0x000000010e237824ULL, 0x000fe200078e0223ULL,
0x0000002b2a2a723eULL, 0x000fe200000010ffULL, 0x000000010e337824ULL, 0x040fe200078e0233ULL,
0x0000000639397211ULL, 0x000fe200078e20ffULL, 0x0000001031317824ULL, 0x000fe200078e0206ULL,
0x000000220505723eULL, 0x000fe200000010ffULL, 0x000000010e067824ULL, 0x000fe200078e020fULL,
0x000000210c0c723eULL, 0x000fe200000010ffULL, 0x0000002e13007388ULL, 0x000fe20000000800ULL,
0x000000350e357210ULL, 0x040fe20007ffe0ffULL, 0x000000010e377824ULL, 0x000fe200078e0237ULL,
0x000000201b1b723eULL, 0x000fe200000010ffULL, 0x0000002c19007388ULL, 0x000fe20000000800ULL,
0x0000001f0404723eULL, 0x000fe200000010ffULL, 0x000000010e397824ULL, 0x000fe200078e0239ULL,
0x0000001e291e723eULL, 0x000fe200000010ffULL, 0x0000002a23007388ULL, 0x000fe20000000800ULL,
0x0000001d281d723eULL, 0x000fe200000010ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0231ULL,
0x0000001c271c723eULL, 0x000fe200000010ffULL, 0x0000000533007388ULL, 0x000fe20000000800ULL,
0x0000001a0d0d723eULL, 0x000fc400000010ffULL, 0x000000182518723eULL, 0x000fe200000010ffULL,
0x0000000c35007388ULL, 0x000fe20000000800ULL, 0x000000172417723eULL, 0x000fe400000010ffULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x0000001b06007388ULL, 0x000fe20000000800ULL,
0x000000110a0a723eULL, 0x000fe400000010ffULL, 0x000000140909723eULL, 0x000fe200000010ffULL,
0x0000000437007388ULL, 0x000fe20000000800ULL, 0x0000000710037211ULL, 0x000fc600078e20ffULL,
0x0000001e39007388ULL, 0x000fe80000000800ULL, 0x0000001d0e007388ULL, 0x000fe80000000800ULL,
0x0004001c19007388ULL, 0x000fe80000000800ULL, 0x0004000d23007388ULL, 0x000fe80000000800ULL,
0x0004001833007388ULL, 0x000fe80000000800ULL, 0x0004001735007388ULL, 0x000fe80000000800ULL,
0x0004001506007388ULL, 0x000fe80000000800ULL, 0x0004000a37007388ULL, 0x000fe80000000800ULL,
0x0004000939007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000003107984ULL, 0x000e680000000c00ULL, 0x00040000030c7984ULL, 0x000ea80000000c00ULL,
0x00080000031c7984ULL, 0x000ee80000000c00ULL, 0x000c000003207984ULL, 0x000f220000000c00ULL,
0x3f803f8008137831ULL, 0x002fc40000200013ULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008117831ULL, 0x040fe40000200011ULL, 0x3f803f8008107831ULL, 0x040fe40000200010ULL,
0x3f803f80080f7831ULL, 0x044fe4000020000fULL, 0x3f803f80080e7831ULL, 0x040fe4000020000eULL,
0x3f803f80080d7831ULL, 0x000fc4000020000dULL, 0x3f803f80080c7831ULL, 0x000fe4000020000cULL,
0x3f803f8013137831ULL, 0x008fe4000020001fULL, 0x3f803f8012127831ULL, 0x000fe4000020001eULL,
0x3f803f8011117831ULL, 0x000fe4000020001dULL, 0x3f803f8010107831ULL, 0x000fe4000020001cULL,
0x3f803f800f0f7831ULL, 0x010fc40000200023ULL, 0x3f803f800e0e7831ULL, 0x000fe20000200022ULL,
0x0000001003007388ULL, 0x000fe20000000c00ULL, 0x3f803f800d0d7831ULL, 0x000fe40000200021ULL,
0x3f803f800c0c7831ULL, 0x000fca0000200020ULL, 0x0004000c03007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002000157810ULL, 0x000fe20007ffe0ffULL,
0x0000000000037919ULL, 0x000ea20000002600ULL, 0x00000003ff057819ULL, 0x102fe20000011600ULL,
0x00000000000579c3ULL, 0x000e620000002700ULL, 0x00000003ff047819ULL, 0x000fe20000011615ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000105067824ULL, 0x000fe400078e0200ULL,
0x0000000115027824ULL, 0x000fc600078e0204ULL, 0x0000000706097812ULL, 0x000fe400078ec0ffULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x0ffffff809087812ULL, 0x000fe200078ef800ULL,
0x000000080b097824ULL, 0x000fe200078e00ffULL, 0x0ffffff802067812ULL, 0x000fc600078ef815ULL,
0x0000001008027824ULL, 0x100fe200078e0207ULL, 0xfffffff809097812ULL, 0x000fe200078ee200ULL,
0x0000001006067824ULL, 0x000fe200078e0207ULL, 0x0000000303077819ULL, 0x044fe200000006ffULL,
0x0000000803087824ULL, 0x000fe200078e00ffULL, 0x00000000020c7984ULL, 0x000ea20000000c00ULL,
0x00000005040472a4ULL, 0x002fe2000f8e023fULL, 0xfffffff807047812ULL, 0x000fe400078ee204ULL,
0x0000000006107984ULL, 0x0002e20000000c00ULL, 0xfffffff808037812ULL, 0x000fc400078ee205ULL,
0x0000000404057c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0xfffffff80a077812ULL, 0x000fe200078ee215ULL, 0x000000ffff067224ULL, 0x002fe200008e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078240ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005a0003027a11ULL, 0x000fe400078040ffULL, 0x00005b0005057a11ULL, 0x000fc400008f4406ULL,
0x00005b0003037a11ULL, 0x000fc600000f4408ULL, 0x0000001007047825ULL, 0x000fc800078e0004ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x004fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000159037810ULL, 0x000fe20007ffe0ffULL,
0x000000020f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000657047819ULL, 0x000fe200000006ffULL,
0x01360000ff067f8cULL, 0x002e62000c80043fULL, 0x000000540300720cULL, 0x000fe20003f06070ULL,
0x000058000f027a24ULL, 0x000fc400078e0210ULL, 0x0000010059127824ULL, 0x000fc800078e0204ULL,
0x0000620002217a24ULL, 0x000fcc00078e0212ULL, 0x0000059000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1a7819ULL, 0x000fe40000011600ULL, 0x000000300e1f7812ULL, 0x000fe400078ec0ffULL,
0x000000081a147810ULL, 0x040fe20007ffe0ffULL, 0x0000000121087824ULL, 0x000fe200078e021aULL,
0x000000101a1c7810ULL, 0x040fe40007ffe0ffULL, 0x0000001255037217ULL, 0x000fe20007800000ULL,
0x00000001210a7824ULL, 0x000fe200078e0214ULL, 0x000000181a1e7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0005ULL, 0x0000000312037210ULL, 0x000fc40007ffe1ffULL,
0x000000201a187810ULL, 0x000fe20007ffe0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0005ULL,
0x0000001f08107210ULL, 0x080fe40007f1e0ffULL, 0x0000100057197811ULL, 0x000fe200078e68ffULL,
0x00000001210c7824ULL, 0x040fe200078e021cULL, 0x0000001f0a127210ULL, 0x000fe20007f3e0ffULL,
0x00000001210e7824ULL, 0x000fe200078e021eULL, 0x000000031c00720cULL, 0x000fe20003fa6070ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0005ULL, 0x000000031e00720cULL, 0x000fc40003f86070ULL,
0x000000031800720cULL, 0x000fe20003f66070ULL, 0x000000ffff117224ULL, 0x000fe200000e0609ULL,
0x0000001f0c087210ULL, 0x000fe20007f1e0ffULL, 0x00005e000e0e7625ULL, 0x000fe200078e0005ULL,
0x00000002140c7819ULL, 0x000fe400000006ffULL, 0x000000021c1c7819ULL, 0x000fe200000006ffULL,
0x000000ffff137224ULL, 0x000fe200008e060bULL, 0x00000000000b7211ULL, 0x000fe200078fe8ffULL,
0x00000001210a7824ULL, 0x000fe200078e0218ULL, 0x0000001f0e0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e060dULL, 0x000000030b0d7812ULL, 0x000fe200078ec0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0005ULL, 0x000000031a00720cULL, 0x000fc40003f06070ULL,
0x0ffffffc0d007812ULL, 0x000fe200078ef800ULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x000000031400720cULL, 0x000fe40003f26070ULL, 0x0000001f0a147210ULL, 0x000fe20007f5e0ffULL,
0x00000010001b7824ULL, 0x000fe200078e0219ULL, 0xfffffffc0c0a7812ULL, 0x000fe400078ee20dULL,
0x000000281a0c7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200010e060bULL,
0x000000301a007810ULL, 0x000fe20007ffe0ffULL, 0x000000100a1d7824ULL, 0x000fe200078e0219ULL,
0x000000381a1a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001210a7824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101b7faeULL, 0x0005e2000c101c46ULL,
0x000000030c00720cULL, 0x000fc40003f46070ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0005ULL,
0x00000000121d7faeULL, 0x0007e2000c901c46ULL, 0x000000030000720cULL, 0x000fe40003f26070ULL,
0x000000041a207824ULL, 0x000fe200078e00ffULL, 0x0000001f0a167210ULL, 0x000fe20007fde0ffULL,
0x00000001210a7824ULL, 0x000fe200078e0200ULL, 0x000000031a00720cULL, 0x000fe20003f06070ULL,
0x000000041e107824ULL, 0x004fe400078e00ffULL, 0x000000ffff177224ULL, 0x000fc400030e060bULL,
0x0000000418127824ULL, 0x008fe200078e00ffULL, 0xfffffffc10107812ULL, 0x100fe200078ee20dULL,
0x000000040c187824ULL, 0x000fe200078e00ffULL, 0x0000001a210c7210ULL, 0x000fe20007ffe0ffULL,
0x00000004001e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1c007812ULL, 0x100fe200078ee20dULL,
0x00005e000a0a7625ULL, 0x000fe200078e0005ULL, 0xfffffffc12127812ULL, 0x100fe400078ee20dULL,
0xfffffffc18187812ULL, 0x000fe200078ee20dULL, 0x0000001000037824ULL, 0x100fe200078e0219ULL,
0x0000001f0a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001012117824ULL, 0x000fe200078e0219ULL,
0xfffffffc1e1a7812ULL, 0x000fc400078ee20dULL, 0xfffffffc201c7812ULL, 0x000fe200078ee20dULL,
0x00005e000c0c7625ULL, 0x000fe200078e0005ULL, 0x0000001918137211ULL, 0x000fe200078e20ffULL,
0x0000000008037faeULL, 0x0005e4000e901c46ULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000001f0c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001010057824ULL, 0x100fe400078e0219ULL,
0x000000101a1b7824ULL, 0x100fe400078e0219ULL, 0x000000101c197824ULL, 0x000fe200078e0219ULL,
0x000000000e057faeULL, 0x0005e2000e101c46ULL, 0x000000ffff0d7224ULL, 0x000fc600030e060dULL,
0x0000000014117faeULL, 0x0005e8000d901c46ULL, 0x0000000016137faeULL, 0x0005e8000d101c46ULL,
0x000000000a1b7faeULL, 0x0005e8000c901c46ULL, 0x000000000c197faeULL, 0x0005e2000c101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x040fe400078ff0ffULL,
0x0000001800097811ULL, 0x000fc400078ff0ffULL, 0x0000002100087211ULL, 0x000fe200078ff0ffULL,
0x000000040c127824ULL, 0x000fe200078e00ffULL, 0x00000000000a7211ULL, 0x040fe200078fe8ffULL,
0x0000000121107824ULL, 0x000fe200078e0209ULL, 0x0000001000037811ULL, 0x040fe200078ff0ffULL,
0x0000000409167824ULL, 0x000fe200078e00ffULL, 0x00000020000b7811ULL, 0x000fe200078ff0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0005ULL, 0x000000030a177812ULL, 0x000fe400078ec0ffULL,
0x00000028000d7811ULL, 0x000fe200078ff0ffULL, 0x00000001210a7824ULL, 0x000fe200078e020cULL,
0x000000300e257812ULL, 0x000fe200078ec0ffULL, 0x0000000403147824ULL, 0x000fe200078e00ffULL,
0x00000003210c7210ULL, 0x000fe20007ffe0ffULL, 0x000000040b207824ULL, 0x000fe200078e00ffULL,
0x00000030000e7811ULL, 0x040fe200078ff0ffULL, 0x000000040d227824ULL, 0x000fe200078e00ffULL,
0x00000038000f7811ULL, 0x000fe200078ff0ffULL, 0x0000000121187824ULL, 0x000fe200078e020bULL,
0x0ffffffc17037812ULL, 0x000fe200078ef800ULL, 0x00000001211c7824ULL, 0x000fe200078e020eULL,
0xfffffffc12007812ULL, 0x100fe200078ee217ULL, 0x000000040e247824ULL, 0x000fe200078e00ffULL,
0x0000002508127210ULL, 0x000fe20007f1e0ffULL, 0x000000040f267824ULL, 0x000fe200078e00ffULL,
0xfffffffc140e7812ULL, 0x000fe200078ee217ULL, 0x00000001211e7824ULL, 0x000fe200078e020fULL,
0xfffffffc20117812ULL, 0x000fc400078ee217ULL, 0x00000009ff137210ULL, 0x000fe200007fe4ffULL,
0x00005e000a087625ULL, 0x080fe200078e0005ULL, 0xfffffffc22147812ULL, 0x100fe400078ee217ULL,
0x0000100057207811ULL, 0x000fe200078e68ffULL, 0x00005e000c0a7625ULL, 0x000fe200078e0005ULL,
0xfffffffc160f7812ULL, 0x100fe400078ee217ULL, 0xfffffffc24157812ULL, 0x100fe200078ee217ULL,
0x000000100e197824ULL, 0x100fe200078e0220ULL, 0x00000020141f7211ULL, 0x000fe200078e20ffULL,
0x000000100f1b7824ULL, 0x000fe200078e0220ULL, 0x0000000d211a7210ULL, 0x000fe20007ffe0ffULL,
0x00005e00100c7625ULL, 0x000fe200078e0005ULL, 0xfffffffc26177812ULL, 0x000fc400078ee217ULL,
0x0000002508147210ULL, 0x080fe20007f1e0ffULL, 0x0000001015217824ULL, 0x100fe200078e0220ULL,
0x000000250a167210ULL, 0x080fe20007f3e0ffULL, 0x0000001017237824ULL, 0x000fe400078e0220ULL,
0x000000ffff157224ULL, 0x000fe200000e0609ULL, 0x000000250c0c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe400008e060bULL, 0x00005e0018087625ULL, 0x000fc800078e0005ULL,
0x00005e001a0a7625ULL, 0x000fc800078e0005ULL, 0x00000010111d7824ULL, 0x000fe200078e0220ULL,
0x000000250a0a7210ULL, 0x000fe20007f3e0ffULL, 0x00005e001c0e7625ULL, 0x000fc800078e0005ULL,
0x00005e001e107625ULL, 0x000fe200078e0005ULL, 0x000000250e0e7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000002508087210ULL, 0x080fe20007f1e0ffULL,
0x0000001003277824ULL, 0x100fe200078e0220ULL, 0x0000002510107210ULL, 0x000fe20007f7e0ffULL,
0x0000001000037824ULL, 0x000fe200078e0220ULL, 0x00000009ff097210ULL, 0x000fe200007fe4ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012277faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fe400010e060fULL,
0x000000ffff117224ULL, 0x000fe200018e0611ULL, 0x0000000014037faeULL, 0x0005e8000b901c46ULL,
0x0000000016197faeULL, 0x0005e8000b901c46ULL, 0x000000000c1b7faeULL, 0x0005e8000b901c46ULL,
0x00000000081d7faeULL, 0x0005e8000b901c46ULL, 0x000000000a1f7faeULL, 0x0005e8000b901c46ULL,
0x000000000e217faeULL, 0x0005e8000b901c46ULL, 0x0000000010237faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x004fc40000015200ULL,
0x01360400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x006fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08037210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e09ULL, 0x003d09000300780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400300780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140aULL,
0x0000000300007211ULL, 0x000fc800078110ffULL, 0x0000000aff037210ULL, 0x000fc800007fe4ffULL,
0x0000000200007819ULL, 0x000fc80000001203ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000105057810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01360400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000545900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x000e620000000000ULL, 0x0001368857617811ULL, 0x040fe200078e18ffULL,
0x0000002057077824ULL, 0x000fe200078e00ffULL, 0xffffffff54607810ULL, 0x000fc40007ffe0ffULL,
0x0000010059067824ULL, 0x000fe200078e0204ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000065500720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x0000000159037810ULL, 0x000fe20007ffe0ffULL, 0x0000620002697a24ULL, 0x000fe400078e0206ULL,
0x00000100ff057424ULL, 0x000fe200078e00ffULL, 0x000000540300720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0e7819ULL, 0x002fe20000011608ULL,
0x0000000155037824ULL, 0x000fe200078e0a06ULL, 0x0000000808097211ULL, 0x000fe400078fe8ffULL,
0x000000080e107810ULL, 0x040fe20007ffe0ffULL, 0x000000010e0a7824ULL, 0x000fe200078e0269ULL,
0x00000003086b7812ULL, 0x000fe400078ec0ffULL, 0x000000031000720cULL, 0x000fe20003f46070ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0005ULL, 0x00000069100c7210ULL, 0x000fc40007ffe0ffULL,
0x0ffffffc08007812ULL, 0x000fe200078ec0ffULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0x0000000309137812ULL, 0x000fe200078ec0ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0005ULL,
0x000000030e00720cULL, 0x000fe40003f26070ULL, 0x000000046b097812ULL, 0x000fe400078efcffULL,
0x0000200057167811ULL, 0x000fe400078e68ffULL, 0x00000000130f7212ULL, 0x000fe200078efcffULL,
0x00000010090a7825ULL, 0x000fe200078e000aULL, 0xfffffffc10117812ULL, 0x000fc400078ee213ULL,
0x000000100e107810ULL, 0x040fe20007ffe0ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0216ULL,
0x000000180e127810ULL, 0x040fe20007ffe0ffULL, 0x0000001011117824ULL, 0x000fe200078e0216ULL,
0x000000200e147810ULL, 0x040fe20007ffe0ffULL, 0x00000010090c7825ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000c901c46ULL,
0x000000280e187810ULL, 0x040fe40007ffe0ffULL, 0x000000300e1a7810ULL, 0x040fe20007ffe0ffULL,
0x000000000c117faeULL, 0x0005e2000d101c46ULL, 0x000000380e1c7810ULL, 0x000fe20007ffe0ffULL,
0x00000004181e7824ULL, 0x000fe200078e00ffULL, 0x00000002140e7819ULL, 0x000fe200000006ffULL,
0x000000041a207824ULL, 0x000fe200078e00ffULL, 0x000000031000720cULL, 0x080fe20003f26070ULL,
0x000000041c227824ULL, 0x000fe200078e00ffULL, 0x000000031200720cULL, 0x080fe20003f46070ULL,
0x00000004100a7824ULL, 0x002fe200078e00ffULL, 0x000000031400720cULL, 0x000fc40003f66070ULL,
0x000000031800720cULL, 0x080fe20003f86070ULL, 0x00000004120c7824ULL, 0x004fe200078e00ffULL,
0x000000031a00720cULL, 0x080fe40003fa6070ULL, 0x000000031c00720cULL, 0x000fe40003fc6070ULL,
0xfffffffc0a037812ULL, 0x000fe200078ee213ULL, 0x00000001100a7824ULL, 0x000fe200078e0269ULL,
0xfffffffc0c177812ULL, 0x000fe200078ee213ULL, 0x00000001120c7824ULL, 0x000fe200078e0269ULL,
0xfffffffc0e197812ULL, 0x000fe200078ee213ULL, 0x0000000118107824ULL, 0x100fe200078e0269ULL,
0x00000069140e7210ULL, 0x000fe20007ffe0ffULL, 0x000000011a127824ULL, 0x000fe200078e0269ULL,
0xfffffffc1e1b7812ULL, 0x000fe200078ee213ULL, 0x000000011c147824ULL, 0x000fe200078e0269ULL,
0xfffffffc201d7812ULL, 0x100fe200078ee213ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0005ULL,
0xfffffffc221f7812ULL, 0x000fc600078ee213ULL, 0x00005e000c0c7625ULL, 0x000fc800078e0005ULL,
0x00005e000e0e7625ULL, 0x000fc800078e0005ULL, 0x00005e0010107625ULL, 0x000fc800078e0005ULL,
0x00005e0012127625ULL, 0x000fc800078e0005ULL, 0x00005e0014147625ULL, 0x000fc800078e0005ULL,
0x00000010090a7825ULL, 0x000fc800078e000aULL, 0x00000010090c7825ULL, 0x000fc800078e000cULL,
0x00000010090e7825ULL, 0x000fc800078e000eULL, 0x0000001009107825ULL, 0x000fc800078e0010ULL,
0x0000001009127825ULL, 0x000fc800078e0012ULL, 0x0000001009147825ULL, 0x000fc800078e0014ULL,
0x0000001003037824ULL, 0x100fe400078e0216ULL, 0x0000001017097824ULL, 0x100fe200078e0216ULL,
0x0000001619177211ULL, 0x000fe200078e20ffULL, 0x000000101b197824ULL, 0x100fe200078e0216ULL,
0x000000000a037faeULL, 0x0003e2000c901c46ULL, 0x000000101d1b7824ULL, 0x100fe400078e0216ULL,
0x000000101f1d7824ULL, 0x000fe200078e0216ULL, 0x000000000c097faeULL, 0x0003e8000d101c46ULL,
0x000000000e177faeULL, 0x0003e8000d901c46ULL, 0x0000000010197faeULL, 0x0003e8000e101c46ULL,
0x00000000121b7faeULL, 0x0003e8000e901c46ULL, 0x00000000141d7faeULL, 0x0003e2000f101c46ULL,
0x0000047000007947ULL, 0x000fea0003800000ULL, 0x00000008080e7811ULL, 0x042fe400078ff0ffULL,
0x0000001008107811ULL, 0x000fc400078ff0ffULL, 0x0000001808127811ULL, 0x000fe200078ff0ffULL,
0x000000010e0c7824ULL, 0x100fe200078e0269ULL, 0x0000002008147811ULL, 0x000fe200078ff0ffULL,
0x000000040e1e7824ULL, 0x000fe200078e00ffULL, 0x0000002808167811ULL, 0x000fe200078ff0ffULL,
0x0000000410207824ULL, 0x000fe200078e00ffULL, 0x0000003008187811ULL, 0x000fe200078ff0ffULL,
0x0000000412227824ULL, 0x000fe200078e00ffULL, 0x00000038081c7811ULL, 0x000fe200078ff0ffULL,
0x0000000414247824ULL, 0x000fe200078e00ffULL, 0x00000069100e7210ULL, 0x080fe20007ffe0ffULL,
0x0000000112107824ULL, 0x100fe200078e0269ULL, 0x0000000808037211ULL, 0x000fe200078fe8ffULL,
0x0000000114127824ULL, 0x100fe200078e0269ULL, 0x0000006916147210ULL, 0x0c0fe20007ffe0ffULL,
0x0000000416267824ULL, 0x000fe200078e00ffULL, 0x00000069080a7211ULL, 0x000fe200078ff0ffULL,
0x0000000118167824ULL, 0x100fe200078e0269ULL, 0x00000003086b7812ULL, 0x000fe200078ec0ffULL,
0x0000000418287824ULL, 0x000fe200078e00ffULL, 0x0000000303097812ULL, 0x000fe200078ec0ffULL,
0x000000011c187824ULL, 0x000fe200078e0269ULL, 0x0ffffffc08007812ULL, 0x000fe200078ec0ffULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0x000000046b037812ULL, 0x000fe200078efcffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0005ULL, 0xfffffffc1e1b7812ULL, 0x000fc400078ee209ULL,
0xfffffffc201d7812ULL, 0x100fe200078ee209ULL, 0x00005e000c0c7625ULL, 0x080fe200078e0005ULL,
0xfffffffc221f7812ULL, 0x100fe400078ee209ULL, 0xfffffffc24217812ULL, 0x100fe200078ee209ULL,
0x00005e000e0e7625ULL, 0x080fe200078e0005ULL, 0xfffffffc26237812ULL, 0x100fe400078ee209ULL,
0xfffffffc28277812ULL, 0x100fe200078ee209ULL, 0x00005e0010107625ULL, 0x000fe200078e0005ULL,
0xfffffffc1c297812ULL, 0x000fc400078ee209ULL, 0x00002000571a7811ULL, 0x000fe200078e68ffULL,
0x00005e0012127625ULL, 0x000fe200078e0005ULL, 0x0000000009097212ULL, 0x000fc600078efcffULL,
0x00005e0014147625ULL, 0x000fe200078e0005ULL, 0x0000001a09257211ULL, 0x000fc600078e20ffULL,
0x00005e0016167625ULL, 0x000fc800078e0005ULL, 0x00005e0018187625ULL, 0x000fc800078e0005ULL,
0x00000010030a7825ULL, 0x000fc800078e000aULL, 0x00000010030c7825ULL, 0x040fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a257faeULL, 0x0003e6000b901c46ULL,
0x00000010030e7825ULL, 0x000fc800078e000eULL, 0x0000001003107825ULL, 0x000fc800078e0010ULL,
0x0000001003127825ULL, 0x000fc800078e0012ULL, 0x0000001003147825ULL, 0x000fc800078e0014ULL,
0x0000001003167825ULL, 0x000fc800078e0016ULL, 0x0000001003187825ULL, 0x000fc800078e0018ULL,
0x000000101b037824ULL, 0x100fe400078e021aULL, 0x000000101d097824ULL, 0x100fe400078e021aULL,
0x000000101f1b7824ULL, 0x100fe200078e021aULL, 0x000000000c037faeULL, 0x0003e2000b901c46ULL,
0x00000010211d7824ULL, 0x100fe200078e021aULL, 0x0000001a27217211ULL, 0x000fe200078e20ffULL,
0x00000010231f7824ULL, 0x100fe200078e021aULL, 0x000000000e097faeULL, 0x0003e2000b901c46ULL,
0x0000001029237824ULL, 0x000fc600078e021aULL, 0x00000000101b7faeULL, 0x0003e8000b901c46ULL,
0x00000000121d7faeULL, 0x0003e8000b901c46ULL, 0x00000000141f7faeULL, 0x0003e8000b901c46ULL,
0x0000000016217faeULL, 0x0003e8000b901c46ULL, 0x0000000018237faeULL, 0x0003e4000b901c46ULL,
0x00000004ff0c7819ULL, 0x102fe20000011608ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000708037812ULL, 0x000fe200078ec0ffULL, 0x00002000576c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff437819ULL, 0x000fe20000011608ULL, 0x000000080c0a7824ULL, 0x000fc600078e00ffULL,
0x000010006c5e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a0b7812ULL, 0x000fe400078ee203ULL,
0x0000000803037812ULL, 0x000fe400078ef808ULL, 0x000000100b0d7810ULL, 0x040fe20007ffe0ffULL,
0x000000040b5b7824ULL, 0x040fe200078e00ffULL, 0x000000200b0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010c5f7824ULL, 0x000fe200078e0203ULL, 0x00000001430a7812ULL, 0x000fe200078ec0ffULL,
0x00000010030c7824ULL, 0x000fe200078e00ffULL, 0x000000300b117810ULL, 0x040fe20007ffe0ffULL,
0x000000040b157824ULL, 0x000fe200078e00ffULL, 0x0000000a0f0e7211ULL, 0x080fe200078ff8ffULL,
0x000000040d107824ULL, 0x000fe200078e00ffULL, 0xfffffff00c097812ULL, 0x000fe200078ee25fULL,
0x000000040f3f7824ULL, 0x000fe200078e00ffULL, 0x0000000a0b0c7211ULL, 0x000fe200078ff8ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000a0d0b7211ULL, 0x080fe200078ff8ffULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0x0000000a110a7211ULL, 0x040fe200078ff8ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000002113d7819ULL, 0x000fe200000006ffULL,
0x000000040d127824ULL, 0x000fe200078e00ffULL, 0xfffffffc5b5b7812ULL, 0x000fe200078ee20cULL,
0x000000000928783bULL, 0x0003e20000000200ULL, 0xfffffffc10417812ULL, 0x000fe400078ee20bULL,
0xfffffffc3f3f7812ULL, 0x000fe200078ee20eULL, 0x000000105b6a7824ULL, 0x000fe200078e025eULL,
0xfffffffc3d3d7812ULL, 0x000fe200078ee20aULL, 0x0000001041687824ULL, 0x100fe200078e025eULL,
0x000000020c0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000103f677824ULL, 0x100fe200078e025eULL,
0x000000006a34783bULL, 0x000ea20000000200ULL, 0x000000103d667824ULL, 0x000fe200078e025eULL,
0x000000020b717810ULL, 0x000fc40007ffe0ffULL, 0x000000006830783bULL, 0x000ee20000000200ULL,
0xfffffffc150b7812ULL, 0x000fe400078ee20cULL, 0x0000000403137819ULL, 0x000fe200000006ffULL,
0x00000000672c783bULL, 0x000f220000000200ULL, 0x000000025f107810ULL, 0x000fe20007ffe0ffULL,
0x000000100b657824ULL, 0x000fe200078e025eULL, 0x000000020f0c7819ULL, 0x000fe200000006ffULL,
0x000000006638783bULL, 0x000f220000000200ULL, 0x000000020e097810ULL, 0x002fe20007ffe0ffULL,
0x00000004110e7824ULL, 0x000fe200078e00ffULL, 0x000000020a6f7810ULL, 0x000fe20007ffe0ffULL,
0x00000000654c783bULL, 0x000fe20000000200ULL, 0xfffffff013107812ULL, 0x000fc400078ee210ULL,
0xfffffffc12717812ULL, 0x000fe400078ee271ULL, 0xfffffffc0c097812ULL, 0x000fe200078ee209ULL,
0x0000001010107824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e6f7812ULL, 0x000fe200078ee26fULL,
0x0000001071647824ULL, 0x100fe400078e025eULL, 0x0000001009637824ULL, 0x000fe200078e025eULL,
0x0000005e6f627211ULL, 0x000fe200078e20ffULL, 0x00000000101c783bULL, 0x0008680000000200ULL,
0x00000000640c783bULL, 0x000e680000000200ULL, 0x000000006314783bULL, 0x000e680000000200ULL,
0x000000006224783bULL, 0x000e620000000200ULL, 0x000000342820723cULL, 0x044f7000000418ffULL,
0x000000302848723cULL, 0x048f7000000418ffULL, 0x0000002c2810723cULL, 0x050f7000000418ffULL,
0x000000362834723cULL, 0x040f7000000418ffULL, 0x000000322830723cULL, 0x040f7000000418ffULL,
0x0000002e282c723cULL, 0x040f7000000418ffULL, 0x000000382818723cULL, 0x040f7000000418ffULL,
0x0000003a2828723cULL, 0x000f7000000418ffULL, 0x0000004c1c20723cULL, 0x062b700000041820ULL,
0x0000000c1c48723cULL, 0x040b700000041848ULL, 0x000000141c10723cULL, 0x040b700000041810ULL,
0x0000004e1c4c723cULL, 0x040b700000041834ULL, 0x0000000e1c0c723cULL, 0x040b700000041830ULL,
0x000000161c14723cULL, 0x040b70000004182cULL, 0x000000241c18723cULL, 0x040b700000041818ULL,
0x000000261c1c723cULL, 0x000b620000041828ULL, 0x000004f000008947ULL, 0x000fce0003800000ULL,
0x00000002ff287819ULL, 0x120fe20000011608ULL, 0x0000000143437824ULL, 0x000fe200078e0208ULL,
0x000000086b317812ULL, 0x000fe200078efcffULL, 0x00000001550a7824ULL, 0x000fe200078e0a06ULL,
0x0000000828267810ULL, 0x040fe20007ffe0ffULL, 0x0000000128247824ULL, 0x000fe200078e0269ULL,
0x00000003435d7812ULL, 0x000fc400078ec0ffULL, 0x0000000a2800720cULL, 0x080fe20003f26070ULL,
0x00000001262a7824ULL, 0x040fe200078e0269ULL, 0x0000000a2600720cULL, 0x040fe20003f46070ULL,
0x00000004262c7824ULL, 0x000fe200078e00ffULL, 0x000000005d6d7212ULL, 0x000fe200078efcffULL,
0x00005e0024247625ULL, 0x080fe200078e0005ULL, 0x0000001028007810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc2c297812ULL, 0x000fe200078ee25dULL, 0x00005e002a267625ULL, 0x000fe200078e0005ULL,
0x0000005e6d5c7211ULL, 0x000fc400078e20ffULL, 0x0000001828307810ULL, 0x040fe20007ffe0ffULL,
0x0000001031247825ULL, 0x000fe200078e0024ULL, 0x0000002028327810ULL, 0x040fe40007ffe0ffULL,
0x0000002828347810ULL, 0x040fe20007ffe0ffULL, 0x0000001029297824ULL, 0x000fe200078e025eULL,
0x0000003028357810ULL, 0x040fe20007ffe0ffULL, 0x0000001031267825ULL, 0x000fe200078e0026ULL,
0x0000003828367810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245c7faeULL, 0x0003e2000c901c46ULL, 0x00000069342c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000130287824ULL, 0x100fe200078e0269ULL, 0x0000000a0000720cULL, 0x080fe20003f26070ULL,
0x0000000026297faeULL, 0x0005e2000d101c46ULL, 0x00000001322e7824ULL, 0x100fe200078e0269ULL,
0x0000000a3000720cULL, 0x080fe20003f46070ULL, 0x00000001352a7824ULL, 0x000fe200078e0269ULL,
0x0000000a3200720cULL, 0x080fe20003f66070ULL, 0x00005e002e2e7625ULL, 0x000fe200078e0005ULL,
0x0000000a3400720cULL, 0x000fc40003f86070ULL, 0x0000000a3600720cULL, 0x080fe20003fc6070ULL,
0x0000000100247824ULL, 0x102fe200078e0269ULL, 0x0000000234347819ULL, 0x000fe200000006ffULL,
0x0000000400007824ULL, 0x000fe200078e00ffULL, 0x0000000a3500720cULL, 0x000fe20003fa6070ULL,
0x0000000136267824ULL, 0x004fe200078e0269ULL, 0xfffffffc34377812ULL, 0x100fe200078ee25dULL,
0x00005e0024247625ULL, 0x000fe200078e0005ULL, 0xfffffffc00337812ULL, 0x000fc600078ee25dULL,
0x00005e0028287625ULL, 0x000fc800078e0005ULL, 0x00005e002c2c7625ULL, 0x000fc800078e0005ULL,
0x00005e002a2a7625ULL, 0x000fc800078e0005ULL, 0x00005e0026267625ULL, 0x000fc800078e0005ULL,
0x0000000430307824ULL, 0x000fe400078e00ffULL, 0x0000000432327824ULL, 0x000fe400078e00ffULL,
0x0000001031247825ULL, 0x000fc800078e0024ULL, 0x0000001031287825ULL, 0x000fc800078e0028ULL,
0x00000010312e7825ULL, 0x000fc800078e002eULL, 0x00000010312c7825ULL, 0x000fc800078e002cULL,
0x00000010312a7825ULL, 0x000fc800078e002aULL, 0x0000001031267825ULL, 0x000fe200078e0026ULL,
0xfffffffc30317812ULL, 0x000fc600078ee25dULL, 0x0000000435007824ULL, 0x000fe200078e00ffULL,
0xfffffffc32357812ULL, 0x100fe200078ee25dULL, 0x0000000436367824ULL, 0x000fe400078e00ffULL,
0x0000001033337824ULL, 0x100fe200078e025eULL, 0xfffffffc00397812ULL, 0x100fe200078ee25dULL,
0x0000001031317824ULL, 0x100fe200078e025eULL, 0xfffffffc363b7812ULL, 0x000fe200078ee25dULL,
0x0000001035357824ULL, 0x100fe200078e025eULL, 0x0000005e39397211ULL, 0x000fe200078e20ffULL,
0x0000001037377824ULL, 0x100fe200078e025eULL, 0x0000000024337faeULL, 0x0003e2000c901c46ULL,
0x000000103b3b7824ULL, 0x000fc600078e025eULL, 0x0000000028317faeULL, 0x0003e8000d101c46ULL,
0x000000002e357faeULL, 0x0003e8000d901c46ULL, 0x000000002c377faeULL, 0x0003e8000e101c46ULL,
0x000000002a397faeULL, 0x0003e8000e901c46ULL, 0x00000000263b7faeULL, 0x0003e2000f101c46ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x0000000143437824ULL, 0x000fe200078e0208ULL,
0x0000000808247811ULL, 0x020fc400078ff0ffULL, 0x0000001008287811ULL, 0x040fe400078ff0ffULL,
0x00000018083a7811ULL, 0x000fe200078ff0ffULL, 0x00000001242c7824ULL, 0x100fe200078e0269ULL,
0x0000002008387811ULL, 0x000fe200078ff0ffULL, 0x00000004243c7824ULL, 0x000fe200078e00ffULL,
0x00000028080a7811ULL, 0x000fe200078ff0ffULL, 0x00000001282a7824ULL, 0x100fe200078e0269ULL,
0x0000003008367811ULL, 0x000fe200078ff0ffULL, 0x000000013a247824ULL, 0x100fe200078e0269ULL,
0x0000003808347811ULL, 0x000fe200078ff0ffULL, 0x0000000138327824ULL, 0x100fe200078e0269ULL,
0x0000006908267211ULL, 0x000fe200078ff0ffULL, 0x000000010a307824ULL, 0x100fe200078e0269ULL,
0x00000003435d7812ULL, 0x000fe200078ec0ffULL, 0x00000001362e7824ULL, 0x100fe200078e0269ULL,
0x00000002283e7819ULL, 0x000fe200000006ffULL, 0x0000000134287824ULL, 0x000fe200078e0269ULL,
0x000000086b397812ULL, 0x000fe200078efcffULL, 0x00005e0026267625ULL, 0x000fe200078e0005ULL,
0x000000005d6d7212ULL, 0x000fc400078efcffULL, 0xfffffffc3c357812ULL, 0x100fe200078ee25dULL,
0x00005e002c2c7625ULL, 0x080fe200078e0005ULL, 0xfffffffc3e377812ULL, 0x000fe400078ee25dULL,
0x0000005e35357211ULL, 0x000fe200078e20ffULL, 0x00005e002a2a7625ULL, 0x000fe200078e0005ULL,
0x0000000236367819ULL, 0x000fc600000006ffULL, 0x00005e0024247625ULL, 0x000fc800078e0005ULL,
0x00005e0032327625ULL, 0x000fc800078e0005ULL, 0x00005e0030307625ULL, 0x000fc800078e0005ULL,
0x00005e002e2e7625ULL, 0x000fc800078e0005ULL, 0x00005e0028287625ULL, 0x000fc800078e0005ULL,
0x000000043a3a7824ULL, 0x000fe400078e00ffULL, 0x0000000438387824ULL, 0x000fe400078e00ffULL,
0x0000001039267825ULL, 0x000fc600078e0026ULL, 0xfffffffc383b7812ULL, 0x000fe200078ee25dULL,
0x000000106d5c7824ULL, 0x000fe400078e025eULL, 0x000000040a0a7824ULL, 0x000fe400078e00ffULL,
0x00000010392c7825ULL, 0x040fe200078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000265c7faeULL, 0x0003e4000b901c46ULL, 0xfffffffc0a437812ULL, 0x000fe200078ee25dULL,
0x00000010392a7825ULL, 0x040fe200078e002aULL, 0x000000002c357faeULL, 0x0005e6000b901c46ULL,
0x0000001039247825ULL, 0x000fc800078e0024ULL, 0x0000001039327825ULL, 0x000fe200078e0032ULL,
0xfffffffc36277812ULL, 0x002fc600078ee25dULL, 0x0000001039307825ULL, 0x000fc800078e0030ULL,
0x00000010392e7825ULL, 0x000fc800078e002eULL, 0x0000001039287825ULL, 0x000fe200078e0028ULL,
0xfffffffc3a397812ULL, 0x000fc600078ee25dULL, 0x0000000434347824ULL, 0x000fe400078e00ffULL,
0x0000001037377824ULL, 0x100fe400078e025eULL, 0x0000001039397824ULL, 0x100fe200078e025eULL,
0xfffffffc342d7812ULL, 0x004fe200078ee25dULL, 0x000000103b3b7824ULL, 0x100fe200078e025eULL,
0x000000002a377faeULL, 0x0003e2000b901c46ULL, 0x0000001043437824ULL, 0x100fe200078e025eULL,
0x0000005e2d2d7211ULL, 0x000fe200078e20ffULL, 0x0000001027277824ULL, 0x000fe200078e025eULL,
0x0000000024397faeULL, 0x0003e8000b901c46ULL, 0x00000000323b7faeULL, 0x0003e8000b901c46ULL,
0x0000000030437faeULL, 0x0003e8000b901c46ULL, 0x000000002e277faeULL, 0x0003e8000b901c46ULL,
0x00000000282d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001003257824ULL, 0x002fe200078e00ffULL, 0x000000045f007810ULL, 0x000fc40007ffe0ffULL,
0x000020006c6c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff025007812ULL, 0x000fe400078ee200ULL,
0x0000006c3d567211ULL, 0x000fe200078e20ffULL, 0x000000105b5b7824ULL, 0x100fe200078e026cULL,
0x000000065f0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001000007824ULL, 0x000fe400078e00ffULL,
0x00000010415a7824ULL, 0x000fe200078e026cULL, 0xfffffff0250a7812ULL, 0x000fe200078ee20aULL,
0x000000103f587824ULL, 0x000fc400078e026cULL, 0x000000100b0b7824ULL, 0x100fe400078e026cULL,
0x000000100a247824ULL, 0x000fe400078e00ffULL, 0x00000010710a7824ULL, 0x100fe400078e026cULL,
0x0000001009097824ULL, 0x000fe200078e026cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000005b50783bULL, 0x000fe80000000200ULL, 0x000000000038783bULL, 0x0002a80000000200ULL,
0x000000005a44783bULL, 0x000ee80000000200ULL, 0x000000005840783bULL, 0x000f220000000200ULL,
0x000000106f007824ULL, 0x002fc600078e026cULL, 0x00000000563c783bULL, 0x000e680000000200ULL,
0x000000000b34783bULL, 0x000fe80000000200ULL, 0x000000002424783bULL, 0x000e680000000200ULL,
0x000000000a30783bULL, 0x000e680000000200ULL, 0x00000000092c783bULL, 0x000e680000000200ULL,
0x000000000028783bULL, 0x000e620000000200ULL, 0x000000503820723cULL, 0x044f700000041820ULL,
0x00000052384c723cULL, 0x040f70000004184cULL, 0x000000443848723cULL, 0x048f700000041848ULL,
0x00000046380c723cULL, 0x040f70000004180cULL, 0x000000403810723cULL, 0x050f700000041810ULL,
0x000000423814723cULL, 0x040f700000041814ULL, 0x0000003c3818723cULL, 0x042f700000041818ULL,
0x0000003e381c723cULL, 0x000f70000004181cULL, 0x000000342420723cULL, 0x060b700000041820ULL,
0x00000036244c723cULL, 0x040b70000004184cULL, 0x000000302448723cULL, 0x040b700000041848ULL,
0x00000032240c723cULL, 0x040b70000004180cULL, 0x0000002c2410723cULL, 0x040b700000041810ULL,
0x0000002e2414723cULL, 0x040b700000041814ULL, 0x000000282418723cULL, 0x040b700000041818ULL,
0x0000002a2424723cULL, 0x000b62000004181cULL, 0x000004c000008947ULL, 0x000fce0003800000ULL,
0x00000002ff1f7819ULL, 0x020fe20000011608ULL, 0x000000106d6d7824ULL, 0x000fe200078e026cULL,
0x80000006551e7210ULL, 0x000fc40007ffe0ffULL, 0x0000000c6b6b7812ULL, 0x000fe200078efcffULL,
0x000000011f1c7824ULL, 0x040fe200078e0269ULL, 0x0000001e1f00720cULL, 0x040fe40003f06070ULL,
0x000000081f287810ULL, 0x040fe20007ffe0ffULL, 0x00005e001c1c7625ULL, 0x000fe200078e0005ULL,
0x000000101f297810ULL, 0x040fe40007ffe0ffULL, 0x000000181f2b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000428327824ULL, 0x000fe200078e00ffULL, 0x000000201f2c7810ULL, 0x000fe20007ffe0ffULL,
0x000000106b1c7825ULL, 0x000fe200078e001cULL, 0x000000281f2d7810ULL, 0x000fc40007ffe0ffULL,
0x000000301f2f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001292a7824ULL, 0x100fe200078e0269ULL,
0x000000381f1f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c6d7faeULL, 0x0003e2000c101c46ULL, 0x0000001e2800720cULL, 0x080fe20003f06070ULL,
0x000000012b2e7824ULL, 0x100fe200078e0269ULL, 0x0000001e2900720cULL, 0x080fe20003f26070ULL,
0x000000042b367824ULL, 0x040fe200078e00ffULL, 0x0000001e2b00720cULL, 0x080fe20003f46070ULL,
0x000000012c307824ULL, 0x140fe200078e0269ULL, 0x0000001e2c00720cULL, 0x0c0fe20003f66070ULL,
0x000000042c387824ULL, 0x000fe200078e00ffULL, 0x0000001e2d00720cULL, 0x080fe20003f86070ULL,
0x000000041f3e7824ULL, 0x000fe200078e00ffULL, 0x0000001e2f00720cULL, 0x080fe20003fa6070ULL,
0x000000011f1c7824ULL, 0x142fe200078e0269ULL, 0x0000001e1f00720cULL, 0x000fe20003fc6070ULL,
0x00000001281e7824ULL, 0x100fe200078e0269ULL, 0x0000000229347819ULL, 0x000fe200000006ffULL,
0x000000012d2c7824ULL, 0x040fe200078e0269ULL, 0x000000022d3a7819ULL, 0x000fe200000006ffULL,
0x00005e001e1e7625ULL, 0x000fe200078e0005ULL, 0xfffffffc32337812ULL, 0x000fc400078ee25dULL,
0xfffffffc34357812ULL, 0x000fe200078ee25dULL, 0x000000012f287824ULL, 0x040fe200078e0269ULL,
0xfffffffc36377812ULL, 0x100fe200078ee25dULL, 0x000000042f3c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc38397812ULL, 0x100fe200078ee25dULL, 0x00005e002a2a7625ULL, 0x080fe200078e0005ULL,
0xfffffffc3a3b7812ULL, 0x100fe400078ee25dULL, 0xfffffffc3c3d7812ULL, 0x100fe200078ee25dULL,
0x00005e002e2e7625ULL, 0x000fe200078e0005ULL, 0xfffffffc3e3f7812ULL, 0x000fc400078ee25dULL,
0x0000006c35357211ULL, 0x000fe200078e20ffULL, 0x00005e0030307625ULL, 0x000fc800078e0005ULL,
0x00005e002c2c7625ULL, 0x000fc800078e0005ULL, 0x00005e0028287625ULL, 0x000fc800078e0005ULL,
0x0000001033337824ULL, 0x000fe400078e026cULL, 0x00005e001c1c7625ULL, 0x000fc800078e0005ULL,
0x000000106b1e7825ULL, 0x000fc800078e001eULL, 0x000000106b2a7825ULL, 0x000fe200078e002aULL,
0x000000001e337faeULL, 0x0003e6000c101c46ULL, 0x0000001037377824ULL, 0x000fe200078e026cULL,
0x000000002a357faeULL, 0x0003e2000c901c46ULL, 0x000000106b2e7825ULL, 0x000fc800078e002eULL,
0x0000001039397824ULL, 0x000fe200078e026cULL, 0x000000002e377faeULL, 0x0003e2000d101c46ULL,
0x000000106b307825ULL, 0x000fc800078e0030ULL, 0x000000103b3b7824ULL, 0x000fe200078e026cULL,
0x0000000030397faeULL, 0x0003e2000d901c46ULL, 0x000000106b2c7825ULL, 0x000fc800078e002cULL,
0x000000103d3d7824ULL, 0x000fe200078e026cULL, 0x000000002c3b7faeULL, 0x0003e2000e101c46ULL,
0x000000106b287825ULL, 0x000fc800078e0028ULL, 0x000000103f3f7824ULL, 0x000fe200078e026cULL,
0x00000000283d7faeULL, 0x0003e2000e901c46ULL, 0x000000106b1c7825ULL, 0x000fca00078e001cULL,
0x000000001c3f7faeULL, 0x0003e2000f101c46ULL, 0x0000041000007947ULL, 0x000fea0003800000ULL,
0x00000069081c7211ULL, 0x060fe400078ff0ffULL, 0x0000000c6b6b7812ULL, 0x000fe400078efcffULL,
0x00000008081e7811ULL, 0x000fe200078ff0ffULL, 0x00005e001c1c7625ULL, 0x000fe200078e0005ULL,
0x00000010082a7811ULL, 0x040fe400078ff0ffULL, 0x00000018082e7811ULL, 0x000fe200078ff0ffULL,
0x000000011e287824ULL, 0x000fe200078e0269ULL, 0x0000006c6d6d7211ULL, 0x000fe200078e20ffULL,
0x000000106b1c7825ULL, 0x000fe200078e001cULL, 0x0000002008327811ULL, 0x000fc400078ff0ffULL,
0x0000002808347811ULL, 0x000fe200078ff0ffULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x0000003008367811ULL, 0x000fe200078ff0ffULL, 0x000000012a2c7824ULL, 0x100fe200078e0269ULL,
0x0000003808387811ULL, 0x000fe200078ff0ffULL, 0x000000042a2a7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c6d7faeULL, 0x0003e2000b901c46ULL,
0x000000012e307824ULL, 0x040fe200078e0269ULL, 0x000000022e2e7819ULL, 0x000fe200000006ffULL,
0x00000004323a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1e337812ULL, 0x100fe200078ee25dULL,
0x00000004343c7824ULL, 0x000fe200078e00ffULL, 0x00000002363e7819ULL, 0x000fe200000006ffULL,
0x00005e00281e7625ULL, 0x000fe200078e0005ULL, 0xfffffffc2a357812ULL, 0x000fc400078ee25dULL,
0xfffffffc2e377812ULL, 0x100fe200078ee25dULL, 0x00005e002c2a7625ULL, 0x000fe200078e0005ULL,
0xfffffffc3a397812ULL, 0x100fe400078ee25dULL, 0xfffffffc3c3b7812ULL, 0x000fe200078ee25dULL,
0x00000001321c7824ULL, 0x002fe200078e0269ULL, 0xfffffffc3e3d7812ULL, 0x000fe200078ee25dULL,
0x0000000134327824ULL, 0x100fe200078e0269ULL, 0x0000006c39397211ULL, 0x000fe200078e20ffULL,
0x0000000136347824ULL, 0x100fe400078e0269ULL, 0x0000000138367824ULL, 0x000fc400078e0269ULL,
0x0000000438387824ULL, 0x000fe400078e00ffULL, 0x00005e00302e7625ULL, 0x000fc600078e0005ULL,
0xfffffffc383f7812ULL, 0x000fe200078ee25dULL, 0x00005e001c307625ULL, 0x000fc800078e0005ULL,
0x00005e00322c7625ULL, 0x000fc800078e0005ULL, 0x00005e0034287625ULL, 0x000fc800078e0005ULL,
0x0000001033337824ULL, 0x000fe400078e026cULL, 0x00005e00361c7625ULL, 0x000fc800078e0005ULL,
0x000000106b1e7825ULL, 0x000fc800078e001eULL, 0x0000001035357824ULL, 0x000fe200078e026cULL,
0x000000001e337faeULL, 0x0003e2000b901c46ULL, 0x000000106b2a7825ULL, 0x000fc800078e002aULL,
0x0000001037377824ULL, 0x000fe200078e026cULL, 0x000000002a357faeULL, 0x0003e2000b901c46ULL,
0x000000106b2e7825ULL, 0x000fc800078e002eULL, 0x000000106b307825ULL, 0x000fe200078e0030ULL,
0x000000002e377faeULL, 0x0003e6000b901c46ULL, 0x000000103b3b7824ULL, 0x000fe200078e026cULL,
0x0000000030397faeULL, 0x0003e2000b901c46ULL, 0x000000106b2c7825ULL, 0x000fc800078e002cULL,
0x000000103d3d7824ULL, 0x000fe200078e026cULL, 0x000000002c3b7faeULL, 0x0003e2000b901c46ULL,
0x000000106b287825ULL, 0x000fc800078e0028ULL, 0x000000103f3f7824ULL, 0x000fe200078e026cULL,
0x00000000283d7faeULL, 0x0003e2000b901c46ULL, 0x000000106b1c7825ULL, 0x000fca00078e001cULL,
0x000000001c3f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000010031d7824ULL, 0x002fe200078e00ffULL, 0x000000085f1c7810ULL, 0x040fe40007ffe0ffULL,
0x0000000a5f287810ULL, 0x000fe40007ffe0ffULL, 0xfffffff01d1c7812ULL, 0x000fe400078ee21cULL,
0x0000000403297819ULL, 0x000fc600000006ffULL, 0x000000101c3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff029287812ULL, 0x000fca00078ee228ULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006a1c783bULL, 0x000fe80000000200ULL,
0x000000003c3c783bULL, 0x000e680000000200ULL, 0x000000006850783bULL, 0x000ea80000000200ULL,
0x000000006744783bULL, 0x000ee80000000200ULL, 0x000000006640783bULL, 0x000f280000000200ULL,
0x000000006538783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000ee80000000200ULL,
0x000000006434783bULL, 0x000ee80000000200ULL, 0x000000006330783bULL, 0x000ee80000000200ULL,
0x00000000622c783bULL, 0x000ee20000000200ULL, 0x0000001c3c20723cULL, 0x042f700000041820ULL,
0x0000001e3c4c723cULL, 0x040f70000004184cULL, 0x000000503c48723cULL, 0x044b6e0000041848ULL,
0x0000030059517a10ULL, 0x020fe20007ffe0ffULL, 0x000000523c0c723cULL, 0x000f66000004180cULL,
0x00000001511d7810ULL, 0x040fe20007ffe0ffULL, 0x00000100511f7824ULL, 0x000fc600078e0204ULL,
0x000000541d00720cULL, 0x000fe20003f06070ULL, 0x000000443c10723cULL, 0x048f700000041810ULL,
0x000000463c14723cULL, 0x040f700000041814ULL, 0x000000403c18723cULL, 0x050f700000041818ULL,
0x000000423c24723cULL, 0x000f700000041824ULL, 0x000000382820723cULL, 0x040f700000041820ULL,
0x0000003a284c723cULL, 0x040f70000004184cULL, 0x000000342848723cULL, 0x040f700000041848ULL,
0x00000036280c723cULL, 0x060f70000004180cULL, 0x000000302810723cULL, 0x040b6e0000041810ULL,
0x0000620002317a24ULL, 0x020fe200078e021fULL, 0x000000322814723cULL, 0x040b700000041814ULL,
0x0000002c2818723cULL, 0x040b700000041818ULL, 0x0000002e2824723cULL, 0x000b620000041824ULL,
0x0000055000008947ULL, 0x000fce0003800000ULL, 0x00000002ff337819ULL, 0x020fe20000011608ULL,
0x0000001008307824ULL, 0x000fe200078e00ffULL, 0x0000001f551e7217ULL, 0x000fc40007800000ULL,
0x00000008332e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001331c7824ULL, 0x100fe200078e0231ULL,
0x0000003030307812ULL, 0x000fe400078ec0ffULL, 0x0000001e1f327210ULL, 0x000fe20007ffe1ffULL,
0x00005e001c1c7625ULL, 0x080fe200078e0005ULL, 0x0000001033347810ULL, 0x040fe40007ffe0ffULL,
0x0000001833367810ULL, 0x040fe20007ffe0ffULL, 0x000000012e287824ULL, 0x100fe200078e0231ULL,
0x000000301c1e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001341c7824ULL, 0x000fe200078e0231ULL,
0x0000002033377810ULL, 0x000fe20007ffe0ffULL, 0x00005e0028287625ULL, 0x000fe200078e0005ULL,
0x000000322e00720cULL, 0x000fc40003f26070ULL, 0x000000022e2e7819ULL, 0x000fe200000006ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e061dULL, 0x00000030282c7210ULL, 0x000fe20007f1e0ffULL,
0x00005e001c1c7625ULL, 0x080fe200078e0005ULL, 0x0000002833387810ULL, 0x040fe40007ffe0ffULL,
0xfffffffc2e2f7812ULL, 0x000fe200078ee25dULL, 0x000000ffff2d7224ULL, 0x000fe200000e0629ULL,
0x000000323300720cULL, 0x000fe20003f06070ULL, 0x0000000136287824ULL, 0x100fe200078e0231ULL,
0x000000301c1c7210ULL, 0x000fe20007f5e0ffULL, 0x00000001372a7824ULL, 0x100fe200078e0231ULL,
0x0000003033397810ULL, 0x040fe20007ffe0ffULL, 0x00000001382e7824ULL, 0x000fe200078e0231ULL,
0x0000003833337810ULL, 0x000fe20007ffe0ffULL, 0x00005e0028287625ULL, 0x000fe200078e0005ULL,
0x000000323400720cULL, 0x000fc40003fa6070ULL, 0x000000323600720cULL, 0x080fe20003f86070ULL,
0x00005e002a2a7625ULL, 0x080fe200078e0005ULL, 0x00000002393a7819ULL, 0x000fe200000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e5c7faeULL, 0x0003e2000c101c46ULL,
0x000000323300720cULL, 0x000fe20003f06070ULL, 0x000000102f357824ULL, 0x000fe200078e025eULL,
0x000000302a2a7210ULL, 0x000fe20007f7e0ffULL, 0x00005e002e2e7625ULL, 0x000fc600078e0005ULL,
0x000000002c357faeULL, 0x0005e2000c901c46ULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x0000003028287210ULL, 0x080fe20007f5e0ffULL, 0x0000000434347824ULL, 0x000fe200078e00ffULL,
0x000000302e2e7210ULL, 0x000fe20007fde0ffULL, 0x00000001391e7824ULL, 0x042fe200078e0231ULL,
0x000000323900720cULL, 0x080fe20003f26070ULL, 0x000000ffff297224ULL, 0x000fe200010e0629ULL,
0x000000323800720cULL, 0x000fe20003f46070ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0005ULL,
0x0000002fff2f7210ULL, 0x000fc400037fe4ffULL, 0xfffffffc3a397812ULL, 0x000fe200078ee25dULL,
0x000000ffff2b7224ULL, 0x000fe200018e062bULL, 0x000000323700720cULL, 0x000fe20003f66070ULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0x000000301e1e7210ULL, 0x000fe20007fde0ffULL,
0x00000001332c7824ULL, 0x004fe200078e0231ULL, 0xfffffffc34317812ULL, 0x100fe200078ee25dULL,
0x0000000437327824ULL, 0x000fe400078e00ffULL, 0x0000000438387824ULL, 0x000fe400078e00ffULL,
0x00000004333c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc36337812ULL, 0x100fe200078ee25dULL,
0x00005e002c2c7625ULL, 0x000fe200078e0005ULL, 0xfffffffc32357812ULL, 0x000fc400078ee25dULL,
0xfffffffc38377812ULL, 0x000fe200078ee25dULL, 0x000000ffff1f7224ULL, 0x000fe200030e061fULL,
0xfffffffc3c5d7812ULL, 0x000fe200078ee25dULL, 0x0000001031057824ULL, 0x100fe200078e025eULL,
0x000000302c307210ULL, 0x000fe20007fde0ffULL, 0x0000001033337824ULL, 0x100fe200078e025eULL,
0x0000005e35357211ULL, 0x000fe200078e20ffULL, 0x0000001037377824ULL, 0x100fe200078e025eULL,
0x000000001c057faeULL, 0x0003e2000e901c46ULL, 0x0000001039397824ULL, 0x100fe400078e025eULL,
0x000000105d5d7824ULL, 0x000fe200078e025eULL, 0x0000000028337faeULL, 0x0003e2000e101c46ULL,
0x000000ffff317224ULL, 0x000fc600030e062dULL, 0x000000002a357faeULL, 0x0003e8000d901c46ULL,
0x000000002e377faeULL, 0x0003e8000d101c46ULL, 0x000000001e397faeULL, 0x0003e8000c901c46ULL,
0x00000000305d7faeULL, 0x0003e2000c101c46ULL, 0x0000049000007947ULL, 0x000fea0003800000ULL,
0x00000031081c7211ULL, 0x040fe200078ff0ffULL, 0x00000010082d7824ULL, 0x060fe200078e00ffULL,
0x0000000808287811ULL, 0x000fc400078ff0ffULL, 0x00000010082c7811ULL, 0x000fe200078ff0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e0005ULL, 0x000000302d2d7812ULL, 0x000fe400078ec0ffULL,
0x00000031281e7210ULL, 0x040fe20007ffe0ffULL, 0x0000000428387824ULL, 0x000fe200078e00ffULL,
0x00000018082e7811ULL, 0x000fe200078ff0ffULL, 0x000000012c2a7824ULL, 0x000fe200078e0231ULL,
0x0000002008307811ULL, 0x000fe200078ff0ffULL, 0x00005e001e1e7625ULL, 0x000fe200078e0005ULL,
0x0000002808327811ULL, 0x000fc400078ff0ffULL, 0x0000003008347811ULL, 0x000fe200078ff0ffULL,
0x000000042c2c7824ULL, 0x000fe200078e00ffULL, 0x0000002d1c1c7210ULL, 0x000fe20007f1e0ffULL,
0x000000012e287824ULL, 0x000fe200078e0231ULL, 0x0000003808367811ULL, 0x000fe200078ff0ffULL,
0x000000042e3a7824ULL, 0x000fe200078e00ffULL, 0x00000031302e7210ULL, 0x040fe20007ffe0ffULL,
0x00000004303c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc382f7812ULL, 0x000fe200078ee25dULL,
0x0000000132307824ULL, 0x000fe200078e0231ULL, 0xfffffffc3a337812ULL, 0x100fe200078ee25dULL,
0x00000004323e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc3c357812ULL, 0x000fe200078ee25dULL,
0x0000000134327824ULL, 0x000fc400078e0231ULL, 0x0000000434407824ULL, 0x000fe200078e00ffULL,
0x0000003136347210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x0000002d1e1e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e002a2a7625ULL, 0x080fe200078e0005ULL,
0xfffffffc2c317812ULL, 0x100fe400078ee25dULL, 0x0000005e353d7211ULL, 0x000fe200078e20ffULL,
0x00005e0028287625ULL, 0x000fe200078e0005ULL, 0x0000002d2a2a7210ULL, 0x080fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c5c7faeULL, 0x0003e2000b901c46ULL,
0xfffffffc3e3f7812ULL, 0x100fe200078ee25dULL, 0x000000102f377824ULL, 0x100fe200078e025eULL,
0xfffffffc40417812ULL, 0x000fe200078ee25dULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000002d28287210ULL, 0x000fe20007f1e0ffULL, 0x0000001031397824ULL, 0x000fc400078e025eULL,
0x00005e002e2e7625ULL, 0x000fe200078e0005ULL, 0x00000029ff297210ULL, 0x000fe200007fe4ffULL,
0x000000001e377faeULL, 0x0003e4000b901c46ULL, 0x00000010333b7824ULL, 0x000fe200078e025eULL,
0x0000002d2e2c7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0030307625ULL, 0x000fc800078e0005ULL,
0x00005e0032327625ULL, 0x000fc800078e0005ULL, 0x0000000436367824ULL, 0x000fe400078e00ffULL,
0x00005e0034347625ULL, 0x000fc600078e0005ULL, 0xfffffffc365d7812ULL, 0x000fe200078ee25dULL,
0x000000ffff2b7224ULL, 0x000fe200008e062bULL, 0x0000002d302e7210ULL, 0x080fe20007f3e0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e025eULL, 0x0000002d32307210ULL, 0x080fe20007f5e0ffULL,
0x0000001041417824ULL, 0x100fe200078e025eULL, 0x0000002d34327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e062fULL, 0x000000002a397faeULL, 0x0003e2000b901c46ULL,
0x000000ffff2f7224ULL, 0x000fe400008e0631ULL, 0x000000ffff317224ULL, 0x000fe200010e0633ULL,
0x00000000283b7faeULL, 0x0003e2000b901c46ULL, 0x000000105d5d7824ULL, 0x000fc400078e025eULL,
0x000000ffff337224ULL, 0x000fe200018e0635ULL, 0x000000002c3d7faeULL, 0x0003e8000b901c46ULL,
0x000000002e3f7faeULL, 0x0003e8000b901c46ULL, 0x0000000030417faeULL, 0x0003e8000b901c46ULL,
0x00000000325d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000010031c7824ULL, 0x002fe200078e00ffULL, 0x0000000c5f057810ULL, 0x000fe20007ffe0ffULL,
0x0000001003307824ULL, 0x000fe200078e00ffULL, 0x0000000e5f5f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff01c057812ULL, 0x000fe400078ee205ULL, 0xfffffff0305f7812ULL, 0x000fe400078ee25fULL,
0x0000000405057819ULL, 0x000fc600000006ffULL, 0x000000105f387824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000005b1c783bULL, 0x000fe80000000200ULL,
0x000000000528783bULL, 0x000e680000000200ULL, 0x000000005634783bULL, 0x000ea80000000200ULL,
0x000000005a2c783bULL, 0x000ee80000000200ULL, 0x000000005830783bULL, 0x000f280000000200ULL,
0x000000003838783bULL, 0x000fe80000000200ULL, 0x000000000044783bULL, 0x000ee80000000200ULL,
0x000000000b3c783bULL, 0x000ee80000000200ULL, 0x000000000a40783bULL, 0x000f220000000200ULL,
0x0000001c2820723cULL, 0x042ff00000041820ULL, 0x0000001e284c723cULL, 0x040be4000004184cULL,
0x00000000091c783bULL, 0x02026c0000000200ULL, 0x000000342818723cULL, 0x044f700000041818ULL,
0x0000002e280c723cULL, 0x048f70000004180cULL, 0x0000002c2848723cULL, 0x040f700000041848ULL,
0x000000302810723cULL, 0x050ff00000041810ULL, 0x000000322814723cULL, 0x040ff00000041814ULL,
0x000000362824723cULL, 0x000ff00000041824ULL, 0x000000443818723cULL, 0x060ff00000041818ULL,
0x0000003c3820723cULL, 0x040f700000041820ULL, 0x00000042380c723cULL, 0x040f70000004180cULL,
0x0000003e384c723cULL, 0x040f70000004184cULL, 0x000000403848723cULL, 0x000f640000041848ULL,
0x3db504f320037820ULL, 0x020fe20000410000ULL, 0x3db504f321097820ULL, 0x002fe20000410000ULL,
0x3db504f322227820ULL, 0x000fe20000410000ULL, 0x3db504f323237820ULL, 0x000fc60000410000ULL,
0x0000001c3810723cULL, 0x000f620000041810ULL, 0x3db504f30e2b7820ULL, 0x000fe20000410000ULL,
0x3db504f30f2c7820ULL, 0x000fe20000410000ULL, 0x3db504f30c0c7820ULL, 0x000fe20000410000ULL,
0x3db504f30d0d7820ULL, 0x000fc80000410000ULL, 0x0000001e3814723cULL, 0x000b620000041814ULL,
0x3db504f34c4c7820ULL, 0x000fe20000410000ULL, 0x3db504f34d4d7820ULL, 0x000fe20000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe20000410000ULL, 0x3db504f34f4f7820ULL, 0x000fc60000410000ULL,
0x3db504f3181e7820ULL, 0x020fe20000410000ULL, 0x000000463824723cULL, 0x000f620000041824ULL,
0x3db504f3191f7820ULL, 0x000fe20000410000ULL, 0x3db504f31a187820ULL, 0x000fe20000410000ULL,
0x3db504f348487820ULL, 0x000fe20000410000ULL, 0x3db504f349497820ULL, 0x000fe20000410000ULL,
0x3db504f34a297820ULL, 0x000fe20000410000ULL, 0x3db504f34b2a7820ULL, 0x000fe20000410000ULL,
0x3db504f31b197820ULL, 0x000fe20000410000ULL, 0x3db504f310007820ULL, 0x000fe20000410000ULL,
0x3db504f311057820ULL, 0x000fe20000410000ULL, 0x3db504f3120e7820ULL, 0x000fe20000410000ULL,
0x3db504f313287820ULL, 0x000fca0000410000ULL, 0x3db504f3140a7820ULL, 0x000fe20000410000ULL,
0x3db504f3151d7820ULL, 0x000fe20000410000ULL, 0x3db504f316217820ULL, 0x000fe20000410000ULL,
0x3db504f3170f7820ULL, 0x000fca0000410000ULL, 0x3db504f324207820ULL, 0x020fe20000410000ULL,
0x3db504f325257820ULL, 0x000fe20000410000ULL, 0x3db504f3261a7820ULL, 0x000fe20000410000ULL,
0x3db504f3271c7820ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ffff1b7224ULL, 0x000fe200078e000aULL, 0x0000004900137202ULL, 0x000fe20000000f00ULL,
0x00000000610a7f8cULL, 0x0002a2000c80043fULL, 0x000000ffff167224ULL, 0x000fe200078e0000ULL,
0x0000002500007202ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e004cULL,
0x000000ffff117224ULL, 0x000fc400078e004dULL, 0x000000ffff127224ULL, 0x000fe400078e0048ULL,
0x000000ffff147224ULL, 0x000fe400078e000cULL, 0x000000ffff157224ULL, 0x000fe400078e000dULL,
0x000000ffff177224ULL, 0x000fe400078e0005ULL, 0x000000ffff257224ULL, 0x000fe400078e004eULL,
0x000000ffff267224ULL, 0x000fc400078e004fULL, 0x000000ffff277224ULL, 0x000fe400078e000eULL,
0x000000ffff247224ULL, 0x000fc400078e000fULL, 0x00000000000c7805ULL, 0x002fca0000015200ULL,
0x0000040061057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fe4000780480bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c0e7210ULL, 0x000fc80007f1e1ffULL,
0x0000000f0d0f7210ULL, 0x000fe400007fe5ffULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140fULL,
0x0000000e05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x0000000205057819ULL, 0x000fc8000000120eULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012d2d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040061057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004080a7824ULL, 0x000fe200078e00ffULL, 0x000000605900720cULL, 0x000fc80003f05270ULL,
0xfffffff00a0c7812ULL, 0x000fca00078ec0ffULL, 0x0000008057057824ULL, 0x000fca00078e020cULL,
0x01340000050c7984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002080b7824ULL, 0x000fe400078e00ffULL, 0x00000001552f7824ULL, 0x000fc600078e0a06ULL,
0x000000060b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000010b067812ULL, 0x040fe400078efcffULL,
0x000000080b2d7812ULL, 0x040fe400078efcffULL, 0x0000002f0600720cULL, 0x080fe40003f26070ULL,
0x000000100b067812ULL, 0x000fe400078efcffULL, 0x0000002f2d00720cULL, 0x080fe40003f06070ULL,
0x0000002f0600720cULL, 0x000fc40003fc6070ULL, 0x000000110b2d7812ULL, 0x040fe400078efcffULL,
0x000000180b067812ULL, 0x040fe400078efcffULL, 0x0000002f0b00720cULL, 0x080fe40003f46070ULL,
0x0000002f2d00720cULL, 0x080fe40003fa6070ULL, 0x0000002f0600720cULL, 0x000fe40003f66070ULL,
0x000000090b2e7812ULL, 0x000fc400078efcffULL, 0x000000190b2d7812ULL, 0x040fe400078efcffULL,
0x000000200b067812ULL, 0x000fe400078efcffULL, 0xff80000022227808ULL, 0x000fe40005000000ULL,
0xff80000003037808ULL, 0x000fe40005000000ULL, 0xff80000023237808ULL, 0x000fe40004800000ULL,
0xff80000009097808ULL, 0x000fc40004800000ULL, 0x0000002f2e00720cULL, 0x080fe40003f86070ULL,
0x0000002f2d00720cULL, 0x080fe40003f46070ULL, 0x0000002f0600720cULL, 0x000fe40003f26070ULL,
0x000000210b2d7812ULL, 0x040fe400078efcffULL, 0x000000280b067812ULL, 0x000fe400078efcffULL,
0xff80000025257808ULL, 0x000fc40004000000ULL, 0xff80000010107808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000011117808ULL, 0x000fe40006000000ULL,
0x0000002f2d00720cULL, 0x080fe40003f06070ULL, 0x0000002f0600720cULL, 0x000fe40003f86070ULL,
0x000000290b2d7812ULL, 0x000fc400078efcffULL, 0x000000300b067812ULL, 0x000fe400078efcffULL,
0xff80000029297808ULL, 0x000fe40007000000ULL, 0xff80000012127808ULL, 0x000fe40007000000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0xff80000013137808ULL, 0x000fe40006800000ULL,
0x0000002f2d00720cULL, 0x000fc40003fc6070ULL, 0x0000002f0600720cULL, 0x000fe40003fa6070ULL,
0x000000310b2d7812ULL, 0x040fe400078efcffULL, 0x000000380b067812ULL, 0x040fe400078efcffULL,
0x000000390b0b7812ULL, 0x000fe400078efcffULL, 0xff8000002b2b7808ULL, 0x000fe40005800000ULL,
0xff80000014147808ULL, 0x000fc40005800000ULL, 0xff8000002c2c7808ULL, 0x000fe40005000000ULL,
0xff80000015157808ULL, 0x000fe40005000000ULL, 0xff80000027277808ULL, 0x000fe40004800000ULL,
0xff80000016167808ULL, 0x000fe40004800000ULL, 0x0000002f2d00720cULL, 0x080fe40003f66070ULL,
0x0000002f0600720cULL, 0x000fc40003f46070ULL, 0x0000002f0b00720cULL, 0x000fe40003f26070ULL,
0xff80000028287808ULL, 0x000fe40004000000ULL, 0xff80000017177808ULL, 0x000fe40004000000ULL,
0xff80000021217808ULL, 0x000fe40006000000ULL, 0xff8000001b1b7808ULL, 0x000fe40006000000ULL,
0xff80000024247808ULL, 0x000fc40007000000ULL, 0xff8000001d1d7808ULL, 0x000fe40007000000ULL,
0xff80000018187808ULL, 0x000fe40006800000ULL, 0xff8000001e1e7808ULL, 0x000fe40006800000ULL,
0xff80000019197808ULL, 0x000fe40005800000ULL, 0xff8000001f1f7808ULL, 0x000fe40005800000ULL,
0xff8000001a1a7808ULL, 0x000fc40005000000ULL, 0xff80000020207808ULL, 0x000fe40005000000ULL,
0xff8000001c1c7808ULL, 0x000fe40004800000ULL, 0xff80000000007808ULL, 0x000fc40004800000ULL,
0x000000030c00720bULL, 0x004fe20003f1e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x000000220d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c030c7208ULL, 0x000fe40004000000ULL,
0x0000000d22067208ULL, 0x000fc40004800000ULL, 0x000000090c00720bULL, 0x000fe40003f1e000ULL,
0x000000230600720bULL, 0x000fe40003f3e000ULL, 0x0000000c090b7208ULL, 0x000fe40004000000ULL,
0x0000000623067208ULL, 0x000fe40004800000ULL, 0x000000100b00720bULL, 0x000fe40003f1e000ULL,
0x000000250600720bULL, 0x000fc40003f3e000ULL, 0x0000000b100c7208ULL, 0x000fe40004000000ULL,
0x00000006250b7208ULL, 0x000fe40004800000ULL, 0x000000110c00720bULL, 0x000fe40003f1e000ULL,
0x000000260b00720bULL, 0x000fe40003f3e000ULL, 0x0000000c110d7208ULL, 0x000fe40004000000ULL,
0x0000000b26067208ULL, 0x000fc40004800000ULL, 0x000000120d00720bULL, 0x000fe40003f1e000ULL,
0x000000290600720bULL, 0x000fe40003f3e000ULL, 0x0000000d120c7208ULL, 0x000fe40004000000ULL,
0x00000006290b7208ULL, 0x000fe40004800000ULL, 0x000000130c00720bULL, 0x000fe40003f1e000ULL,
0x0000002a0b00720bULL, 0x000fc40003f3e000ULL, 0x0000000c130d7208ULL, 0x000fe40004000000ULL,
0x0000000b2a067208ULL, 0x000fe40004800000ULL, 0x000000140d00720bULL, 0x000fe40003f1e000ULL,
0x0000002b0600720bULL, 0x000fe40003f3e000ULL, 0x0000000d140c7208ULL, 0x000fe40004000000ULL,
0x000000062b0b7208ULL, 0x000fc40004800000ULL, 0x000000150c00720bULL, 0x000fe40003f1e000ULL,
0x0000002c0b00720bULL, 0x000fe40003f3e000ULL, 0x0000000c150d7208ULL, 0x000fe40004000000ULL,
0x0000000b2c067208ULL, 0x000fe40004800000ULL, 0x000000160d00720bULL, 0x000fe40003f1e000ULL,
0x000000270600720bULL, 0x000fc40003f3e000ULL, 0x0000000d160c7208ULL, 0x000fe40004000000ULL,
0x00000006270b7208ULL, 0x000fe40004800000ULL, 0x000000170c00720bULL, 0x000fe40003f1e000ULL,
0x000000280b00720bULL, 0x000fe40003f3e000ULL, 0x0000000c170c7208ULL, 0x000fe40004000000ULL,
0x0000000b28067208ULL, 0x000fc40004800000ULL, 0x0000001b0c00720bULL, 0x000fe40003f1e000ULL,
0x000000210600720bULL, 0x000fe40003f3e000ULL, 0x0000000c1b0c7208ULL, 0x000fe40004000000ULL,
0x00000006210b7208ULL, 0x000fe40004800000ULL, 0x0000001d0c00720bULL, 0x000fe40003f1e000ULL,
0x000000240b00720bULL, 0x000fc40003f3e000ULL, 0x0000000c1d0d7208ULL, 0x000fe40004000000ULL,
0x0000000b240b7208ULL, 0x000fe40004800000ULL, 0x0000001e0d00720bULL, 0x000fe40003f1e000ULL,
0x000000180b00720bULL, 0x000fe40003f3e000ULL, 0x0000000d1e067208ULL, 0x000fe40004000000ULL,
0x0000000b180c7208ULL, 0x000fc40004800000ULL, 0x0000001f0600720bULL, 0x000fe40003f1e000ULL,
0x000000190c00720bULL, 0x000fe40003f3e000ULL, 0x000000061f0b7208ULL, 0x000fe40004000000ULL,
0x0000000c190d7208ULL, 0x000fe40004800000ULL, 0x000000200b00720bULL, 0x000fe40003f1e000ULL,
0x0000001a0d00720bULL, 0x000fc40003f3e000ULL, 0x0000000b200b7208ULL, 0x000fe40004000000ULL,
0x0000000d1a0d7208ULL, 0x000fe40004800000ULL, 0x000000000b00720bULL, 0x000fe40003f1e000ULL,
0x0000001c0d00720bULL, 0x000fe40003f3e000ULL, 0x0000001f00337802ULL, 0x000fe40000000f00ULL,
0x0000000b002d7208ULL, 0x000fc40004000000ULL, 0x0000000d1c317208ULL, 0x000fe20004800000ULL,
0x000015427f007947ULL, 0x000fea000b800000ULL, 0x0c401f002d067f89ULL, 0x0004e400000e0000ULL,
0x000000062d00720bULL, 0x008fc80003f1e000ULL, 0x0000002d06327208ULL, 0x000fe20004000000ULL,
0x000015527f007947ULL, 0x000fea000b800000ULL, 0x0c401f0031067f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e0b7f89ULL, 0x000f2800000e0000ULL, 0x0c401f000f0c7f89ULL, 0x000e6800000e0000ULL,
0x0c201f00320d7f89ULL, 0x000ea200000e0000ULL, 0x000000063100720bULL, 0x008fc40003f1e000ULL,
0x0000000b0e00720bULL, 0x010fe40003f3e000ULL, 0x00000031062d7208ULL, 0x006fe40004000000ULL,
0x0000000e0b2e7208ULL, 0x000fe40004800000ULL, 0x0000000c0f00720bULL, 0x000fe20003f1e000ULL,
0x0c201f002d307f89ULL, 0x000e6600000e0000ULL, 0x0000000f0c067208ULL, 0x000fe20004000000ULL,
0x0c201f002e2f7f89ULL, 0x000ea200000e0000ULL, 0x0000000d3200720bULL, 0x000fc60003f1e000ULL,
0x0c201f00060b7f89ULL, 0x0006e200000e0000ULL, 0x000000320d0c7208ULL, 0x000fe40004000000ULL,
0x000000302d00720bULL, 0x002fe40003f3e000ULL, 0x0000002f2e00720bULL, 0x004fe40003f5e000ULL,
0x0000002d300d7208ULL, 0x000fe40004800000ULL, 0x0000002e2f0e7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b0c307820ULL, 0x00afe20000410000ULL, 0x3fb8aa3b0d357820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000308ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b03037823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b09097823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010835ULL,
0x0000001100347308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b1f2e7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010835ULL,
0x0000001300367308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b24247823ULL, 0x000fe20000010835ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010830ULL,
0x0000001400317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b00007823ULL, 0x000fe20000010830ULL,
0x0000000b0600720bULL, 0x004fcc0003f3e000ULL, 0x00000003000f7308ULL, 0x0003f00000000800ULL,
0x0000000900327308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b1e037823ULL, 0x002fe20000010830ULL,
0x00000004001e7c02ULL, 0x000fe20008000f00ULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x3f8000001e1e783eULL, 0x000fc400000010ffULL, 0x00000010002d7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b20097823ULL, 0x004fe40000010830ULL, 0x000000ffff1f7224ULL, 0x100fe400078e001eULL,
0x000000ffff307224ULL, 0x000fc600078e001eULL, 0x0000002200117308ULL, 0x000fe20000000800ULL,
0x0000000f3210723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b280f7823ULL, 0x000fcc0000010835ULL,
0x0000002300147308ULL, 0x000e700000000800ULL, 0x0000002500137308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000ea20000000800ULL, 0x000000111411723eULL, 0x002fce00000010ffULL,
0x00000012002f7308ULL, 0x0002e20000000800ULL, 0x000000132613723eULL, 0x004fce00000010ffULL,
0x0000001500387308ULL, 0x000fe20000000800ULL, 0x0000002d3412723eULL, 0x002fe400000010ffULL,
0x0000002f3614723eULL, 0x008fca00000010ffULL, 0x00000017003a7308ULL, 0x000ff00000000800ULL,
0x0000002900157308ULL, 0x000ff00000000800ULL, 0x0000002a00207308ULL, 0x000e700000000800ULL,
0x0000002b00177308ULL, 0x0005f00000000800ULL, 0x0000002c002c7308ULL, 0x000ee20000000800ULL,
0x0000001e1028723cULL, 0x004f6200000418ffULL, 0x000000152015723eULL, 0x002fc400000010ffULL,
0x00000002ff207819ULL, 0x000fc80000011608ULL, 0x0000001600337308ULL, 0x0003e20000000800ULL,
0x0000000820257824ULL, 0x040fe200078e00ffULL, 0x0000000420237810ULL, 0x040fe20007ffe0ffULL,
0x0000000820267824ULL, 0x040fe400078e00ffULL, 0x00000008202d7824ULL, 0x000fe200078e00ffULL,
0x000000172c17723eULL, 0x008fe400000010ffULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x000000313816723eULL, 0x002fe200000010ffULL, 0x00000008202c7824ULL, 0x000fe200078e00ffULL,
0x0000001e00317202ULL, 0x000fe20000000f00ULL, 0x000000ffff387224ULL, 0x000fe200078e001eULL,
0xfffffff8262f7812ULL, 0x000fc400078ee223ULL, 0x0000000820267810ULL, 0x040fe20007ffe0ffULL,
0x0000001d003c7308ULL, 0x0002a20000000800ULL, 0x0000001e1428723cULL, 0x020b620000041828ULL,
0xffffffff20237810ULL, 0x000fe40007ffe0ffULL, 0x0000000326397819ULL, 0x000fc800000006ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1a1f7823ULL, 0x120fe20000010835ULL,
0x3fb8aa3b191d7823ULL, 0x002fcc0000010835ULL, 0x0000000f00227308ULL, 0x0002e20000000800ULL,
0x0000001b3c1a723eULL, 0x004fce00000010ffULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b180f7823ULL, 0x102fe20000010835ULL, 0x0000000120187810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b1c357823ULL, 0x000fc60000010835ULL, 0xfffffff825257812ULL, 0x000fe400078ee218ULL,
0x0000002400247308ULL, 0x000e620000000800ULL, 0x000000333a18723eULL, 0x000fe200000010ffULL,
0x0000000820337824ULL, 0x000fe200078e00ffULL, 0x000000272219723eULL, 0x008fe400000010ffULL,
0x0000000320227810ULL, 0x000fc60007ffe0ffULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee222ULL, 0x0000000620227810ULL, 0x000fc80007ffe0ffULL,
0xfffffff833337812ULL, 0x000fe200078ee222ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x00000021241b723eULL, 0x002fe200000010ffULL, 0x0000000820247824ULL, 0x040fe200078e00ffULL,
0x0000000220217810ULL, 0x000fc80007ffe0ffULL, 0xfffffff824277812ULL, 0x000fe200078ee221ULL,
0x000000301828723cULL, 0x000b620000041828ULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x0000000520217810ULL, 0x000fca0007ffe0ffULL, 0xfffffff82c317812ULL, 0x020fe400078ee221ULL,
0x0000000000007308ULL, 0x000e700000000800ULL, 0x0000000f000f7308ULL, 0x000ff00000000800ULL,
0x0000001d001c7308ULL, 0x0004e20000000800ULL, 0x000000090022723eULL, 0x002fc400000010ffULL,
0x0000900057007811ULL, 0x000fca00078e58ffULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x00000008201d7824ULL, 0x004fe400078e00ffULL, 0x0000001025097824ULL, 0x000fc600078e0200ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee220ULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0x0000003500247308ULL, 0x0002a20000000800ULL, 0x0000000f1c21723eULL, 0x008fe200000010ffULL,
0x000000102f1c7824ULL, 0x100fe200078e0200ULL, 0x000000002d0f7211ULL, 0x000fe400078e20ffULL,
0xfffffff820377812ULL, 0x000fe400078ee223ULL, 0x000000032e20723eULL, 0x000fe200000010ffULL,
0x000000101d037824ULL, 0x000fe200078e0200ULL, 0xfffffff839357812ULL, 0x002fe200078ee226ULL,
0x000000ffff397224ULL, 0x000fe200078e001eULL, 0x0000000c0a267812ULL, 0x000fe200078ec0ffULL,
0x00000010270a7824ULL, 0x000fc400078e0200ULL, 0x00000010311d7824ULL, 0x100fe200078e0200ULL,
0x0000001f2423723eULL, 0x004fe200000010ffULL, 0x0000000126037824ULL, 0x040fe200078e0203ULL,
0x0000000035247211ULL, 0x000fe200078e20ffULL, 0x00000010331e7824ULL, 0x100fe400078e0200ULL,
0x0000000126097824ULL, 0x040fe200078e0209ULL, 0x0000001003007388ULL, 0x0003e20000000800ULL,
0x000000382028723cULL, 0x000f620000041828ULL, 0x00000010371f7824ULL, 0x000fe200078e0200ULL,
0x0000001e261e7210ULL, 0x040fe20007ffe0ffULL, 0x00000001260a7824ULL, 0x040fe200078e020aULL,
0x0000001209007388ULL, 0x0003e20000000800ULL, 0x0000000126007824ULL, 0x040fe200078e020fULL,
0x000000060b0f7208ULL, 0x000fe20004800000ULL, 0x00000001261c7824ULL, 0x040fe200078e021cULL,
0x000000140a007388ULL, 0x0003e20000000800ULL, 0x00000001261d7824ULL, 0x000fc400078e021dULL,
0x00000001261f7824ULL, 0x040fe200078e021fULL, 0x0000001600007388ULL, 0x0003e20000000800ULL,
0x0000000126247824ULL, 0x000fc600078e0224ULL, 0x000000181c007388ULL, 0x0003e80000000800ULL,
0x0000001a1d007388ULL, 0x0003e80000000800ULL, 0x000000201e007388ULL, 0x0003e20000000800ULL,
0x000000ffff297224ULL, 0x020fc600078e002aULL, 0x000000221f007388ULL, 0x0003e80000000800ULL,
0x0000001124007388ULL, 0x0003e80000000800ULL, 0x0004001309007388ULL, 0x0003e80000000800ULL,
0x000400150a007388ULL, 0x0003e80000000800ULL, 0x0004001700007388ULL, 0x0003e80000000800ULL,
0x000400191c007388ULL, 0x0003e80000000800ULL, 0x0004001b1d007388ULL, 0x0003e80000000800ULL,
0x000400211e007388ULL, 0x0003e80000000800ULL, 0x000400231f007388ULL, 0x0003e80000000800ULL,
0x0130000c05008388ULL, 0x0003e80000000c00ULL, 0x0132002805008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080007ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136100007ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136180007ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000545100720cULL, 0x000fe20003f06070ULL,
0x0136200007ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff597224ULL, 0x000fd600078e0051ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb1a000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0d7807ULL, 0x004fe40004000000ULL,
0x00010a40000c7802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0015ULL, 0xffff179000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40005000000ULL, 0x00010a90000c7802ULL, 0x000fc40000000f00ULL,
0x00000c2000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0015ULL,
0xffff180000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x004fe200078e0015ULL,
0x00010ae000187802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0017ULL, 0xffff18c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0015ULL, 0x00010b3000187802ULL, 0x000fc40000000f00ULL,
0x00000b3000007944ULL, 0x008fea0003c00000ULL, 0x00000017000c7202ULL, 0x004fe20000000f00ULL,
0xffff19e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e000fULL,
0x00010b9000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000eULL,
0x00000ad000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0017ULL,
0xffff1b9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0008ULL,
0x00010bf000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff177224ULL, 0x000fc400078e000fULL,
0x00000a7000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0017ULL,
0xffff1b6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x008fe40004000000ULL,
0x00010c40000c7802ULL, 0x000fc40000000f00ULL, 0x00000a7000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0xffff30a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40004800000ULL, 0x00010c90000c7802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x002fea0003c00000ULL, 0xffff310000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0x00010cd000187802ULL, 0x000fc40000000f00ULL,
0x0000099000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0017ULL,
0xffff31e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0016ULL,
0x00010d2000187802ULL, 0x000fc40000000f00ULL, 0x0000094000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0017ULL, 0xffff32f000007947ULL, 0x000fea000383ffffULL,
0x0000000e00177202ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000fULL,
0x00010d8000187802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0017ULL, 0xffff34a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e000eULL, 0x00010dd000187802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0017ULL,
0xffff348000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x008fe40004000000ULL,
0x00010e20000c7802ULL, 0x000fc40000000f00ULL, 0x0000089000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0015ULL, 0xffff468000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40004800000ULL, 0x00010e70000c7802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff167224ULL, 0x000fe200078e0015ULL,
0xffff46d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e001aULL,
0x00010ec000187802ULL, 0x000fc40000000f00ULL, 0x000007a000007944ULL, 0x000fea0003c00000ULL,
0x00000017000c7202ULL, 0x004fe20000000f00ULL, 0xffff47b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e001aULL, 0x00010f1000187802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0017ULL,
0xffff48c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e000eULL,
0x00010f7000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000fULL,
0x000006f000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0017ULL,
0xffff4a7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e000eULL,
0x00010fc000187802ULL, 0x000fc40000000f00ULL, 0x000006a000007944ULL, 0x00efea0003c00000ULL,
0x0000001700087202ULL, 0x004fe20000000f00ULL, 0xffff4a5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x008fe40004000000ULL, 0x00011010000c7802ULL, 0x000fc40000000f00ULL,
0x000006a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0015ULL,
0xffff5c7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x000fe40005000000ULL,
0x00011060000c7802ULL, 0x000fc40000000f00ULL, 0x0000065000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0xffff5cc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0x000110b000187802ULL, 0x000fc40000000f00ULL,
0x000005b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0017ULL,
0xffff5d9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0016ULL,
0x0001110000187802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x002fea0003c00000ULL,
0x00000017000c7202ULL, 0x004fe20000000f00ULL, 0xffff5ea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e000eULL, 0x0001116000187802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e000fULL, 0x0000050000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0017ULL, 0xffff605000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e000eULL, 0x000111b000187802ULL, 0x000fc40000000f00ULL,
0x000004b000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0017ULL,
0xffff603000007947ULL, 0x000fea000383ffffULL, 0x00000002ff307424ULL, 0x000fe200078e00ffULL,
0x00011200002e7802ULL, 0x000fc40000000f00ULL, 0x0000042000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000bULL, 0xffffea8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2d7224ULL, 0x006fe200078e0031ULL, 0x00011260002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff307424ULL, 0x000fc400078e00ffULL, 0x000003c000007944ULL, 0x000fea0003c00000ULL,
0x0000000b3100720bULL, 0x004fe20003f1e000ULL, 0x00000002ff307424ULL, 0x002fe200078e00ffULL,
0x0000000e002d7202ULL, 0x000fc40000000f00ULL, 0x000000310b347208ULL, 0x000fe40004000000ULL,
0x000112c0002e7802ULL, 0x000fc40000000f00ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e000fULL,
0x00011320002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff307424ULL, 0x000fe200078e00ffULL,
0x0000000e0b0e7208ULL, 0x000fc80004000000ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e0032ULL,
0x00011380002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff307424ULL, 0x000fe200078e00ffULL,
0x0000000f0b067208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x0000000b3200720bULL, 0x004fe20003f1e000ULL, 0x00000001ff307424ULL, 0x002fe200078e00ffULL,
0x00000034002d7202ULL, 0x000fc40000000f00ULL, 0x000000320b0c7208ULL, 0x000fe40004000000ULL,
0x000113e0002e7802ULL, 0x000fc40000000f00ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x0000000b3400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e000eULL,
0x00011440002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff307424ULL, 0x000fe200078e00ffULL,
0x000000340b0d7208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e0006ULL,
0x000114a0002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff307424ULL, 0x000fe200078e00ffULL,
0x0000000e0b0e7208ULL, 0x000fc80004000000ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffe95000007947ULL, 0x000fea000383ffffULL, 0x0180000005007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000097812ULL, 0x000fc800078ec0ffULL,
0x018000000900780cULL, 0x000fda0003f05070ULL, 0x0000000500008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x040fe40003f25070ULL,
0x008000000900780cULL, 0x000fe40003f02070ULL, 0x00000001ff097807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000009ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff05ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000009ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000005097812ULL, 0x000fd600078ec0ffULL, 0x0080000009000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0009ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000500007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000d7802ULL, 0x000fc80000000f00ULL, 0xfffee9e00c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c0000302d0b7389ULL, 0x0002a200000e0033ULL, 0xfffee9a02e007950ULL, 0x000fea0003c3ffffULL,
0x0000006100007348ULL, 0x000fe80003800000ULL, 0x0000000c17177389ULL, 0x0002a200000e0064ULL,
0x00000000ff0d7424ULL, 0x000fc400078e00ffULL, 0x000000ffff0c7224ULL, 0x002fc800078e0018ULL,
0xfffee9500c007950ULL, 0x000fea0003c3ffffULL, 0x000000010d00780cULL, 0x000fe20003f45070ULL,
0x0000006200007348ULL, 0x000fd80003800000ULL, 0x00000000000d7806ULL, 0x000fc800050e0100ULL,
0x000000620d157212ULL, 0x000fe200078ec0ffULL, 0x00000000ff0d7424ULL, 0x000fc800078e00ffULL,
0xfffee8f00c007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000002ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000054aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a8ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000900ULL,
0x00000000000002f8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bf8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000cb8ULL,
0x0000000000000584ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001240ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001250ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012e0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012e4ULL,
0x00000000000001a8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x0000000000011800ULL, 0x7400001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000012d00ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000012d40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000130c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012e0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000011a20ULL,
0x0000000000011a20ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000012d00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000130c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_8_m_8_sm_86_cubin_len = 78240;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
