/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000012118ULL, 0x0000000000011d98ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x625f766e5f5f3431ULL,
0x32363174616f6c66ULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454536316a4cULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45346aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x32336a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x6a4c45386a4c4545ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x0000000000676e69ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x6c65722e00687461ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b0001000000b1ULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000efULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000b00010000016fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0001000001b9ULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000001ffULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000246ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000b00010000028cULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000002daULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b000100000328ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000036eULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000003b3ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000040eULL,
0x0000000000010ae0ULL, 0x0000000000000220ULL, 0x0004000300000484ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000010d00ULL,
0x000d0003000004b4ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00010ae000000000ULL, 0x0000680400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808a0828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808a92ULL,
0x0000001cffffffffULL, 0x0000006000000000ULL, 0x00010ae000000000ULL, 0x0000022000000000ULL,
0x0000000000000000ULL, 0x0000001400082f04ULL, 0x000823040000007fULL, 0x0000000000000012ULL,
0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL,
0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b42904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010000b42804ULL, 0x0000064000000110ULL,
0x0000236000001510ULL, 0x000024c0000023e0ULL, 0x0000297000002600ULL, 0x00002e9000002980ULL,
0x00003c6000003bf0ULL, 0x00003ea000003d60ULL, 0x000040b0000040a0ULL, 0x0000515000004450ULL,
0x000052c0000051c0ULL, 0x0000560000005400ULL, 0x000059d000005610ULL, 0x00006750000066d0ULL,
0x0000697000006830ULL, 0x00006b8000006b70ULL, 0x0000717000007160ULL, 0x000092b000009270ULL,
0x0000993000009900ULL, 0x0000ff900000fee0ULL, 0x00010260000101c0ULL, 0x000105e000010590ULL,
0x0001084000010780ULL, 0x000001f001f03904ULL, 0x0001b600000000ffULL, 0x000002d000040100ULL,
0x0001b60800000002ULL, 0x000003e0003f0100ULL, 0x0001b68800000002ULL, 0x00000690003f0100ULL,
0x0001b6000000000cULL, 0x000007b0003f0107ULL, 0x0001b68800000000ULL, 0x000020b0003f0101ULL,
0x0001b60800000033ULL, 0x00002110003f0101ULL, 0x0001b60800000037ULL, 0x00002280003f0109ULL,
0x0001b60800000037ULL, 0x00002e00003f0109ULL, 0x0001b6880000004bULL, 0x000039e0003f0101ULL,
0x0001b62800000035ULL, 0x00003a00003f0101ULL, 0x0001b62800000035ULL, 0x00003b70003f0109ULL,
0x0001b62800000035ULL, 0x000043b0003f0109ULL, 0x0001b6900000004bULL, 0x00004f40003f0101ULL,
0x0001b64800000035ULL, 0x00004f60003f0101ULL, 0x0001b64800000035ULL, 0x000050d0003f0109ULL,
0x0001b64800000035ULL, 0x000058f0003f0109ULL, 0x0001b6980000004bULL, 0x000064c0003f0101ULL,
0x0001b66800000037ULL, 0x000064e0003f0101ULL, 0x0001b66800000037ULL, 0x00006650003f0109ULL,
0x0001b66800000037ULL, 0x00006e00003f0109ULL, 0x0001b6a00000004bULL, 0x0000a260003f0101ULL,
0x0001b6000000000cULL, 0x0000b8b0003f0101ULL, 0x0001b6000000000cULL, 0x0000ba20003f0109ULL,
0x0001b6000000000cULL, 0x0000f370003f0109ULL, 0x0001b68800000007ULL, 0x0000f5e0003f0101ULL,
0x0001b68800000007ULL, 0x0000f750003f0109ULL, 0x0001b68800000007ULL, 0x00010a80003f0109ULL,
0x0001b60800000005ULL, 0x00010a90003f0101ULL, 0x0001b61000000005ULL, 0x00010aa0003f0101ULL,
0x0001b61800000005ULL, 0x00010ab0003f0101ULL, 0x0001b62000000005ULL, 0x00033803003f0101ULL,
0x00009f6000141c04ULL, 0x0000ba500000a1d0ULL, 0x00010ad00000bac0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400481903ULL, 0x0048021000000015ULL,
0x00000000000000bcULL, 0x0000001400000002ULL, 0x0000000000010ae0ULL, 0x0000000000000044ULL,
0x0000001400000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001400000002ULL,
0x0000000000000000ULL, 0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000077919ULL, 0x000eae0000002100ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x0000000000037919ULL, 0x000f220000002300ULL, 0x0000000000027919ULL, 0x000f6a0000002200ULL,
0x00000300ff0e7b82ULL, 0x000f620000000800ULL, 0x0000010000057ab9ULL, 0x000fe20000000800ULL,
0x0000000000137919ULL, 0x000f620000002700ULL, 0x0000000000157919ULL, 0x000f6a0000008800ULL,
0x00008400ff107b82ULL, 0x000f620000000800ULL, 0x00000000000b7919ULL, 0x000f6e0000000000ULL,
0x00008800ff047b82ULL, 0x000f620000000a00ULL, 0x00000004ff417e24ULL, 0x008fe2000f8e00ffULL,
0x00000005ff437819ULL, 0x004fcc0000011607ULL, 0x00000000000879c3ULL, 0x000ea20000002600ULL,
0x00001fff03007589ULL, 0x010fe800000e0000ULL, 0x00001fff43437589ULL, 0x000ee200000e0000ULL,
0x0000000503027c24ULL, 0x022fe2000f8e0202ULL, 0x0000000000057ab9ULL, 0x000fc60000000800ULL,
0x0000000502077c24ULL, 0x000fca000f8e0207ULL, 0x000000ff0700720cULL, 0x040fe40003f05270ULL,
0x0000000f0700780cULL, 0x040fe40003f24070ULL, 0x000000030700780cULL, 0x000fe20003f44070ULL,
0x0000000400037824ULL, 0x008fd000078e0243ULL, 0x0000000000240947ULL, 0x004fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01b60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000407027c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000020612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01b60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000407027c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01b68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000308047899ULL, 0x000fe2000800063fULL, 0x0000007f0700780cULL, 0x000fe20003f04070ULL,
0x0000000810027824ULL, 0x000fe200078e00ffULL, 0x00000004ff0a7819ULL, 0x000fe2000001160bULL,
0x00008c00ff087b82ULL, 0x000e620000000a00ULL, 0x0000000103067819ULL, 0x000fe200000006ffULL,
0x0000000402027e24ULL, 0x000fe2000f8e0213ULL, 0x00000400000c7802ULL, 0x000fe20000000f00ULL,
0x000000100b037824ULL, 0x000fe200078e00ffULL, 0x00000008060d7848ULL, 0x000fe20007fe0000ULL,
0x00000001060f7824ULL, 0x000fe200078e020aULL, 0x00000654150c7816ULL, 0x000fe2000000000cULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000d060d7210ULL, 0x000fe20007ffe1ffULL,
0x0000000102117824ULL, 0x000fe200078e020fULL, 0x000000000c0472caULL, 0x000fe200000e0000ULL,
0x0000000407028824ULL, 0x000fe200078e020cULL, 0x000000040f127819ULL, 0x000fe200000006ffULL,
0x0000010011047825ULL, 0x000fe200078e0004ULL, 0x000000f003117812ULL, 0x000fc400078ec0ffULL,
0x0000000d0a00720cULL, 0x000fe20003f26070ULL, 0x000000010f077824ULL, 0x000fe200078e020bULL,
0x0000001104067210ULL, 0x000fe20007f5e0ffULL, 0xff317217ff158424ULL, 0x000fc600078e00ffULL,
0xfffffff0120d7812ULL, 0x000fe200078ee207ULL, 0x0001b60004047890ULL, 0x000fe2000fffe03fULL,
0x000000ffff077224ULL, 0x000fe200010e0605ULL, 0x01b4001502008388ULL, 0x0005e20000000800ULL,
0x0000000413047825ULL, 0x002fc800078e0008ULL, 0x000000100d0d7824ULL, 0x000fe200078e020cULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0005e2000c901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000006040f7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x000000ff0f0d7836ULL, 0x004fca0000000000ULL,
0x00000008ff0d7819ULL, 0x000fce000001160dULL, 0x0000009800b08947ULL, 0x000fea0003800000ULL,
0x00000003430a7819ULL, 0x000fe200000006ffULL, 0x0000000141027836ULL, 0x000fe20000000000ULL,
0x00000001ff097819ULL, 0x000fe20000011643ULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x000000010c007824ULL, 0x000fe200078e020aULL,
0x0000000d0200720cULL, 0x000fe20003f06070ULL, 0x0000000213077824ULL, 0x000fe200078e00ffULL,
0x0000000143067812ULL, 0x000fe200078ec0ffULL, 0x01b6880300ff79a7ULL, 0x0003e2000850003fULL,
0x0000002009087824ULL, 0x000fc800078e00ffULL, 0x0000010041047824ULL, 0x000fe200078e0208ULL,
0x0000000810007c10ULL, 0x002fca000fffe0ffULL, 0x0000001007077224ULL, 0x000fc800078e0200ULL,
0x00000004072b7c24ULL, 0x000fe2000f8e0204ULL, 0x0000000400748947ULL, 0x000fec0003800000ULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x00000003ff107819ULL, 0x100fe2000001160bULL,
0x0000400009117824ULL, 0x000fe200078e020cULL, 0x000000040f007248ULL, 0x000fe40007fe0000ULL,
0x000000ff04057210ULL, 0x000fe20007ffe1ffULL, 0x0000000110047824ULL, 0x000fe200078e020bULL,
0x0000000306147819ULL, 0x040fe200000006ffULL, 0x0000200006117824ULL, 0x000fe200078e0211ULL,
0x0000002000007446ULL, 0x000fe20003800005ULL, 0x000000012b057824ULL, 0x000fe200078e0210ULL,
0x0000000704127812ULL, 0x000fe200078ec0ffULL, 0x0001300011117836ULL, 0x000fe20000000000ULL,
0x000000001000720cULL, 0x080fe20003f06070ULL, 0x0000000c10157836ULL, 0x000fe20000000000ULL,
0xfffffff8141b7812ULL, 0x000fe200078ee20bULL, 0x0000000810147836ULL, 0x000fe20000000000ULL,
0x0ffffff812127812ULL, 0x000fe200078ef80bULL, 0x0000001010167836ULL, 0x000fe20000000000ULL,
0x0000001410187810ULL, 0x000fe20007ffe0ffULL, 0x00000018101a7836ULL, 0x000fe20000000000ULL,
0x0000000315177819ULL, 0x000fe200000006ffULL, 0x0000001012137824ULL, 0x000fe200078e0211ULL,
0x0000000410127810ULL, 0x000fe20007ffe0ffULL, 0x0000010005047825ULL, 0x002fe200078e0002ULL,
0x000000001400720cULL, 0x000fc40003f26070ULL, 0x000000001500720cULL, 0x080fe20003f46070ULL,
0x0000001c101c7836ULL, 0x000fe20000000000ULL, 0x000000001600720cULL, 0x080fe20003f66070ULL,
0x000000101b047825ULL, 0x000fe200078e0004ULL, 0x000000001800720cULL, 0x080fe40003f86070ULL,
0x000000001a00720cULL, 0x080fe20003fa6070ULL, 0x00000008141e7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004137faeULL, 0x0003e2000c101c46ULL,
0x0000000115107824ULL, 0x000fe200078e020bULL, 0x000000001200720cULL, 0x080fe20003f06070ULL,
0x000000012b197824ULL, 0x000fe200078e0218ULL, 0x000000001c00720cULL, 0x000fe20003fc6070ULL,
0x00000008181f7824ULL, 0x000fe200078e00ffULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000008161d7824ULL, 0x000fe200078e00ffULL, 0x000000162b177210ULL, 0x000fe20007ffe0ffULL,
0x000000081a217824ULL, 0x000fc400078e00ffULL, 0x000000081c237824ULL, 0x000fe200078e00ffULL,
0x0000000312137819ULL, 0x042fe200000006ffULL, 0x0000000112047824ULL, 0x100fe400078e020bULL,
0x0000000114057824ULL, 0x000fe400078e020bULL, 0x000000012b157824ULL, 0x040fe200078e0215ULL,
0xfffffff813047812ULL, 0x000fe200078ee204ULL, 0x000000012b137824ULL, 0x040fe200078e0214ULL,
0xfffffff81e007812ULL, 0x000fe200078ee205ULL, 0x000000012b057824ULL, 0x040fe200078e0212ULL,
0x0000000b18147210ULL, 0x000fe20007ffe0ffULL, 0x0000000116127824ULL, 0x100fe200078e020bULL,
0x0000000b1a167210ULL, 0x000fe20007ffe0ffULL, 0x000000011c187824ULL, 0x000fe200078e020bULL,
0xfffffff81f147812ULL, 0x000fe200078ee214ULL, 0x00000010001f7824ULL, 0x100fe200078e0211ULL,
0xfffffff81d127812ULL, 0x000fe200078ee212ULL, 0x000000012b277824ULL, 0x000fe200078e021aULL,
0xfffffff821167812ULL, 0x000fe200078ee216ULL, 0x0000001010217824ULL, 0x100fe200078e0211ULL,
0xfffffff823187812ULL, 0x000fe200078ee218ULL, 0x0000001012237824ULL, 0x100fe200078e0211ULL,
0x00000011041d7211ULL, 0x080fe200078e20ffULL, 0x0000001016297824ULL, 0x100fe200078e0211ULL,
0x0000001114257211ULL, 0x000fe200078e20ffULL, 0x00000010182d7824ULL, 0x000fc400078e0211ULL,
0x0000010005047825ULL, 0x000fc800078e0002ULL, 0x0000010013107825ULL, 0x000fc800078e0002ULL,
0x000000012b2b7824ULL, 0x000fe400078e021cULL, 0x0000010015127825ULL, 0x000fc800078e0002ULL,
0x0000010017147825ULL, 0x000fc800078e0002ULL, 0x0000010019167825ULL, 0x000fc800078e0002ULL,
0x0000010027187825ULL, 0x000fc800078e0002ULL, 0x000001002b027825ULL, 0x000fc800078e0002ULL,
0x000000101b047825ULL, 0x000fc800078e0004ULL, 0x000000101b107825ULL, 0x040fe200078e0010ULL,
0x00000000041d7faeULL, 0x0003e6000c101c46ULL, 0x000000101b127825ULL, 0x040fe200078e0012ULL,
0x00000000101f7faeULL, 0x0003e6000c901c46ULL, 0x000000101b147825ULL, 0x040fe200078e0014ULL,
0x0000000012217faeULL, 0x0003e6000d101c46ULL, 0x000000101b167825ULL, 0x040fe200078e0016ULL,
0x0000000014237faeULL, 0x0003e6000d901c46ULL, 0x000000101b187825ULL, 0x040fe200078e0018ULL,
0x0000000016257faeULL, 0x0003e6000e101c46ULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x0000000018297faeULL, 0x0003e8000e901c46ULL, 0x00000000022d7faeULL, 0x0003e2000f101c46ULL,
0x0000000400407947ULL, 0x000fea0003800000ULL, 0x000000080b107811ULL, 0x040fe200078fe8ffULL,
0x00008a00ff1a7b82ULL, 0x000e620000000a00ULL, 0x0000000c0b147811ULL, 0x040fe400078fe8ffULL,
0x000000140b1c7811ULL, 0x040fe200078fe8ffULL, 0x0000000110037824ULL, 0x100fe200078e020bULL,
0x0000000314187819ULL, 0x000fe200000006ffULL, 0x0000000810127824ULL, 0x000fe200078e00ffULL,
0x000000180b207811ULL, 0x040fe200078fe8ffULL, 0x0000000114057824ULL, 0x100fe200078e020bULL,
0x000000040b027811ULL, 0x000fe200078fe8ffULL, 0x000000012b137824ULL, 0x000fe200078e0214ULL,
0xfffffff812127812ULL, 0x000fe200078ee203ULL, 0x000000011c037824ULL, 0x100fe200078e020bULL,
0xfffffff818157812ULL, 0x000fe200078ee205ULL, 0x0000000120057824ULL, 0x100fe200078e020bULL,
0x000000031c1e7819ULL, 0x000fe200000006ffULL, 0x0000000820227824ULL, 0x000fe200078e00ffULL,
0x0000001c0b247811ULL, 0x000fe200078fe8ffULL, 0x0000000102007824ULL, 0x140fe200078e020bULL,
0x0000000302117819ULL, 0x000fe200000006ffULL, 0x000000012b197824ULL, 0x000fe200078e021cULL,
0x000000100b167811ULL, 0x000fe200078fe8ffULL, 0x000000012b2d7824ULL, 0x000fe200078e0224ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL, 0x0000000124037824ULL, 0x140fe200078e020bULL,
0xfffffff822227812ULL, 0x000fe200078ee205ULL, 0x0000400009057824ULL, 0x000fe200078e020cULL,
0x0000000324267819ULL, 0x000fe200000006ffULL, 0x000000012b177824ULL, 0x000fe200078e0216ULL,
0xfffffff811047812ULL, 0x000fe200078ee200ULL, 0x0000000116007824ULL, 0x040fe200078e020bULL,
0xfffffff826267812ULL, 0x000fe200078ee203ULL, 0x0000000816117824ULL, 0x000fe200078e00ffULL,
0x000000202b297210ULL, 0x000fe20007ffe0ffULL, 0x0000200006037824ULL, 0x000fc400078e0205ULL,
0x000000012b057824ULL, 0x000fe200078e0202ULL, 0xfffffff811187812ULL, 0x000fe200078ee200ULL,
0x00013000032f7836ULL, 0x000fe20000000000ULL, 0x0000000b0b007211ULL, 0x040fe200078fe8ffULL,
0x0000000806027824ULL, 0x000fe200078e00ffULL, 0x0000002b0b037211ULL, 0x000fe200078fe8ffULL,
0x00000010041f7824ULL, 0x000fe200078e022fULL, 0x000000102b117210ULL, 0x000fe20007ffe0ffULL,
0x0000010005047825ULL, 0x102fe200078e001aULL, 0x0000000700007812ULL, 0x000fe400078ec0ffULL,
0xfffffff802317812ULL, 0x000fe200078ee20bULL, 0x0000010003027825ULL, 0x000fe200078e001aULL,
0x0ffffff800007812ULL, 0x000fc400078ef80bULL, 0x0000002f18257211ULL, 0x080fe200078e20ffULL,
0x0000001012217824ULL, 0x000fe200078e022fULL, 0x0000002f001d7211ULL, 0x000fe200078e20ffULL,
0x0000010011107825ULL, 0x000fc800078e001aULL, 0x0000001015237824ULL, 0x000fe400078e022fULL,
0x0000010013127825ULL, 0x000fc800078e001aULL, 0x0000010017147825ULL, 0x000fc800078e001aULL,
0x0000010019167825ULL, 0x000fc800078e001aULL, 0x0000010029187825ULL, 0x000fc800078e001aULL,
0x0000001031027825ULL, 0x000fc800078e0002ULL, 0x000001002d1a7825ULL, 0x000fe200078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000021d7faeULL, 0x0003e6000b901c46ULL,
0x0000001031047825ULL, 0x000fc800078e0004ULL, 0x0000001031107825ULL, 0x040fe200078e0010ULL,
0x00000000041f7faeULL, 0x0003e6000b901c46ULL, 0x0000001031127825ULL, 0x040fe200078e0012ULL,
0x0000000010217faeULL, 0x0003e6000b901c46ULL, 0x0000001031147825ULL, 0x040fe200078e0014ULL,
0x0000000012237faeULL, 0x0003e6000b901c46ULL, 0x000000101e277824ULL, 0x000fe200078e022fULL,
0x0000000014257faeULL, 0x0003e2000b901c46ULL, 0x0000001031167825ULL, 0x000fc800078e0016ULL,
0x00000010222b7824ULL, 0x000fe200078e022fULL, 0x0000000016277faeULL, 0x0003e2000b901c46ULL,
0x0000001031187825ULL, 0x000fc800078e0018ULL, 0x00000010262f7824ULL, 0x000fe200078e022fULL,
0x00000000182b7faeULL, 0x0003e2000b901c46ULL, 0x00000010311a7825ULL, 0x000fca00078e001aULL,
0x000000001a2f7faeULL, 0x0003e4000b901c46ULL, 0x0000000d4100720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff31721700587802ULL, 0x000fe20000000f00ULL,
0x000000ffff057224ULL, 0x002fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fc4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fc4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000058009c0947ULL, 0x000fec0003800000ULL,
0xff317217ff587424ULL, 0x000fe200078e00ffULL, 0x000000ff002f7202ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fce00078e00ffULL, 0x0000010041047824ULL, 0x000fca00078e00ffULL,
0x0000000f0400720cULL, 0x000fda0003f06070ULL, 0x0000005800780947ULL, 0x000fea0003800000ULL,
0x0000000141047836ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x0000010041577824ULL, 0x000fc600078e0208ULL, 0x0000000d0400720cULL, 0x000fe20003f06070ULL,
0x000000ffff047224ULL, 0x000fe200078e005aULL, 0x0000004057367810ULL, 0x000fca0007ffe0ffULL,
0x0000000407347c24ULL, 0x000fe2000f8e0236ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000004007c8947ULL, 0x000fea0003800000ULL, 0x00008a00ff307b82ULL, 0x000e620000000a00ULL,
0x000000ffff337224ULL, 0x000fe200078e0a36ULL, 0x00000003ff387819ULL, 0x100fe2000001160bULL,
0x0000400009357824ULL, 0x000fe200078e020cULL, 0x000000360f327248ULL, 0x000fe20007fe0000ULL,
0x00000008063e7824ULL, 0x000fe200078e00ffULL, 0x0000001c38487810ULL, 0x000fe20007ffe0ffULL,
0x0000000138367824ULL, 0x040fe200078e020bULL, 0x0000002032337446ULL, 0x000fe20003800033ULL,
0x0000000138377824ULL, 0x100fe200078e0234ULL, 0x0000000c5a327819ULL, 0x000fe200000006ffULL,
0x0000001038427836ULL, 0x000fe20000000000ULL, 0x00000035063c7211ULL, 0x000fe200078e68ffULL,
0x0000001438447836ULL, 0x000fe20000000000ULL, 0x0000100032357812ULL, 0x000fe200078e0cffULL,
0x0000001838467836ULL, 0x000fe20000000000ULL, 0x00000007363a7812ULL, 0x000fe200078ec0ffULL,
0x00000001443d7824ULL, 0x100fe200078e0234ULL, 0x000000333800720cULL, 0x000fe20003f06070ULL,
0x00000001463f7824ULL, 0x100fe200078e0234ULL, 0xfffffff83e327812ULL, 0x000fe200078ee20bULL,
0x0000000148517824ULL, 0x000fe200078e0234ULL, 0x000130003c357810ULL, 0x000fe20007ffe035ULL,
0x00000008383c7836ULL, 0x000fe20000000000ULL, 0x0ffffff83a3a7812ULL, 0x000fe200078ef80bULL,
0x0000010037367825ULL, 0x002fe200078e0030ULL, 0x0000000c383e7810ULL, 0x000fc40007ffe0ffULL,
0x000000333c00720cULL, 0x080fe20003f26070ULL, 0x000000103a397824ULL, 0x000fe200078e0235ULL,
0x000000333e00720cULL, 0x080fe20003f46070ULL, 0x0000001032367825ULL, 0x000fe200078e0036ULL,
0x000000334200720cULL, 0x080fe40003f66070ULL, 0x000000334400720cULL, 0x080fe20003f86070ULL,
0x00000004383a7836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036397faeULL, 0x0003e2000c101c46ULL, 0x000000083e407824ULL, 0x000fe200078e00ffULL,
0x000000033c387819ULL, 0x000fe200000006ffULL, 0x000000083a3b7824ULL, 0x040fe200078e00ffULL,
0x000000333a00720cULL, 0x080fe20003f06070ULL, 0x0000000846497824ULL, 0x040fe200078e00ffULL,
0x000000334600720cULL, 0x000fc40003fa6070ULL, 0x000000334800720cULL, 0x000fe20003fc6070ULL,
0x000000013a337824ULL, 0x100fe200078e0234ULL, 0x0000000342457819ULL, 0x000fe200000006ffULL,
0x000000013c377824ULL, 0x102fe200078e020bULL, 0x0000000344477819ULL, 0x000fe200000006ffULL,
0x000000013e397824ULL, 0x100fe200078e020bULL, 0x00000003484b7819ULL, 0x000fe200000006ffULL,
0x000000013a367824ULL, 0x100fe200078e020bULL, 0xfffffff838387812ULL, 0x000fe200078ee237ULL,
0x00000001423a7824ULL, 0x100fe200078e020bULL, 0xfffffff840407812ULL, 0x000fe200078ee239ULL,
0x000000013e397824ULL, 0x100fe200078e0234ULL, 0x000000343c377210ULL, 0x000fe20007ffe0ffULL,
0x00000001443c7824ULL, 0x100fe200078e020bULL, 0xfffffff83b367812ULL, 0x000fe200078ee236ULL,
0x00000001483e7824ULL, 0x000fe200078e020bULL, 0xfffffff8453a7812ULL, 0x000fe200078ee23aULL,
0x00000001423b7824ULL, 0x000fe200078e0234ULL, 0x0000000b46347210ULL, 0x000fe20007ffe0ffULL,
0x0000001036457824ULL, 0x100fe200078e0235ULL, 0xfffffff8473c7812ULL, 0x000fe200078ee23cULL,
0x0000001038477824ULL, 0x100fe200078e0235ULL, 0xfffffff84b3e7812ULL, 0x000fe200078ee23eULL,
0x000000103a4b7824ULL, 0x100fe200078e0235ULL, 0xfffffff849347812ULL, 0x000fe200078ee234ULL,
0x000000103c4d7824ULL, 0x100fe200078e0235ULL, 0x0000003540497211ULL, 0x080fe200078e20ffULL,
0x000000103e537824ULL, 0x000fe200078e0235ULL, 0x00000035344f7211ULL, 0x000fe200078e20ffULL,
0x0000010033347825ULL, 0x000fc800078e0030ULL, 0x0000010037367825ULL, 0x000fc800078e0030ULL,
0x0000010039387825ULL, 0x000fc800078e0030ULL, 0x000001003b3a7825ULL, 0x000fc800078e0030ULL,
0x000001003d3c7825ULL, 0x000fc800078e0030ULL, 0x000001003f3e7825ULL, 0x000fc800078e0030ULL,
0x0000010051307825ULL, 0x000fc800078e0030ULL, 0x0000001032347825ULL, 0x000fc800078e0034ULL,
0x0000001032367825ULL, 0x040fe200078e0036ULL, 0x0000000034457faeULL, 0x0003e6000c101c46ULL,
0x0000001032387825ULL, 0x040fe200078e0038ULL, 0x0000000036477faeULL, 0x0003e6000c901c46ULL,
0x00000010323a7825ULL, 0x040fe200078e003aULL, 0x0000000038497faeULL, 0x0003e6000d101c46ULL,
0x00000010323c7825ULL, 0x040fe200078e003cULL, 0x000000003a4b7faeULL, 0x0003e6000d901c46ULL,
0x00000010323e7825ULL, 0x040fe200078e003eULL, 0x000000003c4d7faeULL, 0x0003e6000e101c46ULL,
0x0000001032307825ULL, 0x000fe200078e0030ULL, 0x000000003e4f7faeULL, 0x0003e8000e901c46ULL,
0x0000000030537faeULL, 0x0003e2000f101c46ULL, 0x0000000400487947ULL, 0x000fea0003800000ULL,
0x0000400009317824ULL, 0x000fe200078e020cULL, 0x0000000c5a307819ULL, 0x000fe400000006ffULL,
0x000000040b357811ULL, 0x040fe200078fe8ffULL, 0x0000200006317824ULL, 0x000fe200078e0231ULL,
0x0000100030307812ULL, 0x000fe400078e0cffULL, 0x000000080b377811ULL, 0x000fe400078fe8ffULL,
0x0001300031557810ULL, 0x000fe20007ffe030ULL, 0x0000000135307824ULL, 0x140fe200078e020bULL,
0x00000003353d7819ULL, 0x000fe200000006ffULL, 0x0000000137317824ULL, 0x100fe200078e020bULL,
0x0000000c0b397811ULL, 0x000fe200078fe8ffULL, 0x0000000837387824ULL, 0x000fe200078e00ffULL,
0xfffffff83d367812ULL, 0x000fe200078ee230ULL, 0x0000000135357824ULL, 0x100fe200078e0234ULL,
0x000000100b3b7811ULL, 0x000fe200078fe8ffULL, 0x00000008393f7824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee231ULL, 0x0000000137377824ULL, 0x100fe200078e0234ULL,
0x00008a00ff307b82ULL, 0x000e620000000a00ULL, 0x0000000b39327210ULL, 0x000fe20007ffe0ffULL,
0x000000013b337824ULL, 0x040fe200078e020bULL, 0x000000033b3c7819ULL, 0x040fe200000006ffULL,
0x000000013b3b7824ULL, 0x000fe200078e0234ULL, 0x000000140b3d7811ULL, 0x000fe200078fe8ffULL,
0x0000001038497824ULL, 0x000fe200078e0255ULL, 0xfffffff83f3a7812ULL, 0x000fc400078ee232ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee233ULL, 0x000000013d337824ULL, 0x000fe200078e020bULL,
0x0000000b0b327211ULL, 0x000fe200078fe8ffULL, 0x000000083d3e7824ULL, 0x000fe200078e00ffULL,
0x000000180b3f7811ULL, 0x000fe200078fe8ffULL, 0x000000013d3d7824ULL, 0x100fe200078e0234ULL,
0x0000001c0b537811ULL, 0x000fe200078fe8ffULL, 0x000000103c4d7824ULL, 0x000fe200078e0255ULL,
0x0000000732327812ULL, 0x000fe200078ec0ffULL, 0x000000083f457824ULL, 0x000fe200078e00ffULL,
0x0000000b3f407210ULL, 0x000fe20007ffe0ffULL, 0x0000000153427824ULL, 0x040fe200078e020bULL,
0x0000000353477819ULL, 0x040fe200000006ffULL, 0x0000000153537824ULL, 0x000fe200078e0234ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee233ULL, 0x000001003d3c7825ULL, 0x002fe200078e0030ULL,
0x0000003439397210ULL, 0x000fc40007ffe0ffULL, 0x000000343f3f7210ULL, 0x000fe20007ffe0ffULL,
0x000000103e4f7824ULL, 0x000fe200078e0255ULL, 0x000000340b337211ULL, 0x000fe200078fe8ffULL,
0x0000000806347824ULL, 0x000fe200078e00ffULL, 0x0ffffff832327812ULL, 0x000fe200078ef80bULL,
0x0000010039387825ULL, 0x100fe200078e0030ULL, 0xfffffff845407812ULL, 0x000fe400078ee240ULL,
0x0000005532457211ULL, 0x000fe200078e20ffULL, 0x0000010033327825ULL, 0x000fe200078e0030ULL,
0xfffffff847427812ULL, 0x000fc400078ee242ULL, 0xfffffff834597812ULL, 0x000fe200078ee20bULL,
0x0000001036477824ULL, 0x000fe200078e0255ULL, 0x000000553a4b7211ULL, 0x080fe200078e20ffULL,
0x0000010035347825ULL, 0x000fe200078e0030ULL, 0x0000005540517211ULL, 0x000fc600078e20ffULL,
0x0000010037367825ULL, 0x000fc800078e0030ULL, 0x000001003b3a7825ULL, 0x000fc800078e0030ULL,
0x000001003f3e7825ULL, 0x000fc800078e0030ULL, 0x0000001059327825ULL, 0x000fc800078e0032ULL,
0x0000010053307825ULL, 0x000fe200078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032457faeULL, 0x0003e6000b901c46ULL, 0x0000001059347825ULL, 0x000fc800078e0034ULL,
0x0000001059367825ULL, 0x040fe200078e0036ULL, 0x0000000034477faeULL, 0x0003e6000b901c46ULL,
0x0000001059387825ULL, 0x040fe200078e0038ULL, 0x0000000036497faeULL, 0x0003e6000b901c46ULL,
0x00000010593a7825ULL, 0x040fe200078e003aULL, 0x00000000384b7faeULL, 0x0003e6000b901c46ULL,
0x00000010593c7825ULL, 0x040fe200078e003cULL, 0x000000003a4d7faeULL, 0x0003e6000b901c46ULL,
0x00000010593e7825ULL, 0x040fe200078e003eULL, 0x000000003c4f7faeULL, 0x0003e6000b901c46ULL,
0x0000001042557824ULL, 0x000fe200078e0255ULL, 0x000000003e517faeULL, 0x0003e2000b901c46ULL,
0x0000001059307825ULL, 0x000fca00078e0030ULL, 0x0000000030557faeULL, 0x0003e4000b901c46ULL,
0xffffffe00a317812ULL, 0x042fe200078ec0ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000100a337812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000010c327824ULL, 0x000fca00078e0231ULL, 0x0000003332337210ULL, 0x000fca0007ffe0ffULL,
0x0000000806337824ULL, 0x000fc800078e0233ULL, 0x01b60834333479a7ULL, 0x0002a6000850003fULL,
0x0000000000307805ULL, 0x000fe40000015200ULL, 0x0000000409337819ULL, 0x002fc800000006ffULL,
0x0000001033337812ULL, 0x000fca00078ec0ffULL, 0x0000000132337824ULL, 0x000fc800078e0233ULL,
0x0000000806377824ULL, 0x000fc800078e0233ULL, 0x01b60835370075a7ULL, 0x004ee4000800017fULL,
0x00000000005c0947ULL, 0x00efea0003800000ULL, 0x000000ff00367202ULL, 0x000fce0000000f00ULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fce0007ffe0ffULL,
0x01b60835370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002043307824ULL, 0x000fe200078e00ffULL, 0x00000001ff517819ULL, 0x000fe2000001160bULL,
0x000000100b567824ULL, 0x000fe400078e00ffULL, 0x000000ffff537224ULL, 0x000fe200078e0058ULL,
0xffffff8030317812ULL, 0x000fe400078ec0ffULL, 0x0000007056567812ULL, 0x000fe400078ec0ffULL,
0x0000000c51517812ULL, 0x000fe400078ec0ffULL, 0x000000310c547210ULL, 0x000fc80007ffe0ffULL,
0x0000005451307210ULL, 0x000fca0007ffe056ULL, 0x01b0000030317984ULL, 0x000e680000000800ULL,
0x01b2000030597984ULL, 0x0004a20000000800ULL, 0x000000583100720bULL, 0x002fda0003f1d000ULL,
0x0000000000327806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff32337812ULL, 0x000fda000782c0ffULL, 0x0000000000f49947ULL, 0x004fea0003800000ULL,
0x00000002ff307819ULL, 0x000fe40000011643ULL, 0x000000583100720bULL, 0x000fe40003f34000ULL,
0x000000433000720cULL, 0x000fe40003f45270ULL, 0x0000003158537209ULL, 0x000fd20007810000ULL,
0x0000000000347806ULL, 0x000fe400008e0100ULL, 0x000000804330a824ULL, 0x000fe400078e020cULL,
0x0000991034327816ULL, 0x000fc600000000ffULL, 0x000000305130a210ULL, 0x000fe40007ffe056ULL,
0x000000ff3200720cULL, 0x000fc60003f25270ULL, 0x01b400533000a388ULL, 0x0003f40000000800ULL,
0x0000000000b09947ULL, 0x002fea0003800000ULL, 0x8000005358307221ULL, 0x000fe20000010000ULL,
0x000000ff34ff7812ULL, 0x040fe4000782c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x0000003000357308ULL, 0x0002ac0000000800ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x002fcc000001160bULL,
0x00001f3035307589ULL, 0x004e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003505057220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080b307811ULL, 0x002fcc00078ff0ffULL,
0x00001f3035307589ULL, 0x000e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff33ff7812ULL, 0x000fda0007826034ULL,
0x8000005331311221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b31311820ULL, 0x000fc80000410000ULL, 0x0000003100021308ULL, 0x000ea40000000800ULL,
0x0000000259591220ULL, 0x004fce0000410000ULL, 0x000000080b407812ULL, 0x000fe200078ec0ffULL,
0x0000020043307824ULL, 0x002fe200078e00ffULL, 0x0000000c09557211ULL, 0x000fe200078e70ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000740407812ULL, 0x000fe200078ef80bULL,
0x0000200006557824ULL, 0x000fe200078e0255ULL, 0x000000070b527812ULL, 0x040fe400078ec0ffULL,
0x000000400b327211ULL, 0x000fe200078fe0ffULL, 0x0000000840367824ULL, 0x040fe200078e00ffULL,
0x0000000340317819ULL, 0x040fe200000006ffULL, 0x00000008404f7824ULL, 0x000fe200078e00ffULL,
0x00000004ff347819ULL, 0x000fe2000001160bULL, 0x00000002324e7836ULL, 0x000fe20000000000ULL,
0xfffff80030337812ULL, 0x000fe200078ec0ffULL, 0x00000004324d7836ULL, 0x000fe20000000000ULL,
0x0000000852427812ULL, 0x000fe200078ef80bULL, 0x0000000840357824ULL, 0x000fe200078e00ffULL,
0xfffffff8314e7812ULL, 0x000fe200078ee24eULL, 0x000000010c4a7824ULL, 0x000fe200078e0233ULL,
0x0000003409317211ULL, 0x000fe200078e10ffULL, 0x0000000842337824ULL, 0x000fe200078e00ffULL,
0x000000555a4b7211ULL, 0x000fc400078e60ffULL, 0x0000003142487210ULL, 0x000fe40007ffe0ffULL,
0xfffffff8364d7812ULL, 0x000fe200078ee24dULL, 0x000130004b4b7836ULL, 0x000fe20000000000ULL,
0xfffffff833337812ULL, 0x000fe400078ee248ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee232ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160bULL,
0x00000002ff00723eULL, 0x000fe400000010ffULL, 0x0000000803317810ULL, 0x000fe40007ffe0ffULL,
0x0000541000307816ULL, 0x000fca0000000000ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130007589ULL, 0x0002e400000e0000ULL, 0x0000001033507824ULL, 0x000fe200078e024aULL,
0x0000004b4f447211ULL, 0x000fe200078e20ffULL, 0x00000006324c7836ULL, 0x000fe40000000000ULL,
0x000000104e3c7824ULL, 0x100fe200078e024bULL, 0x011000005030783bULL, 0x0022e20000000200ULL,
0x000000104d387824ULL, 0x000fe200078e024bULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0xfffffff8354c7812ULL, 0x000fe200078ee24cULL, 0x000000003838783bULL, 0x000f220000004200ULL,
0x0000001040407812ULL, 0x000fe200078efcffULL, 0x0000000248487836ULL, 0x000fe20000000000ULL,
0x0000004b4c347211ULL, 0x000fe200078e20ffULL, 0x000000004444783bULL, 0x000fe40000004200ULL,
0x0000000840497824ULL, 0x000fe400078e00ffULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x000000383020723cULL, 0x018fec0000041820ULL,
0x0000003a3024723cULL, 0x000fe20000041824ULL, 0x0000000842397824ULL, 0x000fe200078e00ffULL,
0x000000400b387211ULL, 0x000fc800078fe0ffULL, 0xfffffff839397812ULL, 0x000fe200078ee248ULL,
0x000000343028723cULL, 0x022fe20000041828ULL, 0x0000000238487836ULL, 0x000fe20000000000ULL,
0x0000000438427810ULL, 0x000fe20007ffe0ffULL, 0x00000008403b7824ULL, 0x040fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee238ULL, 0x00000010394a7824ULL, 0x000fe200078e024aULL,
0x000000443010723cULL, 0x000fe20000041810ULL, 0x0000000340357819ULL, 0x000fe400000006ffULL,
0xfffffff83b427812ULL, 0x000fe200078ee242ULL, 0x0000001049397824ULL, 0x000fe200078e024bULL,
0xfffffff835487812ULL, 0x000fe200078ee248ULL, 0x000000463014723cULL, 0x000fe20000041814ULL,
0x0000000638407810ULL, 0x000fc60007ffe0ffULL, 0x0000001048447824ULL, 0x000fe400078e024bULL,
0x0000003c3018723cULL, 0x000fec0000041818ULL, 0x0000003e301c723cULL, 0x000fe2000004181cULL,
0x0000004b423c7211ULL, 0x000fca00078e20ffULL, 0x00000036302c723cULL, 0x000fe2000004182cULL,
0x011000004a30783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0xfffffff835407812ULL, 0x000fe200078ee240ULL,
0x000000004444783bULL, 0x000f220000004200ULL, 0x0000000559057221ULL, 0x000fe20000010000ULL,
0x000000ffff587224ULL, 0x000fe200078e0053ULL, 0x000000015a5a7812ULL, 0x000fe200078e0cffULL,
0x0000001040347824ULL, 0x000fe200078e024bULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000003938783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000443018723cULL, 0x018fec0000041818ULL, 0x00000046301c723cULL, 0x000fec000004181cULL,
0x0000003c3020723cULL, 0x022fec0000041820ULL, 0x0000003e3024723cULL, 0x000fec0000041824ULL,
0x000000383010723cULL, 0x000fe20000041810ULL, 0x00000001003e7802ULL, 0x000fca0000000f00ULL,
0x0000003a3014723cULL, 0x000fe20000041814ULL, 0x0000000243387824ULL, 0x000fca00078e00ffULL,
0x000000343028723cULL, 0x004fe20000041828ULL, 0xfffffff8384b7812ULL, 0x000fca00078ec0ffULL,
0x00000036302c723cULL, 0x000fe2000004182cULL, 0x000000010c4b7824ULL, 0x000fc800078e024bULL,
0x01b6883e4bff79a7ULL, 0x0003e4000850003fULL, 0x0000004041307811ULL, 0x000fc800078e40ffULL,
0x0000000f3000720cULL, 0x000fda0003f06070ULL, 0x0000004000100947ULL, 0x002fea0003800000ULL,
0x0000000141307810ULL, 0x000fe20007ffe0ffULL, 0x0000008057327836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe40000000800ULL, 0x0000000d3000720cULL, 0x000fe20003f06070ULL,
0x0000000407347c24ULL, 0x000fe2000f8e0232ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0000000400748947ULL, 0x000fea0003800000ULL, 0x00008a00ff367b82ULL, 0x000e620000000a00ULL,
0x000000ffff317224ULL, 0x000fe200078e0a32ULL, 0x00000003ff357819ULL, 0x100fe4000001160bULL,
0x000000320f307248ULL, 0x000fe40007fe0000ULL, 0x00000003063f7819ULL, 0x000fe200000006ffULL,
0x0000000135337824ULL, 0x040fe200078e020bULL, 0x0000002030327446ULL, 0x000fe20003800031ULL,
0x0000000135317824ULL, 0x000fe200078e0234ULL, 0x0000000c04307819ULL, 0x000fe200000006ffULL,
0x0000000c353d7836ULL, 0x000fe20000000000ULL, 0x00000007333a7812ULL, 0x000fe200078ec0ffULL,
0x0000000435397836ULL, 0x000fe20000000000ULL, 0x0000100030387812ULL, 0x000fe200078ec0ffULL,
0x00000010355b7836ULL, 0x000fe20000000000ULL, 0x000000323500720cULL, 0x000fe20003f06070ULL,
0x00000018355f7836ULL, 0x000fe20000000000ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee252ULL,
0x0000001c35637836ULL, 0x000fe20000000000ULL, 0x0001300055387810ULL, 0x000fe20007ffe038ULL,
0x000000083d3c7824ULL, 0x000fe200078e00ffULL, 0x0ffffff83a337812ULL, 0x000fe200078ef80bULL,
0x0000000839457824ULL, 0x000fe200078e00ffULL, 0x00000008353b7810ULL, 0x000fe20007ffe0ffULL,
0x0000010031307825ULL, 0x002fe200078e0036ULL, 0x00000014355d7810ULL, 0x000fc40007ffe0ffULL,
0x000000033b3a7819ULL, 0x000fe200000006ffULL, 0x0000001033337824ULL, 0x000fe200078e0238ULL,
0x000000323b00720cULL, 0x080fe20003f26070ULL, 0x000000103f307825ULL, 0x000fe200078e0030ULL,
0x000000323d00720cULL, 0x080fe40003f46070ULL, 0x000000325b00720cULL, 0x080fe20003f66070ULL,
0x0000000163617824ULL, 0x000fe200078e0234ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030337faeULL, 0x0003e2000c101c46ULL, 0x000000323900720cULL, 0x080fe40003f06070ULL,
0x000000325d00720cULL, 0x000fc40003f86070ULL, 0x000000325f00720cULL, 0x080fe40003fa6070ULL,
0x000000326300720cULL, 0x000fe20003fc6070ULL, 0x000000015d327824ULL, 0x100fe200078e020bULL,
0x0000003439357210ULL, 0x000fe20007ffe0ffULL, 0x000000013b317824ULL, 0x102fe200078e020bULL,
0x0000000b39307210ULL, 0x000fe20007ffe0ffULL, 0x000000013d337824ULL, 0x100fe200078e020bULL,
0x000000345b397210ULL, 0x000fe20007ffe0ffULL, 0x000000013b3b7824ULL, 0x100fe200078e0234ULL,
0xfffffff83a477812ULL, 0x000fe200078ee231ULL, 0x000000013d3d7824ULL, 0x000fe200078e0234ULL,
0xfffffff83c597812ULL, 0x000fe200078ee233ULL, 0x00000001633a7824ULL, 0x100fe200078e020bULL,
0xfffffff845457812ULL, 0x000fe200078ee230ULL, 0x000000015b307824ULL, 0x100fe200078e020bULL,
0x000000345d317210ULL, 0x000fe20007ffe0ffULL, 0x000000085d5d7824ULL, 0x000fe200078e00ffULL,
0x000000345f337210ULL, 0x000fe20007ffe0ffULL, 0x000000015f347824ULL, 0x040fe200078e020bULL,
0x000000035f5f7819ULL, 0x000fe200000006ffULL, 0x000000085b5b7824ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee232ULL, 0x0000000863637824ULL, 0x000fe200078e00ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee234ULL, 0x0000010035347825ULL, 0x000fe200078e0036ULL,
0xfffffff85b5b7812ULL, 0x000fc400078ee230ULL, 0xfffffff863637812ULL, 0x000fe200078ee23aULL,
0x000001003b3a7825ULL, 0x000fe200078e0036ULL, 0x0000003845457211ULL, 0x080fe400078e20ffULL,
0x000000385b5b7211ULL, 0x080fe200078e20ffULL, 0x0000001047477824ULL, 0x100fe200078e0238ULL,
0x0000003863637211ULL, 0x000fe200078e20ffULL, 0x0000001059597824ULL, 0x100fe400078e0238ULL,
0x000000105d5d7824ULL, 0x100fe400078e0238ULL, 0x000000105f5f7824ULL, 0x000fc400078e0238ULL,
0x000001003d3c7825ULL, 0x000fc800078e0036ULL, 0x0000010039387825ULL, 0x000fc800078e0036ULL,
0x0000010031307825ULL, 0x000fc800078e0036ULL, 0x0000010033327825ULL, 0x000fc800078e0036ULL,
0x0000010061367825ULL, 0x000fc800078e0036ULL, 0x000000103f347825ULL, 0x000fc800078e0034ULL,
0x000000103f3a7825ULL, 0x040fe200078e003aULL, 0x0000000034457faeULL, 0x0003e6000c101c46ULL,
0x000000103f3c7825ULL, 0x040fe200078e003cULL, 0x000000003a477faeULL, 0x0003e6000c901c46ULL,
0x000000103f387825ULL, 0x040fe200078e0038ULL, 0x000000003c597faeULL, 0x0003e6000d101c46ULL,
0x000000103f307825ULL, 0x040fe200078e0030ULL, 0x00000000385b7faeULL, 0x0003e6000d901c46ULL,
0x000000103f327825ULL, 0x040fe200078e0032ULL, 0x00000000305d7faeULL, 0x0003e6000e101c46ULL,
0x000000103f367825ULL, 0x000fe200078e0036ULL, 0x00000000325f7faeULL, 0x0003e8000e901c46ULL,
0x0000000036637faeULL, 0x0003e2000f101c46ULL, 0x0000000400407947ULL, 0x000fea0003800000ULL,
0x0000000c0b457811ULL, 0x040fe200078fe8ffULL, 0x0000000806677824ULL, 0x000fe200078e00ffULL,
0x000000040b377811ULL, 0x000fe400078fe8ffULL, 0x0000000345357819ULL, 0x040fe200000006ffULL,
0x0000000145327824ULL, 0x100fe200078e020bULL, 0x000000100b3b7811ULL, 0x000fe200078fe8ffULL,
0x0000000137307824ULL, 0x100fe200078e020bULL, 0x000000080b3d7811ULL, 0x000fe200078fe8ffULL,
0x0000000837337824ULL, 0x040fe200078e00ffULL, 0xfffffff8353c7812ULL, 0x000fe200078ee232ULL,
0x0000000137377824ULL, 0x100fe200078e0234ULL, 0x000000180b357811ULL, 0x000fe200078fe8ffULL,
0x000000083d3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff833387812ULL, 0x000fe200078ee230ULL,
0x000000013b307824ULL, 0x100fe200078e020bULL, 0x00000003353f7819ULL, 0x000fe200000006ffULL,
0x000000083b337824ULL, 0x000fe200078e00ffULL, 0x000000140b397811ULL, 0x000fe200078fe8ffULL,
0x0000000135327824ULL, 0x000fe200078e020bULL, 0x0000000b3d317210ULL, 0x000fe20007ffe0ffULL,
0x000000013d3d7824ULL, 0x100fe200078e0234ULL, 0xfffffff833447812ULL, 0x000fe200078ee230ULL,
0x0000000839467824ULL, 0x000fe200078e00ffULL, 0xfffffff83f587812ULL, 0x000fe200078ee232ULL,
0x000000013b3b7824ULL, 0x000fe200078e0234ULL, 0x00008a00ff327b82ULL, 0x000e620000000a00ULL,
0x0000001c0b637811ULL, 0x000fc400078fe8ffULL, 0xfffffff83a3a7812ULL, 0x000fe400078ee231ULL,
0x0000000b39317210ULL, 0x000fe20007ffe0ffULL, 0x0000000163367824ULL, 0x040fe200078e020bULL,
0x0000000c04307819ULL, 0x000fe200000006ffULL, 0x00000008633f7824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee231ULL, 0x0000000139397824ULL, 0x100fe200078e0234ULL,
0x0000000b0b317211ULL, 0x000fe200078fe8ffULL, 0x0000000163637824ULL, 0x000fe200078e0234ULL,
0xfffffff83f5a7812ULL, 0x000fc400078ee236ULL, 0x0000000731367812ULL, 0x000fe400078ec0ffULL,
0x0000100030307812ULL, 0x000fe400078ec0ffULL, 0x000000340b317211ULL, 0x000fe400078fe8ffULL,
0x0ffffff836367812ULL, 0x000fe400078ef80bULL, 0x0001300055657810ULL, 0x000fe20007ffe030ULL,
0x0000010031307825ULL, 0x002fe200078e0032ULL, 0x0000003445457210ULL, 0x000fc40007ffe0ffULL,
0x00000065363f7211ULL, 0x080fe200078e20ffULL, 0x0000010037367825ULL, 0x000fe200078e0032ULL,
0x0000003435357210ULL, 0x000fe40007ffe0ffULL, 0x000000653c5b7211ULL, 0x080fe200078e20ffULL,
0x00000010445d7824ULL, 0x000fe200078e0265ULL, 0xfffffff867677812ULL, 0x000fe200078ee252ULL,
0x000001003d3c7825ULL, 0x000fe200078e0032ULL, 0x0000006558617211ULL, 0x000fc600078e20ffULL,
0x000000103a597824ULL, 0x000fe400078e0265ULL, 0x0000010045447825ULL, 0x000fc800078e0032ULL,
0x0000001038477824ULL, 0x000fe400078e0265ULL, 0x000001003b3a7825ULL, 0x000fc800078e0032ULL,
0x0000010039387825ULL, 0x000fc800078e0032ULL, 0x0000010035347825ULL, 0x000fc800078e0032ULL,
0x0000001067307825ULL, 0x000fc800078e0030ULL, 0x0000010063327825ULL, 0x000fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303f7faeULL, 0x0003e6000b901c46ULL,
0x0000001067367825ULL, 0x000fc800078e0036ULL, 0x00000010673c7825ULL, 0x040fe200078e003cULL,
0x0000000036477faeULL, 0x0003e6000b901c46ULL, 0x0000001067447825ULL, 0x040fe200078e0044ULL,
0x000000003c597faeULL, 0x0003e6000b901c46ULL, 0x00000010673a7825ULL, 0x040fe200078e003aULL,
0x00000000445b7faeULL, 0x0003e6000b901c46ULL, 0x00000010465f7824ULL, 0x000fe200078e0265ULL,
0x000000003a5d7faeULL, 0x0003e2000b901c46ULL, 0x0000001067387825ULL, 0x000fc800078e0038ULL,
0x0000001067347825ULL, 0x040fe200078e0034ULL, 0x00000000385f7faeULL, 0x0003e6000b901c46ULL,
0x000000105a657824ULL, 0x000fe200078e0265ULL, 0x0000000034617faeULL, 0x0003e2000b901c46ULL,
0x0000001067327825ULL, 0x000fca00078e0032ULL, 0x0000000032657faeULL, 0x0003e4000b901c46ULL,
0x0000001009307824ULL, 0x002fe200078e00ffULL, 0xffffffe00a317812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x0000001030307812ULL, 0x000fc800078ec0ffULL,
0x0000000c30317210ULL, 0x000fc80007ffe031ULL, 0x0000003106357211ULL, 0x000fc800078e18ffULL,
0x01b6283e353e79a7ULL, 0x0002a6000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01b6283f350075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff347224ULL, 0x000fce00078e00ffULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230377210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003732327211ULL, 0x000fc800078110ffULL,
0x00000033ff337210ULL, 0x000fc800007fe4ffULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x01b6283f350075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000008056307810ULL, 0x000fe40007ffe054ULL,
0x0000005300587202ULL, 0x000fc60000000f00ULL, 0x0000000151307824ULL, 0x000fca00078e0230ULL,
0x01b0000030327984ULL, 0x000ea80000000800ULL, 0x01b2000030597984ULL, 0x0006e20000000800ULL,
0x000000533200720bULL, 0x004fda0003f1d000ULL, 0x0000000000337806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff33ff7812ULL, 0x000fda000782c0ffULL,
0x0000000000f89947ULL, 0x00afea0003800000ULL, 0x0000000143307811ULL, 0x000fe400078ff0ffULL,
0x000000533200720bULL, 0x000fe40003f14000ULL, 0x000000433000720cULL, 0x000fd60003f25270ULL,
0x0000000000347806ULL, 0x000fe400000e0100ULL, 0x0000008043319824ULL, 0x000fe200078e020cULL,
0x0000005332309209ULL, 0x000fc80007810000ULL, 0x0000003151359210ULL, 0x000fe40007ffe056ULL,
0x0000991034317816ULL, 0x000fc600000000ffULL, 0x01b4003035009388ULL, 0x0003e20000000800ULL,
0x000000ff3100720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005332307209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000782c0ffULL, 0x0000005330307221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x0000003000367308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x000fca000001160bULL,
0x00001f3136307589ULL, 0x006e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003605057220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x000000080b317811ULL, 0x000fca00078ff0ffULL,
0x00001f3136307589ULL, 0x002e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff34ff7812ULL, 0x000fe40007800833ULL,
0x0000005332587209ULL, 0x000fd60007810000ULL, 0x8000005832320221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b32320820ULL, 0x000fc80000410000ULL, 0x0000003200020308ULL, 0x000ea40000000800ULL,
0x0000000259590220ULL, 0x004fce0000410000ULL, 0x0000100004307824ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000100030307812ULL, 0x000fc800078e0cffULL,
0x0001300055537810ULL, 0x000fe20007ffe030ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160bULL, 0x00000002ff00723eULL, 0x000fe400000010ffULL,
0x0000000803317810ULL, 0x000fe40007ffe0ffULL, 0x0000541000307816ULL, 0x000fca0000000000ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130007589ULL, 0x0002e400000e0000ULL,
0x011800005030783bULL, 0x0022e20000000200ULL, 0x000000104f447824ULL, 0x100fe200078e0253ULL,
0x000000534d387211ULL, 0x000fe200078e20ffULL, 0x000000104e3c7824ULL, 0x000fe200078e0253ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000104c347824ULL, 0x100fe200078e0253ULL,
0x000000004444783bULL, 0x000f280000004200ULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000443010723cULL, 0x018fec0000041810ULL, 0x000000463014723cULL, 0x000fe20000041814ULL,
0x0000001049447824ULL, 0x000fca00078e0253ULL, 0x0000003c3018723cULL, 0x022fec0000041818ULL,
0x0000003e301c723cULL, 0x000fe2000004181cULL, 0x00000053483c7211ULL, 0x000fca00078e20ffULL,
0x000000383020723cULL, 0x000fec0000041820ULL, 0x0000003a3024723cULL, 0x000fe20000041824ULL,
0x0000001042387824ULL, 0x000fca00078e0253ULL, 0x000000343028723cULL, 0x004fec0000041828ULL,
0x00000036302c723cULL, 0x000fe2000004182cULL, 0x011800004a30783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x0000001040347824ULL, 0x000fe200078e0253ULL, 0x000000004444783bULL, 0x000ee20000004200ULL,
0x0000000559057221ULL, 0x000fe20000010000ULL, 0x00000001045a7812ULL, 0x000fe400078ec0ffULL,
0x000000003c3c783bULL, 0x000f280000004200ULL, 0x000000003838783bULL, 0x000f680000004200ULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x000000443010723cULL, 0x00cfec0000041810ULL,
0x000000463014723cULL, 0x000fec0000041814ULL, 0x0000003c3018723cULL, 0x010fec0000041818ULL,
0x0000003e301c723cULL, 0x000fec000004181cULL, 0x000000383020723cULL, 0x022fec0000041820ULL,
0x0000003a3024723cULL, 0x000fec0000041824ULL, 0x000000343028723cULL, 0x000fe20000041828ULL,
0x00000001003a7802ULL, 0x000fc80000000f00ULL, 0x01b6903a4bff79a7ULL, 0x0003e2000850003fULL,
0x00000036302c723cULL, 0x000fee000004182cULL, 0x0000008041307811ULL, 0x000fc800078e40ffULL,
0x0000000f3000720cULL, 0x000fda0003f06070ULL, 0x0000002800a00947ULL, 0x002fea0003800000ULL,
0x0000000141307836ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x000000c057347836ULL, 0x000fc60000000000ULL, 0x0000000d3000720cULL, 0x000fe20003f06070ULL,
0x0000000407307c24ULL, 0x000fe2000f8e0234ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0000000400688947ULL, 0x000fea0003800000ULL, 0x00008a00ff327b82ULL, 0x000e620000000a00ULL,
0x000000340f317248ULL, 0x000fe40007fe0000ULL, 0x000000ff34347210ULL, 0x000fe40007ffe1ffULL,
0x00000003ff367819ULL, 0x100fe4000001160bULL, 0x0000002031317446ULL, 0x000fe40003800034ULL,
0x00000003063b7819ULL, 0x000fe200000006ffULL, 0x0000000136347824ULL, 0x140fe200078e020bULL,
0x000000313600720cULL, 0x0c0fe20003f06070ULL, 0x0000000136357824ULL, 0x000fe200078e0230ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee252ULL, 0x0000000c363e7836ULL, 0x000fe20000000000ULL,
0x0000000734387812ULL, 0x000fe200078ec0ffULL, 0x00000010365c7836ULL, 0x000fe20000000000ULL,
0x00000008363c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001836607836ULL, 0x000fe20000000000ULL,
0x0ffffff838387812ULL, 0x000fe200078ef80bULL, 0x0000001c36627836ULL, 0x000fe20000000000ULL,
0x00000014365e7810ULL, 0x000fe20007ffe0ffULL, 0x000000013e447824ULL, 0x000fe200078e020bULL,
0x000000033c5a7819ULL, 0x040fe200000006ffULL, 0x0000010035347825ULL, 0x002fe200078e0032ULL,
0x000000313c00720cULL, 0x000fc40003f26070ULL, 0x000000313e00720cULL, 0x080fe20003f46070ULL,
0x0000001038377824ULL, 0x000fe200078e0253ULL, 0x000000315c00720cULL, 0x080fe20003f66070ULL,
0x000000103b347825ULL, 0x000fe200078e0034ULL, 0x000000315e00720cULL, 0x080fe40003f86070ULL,
0x000000316000720cULL, 0x080fe20003fa6070ULL, 0x0000000436387836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e2000c101c46ULL,
0x000000083e397824ULL, 0x000fe200078e00ffULL, 0x000000316200720cULL, 0x080fe20003fc6070ULL,
0x000000013c3d7824ULL, 0x100fe200078e0230ULL, 0x000000313800720cULL, 0x000fe20003f06070ULL,
0x000000013e3f7824ULL, 0x100fe200078e0230ULL, 0xfffffff839447812ULL, 0x000fe200078ee244ULL,
0x0000000162457824ULL, 0x000fe200078e0230ULL, 0x0000003038317210ULL, 0x000fe20007ffe0ffULL,
0x000000085c477824ULL, 0x000fe200078e00ffULL, 0x000000305c397210ULL, 0x000fe20007ffe0ffULL,
0x000000015e367824ULL, 0x100fe200078e020bULL, 0x0000000b38347210ULL, 0x002fe20007ffe0ffULL,
0x0000000838377824ULL, 0x000fe200078e00ffULL, 0x0000000360597819ULL, 0x000fe200000006ffULL,
0x000000013c357824ULL, 0x000fc400078e020bULL, 0x000000085e577824ULL, 0x000fe200078e00ffULL,
0xfffffff837467812ULL, 0x000fe200078ee234ULL, 0x000000015c347824ULL, 0x100fe200078e020bULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee235ULL, 0x0000000162387824ULL, 0x140fe200078e020bULL,
0x000000305e377210ULL, 0x000fe20007ffe0ffULL, 0x00000008625b7824ULL, 0x000fe200078e00ffULL,
0x0000003060357210ULL, 0x000fe20007ffe0ffULL, 0x0000000160307824ULL, 0x000fe200078e020bULL,
0xfffffff8475c7812ULL, 0x000fe200078ee234ULL, 0x000001003d3c7825ULL, 0x000fe200078e0032ULL,
0xfffffff8575e7812ULL, 0x000fc400078ee236ULL, 0xfffffff859607812ULL, 0x000fe200078ee230ULL,
0x0000010031307825ULL, 0x100fe200078e0032ULL, 0xfffffff85b627812ULL, 0x000fe400078ee238ULL,
0x000000535c577211ULL, 0x080fe200078e20ffULL, 0x000001003f3e7825ULL, 0x000fe200078e0032ULL,
0x00000053625d7211ULL, 0x000fc600078e20ffULL, 0x0000010039387825ULL, 0x000fc800078e0032ULL,
0x0000010037367825ULL, 0x000fc800078e0032ULL, 0x0000010035347825ULL, 0x000fc800078e0032ULL,
0x0000010045327825ULL, 0x000fe200078e0032ULL, 0x0000005346457211ULL, 0x000fc600078e20ffULL,
0x000000103b307825ULL, 0x000fc800078e0030ULL, 0x000000105a477824ULL, 0x000fe200078e0253ULL,
0x0000000030457faeULL, 0x0003e2000c101c46ULL, 0x000000103b3c7825ULL, 0x000fc800078e003cULL,
0x000000103b3e7825ULL, 0x040fe200078e003eULL, 0x000000003c477faeULL, 0x0003e6000c901c46ULL,
0x000000103b387825ULL, 0x000fc800078e0038ULL, 0x000000103b367825ULL, 0x000fc800078e0036ULL,
0x000000103b347825ULL, 0x000fc800078e0034ULL, 0x000000103b327825ULL, 0x000fc800078e0032ULL,
0x00000010443b7824ULL, 0x100fe400078e0253ULL, 0x000000105e597824ULL, 0x100fe400078e0253ULL,
0x00000010605b7824ULL, 0x000fe200078e0253ULL, 0x000000003e3b7faeULL, 0x0003e8000d101c46ULL,
0x0000000038577faeULL, 0x0003e8000d901c46ULL, 0x0000000036597faeULL, 0x0003e8000e101c46ULL,
0x00000000345b7faeULL, 0x0003e8000e901c46ULL, 0x00000000325d7faeULL, 0x0003e2000f101c46ULL,
0x0000000400347947ULL, 0x000fea0003800000ULL, 0x000000080b3f7811ULL, 0x040fe200078fe8ffULL,
0x0000000806597824ULL, 0x000fe200078e00ffULL, 0x000000040b377811ULL, 0x000fe400078fe8ffULL,
0x0000000b3f647210ULL, 0x000fe20007ffe0ffULL, 0x000000083f337824ULL, 0x000fe200078e00ffULL,
0x0000000c0b457811ULL, 0x000fe200078fe8ffULL, 0x0000000137627824ULL, 0x100fe200078e020bULL,
0x000000100b3d7811ULL, 0x000fe200078fe8ffULL, 0x0000000837317824ULL, 0x000fe200078e00ffULL,
0xfffffff833647812ULL, 0x000fe200078ee264ULL, 0x0000000145607824ULL, 0x100fe200078e020bULL,
0x00008a00ff327b82ULL, 0x000e620000000a00ULL, 0x000000140b397811ULL, 0x000fe200078fe8ffULL,
0x000000013d5e7824ULL, 0x140fe200078e020bULL, 0xfffffff831627812ULL, 0x000fe200078ee262ULL,
0x000000083d357824ULL, 0x000fe200078e00ffULL, 0x0000000345317819ULL, 0x000fe200000006ffULL,
0x00000008393b7824ULL, 0x000fe200078e00ffULL, 0x0000000b0b347211ULL, 0x000fe200078fe8ffULL,
0x0000000137377824ULL, 0x100fe200078e0230ULL, 0x000000180b367811ULL, 0x000fe200078fe8ffULL,
0x0000000145457824ULL, 0x100fe200078e0230ULL, 0x0000000b395a7210ULL, 0x000fe20007ffe0ffULL,
0x000000013d3d7824ULL, 0x000fe200078e0230ULL, 0x0000001c0b387811ULL, 0x000fe200078fe8ffULL,
0x0000000136467824ULL, 0x000fe200078e020bULL, 0xfffffff831607812ULL, 0x000fc400078ee260ULL,
0x000000300b317211ULL, 0x000fe200078fe8ffULL, 0x00000001385c7824ULL, 0x000fe200078e020bULL,
0xfffffff8355e7812ULL, 0x000fe200078ee25eULL, 0x0000000136357824ULL, 0x000fe200078e0230ULL,
0x000000303f3f7210ULL, 0x000fe40007ffe0ffULL, 0x0000003039397210ULL, 0x000fe20007ffe0ffULL,
0x0000010045447825ULL, 0x002fe200078e0032ULL, 0x0000000734347812ULL, 0x000fe400078ec0ffULL,
0xfffffff83b5a7812ULL, 0x000fe200078ee25aULL, 0x00000001383b7824ULL, 0x000fe200078e0230ULL,
0x0000000336477819ULL, 0x000fe200000006ffULL, 0x0000010031307825ULL, 0x000fe200078e0032ULL,
0x0000000338577819ULL, 0x000fc400000006ffULL, 0x0ffffff834667812ULL, 0x000fe200078ef80bULL,
0x0000010037367825ULL, 0x100fe200078e0032ULL, 0xfffffff859597812ULL, 0x000fe400078ee252ULL,
0xfffffff847467812ULL, 0x000fe200078ee246ULL, 0x000001003f3e7825ULL, 0x100fe200078e0032ULL,
0xfffffff8575c7812ULL, 0x000fe400078ee25cULL, 0x0000005362477211ULL, 0x080fe200078e20ffULL,
0x000001003d3c7825ULL, 0x000fe200078e0032ULL, 0x000000535e5b7211ULL, 0x000fc400078e20ffULL,
0x000000535c617211ULL, 0x000fe200078e20ffULL, 0x0000010039387825ULL, 0x000fc800078e0032ULL,
0x0000010035347825ULL, 0x000fc800078e0032ULL, 0x000001003b327825ULL, 0x000fc800078e0032ULL,
0x0000001059307825ULL, 0x000fc800078e0030ULL, 0x00000010663b7824ULL, 0x000fe400078e0253ULL,
0x0000001059367825ULL, 0x000fc600078e0036ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303b7faeULL, 0x0003e2000b901c46ULL, 0x0000001064577824ULL, 0x000fe400078e0253ULL,
0x00000010593e7825ULL, 0x040fe200078e003eULL, 0x0000000036477faeULL, 0x0003e6000b901c46ULL,
0x0000001059447825ULL, 0x040fe200078e0044ULL, 0x000000003e577faeULL, 0x0003e6000b901c46ULL,
0x00000010593c7825ULL, 0x000fc800078e003cULL, 0x0000001059387825ULL, 0x000fc800078e0038ULL,
0x0000001059347825ULL, 0x000fc800078e0034ULL, 0x0000001059327825ULL, 0x000fc800078e0032ULL,
0x0000001060597824ULL, 0x100fe400078e0253ULL, 0x000000105a5d7824ULL, 0x100fe400078e0253ULL,
0x00000010465f7824ULL, 0x000fe200078e0253ULL, 0x0000000044597faeULL, 0x0003e8000b901c46ULL,
0x000000003c5b7faeULL, 0x0003e8000b901c46ULL, 0x00000000385d7faeULL, 0x0003e8000b901c46ULL,
0x00000000345f7faeULL, 0x0003e8000b901c46ULL, 0x0000000032617faeULL, 0x0003e4000b901c46ULL,
0xffffffe00a337812ULL, 0x042fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100a307812ULL, 0x040fe400078ec0ffULL, 0x000000080a317812ULL, 0x000fe400078ec0ffULL,
0x0000000c30307210ULL, 0x000fca0007ffe033ULL, 0x0000000130357824ULL, 0x000fc800078e0231ULL,
0x01b6483a353a79a7ULL, 0x0002a6000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01b6483b350075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff347224ULL, 0x000fce00078e00ffULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230377210ULL, 0x000fc80007f1e1ffULL, 0x0000003331337210ULL, 0x000fe400007fe5ffULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003732327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x01b6483b350075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000010056307810ULL, 0x000fe20007ffe054ULL,
0x000000ffff577224ULL, 0x000fc600078e0058ULL, 0x0000003051307210ULL, 0x000fca0007ffe0ffULL,
0x01b0000030317984ULL, 0x000ea80000000800ULL, 0x01b2000030597984ULL, 0x0006e20000000800ULL,
0x000000583100720bULL, 0x004fda0003f1d000ULL, 0x0000000000337806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff33ff7812ULL, 0x000fda000782c0ffULL,
0x0000000000f89947ULL, 0x00afea0003800000ULL, 0x0000000243307811ULL, 0x000fe400078ff0ffULL,
0x000000583100720bULL, 0x000fe40003f14000ULL, 0x000000433000720cULL, 0x000fd60003f25270ULL,
0x0000000000347806ULL, 0x000fe400000e0100ULL, 0x0000008043329824ULL, 0x000fe200078e020cULL,
0x0000003158309209ULL, 0x000fc80007810000ULL, 0x0000003251359210ULL, 0x000fe40007ffe056ULL,
0x0000991034327816ULL, 0x000fc600000000ffULL, 0x01b4003035009388ULL, 0x0003e20000000800ULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000003158357209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000782c0ffULL, 0x8000003558307221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x0000003000327308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff357819ULL, 0x000fca000001160bULL,
0x00001f3532307589ULL, 0x006e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003205057220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x000000080b357811ULL, 0x000fca00078ff0ffULL,
0x00001f3532307589ULL, 0x002e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff34ff7812ULL, 0x000fe40007800833ULL,
0x0000003158577209ULL, 0x000fd60007810000ULL, 0x8000005731310221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100020308ULL, 0x000ea40000000800ULL,
0x0000000259590220ULL, 0x004fce0000410000ULL, 0x0000000c04307819ULL, 0x002fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000100030307812ULL, 0x000fc800078ec0ffULL,
0x0001300055557810ULL, 0x000fe20007ffe030ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160bULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803317836ULL, 0x000fe20000000000ULL, 0x0000541000307816ULL, 0x000fca0000000000ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130007589ULL, 0x0002e400000e0000ULL,
0x012000005030783bULL, 0x0022e20000000200ULL, 0x000000104f447824ULL, 0x100fe200078e0255ULL,
0x000000554e3c7211ULL, 0x000fe200078e20ffULL, 0x000000104d387824ULL, 0x000fe200078e0255ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000104c347824ULL, 0x000fe200078e0255ULL,
0x000000004444783bULL, 0x000f280000004200ULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000443010723cULL, 0x018fec0000041810ULL, 0x000000463014723cULL, 0x000fe20000041814ULL,
0x0000005549447211ULL, 0x000fca00078e20ffULL, 0x0000003c3018723cULL, 0x022fec0000041818ULL,
0x0000003e301c723cULL, 0x000fe2000004181cULL, 0x00000010483d7824ULL, 0x000fca00078e0255ULL,
0x000000383020723cULL, 0x000fec0000041820ULL, 0x0000003a3024723cULL, 0x000fe20000041824ULL,
0x0000001042387824ULL, 0x000fca00078e0255ULL, 0x000000343028723cULL, 0x004fec0000041828ULL,
0x00000036302c723cULL, 0x000fe2000004182cULL, 0x012000004a30783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x0000005540347211ULL, 0x000fe200078e20ffULL, 0x000000004444783bULL, 0x000ee20000004200ULL,
0x0000000559057221ULL, 0x000fe20000010000ULL, 0x00000001045a7812ULL, 0x000fe200078e0cffULL,
0x000000ffff587224ULL, 0x000fe200078e0057ULL, 0x000000003d3c783bULL, 0x000f280000004200ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x000000443010723cULL, 0x00cfec0000041810ULL, 0x000000463014723cULL, 0x000fec0000041814ULL,
0x0000003c3018723cULL, 0x010fec0000041818ULL, 0x0000003e301c723cULL, 0x000fe2000004181cULL,
0x00000001ff3c7424ULL, 0x000fc800078e00ffULL, 0x01b6983c4bff79a7ULL, 0x0005e2000850003fULL,
0x000000383020723cULL, 0x022fec0000041820ULL, 0x0000003a3024723cULL, 0x000fec0000041824ULL,
0x000000343028723cULL, 0x000fec0000041828ULL, 0x00000036302c723cULL, 0x000fee000004182cULL,
0x000000c041307811ULL, 0x000fc800078e40ffULL, 0x0000000f3000720cULL, 0x000fda0003f06070ULL,
0x0000001400440947ULL, 0x004fea0003800000ULL, 0x000000410e317210ULL, 0x000fe20007ffe0ffULL,
0x00008e0000047ab9ULL, 0x000fc80000000800ULL, 0x0000000131307836ULL, 0x000fe40000000000ULL,
0x0000010031347824ULL, 0x000fc600078e0208ULL, 0x0000000d3000720cULL, 0x000fe20003f06070ULL,
0x0000000407307c24ULL, 0x000fe2000f8e0234ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0000000400688947ULL, 0x000fea0003800000ULL, 0x00008a00ff327b82ULL, 0x000e620000000a00ULL,
0x000000340f317248ULL, 0x000fe40007fe0000ULL, 0x000000ff34347210ULL, 0x000fe40007ffe1ffULL,
0x00000003ff367819ULL, 0x100fe4000001160bULL, 0x0000002031317446ULL, 0x000fe40003800034ULL,
0x00000003063d7819ULL, 0x000fe200000006ffULL, 0x0000000136347824ULL, 0x040fe200078e020bULL,
0x000000313600720cULL, 0x0c0fe20003f06070ULL, 0x0000000136357824ULL, 0x000fe200078e0230ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee252ULL, 0x0000000c363e7836ULL, 0x000fe20000000000ULL,
0x0000000734387812ULL, 0x000fe200078ec0ffULL, 0x0000001036467836ULL, 0x000fe20000000000ULL,
0x00000008363a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001836587836ULL, 0x000fe20000000000ULL,
0x0ffffff838387812ULL, 0x000fe200078ef80bULL, 0x0000001c365a7836ULL, 0x000fe20000000000ULL,
0x0000001436527810ULL, 0x000fe20007ffe0ffULL, 0x000000083e447824ULL, 0x000fe200078e00ffULL,
0x000000313a00720cULL, 0x080fe20003f26070ULL, 0x0000010035347825ULL, 0x002fe200078e0032ULL,
0x000000313e00720cULL, 0x000fc40003f46070ULL, 0x000000314600720cULL, 0x080fe20003f66070ULL,
0x0000001038377824ULL, 0x000fe200078e0255ULL, 0x000000315200720cULL, 0x080fe20003f86070ULL,
0x000000103d347825ULL, 0x000fe200078e0034ULL, 0x000000315800720cULL, 0x080fe40003fa6070ULL,
0x000000315a00720cULL, 0x080fe20003fc6070ULL, 0x0000000436387836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e2000c101c46ULL,
0x000000033a367819ULL, 0x000fe200000006ffULL, 0x000000013e3f7824ULL, 0x100fe200078e0230ULL,
0x00000030463b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000838397824ULL, 0x040fe200078e00ffULL,
0x000000313800720cULL, 0x000fe20003f06070ULL, 0x000000015a617824ULL, 0x000fe200078e0230ULL,
0x0000003058317210ULL, 0x000fe20007ffe0ffULL, 0x0000000852477824ULL, 0x000fe200078e00ffULL,
0x0000000358597819ULL, 0x000fe200000006ffULL, 0x0000000846457824ULL, 0x000fc400078e00ffULL,
0x000000013a357824ULL, 0x102fe200078e020bULL, 0x0000000b38347210ULL, 0x000fe20007ffe0ffULL,
0x000000013e377824ULL, 0x100fe400078e020bULL, 0x000000015a3e7824ULL, 0x100fe200078e020bULL,
0xfffffff839347812ULL, 0x000fe200078ee234ULL, 0x000000013a397824ULL, 0x000fe200078e0230ULL,
0xfffffff836367812ULL, 0x000fe200078ee235ULL, 0x00000001523a7824ULL, 0x100fe200078e020bULL,
0xfffffff844447812ULL, 0x000fe200078ee237ULL, 0x000000085a5b7824ULL, 0x000fe200078e00ffULL,
0x0000003038357210ULL, 0x000fe20007ffe0ffULL, 0x0000000146387824ULL, 0x100fe200078e020bULL,
0x0000003052377210ULL, 0x000fe20007ffe0ffULL, 0x0000000158307824ULL, 0x000fe200078e020bULL,
0xfffffff8473a7812ULL, 0x000fe200078ee23aULL, 0x0000001036477824ULL, 0x000fe200078e0255ULL,
0xfffffff845387812ULL, 0x000fe200078ee238ULL, 0x0000010037367825ULL, 0x000fe200078e0032ULL,
0xfffffff859307812ULL, 0x000fc400078ee230ULL, 0xfffffff85b3e7812ULL, 0x000fe200078ee23eULL,
0x0000001044597824ULL, 0x100fe200078e0255ULL, 0x0000005534457211ULL, 0x080fe200078e20ffULL,
0x000000103a5d7824ULL, 0x100fe200078e0255ULL, 0x00000055385b7211ULL, 0x080fe200078e20ffULL,
0x00000010305f7824ULL, 0x000fe200078e0255ULL, 0x000000553e557211ULL, 0x000fe200078e20ffULL,
0x0000010035347825ULL, 0x000fc800078e0032ULL, 0x0000010039387825ULL, 0x000fc800078e0032ULL,
0x000001003f3e7825ULL, 0x000fc800078e0032ULL, 0x000001003b3a7825ULL, 0x000fc800078e0032ULL,
0x0000010031307825ULL, 0x000fc800078e0032ULL, 0x0000010061327825ULL, 0x000fc800078e0032ULL,
0x000000103d347825ULL, 0x000fc800078e0034ULL, 0x000000103d387825ULL, 0x040fe200078e0038ULL,
0x0000000034457faeULL, 0x0003e6000c101c46ULL, 0x000000103d3e7825ULL, 0x040fe200078e003eULL,
0x0000000038477faeULL, 0x0003e6000c901c46ULL, 0x000000103d3a7825ULL, 0x040fe200078e003aULL,
0x000000003e597faeULL, 0x0003e6000d101c46ULL, 0x000000103d367825ULL, 0x040fe200078e0036ULL,
0x000000003a5b7faeULL, 0x0003e6000d901c46ULL, 0x000000103d307825ULL, 0x040fe200078e0030ULL,
0x00000000365d7faeULL, 0x0003e6000e101c46ULL, 0x000000103d327825ULL, 0x000fe200078e0032ULL,
0x00000000305f7faeULL, 0x0003e8000e901c46ULL, 0x0000000032557faeULL, 0x0003e2000f101c46ULL,
0x0000000400347947ULL, 0x000fea0003800000ULL, 0x000000080b3f7811ULL, 0x040fe200078fe8ffULL,
0x00000008063d7824ULL, 0x000fe200078e00ffULL, 0x000000100b357811ULL, 0x040fe400078fe8ffULL,
0x0000000c0b457811ULL, 0x000fe200078fe8ffULL, 0x000000013f327824ULL, 0x100fe200078e020bULL,
0x0000000335397819ULL, 0x000fe200000006ffULL, 0x000000083f377824ULL, 0x000fe200078e00ffULL,
0x0000000b45337210ULL, 0x000fe20007ffe0ffULL, 0x0000000135367824ULL, 0x100fe200078e020bULL,
0x000000040b3b7811ULL, 0x000fe200078fe8ffULL, 0x00000008453a7824ULL, 0x000fe200078e00ffULL,
0xfffffff837387812ULL, 0x000fe200078ee232ULL, 0x000000013f3f7824ULL, 0x100fe200078e0230ULL,
0xfffffff8393e7812ULL, 0x000fe200078ee236ULL, 0x000000013b317824ULL, 0x000fe200078e020bULL,
0x00008a00ff367b82ULL, 0x000e620000000a00ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee233ULL,
0x0000000135357824ULL, 0x000fe200078e0230ULL, 0x000000140b337811ULL, 0x000fc400078fe8ffULL,
0x000000033b347819ULL, 0x040fe200000006ffULL, 0x000000013b3b7824ULL, 0x000fe200078e0230ULL,
0x000000180b397811ULL, 0x000fe200078fe8ffULL, 0x0000000133327824ULL, 0x040fe200078e020bULL,
0xfffffff834347812ULL, 0x000fe200078ee231ULL, 0x0000000833597824ULL, 0x000fe200078e00ffULL,
0x0000000b0b317211ULL, 0x000fe200078fe8ffULL, 0x00000008395b7824ULL, 0x000fe200078e00ffULL,
0x0000001c0b657811ULL, 0x000fe200078fe8ffULL, 0x000000103a5d7824ULL, 0x000fe200078e0255ULL,
0xfffffff859447812ULL, 0x000fc400078ee232ULL, 0x0000000731327812ULL, 0x000fe200078ec0ffULL,
0x0000000133317824ULL, 0x000fe200078e0230ULL, 0x0000000b39467210ULL, 0x000fe20007ffe0ffULL,
0x0000000165477824ULL, 0x000fe200078e020bULL, 0x0000003039337210ULL, 0x000fe20007ffe0ffULL,
0x0000001044617824ULL, 0x000fe200078e0255ULL, 0x000000300b397211ULL, 0x000fe200078fe8ffULL,
0x000001003b3a7825ULL, 0x002fe200078e0036ULL, 0xfffffff85b467812ULL, 0x000fe400078ee246ULL,
0x0000003045457210ULL, 0x000fe20007ffe0ffULL, 0x00000010385b7824ULL, 0x000fe200078e0255ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee252ULL, 0x0000010039387825ULL, 0x000fe200078e0036ULL,
0x0000000365527819ULL, 0x000fc400000006ffULL, 0x0ffffff832327812ULL, 0x000fe200078ef80bULL,
0x0000000165657824ULL, 0x000fe200078e0230ULL, 0x000000553e5f7211ULL, 0x080fe200078e20ffULL,
0x000001003f3e7825ULL, 0x100fe200078e0036ULL, 0x0000005534597211ULL, 0x000fe400078e20ffULL,
0xfffffff852527812ULL, 0x000fe200078ee247ULL, 0x0000010045447825ULL, 0x000fc800078e0036ULL,
0x0000010035347825ULL, 0x000fc800078e0036ULL, 0x0000001032477824ULL, 0x000fe400078e0255ULL,
0x0000010031307825ULL, 0x000fc800078e0036ULL, 0x0000010033327825ULL, 0x000fc800078e0036ULL,
0x000000103d387825ULL, 0x000fc800078e0038ULL, 0x0000010065367825ULL, 0x000fe200078e0036ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038477faeULL, 0x0003e6000b901c46ULL,
0x000000103d3a7825ULL, 0x000fc800078e003aULL, 0x000000103d3e7825ULL, 0x040fe200078e003eULL,
0x000000003a597faeULL, 0x0003e6000b901c46ULL, 0x000000103d447825ULL, 0x040fe200078e0044ULL,
0x000000003e5b7faeULL, 0x0003e6000b901c46ULL, 0x000000103d347825ULL, 0x040fe200078e0034ULL,
0x00000000445d7faeULL, 0x0003e6000b901c46ULL, 0x000000103d307825ULL, 0x040fe200078e0030ULL,
0x00000000345f7faeULL, 0x0003e6000b901c46ULL, 0x0000001046637824ULL, 0x000fe200078e0255ULL,
0x0000005552557211ULL, 0x000fe200078e20ffULL, 0x000000103d327825ULL, 0x040fe200078e0032ULL,
0x0000000030617faeULL, 0x0003e6000b901c46ULL, 0x000000103d367825ULL, 0x000fe200078e0036ULL,
0x0000000032637faeULL, 0x0003e8000b901c46ULL, 0x0000000036557faeULL, 0x0003e4000b901c46ULL,
0xffffffe00a317812ULL, 0x042fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100a307812ULL, 0x040fe400078ec0ffULL, 0x000000080a327812ULL, 0x000fe400078ec0ffULL,
0x0000000c30317210ULL, 0x000fca0007ffe031ULL, 0x0000000131377824ULL, 0x000fc800078e0232ULL,
0x01b6683c373c79a7ULL, 0x0002a6000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01b6683d370075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff347224ULL, 0x000fce00078e00ffULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230357210ULL, 0x000fc80007f1e1ffULL, 0x0000003331337210ULL, 0x000fe400007fe5ffULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x01b6683d370075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000018056547810ULL, 0x000fe20007ffe054ULL,
0x000000ffff587224ULL, 0x000fc600078e0057ULL, 0x0000005451547210ULL, 0x000fca0007ffe0ffULL,
0x01b0000054307984ULL, 0x000ea80000000800ULL, 0x01b2000054527984ULL, 0x0006e20000000800ULL,
0x000000573000720bULL, 0x004fda0003f1d000ULL, 0x0000000000317806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff31337812ULL, 0x000fda000782c0ffULL,
0x0000000000f49947ULL, 0x00afea0003800000ULL, 0x0000000343327811ULL, 0x000fe400078ff0ffULL,
0x000000573000720bULL, 0x000fe40003f34000ULL, 0x000000433200720cULL, 0x000fe40003f45270ULL,
0x0000005730587209ULL, 0x000fd20007810000ULL, 0x0000000000327806ULL, 0x000fe400008e0100ULL,
0x000000804331a824ULL, 0x000fca00078e020cULL, 0x000000315151a210ULL, 0x000fe40007ffe056ULL,
0x0000991032317816ULL, 0x000fc600000000ffULL, 0x01b400585100a388ULL, 0x0003e20000000800ULL,
0x000000ff3100720cULL, 0x000fda0003f25270ULL, 0x0000000000b09947ULL, 0x002fea0003800000ULL,
0x0000005758317221ULL, 0x000fe20000010100ULL, 0x000000ff32ff7812ULL, 0x040fe4000782c0ffULL,
0x0000ff0032ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x0000003100347308ULL, 0x0002ac0000000800ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x002fcc000001160bULL, 0x00001f3134317589ULL, 0x004e6400000e0000ULL,
0x0000003110107220ULL, 0x082fe20000410000ULL, 0x0000003111117220ULL, 0x080fe20000410000ULL,
0x0000003114147220ULL, 0x080fe20000410000ULL, 0x0000003115157220ULL, 0x080fe20000410000ULL,
0x0000003118187220ULL, 0x080fe20000410000ULL, 0x0000003119197220ULL, 0x080fe20000410000ULL,
0x000000311c1c7220ULL, 0x080fe20000410000ULL, 0x000000311d1d7220ULL, 0x080fe20000410000ULL,
0x0000003120207220ULL, 0x080fe20000410000ULL, 0x0000003121217220ULL, 0x080fe20000410000ULL,
0x0000003124247220ULL, 0x080fe20000410000ULL, 0x0000003125257220ULL, 0x080fe20000410000ULL,
0x0000003128287220ULL, 0x080fe20000410000ULL, 0x0000003129297220ULL, 0x080fe20000410000ULL,
0x000000312c2c7220ULL, 0x080fe20000410000ULL, 0x000000312d2d7220ULL, 0x000fce0000410000ULL,
0x0000003405057220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080b317811ULL, 0x002fcc00078ff0ffULL, 0x00001f3134317589ULL, 0x000e6400000e0000ULL,
0x0000003112127220ULL, 0x082fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x000000311a1a7220ULL, 0x080fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x0000003126267220ULL, 0x080fe20000410000ULL, 0x0000003127277220ULL, 0x080fe20000410000ULL,
0x000000312a2a7220ULL, 0x080fe20000410000ULL, 0x000000312b2b7220ULL, 0x080fe20000410000ULL,
0x000000312e2e7220ULL, 0x080fe20000410000ULL, 0x000000312f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff33ff7812ULL, 0x000fda0007826032ULL, 0x0000003058301221ULL, 0x000fe20000010100ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b30301820ULL, 0x000fc80000410000ULL,
0x0000003000021308ULL, 0x000ea40000000800ULL, 0x0000000252521220ULL, 0x004fce0000410000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000534d387211ULL, 0x000fe200078e20ffULL,
0x000000104e3c7824ULL, 0x100fe400078e0253ULL, 0x000000104f447824ULL, 0x000fe200078e0253ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160bULL,
0x00000002ff00723eULL, 0x000fe400000010ffULL, 0x0000000803317810ULL, 0x002fe40007ffe0ffULL,
0x0000541000307816ULL, 0x000fca0000000000ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130007589ULL, 0x0002e400000e0000ULL, 0x012800005030783bULL, 0x0022e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000031317232ULL, 0x080fe40000200000ULL,
0x0000000033337232ULL, 0x000fce0000200000ULL, 0x000000104c347824ULL, 0x100fe200078e0253ULL,
0x000000004444783bULL, 0x000f280000004200ULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000443010723cULL, 0x018fec0000041810ULL, 0x000000463014723cULL, 0x000fe20000041814ULL,
0x0000001049447824ULL, 0x000fca00078e0253ULL, 0x0000003c3018723cULL, 0x022fec0000041818ULL,
0x0000003e301c723cULL, 0x000fe2000004181cULL, 0x00000053483c7211ULL, 0x000fca00078e20ffULL,
0x000000383020723cULL, 0x000fec0000041820ULL, 0x0000003a3024723cULL, 0x000fe20000041824ULL,
0x0000001042397824ULL, 0x000fca00078e0253ULL, 0x000000343028723cULL, 0x004fec0000041828ULL,
0x00000036302c723cULL, 0x000fe2000004182cULL, 0x012800004a30783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000031317232ULL, 0x080fe40000200000ULL, 0x0000000033337232ULL, 0x000fce0000200000ULL,
0x000000003938783bULL, 0x000ee20000004200ULL, 0x0000001040347824ULL, 0x000fe400078e0253ULL,
0x0000000552057221ULL, 0x000fe20000010000ULL, 0x00000001045a7812ULL, 0x000fe200078ec0ffULL,
0x000000004444783bULL, 0x000f280000004200ULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x000000383020723cULL, 0x00cfec0000041820ULL,
0x000000443010723cULL, 0x010fe20000041810ULL, 0x0000000100387802ULL, 0x000fc80000000f00ULL,
0x01b6a0384bff79a7ULL, 0x0005e2000850003fULL, 0x000000463014723cULL, 0x000fec0000041814ULL,
0x0000003c3018723cULL, 0x022fec0000041818ULL, 0x0000003e301c723cULL, 0x000fec000004181cULL,
0x0000003a3024723cULL, 0x000fec0000041824ULL, 0x000000343028723cULL, 0x000fec0000041828ULL,
0x00000036302c723cULL, 0x004fde000004182cULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000010e417824ULL, 0x000fca00078e0241ULL, 0x0000000d4100720cULL, 0x000fda0003f06070ULL,
0xffffffa400708947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000e620000002500ULL,
0x000000ffff357224ULL, 0x000fe200078e002dULL, 0x0000002c00347202ULL, 0x000fe20000000f00ULL,
0x000000ffff337224ULL, 0x000fe200078e0029ULL, 0x0000002700307202ULL, 0x000fe20000000f00ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0025ULL, 0x0000002100257202ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe200078e0023ULL, 0x0000001e00217202ULL, 0x000fe20000000f00ULL,
0x000000ffff317224ULL, 0x000fe200078e0026ULL, 0x0000001b001e7202ULL, 0x000fe20000000f00ULL,
0x000000ffff237224ULL, 0x000fe200078e001fULL, 0x00000024002c7202ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fc400078e001dULL, 0x000000ffff267224ULL, 0x000fe200078e001cULL,
0x00000018001c7202ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe200078e0028ULL,
0x0000001300187202ULL, 0x000fe20000000f00ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001aULL,
0x000000ffff1b7224ULL, 0x000fe400078e0019ULL, 0x000000ffff277224ULL, 0x000fe400078e0022ULL,
0x000000ffff287224ULL, 0x000fc400078e0020ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0017ULL,
0x000000ffff197224ULL, 0x000fe400078e0016ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0012ULL,
0x0000000d0200720cULL, 0x002fda0003f06070ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x0180000005007836ULL, 0x000fca0000000000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x000070c0000a7802ULL, 0x000fce0000000f00ULL, 0x0000009800887944ULL, 0x000fea0003c00000ULL,
0x0000000300007202ULL, 0x00cfe20000000f00ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000500007308ULL, 0x000e640000001000ULL, 0xbf80000000037423ULL, 0x002fc80000000005ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000047919ULL, 0x000ea40000000000ULL, 0x00000002ff037819ULL, 0x004fe40000011604ULL,
0x0000000804077811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0700047589ULL, 0x000ee200000e0000ULL,
0x0000001003107220ULL, 0x044fe20000410000ULL, 0x0000001103117220ULL, 0x040fe20000410000ULL,
0x0000001403147220ULL, 0x040fe20000410000ULL, 0x0000001503157220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000002803287220ULL, 0x040fe20000410000ULL, 0x0000002503257220ULL, 0x040fe20000410000ULL,
0x0000002c032c7220ULL, 0x040fe20000410000ULL, 0x0000002d032d7220ULL, 0x040fe20000410000ULL,
0x0000003203327220ULL, 0x040fe20000410000ULL, 0x0000003303337220ULL, 0x040fe20000410000ULL,
0x0000003403347220ULL, 0x040fe20000410000ULL, 0x0000003503357220ULL, 0x000fe20000410000ULL,
0x0000000f040f7220ULL, 0x048fe20000410000ULL, 0x0000001804187220ULL, 0x040fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x000fce0000410000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x0000000f1818723eULL, 0x000fe400000010ffULL,
0x0000001c1b12723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000101110723eULL, 0x000fc400000010ffULL, 0x00000021231b723eULL, 0x000fe400000010ffULL,
0x000000141511723eULL, 0x000fe400000010ffULL, 0x000000282514723eULL, 0x000fe400000010ffULL,
0x0000002c2d15723eULL, 0x000fe400000010ffULL, 0x000000323316723eULL, 0x000fe400000010ffULL,
0x000000343517723eULL, 0x000fc400000010ffULL, 0x000000191a19723eULL, 0x000fe400000010ffULL,
0x0000001d1e1a723eULL, 0x000fe400000010ffULL, 0x00000027291c723eULL, 0x000fe400000010ffULL,
0x00000031301d723eULL, 0x000fe400000010ffULL, 0x00000003ff047819ULL, 0x104fe20000011607ULL,
0x0000000108217824ULL, 0x000fe200078e0207ULL, 0xfffffff8ff037812ULL, 0x000fc400078ee207ULL,
0x0000000304007812ULL, 0x000fe400078ec0ffULL, 0x0000000303137819ULL, 0x000fe200000006ffULL,
0x00000008030b7836ULL, 0x000fe20000000000ULL, 0x0000002a2b1e723eULL, 0x000fe200000010ffULL,
0x00000008030a7824ULL, 0x000fe200078e00ffULL, 0x000000010e00780cULL, 0x000fe20003f05270ULL,
0x0000000100037824ULL, 0x040fe200078e0203ULL, 0x000000030b227819ULL, 0x040fe200000006ffULL,
0x00000001000d7824ULL, 0x000fe400078e020bULL, 0x000000080b247824ULL, 0x000fe200078e00ffULL,
0x0000000c030b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000403007836ULL, 0x000fe20000000000ULL,
0xfffffff80a0a7812ULL, 0x000fc400078ee203ULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x00000800090b7824ULL, 0x000fe200078e00ffULL, 0xfffffff813207812ULL, 0x000fe200078ee200ULL,
0x0000100006007824ULL, 0x000fe200078e020cULL, 0xfffffff822227812ULL, 0x000fe200078ee20dULL,
0x000000ff00037306ULL, 0x000ea20000202400ULL, 0x000000261f13723eULL, 0x000fe400000010ffULL,
0x0000000b000f7210ULL, 0x000fe40007ffe0ffULL, 0x0000002e2f1f723eULL, 0x000fc400000010ffULL,
0x0000000f22227211ULL, 0x000fe200078e20ffULL, 0x000000100a0a7824ULL, 0x100fe200078e020fULL,
0x0000000021257211ULL, 0x000fe200078e20ffULL, 0x0000001020207824ULL, 0x100fe400078e020fULL,
0x0000001024247824ULL, 0x000fe200078e020fULL, 0x000000100a007844ULL, 0x000fe80000000200ULL,
0x0000001420007844ULL, 0x000fe80000000200ULL, 0x0000001822007844ULL, 0x000fe80000000200ULL,
0x0000001c24007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000025287984ULL, 0x000ea80000000c00ULL, 0x0004000025307984ULL, 0x000ee80000000c00ULL,
0x00080000252c7984ULL, 0x000f280000000c00ULL, 0x000c000025347984ULL, 0x000f620000000c00ULL,
0x0000002b032b7230ULL, 0x004fc40000200800ULL, 0x0000002a032a7230ULL, 0x040fe40000200800ULL,
0x0000002903297230ULL, 0x040fe40000200800ULL, 0x0000002803287230ULL, 0x040fe40000200800ULL,
0x0000003303337230ULL, 0x048fe40000200800ULL, 0x0000003203327230ULL, 0x040fe40000200800ULL,
0x0000003103317230ULL, 0x000fc40000200800ULL, 0x0000003003037230ULL, 0x000fe40000200800ULL,
0x0000002f2b2b7230ULL, 0x010fe40000200000ULL, 0x0000002e2a2a7230ULL, 0x000fe40000200000ULL,
0x0000002d29297230ULL, 0x000fe40000200000ULL, 0x0000002c28287230ULL, 0x000fe40000200000ULL,
0x0000003733337230ULL, 0x022fc40000200000ULL, 0x0000003632327230ULL, 0x000fe20000200000ULL,
0x0000002825007388ULL, 0x0003e20000000c00ULL, 0x0000003531317230ULL, 0x000fe40000200000ULL,
0x0000003403307230ULL, 0x000fca0000200000ULL, 0x0004003025007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002400cc8947ULL, 0x000fea0003800000ULL,
0x00009000ff037b82ULL, 0x000ea20000000800ULL, 0x00000000001d7919ULL, 0x000ee20000002700ULL,
0x0000000000147919ULL, 0x000eec0000002600ULL, 0x00008400ff167b82ULL, 0x000ea20000000800ULL,
0x0000000025107984ULL, 0x00092e0000000c00ULL, 0x00009400ff0c7b82ULL, 0x000f620000000a00ULL,
0x0000000316037224ULL, 0x004fc800078e02ffULL, 0x0000000e030a7224ULL, 0x040fe200078e02ffULL,
0x0000000f03157811ULL, 0x000fe200078e10ffULL, 0x000000161d1d7224ULL, 0x008fc600078e0214ULL,
0xfffffff015157812ULL, 0x000fe200078ec0ffULL, 0x0000000e1d207224ULL, 0x000fc800078e02ffULL,
0x000000800a237824ULL, 0x000fe400078e0215ULL, 0x0000000120027824ULL, 0x000fe400078e0202ULL,
0x000000800a0a7824ULL, 0x000fca00078e0223ULL, 0x0000007f0a037810ULL, 0x000fc80007ffe0ffULL,
0xffffff8003037812ULL, 0x000fc800078ec0ffULL, 0x0000000c03177210ULL, 0x020fc80007f1e0ffULL,
0x0000001702167211ULL, 0x000fe200078258ffULL, 0x000000ffff177224ULL, 0x000fe200000e060dULL,
0x0000000109ff7812ULL, 0x000fc8000780f843ULL, 0x0000001702177211ULL, 0x000fe400008f5cffULL,
0x0000000c151f7210ULL, 0x000fe20007f3e0ffULL, 0x0000040006167825ULL, 0x000fc800078e0016ULL,
0x0000001021167825ULL, 0x000fe200078e0016ULL, 0x0000000dff217210ULL, 0x000fe20000ffe4ffULL,
0x0000000000400947ULL, 0x012fec0003800000ULL, 0x0000001007147824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe20000011607ULL, 0x00000080020a7824ULL, 0x000fe200078e00ffULL,
0x00000019ff027819ULL, 0x000fe40000011602ULL, 0x00000070141b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a1a7210ULL, 0x000fe40007ebe023ULL, 0x0000000c18197812ULL, 0x000fe400078ec0ffULL,
0x0000001f1b0a7210ULL, 0x000fc40007a3e00aULL, 0x0000000d02147210ULL, 0x000fe40002fec4ffULL,
0x0000000a19187210ULL, 0x000fe40007fbe0ffULL, 0x00000021ff027210ULL, 0x000fe40000fe4402ULL,
0x0000001a191a7210ULL, 0x000fe40007c7e01bULL, 0x00000002ff197210ULL, 0x000fe40002ffe4ffULL,
0x00000014ff1b7210ULL, 0x000fc60001fe84ffULL, 0x0000005818007986ULL, 0x0003e8000c101906ULL,
0x000000051a007986ULL, 0x0003e4000c101906ULL, 0x000000ff0700720cULL, 0x000fe20000705670ULL,
0x0000001016007986ULL, 0x0005e2000c101d06ULL, 0x0000000000007b1dULL, 0x000ff60000000000ULL,
0x0000000000600947ULL, 0x000fea0003800000ULL, 0x00009400ff107b82ULL, 0x004ea20000000a00ULL,
0xffffffff0e057836ULL, 0x002fe40000000000ULL, 0x000000041d107825ULL, 0x004fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe80002000000ULL, 0x00000005101079a8ULL, 0x00032200099ee1c6ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000051000720cULL, 0x010fc80003f05270ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x004fd20008000004ULL,
0x00000002ff007988ULL, 0x0005e60008000004ULL, 0x0000000000057919ULL, 0x002e620000008800ULL,
0x0000040000227802ULL, 0x000fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000065405227816ULL, 0x002fca0000000022ULL,
0x0000000022027984ULL, 0x004e640000000000ULL, 0x000000ff0200720cULL, 0x002fda0003f05270ULL,
0x0000002000908947ULL, 0x000fea0003800000ULL, 0x000000ff4300720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe40000011607ULL, 0x0000001f20047211ULL, 0x000fe400078038ffULL,
0x0000007002057812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000002120027211ULL, 0x000fe400000f3cffULL, 0x000000040a047210ULL, 0x000fc8000791e005ULL,
0x00000002ff057210ULL, 0x000fca00007e24ffULL, 0x0000000604027981ULL, 0x000328000c1e1900ULL,
0x0000800604117981ULL, 0x000322000c1e1900ULL, 0x000000020e00780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x002fea0003800000ULL, 0x0001000604137981ULL, 0x000322000c1e1900ULL,
0x000000040e00780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x0001800604177981ULL, 0x000322000c1e1900ULL, 0x000000040e00780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x002fea0003800000ULL, 0x0002000604197981ULL, 0x000322000c1e1900ULL,
0x000000060e00780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x002fea0003800000ULL,
0x00028006041b7981ULL, 0x000322000c1e1900ULL, 0x000000060e00780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x002fea0003800000ULL, 0x000000080e00780cULL, 0x000fe20003f06070ULL,
0x00030006041d7981ULL, 0x000318000c1e1900ULL, 0x00038006041f0981ULL, 0x000324000c1e1900ULL,
0x000000070e047810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011604ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x0000001520057211ULL, 0x040fe200078038ffULL, 0x000000ffff217224ULL, 0x010fe200078e0002ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000000c050c7210ULL, 0x000fe40007f3e0ffULL, 0x000000ff20047211ULL, 0x000fe400000f3cffULL,
0x000007800c257810ULL, 0x000fc80007f5e0ffULL, 0x00000004ff0d7210ULL, 0x000fd200017e240dULL,
0x000000040e007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050a007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000002102027209ULL, 0x000fca0007810000ULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fc80007f3e0ffULL, 0x0000000dff057210ULL, 0x000fca0000ffe4ffULL,
0xfffc800604217981ULL, 0x000328000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000001102027209ULL, 0x000fca0007810000ULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xfffd000604117981ULL, 0x000326000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000001302027209ULL, 0x000fca0007810000ULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000407047819ULL, 0x002fe400000006ffULL, 0x00000001ff057819ULL, 0x000fe40000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xfffd800604137981ULL, 0x000326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000001702027209ULL, 0x000fca0007810000ULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fc80007f3e0ffULL, 0x0000000dff057210ULL, 0x000fca0000ffe4ffULL,
0xfffe000604177981ULL, 0x000328000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x0000001902027209ULL, 0x000fca0007810000ULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xfffe800604197981ULL, 0x000326000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x0000001b02027209ULL, 0x000fca0007810000ULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000407047819ULL, 0x002fe400000006ffULL, 0x00000001ff057819ULL, 0x000fe40000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xffff0006041b7981ULL, 0x000326000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001d02027209ULL, 0x000fca0007810000ULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fc80007f3e0ffULL, 0x0000000dff057210ULL, 0x000fca0000ffe4ffULL,
0xffff8006041d7981ULL, 0x000328000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000001f02027209ULL, 0x000fca0007810000ULL,
0x000000080e007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0x00000006041f7981ULL, 0x000326000c1e1900ULL, 0x0000040025257810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc6000fffe03fULL, 0x0000000dff0d7210ULL, 0x000fe20000ffe4ffULL,
0xfffffff8002c8947ULL, 0x000ff0000383ffffULL, 0x0000000000077919ULL, 0x000ea40000000000ULL,
0x0000001007047824ULL, 0x006fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fc80000011607ULL,
0x0000007004057812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x000000220a057210ULL, 0x000fca0007ffe005ULL, 0x0000000205007388ULL, 0x0103e40000000800ULL,
0x00009400ff287b82ULL, 0x000ea20000000a00ULL, 0x000000070700780cULL, 0x000fe20003f04070ULL,
0x0000040043217824ULL, 0x000fe200078e00ffULL, 0x00000001090a7812ULL, 0x040fe200078ec0ffULL,
0x0000000109117824ULL, 0x040fe200078e0220ULL, 0x0000002209257211ULL, 0x000fe200078e68ffULL,
0x0000001007277824ULL, 0x000fe200078e00ffULL, 0x0000040021217812ULL, 0x000fe200078ee2ffULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x00000001ff267819ULL, 0x000fe20000011607ULL,
0x0000100006257824ULL, 0x000fe200078e0225ULL, 0x0000007027277812ULL, 0x000fc400078ec0ffULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000c26267812ULL, 0x000fe400078ec0ffULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x0000002209058211ULL, 0x0c2fe400078e48ffULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x0000002209138211ULL, 0x000fc400078e48ffULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000022262a7210ULL, 0x000fe20007ffe027ULL,
0x00000100060d8824ULL, 0x040fe200078e0205ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002803027210ULL, 0x004fe20007f3e0ffULL, 0x0000010006138824ULL, 0x000fe200078e0213ULL,
0x0000000d0a128211ULL, 0x040fe200078e38ffULL, 0x000000002a2a7984ULL, 0x000e620000000800ULL,
0x0000002815247210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff037224ULL, 0x000fe200008e0629ULL,
0x0000002823237210ULL, 0x000fe20007f3e0ffULL, 0x000000800a148824ULL, 0x000fe200078e0213ULL,
0x000008000b0a7812ULL, 0x000fe200078ec0ffULL, 0x0000080011047825ULL, 0x000fe200078e0002ULL,
0x00000029ff287210ULL, 0x000fc40000ffe4ffULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x00000023110c8211ULL, 0x000fe200078238ffULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0x0000002104047210ULL, 0x000fe20007f5e0ffULL, 0x00000001250a7824ULL, 0x000fe200078e020aULL,
0x00000020070b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001007158824ULL, 0x000fe200078e0212ULL,
0x00000028110d8211ULL, 0x040fe200008f3cffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x0000002411108211ULL, 0x000fe200078438ffULL, 0x0000001007137824ULL, 0x000fe200078e020aULL,
0x0000000e0900720cULL, 0x000fe20003f26070ULL, 0x000000100b0a7825ULL, 0x000fe200078e0004ULL,
0x0000002911118211ULL, 0x000fc400010f3cffULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000001407178211ULL, 0x040fe200078e20ffULL, 0x0000001007047825ULL, 0x040fe200078e0004ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x00000010070c8825ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004137faeULL, 0x0005e2000b901c46ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000001007108825ULL, 0x000fe200078e0010ULL, 0x003800000a137faeULL, 0x0005e2000b901c46ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x045800000c158faeULL, 0x0005e2000b901c46ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0418000010178faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000800a01947ULL, 0x002fea0003800000ULL, 0x00000003ff047819ULL, 0x004fe20000011607ULL,
0x000000ffff4d7224ULL, 0x000fe200078e0009ULL, 0xfffffff8ff057812ULL, 0x000fe400078ee207ULL,
0x0000000304047812ULL, 0x000fe400078ec0ffULL, 0x00000003050d7819ULL, 0x040fe200000006ffULL,
0x00000008050b7836ULL, 0x000fe20000000000ULL, 0x00000002ff527819ULL, 0x000fe20000011607ULL,
0x00000008054e7824ULL, 0x000fe200078e00ffULL, 0x000000ff002b7202ULL, 0x000fe20000000f00ULL,
0x0000000104057824ULL, 0x000fe200078e0205ULL, 0x0000000b044f7210ULL, 0x000fe20007ffe0ffULL,
0x000000080b047824ULL, 0x040fe200078e00ffULL, 0x00000008524c7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0a7824ULL, 0x000fe200078e00ffULL, 0x0000000405507810ULL, 0x000fe20007ffe0ffULL,
0x0000000c05517836ULL, 0x000fe20000000000ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee205ULL,
0x0000020009057824ULL, 0x000fe200078e0222ULL, 0xfffffff8044f7812ULL, 0x000fc400078ee24fULL,
0xfffffff80d507812ULL, 0x000fe200078ee250ULL, 0x0000010006547824ULL, 0x000fe200078e0205ULL,
0xfffffff80a517812ULL, 0x000fce00078ee251ULL, 0x000000014d0b7836ULL, 0x000fca0000000000ULL,
0x0000000e0b00720cULL, 0x000fda0003f06070ULL, 0x0000000000880947ULL, 0x000fea0003800000ULL,
0x000000070700780cULL, 0x000fe20003f44070ULL, 0x0000000120137824ULL, 0x000fc800078e020bULL,
0x0000080013047825ULL, 0x000fc600078e0002ULL, 0x0000002104107210ULL, 0x000fe20007f1e0ffULL,
0x000008000b047824ULL, 0x000fc800078e00ffULL, 0x00000022090da211ULL, 0x040fe200078e48ffULL,
0x000002000915a824ULL, 0x000fe200078e0222ULL, 0x00000005ff117210ULL, 0x000fe400007fe4ffULL,
0x00000800040c7812ULL, 0x000fe200078ec0ffULL, 0x000001000654a824ULL, 0x000fe200078e020dULL,
0x000000010b0d7812ULL, 0x000fe400078ec0ffULL, 0x00000023130aa211ULL, 0x000fe200078038ffULL,
0x00000001250c7824ULL, 0x000fe200078e020cULL, 0x000000241304a211ULL, 0x000fc400078238ffULL,
0x000000540d12a211ULL, 0x000fe200078e38ffULL, 0x000001000654a824ULL, 0x000fe200078e0215ULL,
0x00000028130ba211ULL, 0x040fe200000f3cffULL, 0x0000002007157836ULL, 0x000fe20000000000ULL,
0x000000291305a211ULL, 0x000fe200008f3cffULL, 0x000000800d14a824ULL, 0x000fe200078e0254ULL,
0x0000000c07137211ULL, 0x000fe200078e20ffULL, 0x00000010150c7825ULL, 0x000fc600078e0010ULL,
0x000000140717a211ULL, 0x040fe200078e20ffULL, 0x0000001007107825ULL, 0x000fc800078e0010ULL,
0x00000010070aa825ULL, 0x040fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000010137faeULL, 0x0003e6000b901c46ULL, 0x000000100715a824ULL, 0x040fe200078e0212ULL,
0x003800000c137faeULL, 0x0003e2000b901c46ULL, 0x000000100704a825ULL, 0x000fc600078e0004ULL,
0x045800000a15afaeULL, 0x0003e8000b901c46ULL, 0x041800000417afaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000804d047824ULL, 0x002fca00078e00ffULL,
0x0000008004047812ULL, 0x000fc800078ec0ffULL, 0x0000005427057210ULL, 0x000fe40007ffe004ULL,
0x0000000b4d047819ULL, 0x000fe200000006ffULL, 0x000000024d4d7836ULL, 0x000fe40000000000ULL,
0x0000000126057824ULL, 0x000fe200078e0205ULL, 0x0000080004047812ULL, 0x000fe400078ec0ffULL,
0x0000000e4d00720cULL, 0x000fe40003f06070ULL, 0x0000018025047810ULL, 0x000fe20007ffe004ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000050b7984ULL, 0x000e620000000800ULL,
0x000000104e107824ULL, 0x100fe200078e0204ULL, 0x000000044f187211ULL, 0x000fe200078e20ffULL,
0x0000001050147824ULL, 0x100fe200078e0204ULL, 0x00458000050a7984ULL, 0x000fe20000000800ULL,
0x00000010511c7824ULL, 0x000fc600078e0204ULL, 0x000000001010783bULL, 0x000ea80000000200ULL,
0x000000001414783bULL, 0x000ee80000000200ULL, 0x000000001818783bULL, 0x000f280000000200ULL,
0x000000001c1c783bULL, 0x000f620000000200ULL, 0x0000000b2a0b7221ULL, 0x002fc80000010100ULL,
0x3fb8aa3b0b0d7820ULL, 0x000fe20000410000ULL, 0x0000763211047816ULL, 0x004fe20000000004ULL,
0x00010000120b7824ULL, 0x000fc800078e00ffULL, 0x0000000d000d7308ULL, 0x000e620000000800ULL,
0x0001000010057824ULL, 0x040fe200078e00ffULL, 0x0000001017587819ULL, 0x008fe200000006ffULL,
0x0001000015567824ULL, 0x000fe200078e00ffULL, 0x0000763210107816ULL, 0x000fe20000000010ULL,
0x0001000004047824ULL, 0x000fe200078e00ffULL, 0x000000101a577819ULL, 0x010fe200000006ffULL,
0x0001000016537824ULL, 0x000fe200078e00ffULL, 0x00007632130c7816ULL, 0x000fe2000000000cULL,
0x0001000018557824ULL, 0x000fe200078e00ffULL, 0x000076321c597816ULL, 0x020fe20000000059ULL,
0x00010000195a7824ULL, 0x000fe200078e00ffULL, 0x000076321e5c7816ULL, 0x000fe2000000005cULL,
0x000100001c5b7824ULL, 0x000fe200078e00ffULL, 0x000076321d1c7816ULL, 0x000fe2000000001cULL,
0x0000000a0d5f7220ULL, 0x002fe20000410000ULL, 0x00007632120a7816ULL, 0x000fe2000000000aULL,
0x000100001e5d7824ULL, 0x000fe200078e00ffULL, 0x0000763215127816ULL, 0x000fe20000000012ULL,
0x0000004b5f4b7221ULL, 0x000fe20000010000ULL, 0x00001f525f5e7589ULL, 0x000e6200000e0000ULL,
0x0000763216157816ULL, 0x000fe20000000015ULL, 0x000100000a0a7824ULL, 0x000fe200078e00ffULL,
0x0000763217167816ULL, 0x000fe20000000016ULL, 0x00001f4c5f5f7589ULL, 0x000ea200000e0000ULL,
0x0000763218177816ULL, 0x000fe20000000017ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x0000763219187816ULL, 0x000fe20000000018ULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x000076321a197816ULL, 0x000fe20000000019ULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00007632140d7816ULL, 0x000fc4000000000dULL, 0x000076321b1a7816ULL, 0x040fe2000000001aULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x000076321f1e7816ULL, 0x040fe2000000001eULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000001011117819ULL, 0x000fe200000006ffULL,
0x000100000d0d7824ULL, 0x000fe200078e00ffULL, 0x0000001014147819ULL, 0x000fe200000006ffULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x000000101d1d7819ULL, 0x000fe200000006ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x0000001010107819ULL, 0x000fe200000006ffULL,
0x0000005e04457223ULL, 0x082fe20000010045ULL, 0x0000005e05487223ULL, 0x000fe20000010048ULL,
0x0000001015047819ULL, 0x000fe200000006ffULL, 0x0001000012057824ULL, 0x000fc400078e00ffULL,
0x0000005e0a437223ULL, 0x080fe20000010043ULL, 0x000000100c0c7819ULL, 0x000fe200000006ffULL,
0x0000005e10477223ULL, 0x080fe20000010047ULL, 0x0000005e05407223ULL, 0x080fe20000010040ULL,
0x0000005e043f7223ULL, 0x080fe2000001003fULL, 0x0000001018187819ULL, 0x000fe200000006ffULL,
0x0001000016057824ULL, 0x000fe200078e00ffULL, 0x00000010590a7819ULL, 0x000fe200000006ffULL,
0x0001000019047824ULL, 0x000fe200078e00ffULL, 0x000000105c5c7819ULL, 0x000fe200000006ffULL,
0x0000005e11467223ULL, 0x080fe20000010046ULL, 0x0000005e0b447223ULL, 0x080fe20000010044ULL,
0x0000005e13427223ULL, 0x080fe20000010042ULL, 0x0000005e0c417223ULL, 0x080fe20000010041ULL,
0x0000005e143d7223ULL, 0x080fe2000001003dULL, 0x0000005e0d3c7223ULL, 0x080fe2000001003cULL,
0x0000005e563b7223ULL, 0x080fe2000001003bULL, 0x0000005e534a7223ULL, 0x080fe2000001004aULL,
0x0000005e58497223ULL, 0x080fe20000010049ULL, 0x0000005e053e7223ULL, 0x000fe2000001003eULL,
0x0000005f553a7223ULL, 0x084fe2000001003aULL, 0x0000005f17347223ULL, 0x080fe20000010034ULL,
0x0000005f5a337223ULL, 0x080fe20000010033ULL, 0x0000005f18397223ULL, 0x080fe20000010039ULL,
0x0000005f57387223ULL, 0x080fe20000010038ULL, 0x0000005f04377223ULL, 0x080fe20000010037ULL,
0x0000005f1b327223ULL, 0x080fe20000010032ULL, 0x0000005f1a317223ULL, 0x080fe20000010031ULL,
0x0000005f5b307223ULL, 0x080fe20000010030ULL, 0x0000005f0a2f7223ULL, 0x080fe2000001002fULL,
0x0000005f1d367223ULL, 0x080fe20000010036ULL, 0x0000005f1c357223ULL, 0x080fe20000010035ULL,
0x0000005f5d2e7223ULL, 0x080fe2000001002eULL, 0x0000005f5c2d7223ULL, 0x080fe2000001002dULL,
0x0000005f1f2c7223ULL, 0x080fe2000001002cULL, 0x0000005f1e2b7223ULL, 0x000fe2000001002bULL,
0xfffffff400b88947ULL, 0x000fec000383ffffULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff047819ULL, 0x004fe40000011602ULL, 0x0000498022027810ULL, 0x000fe40007ffe0ffULL,
0x0000007003077812ULL, 0x000fe400078ec0ffULL, 0x0000000c040a7812ULL, 0x000fca00078ec0ffULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000008009227824ULL, 0x000fe400078e0222ULL, 0x0000001003047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011603ULL, 0x0000007004037812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000002205227210ULL, 0x000fca0007ffe003ULL,
0x0049804b22007388ULL, 0x0003e40000000800ULL, 0x000000020a027210ULL, 0x000fe20007ffe007ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002037984ULL, 0x000ea80000000800ULL,
0x0000800002047984ULL, 0x000ee20000000800ULL, 0x00000003ff037221ULL, 0x004fc80000010000ULL,
0x0000000403037221ULL, 0x008fca0000010000ULL, 0x0180000003047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0003ULL, 0x00009850000a7802ULL, 0x000fce0000000f00ULL,
0x0000007000a47944ULL, 0x002fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0003ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000300027308ULL, 0x000ea40000001000ULL,
0xbf80000003047423ULL, 0x004fc80000000002ULL, 0x800000ff04057221ULL, 0x000fc80000010100ULL,
0x0000000502027223ULL, 0x000fce0000000002ULL, 0x0000000000077919ULL, 0x000ea40000000000ULL,
0x00000002ff037819ULL, 0x104fe40000011607ULL, 0x00000008070b7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff047819ULL, 0x000fe20000011607ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0302037589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff157812ULL, 0x000fc400078ee207ULL,
0x0000000304147812ULL, 0x000fe200078ec0ffULL, 0x00001f0b020b7589ULL, 0x000ee200000e0000ULL,
0x0000000815177810ULL, 0x000fe20007ffe0ffULL, 0x00000008151a7824ULL, 0x040fe400078e00ffULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0x0000001514157210ULL, 0x000fe20007ffe0ffULL,
0x0000000114187824ULL, 0x000fe200078e0217ULL, 0x00000003171c7819ULL, 0x040fe200000006ffULL,
0x00000008171b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a147812ULL, 0x000fe200078ee215ULL,
0x0000000415167836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000c15177836ULL, 0x000fe20000000000ULL, 0xfffffff81b187812ULL, 0x000fe200078ee218ULL,
0x00000048030c7220ULL, 0x044fe20000410000ULL, 0x0000004703477220ULL, 0x040fe20000410000ULL,
0x00000046030d7220ULL, 0x040fe20000410000ULL, 0x00000045030a7220ULL, 0x040fe20000410000ULL,
0x00000044030e7220ULL, 0x040fe20000410000ULL, 0x0000004303437220ULL, 0x040fe20000410000ULL,
0x0000004203427220ULL, 0x040fe20000410000ULL, 0x0000004103417220ULL, 0x040fe20000410000ULL,
0x0000003d03107220ULL, 0x040fe20000410000ULL, 0x0000003c03057220ULL, 0x042fe20000410000ULL,
0x0000003b03117220ULL, 0x040fe20000410000ULL, 0x0000004003407220ULL, 0x040fe20000410000ULL,
0x0000004a03127220ULL, 0x040fe20000410000ULL, 0x0000003f033f7220ULL, 0x040fe20000410000ULL,
0x0000004903137220ULL, 0x040fe20000410000ULL, 0x0000003e033e7220ULL, 0x000fe20000410000ULL,
0xfffffff819167812ULL, 0x000fe200078ee216ULL, 0x0000003a0b3a7220ULL, 0x048fe20000410000ULL,
0x000000340b037220ULL, 0x040fe20000410000ULL, 0xfffffff81c1a7812ULL, 0x000fe200078ee217ULL,
0x000000330b337220ULL, 0x040fe20000410000ULL, 0x000000390b027220ULL, 0x040fe20000410000ULL,
0x000000380b387220ULL, 0x040fe20000410000ULL, 0x000000370b377220ULL, 0x040fe20000410000ULL,
0x000000320b327220ULL, 0x040fe20000410000ULL, 0x000000310b317220ULL, 0x040fe20000410000ULL,
0x000000300b307220ULL, 0x040fe20000410000ULL, 0x0000002f0b2f7220ULL, 0x040fe20000410000ULL,
0x000000360b367220ULL, 0x040fe20000410000ULL, 0x000000350b357220ULL, 0x040fe20000410000ULL,
0x0000002e0b2e7220ULL, 0x040fe20000410000ULL, 0x0000002d0b2d7220ULL, 0x040fe20000410000ULL,
0x0000002c0b2c7220ULL, 0x040fe20000410000ULL, 0x0000002b0b0b7220ULL, 0x000fe20000410000ULL,
0x0000000f14287211ULL, 0x080fe200078e20ffULL, 0x00000010182a7824ULL, 0x100fe200078e020fULL,
0x0000000f1a2b7211ULL, 0x000fe200078e20ffULL, 0x0000001016297824ULL, 0x000fe200078e020fULL,
0x0000000c470c723eULL, 0x000fc400000010ffULL, 0x0000000d0a0d723eULL, 0x000fe400000010ffULL,
0x0000000e430e723eULL, 0x000fe400000010ffULL, 0x00000042410f723eULL, 0x000fe400000010ffULL,
0x0000003a0314723eULL, 0x000fe200000010ffULL, 0x0000000108037824ULL, 0x000fe200078e0207ULL,
0x000000100510723eULL, 0x000fe200000010ffULL, 0x0000000c28007844ULL, 0x000fe20000000200ULL,
0x000000114011723eULL, 0x000fe200000010ffULL, 0x0000001003037824ULL, 0x000fe200078e0200ULL,
0x000000123f12723eULL, 0x000fc400000010ffULL, 0x000000133e13723eULL, 0x000fe400000010ffULL,
0x000000330215723eULL, 0x000fe400000010ffULL, 0x000000383716723eULL, 0x000fe200000010ffULL,
0x0000001029007844ULL, 0x000fe20000000200ULL, 0x000000323117723eULL, 0x000fe200000010ffULL,
0x000000ff00027306ULL, 0x000e620000202400ULL, 0x000000302f30723eULL, 0x000fe400000010ffULL,
0x000000363531723eULL, 0x000fe200000010ffULL, 0x000000142a007844ULL, 0x000fe20000000200ULL,
0x0000002e2d32723eULL, 0x000fc400000010ffULL, 0x0000002c0b33723eULL, 0x000fca00000010ffULL,
0x000000302b007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000003187984ULL, 0x000e680000000c00ULL, 0x0004000003207984ULL, 0x000ea80000000c00ULL,
0x00080000031c7984ULL, 0x000ee80000000c00ULL, 0x000c000003247984ULL, 0x000f220000000c00ULL,
0x0000001b021b7230ULL, 0x002fc40000200800ULL, 0x0000001a021a7230ULL, 0x040fe40000200800ULL,
0x0000001902197230ULL, 0x040fe40000200800ULL, 0x0000001802187230ULL, 0x040fe40000200800ULL,
0x0000002302237230ULL, 0x044fe40000200800ULL, 0x0000002202227230ULL, 0x040fe40000200800ULL,
0x0000002102217230ULL, 0x000fc40000200800ULL, 0x0000002002207230ULL, 0x000fe40000200800ULL,
0x0000001f1b1b7230ULL, 0x008fe40000200000ULL, 0x0000001e1a1a7230ULL, 0x000fe40000200000ULL,
0x0000001d19197230ULL, 0x000fe40000200000ULL, 0x0000001c18187230ULL, 0x000fe40000200000ULL,
0x0000002723237230ULL, 0x010fc40000200000ULL, 0x0000002622227230ULL, 0x000fe20000200000ULL,
0x0000001803007388ULL, 0x0003e20000000c00ULL, 0x0000002521217230ULL, 0x000fe40000200000ULL,
0x0000002420207230ULL, 0x000fca0000200000ULL, 0x0004002003007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002007127810ULL, 0x000fe20007ffe0ffULL,
0x0000000000107919ULL, 0x000ea20000002600ULL, 0x0000000104057824ULL, 0x000fe200078e0207ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x00000003ff037819ULL, 0x002fe20000011612ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000000806147824ULL, 0x000fe200078e00ffULL,
0x0000000705087812ULL, 0x000fe200078ec0ffULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000112027824ULL, 0x000fe400078e0203ULL, 0x0ffffff808097812ULL, 0x000fe200078ef807ULL,
0x0000000806137824ULL, 0x000fc400078e00ffULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0x0ffffff802057812ULL, 0x000fe400078ef812ULL, 0x0000000009027211ULL, 0x000fc600078e20ffULL,
0x0000001005057824ULL, 0x000fe400078e0200ULL, 0x0000000002087984ULL, 0x0003220000000c00ULL,
0x00000005040472a4ULL, 0x008fc6000f8e023fULL, 0x00000000050c7984ULL, 0x0007620000000c00ULL,
0x0000000810117824ULL, 0x044fe200078e00ffULL, 0x0000000310107819ULL, 0x000fc800000006ffULL,
0xfffffff811047812ULL, 0x000fe400078ee204ULL, 0xfffffff810037812ULL, 0x000fe400078ee203ULL,
0x0000000404107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000403007c10ULL, 0x000fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe20000000a00ULL, 0xfffffff814117812ULL, 0x000fe200078ee207ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0000000410027c11ULL, 0x002fc4000f8040ffULL,
0x000000ffff057210ULL, 0x008fe40000ffe4ffULL, 0x0000000400047c11ULL, 0x000fe4000f8240ffULL,
0x0000000510037c11ULL, 0x000fe400080f4403ULL, 0x0000000500057c11ULL, 0x000fe400088f4405ULL,
0xfffffff813077812ULL, 0x000fe200078ee212ULL, 0x0000001011027825ULL, 0x000fc800078e0002ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000000c04007986ULL, 0x020fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000141007836ULL, 0x000fe20000000000ULL, 0x0000000113137819ULL, 0x000fe200000006ffULL,
0x0000004043027824ULL, 0x000fe200078e00ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x00000001ff057424ULL, 0x000fe200078e00ffULL, 0x0000000d0000720cULL, 0x000fe20003f06070ULL,
0x0000000813007e24ULL, 0x000fe2000f8e0210ULL, 0x0000000241097211ULL, 0x000fc600078e40ffULL,
0x01b600050c0479a7ULL, 0x0002a4000850003fULL, 0x0000000400087c24ULL, 0x000fcc000f8e0209ULL,
0x0000000800e88947ULL, 0x000fea0003800000ULL, 0x00008a00ff067b82ULL, 0x000ee20000000a00ULL,
0x00000003ff317819ULL, 0x100fe4000001160bULL, 0x000000090f0a7248ULL, 0x000fe40007fe0000ULL,
0x0000007003037812ULL, 0x000fe200078ec0ffULL, 0x0000000431137836ULL, 0x000fe40000000000ULL,
0x0000000831157836ULL, 0x000fe40000000000ULL, 0x0000000113107824ULL, 0x040fe200078e020bULL,
0x0000000313117819ULL, 0x000fe200000006ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a09ULL,
0x0000000b15097210ULL, 0x000fe20007ffe0ffULL, 0x0000000c31177836ULL, 0x000fe20000000000ULL,
0xfffffff811187812ULL, 0x000fe200078ee210ULL, 0x0000000815247824ULL, 0x000fe200078e00ffULL,
0x0000003108117210ULL, 0x000fe20007ffe0ffULL, 0x0000000117127824ULL, 0x040fe200078e020bULL,
0x00000003171b7819ULL, 0x000fe200000006ffULL, 0x0000001031197836ULL, 0x000fe20000000000ULL,
0xfffffff824247812ULL, 0x000fe200078ee209ULL, 0x0000001431237836ULL, 0x000fe20000000000ULL,
0x0000001308097210ULL, 0x000fe20007ffe0ffULL, 0x0000010011107825ULL, 0x008fe200078e0006ULL,
0xfffffff81b267812ULL, 0x000fc400078ee212ULL, 0x0000000a1300720cULL, 0x080fe20003f86070ULL,
0x0000000119147824ULL, 0x040fe200078e020bULL, 0x00000010031a7210ULL, 0x000fe20007f1e0ffULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0x0000000a1500720cULL, 0x080fe20003f46070ULL,
0x0000000108137824ULL, 0x000fe200078e0215ULL, 0x0000001708157210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e0611ULL, 0xfffffff81d287812ULL, 0x000fe200078ee214ULL,
0x0000010009107825ULL, 0x000fe200078e0006ULL, 0x0000000a1700720cULL, 0x000fc40003f66070ULL,
0x0000002308177210ULL, 0x000fe20007ffe0ffULL, 0x0000010013127825ULL, 0x100fe200078e0006ULL,
0x00000010031c7210ULL, 0x000fe40007f3e0ffULL, 0x0000000a1900720cULL, 0x000fe20003f06070ULL,
0x0000010015147825ULL, 0x000fc800078e0006ULL, 0x0000000108097824ULL, 0x000fe200078e0219ULL,
0x0000001403207210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e0611ULL,
0x00000012031e7210ULL, 0x000fe20007f3e0ffULL, 0x0000010009107825ULL, 0x100fe200078e0006ULL,
0x00000015ff217210ULL, 0x000fe40002ffe4ffULL, 0x0000000c43097211ULL, 0x000fe200078e70ffULL,
0x0000010017167825ULL, 0x000fc600078e0006ULL, 0x0000100009097810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e0613ULL, 0x0000001003127210ULL, 0x000fe20007f3e0ffULL,
0x00000018312b7836ULL, 0x000fe20000000000ULL, 0x0000001603107210ULL, 0x000fe20007fbe0ffULL,
0x0000000131147824ULL, 0x000fe400078e020bULL, 0x000000ffff137224ULL, 0x000fe200008e0611ULL,
0x0000002b08157210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0617ULL,
0x0000000a2300720cULL, 0x0c0fe20003f26070ULL, 0x0000000123177824ULL, 0x040fe200078e020bULL,
0x0000000714167812ULL, 0x000fe200078ec0ffULL, 0x00000008232a7824ULL, 0x000fe200078e00ffULL,
0x0000000a3100720cULL, 0x000fe20003fa6070ULL, 0x0000001c31237836ULL, 0x000fe20000000000ULL,
0x0ffffff816167812ULL, 0x000fe200078ef80bULL, 0x0000010015147825ULL, 0x000fe200078e0006ULL,
0xfffffff82a2a7812ULL, 0x000fc400078ee217ULL, 0x0000002308177210ULL, 0x000fe20007ffe0ffULL,
0x0000001018277824ULL, 0x000fe200078e0209ULL, 0x0000001403147210ULL, 0x000fe20007fde0ffULL,
0x0000002031297836ULL, 0x000fe20000000000ULL, 0x0000000916257211ULL, 0x000fe200078e20ffULL,
0x0000010017167825ULL, 0x000fc800078e0006ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a257faeULL, 0x0007e2000e901c46ULL,
0x0000001603227210ULL, 0x000fe20007fde0ffULL, 0x0000000123167824ULL, 0x000fe200078e020bULL,
0x0000000a2b00720cULL, 0x080fe20003fa6070ULL, 0x000000001c277faeULL, 0x0009e2000e101c46ULL,
0x0000000108197824ULL, 0x000fe200078e0229ULL, 0x0000000a2300720cULL, 0x000fe20003f86070ULL,
0x000000012b2c7824ULL, 0x040fe200078e020bULL, 0x000000032b2b7819ULL, 0x000fe200000006ffULL,
0x0000010019187825ULL, 0x000fe200078e0006ULL, 0x0000002431257810ULL, 0x008fc60007ffe0ffULL,
0x00000008231b7824ULL, 0x000fe200078e00ffULL, 0x0000000b291a7210ULL, 0x000fe20007ffe0ffULL,
0x00000034312d7836ULL, 0x000fe20000000000ULL, 0x00000017ff237210ULL, 0x000fe200037fe4ffULL,
0x00000010261d7824ULL, 0x110fe200078e0209ULL, 0xfffffff81b2e7812ULL, 0x000fe200078ee216ULL,
0x00000010241b7824ULL, 0x000fe200078e0209ULL, 0xfffffff82b2c7812ULL, 0x000fe200078ee22cULL,
0x0000000108177824ULL, 0x000fe200078e0225ULL, 0x0000001803187210ULL, 0x000fe20007fde0ffULL,
0x0000002831277836ULL, 0x000fe20000000000ULL, 0x000000001e1b7faeULL, 0x0007e2000d101c46ULL,
0x0000000a2500720cULL, 0x0c0fe20003f46070ULL, 0x00000001251c7824ULL, 0x040fe200078e020bULL,
0x0000000325257819ULL, 0x000fe200000006ffULL, 0x00000000201d7faeULL, 0x0009e2000d901c46ULL,
0x0000000a2900720cULL, 0x040fe20003f66070ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0xfffffff8251c7812ULL, 0x000fe200078ee21cULL, 0x0000010017167825ULL, 0x000fe200078e0006ULL,
0x00000030312b7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8291a7812ULL, 0x000fe200078ee21aULL,
0x00000010281b7824ULL, 0x108fe400078e0209ULL, 0x000000102c1f7824ULL, 0x100fe200078e0209ULL,
0x000000091a257211ULL, 0x080fe200078e20ffULL, 0x000000102e217824ULL, 0x010fe200078e0209ULL,
0x000000092a1d7211ULL, 0x000fe200078e20ffULL, 0x00000000121b7faeULL, 0x0007e2000c101c46ULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x0000001603167210ULL, 0x000fe20007fde0ffULL,
0x0000002c31297836ULL, 0x000fe20000000000ULL, 0x00000000101d7faeULL, 0x0009e2000c901c46ULL,
0x00000038312f7836ULL, 0x000fc40000000000ULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x00000000141f7faeULL, 0x000fe2000e901c46ULL, 0x0000000a2700720cULL, 0x080fe20003fc6070ULL,
0x000000082b1e7824ULL, 0x000fe200078e00ffULL, 0x0000000a2900720cULL, 0x080fe20003fa6070ULL,
0x0000000022217faeULL, 0x000fe2000e101c46ULL, 0x0000000108137824ULL, 0x048fe200078e0229ULL,
0x0000000a2b00720cULL, 0x080fe20003f86070ULL, 0x00000001081b7824ULL, 0x000fe200078e022bULL,
0x0000000018257faeULL, 0x0007e2000d901c46ULL, 0x0000000127107824ULL, 0x050fe200078e020bULL,
0x0000003c311d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000827117824ULL, 0x000fe200078e00ffULL,
0x0000000a2d00720cULL, 0x080fe20003f66070ULL, 0x0000010013127825ULL, 0x000fe200078e0006ULL,
0x0000000a2f00720cULL, 0x000fc40003f26070ULL, 0xfffffff8111a7812ULL, 0x000fe200078ee210ULL,
0x0000000108117824ULL, 0x000fe200078e0227ULL, 0x0000000a1d00720cULL, 0x000fe40003f06070ULL,
0x000000091c197211ULL, 0x008fe200078e20ffULL, 0x0000010011107825ULL, 0x000fe200078e0006ULL,
0x0000000b290a7210ULL, 0x000fe40007ffe0ffULL, 0x0000000b2b157210ULL, 0x002fe20007ffe0ffULL,
0x0000000016197faeULL, 0x0003e2000d101c46ULL, 0x0000001003147210ULL, 0x000fe20007f5e0ffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fc400078ee215ULL,
0x0000001d081f7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200010e0611ULL,
0xfffffff8291c7812ULL, 0x000fe200078ee20aULL, 0x000001001b107825ULL, 0x000fe200078e0006ULL,
0x0000000b2d0a7210ULL, 0x000fe40007ffe0ffULL, 0x0000001203167210ULL, 0x002fe20007f5e0ffULL,
0x000000082d197824ULL, 0x000fe400078e00ffULL, 0x00000001082d7824ULL, 0x040fe200078e022dULL,
0x00000013ff177210ULL, 0x000fe200017fe4ffULL, 0x00000001081b7824ULL, 0x000fe200078e022fULL,
0x0000001003187210ULL, 0x000fe20007f5e0ffULL, 0x000001002d127825ULL, 0x000fe200078e0006ULL,
0xfffffff819207812ULL, 0x000fc600078ee20aULL, 0x000000ffff197224ULL, 0x000fe200010e0611ULL,
0x00000012030a7210ULL, 0x000fe20007f5e0ffULL, 0x000001001b107825ULL, 0x000fe200078e0006ULL,
0x0000000b1d127210ULL, 0x000fc60007ffe0ffULL, 0x000000012f087824ULL, 0x040fe400078e020bULL,
0x000000082f2f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e0613ULL,
0x0000001003107210ULL, 0x000fe20007f5e0ffULL, 0x000001001f067825ULL, 0x000fe200078e0006ULL,
0xfffffff82f087812ULL, 0x000fe400078ee208ULL, 0x00000011ff117210ULL, 0x000fe200017fe4ffULL,
0x000000081d1d7824ULL, 0x000fe200078e00ffULL, 0x0000000603067210ULL, 0x000fe20007f5e0ffULL,
0x000000101a137824ULL, 0x000fc400078e0209ULL, 0x000000101c1b7824ULL, 0x100fe200078e0209ULL,
0xfffffff81d127812ULL, 0x000fe200078ee212ULL, 0x0000001020037824ULL, 0x100fe200078e0209ULL,
0x000000091e1d7211ULL, 0x080fe200078e20ffULL, 0x00000010081f7824ULL, 0x000fe200078e0209ULL,
0x0000000912097211ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200010e0607ULL,
0x0000000014137faeULL, 0x0005e8000f101c46ULL, 0x00000000161b7faeULL, 0x0005e8000e901c46ULL,
0x00000000181d7faeULL, 0x0005e8000e101c46ULL, 0x000000000a037faeULL, 0x0005e8000d901c46ULL,
0x00000000101f7faeULL, 0x0005e8000c901c46ULL, 0x0000000006097faeULL, 0x0005e2000c101c46ULL,
0x0000000800987947ULL, 0x000fea0003800000ULL, 0x000000100b197811ULL, 0x000fe200078fe8ffULL,
0x00004000432a7824ULL, 0x000fe200078e020cULL, 0x000000040b137811ULL, 0x040fe400078fe8ffULL,
0x000000080b157811ULL, 0x000fe200078fe8ffULL, 0x00000001190a7824ULL, 0x140fe200078e020bULL,
0x00000003191b7819ULL, 0x000fe200000006ffULL, 0x0000000113067824ULL, 0x100fe200078e020bULL,
0x0000001c0b1f7811ULL, 0x000fe200078fe8ffULL, 0x0000000115077824ULL, 0x140fe200078e020bULL,
0xfffffff81b327812ULL, 0x000fe200078ee20aULL, 0x00000008152e7824ULL, 0x000fe200078e00ffULL,
0x0000000313117819ULL, 0x000fe200000006ffULL, 0x000000011f107824ULL, 0x000fe200078e020bULL,
0x000000140b1b7811ULL, 0x000fc400078fe8ffULL, 0x000000200b0a7811ULL, 0x000fe400078fe8ffULL,
0xfffffff8112c7812ULL, 0x000fe200078ee206ULL, 0x000000081b347824ULL, 0x040fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee207ULL, 0x000000011b077824ULL, 0x100fe200078e020bULL,
0x000000300b1e7811ULL, 0x040fe200078fe8ffULL, 0x000000010a067824ULL, 0x040fe200078e020bULL,
0x0000000c0b177811ULL, 0x000fe200078fe8ffULL, 0x000000080a217824ULL, 0x000fe200078e00ffULL,
0x000000031f117819ULL, 0x000fe200000006ffULL, 0x000000081e207824ULL, 0x000fe200078e00ffULL,
0x000000240b127811ULL, 0x000fe200078fe8ffULL, 0x0000000817307824ULL, 0x000fe200078e00ffULL,
0x000000280b167811ULL, 0x000fe200078fe8ffULL, 0x0000000108277824ULL, 0x000fe200078e021eULL,
0xfffffff811387812ULL, 0x000fc400078ee210ULL, 0x000000180b1d7811ULL, 0x000fe400078fe8ffULL,
0xfffffff834347812ULL, 0x000fe200078ee207ULL, 0x0000000116077824ULL, 0x000fe200078e020bULL,
0xfffffff821107812ULL, 0x000fe200078ee206ULL, 0x0000000812217824ULL, 0x000fe200078e00ffULL,
0x0000000b1e117210ULL, 0x000fe20007ffe0ffULL, 0x000000081d367824ULL, 0x000fe200078e00ffULL,
0x0000000b17097210ULL, 0x000fe40007ffe0ffULL, 0x0000000b12067210ULL, 0x000fc40007ffe0ffULL,
0x0000000316187819ULL, 0x000fe400000006ffULL, 0xfffffff820207812ULL, 0x000fe400078ee211ULL,
0xfffffff830307812ULL, 0x000fe400078ee209ULL, 0x0000000b0b117211ULL, 0x040fe400078fe8ffULL,
0x0000000b1d097210ULL, 0x000fe40007ffe0ffULL, 0x0000002c0b1a7811ULL, 0x000fc400078fe8ffULL,
0xfffffff821147812ULL, 0x000fe200078ee206ULL, 0x0000000108217824ULL, 0x000fe200078e0212ULL,
0xfffffff818187812ULL, 0x000fe200078ee207ULL, 0x000000081a1c7824ULL, 0x000fe200078e00ffULL,
0x00008a00ff067b82ULL, 0x000ee20000000a00ULL, 0x0000000711287812ULL, 0x000fe200078ec0ffULL,
0x0000000108257824ULL, 0x000fe200078e021aULL, 0xfffffff836367812ULL, 0x000fe200078ee209ULL,
0x000000011a097824ULL, 0x000fe200078e020bULL, 0x0000000813117210ULL, 0x000fe20007ffe0ffULL,
0x0000000115137824ULL, 0x100fe200078e0208ULL, 0x000000340b227811ULL, 0x000fe200078fe8ffULL,
0x0000000117157824ULL, 0x000fe200078e0208ULL, 0x000000380b247811ULL, 0x000fc400078fe8ffULL,
0x0000003c0b267811ULL, 0x000fe200078fe8ffULL, 0x00000008222d7824ULL, 0x000fe200078e00ffULL,
0x0000000819177210ULL, 0x000fe20007ffe0ffULL, 0x000000011b197824ULL, 0x100fe200078e0208ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x000000011d1b7824ULL, 0x000fe200078e0208ULL,
0x000000081f1d7210ULL, 0x000fe20007ffe0ffULL, 0x00000001081f7824ULL, 0x000fe200078e020aULL,
0x000000080b097211ULL, 0x000fe200078fe8ffULL, 0x00000001220a7824ULL, 0x100fe200078e020bULL,
0x0000001608237210ULL, 0x000fe20007ffe0ffULL, 0x0000000124127824ULL, 0x040fe200078e020bULL,
0x0000002208297210ULL, 0x000fe20007ffe0ffULL, 0x00000008242f7824ULL, 0x000fe200078e00ffULL,
0x00000024082b7210ULL, 0x000fe20007ffe0ffULL, 0x0000010017167825ULL, 0x008fe200078e0006ULL,
0x00000026084d7210ULL, 0x000fc40007ffe0ffULL, 0x0ffffff828087812ULL, 0x000fe200078ef80bULL,
0x00000001260b7824ULL, 0x040fe200078e020bULL, 0x000010002a4f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000826267824ULL, 0x000fe200078e00ffULL, 0xfffffff82d0a7812ULL, 0x000fe200078ee20aULL,
0x000001001b1a7825ULL, 0x000fe200078e0006ULL, 0xfffffff82f127812ULL, 0x000fe400078ee212ULL,
0xfffffff8260b7812ULL, 0x000fe200078ee20bULL, 0x0000001008087824ULL, 0x100fe200078e024fULL,
0x0000004f2e2f7211ULL, 0x080fe200078e20ffULL, 0x000000102c2d7824ULL, 0x100fe200078e024fULL,
0x0000004f34357211ULL, 0x080fe200078e20ffULL, 0x0000001030317824ULL, 0x100fe200078e024fULL,
0x0000004f103b7211ULL, 0x080fe200078e20ffULL, 0x0000001032337824ULL, 0x100fe200078e024fULL,
0x0000004f1c457211ULL, 0x080fe200078e20ffULL, 0x0000001036377824ULL, 0x100fe200078e024fULL,
0x0000004f124b7211ULL, 0x000fe200078e20ffULL, 0x0000001038397824ULL, 0x100fe200078e024fULL,
0x0000007003037812ULL, 0x000fe200078ec0ffULL, 0x00000010143d7824ULL, 0x000fc400078e024fULL,
0x00000010183f7824ULL, 0x100fe400078e024fULL, 0x0000001020477824ULL, 0x100fe400078e024fULL,
0x000000100a497824ULL, 0x100fe400078e024fULL, 0x000000100b4f7824ULL, 0x000fe400078e024fULL,
0x00000100090a7825ULL, 0x000fc800078e0006ULL, 0x0000010011107825ULL, 0x000fe200078e0006ULL,
0x000000030a0a7210ULL, 0x000fc60007f1e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0006ULL,
0x0000000310107210ULL, 0x000fc60007f3e0ffULL, 0x0000010015147825ULL, 0x100fe200078e0006ULL,
0x0000000312127210ULL, 0x000fe40007f5e0ffULL, 0x00000011ff117210ULL, 0x000fe20000ffe4ffULL,
0x0000010019187825ULL, 0x000fe200078e0006ULL, 0x0000000314147210ULL, 0x000fc60007f7e0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0006ULL, 0x0000000318187210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000000316167210ULL, 0x000fe20007f1e0ffULL,
0x000001001f1e7825ULL, 0x000fc600078e0006ULL, 0x00000017ff177210ULL, 0x000fe200007fe4ffULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x000000031a1a7210ULL, 0x000fe20007f5e0ffULL,
0x0000010021207825ULL, 0x000fe200078e0006ULL, 0x000000031e1e7210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a087faeULL, 0x0007e4000b901c46ULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x000000031c1c7210ULL, 0x000fe20007f7e0ffULL,
0x0000010023227825ULL, 0x100fe200078e0006ULL, 0x00000000102d7faeULL, 0x0007e4000b901c46ULL,
0x0000001dff1d7210ULL, 0x000fe20001ffe4ffULL, 0x0000010025247825ULL, 0x100fe200078e0006ULL,
0x00000000122f7faeULL, 0x0007e6000b901c46ULL, 0x0000010027267825ULL, 0x000fe200078e0006ULL,
0x0000000324247210ULL, 0x000fe20007f7e0ffULL, 0x0000000014317faeULL, 0x0007e4000b901c46ULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x0000000320207210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x0000000322227210ULL, 0x000fe20007f5e0ffULL,
0x0000010029287825ULL, 0x100fe200078e0006ULL, 0x0000000016337faeULL, 0x0007e4000b901c46ULL,
0x00000023ff237210ULL, 0x000fe200017fe4ffULL, 0x000001002b2a7825ULL, 0x100fe200078e0006ULL,
0x0000000018357faeULL, 0x0007e6000b901c46ULL, 0x000001004d067825ULL, 0x000fe200078e0006ULL,
0x000000032a2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000001a377faeULL, 0x0007e4000b901c46ULL,
0x000000ffff1f7224ULL, 0x000fe200000e061fULL, 0x0000000326267210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200008e0621ULL, 0x0000000328287210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff257224ULL, 0x000fe200018e0625ULL, 0x0000000306067210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x000000001c397faeULL, 0x0007e2000b901c46ULL,
0x00000029ff297210ULL, 0x000fe20000ffe4ffULL, 0x000000ffff2b7224ULL, 0x000fc400010e062bULL,
0x000000001e3b7faeULL, 0x0007e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fc600018e0607ULL,
0x00000000203d7faeULL, 0x0007e8000b901c46ULL, 0x00000000223f7faeULL, 0x0007e8000b901c46ULL,
0x0000000024457faeULL, 0x0007e8000b901c46ULL, 0x0000000026477faeULL, 0x0007e8000b901c46ULL,
0x0000000028497faeULL, 0x0007e8000b901c46ULL, 0x000000002a4b7faeULL, 0x0007e8000b901c46ULL,
0x00000000064f7faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x00cfce0000015200ULL, 0x01b600050c0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ff000a7202ULL, 0x000fce0000000f00ULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fce0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fce0007ffe0ffULL,
0x01b600050c0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000000d4100720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x0000000843077824ULL, 0x040fe200078e020cULL,
0x0000000c43057211ULL, 0x000fe200078e28ffULL, 0xffffffff0d0a7836ULL, 0x000fce0000000000ULL,
0x0000010041067824ULL, 0x000fca00078e0202ULL, 0x000000060f00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x004fea0003800000ULL, 0x0000000141047836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe40000000800ULL, 0x0000000400037c24ULL, 0x000fe4000f8e0206ULL,
0x0000000d0400720cULL, 0x000fda0003f06070ULL, 0x0000000800b08947ULL, 0x000fea0003800000ULL,
0x00000003ff257819ULL, 0x004fe20000011608ULL, 0x00008a0000087ab9ULL, 0x000fe20000000a00ULL,
0x800000060f1a7210ULL, 0x000fe20007ffe0ffULL, 0x00004000435f7824ULL, 0x000fe200078e020cULL,
0x0000000425137810ULL, 0x000fe20007ffe0ffULL, 0x0000000825157836ULL, 0x000fe20000000000ULL,
0x0000001c25297810ULL, 0x000fe20007ffe0ffULL, 0x0000000c25177836ULL, 0x000fe20000000000ULL,
0x0000000813047210ULL, 0x000fe20007ffe0ffULL, 0x0000000813117824ULL, 0x000fe200078e00ffULL,
0x0000001025217810ULL, 0x000fe20007ffe0ffULL, 0x0000000115097824ULL, 0x140fe200078e0208ULL,
0x00000003151c7819ULL, 0x000fe200000006ffULL, 0x00000001170b7824ULL, 0x140fe200078e0208ULL,
0xfffffff811187812ULL, 0x000fe200078ee204ULL, 0x00000008171e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x0000000129107824ULL, 0x140fe200078e0208ULL,
0x0ffffff808617812ULL, 0x040fe200078ec0ffULL, 0x0000000829197824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL, 0x0000001425237836ULL, 0x000fe20000000000ULL,
0x0000000900797c02ULL, 0x000fe20008000f00ULL, 0x0000000121047824ULL, 0x140fe200078e0208ULL,
0xfffffff819267812ULL, 0x000fe200078ee210ULL, 0x0000000821117824ULL, 0x000fe200078e00ffULL,
0x0000000823097210ULL, 0x000fe20007ffe0ffULL, 0x0000001825277836ULL, 0x000fe20000000000ULL,
0x0000000825107210ULL, 0x000fe20007ffe0ffULL, 0x0000000823227824ULL, 0x000fe200078e00ffULL,
0xfffffff811207812ULL, 0x000fe200078ee204ULL, 0x00000001270b7824ULL, 0x040fe200078e0208ULL,
0x0000000327247819ULL, 0x000fe200000006ffULL, 0x0000000125117824ULL, 0x040fe200078e0203ULL,
0x0000000708047812ULL, 0x000fe200078ec0ffULL, 0x00000008ff787e24ULL, 0x000fe2000f8e00ffULL,
0x0000001a2500720cULL, 0x000fe20003f06070ULL, 0x00000020252b7836ULL, 0x000fe20000000000ULL,
0xfffffff822227812ULL, 0x000fe200078ee209ULL, 0x000030005f097836ULL, 0x000fe20000000000ULL,
0x0000000761127812ULL, 0x000fe200078ef810ULL, 0x0000010011107825ULL, 0x000fe200078e0078ULL,
0xfffffff824247812ULL, 0x000fc400078ee20bULL, 0x00000008040b7812ULL, 0x000fe200078efcffULL,
0x000000012b147824ULL, 0x000fe200078e0208ULL, 0x0000001a1300720cULL, 0x0c0fe20003f26070ULL,
0x0000000113137824ULL, 0x000fe200078e0203ULL, 0x0000001a1500720cULL, 0x080fe20003f46070ULL,
0x000000082b1b7824ULL, 0x000fe200078e00ffULL, 0x0000000315157210ULL, 0x000fe20007ffe0ffULL,
0x000000100b107825ULL, 0x000fe200078e0010ULL, 0x0000001a1700720cULL, 0x0c0fe40003f66070ULL,
0x0000000912197211ULL, 0x080fe200078e20ffULL, 0x0000000117177824ULL, 0x000fe200078e0203ULL,
0xfffffff81b287812ULL, 0x000fe200078ee214ULL, 0x0000010013127825ULL, 0x100fe200078e0078ULL,
0x000000091c1d7211ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010197faeULL, 0x0005e2000c101c46ULL, 0x0000001a2100720cULL, 0x080fe20003f06070ULL,
0x0000010015147825ULL, 0x000fe200078e0078ULL, 0x0000001a2b00720cULL, 0x000fc60003f86070ULL,
0x0000010017167825ULL, 0x000fc800078e0078ULL, 0x00000010181b7824ULL, 0x000fe400078e0209ULL,
0x000000100b127825ULL, 0x000fe200078e0012ULL, 0x0000000323197210ULL, 0x004fc60007ffe0ffULL,
0x0000000121217824ULL, 0x000fe200078e0203ULL, 0x00000000121b7faeULL, 0x0005e2000c901c46ULL,
0x000000100b147825ULL, 0x000fe200078e0014ULL, 0x0000001a2300720cULL, 0x000fc60003f26070ULL,
0x000000101e1f7824ULL, 0x000fe200078e0209ULL, 0x00000000141d7faeULL, 0x0007e2000d101c46ULL,
0x000000100b167825ULL, 0x000fe200078e0016ULL, 0x0000001a2700720cULL, 0x000fc60003f46070ULL,
0x0000010021107825ULL, 0x000fe200078e0078ULL, 0x00000003291b7210ULL, 0x004fe20007ffe0ffULL,
0x00000000161f7faeULL, 0x0005e2000d901c46ULL, 0x0000001a2900720cULL, 0x000fe20003f66070ULL,
0x0000000127237824ULL, 0x000fe200078e0203ULL, 0x0000003025297810ULL, 0x000fe20007ffe0ffULL,
0x0000010019127825ULL, 0x000fc800078e0078ULL, 0x000000012b1d7824ULL, 0x008fe400078e0203ULL,
0x0000001020217824ULL, 0x000fe400078e0209ULL, 0x000000100b107825ULL, 0x000fc800078e0010ULL,
0x0000010023147825ULL, 0x100fe200078e0078ULL, 0x0000000010217faeULL, 0x0007e6000c101c46ULL,
0x000001001b167825ULL, 0x004fc800078e0078ULL, 0x000001001d187825ULL, 0x000fe200078e0078ULL,
0x00000009241d7211ULL, 0x000fc600078e20ffULL, 0x00000010221b7824ULL, 0x000fe200078e0209ULL,
0x0000002425217810ULL, 0x008fe20007ffe0ffULL, 0x000000100b127825ULL, 0x000fc600078e0012ULL,
0x0000001a2100720cULL, 0x000fe20003f06070ULL, 0x000000100b147825ULL, 0x040fe200078e0014ULL,
0x00000000121b7faeULL, 0x000fe6000c901c46ULL, 0x00000010261f7824ULL, 0x000fe200078e0209ULL,
0x00000000141d7faeULL, 0x0005e2000d101c46ULL, 0x000000100b167825ULL, 0x000fc800078e0016ULL,
0x0000001028117824ULL, 0x000fe200078e0209ULL, 0x00000000161f7faeULL, 0x000fe2000d901c46ULL,
0x000000100b187825ULL, 0x000fe200078e0018ULL, 0x0000001a2900720cULL, 0x000fc60003f66070ULL,
0x0000002c25277836ULL, 0x000fe20000000000ULL, 0x0000000018117faeULL, 0x0007e2000e101c46ULL,
0x0000002825237836ULL, 0x000fe40000000000ULL, 0x0000000121107824ULL, 0x100fe200078e0208ULL,
0x0000000327157819ULL, 0x004fe200000006ffULL, 0x0000000821137824ULL, 0x000fe200078e00ffULL,
0x0000001a2300720cULL, 0x080fe20003f26070ULL, 0x0000000127127824ULL, 0x140fe200078e0208ULL,
0x0000001a2700720cULL, 0x080fe20003f46070ULL, 0x00000034252b7836ULL, 0x000fe20000000000ULL,
0xfffffff8131e7812ULL, 0x000fe200078ee210ULL, 0x00000038252d7836ULL, 0x000fe20000000000ULL,
0x0000000823117210ULL, 0x00afe20007ffe0ffULL, 0x0000000823207824ULL, 0x000fe200078e00ffULL,
0x0000003c25257810ULL, 0x000fe20007ffe0ffULL, 0x0000000129177824ULL, 0x140fe200078e0203ULL,
0xfffffff815227812ULL, 0x000fe200078ee212ULL, 0x0000000129107824ULL, 0x100fe200078e0208ULL,
0x0000001a2b00720cULL, 0x0c0fe20003f86070ULL, 0x000000012b197824ULL, 0x100fe200078e0203ULL,
0x0000001a2d00720cULL, 0x080fe20003fa6070ULL, 0x000000012b127824ULL, 0x100fe200078e0208ULL,
0xfffffff820207812ULL, 0x000fe200078ee211ULL, 0x000000012d1b7824ULL, 0x100fe200078e0203ULL,
0x0000000329297819ULL, 0x000fe200000006ffULL, 0x000000012d147824ULL, 0x100fe200078e0208ULL,
0x0000000327157210ULL, 0x000fe20007ffe0ffULL, 0x0000000121117824ULL, 0x100fe200078e0203ULL,
0x000000032b2b7819ULL, 0x000fe200000006ffULL, 0x0000000123137824ULL, 0x100fe200078e0203ULL,
0x000000032d2d7819ULL, 0x000fe200000006ffULL, 0x00000001251d7824ULL, 0x040fe200078e0203ULL,
0xfffffff829247812ULL, 0x000fe200078ee210ULL, 0x0000000125037824ULL, 0x040fe200078e0208ULL,
0x0000001a2500720cULL, 0x000fe20003fc6070ULL, 0x0000010011107825ULL, 0x000fe200078e0078ULL,
0xfffffff82b267812ULL, 0x000fc400078ee212ULL, 0xfffffff82d287812ULL, 0x000fe200078ee214ULL,
0x0000010013127825ULL, 0x100fe200078e0078ULL, 0x00000003252a7819ULL, 0x000fe400000006ffULL,
0x0000000928257211ULL, 0x000fe200078e20ffULL, 0x0000010015147825ULL, 0x000fe200078e0078ULL,
0xfffffff82a2a7812ULL, 0x000fc600078ee203ULL, 0x0000010017167825ULL, 0x000fc800078e0078ULL,
0x0000010019187825ULL, 0x000fc800078e0078ULL, 0x000001001b1a7825ULL, 0x000fc800078e0078ULL,
0x000001001d1c7825ULL, 0x000fc800078e0078ULL, 0x000000101e037824ULL, 0x000fe400078e0209ULL,
0x000000100b107825ULL, 0x000fc800078e0010ULL, 0x00000010201f7824ULL, 0x000fe200078e0209ULL,
0x0000000010037faeULL, 0x0003e2000c101c46ULL, 0x000000100b127825ULL, 0x000fc800078e0012ULL,
0x000000100b147825ULL, 0x040fe200078e0014ULL, 0x00000000121f7faeULL, 0x0003e6000c901c46ULL,
0x000000100b167825ULL, 0x000fc800078e0016ULL, 0x000000100b187825ULL, 0x000fc800078e0018ULL,
0x000000100b1a7825ULL, 0x000fc800078e001aULL, 0x000000100b1c7825ULL, 0x000fe200078e001cULL,
0x00000009220b7211ULL, 0x000fc600078e20ffULL, 0x0000001024217824ULL, 0x100fe400078e0209ULL,
0x0000001026237824ULL, 0x100fe200078e0209ULL, 0x00000000140b7faeULL, 0x0003e2000d101c46ULL,
0x000000102a277824ULL, 0x000fc600078e0209ULL, 0x0000000016217faeULL, 0x0003e8000d901c46ULL,
0x0000000018237faeULL, 0x0003e8000e101c46ULL, 0x000000001a257faeULL, 0x0003e8000e901c46ULL,
0x000000001c277faeULL, 0x0003e2000f101c46ULL, 0x00000008005c7947ULL, 0x000fea0003800000ULL,
0x0000000c08157811ULL, 0x044fe200078fe8ffULL, 0x00008a00ff787b82ULL, 0x000ea20000000a00ULL,
0x0000000808137811ULL, 0x040fe400078fe8ffULL, 0x00000004080b7811ULL, 0x040fe200078fe8ffULL,
0x0000000815177824ULL, 0x000fe200078e00ffULL, 0x0000000815447210ULL, 0x000fe20007ffe0ffULL,
0x0000000113427824ULL, 0x140fe200078e0208ULL, 0x00000018081b7811ULL, 0x040fe200078fe8ffULL,
0x0000000813117824ULL, 0x000fe200078e00ffULL, 0x0000001c081d7811ULL, 0x040fe200078fe8ffULL,
0x000000010b467824ULL, 0x100fe200078e0208ULL, 0xfffffff817447812ULL, 0x000fe200078ee244ULL,
0x000000081b1f7824ULL, 0x000fe200078e00ffULL, 0x0000001008177811ULL, 0x040fe200078fe8ffULL,
0x000000011d3a7824ULL, 0x100fe200078e0208ULL, 0x0000001408197811ULL, 0x000fe200078fe8ffULL,
0x0000000113137824ULL, 0x100fe200078e0203ULL, 0x000000030b097819ULL, 0x000fe200000006ffULL,
0x0000000117407824ULL, 0x100fe200078e0208ULL, 0x000000081b3c7210ULL, 0x000fe20007ffe0ffULL,
0x00000001193e7824ULL, 0x000fe200078e0208ULL, 0x000000031d217819ULL, 0x000fe200000006ffULL,
0x000000010b0b7824ULL, 0x100fe200078e0203ULL, 0xfffffff811427812ULL, 0x000fe200078ee242ULL,
0x0000000819117824ULL, 0x040fe200078e00ffULL, 0xfffffff809467812ULL, 0x000fe200078ee246ULL,
0x0000000119197824ULL, 0x100fe200078e0203ULL, 0xfffffff81f3c7812ULL, 0x000fe200078ee23cULL,
0x000000011d1d7824ULL, 0x000fe200078e0203ULL, 0xfffffff8213a7812ULL, 0x000fc400078ee23aULL,
0x0000000317097819ULL, 0x040fe200000006ffULL, 0x0000000117177824ULL, 0x000fe200078e0203ULL,
0x00000020081f7811ULL, 0x040fe200078fe8ffULL, 0x000001001d1c7825ULL, 0x004fe200078e0078ULL,
0x0000002408217811ULL, 0x040fe400078fe8ffULL, 0xfffffff809407812ULL, 0x000fe200078ee240ULL,
0x000000011f387824ULL, 0x140fe200078e0208ULL, 0xfffffff8113e7812ULL, 0x000fe200078ee23eULL,
0x000000081f097824ULL, 0x000fe200078e00ffULL, 0x0000002c08277811ULL, 0x040fe200078fe8ffULL,
0x0000000821117824ULL, 0x000fe200078e00ffULL, 0x0000000821367210ULL, 0x000fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x100fe200078e0203ULL, 0xfffffff809387812ULL, 0x000fe200078ee238ULL,
0x00000001272c7824ULL, 0x040fe200078e0208ULL, 0xfffffff811367812ULL, 0x000fe200078ee236ULL,
0x0000000827297824ULL, 0x040fe200078e00ffULL, 0x0000002808237811ULL, 0x040fe200078fe8ffULL,
0x0000000127277824ULL, 0x000fe200078e0203ULL, 0x0000000808107211ULL, 0x040fe200078fe8ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0078ULL, 0x0ffffff808617812ULL, 0x000fc400078ec0ffULL,
0x0000000308117211ULL, 0x040fe200078fe8ffULL, 0x0000000123327824ULL, 0x100fe200078e0208ULL,
0x0000003008097811ULL, 0x040fe400078fe8ffULL, 0x0000000c435f7211ULL, 0x000fe400078e70ffULL,
0x0000000708047812ULL, 0x040fe200078ec0ffULL, 0x0000000109487824ULL, 0x040fe200078e0208ULL,
0xfffffff8292c7812ULL, 0x000fe200078ee22cULL, 0x0000000809337824ULL, 0x000fe200078e00ffULL,
0x0000000761127812ULL, 0x000fe200078ef810ULL, 0x0000010011107825ULL, 0x000fe200078e0078ULL,
0x0000003c08187811ULL, 0x000fc400078fe8ffULL, 0x0000000309297210ULL, 0x000fe40007ffe0ffULL,
0x0000000323257819ULL, 0x040fe200000006ffULL, 0x0000000123237824ULL, 0x100fe200078e0203ULL,
0x0000003408147811ULL, 0x000fe200078fe8ffULL, 0x0000000118317824ULL, 0x000fe200078e0203ULL,
0x0000003808167811ULL, 0x000fe200078fe8ffULL, 0x00000001182e7824ULL, 0x100fe200078e0208ULL,
0x000030005f097810ULL, 0x000fe20007ffe0ffULL, 0x00000001144a7824ULL, 0x100fe200078e0208ULL,
0x00000008042f7812ULL, 0x000fe200078efcffULL, 0x0000000814357824ULL, 0x000fe200078e00ffULL,
0xfffffff825327812ULL, 0x000fe200078ee232ULL, 0x0000000116347824ULL, 0x000fe200078e0208ULL,
0x0000000315157210ULL, 0x000fe20007ffe0ffULL, 0x000000102f247825ULL, 0x000fe200078e0010ULL,
0x000000031b1b7210ULL, 0x000fc40007ffe0ffULL, 0x0000000321217210ULL, 0x000fe20007ffe0ffULL,
0x000001000b107825ULL, 0x000fe200078e0078ULL, 0x00000003142b7210ULL, 0x000fe40007ffe0ffULL,
0x00000003162d7210ULL, 0x000fe20007ffe0ffULL, 0x0000001012037824ULL, 0x000fe200078e0209ULL,
0x0000000318397819ULL, 0x000fe200000006ffULL, 0x0000000816377824ULL, 0x000fe200078e00ffULL,
0x00000009420b7211ULL, 0x000fe200078e20ffULL, 0x0000010013127825ULL, 0x000fe200078e0078ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024037faeULL, 0x0005e2000b901c46ULL,
0xfffffff833487812ULL, 0x000fc400078ee248ULL, 0x0000010015147825ULL, 0x100fe200078e0078ULL,
0xfffffff8354a7812ULL, 0x000fe400078ee24aULL, 0x000000093e337211ULL, 0x080fe200078e20ffULL,
0x0000010017167825ULL, 0x100fe200078e0078ULL, 0xfffffff837347812ULL, 0x000fe400078ee234ULL,
0xfffffff8392e7812ULL, 0x000fe200078ee22eULL, 0x0000010019187825ULL, 0x000fe200078e0078ULL,
0x0000000938397211ULL, 0x000fc600078e20ffULL, 0x0000010027247825ULL, 0x004fc800078e0078ULL,
0x0000010029267825ULL, 0x000fc800078e0078ULL, 0x000001002b287825ULL, 0x000fc800078e0078ULL,
0x000001001b1a7825ULL, 0x000fc800078e0078ULL, 0x0000010021207825ULL, 0x000fc800078e0078ULL,
0x0000010023227825ULL, 0x000fc800078e0078ULL, 0x000001002d2a7825ULL, 0x000fc800078e0078ULL,
0x0000010031307825ULL, 0x000fc800078e0078ULL, 0x000000102f107825ULL, 0x000fc800078e0010ULL,
0x0000001046037824ULL, 0x000fe400078e0209ULL, 0x000000102f127825ULL, 0x000fc600078e0012ULL,
0x0000000010037faeULL, 0x0005e2000b901c46ULL, 0x000000102f147825ULL, 0x000fc600078e0014ULL,
0x00000000120b7faeULL, 0x0007e2000b901c46ULL, 0x000000102f167825ULL, 0x000fc800078e0016ULL,
0x000000102f187825ULL, 0x000fe200078e0018ULL, 0x000000092c037211ULL, 0x004fc600078e20ffULL,
0x000000102f1a7825ULL, 0x000fe200078e001aULL, 0x0000000934137211ULL, 0x008fc600078e20ffULL,
0x000000102f1c7825ULL, 0x000fc800078e001cULL, 0x000000102f1e7825ULL, 0x000fc800078e001eULL,
0x000000102f207825ULL, 0x000fc800078e0020ULL, 0x000000102f227825ULL, 0x000fc800078e0022ULL,
0x000000102f247825ULL, 0x000fc800078e0024ULL, 0x000000102f267825ULL, 0x000fc800078e0026ULL,
0x000000102f287825ULL, 0x000fc800078e0028ULL, 0x000000102f2a7825ULL, 0x000fc800078e002aULL,
0x000000102f307825ULL, 0x000fc800078e0030ULL, 0x00000010442d7824ULL, 0x100fe400078e0209ULL,
0x00000010402f7824ULL, 0x100fe400078e0209ULL, 0x000000103c357824ULL, 0x100fe200078e0209ULL,
0x00000000142d7faeULL, 0x0005e2000b901c46ULL, 0x000000103a377824ULL, 0x100fe400078e0209ULL,
0x00000010363b7824ULL, 0x100fe200078e0209ULL, 0x00000000162f7faeULL, 0x0007e2000b901c46ULL,
0x00000010323d7824ULL, 0x000fc400078e0209ULL, 0x00000010480b7824ULL, 0x100fe200078e0209ULL,
0x0000000018337faeULL, 0x0007e2000b901c46ULL, 0x000000104a117824ULL, 0x000fc600078e0209ULL,
0x000000001a357faeULL, 0x0007e2000b901c46ULL, 0x000000102e157824ULL, 0x004fc600078e0209ULL,
0x000000001c377faeULL, 0x0007e8000b901c46ULL, 0x000000001e397faeULL, 0x0007e8000b901c46ULL,
0x00000000203b7faeULL, 0x0007e8000b901c46ULL, 0x00000000223d7faeULL, 0x0007e8000b901c46ULL,
0x0000000024037faeULL, 0x0007e8000b901c46ULL, 0x00000000260b7faeULL, 0x0007e8000b901c46ULL,
0x0000000028117faeULL, 0x0007e8000b901c46ULL, 0x000000002a137faeULL, 0x0007e8000b901c46ULL,
0x0000000030157faeULL, 0x0007e4000b901c46ULL, 0x00000004ff107819ULL, 0x102fe20000011608ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000003ff037819ULL, 0x008fe20000011608ULL,
0x000010005f5f7836ULL, 0x000fe20000000000ULL, 0x00000008040b7812ULL, 0x000fe200078ef808ULL,
0x0000000810117824ULL, 0x000fe200078e00ffULL, 0x0000000103137812ULL, 0x000fe400078ec0ffULL,
0x0000000b105d7210ULL, 0x000fe20007ffe0ffULL, 0x000000100b107824ULL, 0x040fe200078e00ffULL,
0xfffffff8113c7812ULL, 0x000fe200078ee204ULL, 0x000000100b197824ULL, 0x000fc600078e00ffULL,
0x000000033c767819ULL, 0x040fe200000006ffULL, 0x00000001133b7824ULL, 0x000fe200078e023cULL,
0xfffffff010117812ULL, 0x000fe200078ee25dULL, 0x000000103c3a7836ULL, 0x000fe20000000000ULL,
0x000000033c1b7819ULL, 0x000fe200000006ffULL, 0x000000203c397836ULL, 0x000fe20000000000ULL,
0xfffffff876767812ULL, 0x000fe200078ee23bULL, 0x0000001011117824ULL, 0x000fe200078e020cULL,
0x0000003a13747210ULL, 0x000fe20007ffe0ffULL, 0x0000000113727824ULL, 0x000fe200078e0239ULL,
0x0000005f76147211ULL, 0x000fe200078e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001128783bULL, 0x0003e20000000200ULL, 0x000000303c387836ULL, 0x000fe20000000000ULL,
0x000000123b6c7810ULL, 0x000fe20007ffe0ffULL, 0x000000023b6e7836ULL, 0x000fe20000000000ULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x000000025d107836ULL, 0x000fe20000000000ULL,
0x0000003813707210ULL, 0x000fe20007ffe0ffULL, 0x000000223b687836ULL, 0x000fe20000000000ULL,
0xfffffff81b6e7812ULL, 0x000fe200078ee26eULL, 0x000000083a117824ULL, 0x002fe200078e00ffULL,
0xfffffff019197812ULL, 0x000fe200078ee210ULL, 0x000000323b667836ULL, 0x000fe20000000000ULL,
0x000000343b607810ULL, 0x000fe20007ffe0ffULL, 0x000000106e547824ULL, 0x100fe200078e025fULL,
0xfffffff811747812ULL, 0x000fe200078ee274ULL, 0x00000008383d7824ULL, 0x040fe200078e00ffULL,
0x0000000339117819ULL, 0x000fe200000006ffULL, 0x00000008383f7824ULL, 0x000fe200078e00ffULL,
0x0000000c19197211ULL, 0x000fe200078e20ffULL, 0x0000001074347824ULL, 0x100fe200078e025fULL,
0xfffffff811727812ULL, 0x000fe200078ee272ULL, 0x0000000838117824ULL, 0x000fe200078e00ffULL,
0x000000005454783bULL, 0x000fe20000000200ULL, 0xfffffff83d667812ULL, 0x000fe200078ee266ULL,
0x000000043b6a7836ULL, 0x000fe20000000000ULL, 0xfffffff83f607812ULL, 0x000fe200078ee260ULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0xfffffff811707812ULL, 0x000fe200078ee270ULL,
0x0000001072307824ULL, 0x000fe200078e025fULL, 0x0000005f60447211ULL, 0x000fe200078e20ffULL,
0x000000001920783bULL, 0x0007220000000200ULL, 0x000000083a117824ULL, 0x000fc400078e00ffULL,
0x00000010702c7824ULL, 0x100fe200078e025fULL, 0x000000003030783bULL, 0x000f620000000200ULL,
0x000000243b627836ULL, 0x000fe20000000000ULL, 0xfffffff8116c7812ULL, 0x000fe200078ee26cULL,
0x00000008393d7824ULL, 0x040fe200078e00ffULL, 0x000000004444783bULL, 0x000fe20000000200ULL,
0x0000000839197824ULL, 0x048fe200078e00ffULL, 0x0000005f6c107211ULL, 0x080fe200078e20ffULL,
0x000000143b647836ULL, 0x000fe20000000000ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0xfffffff83d627812ULL, 0x000fe200078ee262ULL, 0x000000142824723cULL, 0x004fe200000418ffULL,
0xfffffff819687812ULL, 0x000fe200078ee268ULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x000000063b5e7836ULL, 0x000fe20000000000ULL, 0x0000000339397819ULL, 0x000fe200000006ffULL,
0x000000363b407836ULL, 0x000fe20000000000ULL, 0x000000162814723cULL, 0x000fe200000418ffULL,
0x0000005f68187211ULL, 0x000fe200078e20ffULL, 0x0000001062487824ULL, 0x000fc400078e025fULL,
0x000000163b5c7836ULL, 0x000fe40000000000ULL, 0x000000263b427836ULL, 0x000fe20000000000ULL,
0x000000001818783bULL, 0x000ea80000000200ULL, 0x000000004848783bULL, 0x000fe20000000200ULL,
0xfffffff839427812ULL, 0x000fe200078ee242ULL, 0x000000342850723cULL, 0x002fec00000418ffULL,
0x000000362834723cULL, 0x000fec00000418ffULL, 0x000000542024723cULL, 0x010fec0000041824ULL,
0x000000562054723cULL, 0x000fec0000041814ULL, 0x000000302814723cULL, 0x020fec00000418ffULL,
0x0000002c281c723cULL, 0x008fec00000418ffULL, 0x000000322830723cULL, 0x000fe200000418ffULL,
0x0000005f662c7211ULL, 0x000fca00078e20ffULL, 0x0000002e2828723cULL, 0x000fe200000418ffULL,
0x000000002c2c783bULL, 0x000e6a0000000200ULL, 0x000000102050723cULL, 0x004fec0000041850ULL,
0x000000122010723cULL, 0x000fec0000041834ULL, 0x000000182014723cULL, 0x000fe20000041814ULL,
0x000000100b357824ULL, 0x000fe200078e00ffULL, 0x000000033a377819ULL, 0x000fe200000006ffULL,
0x000000045d347836ULL, 0x000fc60000000000ULL, 0xfffffff837647812ULL, 0x000fe400078ee264ULL,
0xfffffff035357812ULL, 0x000fe400078ee234ULL, 0x000000033c197819ULL, 0x000fe200000006ffULL,
0x00000010644c7824ULL, 0x100fe200078e025fULL, 0x0000000c35357211ULL, 0x000fe400078e20ffULL,
0xfffffff8196a7812ULL, 0x000fe400078ee26aULL, 0x0000001a2018723cULL, 0x000fe20000041830ULL,
0x000000004c4c783bULL, 0x000fe40000000200ULL, 0x000000106a587824ULL, 0x000fc800078e025fULL,
0x000000033c337819ULL, 0x000fe200000006ffULL, 0x000000100b317824ULL, 0x000fe200078e00ffULL,
0x00000000353c783bULL, 0x000ea20000000200ULL, 0x000000065d307836ULL, 0x000fe20000000000ULL,
0xfffffff8335e7812ULL, 0x000fe200078ee25eULL, 0x0000002c201c723cULL, 0x002fe2000004181cULL,
0x0000000338337819ULL, 0x000fe200000006ffULL, 0x000000005858783bULL, 0x000e620000000200ULL,
0xfffffff031317812ULL, 0x000fe200078ee230ULL, 0x0000001042307824ULL, 0x000fe200078e025fULL,
0xfffffff833407812ULL, 0x000fe200078ee240ULL, 0x0000002e2020723cULL, 0x000fe20000041828ULL,
0x000000083a2d7824ULL, 0x000fe200078e00ffULL, 0x0000005f5e387211ULL, 0x080fe200078e20ffULL,
0x0000001031637824ULL, 0x000fe200078e020cULL, 0x0000005f402c7211ULL, 0x000fe200078e20ffULL,
0x000000003030783bULL, 0x000fe20000000200ULL, 0xfffffff82d5c7812ULL, 0x000fc600078ee25cULL,
0x000000006328783bULL, 0x0007e40000000200ULL, 0x000000105c347824ULL, 0x000fe400078e025fULL,
0x000000002c2c783bULL, 0x000f280000000200ULL, 0x000000003434783bULL, 0x000f620000000200ULL,
0x000000010e637824ULL, 0x008fc600078e0241ULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x000000443c1c723cULL, 0x004fec000004181cULL, 0x000000463c20723cULL, 0x000fec0000041820ULL,
0x0000004c3c50723cULL, 0x000fec0000041850ULL, 0x000000583c24723cULL, 0x002fec0000041824ULL,
0x0000005a3c54723cULL, 0x000fec0000041854ULL, 0x0000004e3c10723cULL, 0x000fec0000041810ULL,
0x000000483c14723cULL, 0x000fec0000041814ULL, 0x0000004a3c18723cULL, 0x000fec0000041818ULL,
0x0000002c281c723cULL, 0x010fec000004181cULL, 0x0000002e282c723cULL, 0x000fec0000041820ULL,
0x000000342850723cULL, 0x020fe20000041850ULL, 0x0000000163207836ULL, 0x000fe20000000000ULL,
0x0000000263217211ULL, 0x000fc800078e40ffULL, 0x0000000d2000720cULL, 0x000fe20003f06070ULL,
0x000000382824723cULL, 0x008fe20000041824ULL, 0x0000000400347c24ULL, 0x000fca000f8e0221ULL,
0x0000003a2854723cULL, 0x000fec0000041854ULL, 0x000000362810723cULL, 0x000fec0000041810ULL,
0x000000302814723cULL, 0x000fec0000041814ULL, 0x000000322818723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000800d88947ULL, 0x000fde0003800000ULL,
0x0000000403297836ULL, 0x000fe20000000000ULL, 0x00000014033f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000c03317836ULL, 0x000fe20000000000ULL, 0x000000210f3a7248ULL, 0x000fe20007fe0000ULL,
0x0000000829237824ULL, 0x000fe200078e00ffULL, 0x0000000829367210ULL, 0x000fe20007ffe0ffULL,
0x000000013f4a7824ULL, 0x140fe200078e0208ULL, 0x00000008032b7810ULL, 0x000fe20007ffe0ffULL,
0x000000083f357824ULL, 0x000fe200078e00ffULL, 0xfffffff823367812ULL, 0x000fe200078ee236ULL,
0x0000000831237824ULL, 0x000fe200078e00ffULL, 0x00000008314e7210ULL, 0x000fe20007ffe0ffULL,
0x000000013a3a7824ULL, 0x000fe200078e0a21ULL, 0xfffffff8354a7812ULL, 0x000fe200078ee24aULL,
0x000000012b387824ULL, 0x040fe200078e0208ULL, 0xfffffff8234e7812ULL, 0x000fe200078ee24eULL,
0x000000082b217824ULL, 0x000fe200078e00ffULL, 0x0000000408357819ULL, 0x000fe200000006ffULL,
0x0000000103237824ULL, 0x000fe200078e0234ULL, 0x0000003a2900720cULL, 0x000fe20003f26070ULL,
0x0000001803377836ULL, 0x000fe20000000000ULL, 0xfffffff821387812ULL, 0x000fe200078ee238ULL,
0x0000010023227825ULL, 0x000fe200078e0078ULL, 0x0000007035357812ULL, 0x000fc400078ec0ffULL,
0x0000003429217210ULL, 0x000fe20007ffe0ffULL, 0x0000001003457836ULL, 0x000fe20000000000ULL,
0x0000000337297819ULL, 0x040fe200000006ffULL, 0x0000000137487824ULL, 0x100fe200078e0208ULL,
0x0000002235287210ULL, 0x000fe20007f1e0ffULL, 0x00000001454c7824ULL, 0x040fe200078e0208ULL,
0x0000000345337819ULL, 0x000fe200000006ffULL, 0x0000001c03397836ULL, 0x000fe20000000000ULL,
0xfffffff829487812ULL, 0x000fe200078ee248ULL, 0x0000010021207825ULL, 0x000fe200078e0078ULL,
0x00000023ff297210ULL, 0x000fc400007fe4ffULL, 0xfffffff8334c7812ULL, 0x000fe200078ee24cULL,
0x00000001393c7824ULL, 0x000fe200078e0208ULL, 0x0000003a2b00720cULL, 0x080fe20003f06070ULL,
0x0000000839337824ULL, 0x000fe200078e00ffULL, 0x0000002035327210ULL, 0x000fe20007f5e0ffULL,
0x000000012b2b7824ULL, 0x100fe200078e0234ULL, 0x00000024033b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000131237824ULL, 0x000fe200078e0234ULL, 0xfffffff8333c7812ULL, 0x000fe200078ee23cULL,
0x0000000103467824ULL, 0x040fe200078e0208ULL, 0x0000003a0300720cULL, 0x080fe20003f66070ULL,
0x00000020033d7836ULL, 0x000fe20000000000ULL, 0x0000003a4500720cULL, 0x000fe20003fa6070ULL,
0x000001002b2a7825ULL, 0x000fe200078e0078ULL, 0x0000000761467812ULL, 0x000fc400078ef846ULL,
0x000000083b447210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff337224ULL, 0x000fe200010e0621ULL,
0x0000003a3100720cULL, 0x000fe20003f46070ULL, 0x0000010023227825ULL, 0x000fe200078e0078ULL,
0x0000003445217210ULL, 0x000fe40007ffe0ffULL, 0x0000002a35307210ULL, 0x000fe20007f9e0ffULL,
0x000000013d3e7824ULL, 0x040fe200078e0208ULL, 0x00000022352a7210ULL, 0x000fe20007fde0ffULL,
0x000000083d317824ULL, 0x000fe400078e00ffULL, 0x000000083b457824ULL, 0x000fc400078e00ffULL,
0x0000010021207825ULL, 0x000fe200078e0078ULL, 0xfffffff8313e7812ULL, 0x000fe400078ee23eULL,
0xfffffff845447812ULL, 0x000fe200078ee244ULL, 0x000000ffff317224ULL, 0x000fe200020e062bULL,
0x00000023ff2b7210ULL, 0x000fe200037fe4ffULL, 0x0000001046457824ULL, 0x000fe200078e025fULL,
0x0000002035207210ULL, 0x000fe20007fde0ffULL, 0x000000013f237824ULL, 0x040fe200078e0234ULL,
0x0000003a3f00720cULL, 0x080fe20003f86070ULL, 0x00000028033f7836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028457faeULL, 0x0003e2000d901c46ULL,
0x0000010023227825ULL, 0x000fe200078e0078ULL, 0x0000003a3700720cULL, 0x000fc40003f66070ULL,
0x00000021ff217210ULL, 0x000fe200037fe4ffULL, 0x0000000137377824ULL, 0x000fe200078e0234ULL,
0x0000002235227210ULL, 0x000fe20007fde0ffULL, 0x0000001036477824ULL, 0x000fe200078e025fULL,
0x000000083f467210ULL, 0x000fe20007ffe0ffULL, 0x0000010037367825ULL, 0x000fe200078e0078ULL,
0x00000023ff237210ULL, 0x000fe400037fe4ffULL, 0x0000000032477faeULL, 0x0005e2000c901c46ULL,
0x000000083f497824ULL, 0x000fe200078e00ffULL, 0x0000003a3900720cULL, 0x0c0fe20003f26070ULL,
0x0000000139397824ULL, 0x000fe200078e0234ULL, 0x0000003635287210ULL, 0x002fe20007fde0ffULL,
0x0000001038457824ULL, 0x000fe200078e025fULL, 0xfffffff849467812ULL, 0x000fe200078ee246ULL,
0x0000002c03497836ULL, 0x000fe20000000000ULL, 0x00000037ff297210ULL, 0x000fe200037fe4ffULL,
0x0000010039387825ULL, 0x000fe200078e0078ULL, 0x0000000030457faeULL, 0x0003e2000c101c46ULL,
0x0000003a3d00720cULL, 0x000fc40003f06070ULL, 0x000000013d377824ULL, 0x000fe200078e0234ULL,
0x0000000849337210ULL, 0x004fe20007ffe0ffULL, 0x0000000849587824ULL, 0x000fe200078e00ffULL,
0x0000003835327210ULL, 0x000fe20007fde0ffULL, 0x0000010037367825ULL, 0x000fc800078e0078ULL,
0x000000104e3d7824ULL, 0x100fe200078e025fULL, 0xfffffff8584e7812ULL, 0x000fe200078ee233ULL,
0x0000003003477836ULL, 0x000fe20000000000ULL, 0x00000039ff337210ULL, 0x000fe200037fe4ffULL,
0x000000013b397824ULL, 0x000fe200078e0234ULL, 0x0000003635307210ULL, 0x002fe20007fde0ffULL,
0x000000104c457824ULL, 0x000fe200078e025fULL, 0x000000002a3d7faeULL, 0x0003e2000d101c46ULL,
0x0000010039387825ULL, 0x000fe200078e0078ULL, 0x00000037ff317210ULL, 0x000fe400037fe4ffULL,
0x0000003a3b00720cULL, 0x080fe20003f46070ULL, 0x000000013f377824ULL, 0x000fe200078e0234ULL,
0x0000000020457faeULL, 0x0005e2000e901c46ULL, 0x00000008474c7824ULL, 0x000fe200078e00ffULL,
0x0000003a3f00720cULL, 0x000fe20003fa6070ULL, 0x0000010037367825ULL, 0x000fe200078e0078ULL,
0x00000008472b7210ULL, 0x002fc60007ffe0ffULL, 0x000000104a3b7824ULL, 0x100fe200078e025fULL,
0x00000038352a7210ULL, 0x000fe20007fde0ffULL, 0x00000034033f7836ULL, 0x000fe20000000000ULL,
0xfffffff84c4a7812ULL, 0x000fe200078ee22bULL, 0x00000010483d7824ULL, 0x000fe200078e025fULL,
0x00000039ff2b7210ULL, 0x000fe200037fe4ffULL, 0x0000000149397824ULL, 0x000fe200078e0234ULL,
0x0000003635207210ULL, 0x004fe20007fde0ffULL, 0x00000000223b7faeULL, 0x0003e2000e101c46ULL,
0x000000083f487824ULL, 0x000fe200078e00ffULL, 0x0000003a4900720cULL, 0x080fe20003f86070ULL,
0x0000010039387825ULL, 0x000fe200078e0078ULL, 0x00000037ff217210ULL, 0x000fe200037fe4ffULL,
0x00000000283d7faeULL, 0x0005e2000d901c46ULL, 0x0000003a4700720cULL, 0x040fe20003f66070ULL,
0x0000000147377824ULL, 0x000fc400078e0234ULL, 0x0000003803457836ULL, 0x000fe40000000000ULL,
0x0000010037367825ULL, 0x000fe200078e0078ULL, 0x000000083f237210ULL, 0x002fe40007ffe0ffULL,
0x0000003835227210ULL, 0x000fe20007fde0ffULL, 0x000000103c3b7824ULL, 0x100fe200078e025fULL,
0xfffffff848387812ULL, 0x000fe200078ee223ULL, 0x000000103e3d7824ULL, 0x104fe200078e025fULL,
0x00000039ff237210ULL, 0x000fe200037fe4ffULL, 0x000000013f397824ULL, 0x040fe200078e0234ULL,
0x0000003635287210ULL, 0x000fe20007fde0ffULL, 0x00000000323b7faeULL, 0x0003e2000c901c46ULL,
0x0000003a3f00720cULL, 0x080fe20003f26070ULL, 0x00000010443f7824ULL, 0x000fe200078e025fULL,
0x00000037ff297210ULL, 0x000fe200037fe4ffULL, 0x0000010039367825ULL, 0x000fe200078e0078ULL,
0x00000000303d7faeULL, 0x0005e6000c101c46ULL, 0x0000000145397824ULL, 0x040fe200078e0234ULL,
0x000000002a3f7faeULL, 0x0007e2000d101c46ULL, 0x0000003a4500720cULL, 0x000fc40003f46070ULL,
0x0000003635327210ULL, 0x002fe40007fde0ffULL, 0x0000003c033b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000845367210ULL, 0x000fe20007ffe0ffULL, 0x0000010039307825ULL, 0x004fe200078e0078ULL,
0x0000003a3b00720cULL, 0x000fc60003f06070ULL, 0x000000ffff337224ULL, 0x000fe200030e0637ULL,
0x000000083b2b7210ULL, 0x008fe20007ffe0ffULL, 0x000000013b377824ULL, 0x000fe200078e0234ULL,
0x00000030352a7210ULL, 0x000fe20007fde0ffULL, 0x0000000845457824ULL, 0x000fe400078e00ffULL,
0x000000083b347824ULL, 0x000fe400078e00ffULL, 0x0000010037787825ULL, 0x000fe200078e0078ULL,
0xfffffff845367812ULL, 0x000fe400078ee236ULL, 0xfffffff834347812ULL, 0x000fe200078ee22bULL,
0x000000ffff2b7224ULL, 0x000fe200030e0631ULL, 0x0000005f46377211ULL, 0x080fe200078e20ffULL,
0x000000104e397824ULL, 0x100fe200078e025fULL, 0x0000007835307210ULL, 0x000fe20007fde0ffULL,
0x000000104a3b7824ULL, 0x100fe200078e025fULL, 0x0000005f38357211ULL, 0x000fe200078e20ffULL,
0x00000010363d7824ULL, 0x100fe200078e025fULL, 0x00000079ff317210ULL, 0x000fe200037fe4ffULL,
0x00000010345f7824ULL, 0x000fe200078e025fULL, 0x0000000020377faeULL, 0x0003e8000e901c46ULL,
0x0000000022397faeULL, 0x0003e8000e101c46ULL, 0x00000000283b7faeULL, 0x0003e8000d901c46ULL,
0x0000000032357faeULL, 0x0003e8000c901c46ULL, 0x000000002a3d7faeULL, 0x0003e8000d101c46ULL,
0x00000000305f7faeULL, 0x0003e2000c101c46ULL, 0x00000008008c7947ULL, 0x000fea0003800000ULL,
0x0000000403237836ULL, 0x000fe20000000000ULL, 0x0000001c03377810ULL, 0x000fe20007ffe0ffULL,
0x0000000803297836ULL, 0x000fe20000000000ULL, 0x00000030036b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000823207824ULL, 0x000fe200078e00ffULL, 0x0000000823697210ULL, 0x000fe20007ffe0ffULL,
0x0000000137587824ULL, 0x100fe200078e0208ULL, 0x0000000829677210ULL, 0x000fe20007ffe0ffULL,
0x0000001803397836ULL, 0x000fe20000000000ULL, 0xfffffff820697812ULL, 0x000fe200078ee269ULL,
0x0000000829207824ULL, 0x000fe200078e00ffULL, 0x0000000337217819ULL, 0x000fe200000006ffULL,
0x0000002403317836ULL, 0x000fe20000000000ULL, 0x0000000839597210ULL, 0x000fe20007ffe0ffULL,
0x000000016b487824ULL, 0x000fe200078e0208ULL, 0xfffffff820677812ULL, 0x000fe200078ee267ULL,
0x0000000839207824ULL, 0x000fe200078e00ffULL, 0xfffffff821587812ULL, 0x000fe200078ee258ULL,
0x0000001008497824ULL, 0x000fe200078e00ffULL, 0x0000003403217210ULL, 0x000fe20007ffe0ffULL,
0x0000002c034d7836ULL, 0x000fe20000000000ULL, 0x000000036b457819ULL, 0x000fe200000006ffULL,
0x0000000831337824ULL, 0x000fe200078e00ffULL, 0x00000008314e7210ULL, 0x000fe20007ffe0ffULL,
0x00000028034b7836ULL, 0x000fe20000000000ULL, 0xfffffff820597812ULL, 0x000fe200078ee259ULL,
0x0000010021207825ULL, 0x000fe200078e0078ULL, 0xfffffff845487812ULL, 0x000fc400078ee248ULL,
0x0000007049497812ULL, 0x000fe200078ec0ffULL, 0x0000000103227824ULL, 0x000fe200078e0208ULL,
0x0000003429457210ULL, 0x000fe20007ffe0ffULL, 0x000000084d3f7824ULL, 0x000fe200078e00ffULL,
0x0000000c032b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000123477824ULL, 0x000fe200078e0234ULL,
0x000000084d4c7210ULL, 0x000fe20007ffe0ffULL, 0x00000010033d7836ULL, 0x000fe20000000000ULL,
0xfffffff8334e7812ULL, 0x000fe200078ee24eULL, 0x000000014b4a7824ULL, 0x040fe200078e0208ULL,
0x0000002049327210ULL, 0x000fe20007f1e0ffULL, 0x000000084b337824ULL, 0x000fe200078e00ffULL,
0x0000000761227812ULL, 0x000fe200078ef822ULL, 0x00000014033b7836ULL, 0x000fe20000000000ULL,
0xfffffff83f4c7812ULL, 0x000fe200078ee24cULL, 0x0000010047467825ULL, 0x000fe200078e0078ULL,
0xfffffff8334a7812ULL, 0x000fc400078ee24aULL, 0x000000083b5b7210ULL, 0x000fe20007ffe0ffULL,
0x0000010045447825ULL, 0x000fe200078e0078ULL, 0x000000032b287819ULL, 0x000fe400000006ffULL,
0x00000038036f7810ULL, 0x000fe20007ffe0ffULL, 0x000000013d617824ULL, 0x040fe200078e0208ULL,
0x0000004449447210ULL, 0x000fe20007f3e0ffULL, 0x000000083d2a7824ULL, 0x000fe200078e00ffULL,
0x000000344d4d7210ULL, 0x000fe20007ffe0ffULL, 0x000000012b3f7824ULL, 0x100fe200078e0234ULL,
0x0000005f69697211ULL, 0x000fe200078e20ffULL, 0x000000013d3d7824ULL, 0x000fe200078e0234ULL,
0xfffffff82a617812ULL, 0x000fe200078ee261ULL, 0x000000ffff337224ULL, 0x000fe200000e0621ULL,
0x0000004649467210ULL, 0x000fe20007f1e0ffULL, 0x000000012b657824ULL, 0x000fe200078e0208ULL,
0x000000086f7a7210ULL, 0x000fe20007ffe0ffULL, 0x000000083b307824ULL, 0x000fe200078e00ffULL,
0x000000343b3b7210ULL, 0x000fe20007ffe0ffULL, 0x000001003f3e7825ULL, 0x000fe200078e0078ULL,
0x00000047ff477210ULL, 0x000fc400007fe4ffULL, 0xfffffff828657812ULL, 0x000fe200078ee265ULL,
0x000001003d3c7825ULL, 0x000fe200078e0078ULL, 0x0000003e493e7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff8305b7812ULL, 0x000fe200078ee25bULL, 0x0000002003357836ULL, 0x000fe20000000000ULL,
0x0000005f61617211ULL, 0x080fe200078e20ffULL, 0x0000000139217824ULL, 0x000fe200078e0234ULL,
0x0000005f58587211ULL, 0x000fe200078e20ffULL, 0x000000ffff457224ULL, 0x000fe200008e0645ULL,
0x0000003c493c7210ULL, 0x000fe20007f3e0ffULL, 0x00000001354f7824ULL, 0x040fe200078e0208ULL,
0x0000003435297210ULL, 0x000fe20007ffe0ffULL, 0x0000000835287824ULL, 0x000fe200078e00ffULL,
0x0000003dff3d7210ULL, 0x000fe20000ffe4ffULL, 0x000001003b3a7825ULL, 0x000fc600078e0078ULL,
0xfffffff8284f7812ULL, 0x000fe200078ee24fULL, 0x0000010021207825ULL, 0x000fc800078e0078ULL,
0x0000000137237824ULL, 0x100fe200078e0234ULL, 0x0000002049207210ULL, 0x000fe20007f3e0ffULL,
0x000000016b357824ULL, 0x000fe400078e0234ULL, 0x000000ffff3f7224ULL, 0x000fe200000e063fULL,
0x0000003a493a7210ULL, 0x000fe20007f1e0ffULL, 0x00000010226b7824ULL, 0x000fe400078e025fULL,
0x0000010023227825ULL, 0x000fc600078e0078ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000326b7faeULL, 0x0003e2000b901c46ULL, 0x0000010029287825ULL, 0x000fc600078e0078ULL,
0x0000000046697faeULL, 0x0005e2000b901c46ULL, 0x00000001312b7824ULL, 0x100fe400078e0234ULL,
0x000000014b317824ULL, 0x000fe400078e0234ULL, 0x000000ffff3b7224ULL, 0x000fe200000e063bULL,
0x0000002249227210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff217224ULL, 0x000fe200008e0621ULL,
0x0000002849287210ULL, 0x000fe20007f3e0ffULL, 0x000001002b2a7825ULL, 0x000fe200078e0078ULL,
0x00000023ff237210ULL, 0x000fc600007fe4ffULL, 0x00000034036d7836ULL, 0x000fe20000000000ULL,
0x0000002a492a7210ULL, 0x000fe20007f1e0ffULL, 0x0000003c03717836ULL, 0x000fe40000000000ULL,
0x0000010031307825ULL, 0x000fe200078e0078ULL, 0x000000086d7c7210ULL, 0x000fe40007ffe0ffULL,
0x00000008715a7210ULL, 0x000fe20007ffe0ffULL, 0x000000016d377824ULL, 0x100fe400078e0234ULL,
0x000000016f397824ULL, 0x000fc400078e0234ULL, 0x00000001714b7824ULL, 0x000fe400078e0234ULL,
0x000000ffff297224ULL, 0x000fe200008e0629ULL, 0x0000003049307210ULL, 0x000fe20007f3e0ffULL,
0x000001004d327825ULL, 0x102fe200078e0078ULL, 0x0000005f4a4d7211ULL, 0x000fe400078e20ffULL,
0x00000031ff317210ULL, 0x000fe20000ffe4ffULL, 0x0000010035347825ULL, 0x000fc800078e0078ULL,
0x0000001067677824ULL, 0x000fe200078e025fULL, 0x0000003449347210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200000e062bULL, 0x0000003249327210ULL, 0x000fe20007f1e0ffULL,
0x0000001065657824ULL, 0x000fe200078e025fULL, 0x0000000044677faeULL, 0x0005e2000b901c46ULL,
0x000000086d6d7824ULL, 0x000fe400078e00ffULL, 0x000000086f6f7824ULL, 0x000fe200078e00ffULL,
0x000000003e657faeULL, 0x0005e2000b901c46ULL, 0x0000010037367825ULL, 0x000fe200078e0078ULL,
0xfffffff86d7c7812ULL, 0x000fc400078ee27cULL, 0xfffffff86f7a7812ULL, 0x000fe200078ee27aULL,
0x0000010039387825ULL, 0x100fe200078e0078ULL, 0x000000003c617faeULL, 0x0005e2000b901c46ULL,
0x0000005f7c4a7211ULL, 0x000fe400078e20ffULL, 0x0000000871717824ULL, 0x000fe400078e00ffULL,
0x000001004b787825ULL, 0x000fc600078e0078ULL, 0xfffffff8715a7812ULL, 0x000fe200078ee25aULL,
0x000000105b5b7824ULL, 0x100fe200078e025fULL, 0x0000007849787210ULL, 0x000fe20007f5e0ffULL,
0x0000001059597824ULL, 0x100fe400078e025fULL, 0x000000104f4f7824ULL, 0x000fe200078e025fULL,
0x000000003a5b7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff337224ULL, 0x000fe200000e0633ULL,
0x0000003649367210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff357224ULL, 0x000fe200008e0635ULL,
0x0000003849387210ULL, 0x000fe20007f3e0ffULL, 0x000000104e4e7824ULL, 0x100fe200078e025fULL,
0x0000000020597faeULL, 0x0005e2000b901c46ULL, 0x000000104c4c7824ULL, 0x100fe200078e025fULL,
0x00000037ff377210ULL, 0x000fe200007fe4ffULL, 0x00000010484b7824ULL, 0x100fe200078e025fULL,
0x0000000022587faeULL, 0x0005e2000b901c46ULL, 0x000000107a487824ULL, 0x000fc400078e025fULL,
0x000000ffff397224ULL, 0x000fe200008e0639ULL, 0x00000000284f7faeULL, 0x0005e2000b901c46ULL,
0x000000105a5f7824ULL, 0x000fe400078e025fULL, 0x000000ffff797224ULL, 0x000fe200010e0679ULL,
0x000000002a4e7faeULL, 0x0005e8000b901c46ULL, 0x00000000304d7faeULL, 0x0005e8000b901c46ULL,
0x00000000324c7faeULL, 0x0005e8000b901c46ULL, 0x00000000344b7faeULL, 0x0005e8000b901c46ULL,
0x00000000364a7faeULL, 0x0005e8000b901c46ULL, 0x0000000038487faeULL, 0x0005e8000b901c46ULL,
0x00000000785f7faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100b217824ULL, 0x046fe200078e00ffULL, 0x000000085d207810ULL, 0x000fe20007ffe0ffULL,
0x00000010763c7824ULL, 0x100fe200078e0209ULL, 0x0000000970307211ULL, 0x080fe200078e20ffULL,
0x0000001074447824ULL, 0x100fe200078e0209ULL, 0xfffffff021217812ULL, 0x000fe200078ee220ULL,
0x0000000a5d287836ULL, 0x000fe20000000000ULL, 0x000000096e347211ULL, 0x080fe200078e20ffULL,
0x000000100b297824ULL, 0x000fe200078e00ffULL, 0x0000000c21387211ULL, 0x000fe200078e20ffULL,
0x0000001072207824ULL, 0x100fe200078e0209ULL, 0x0000000968687211ULL, 0x000fe200078e20ffULL,
0x000000106a6a7824ULL, 0x100fe200078e0209ULL, 0xfffffff029297812ULL, 0x000fe200078ee228ULL,
0x0000001060587824ULL, 0x000fc400078e0209ULL, 0x000000100b487824ULL, 0x000fe400078e00ffULL,
0x0000001029297824ULL, 0x000fe400078e020cULL, 0x000000105e4c7824ULL, 0x000fe200078e0209ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003c3c783bULL, 0x000fe80000000200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000004444783bULL, 0x000ea80000000200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000002020783bULL, 0x000f280000000200ULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000002928783bULL, 0x000f680000000200ULL,
0x000000005858783bULL, 0x000fe80000000200ULL, 0x000000004c4c783bULL, 0x000fe20000000200ULL,
0x0000003c3824723cULL, 0x002fec0000041824ULL, 0x0000003e3854723cULL, 0x000fe20000041854ULL,
0x000000106c3c7824ULL, 0x000fca00078e0209ULL, 0x000000443850723cULL, 0x004fe20000041850ULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x00000030381c723cULL, 0x008fe2000004181cULL,
0x000000100b447824ULL, 0x000fca00078e00ffULL, 0x000000203814723cULL, 0x010fe20000041814ULL,
0x0000000c5d317836ULL, 0x000fe20000000000ULL, 0x0000000966307211ULL, 0x000fe200078e20ffULL,
0x0000000e5d5d7836ULL, 0x000fc60000000000ULL, 0xfffffff044457812ULL, 0x000fe200078ee231ULL,
0x000000463810723cULL, 0x000fe20000041810ULL, 0xfffffff0485d7812ULL, 0x000fc600078ee25dULL,
0x0000001045457824ULL, 0x000fe200078e020cULL, 0x0000000c5d487211ULL, 0x000fe200078e20ffULL,
0x000000223820723cULL, 0x000fe20000041818ULL, 0x000000006818783bULL, 0x000eaa0000000200ULL,
0x00000032382c723cULL, 0x000fe2000004182cULL, 0x000000004544783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0x000000342838723cULL, 0x020fe60000041824ULL,
0x000000006a24783bULL, 0x000f260000000200ULL, 0x0000003c2850723cULL, 0x002fe20000041850ULL,
0x0000000964347211ULL, 0x080fe200078e20ffULL, 0x000000004848783bULL, 0x000fe80000000200ULL,
0x000000362854723cULL, 0x000fe20000041854ULL, 0x00000009623c7211ULL, 0x000fe200078e20ffULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x0000003e2810723cULL, 0x000fe20000041810ULL,
0x000000003c3c783bULL, 0x000f6a0000000200ULL, 0x000000182814723cULL, 0x004fec0000041814ULL,
0x0000001a2820723cULL, 0x000fe20000041820ULL, 0x000000105c187824ULL, 0x000fca00078e0209ULL,
0x00000032282c723cULL, 0x008fe2000004182cULL, 0x000000001818783bULL, 0x000fea0000000200ULL,
0x000000244438723cULL, 0x010fec0000041838ULL, 0x00000030281c723cULL, 0x000fe2000004181cULL,
0x0000000940247211ULL, 0x000fca00078e20ffULL, 0x000000264454723cULL, 0x000fe20000041854ULL,
0x0000001042287824ULL, 0x000fe200078e0209ULL, 0x000000002424783bULL, 0x000ea80000000200ULL,
0x0000005a442c723cULL, 0x000fe2000004182cULL, 0x000000002828783bULL, 0x000eea0000000200ULL,
0x000000344450723cULL, 0x002fec0000041850ULL, 0x000000364410723cULL, 0x000fec0000041810ULL,
0x0000003c4414723cULL, 0x020fec0000041814ULL, 0x0000003e4420723cULL, 0x000fec0000041820ULL,
0x00000058441c723cULL, 0x000fec000004181cULL, 0x00000026482c723cULL, 0x004fec000004182cULL,
0x0000004c4838723cULL, 0x000fe20000041838ULL, 0x00000001ff267424ULL, 0x000fca00078e00ffULL,
0x0000004e4854723cULL, 0x000fe20000041854ULL, 0x01b68826072679a7ULL, 0x000e6a000850003fULL,
0x000000184850723cULL, 0x000fec0000041850ULL, 0x0000001a4810723cULL, 0x000fe20000041810ULL,
0x3db504f32c2c7820ULL, 0x000fe20000410000ULL, 0x3db504f32d2d7820ULL, 0x000fe20000410000ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fc40000410000ULL,
0x000000284814723cULL, 0x008fe20000041814ULL, 0x3db504f3380b7820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fe40000410000ULL, 0x0000002a4820723cULL, 0x000fe20000041820ULL,
0x3db504f354547820ULL, 0x000fe20000410000ULL, 0x3db504f355557820ULL, 0x000fe20000410000ULL,
0x3db504f356567820ULL, 0x000fe20000410000ULL, 0x3db504f357577820ULL, 0x000fc40000410000ULL,
0x00000024481c723cULL, 0x000fe2000004181cULL, 0x3db504f350507820ULL, 0x000fe20000410000ULL,
0x3db504f351517820ULL, 0x000fe20000410000ULL, 0x3db504f352527820ULL, 0x000fe20000410000ULL,
0x3db504f353537820ULL, 0x000fe40000410000ULL, 0x3db504f310197820ULL, 0x000fe20000410000ULL,
0x3db504f3111b7820ULL, 0x000fe20000410000ULL, 0x3db504f3121a7820ULL, 0x000fe20000410000ULL,
0x3db504f313247820ULL, 0x000fc60000410000ULL, 0x3db504f314147820ULL, 0x000fe20000410000ULL,
0x3db504f315157820ULL, 0x000fe20000410000ULL, 0x3db504f316167820ULL, 0x000fe20000410000ULL,
0x3db504f317187820ULL, 0x000fc60000410000ULL, 0x3db504f320207820ULL, 0x000fe20000410000ULL,
0x3db504f321217820ULL, 0x000fe20000410000ULL, 0x3db504f322227820ULL, 0x000fe20000410000ULL,
0x3db504f323237820ULL, 0x000fc60000410000ULL, 0x3db504f31c1c7820ULL, 0x000fe20000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe20000410000ULL, 0x3db504f31e1e7820ULL, 0x000fe20000410000ULL,
0x3db504f31f1f7820ULL, 0x000fe20000410000ULL, 0x0000000000107805ULL, 0x000fe20000015200ULL,
0x01b68827070075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff177224ULL, 0x000fce00078e00ffULL, 0x000000101700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210127210ULL, 0x000fc80007f1e1ffULL, 0x0000001311137210ULL, 0x000fe400007fe5ffULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011413ULL, 0x0000001209097211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x0000000209097819ULL, 0x000fc80000001212ULL,
0x000000090000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000117177836ULL, 0x000fce0000000000ULL, 0x01b68827070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000208097819ULL, 0x000fe200000006ffULL,
0x0000008043107824ULL, 0x000fe200078e020cULL, 0x0000000a4100720cULL, 0x000fe40003f05270ULL,
0xfffffff009097812ULL, 0x000fca00078ec0ffULL, 0x0000000110097824ULL, 0x000fca00078e0209ULL,
0x01b4000009107984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000108177819ULL, 0x000fe200000006ffULL, 0x000000010f277824ULL, 0x000fc600078e0a06ULL,
0x0000000617177812ULL, 0x000fc800078ec0ffULL, 0x0000000117067812ULL, 0x040fe400078efcffULL,
0x0000000817257812ULL, 0x040fe400078efcffULL, 0x000000270600720cULL, 0x080fe40003f26070ULL,
0x0000001017067812ULL, 0x000fe400078efcffULL, 0x000000272500720cULL, 0x080fe40003f06070ULL,
0x000000270600720cULL, 0x000fc40003fc6070ULL, 0x0000001117257812ULL, 0x040fe400078efcffULL,
0x0000001817067812ULL, 0x040fe400078efcffULL, 0x000000271700720cULL, 0x080fe40003f46070ULL,
0x000000272500720cULL, 0x080fe40003fa6070ULL, 0x000000270600720cULL, 0x000fe40003f66070ULL,
0x0000000917267812ULL, 0x000fc400078efcffULL, 0x0000001917257812ULL, 0x040fe400078efcffULL,
0x0000002017067812ULL, 0x000fe400078efcffULL, 0xff8000003a3a7808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff8000003b3b7808ULL, 0x000fe40004800000ULL,
0xff80000039397808ULL, 0x000fc40004800000ULL, 0x000000272600720cULL, 0x080fe40003f86070ULL,
0x000000272500720cULL, 0x080fe40003f46070ULL, 0x000000270600720cULL, 0x000fe40003f26070ULL,
0x0000002117257812ULL, 0x040fe400078efcffULL, 0x0000002817067812ULL, 0x000fe400078efcffULL,
0xff80000056567808ULL, 0x000fc40004000000ULL, 0xff80000054547808ULL, 0x000fe40004000000ULL,
0xff80000057577808ULL, 0x000fe40006000000ULL, 0xff80000055557808ULL, 0x000fe40006000000ULL,
0x000000272500720cULL, 0x080fe40003f06070ULL, 0x000000270600720cULL, 0x000fe40003f86070ULL,
0x0000002917257812ULL, 0x000fc400078efcffULL, 0x0000003017067812ULL, 0x000fe400078efcffULL,
0xff80000052527808ULL, 0x000fe40007000000ULL, 0xff80000050507808ULL, 0x000fe40007000000ULL,
0xff80000053537808ULL, 0x000fe40006800000ULL, 0xff80000051517808ULL, 0x000fe40006800000ULL,
0x000000272500720cULL, 0x000fc40003fc6070ULL, 0x000000270600720cULL, 0x000fe40003fa6070ULL,
0x0000003117257812ULL, 0x040fe400078efcffULL, 0x0000003817067812ULL, 0x040fe400078efcffULL,
0x0000003917177812ULL, 0x000fe400078efcffULL, 0xff8000001a1a7808ULL, 0x000fe40005800000ULL,
0xff80000019197808ULL, 0x000fc40005800000ULL, 0xff80000024247808ULL, 0x000fe40005000000ULL,
0xff8000001b1b7808ULL, 0x000fe40005000000ULL, 0xff80000016167808ULL, 0x000fe40004800000ULL,
0xff80000014147808ULL, 0x000fe40004800000ULL, 0x000000272500720cULL, 0x080fe40003f66070ULL,
0x000000270600720cULL, 0x000fc40003f46070ULL, 0x000000271700720cULL, 0x000fe40003f26070ULL,
0xff80000018187808ULL, 0x000fe40004000000ULL, 0xff80000015157808ULL, 0x000fe40004000000ULL,
0xff80000022227808ULL, 0x000fe40006000000ULL, 0xff80000020207808ULL, 0x000fe40006000000ULL,
0xff80000023237808ULL, 0x000fc40007000000ULL, 0xff80000021217808ULL, 0x000fe40007000000ULL,
0xff8000001e1e7808ULL, 0x000fe40006800000ULL, 0xff8000001c1c7808ULL, 0x000fe40006800000ULL,
0xff8000001f1f7808ULL, 0x000fe40005800000ULL, 0xff8000001d1d7808ULL, 0x000fe40005800000ULL,
0xff8000002e2e7808ULL, 0x000fc40005000000ULL, 0xff8000002c2c7808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff8000002d2d7808ULL, 0x000fce0004800000ULL,
0x0000000b1000720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0xfffffff8ff047812ULL, 0x000fe200078ee204ULL, 0x000000ffff417224ULL, 0x000fe200078e0063ULL,
0x000000100b107208ULL, 0x000fe40004000000ULL, 0x0000000303037812ULL, 0x000fe400078ec0ffULL,
0x000000391000720bULL, 0x000fc80003f1e000ULL, 0x0000001039177208ULL, 0x000fc80004000000ULL,
0x000000541700720bULL, 0x000fc80003f1e000ULL, 0x0000001754067208ULL, 0x000fc80004000000ULL,
0x000000550600720bULL, 0x000fc80003f1e000ULL, 0x0000000655177208ULL, 0x000fc80004000000ULL,
0x000000501700720bULL, 0x000fc80003f1e000ULL, 0x0000001750067208ULL, 0x000fc80004000000ULL,
0x000000510600720bULL, 0x000fc80003f1e000ULL, 0x0000000651067208ULL, 0x000fc80004000000ULL,
0x000000190600720bULL, 0x000fc80003f1e000ULL, 0x0000000619067208ULL, 0x000fc80004000000ULL,
0x0000001b0600720bULL, 0x000fc80003f1e000ULL, 0x000000061b177208ULL, 0x000fc80004000000ULL,
0x000000141700720bULL, 0x000fc80003f1e000ULL, 0x0000001714067208ULL, 0x000fc80004000000ULL,
0x000000150600720bULL, 0x000fc80003f1e000ULL, 0x0000000615177208ULL, 0x000fc80004000000ULL,
0x000000201700720bULL, 0x000fc80003f1e000ULL, 0x0000001720067208ULL, 0x000fe40004000000ULL,
0x0000003a1100720bULL, 0x000fe40003f1e000ULL, 0x000000210600720bULL, 0x000fc80003f3e000ULL,
0x0000000621177208ULL, 0x000fe40004800000ULL, 0x000000113a067208ULL, 0x000fe40004000000ULL,
0x0000001c1700720bULL, 0x000fe40003f3e000ULL, 0x0000003b0600720bULL, 0x000fe40003f1e000ULL,
0x000000171c107208ULL, 0x000fe40004800000ULL, 0x000000063b117208ULL, 0x000fc40004000000ULL,
0x0000001d1000720bULL, 0x000fe40003f3e000ULL, 0x000000561100720bULL, 0x000fe40003f1e000ULL,
0x000000101d177208ULL, 0x000fe40004800000ULL, 0x0000001156067208ULL, 0x000fe40004000000ULL,
0x0000002c1700720bULL, 0x000fe40003f3e000ULL, 0x000000570600720bULL, 0x000fc40003f1e000ULL,
0x000000172c107208ULL, 0x000fe40004800000ULL, 0x0000000657117208ULL, 0x000fe40004000000ULL,
0x0000002d1000720bULL, 0x000fe40003f3e000ULL, 0x000000521100720bULL, 0x000fe40003f1e000ULL,
0x000000102d107208ULL, 0x000fe40004800000ULL, 0x0000001152067208ULL, 0x000fc60004000000ULL,
0x0c401f0010177f89ULL, 0x000ea200000e0000ULL, 0x000000530600720bULL, 0x000fc80003f1e000ULL,
0x0000000653117208ULL, 0x000fc80004000000ULL, 0x0000001a1100720bULL, 0x000fc80003f1e000ULL,
0x000000111a117208ULL, 0x000fc80004000000ULL, 0x000000241100720bULL, 0x000fc80003f1e000ULL,
0x0000001124117208ULL, 0x000fe40004000000ULL, 0x000000171000720bULL, 0x004fe40003f3e000ULL,
0x000000161100720bULL, 0x000fe40003f1e000ULL, 0x0000001017177208ULL, 0x000fe40004800000ULL,
0x0000001116117208ULL, 0x000fc60004000000ULL, 0x0c201f0017107f89ULL, 0x000ea200000e0000ULL,
0x000000181100720bULL, 0x000fc80003f1e000ULL, 0x0000001118117208ULL, 0x000fc80004000000ULL,
0x000000221100720bULL, 0x000fc80003f1e000ULL, 0x0000001122067208ULL, 0x000fc80004000000ULL,
0x000000230600720bULL, 0x000fc80003f1e000ULL, 0x0000000623117208ULL, 0x000fe40004000000ULL,
0x000000101700720bULL, 0x004fe40003f3e000ULL, 0x0000001e1100720bULL, 0x000fe40003f1e000ULL,
0x0000001710107208ULL, 0x000fe40004800000ULL, 0x000000111e067208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b10267820ULL, 0x000fe20000410000ULL, 0x0000001f0600720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b0b117823ULL, 0x100fe20000010826ULL, 0x000000061f0b7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010826ULL,
0x0000001100177308ULL, 0x000fe20000000800ULL, 0x0000002e0b00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010826ULL, 0x0000000b2e067208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010826ULL,
0x0000003900287308ULL, 0x000ea20000000800ULL, 0x0000002f0600720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010826ULL, 0x000000062f067208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010826ULL,
0x0000001500307308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010826ULL,
0x0c401f00060b7f89ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b2d267823ULL, 0x000fc80000010826ULL, 0x0000005400547308ULL, 0x000ff00000000800ULL,
0x0000005500557308ULL, 0x000f300000000800ULL, 0x0000001d00327308ULL, 0x000be20000000800ULL,
0x0000000b0600720bULL, 0x008fc80003f1e000ULL, 0x000000060b067208ULL, 0x000fc60004000000ULL,
0x00000014002b7308ULL, 0x0005e20000000800ULL, 0x00000004ff1d7e24ULL, 0x022fe2000f8e00ffULL,
0x0c201f0006117f89ULL, 0x000e6c00000e0000ULL, 0x0000001c00317308ULL, 0x000fe20000000800ULL,
0x000000172814723eULL, 0x004fe400000010ffULL, 0x3f8000001d28783eULL, 0x000fc800000010ffULL,
0x0000002800297202ULL, 0x000fe20000000f00ULL, 0x00000026002d7308ULL, 0x000fe20000000800ULL,
0x000000ffff367224ULL, 0x100fe400078e0028ULL, 0x000000ffff377224ULL, 0x100fe400078e0028ULL,
0x000000ffff357224ULL, 0x000fc600078e0028ULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x000000110600720bULL, 0x002fc80003f1e000ULL, 0x0000000611117208ULL, 0x000fc60004000000ULL,
0x0000001b002a7308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b11337820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b56567823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b160b7823ULL, 0x100fe20000010833ULL, 0x000000545516723eULL, 0x010fe200000010ffULL,
0x0000003a00157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010833ULL,
0x0000003b00067308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fce0000010833ULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x000000150615723eULL, 0x002fce00000010ffULL,
0x0000005700577308ULL, 0x000e620000000800ULL, 0x3fb8aa3b18067823ULL, 0x000fce0000010833ULL,
0x00000024001c7308ULL, 0x0005e20000000800ULL, 0x000000565717723eULL, 0x002fce00000010ffULL,
0x0000005000507308ULL, 0x000fe20000000800ULL, 0x000000281424723cULL, 0x004fee00000418ffULL,
0x0000005100517308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1e297823ULL, 0x000fce0000010833ULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x000000505118723eULL, 0x002fce00000010ffULL,
0x0000005300537308ULL, 0x000e700000000800ULL, 0x0000001a001b7308ULL, 0x0004f00000000800ULL,
0x0000000b001d7308ULL, 0x0009e20000000800ULL, 0x000000192a1a723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b1f2a7823ULL, 0x000fe20000010833ULL, 0x000000525319723eULL, 0x002fe200000010ffULL,
0x000000ffff337224ULL, 0x000fe200078e0028ULL, 0x0000001b1c1b723eULL, 0x008fc600000010ffULL,
0x0000000600347308ULL, 0x0002a20000000800ULL, 0x0c401f00120b7f89ULL, 0x010ee200000e0000ULL,
0x0000002b301c723eULL, 0x000fe200000010ffULL, 0x00000008042b7836ULL, 0x000fe20000000000ULL,
0x000000361824723cULL, 0x000fe80000041824ULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x0c401f0013067f89ULL, 0x002e6200000e0000ULL, 0x0000001d341d723eULL, 0x004fcc00000010ffULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x0000002800347202ULL, 0x000fce0000000f00ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x0000000b1200720bULL, 0x008fc80003f1e000ULL,
0x000000120b127208ULL, 0x000fe40004000000ULL, 0x00000020211e723eULL, 0x004fe200000010ffULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x000000061300720bULL, 0x002fe40003f3e000ULL,
0x000000313220723eULL, 0x000fe200000010ffULL, 0x000000ffff327224ULL, 0x000fe200078e0028ULL,
0x0000001306137208ULL, 0x000fe20004800000ULL, 0x0000000103067824ULL, 0x000fe200078e0204ULL,
0x00000003040b7819ULL, 0x000fe200000006ffULL, 0x0000002c002c7308ULL, 0x000e620000000800ULL,
0x000000032b317819ULL, 0x040fe200000006ffULL, 0x000000082b287824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0b7812ULL, 0x000fc400078ee206ULL, 0x00000022231f723eULL, 0x004fc600000010ffULL,
0x0000002900297308ULL, 0x000fe80000000800ULL, 0x000000341c24723cULL, 0x000fe20000041824ULL,
0x0000002c2d22723eULL, 0x002fc600000010ffULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x00000001032c7824ULL, 0x000fe200078e022bULL, 0x0000000c062d7810ULL, 0x000fe20007ffe0ffULL,
0x0c201f0012037f89ULL, 0x000eaa00000e0000ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000292a21723eULL, 0x002fce00000010ffULL, 0x0000002f00237308ULL, 0x0002e20000000800ULL,
0x0000080043297824ULL, 0x000fe400078e020cULL, 0x00000004062a7836ULL, 0x000fe40000000000ULL,
0x0001100029067836ULL, 0x000fe20000000000ULL, 0xfffffff831297812ULL, 0x000fe400078ee22cULL,
0xfffffff828317812ULL, 0x000fe200078ee22dULL, 0x000000ffff2d7224ULL, 0x000fe200078e0016ULL,
0x00000003042f7819ULL, 0x002fe200000006ffULL, 0x000000ffff287224ULL, 0x000fe200078e001cULL,
0x0c201f0013047f89ULL, 0x000e6200000e0000ULL, 0x000000031200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x0000002e2323723eULL, 0x008fe200000010ffULL,
0x000000ffff2e7224ULL, 0x000fe200078e0018ULL, 0xfffffff82f2b7812ULL, 0x000fe200078ee22aULL,
0x0000001031317824ULL, 0x000fe200078e0206ULL, 0x0000001203127208ULL, 0x000fe20004000000ULL,
0x000000ffff187224ULL, 0x000fe200078e001dULL, 0x0000000308ff7812ULL, 0x000fe2000780c0ffULL,
0x000000322024723cULL, 0x000fe20000041824ULL, 0x000000060b0b7211ULL, 0x000fe200078e20ffULL,
0x000000ffff197224ULL, 0x000fe200078e001fULL, 0x00000014002c7202ULL, 0x000fc40000000f00ULL,
0x0000001a002f7202ULL, 0x000fe40000000f00ULL, 0x00000020002a7202ULL, 0x000fe40000000f00ULL,
0x0000001500147202ULL, 0x000fe20000000f00ULL, 0x000000ffff157224ULL, 0x000fe200078e0017ULL,
0x0000002c0b007844ULL, 0x000fe20000000200ULL, 0x0000001b00177202ULL, 0x000fe20000000f00ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0023ULL, 0x000000041300720bULL, 0x002fe40003f3e000ULL,
0x00000021001a7202ULL, 0x000fc40000000f00ULL, 0x0000001304137208ULL, 0x000fe40004800000ULL,
0x000000102b257824ULL, 0x100fe200078e0206ULL, 0x0000000100047802ULL, 0x000fe20000000f00ULL,
0x0000001029277824ULL, 0x000fe400078e0206ULL, 0x000000ffff297224ULL, 0x000fe400078e001eULL,
0x000000ffff2b7224ULL, 0x000fca00078e0022ULL, 0x0000002825007844ULL, 0x0003e80000000200ULL,
0x0000001427007844ULL, 0x0005e80000000200ULL, 0x0000001831007844ULL, 0x0005e80000000200ULL,
0x01b0001009008388ULL, 0x0005e20000000c00ULL, 0x000000ffff257224ULL, 0x002fca00078e0026ULL,
0x01b2002409008388ULL, 0x0005e20000000a00ULL, 0x0000000d6300720cULL, 0x000fe20003f06070ULL,
0x01b6080405ff79a7ULL, 0x0005e2000850003fULL, 0x01b6100405ff79a7ULL, 0x0005e2000850003fULL,
0x01b6180405ff79a7ULL, 0x0005e2000850003fULL, 0x01b6200405ff79a7ULL, 0x0005f2000850003fULL,
0xffffffac00f48947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000005037836ULL, 0x000fe20000000000ULL, 0x0000013000007945ULL, 0x000fe80003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000000500038308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff05ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000005047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe400078efcffULL, 0x0000000400038202ULL, 0x000fe20000000f00ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000500037308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff0b7424ULL, 0x000fc800078e00ffULL,
0xfffffef00aec7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004cdULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000648ULL, 0x0000000000000210ULL,
0x0000001400000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000858ULL, 0x00000000000000d0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000928ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000097cULL, 0x0000000000000424ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000da0ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000da0ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000007bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000de8ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e00ULL, 0x0000000000010d00ULL,
0x0000001400000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000008dULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011b00ULL, 0x000000000000003cULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011b40ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000011b40ULL, 0x0000000000000258ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000012118ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000012118ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000de8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000010d00ULL, 0x0000000000010d00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000011b00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000011b40ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000258ULL, 0x0000000000000258ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_8_m_8_sm_90_cubin_len = 74344;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
