/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016f40ULL, 0x0000000000016bc0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45346a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL,
0x6a4c4545346a4c6aULL, 0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x4c6a496365563349ULL, 0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL,
0x245f305f6c616e72ULL, 0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL,
0x70776f6c735f3233ULL, 0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL,
0x5f5f245f325f6c61ULL, 0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL,
0x65746e695f5f2400ULL, 0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL,
0x6c61625f636e7973ULL, 0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL,
0x742e6c65722e0061ULL, 0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL,
0x426d656d73246168ULL, 0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL,
0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL,
0x612e6c65722e766eULL, 0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000208ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000c000100000295ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000002e3ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000331ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b0022000003bdULL, 0x00000000000153c0ULL, 0x0000000000000170ULL,
0x000b0022000003f0ULL, 0x0000000000015530ULL, 0x0000000000000040ULL, 0x000b00220000041bULL,
0x0000000000015570ULL, 0x0000000000000050ULL, 0x000b002200000445ULL, 0x00000000000155c0ULL,
0x0000000000000140ULL, 0x000a0003000004b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000004d3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000503ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000015700ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000153c000000000ULL, 0x0000040400000000ULL,
0x810c000001500400ULL, 0x0053900400288080ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808e0828808081ULL, 0xab082880808f0828ULL, 0x2880808808288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808088ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x000153c000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808d0828808081ULL, 0x8f082880808e0828ULL, 0x288080ab08288080ULL, 0x8280162880808608ULL,
0x0000000003102880ULL, 0x8080869200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x000000f000000000ULL, 0x0001553000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808e0828808081ULL, 0x8f08288080ab0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x002880808f920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL,
0x0000017800000000ULL, 0x0001557000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x808e2880808f0900ULL, 0x0000000000002880ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808f0828808081ULL,
0x8e08288080ab0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808e920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000020800000000ULL, 0x000155c000000000ULL,
0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001800082f04ULL, 0x0008230400000080ULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL,
0x0000000000000012ULL, 0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000001100081104ULL, 0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL,
0x0008110400000000ULL, 0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0060016000000015ULL, 0x000c170400601903ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0x000008b000043104ULL, 0xffffffff01542904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002d001542804ULL, 0x000004e000000440ULL,
0x00002ae0000019b0ULL, 0x00002ca000002b80ULL, 0x0000300000002e00ULL, 0x000030a000003030ULL,
0x0000380000003110ULL, 0x000047e000004750ULL, 0x00004a7000004910ULL, 0x00004cb000004c80ULL,
0x00004d9000004d20ULL, 0x0000618000005170ULL, 0x0000634000006210ULL, 0x000066b0000064a0ULL,
0x00006750000066e0ULL, 0x00006bd0000067c0ULL, 0x00007c6000007bc0ULL, 0x00007ef000007d90ULL,
0x0000813000008100ULL, 0x00008210000081a0ULL, 0x0000877000008760ULL, 0x0000aba00000ab60ULL,
0x0000b2f00000b2b0ULL, 0x00013900000138c0ULL, 0x0001392000013910ULL, 0x0001399000013930ULL,
0x000139d0000139b0ULL, 0x000146d000014680ULL, 0x000147a000014740ULL, 0x0001488000014810ULL,
0x00014930000148e0ULL, 0x00014a00000149a0ULL, 0x00014ae000014a70ULL, 0x00014b9000014b40ULL,
0x00014c6000014c00ULL, 0x00014d4000014cd0ULL, 0x00014df000014da0ULL, 0x00014ec000014e60ULL,
0x00014fa000014f30ULL, 0x0001509000015010ULL, 0x0001519000015110ULL, 0x0001529000015210ULL,
0x0001539000015310ULL, 0x000003a002003904ULL, 0x0001b600000000ffULL, 0x000003d0003f0100ULL,
0x0001b6080000000bULL, 0x00000480003f0120ULL, 0x0001b6880000000bULL, 0x00000910003f0120ULL,
0x0001b600000000ffULL, 0x00000ad0003f0107ULL, 0x0001b68c0000006eULL, 0x00000ba0003f0102ULL,
0x0001b6880000006eULL, 0x000027f0003f0101ULL, 0x0001b6080000000aULL, 0x00002810003f0101ULL,
0x0001b60c0000000aULL, 0x000029e0003f0105ULL, 0x0001b60c0000000aULL, 0x00003780003f0105ULL,
0x0001b6880000004eULL, 0x000044b0003f0101ULL, 0x0001b62800000034ULL, 0x000044d0003f0101ULL,
0x0001b62c00000034ULL, 0x000046a0003f0105ULL, 0x0001b62c00000034ULL, 0x00005120003f0105ULL,
0x000000000000000eULL, 0x00005ee0003f0101ULL, 0x0001b64800000009ULL, 0x00005f00003f0101ULL,
0x0001b64c00000009ULL, 0x000060d0003f0105ULL, 0x0001b64c00000009ULL, 0x00006bb0003f0105ULL,
0x000000000000000cULL, 0x00007920003f0101ULL, 0x0001b6680000001eULL, 0x00007940003f0101ULL,
0x0001b66c0000001eULL, 0x00007b10003f0105ULL, 0x0001b66c0000001eULL, 0x00008600003f0105ULL,
0x0000000000000008ULL, 0x0000c290003f0101ULL, 0x0001b600000000ffULL, 0x0000dab0003f0101ULL,
0x0001b604000000ffULL, 0x0000dc80003f0105ULL, 0x0001b604000000ffULL, 0x00011dd0003f0105ULL,
0x0000000000000073ULL, 0x00011ee0003f0101ULL, 0x0000000400000073ULL, 0x000120b0003f0105ULL,
0x0000000400000073ULL, 0x000144d0003f0105ULL, 0x0001b60800000074ULL, 0x00014530003f0101ULL,
0x0001b61000000074ULL, 0x00014590003f0101ULL, 0x0001b61800000074ULL, 0x00014600003f0101ULL,
0x0001b62000000074ULL, 0x00033803003f0101ULL, 0x0000bb5000201c04ULL, 0x0000bd600000bb80ULL,
0x0000c0500000bec0ULL, 0x0000dce00000c150ULL, 0x0000040100014640ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000274ULL, 0x0000001800000002ULL, 0x00000000000001e4ULL, 0x0000001800000002ULL,
0x0000000000000164ULL, 0x0000001800000002ULL, 0x00000000000000dcULL, 0x0000001800000002ULL,
0x0000000000000044ULL, 0x0000001800000002ULL, 0x000000000000024aULL, 0x0000001800000002ULL,
0x00000000000001baULL, 0x0000001800000002ULL, 0x000000000000013cULL, 0x0000001800000002ULL,
0x00000000000000b7ULL, 0x0000001800000002ULL, 0x000000000001b700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000e747a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000077919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000797919ULL, 0x000ea20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003737a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a73ULL, 0x0000040003007624ULL, 0x000fca00078e020eULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000173730810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000173731810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff73aa12ULL, 0x000fc800078e33ffULL,
0x0000007300007306ULL, 0x000e620000209000ULL, 0x000000ff7300720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000373047224ULL, 0x004fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000000603717227ULL, 0x000fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a71ULL,
0x0000000073007224ULL, 0x000fca00078e0206ULL, 0x000000730000720cULL, 0x000fe20003f06070ULL,
0x0000010009027a24ULL, 0x008fe400078e0204ULL, 0x00001fff09097589ULL, 0x000fe400000e0000ULL,
0x00000000020b7a24ULL, 0x000fca00078e0207ULL, 0x000000ff0b00720cULL, 0x000fc60003f65270ULL,
0x0000000100000824ULL, 0x000fe200078e0a73ULL, 0x0000000171710810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0b00780cULL, 0x040fe40003f84070ULL, 0x000000730000720cULL, 0x000fe40003f26070ULL,
0x000000030b00780cULL, 0x000fc60003f04070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fc800078e00ffULL, 0x3fffffc0ff04c424ULL, 0x000fe200078e00ffULL,
0x7fffffc00005c802ULL, 0x000fe40000000f00ULL, 0x0000000171711810ULL, 0x000fe20007ffe0ffULL,
0x01b60002ff00b388ULL, 0x0003e20000000a00ULL, 0x00000073ff71a212ULL, 0x000fe400078e33ffULL,
0x0000007f0b00780cULL, 0x000fe20003f24070ULL, 0x01b608040b00c388ULL, 0x000fe40000008a00ULL,
0x000000ffff007224ULL, 0x000fc800078e0a71ULL, 0x0000000073737224ULL, 0x000fe200078e0206ULL,
0x00000005ff007819ULL, 0x000fe20000011607ULL, 0x3fffff60ff068424ULL, 0x000fe400078e00ffULL,
0x00000010736b7824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff078424ULL, 0x000fe200078e00ffULL,
0x00001fff00007589ULL, 0x000ea200000e0000ULL, 0xff317217ff089424ULL, 0x000fe200078e00ffULL,
0x000000046b027c10ULL, 0x002fe2000fffe1ffULL, 0x0000580079037a24ULL, 0x000fe200078e02ffULL,
0x01b688060b008388ULL, 0x000fe20000008a00ULL, 0x000000046b007c0cULL, 0x000fc4000bf03070ULL,
0x0000001002027817ULL, 0x000fe20003800000ULL, 0x01b400080b009388ULL, 0x000fe60000004800ULL,
0x000000ff02727207ULL, 0x000fe40000000000ULL, 0x00005a0071027a19ULL, 0x000fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000107200780cULL, 0x000fe20003f05270ULL,
0x0000007403037224ULL, 0x000fc400078e0202ULL, 0x00000005ff027e24ULL, 0x010fe4000f8e00ffULL,
0x0000000409047824ULL, 0x004fc800078e0200ULL, 0x0000000204047824ULL, 0x000fc800078e00ffULL,
0x000001d000008947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff087819ULL, 0x002fca0000011605ULL,
0x00000001040a7824ULL, 0x000fc800078e0208ULL, 0x000000016b067824ULL, 0x000fca00078e020aULL,
0x00000004060c7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff077a19ULL, 0x000fc60000011606ULL,
0x00000001030c7824ULL, 0x000fe200078e020cULL, 0x0000000472037217ULL, 0x000fc60007800000ULL,
0x0000007407077224ULL, 0x000fe200078e020cULL, 0x0000000304037210ULL, 0x000fe20007ffe1ffULL,
0x00000010050c7824ULL, 0x000fe400078e00ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x000000030800720cULL, 0x000fe40003f06070ULL, 0x000000f00c0b7812ULL, 0x000fe200078ec0ffULL,
0x000000010a037824ULL, 0x040fe400078e0205ULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000b060b7212ULL, 0x000fc800078efcffULL, 0xfffffff00a037812ULL, 0x000fe400078ee203ULL,
0x00005e000b067a10ULL, 0x000fc60007f3e0ffULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x00005f0007077a10ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e2000c101c48ULL, 0x0000018000007947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000405047211ULL, 0x042fe200078fe0ffULL, 0x00000010050c7824ULL, 0x000fc800078e00ffULL,
0x000000016b067824ULL, 0x000fe200078e0204ULL, 0x000000f00c0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000406087c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff077a19ULL, 0x000fc60000011606ULL,
0x0000000103087824ULL, 0x000fe400078e0208ULL, 0x0000000104037824ULL, 0x040fe400078e0205ULL,
0x0000007407077224ULL, 0x000fe400078e0208ULL, 0x0000001004047824ULL, 0x000fe400078e00ffULL,
0x0000010007067825ULL, 0x000fc600078e00ffULL, 0xfffffff004037812ULL, 0x000fe400078ee203ULL,
0x0000000b06067212ULL, 0x000fc600078efcffULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x00005e0006067a10ULL, 0x000fc80007f1e0ffULL, 0x00005f0007077a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e8000b901c48ULL,
0x0000000000077919ULL, 0x002e620000000000ULL, 0x0000000000037806ULL, 0x000fc800038e0000ULL,
0x0000000300047300ULL, 0x000e7000000e0000ULL, 0x0000000300067309ULL, 0x000ea20000000000ULL,
0x000000070400720cULL, 0x002fe20003f02070ULL, 0x00000004ff077424ULL, 0x000fc400078e00ffULL,
0x000000ffff047224ULL, 0x004fe400078e0a06ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000660079687625ULL, 0x000fce00078e0007ULL, 0x01b60404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000868687981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe40003f05270ULL,
0x0000007f686d7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff685e7810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff6d7819ULL, 0x000fe4000001166dULL, 0x00000008ff5e7819ULL, 0x000fca000001165eULL,
0x0000b75000008947ULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x00000008006e7824ULL, 0x000fe400078e00ffULL, 0xffffffffff597424ULL, 0x000fe200078e00ffULL,
0x01ffffff03037812ULL, 0x000fca00078ec0ffULL, 0x00000002020b7824ULL, 0x000fca00078e0203ULL,
0x0000006d0b00720cULL, 0x000fda0003f06070ULL, 0x0000000179038819ULL, 0x000fe200000006ffULL,
0x00006800ff048624ULL, 0x002fc800078e00ffULL, 0x0000680003048624ULL, 0x000fe400078e0204ULL,
0x00000003ff037424ULL, 0x000fe400078e00ffULL, 0x000000010b048824ULL, 0x000fe200078e0204ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b68c036eff738cULL, 0x0003e20000000000ULL,
0x0000640004068625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000806598981ULL, 0x000ea2000c1e1900ULL, 0x0000000102097810ULL, 0x000fe20007ffe0ffULL,
0x0000008071697824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011600ULL,
0x00000100ff087424ULL, 0x000fe200078e00ffULL, 0x0000005e0900720cULL, 0x000fe20003f06070ULL,
0x01b688006eff7f8cULL, 0x0007e2000c80043fULL, 0x00000001006a7812ULL, 0x000fe200078ec0ffULL,
0x000000200a6f7824ULL, 0x000fc800078e00ffULL, 0x0000010002107824ULL, 0x000fca00078e026fULL,
0x0000006069047812ULL, 0x000fe200078ef810ULL, 0x0000590059037a24ULL, 0x006fc800078e02ffULL,
0x0000008003037824ULL, 0x000fc800078e00ffULL, 0x0000620003067625ULL, 0x000fe200078e0008ULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff187819ULL, 0x108fe20000011605ULL,
0x000000020a177824ULL, 0x000fe200078e026aULL, 0x0000001068037217ULL, 0x000fe40007800000ULL,
0x00000004180e7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c18167810ULL, 0x040fe20007ffe0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a10ULL, 0x0000000818107810ULL, 0x000fe20007ffe0ffULL,
0x000000010e087824ULL, 0x140fe200078e0205ULL, 0x000000030e197819ULL, 0x000fe200000006ffULL,
0x00000001160f7824ULL, 0x100fe200078e0205ULL, 0x000000700c097812ULL, 0x000fe200078ec0ffULL,
0x0000000816147824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee208ULL,
0x00000001100d7824ULL, 0x040fe200078e0205ULL, 0x0000002003037817ULL, 0x000fe20003800000ULL,
0x0000000810127824ULL, 0x000fe200078e00ffULL, 0xfffffff814217812ULL, 0x000fe200078ee20fULL,
0x000000806a087824ULL, 0x000fe200078e0209ULL, 0x000000030e00720cULL, 0x080fe20003f86070ULL,
0x00000001040f7824ULL, 0x000fe200078e020eULL, 0xfffffff8121f7812ULL, 0x000fe200078ee20dULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00000014181c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001040d7824ULL, 0x000fe200078e0218ULL, 0x00000010181a7810ULL, 0x000fe20007ffe0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0008ULL, 0x000000031000720cULL, 0x000fc40003f66070ULL,
0x000000031600720cULL, 0x080fe20003f46070ULL, 0x000001000d0c7825ULL, 0x000fe200078e0008ULL,
0x0000000e06147210ULL, 0x000fe40007f3e0ffULL, 0x000000031800720cULL, 0x080fe20003fa6070ULL,
0x000000011c137824ULL, 0x000fe200078e0205ULL, 0x0000000c06127210ULL, 0x000fe20007f1e0ffULL,
0x000000081c207824ULL, 0x000fe400078e00ffULL, 0x0000000107157824ULL, 0x040fe200008e060fULL,
0x000000031a00720cULL, 0x040fe20003f26070ULL, 0x000000011a117824ULL, 0x000fe200078e0205ULL,
0xfffffff820277812ULL, 0x000fe200078ee213ULL, 0x000000081a1e7824ULL, 0x000fe200078e00ffULL,
0x0000000d07137210ULL, 0x000fe200007fe4ffULL, 0x00000001040f7824ULL, 0x000fc400078e0216ULL,
0x00000001040d7824ULL, 0x000fe200078e0210ULL, 0xfffffff81e237812ULL, 0x000fe200078ee211ULL,
0x0000000118107824ULL, 0x040fe200078e0205ULL, 0x0000001c181e7810ULL, 0x000fe20007ffe0ffULL,
0x000001000f0e7825ULL, 0x000fc600078e0008ULL, 0x0000000710167812ULL, 0x000fe200078ec0ffULL,
0x0000000104117824ULL, 0x000fe200078e021aULL, 0x0000000e060e7210ULL, 0x000fe20007fde0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0008ULL, 0x00013000171a7811ULL, 0x000fe400078e68ffULL,
0x0ffffff816177812ULL, 0x000fe200078ef805ULL, 0x0000010011107825ULL, 0x000fe200078e0008ULL,
0x0000000c060c7210ULL, 0x000fc60007f1e0ffULL, 0x00000001070f7824ULL, 0x000fe200030e060fULL,
0x0000001006167210ULL, 0x000fe20007fde0ffULL, 0x0000000104257824ULL, 0x000fe400078e021cULL,
0x00000010171b7824ULL, 0x000fe400078e021aULL, 0x0000000107177824ULL, 0x040fe400030e0611ULL,
0x00000001070d7824ULL, 0x000fe200000e060dULL, 0x000000031c00720cULL, 0x080fe20003f06070ULL,
0x0000010025107825ULL, 0x000fe200078e0008ULL, 0x00000018181c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121b7faeULL, 0x0003e4000e901c48ULL,
0x00000010191d7824ULL, 0x000fe200078e021aULL, 0x0000001006187210ULL, 0x000fe20007fde0ffULL,
0x0000000104297824ULL, 0x040fe200078e021eULL, 0x0000001c04257210ULL, 0x000fe20007ffe0ffULL,
0x000000011e047824ULL, 0x000fe200078e0205ULL, 0x00000000141d7faeULL, 0x0005e2000e101c48ULL,
0x0000000107197824ULL, 0x000fe200030e0611ULL, 0x000000031c00720cULL, 0x080fe20003fa6070ULL,
0x0000010025107825ULL, 0x000fe200078e0008ULL, 0x000000031e00720cULL, 0x000fc60003f86070ULL,
0x000000011c037824ULL, 0x000fe200078e0205ULL, 0x0000001006107210ULL, 0x000fe20007fde0ffULL,
0x000000081c1c7824ULL, 0x000fe400078e00ffULL, 0x0000010029087825ULL, 0x000fc600078e0008ULL,
0xfffffff81c037812ULL, 0x000fe200078ee203ULL, 0x000000081e137824ULL, 0x002fe400078e00ffULL,
0x0000000107117824ULL, 0x000fe200030e0611ULL, 0x0000000806067210ULL, 0x000fe20007fde0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e021aULL, 0xfffffff813137812ULL, 0x000fe200078ee204ULL,
0x0000001021217824ULL, 0x100fe400078e021aULL, 0x0000001023237824ULL, 0x100fe200078e021aULL,
0x0000001a13137211ULL, 0x000fe200078e20ffULL, 0x0000001027277824ULL, 0x100fe200078e021aULL,
0x000000000c1f7faeULL, 0x0005e2000d901c48ULL, 0x0000001003037824ULL, 0x000fc400078e021aULL,
0x0000000107077824ULL, 0x000fe200030e0609ULL, 0x000000000e217faeULL, 0x0005e8000d101c48ULL,
0x0000000016237faeULL, 0x0005e8000c901c48ULL, 0x0000000018277faeULL, 0x0005e8000c101c48ULL,
0x0000000010037faeULL, 0x0005e8000e901c48ULL, 0x0000000006137faeULL, 0x0005e2000e101c48ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x0000000405097811ULL, 0x048fe200078fe8ffULL,
0x000000020a1d7824ULL, 0x000fe200078e026aULL, 0x00000008050e7811ULL, 0x000fc400078fe8ffULL,
0x0000000c05107811ULL, 0x000fe200078fe8ffULL, 0x0000000109037824ULL, 0x100fe200078e0205ULL,
0x0000001005127811ULL, 0x000fe200078fe8ffULL, 0x00000008091a7824ULL, 0x000fe200078e00ffULL,
0x0000001805167811ULL, 0x040fe200078fe8ffULL, 0x000000010e087824ULL, 0x040fe200078e0205ULL,
0x0000001405147811ULL, 0x000fe200078fe8ffULL, 0x000000080e0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL, 0x0000000110037824ULL, 0x100fe200078e0205ULL,
0x0000000316247819ULL, 0x000fe200000006ffULL, 0x00000008101e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d1c7812ULL, 0x000fe200078ee208ULL, 0x0000000112087824ULL, 0x000fe200078e0205ULL,
0x000000700c197812ULL, 0x000fe200078ec0ffULL, 0x0000000812117824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL, 0x00000001160f7824ULL, 0x100fe200078e0205ULL,
0x0000000505037211ULL, 0x040fe200078fe8ffULL, 0x00000001140d7824ULL, 0x040fe200078e0205ULL,
0x0000001c050c7811ULL, 0x000fe200078fe8ffULL, 0x0000000814227824ULL, 0x000fe200078e00ffULL,
0xfffffff811207812ULL, 0x000fe200078ee208ULL, 0x000000806a187824ULL, 0x000fe200078e0219ULL,
0xfffffff824247812ULL, 0x000fe200078ee20fULL, 0x00000001040f7824ULL, 0x000fe200078e020eULL,
0x0000000703087812ULL, 0x000fe200078ec0ffULL, 0x000000010c037824ULL, 0x000fe200078e0205ULL,
0xfffffff822227812ULL, 0x000fe200078ee20dULL, 0x000000080c0e7824ULL, 0x000fe200078e00ffULL,
0x000130001d277811ULL, 0x000fe200078e68ffULL, 0x00000001040d7824ULL, 0x000fe200078e0209ULL,
0x0000000405097211ULL, 0x000fe200078fe8ffULL, 0x000000ffff197224ULL, 0x000fc400078e00ffULL,
0x0000000104117824ULL, 0x040fe400078e0210ULL, 0x0000000104137824ULL, 0x040fe400078e0212ULL,
0x0000000104157824ULL, 0x040fe400078e0214ULL, 0x0000000104177824ULL, 0x040fe400078e0216ULL,
0x00000001041b7824ULL, 0x000fe200078e020cULL, 0xfffffff80e047812ULL, 0x000fe200078ee203ULL,
0x000001000d0c7825ULL, 0x000fe200078e0018ULL, 0x0ffffff808037812ULL, 0x000fc600078ef805ULL,
0x0000010009087825ULL, 0x100fe200078e0018ULL, 0x0000000c060c7210ULL, 0x040fe40007f3e0ffULL,
0x0000002703037211ULL, 0x000fe200078e20ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0018ULL,
0x0000000806087210ULL, 0x000fc60007f1e0ffULL, 0x0000010011107825ULL, 0x000fe200078e0018ULL,
0x0000000e060e7210ULL, 0x000fc60007f5e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0018ULL,
0x0000001006107210ULL, 0x000fc60007f7e0ffULL, 0x0000010015147825ULL, 0x000fc800078e0018ULL,
0x0000010017167825ULL, 0x000fc800078e0018ULL, 0x000001001b187825ULL, 0x000fc800078e0018ULL,
0x0000000107097824ULL, 0x040fe200000e0609ULL, 0x0000001206127210ULL, 0x040fe20007f1e0ffULL,
0x00000001070d7824ULL, 0x040fe200008e060dULL, 0x0000001406147210ULL, 0x040fe20007f3e0ffULL,
0x00000001070f7824ULL, 0x040fe200010e060fULL, 0x0000001606167210ULL, 0x000fe20007f5e0ffULL,
0x000000101a1b7824ULL, 0x000fe200078e0227ULL, 0x0000001507157210ULL, 0x040fe20000ffe4ffULL,
0x0000000107117824ULL, 0x000fe200018e0611ULL, 0x0000001806067210ULL, 0x000fe20007f7e0ffULL,
0x000000101c1d7824ULL, 0x100fe200078e0227ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008037faeULL, 0x0003e2000b901c48ULL, 0x000000101e1f7824ULL, 0x000fc400078e0227ULL,
0x0000001020217824ULL, 0x000fe200078e0227ULL, 0x000000000c1b7faeULL, 0x0003e2000b901c48ULL,
0x0000000107137824ULL, 0x040fe400000e0613ULL, 0x0000001022237824ULL, 0x100fe200078e0227ULL,
0x000000000e1d7faeULL, 0x0003e2000b901c48ULL, 0x0000001024257824ULL, 0x000fe400078e0227ULL,
0x0000000107177824ULL, 0x000fe200010e0617ULL, 0x00000000101f7faeULL, 0x0003e2000b901c48ULL,
0x0000001004277824ULL, 0x000fc400078e0227ULL, 0x0000000107077824ULL, 0x000fe200018e0619ULL,
0x0000000012217faeULL, 0x0003e8000b901c48ULL, 0x0000000014237faeULL, 0x0003e8000b901c48ULL,
0x0000000016257faeULL, 0x0003e8000b901c48ULL, 0x0000000006277faeULL, 0x0003e4000b901c48ULL,
0x0000005e0200720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff0c7424ULL, 0x006fe200078e00ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00006d0000000947ULL, 0x000fea0003800000ULL, 0x00000002796c7824ULL, 0x000fe400078e00ffULL,
0x00006800ff037624ULL, 0x000fc400078e00ffULL, 0xff317217ff0c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x000068006c6c7624ULL, 0x000fc400078e0203ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001020d7810ULL, 0x000fe20007ffe0ffULL,
0x0000590059597a24ULL, 0x010fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe008097812ULL, 0x000fe200078ec0ffULL, 0x0000008059087824ULL, 0x000fe200078e00ffULL,
0x0000005e0d00720cULL, 0x000fc60003f06070ULL, 0x0000010002097824ULL, 0x000fca00078e0209ULL,
0x00000040090f7810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff097424ULL, 0x000fc600078e00ffULL,
0x000000600f307812ULL, 0x020fe200078ec0ffULL, 0x0000620008087625ULL, 0x000fc600078e0009ULL,
0x0000003069307210ULL, 0x000fe20007ffe0ffULL, 0x0000068000008947ULL, 0x000fea0003800000ULL,
0x0000000f680d7217ULL, 0x000fe20007800000ULL, 0x0000001005247824ULL, 0x000fe200078e00ffULL,
0x00000003ff387819ULL, 0x000fe20000011605ULL, 0x00000080000e7824ULL, 0x000fe400078e00ffULL,
0x000000010d0f7824ULL, 0x000fe200078e0a0fULL, 0x0000000438287810ULL, 0x000fe20007ffe0ffULL,
0x00002000000d7824ULL, 0x000fe200078e00ffULL, 0x0000007024257812ULL, 0x000fe400078ec0ffULL,
0x0000000838367810ULL, 0x000fe20007ffe0ffULL, 0x0000000128247824ULL, 0x140fe200078e0205ULL,
0x00000080250e7812ULL, 0x000fe200078ef80eULL, 0x0000000828397824ULL, 0x000fe200078e00ffULL,
0x000020000d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000136257824ULL, 0x000fe200078e0205ULL,
0x0000000c383a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000836267824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee224ULL, 0x000040000a347824ULL, 0x000fe200078e020dULL,
0x000000200f337817ULL, 0x000fe20003800000ULL, 0x000000013a317824ULL, 0x000fe200078e0205ULL,
0xfffffff8260d7812ULL, 0x000fe200078ee225ULL, 0x000000083a247824ULL, 0x000fe200078e00ffULL,
0x00000010383c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000138257824ULL, 0x040fe200078e0230ULL,
0x00000014383e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0xfffffff824317812ULL, 0x000fe200078ee231ULL, 0x000000013c327824ULL, 0x040fe200078e0205ULL,
0x000000033c277819ULL, 0x000fe200000006ffULL, 0x0000010025247825ULL, 0x000fe200078e000eULL,
0x000000333a00720cULL, 0x000fc40003f26070ULL, 0xfffffff827327812ULL, 0x000fe200078ee232ULL,
0x000000013e0a7824ULL, 0x100fe200078e0205ULL, 0x00000024082a7210ULL, 0x000fe20007f5e0ffULL,
0x000000083e297824ULL, 0x000fe200078e00ffULL, 0x000000332800720cULL, 0x080fe20003f66070ULL,
0x0000000138267824ULL, 0x000fe200078e0205ULL, 0x000000333600720cULL, 0x080fe20003f06070ULL,
0x0000000128277824ULL, 0x000fe200078e0230ULL, 0xfffffff8290a7812ULL, 0x000fe200078ee20aULL,
0x0000000136297824ULL, 0x100fe200078e0230ULL, 0x0001400034367810ULL, 0x000fe20007ffe0ffULL,
0x000000013a357824ULL, 0x000fe200078e0230ULL, 0x00000007263a7812ULL, 0x000fe200078ec0ffULL,
0x00000001092b7824ULL, 0x000fe200010e0625ULL, 0x000000333800720cULL, 0x000fe20003f86070ULL,
0x0000010027247825ULL, 0x000fe200078e000eULL, 0x0ffffff83a377812ULL, 0x000fc400078ef805ULL,
0x00000018383a7810ULL, 0x000fe20007ffe0ffULL, 0x0000010029267825ULL, 0x100fe200078e000eULL,
0x0000002408347210ULL, 0x040fe40007f5e0ffULL, 0x0000003637377211ULL, 0x000fe200078e20ffULL,
0x0000010035287825ULL, 0x000fe200078e000eULL, 0x0000002608247210ULL, 0x000fe40007fbe0ffULL,
0x0000001c38387810ULL, 0x000fe20007ffe0ffULL, 0x0000000109357824ULL, 0x040fe200010e0625ULL,
0x0000002808267210ULL, 0x000fe20007fde0ffULL, 0x0000000109257824ULL, 0x000fe200028e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0003e2000e101c48ULL,
0x0000001039397824ULL, 0x000fe200078e0236ULL, 0x000000333c00720cULL, 0x080fe20003f46070ULL,
0x0000000109277824ULL, 0x000fe200030e0629ULL, 0x000000333e00720cULL, 0x080fe20003fa6070ULL,
0x000000013c297824ULL, 0x100fe200078e0230ULL, 0x0000000034397faeULL, 0x0005e2000d901c48ULL,
0x000000013e3b7824ULL, 0x000fe200078e0230ULL, 0x000000333a00720cULL, 0x080fe20003f86070ULL,
0x0000010029287825ULL, 0x000fe200078e000eULL, 0x000000333800720cULL, 0x000fc40003f66070ULL,
0x000000360d0d7211ULL, 0x000fe200078e20ffULL, 0x000001003b2a7825ULL, 0x002fe200078e000eULL,
0x0000002808287210ULL, 0x000fc60007fde0ffULL, 0x000000013a337824ULL, 0x000fe200078e0230ULL,
0x00000000240d7faeULL, 0x0003e2000c101c48ULL, 0x0000000109297824ULL, 0x000fe200030e0629ULL,
0x0000002a082a7210ULL, 0x000fe20007fde0ffULL, 0x0000010033347825ULL, 0x004fc800078e000eULL,
0x0000000138377824ULL, 0x000fe400078e0230ULL, 0x00000001092b7824ULL, 0x000fe200030e062bULL,
0x0000003408347210ULL, 0x000fe20007fde0ffULL, 0x000000013a307824ULL, 0x140fe400078e0205ULL,
0x000000083a397824ULL, 0x000fe400078e00ffULL, 0x0000000138337824ULL, 0x040fe400078e0205ULL,
0x0000000838387824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee230ULL,
0x00000100370e7825ULL, 0x000fc600078e000eULL, 0xfffffff8383b7812ULL, 0x000fe200078ee233ULL,
0x0000000109357824ULL, 0x000fe200030e0635ULL, 0x0000000e08087210ULL, 0x000fe20007fde0ffULL,
0x0000001031317824ULL, 0x100fe400078e0236ULL, 0x0000001032337824ULL, 0x100fe400078e0236ULL,
0x000000100a377824ULL, 0x100fe200078e0236ULL, 0x0000000026317faeULL, 0x0003e2000c901c48ULL,
0x0000001039397824ULL, 0x100fe400078e0236ULL, 0x000000103b3b7824ULL, 0x000fe200078e0236ULL,
0x0000000028337faeULL, 0x0003e2000d101c48ULL, 0x0000000109097824ULL, 0x000fc600030e060fULL,
0x000000002a377faeULL, 0x0003e8000e901c48ULL, 0x0000000034397faeULL, 0x0003e8000e101c48ULL,
0x00000000083b7faeULL, 0x0003e2000d901c48ULL, 0x000005b000007947ULL, 0x000fea0003800000ULL,
0x00002000000e7824ULL, 0x040fe200078e00ffULL, 0x0000000405257811ULL, 0x040fe200078fe8ffULL,
0x00000010050d7824ULL, 0x040fe200078e00ffULL, 0x0000000805277811ULL, 0x000fe200078fe8ffULL,
0x0000008000347824ULL, 0x000fe200078e00ffULL, 0x000020000e0f7812ULL, 0x000fe200078ec0ffULL,
0x00000008252b7824ULL, 0x000fe200078e00ffULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000827387824ULL, 0x000fe200078e00ffULL, 0x0000001405317811ULL, 0x000fe200078fe8ffULL,
0x000040000a0e7824ULL, 0x000fe200078e020fULL, 0x000000800d347812ULL, 0x000fe200078ef834ULL,
0x00000001250a7824ULL, 0x000fe200078e0205ULL, 0x00000005270d7210ULL, 0x080fe20007ffe0ffULL,
0x00000008313e7824ULL, 0x000fe200078e00ffULL, 0x0000000c05297811ULL, 0x000fe200078fe8ffULL,
0x0000000125257824ULL, 0x000fe200078e0230ULL, 0xfffffff82b367812ULL, 0x000fe200078ee20aULL,
0x0000000127277824ULL, 0x000fe200078e0230ULL, 0xfffffff838387812ULL, 0x000fe200078ee20dULL,
0x00000001310d7824ULL, 0x100fe200078e0205ULL, 0x00000010052b7811ULL, 0x000fe200078fe8ffULL,
0x00000001290f7824ULL, 0x000fe200078e0205ULL, 0x0000001805337811ULL, 0x000fe200078fe8ffULL,
0x00000008293a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL,
0x000000012b0a7824ULL, 0x000fe200078e0205ULL, 0x0000001c050d7811ULL, 0x000fe200078fe8ffULL,
0x000000082b357824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL,
0x00000001330f7824ULL, 0x140fe200078e0205ULL, 0x000140000e437810ULL, 0x000fe20007ffe0ffULL,
0x0000000833407824ULL, 0x000fe200078e00ffULL, 0xfffffff8353c7812ULL, 0x000fe200078ee20aULL,
0x000000010d247824ULL, 0x000fe200078e0205ULL, 0x00000005050a7211ULL, 0x000fe200078fe8ffULL,
0x000000080d357824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee20fULL,
0x0000000129297824ULL, 0x100fe200078e0230ULL, 0x00000030050f7211ULL, 0x080fe200078fe8ffULL,
0x0000000131317824ULL, 0x000fe200078e0230ULL, 0xfffffff835427812ULL, 0x000fe200078ee224ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000000302b2b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000133337824ULL, 0x000fe200078e0230ULL, 0x000000070a0a7812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0034ULL, 0x0000004340417211ULL, 0x000fc400078e20ffULL,
0x0ffffff80a0a7812ULL, 0x000fe200078ef805ULL, 0x0000010025247825ULL, 0x000fe200078e0034ULL,
0x0000000e080e7210ULL, 0x000fc60007f1e0ffULL, 0x0000010027267825ULL, 0x000fe200078e0034ULL,
0x0000002408247210ULL, 0x000fc60007f3e0ffULL, 0x0000010029287825ULL, 0x000fe200078e0034ULL,
0x0000002608267210ULL, 0x000fc60007f5e0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0230ULL,
0x0000002808287210ULL, 0x000fe20007f7e0ffULL, 0x000001002b2a7825ULL, 0x000fc800078e0034ULL,
0x0000010031307825ULL, 0x000fc800078e0034ULL, 0x0000010033327825ULL, 0x000fc800078e0034ULL,
0x000001000d347825ULL, 0x000fc800078e0034ULL, 0x00000001090f7824ULL, 0x040fe200000e060fULL,
0x0000002a082a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000109257824ULL, 0x040fe200008e0625ULL,
0x0000003008307210ULL, 0x000fe20007f3e0ffULL, 0x000000100a0d7824ULL, 0x000fe400078e0243ULL,
0x0000000109277824ULL, 0x040fe200010e0627ULL, 0x0000003208327210ULL, 0x000fe20007f5e0ffULL,
0x0000001036377824ULL, 0x000fe200078e0243ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0d7faeULL, 0x0003e2000b901c48ULL, 0x0000000109297824ULL, 0x000fe200018e0629ULL,
0x0000003408087210ULL, 0x000fe20007f7e0ffULL, 0x0000001038397824ULL, 0x100fe200078e0243ULL,
0x0000000024377faeULL, 0x0003e2000b901c48ULL, 0x000000103a3b7824ULL, 0x000fc400078e0243ULL,
0x000000103c3d7824ULL, 0x000fe200078e0243ULL, 0x0000000026397faeULL, 0x0003e2000b901c48ULL,
0x00000001092b7824ULL, 0x040fe400000e062bULL, 0x000000103e3f7824ULL, 0x000fe200078e0243ULL,
0x00000000283b7faeULL, 0x0003e2000b901c48ULL, 0x0000000109317824ULL, 0x040fe400008e0631ULL,
0x0000000109337824ULL, 0x000fe200010e0633ULL, 0x000000002a3d7faeULL, 0x0003e2000b901c48ULL,
0x0000001042437824ULL, 0x000fc400078e0243ULL, 0x0000000109097824ULL, 0x000fe200018e0635ULL,
0x00000000303f7faeULL, 0x0003e8000b901c48ULL, 0x0000000032417faeULL, 0x0003e8000b901c48ULL,
0x0000000008437faeULL, 0x0003e4000b901c48ULL, 0x00000300ff087624ULL, 0x002fe200078e00ffULL,
0x000000010b097812ULL, 0x000fe200078ec0ffULL, 0xffffffffff4c7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000010900780cULL, 0x000fc40003f05070ULL,
0xffffffff08087811ULL, 0x000fc800078e08ffULL, 0x0000000108087807ULL, 0x000fca0004000000ULL,
0x00000001080b7824ULL, 0x000fca00078e020bULL, 0x0000006d0b00720cULL, 0x000fda0003f06070ULL,
0x0000000400098802ULL, 0x000fe20000000f00ULL, 0x000000016c088824ULL, 0x000fc800078e020bULL,
0x0000640008088625ULL, 0x000fca00078e0009ULL, 0x00000008084c8981ULL, 0x000322000c1e1900ULL,
0xffffffe06e0a7812ULL, 0x040fe400078ec0ffULL, 0x000000106e0d7812ULL, 0x040fe400078ec0ffULL,
0x000000086e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fe20007ffe00dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b608000a247f8cULL, 0x0022a4000c80043fULL,
0x0000000000087805ULL, 0x000fc40000015200ULL, 0x01b60c000a0d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e080e7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e09ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc8000001140fULL, 0x0000000e0d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e060fULL, 0x000000020d0d7819ULL, 0x000fc8000000120eULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000126267810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b60c000a0d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010056b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff707819ULL, 0x000fe20000011605ULL, 0x00000020005c7824ULL, 0x000fc600078e00ffULL,
0x000000706b6b7812ULL, 0x000fe400078ec0ffULL, 0xffffff805c5c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c70707812ULL, 0x000fc800078ec0ffULL, 0x0000005c70087210ULL, 0x000fca0007ffe06bULL,
0x01b00000080d7984ULL, 0x000ea80000000800ULL, 0x01b20000080a7984ULL, 0x0022e20000000800ULL,
0x0000000c0d00720bULL, 0x004fe20003f1d000ULL, 0x00011b727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x002fc800000e0100ULL, 0x0000ffff09257812ULL, 0x000fe2000782c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff087224ULL, 0x000fd400078e000cULL, 0x0000043000009947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe40000011600ULL, 0x0000000c0d00720bULL, 0x000fe40003f34000ULL,
0x000000000900720cULL, 0x000fe20003f05270ULL, 0x00011b227f007947ULL, 0x000fd4000b800000ULL,
0x0000000000247806ULL, 0x000fc400008e0100ULL, 0x0000008000098824ULL, 0x000fe200078e026bULL,
0x0000000c0d087209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910240e7816ULL, 0x000fe200000000ffULL, 0x0000000170098824ULL, 0x000fca00078e0209ULL,
0x01b4000809008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000c08097221ULL, 0x002fe20000010100ULL,
0x000000ff24ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009000c7308ULL, 0x000e640000000800ULL,
0x0000000c07077220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe20000011605ULL, 0x00011a627f007947ULL, 0x000fea000b800000ULL,
0x00001f090c097589ULL, 0x0002a400000e0000ULL, 0x0000000910107220ULL, 0x084fe40000410000ULL,
0x0000000911117220ULL, 0x080fe40000410000ULL, 0x0000000914147220ULL, 0x080fe40000410000ULL,
0x0000000915157220ULL, 0x080fe40000410000ULL, 0x0000000918187220ULL, 0x080fe40000410000ULL,
0x0000000919197220ULL, 0x000fc40000410000ULL, 0x0000000950507220ULL, 0x080fe40000410000ULL,
0x0000000951517220ULL, 0x080fe40000410000ULL, 0x0000000954547220ULL, 0x080fe40000410000ULL,
0x0000000955557220ULL, 0x080fe40000410000ULL, 0x000000092c2c7220ULL, 0x080fe40000410000ULL,
0x000000092d2d7220ULL, 0x000fc40000410000ULL, 0x0000000920207220ULL, 0x080fe40000410000ULL,
0x0000000921217220ULL, 0x080fe40000410000ULL, 0x000000091c1c7220ULL, 0x080fe40000410000ULL,
0x000000091d1d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000805097811ULL, 0x000fe200078ff0ffULL, 0x000119627f007947ULL, 0x000fea000b800000ULL,
0x00001f090c097589ULL, 0x00046400000e0000ULL, 0x0000000912127220ULL, 0x086fe40000410000ULL,
0x0000000913137220ULL, 0x080fe40000410000ULL, 0x0000000916167220ULL, 0x080fe40000410000ULL,
0x0000000917177220ULL, 0x080fe40000410000ULL, 0x000000091a1a7220ULL, 0x080fe40000410000ULL,
0x000000091b1b7220ULL, 0x000fc40000410000ULL, 0x0000000952527220ULL, 0x080fe40000410000ULL,
0x0000000953537220ULL, 0x080fe40000410000ULL, 0x0000000956567220ULL, 0x080fe40000410000ULL,
0x0000000957577220ULL, 0x080fe40000410000ULL, 0x000000092e2e7220ULL, 0x080fe40000410000ULL,
0x000000092f2f7220ULL, 0x000fc40000410000ULL, 0x0000000922227220ULL, 0x080fe40000410000ULL,
0x0000000923237220ULL, 0x080fe40000410000ULL, 0x000000091e1e7220ULL, 0x080fe40000410000ULL,
0x000000091f1f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff25ff7812ULL, 0x000fda0007806024ULL, 0x800000080d0d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL, 0x0000000d00030308ULL, 0x000e640000000800ULL,
0x000000030a0a0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000070a077221ULL, 0x008fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000003ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011605ULL,
0x00005410040a7816ULL, 0x000fe20000000004ULL, 0x000117c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0a047589ULL, 0x0002a400000e0000ULL, 0x000000080d097810ULL, 0x000fe20007ffe0ffULL,
0x000118127f007947ULL, 0x000fea000b800000ULL, 0x00001f090a067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100d097810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x000030b0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000124c000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180d097810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000aULL,
0x00003120000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0001245000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002004e7824ULL, 0x040fe200078e00ffULL,
0x00000007050d7812ULL, 0x002fe200078ec0ffULL, 0x0000020000097824ULL, 0x00cfe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000000044e0a7812ULL, 0x000fc400078ec0ffULL,
0x000000080d0c7812ULL, 0x000fe400078ef805ULL, 0x0000000a05677211ULL, 0x000fe400078fe0ffULL,
0xfffff800090e7812ULL, 0x000fe200078ec0ffULL, 0x000000080c0a7824ULL, 0x040fe400078e00ffULL,
0x000000010c677824ULL, 0x000fca00078e0267ULL, 0xfffffff80a5d7812ULL, 0x000fe400078ee267ULL,
0x00000008050a7812ULL, 0x000fc600078ec0ffULL, 0x000000105d5d7824ULL, 0x000fc800078e020eULL,
0x00000001ff097819ULL, 0x000fe20000011600ULL, 0x011000005d38783bULL, 0x000e620000000200ULL,
0x00000004ff267819ULL, 0x000fe20000011605ULL, 0x000059004c4c7a24ULL, 0x010fe200078e02ffULL,
0x0000000d0a0f7212ULL, 0x040fe400078efcffULL, 0x000000100a287812ULL, 0x000fe200078efe0dULL,
0x00000002090a7824ULL, 0x000fe200078e026aULL, 0x0000000f26247210ULL, 0x000fe20007ffe0ffULL,
0x000000080f617824ULL, 0x000fe200078e00ffULL, 0x0000002805657211ULL, 0x000fe200078fe0ffULL,
0x00000004090d7824ULL, 0x000fe200078e0226ULL, 0x0000000224607810ULL, 0x040fe20007ffe0ffULL,
0x000000080f257824ULL, 0x000fe200078e00ffULL, 0x00000004245f7810ULL, 0x000fe20007ffe0ffULL,
0x000020000a0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff861617812ULL, 0x000fe200078ee224ULL,
0x000000080f267824ULL, 0x040fe200078e00ffULL, 0x0000000624627810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x000000020d0d7810ULL, 0x000fe20007ffe00cULL,
0x000000080c247824ULL, 0x000fe200078e00ffULL, 0xfffffff825607812ULL, 0x000fe200078ee260ULL,
0x0000000828307824ULL, 0x000fe200078e00ffULL, 0x000130000a0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8265f7812ULL, 0x000fc400078ee25fULL,
0xfffffff80f627812ULL, 0x000fe200078ee262ULL, 0x0000001060587824ULL, 0x100fe200078e020cULL,
0xfffffff8240d7812ULL, 0x000fe200078ee20dULL, 0x000000105f447824ULL, 0x100fe200078e020cULL,
0x0000000c623c7211ULL, 0x000fe200078e20ffULL, 0x0000001061407824ULL, 0x000fe200078e020cULL,
0x0000000465637810ULL, 0x000fe20007ffe0ffULL, 0x000000005858783bULL, 0x000ea20000004200ULL,
0x000000100d4d7824ULL, 0x000fe200078e00ffULL, 0x0000000265647810ULL, 0x040fe20007ffe0ffULL,
0x00000008280f7824ULL, 0x040fe200078e00ffULL, 0x000000004444783bULL, 0x000ee20000004200ULL,
0x00000008280d7824ULL, 0x000fe200078e00ffULL, 0x0000000665667810ULL, 0x000fe20007ffe0ffULL,
0x0000000438380231ULL, 0x082fe200003400ffULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0x000110000e0e7810ULL, 0x000fe20007ffe04dULL, 0x000000043a3a0231ULL, 0x000fe200003400ffULL,
0xfffffff830637812ULL, 0x000fe200078ee263ULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0xfffffff80f647812ULL, 0x000fe200078ee264ULL, 0x0000000639390231ULL, 0x080fe200003400ffULL,
0xfffffff82a657812ULL, 0x000fe200078ee265ULL, 0x000000000e24783bULL, 0x000e620000000200ULL,
0xfffffff80d667812ULL, 0x000fe200078ee266ULL, 0x0000001063307824ULL, 0x100fe200078e020cULL,
0x000000063b3b0231ULL, 0x000fe200003400ffULL, 0x0000001064347824ULL, 0x100fe200078e020cULL,
0xfffffff84e4e7812ULL, 0x000fe200078ec0ffULL, 0x0000001065287824ULL, 0x000fc400078e020cULL,
0x00000010660c7824ULL, 0x000fe200078e020cULL, 0x000000003030783bULL, 0x000e680000004200ULL,
0x000000002828783bULL, 0x000e680000004200ULL, 0x000000003434783bULL, 0x000e680000004200ULL,
0x000000000c0c783bULL, 0x000e620000004200ULL, 0x000000583848723cULL, 0x044ff00000041818ULL,
0x000000443818723cULL, 0x048ff00000041854ULL, 0x00000046382c723cULL, 0x000f62000004182cULL,
0x0000000424240231ULL, 0x002fc400003400ffULL, 0x0000000426260231ULL, 0x000fe400003400ffULL,
0x0000000625250231ULL, 0x080fe400003400ffULL, 0x0000000627270231ULL, 0x000fe200003400ffULL,
0x000000403844723cULL, 0x040f700000041810ULL, 0x0000005a3850723cULL, 0x040f700000041850ULL,
0x000000423840723cULL, 0x040f700000041814ULL, 0x0000003c3820723cULL, 0x040f700000041820ULL,
0x0000003e3838723cULL, 0x000f70000004181cULL, 0x00000032241c723cULL, 0x060f70000004182cULL,
0x00000028242c723cULL, 0x040f700000041844ULL, 0x000000342410723cULL, 0x040f700000041848ULL,
0x000000362414723cULL, 0x040f700000041850ULL, 0x000000302418723cULL, 0x040f700000041818ULL,
0x0000002a2428723cULL, 0x040f700000041840ULL, 0x0000000c2420723cULL, 0x040b6e0000041820ULL,
0x00000008020c7824ULL, 0x020fe200078e0209ULL, 0x0000000e2424723cULL, 0x000b620000041838ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000001020d7810ULL, 0x000fe20007ffe0ffULL,
0x01b688004eff7f8cULL, 0x0003e2000c80043fULL, 0x000000800c0f7811ULL, 0x020fe200078e28ffULL,
0x00000100ff317424ULL, 0x000fe200078e00ffULL, 0x0000005e0d00720cULL, 0x000fe20003f06070ULL,
0x000000804c0c7824ULL, 0x000fe200078e00ffULL, 0x000000600f3c7812ULL, 0x000fc600078ec0ffULL,
0x000062000c0c7625ULL, 0x000fc800078e0031ULL, 0x00000001693c7824ULL, 0x000fe200078e023cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff3f7819ULL, 0x002fe40000011605ULL, 0x0000000f680e7217ULL, 0x000fe40007800000ULL,
0x000000043f317810ULL, 0x040fe20007ffe0ffULL, 0x000000013f337824ULL, 0x040fe200078e023cULL,
0x0000000d00307819ULL, 0x000fe200000006ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a0fULL,
0x000000083f357810ULL, 0x000fe20007ffe0ffULL, 0x00000001313a7824ULL, 0x140fe200078e0205ULL,
0x0000200030327812ULL, 0x000fe200078ec0ffULL, 0x00000008310f7824ULL, 0x000fe200078e00ffULL,
0x000000200e427817ULL, 0x000fe20003800000ULL, 0x0000008000307824ULL, 0x000fe200078e00ffULL,
0x0000000c3f377810ULL, 0x000fe20007ffe0ffULL, 0x0000400009417824ULL, 0x000fe200078e0232ULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL, 0x00000001310f7824ULL, 0x000fe200078e023cULL,
0x000000806b307812ULL, 0x000fe200078ef830ULL, 0x00000001353d7824ULL, 0x000fe200078e0205ULL,
0x000000423100720cULL, 0x080fe20003f86070ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x000000143f457810ULL, 0x000fe20007ffe0ffULL, 0x0000000835347824ULL, 0x040fe200078e00ffULL,
0x000000423500720cULL, 0x080fe20003f66070ULL, 0x0000010033327825ULL, 0x000fe200078e0030ULL,
0x000000423700720cULL, 0x000fc40003f46070ULL, 0xfffffff8343d7812ULL, 0x000fe200078ee23dULL,
0x000001000f0e7825ULL, 0x000fe200078e0030ULL, 0x000000320c387210ULL, 0x040fe40007f1e0ffULL,
0x000000103f3b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000137407824ULL, 0x140fe200078e0205ULL,
0x0000000e0c327210ULL, 0x000fe20007f3e0ffULL, 0x0000000837397824ULL, 0x000fe200078e00ffULL,
0x000000053b3e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000145097824ULL, 0x000fe200078e0205ULL,
0x000000423f00720cULL, 0x080fe20003fa6070ULL, 0x0000000845347824ULL, 0x000fe200078e00ffULL,
0xfffffff839407812ULL, 0x000fe200078ee240ULL, 0x0000000135357824ULL, 0x100fe200078e023cULL,
0x0001300041417810ULL, 0x000fe20007ffe0ffULL, 0x0000000137377824ULL, 0x000fe200078e023cULL,
0xfffffff834097812ULL, 0x000fe200078ee209ULL, 0x000000010d397824ULL, 0x000fe200000e0633ULL,
0x000000183f497810ULL, 0x000fe20007ffe0ffULL, 0x000000010d337824ULL, 0x000fe200008e060fULL,
0x000000423b00720cULL, 0x000fe20003f26070ULL, 0x000000013f367824ULL, 0x040fe200078e0205ULL,
0x0000001c3f4b7810ULL, 0x000fe20007ffe0ffULL, 0x00000100350e7825ULL, 0x000fc600078e0030ULL,
0x0000000736447812ULL, 0x000fe200078ec0ffULL, 0x0000010037347825ULL, 0x000fe200078e0030ULL,
0x0000000e0c0e7210ULL, 0x000fe40007f1e0ffULL, 0x0ffffff844447812ULL, 0x000fe200078ef805ULL,
0x000000083b437824ULL, 0x040fe200078e00ffULL, 0x000000340c347210ULL, 0x000fe20007fde0ffULL,
0x000000013b3b7824ULL, 0x000fe400078e023cULL, 0x000000010d0f7824ULL, 0x000fe200000e060fULL,
0x000000424500720cULL, 0x000fe20003f06070ULL, 0x000001003b367825ULL, 0x000fe200078e0030ULL,
0x0000003c453b7210ULL, 0x000fc40007ffe0ffULL, 0xfffffff8433e7812ULL, 0x000fe200078ee23eULL,
0x000000010d357824ULL, 0x000fe200030e0635ULL, 0x000000360c367210ULL, 0x000fe20007fde0ffULL,
0x000000103a457824ULL, 0x100fe400078e0241ULL, 0x0000001044437824ULL, 0x000fe400078e0241ULL,
0x000001003b3a7825ULL, 0x000fc600078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038437faeULL, 0x0003e2000e901c48ULL, 0x00000001493f7824ULL, 0x140fe200078e023cULL,
0x000000424900720cULL, 0x000fe20003fa6070ULL, 0x000000010d377824ULL, 0x000fe200030e0637ULL,
0x0000003a0c3a7210ULL, 0x000fe20007fde0ffULL, 0x0000000032457faeULL, 0x0005e2000e101c48ULL,
0x000000014b477824ULL, 0x040fe200078e023cULL, 0x000000424b00720cULL, 0x000fe20003f86070ULL,
0x00000001493c7824ULL, 0x000fe400078e0205ULL, 0x000000010d3b7824ULL, 0x000fc400030e063bULL,
0x000001003f387825ULL, 0x002fe200078e0030ULL, 0x000000413e3f7211ULL, 0x000fc600078e20ffULL,
0x000000084b427824ULL, 0x040fe200078e00ffULL, 0x000000380c327210ULL, 0x004fe20007fde0ffULL,
0x000000014b337824ULL, 0x000fe400078e0205ULL, 0x0000000849497824ULL, 0x000fe400078e00ffULL,
0x0000010047307825ULL, 0x000fe200078e0030ULL, 0xfffffff842387812ULL, 0x000fe400078ee233ULL,
0xfffffff8493c7812ULL, 0x000fe200078ee23cULL, 0x000000010d337824ULL, 0x000fe200030e0639ULL,
0x000000300c307210ULL, 0x000fe20007fde0ffULL, 0x000000103d3d7824ULL, 0x000fc400078e0241ULL,
0x0000001040397824ULL, 0x100fe400078e0241ULL, 0x0000001009097824ULL, 0x100fe200078e0241ULL,
0x000000000e3d7faeULL, 0x0003e2000d901c48ULL, 0x000000103c437824ULL, 0x100fe400078e0241ULL,
0x0000001038417824ULL, 0x000fe200078e0241ULL, 0x0000000034397faeULL, 0x0003e2000d101c48ULL,
0x000000010d317824ULL, 0x000fc600030e0631ULL, 0x00000000363f7faeULL, 0x0003e8000c901c48ULL,
0x000000003a097faeULL, 0x0003e8000c101c48ULL, 0x0000000032437faeULL, 0x0003e8000e901c48ULL,
0x0000000030417faeULL, 0x0003e2000e101c48ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000c053b7811ULL, 0x042fe200078fe8ffULL, 0x00002000000e7824ULL, 0x040fe200078e00ffULL,
0x00000010050f7811ULL, 0x040fe200078fe8ffULL, 0x0000008000347824ULL, 0x000fe200078e00ffULL,
0x00000008053d7811ULL, 0x000fe200078fe8ffULL, 0x000000013b3f7824ULL, 0x140fe200078e0205ULL,
0x000020000e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000083b327824ULL, 0x000fe200078e00ffULL,
0x000000050f407210ULL, 0x0c0fe20007ffe0ffULL, 0x000000080f357824ULL, 0x000fe200078e00ffULL,
0x0000001805337811ULL, 0x000fe200078fe8ffULL, 0x000000013d3e7824ULL, 0x000fe200078e0205ULL,
0x0000000405397811ULL, 0x000fe200078fe8ffULL, 0x000000083d317824ULL, 0x000fe200078e00ffULL,
0xfffffff8323f7812ULL, 0x000fe200078ee23fULL, 0x0000400009307824ULL, 0x000fe200078e020eULL,
0xfffffff835407812ULL, 0x000fe200078ee240ULL, 0x0000000133327824ULL, 0x100fe200078e0205ULL,
0xfffffff8313e7812ULL, 0x000fe200078ee23eULL, 0x0000000833357824ULL, 0x000fe200078e00ffULL,
0x0000001c05437811ULL, 0x000fe200078fe8ffULL, 0x0000000139097824ULL, 0x100fe200078e0205ULL,
0x0000001405317811ULL, 0x000fe200078fe8ffULL, 0x00000008390e7824ULL, 0x000fe200078e00ffULL,
0xfffffff835447812ULL, 0x000fe200078ee232ULL, 0x0000000143327824ULL, 0x140fe200078e0205ULL,
0x0000000343357819ULL, 0x000fe200000006ffULL, 0x0000000131417824ULL, 0x040fe200078e0205ULL,
0xfffffff80e097812ULL, 0x000fe200078ee209ULL, 0x00000008310e7824ULL, 0x000fe200078e00ffULL,
0x000000806b347812ULL, 0x000fe200078ef834ULL, 0x0000000139397824ULL, 0x100fe200078e023cULL,
0x0000003c05377211ULL, 0x000fe200078fe8ffULL, 0x000000013d3d7824ULL, 0x000fe200078e023cULL,
0xfffffff835467812ULL, 0x000fe200078ee232ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0xfffffff80e417812ULL, 0x000fe200078ee241ULL, 0x000000013b3b7824ULL, 0x000fe200078e023cULL,
0x00000005050e7211ULL, 0x000fe200078fe8ffULL, 0x0000010037367825ULL, 0x000fe200078e0034ULL,
0x00013000304b7810ULL, 0x000fc40007ffe0ffULL, 0x000000070e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000010f0f7824ULL, 0x100fe200078e023cULL, 0x000000360c367210ULL, 0x000fe20007f1e0ffULL,
0x0000000131317824ULL, 0x100fe200078e023cULL, 0x0ffffff80e427812ULL, 0x000fe200078ef805ULL,
0x0000000133337824ULL, 0x100fe400078e023cULL, 0x0000000143437824ULL, 0x000fe400078e023cULL,
0x0000010039387825ULL, 0x000fc800078e0034ULL, 0x000001003d3c7825ULL, 0x000fe200078e0034ULL,
0x000000380c387210ULL, 0x000fc60007f3e0ffULL, 0x000001003b3a7825ULL, 0x100fe200078e0034ULL,
0x0000003c0c3c7210ULL, 0x040fe40007f5e0ffULL, 0x000000390d397210ULL, 0x000fe20000ffe4ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0034ULL, 0x0000003a0c3a7210ULL, 0x000fc60007f7e0ffULL,
0x0000010031307825ULL, 0x000fc800078e0034ULL, 0x0000010033327825ULL, 0x000fe200078e0034ULL,
0x000000300c307210ULL, 0x000fc60007f3e0ffULL, 0x0000010043347825ULL, 0x000fc800078e0034ULL,
0x000000010d377824ULL, 0x040fe200000e0637ULL, 0x0000000e0c0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000001042437824ULL, 0x000fe400078e024bULL, 0x000000010d3d7824ULL, 0x000fe200010e063dULL,
0x000000320c327210ULL, 0x040fe20007f5e0ffULL, 0x0000001009097824ULL, 0x000fe200078e024bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036437faeULL, 0x0003e2000b901c48ULL,
0x000000010d3b7824ULL, 0x000fe200018e063bULL, 0x000000340c347210ULL, 0x000fe20007f7e0ffULL,
0x000000103e457824ULL, 0x100fe200078e024bULL, 0x0000000038097faeULL, 0x0003e2000b901c48ULL,
0x000000103f3f7824ULL, 0x000fc400078e024bULL, 0x0000001040477824ULL, 0x000fe200078e024bULL,
0x000000003c457faeULL, 0x0003e2000b901c48ULL, 0x000000010d0f7824ULL, 0x000fe400000e060fULL,
0x0000001041417824ULL, 0x000fe200078e024bULL, 0x000000003a3f7faeULL, 0x0003e2000b901c48ULL,
0x000000010d317824ULL, 0x040fe400008e0631ULL, 0x0000001044497824ULL, 0x000fe200078e024bULL,
0x000000000e477faeULL, 0x0003e2000b901c48ULL, 0x000000010d337824ULL, 0x000fc400010e0633ULL,
0x00000010464b7824ULL, 0x000fe200078e024bULL, 0x0000000030417faeULL, 0x0003e2000b901c48ULL,
0x000000010d357824ULL, 0x000fc600018e0635ULL, 0x0000000032497faeULL, 0x0003e8000b901c48ULL,
0x00000000344b7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe06e097812ULL, 0x042fe400078ec0ffULL, 0x000000106e0e7812ULL, 0x040fe400078ec0ffULL,
0x000000086e0f7812ULL, 0x000fc800078ec0ffULL, 0x000000090f347210ULL, 0x000fe20007ffe00eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6280034307f8cULL, 0x0002a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01b62c0034097984ULL, 0x000ee40000000800ULL,
0x8000000009ff7812ULL, 0x00cfe40007804831ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x000000320e327210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e0fULL,
0x003d09003200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011433ULL, 0x0000003209097211ULL, 0x000fca00078110ffULL,
0x000000ffff327224ULL, 0x000fca00000e0633ULL, 0x0000000209097819ULL, 0x000fc80000001232ULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000135357810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b62c0034097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000806b097810ULL, 0x000fca0007ffe05cULL,
0x0000000170097824ULL, 0x000fca00078e0209ULL, 0x01b0000009317984ULL, 0x000ea80000000800ULL,
0x01b2000009307984ULL, 0x0006620000000800ULL, 0x000000083100720bULL, 0x004fe20003f1d000ULL,
0x000101627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x008fc800000e0100ULL,
0x0000ffff09337812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000100097811ULL, 0x000fe400078ff0ffULL, 0x000000083100720bULL, 0x000fe40003f34000ULL,
0x000000000900720cULL, 0x000fe20003f05270ULL, 0x000101227f007947ULL, 0x000fd4000b800000ULL,
0x0000000000327806ULL, 0x000fc400008e0100ULL, 0x00000080000f8824ULL, 0x000fe200078e026bULL,
0x0000000831098209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x00009910320e7816ULL, 0x000fe200000000ffULL, 0x0000000170348824ULL, 0x002fca00078e020fULL,
0x01b4000934008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000831097209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff32ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000809097221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x0000000900367308ULL, 0x000e640000000800ULL, 0x0000003607077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe20000011605ULL,
0x000100527f007947ULL, 0x000fea000b800000ULL, 0x00001f0936097589ULL, 0x0002a400000e0000ULL,
0x000000092c2c7220ULL, 0x084fe40000410000ULL, 0x000000092d2d7220ULL, 0x080fe40000410000ULL,
0x0000000928287220ULL, 0x080fe40000410000ULL, 0x0000000929297220ULL, 0x000fc40000410000ULL,
0x0000000910107220ULL, 0x080fe40000410000ULL, 0x0000000911117220ULL, 0x080fe40000410000ULL,
0x0000000914147220ULL, 0x080fe40000410000ULL, 0x0000000915157220ULL, 0x080fe40000410000ULL,
0x0000000918187220ULL, 0x080fe40000410000ULL, 0x0000000919197220ULL, 0x000fc40000410000ULL,
0x000000091c1c7220ULL, 0x080fe40000410000ULL, 0x000000091d1d7220ULL, 0x080fe40000410000ULL,
0x0000000920207220ULL, 0x080fe40000410000ULL, 0x0000000921217220ULL, 0x080fe40000410000ULL,
0x0000000924247220ULL, 0x080fe40000410000ULL, 0x0000000925257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0032ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805097811ULL, 0x000fe200078ff0ffULL,
0x0000ff527f007947ULL, 0x000fea000b800000ULL, 0x00001f0936097589ULL, 0x0004e400000e0000ULL,
0x000000092e2e7220ULL, 0x08cfe40000410000ULL, 0x000000092f2f7220ULL, 0x080fe40000410000ULL,
0x000000092a2a7220ULL, 0x080fe40000410000ULL, 0x000000092b2b7220ULL, 0x080fe40000410000ULL,
0x0000000912127220ULL, 0x080fe40000410000ULL, 0x0000000913137220ULL, 0x000fc40000410000ULL,
0x0000000916167220ULL, 0x080fe40000410000ULL, 0x0000000917177220ULL, 0x080fe40000410000ULL,
0x000000091a1a7220ULL, 0x080fe40000410000ULL, 0x000000091b1b7220ULL, 0x080fe40000410000ULL,
0x000000091e1e7220ULL, 0x080fe40000410000ULL, 0x000000091f1f7220ULL, 0x000fc40000410000ULL,
0x0000000922227220ULL, 0x080fe40000410000ULL, 0x0000000923237220ULL, 0x080fe40000410000ULL,
0x0000000926267220ULL, 0x080fe40000410000ULL, 0x0000000927277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff33ff7812ULL, 0x000fe40007806032ULL,
0x0000000831087209ULL, 0x000fd60007810000ULL, 0x8000000831310221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100030308ULL, 0x000e640000000800ULL,
0x0000000330300220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000730077221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000003ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff317819ULL, 0x000fe40000011605ULL,
0x0000541004307816ULL, 0x000fe20000000004ULL, 0x0000fda27f007947ULL, 0x000fea000b800000ULL,
0x00001f3130047589ULL, 0x0002a400000e0000ULL, 0x0000000831097810ULL, 0x000fe20007ffe0ffULL,
0x0000fdf27f007947ULL, 0x000fea000b800000ULL, 0x00001f0930067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001031097810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00004d30000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0001084000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001831097810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0030ULL,
0x00004da0000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x000107d000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000140000a0a7810ULL, 0x000fe20007ffe0ffULL, 0x011800005d44783bULL, 0x000f220000000200ULL,
0x00000002ff097819ULL, 0x00cfe40000011600ULL, 0x0000000a5f587211ULL, 0x000fe200078e20ffULL,
0x0000001061547824ULL, 0x100fe200078e020aULL, 0x0001b690090e7811ULL, 0x000fe200078e18ffULL,
0x0000001060507824ULL, 0x000fc400078e020aULL, 0x0000001062487824ULL, 0x100fe200078e020aULL,
0x000000005858783bULL, 0x000fe20000004200ULL, 0x0000080009307824ULL, 0x002fe400078e024dULL,
0x0000001065407824ULL, 0x100fe200078e020aULL, 0x000000005454783bULL, 0x000e620000004200ULL,
0x00000010643c7824ULL, 0x100fe400078e020aULL, 0x0000001063387824ULL, 0x100fe200078e020aULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x0000001066347824ULL, 0x000fe200078e020aULL,
0x00000001ff0a7819ULL, 0x000fc40000011600ULL, 0x000000004848783bULL, 0x000fe60000004200ULL,
0x00000008020f7824ULL, 0x000fe200078e020aULL, 0x011800003030783bULL, 0x000ea80000000200ULL,
0x000000004040783bULL, 0x000ee80000004200ULL, 0x000000003c3c783bULL, 0x000ee80000004200ULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x0000000444440231ULL, 0x010fc600003400ffULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x0000000446460231ULL, 0x000fe400003400ffULL,
0x0000000645450231ULL, 0x080fe400003400ffULL, 0x0000000647470231ULL, 0x000fce00003400ffULL,
0x00000054442c723cULL, 0x042f70000004182cULL, 0x000000564428723cULL, 0x000f620000041828ULL,
0x0000000430300231ULL, 0x084fe400003400ffULL, 0x0000000432320231ULL, 0x000fca00003400ffULL,
0x00000050444c723cULL, 0x000f620000041810ULL, 0x0000000631310231ULL, 0x080fe400003400ffULL,
0x0000000633330231ULL, 0x000fca00003400ffULL, 0x000000524450723cULL, 0x040f700000041814ULL,
0x000000584454723cULL, 0x040f700000041818ULL, 0x0000005a441c723cULL, 0x040f70000004181cULL,
0x000000484420723cULL, 0x040f700000041820ULL, 0x0000004a4424723cULL, 0x000f700000041824ULL,
0x000000403010723cULL, 0x068b70000004182cULL, 0x000000423014723cULL, 0x040b700000041828ULL,
0x0000003c3018723cULL, 0x040b70000004184cULL, 0x0000003e3050723cULL, 0x040b700000041850ULL,
0x000000383054723cULL, 0x040b700000041854ULL, 0x0000003a301c723cULL, 0x040b70000004181cULL,
0x000000343020723cULL, 0x050b700000041820ULL, 0x000000363030723cULL, 0x000b620000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000102257810ULL, 0x020fe20007ffe0ffULL,
0x000000000eff7f8cULL, 0x0003e2000c80043fULL, 0x000000c00f0f7811ULL, 0x000fc400078e28ffULL,
0x0000005e2500720cULL, 0x000fe40003f06070ULL, 0x000000600f347812ULL, 0x000fca00078ec0ffULL,
0x0000000169347824ULL, 0x000fe200078e0234ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff397819ULL, 0x002fe20000011605ULL,
0x0000008000247824ULL, 0x000fe200078e00ffULL, 0x0000000f680e7217ULL, 0x000fe40007800000ULL,
0x0000000439257810ULL, 0x040fe40007ffe0ffULL, 0x0000000839297810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a0fULL, 0x0000000c392b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001252e7824ULL, 0x100fe200078e0205ULL, 0x0000000329277819ULL, 0x000fe200000006ffULL,
0x00000008250f7824ULL, 0x000fe200078e00ffULL, 0x000000200e3a7817ULL, 0x000fe20003800000ULL,
0x0000000129367824ULL, 0x100fe200078e0205ULL, 0x000000806b0e7812ULL, 0x000fe200078ef824ULL,
0x000000012b357824ULL, 0x000fe200078e0205ULL, 0xfffffff80f2e7812ULL, 0x000fe200078ee22eULL,
0x000000082b267824ULL, 0x000fe200078e00ffULL, 0xfffffff827367812ULL, 0x000fe200078ee236ULL,
0x0000000139277824ULL, 0x040fe200078e0234ULL, 0x00000014393d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0xfffffff826357812ULL, 0x000fc400078ee235ULL,
0x00000010393b7810ULL, 0x000fe20007ffe0ffULL, 0x0000010027267825ULL, 0x000fe200078e000eULL,
0x0000003a2500720cULL, 0x080fe40003f86070ULL, 0x0000003a2900720cULL, 0x000fe20003f66070ULL,
0x000000013d377824ULL, 0x140fe200078e0205ULL, 0x000000260c2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000083d287824ULL, 0x000fe200078e00ffULL, 0x0000003a2b00720cULL, 0x080fe20003f46070ULL,
0x000000013b387824ULL, 0x000fe200078e0205ULL, 0x0000003a3900720cULL, 0x000fe20003fa6070ULL,
0x000000083b2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff828377812ULL, 0x000fe200078ee237ULL,
0x0000000125257824ULL, 0x000fe200078e0234ULL, 0x0000000d00287819ULL, 0x000fe200000006ffULL,
0x0000000139267824ULL, 0x000fe200078e0205ULL, 0xfffffff82d387812ULL, 0x000fe200078ee238ULL,
0x0000010025247825ULL, 0x000fe200078e000eULL, 0x00002000282f7812ULL, 0x000fc400078ec0ffULL,
0x00000007263c7812ULL, 0x000fe200078ec0ffULL, 0x000000010d2d7824ULL, 0x000fe200000e0627ULL,
0x000000240c247210ULL, 0x000fe20007f3e0ffULL, 0x0000000129277824ULL, 0x100fe200078e0234ULL,
0x0ffffff83c3c7812ULL, 0x000fe200078ef805ULL, 0x000000012b297824ULL, 0x000fe200078e0234ULL,
0x0000001839437810ULL, 0x040fe20007ffe0ffULL, 0x000040000a2f7824ULL, 0x000fe200078e022fULL,
0x0000001c39457810ULL, 0x000fe20007ffe0ffULL, 0x0000010029287825ULL, 0x000fc800078e000eULL,
0x000000013b2b7824ULL, 0x000fe200078e0234ULL, 0x000000280c287210ULL, 0x000fe20007fde0ffULL,
0x000000010d257824ULL, 0x000fe200008e0625ULL, 0x0000003a3b00720cULL, 0x000fe20003f26070ULL,
0x000001002b2a7825ULL, 0x000fe200078e000eULL, 0x000140002f3b7810ULL, 0x000fc60007ffe0ffULL,
0x0000010027267825ULL, 0x000fc800078e000eULL, 0x000000013d2f7824ULL, 0x000fe200078e0234ULL,
0x000000260c267210ULL, 0x040fe20007f1e0ffULL, 0x000000010d297824ULL, 0x000fe200030e0629ULL,
0x0000002a0c2a7210ULL, 0x000fe20007fde0ffULL, 0x000000103c3f7824ULL, 0x100fe400078e023bULL,
0x000000102e417824ULL, 0x000fe400078e023bULL, 0x000001002f2e7825ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c3f7faeULL, 0x0003e2000e901c48ULL,
0x0000003a4300720cULL, 0x000fc40003fa6070ULL, 0x0000000143397824ULL, 0x100fe200078e0234ULL,
0x0000000024417faeULL, 0x0005e2000e101c48ULL, 0x000000010d2b7824ULL, 0x040fe200030e062bULL,
0x0000002e0c2e7210ULL, 0x000fe20007fde0ffULL, 0x000000010d277824ULL, 0x000fe200000e0627ULL,
0x0000003a3d00720cULL, 0x080fe20003f06070ULL, 0x00000001453d7824ULL, 0x040fe200078e0234ULL,
0x0000003a4500720cULL, 0x000fe20003f86070ULL, 0x0000000143347824ULL, 0x000fe200078e0205ULL,
0x0000002f0d2f7210ULL, 0x000fe200037fe4ffULL, 0x00000100392c7825ULL, 0x002fc800078e000eULL,
0x0000000145257824ULL, 0x044fe200078e0205ULL, 0x0000002c0c247210ULL, 0x000fe20007fde0ffULL,
0x00000008453a7824ULL, 0x000fe400078e00ffULL, 0x0000000843437824ULL, 0x000fe400078e00ffULL,
0x000001003d0e7825ULL, 0x000fe200078e000eULL, 0xfffffff83a2c7812ULL, 0x000fe400078ee225ULL,
0xfffffff843347812ULL, 0x000fe200078ee234ULL, 0x000000010d257824ULL, 0x000fe200030e062dULL,
0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL, 0x00000010362d7824ULL, 0x000fc400078e023bULL,
0x0000001035357824ULL, 0x100fe200078e023bULL, 0x0000000f0d0d7210ULL, 0x000fe200037fe4ffULL,
0x0000001038397824ULL, 0x100fe200078e023bULL, 0x00000000262d7faeULL, 0x0003e2000d901c48ULL,
0x0000001037377824ULL, 0x100fe400078e023bULL, 0x00000010343d7824ULL, 0x100fe200078e023bULL,
0x0000000028357faeULL, 0x0003e2000d101c48ULL, 0x000000102c3b7824ULL, 0x000fc600078e023bULL,
0x000000002a397faeULL, 0x0003e8000c901c48ULL, 0x000000002e377faeULL, 0x0003e8000c101c48ULL,
0x00000000243d7faeULL, 0x0003e8000e901c48ULL, 0x000000000c3b7faeULL, 0x0003e2000e101c48ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000805357811ULL, 0x042fe200078fe8ffULL,
0x0000008000287824ULL, 0x000fe200078e00ffULL, 0x0000001005247811ULL, 0x000fc400078fe8ffULL,
0x0000001805277811ULL, 0x000fe200078fe8ffULL, 0x00000001353a7824ULL, 0x100fe200078e0205ULL,
0x00000004052d7811ULL, 0x000fe200078fe8ffULL, 0x00000008350f7824ULL, 0x000fe200078e00ffULL,
0x0000000c052f7811ULL, 0x040fe200078fe8ffULL, 0x0000000124387824ULL, 0x140fe200078e0205ULL,
0x0000001405257811ULL, 0x000fe200078fe8ffULL, 0x0000000127367824ULL, 0x100fe200078e0205ULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL, 0x00000008240f7824ULL, 0x000fe200078e00ffULL,
0x0000001c053d7811ULL, 0x000fe200078fe8ffULL, 0x0000000827297824ULL, 0x000fe200078e00ffULL,
0x000000806b287812ULL, 0x000fe200078ef828ULL, 0x000000012d3b7824ULL, 0x100fe200078e0205ULL,
0xfffffff80f387812ULL, 0x000fe200078ee238ULL, 0x000000082d0e7824ULL, 0x000fe200078e00ffULL,
0x0000000d000f7819ULL, 0x000fe200000006ffULL, 0x000000012f397824ULL, 0x100fe200078e0205ULL,
0xfffffff829367812ULL, 0x000fe200078ee236ULL, 0x0000000125377824ULL, 0x000fe200078e0205ULL,
0xfffffff80e3b7812ULL, 0x000fe200078ee23bULL, 0x000000082f0e7824ULL, 0x000fe200078e00ffULL,
0x000020000f297812ULL, 0x000fe200078ec0ffULL, 0x0000000825267824ULL, 0x000fe200078e00ffULL,
0x00000034052b7211ULL, 0x040fe200078fe8ffULL, 0x00000001240f7824ULL, 0x100fe200078e0234ULL,
0xfffffff80e397812ULL, 0x000fe200078ee239ULL, 0x000040000a247824ULL, 0x000fe200078e0229ULL,
0x00000005050e7211ULL, 0x000fe200078fe8ffULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0xfffffff826377812ULL, 0x000fe200078ee237ULL, 0x000000012d2d7824ULL, 0x100fe200078e0234ULL,
0x000000070e0e7812ULL, 0x000fe200078ec0ffULL, 0x0000000135357824ULL, 0x000fc400078e0234ULL,
0x000000012f2f7824ULL, 0x000fe200078e0234ULL, 0x0ffffff80e3c7812ULL, 0x100fe200078ef805ULL,
0x000000013d267824ULL, 0x040fe400078e0205ULL, 0x000000083d3f7824ULL, 0x000fe400078e00ffULL,
0x000001002b2a7825ULL, 0x000fc600078e0028ULL, 0xfffffff83f3e7812ULL, 0x000fe200078ee226ULL,
0x0000000125257824ULL, 0x100fe200078e0234ULL, 0x0000002a0c2a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000127277824ULL, 0x100fe200078e0234ULL, 0x00014000243f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013d3d7824ULL, 0x000fe400078e0234ULL, 0x000001002d2c7825ULL, 0x000fc800078e0028ULL,
0x0000010035347825ULL, 0x000fe200078e0028ULL, 0x0000002c0c2c7210ULL, 0x000fc60007f3e0ffULL,
0x000001002f2e7825ULL, 0x000fe200078e0028ULL, 0x000000340c347210ULL, 0x000fc60007f5e0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0028ULL, 0x0000002e0c2e7210ULL, 0x000fc60007f7e0ffULL,
0x0000010025247825ULL, 0x000fc800078e0028ULL, 0x0000010027267825ULL, 0x000fc800078e0028ULL,
0x000001003d287825ULL, 0x000fe200078e0028ULL, 0x0000003f3c3d7211ULL, 0x000fc600078e20ffULL,
0x000000010d2b7824ULL, 0x040fe200000e062bULL, 0x0000000e0c0e7210ULL, 0x040fe20007f1e0ffULL,
0x000000010d2d7824ULL, 0x040fe200008e062dULL, 0x000000240c247210ULL, 0x040fe20007f3e0ffULL,
0x000000010d357824ULL, 0x000fe200010e0635ULL, 0x000000260c267210ULL, 0x040fe20007f5e0ffULL,
0x000000103b3b7824ULL, 0x000fe200078e023fULL, 0x000000250d257210ULL, 0x040fe20000ffe4ffULL,
0x000000010d2f7824ULL, 0x000fe200018e062fULL, 0x000000280c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000103a417824ULL, 0x100fe200078e023fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3d7faeULL, 0x0003e2000b901c48ULL, 0x0000001039397824ULL, 0x000fc400078e023fULL,
0x0000001038437824ULL, 0x000fe200078e023fULL, 0x000000002c3b7faeULL, 0x0003e2000b901c48ULL,
0x000000010d0f7824ULL, 0x000fe400000e060fULL, 0x0000001037377824ULL, 0x100fe200078e023fULL,
0x0000000034417faeULL, 0x0003e2000b901c48ULL, 0x0000001036457824ULL, 0x000fe400078e023fULL,
0x000000010d277824ULL, 0x000fe200010e0627ULL, 0x000000002e397faeULL, 0x0003e2000b901c48ULL,
0x000000103e3f7824ULL, 0x000fc400078e023fULL, 0x000000010d0d7824ULL, 0x000fe200018e0629ULL,
0x000000000e437faeULL, 0x0003e8000b901c48ULL, 0x0000000024377faeULL, 0x0003e8000b901c48ULL,
0x0000000026457faeULL, 0x0003e8000b901c48ULL, 0x000000000c3f7faeULL, 0x0003e4000b901c48ULL,
0x00000300ff0c7624ULL, 0x002fe200078e00ffULL, 0x000000010b0d7812ULL, 0x000fe200078ec0ffULL,
0xffffffffff597424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000010d00780cULL, 0x000fc40003f05070ULL, 0xffffffff0c0c7811ULL, 0x000fc800078e08ffULL,
0x000000010c0c7807ULL, 0x000fca0004000000ULL, 0x000000010b0b7824ULL, 0x000fca00078e020cULL,
0x0000006d0b00720cULL, 0x000fda0003f06070ULL, 0x000000010b0c8824ULL, 0x000fe400078e026cULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000064000c0c8625ULL, 0x000fca00078e000dULL,
0x000000080c598981ULL, 0x000322000c1e1900ULL, 0x000000106e0e7812ULL, 0x000fca00078ec0ffULL,
0x0000002009097824ULL, 0x000fe200078e020eULL, 0x000000086e0e7812ULL, 0x000fca00078ec0ffULL,
0x000000010e097824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b64800090e7f8cULL, 0x0022a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01b64c0009257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x00cfe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x000000240c277210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e0dULL, 0x003d09002700780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402700780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011425ULL,
0x0000002724247211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x0000000224247819ULL, 0x000fc80000001225ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b64c0009257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001006b097810ULL, 0x002fc80007ffe05cULL, 0x0000000970097210ULL, 0x000fca0007ffe0ffULL,
0x01b00000090d7984ULL, 0x000e680000000800ULL, 0x01b20000090c7984ULL, 0x0004e20000000800ULL,
0x000000080d00720bULL, 0x002fe20003f1d000ULL, 0x0000e9927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x004fc800000e0100ULL, 0x0000ffff09257812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000200097811ULL, 0x000fe400078ff0ffULL,
0x000000080d00720bULL, 0x000fe40003f34000ULL, 0x000000000900720cULL, 0x000fe20003f05270ULL,
0x0000e9527f007947ULL, 0x000fd4000b800000ULL, 0x0000000000247806ULL, 0x000fc400008e0100ULL,
0x00000080000f8824ULL, 0x000fe200078e026bULL, 0x000000080d098209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x00009910240e7816ULL, 0x000fe200000000ffULL,
0x0000000170268824ULL, 0x000fca00078e020fULL, 0x01b4000926008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000080d097209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff24ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000809097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900267308ULL, 0x000e640000000800ULL,
0x0000002607077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe20000011605ULL, 0x0000e8827f007947ULL, 0x000fea000b800000ULL,
0x00001f0926097589ULL, 0x0002a400000e0000ULL, 0x0000000910107220ULL, 0x084fe40000410000ULL,
0x0000000911117220ULL, 0x080fe40000410000ULL, 0x0000000914147220ULL, 0x080fe40000410000ULL,
0x0000000915157220ULL, 0x000fc40000410000ULL, 0x0000000918187220ULL, 0x080fe40000410000ULL,
0x0000000919197220ULL, 0x080fe40000410000ULL, 0x0000000950507220ULL, 0x080fe40000410000ULL,
0x0000000951517220ULL, 0x080fe40000410000ULL, 0x0000000954547220ULL, 0x080fe40000410000ULL,
0x0000000955557220ULL, 0x000fc40000410000ULL, 0x000000091c1c7220ULL, 0x080fe40000410000ULL,
0x000000091d1d7220ULL, 0x080fe40000410000ULL, 0x0000000920207220ULL, 0x080fe40000410000ULL,
0x0000000921217220ULL, 0x080fe40000410000ULL, 0x0000000930307220ULL, 0x080fe40000410000ULL,
0x0000000931317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000805097811ULL, 0x000fe200078ff0ffULL, 0x0000e7827f007947ULL, 0x000fea000b800000ULL,
0x00001f0926097589ULL, 0x00046400000e0000ULL, 0x0000000912127220ULL, 0x086fe40000410000ULL,
0x0000000913137220ULL, 0x080fe40000410000ULL, 0x0000000916167220ULL, 0x080fe40000410000ULL,
0x0000000917177220ULL, 0x080fe40000410000ULL, 0x000000091a1a7220ULL, 0x080fe40000410000ULL,
0x000000091b1b7220ULL, 0x000fc40000410000ULL, 0x0000000952527220ULL, 0x080fe40000410000ULL,
0x0000000953537220ULL, 0x080fe40000410000ULL, 0x0000000956567220ULL, 0x080fe40000410000ULL,
0x0000000957577220ULL, 0x080fe40000410000ULL, 0x000000091e1e7220ULL, 0x080fe40000410000ULL,
0x000000091f1f7220ULL, 0x000fc40000410000ULL, 0x0000000922227220ULL, 0x080fe40000410000ULL,
0x0000000923237220ULL, 0x080fe40000410000ULL, 0x0000000932327220ULL, 0x080fe40000410000ULL,
0x0000000933337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff25ff7812ULL, 0x000fe40007806024ULL, 0x000000080d087209ULL, 0x000fd60007810000ULL,
0x800000080d0d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d00030308ULL, 0x000e640000000800ULL, 0x000000030c0c0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000000070c077221ULL, 0x008fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000003ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011605ULL, 0x00005410040c7816ULL, 0x000fe20000000004ULL,
0x0000e5d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0c047589ULL, 0x0002a400000e0000ULL,
0x000000080d097810ULL, 0x000fe20007ffe0ffULL, 0x0000e6227f007947ULL, 0x000fea000b800000ULL,
0x00001f090c067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100d097810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x00006760000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000ee1000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180d097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0xffffffff00347802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x000067d0000f7802ULL, 0x000fc40000000f00ULL,
0x0000eda000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000007050c7812ULL, 0x00afe200078ec0ffULL,
0x000000020a487824ULL, 0x000fe200078e026aULL, 0x0000000267097810ULL, 0x004fe20007ffe0ffULL,
0x012000005d3c783bULL, 0x000e620000000200ULL, 0x000000080c0c7812ULL, 0x000fe200078ef805ULL,
0x0000200048487824ULL, 0x000fc800078e00ffULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x0001300048287810ULL, 0x000fc80007ffe0ffULL, 0xfffffff80c587812ULL, 0x000fe200078ee209ULL,
0x000000105f0c7824ULL, 0x000fe200078e0228ULL, 0x00000002ff097819ULL, 0x000fe20000011600ULL,
0x00000010614c7824ULL, 0x100fe400078e0228ULL, 0x0000001060447824ULL, 0x100fe400078e0228ULL,
0x0000001062407824ULL, 0x100fe200078e0228ULL, 0x000000000c0c783bULL, 0x000ea20000004200ULL,
0x0000001058587824ULL, 0x000fe400078e00ffULL, 0x0000001065387824ULL, 0x000fe200078e0228ULL,
0x000000004c4c783bULL, 0x000ee20000004200ULL, 0x0000080009247824ULL, 0x000fc400078e0258ULL,
0x0000001064347824ULL, 0x100fe200078e0228ULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x00000010632c7824ULL, 0x000fe200078e0228ULL, 0x0000002866287211ULL, 0x000fe400078e20ffULL,
0x000000004040783bULL, 0x000fe80000004200ULL, 0x012000002424783bULL, 0x000ee80000000200ULL,
0x000000002c2c783bULL, 0x000ee20000004200ULL, 0x000000043c3c0231ULL, 0x002fc400003400ffULL,
0x000000043e3e0231ULL, 0x000fe200003400ffULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x000000063d3d0231ULL, 0x080fe400003400ffULL, 0x000000063f3f0231ULL, 0x000fe200003400ffULL,
0x000000003434783bULL, 0x000e680000004200ULL, 0x000000002828783bULL, 0x000e640000004200ULL,
0x0000000c3c54723cULL, 0x044f700000041854ULL, 0x0000004c3c10723cULL, 0x048f700000041810ULL,
0x0000004e3c14723cULL, 0x000f620000041814ULL, 0x0000000424240231ULL, 0x000fc400003400ffULL,
0x0000000426260231ULL, 0x000fe400003400ffULL, 0x0000000625250231ULL, 0x080fe400003400ffULL,
0x0000000627270231ULL, 0x000fe200003400ffULL, 0x000000443c18723cULL, 0x040f700000041818ULL,
0x000000463c50723cULL, 0x040f700000041850ULL, 0x0000000e3c0c723cULL, 0x040f70000004181cULL,
0x000000403c20723cULL, 0x040f700000041820ULL, 0x000000423c30723cULL, 0x000f700000041830ULL,
0x0000002c2454723cULL, 0x060f700000041854ULL, 0x000000382410723cULL, 0x042f700000041810ULL,
0x0000003a2414723cULL, 0x040f700000041814ULL, 0x000000342418723cULL, 0x040f700000041818ULL,
0x000000362450723cULL, 0x040f700000041850ULL, 0x0000002e242c723cULL, 0x040b6e000004180cULL,
0x0001b698090c7811ULL, 0x020fe200078e18ffULL, 0x000000282420723cULL, 0x040b700000041820ULL,
0x0000002a2424723cULL, 0x000b620000041830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000300020e7a10ULL, 0x000fe20007ffe0ffULL, 0x000000000cff7f8cULL, 0x0003e6000c80043fULL,
0x0000005e0e00720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x000000010e0d7810ULL, 0x042fe20007ffe0ffULL,
0x000001000e1d7824ULL, 0x000fe400078e026fULL, 0x00005900590c7a24ULL, 0x010fe200078e02ffULL,
0x0000005e0d00720cULL, 0x000fe20003f06070ULL, 0x00000100ff0f7424ULL, 0x000fe200078e00ffULL,
0x000000601d347812ULL, 0x000fe200078ec0ffULL, 0x000000800c0c7824ULL, 0x000fc800078e00ffULL,
0x0000000169347824ULL, 0x000fe400078e0234ULL, 0x000062000c0e7625ULL, 0x000fc800078e000fULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff397819ULL, 0x000fe20000011605ULL,
0x00000080001c7824ULL, 0x000fe200078e00ffULL, 0x0000001d680c7217ULL, 0x000fe40007800000ULL,
0x00000004390d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000839317810ULL, 0x060fe20007ffe0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a1dULL, 0x0000000c393b7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d327824ULL, 0x100fe200078e0205ULL, 0x00000010393d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d1d7824ULL, 0x000fe200078e00ffULL, 0x000000200c3a7817ULL, 0x000fe20003800000ULL,
0x0000000131367824ULL, 0x100fe200078e0205ULL, 0x000000806b0c7812ULL, 0x000fe200078ef81cULL,
0x00000008311f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d327812ULL, 0x000fe200078ee232ULL,
0x000000010d1d7824ULL, 0x040fe200078e0234ULL, 0x0000003a0d00720cULL, 0x000fe20003f86070ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0xfffffff81f367812ULL, 0x000fe200078ee236ULL,
0x000000013b357824ULL, 0x000fe200078e0205ULL, 0x00000034391f7210ULL, 0x000fe20007ffe0ffULL,
0x000000083b1e7824ULL, 0x000fe200078e00ffULL, 0x0000001439417810ULL, 0x000fe20007ffe0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e000cULL, 0x0000003a3100720cULL, 0x000fc40003f66070ULL,
0xfffffff81e357812ULL, 0x000fe200078ee235ULL, 0x000000013d387824ULL, 0x040fe200078e0205ULL,
0x0000001c0e287210ULL, 0x040fe20007f3e0ffULL, 0x000000083d297824ULL, 0x000fe200078e00ffULL,
0x0000003a3900720cULL, 0x080fe20003fa6070ULL, 0x000001001f1e7825ULL, 0x000fe200078e000cULL,
0x0000003a3b00720cULL, 0x000fe40003f46070ULL, 0xfffffff829387812ULL, 0x000fe200078ee238ULL,
0x000000010f297824ULL, 0x000fe200008e061dULL, 0x0000001e0e2a7210ULL, 0x000fe20007f1e0ffULL,
0x00002000001d7824ULL, 0x000fe200078e00ffULL, 0x0000001839437810ULL, 0x040fe20007ffe0ffULL,
0x00000001391c7824ULL, 0x040fe200078e0205ULL, 0x0000001c39457810ULL, 0x000fe20007ffe0ffULL,
0x000000010f2b7824ULL, 0x000fe200000e061fULL, 0x000020001d337812ULL, 0x000fe200078ec0ffULL,
0x00000001311f7824ULL, 0x100fe200078e0234ULL, 0x000000071c3c7812ULL, 0x000fe200078ec0ffULL,
0x000000013b1d7824ULL, 0x000fe200078e0234ULL, 0x000000343d317210ULL, 0x000fe20007ffe0ffULL,
0x000001001f1e7825ULL, 0x000fe200078e000cULL, 0x0ffffff83c3c7812ULL, 0x000fc400078ef805ULL,
0x0000003a3d00720cULL, 0x000fe20003f26070ULL, 0x0000000141377824ULL, 0x040fe200078e0205ULL,
0x0000001e0e1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000841307824ULL, 0x000fe400078e00ffULL,
0x000001001d1c7825ULL, 0x000fc600078e000cULL, 0xfffffff830377812ULL, 0x000fe200078ee237ULL,
0x000040000a337824ULL, 0x000fe200078e0233ULL, 0x0000001c0e1c7210ULL, 0x000fe20007fde0ffULL,
0x0000010031307825ULL, 0x000fc600078e000cULL, 0x00013000333b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000141337824ULL, 0x000fe400078e0234ULL, 0x000000010f1f7824ULL, 0x000fe200000e061fULL,
0x0000003a4100720cULL, 0x000fe20003f06070ULL, 0x000000010f1d7824ULL, 0x000fe200030e061dULL,
0x000000300e307210ULL, 0x000fe20007fde0ffULL, 0x0000001032417824ULL, 0x100fe400078e023bULL,
0x000000103c3f7824ULL, 0x000fe400078e023bULL, 0x0000010033327825ULL, 0x000fc600078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a3f7faeULL, 0x0003e2000e901c48ULL,
0x0000000143397824ULL, 0x140fe200078e0234ULL, 0x0000003a4300720cULL, 0x000fe20003fa6070ULL,
0x000000010f317824ULL, 0x000fe200030e0631ULL, 0x000000320e327210ULL, 0x000fe20007fde0ffULL,
0x0000000028417faeULL, 0x0005e2000e101c48ULL, 0x00000001453d7824ULL, 0x040fe200078e0234ULL,
0x0000003a4500720cULL, 0x000fe20003f86070ULL, 0x0000000143347824ULL, 0x000fe400078e0205ULL,
0x000000010f337824ULL, 0x000fc400030e0633ULL, 0x00000100392a7825ULL, 0x002fc800078e000cULL,
0x00000008453a7824ULL, 0x040fe200078e00ffULL, 0x0000000545297210ULL, 0x004fe20007ffe0ffULL,
0x0000000843437824ULL, 0x000fe200078e00ffULL, 0x0000002a0e287210ULL, 0x000fe20007fde0ffULL,
0x000001003d0c7825ULL, 0x000fe200078e000cULL, 0xfffffff83a2a7812ULL, 0x000fe400078ee229ULL,
0xfffffff843347812ULL, 0x000fe200078ee234ULL, 0x000000010f297824ULL, 0x000fe200030e062bULL,
0x0000000c0e0c7210ULL, 0x000fe20007fde0ffULL, 0x00000010362b7824ULL, 0x000fc400078e023bULL,
0x0000001035357824ULL, 0x100fe400078e023bULL, 0x0000001038397824ULL, 0x100fe200078e023bULL,
0x000000001e2b7faeULL, 0x0003e2000d901c48ULL, 0x0000001037377824ULL, 0x100fe400078e023bULL,
0x00000010343d7824ULL, 0x100fe200078e023bULL, 0x000000001c357faeULL, 0x0003e2000d101c48ULL,
0x000000102a3b7824ULL, 0x000fe400078e023bULL, 0x000000010f0d7824ULL, 0x000fe200030e060dULL,
0x0000000030397faeULL, 0x0003e8000c901c48ULL, 0x0000000032377faeULL, 0x0003e8000c101c48ULL,
0x00000000283d7faeULL, 0x0003e8000e901c48ULL, 0x000000000c3b7faeULL, 0x0003e2000e101c48ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000805337811ULL, 0x060fe400078fe8ffULL,
0x0000000405317811ULL, 0x000fc400078fe8ffULL, 0x00000003330d7819ULL, 0x040fe200000006ffULL,
0x00000001333a7824ULL, 0x100fe200078e0205ULL, 0x00000010051e7811ULL, 0x000fe200078fe8ffULL,
0x00000001313b7824ULL, 0x100fe200078e0205ULL, 0x0000001805297811ULL, 0x000fe200078fe8ffULL,
0x00000008310c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d3a7812ULL, 0x000fe200078ee23aULL,
0x000000011e387824ULL, 0x140fe200078e0205ULL, 0x00000014051f7811ULL, 0x040fe200078fe8ffULL,
0x000000081e0d7824ULL, 0x000fe200078e00ffULL, 0x0000000c05357811ULL, 0x000fe200078fe8ffULL,
0x0000000129367824ULL, 0x040fe200078e0205ULL, 0xfffffff80c3b7812ULL, 0x000fe200078ee23bULL,
0x00000008291d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d387812ULL, 0x000fe200078ee238ULL,
0x000000011f377824ULL, 0x100fe200078e0205ULL, 0x00000005050d7211ULL, 0x000fe200078fe8ffULL,
0x000000081f1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d367812ULL, 0x000fe200078ee236ULL,
0x0000000135397824ULL, 0x000fe200078e0205ULL, 0x0000001c053d7811ULL, 0x000fe200078fe8ffULL,
0x00000008350c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c377812ULL, 0x000fe200078ee237ULL,
0x00002000001d7824ULL, 0x000fe200078e00ffULL, 0x000000070d1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000131317824ULL, 0x100fe200078e0234ULL, 0xfffffff80c397812ULL, 0x000fe200078ee239ULL,
0x00000080000c7824ULL, 0x000fe200078e00ffULL, 0x000020001d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000011e1d7824ULL, 0x100fe200078e0234ULL, 0x00000034052b7211ULL, 0x080fe200078fe8ffULL,
0x0000000133337824ULL, 0x000fe200078e0234ULL, 0x000000806b0c7812ULL, 0x000fe200078ef80cULL,
0x000040000a1e7824ULL, 0x000fe200078e020dULL, 0x0000003435357210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0ffffff81c3c7812ULL, 0x100fe200078ef805ULL,
0x000000013d287824ULL, 0x000fc400078e0205ULL, 0x000000083d3f7824ULL, 0x000fe400078e00ffULL,
0x000001002b2a7825ULL, 0x000fc600078e000cULL, 0xfffffff83f3e7812ULL, 0x000fe200078ee228ULL,
0x0000010031307825ULL, 0x000fe200078e000cULL, 0x0000002a0e2a7210ULL, 0x000fe40007f1e0ffULL,
0x000130001e3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0234ULL,
0x000000300e307210ULL, 0x000fe20007f3e0ffULL, 0x0000000129297824ULL, 0x100fe200078e0234ULL,
0x0000003f38437211ULL, 0x000fe200078e20ffULL, 0x000000013d3d7824ULL, 0x000fe400078e0234ULL,
0x0000010033327825ULL, 0x000fc800078e000cULL, 0x0000010035347825ULL, 0x000fe200078e000cULL,
0x000000320e327210ULL, 0x000fc60007f5e0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e000cULL,
0x000000340e347210ULL, 0x000fc60007f7e0ffULL, 0x000001001f1e7825ULL, 0x000fc800078e000cULL,
0x0000010029287825ULL, 0x000fc800078e000cULL, 0x000001003d0c7825ULL, 0x000fc800078e000cULL,
0x000000010f2b7824ULL, 0x040fe200000e062bULL, 0x0000001c0e1c7210ULL, 0x040fe20007f1e0ffULL,
0x000000010f317824ULL, 0x040fe200008e0631ULL, 0x0000001e0e1e7210ULL, 0x000fe20007f3e0ffULL,
0x000000103c3d7824ULL, 0x000fe400078e023fULL, 0x000000010f337824ULL, 0x000fe200010e0633ULL,
0x000000280e287210ULL, 0x040fe20007f5e0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e023fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a3d7faeULL, 0x0003e2000b901c48ULL,
0x000000010f357824ULL, 0x000fe200018e0635ULL, 0x0000000c0e0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000103a417824ULL, 0x100fe200078e023fULL, 0x00000000303b7faeULL, 0x0003e2000b901c48ULL,
0x0000001039397824ULL, 0x000fc400078e023fULL, 0x000000010f1d7824ULL, 0x000fe200000e061dULL,
0x0000000032417faeULL, 0x0003e2000b901c48ULL, 0x0000001037377824ULL, 0x000fe400078e023fULL,
0x000000010f1f7824ULL, 0x040fe200008e061fULL, 0x0000000034397faeULL, 0x0003e2000b901c48ULL,
0x0000001036457824ULL, 0x000fe400078e023fULL, 0x000000010f297824ULL, 0x000fe200010e0629ULL,
0x000000001c437faeULL, 0x0003e2000b901c48ULL, 0x000000103e3f7824ULL, 0x000fc400078e023fULL,
0x000000010f0d7824ULL, 0x000fe200018e060dULL, 0x000000001e377faeULL, 0x0003e8000b901c48ULL,
0x0000000028457faeULL, 0x0003e8000b901c48ULL, 0x000000000c3f7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x002e220000000000ULL, 0x000000106e0c7812ULL, 0x000fc400078ec0ffULL,
0x000000086e0d7812ULL, 0x000fc600078ec0ffULL, 0x00000020090c7824ULL, 0x000fca00078e020cULL,
0x0000000c0d1e7210ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b668001e0e7f8cULL, 0x0002a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01b66c001e097984ULL, 0x000ee40000000800ULL, 0x8000000009ff7812ULL, 0x00cfe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c0c1c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e0dULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc8000001141dULL,
0x0000001c09097211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x0000000209097819ULL, 0x000fc8000000121cULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b66c001e097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001806b097810ULL, 0x000fca0007ffe05cULL, 0x0000000170097824ULL, 0x000fca00078e0209ULL,
0x01b00000090d7984ULL, 0x000ea80000000800ULL, 0x01b20000091c7984ULL, 0x0006620000000800ULL,
0x000000080d00720bULL, 0x004fe20003f1d000ULL, 0x0000d1b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x008fc800000e0100ULL, 0x0000ffff091d7812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff0c7224ULL, 0x000fd400078e0008ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000300097811ULL, 0x000fe400078ff0ffULL, 0x000000080d00720bULL, 0x000fe40003f34000ULL,
0x000000000900720cULL, 0x000fe20003f05270ULL, 0x0000d1627f007947ULL, 0x000fd4000b800000ULL,
0x00000000000c7806ULL, 0x000fc400008e0100ULL, 0x00000080006b8824ULL, 0x000fe200078e026bULL,
0x000000080d098209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100c0e7816ULL, 0x000fe200000000ffULL, 0x0000000170708824ULL, 0x000fca00078e026bULL,
0x01b4000970008388ULL, 0x0005e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000080d097209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL,
0x0000000809097221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x00000009001e7308ULL, 0x002e640000000800ULL, 0x0000001e07077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe20000011605ULL,
0x0000d0927f007947ULL, 0x000fea000b800000ULL, 0x00001f091e097589ULL, 0x0002a400000e0000ULL,
0x0000000910107220ULL, 0x084fe40000410000ULL, 0x0000000911117220ULL, 0x080fe40000410000ULL,
0x0000000914147220ULL, 0x080fe40000410000ULL, 0x0000000915157220ULL, 0x000fc40000410000ULL,
0x0000000918187220ULL, 0x080fe40000410000ULL, 0x0000000919197220ULL, 0x080fe40000410000ULL,
0x0000000950507220ULL, 0x080fe40000410000ULL, 0x0000000951517220ULL, 0x080fe40000410000ULL,
0x0000000954547220ULL, 0x080fe40000410000ULL, 0x0000000955557220ULL, 0x000fc40000410000ULL,
0x000000092c2c7220ULL, 0x080fe40000410000ULL, 0x000000092d2d7220ULL, 0x080fe40000410000ULL,
0x0000000920207220ULL, 0x0a0fe40000410000ULL, 0x0000000921217220ULL, 0x080fe40000410000ULL,
0x0000000924247220ULL, 0x080fe40000410000ULL, 0x0000000925257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805097811ULL, 0x000fe200078ff0ffULL,
0x0000cf927f007947ULL, 0x000fea000b800000ULL, 0x00001f091e097589ULL, 0x0004e400000e0000ULL,
0x0000000912127220ULL, 0x08cfe40000410000ULL, 0x0000000913137220ULL, 0x080fe40000410000ULL,
0x0000000916167220ULL, 0x080fe40000410000ULL, 0x0000000917177220ULL, 0x080fe40000410000ULL,
0x000000091a1a7220ULL, 0x080fe40000410000ULL, 0x000000091b1b7220ULL, 0x000fc40000410000ULL,
0x0000000952527220ULL, 0x080fe40000410000ULL, 0x0000000953537220ULL, 0x080fe40000410000ULL,
0x0000000956567220ULL, 0x080fe40000410000ULL, 0x0000000957577220ULL, 0x080fe40000410000ULL,
0x000000092e2e7220ULL, 0x080fe40000410000ULL, 0x000000092f2f7220ULL, 0x000fc40000410000ULL,
0x0000000922227220ULL, 0x0a0fe40000410000ULL, 0x0000000923237220ULL, 0x080fe40000410000ULL,
0x0000000926267220ULL, 0x080fe40000410000ULL, 0x0000000927277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff1dff7812ULL, 0x000fe4000780600cULL,
0x000000080d0c7209ULL, 0x000fd60007810000ULL, 0x8000000c0d0d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL, 0x0000000d00030308ULL, 0x000ea40000000800ULL,
0x000000031c1c0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000071c077221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000003ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011605ULL,
0x0000541004087816ULL, 0x000fe20000000004ULL, 0x0000cde27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d08047589ULL, 0x0002a400000e0000ULL, 0x000000080d097810ULL, 0x000fe20007ffe0ffULL,
0x0000ce327f007947ULL, 0x000fea000b800000ULL, 0x00001f0908067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100d097810ULL, 0x008fe20007ffe0ffULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00000008000e7202ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x000081b0000f7802ULL, 0x000fc40000000f00ULL,
0x0000d3c000007944ULL, 0x036fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180d097810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0008ULL,
0x00008220000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000d35000007944ULL, 0x032fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000705087812ULL, 0x00afe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x0000000808087812ULL, 0x000fca00078ef805ULL,
0x00000008080e7824ULL, 0x000fe200078e00ffULL, 0x00000002ff087819ULL, 0x000fc80000011600ULL,
0xfffffff80e677812ULL, 0x000fca00078ee267ULL, 0x0000008008407824ULL, 0x000fca00078e0267ULL,
0x0001280040407811ULL, 0x000fca00078e20ffULL, 0x00014000480d7810ULL, 0x000fe20007ffe0ffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x0000000300097811ULL, 0x004fe400078ff0ffULL,
0x0000000d65387211ULL, 0x000fe200078e20ffULL, 0x00000010614c7824ULL, 0x100fe200078e020dULL,
0x0000030002027a10ULL, 0x000fe20007ffe0ffULL, 0x0000001060487824ULL, 0x100fe200078e020dULL,
0x0001b6a008087811ULL, 0x000fe200078e18ffULL, 0x000000105f3c7824ULL, 0x100fe200078e020dULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x0000001062447824ULL, 0x000fc400078e020dULL,
0x00000800091c7824ULL, 0x000fe200078e0258ULL, 0x000000004c4c783bULL, 0x000ea20000004200ULL,
0x0000001064347824ULL, 0x100fe400078e020dULL, 0x0000001063307824ULL, 0x120fe200078e020dULL,
0x000000004848783bULL, 0x000ee20000004200ULL, 0x0000001066287824ULL, 0x000fc600078e020dULL,
0x000000003c3c783bULL, 0x000fe80000004200ULL, 0x000000004444783bULL, 0x000fe80000004200ULL,
0x011000001c1c783bULL, 0x000ee80000000200ULL, 0x000000003434783bULL, 0x000ee80000004200ULL,
0x000000003030783bULL, 0x000ee20000004200ULL, 0x0000000440400231ULL, 0x002fc600003400ffULL,
0x000000002828783bULL, 0x000e620000004200ULL, 0x0000000442420231ULL, 0x000fe400003400ffULL,
0x0000000641410231ULL, 0x080fe400003400ffULL, 0x0000000643430231ULL, 0x000fce00003400ffULL,
0x0000004c4010723cULL, 0x044f700000041810ULL, 0x0000004e4014723cULL, 0x040f700000041814ULL,
0x000000484018723cULL, 0x008f620000041818ULL, 0x000000041c1c0231ULL, 0x000fc400003400ffULL,
0x000000041e1e0231ULL, 0x000fe400003400ffULL, 0x000000061d1d0231ULL, 0x080fe400003400ffULL,
0x000000061f1f0231ULL, 0x000fe200003400ffULL, 0x0000004a4050723cULL, 0x040f700000041850ULL,
0x0000003c4054723cULL, 0x040f700000041854ULL, 0x0000003e402c723cULL, 0x040f70000004182cULL,
0x000000444020723cULL, 0x040f700000041820ULL, 0x000000464024723cULL, 0x000f700000041824ULL,
0x000000381c10723cULL, 0x060b700000041810ULL, 0x0000003a1c14723cULL, 0x040b700000041814ULL,
0x000000341c18723cULL, 0x040b700000041818ULL, 0x000000361c50723cULL, 0x040b700000041850ULL,
0x000000301c54723cULL, 0x040b700000041854ULL, 0x000000321c2c723cULL, 0x040b70000004182cULL,
0x000000281c20723cULL, 0x042b700000041820ULL, 0x0000002a1c1c723cULL, 0x000b620000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000005e0200720cULL, 0x000fe20003f06070ULL,
0x0000000008ff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff935000007947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000e640000002500ULL,
0x0000005e0200720cULL, 0x002fda0003f06070ULL, 0x0000032000000947ULL, 0x000fea0003800000ULL,
0x0180000007037810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000003037812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x000086d000087802ULL, 0x000fc40000000f00ULL,
0x0000ccf000007944ULL, 0x030fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc80000000007ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fc40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x00000002ff047819ULL, 0x002fe40000011605ULL, 0x0000000805067811ULL, 0x000fc800078ff0ffULL,
0x00001f0403047589ULL, 0x00ce6800000e0000ULL, 0x00001f0603057589ULL, 0x000ea200000e0000ULL,
0x0000001004107220ULL, 0x062fe40000410000ULL, 0x0000001104117220ULL, 0x040fe40000410000ULL,
0x0000001404147220ULL, 0x040fe40000410000ULL, 0x0000001504157220ULL, 0x000fc40000410000ULL,
0x0000001804187220ULL, 0x040fe40000410000ULL, 0x0000001904197220ULL, 0x040fe40000410000ULL,
0x0000005004507220ULL, 0x040fe40000410000ULL, 0x0000005104517220ULL, 0x040fe40000410000ULL,
0x0000005404547220ULL, 0x040fe40000410000ULL, 0x0000005504557220ULL, 0x000fc40000410000ULL,
0x0000002c042c7220ULL, 0x040fe40000410000ULL, 0x0000002d042d7220ULL, 0x040fe40000410000ULL,
0x0000002004207220ULL, 0x040fe40000410000ULL, 0x0000002104217220ULL, 0x040fe40000410000ULL,
0x0000001c041c7220ULL, 0x040fe40000410000ULL, 0x0000001d041d7220ULL, 0x000fc40000410000ULL,
0x0000001205127220ULL, 0x044fe40000410000ULL, 0x0000001305137220ULL, 0x040fe40000410000ULL,
0x0000001605167220ULL, 0x040fe40000410000ULL, 0x0000001705177220ULL, 0x040fe40000410000ULL,
0x0000001a051a7220ULL, 0x040fe40000410000ULL, 0x0000001b051b7220ULL, 0x000fc40000410000ULL,
0x0000005205527220ULL, 0x040fe40000410000ULL, 0x0000005305537220ULL, 0x040fe40000410000ULL,
0x0000005605567220ULL, 0x040fe40000410000ULL, 0x0000005705577220ULL, 0x040fe40000410000ULL,
0x0000002e052e7220ULL, 0x040fe40000410000ULL, 0x0000002f052f7220ULL, 0x000fc40000410000ULL,
0x0000002205227220ULL, 0x040fe40000410000ULL, 0x0000002305237220ULL, 0x040fe40000410000ULL,
0x0000001e051e7220ULL, 0x040fe40000410000ULL, 0x0000001f051f7220ULL, 0x000fc40000410000ULL,
0x0000000000087919ULL, 0x000e620000000000ULL, 0x000000141506723eULL, 0x020fe400000010ffULL,
0x0000001a1b14723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000101103723eULL, 0x000fc400000010ffULL, 0x0000001c1d11723eULL, 0x000fe400000010ffULL,
0x000000202110723eULL, 0x000fe400000010ffULL, 0x0000001e1f1a723eULL, 0x000fe400000010ffULL,
0x000000121312723eULL, 0x000fe400000010ffULL, 0x000000181909723eULL, 0x000fe400000010ffULL,
0x000000161713723eULL, 0x000fc400000010ffULL, 0x00000002ff1b7819ULL, 0x002fe40000011608ULL,
0x000000222319723eULL, 0x000fe400000010ffULL, 0x000000011b047810ULL, 0x040fe20007ffe0ffULL,
0x000000081b1d7824ULL, 0x040fe200078e00ffULL, 0x000000021b057810ULL, 0x040fe20007ffe0ffULL,
0x000000081b0e7824ULL, 0x040fe200078e00ffULL, 0x000000061b177810ULL, 0x040fe20007ffe0ffULL,
0x000000081b217824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee204ULL,
0x000000081b1c7824ULL, 0x040fe200078e00ffULL, 0x000000031b047810ULL, 0x040fe20007ffe0ffULL,
0x000000081b257824ULL, 0x040fe200078e00ffULL, 0xfffffff80e1f7812ULL, 0x000fe200078ee205ULL,
0x000000081b1e7824ULL, 0x040fe200078e00ffULL, 0x000000041b057810ULL, 0x040fe20007ffe0ffULL,
0x000000081b297824ULL, 0x040fe200078e00ffULL, 0x000000051b0e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff821217812ULL, 0x000fe200078ee204ULL, 0x000000081b047824ULL, 0x000fe200078e00ffULL,
0xfffffff81c237812ULL, 0x000fe200078ee205ULL, 0x000010006a057824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20eULL, 0x000008000a0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e277812ULL, 0x000fe400078ee217ULL, 0xffffffff1b1c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff804177812ULL, 0x000fe200078ee21bULL, 0x00000004081b7824ULL, 0x040fe200078e00ffULL,
0x00000008082b7811ULL, 0x000fe200078ff0ffULL, 0x0000000105047824ULL, 0x000fe200078e020eULL,
0xfffffff829297812ULL, 0x000fc400078ee21cULL, 0x000000032b1e7819ULL, 0x000fe200000006ffULL,
0x0000001017177824ULL, 0x100fe200078e0204ULL, 0x0000000c1b1c7812ULL, 0x000fe200078ec0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0204ULL, 0xfffffff81e2b7812ULL, 0x000fe200078ee22bULL,
0x000000101f1f7824ULL, 0x100fe200078e0204ULL, 0x0000001c171e7210ULL, 0x000fe20007ffe0ffULL,
0x0000001021217824ULL, 0x100fe200078e0204ULL, 0x00000050510b723eULL, 0x000fe200000010ffULL,
0x0000001023237824ULL, 0x100fe200078e0204ULL, 0x00000054550d723eULL, 0x000fe200000010ffULL,
0x0000001025257824ULL, 0x100fe200078e0204ULL, 0x0000002c2d0f723eULL, 0x000fe200000010ffULL,
0x000000011c1d7824ULL, 0x040fe200078e021dULL, 0x000000031e007388ULL, 0x0003e20000000800ULL,
0x0000001027277824ULL, 0x100fe200078e0204ULL, 0x000000525315723eULL, 0x000fe200000010ffULL,
0x000000011c1f7824ULL, 0x040fe200078e021fULL, 0x000000061d007388ULL, 0x000fe20000000800ULL,
0x0000001029297824ULL, 0x100fe200078e0204ULL, 0x000000565716723eULL, 0x000fe200000010ffULL,
0x000000011c207824ULL, 0x040fe200078e0221ULL, 0x000000091f007388ULL, 0x000fe20000000800ULL,
0x000000102b2b7824ULL, 0x000fe200078e0204ULL, 0x0000002e2f18723eULL, 0x000fe200000010ffULL,
0x000000011c237824ULL, 0x040fe200078e0223ULL, 0x0000000b20007388ULL, 0x000fe20000000800ULL,
0x000000011c257824ULL, 0x040fe200078e0225ULL, 0x000000ff00037306ULL, 0x002fe20000205400ULL,
0x000000011c277824ULL, 0x040fe200078e0227ULL, 0x0000000d23007388ULL, 0x0003e20000000800ULL,
0x000000011c297824ULL, 0x000fc400078e0229ULL, 0x000000011c2b7824ULL, 0x000fe200078e022bULL,
0x0000000f25007388ULL, 0x000fe20000000800ULL, 0x000000016f1c7824ULL, 0x000fe200078e0208ULL,
0x000000ff001e7306ULL, 0x000ea40000209400ULL, 0x0000001027007388ULL, 0x000fe20000000800ULL,
0x000000101c0d7824ULL, 0x002fc600078e0205ULL, 0x0000001129007388ULL, 0x000fe40000000800ULL,
0x000000ff00067306ULL, 0x000e64000020d400ULL, 0x000000122b007388ULL, 0x000fe80000000800ULL,
0x000400131d007388ULL, 0x000fe20000000800ULL, 0x000000031e00720bULL, 0x004fc60003f1d000ULL,
0x000400141f007388ULL, 0x000fe80000000800ULL, 0x0004001520007388ULL, 0x000fe80000000800ULL,
0x0004001623007388ULL, 0x0005e40000000800ULL, 0x0000000106060812ULL, 0x002fc400078efcffULL,
0x0004001825007388ULL, 0x000fe40000000800ULL, 0x00000006060b723eULL, 0x000fe400000010ffULL,
0x0004001927007388ULL, 0x000fe20000000800ULL, 0x00000300ff237624ULL, 0x004fc600078e00ffULL,
0x0004001a29007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000d2c7984ULL, 0x000e620000000c00ULL, 0x000000012300780cULL, 0x000fc60003f05270ULL,
0x000400000d147984ULL, 0x000ea80000000c00ULL, 0x000800000d307984ULL, 0x000ee80000000c00ULL,
0x000c00000d107984ULL, 0x000ee20000000c00ULL, 0x3f803f800b2f7831ULL, 0x042fe4000020002fULL,
0x3f803f800b2e7831ULL, 0x000fc4000020002eULL, 0x3f803f800b2d7831ULL, 0x040fe4000020002dULL,
0x3f803f800b2c7831ULL, 0x040fe4000020002cULL, 0x3f803f800b177831ULL, 0x044fe40000200017ULL,
0x3f803f800b097831ULL, 0x040fe40000200016ULL, 0x3f803f800b157831ULL, 0x040fe40000200015ULL,
0x3f803f800b147831ULL, 0x000fc40000200014ULL, 0x3f803f802f2f7831ULL, 0x008fe40000200033ULL,
0x3f803f802e2e7831ULL, 0x000fe40000200032ULL, 0x3f803f802d2d7831ULL, 0x000fe40000200031ULL,
0x3f803f802c2c7831ULL, 0x000fe40000200030ULL, 0x3f803f8017177831ULL, 0x000fe40000200013ULL,
0x3f803f8009167831ULL, 0x000fe20000200012ULL, 0x0000002c0d007388ULL, 0x000fe20000000c00ULL,
0x3f803f8015157831ULL, 0x000fc40000200011ULL, 0x3f803f8014147831ULL, 0x000fca0000200010ULL,
0x000400140d007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00002a5000008947ULL, 0x000fea0003800000ULL, 0x00000400ff037624ULL, 0x000fe200078e00ffULL,
0x00000000000f7919ULL, 0x000e660000002600ULL, 0x00006a0003037a24ULL, 0x000fe200078e02ffULL,
0x00000000001a7919ULL, 0x000e680000002700ULL, 0x0000000f03187811ULL, 0x040fe200078e10ffULL,
0x0000030003037a24ULL, 0x000fe200078e02ffULL, 0x000000000d107984ULL, 0x000ea40000000c00ULL,
0xfffffff018187812ULL, 0x000fc400078ec0ffULL, 0x000400000d147984ULL, 0x0006a40000000c00ULL,
0x00000018030b7211ULL, 0x000fca00078e38ffULL, 0x0000008003037824ULL, 0x000fe200078e020bULL,
0x000000401c0d7810ULL, 0x008fc80007ffe0ffULL, 0x0000007f03037810ULL, 0x000fe20007ffe0ffULL,
0x000004001a0f7a24ULL, 0x002fc600078e020fULL, 0xffffff8003037812ULL, 0x000fe200078ec0ffULL,
0x000003000f097a24ULL, 0x000fc600078e02ffULL, 0x00006e00031b7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000109027824ULL, 0x000fc800078e0202ULL, 0x00006f00ff197624ULL, 0x000fe200000e06ffULL,
0x000000010aff7812ULL, 0x000fe4000780f800ULL, 0x0000001b021a7211ULL, 0x000fc800078260ffULL,
0x00000019021b7211ULL, 0x000fe400008f64ffULL, 0x00006e0018197a10ULL, 0x000fc60007f3e0ffULL,
0x000008006a1a7825ULL, 0x000fc800078e001aULL, 0x00006f00ff227624ULL, 0x000fe400008e06ffULL,
0x000000101c1c7825ULL, 0x000fc800078e001aULL, 0x000000100d1a7825ULL, 0x000fe200078e001aULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x00000010080d7824ULL, 0x004fe200078e00ffULL,
0x00000001ff1f7819ULL, 0x000fe20000011608ULL, 0x00000080021e7824ULL, 0x000fe200078e00ffULL,
0x00000019ff027819ULL, 0x000fe40000011602ULL, 0x000000700d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1f1f7812ULL, 0x000fe400078ec0ffULL, 0x00006e001e207a10ULL, 0x000fc40007ebe00bULL,
0x000000190d1e7210ULL, 0x000fe40007a3e01eULL, 0x000000201f207210ULL, 0x040fe40007c7e00dULL,
0x00006f00020d7a10ULL, 0x000fe40002fec4ffULL, 0x0000001e1f1e7210ULL, 0x000fe40007fbe0ffULL,
0x00000022ff027210ULL, 0x000fe40000fe4402ULL, 0x0000000dff217210ULL, 0x000fc60001fe84ffULL,
0x000000ffff1f7224ULL, 0x000fca00028e0602ULL, 0x0000000c1e007986ULL, 0x0003e8000c101908ULL,
0x0000000720007986ULL, 0x0003e4000c101908ULL, 0x000000ff0800720cULL, 0x004fe20000705670ULL,
0x000000101c007986ULL, 0x000fe2000c101d08ULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000141a007986ULL, 0x000fe8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff0c7424ULL, 0x002fe200078e00ffULL,
0xffffffff23077810ULL, 0x000fc60007ffe0ffULL, 0x00006e000f0c7625ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x000000070c0c79a8ULL, 0x000ea400099ee1c8ULL,
0x000000070c00720cULL, 0x004fc80003f05270ULL, 0x00000001ff027807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000002ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff027984ULL, 0x002e640000000000ULL, 0x000000ff0200720cULL, 0x002fda0003f05270ULL,
0x000025d000008947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001008007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe40000011608ULL, 0x00000019090c7211ULL, 0x040fe400078038ffULL,
0x00000070000d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c02027812ULL, 0x000fe400078ec0ffULL,
0x0000002209007211ULL, 0x000fe400000f3cffULL, 0x0000000c020c7210ULL, 0x000fc8000791e00dULL,
0x00000000ff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c007981ULL, 0x000328000c1e1900ULL,
0x000080080c077981ULL, 0x000322000c1e1900ULL, 0x000000022300780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x000100080c0f7981ULL, 0x002322000c1e1900ULL,
0x000000042300780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x000180080c117981ULL, 0x002322000c1e1900ULL, 0x000000042300780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x000200080c137981ULL, 0x002322000c1e1900ULL,
0x000000062300780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x000280080c157981ULL, 0x002322000c1e1900ULL, 0x000000062300780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000082300780cULL, 0x002fe20003f06070ULL,
0x000300080c177981ULL, 0x000318000c1e1900ULL, 0x000380080c190981ULL, 0x000324000c1e1900ULL,
0x0000000723027810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff027819ULL, 0x000fc80000011602ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x00000018091d7211ULL, 0x000fe200078038ffULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1b7224ULL, 0x010fe200078e0000ULL,
0x00006e001d1d7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff09107211ULL, 0x000fe400000f3cffULL,
0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL, 0x00006f00ff107a10ULL, 0x000fc400017e2410ULL,
0x0000030012007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000402007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x00000008120c7810ULL, 0x040fe40007ffe0ffULL, 0x00000001120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001b00007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010080c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011608ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fc80007f3e0ffULL, 0x00000010ff0d7210ULL, 0x000fca0000ffe4ffULL,
0xfffc80080c1b7981ULL, 0x000328000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x00000009120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000002120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000700007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001008077824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fc80000011608ULL,
0x0000007007077812ULL, 0x000fc800078ec0ffULL, 0x0000000c070c7812ULL, 0x000fc800078ef80cULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xfffd00080c077981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000003120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000f00007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010080c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011608ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xfffd80080c0f7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000004120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001100007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010080c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011608ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xfffe00080c117981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000005120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001300007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010080c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011608ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xfffe80080c137981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000006120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001500007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010080c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011608ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xffff00080c157981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000007120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001700007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010080c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011608ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xffff80080c177981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f120c7810ULL, 0x002fe40007ffe0ffULL, 0x0000001900007209ULL, 0x000fe40007810000ULL,
0x000003000c007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000004080c7819ULL, 0x000fe400000006ffULL, 0x00000001ff0d7819ULL, 0x000fe40000011608ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0x000000080c197981ULL, 0x000326000c1e1900ULL, 0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL,
0x0000000812127810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200008e0610ULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000087919ULL, 0x000ea40000000000ULL,
0x0000001008027824ULL, 0x004fe200078e00ffULL, 0x00000001ff077819ULL, 0x010fc80000011608ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fca00078ec0ffULL,
0x0000000102077824ULL, 0x000fca00078e0207ULL, 0x0000000007007388ULL, 0x0005e40000000800ULL,
0x00006e0003027a10ULL, 0x000fe20007f3e0ffULL, 0x000000010a1c7824ULL, 0x000fe200078e0209ULL,
0x000000070800780cULL, 0x000fe20003f04070ULL, 0x000008006a007824ULL, 0x004fe200078e00ffULL,
0x000000010a077812ULL, 0x000fe200078ec0ffULL, 0x00006f00ff037624ULL, 0x000fe200008e06ffULL,
0x000008000e0e7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000010001c0c7825ULL, 0x002fe200078e0002ULL, 0x0000002008137810ULL, 0x040fe20007ffe0ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000004008157810ULL, 0x000fe20007ffe0ffULL,
0x000000020a128824ULL, 0x100fe200078e026aULL, 0x000000000c107210ULL, 0x000fe20007f3e0ffULL,
0x000000020a148824ULL, 0x000fe200078e026aULL, 0x0000006008177810ULL, 0x000fe20007ffe0ffULL,
0x00000002121b8824ULL, 0x100fe200078e0207ULL, 0x00000001ff0c7819ULL, 0x100fe20000011608ULL,
0x0000000214258824ULL, 0x000fe200078e0207ULL, 0x00006e0018167a10ULL, 0x000fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x00006e000b077a10ULL, 0x000fe20007f3e0ffULL,
0x00000010080d7824ULL, 0x000fe200078e00ffULL, 0x000000050a0b7211ULL, 0x000fe200078e68ffULL,
0x00006f00ff197624ULL, 0x000fe200010e06ffULL, 0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000081b238824ULL, 0x000fe200078e0208ULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000010b0f7824ULL, 0x000fe200078e020eULL, 0x000000161c1a8211ULL, 0x000fe200078438ffULL,
0x0000000825258824ULL, 0x000fe200078e0208ULL, 0x0000458023238811ULL, 0x000fe200078e20ffULL,
0x00000010081f7824ULL, 0x000fe200078e020fULL, 0x000000191c1b8211ULL, 0x040fe200010f3cffULL,
0x00000010130e7825ULL, 0x100fe200078e0010ULL, 0x0000418025258811ULL, 0x000fe200078e20ffULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000001015127825ULL, 0x100fe200078e0010ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000001017147825ULL, 0x000fe200078e0010ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00006f00ff177624ULL, 0x000fe200008e06ffULL, 0x000000071c208211ULL, 0x000fe200078238ffULL,
0x000000010d1d7824ULL, 0x000fe200078e020cULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000001008107825ULL, 0x000fe200078e0010ULL, 0x000000171c218211ULL, 0x000fc400008f3cffULL,
0x000003000a007a0cULL, 0x000fe20003f26070ULL, 0x000000001d187984ULL, 0x0002a20000000800ULL,
0x000000ffff3b7224ULL, 0x000fe400078e00ffULL, 0x0000001008208825ULL, 0x000fe200078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000101f7faeULL, 0x0007e8000b901c48ULL,
0x003800000e1f7faeULL, 0x0007e2000b901c48ULL, 0x00000000001c7805ULL, 0x002fc6000001ff00ULL,
0x00580000121f7faeULL, 0x0003e2000b901c48ULL, 0x0000001008108825ULL, 0x008fc600078e001aULL,
0x00780000141f7faeULL, 0x0003e2000b901c48ULL, 0x00000000001a7805ULL, 0x000fc6000001ff00ULL,
0x0000000020238faeULL, 0x0007e8000b901c48ULL, 0x0000000010258faeULL, 0x0005e8000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000001e7805ULL, 0x002fe2000001ff00ULL,
0x0000000000207805ULL, 0x008fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x004fe2000001ff00ULL, 0x00000c5000001947ULL, 0x000fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fe400078e00ffULL, 0x000000ffff3a7224ULL, 0x000fca00078e000aULL,
0x000000013a0e7810ULL, 0x000fc80007ffe0ffULL, 0x000003000e007a0cULL, 0x000fda0003f06070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x00000001093e7824ULL, 0x000fe200078e020eULL,
0x000000070800780cULL, 0x000fe40003f44070ULL, 0x000000010e0f7812ULL, 0x000fe200078ec0ffULL,
0x000010003e0c7825ULL, 0x000fe200078e0002ULL, 0x0000004008157810ULL, 0x040fe40007ffe0ffULL,
0x0000006008437810ULL, 0x000fe40007ffe0ffULL, 0x000000000c127210ULL, 0x000fe20007f1e0ffULL,
0x000008000e0c7824ULL, 0x000fc800078e00ffULL, 0x0000006a0a10a211ULL, 0x040fe200078e08ffULL,
0x000000020a14a824ULL, 0x000fe200078e026aULL, 0x000008000c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff137224ULL, 0x000fe400000e060dULL, 0x000000021041a824ULL, 0x100fe200078e020fULL,
0x000000073e10a211ULL, 0x000fe200078038ffULL, 0x000000021445a824ULL, 0x000fe200078e020fULL,
0x00000020080f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0d7824ULL, 0x000fe200078e020cULL,
0x000000163e14a211ULL, 0x000fe200078238ffULL, 0x00000010083c7825ULL, 0x000fe200078e0012ULL,
0x000000173e11a211ULL, 0x000fc600000f3cffULL, 0x00000010083f7824ULL, 0x000fe400078e020dULL,
0x000000100f0e7825ULL, 0x000fc600078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800003c3f7faeULL, 0x0003e2000b901c48ULL, 0x00000010150c7825ULL, 0x100fe200078e0012ULL,
0x000000193e15a211ULL, 0x000fe400008f3cffULL, 0x003800000e3f7faeULL, 0x0003e2000b901c48ULL,
0x0000001043127825ULL, 0x000fc600078e0012ULL, 0x005800000c3f7faeULL, 0x0003e2000b901c48ULL,
0x000000084141a824ULL, 0x100fe400078e0208ULL, 0x000000084543a824ULL, 0x000fe200078e0208ULL,
0x00780000123f7faeULL, 0x0003e2000b901c48ULL, 0x000000100810a825ULL, 0x040fe200078e0010ULL,
0x000045804141a811ULL, 0x000fe400078e20ffULL, 0x000041804343a811ULL, 0x000fe200078e20ffULL,
0x000000100814a825ULL, 0x000fe400078e0014ULL, 0x000000001041afaeULL, 0x0003e8000b901c48ULL,
0x000000001443afaeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000803a0c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011608ULL,
0x000000020a0f7824ULL, 0x000fe200078e026aULL, 0x00000002ff457819ULL, 0x000fe20000011608ULL,
0x00000010080d7824ULL, 0x000fe200078e00ffULL, 0x000000800c0c7812ULL, 0x000fc400078ec0ffULL,
0x0000000145127810ULL, 0x040fe20007ffe0ffULL, 0x00000008453f7824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0e7211ULL, 0x000fe200078e40ffULL, 0x0000000845437824ULL, 0x000fe200078e00ffULL,
0x000000700d0d7812ULL, 0x000fe200078ec0ffULL, 0x00000008453c7824ULL, 0x000fe200078e00ffULL,
0x0000000c100c7812ULL, 0x000fe200078ec0ffULL, 0x0000000408107824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee212ULL, 0x0000000845127824ULL, 0x040fe200078e00ffULL,
0x0000000e0c0f7210ULL, 0x000fe20007ffe00dULL, 0x000008003a0e7824ULL, 0x000fe200078e00ffULL,
0x00000008454d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000845497824ULL, 0x040fe200078e00ffULL,
0x0000000c10467812ULL, 0x000fe200078ec0ffULL, 0x00000008454b7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000f117984ULL, 0x000e620000000800ULL,
0x000008000e0e7812ULL, 0x000fe400078ec0ffULL, 0xfffffff812137812ULL, 0x000fe200078ee245ULL,
0x004580000f157984ULL, 0x0004e20000000800ULL, 0x000001800b107810ULL, 0x000fe20007ffe00eULL,
0x000000084d0e7824ULL, 0x000fe200078e00ffULL, 0x0000000245147810ULL, 0x040fe40007ffe0ffULL,
0x0000000345477819ULL, 0x000fe400000006ffULL, 0xfffffff843437812ULL, 0x000fc400078ee214ULL,
0xfffffff80e0f7812ULL, 0x004fe200078ee24dULL, 0x00000010130e7824ULL, 0x000fe200078e0210ULL,
0x0000000445147810ULL, 0x040fe40007ffe0ffULL, 0xffffffff45407810ULL, 0x000fe20007ffe0ffULL,
0x00000001460e7824ULL, 0x040fe200078e020eULL, 0xfffffff847477812ULL, 0x000fe200078ee214ULL,
0x000000100f0f7824ULL, 0x000fe200078e0210ULL, 0x0000000545147810ULL, 0x000fe40007ffe0ffULL,
0x000000000e3d7984ULL, 0x000ea20000000800ULL, 0x0000000146137824ULL, 0x000fe200078e020fULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee240ULL, 0x000000103f0f7824ULL, 0x000fe200078e0210ULL,
0x000000023a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000013417984ULL, 0x0003e40000000800ULL,
0x000003003a007a0cULL, 0x000fe20003f06070ULL, 0x0000001118117221ULL, 0x002fc80000010100ULL,
0x3fb8aa3b11127820ULL, 0x000fe20000410000ULL, 0x0000000345117810ULL, 0x000fc80007ffe0ffULL,
0xfffffff83c3f7812ULL, 0x000fe200078ee211ULL, 0x0000001200127308ULL, 0x000ee20000000800ULL,
0x0000000146117824ULL, 0x040fe400078e020fULL, 0x00000010430f7824ULL, 0x100fe400078e0210ULL,
0x000000103f137824ULL, 0x000fe200078e0210ULL, 0x00000000113e7984ULL, 0x000fe60000000800ULL,
0x0000000146137824ULL, 0x000fe200078e0213ULL, 0x0004000011427984ULL, 0x0003e80000000800ULL,
0x0000000013407984ULL, 0x000fe20000000800ULL, 0x00000015123c7220ULL, 0x008fe20000410000ULL,
0xfffffff849157812ULL, 0x000fe200078ee214ULL, 0x0000000146127824ULL, 0x000fe200078e020fULL,
0x0000000645147810ULL, 0x000fe20007ffe0ffULL, 0x0000001047117824ULL, 0x002fe200078e0210ULL,
0x00001f453c0f7589ULL, 0x000e6200000e0000ULL, 0x0000003b3c3b7221ULL, 0x000fe20000010000ULL,
0xfffffff849497812ULL, 0x000fe200078ee214ULL, 0x0000000146117824ULL, 0x000fe200078e0211ULL,
0x00001f4d3c0e7589ULL, 0x000ee200000e0000ULL, 0x0000001015147824ULL, 0x000fc400078e0210ULL,
0x0000001049157824ULL, 0x100fe200078e0210ULL, 0x00000000113c7984ULL, 0x000fe20000000800ULL,
0x000000104b107824ULL, 0x000fe200078e0210ULL, 0x0000001446147210ULL, 0x040fe20007ffe0ffULL,
0x0000000146157824ULL, 0x040fe200078e0215ULL, 0x0004000011457984ULL, 0x0005e20000000800ULL,
0x0000000146107824ULL, 0x000fc600078e0210ULL, 0x00000000123f7984ULL, 0x000ee20000000800ULL,
0x00007610ff117816ULL, 0x004fc6000000003dULL, 0x0004000012437984ULL, 0x0004e40000000800ULL,
0x0000000f112c7223ULL, 0x002fe2000001002cULL, 0x00005410ff117816ULL, 0x000fe20000000041ULL,
0x0004000013447984ULL, 0x000e620000000800ULL, 0x00005410ff127816ULL, 0x004fc6000000003dULL,
0x0000000e11397223ULL, 0x008fe20000010039ULL, 0x00007610ff117816ULL, 0x000fe20000000041ULL,
0x0000000014137984ULL, 0x000ea20000000800ULL, 0x0000000f122d7223ULL, 0x000fc6000001002dULL,
0x0000000e112b7223ULL, 0x080fe2000001002bULL, 0x00005410ff117816ULL, 0x000fe2000000003eULL,
0x0004000014417984ULL, 0x000ee80000000800ULL, 0x0000000f11207223ULL, 0x080fe20000010020ULL,
0x00007610ff117816ULL, 0x000fe2000000003eULL, 0x00000000153d7984ULL, 0x000e680000000800ULL,
0x0000000f11387223ULL, 0x000fe20000010038ULL, 0x00005410ff117816ULL, 0x000fe20000000042ULL,
0x00040000153e7984ULL, 0x000e680000000800ULL, 0x0000000e111e7223ULL, 0x000fe2000001001eULL,
0x00007610ff117816ULL, 0x000fc40000000042ULL, 0x00005410ff127816ULL, 0x000fc6000000003fULL,
0x0000000e112a7223ULL, 0x000fe2000001002aULL, 0x00007610ff117816ULL, 0x000fe2000000003fULL,
0x0000000f12297223ULL, 0x080fe40000010029ULL, 0x0000000010127984ULL, 0x000ea40000000800ULL,
0x0000000f11287223ULL, 0x000fe20000010028ULL, 0x00005410ff117816ULL, 0x000fca0000000043ULL,
0x0000000e11277223ULL, 0x000fe40000010027ULL, 0x0004000010117984ULL, 0x0006a40000000800ULL,
0x00007610ff107816ULL, 0x008fca0000000043ULL, 0x0000000e10377223ULL, 0x000fe20000010037ULL,
0x00005410ff107816ULL, 0x000fca0000000040ULL, 0x0000000f10267223ULL, 0x000fe20000010026ULL,
0x00007610ff107816ULL, 0x000fca0000000040ULL, 0x0000000f10367223ULL, 0x000fe20000010036ULL,
0x00005410ff107816ULL, 0x002fca0000000044ULL, 0x0000000e10257223ULL, 0x000fe20000010025ULL,
0x00007610ff107816ULL, 0x000fca0000000044ULL, 0x0000000e10357223ULL, 0x000fe20000010035ULL,
0x00005410ff107816ULL, 0x000fca000000003cULL, 0x0000000f10247223ULL, 0x000fe20000010024ULL,
0x00007610ff107816ULL, 0x000fca000000003cULL, 0x0000000f10347223ULL, 0x000fe20000010034ULL,
0x00005410ff107816ULL, 0x000fca0000000045ULL, 0x0000000e10237223ULL, 0x000fe20000010023ULL,
0x00007610ff107816ULL, 0x000fca0000000045ULL, 0x0000000e10337223ULL, 0x000fe20000010033ULL,
0x00005410ff107816ULL, 0x004fca0000000013ULL, 0x0000000f10227223ULL, 0x000fe20000010022ULL,
0x00007610ff107816ULL, 0x000fca0000000013ULL, 0x0000000f10327223ULL, 0x000fe20000010032ULL,
0x00005410ff107816ULL, 0x000fca0000000041ULL, 0x0000000e10217223ULL, 0x000fe20000010021ULL,
0x00007610ff107816ULL, 0x000fca0000000041ULL, 0x0000000e10317223ULL, 0x000fe20000010031ULL,
0x00005410ff107816ULL, 0x000fca000000003dULL, 0x0000000f101f7223ULL, 0x000fe2000001001fULL,
0x00007610ff107816ULL, 0x000fca000000003dULL, 0x0000000f10307223ULL, 0x000fe20000010030ULL,
0x00005410ff107816ULL, 0x000fca000000003eULL, 0x0000000e101d7223ULL, 0x000fe2000001001dULL,
0x00007610ff107816ULL, 0x000fca000000003eULL, 0x0000000e102f7223ULL, 0x000fe2000001002fULL,
0x00005410ff107816ULL, 0x000fca0000000012ULL, 0x0000000f101c7223ULL, 0x000fe2000001001cULL,
0x00007610ff107816ULL, 0x000fca0000000012ULL, 0x0000000f102e7223ULL, 0x000fe2000001002eULL,
0x00005410ff0f7816ULL, 0x000fca0000000011ULL, 0x0000000e0f1b7223ULL, 0x000fe2000001001bULL,
0x00007610ff0f7816ULL, 0x000fca0000000011ULL, 0x0000000e0f1a7223ULL, 0x000fe2000001001aULL,
0xfffff3d000008947ULL, 0x000fea000383ffffULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x0000018000007945ULL, 0x000fd80003800000ULL, 0x000000800a038824ULL, 0x000fc800078e020dULL,
0x000000010c008824ULL, 0x000fe400078e0203ULL, 0x000000010d0c7824ULL, 0x000fc600078e020cULL,
0x0049803b00008388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x004980000c027984ULL, 0x000e680000000800ULL, 0x004a00000c037984ULL, 0x000ea20000000800ULL,
0x00000002ff027221ULL, 0x002fc80000010000ULL, 0x0000000302027221ULL, 0x004fca0000010000ULL,
0x0180000002037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e0002ULL,
0x0000b20000087802ULL, 0x000fc40000000f00ULL, 0x0000a1c000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200037308ULL, 0x000e640000001000ULL, 0xbf80000002007423ULL, 0x002fc80000000003ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000808137811ULL, 0x004fc400078ff0ffULL,
0x00000002ff117819ULL, 0x000fc60000011608ULL, 0x00001f1300027589ULL, 0x000ea200000e0000ULL,
0x0000000111157810ULL, 0x040fe20007ffe0ffULL, 0x0000000811197824ULL, 0x040fe200078e00ffULL,
0x0000000211167810ULL, 0x040fe20007ffe0ffULL, 0x00001f1100037589ULL, 0x00066200000e0000ULL,
0x0000000311187810ULL, 0x000fe40007ffe0ffULL, 0xfffffff819197812ULL, 0x000fe400078ee216ULL,
0x0000000511167810ULL, 0x000fc60007ffe0ffULL, 0x0000001019197824ULL, 0x000fe400078e0204ULL,
0x0000002a020f7220ULL, 0x044fe40000410000ULL, 0x0000003902397220ULL, 0x040fe40000410000ULL,
0x0000002b02007220ULL, 0x048fe40000410000ULL, 0x0000001e021e7220ULL, 0x040fe40000410000ULL,
0x0000002702277220ULL, 0x000fe20000410000ULL, 0x000000390000723eULL, 0x000fe200000010ffULL,
0x00000037020c7220ULL, 0x040fe20000410000ULL, 0x0000001e0f0f723eULL, 0x000fe200000010ffULL,
0x0000002502257220ULL, 0x000fc40000410000ULL, 0x00000035020e7220ULL, 0x000fe20000410000ULL,
0x000000270c0c723eULL, 0x000fe200000010ffULL, 0x0000002302237220ULL, 0x040fe40000410000ULL,
0x0000003302107220ULL, 0x040fe20000410000ULL, 0x0000000311337819ULL, 0x000fe200000006ffULL,
0x0000002102217220ULL, 0x000fe20000410000ULL, 0x000000250e0e723eULL, 0x000fe200000010ffULL,
0x0000003102127220ULL, 0x000fe20000410000ULL, 0x000000231010723eULL, 0x000fe200000010ffULL,
0x0000001d021d7220ULL, 0x000fc40000410000ULL, 0x0000002f02147220ULL, 0x000fe20000410000ULL,
0x000000211212723eULL, 0x000fe200000010ffULL, 0x0000001b021b7220ULL, 0x000fe40000410000ULL,
0x00000008112a7824ULL, 0x040fe200078e00ffULL, 0x0000001d1414723eULL, 0x000fe200000010ffULL,
0x0000001a02027220ULL, 0x000fe20000410000ULL, 0x00000004111a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008112b7824ULL, 0x040fe200078e00ffULL, 0xfffffff82a177812ULL, 0x040fe200078ee215ULL,
0x00000008112f7824ULL, 0x040fe200078e00ffULL, 0xfffffff82a157812ULL, 0x000fe200078ee211ULL,
0x0000000811317824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee218ULL,
0x0000000811357824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee21aULL,
0x00000008132a7824ULL, 0x000fe200078e00ffULL, 0x0000000611187810ULL, 0x000fe20007ffe0ffULL,
0x0000002d032d7220ULL, 0x002fe20000410000ULL, 0xffffffff111a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000408117824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee216ULL,
0x0000002c032c7220ULL, 0x000fe20000410000ULL, 0xfffffff833337812ULL, 0x000fe200078ee218ULL,
0x0000001015157824ULL, 0x000fe200078e0204ULL, 0xfffffff835357812ULL, 0x000fe200078ee21aULL,
0x0000002003207220ULL, 0x040fe20000410000ULL, 0xfffffff82a137812ULL, 0x000fe200078ee213ULL,
0x0000003803077220ULL, 0x000fe20000410000ULL, 0x0000000c11167812ULL, 0x000fe200078ec0ffULL,
0x0000002903297220ULL, 0x040fe20000410000ULL, 0x0000002d2c2c723eULL, 0x000fe200000010ffULL,
0x0000002803287220ULL, 0x000fe20000410000ULL, 0x0000001615157210ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x100fe200078e0204ULL, 0x000000200707723eULL, 0x000fe200000010ffULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x000000292828723eULL, 0x000fe200000010ffULL,
0x0000003603097220ULL, 0x040fe20000410000ULL, 0x0000002c15007388ULL, 0x000fe20000000800ULL,
0x0000002403247220ULL, 0x040fe20000410000ULL, 0x0000001b0202723eULL, 0x000fe200000010ffULL,
0x00000034030b7220ULL, 0x000fe20000410000ULL, 0x000000260909723eULL, 0x000fe200000010ffULL,
0x000000102b2b7824ULL, 0x000fc400078e0204ULL, 0x0000002203227220ULL, 0x000fe20000410000ULL,
0x000000240b0b723eULL, 0x000fe200000010ffULL, 0x00000032030d7220ULL, 0x000fe40000410000ULL,
0x000000102f2f7824ULL, 0x100fe400078e0204ULL, 0x0000001031317824ULL, 0x100fe200078e0204ULL,
0x000000220d0d723eULL, 0x000fe200000010ffULL, 0x0000001033337824ULL, 0x100fe400078e0204ULL,
0x0000001035357824ULL, 0x000fc400078e0204ULL, 0x0000001013137824ULL, 0x000fe400078e0204ULL,
0x0000001f031f7220ULL, 0x040fe40000410000ULL, 0x0000003003307220ULL, 0x040fe40000410000ULL,
0x0000001c031c7220ULL, 0x040fe40000410000ULL, 0x0000000116047824ULL, 0x000fe200078e0217ULL,
0x0000001f301f723eULL, 0x000fe200000010ffULL, 0x0000002e03037220ULL, 0x000fc40000410000ULL,
0x0000000116117824ULL, 0x040fe200078e0219ULL, 0x0000000704007388ULL, 0x000fe20000000800ULL,
0x00000001162b7824ULL, 0x040fe200078e022bULL, 0x0000001c0303723eULL, 0x000fe200000010ffULL,
0x00000001162f7824ULL, 0x040fe200078e022fULL, 0x0000002811007388ULL, 0x000fe20000000800ULL,
0x0000000116317824ULL, 0x040fe400078e0231ULL, 0x0000000116337824ULL, 0x040fe200078e0233ULL,
0x000000092b007388ULL, 0x000fe20000000800ULL, 0x0000000116357824ULL, 0x000fc400078e0235ULL,
0x0000000116137824ULL, 0x000fe200078e0213ULL, 0x0000000b2f007388ULL, 0x000fe20000000800ULL,
0x000000016f167824ULL, 0x000fc600078e0208ULL, 0x0000000d31007388ULL, 0x000fe20000000800ULL,
0x0000001016167824ULL, 0x000fc600078e0205ULL, 0x0000001f33007388ULL, 0x000fe80000000800ULL,
0x0000000335007388ULL, 0x000fe80000000800ULL, 0x0000000013007388ULL, 0x000fe80000000800ULL,
0x0004000f04007388ULL, 0x000fe80000000800ULL, 0x0004000c11007388ULL, 0x0003e80000000800ULL,
0x0004000e2b007388ULL, 0x000fe80000000800ULL, 0x000400102f007388ULL, 0x000fe20000000800ULL,
0x00000006060c723eULL, 0x002fc600000010ffULL, 0x0004001231007388ULL, 0x000fe80000000800ULL,
0x0004001433007388ULL, 0x000fe80000000800ULL, 0x0004000235007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000016187984ULL, 0x000e680000000c00ULL,
0x0004000016207984ULL, 0x000ea80000000c00ULL, 0x00080000161c7984ULL, 0x000ee80000000c00ULL,
0x000c000016247984ULL, 0x000ee20000000c00ULL, 0x3f803f800c1b7831ULL, 0x002fc4000020001bULL,
0x3f803f800c1a7831ULL, 0x040fe4000020001aULL, 0x3f803f800c197831ULL, 0x040fe40000200019ULL,
0x3f803f800c187831ULL, 0x040fe40000200018ULL, 0x3f803f800c237831ULL, 0x044fe40000200023ULL,
0x3f803f800c227831ULL, 0x040fe40000200022ULL, 0x3f803f800c217831ULL, 0x000fc40000200021ULL,
0x3f803f800c207831ULL, 0x000fe40000200020ULL, 0x3f803f801b1b7831ULL, 0x008fe4000020001fULL,
0x3f803f801a1a7831ULL, 0x000fe4000020001eULL, 0x3f803f8019197831ULL, 0x000fe4000020001dULL,
0x3f803f8018187831ULL, 0x000fe4000020001cULL, 0x3f803f8023237831ULL, 0x000fc40000200027ULL,
0x3f803f8022227831ULL, 0x000fe20000200026ULL, 0x0000001816007388ULL, 0x000fe20000000c00ULL,
0x3f803f8021217831ULL, 0x000fe40000200025ULL, 0x3f803f8020207831ULL, 0x000fca0000200024ULL,
0x0004002016007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff037819ULL, 0x000fc80000011608ULL, 0x000000720300720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x0000000103007824ULL, 0x100fe200078e0208ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005a0071717a19ULL, 0x000fe200000006ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000002008097810ULL, 0x000fe20007ffe0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000000700077812ULL, 0x000fe400078ec0ffULL, 0x0000000373007211ULL, 0x000fe200078e20ffULL,
0x0000580000067ab9ULL, 0x000fe20000000800ULL, 0x0ffffff807027812ULL, 0x000fc400078ef808ULL,
0x0000000500047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff037a19ULL, 0x000fe20000011600ULL,
0x0000001002027824ULL, 0x000fe200078e0205ULL, 0x0000000708077812ULL, 0x000fe200078ec0ffULL,
0x0000000171047824ULL, 0x000fc600078e0204ULL, 0x00000000020c7984ULL, 0x0004e20000000c00ULL,
0x0000007403037224ULL, 0x000fe200078e0204ULL, 0x00000006040472a4ULL, 0x002fe2000f8e023fULL,
0x000000086a077824ULL, 0x000fca00078e0207ULL, 0x0000000474007c24ULL, 0x000fca000f8e02ffULL,
0x0000000300037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x004fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fe400000f4404ULL,
0x00000003ff047819ULL, 0x000fc60000011609ULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x000000720400720cULL, 0x000fc80003f06070ULL, 0x0000000c02007986ULL, 0x0083f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000109027824ULL, 0x102fe200078e0204ULL,
0x00000040080b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001073047824ULL, 0x000fe200078e0204ULL,
0x0000000709077812ULL, 0x000fc400078ec0ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff037a19ULL, 0x000fe20000011604ULL, 0x000000086a077824ULL, 0x000fe200078e0207ULL,
0x0ffffff802027812ULL, 0x000fca00078ef809ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0x0000000504027c12ULL, 0x000fc8000f8e30ffULL, 0x00000000060c7984ULL, 0x000e620000000c00ULL,
0x0000000171027824ULL, 0x000fc800078e0202ULL, 0x0000007403037224ULL, 0x000fca00078e0202ULL,
0x0000000300037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fe400000f4404ULL,
0x00000003ff047819ULL, 0x000fc6000001160bULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x000000720400720cULL, 0x000fc80003f06070ULL, 0x0000000c02007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010b027824ULL, 0x102fe200078e0204ULL,
0x0000006008117810ULL, 0x000fe20007ffe0ffULL, 0x0000001073047824ULL, 0x000fe200078e0204ULL,
0x000000070b077812ULL, 0x000fc400078ec0ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff037a19ULL, 0x000fe20000011604ULL, 0x000000086a077824ULL, 0x000fe200078e0207ULL,
0x0ffffff802027812ULL, 0x000fca00078ef80bULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0x0000000504027c12ULL, 0x000fe4000f8e30ffULL, 0x00000003ff047819ULL, 0x000fe40000011611ULL,
0x00000000060c7984ULL, 0x0002a20000000c00ULL, 0x0000000271027210ULL, 0x000fca0007ffe0ffULL,
0x0000007403037224ULL, 0x000fe400078e0202ULL, 0x0000000111067824ULL, 0x002fc600078e0204ULL,
0x0000000300037210ULL, 0x000fe40007f1e0ffULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x040fe400078040ffULL,
0xfffffff806067812ULL, 0x000fe400078ef811ULL, 0x00005d0003037a11ULL, 0x000fe400000f4408ULL,
0x000000720400720cULL, 0x000fc60003f06070ULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e0205ULL, 0x0000000711057812ULL, 0x000fe200078ec0ffULL,
0x0000001073047824ULL, 0x000fc600078e0204ULL, 0x0000000006087984ULL, 0x000ea20000000c00ULL,
0x000000086a057824ULL, 0x000fe200078e0205ULL, 0x0000000504027c12ULL, 0x002fe4000f8e30ffULL,
0x00005a00ff037a19ULL, 0x000fc60000011604ULL, 0x0000000171027824ULL, 0x000fc800078e0202ULL,
0x0000007403037224ULL, 0x000fca00078e0202ULL, 0x0000000300037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4400ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x004fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0xffffffffff047424ULL, 0x002fc800078e00ffULL,
0x0000000202037824ULL, 0x000fca00078e0203ULL, 0x0000006d0300720cULL, 0x000fda0003f06070ULL,
0x0000000279088824ULL, 0x000fc800078e00ffULL, 0x0000680008088a24ULL, 0x000fc800078e0203ULL,
0x0000640008088625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000808048981ULL, 0x000ea2000c1e1900ULL, 0x00000001020b7810ULL, 0x000fe20007ffe0ffULL,
0x0000004000787824ULL, 0x000fe200078e00ffULL, 0x000000070e777819ULL, 0x000fe200000006ffULL,
0x0000008071677824ULL, 0x000fe200078e00ffULL, 0x0000005e0b00720cULL, 0x000fe20003f06070ULL,
0x00000100020e7824ULL, 0x000fe200078e0278ULL, 0x01b60000ff067f8cULL, 0x000e62000c80043fULL,
0x00000100ff107424ULL, 0x000fc600078e00ffULL, 0x00000040670a7812ULL, 0x000fe200078ef80eULL,
0x00000077040b7224ULL, 0x004fc800078e02ffULL, 0x000062000b087625ULL, 0x000fe400078e0010ULL,
0x00000c7000008947ULL, 0x000fea0003800000ULL, 0x0000000e680d7217ULL, 0x002fe40007800000ULL,
0x00000003ff1e7819ULL, 0x000fc60000011605ULL, 0x000000010d0d7824ULL, 0x000fe200078e0a0eULL,
0x000000041e107810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0e7824ULL, 0x000fe200078e021eULL,
0x000000081e127810ULL, 0x040fe20007ffe0ffULL, 0x000000011e1f7824ULL, 0x100fe200078e0205ULL,
0x0000000d1000720cULL, 0x040fe20003fa6070ULL, 0x00000001100b7824ULL, 0x100fe200078e0205ULL,
0x0000000c1e147810ULL, 0x000fe20007ffe0ffULL, 0x0000000810267824ULL, 0x000fe200078e00ffULL,
0x000000101e167810ULL, 0x000fe20007ffe0ffULL, 0x000000010a107824ULL, 0x000fe200078e0210ULL,
0x0000000514157210ULL, 0x000fe20007ffe0ffULL, 0x00000001120f7824ULL, 0x000fe200078e0205ULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000000d1400720cULL, 0x000fc40003f46070ULL, 0x000000141e227810ULL, 0x000fe20007ffe0ffULL,
0x00000008122e7824ULL, 0x000fe200078e00ffULL, 0x00000070100b7812ULL, 0x000fe200078ef80cULL,
0x0000000814307824ULL, 0x000fe200078e00ffULL, 0x000000181e2c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a147824ULL, 0x000fe200078e0214ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000b08107210ULL, 0x000fe40007f3e0ffULL,
0xfffffff830307812ULL, 0x000fe200078ee215ULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x000000700e137812ULL, 0x000fc400078ef80cULL, 0x0000001c1e387810ULL, 0x000fe20007ffe0ffULL,
0x0000000109117824ULL, 0x040fe200008e0611ULL, 0x0000000d1200720cULL, 0x000fe20003f26070ULL,
0x000000010a127824ULL, 0x000fe200078e0212ULL, 0x00000013080e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000116177824ULL, 0x000fe200078e0205ULL, 0x00000070141b7812ULL, 0x100fe200078ef80cULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000201e247810ULL, 0x000fe40007ffe0ffULL,
0x0000001b081a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000816327824ULL, 0x000fe200078e00ffULL,
0x0000007012197812ULL, 0x000fe200078ef80cULL, 0x00000001090f7824ULL, 0x040fe200000e060fULL,
0x0000000d1600720cULL, 0x000fe20003f06070ULL, 0x000000010a167824ULL, 0x000fe200078e0216ULL,
0xfffffff832327812ULL, 0x000fe200078ee217ULL, 0x000000010a1c7824ULL, 0x000fe200078e0222ULL,
0x0000001908187210ULL, 0x000fe20007f7e0ffULL, 0x000000010a207824ULL, 0x000fe200078e022cULL,
0x00000015091b7210ULL, 0x000fe200027fe4ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000241e287810ULL, 0x000fc40007ffe0ffULL, 0x000000281e2a7810ULL, 0x000fe20007ffe0ffULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x00000070160b7812ULL, 0x100fe400078ef80cULL,
0x000000052c277210ULL, 0x000fe20007ffe0ffULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x000000701c157812ULL, 0x000fc600078ef80cULL, 0x0000000109197824ULL, 0x040fe200018e0613ULL,
0x0000007020137812ULL, 0x000fe200078ef80cULL, 0x000000010a1c7824ULL, 0x000fe200078e0238ULL,
0x0000000b08167210ULL, 0x000fe20007f7e0ffULL, 0x0000000822347824ULL, 0x000fe200078e00ffULL,
0x0000001508147210ULL, 0x000fe20007f9e0ffULL, 0x000000010a257824ULL, 0x000fe200078e022aULL,
0x0000001308127210ULL, 0x000fe20007fde0ffULL, 0x0000000109177824ULL, 0x000fe200018e0617ULL,
0x000000071f207812ULL, 0x000fe200078ec0ffULL, 0x0000000109157824ULL, 0x040fe200020e061dULL,
0x0000000d2200720cULL, 0x080fe20003f66070ULL, 0x0000000109137824ULL, 0x000fe200030e0621ULL,
0x00001000000b7811ULL, 0x000fe200078e70ffULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000d1e00720cULL, 0x000fc60003f86070ULL, 0x0000000122217824ULL, 0x100fe200078e0205ULL,
0x0ffffff820227812ULL, 0x000fe200078ef805ULL, 0x000000010a207824ULL, 0x000fe200078e0224ULL,
0x000000701c1f7812ULL, 0x100fe200078ef80cULL, 0x000000082c367824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee221ULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x0000001f081c7210ULL, 0x000fe40007fde0ffULL, 0xfffffff836367812ULL, 0x000fe200078ee227ULL,
0x00000010221f7824ULL, 0x000fe200078e020bULL, 0x0000007020237812ULL, 0x000fe200078ef80cULL,
0x000000010a227824ULL, 0x000fc400078e0228ULL, 0x00000001091d7824ULL, 0x040fe200030e061dULL,
0x0000002308207210ULL, 0x000fe20007fde0ffULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e1f7faeULL, 0x0003e2000e101c48ULL,
0x0000000d2c00720cULL, 0x000fe40003f86070ULL, 0x0000000109217824ULL, 0x000fe200030e0621ULL,
0x0000002c1e2c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000838277824ULL, 0x000fe400078e00ffULL,
0x0000000824297824ULL, 0x000fc400078e00ffULL, 0x00000008282b7824ULL, 0x000fe400078e00ffULL,
0x00000100250e7825ULL, 0x002fe200078e00ffULL, 0x0000007022257812ULL, 0x000fc600078ef80cULL,
0x00000010261f7824ULL, 0x000fe200078e020bULL, 0x0000002508227210ULL, 0x000fe20007fde0ffULL,
0x0000000138267824ULL, 0x000fe200078e0205ULL, 0x000000700e257812ULL, 0x000fe400078ef80cULL,
0x00000000101f7faeULL, 0x0003e2000e901c48ULL, 0x0000000109237824ULL, 0x000fe200030e0623ULL,
0x00000025080e7210ULL, 0x000fe20007fde0ffULL, 0x000000102e257824ULL, 0x000fe200078e020bULL,
0x0000000d3800720cULL, 0x080fe40003fa6070ULL, 0xfffffff827387812ULL, 0x000fe200078ee226ULL,
0x00000001090f7824ULL, 0x000fe200030e060fULL, 0x0000000018257faeULL, 0x0005e2000c901c48ULL,
0x0000000d2400720cULL, 0x000fc40003f26070ULL, 0x0000000524267210ULL, 0x000fe20007ffe0ffULL,
0x00000010301f7824ULL, 0x002fe400078e020bULL, 0x000000010a107824ULL, 0x000fe200078e022cULL,
0xfffffff829267812ULL, 0x000fe200078ee226ULL, 0x0000000128247824ULL, 0x000fe200078e0205ULL,
0x000000001a1f7faeULL, 0x0003e2000d101c48ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000000d2800720cULL, 0x000fe40003f46070ULL, 0x000000301e187810ULL, 0x004fe20007ffe0ffULL,
0x0000001032197824ULL, 0x100fe200078e020bULL, 0xfffffff82b247812ULL, 0x000fe200078ee224ULL,
0x0000001038257824ULL, 0x000fe200078e020bULL, 0x0000007010277812ULL, 0x000fc400078ef80cULL,
0x0000000016197faeULL, 0x0005e2000c101c48ULL, 0x0000001024297824ULL, 0x100fe200078e020bULL,
0x000000341e247810ULL, 0x000fe20007ffe0ffULL, 0x00000010341b7824ULL, 0x102fe200078e020bULL,
0x0000002708107210ULL, 0x000fe20007fde0ffULL, 0x00000010361f7824ULL, 0x100fe200078e020bULL,
0x0000003c1e287810ULL, 0x000fe20007ffe0ffULL, 0x0000001026277824ULL, 0x000fe200078e020bULL,
0x00000000141b7faeULL, 0x0003e2000d901c48ULL, 0x0000000109117824ULL, 0x000fe200030e0611ULL,
0x000000381e267810ULL, 0x000fe20007ffe0ffULL, 0x000000010a167824ULL, 0x004fe200078e0218ULL,
0x00000000121f7faeULL, 0x0005e2000e101c48ULL, 0x000000082a177824ULL, 0x000fe200078e00ffULL,
0x0000000d1800720cULL, 0x000fc40003f66070ULL, 0x000000001c257faeULL, 0x0007e2000e901c48ULL,
0x0000000d2a00720cULL, 0x080fe20003fa6070ULL, 0x000000010a147824ULL, 0x002fe400078e0224ULL,
0x0000000020277faeULL, 0x0003e2000c901c48ULL, 0x0000000d2c00720cULL, 0x080fe20003f86070ULL,
0x00000001261b7824ULL, 0x040fe200078e0205ULL, 0x0000000d2600720cULL, 0x000fe20003f26070ULL,
0x0000010016127825ULL, 0x004fe200078e00ffULL, 0x000000052a167210ULL, 0x000fe20007ffe0ffULL,
0x0000000022297faeULL, 0x0005e2000d101c48ULL, 0x0000000d2400720cULL, 0x000fe20003f46070ULL,
0x000000082c1c7824ULL, 0x008fe200078e00ffULL, 0x0000007012157812ULL, 0x000fc400078ef80cULL,
0xfffffff8171a7812ULL, 0x000fe200078ee216ULL, 0x0000000818177824ULL, 0x000fe200078e00ffULL,
0x0000001508127210ULL, 0x000fe20007fde0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000000d2800720cULL, 0x000fc60003f06070ULL, 0x0000000109137824ULL, 0x000fe200030e0613ULL,
0x0000007014197812ULL, 0x000fe200078ef80cULL, 0x0000000118147824ULL, 0x100fe400078e0205ULL,
0x000000010a167824ULL, 0x000fe200078e0226ULL, 0x0000001908187210ULL, 0x000fe20007fde0ffULL,
0x000000012c0d7824ULL, 0x000fe200078e0205ULL, 0xfffffff8171e7812ULL, 0x000fe200078ee214ULL,
0x0000000826207824ULL, 0x002fe400078e00ffULL, 0x0000000109197824ULL, 0x000fe200030e0615ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL, 0x0000010016147825ULL, 0x000fe200078e00ffULL,
0x000000280a167210ULL, 0x000fc40007ffe0ffULL, 0xfffffff820207812ULL, 0x000fe200078ee21bULL,
0x00000001240d7824ULL, 0x000fe200078e0205ULL, 0x00000070141d7812ULL, 0x000fe200078ef80cULL,
0x0000010016167825ULL, 0x000fc600078e00ffULL, 0x0000001d08147210ULL, 0x000fe20007fde0ffULL,
0x0000000824247824ULL, 0x000fe200078e00ffULL, 0x00000070161d7812ULL, 0x000fe200078ef80cULL,
0x0000000128057824ULL, 0x040fe400078e0205ULL, 0x0000000828227824ULL, 0x004fe200078e00ffULL,
0xfffffff8240a7812ULL, 0x000fe200078ee20dULL, 0x0000000109157824ULL, 0x040fe200030e0615ULL,
0x0000001d08087210ULL, 0x000fe20007fde0ffULL, 0x000000101c0d7824ULL, 0x000fe200078e020bULL,
0xfffffff822227812ULL, 0x000fe200078ee205ULL, 0x000000101a057824ULL, 0x100fe200078e020bULL,
0x0000001709097210ULL, 0x000fe200037fe4ffULL, 0x000000101e1b7824ULL, 0x000fc400078e020bULL,
0x000000100a1d7824ULL, 0x100fe200078e020bULL, 0x000000000e057faeULL, 0x0003e2000e901c48ULL,
0x00000010201f7824ULL, 0x100fe400078e020bULL, 0x00000010220b7824ULL, 0x000fe200078e020bULL,
0x00000000100d7faeULL, 0x0003e8000e101c48ULL, 0x00000000121b7faeULL, 0x0003e8000d901c48ULL,
0x00000000181d7faeULL, 0x0003e8000d101c48ULL, 0x00000000141f7faeULL, 0x0003e8000c901c48ULL,
0x00000000080b7faeULL, 0x0003e2000c101c48ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x0000000c05187811ULL, 0x042fe400078fe8ffULL, 0x0000000805167811ULL, 0x000fc400078fe8ffULL,
0x0000001c051e7811ULL, 0x040fe200078fe8ffULL, 0x00000001180e7824ULL, 0x140fe200078e0205ULL,
0x0000000405147811ULL, 0x040fe200078fe8ffULL, 0x00000008180f7824ULL, 0x000fe200078e00ffULL,
0x00000014051c7811ULL, 0x040fe200078fe8ffULL, 0x00000001160d7824ULL, 0x140fe200078e0205ULL,
0x00000018051d7811ULL, 0x000fe200078fe8ffULL, 0x0000000816387824ULL, 0x000fe200078e00ffULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee20eULL, 0x000000011e0f7824ULL, 0x040fe200078e0205ULL,
0x00000010051a7811ULL, 0x000fe200078fe8ffULL, 0x000000081e427824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee20dULL, 0x00000001140b7824ULL, 0x040fe200078e0205ULL,
0x000000031d117819ULL, 0x000fe200000006ffULL, 0x0000000814367824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee20fULL, 0x000000011c0d7824ULL, 0x040fe200078e0205ULL,
0x00000024050f7811ULL, 0x000fe200078fe8ffULL, 0x000000081c3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee20bULL, 0x000000011d0e7824ULL, 0x100fe200078e0205ULL,
0x0000002c05137811ULL, 0x000fe200078fe8ffULL, 0x000000011a0b7824ULL, 0x000fe200078e0205ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL, 0x000000081a3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff811407812ULL, 0x000fe200078ee20eULL, 0x000000010f0e7824ULL, 0x100fe200078e0205ULL,
0x00000020050d7811ULL, 0x000fe200078fe8ffULL, 0x000000080f2f7824ULL, 0x000fe200078e00ffULL,
0x0000002805117811ULL, 0x000fe200078fe8ffULL, 0x0000000113127824ULL, 0x000fe200078e0205ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL, 0x000000010d0b7824ULL, 0x100fe200078e0205ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee20eULL, 0x000000080d207824ULL, 0x000fe200078e00ffULL,
0x00000005050e7211ULL, 0x000fe200078fe8ffULL, 0x0000000111107824ULL, 0x000fe200078e0205ULL,
0x0000003805197811ULL, 0x000fe200078fe8ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0xfffffff8202d7812ULL, 0x000fe200078ee20bULL, 0x0000000813177824ULL, 0x000fe200078e00ffULL,
0x000000070e267812ULL, 0x000fe200078ec0ffULL, 0x00000001140e7824ULL, 0x000fe200078e020aULL,
0xfffffff815207812ULL, 0x000fe200078ee210ULL, 0x000000011a147824ULL, 0x000fe200078e020aULL,
0xfffffff817227812ULL, 0x000fe200078ee212ULL, 0x000000011e1a7824ULL, 0x100fe200078e020aULL,
0x0000003005157811ULL, 0x040fe200078fe8ffULL, 0x000000010a1e7824ULL, 0x040fe200078e020fULL,
0x0000003405177811ULL, 0x040fe200078fe8ffULL, 0x000000010a327824ULL, 0x000fe200078e0211ULL,
0x0000003c051b7811ULL, 0x040fe200078fe8ffULL, 0x0000000118127824ULL, 0x100fe200078e020aULL,
0x0000000a050b7211ULL, 0x080fe200078fe8ffULL, 0x00000001170f7824ULL, 0x100fe200078e0205ULL,
0x0000000a16107210ULL, 0x000fe20007ffe0ffULL, 0x000000011c167824ULL, 0x000fe200078e020aULL,
0x0ffffff8262b7812ULL, 0x000fe200078ef805ULL, 0x000000010a1c7824ULL, 0x000fe200078e020dULL,
0x00000003152a7819ULL, 0x040fe200000006ffULL, 0x00000001150d7824ULL, 0x100fe200078e0205ULL,
0x00001000003d7811ULL, 0x000fe200078e70ffULL, 0x0000000119117824ULL, 0x000fc400078e0205ULL,
0x000000011d187824ULL, 0x000fe200078e020aULL, 0xfffffff82a267812ULL, 0x000fe200078ee20dULL,
0x000000010a347824ULL, 0x000fe200078e0213ULL, 0x0000003d38277211ULL, 0x000fe200078e20ffULL,
0x000000010a307824ULL, 0x040fe400078e0215ULL, 0x000000010a2c7824ULL, 0x040fe400078e0217ULL,
0x00000008172e7824ULL, 0x000fe400078e00ffULL, 0x000000010a287824ULL, 0x000fc400078e0219ULL,
0x000000010a247824ULL, 0x000fe200078e021bULL, 0xfffffff82e2a7812ULL, 0x000fe200078ee20fULL,
0x000000011b057824ULL, 0x040fe400078e0205ULL, 0x000000081b467824ULL, 0x000fe400078e00ffULL,
0x0000000819447824ULL, 0x000fe400078e00ffULL, 0x000001000b0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff846137812ULL, 0x000fe400078ee205ULL, 0xfffffff8442e7812ULL, 0x000fe200078ee211ULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000700a057812ULL, 0x000fc400078ef80cULL,
0x0000003d2e2e7211ULL, 0x000fe200078e20ffULL, 0x000000102b2b7824ULL, 0x100fe200078e023dULL,
0x00000005080a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001036297824ULL, 0x100fe200078e023dULL,
0x0000007010177812ULL, 0x000fe200078ef80cULL, 0x000000103a257824ULL, 0x100fe400078e023dULL,
0x000000103c237824ULL, 0x100fe400078e023dULL, 0x000000103e217824ULL, 0x100fe400078e023dULL,
0x00000010400d7824ULL, 0x000fc400078e023dULL, 0x0000001042057824ULL, 0x100fe400078e023dULL,
0x000000102d2d7824ULL, 0x100fe400078e023dULL, 0x000000102f2f7824ULL, 0x100fe400078e023dULL,
0x0000001020207824ULL, 0x100fe400078e023dULL, 0x0000001022227824ULL, 0x100fe400078e023dULL,
0x0000001026267824ULL, 0x000fc400078e023dULL, 0x000000102a2a7824ULL, 0x100fe400078e023dULL,
0x00000010133d7824ULL, 0x000fe400078e023dULL, 0x0000010012127825ULL, 0x000fc800078e00ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x00000070121b7812ULL, 0x000fc600078ef80cULL,
0x00000001090b7824ULL, 0x040fe200000e060bULL, 0x0000001708107210ULL, 0x000fe20007f1e0ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000700e157812ULL, 0x100fe400078ef80cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a2b7faeULL, 0x0003e2000b901c48ULL,
0x0000000109117824ULL, 0x000fe200000e0611ULL, 0x0000001b08127210ULL, 0x000fe20007f1e0ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x00000015080e7210ULL, 0x000fe40007f3e0ffULL,
0x00000070181b7812ULL, 0x100fe200078ef80cULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x00000070161d7812ULL, 0x000fc400078ef80cULL, 0x0000001b08187210ULL, 0x000fe20007f5e0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x00000070141f7812ULL, 0x000fc600078ef80cULL,
0x0000000109137824ULL, 0x040fe200000e0613ULL, 0x0000001d08167210ULL, 0x040fe20007f1e0ffULL,
0x00000001090f7824ULL, 0x000fe200008e060fULL, 0x0000001f08147210ULL, 0x000fe20007f3e0ffULL,
0x000001001e1e7825ULL, 0x000fe200078e00ffULL, 0x000000701a317812ULL, 0x000fe400078ef80cULL,
0x000000000e297faeULL, 0x0003e2000b901c48ULL, 0x000001001c1c7825ULL, 0x000fc600078e00ffULL,
0x0000000010277faeULL, 0x0003e2000b901c48ULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0x000000701c377812ULL, 0x100fe400078ef80cULL, 0x0000000012257faeULL, 0x0003e2000b901c48ULL,
0x0000000109177824ULL, 0x040fe200000e0617ULL, 0x00000031081a7210ULL, 0x000fe20007f1e0ffULL,
0x0000010034347825ULL, 0x000fe200078e00ffULL, 0x000000701e317812ULL, 0x100fe400078ef80cULL,
0x00000070323b7812ULL, 0x100fe200078ef80cULL, 0x00000001091b7824ULL, 0x040fe200000e061bULL,
0x00000031081e7210ULL, 0x040fe20007f1e0ffULL, 0x0000000109157824ULL, 0x040fe200008e0615ULL,
0x00000037081c7210ULL, 0x040fe20007f3e0ffULL, 0x0000000109197824ULL, 0x040fe200010e0619ULL,
0x0000003b083a7210ULL, 0x000fe20007f5e0ffULL, 0x00000001091f7824ULL, 0x040fe200000e061fULL,
0x0000007034377812ULL, 0x100fe200078ef80cULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x00000033093b7210ULL, 0x040fe200017fe4ffULL, 0x0000000014237faeULL, 0x0003e2000b901c48ULL,
0x0000003708347210ULL, 0x000fe20007f1e0ffULL, 0x000001002c327825ULL, 0x000fe200078e00ffULL,
0x0000007030457812ULL, 0x100fe200078ef80cULL, 0x0000000016217faeULL, 0x0003e4000b901c48ULL,
0x0000010028367825ULL, 0x000fe200078e00ffULL, 0x0000007032437812ULL, 0x100fe200078ef80cULL,
0x00000000180d7faeULL, 0x0003e4000b901c48ULL, 0x0000010024387825ULL, 0x000fe200078e00ffULL,
0x0000007036417812ULL, 0x100fe200078ef80cULL, 0x000000001a057faeULL, 0x0003e4000b901c48ULL,
0x0000000109357824ULL, 0x040fe200000e0635ULL, 0x00000070383f7812ULL, 0x000fe200078ef80cULL,
0x00000001091d7824ULL, 0x000fe200008e061dULL, 0x0000004508307210ULL, 0x000fc40007f1e0ffULL,
0x0000004308327210ULL, 0x040fe40007f3e0ffULL, 0x0000004108367210ULL, 0x040fe20007f5e0ffULL,
0x0000000109317824ULL, 0x040fe200000e0631ULL, 0x0000003f08087210ULL, 0x000fe20007f7e0ffULL,
0x0000000109337824ULL, 0x040fe200008e0633ULL, 0x000000001c2d7faeULL, 0x0003e2000b901c48ULL,
0x0000000109377824ULL, 0x040fe400010e0637ULL, 0x0000000109097824ULL, 0x000fe200018e0639ULL,
0x000000001e2f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a207faeULL, 0x0003e8000b901c48ULL,
0x0000000034227faeULL, 0x0003e8000b901c48ULL, 0x0000000030267faeULL, 0x0003e8000b901c48ULL,
0x00000000322a7faeULL, 0x0003e8000b901c48ULL, 0x00000000362e7faeULL, 0x0003e8000b901c48ULL,
0x00000000083d7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01b60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000005e0200720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x00005800ff697624ULL, 0x000fe200078e00ffULL, 0x80005800686c7a10ULL, 0x000fe20007ffe0ffULL,
0x0000680079797a24ULL, 0x000fe200078e02ffULL, 0x0001b68800737811ULL, 0x040fe200078e18ffULL,
0x0000002000747824ULL, 0x000fe200078e00ffULL, 0x0000001f69067810ULL, 0x040fe40007ffe0ffULL,
0xffffffff69727810ULL, 0x000fe40007ffe0ffULL, 0x00000004ff067819ULL, 0x000fc40000011606ULL,
0x0000000969697810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff6c7819ULL, 0x000fe4000001166cULL,
0x0ffffffe066a7812ULL, 0x000fc400078ec0ffULL, 0x0000000102077810ULL, 0x040fe20007ffe0ffULL,
0x0000010002067824ULL, 0x004fe200078e0278ULL, 0x00000100006e7802ULL, 0x000fe20000000f00ULL,
0x00000004770b7224ULL, 0x000fe200078e02ffULL, 0x0000005e0700720cULL, 0x000fe20003f06070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000004006047812ULL, 0x000fe200078ec0ffULL,
0x000062000b0a7625ULL, 0x000fc800078e006eULL, 0x0000000167047824ULL, 0x000fcc00078e0204ULL,
0x00000bb000008947ULL, 0x008fea0003800000ULL, 0x00000003ff1a7819ULL, 0x102fe20000011605ULL,
0x0000001005077824ULL, 0x000fe200078e00ffULL, 0x00000006681b7217ULL, 0x000fe40007800000ULL,
0x000000041a107810ULL, 0x040fe20007ffe0ffULL, 0x000000011a1f7824ULL, 0x140fe200078e0205ULL,
0x000000081a127810ULL, 0x000fe20007ffe0ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0a06ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x0000000110087824ULL, 0x100fe200078e0205ULL,
0x0000000c1a147810ULL, 0x000fe20007ffe0ffULL, 0x00000008100d7824ULL, 0x000fe200078e00ffULL,
0x00000080070c7812ULL, 0x000fe200078efcffULL, 0x0000000112097824ULL, 0x100fe200078e0205ULL,
0x000000101a167810ULL, 0x000fe20007ffe0ffULL, 0x0000000812227824ULL, 0x000fe200078e00ffULL,
0xfffffff80d1e7812ULL, 0x000fe200078ee208ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000000316267819ULL, 0x000fe200000006ffULL, 0x00000001140f7824ULL, 0x000fe200078e0205ULL,
0xfffffff822227812ULL, 0x000fe200078ee209ULL, 0x000000011a097824ULL, 0x040fe200078e0204ULL,
0x000000141a1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000814247824ULL, 0x000fe200078e00ffULL,
0x0000001b1000720cULL, 0x080fe20003f86070ULL, 0x0000010009087825ULL, 0x000fe200078e000cULL,
0x0000001b1200720cULL, 0x000fc40003f46070ULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x0000000116117824ULL, 0x000fe200078e0205ULL, 0x000000080a0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000114137824ULL, 0x140fe200078e0204ULL, 0x0000001b1400720cULL, 0x080fe20003f66070ULL,
0x0000000116157824ULL, 0x100fe200078e0204ULL, 0xfffffff826267812ULL, 0x000fe200078ee211ULL,
0x000000010b0f7824ULL, 0x000fe200000e0609ULL, 0x0000001b1600720cULL, 0x000fe20003f06070ULL,
0x0000000110097824ULL, 0x100fe200078e0204ULL, 0x000000181a2a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112117824ULL, 0x000fe200078e0204ULL, 0x0000001c1a2c7810ULL, 0x040fe20007ffe0ffULL,
0x0000010009087825ULL, 0x000fe200078e000cULL, 0x000000201a2e7810ULL, 0x000fc40007ffe0ffULL,
0x000000052c297210ULL, 0x000fe20007ffe0ffULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0x000000080a207210ULL, 0x000fc60007f3e0ffULL, 0x000000011c177824ULL, 0x000fe200078e0204ULL,
0x000000100a167210ULL, 0x000fe20007fbe0ffULL, 0x000000010b217824ULL, 0x000fe400008e0609ULL,
0x0000010013127825ULL, 0x000fc800078e000cULL, 0x0000010015087825ULL, 0x000fe200078e000cULL,
0x000000120a187210ULL, 0x000fc60007f3e0ffULL, 0x0000010017147825ULL, 0x000fc800078e000cULL,
0x000000010b177824ULL, 0x040fe200028e0611ULL, 0x000000080a107210ULL, 0x000fe20007fbe0ffULL,
0x000000012a1d7824ULL, 0x000fe200078e0204ULL, 0x000000140a127210ULL, 0x000fe20007fde0ffULL,
0x000000010b197824ULL, 0x040fe200008e0613ULL, 0x000000090b117210ULL, 0x000fe20002ffe4ffULL,
0x000000081c287824ULL, 0x000fe200078e00ffULL, 0x0ffffff805087812ULL, 0x000fe200078ec0ffULL,
0x000000010b137824ULL, 0x000fe200030e0615ULL, 0x0000001b1a00720cULL, 0x080fe20003fa6070ULL,
0x000001001d147825ULL, 0x000fe200078e000cULL, 0x0000001b1c00720cULL, 0x000fc40003f26070ULL,
0x0000300000097811ULL, 0x000fe200078e70ffULL, 0x000000011c1d7824ULL, 0x000fe200078e0205ULL,
0x00000007081c7812ULL, 0x000fe200078ef81fULL, 0x000000012e1f7824ULL, 0x100fe200078e0204ULL,
0x000000140a147210ULL, 0x000fe20007fde0ffULL, 0x000000101e257824ULL, 0x000fe200078e0209ULL,
0xfffffff828287812ULL, 0x000fe200078ee21dULL, 0x000000101c237824ULL, 0x000fe400078e0209ULL,
0x000000012c1d7824ULL, 0x000fe400078e0204ULL, 0x000000012a277824ULL, 0x040fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e237faeULL, 0x0003e2000e901c48ULL,
0x000001001d1c7825ULL, 0x000fe200078e000cULL, 0x0000001b2a00720cULL, 0x000fc40003fa6070ULL,
0x0000000020257faeULL, 0x0005e2000e101c48ULL, 0x000000010b157824ULL, 0x000fe200030e0615ULL,
0x0000001b2c00720cULL, 0x000fe20003f86070ULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0x0000001c0a1c7210ULL, 0x000fe20007fde0ffULL, 0x000000082c2c7824ULL, 0x000fe400078e00ffULL,
0x000001001f1e7825ULL, 0x000fc800078e000cULL, 0x0000001024237824ULL, 0x002fe200078e0209ULL,
0xfffffff82a207812ULL, 0x004fe200078ee227ULL, 0x0000001022217824ULL, 0x000fe200078e0209ULL,
0xfffffff82c2a7812ULL, 0x000fe200078ee229ULL, 0x000000012e227824ULL, 0x000fe200078e0205ULL,
0x000000241a2c7810ULL, 0x000fe20007ffe0ffULL, 0x000000082e257824ULL, 0x000fe200078e00ffULL,
0x0000000016217faeULL, 0x0003e2000d101c48ULL, 0x000000010b1d7824ULL, 0x000fe200030e061dULL,
0x0000001e0a0e7210ULL, 0x000fe20007fde0ffULL, 0x000000012c247824ULL, 0x000fe200078e0205ULL,
0x0000000018237faeULL, 0x0005e2000d901c48ULL, 0x0000001b2e00720cULL, 0x080fe20003f66070ULL,
0x000000082c277824ULL, 0x040fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fe200078ee222ULL,
0x000000010b0f7824ULL, 0x000fe200030e061fULL, 0x0000001b2c00720cULL, 0x040fe20003f46070ULL,
0x000000012c1f7824ULL, 0x000fe200078e0204ULL, 0xfffffff827247812ULL, 0x000fe200078ee224ULL,
0x0000001026177824ULL, 0x102fe200078e0209ULL, 0x000000281a167810ULL, 0x000fe20007ffe0ffULL,
0x0000001020217824ULL, 0x100fe200078e0209ULL, 0x0000002c1a207810ULL, 0x000fe20007ffe0ffULL,
0x0000001028197824ULL, 0x104fe200078e0209ULL, 0x0000000010177faeULL, 0x0003e2000c101c48ULL,
0x000000102a237824ULL, 0x100fe200078e0209ULL, 0x000000341a267810ULL, 0x000fe20007ffe0ffULL,
0x0000001022257824ULL, 0x000fe200078e0209ULL, 0x0000000012197faeULL, 0x0005e2000c901c48ULL,
0x000001001f1e7825ULL, 0x000fe200078e000cULL, 0x000000301a227810ULL, 0x000fc40007ffe0ffULL,
0x0000000014217faeULL, 0x0007e2000e901c48ULL, 0x000000381a287810ULL, 0x000fe40007ffe0ffULL,
0x0000001e0a1e7210ULL, 0x000fe20007fde0ffULL, 0x000000001c237faeULL, 0x0009e2000e101c48ULL,
0x0000000120117824ULL, 0x002fe200078e0204ULL, 0x0000003c1a2a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000820177824ULL, 0x000fe200078e00ffULL, 0x000000000e257faeULL, 0x0003e2000d901c48ULL,
0x0000001f0b1f7210ULL, 0x000fe200037fe4ffULL, 0x0000001024137824ULL, 0x004fe200078e0209ULL,
0x0000001b1600720cULL, 0x080fe20003fc6070ULL, 0x0000000122147824ULL, 0x148fe200078e0205ULL,
0x0000000422157210ULL, 0x040fe20007ffe0ffULL, 0x0000000822197824ULL, 0x000fe200078e00ffULL,
0x000000001e137faeULL, 0x0005e2000d101c48ULL, 0x0000000120127824ULL, 0x040fe200078e0205ULL,
0x0000001b2000720cULL, 0x000fe20003fa6070ULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0xfffffff8191c7812ULL, 0x010fc400078ee214ULL, 0xfffffff8171a7812ULL, 0x000fe200078ee212ULL,
0x00000001160e7824ULL, 0x002fe200078e0205ULL, 0x0000001b2200720cULL, 0x080fe20003f86070ULL,
0x00000008160f7824ULL, 0x000fe200078e00ffULL, 0x0000001b2600720cULL, 0x0c0fe20003f66070ULL,
0x0000000826197824ULL, 0x000fe200078e00ffULL, 0x0000001b2800720cULL, 0x080fe20003f26070ULL,
0x0000010015127825ULL, 0x004fe200078e000cULL, 0xfffffff80f187812ULL, 0x000fe400078ee20eULL,
0x0000001b2a00720cULL, 0x000fe20003f06070ULL, 0x00000001160f7824ULL, 0x100fe200078e0204ULL,
0x00000003281d7819ULL, 0x000fe200000006ffULL, 0x0000000126177824ULL, 0x000fc400078e0204ULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000012a1b7824ULL, 0x000fe200078e0204ULL,
0x0000000e0a0e7210ULL, 0x000fe20007f5e0ffULL, 0x000000082a207824ULL, 0x000fc800078e00ffULL,
0x000000010b0f7824ULL, 0x000fe200010e060fULL, 0x000000100a147210ULL, 0x000fe20007f5e0ffULL,
0x0000000126107824ULL, 0x000fc800078e0205ULL, 0x000000010b157824ULL, 0x000fe200010e0611ULL,
0x000000120a167210ULL, 0x000fe40007f5e0ffULL, 0xfffffff8191e7812ULL, 0x000fe200078ee210ULL,
0x0000010017107825ULL, 0x000fc800078e000cULL, 0x0000000128197824ULL, 0x000fe400078e0204ULL,
0x000000010b177824ULL, 0x000fe200010e0613ULL, 0x000000100a107210ULL, 0x000fe20007f5e0ffULL,
0x0000010019127825ULL, 0x000fc800078e000cULL, 0x000000010b117824ULL, 0x000fe200010e0611ULL,
0x000000120a127210ULL, 0x000fe20007f5e0ffULL, 0x0000000128047824ULL, 0x100fe400078e0205ULL,
0x000000012a197824ULL, 0x000fe400078e0205ULL, 0x000001001b0c7825ULL, 0x000fe200078e000cULL,
0xfffffff81d047812ULL, 0x000fe400078ee204ULL, 0xfffffff820207812ULL, 0x000fe200078ee219ULL,
0x000000010b137824ULL, 0x000fe200010e0613ULL, 0x0000000c0a0a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001018197824ULL, 0x000fc400078e0209ULL, 0x000000101a1b7824ULL, 0x100fe400078e0209ULL,
0x000000101c1d7824ULL, 0x100fe200078e0209ULL, 0x000000000e197faeULL, 0x0003e2000f101c48ULL,
0x000000101e1f7824ULL, 0x100fe400078e0209ULL, 0x0000001004217824ULL, 0x100fe200078e0209ULL,
0x00000000141b7faeULL, 0x0003e2000e901c48ULL, 0x0000001020097824ULL, 0x000fe400078e0209ULL,
0x000000010b0b7824ULL, 0x000fe200010e060dULL, 0x00000000161d7faeULL, 0x0003e8000e101c48ULL,
0x00000000101f7faeULL, 0x0003e8000d901c48ULL, 0x0000000012217faeULL, 0x0003e8000c901c48ULL,
0x000000000a097faeULL, 0x0003e2000c101c48ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x00000004051b7811ULL, 0x042fe400078fe8ffULL, 0x0000000c051f7811ULL, 0x000fc400078fe8ffULL,
0x000000051b077210ULL, 0x0c0fe20007ffe0ffULL, 0x000000081b0c7824ULL, 0x000fe200078e00ffULL,
0x0000001805257811ULL, 0x000fe200078fe8ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0204ULL,
0x00000008051d7811ULL, 0x000fe400078fe8ffULL, 0xfffffff80c2d7812ULL, 0x000fe200078ee207ULL,
0x000000011f077824ULL, 0x100fe200078e0205ULL, 0x00000024052b7811ULL, 0x000fe200078fe8ffULL,
0x000000081f0c7824ULL, 0x000fe200078e00ffULL, 0x0000001405237811ULL, 0x000fe200078fe8ffULL,
0x000000011d087824ULL, 0x000fe200078e0205ULL, 0x0000001005217811ULL, 0x000fe200078fe8ffULL,
0x000000081d2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c317812ULL, 0x000fe200078ee207ULL,
0x0000000125077824ULL, 0x100fe200078e0205ULL, 0x00000030050d7811ULL, 0x000fe200078fe8ffULL,
0x00000008250c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee208ULL,
0x0000000123097824ULL, 0x000fe200078e0205ULL, 0x0000001c05277811ULL, 0x000fe200078fe8ffULL,
0x00000008230e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c377812ULL, 0x000fe200078ee207ULL,
0x000000012b077824ULL, 0x100fe200078e0205ULL, 0x0000002005297811ULL, 0x000fe200078fe8ffULL,
0x000000082b0c7824ULL, 0x000fe200078e00ffULL, 0x0000003c053f7811ULL, 0x000fe200078fe8ffULL,
0x0000000121087824ULL, 0x040fe200078e0205ULL, 0xfffffff80e357812ULL, 0x000fe200078ee209ULL,
0x0000000821337824ULL, 0x000fe200078e00ffULL, 0xfffffff80c3b7812ULL, 0x000fe200078ee207ULL,
0x000000010d077824ULL, 0x100fe200078e0205ULL, 0x0000002805157811ULL, 0x000fe200078fe8ffULL,
0x000000080d0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee208ULL,
0x0000000827397824ULL, 0x040fe200078e00ffULL, 0x0000000527087210ULL, 0x080fe20007ffe0ffULL,
0x0000000129097824ULL, 0x000fe200078e0205ULL, 0x0000002c05137811ULL, 0x000fe200078fe8ffULL,
0x00000008290e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c437812ULL, 0x000fe200078ee207ULL,
0x000000013f0c7824ULL, 0x000fe200078e0205ULL, 0xfffffff839397812ULL, 0x000fe200078ee208ULL,
0x000000083f497824ULL, 0x000fe200078e00ffULL, 0xfffffff80e177812ULL, 0x000fe200078ee209ULL,
0x0000001005077824ULL, 0x040fe200078e00ffULL, 0x00000034050f7811ULL, 0x000fe200078fe8ffULL,
0x0000000115087824ULL, 0x100fe200078e0205ULL, 0x0000003805117811ULL, 0x000fe200078fe8ffULL,
0x00000008153d7824ULL, 0x000fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee20cULL,
0x0000000113097824ULL, 0x040fe200078e0205ULL, 0x00003000000c7811ULL, 0x000fe200078e70ffULL,
0x00000008130e7824ULL, 0x000fe200078e00ffULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x000000080f457824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee208ULL,
0x000000011d1d7824ULL, 0x100fe200078e0204ULL, 0xfffffff80e417812ULL, 0x000fe200078ee209ULL,
0x0000000111097824ULL, 0x000fe200078e0205ULL, 0x000000050f087210ULL, 0x080fe20007ffe0ffULL,
0x00000008110e7824ULL, 0x000fe200078e00ffULL, 0x0000000425257210ULL, 0x080fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x100fe200078e0204ULL, 0x0000000405197211ULL, 0x000fe200078fe8ffULL,
0x0000000121217824ULL, 0x100fe200078e0204ULL, 0x0000008007167812ULL, 0x000fe200078efcffULL,
0x0000000123237824ULL, 0x000fe200078e0204ULL, 0xfffffff845457812ULL, 0x000fe200078ee208ULL,
0x0000000127277824ULL, 0x100fe200078e0204ULL, 0xfffffff80e477812ULL, 0x000fe200078ee209ULL,
0x0000000129297824ULL, 0x100fe200078e0204ULL, 0x0000000505097211ULL, 0x000fe200078fe8ffULL,
0x000000012b2b7824ULL, 0x100fe200078e0204ULL, 0x0ffffff805087812ULL, 0x000fe200078ec0ffULL,
0x0000000115157824ULL, 0x100fe200078e0204ULL, 0x0000000c2f2f7211ULL, 0x000fe200078e20ffULL,
0x0000000113137824ULL, 0x100fe200078e0204ULL, 0x0000000708097812ULL, 0x000fe200078ef809ULL,
0x000000010d0d7824ULL, 0x000fc400078e0204ULL, 0x000000010f0f7824ULL, 0x100fe400078e0204ULL,
0x0000000111117824ULL, 0x100fe400078e0204ULL, 0x000000013f3f7824ULL, 0x000fe400078e0204ULL,
0x0000001017047824ULL, 0x100fe400078e020cULL, 0x000000ffff177224ULL, 0x000fe400078e00ffULL,
0x0000001009097824ULL, 0x000fc400078e020cULL, 0x0000010019187825ULL, 0x000fc800078e0016ULL,
0x000001001b1a7825ULL, 0x000fe200078e0016ULL, 0x000000180a187210ULL, 0x000fc60007f1e0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0016ULL, 0x0000001a0a1a7210ULL, 0x000fc60007f3e0ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0016ULL, 0x0000001c0a1c7210ULL, 0x000fc60007f5e0ffULL,
0x0000010021207825ULL, 0x000fe200078e0016ULL, 0x0000001e0a1e7210ULL, 0x000fc60007f7e0ffULL,
0x0000010023227825ULL, 0x000fc800078e0016ULL, 0x0000010025247825ULL, 0x000fc800078e0016ULL,
0x0000010027267825ULL, 0x000fc800078e0016ULL, 0x000000010b197824ULL, 0x000fe200000e0619ULL,
0x000000200a207210ULL, 0x000fe20007f1e0ffULL, 0x0000010029287825ULL, 0x000fc600078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018097faeULL, 0x0003e2000b901c48ULL,
0x000000010b1b7824ULL, 0x040fe200008e061bULL, 0x000000220a227210ULL, 0x040fe20007f3e0ffULL,
0x000000010b1d7824ULL, 0x040fe200010e061dULL, 0x000000240a247210ULL, 0x040fe20007f5e0ffULL,
0x000000010b1f7824ULL, 0x000fe200018e061fULL, 0x000000260a267210ULL, 0x000fe20007f7e0ffULL,
0x000001002b2a7825ULL, 0x000fc800078e0016ULL, 0x0000010015147825ULL, 0x000fc800078e0016ULL,
0x0000010013127825ULL, 0x000fc800078e0016ULL, 0x000000103b2c7824ULL, 0x100fe400078e020cULL,
0x000000103d2e7824ULL, 0x100fe200078e020cULL, 0x0000000c473d7211ULL, 0x000fe200078e20ffULL,
0x0000001041307824ULL, 0x100fe400078e020cULL, 0x000000010b217824ULL, 0x000fe200000e0621ULL,
0x000000280a287210ULL, 0x000fe20007f1e0ffULL, 0x000000102d2d7824ULL, 0x100fe400078e020cULL,
0x0000001031317824ULL, 0x000fc400078e020cULL, 0x0000001033337824ULL, 0x100fe200078e020cULL,
0x000000001a2d7faeULL, 0x0003e2000b901c48ULL, 0x0000001035357824ULL, 0x100fe400078e020cULL,
0x0000001037377824ULL, 0x100fe200078e020cULL, 0x000000001c2f7faeULL, 0x0003e2000b901c48ULL,
0x0000001039397824ULL, 0x100fe400078e020cULL, 0x0000001043327824ULL, 0x100fe200078e020cULL,
0x000000001e317faeULL, 0x0003e2000b901c48ULL, 0x00000010453b7824ULL, 0x000fc400078e020cULL,
0x0000001049417824ULL, 0x000fe200078e020cULL, 0x0000000020337faeULL, 0x0003e2000b901c48ULL,
0x000001000d0c7825ULL, 0x000fc800078e0016ULL, 0x000000010b237824ULL, 0x040fe200008e0623ULL,
0x0000002a0a2a7210ULL, 0x040fe20007f3e0ffULL, 0x000000010b257824ULL, 0x000fe200010e0625ULL,
0x000000140a147210ULL, 0x040fe20007f5e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0016ULL,
0x0000002b0b2b7210ULL, 0x040fe20000ffe4ffULL, 0x0000000022357faeULL, 0x0003e4000b901c48ULL,
0x000000010b277824ULL, 0x000fe200018e0627ULL, 0x000000120a127210ULL, 0x040fe20007f7e0ffULL,
0x0000010011107825ULL, 0x100fe200078e0016ULL, 0x0000000e0a0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000024377faeULL, 0x0003e4000b901c48ULL, 0x000001003f167825ULL, 0x000fc400078e0016ULL,
0x0000000026397faeULL, 0x0003e4000b901c48ULL, 0x000000010b297824ULL, 0x040fe200000e0629ULL,
0x0000000c0a0c7210ULL, 0x040fe20007f1e0ffULL, 0x000000010b157824ULL, 0x040fe200010e0615ULL,
0x000000100a107210ULL, 0x040fe20007f5e0ffULL, 0x000000010b137824ULL, 0x040fe200018e0613ULL,
0x000000160a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b0d7824ULL, 0x040fe200000e060dULL,
0x0000000028047faeULL, 0x0003e2000b901c48ULL, 0x000000010b0f7824ULL, 0x000fc400008e060fULL,
0x000000010b117824ULL, 0x040fe200010e0611ULL, 0x000000002a2c7faeULL, 0x0003e2000b901c48ULL,
0x000000010b0b7824ULL, 0x000fc600018e0617ULL, 0x00000000142e7faeULL, 0x0003e8000b901c48ULL,
0x0000000012307faeULL, 0x0003e8000b901c48ULL, 0x000000000c327faeULL, 0x0003e8000b901c48ULL,
0x000000000e3b7faeULL, 0x0003e8000b901c48ULL, 0x00000000103d7faeULL, 0x0003e8000b901c48ULL,
0x000000000a417faeULL, 0x0003e4000b901c48ULL, 0x0000000203037810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff047424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000006d0300720cULL, 0x000fda0003f06070ULL, 0x00000002790c8824ULL, 0x000fe400078e0203ULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000064000c0c8625ULL, 0x000fe200078e000dULL,
0x0000000705107812ULL, 0x000fe400078ec0ffULL, 0x00000004ff0e7819ULL, 0x000fe20000011605ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000080c048981ULL, 0x000322000c1e1900ULL,
0x0000000810097812ULL, 0x000fe200078ef805ULL, 0xffffffff00007948ULL, 0x000fe80003800000ULL,
0x000000010e0a7824ULL, 0x000fe400078e0209ULL, 0x00000010090b7824ULL, 0x000fca00078e00ffULL,
0xfffffff00b0b7812ULL, 0x000fc800078ee20aULL, 0x000000040b2c7819ULL, 0x000fc600000006ffULL,
0x000000080e397824ULL, 0x002fe200078e00ffULL, 0x00000003ff647819ULL, 0x000fe20000011605ULL,
0x00004000000b7824ULL, 0x000fe200078e00ffULL, 0x000000002c2c783bULL, 0x000fe20000000200ULL,
0x0000001009127824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe400078ee210ULL,
0x0000000164107812ULL, 0x000fe400078ec0ffULL, 0x000010000b0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008390d7824ULL, 0x040fe200078e00ffULL, 0x0000001039387810ULL, 0x000fe20007ffe0ffULL,
0x00000001100e7824ULL, 0x000fc400078e0239ULL, 0x00000008390f7824ULL, 0x000fe400078e00ffULL,
0x00000001105f7824ULL, 0x000fe200078e0238ULL, 0xfffffff80d5c7812ULL, 0x000fe200078ee20eULL,
0x0000000838147824ULL, 0x000fe200078e00ffULL, 0x000000020a0d7810ULL, 0x000fe40007ffe0ffULL,
0x000000020e627810ULL, 0x000fe20007ffe0ffULL, 0x000000105c1c7824ULL, 0x000fe200078e020cULL,
0xfffffff0120d7812ULL, 0x000fe200078ee20dULL, 0x0000000838127824ULL, 0x000fe200078e00ffULL,
0xfffffff80f627812ULL, 0x000fc400078ee262ULL, 0x00000020390f7810ULL, 0x000fe20007ffe0ffULL,
0x000000100d287824ULL, 0x000fe200078e00ffULL, 0x00000030390d7810ULL, 0x000fe20007ffe0ffULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0xfffffff8125f7812ULL, 0x000fe200078ee25fULL,
0x00000001105b7824ULL, 0x000fe200078e020fULL, 0x000000120e637810ULL, 0x000fe20007ffe0ffULL,
0x0000000110607824ULL, 0x000fe200078e020dULL, 0x0000000c5f347211ULL, 0x000fe200078e20ffULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0x000000002828783bULL, 0x000fe20000000200ULL,
0x000000080f107824ULL, 0x000fe200078e00ffULL, 0x000000220e667810ULL, 0x000fe20007ffe0ffULL,
0x0000001062507824ULL, 0x000fe200078e020cULL, 0xfffffff811607812ULL, 0x000fe200078ee260ULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0xfffffff8105b7812ULL, 0x000fe200078ee25bULL,
0x000000080f157824ULL, 0x000fe200078e00ffULL, 0xfffffff814637812ULL, 0x000fe200078ee263ULL,
0x0000001060307824ULL, 0x100fe200078e020cULL, 0x000000005050783bULL, 0x000fe20000000200ULL,
0x000000105b107824ULL, 0x000fe200078e020cULL, 0xfffffff815667812ULL, 0x000fe200078ee266ULL,
0x0000001063187824ULL, 0x100fe200078e020cULL, 0x000000320e657810ULL, 0x040fe20007ffe0ffULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0x000000040e617810ULL, 0x000fe20007ffe0ffULL,
0x0000001066207824ULL, 0x000fe200078e020cULL, 0x000000140e5d7810ULL, 0x040fe20007ffe0ffULL,
0x000000001010783bULL, 0x000ee20000000200ULL, 0x000000240e5a7810ULL, 0x040fe20007ffe0ffULL,
0x000000080d3a7824ULL, 0x000fe200078e00ffULL, 0x000000340e597810ULL, 0x040fe20007ffe0ffULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x000000060e587810ULL, 0x000fc40007ffe0ffULL,
0xfffffff83a597812ULL, 0x000fe200078ee259ULL, 0x000000002020783bULL, 0x000ee60000000200ULL,
0x0000000c59447211ULL, 0x000fe200078e20ffULL, 0x0000001c2c54723cULL, 0x042f6a00000418ffULL,
0x000000004444783bULL, 0x000fe60000000200ULL, 0x0000001e2c1c723cULL, 0x040f7000000418ffULL,
0x000000342c14723cULL, 0x044f7000000418ffULL, 0x000000302c24723cULL, 0x008bee00000418ffULL,
0x000000080d307824ULL, 0x020fe200078e00ffULL, 0x000000502854723cULL, 0x000fe80000041854ULL,
0xfffffff830657812ULL, 0x000fc800078ee265ULL, 0x000000522850723cULL, 0x000fe2000004181cULL,
0x0000000c65307211ULL, 0x000fce00078e20ffULL, 0x000000362c34723cULL, 0x040f7000000418ffULL,
0x000000102c1c723cULL, 0x040f7000000418ffULL, 0x000000122c10723cULL, 0x040f7000000418ffULL,
0x000000322c2c723cULL, 0x000b6400000418ffULL, 0x000000003030783bULL, 0x020e6c0000000200ULL,
0x000000182814723cULL, 0x040f700000041814ULL, 0x0000001a2818723cULL, 0x040b6e0000041834ULL,
0x0000000838367824ULL, 0x020fe200078e00ffULL, 0x00000020281c723cULL, 0x040b62000004181cULL,
0x0000001009357824ULL, 0x000fe200078e00ffULL, 0x000000040a347810ULL, 0x000fe20007ffe0ffULL,
0x0000000838387824ULL, 0x000fe200078e00ffULL, 0xfffffff8365d7812ULL, 0x000fe200078ee25dULL,
0x000000080f377824ULL, 0x000fe200078e00ffULL, 0xfffffff035347812ULL, 0x000fe200078ee234ULL,
0x0000000839207824ULL, 0x020fe200078e00ffULL, 0x000000060a357810ULL, 0x000fe20007ffe0ffULL,
0x000000080f217824ULL, 0x000fe200078e00ffULL, 0x000000160e0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000105d4c7824ULL, 0x000fe200078e020cULL, 0xfffffff820617812ULL, 0x000fe200078ee261ULL,
0x0000001034347824ULL, 0x000fe200078e00ffULL, 0xfffffff8215a7812ULL, 0x000fe200078ee25aULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x000000222820723cULL, 0x000b620000041810ULL,
0x000000004c4c783bULL, 0x000fe20000000200ULL, 0x0000001009367824ULL, 0x000fc400078e00ffULL,
0x000000105a487824ULL, 0x000fe200078e020cULL, 0x000000003440783bULL, 0x0004e20000000200ULL,
0xfffffff839587812ULL, 0x000fe200078ee258ULL, 0x0000001061107824ULL, 0x120fe200078e020cULL,
0x000000302824723cULL, 0x042b620000041824ULL, 0xfffffff036357812ULL, 0x000fe200078ee235ULL,
0x000000004848783bULL, 0x000fe20000000200ULL, 0x00000010583c7824ULL, 0x000fe400078e020cULL,
0x000000080d347824ULL, 0x004fe200078e00ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x000000260e307810ULL, 0x060fe20007ffe0ffULL, 0x000000322828723cULL, 0x000b62000004182cULL,
0x000000360e317810ULL, 0x000fe20007ffe0ffULL, 0x00000010356f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8380d7812ULL, 0x000fe200078ee20fULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0xfffffff8370e7812ULL, 0x000fc400078ee230ULL, 0xfffffff8340f7812ULL, 0x000fe200078ee231ULL,
0x000000100d387824ULL, 0x100fe200078e020cULL, 0x000000006f2c783bULL, 0x020ea20000000200ULL,
0x000000100e347824ULL, 0x100fe400078e020cULL, 0x000000100f307824ULL, 0x000fe400078e020cULL,
0x000000003838783bULL, 0x000ea80000000200ULL, 0x000000003434783bULL, 0x000ea80000000200ULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x0000004c4014723cULL, 0x048ff00000041814ULL,
0x0000004e4018723cULL, 0x040ff00000041818ULL, 0x000000104054723cULL, 0x042f700000041854ULL,
0x000000124050723cULL, 0x040f700000041850ULL, 0x00000048401c723cULL, 0x040b6e000004181cULL,
0x0000030002487a10ULL, 0x020fe20007ffe0ffULL, 0x0000004a4020723cULL, 0x000f660000041820ULL,
0x0000000148117810ULL, 0x040fe20007ffe0ffULL, 0x0000010048137824ULL, 0x000fc600078e0278ULL,
0x0000005e1100720cULL, 0x000fe20003f06070ULL, 0x000000444024723cULL, 0x000b620000041824ULL,
0x0000007704117224ULL, 0x010fc800078e02ffULL, 0x0000620011107625ULL, 0x000fe400078e006eULL,
0x0000004013447812ULL, 0x020fe200078ec0ffULL, 0x000000464028723cULL, 0x000f680000041828ULL,
0x0000000167447824ULL, 0x000fc800078e0244ULL, 0x0000003c2c54723cULL, 0x044b700000041854ULL,
0x0000003e2c50723cULL, 0x040b700000041850ULL, 0x000000382c14723cULL, 0x040b700000041814ULL,
0x0000003a2c18723cULL, 0x040b700000041818ULL, 0x000000342c1c723cULL, 0x040b70000004181cULL,
0x000000362c20723cULL, 0x040b700000041820ULL, 0x000000302c24723cULL, 0x040b700000041824ULL,
0x000000322c28723cULL, 0x020b620000041828ULL, 0x00000c4000008947ULL, 0x000fce0003800000ULL,
0x00000004642d7810ULL, 0x060fe20007ffe0ffULL, 0x0000000164397824ULL, 0x000fe200078e0205ULL,
0x0000001368387217ULL, 0x000fc40007800000ULL, 0x000000052d357210ULL, 0x040fe20007ffe0ffULL,
0x000000082d127824ULL, 0x040fe200078e00ffULL, 0x0000000864317810ULL, 0x000fe20007ffe0ffULL,
0x0000000138387824ULL, 0x000fe200078e0a13ULL, 0x0000001064377810ULL, 0x000fe20007ffe0ffULL,
0x000000012d2e7824ULL, 0x140fe200078e0244ULL, 0xfffffff812357812ULL, 0x000fe200078ee235ULL,
0x0000000164127824ULL, 0x040fe200078e0244ULL, 0x000000382d00720cULL, 0x080fe20003f46070ULL,
0x0000000131437824ULL, 0x040fe200078e0205ULL, 0x0000000c64337810ULL, 0x000fe20007ffe0ffULL,
0x00000008312c7824ULL, 0x000fe200078e00ffULL, 0x0000000708397812ULL, 0x000fe200078ef839ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000383300720cULL, 0x000fc40003fa6070ULL,
0xfffffff82c437812ULL, 0x000fe200078ee243ULL, 0x00000001373f7824ULL, 0x040fe200078e0205ULL,
0x00000007122d7212ULL, 0x000fe200078efcffULL, 0x00000008372c7824ULL, 0x000fe200078e00ffULL,
0x00000014643b7810ULL, 0x000fe20007ffe0ffULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x0000002d10127210ULL, 0x000fe40007f1e0ffULL, 0xfffffff82c3f7812ULL, 0x000fe200078ee23fULL,
0x0000000131327824ULL, 0x100fe200078e0244ULL, 0x000000072e2d7212ULL, 0x000fe200078efcffULL,
0x0000000133417824ULL, 0x000fe200078e0205ULL, 0x000000033b307819ULL, 0x000fe200000006ffULL,
0x0000000833087824ULL, 0x040fe200078e00ffULL, 0x000000386400720cULL, 0x0c0fe20003f26070ULL,
0x00000001332c7824ULL, 0x000fe200078e0244ULL, 0x0000001864477810ULL, 0x000fe20007ffe0ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x000000383700720cULL, 0x000fc40003f86070ULL,
0x000000383100720cULL, 0x080fe20003f66070ULL, 0x0000000111137824ULL, 0x000fe200000e0613ULL,
0x0000002d102e7210ULL, 0x000fe20007f1e0ffULL, 0x000000013b3d7824ULL, 0x000fe200078e0205ULL,
0x0000000732457212ULL, 0x000fe200078efcffULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0xfffffff808417812ULL, 0x000fe400078ee241ULL, 0xfffffff8303d7812ULL, 0x000fe200078ee23dULL,
0x00000001112f7824ULL, 0x000fe200000e062fULL, 0x0000004510327210ULL, 0x000fe20007f1e0ffULL,
0x0000000137307824ULL, 0x000fe200078e0244ULL, 0x000000072c377212ULL, 0x000fe200078efcffULL,
0x0000001039397824ULL, 0x000fe200078e020cULL, 0x00000020644b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111337824ULL, 0x000fe200000e0633ULL, 0x000000383b00720cULL, 0x080fe20003f06070ULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x00000037102c7210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012397faeULL, 0x0003e2000c901c48ULL,
0x000000384700720cULL, 0x040fe20003f26070ULL, 0x0000000147087824ULL, 0x040fe200078e0205ULL,
0x0000000730457212ULL, 0x000fe200078efcffULL, 0x0000000847497824ULL, 0x000fc400078e00ffULL,
0x000000013b3b7824ULL, 0x000fe400078e0244ULL, 0x00000001112d7824ULL, 0x000fe200030e062dULL,
0xfffffff849377812ULL, 0x000fe200078ee208ULL, 0x0000000147087824ULL, 0x000fe200078e0244ULL,
0x0000001c64497810ULL, 0x000fe20007ffe0ffULL, 0x000001003b127825ULL, 0x002fe200078e00ffULL,
0x0000004510307210ULL, 0x000fc60007fde0ffULL, 0x0000000149367824ULL, 0x140fe200078e0205ULL,
0x00000007123b7212ULL, 0x000fe200078efcffULL, 0x0000000849457824ULL, 0x000fe200078e00ffULL,
0x0000003111317210ULL, 0x000fe200037fe4ffULL, 0x000000014b3a7824ULL, 0x040fe200078e0205ULL,
0x0000003b10347210ULL, 0x000fe20007fde0ffULL, 0x000000084b477824ULL, 0x000fe200078e00ffULL,
0xfffffff845397812ULL, 0x000fe200078ee236ULL, 0x0000001035457824ULL, 0x000fe400078e020cULL,
0x0000000111357824ULL, 0x000fe200030e0613ULL, 0xfffffff8473b7812ULL, 0x000fe200078ee23aULL,
0x0000010008127825ULL, 0x000fe200078e00ffULL, 0x000000002e457faeULL, 0x0003e2000d101c48ULL,
0x000000384900720cULL, 0x000fc40003f46070ULL, 0x0000001043437824ULL, 0x000fe200078e020cULL,
0x0000000712477212ULL, 0x000fe200078efcffULL, 0x0000000149087824ULL, 0x100fe200078e0244ULL,
0x0000003064497810ULL, 0x000fe20007ffe0ffULL, 0x000000014b367824ULL, 0x000fe200078e0244ULL,
0x0000000032437faeULL, 0x0005e2000d901c48ULL, 0x0000004710127210ULL, 0x000fe20007fde0ffULL,
0x0000001039397824ULL, 0x000fe200078e020cULL, 0x0000002464477810ULL, 0x000fe20007ffe0ffULL,
0x00000100362e7825ULL, 0x002fe200078e00ffULL, 0x0000000c41457211ULL, 0x000fc400078e20ffULL,
0x000000384b00720cULL, 0x000fe20003f66070ULL, 0x0000000111137824ULL, 0x000fe200030e0613ULL,
0x0000000c3b3b7211ULL, 0x000fe200078e20ffULL, 0x000000002c457faeULL, 0x0003e2000e901c48ULL,
0x000000384700720cULL, 0x000fe20003fa6070ULL, 0x0000010008327825ULL, 0x004fc800078e00ffULL,
0x0000000147087824ULL, 0x040fe200078e0205ULL, 0x0000000732417212ULL, 0x000fe200078efcffULL,
0x0000000147327824ULL, 0x140fe400078e0244ULL, 0x0000000847437824ULL, 0x000fe200078e00ffULL,
0x00000041102c7210ULL, 0x002fe20007fde0ffULL, 0x0000000149367824ULL, 0x000fe200078e0244ULL,
0x000000072e417212ULL, 0x000fe400078efcffULL, 0x0000002864457810ULL, 0x000fe20007ffe0ffULL,
0x00000001112d7824ULL, 0x000fe200030e0633ULL, 0x00000041102e7210ULL, 0x000fe20007fde0ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0xfffffff843417812ULL, 0x000fc600078ee208ULL,
0x000000103f437824ULL, 0x000fe200078e020cULL, 0x00000007323f7212ULL, 0x000fe200078efcffULL,
0x0000000145087824ULL, 0x040fe400078e0205ULL, 0x0000000845477824ULL, 0x000fe200078e00ffULL,
0x0000000030437faeULL, 0x0003e2000e101c48ULL, 0x00000001112f7824ULL, 0x000fe200030e062fULL,
0x000000384500720cULL, 0x040fe20003f86070ULL, 0x0000000145327824ULL, 0x000fe400078e0244ULL,
0x000000103d457824ULL, 0x000fc400078e020cULL, 0x0000001041417824ULL, 0x000fc600078e020cULL,
0x0000000034457faeULL, 0x0005e2000c101c48ULL, 0x0000003f10307210ULL, 0x002fe40007fde0ffULL,
0xfffffff8473f7812ULL, 0x000fe400078ee208ULL, 0x0000002c64477810ULL, 0x000fe20007ffe0ffULL,
0x0000000111317824ULL, 0x000fe200030e0633ULL, 0x0000000c3f3f7211ULL, 0x000fe200078e20ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x0000004447087210ULL, 0x040fe40007ffe0ffULL,
0x000000384700720cULL, 0x000fe20003f06070ULL, 0x0000001037457824ULL, 0x004fe200078e020cULL,
0x00000007323d7212ULL, 0x000fe200078efcffULL, 0x0000010008347825ULL, 0x000fc600078e00ffULL,
0x0000003d10327210ULL, 0x000fe20007fde0ffULL, 0x00000001473a7824ULL, 0x040fe200078e0205ULL,
0x0000000734437212ULL, 0x000fe200078efcffULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0x0000000012457faeULL, 0x0003e2000c901c48ULL, 0x0000010036367825ULL, 0x000fe200078e00ffULL,
0x000000384900720cULL, 0x000fe40003f26070ULL, 0xfffffff8473d7812ULL, 0x000fe200078ee23aULL,
0x0000000111337824ULL, 0x000fe200030e0633ULL, 0x0000003464477810ULL, 0x000fe20007ffe0ffULL,
0x0000000149087824ULL, 0x040fe200078e0205ULL, 0x000000002c397faeULL, 0x0005e2000d101c48ULL,
0x0000000849497824ULL, 0x000fc400078e00ffULL, 0x000000103d3d7824ULL, 0x000fe200078e020cULL,
0x0000004310127210ULL, 0x002fe20007fde0ffULL, 0x000000002e3b7faeULL, 0x0003e2000d901c48ULL,
0x0000000736437212ULL, 0x000fe200078efcffULL, 0x0000000147367824ULL, 0x000fe200078e0205ULL,
0x0000003864457810ULL, 0x000fe20007ffe0ffULL, 0x0000000111137824ULL, 0x000fe200030e0635ULL,
0x0000004310347210ULL, 0x000fe20007fde0ffULL, 0x0000000030417faeULL, 0x0007e2000e901c48ULL,
0xfffffff849437812ULL, 0x000fe200078ee208ULL, 0x0000000147087824ULL, 0x100fe200078e0244ULL,
0x0000003c64497810ULL, 0x000fe20007ffe0ffULL, 0x0000000111357824ULL, 0x000fe200030e0637ULL,
0x000000384700720cULL, 0x080fe20003fa6070ULL, 0x00000100082c7825ULL, 0x004fe200078e00ffULL,
0x000000384500720cULL, 0x080fe20003f66070ULL, 0x00000000323f7faeULL, 0x0005e2000e101c48ULL,
0x000000384900720cULL, 0x000fe20003f46070ULL, 0x0000000145087824ULL, 0x100fe200078e0244ULL,
0x000000072c377212ULL, 0x000fe200078efcffULL, 0x0000000149307824ULL, 0x008fe200078e0244ULL,
0x00000000123d7faeULL, 0x0005e2000c101c48ULL, 0x00000100082e7825ULL, 0x002fe200078e00ffULL,
0x00000037102c7210ULL, 0x000fc60007fde0ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x000000072e377212ULL, 0x000fc600078efcffULL, 0x00000001112d7824ULL, 0x000fe200030e062dULL,
0x00000037102e7210ULL, 0x000fe20007fde0ffULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0x0000000730077212ULL, 0x000fe200078efcffULL, 0x0000000145087824ULL, 0x140fe400078e0205ULL,
0x0000000845397824ULL, 0x000fe200078e00ffULL, 0xfffffff847377812ULL, 0x000fe200078ee236ULL,
0x0000000149387824ULL, 0x040fe400078e0205ULL, 0x00000008493b7824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee208ULL, 0x00000001112f7824ULL, 0x000fe200030e062fULL,
0x0000000710107210ULL, 0x000fe20007fde0ffULL, 0x0000001043437824ULL, 0x000fe200078e020cULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee238ULL, 0x0000001037077824ULL, 0x000fc400078e020cULL,
0x0000001039377824ULL, 0x100fe200078e020cULL, 0x0000000034437faeULL, 0x0005e2000c901c48ULL,
0x000000103b397824ULL, 0x000fe400078e020cULL, 0x0000000111117824ULL, 0x000fe200030e0631ULL,
0x000000002c077faeULL, 0x0005e8000e901c48ULL, 0x000000002e377faeULL, 0x0005e8000d901c48ULL,
0x0000000010397faeULL, 0x0005e2000d101c48ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x0000000164127824ULL, 0x040fe200078e0244ULL, 0x0000000464717810ULL, 0x040fe20007ffe0ffULL,
0x0000000164317824ULL, 0x040fe200078e0205ULL, 0x0000000864707810ULL, 0x000fe20007ffe0ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x00000010646e7810ULL, 0x000fc40007ffe0ffULL,
0x00000014644d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001712e7824ULL, 0x120fe200078e0244ULL,
0x00000007122d7212ULL, 0x000fe200078efcffULL, 0x0000000170127824ULL, 0x100fe200078e0244ULL,
0x0000000c646f7810ULL, 0x000fe20007ffe0ffULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x0000002d102c7210ULL, 0x000fe40007f1e0ffULL, 0x0000000708427812ULL, 0x000fe200078ef831ULL,
0x000000014d347824ULL, 0x100fe200078e0244ULL, 0x000000072e417212ULL, 0x000fe200078efcffULL,
0x000000016e2e7824ULL, 0x000fe200078e0244ULL, 0x00000013112d7210ULL, 0x000fe200007fe4ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000004110407210ULL, 0x000fc40007f1e0ffULL,
0x0000002064087810ULL, 0x000fe20007ffe0ffULL, 0x000000016f307824ULL, 0x000fe200078e0244ULL,
0x0000000712337212ULL, 0x000fe200078efcffULL, 0x0000000111417824ULL, 0x000fe200000e062fULL,
0x00000018644c7810ULL, 0x000fe20007ffe0ffULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x0000003310127210ULL, 0x000fe40007f1e0ffULL, 0x0000001c644b7810ULL, 0x000fe20007ffe0ffULL,
0x0000010034347825ULL, 0x000fe200078e00ffULL, 0x000000072e3d7212ULL, 0x000fc400078efcffULL,
0x0000002464497810ULL, 0x000fe20007ffe0ffULL, 0x0000000111137824ULL, 0x040fe200000e0613ULL,
0x0000003d103c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x00000007343b7212ULL, 0x080fe400078efcffULL, 0x00000028644a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001082e7824ULL, 0x000fe200078e0244ULL, 0x00000007303f7212ULL, 0x000fe200078efcffULL,
0x00000001113d7824ULL, 0x000fe200000e062fULL, 0x0000003b103a7210ULL, 0x000fe20007f1e0ffULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000003f103e7210ULL, 0x000fc40007f3e0ffULL,
0x00000030644f7810ULL, 0x000fe20007ffe0ffULL, 0x000000014c327824ULL, 0x100fe200078e0244ULL,
0x0000002c644e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001113b7824ULL, 0x000fe200000e0635ULL,
0x000000072e357212ULL, 0x000fe200078efcffULL, 0x000000014b307824ULL, 0x000fe200078e0244ULL,
0x0000003464767810ULL, 0x000fe20007ffe0ffULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0x0000003510347210ULL, 0x000fe40007f5e0ffULL, 0x0000003864757810ULL, 0x000fe20007ffe0ffULL,
0x00000001113f7824ULL, 0x000fe200008e0631ULL, 0x0000000732397212ULL, 0x000fe200078efcffULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x0000003c64647810ULL, 0x000fc40007ffe0ffULL,
0x0000003910387210ULL, 0x000fe20007f1e0ffULL, 0x00000001492e7824ULL, 0x100fe200078e0244ULL,
0x0000000730377212ULL, 0x000fe200078efcffULL, 0x0000000111357824ULL, 0x040fe200010e062fULL,
0x0000003311397210ULL, 0x000fe200007fe4ffULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x0000003710367210ULL, 0x000fe40007f3e0ffULL, 0x000000054a7d7210ULL, 0x040fe20007ffe0ffULL,
0x000000014a307824ULL, 0x000fe200078e0244ULL, 0x000000072e337212ULL, 0x000fe200078efcffULL,
0x0000001042437824ULL, 0x000fc400078e020cULL, 0x000000014f427824ULL, 0x000fe200078e0244ULL,
0x0000003310327210ULL, 0x000fe20007f1e0ffULL, 0x0000000111377824ULL, 0x000fe200008e0631ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c437faeULL, 0x0003e2000b901c48ULL,
0x0000010030307825ULL, 0x000fc800078e00ffULL, 0x000000014e2e7824ULL, 0x000fe200078e0244ULL,
0x0000000730457212ULL, 0x000fe200078efcffULL, 0x0000000111337824ULL, 0x000fe400000e062fULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000004510307210ULL, 0x000fc60007f1e0ffULL,
0x00000100422c7825ULL, 0x002fe200078e00ffULL, 0x000000072e457212ULL, 0x000fc600078efcffULL,
0x0000000176427824ULL, 0x100fe200078e0244ULL, 0x000000072c437212ULL, 0x000fe200078efcffULL,
0x0000000111317824ULL, 0x000fe200000e0631ULL, 0x00000045102e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000164467824ULL, 0x000fe200078e0244ULL, 0x00000043102c7210ULL, 0x000fe20007f3e0ffULL,
0x0000010042427825ULL, 0x000fc800078e00ffULL, 0x00000001112f7824ULL, 0x000fe200000e062fULL,
0x0000000742457212ULL, 0x000fe200078efcffULL, 0x0000010046467825ULL, 0x000fc600078e00ffULL,
0x0000004510427210ULL, 0x000fe20007f1e0ffULL, 0x00000001112d7824ULL, 0x000fe200008e062dULL,
0x0000004475457210ULL, 0x000fe20007ffe0ffULL, 0x000000084a4a7824ULL, 0x000fe400078e00ffULL,
0x0000000111437824ULL, 0x000fe400000e0643ULL, 0x0000010045447825ULL, 0x000fe200078e00ffULL,
0xfffffff84a7d7812ULL, 0x000fc800078ee27dULL, 0x00000007447b7212ULL, 0x080fe200078efcffULL,
0x000000107d7d7824ULL, 0x000fe200078e020cULL, 0x0000000746077212ULL, 0x000fe200078efcffULL,
0x0000000871467824ULL, 0x000fe200078e00ffULL, 0x0000007b10447210ULL, 0x040fe20007f1e0ffULL,
0x000000084d7b7824ULL, 0x000fe200078e00ffULL, 0x0000000710107210ULL, 0x000fe20007f3e0ffULL,
0x0000000171077824ULL, 0x000fe400078e0205ULL, 0x0000000111457824ULL, 0x040fe400000e0645ULL,
0x0000000111117824ULL, 0x000fe200008e0647ULL, 0xfffffff846077812ULL, 0x000fe200078ee207ULL,
0x000000086f467824ULL, 0x000fc400078e00ffULL, 0x0000000170477824ULL, 0x100fe400078e0205ULL,
0x0000001007717824ULL, 0x100fe400078e020cULL, 0x000000016f077824ULL, 0x000fe400078e0205ULL,
0x000000086e6f7824ULL, 0x000fe200078e00ffULL, 0x0000000040717faeULL, 0x0003e2000b901c48ULL,
0x0000000870707824ULL, 0x000fe200078e00ffULL, 0xfffffff846077812ULL, 0x000fe400078ee207ULL,
0x000000056e467210ULL, 0x000fe20007ffe0ffULL, 0x000000014d6e7824ULL, 0x000fe200078e0205ULL,
0xfffffff870477812ULL, 0x000fe200078ee247ULL, 0x0000001007077824ULL, 0x000fe200078e020cULL,
0xfffffff86f4d7812ULL, 0x000fe200078ee246ULL, 0x000000014c6f7824ULL, 0x140fe200078e0205ULL,
0x0000000c47477211ULL, 0x000fe200078e20ffULL, 0x000000084c4c7824ULL, 0x000fe200078e00ffULL,
0xfffffff87b417812ULL, 0x002fe200078ee26eULL, 0x000000014b407824ULL, 0x000fc400078e0205ULL,
0x000000084b4b7824ULL, 0x000fe200078e00ffULL, 0xfffffff84c6f7812ULL, 0x000fe200078ee26fULL,
0x0000000108717824ULL, 0x100fe200078e0205ULL, 0x0000000012477faeULL, 0x0003e2000b901c48ULL,
0x000000014e7b7824ULL, 0x100fe200078e0205ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee240ULL,
0x0000000808407824ULL, 0x000fe200078e00ffULL, 0x000000003e077faeULL, 0x0003e2000b901c48ULL,
0x0000000149087824ULL, 0x040fe400078e0205ULL, 0x0000000849497824ULL, 0x000fe200078e00ffULL,
0xfffffff840717812ULL, 0x000fe200078ee271ULL, 0x000000084f407824ULL, 0x000fc400078e00ffULL,
0x000000084e4e7824ULL, 0x000fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee208ULL,
0x000000014f087824ULL, 0x100fe400078e0205ULL, 0x00000001764f7824ULL, 0x000fe200078e0205ULL,
0xfffffff84e7b7812ULL, 0x000fe200078ee27bULL, 0x0000000876767824ULL, 0x000fe200078e00ffULL,
0xfffffff840087812ULL, 0x000fe200078ee208ULL, 0x0000000175407824ULL, 0x040fe400078e0205ULL,
0x0000000875757824ULL, 0x000fe200078e00ffULL, 0xfffffff8764f7812ULL, 0x000fe200078ee24fULL,
0x0000000164467824ULL, 0x000fc400078e0205ULL, 0x000000104d4d7824ULL, 0x000fe200078e020cULL,
0xfffffff875757812ULL, 0x000fe200078ee240ULL, 0x0000000864647824ULL, 0x000fe400078e00ffULL,
0x0000001041417824ULL, 0x100fe200078e020cULL, 0x000000003c4d7faeULL, 0x0003e2000b901c48ULL,
0x000000106f6f7824ULL, 0x000fe200078e020cULL, 0xfffffff864407812ULL, 0x000fe200078ee246ULL,
0x000000104b4b7824ULL, 0x100fe200078e020cULL, 0x000000003a417faeULL, 0x0003e2000b901c48ULL,
0x0000001071717824ULL, 0x100fe200078e020cULL, 0x0000000c75757211ULL, 0x000fe200078e20ffULL,
0x0000001049497824ULL, 0x100fe200078e020cULL, 0x00000000386f7faeULL, 0x0003e2000b901c48ULL,
0x000000107b7b7824ULL, 0x000fc400078e020cULL, 0x0000001008087824ULL, 0x100fe200078e020cULL,
0x00000000364b7faeULL, 0x0003e2000b901c48ULL, 0x000000104f4f7824ULL, 0x100fe400078e020cULL,
0x0000001040407824ULL, 0x000fe200078e020cULL, 0x0000000034717faeULL, 0x0003e8000b901c48ULL,
0x0000000032497faeULL, 0x0003e8000b901c48ULL, 0x00000000307d7faeULL, 0x0003e8000b901c48ULL,
0x000000002e7b7faeULL, 0x0003e8000b901c48ULL, 0x000000002c087faeULL, 0x0003e8000b901c48ULL,
0x00000000424f7faeULL, 0x0003e8000b901c48ULL, 0x0000000044757faeULL, 0x0003e8000b901c48ULL,
0x0000000010407faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001009087824ULL, 0x042fe200078e00ffULL, 0x000000080a077810ULL, 0x004fe20007ffe0ffULL,
0x0000001009317824ULL, 0x000fe200078e00ffULL, 0x000030000b0b7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff008077812ULL, 0x000fe400078ee207ULL, 0x0000000a0a087810ULL, 0x000fe20007ffe0ffULL,
0x000000105c107824ULL, 0x100fe400078e020bULL, 0x0000001007077824ULL, 0x000fe200078e00ffULL,
0xfffffff031087812ULL, 0x000fe200078ee208ULL, 0x000000105f407824ULL, 0x100fe400078e020bULL,
0x000000105b3c7824ULL, 0x100fe400078e020bULL, 0x0000001060387824ULL, 0x000fc400078e020bULL,
0x0000001062347824ULL, 0x100fe400078e020bULL, 0x0000001008087824ULL, 0x000fe400078e00ffULL,
0x0000001063447824ULL, 0x000fe200078e020bULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001010783bULL, 0x000fe20000000200ULL, 0x0000001058587824ULL, 0x000fc600078e020bULL,
0x00000000072c783bULL, 0x0002a80000000200ULL, 0x000000004040783bULL, 0x000ee80000000200ULL,
0x000000003c3c783bULL, 0x000f220000000200ULL, 0x0000000c0a077810ULL, 0x042fe40007ffe0ffULL,
0x0000000e0a0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000003838783bULL, 0x000e680000000200ULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000000830783bULL, 0x0004680000000200ULL,
0x000000004444783bULL, 0x000fe20000000200ULL, 0x0000001009087824ULL, 0x004fc400078e00ffULL,
0x0000001009097824ULL, 0x000fc600078e00ffULL, 0xfffffff008077812ULL, 0x000fe400078ee207ULL,
0xfffffff0090a7812ULL, 0x000fc600078ee20aULL, 0x0000001007077824ULL, 0x000fe200078e00ffULL,
0x000000102c54723cULL, 0x040b6e0000041854ULL, 0x0000000b66107211ULL, 0x0a0fe200078e20ffULL,
0x000000122c50723cULL, 0x040b6a0000041850ULL, 0x000000001010783bULL, 0x020ea60000000200ULL,
0x000000402c14723cULL, 0x048bee0000041814ULL, 0x0000001059407824ULL, 0x120fe200078e020bULL,
0x000000422c18723cULL, 0x040bea0000041818ULL, 0x000000004040783bULL, 0x020fe60000000200ULL,
0x0000003c2c1c723cULL, 0x050b6e000004181cULL, 0x000000105d3c7824ULL, 0x120fe200078e020bULL,
0x0000003e2c20723cULL, 0x040b6a0000041820ULL, 0x000000003c3c783bULL, 0x020fe60000000200ULL,
0x000000382c24723cULL, 0x042f700000041824ULL, 0x0000003a2c28723cULL, 0x000be40000041828ULL,
0x000000000738783bULL, 0x020fea0000000200ULL, 0x00000010652c7824ULL, 0x100fe200078e020bULL,
0x000000343054723cULL, 0x040b6a0000041854ULL, 0x000000002c2c783bULL, 0x000e640000000200ULL,
0x0000001061347824ULL, 0x120fe200078e020bULL, 0x000000363050723cULL, 0x040b6a0000041850ULL,
0x000000003434783bULL, 0x020ee60000000200ULL, 0x00000010301c723cULL, 0x044bee000004181cULL,
0x000000105a107824ULL, 0x120fe200078e020bULL, 0x000000123020723cULL, 0x040bea0000041820ULL,
0x000000001010783bULL, 0x020ea60000000200ULL, 0x000000443014723cULL, 0x040bee0000041814ULL,
0x000000100d447824ULL, 0x120fe200078e020bULL, 0x000000463018723cULL, 0x040b6a0000041818ULL,
0x000000004444783bULL, 0x020fe60000000200ULL, 0x0000002c3024723cULL, 0x002b6e0000041824ULL,
0x000000100a2c7824ULL, 0x020fe200078e00ffULL, 0x000000343854723cULL, 0x008bee0000041854ULL,
0x0000000b0e347211ULL, 0x020fe200078e20ffULL, 0x0000002e3028723cULL, 0x000b620000041828ULL,
0x000000100f0b7824ULL, 0x000fe200078e020bULL, 0x000000002c2c783bULL, 0x020e680000000200ULL,
0x000000005830783bULL, 0x000fe40000000200ULL, 0x000000363850723cULL, 0x040be40000041850ULL,
0x000000003434783bULL, 0x020ee80000000200ULL, 0x000000000b08783bULL, 0x000f240000000200ULL,
0x0000003e3818723cULL, 0x040f700000041818ULL, 0x00000010381c723cULL, 0x044f70000004181cULL,
0x000000403824723cULL, 0x040f700000041824ULL, 0x0000003c3814723cULL, 0x040ff00000041814ULL,
0x000000123820723cULL, 0x040ff00000041820ULL, 0x000000423828723cULL, 0x000ff00000041828ULL,
0x000000462c18723cULL, 0x062f700000041818ULL, 0x000000342c1c723cULL, 0x048f70000004181cULL,
0x000000082c24723cULL, 0x050f700000041824ULL, 0x000000302c54723cULL, 0x000b640000041854ULL,
0x3db504f318187820ULL, 0x020fcc0000410000ULL, 0x000000322c50723cULL, 0x040b620000041850ULL,
0x3db504f31c317820ULL, 0x000fe40000410000ULL, 0x3db504f31d077820ULL, 0x000fe40000410000ULL,
0x3db504f31e137820ULL, 0x000fe40000410000ULL, 0x3db504f319337820ULL, 0x020fe20000410000ULL,
0x000000442c14723cULL, 0x000f620000041814ULL, 0x3db504f31b327820ULL, 0x000fe40000410000ULL,
0x3db504f31f127820ULL, 0x000fc40000410000ULL, 0x3db504f325087820ULL, 0x000fe40000410000ULL,
0x3db504f326197820ULL, 0x000fe20000410000ULL, 0x000000362c20723cULL, 0x040f620000041820ULL,
0x3db504f354547820ULL, 0x000fe40000410000ULL, 0x3db504f355557820ULL, 0x000fe40000410000ULL,
0x3db504f356567820ULL, 0x000fe40000410000ULL, 0x3db504f357577820ULL, 0x000fe20000410000ULL,
0x0000000a2c28723cULL, 0x000b620000041828ULL, 0x3db504f350507820ULL, 0x000fc40000410000ULL,
0x3db504f352527820ULL, 0x000fe40000410000ULL, 0x3db504f353307820ULL, 0x000fe40000410000ULL,
0x3db504f31a0a7820ULL, 0x020fe40000410000ULL, 0x3db504f3242d7820ULL, 0x000fe40000410000ULL,
0x3db504f3512f7820ULL, 0x000fe40000410000ULL, 0x3db504f3142c7820ULL, 0x000fc40000410000ULL,
0x3db504f315157820ULL, 0x000fe40000410000ULL, 0x3db504f316167820ULL, 0x000fe40000410000ULL,
0x3db504f317177820ULL, 0x000fe40000410000ULL, 0x3db504f320207820ULL, 0x000fe40000410000ULL,
0x3db504f3212e7820ULL, 0x000fe40000410000ULL, 0x3db504f3221b7820ULL, 0x000fc40000410000ULL,
0x3db504f3231c7820ULL, 0x000fe40000410000ULL, 0x3db504f3270b7820ULL, 0x000fe40000410000ULL,
0x3db504f328247820ULL, 0x000fe40000410000ULL, 0x3db504f3291a7820ULL, 0x000fe40000410000ULL,
0x3db504f32a0c7820ULL, 0x000fe40000410000ULL, 0x3db504f32b0d7820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0008ULL,
0x00000052001f7202ULL, 0x000fe20000000f00ULL, 0x0000000073087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff277224ULL, 0x000fc400078e0015ULL, 0x000000ffff287224ULL, 0x000fe400078e0018ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0020ULL, 0x000000ffff217224ULL, 0x000fe400078e0017ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0054ULL, 0x000000ffff257224ULL, 0x000fe400078e0055ULL,
0x000000ffff267224ULL, 0x000fc400078e0050ULL, 0x000000ffff297224ULL, 0x000fe400078e0007ULL,
0x000000ffff207224ULL, 0x000fe400078e0056ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0057ULL,
0x000000ffff227224ULL, 0x000fe400078e0016ULL, 0x000000ffff237224ULL, 0x000fe400078e000aULL,
0x000000ffff177224ULL, 0x000fc400078e000bULL, 0x000000ffff187224ULL, 0x000fe400078e000cULL,
0x000000ffff157224ULL, 0x000fc400078e000dULL, 0x00000000000a7805ULL, 0x006fca0000015200ULL,
0x0000040073077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc8000001140dULL,
0x0000000c07077211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000207077819ULL, 0x000fc8000000120cULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040073077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000405167824ULL, 0x000fe200078e00ffULL, 0x0000006c0200720cULL, 0x000fc80003f06070ULL,
0xfffffff016077812ULL, 0x000fca00078ec0ffULL, 0x0000008000147824ULL, 0x000fca00078e0207ULL,
0x01b4000014087984ULL, 0x0002a20000000c00ULL, 0x0000135000008947ULL, 0x000fea0003800000ULL,
0x0000000105027819ULL, 0x000fe200000006ffULL, 0x00000002ff4b7424ULL, 0x000fe200078e00ffULL,
0x0000000668357217ULL, 0x000fe40007800000ULL, 0x0000000602027812ULL, 0x000fc600078ec0ffULL,
0x0000000135357824ULL, 0x000fe200078e0a06ULL, 0x0000006b05067211ULL, 0x000fe200078ff0ffULL,
0x00000001690c7824ULL, 0x000fe200078e0202ULL, 0x0000580002347a10ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff077a19ULL, 0x000fe20000011606ULL, 0x000000010c0f7824ULL, 0x140fe200078e0a35ULL,
0x000000350c00720cULL, 0x000fe20003f26070ULL, 0x00000001340d7824ULL, 0x000fe200078e0a35ULL,
0x0000000772077217ULL, 0x040fe40003800000ULL, 0x0000000f720f7217ULL, 0x000fc40003800000ULL,
0x000000353400720cULL, 0x000fe20003f06070ULL, 0x000000076a507224ULL, 0x000fe200078e02ffULL,
0x00000004ff0f7819ULL, 0x000fe4000001160fULL, 0x0000000d720d7217ULL, 0x000fe40003800000ULL,
0x000000ff0f0f7207ULL, 0x000fe40000800000ULL, 0x0000000806067810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0d437207ULL, 0x000fe20000000000ULL, 0x00000001500c7824ULL, 0x000fe200078e020fULL,
0x00005a00ff077a19ULL, 0x000fc40000011606ULL, 0x0000005043107211ULL, 0x000fe200078fe0ffULL,
0x000060000c0c7625ULL, 0x000fe200078e004bULL, 0x0000001002387812ULL, 0x000fe400078efcffULL,
0x0000000772077217ULL, 0x000fe20003800000ULL, 0x0000600010107625ULL, 0x000fe200078e004bULL,
0x0000580038367a10ULL, 0x000fe20007ffe0ffULL, 0x000000080c4e7981ULL, 0x000724000c1e9500ULL,
0x000000076a527224ULL, 0x000fe200078e02ffULL, 0x00000020023a7812ULL, 0x000fe200078efcffULL,
0x0000000810497981ULL, 0x000324000c1e9500ULL, 0x000000010f067824ULL, 0x000fc400078e0252ULL,
0x00000001360d7824ULL, 0x048fe200078e0a35ULL, 0x000000353600720cULL, 0x000fe20003f06070ULL,
0x0000000169107824ULL, 0x002fc600078e0238ULL, 0x0000000d720d7217ULL, 0x000fe20003800000ULL,
0x0000600006067625ULL, 0x000fe200078e004bULL, 0x000058003a3e7a10ULL, 0x000fc60007ffe0ffULL,
0x0000000110117824ULL, 0x100fe200078e0a35ULL, 0x000000ff0d377207ULL, 0x000fe20000000000ULL,
0x000000013e3d7824ULL, 0x000fe200078e0a35ULL, 0x00000052430e7211ULL, 0x000fe200078fe0ffULL,
0x00000008064c7981ULL, 0x0002e2000c1e9500ULL, 0x0000001172117217ULL, 0x000fe20003800000ULL,
0x0000000169427824ULL, 0x000fe200078e023aULL, 0x000000351000720cULL, 0x000fe20003f26070ULL,
0x000060000e0e7625ULL, 0x000fe200078e004bULL, 0x00000004ff117819ULL, 0x000fe40000011611ULL,
0x000000353e00720cULL, 0x000fc40003f06070ULL, 0x0000005037067211ULL, 0x002fe400078fe0ffULL,
0x0000003d723d7217ULL, 0x000fe20003800000ULL, 0x00000001423f7824ULL, 0x000fe200078e0a35ULL,
0x000000ff11117207ULL, 0x000fe20000800000ULL, 0x0000600006067625ULL, 0x000fe200078e004bULL,
0x000000080e457981ULL, 0x0002e2000c1e9500ULL, 0x000000ff3d3d7207ULL, 0x000fe40000000000ULL,
0x000000354200720cULL, 0x000fe20003f26070ULL, 0x0000000806397981ULL, 0x0004e2000c1e9500ULL,
0x0000003002427812ULL, 0x000fe200078efcffULL, 0x00000001500c7824ULL, 0x000fe200078e0211ULL,
0x0000005211107210ULL, 0x000fc40007ffe0ffULL, 0x0000003f723f7217ULL, 0x000fe40003800000ULL,
0x00000052370e7211ULL, 0x002fe400078fe0ffULL, 0x000000503d067211ULL, 0x004fe200078fe0ffULL,
0x0000000169547824ULL, 0x000fe200078e0242ULL, 0x00000004ff3f7819ULL, 0x000fe2000001163fULL,
0x000060000c0c7625ULL, 0x000fe200078e004bULL, 0x0000580042447a10ULL, 0x000fc60007ffe0ffULL,
0x000060000e0e7625ULL, 0x000fc800078e004bULL, 0x0000600010107625ULL, 0x080fe200078e004bULL,
0x000000ff3f417207ULL, 0x000fe20000800000ULL, 0x000000080c3c7981ULL, 0x0002a4000c1e9500ULL,
0x0000600006067625ULL, 0x000fe400078e004bULL, 0x000000080e3b7981ULL, 0x0002a4000c1e9500ULL,
0x0000000154477824ULL, 0x000fe400078e0a35ULL, 0x0000000810407981ULL, 0x0002a8000c1e9500ULL,
0x00000008063f7981ULL, 0x0002a2000c1e9500ULL, 0x0000004772477217ULL, 0x000fe20003800000ULL,
0x00000001500c7824ULL, 0x002fe200078e0241ULL, 0x000000523d0e7211ULL, 0x000fe200078fe0ffULL,
0x0000000141107824ULL, 0x000fc400078e0252ULL, 0x0000000144077824ULL, 0x040fe200078e0a35ULL,
0x000000354400720cULL, 0x000fe20003f06070ULL, 0x000060000c0c7625ULL, 0x000fe200078e004bULL,
0x000000355400720cULL, 0x000fe40003f26070ULL, 0x0000000772077217ULL, 0x000fe20003800000ULL,
0x000060000e0e7625ULL, 0x080fe200078e004bULL, 0x00000004ff067819ULL, 0x000fe20000011647ULL,
0x000000080c467981ULL, 0x0002a4000c1e9500ULL, 0x0000600010107625ULL, 0x000fe200078e004bULL,
0x000000ff07477207ULL, 0x000fe20000000000ULL, 0x000000080e417981ULL, 0x0002a2000c1e9500ULL,
0x000000ff064d7207ULL, 0x000fc60000800000ULL, 0x00000008104a7981ULL, 0x0002a2000c1e9500ULL,
0x0000005047067211ULL, 0x000fe200078fe0ffULL, 0x00000001500c7824ULL, 0x002fc800078e024dULL,
0x0000600006067625ULL, 0x000fc800078e004bULL, 0x000060000c0c7625ULL, 0x000fe400078e004bULL,
0x0000000806067981ULL, 0x0002a2000c1e9500ULL, 0x00000052470e7211ULL, 0x000fc600078fe0ffULL,
0x000000080c0d7981ULL, 0x0002a2000c1e9500ULL, 0x000000014d107824ULL, 0x000fe400078e0252ULL,
0x000060000e0e7625ULL, 0x000fc800078e004bULL, 0x0000600010107625ULL, 0x000fe400078e004bULL,
0x000000080e0e7981ULL, 0x0002a8000c1e9500ULL, 0x0000000810117981ULL, 0x0008a2000c1e9500ULL,
0xfffffff043507812ULL, 0x000fc800078ec0ffULL, 0x0000005035077210ULL, 0x002fe20007ffe0ffULL,
0x00000001ff437424ULL, 0x000fe200078e00ffULL, 0x0000000802507812ULL, 0x000fc600078efcffULL,
0x0000000134587824ULL, 0x100fe200078e0a07ULL, 0x0000000902547812ULL, 0x000fe400078efcffULL,
0x0000580050527a10ULL, 0x000fe40007ffe0ffULL, 0x0000005843587219ULL, 0x000fe400000006ffULL,
0x00005800540c7a10ULL, 0x000fe20007ffe0ffULL, 0x00000001525a7824ULL, 0x000fc800078e0a07ULL,
0x000000010c5c7824ULL, 0x000fe200078e0a07ULL, 0x0000005a435a7219ULL, 0x040fe400000006ffULL,
0x00000018027a7812ULL, 0x000fe400078efcffULL, 0x0000005c435c7219ULL, 0x000fe400000006ffULL,
0xfffffff037377812ULL, 0x000fe400078ec0ffULL, 0xfffffff047477812ULL, 0x000fe400078ec0ffULL,
0x000058007a0f7a10ULL, 0x000fc60007ffe0ffULL, 0x0000000135517824ULL, 0x000fe200078e0247ULL,
0x0000001902767812ULL, 0x040fe400078efcffULL, 0x00000011027c7812ULL, 0x040fe400078efcffULL,
0x0000002102627812ULL, 0x040fe400078efcffULL, 0x0000002802607812ULL, 0x000fe400078efcffULL,
0x00005800626e7a10ULL, 0x000fe40007ffe0ffULL, 0x0000580060667a10ULL, 0x000fe20007ffe0ffULL,
0x00000001445b7824ULL, 0x000fca00078e0a51ULL, 0x0000005b435b7219ULL, 0x000fe400000006ffULL,
0x0000541049497816ULL, 0x010fe4000000004eULL, 0x00000001024e7812ULL, 0x000fc800078efcffULL,
0x000058004e567a10ULL, 0x000fe40007ffe0ffULL, 0x0000004958ff7212ULL, 0x000fc6000780c0ffULL,
0x0000000156107824ULL, 0x000fe200078e0a07ULL, 0x000000353400720cULL, 0x000fc80000701470ULL,
0x0000001043107219ULL, 0x000fe400000006ffULL, 0x000000350200720cULL, 0x000fe40000701070ULL,
0x0000004910ff7212ULL, 0x080fe4000786c0ffULL, 0x000000495aff7212ULL, 0x080fe4000784c0ffULL,
0x000000495cff7212ULL, 0x000fe4000782c0ffULL, 0xff8000001d1d7808ULL, 0x000fc40000000000ULL,
0xfffffff03d497812ULL, 0x000fe200078ec0ffULL, 0x00000001353d7824ULL, 0x000fe200078e0237ULL,
0x0000541045457816ULL, 0x008fc8000000004cULL, 0x0000004558ff7212ULL, 0x080fe4000788c0ffULL,
0x000000455aff7212ULL, 0x080fe400078cc0ffULL, 0x000000455cff7212ULL, 0x000fe2000780c0ffULL,
0x0000000136477824ULL, 0x100fe200078e0a3dULL, 0x000000353400720cULL, 0x080fe20002781470ULL,
0x000000010f4d7824ULL, 0x000fe200078e0a3dULL, 0x000000355200720cULL, 0x080fe400037c1470ULL,
0x000000350c00720cULL, 0x000fc40000701470ULL, 0x000000350200720cULL, 0x080fe40002781070ULL,
0x000000355000720cULL, 0x080fe400037c1070ULL, 0x000000355400720cULL, 0x000fe40000701070ULL,
0x0000004743477219ULL, 0x040fe400000006ffULL, 0x0000004d434d7219ULL, 0x000fe400000006ffULL,
0x0000004510ff7212ULL, 0x000fc400078ac0ffULL, 0x00005410393c7816ULL, 0x004fe4000000003cULL,
0x00000029025c7812ULL, 0x040fe400078efcffULL, 0x0000003102587812ULL, 0x040fe400078efcffULL,
0x000054103b407816ULL, 0x000fe40000000040ULL, 0x00000038024c7812ULL, 0x040fe400078efcffULL,
0x0000003902107812ULL, 0x000fc400078efcffULL, 0x0000580076077a10ULL, 0x000fe20007ffe0ffULL,
0x0000000135497824ULL, 0x000fe200078e0249ULL, 0x000058007c457a10ULL, 0x000fe40007ffe0ffULL,
0x000000350c00720cULL, 0x000fe40000f21470ULL, 0xff80000020207808ULL, 0x000fe40002000000ULL,
0xff8000001f1f7808ULL, 0x000fe40003000000ULL, 0xff80000030307808ULL, 0x000fc40000000000ULL,
0x0000003c47ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004047ff7212ULL, 0x080fe400078cc0ffULL,
0x000000404dff7212ULL, 0x000fe4000780c0ffULL, 0x000058005c647a10ULL, 0x000fe20007ffe0ffULL,
0x00000001074f7824ULL, 0x000fe200078e0a3dULL, 0x00005800585a7a10ULL, 0x000fe40007ffe0ffULL,
0x000058004c707a10ULL, 0x000fc40007ffe0ffULL, 0x0000580010377a10ULL, 0x000fe20007ffe0ffULL,
0x00000001454b7824ULL, 0x000fe200078e0a3dULL, 0x000000355400720cULL, 0x080fe40000f21070ULL,
0x000000355600720cULL, 0x0c0fe40001f61470ULL, 0x000000355600720cULL, 0x080fe40002fa1470ULL,
0x000000355200720cULL, 0x080fe40001741470ULL, 0x000000353600720cULL, 0x000fc40002781470ULL,
0x000000353600720cULL, 0x080fe400037c1470ULL, 0x000000350f00720cULL, 0x000fe20000701470ULL,
0x000000016e557824ULL, 0x100fe200078e0a49ULL, 0x800000493e537210ULL, 0x000fe20007ffe0ffULL,
0x0000000166577824ULL, 0x100fe200078e0a49ULL, 0xff8000002f2f7808ULL, 0x000fe20000800000ULL,
0x0000000164597824ULL, 0x000fe200078e0a49ULL, 0x000000354e00720cULL, 0x080fe20001f61070ULL,
0x000000015a5d7824ULL, 0x100fe200078e0a51ULL, 0x000000354e00720cULL, 0x080fe20002fa1070ULL,
0x00000001703d7824ULL, 0x100fe200078e0a51ULL, 0x000000355000720cULL, 0x000fe20001741070ULL,
0x0000000137497824ULL, 0x000fe200078e0a51ULL, 0x0000004f43517219ULL, 0x000fc400000006ffULL,
0x000000353800720cULL, 0x0c0fe40002721070ULL, 0x000000353800720cULL, 0x080fe400037c1070ULL,
0x000000357a00720cULL, 0x000fe40000701070ULL, 0x0000004b434b7219ULL, 0x040fe400000006ffULL,
0x00000053434f7219ULL, 0x000fe400000006ffULL, 0x000054103f467816ULL, 0x000fc40000000046ULL,
0x00005410414a7816ULL, 0x000fe4000000004aULL, 0xff80000025257808ULL, 0x000fe40001800000ULL,
0xff8000001e1e7808ULL, 0x000fe40002800000ULL, 0xff80000026267808ULL, 0x000fe40001000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff80000022227808ULL, 0x000fc40003000000ULL,
0xff80000023237808ULL, 0x000fe40000000000ULL, 0x0000003c4bff7212ULL, 0x080fe4000786c0ffULL,
0x0000003c4dff7212ULL, 0x080fe400078ac0ffULL, 0x0000003c51ff7212ULL, 0x000fe4000784c0ffULL,
0x000000404bff7212ULL, 0x080fe4000788c0ffULL, 0x0000004051ff7212ULL, 0x000fc4000782c0ffULL,
0x000000464fff7212ULL, 0x040fe400078cc0ffULL, 0x0000004a4fff7212ULL, 0x000fe4000780c0ffULL,
0x000000354500720cULL, 0x0c0fe40001f61470ULL, 0x000000354500720cULL, 0x080fe40002781470ULL,
0x000000350f00720cULL, 0x080fe40002fa1470ULL, 0x000000350700720cULL, 0x000fc40001741470ULL,
0x000000350700720cULL, 0x080fe40000f21470ULL, 0x000000353e00720cULL, 0x0c0fe400037c1470ULL,
0x000000353e00720cULL, 0x080fe40000701470ULL, 0x000000357c00720cULL, 0x0c0fe40001f61070ULL,
0x000000357c00720cULL, 0x080fe40002781070ULL, 0x000000357a00720cULL, 0x000fc40002fa1070ULL,
0x000000357600720cULL, 0x0c0fe40001741070ULL, 0x000000357600720cULL, 0x080fe40000f21070ULL,
0x000000353a00720cULL, 0x0c0fe400037c1070ULL, 0x000000353a00720cULL, 0x000fe40000701070ULL,
0x0000005543557219ULL, 0x040fe400000006ffULL, 0x0000005743577219ULL, 0x000fc400000006ffULL,
0x0000005943597219ULL, 0x000fe400000006ffULL, 0x0000541006067816ULL, 0x000fe4000000000dULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff80000021217808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0xff80000033337808ULL, 0x000fc40001000000ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff80000031317808ULL, 0x000fe40003000000ULL,
0xff80000013137808ULL, 0x000fe40000000000ULL, 0x0000004655ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004657ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004659ff7212ULL, 0x000fc400078ac0ffULL,
0x0000004a55ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004a57ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004a59ff7212ULL, 0x000fe400078cc0ffULL, 0x000000065bff7212ULL, 0x000fe4000780c0ffULL,
0x000000356e00720cULL, 0x0c0fe40001f61470ULL, 0x000000356e00720cULL, 0x000fc40001741470ULL,
0x000000356600720cULL, 0x0c0fe40002781470ULL, 0x000000356600720cULL, 0x080fe40000f21470ULL,
0x000000356400720cULL, 0x0c0fe40002fa1470ULL, 0x000000356400720cULL, 0x080fe400037c1470ULL,
0x000000354400720cULL, 0x080fe40000701470ULL, 0x000000356200720cULL, 0x000fc40001f61070ULL,
0x000000356200720cULL, 0x080fe40001741070ULL, 0x000000356000720cULL, 0x0c0fe40002781070ULL,
0x000000356000720cULL, 0x080fe40000f21070ULL, 0x000000355c00720cULL, 0x0c0fe40002fa1070ULL,
0x000000355c00720cULL, 0x080fe400037c1070ULL, 0x000000354200720cULL, 0x000fc40000701070ULL,
0x0000005d435d7219ULL, 0x040fe400000006ffULL, 0x0000003d433d7219ULL, 0x040fe400000006ffULL,
0x0000004943497219ULL, 0x000fe400000006ffULL, 0x000054100e0e7816ULL, 0x000fe40000000011ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000012127808ULL, 0x000fc40001000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002000000ULL, 0xff8000001b1b7808ULL, 0x000fe40000800000ULL,
0xff8000002e2e7808ULL, 0x000fe40002800000ULL, 0xff8000001c1c7808ULL, 0x000fe40003000000ULL,
0xff8000002d2d7808ULL, 0x000fe40000000000ULL, 0x000000065dff7212ULL, 0x000fc4000786c0ffULL,
0x000000063dff7212ULL, 0x080fe4000784c0ffULL, 0x0000000649ff7212ULL, 0x000fe4000788c0ffULL,
0x0000000e5bff7212ULL, 0x080fe4000782c0ffULL, 0x0000000e5dff7212ULL, 0x080fe400078ac0ffULL,
0x0000000e3dff7212ULL, 0x080fe400078cc0ffULL, 0x0000000e49ff7212ULL, 0x000fc4000780c0ffULL,
0x000000354400720cULL, 0x080fe40000f21470ULL, 0x000000355a00720cULL, 0x0c0fe40001f61470ULL,
0x000000355a00720cULL, 0x080fe40002fa1470ULL, 0x000000357000720cULL, 0x0c0fe40001741470ULL,
0x000000357000720cULL, 0x080fe400037c1470ULL, 0x000000353700720cULL, 0x000fc40002781470ULL,
0x000000353700720cULL, 0x080fe40000701470ULL, 0x000000354200720cULL, 0x080fe40000f21070ULL,
0x000000355800720cULL, 0x0c0fe40001f61070ULL, 0x000000355800720cULL, 0x080fe40002fa1070ULL,
0x000000354c00720cULL, 0x0c0fe40001741070ULL, 0x000000354c00720cULL, 0x000fc400037c1070ULL,
0x000000351000720cULL, 0x0c0fe40002781070ULL, 0x000000351000720cULL, 0x000fe40000701070ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fe40001000000ULL,
0xff8000001a1a7808ULL, 0x000fe40002000000ULL, 0xff80000019197808ULL, 0x000fc40000800000ULL,
0xff80000017177808ULL, 0x000fe40002800000ULL, 0xff80000018187808ULL, 0x000fe40003000000ULL,
0xff80000015157808ULL, 0x000fc40000000000ULL, 0x0000001d0800720bULL, 0x004fe40003f1e000ULL,
0x000000200900720bULL, 0x000fe40003f3e000ULL, 0x000000081d087208ULL, 0x000fe40004000000ULL,
0x0000000920097208ULL, 0x000fc40004800000ULL, 0x000000250800720bULL, 0x000fe40003f1e000ULL,
0x0000001e0900720bULL, 0x000fe40003f3e000ULL, 0x0000000825077208ULL, 0x000fe40004000000ULL,
0x000000091e027208ULL, 0x000fe40004800000ULL, 0x000000260700720bULL, 0x000fe40003f1e000ULL,
0x0000001f0200720bULL, 0x000fc40003f3e000ULL, 0x0000000726067208ULL, 0x000fe40004000000ULL,
0x000000021f077208ULL, 0x000fe40004800000ULL, 0x0000002f0600720bULL, 0x000fe40003f1e000ULL,
0x000000300700720bULL, 0x000fe40003f3e000ULL, 0x000000062f097208ULL, 0x000fe40004000000ULL,
0x0000000730077208ULL, 0x000fc40004800000ULL, 0x0000002c0900720bULL, 0x000fe40003f1e000ULL,
0x000000220700720bULL, 0x000fe40003f3e000ULL, 0x000000092c027208ULL, 0x000fe40004000000ULL,
0x0000000722067208ULL, 0x000fe40004800000ULL, 0x000000270200720bULL, 0x000fe40003f1e000ULL,
0x000000210600720bULL, 0x000fc40003f3e000ULL, 0x0000000227077208ULL, 0x000fe40004000000ULL,
0x0000000621067208ULL, 0x000fe40004800000ULL, 0x000000280700720bULL, 0x000fe40003f1e000ULL,
0x000000230600720bULL, 0x000fe40003f3e000ULL, 0x0000000728027208ULL, 0x000fe40004000000ULL,
0x0000000623077208ULL, 0x000fc40004800000ULL, 0x000000330200720bULL, 0x000fe40003f1e000ULL,
0x000000320700720bULL, 0x000fe40003f3e000ULL, 0x0000000233027208ULL, 0x000fe40004000000ULL,
0x0000000732067208ULL, 0x000fe40004800000ULL, 0x000000310200720bULL, 0x000fe40003f1e000ULL,
0x000000130600720bULL, 0x000fc40003f3e000ULL, 0x0000000231027208ULL, 0x000fe40004000000ULL,
0x0000000613077208ULL, 0x000fe40004800000ULL, 0x000000290200720bULL, 0x000fe40003f1e000ULL,
0x000000120700720bULL, 0x000fe40003f3e000ULL, 0x0000000229097208ULL, 0x000fe40004000000ULL,
0x0000000712027208ULL, 0x000fc40004800000ULL, 0x0000002a0900720bULL, 0x000fe40003f1e000ULL,
0x0000001b0200720bULL, 0x000fe40003f3e000ULL, 0x000000092a097208ULL, 0x000fe40004000000ULL,
0x000000021b077208ULL, 0x000fe40004800000ULL, 0x0000002e0900720bULL, 0x000fe40003f1e000ULL,
0x0000001c0700720bULL, 0x000fc40003f3e000ULL, 0x000000092e027208ULL, 0x000fe40004000000ULL,
0x000000071c067208ULL, 0x000fe40004800000ULL, 0x0000002d0200720bULL, 0x000fe40003f1e000ULL,
0x000000190600720bULL, 0x000fe40003f3e000ULL, 0x000000022d027208ULL, 0x000fe40004000000ULL,
0x0000000619067208ULL, 0x000fc40004800000ULL, 0x0000002b0200720bULL, 0x000fe40003f1e000ULL,
0x000000170600720bULL, 0x000fe40003f3e000ULL, 0x000000022b077208ULL, 0x000fe40004000000ULL,
0x0000000617097208ULL, 0x000fe40004800000ULL, 0x000000240700720bULL, 0x000fe40003f1e000ULL,
0x000000180900720bULL, 0x000fc40003f3e000ULL, 0x0000000724077208ULL, 0x000fe40004000000ULL,
0x0000000918027208ULL, 0x000fe40004800000ULL, 0x0000001a0700720bULL, 0x000fe40003f1e000ULL,
0x000000150200720bULL, 0x000fe40003f3e000ULL, 0x000000071a0d7208ULL, 0x000fe40004000000ULL,
0x0000000215117208ULL, 0x000fe20004800000ULL, 0x000017127f007947ULL, 0x000fec000b800000ULL,
0x0c401f000d027f89ULL, 0x0004e400000e0000ULL, 0x000000020d00720bULL, 0x008fc80003f1e000ULL,
0x0000000d02107208ULL, 0x000fe20004000000ULL, 0x000017427f007947ULL, 0x000fea000b800000ULL,
0x0c401f0011027f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a077f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b087f89ULL, 0x000e6800000e0000ULL, 0x0c201f0010097f89ULL, 0x000ea200000e0000ULL,
0x000000021100720bULL, 0x008fc40003f1e000ULL, 0x000000070a00720bULL, 0x010fe40003f3e000ULL,
0x0000001102067208ULL, 0x000fe40004000000ULL, 0x0000000a070c7208ULL, 0x000fe40004800000ULL,
0x000000080b00720bULL, 0x002fe20003f1e000ULL, 0x0c201f00060d7f89ULL, 0x004e6600000e0000ULL,
0x0000000b08027208ULL, 0x000fe20004000000ULL, 0x0c201f000c0f7f89ULL, 0x000ea200000e0000ULL,
0x000000091000720bULL, 0x000fc60003f1e000ULL, 0x0c201f0002077f89ULL, 0x0006e200000e0000ULL,
0x0000001009087208ULL, 0x000fe40004000000ULL, 0x0000000d0600720bULL, 0x002fe40003f3e000ULL,
0x0000000f0c00720bULL, 0x004fe40003f5e000ULL, 0x000000060d097208ULL, 0x000fe40004800000ULL,
0x0000000c0f0a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b08067820ULL, 0x008fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000305ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010806ULL, 0x000000070200720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b25257823ULL, 0x100fe40000010806ULL, 0x00000026000e7308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe40000010806ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe40000010806ULL,
0x3fb8aa3b27277823ULL, 0x100fe40000010806ULL, 0x3fb8aa3b280b7823ULL, 0x100fe20000010806ULL,
0x0000001d000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b267823ULL, 0x002fc40000010806ULL,
0x3fb8aa3b092b7820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b33337823ULL, 0x000fe40000010806ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082bULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x3fb8aa3b30307823ULL, 0x100fe4000001082bULL, 0x3fb8aa3b20207823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b1f1f7823ULL, 0x000fc4000001082bULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082bULL,
0x0000002f002f7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe40000010806ULL, 0x3fb8aa3b23237823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b32327823ULL, 0x000fe2000001082bULL, 0x00000020000d7308ULL, 0x000fe20000000800ULL,
0x0000000c250c723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b31287823ULL, 0x000fc40000010806ULL,
0x3fb8aa3b29297823ULL, 0x100fe40000010806ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe40000010806ULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x0000000e2f0e723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe4000001082bULL, 0x3fb8aa3b2e2e7823ULL, 0x000fe40000010806ULL,
0x3fb8aa3b15157823ULL, 0x000fc4000001082bULL, 0x0000001f000f7308ULL, 0x0005f00000000800ULL,
0x0000003000307308ULL, 0x000ee20000000800ULL, 0x0000000d1e0d723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b131f7823ULL, 0x004fcc000001082bULL, 0x0000002700357308ULL, 0x0003e20000000800ULL,
0x0000000f300f723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b24277823ULL, 0x002fcc0000010806ULL,
0x0000000b001d7308ULL, 0x0003e20000000800ULL, 0x00000004ff247e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe80003800000ULL, 0x3f8000002424783eULL, 0x000fe400000010ffULL,
0x0000003300347308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b2d0b7823ULL, 0x002fe40000010806ULL,
0x000000ffff257224ULL, 0x000fc400078e0024ULL, 0x3fb8aa3b122d7823ULL, 0x000fe4000001082bULL,
0x3fb8aa3b1a067823ULL, 0x000fe20000010806ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x0000002400337202ULL, 0x004fe20000000f00ULL, 0x000000240c10723cULL, 0x000b6200000418ffULL,
0x000000ffff3a7224ULL, 0x100fe400078e0024ULL, 0x000000ffff3b7224ULL, 0x000fc600078e0024ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1c257823ULL, 0x020fe2000001082bULL,
0x0000001d341e723eULL, 0x008fcc00000010ffULL, 0x0000002c002c7308ULL, 0x000eb00000000800ULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x00000022211d723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b19217823ULL, 0x000fcc000001082bULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x0000002c351c723eULL, 0x004fe400000010ffULL, 0x00000002ff2c7819ULL, 0x000fc80000011605ULL,
0x000000012c197810ULL, 0x040fe20007ffe0ffULL, 0x0000001f00207308ULL, 0x0003e20000000800ULL,
0x000000082c1a7824ULL, 0x040fe400078e00ffULL, 0x000000082c2f7824ULL, 0x040fe400078e00ffULL,
0x000000082c377824ULL, 0x000fc600078e00ffULL, 0x0000002500227308ULL, 0x0005e20000000800ULL,
0x00000023321f723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b17237823ULL, 0x000fe4000001082bULL,
0x000000ffff327224ULL, 0x000fc800078e0024ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x000000ffff257224ULL, 0x004fce00078e0024ULL, 0x000000241c10723cULL, 0x000b620000041810ULL,
0x0000002900297308ULL, 0x000e6c0000000800ULL, 0x3fb8aa3b18257823ULL, 0x020fe2000001082bULL,
0xfffffff81a2b7812ULL, 0x000fe200078ee219ULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000002e00317308ULL, 0x0004e20000000800ULL, 0x000000282918723eULL, 0x002fe200000010ffULL,
0x000000082c297824ULL, 0x000fca00078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee22cULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x000000082c2e7824ULL, 0x004fce00078e00ffULL,
0x0000001b001b7308ULL, 0x000ea20000000800ULL, 0x0000002a311a723eULL, 0x008fe200000010ffULL,
0x000000082c2a7824ULL, 0x000fe200078e00ffULL, 0x000000202d19723eULL, 0x002fca00000010ffULL,
0x0000002100177308ULL, 0x0003e20000000800ULL, 0x000000082c2d7824ULL, 0x040fe200078e00ffULL,
0x000000022c207810ULL, 0x000fc80007ffe0ffULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee220ULL,
0x0000001b221b723eULL, 0x004fe200000010ffULL, 0x0000002300287308ULL, 0x0005e20000000800ULL,
0x000000032c227810ULL, 0x040fe40007ffe0ffULL, 0x000000042c217810ULL, 0x002fe40007ffe0ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee222ULL, 0xfffffff82a317812ULL, 0x000fe200078ee221ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x000000321820723cULL, 0x004b6e0000041810ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000082c137810ULL, 0x060fe20007ffe0ffULL,
0x000000082c337824ULL, 0x040fe200078e00ffULL, 0x000000052c107810ULL, 0x000fc40007ffe0ffULL,
0x000000062c117810ULL, 0x040fe40007ffe0ffULL, 0xffffffff2c127810ULL, 0x000fe20007ffe0ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x00000008132c7824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe400078ee210ULL, 0xfffffff82e357812ULL, 0x000fe400078ee211ULL,
0xfffffff837377812ULL, 0x000fe400078ee212ULL, 0x0000000600067308ULL, 0x000ea20000000800ULL,
0xfffffff82c397812ULL, 0x000fc400078ee213ULL, 0x0000000b2610723eULL, 0x002fe400000010ffULL,
0x000000172811723eULL, 0x000fe400000010ffULL, 0x0000000c16287812ULL, 0x000fe200078ec0ffULL,
0x0000002500257308ULL, 0x000ff00000000800ULL, 0x00000015002a7308ULL, 0x0002e20000000800ULL,
0x000000270612723eULL, 0x004fc400000010ffULL, 0x0001100000067811ULL, 0x000fc800078e58ffULL,
0x000000062f177211ULL, 0x000fe200078e20ffULL, 0x00000010290b7824ULL, 0x100fe400078e0206ULL,
0x000000102b157824ULL, 0x102fe400078e0206ULL, 0x000000102d167824ULL, 0x100fe400078e0206ULL,
0x0000001031247824ULL, 0x100fe200078e0206ULL, 0x000000252a13723eULL, 0x008fe200000010ffULL,
0x00000001280b7824ULL, 0x000fe400078e020bULL, 0x0000001033257824ULL, 0x000fc400078e0206ULL,
0x0000001035267824ULL, 0x000fe200078e0206ULL, 0x0000000c0b007388ULL, 0x0003e20000000800ULL,
0x0000003a1020723cULL, 0x000f620000041820ULL, 0x0000000128157824ULL, 0x040fe400078e0215ULL,
0x0000000128167824ULL, 0x040fe200078e0216ULL, 0x0000002628267210ULL, 0x040fe20007ffe0ffULL,
0x0000001037277824ULL, 0x100fe200078e0206ULL, 0x0000000e15007388ULL, 0x0005e20000000800ULL,
0x0000000128177824ULL, 0x040fe400078e0217ULL, 0x0000001039067824ULL, 0x000fe200078e0206ULL,
0x0000001c16007388ULL, 0x0005e20000000800ULL, 0x0000000128247824ULL, 0x040fe200078e0224ULL,
0x00000002070b7208ULL, 0x002fe20004800000ULL, 0x0000000128257824ULL, 0x040fe200078e0225ULL,
0x0000001e17007388ULL, 0x0005e20000000800ULL, 0x0000000128277824ULL, 0x000fc400078e0227ULL,
0x0000000128067824ULL, 0x000fe200078e0206ULL, 0x0000001824007388ULL, 0x0005e80000000800ULL,
0x0000001a25007388ULL, 0x0005e40000000800ULL, 0x000000ffff217224ULL, 0x020fe400078e0022ULL,
0x0000001026007388ULL, 0x0005e80000000800ULL, 0x0000001227007388ULL, 0x0005e80000000800ULL,
0x0000000d06007388ULL, 0x0005e80000000800ULL, 0x0004000f15007388ULL, 0x0005e80000000800ULL,
0x0004001d16007388ULL, 0x0005e80000000800ULL, 0x0004001f17007388ULL, 0x0005e80000000800ULL,
0x0004001924007388ULL, 0x0005e80000000800ULL, 0x0004001b25007388ULL, 0x0005e80000000800ULL,
0x0004001126007388ULL, 0x0005e80000000800ULL, 0x0004001327007388ULL, 0x0005e80000000800ULL,
0x01b0000814008388ULL, 0x0005e80000000c00ULL, 0x01b2002014008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080074ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6100074ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6180074ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000005e4800720cULL, 0x000fe20003f06070ULL,
0x01b6200074ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff027224ULL, 0x000fd600078e0048ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff977000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff097807ULL, 0x002fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014690000e7802ULL, 0x000fc40000000f00ULL,
0x00000f3000007944ULL, 0x018fea0003c00000ULL, 0xfffee45000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x000146e0000e7802ULL, 0x000fc40000000f00ULL, 0x00000ee000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0009ULL, 0xfffee49000007947ULL, 0x000fea000383ffffULL,
0x0000000c000e7202ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x00014750000f7802ULL, 0x000fe20000000f00ULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000e2000007944ULL, 0x018fea0003c00000ULL, 0xfffee55000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x000147b0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000dc000007944ULL, 0x01afea0003c00000ULL, 0xfffee65000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00014820000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fe400078e000dULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00000d5000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0009ULL, 0xfffee7d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0xffffffff00347802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00014890000f7802ULL, 0x000fc40000000f00ULL,
0x00000ce000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xfffee79000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x000148f0000e7802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x002fea0003c00000ULL, 0xfffefe6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014940000e7802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x002fea0003c00000ULL,
0x0000000900327202ULL, 0x000fe20000000f00ULL, 0xfffefe9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0036ULL, 0x000149b0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000bc000007944ULL, 0x000fea0003c00000ULL, 0xfffeff6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0036ULL, 0x00014a10000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000b6000007944ULL, 0x002fea0003c00000ULL, 0xffff006000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00014a80000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fe400078e0031ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x0000000900047202ULL, 0x004fe20000000f00ULL, 0xffff01f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00014af0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000a8000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff01b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014b50000e7802ULL, 0x000fc40000000f00ULL,
0x00000a7000007944ULL, 0x018fea0003c00000ULL, 0xffff163000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014ba0000e7802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0009ULL, 0xffff166000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0026ULL, 0x00014c10000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000096000007944ULL, 0x018fea0003c00000ULL, 0xffff173000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0026ULL, 0x00014c70000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000090000007944ULL, 0x01afea0003c00000ULL, 0xffff183000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x0000000d00097202ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00014ce0000f7802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000089000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0009ULL, 0xffff19c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00014d50000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000082000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff198000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014db0000e7802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x032fea0003c00000ULL, 0xffff2e1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014e00000e7802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0xffff2e5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0xffffffff00347802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00014e70000f7802ULL, 0x000fc40000000f00ULL,
0x0000070000007944ULL, 0x030fea0003c00000ULL, 0xffff2f2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0x00014ed0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x032fea0003c00000ULL, 0xffff302000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00014f40000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fe400078e000dULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0009ULL, 0xffff31b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00014fb0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x036fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff317000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0e7424ULL, 0x000fe200078e00ffULL,
0x0001502000067802ULL, 0x000fe20000000f00ULL, 0x0000001fff0c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000cULL, 0xffffe89000007947ULL, 0x000fea000383ffffULL,
0x00000011000d7202ULL, 0x006fe20000000f00ULL, 0x00000002ff0e7424ULL, 0x000fe200078e00ffULL,
0x000150a000067802ULL, 0x000fe20000000f00ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000000c1100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0d7224ULL, 0x002fe200078e000aULL,
0x0001512000067802ULL, 0x000fe20000000f00ULL, 0x00000002ff0e7424ULL, 0x000fe200078e00ffULL,
0x000000110c097208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x0000000c0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0d7224ULL, 0x002fe200078e000bULL,
0x000151a000067802ULL, 0x000fe20000000f00ULL, 0x00000002ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000a0c0f7208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000000c0b00720bULL, 0x004fe20003f1e000ULL, 0x00000001ff0e7424ULL, 0x002fe200078e00ffULL,
0x00000010000d7202ULL, 0x000fe20000000f00ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x0000000b0c027208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fe200078e00ffULL,
0x0001522000067802ULL, 0x000fc40000000f00ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000000c1000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0d7224ULL, 0x002fe200078e0009ULL,
0x000152a000067802ULL, 0x000fe20000000f00ULL, 0x00000001ff0e7424ULL, 0x000fe200078e00ffULL,
0x000000100c087208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x0000000c0900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0d7224ULL, 0x002fe200078e000fULL,
0x0001532000067802ULL, 0x000fe20000000f00ULL, 0x00000001ff0e7424ULL, 0x000fe200078e00ffULL,
0x000000090c097208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x0000000c0f00720bULL, 0x004fe20003f1e000ULL, 0x00000001ff0e7424ULL, 0x002fe200078e00ffULL,
0x00000002000d7202ULL, 0x000fe20000000f00ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x0000000f0c0a7208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fe200078e00ffULL,
0x000153a000067802ULL, 0x000fc40000000f00ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000cULL, 0xffffe67000007947ULL, 0x000fea000383ffffULL,
0x0180000007037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003097812ULL, 0x000fc800078ec0ffULL, 0x018000000900780cULL, 0x000fda0003f05070ULL,
0x0000000700038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0900720cULL, 0x040fe40003f25070ULL, 0x008000000900780cULL, 0x000fe40003f02070ULL,
0x00000001ff0e7807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x000000030eff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000007097812ULL, 0x000fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x000000030eff7212ULL, 0x000fda000780c0ffULL,
0x0080000009030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0009ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000700037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffeaad008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff077424ULL, 0x000fe200078e00ffULL,
0x0000003500007348ULL, 0x000fe80003800000ULL, 0x0c00000e0d0c7389ULL, 0x0002a200000e000cULL,
0xfffeaa9006007950ULL, 0x000fea0003c3ffffULL, 0x0000003400007348ULL, 0x000fe80003800000ULL,
0x000000090e097389ULL, 0x0002a400000e0035ULL, 0x000000ffff0e7224ULL, 0x002fc400078e000fULL,
0x00000000ff0f7424ULL, 0x000fc800078e00ffULL, 0xfffeaa400e007950ULL, 0x000fea0003c3ffffULL,
0x000000010900780cULL, 0x000fe20003f25070ULL, 0x0000000f00007348ULL, 0x000fd80003800000ULL,
0x0000000000097806ULL, 0x000fc800048e0100ULL, 0x0000000f09097212ULL, 0x000fe200078ec0ffULL,
0x00000000ff0f7424ULL, 0x000fc800078e00ffULL, 0xfffea9e00e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000512ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000670ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c8ULL,
0x0000000000000288ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b50ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c10ULL,
0x00000000000005c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011d0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011e0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001270ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001274ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001480ULL,
0x0000000000015700ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016b80ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016bc0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000016f40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001270ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000015910ULL,
0x0000000000015910ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000016b80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000016f40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_16_sm_80_cubin_len = 94240;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
