/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014bb0ULL, 0x0000000000014830ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL,
0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL,
0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x30624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x0000000000676e69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x6c65722e00687461ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x74736e6f632e766eULL,
0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0001000000beULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000fcULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0001000001c6ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b00010000020cULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000299ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000002e7ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000335ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a0022000003d6ULL, 0x0000000000013490ULL, 0x0000000000000270ULL, 0x000400030000044cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000013700ULL, 0x000d00030000047cULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001349000000000ULL, 0x0001080400000000ULL, 0x0000288080810c00ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8c08288080840828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x002880808c920000ULL, 0x0000000000000022ULL, 0x00000034ffffffffULL,
0x0000006000000000ULL, 0x0001349000000000ULL, 0x0000027000000000ULL, 0x0000480400000000ULL,
0x8082288080840900ULL, 0x0900000010042880ULL, 0x288080842880808cULL, 0x0000001400082f04ULL,
0x0008230400000080ULL, 0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL,
0x0000000000000012ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b42904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f000b42804ULL, 0x000007c000000270ULL,
0x00002c9000001cb0ULL, 0x00002df000002d10ULL, 0x000032e000002f30ULL, 0x000037e0000032f0ULL,
0x000046b000004640ULL, 0x000048f0000047b0ULL, 0x00004b0000004af0ULL, 0x00005dc000004ec0ULL,
0x00005f3000005e30ULL, 0x0000627000006070ULL, 0x0000664000006280ULL, 0x000075b000007540ULL,
0x000077f0000076b0ULL, 0x00007a7000007a60ULL, 0x00007ff000007fe0ULL, 0x0000a2500000a210ULL,
0x0000a8d00000a8c0ULL, 0x00012950000128a0ULL, 0x00012c0000012b80ULL, 0x00012ed000012dc0ULL,
0x0001321000013110ULL, 0x0000047001f03904ULL, 0x0001b600000000ffULL, 0x0000055000040100ULL,
0x0001b60800000000ULL, 0x00000660003f0100ULL, 0x0001b68800000004ULL, 0x00000bd0003f0100ULL,
0x0001b60000000007ULL, 0x00000d70003f0107ULL, 0x0001b68800000000ULL, 0x00002a20003f0101ULL,
0x0001b60800000023ULL, 0x00002a40003f0101ULL, 0x0001b60800000023ULL, 0x00002bb0003f0109ULL,
0x0001b60800000023ULL, 0x00003770003f0109ULL, 0x0001b68800000021ULL, 0x00004430003f0101ULL,
0x0001b62800000023ULL, 0x00004450003f0101ULL, 0x0001b62800000023ULL, 0x000045c0003f0109ULL,
0x0001b62800000023ULL, 0x00004e50003f0109ULL, 0x0001b69000000021ULL, 0x00005bb0003f0101ULL,
0x0001b64800000021ULL, 0x00005bd0003f0101ULL, 0x0001b64800000021ULL, 0x00005d40003f0109ULL,
0x0001b64800000021ULL, 0x00006610003f0109ULL, 0x0001b69800000021ULL, 0x00007330003f0101ULL,
0x0001b66800000023ULL, 0x00007350003f0101ULL, 0x0001b66800000023ULL, 0x000074c0003f0109ULL,
0x0001b66800000023ULL, 0x00007d70003f0109ULL, 0x0001b6a000000053ULL, 0x0000b5e0003f0101ULL,
0x0001b60000000007ULL, 0x0000ce80003f0101ULL, 0x0001b60000000007ULL, 0x0000cff0003f0109ULL,
0x0001b60000000007ULL, 0x00010e40003f0109ULL, 0x0001b6880000004aULL, 0x000110b0003f0101ULL,
0x0001b6880000004aULL, 0x00011220003f0109ULL, 0x0001b6880000004aULL, 0x00013430003f0109ULL,
0x0001b60800000049ULL, 0x00013440003f0101ULL, 0x0001b61000000049ULL, 0x00013450003f0101ULL,
0x0001b61800000049ULL, 0x00013460003f0101ULL, 0x0001b62000000049ULL, 0x00033803003f0101ULL,
0x0000af2000201c04ULL, 0x0000b1300000af70ULL, 0x0000b4200000b290ULL, 0x0000d0200000b520ULL,
0x000c050400013480ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL,
0x0000001500080a04ULL, 0x0000000000600210ULL, 0x00000000000000ccULL, 0x0000001400000002ULL,
0x0000000000013490ULL, 0x0000000000000044ULL, 0x0000001400000002ULL, 0x0000000000000000ULL,
0x00000000000000a2ULL, 0x0000001400000002ULL, 0x0000000000000000ULL, 0x000000000001b700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000117919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000000004a7919ULL, 0x000f2a0000002600ULL, 0x00000300ff0a7b82ULL, 0x000f620000000800ULL,
0x0000000000097919ULL, 0x000ea20000002100ULL, 0x00000000004d7919ULL, 0x000f6c0000002700ULL,
0x00000400ff067b82ULL, 0x000ee20000000800ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000000300007306ULL, 0x004ea20000209000ULL, 0x000000ff0300720cULL, 0x000fca0003f45070ULL,
0x00008600ff0d7b82ULL, 0x000f640000000800ULL, 0x0000000000007308ULL, 0x004ea20000001000ULL,
0x00000005ff487819ULL, 0x002fcc0000011609ULL, 0x00001fff48487589ULL, 0x000f6200000e0000ULL,
0x0ffffffe00047836ULL, 0x004fc80000000000ULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff087224ULL, 0x004fc800078e0a05ULL,
0x0000000308077224ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000e640000002200ULL,
0x0000000705057227ULL, 0x000fcc00078e0004ULL, 0x0000000605077227ULL, 0x008fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a07ULL, 0x0000000003007224ULL, 0x000fca00078e0206ULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x8000000300000210ULL, 0x000fe20007ffe0ffULL,
0x0000000107070836ULL, 0x000fc60000000000ULL, 0x000000030000720cULL, 0x000fda0003f26070ULL,
0x0000000107071836ULL, 0x000fe20000000000ULL, 0x00000003ff07a212ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000ea20000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f65070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00047836ULL, 0x004fe40000000000ULL,
0x0000000411007c24ULL, 0x002fe2000f8e0208ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x0002a2000021f000ULL, 0x00001fff11117589ULL, 0x000f6200000e0000ULL,
0x000000ff00047202ULL, 0x002fe20000000f00ULL, 0x0000000507067224ULL, 0x004fc800078e02ffULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a06ULL, 0x0000000b05057227ULL, 0x000fc800078e0004ULL,
0x0000000400047c24ULL, 0x000fe4000f8e0209ULL, 0x0000004a054b7227ULL, 0x010fc600078e00ffULL,
0x0000007f0400780cULL, 0x000fe20003f44070ULL, 0x000000ffff057224ULL, 0x000fc800078e0a4bULL,
0x0000000507007224ULL, 0x000fca00078e024aULL, 0x000000070000720cULL, 0x000fc60003f06070ULL,
0x000000000006a919ULL, 0x000e620000008800ULL, 0x000004000005a802ULL, 0x000fd20000000f00ULL,
0x0000000100000824ULL, 0x000fe400078e0a07ULL, 0x000000014b4b0836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x000000070000720cULL, 0x000fda0003f26070ULL,
0x000000014b4b1836ULL, 0x000fe20000000000ULL, 0x00000007ff4bb212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x000fe40003f24070ULL, 0x000000ff4b007210ULL, 0x000fe40007ffe1ffULL,
0x000006540605a816ULL, 0x002fe40000000005ULL, 0x000000030400780cULL, 0x000fe20003f64070ULL,
0x00000000074a7224ULL, 0x000fc400078e024aULL, 0xff317217ff07a424ULL, 0x000fe400078e00ffULL,
0x000000040406a824ULL, 0x000fe200078e0205ULL, 0x0000000000240947ULL, 0x020fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01b60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01b60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01b68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000104a007824ULL, 0x000fe200078e00ffULL, 0x0000000d02057219ULL, 0x080fe200000006ffULL,
0x00000000004c7919ULL, 0x000e620000002500ULL, 0x0000000d03097219ULL, 0x080fe200000006ffULL,
0x000000ffff047224ULL, 0x000fe200078e0a00ULL, 0x000000000500720cULL, 0x000fe20003f06070ULL,
0x01b400070600a388ULL, 0x0003e20000000800ULL, 0x000000024d027224ULL, 0x000fe200078e02ffULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000001005497446ULL, 0x000fe40003800004ULL,
0x0000000d4b047219ULL, 0x000fc400000006ffULL, 0x000000ff49497207ULL, 0x000fe40000000000ULL,
0x0000004811057211ULL, 0x000fe200078e10ffULL, 0x0000000902027224ULL, 0x000fe200078e0204ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000104900780cULL, 0x000fe20003f05270ULL,
0x0000000205057824ULL, 0x000fd800078e00ffULL, 0x0000000000808947ULL, 0x002fea0003800000ULL,
0x0000000000087919ULL, 0x000e620000000000ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000f7919ULL, 0x000ea60000008800ULL,
0x0000000d040b7219ULL, 0x000fe400000006ffULL, 0x00000004ff067819ULL, 0x002fca0000011608ULL,
0x0000000105077824ULL, 0x000fc800078e0206ULL, 0x0000000100047824ULL, 0x000fe400078e0207ULL,
0x0000001007137824ULL, 0x000fc600078e00ffULL, 0x0000000b040b7212ULL, 0x000fe400078e30ffULL,
0x0000000dff047219ULL, 0x000fe40000011604ULL, 0x0000000b020b7210ULL, 0x000fe40007ffe0ffULL,
0x0000000549027248ULL, 0x000fc60007fe0000ULL, 0x0000000904047224ULL, 0x000fe400078e020bULL,
0x00000010080b7824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe400078e0a05ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f00b0d7812ULL, 0x000fe400078ec0ffULL,
0x000000020600720cULL, 0x000fe20003f06070ULL, 0x0000000107027824ULL, 0x000fe200078e0208ULL,
0x0000040000067802ULL, 0x000fc40000000f00ULL, 0x0000000d040d7212ULL, 0x000fe400078efcffULL,
0x000006540f077816ULL, 0x004fe40000000006ULL, 0x000000040d047c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff013027812ULL, 0x000fe400078ee202ULL, 0x0000000505057c10ULL, 0x000fe40008ffe4ffULL,
0x00000007020d7211ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000c101c46ULL, 0x00000000006c7947ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x000e620000000000ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x0000040000067802ULL, 0x000fe20000000f00ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000000000f7919ULL, 0x000ea20000008800ULL, 0x0000000508077211ULL, 0x042fe200078fe0ffULL,
0x00000010080b7824ULL, 0x000fe200078e00ffULL, 0x0000000d04057219ULL, 0x000fc600000006ffULL,
0x0000000100047824ULL, 0x000fca00078e0207ULL, 0x0000000504057212ULL, 0x000fe400078e30ffULL,
0x0000000dff047219ULL, 0x000fe40000011604ULL, 0x000000f00b0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000102057824ULL, 0x000fe200078e0205ULL, 0x0000000807027210ULL, 0x000fc60007ffe0ffULL,
0x0000000904047224ULL, 0x000fc800078e0205ULL, 0x0000010004047825ULL, 0x000fc600078e00ffULL,
0x0000000d04047212ULL, 0x000fe200078efcffULL, 0x00000010070d7824ULL, 0x000fe200078e00ffULL,
0x000006540f077816ULL, 0x004fe40000000006ULL, 0x0000000404047c10ULL, 0x000fe4000ff1e0ffULL,
0xfffffff00d027812ULL, 0x000fe400078ee202ULL, 0x0000000505057c10ULL, 0x000fc600087fe4ffULL,
0x00000010020d7824ULL, 0x000fca00078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e4000b901c46ULL, 0x00000000070472caULL, 0x000fe200000e0000ULL,
0x00009200ff0c7b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001b60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x000000044d0c7825ULL, 0x002fe200078e000cULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x000000060c0f7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff1100720cULL, 0x000fe20003f05270ULL, 0x0000007f0f067836ULL, 0x004fe40000000000ULL,
0x000000ff0f057836ULL, 0x000fc60000000000ULL, 0x00000007ff067819ULL, 0x000fe40000011606ULL,
0x00000008ff057819ULL, 0x000fca0000011605ULL, 0x000000a800248947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe20000011648ULL, 0x0000000848047824ULL, 0x000fe200078e00ffULL,
0xffffffff00577802ULL, 0x000fe20000000f00ULL, 0x00000004ff137424ULL, 0x000fe200078e00ffULL,
0x01ffffff000d7812ULL, 0x000fc800078ec0ffULL, 0x0000000d4c587211ULL, 0x000fc800078e08ffULL,
0x000000065800720cULL, 0x000fda0003f06070ULL, 0x00009400ff0d8b82ULL, 0x000e620000000800ULL,
0x000000024d008824ULL, 0x000fce00078e00ffULL, 0x00009000ff108b82ULL, 0x000ea20000000a00ULL,
0x0000000d000d8224ULL, 0x002fe400078e020dULL, 0x0000000107007824ULL, 0x000fe400078e0204ULL,
0x00000001580d8824ULL, 0x000fe400078e020dULL, 0x01b6881300ff79a7ULL, 0x0003e4000850003fULL,
0x000000040d108825ULL, 0x004fca00078e0010ULL, 0x0000000610578981ULL, 0x000e62000c1e1900ULL,
0x000000014c027836ULL, 0x000fe20000000000ULL, 0x00000001ff557819ULL, 0x000fc80000011648ULL,
0x000000050200720cULL, 0x000fe40003f06070ULL, 0x000000074b027819ULL, 0x000fe200000006ffULL,
0x00008e00ff0c7b82ULL, 0x000ea20000000a00ULL, 0x0000000357007224ULL, 0x002fe400078e02ffULL,
0x0000002055037824ULL, 0x000fe400078e00ffULL, 0x0000008000137824ULL, 0x000fe200078e00ffULL,
0x0000000148007812ULL, 0x000fe200078ec0ffULL, 0x000001004c167824ULL, 0x000fc400078e0203ULL,
0x00000100130c7825ULL, 0x004fc600078e000cULL, 0x0000006002177812ULL, 0x000fe200078ef816ULL,
0x0000000400948947ULL, 0x000fec0003800000ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0e7819ULL, 0x000fe40000011608ULL, 0x000000ff00117202ULL, 0x000fe20000000f00ULL,
0x0000008000107824ULL, 0x000fe200078e020bULL, 0x000000160f0b7248ULL, 0x000fe20007fe0000ULL,
0x0000000117137824ULL, 0x000fe200078e020eULL, 0x000000140e247810ULL, 0x000fe20007ffe0ffULL,
0x000000040e147836ULL, 0x000fe40000000000ULL, 0x0000010013127825ULL, 0x000fc800078e0010ULL,
0x000000ffff167224ULL, 0x000fe200078e0a16ULL, 0x000000120c1a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000114157824ULL, 0x040fe400078e0208ULL, 0x00000008141e7824ULL, 0x040fe200078e00ffULL,
0x000000200b0b7446ULL, 0x000fe20003800016ULL, 0x000000010d1b7824ULL, 0x000fe200000e0613ULL,
0x0000000755137211ULL, 0x000fe200078e70ffULL, 0x000000080e207836ULL, 0x000fe20000000000ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee215ULL, 0x0000000117157824ULL, 0x000fe200078e0214ULL,
0x0000000b1400720cULL, 0x080fe20003f26070ULL, 0x0000000c0e227836ULL, 0x000fe20000000000ULL,
0x000000080e147210ULL, 0x000fe20007ffe0ffULL, 0x0000200000167824ULL, 0x000fe200078e0213ULL,
0x0000000b0e00720cULL, 0x000fe20003f06070ULL, 0x0000010015127825ULL, 0x000fe200078e0010ULL,
0x00000007141d7812ULL, 0x000fc400078ec0ffULL, 0x0000000b2000720cULL, 0x0c0fe20003fa6070ULL,
0x0000000117197824ULL, 0x040fe200078e0220ULL, 0x000000120c1c7210ULL, 0x000fe20007f5e0ffULL,
0x00000001171f7824ULL, 0x000fe200078e0222ULL, 0x0000000320257819ULL, 0x000fe200000006ffULL,
0x0000010019147825ULL, 0x000fe200078e0010ULL, 0x0000000b2200720cULL, 0x000fc60003f86070ULL,
0x000001001f187825ULL, 0x000fe200078e0010ULL, 0x000000140c127210ULL, 0x000fc60007f7e0ffULL,
0x00013000161f7836ULL, 0x000fe20000000000ULL, 0x0ffffff81d167812ULL, 0x000fe200078ef808ULL,
0x000000010d1d7824ULL, 0x040fe200010e0613ULL, 0x000000180c147210ULL, 0x000fe20007f5e0ffULL,
0x000000101e237824ULL, 0x000fe200078e021fULL, 0x0000001f16217211ULL, 0x000fe200078e20ffULL,
0x000000100e1e7836ULL, 0x000fe40000000000ULL, 0x000000010d137824ULL, 0x040fe400018e0615ULL,
0x000000010d157824ULL, 0x000fe200010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a217faeULL, 0x0003e2000c101c46ULL, 0x0000000117197824ULL, 0x000fe200078e021eULL,
0x0000000b1e00720cULL, 0x080fe20003f66070ULL, 0x0000000122167824ULL, 0x000fe200078e0208ULL,
0x000000001c237faeULL, 0x0005e2000c901c46ULL, 0x0000010019187825ULL, 0x000fe200078e0010ULL,
0x0000000b2400720cULL, 0x000fc60003f46070ULL, 0x000000180e267836ULL, 0x000fe20000000000ULL,
0x000000180c187210ULL, 0x000fe20007fde0ffULL, 0x0000001c0e287836ULL, 0x000fe40000000000ULL,
0x00000001171b7824ULL, 0x002fe200078e0224ULL, 0x0000000b2600720cULL, 0x080fe20003f26070ULL,
0x0000000824217824ULL, 0x000fe200078e00ffULL, 0x0000000b2800720cULL, 0x000fe20003f06070ULL,
0x00000008221d7824ULL, 0x004fe200078e00ffULL, 0x000000081e0b7210ULL, 0x000fe20007ffe0ffULL,
0x000001001b1a7825ULL, 0x000fc600078e0010ULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee216ULL,
0x0000000124167824ULL, 0x000fe200078e0208ULL, 0x0000000328247819ULL, 0x000fe200000006ffULL,
0x00000001171d7824ULL, 0x000fe400078e0226ULL, 0x00000001200e7824ULL, 0x000fe200078e0208ULL,
0xfffffff821207812ULL, 0x000fe200078ee216ULL, 0x000000010d197824ULL, 0x000fe200030e0619ULL,
0x0000001a0c1a7210ULL, 0x000fe20007fde0ffULL, 0x000000081e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8250e7812ULL, 0x000fe200078ee20eULL, 0x0000000117217824ULL, 0x000fe200078e0228ULL,
0x0000001b0d1b7210ULL, 0x000fe200037fe4ffULL, 0x000001001d167825ULL, 0x000fe200078e0010ULL,
0xfffffff81e1e7812ULL, 0x000fc400078ee20bULL, 0x0000001f20237211ULL, 0x000fe200078e20ffULL,
0x00000001260b7824ULL, 0x140fe200078e0208ULL, 0x000000160c167210ULL, 0x000fe20007fde0ffULL,
0x0000000826227824ULL, 0x000fe400078e00ffULL, 0x00000001281d7824ULL, 0x000fe400078e0208ULL,
0x0000010021107825ULL, 0x000fe200078e0010ULL, 0xfffffff822227812ULL, 0x000fe400078ee20bULL,
0xfffffff824247812ULL, 0x000fe200078ee21dULL, 0x000000010d177824ULL, 0x000fe200030e0617ULL,
0x000000100c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000100e0b7824ULL, 0x000fc400078e021fULL,
0x000000101c1d7824ULL, 0x100fe400078e021fULL, 0x000000101e217824ULL, 0x100fe200078e021fULL,
0x00000000120b7faeULL, 0x0003e2000e901c46ULL, 0x0000001022257824ULL, 0x100fe400078e021fULL,
0x00000010241f7824ULL, 0x000fe200078e021fULL, 0x00000000141d7faeULL, 0x0003e2000e101c46ULL,
0x000000010d0d7824ULL, 0x000fc600030e0611ULL, 0x0000000018217faeULL, 0x0003e8000d901c46ULL,
0x000000001a237faeULL, 0x0003e8000d101c46ULL, 0x0000000016257faeULL, 0x0003e8000c901c46ULL,
0x000000000c1f7faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x00000004080e7811ULL, 0x040fe400078fe8ffULL, 0x0000000808117811ULL, 0x000fe400078fe8ffULL,
0x000000030e137819ULL, 0x040fe200000006ffULL, 0x000000010e107824ULL, 0x100fe200078e0208ULL,
0x0000001008147811ULL, 0x040fe200078fe8ffULL, 0x0000000111127824ULL, 0x140fe200078e0208ULL,
0x0000001408167811ULL, 0x000fe200078fe8ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0xfffffff813207812ULL, 0x000fe200078ee210ULL, 0x0000000814267824ULL, 0x000fe200078e00ffULL,
0x0000000c08107811ULL, 0x000fe200078fe8ffULL, 0x0000000816287824ULL, 0x040fe200078e00ffULL,
0xfffffff815227812ULL, 0x000fe200078ee212ULL, 0x0000000116157824ULL, 0x100fe200078e0208ULL,
0x0000000814137210ULL, 0x000fe20007ffe0ffULL, 0x0000000110127824ULL, 0x040fe200078e0208ULL,
0x000000700b1f7812ULL, 0x000fe200078ec0ffULL, 0x00000008101b7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee213ULL, 0x0000400055137824ULL, 0x000fe200078e0207ULL,
0x0000001808187811ULL, 0x000fe200078fe8ffULL, 0x00000080001e7824ULL, 0x040fe200078e021fULL,
0xfffffff81b247812ULL, 0x000fe200078ee212ULL, 0x00002000001a7824ULL, 0x000fe200078e0213ULL,
0x0000001c08127811ULL, 0x000fe200078fe8ffULL, 0x0000000117137824ULL, 0x040fe200078e020eULL,
0xfffffff828287812ULL, 0x000fe200078ee215ULL, 0x0000000118197824ULL, 0x100fe200078e0208ULL,
0x00000003121f7819ULL, 0x040fe200000006ffULL, 0x00000001120e7824ULL, 0x000fe200078e0208ULL,
0x00000003182a7819ULL, 0x000fe200000006ffULL, 0x0000000117237824ULL, 0x040fe200078e0212ULL,
0x0000001117157210ULL, 0x000fe20007ffe0ffULL, 0x00000001171b7824ULL, 0x040fe200078e0214ULL,
0x0000001708117211ULL, 0x040fe200078fe8ffULL, 0x00000001171d7824ULL, 0x040fe200078e0216ULL,
0xfffffff81f0e7812ULL, 0x000fe200078ee20eULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee219ULL, 0x0000000117197824ULL, 0x000fe200078e0210ULL,
0x00000008080b7211ULL, 0x000fe200078fe8ffULL, 0x0000010011107825ULL, 0x000fc600078e001eULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000010013127825ULL, 0x000fe200078e001eULL,
0x000000100c107210ULL, 0x000fe40007f1e0ffULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef808ULL,
0x0000000117217824ULL, 0x000fe200078e0218ULL, 0x000000120c127210ULL, 0x000fe20007f3e0ffULL,
0x0000010015147825ULL, 0x000fc800078e001eULL, 0x0000010019167825ULL, 0x000fe200078e001eULL,
0x000000140c147210ULL, 0x000fc60007f5e0ffULL, 0x000130001a2d7836ULL, 0x000fe20000000000ULL,
0x000000160c167210ULL, 0x000fe20007f7e0ffULL, 0x000001001b187825ULL, 0x100fe200078e001eULL,
0x000000150d157210ULL, 0x000fe400017fe4ffULL, 0x0000002d0b0b7211ULL, 0x080fe200078e20ffULL,
0x000001001d1a7825ULL, 0x000fe200078e001eULL, 0x0000002d28297211ULL, 0x000fc600078e20ffULL,
0x00000100211c7825ULL, 0x000fc800078e001eULL, 0x00000100231e7825ULL, 0x000fe200078e001eULL,
0x0000001c0c1c7210ULL, 0x000fc60007f5e0ffULL, 0x000000010d117824ULL, 0x040fe200000e0611ULL,
0x000000180c187210ULL, 0x000fe20007f1e0ffULL, 0x000000010d137824ULL, 0x040fe200008e0613ULL,
0x0000001a0c1a7210ULL, 0x000fe20007f3e0ffULL, 0x0000001020217824ULL, 0x100fe200078e022dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100b7faeULL, 0x0003e2000b901c46ULL,
0x0000001022237824ULL, 0x000fe400078e022dULL, 0x000000010d177824ULL, 0x000fe200018e0617ULL,
0x0000001e0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001024257824ULL, 0x100fe200078e022dULL,
0x0000000012217faeULL, 0x0003e2000b901c46ULL, 0x0000001026277824ULL, 0x000fc400078e022dULL,
0x000000010d197824ULL, 0x040fe200000e0619ULL, 0x0000000014237faeULL, 0x0003e2000b901c46ULL,
0x000000010d1b7824ULL, 0x040fe400008e061bULL, 0x000000102a2b7824ULL, 0x000fe200078e022dULL,
0x0000000016257faeULL, 0x0003e2000b901c46ULL, 0x000000010d1d7824ULL, 0x000fe200010e061dULL,
0x0000001f0d0d7210ULL, 0x000fe20001ffe4ffULL, 0x000000100e2d7824ULL, 0x000fe200078e022dULL,
0x0000000018277faeULL, 0x0003e8000b901c46ULL, 0x000000001a297faeULL, 0x0003e8000b901c46ULL,
0x000000001c2b7faeULL, 0x0003e8000b901c46ULL, 0x000000000c2d7faeULL, 0x0003e4000b901c46ULL,
0x000000054c00720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff567424ULL, 0x000fe200078e00ffULL, 0x00000000001e7805ULL, 0x002fe2000001ff00ULL,
0x000000ffff597224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fc4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000060009c0947ULL, 0x000fec0003800000ULL, 0x00009400ff0c7b82ULL, 0x000e620000000800ULL,
0x000000024d0b7824ULL, 0x000fe200078e00ffULL, 0x000000ff001f7202ULL, 0x000fe20000000f00ULL,
0xff317217ff567424ULL, 0x000fe400078e00ffULL, 0x0000000c0b0b7224ULL, 0x002fce00078e020cULL,
0x00000010481a7824ULL, 0x000fe200078e00ffULL, 0x00008e00ff187b82ULL, 0x000e620000000a00ULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x0000000457577c24ULL, 0x010fe2000f8e02ffULL,
0xffffffe01a1b7812ULL, 0x000fe200078ec0ffULL, 0x000000014c1a7836ULL, 0x000fc60000000000ULL,
0x0000000757577819ULL, 0x000fe200000006ffULL, 0x000001004c1b7824ULL, 0x000fe200078e021bULL,
0x000000051a00720cULL, 0x000fc60003f06070ULL, 0x000000401b207836ULL, 0x000fca0000000000ULL,
0x0000006020277812ULL, 0x000fca00078ec0ffULL, 0x0000000102277824ULL, 0x000fe400078e0227ULL,
0x0000010057187825ULL, 0x002fe200078e0018ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400a08947ULL, 0x000fea0003800000ULL, 0x0000001008227824ULL, 0x000fe200078e00ffULL,
0x000000200f1a7248ULL, 0x000fe20007fe0000ULL, 0x000000ffff217224ULL, 0x000fe200078e0a20ULL,
0x00000003ff297819ULL, 0x100fe20000011608ULL, 0x00000080481b7824ULL, 0x000fe200078e00ffULL,
0x0000007022227812ULL, 0x000fe400078ec0ffULL, 0x000000201a247446ULL, 0x000fe20003800021ULL,
0x0000000129257824ULL, 0x000fe200078e0208ULL, 0x00000080221a7812ULL, 0x000fe200078ef81bULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x0000002729217210ULL, 0x000fe20007ffe0ffULL,
0x0000200048227824ULL, 0x000fe200078e00ffULL, 0x0000000755557211ULL, 0x000fe200078e70ffULL,
0x00000004292b7836ULL, 0x000fe20000000000ULL, 0x0000000725257812ULL, 0x000fe200078ec0ffULL,
0x0000010021207825ULL, 0x000fe200078e001aULL, 0x0000200022227812ULL, 0x000fc400078ec0ffULL,
0x000000242900720cULL, 0x080fe20003f26070ULL, 0x000000012b287824ULL, 0x040fe200078e0208ULL,
0x0000002018207210ULL, 0x000fe20007f1e0ffULL, 0x000000082b417824ULL, 0x000fe200078e00ffULL,
0x0001400055267810ULL, 0x000fe20007ffe022ULL, 0x000000012b237824ULL, 0x000fe200078e0227ULL,
0x0ffffff825257812ULL, 0x000fe200078ef808ULL, 0x0000000119217824ULL, 0x000fe200000e0621ULL,
0x000000242b00720cULL, 0x000fe20003f06070ULL, 0x0000010023227825ULL, 0x000fe200078e001aULL,
0x0000002625257211ULL, 0x000fc400078e20ffULL, 0xfffffff8412b7812ULL, 0x000fe200078ee228ULL,
0x0000000829417836ULL, 0x000fe20000000000ULL, 0x0000002218227210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e2000c901c46ULL,
0x0000000c29457836ULL, 0x000fe20000000000ULL, 0x00000014294d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000841437824ULL, 0x040fe200078e00ffULL, 0x000000244100720cULL, 0x080fe20003fc6070ULL,
0x0000001029477836ULL, 0x000fe20000000000ULL, 0x000000244500720cULL, 0x080fe20003fa6070ULL,
0x00000018294f7836ULL, 0x000fe20000000000ULL, 0x000000244d00720cULL, 0x000fe20003f66070ULL,
0x0000001c29517836ULL, 0x000fe20000000000ULL, 0x000000262b297211ULL, 0x000fe200078e20ffULL,
0x0000000119237824ULL, 0x000fe200010e0623ULL, 0x000000244700720cULL, 0x080fe20003f86070ULL,
0x0000000141207824ULL, 0x002fe200078e0208ULL, 0x000000244f00720cULL, 0x080fe20003f46070ULL,
0x0000000141217824ULL, 0x100fe200078e0227ULL, 0x0000000022297faeULL, 0x0003e2000c101c46ULL,
0x0000000145257824ULL, 0x000fe200078e0227ULL, 0xfffffff843437812ULL, 0x000fe200078ee220ULL,
0x0000010021207825ULL, 0x000fe200078e001aULL, 0x000000245100720cULL, 0x000fc40003f26070ULL,
0x00000027472b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000145287824ULL, 0x100fe200078e0208ULL,
0x0000002018207210ULL, 0x000fe20007f1e0ffULL, 0x00000001472a7824ULL, 0x000fe200078e0208ULL,
0x000000034d417819ULL, 0x000fe200000006ffULL, 0x0000000845457824ULL, 0x000fe400078e00ffULL,
0x0000000847477824ULL, 0x000fe400078e00ffULL, 0x0000010025247825ULL, 0x000fe200078e001aULL,
0xfffffff845457812ULL, 0x000fc400078ee228ULL, 0xfffffff847477812ULL, 0x000fe200078ee22aULL,
0x0000000119217824ULL, 0x000fe200000e0621ULL, 0x0000002418227210ULL, 0x002fe20007f1e0ffULL,
0x000001002b287825ULL, 0x000fc800078e001aULL, 0x000000014d2a7824ULL, 0x140fe400078e0208ULL,
0x000000014d2b7824ULL, 0x000fe400078e0227ULL, 0x0000000119237824ULL, 0x000fe200000e0625ULL,
0x0000002818247210ULL, 0x000fe20007f1e0ffULL, 0x000000014f427824ULL, 0x000fe200078e0208ULL,
0xfffffff8414d7812ULL, 0x000fe200078ee22aULL, 0x000001002b2a7825ULL, 0x000fc800078e001aULL,
0x000000014f417824ULL, 0x000fe200078e0227ULL, 0x0000002751277210ULL, 0x000fe20007ffe0ffULL,
0x0000000119257824ULL, 0x000fe200000e0629ULL, 0x0000002a18287210ULL, 0x000fe20007f1e0ffULL,
0x0000010041407825ULL, 0x000fc600078e001aULL, 0x0000002b19297210ULL, 0x000fe200007fe4ffULL,
0x000000084f4f7824ULL, 0x000fe200078e00ffULL, 0x00000040182a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000151447824ULL, 0x040fe400078e0208ULL, 0x0000000851517824ULL, 0x000fe200078e00ffULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee242ULL, 0x00000100271a7825ULL, 0x000fc600078e001aULL,
0xfffffff851517812ULL, 0x000fe200078ee244ULL, 0x00000001192b7824ULL, 0x000fe200000e0641ULL,
0x0000001a18187210ULL, 0x000fe20007f1e0ffULL, 0x0000001043277824ULL, 0x100fe400078e0226ULL,
0x0000001045417824ULL, 0x100fe200078e0226ULL, 0x000000264d457211ULL, 0x000fe200078e20ffULL,
0x0000001047437824ULL, 0x100fe200078e0226ULL, 0x0000000020277faeULL, 0x0003e2000f101c46ULL,
0x000000104f477824ULL, 0x100fe400078e0226ULL, 0x00000010514d7824ULL, 0x000fe200078e0226ULL,
0x0000000022417faeULL, 0x0003e2000e901c46ULL, 0x0000000119197824ULL, 0x000fc600000e061bULL,
0x0000000024437faeULL, 0x0003e8000e101c46ULL, 0x0000000028457faeULL, 0x0003e8000d901c46ULL,
0x000000002a477faeULL, 0x0003e8000d101c46ULL, 0x00000000184d7faeULL, 0x0003e2000c901c46ULL,
0x00000004006c7947ULL, 0x000fea0003800000ULL, 0x00000004081a7819ULL, 0x000fe200000006ffULL,
0x00000080481b7824ULL, 0x000fe200078e00ffULL, 0x0000000808257811ULL, 0x000fe200078fe8ffULL,
0x0000200048207824ULL, 0x000fe200078e00ffULL, 0x0000000408237811ULL, 0x000fe200078fe8ffULL,
0x0000400055557824ULL, 0x000fe200078e0207ULL, 0x000000701a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000000825247824ULL, 0x000fe200078e00ffULL, 0x0000000c08297811ULL, 0x040fe200078fe8ffULL,
0x0000000123217824ULL, 0x140fe200078e0208ULL, 0x000000801a1a7812ULL, 0x000fe200078ef81bULL,
0x0000000823227824ULL, 0x000fe200078e00ffULL, 0x00000008251b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000829267824ULL, 0x000fe200078e00ffULL, 0x00000010082b7811ULL, 0x040fe200078fe8ffULL,
0x0000000123237824ULL, 0x100fe200078e0227ULL, 0xfffffff824477812ULL, 0x000fe200078ee21bULL,
0x0000000125257824ULL, 0x100fe200078e0227ULL, 0xfffffff822457812ULL, 0x000fe200078ee221ULL,
0x0000000129217824ULL, 0x100fe200078e0208ULL, 0x00000008081b7211ULL, 0x040fe200078fe8ffULL,
0x000000012b227824ULL, 0x000fe200078e0208ULL, 0x0000001408417811ULL, 0x040fe200078fe8ffULL,
0x0000000129297824ULL, 0x000fe200078e0227ULL, 0x0000001c08577811ULL, 0x000fc400078fe8ffULL,
0x0000200020207812ULL, 0x000fe400078ec0ffULL, 0x000000032b4f7819ULL, 0x000fe200000006ffULL,
0x00000008575b7824ULL, 0x000fe200078e00ffULL, 0x0000001808537811ULL, 0x040fe400078fe8ffULL,
0x000000071b1b7812ULL, 0x000fe400078ec0ffULL, 0xfffffff8264d7812ULL, 0x000fe200078ee221ULL,
0x0000000141217824ULL, 0x000fe200078e0208ULL, 0x0001400055207810ULL, 0x000fe20007ffe020ULL,
0x0000000841267824ULL, 0x000fe200078e00ffULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee222ULL,
0x0000000153227824ULL, 0x040fe200078e0208ULL, 0x0000000857247210ULL, 0x000fe20007ffe0ffULL,
0x0000000853557824ULL, 0x000fe200078e00ffULL, 0x0ffffff81b1b7812ULL, 0x000fe200078ef808ULL,
0x0000001047477824ULL, 0x100fe200078e0220ULL, 0xfffffff826517812ULL, 0x000fe200078ee221ULL,
0x000000104d4d7824ULL, 0x100fe200078e0220ULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee224ULL,
0x000000101b437824ULL, 0x100fe200078e0220ULL, 0xfffffff855557812ULL, 0x000fe200078ee222ULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x0000002708217211ULL, 0x000fe200078fe8ffULL,
0x000000104f4f7824ULL, 0x100fe200078e0220ULL, 0x0000002045457211ULL, 0x080fe200078e20ffULL,
0x0000001051517824ULL, 0x100fe200078e0220ULL, 0x0000002055557211ULL, 0x000fe200078e20ffULL,
0x000000105b5b7824ULL, 0x000fe200078e0220ULL, 0x000000272b2b7210ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fc800078e001aULL, 0x0000010023227825ULL, 0x000fe200078e001aULL,
0x0000002018207210ULL, 0x000fc60007f1e0ffULL, 0x0000000141417824ULL, 0x100fe200078e0227ULL,
0x0000002218227210ULL, 0x000fe20007f3e0ffULL, 0x0000000153537824ULL, 0x100fe400078e0227ULL,
0x0000000157577824ULL, 0x000fe400078e0227ULL, 0x0000010025247825ULL, 0x000fc800078e001aULL,
0x0000010029267825ULL, 0x000fe200078e001aULL, 0x0000002418247210ULL, 0x000fc60007f5e0ffULL,
0x000001002b287825ULL, 0x100fe200078e001aULL, 0x0000002618267210ULL, 0x000fe40007f7e0ffULL,
0x0000002519257210ULL, 0x000fe200017fe4ffULL, 0x00000100412a7825ULL, 0x000fc800078e001aULL,
0x0000010053407825ULL, 0x000fc800078e001aULL, 0x00000100571a7825ULL, 0x000fe200078e001aULL,
0x0000004018407210ULL, 0x000fc60007f5e0ffULL, 0x0000000119217824ULL, 0x040fe200000e0621ULL,
0x0000002818287210ULL, 0x000fe20007f1e0ffULL, 0x0000000119237824ULL, 0x040fe200008e0623ULL,
0x0000002a182a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000119277824ULL, 0x040fe200018e0627ULL,
0x0000001a18187210ULL, 0x000fe20007f7e0ffULL, 0x0000000119297824ULL, 0x040fe200000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020437faeULL, 0x0003e2000b901c46ULL,
0x00000001192b7824ULL, 0x040fe400008e062bULL, 0x0000000119417824ULL, 0x000fe200010e0641ULL,
0x0000000022457faeULL, 0x0003e2000b901c46ULL, 0x0000001b19197210ULL, 0x000fc60001ffe4ffULL,
0x0000000024477faeULL, 0x0003e8000b901c46ULL, 0x00000000264d7faeULL, 0x0003e8000b901c46ULL,
0x00000000284f7faeULL, 0x0003e8000b901c46ULL, 0x000000002a517faeULL, 0x0003e8000b901c46ULL,
0x0000000040557faeULL, 0x0003e8000b901c46ULL, 0x00000000185b7faeULL, 0x0003e4000b901c46ULL,
0x0000000158197812ULL, 0x002fe200078ec0ffULL, 0xffffffffff5d7424ULL, 0x000fe200078e00ffULL,
0xffffffff0a187811ULL, 0x000fe200078e08ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000011900780cULL, 0x000fc80003f05070ULL, 0x0000000118197807ULL, 0x000fca0004000000ULL,
0x0000000119587824ULL, 0x000fca00078e0258ULL, 0x000000065800720cULL, 0x000fda0003f06070ULL,
0x00009000ff188b82ULL, 0x000e620000000a00ULL, 0x000000010b1b8824ULL, 0x000fe200078e0258ULL,
0xffffffe0041a7812ULL, 0x040fe400078ec0ffULL, 0x0000000100207802ULL, 0x000fe20000000f00ULL,
0x000000041b188825ULL, 0x002fe200078e0018ULL, 0x00000010041b7812ULL, 0x000fc800078ec0ffULL,
0x000000071b1a7210ULL, 0x000fe20007ffe01aULL, 0x00000006185d8981ULL, 0x000322000c1e1900ULL,
0x00000008041b7812ULL, 0x000fca00078ec0ffULL, 0x000000011a237824ULL, 0x000fc800078e021bULL,
0x01b60820232079a7ULL, 0x0002a6000850003fULL, 0x0000000000187805ULL, 0x002fce0000015200ULL,
0x01b60821230075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff227224ULL, 0x000fce00078e00ffULL, 0x000000102200780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x0000001a18257210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x000000251a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000122227836ULL, 0x000fce0000000000ULL, 0x01b60821230075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000548187819ULL, 0x000fe200000006ffULL,
0x0000001008447824ULL, 0x000fe200078e00ffULL, 0x00000001ff537819ULL, 0x000fe20000011608ULL,
0x000000ffff5c7224ULL, 0x000fe200078e0056ULL, 0xffffff8018187812ULL, 0x000fe400078ec0ffULL,
0x0000007044447812ULL, 0x000fe400078ec0ffULL, 0x0000000c53537812ULL, 0x000fe200078ec0ffULL,
0x0000000107547824ULL, 0x000fca00078e0218ULL, 0x0000005453187210ULL, 0x000fca0007ffe044ULL,
0x01b0000018197984ULL, 0x000e680000000800ULL, 0x01b20000185b7984ULL, 0x0004a20000000800ULL,
0x000000561900720bULL, 0x002fda0003f1d000ULL, 0x00000000001a7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff1a1a7812ULL, 0x000fda000782c0ffULL,
0x0000000000f09947ULL, 0x004fea0003800000ULL, 0x00000002ff1b7819ULL, 0x000fe40000011648ULL,
0x000000561900720bULL, 0x000fe40003f14000ULL, 0x000000481b00720cULL, 0x000fe40003f25270ULL,
0x00000056195c7209ULL, 0x000fd20007810000ULL, 0x0000000000217806ULL, 0x000fe400000e0100ULL,
0x0000008048189824ULL, 0x000fca00078e0207ULL, 0x00000018531b9210ULL, 0x000fe40007ffe044ULL,
0x0000991021187816ULL, 0x000fc600000000ffULL, 0x01b4005c1b009388ULL, 0x0003e20000000800ULL,
0x000000ff1800720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x000000565c187221ULL, 0x000fe20000010100ULL, 0x000000ff21ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0021ff7812ULL, 0x000fe2000782c0ffULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x00000018001b7308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff187819ULL, 0x002fcc0000011608ULL, 0x00001f181b187589ULL, 0x004e6400000e0000ULL,
0x000000182c2c7220ULL, 0x082fe20000410000ULL, 0x000000182d2d7220ULL, 0x080fe20000410000ULL,
0x0000001830307220ULL, 0x080fe20000410000ULL, 0x0000001831317220ULL, 0x080fe20000410000ULL,
0x0000001834347220ULL, 0x080fe20000410000ULL, 0x0000001835357220ULL, 0x080fe20000410000ULL,
0x0000001838387220ULL, 0x080fe20000410000ULL, 0x0000001839397220ULL, 0x080fe20000410000ULL,
0x000000183c3c7220ULL, 0x080fe20000410000ULL, 0x000000183d3d7220ULL, 0x080fe20000410000ULL,
0x0000001810107220ULL, 0x080fe20000410000ULL, 0x0000001811117220ULL, 0x080fe20000410000ULL,
0x0000001814147220ULL, 0x080fe20000410000ULL, 0x0000001815157220ULL, 0x080fe20000410000ULL,
0x000000181c1c7220ULL, 0x080fe20000410000ULL, 0x000000181d1d7220ULL, 0x000fce0000410000ULL,
0x0000001b59597220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000808187811ULL, 0x002fcc00078ff0ffULL, 0x00001f181b187589ULL, 0x000e6400000e0000ULL,
0x000000182e2e7220ULL, 0x082fe20000410000ULL, 0x000000182f2f7220ULL, 0x080fe20000410000ULL,
0x0000001832327220ULL, 0x080fe20000410000ULL, 0x0000001833337220ULL, 0x080fe20000410000ULL,
0x0000001836367220ULL, 0x080fe20000410000ULL, 0x0000001837377220ULL, 0x080fe20000410000ULL,
0x000000183a3a7220ULL, 0x080fe20000410000ULL, 0x000000183b3b7220ULL, 0x080fe20000410000ULL,
0x000000183e3e7220ULL, 0x080fe20000410000ULL, 0x000000183f3f7220ULL, 0x080fe20000410000ULL,
0x0000001812127220ULL, 0x080fe20000410000ULL, 0x0000001813137220ULL, 0x080fe20000410000ULL,
0x0000001816167220ULL, 0x080fe20000410000ULL, 0x0000001817177220ULL, 0x080fe20000410000ULL,
0x000000181e1e7220ULL, 0x080fe20000410000ULL, 0x000000181f1f7220ULL, 0x000fce0000410000ULL,
0x0000ffff1aff7812ULL, 0x000fda0007806021ULL, 0x8000005c19190221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b19190820ULL, 0x000fc80000410000ULL, 0x00000019000c0308ULL, 0x000ea40000000800ULL,
0x0000000c5b5b0220ULL, 0x004fce0000410000ULL, 0x0000000708517812ULL, 0x000fe200078ec0ffULL,
0x00000002485e7824ULL, 0x000fe200078e00ffULL, 0x00000008084e7812ULL, 0x000fe200078ec0ffULL,
0x0000020048187824ULL, 0x002fe200078e00ffULL, 0x00000004ff607819ULL, 0x000fe20000011608ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000514e1b7212ULL, 0x000fe400078efcffULL,
0x00000008514d7812ULL, 0x000fe400078ef808ULL, 0x0000001b601a7210ULL, 0x000fe20007ffe0ffULL,
0x000000081b197824ULL, 0x040fe200078e00ffULL, 0x00000001ff577819ULL, 0x000fe20000011648ULL,
0x000000081b477824ULL, 0x000fe200078e00ffULL, 0xfffff80018187812ULL, 0x000fe200078ec0ffULL,
0x000000021a467836ULL, 0x000fe20000000000ULL, 0x00000007575a7211ULL, 0x000fe200078e70ffULL,
0x000000041a457836ULL, 0x000fe20000000000ULL, 0xfffffff847477812ULL, 0x000fe200078ee21aULL,
0x00000001074f7824ULL, 0x000fe200078e0218ULL, 0xfffffff819467812ULL, 0x000fe200078ee246ULL,
0x000000081b187824ULL, 0x040fe200078e00ffULL, 0x000000045e197812ULL, 0x000fe200078ec0ffULL,
0x000000081b1b7824ULL, 0x000fc400078e00ffULL, 0x000000061a507836ULL, 0x000fe20000000000ULL,
0x0000001908527211ULL, 0x000fe200078fe0ffULL, 0x00002000005f7824ULL, 0x000fe200078e025aULL,
0x000000034d197819ULL, 0x040fe400000006ffULL, 0xfffffff818457812ULL, 0x000fe200078ee245ULL,
0x000000014d527824ULL, 0x000fe200078e0252ULL, 0xfffffff81b507812ULL, 0x000fe400078ee250ULL,
0x000130005f5f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff819567812ULL, 0x000fca00078ee252ULL,
0x0000001056567824ULL, 0x000fe200078e024fULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff1b7819ULL, 0x000fe40000011608ULL, 0x0000000cff0d723eULL, 0x000fc600000010ffULL,
0x000000081b197836ULL, 0x000fe20000000000ULL, 0x000054100d187816ULL, 0x000fca000000000dULL,
0x00001f1b180d7589ULL, 0x0002a800000e0000ULL, 0x00001f19180e7589ULL, 0x0002e400000e0000ULL,
0x011000005618783bULL, 0x0022e20000000200ULL, 0x0000001047557824ULL, 0x100fe200078e025fULL,
0x0000005f45287211ULL, 0x000fe200078e20ffULL, 0x0000001046407824ULL, 0x000fe200078e025fULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000d18187232ULL, 0x08cfe40000200000ULL,
0x0000000d1a1a7232ULL, 0x000fe40000200000ULL, 0x0000000e19197232ULL, 0x080fe40000200000ULL,
0x0000000e1b1b7232ULL, 0x000fce0000200000ULL, 0x0000001050207824ULL, 0x000fe200078e025fULL,
0x000000002828783bULL, 0x000f620000004200ULL, 0x0000000457607824ULL, 0x000fc600078e0260ULL,
0x000000005524783bULL, 0x000b680000004200ULL, 0x000000002020783bULL, 0x000f680000004200ULL,
0x000000004040783bULL, 0x000f640000004200ULL, 0x0000000260557810ULL, 0x028fe20007ffe04dULL,
0x00000028183c723cULL, 0x002fec000004183cULL, 0x00000024182c723cULL, 0x004fe2000004182cULL,
0x000000104e297812ULL, 0x000fe200078efe51ULL, 0x000000084d287824ULL, 0x000fc800078e00ffULL,
0x000000201814723cULL, 0x000fe20000041814ULL, 0xfffffff828557812ULL, 0x000fe200078ee255ULL,
0x0000000829517824ULL, 0x000fc800078e00ffULL, 0x000000401834723cULL, 0x000fe20000041834ULL,
0x0000002908207211ULL, 0x000fe200078fe0ffULL, 0x0000000829217824ULL, 0x000fc600078e00ffULL,
0xfffffff851517812ULL, 0x000fe200078ee220ULL, 0x000000421838723cULL, 0x000fe20000041838ULL,
0x00000002204e7836ULL, 0x000fe40000000000ULL, 0x00000004204d7836ULL, 0x000fc60000000000ULL,
0x0000002a1810723cULL, 0x000fe20000041810ULL, 0xfffffff8214e7812ULL, 0x000fca00078ee24eULL,
0x000000261824723cULL, 0x000fe20000041830ULL, 0x00000003292a7819ULL, 0x000fe200000006ffULL,
0x000000104e407824ULL, 0x000fc600078e025fULL, 0xfffffff82a4d7812ULL, 0x000fe200078ee24dULL,
0x00000022181c723cULL, 0x000fe2000004181cULL, 0x00000010512a7824ULL, 0x000fc600078e025fULL,
0x000000104d307824ULL, 0x000fc600078e025fULL, 0x0000004f55187211ULL, 0x000fe200078e20ffULL,
0x0000000829227824ULL, 0x000fe400078e00ffULL, 0x00000006204f7836ULL, 0x000fc60000000000ULL,
0x011000001818783bULL, 0x000e620000000200ULL, 0x0000000000108947ULL, 0x000ff40003800000ULL,
0x0000000d18187232ULL, 0x082fe40000200000ULL, 0x0000000d1a1a7232ULL, 0x000fe40000200000ULL,
0x0000000e19197232ULL, 0x080fe40000200000ULL, 0x0000000e1b1b7232ULL, 0x000fce0000200000ULL,
0xfffffff8224f7812ULL, 0x000fe200078ee24fULL, 0x000000002a28783bULL, 0x000ea20000004200ULL,
0xfffffff85e5e7812ULL, 0x000fe200078ec0ffULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000005f4f207211ULL, 0x000fe200078e20ffULL, 0x000000004040783bULL, 0x000ee20000004200ULL,
0x000000045d5d7c24ULL, 0x010fe4000f8e02ffULL, 0x000000595b5b7221ULL, 0x000fe20000010000ULL,
0x000000003030783bULL, 0x000f240000004200ULL, 0x000000075d5d7819ULL, 0x000fc400000006ffULL,
0x000000002020783bULL, 0x000f620000004200ULL, 0x00000028182c723cULL, 0x006fe2000004182cULL,
0x00008e00ff287b82ULL, 0x000e6a0000000a00ULL, 0x000000401834723cULL, 0x008fec0000041834ULL,
0x000000421838723cULL, 0x000fe20000041838ULL, 0x00000001ff407424ULL, 0x000fca00078e00ffULL,
0x00000030183c723cULL, 0x010fec000004183cULL, 0x000000321810723cULL, 0x000fec0000041810ULL,
0x0000002a1824723cULL, 0x000fec0000041824ULL, 0x000000201814723cULL, 0x020fec0000041814ULL,
0x000000221818723cULL, 0x000fe2000004181cULL, 0x0000000107217824ULL, 0x000fc400078e025eULL,
0x000001005d5e7825ULL, 0x002fe400078e0028ULL, 0x01b6884021ff79a7ULL, 0x0003e4000850003fULL,
0x000000014c1e7836ULL, 0x000fe40000000000ULL, 0x000000084c1c7824ULL, 0x000fc600078e0257ULL,
0x000000051e00720cULL, 0x000fe40003f06070ULL, 0x000000801c1c7811ULL, 0x000fc800078e28ffULL,
0x000000601c317812ULL, 0x000fca00078ec0ffULL, 0x0000000102317824ULL, 0x000fe200078e0231ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400948947ULL, 0x002fea0003800000ULL,
0x00000003ff437819ULL, 0x000fe20000011608ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0a1cULL,
0x0000001c0f307248ULL, 0x000fe20007fe0000ULL, 0x00002000481e7824ULL, 0x040fe200078e00ffULL,
0x0000000843597810ULL, 0x000fe20007ffe0ffULL, 0x0000000443237836ULL, 0x000fe20000000000ULL,
0x0000002030307446ULL, 0x000fe2000380001dULL, 0x00000080481f7824ULL, 0x000fe200078e00ffULL,
0x000020001e217812ULL, 0x000fe200078ec0ffULL, 0x0000000823417824ULL, 0x000fe200078e00ffULL,
0x00000008231c7210ULL, 0x000fe20007ffe0ffULL, 0x00000001431d7824ULL, 0x000fe200078e0208ULL,
0x000130005a5a7810ULL, 0x000fe20007ffe021ULL, 0x0000000c435d7836ULL, 0x000fe20000000000ULL,
0xfffffff841417812ULL, 0x000fe200078ee21cULL, 0x0000000123217824ULL, 0x100fe200078e0231ULL,
0x00000080441c7812ULL, 0x000fe200078ef81fULL, 0x00000001431f7824ULL, 0x100fe200078e0231ULL,
0x000000071d2b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x000000302300720cULL, 0x080fe20003f26070ULL, 0x0000000159297824ULL, 0x000fe200078e0231ULL,
0x000000315d237210ULL, 0x000fe20007ffe0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e001cULL,
0x000000304300720cULL, 0x000fc40003f06070ULL, 0x0ffffff82b2b7812ULL, 0x000fe200078ef808ULL,
0x0000010021207825ULL, 0x100fe200078e001cULL, 0x0000001e5e1e7210ULL, 0x000fe40007f5e0ffULL,
0x0000005a41417211ULL, 0x000fe200078e20ffULL, 0x0000010029287825ULL, 0x100fe200078e001cULL,
0x000000205e207210ULL, 0x000fe40007f7e0ffULL, 0x000000305900720cULL, 0x000fe20003fa6070ULL,
0x0000010023227825ULL, 0x000fe200078e001cULL, 0x0000001c43677810ULL, 0x000fc40007ffe0ffULL,
0x000000305d00720cULL, 0x080fe20003f86070ULL, 0x000000015f1f7824ULL, 0x040fe200010e061fULL,
0x000000285e2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000015f217824ULL, 0x000fe200018e0621ULL,
0x000000225e287210ULL, 0x000fe20007f7e0ffULL, 0x0000001043617836ULL, 0x000fe40000000000ULL,
0x000000102b337824ULL, 0x000fe400078e025aULL, 0x000000015f2b7824ULL, 0x040fe400010e0629ULL,
0x000000015f297824ULL, 0x000fe200018e0623ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e337faeULL, 0x0003e2000c101c46ULL, 0x0000000161237824ULL, 0x040fe200078e0231ULL,
0x000000306100720cULL, 0x080fe20003f66070ULL, 0x0000001443637836ULL, 0x000fe20000000000ULL,
0x0000000020417faeULL, 0x0005e2000c901c46ULL, 0x0000000159327824ULL, 0x000fe200078e0208ULL,
0x000000306700720cULL, 0x080fe20003f06070ULL, 0x0000000859597824ULL, 0x000fe200078e00ffULL,
0x000000306300720cULL, 0x000fe20003f46070ULL, 0x0000001843657836ULL, 0x000fc40000000000ULL,
0x00000100231e7825ULL, 0x002fc600078e001cULL, 0x000000306500720cULL, 0x000fe20003f26070ULL,
0x0000000163217824ULL, 0x004fe200078e0231ULL, 0x0000001e5e227210ULL, 0x000fe20007fde0ffULL,
0x000000015d337824ULL, 0x040fe200078e0208ULL, 0x000000035d207819ULL, 0x000fe200000006ffULL,
0x00000008635d7824ULL, 0x000fe200078e00ffULL, 0xfffffff859417812ULL, 0x000fe200078ee232ULL,
0x000000015f237824ULL, 0x000fe200030e061fULL, 0xfffffff820437812ULL, 0x000fe200078ee233ULL,
0x00000100211e7825ULL, 0x000fe200078e001cULL, 0x0000000863307210ULL, 0x000fc60007ffe0ffULL,
0x0000000161217824ULL, 0x040fe200078e0208ULL, 0x0000001e5e207210ULL, 0x000fe20007fde0ffULL,
0x0000000861327824ULL, 0x000fe200078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee230ULL,
0x0000000165337824ULL, 0x100fe200078e0231ULL, 0x0000000865307210ULL, 0x000fe20007ffe0ffULL,
0x0000000167317824ULL, 0x000fe200078e0231ULL, 0xfffffff832597812ULL, 0x000fe200078ee221ULL,
0x000000015f217824ULL, 0x000fe400030e061fULL, 0x00000100331e7825ULL, 0x000fc800078e001cULL,
0x0000000865617824ULL, 0x000fe200078e00ffULL, 0x0000001e5e1e7210ULL, 0x000fe20007fde0ffULL,
0x00000100311c7825ULL, 0x000fe200078e001cULL, 0x0000005a41317211ULL, 0x000fe400078e20ffULL,
0xfffffff861617812ULL, 0x000fe200078ee230ULL, 0x0000000167327824ULL, 0x040fe400078e0208ULL,
0x0000000867637824ULL, 0x000fe200078e00ffULL, 0x000000002a317faeULL, 0x0003e2000e901c46ULL,
0x000000015f1f7824ULL, 0x000fe200030e061fULL, 0x0000001c5e1c7210ULL, 0x000fe20007fde0ffULL,
0x0000001043337824ULL, 0x100fe200078e025aULL, 0xfffffff863637812ULL, 0x000fe200078ee232ULL,
0x0000001059417824ULL, 0x000fc400078e025aULL, 0x000000105d437824ULL, 0x100fe200078e025aULL,
0x0000005a635d7211ULL, 0x000fe200078e20ffULL, 0x0000001061597824ULL, 0x000fe200078e025aULL,
0x0000000028337faeULL, 0x0003e2000e101c46ULL, 0x000000015f1d7824ULL, 0x000fc600030e061dULL,
0x0000000022417faeULL, 0x0003e8000d901c46ULL, 0x0000000020437faeULL, 0x0003e8000d101c46ULL,
0x000000001e597faeULL, 0x0003e8000c901c46ULL, 0x000000001c5d7faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x00002000481c7824ULL, 0x000fe200078e00ffULL,
0x00000004081f7811ULL, 0x040fe400078fe8ffULL, 0x0000000808217811ULL, 0x000fe400078fe8ffULL,
0x000020001c1d7812ULL, 0x000fe200078ec0ffULL, 0x000000011f617824ULL, 0x140fe200078e0208ULL,
0x0000000c08237811ULL, 0x040fe200078fe8ffULL, 0x000000081f1c7824ULL, 0x040fe200078e00ffULL,
0x0000001008297811ULL, 0x000fe200078fe8ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0231ULL,
0x00000008215d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000123597824ULL, 0x100fe200078e0208ULL,
0xfffffff81c617812ULL, 0x000fe200078ee261ULL, 0x00000008211c7824ULL, 0x000fe200078e00ffULL,
0x000130005a5a7810ULL, 0x000fe20007ffe01dULL, 0x00000008231e7824ULL, 0x000fe200078e00ffULL,
0x0000000329207819ULL, 0x040fe200000006ffULL, 0x0000000129437824ULL, 0x000fe200078e0208ULL,
0xfffffff81c5d7812ULL, 0x000fe200078ee25dULL, 0x00000080481d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e597812ULL, 0x000fe200078ee259ULL, 0x0000000123237824ULL, 0x100fe200078e0231ULL,
0x00000008081c7211ULL, 0x040fe200078fe8ffULL, 0x0000000129297824ULL, 0x100fe200078e0231ULL,
0x00000018081e7811ULL, 0x000fe200078fe8ffULL, 0x0000001061617824ULL, 0x100fe200078e025aULL,
0xfffffff820437812ULL, 0x000fe200078ee243ULL, 0x000000105d5d7824ULL, 0x100fe200078e025aULL,
0x000000071c677812ULL, 0x000fe200078ec0ffULL, 0x000000081e207824ULL, 0x040fe200078e00ffULL,
0x00000080441c7812ULL, 0x000fe200078ef81dULL, 0x000000011e637824ULL, 0x000fe200078e0231ULL,
0x000000081e1d7210ULL, 0x000fe20007ffe0ffULL, 0x0000001059597824ULL, 0x000fe200078e025aULL,
0x0000001c08657811ULL, 0x000fc400078fe8ffULL, 0x00000014082b7811ULL, 0x040fe400078fe8ffULL,
0xfffffff820697812ULL, 0x000fe200078ee21dULL, 0x00000001651e7824ULL, 0x140fe200078e0208ULL,
0x0000003108337211ULL, 0x000fe200078fe8ffULL, 0x00000008656b7824ULL, 0x000fe200078e00ffULL,
0x000000ff001d7202ULL, 0x000fe20000000f00ULL, 0x000000012b417824ULL, 0x040fe200078e0208ULL,
0x0000003121217210ULL, 0x000fe20007ffe0ffULL, 0x000000082b227824ULL, 0x000fe200078e00ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee21eULL, 0x0000010033327825ULL, 0x000fe200078e001cULL,
0x0ffffff867677812ULL, 0x000fc400078ef808ULL, 0xfffffff822417812ULL, 0x000fe200078ee241ULL,
0x000001001f1e7825ULL, 0x000fe200078e001cULL, 0x000000325e327210ULL, 0x000fe40007f1e0ffULL,
0x0000005a43437211ULL, 0x000fe200078e20ffULL, 0x000000012b2b7824ULL, 0x000fe200078e0231ULL,
0x0000001e5e1e7210ULL, 0x000fe20007f3e0ffULL, 0x0000010021207825ULL, 0x000fc600078e001cULL,
0x0000001f5f1f7210ULL, 0x000fe20000ffe4ffULL, 0x0000010023227825ULL, 0x000fe200078e001cULL,
0x000000205e207210ULL, 0x000fc60007f5e0ffULL, 0x0000000165657824ULL, 0x000fe200078e0231ULL,
0x000000225e227210ULL, 0x000fe20007f7e0ffULL, 0x0000010029287825ULL, 0x000fc800078e001cULL,
0x000001002b2a7825ULL, 0x000fc800078e001cULL, 0x0000010063307825ULL, 0x000fe200078e001cULL,
0x0000002a5e2a7210ULL, 0x000fc60007f3e0ffULL, 0x00000100651c7825ULL, 0x000fc800078e001cULL,
0x000000015f337824ULL, 0x000fe200000e0633ULL, 0x000000285e287210ULL, 0x000fe20007f1e0ffULL,
0x0000001067637824ULL, 0x100fe400078e025aULL, 0x000000015f217824ULL, 0x040fe200010e0621ULL,
0x000000305e307210ULL, 0x000fe20007f5e0ffULL, 0x000000015f237824ULL, 0x040fe200018e0623ULL,
0x0000001c5e1c7210ULL, 0x000fe20007f7e0ffULL, 0x000000015f297824ULL, 0x000fe200000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032637faeULL, 0x0003e2000b901c46ULL,
0x0000001041417824ULL, 0x100fe200078e025aULL, 0x000000315f317210ULL, 0x000fe200017fe4ffULL,
0x000000015f2b7824ULL, 0x000fe200008e062bULL, 0x000000001e617faeULL, 0x0003e2000b901c46ULL,
0x0000001069657824ULL, 0x000fc400078e025aULL, 0x000000106b677824ULL, 0x000fe200078e025aULL,
0x00000000205d7faeULL, 0x0003e2000b901c46ULL, 0x000000015f1d7824ULL, 0x000fc600018e061dULL,
0x0000000022597faeULL, 0x0003e8000b901c46ULL, 0x0000000028437faeULL, 0x0003e8000b901c46ULL,
0x000000002a417faeULL, 0x0003e8000b901c46ULL, 0x0000000030657faeULL, 0x0003e8000b901c46ULL,
0x000000001c677faeULL, 0x0003e4000b901c46ULL, 0xffffffe0041c7812ULL, 0x042fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010041d7812ULL, 0x040fe400078ec0ffULL,
0x00000008041e7812ULL, 0x000fe400078ec0ffULL, 0x000000071d1d7210ULL, 0x000fca0007ffe01cULL,
0x000000011d237824ULL, 0x000fc800078e021eULL, 0x01b62840234079a7ULL, 0x0002a6000850003fULL,
0x00000000001c7805ULL, 0x000fce0000015200ULL, 0x01b62841230075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff207224ULL, 0x000fce00078e00ffULL,
0x000000102000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fce0000015200ULL, 0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000211e1e7211ULL, 0x000fc800078110ffULL, 0x0000001fff1f7210ULL, 0x000fc800007fe4ffULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000120207836ULL, 0x000fce0000000000ULL,
0x01b62841230075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000080441c7810ULL, 0x000fe20007ffe054ULL, 0x000000ffff597224ULL, 0x000fc800078e005cULL,
0x00000001531c7824ULL, 0x000fca00078e021cULL, 0x01b000001c1d7984ULL, 0x000ea80000000800ULL,
0x01b200001c5a7984ULL, 0x0006e20000000800ULL, 0x0000005c1d00720bULL, 0x004fda0003f1d000ULL,
0x00000000001e7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1e207812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x00afea0003800000ULL,
0x00000001481f7811ULL, 0x000fe400078ff0ffULL, 0x0000005c1d00720bULL, 0x000fe40003f14000ULL,
0x000000481f00720cULL, 0x000fd60003f25270ULL, 0x00000000001f7806ULL, 0x000fe400000e0100ULL,
0x00000080481e9824ULL, 0x000fe200078e0207ULL, 0x0000005c1d1c9209ULL, 0x000fc80007810000ULL,
0x0000001e53219210ULL, 0x000fe40007ffe044ULL, 0x000099101f1e7816ULL, 0x000fc600000000ffULL,
0x01b4001c21009388ULL, 0x0003e20000000800ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005c1d217209ULL, 0x000fe40007810000ULL,
0x000000ff1fff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001fff7812ULL, 0x000fe2000782c0ffULL,
0x0000005c211c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL,
0x0000001c001e7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x000fca0000011608ULL, 0x00001f211e1c7589ULL, 0x006e6400000e0000ULL,
0x0000002c1c2c7220ULL, 0x042fe20000410000ULL, 0x0000002d1c2d7220ULL, 0x040fe20000410000ULL,
0x000000241c247220ULL, 0x040fe20000410000ULL, 0x000000251c257220ULL, 0x040fe20000410000ULL,
0x000000341c347220ULL, 0x040fe20000410000ULL, 0x000000351c357220ULL, 0x040fe20000410000ULL,
0x000000381c387220ULL, 0x040fe20000410000ULL, 0x000000391c397220ULL, 0x040fe20000410000ULL,
0x0000003c1c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d1c3d7220ULL, 0x040fe20000410000ULL,
0x000000101c107220ULL, 0x040fe20000410000ULL, 0x000000111c117220ULL, 0x040fe20000410000ULL,
0x000000141c147220ULL, 0x040fe20000410000ULL, 0x000000151c157220ULL, 0x040fe20000410000ULL,
0x000000181c187220ULL, 0x040fe20000410000ULL, 0x000000191c197220ULL, 0x000fce0000410000ULL,
0x0000001e5b5b7220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000808217811ULL, 0x000fca00078ff0ffULL, 0x00001f211e1c7589ULL, 0x002e6400000e0000ULL,
0x0000002e1c2e7220ULL, 0x042fe20000410000ULL, 0x0000002f1c2f7220ULL, 0x040fe20000410000ULL,
0x000000261c267220ULL, 0x040fe20000410000ULL, 0x000000271c277220ULL, 0x040fe20000410000ULL,
0x000000361c367220ULL, 0x040fe20000410000ULL, 0x000000371c377220ULL, 0x040fe20000410000ULL,
0x0000003a1c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b1c3b7220ULL, 0x040fe20000410000ULL,
0x0000003e1c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f1c3f7220ULL, 0x040fe20000410000ULL,
0x000000121c127220ULL, 0x040fe20000410000ULL, 0x000000131c137220ULL, 0x040fe20000410000ULL,
0x000000161c167220ULL, 0x040fe20000410000ULL, 0x000000171c177220ULL, 0x040fe20000410000ULL,
0x0000001a1c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b1c1b7220ULL, 0x000fce0000410000ULL,
0x0000ffff20ff7812ULL, 0x000fe4000780601fULL, 0x0000005c1d597209ULL, 0x000fd60007810000ULL,
0x800000591d1d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL,
0x0000001d000c0308ULL, 0x000ea40000000800ULL, 0x0000000c5a5a0220ULL, 0x004fce0000410000ULL,
0x0000000757577211ULL, 0x000fe200078e70ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00002000005d7824ULL, 0x000fc800078e0257ULL, 0x000140005d5d7836ULL, 0x000fe20000000000ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff1d7819ULL, 0x000fe40000011608ULL,
0x0000000cff0d723eULL, 0x000fc600000010ffULL, 0x000000081d1f7836ULL, 0x000fe20000000000ULL,
0x000054100d1c7816ULL, 0x002fca000000000dULL, 0x00001f1d1c0d7589ULL, 0x0002a800000e0000ULL,
0x00001f1f1c0e7589ULL, 0x0002e400000e0000ULL, 0x01180000561c783bULL, 0x0022e20000000200ULL,
0x00000010475c7824ULL, 0x100fe200078e025dULL, 0x0000005d46407211ULL, 0x000fe200078e20ffULL,
0x0000001045287824ULL, 0x000fe200078e025dULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000d1c1c7232ULL, 0x08cfe40000200000ULL, 0x0000000d1e1e7232ULL, 0x000fe40000200000ULL,
0x0000000e1d1d7232ULL, 0x080fe40000200000ULL, 0x0000000e1f1f7232ULL, 0x000fce0000200000ULL,
0x000000005c30783bULL, 0x0009620000004200ULL, 0x0000001050207824ULL, 0x000fc600078e025dULL,
0x000000004040783bULL, 0x000f680000004200ULL, 0x000000002828783bULL, 0x000f620000004200ULL,
0x00000002ff5c7819ULL, 0x010fc60000011648ULL, 0x000000002020783bULL, 0x000f220000004200ULL,
0x000000301c2c723cULL, 0x02afec000004182cULL, 0x000000321c30723cULL, 0x000fec0000041824ULL,
0x000000401c34723cULL, 0x000fe20000041834ULL, 0x000008005c247824ULL, 0x000fc400078e0207ULL,
0x000000104d257824ULL, 0x000fe400078e025dULL, 0x0000001055247824ULL, 0x000fe200078e0224ULL,
0x000000421c38723cULL, 0x000fe20000041838ULL, 0x0000005d51407211ULL, 0x000fca00078e20ffULL,
0x000000281c3c723cULL, 0x004fec000004183cULL, 0x0000002a1c10723cULL, 0x000fe20000041810ULL,
0x000000104e287824ULL, 0x000fca00078e025dULL, 0x000000201c14723cULL, 0x010fec0000041814ULL,
0x000000221c18723cULL, 0x000fe20000041818ULL, 0x01180000241c783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000d1c1c7232ULL, 0x084fe40000200000ULL, 0x0000000d1e1e7232ULL, 0x000fe40000200000ULL,
0x0000000e1d1d7232ULL, 0x080fe40000200000ULL, 0x0000000e1f1f7232ULL, 0x000fce0000200000ULL,
0x000000104f207824ULL, 0x000fe200078e025dULL, 0x000000004040783bULL, 0x000ee20000004200ULL,
0x00000001ff557819ULL, 0x000fe20000011648ULL, 0x0000005b5a5a7221ULL, 0x000fe40000010000ULL,
0x000000002828783bULL, 0x000f280000004200ULL, 0x000000002524783bULL, 0x002e680000004200ULL,
0x000000002020783bULL, 0x000f620000004200ULL, 0x000000401c2c723cULL, 0x00cfec000004182cULL,
0x000000421c30723cULL, 0x000fe20000041830ULL, 0x00000001ff407424ULL, 0x000fca00078e00ffULL,
0x000000281c34723cULL, 0x010fec0000041834ULL, 0x0000002a1c38723cULL, 0x000fec0000041838ULL,
0x000000241c3c723cULL, 0x002fec000004183cULL, 0x000000261c10723cULL, 0x000fec0000041810ULL,
0x000000201c14723cULL, 0x020fec0000041814ULL, 0x000000221c18723cULL, 0x000fe20000041818ULL,
0x000000075c217211ULL, 0x000fc800078e18ffULL, 0x01b6904021ff79a7ULL, 0x0003e4000850003fULL,
0x000000014c1e7836ULL, 0x000fe40000000000ULL, 0x000000084c1c7824ULL, 0x000fc600078e0255ULL,
0x000000051e00720cULL, 0x000fe40003f06070ULL, 0x000000c01c1c7811ULL, 0x000fc800078e28ffULL,
0x000000601c297812ULL, 0x000fca00078ec0ffULL, 0x0000000102297824ULL, 0x000fe200078e0229ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400948947ULL, 0x002fea0003800000ULL,
0x00000003ff2b7819ULL, 0x000fe20000011608ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0a1cULL,
0x0000001c0f287248ULL, 0x000fe20007fe0000ULL, 0x0000008048277824ULL, 0x040fe200078e00ffULL,
0x000000042b1f7810ULL, 0x000fe20007ffe0ffULL, 0x00002000481e7824ULL, 0x000fe200078e00ffULL,
0x0000002028287446ULL, 0x000fe2000380001dULL, 0x000000012b1d7824ULL, 0x100fe200078e0229ULL,
0x0000008044267812ULL, 0x000fe200078ef827ULL, 0x000000011f1c7824ULL, 0x040fe200078e0208ULL,
0x000000ff00277202ULL, 0x000fe20000000f00ULL, 0x000000081f217824ULL, 0x040fe200078e00ffULL,
0x000020001e1e7812ULL, 0x000fe200078ec0ffULL, 0x000000082b5b7836ULL, 0x000fe20000000000ULL,
0x000000281f00720cULL, 0x040fe20003f26070ULL, 0x000000011f1f7824ULL, 0x100fe200078e0229ULL,
0xfffffff821427812ULL, 0x000fe200078ee21cULL, 0x0000000c2b5d7836ULL, 0x000fe20000000000ULL,
0x000000082b1c7210ULL, 0x000fe20007ffe0ffULL, 0x000000015b237824ULL, 0x000fe200078e0229ULL,
0x0001400057577810ULL, 0x000fe20007ffe01eULL, 0x000001001f1e7825ULL, 0x000fe200078e0026ULL,
0x000000071c257812ULL, 0x000fc400078ec0ffULL, 0x000000282b00720cULL, 0x080fe20003f06070ULL,
0x000001001d1c7825ULL, 0x000fe200078e0026ULL, 0x0000001e5e1e7210ULL, 0x000fe40007f7e0ffULL,
0x0ffffff8252a7812ULL, 0x000fe200078ef808ULL, 0x000000015d217824ULL, 0x000fe200078e0229ULL,
0x0000001c5e1c7210ULL, 0x000fe20007f5e0ffULL, 0x0000010023227825ULL, 0x100fe200078e0026ULL,
0x000000572a417211ULL, 0x000fe400078e20ffULL, 0x000000142b637810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e0026ULL, 0x000000285b00720cULL, 0x000fc40003fa6070ULL,
0x000000285d00720cULL, 0x080fe20003f86070ULL, 0x000000015f1d7824ULL, 0x040fe200010e061dULL,
0x000000225e247210ULL, 0x000fe20007f5e0ffULL, 0x000000015f1f7824ULL, 0x040fe200018e061fULL,
0x000000205e227210ULL, 0x000fe20007f7e0ffULL, 0x000000102b617836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c417faeULL, 0x0003e2000c101c46ULL,
0x000000015f257824ULL, 0x000fe200010e0623ULL, 0x000000286300720cULL, 0x080fe20003f46070ULL,
0x000000015f237824ULL, 0x000fe200018e0621ULL, 0x000000286100720cULL, 0x040fe20003f66070ULL,
0x0000000161217824ULL, 0x000fc400078e0229ULL, 0x0000001042437824ULL, 0x000fe400078e0257ULL,
0x000000182b657836ULL, 0x000fe40000000000ULL, 0x0000001c2b677836ULL, 0x000fe20000000000ULL,
0x000000001e437faeULL, 0x0005e2000c901c46ULL, 0x00000100211c7825ULL, 0x002fe200078e0026ULL,
0x000000286500720cULL, 0x080fe40003f26070ULL, 0x000000286700720cULL, 0x000fe20003f06070ULL,
0x000000015d2b7824ULL, 0x100fe200078e0208ULL, 0x0000001c5e207210ULL, 0x000fe20007fde0ffULL,
0x0000000861427824ULL, 0x000fe200078e00ffULL, 0x0000000367647819ULL, 0x000fe200000006ffULL,
0x0000000163417824ULL, 0x000fc400078e0208ULL, 0x000000015f217824ULL, 0x000fe400030e061dULL,
0x00000001631f7824ULL, 0x004fe400078e0229ULL, 0x000000085d1e7824ULL, 0x000fe400078e00ffULL,
0x000001001f1c7825ULL, 0x000fe200078e0026ULL, 0x00000008611f7210ULL, 0x000fe40007ffe0ffULL,
0xfffffff81e287812ULL, 0x000fe200078ee22bULL, 0x00000001652b7824ULL, 0x000fe200078e0229ULL,
0x0000001c5e1e7210ULL, 0x000fe20007fde0ffULL, 0x0000000863607824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee21fULL, 0x000000015b2a7824ULL, 0x000fe200078e0208ULL,
0x0000001d5f1f7210ULL, 0x000fe200037fe4ffULL, 0x000001002b1c7825ULL, 0x000fe200078e0026ULL,
0x000000035b5b7819ULL, 0x000fc400000006ffULL, 0xfffffff860607812ULL, 0x000fe200078ee241ULL,
0x0000000167297824ULL, 0x000fe200078e0229ULL, 0x0000001c5e1c7210ULL, 0x000fe20007fde0ffULL,
0x00000001652b7824ULL, 0x140fe200078e0208ULL, 0xfffffff85b2a7812ULL, 0x000fe200078ee22aULL,
0x0000000865627824ULL, 0x000fe200078e00ffULL, 0x0000005760437211ULL, 0x000fe200078e20ffULL,
0x0000000167417824ULL, 0x000fe400078e0208ULL, 0x0000010029267825ULL, 0x000fe200078e0026ULL,
0xfffffff862627812ULL, 0x000fc400078ee22bULL, 0xfffffff864647812ULL, 0x000fe200078ee241ULL,
0x000000015f1d7824ULL, 0x040fe200030e061dULL, 0x000000265e267210ULL, 0x000fe20007fde0ffULL,
0x000000102a297824ULL, 0x100fe400078e0257ULL, 0x00000010282b7824ULL, 0x100fe400078e0257ULL,
0x0000001042417824ULL, 0x100fe200078e0257ULL, 0x0000000024297faeULL, 0x0003e2000e901c46ULL,
0x00000010625b7824ULL, 0x100fe400078e0257ULL, 0x0000001064577824ULL, 0x000fe200078e0257ULL,
0x00000000222b7faeULL, 0x0003e2000e101c46ULL, 0x000000015f277824ULL, 0x000fc600030e0627ULL,
0x0000000020417faeULL, 0x0003e8000d901c46ULL, 0x000000001e437faeULL, 0x0003e8000d101c46ULL,
0x000000001c5b7faeULL, 0x0003e8000c901c46ULL, 0x0000000026577faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x00000004081f7811ULL, 0x000fe200078fe8ffULL,
0x00002000481c7824ULL, 0x000fe200078e00ffULL, 0x0000000808217811ULL, 0x040fe400078fe8ffULL,
0x000000081f667210ULL, 0x000fe20007ffe0ffULL, 0x000000081f1d7824ULL, 0x000fe200078e00ffULL,
0x0000001408277811ULL, 0x000fe200078fe8ffULL, 0x0000000121647824ULL, 0x100fe200078e0208ULL,
0x000020001c1c7812ULL, 0x000fe200078ec0ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0229ULL,
0xfffffff81d667812ULL, 0x000fe200078ee266ULL, 0x00000008211d7824ULL, 0x000fe200078e00ffULL,
0x0000001008257811ULL, 0x040fe200078fe8ffULL, 0x0000000127427824ULL, 0x000fe200078e0208ULL,
0x0001400057577810ULL, 0x000fe20007ffe01cULL, 0x0000000827437824ULL, 0x000fe200078e00ffULL,
0x0000000c08237811ULL, 0x040fe200078fe8ffULL, 0x0000000125607824ULL, 0x140fe200078e0208ULL,
0xfffffff81d647812ULL, 0x000fe200078ee264ULL, 0x0000000825417824ULL, 0x000fe200078e00ffULL,
0x00000008081c7211ULL, 0x000fe200078fe8ffULL, 0x0000000123627824ULL, 0x000fe200078e0208ULL,
0x00000007481d7819ULL, 0x000fe200000006ffULL, 0x0000000121217824ULL, 0x100fe200078e0229ULL,
0x00000018081e7811ULL, 0x000fe200078fe8ffULL, 0x0000000125257824ULL, 0x000fe200078e0229ULL,
0xfffffff843427812ULL, 0x000fc400078ee242ULL, 0x000000071c5b7812ULL, 0x000fe200078ec0ffULL,
0x000000081e6a7824ULL, 0x000fe200078e00ffULL, 0x0000001c08437811ULL, 0x000fe200078fe8ffULL,
0x0000001042637824ULL, 0x000fe200078e0257ULL, 0x00000080441c7812ULL, 0x000fe200078ef81dULL,
0x000000011e1d7824ULL, 0x140fe200078e0208ULL, 0x00000003232b7819ULL, 0x040fe200000006ffULL,
0x0000000123237824ULL, 0x100fe200078e0229ULL, 0xfffffff841607812ULL, 0x000fe200078ee260ULL,
0x000000011e417824ULL, 0x100fe200078e0229ULL, 0xfffffff82b627812ULL, 0x000fe200078ee262ULL,
0x00000001431e7824ULL, 0x040fe200078e0208ULL, 0x00000003435d7819ULL, 0x040fe200000006ffULL,
0x0000000143437824ULL, 0x000fe200078e0229ULL, 0x00000029082b7211ULL, 0x000fe200078fe8ffULL,
0x0000001060617824ULL, 0x100fe200078e0257ULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee21dULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0xfffffff85d6c7812ULL, 0x000fe200078ee21eULL,
0x00000010625d7824ULL, 0x000fe200078e0257ULL, 0x0000002927277210ULL, 0x000fe20007ffe0ffULL,
0x000001002b2a7825ULL, 0x000fe200078e001cULL, 0x0ffffff85b687812ULL, 0x000fc400078ef808ULL,
0x00000057645b7211ULL, 0x000fe200078e20ffULL, 0x000001001f1e7825ULL, 0x000fe200078e001cULL,
0x0000002a5e2a7210ULL, 0x000fc60007f1e0ffULL, 0x0000010021207825ULL, 0x000fe200078e001cULL,
0x0000001e5e1e7210ULL, 0x000fc60007f3e0ffULL, 0x0000010023227825ULL, 0x000fe200078e001cULL,
0x000000205e207210ULL, 0x000fc60007f5e0ffULL, 0x0000010025247825ULL, 0x000fe200078e001cULL,
0x000000225e227210ULL, 0x000fc60007f7e0ffULL, 0x0000010027267825ULL, 0x000fc800078e001cULL,
0x0000010041287825ULL, 0x000fc800078e001cULL, 0x00000100431c7825ULL, 0x000fc800078e001cULL,
0x000000015f2b7824ULL, 0x040fe200000e062bULL, 0x000000245e247210ULL, 0x000fe20007f1e0ffULL,
0x000000015f1f7824ULL, 0x040fe200008e061fULL, 0x000000265e267210ULL, 0x000fe20007f3e0ffULL,
0x0000001068417824ULL, 0x000fe200078e0257ULL, 0x000000255f257210ULL, 0x000fe200007fe4ffULL,
0x000000015f217824ULL, 0x040fe200010e0621ULL, 0x000000285e287210ULL, 0x000fe20007f5e0ffULL,
0x0000001066437824ULL, 0x000fe200078e0257ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a417faeULL, 0x0003e2000b901c46ULL, 0x000000015f237824ULL, 0x040fe200018e0623ULL,
0x0000001c5e1c7210ULL, 0x000fe20007f7e0ffULL, 0x000000015f277824ULL, 0x040fe200008e0627ULL,
0x000000001e437faeULL, 0x0003e2000b901c46ULL, 0x000000106a657824ULL, 0x000fe200078e0257ULL,
0x000000576c577211ULL, 0x000fe200078e20ffULL, 0x000000015f297824ULL, 0x040fe200010e0629ULL,
0x00000000205b7faeULL, 0x0003e2000b901c46ULL, 0x000000015f1d7824ULL, 0x000fc600018e061dULL,
0x00000000225d7faeULL, 0x0003e8000b901c46ULL, 0x0000000024617faeULL, 0x0003e8000b901c46ULL,
0x0000000026637faeULL, 0x0003e8000b901c46ULL, 0x0000000028657faeULL, 0x0003e8000b901c46ULL,
0x000000001c577faeULL, 0x0003e4000b901c46ULL, 0x00000001581c7812ULL, 0x002fe200078ec0ffULL,
0xffffffffff577424ULL, 0x000fe200078e00ffULL, 0xffffffff0a1d7811ULL, 0x000fe200078e08ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000011c00780cULL, 0x000fc80003f05070ULL,
0x000000011d1d7807ULL, 0x000fca0004000000ULL, 0x0000000158587824ULL, 0x000fca00078e021dULL,
0x000000065800720cULL, 0x000fda0003f06070ULL, 0x00009000ff1c8b82ULL, 0x000e620000000a00ULL,
0x0000000b581f8210ULL, 0x000fe20007ffe0ffULL, 0x000000205c5c7824ULL, 0x000fe200078e0207ULL,
0x0000000804217812ULL, 0x040fe400078ec0ffULL, 0x00000010041e7812ULL, 0x000fc800078ec0ffULL,
0x0000005c21217210ULL, 0x000fe20007ffe01eULL, 0x000000041f1c8825ULL, 0x002fca00078e001cULL,
0x000000061c578981ULL, 0x000322000c1e1900ULL, 0x01b64840214079a7ULL, 0x0002a4000850003fULL,
0x00000000001c7805ULL, 0x002fce0000015200ULL, 0x01b64841210075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff207224ULL, 0x000fce00078e00ffULL,
0x000000102000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fce0000015200ULL, 0x0000001e1c237210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000231e1e7211ULL, 0x000fc800078110ffULL, 0x0000001fff1f7210ULL, 0x000fc800007fe4ffULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000120207836ULL, 0x000fce0000000000ULL,
0x01b64841210075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000100441c7810ULL, 0x000fe20007ffe054ULL, 0x000000ffff5c7224ULL, 0x000fc800078e0059ULL,
0x00000001531c7824ULL, 0x000fca00078e021cULL, 0x01b000001c1e7984ULL, 0x000e680000000800ULL,
0x01b200001c5b7984ULL, 0x0004a20000000800ULL, 0x000000591e00720bULL, 0x002fda0003f1d000ULL,
0x00000000001d7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1d1f7812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x004fea0003800000ULL,
0x00000002481d7811ULL, 0x000fe400078ff0ffULL, 0x000000591e00720bULL, 0x000fe40003f14000ULL,
0x000000481d00720cULL, 0x000fd60003f25270ULL, 0x0000000000207806ULL, 0x000fe400000e0100ULL,
0x00000080481d9824ULL, 0x000fe200078e0207ULL, 0x000000591e1c9209ULL, 0x000fc80007810000ULL,
0x0000001d53219210ULL, 0x000fe40007ffe044ULL, 0x00009910201d7816ULL, 0x000fc600000000ffULL,
0x01b4001c21009388ULL, 0x0003e20000000800ULL, 0x000000ff1d00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x000000591e1c7209ULL, 0x000fe40007810000ULL,
0x000000ff20ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0020ff7812ULL, 0x000fe2000782c0ffULL,
0x000000591c1c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL,
0x0000001c001d7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff1c7819ULL, 0x002fcc0000011608ULL, 0x00001f1c1d1c7589ULL, 0x004e6400000e0000ULL,
0x0000002c1c2c7220ULL, 0x042fe20000410000ULL, 0x0000002d1c2d7220ULL, 0x040fe20000410000ULL,
0x000000301c307220ULL, 0x040fe20000410000ULL, 0x000000311c317220ULL, 0x040fe20000410000ULL,
0x000000341c347220ULL, 0x040fe20000410000ULL, 0x000000351c357220ULL, 0x040fe20000410000ULL,
0x000000381c387220ULL, 0x040fe20000410000ULL, 0x000000391c397220ULL, 0x040fe20000410000ULL,
0x0000003c1c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d1c3d7220ULL, 0x040fe20000410000ULL,
0x000000101c107220ULL, 0x040fe20000410000ULL, 0x000000111c117220ULL, 0x040fe20000410000ULL,
0x000000141c147220ULL, 0x040fe20000410000ULL, 0x000000151c157220ULL, 0x040fe20000410000ULL,
0x000000181c187220ULL, 0x040fe20000410000ULL, 0x000000191c197220ULL, 0x000fce0000410000ULL,
0x0000001d5a5a7220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x00000008081c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f1c1d1c7589ULL, 0x000e6400000e0000ULL,
0x0000002e1c2e7220ULL, 0x042fe20000410000ULL, 0x0000002f1c2f7220ULL, 0x040fe20000410000ULL,
0x000000321c327220ULL, 0x040fe20000410000ULL, 0x000000331c337220ULL, 0x040fe20000410000ULL,
0x000000361c367220ULL, 0x040fe20000410000ULL, 0x000000371c377220ULL, 0x040fe20000410000ULL,
0x0000003a1c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b1c3b7220ULL, 0x040fe20000410000ULL,
0x0000003e1c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f1c3f7220ULL, 0x040fe20000410000ULL,
0x000000121c127220ULL, 0x040fe20000410000ULL, 0x000000131c137220ULL, 0x040fe20000410000ULL,
0x000000161c167220ULL, 0x040fe20000410000ULL, 0x000000171c177220ULL, 0x040fe20000410000ULL,
0x0000001a1c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b1c1b7220ULL, 0x000fce0000410000ULL,
0x0000ffff1fff7812ULL, 0x000fe40007806020ULL, 0x000000591e5c7209ULL, 0x000fd60007810000ULL,
0x8000005c1e1e0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1e1e0820ULL, 0x000fc80000410000ULL,
0x0000001e000c0308ULL, 0x000ea40000000800ULL, 0x0000000c5b5b0220ULL, 0x004fce0000410000ULL,
0x0000000755597211ULL, 0x000fe200078e70ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00002000005e7824ULL, 0x000fc800078e0259ULL, 0x000130005e5e7836ULL, 0x000fe20000000000ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff1d7819ULL, 0x000fe40000011608ULL,
0x0000000cff0d723eULL, 0x000fc600000010ffULL, 0x000000081d1f7836ULL, 0x000fe20000000000ULL,
0x000054100d1c7816ULL, 0x002fca000000000dULL, 0x00001f1d1c0d7589ULL, 0x0002a800000e0000ULL,
0x00001f1f1c0e7589ULL, 0x0002e400000e0000ULL, 0x01200000561c783bULL, 0x0022e20000000200ULL,
0x0000001047407824ULL, 0x100fe200078e025eULL, 0x0000005e46287211ULL, 0x000fe200078e20ffULL,
0x0000001045247824ULL, 0x000fe200078e025eULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000d1c1c7232ULL, 0x08cfe40000200000ULL, 0x0000000d1e1e7232ULL, 0x000fe40000200000ULL,
0x0000000e1d1d7232ULL, 0x080fe40000200000ULL, 0x0000000e1f1f7232ULL, 0x000fce0000200000ULL,
0x000000002424783bULL, 0x000f620000004200ULL, 0x0000001050207824ULL, 0x000fe200078e025eULL,
0x00000002ff567819ULL, 0x002fe20000011648ULL, 0x00000002525d7836ULL, 0x000fe20000000000ULL,
0x000000004040783bULL, 0x000e680000004200ULL, 0x000000002020783bULL, 0x000e680000004200ULL,
0x000000002828783bULL, 0x000e620000004200ULL, 0x000000241c3c723cULL, 0x028fec000004183cULL,
0x000000401c2c723cULL, 0x002fe2000004182cULL, 0x0000000708257812ULL, 0x000fc800078ec0ffULL,
0x0000000825257812ULL, 0x000fe200078ef808ULL, 0x000000201c14723cULL, 0x000fe20000041814ULL,
0x0000001051407824ULL, 0x000fc600078e025eULL, 0x0000000825247824ULL, 0x000fe400078e00ffULL,
0x000000421c30723cULL, 0x000fe20000041830ULL, 0x0000000756207211ULL, 0x000fe400078e58ffULL,
0xfffffff8245d7812ULL, 0x000fe200078ee25dULL, 0x000000104d247824ULL, 0x000fe400078e025eULL,
0x000000281c34723cULL, 0x004fe40000041834ULL, 0x000000105d207824ULL, 0x000fc800078e0220ULL,
0x0000002a1c38723cULL, 0x000fe20000041838ULL, 0x000000104e287824ULL, 0x000fca00078e025eULL,
0x000000261c10723cULL, 0x000fec0000041810ULL, 0x000000221c18723cULL, 0x000fe20000041818ULL,
0x01200000201c783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000d1c1c7232ULL, 0x084fe40000200000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000200000ULL, 0x0000000e1d1d7232ULL, 0x080fe40000200000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000200000ULL, 0x0000005e4f207211ULL, 0x002fe200078e20ffULL,
0x000000004040783bULL, 0x000e620000004200ULL, 0x0000005a5b5a7221ULL, 0x000fc60000010000ULL,
0x000000002828783bULL, 0x000ee80000004200ULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x000000002020783bULL, 0x000ee20000004200ULL, 0x000000401c2c723cULL, 0x006fec000004182cULL,
0x000000421c30723cULL, 0x000fec0000041830ULL, 0x000000281c34723cULL, 0x008fe20000041834ULL,
0x00000001ff427424ULL, 0x000fca00078e00ffULL, 0x0000002a1c38723cULL, 0x000fec0000041838ULL,
0x000000241c3c723cULL, 0x020fec000004183cULL, 0x000000261c10723cULL, 0x000fec0000041810ULL,
0x000000201c14723cULL, 0x000fec0000041814ULL, 0x000000221c18723cULL, 0x000fe20000041818ULL,
0x0000000856217824ULL, 0x000fc800078e0207ULL, 0x01b6984221ff79a7ULL, 0x0003e4000850003fULL,
0x000000010a1e7824ULL, 0x000fca00078e024cULL, 0x000000051e00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000c00200947ULL, 0x002fea0003800000ULL,
0x00008e00ff1c7b82ULL, 0x000e620000000a00ULL, 0x000001001e207824ULL, 0x000fe200078e0203ULL,
0x000000011e1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x00000004571f7c24ULL, 0x010fe2000f8e02ffULL, 0x000000051e00720cULL, 0x000fe40003f06070ULL,
0x00000060202b7812ULL, 0x000fe200078ec0ffULL, 0x000000801f1f7824ULL, 0x000fc800078e00ffULL,
0x00000001022b7824ULL, 0x000fe400078e022bULL, 0x000001001f1c7825ULL, 0x002fc800078e001cULL,
0x0000000400948947ULL, 0x000fea0003800000ULL, 0x00000003ff417819ULL, 0x100fe20000011608ULL,
0x00002000481e7824ULL, 0x040fe200078e00ffULL, 0x000000200f2a7248ULL, 0x000fe20007fe0000ULL,
0x0000008048217824ULL, 0x000fe200078e00ffULL, 0x000000ff201f7210ULL, 0x000fe20007ffe1ffULL,
0x0000000441257836ULL, 0x000fe20000000000ULL, 0x000020001e1e7812ULL, 0x000fe200078ec0ffULL,
0x00000008415f7836ULL, 0x000fe20000000000ULL, 0x000000202a2a7446ULL, 0x000fe2000380001fULL,
0x0000000125207824ULL, 0x000fe200078e0208ULL, 0x0001300059597810ULL, 0x000fe20007ffe01eULL,
0x0000000825237824ULL, 0x000fe200078e00ffULL, 0x00000080441e7812ULL, 0x000fe200078ef821ULL,
0x00000001411f7824ULL, 0x000fe200078e0208ULL, 0x0000002a2500720cULL, 0x0c0fe20003f26070ULL,
0x0000000125257824ULL, 0x100fe200078e022bULL, 0xfffffff8235e7812ULL, 0x000fe200078ee220ULL,
0x0000000c41617836ULL, 0x000fe20000000000ULL, 0x0000002b41237210ULL, 0x000fe20007ffe0ffULL,
0x0000001041637836ULL, 0x000fe20000000000ULL, 0x000000071f297812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x0000002b5f277210ULL, 0x000fe20007ffe0ffULL,
0x0000000161217824ULL, 0x000fe200078e022bULL, 0x0000002a4100720cULL, 0x000fe20003f06070ULL,
0x0000010023227825ULL, 0x000fe200078e001eULL, 0x0ffffff829407812ULL, 0x000fc400078ef808ULL,
0x0000002a5f00720cULL, 0x080fe20003fa6070ULL, 0x0000010025247825ULL, 0x100fe200078e001eULL,
0x000000221c227210ULL, 0x000fe40007f5e0ffULL, 0x0000001841677810ULL, 0x000fe20007ffe0ffULL,
0x0000010027267825ULL, 0x000fe200078e001eULL, 0x000000241c247210ULL, 0x000fe40007f7e0ffULL,
0x0000002a6100720cULL, 0x000fe20003f86070ULL, 0x000000011d237824ULL, 0x000fe200010e0623ULL,
0x000000261c287210ULL, 0x000fe20007f5e0ffULL, 0x0000010021207825ULL, 0x000fc600078e001eULL,
0x000000271d297210ULL, 0x000fe200017fe4ffULL, 0x0000001040437824ULL, 0x000fe200078e0259ULL,
0x0000000861407210ULL, 0x000fe20007ffe0ffULL, 0x000000011d257824ULL, 0x000fe200018e0625ULL,
0x000000201c207210ULL, 0x000fe20007f7e0ffULL, 0x000000105e5b7824ULL, 0x000fe200078e0259ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022437faeULL, 0x0003e2000c101c46ULL,
0x0000000163277824ULL, 0x000fe400078e022bULL, 0x0000001441657836ULL, 0x000fe20000000000ULL,
0x00000000245b7faeULL, 0x0005e2000c901c46ULL, 0x0000001c41697836ULL, 0x000fe20000000000ULL,
0x0000002a6700720cULL, 0x080fe20003f26070ULL, 0x000000015f267824ULL, 0x000fe200078e0208ULL,
0x0000002a6500720cULL, 0x080fe20003f46070ULL, 0x000000085f5f7824ULL, 0x000fe200078e00ffULL,
0x0000002a6900720cULL, 0x080fe20003f06070ULL, 0x000000011d217824ULL, 0x000fe200018e0621ULL,
0x0000002a6300720cULL, 0x000fe20003f66070ULL, 0x0000010027227825ULL, 0x002fe200078e001eULL,
0xfffffff85f2a7812ULL, 0x000fc600078ee226ULL, 0x0000000165257824ULL, 0x004fe200078e022bULL,
0x000000221c227210ULL, 0x000fe20007fde0ffULL, 0x0000000163267824ULL, 0x040fe200078e0208ULL,
0x0000000363637819ULL, 0x000fe200000006ffULL, 0x0000010025247825ULL, 0x000fc600078e001eULL,
0xfffffff8635e7812ULL, 0x000fe200078ee226ULL, 0x0000000167277824ULL, 0x000fe200078e022bULL,
0x0000002b692b7210ULL, 0x000fe20007ffe0ffULL, 0x000000011d237824ULL, 0x000fe200030e0623ULL,
0x000000241c247210ULL, 0x000fe20007fde0ffULL, 0x0000000165417824ULL, 0x040fe400078e0208ULL,
0x0000000865607824ULL, 0x000fe400078e00ffULL, 0x0000010027267825ULL, 0x000fc600078e001eULL,
0xfffffff860607812ULL, 0x000fe200078ee241ULL, 0x0000000861617824ULL, 0x000fe400078e00ffULL,
0x000000011d257824ULL, 0x000fe200030e0625ULL, 0x000000261c267210ULL, 0x000fe20007fde0ffULL,
0x0000000167417824ULL, 0x140fe200078e0208ULL, 0xfffffff861407812ULL, 0x000fe200078ee240ULL,
0x0000000867627824ULL, 0x000fe200078e00ffULL, 0x000000271d277210ULL, 0x000fe200037fe4ffULL,
0x0000000169437824ULL, 0x040fe400078e0208ULL, 0x0000000869647824ULL, 0x000fe200078e00ffULL,
0xfffffff862627812ULL, 0x000fe200078ee241ULL, 0x000001002b1e7825ULL, 0x000fc600078e001eULL,
0xfffffff864647812ULL, 0x000fe200078ee243ULL, 0x000000102a2b7824ULL, 0x100fe200078e0259ULL,
0x0000001e1c1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001040417824ULL, 0x100fe200078e0259ULL,
0x00000059625f7211ULL, 0x000fe200078e20ffULL, 0x000000105e437824ULL, 0x100fe200078e0259ULL,
0x00000000282b7faeULL, 0x0003e2000e901c46ULL, 0x00000010605b7824ULL, 0x100fe400078e0259ULL,
0x0000001064597824ULL, 0x000fe200078e0259ULL, 0x0000000020417faeULL, 0x0003e2000e101c46ULL,
0x000000011d1d7824ULL, 0x000fc600030e061fULL, 0x0000000022437faeULL, 0x0003e8000d901c46ULL,
0x00000000245b7faeULL, 0x0003e8000d101c46ULL, 0x00000000265f7faeULL, 0x0003e8000c901c46ULL,
0x000000001c597faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x0000000408217811ULL, 0x000fe200078fe8ffULL, 0x00002000481e7824ULL, 0x000fe200078e00ffULL,
0x0000000808237811ULL, 0x000fe400078fe8ffULL, 0x00000003211f7819ULL, 0x040fe200000006ffULL,
0x0000000121667824ULL, 0x100fe200078e0208ULL, 0x000020001e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000123647824ULL, 0x040fe200078e0208ULL, 0x0000001408297811ULL, 0x040fe400078fe8ffULL,
0xfffffff81f667812ULL, 0x000fe200078ee266ULL, 0x00000008231f7824ULL, 0x000fe200078e00ffULL,
0x0001300059597810ULL, 0x000fe20007ffe01eULL, 0x00000001295e7824ULL, 0x140fe200078e0208ULL,
0x0000001008277811ULL, 0x000fe200078fe8ffULL, 0x00000008295b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f647812ULL, 0x000fe200078ee264ULL, 0x00000080481f7824ULL, 0x000fe200078e00ffULL,
0x0000000c08257811ULL, 0x040fe200078fe8ffULL, 0x0000000827437824ULL, 0x000fe200078e00ffULL,
0x00000008081e7211ULL, 0x040fe200078fe8ffULL, 0x0000000123237824ULL, 0x100fe200078e022bULL,
0x0000001808207811ULL, 0x000fe200078fe8ffULL, 0x0000000125627824ULL, 0x140fe200078e0208ULL,
0x000000071e5f7812ULL, 0x000fe200078ec0ffULL, 0x0000000825417824ULL, 0x040fe200078e00ffULL,
0x0000000827607210ULL, 0x000fe20007ffe0ffULL, 0x00000008206a7824ULL, 0x040fe200078e00ffULL,
0xfffffff85b5e7812ULL, 0x000fe200078ee25eULL, 0x0000000125257824ULL, 0x100fe200078e022bULL,
0x00000080441e7812ULL, 0x000fe200078ef81fULL, 0x00000001201f7824ULL, 0x100fe200078e0208ULL,
0x0000001c085b7811ULL, 0x000fe200078fe8ffULL, 0x0000000127277824ULL, 0x100fe200078e022bULL,
0xfffffff843607812ULL, 0x000fe200078ee260ULL, 0x0000000129297824ULL, 0x000fe200078e022bULL,
0xfffffff841627812ULL, 0x000fe200078ee262ULL, 0x000000085b617824ULL, 0x040fe200078e00ffULL,
0x0000002b20437210ULL, 0x000fe20007ffe0ffULL, 0x000000015b207824ULL, 0x000fe200078e0208ULL,
0x0000002b21217210ULL, 0x000fe20007ffe0ffULL, 0x0000001060637824ULL, 0x100fe200078e0259ULL,
0x0000002b08417211ULL, 0x000fe200078fe8ffULL, 0x000000105e657824ULL, 0x000fe200078e0259ULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee21fULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x0000002b5b5b7210ULL, 0x000fc40007ffe0ffULL, 0xfffffff8616c7812ULL, 0x000fe200078ee220ULL,
0x0000010041407825ULL, 0x100fe200078e001eULL, 0x0ffffff85f687812ULL, 0x000fe400078ef808ULL,
0x0000005962617211ULL, 0x000fe200078e20ffULL, 0x00000100212a7825ULL, 0x000fe200078e001eULL,
0x000000401c407210ULL, 0x000fc60007f1e0ffULL, 0x0000010023207825ULL, 0x100fe200078e001eULL,
0x0000002a1c2a7210ULL, 0x000fe40007f3e0ffULL, 0x000000411d417210ULL, 0x000fe200007fe4ffULL,
0x0000010025227825ULL, 0x000fe200078e001eULL, 0x000000201c207210ULL, 0x000fc60007f5e0ffULL,
0x0000010027247825ULL, 0x000fe200078e001eULL, 0x000000221c227210ULL, 0x000fc60007f7e0ffULL,
0x0000010029267825ULL, 0x000fe200078e001eULL, 0x000000241c247210ULL, 0x000fc60007f1e0ffULL,
0x0000010043287825ULL, 0x000fc800078e001eULL, 0x000001005b1e7825ULL, 0x000fc800078e001eULL,
0x0000001068437824ULL, 0x000fe400078e0259ULL, 0x000000011d2b7824ULL, 0x040fe200008e062bULL,
0x000000261c267210ULL, 0x000fe20007f3e0ffULL, 0x000000011d217824ULL, 0x040fe200010e0621ULL,
0x000000281c287210ULL, 0x000fe20007f5e0ffULL, 0x00000010665b7824ULL, 0x000fe200078e0259ULL,
0x000000271d277210ULL, 0x000fe20000ffe4ffULL, 0x000000011d237824ULL, 0x040fe200018e0623ULL,
0x0000001e1c1c7210ULL, 0x000fe20007f7e0ffULL, 0x00000010645f7824ULL, 0x000fe200078e0259ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040437faeULL, 0x0003e2000b901c46ULL,
0x000000011d257824ULL, 0x000fc400000e0625ULL, 0x000000106a677824ULL, 0x000fe200078e0259ULL,
0x000000002a5b7faeULL, 0x0003e2000b901c46ULL, 0x000000011d297824ULL, 0x040fe400010e0629ULL,
0x000000106c597824ULL, 0x000fe200078e0259ULL, 0x00000000205f7faeULL, 0x0003e2000b901c46ULL,
0x000000011d1d7824ULL, 0x000fc600018e061fULL, 0x0000000022617faeULL, 0x0003e8000b901c46ULL,
0x0000000024637faeULL, 0x0003e8000b901c46ULL, 0x0000000026657faeULL, 0x0003e8000b901c46ULL,
0x0000000028677faeULL, 0x0003e8000b901c46ULL, 0x000000001c597faeULL, 0x0003e4000b901c46ULL,
0x00000020561d7824ULL, 0x002fe200078e0207ULL, 0x00000010041c7812ULL, 0x040fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008041e7812ULL, 0x000fc800078ec0ffULL,
0x0000001d1e237210ULL, 0x000fc80007ffe01cULL, 0x01b66842234279a7ULL, 0x0002a6000850003fULL,
0x00000000001c7805ULL, 0x000fce0000015200ULL, 0x01b66843230075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff207224ULL, 0x000fce00078e00ffULL,
0x000000102000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fce0000015200ULL, 0x0000001e1c217210ULL, 0x000fc80007f1e1ffULL,
0x0000001f1d1f7210ULL, 0x000fe400007fe5ffULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000211e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000120207836ULL, 0x000fce0000000000ULL,
0x01b66843230075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000018044547810ULL, 0x000fe20007ffe054ULL, 0x000000ffff567224ULL, 0x000fc800078e005cULL,
0x0000000153547824ULL, 0x000fca00078e0254ULL, 0x01b00000541d7984ULL, 0x000ea80000000800ULL,
0x01b2000054597984ULL, 0x0006e20000000800ULL, 0x0000005c1d00720bULL, 0x004fda0003f1d000ULL,
0x00000000001c7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1c207812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x00afea0003800000ULL,
0x00000003481f7811ULL, 0x000fe400078ff0ffULL, 0x0000005c1d00720bULL, 0x000fe40003f14000ULL,
0x000000481f00720cULL, 0x000fd60003f25270ULL, 0x00000000001f7806ULL, 0x000fe400000e0100ULL,
0x00000007481e9211ULL, 0x000fe400078e38ffULL, 0x0000005c1d1c9209ULL, 0x000fe40007810000ULL,
0x0000001e53539210ULL, 0x000fe40007ffe044ULL, 0x000099101f1e7816ULL, 0x000fc600000000ffULL,
0x01b4001c53009388ULL, 0x0003e20000000800ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005c1d217209ULL, 0x000fe40007810000ULL,
0x000000ff1fff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001fff7812ULL, 0x000fe2000782c0ffULL,
0x0000005c211c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL,
0x0000001c00217308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff1c7819ULL, 0x002fcc0000011608ULL, 0x00001f1c211c7589ULL, 0x004e6400000e0000ULL,
0x0000002c1c2c7220ULL, 0x042fe20000410000ULL, 0x0000002d1c2d7220ULL, 0x040fe20000410000ULL,
0x000000301c307220ULL, 0x040fe20000410000ULL, 0x000000311c317220ULL, 0x040fe20000410000ULL,
0x000000341c347220ULL, 0x040fe20000410000ULL, 0x000000351c357220ULL, 0x040fe20000410000ULL,
0x000000381c387220ULL, 0x040fe20000410000ULL, 0x000000391c397220ULL, 0x040fe20000410000ULL,
0x0000003c1c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d1c3d7220ULL, 0x040fe20000410000ULL,
0x000000101c107220ULL, 0x040fe20000410000ULL, 0x000000111c117220ULL, 0x040fe20000410000ULL,
0x000000141c147220ULL, 0x040fe20000410000ULL, 0x000000151c157220ULL, 0x040fe20000410000ULL,
0x000000181c187220ULL, 0x040fe20000410000ULL, 0x000000191c197220ULL, 0x000fce0000410000ULL,
0x000000215a5a7220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x00000008081c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f1c211c7589ULL, 0x000e6400000e0000ULL,
0x0000002e1c2e7220ULL, 0x042fe20000410000ULL, 0x0000002f1c2f7220ULL, 0x040fe20000410000ULL,
0x000000321c327220ULL, 0x040fe20000410000ULL, 0x000000331c337220ULL, 0x040fe20000410000ULL,
0x000000361c367220ULL, 0x040fe20000410000ULL, 0x000000371c377220ULL, 0x040fe20000410000ULL,
0x0000003a1c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b1c3b7220ULL, 0x040fe20000410000ULL,
0x0000003e1c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f1c3f7220ULL, 0x040fe20000410000ULL,
0x000000121c127220ULL, 0x040fe20000410000ULL, 0x000000131c137220ULL, 0x040fe20000410000ULL,
0x000000161c167220ULL, 0x040fe20000410000ULL, 0x000000171c177220ULL, 0x040fe20000410000ULL,
0x0000001a1c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b1c1b7220ULL, 0x000fce0000410000ULL,
0x0000ffff20ff7812ULL, 0x000fe4000780601fULL, 0x0000005c1d567209ULL, 0x000fd60007810000ULL,
0x800000561d1d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL,
0x0000001d000c0308ULL, 0x000ea40000000800ULL, 0x0000000c59590220ULL, 0x004fce0000410000ULL,
0x00000007081d7812ULL, 0x000fe200078ec0ffULL, 0x00004000551f7824ULL, 0x000fe200078e0207ULL,
0x00000002ff537819ULL, 0x000fe20000011648ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000081d1d7812ULL, 0x000fe200078ef808ULL, 0x00002000001f7824ULL, 0x000fe400078e021fULL,
0x00000800531c7824ULL, 0x002fe400078e0207ULL, 0x000000081d1d7824ULL, 0x000fca00078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe400078ee252ULL, 0x000140001f527810ULL, 0x000fc60007ffe0ffULL,
0x000000101d1c7824ULL, 0x000fe200078e021cULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe40000011608ULL, 0x0000000cff0d723eULL, 0x000fc600000010ffULL,
0x000000081e0e7836ULL, 0x000fe20000000000ULL, 0x000054100d1d7816ULL, 0x000fca000000000dULL,
0x00001f1e1d0d7589ULL, 0x0002a800000e0000ULL, 0x00001f0e1d0e7589ULL, 0x0002e400000e0000ULL,
0x012800001c1c783bULL, 0x002e620000000200ULL, 0x0000001047477824ULL, 0x100fe200078e0252ULL,
0x0000005245247211ULL, 0x000fe200078e20ffULL, 0x0000001046407824ULL, 0x000fe200078e0252ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000d1c1c7232ULL, 0x086fe40000200000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000200000ULL, 0x0000000e1d1d7232ULL, 0x088fe40000200000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000200000ULL, 0x0000001050287824ULL, 0x000fe200078e0252ULL,
0x000000004744783bULL, 0x000f620000004200ULL, 0x0000000353207836ULL, 0x000fe40000000000ULL,
0x0000005a59597221ULL, 0x000fe20000010000ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x0000080020207824ULL, 0x000fc600078e0207ULL, 0x000000002424783bULL, 0x000f620000004200ULL,
0x000000105d207824ULL, 0x000fc600078e0220ULL, 0x000000002828783bULL, 0x000f680000004200ULL,
0x011000002020783bULL, 0x000f640000000200ULL, 0x000000441c2c723cULL, 0x02afec000004182cULL,
0x000000461c30723cULL, 0x000fec0000041830ULL, 0x000000401c34723cULL, 0x004fec0000041834ULL,
0x000000421c38723cULL, 0x000fec0000041838ULL, 0x000000241c3c723cULL, 0x000fec000004183cULL,
0x000000261c10723cULL, 0x000fec0000041810ULL, 0x000000281c14723cULL, 0x000fec0000041814ULL,
0x0000002a1c1c723cULL, 0x000fe20000041818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000d20207232ULL, 0x080fe40000200000ULL,
0x0000000d22227232ULL, 0x000fe40000200000ULL, 0x0000000e21217232ULL, 0x080fe40000200000ULL,
0x0000000e23237232ULL, 0x000fce0000200000ULL, 0x000000104d247824ULL, 0x100fe200078e0252ULL,
0x0000005251407211ULL, 0x000fe200078e20ffULL, 0x000000104e287824ULL, 0x100fe400078e0252ULL,
0x000000104f187824ULL, 0x000fe400078e0252ULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x000000010a4c7824ULL, 0x000fe400078e024cULL, 0x0000000853537824ULL, 0x000fe200078e0207ULL,
0x000000004040783bULL, 0x000ea40000004200ULL, 0x000000054c00720cULL, 0x000fc40003f06070ULL,
0x000000002828783bULL, 0x000ee80000004200ULL, 0x000000001818783bULL, 0x000f620000004200ULL,
0x000000262010723cULL, 0x002fec0000041810ULL, 0x00000040202c723cULL, 0x004fe2000004182cULL,
0x0000000100267802ULL, 0x000fc80000000f00ULL, 0x01b6a02653ff79a7ULL, 0x0003e2000850003fULL,
0x000000422030723cULL, 0x000fec0000041830ULL, 0x000000282034723cULL, 0x008fec0000041834ULL,
0x0000002a2038723cULL, 0x000fec0000041838ULL, 0x00000024203c723cULL, 0x000fec000004183cULL,
0x000000182014723cULL, 0x020fec0000041814ULL, 0x0000001a201c723cULL, 0x000fe2000004181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff9c00788947ULL, 0x002fde000383ffffULL,
0x0000000000187919ULL, 0x000e620000002500ULL, 0x000000ffff087224ULL, 0x000fe200078e001eULL,
0x0000001700067202ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe200078e001cULL,
0x00000012001c7202ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1e7224ULL, 0x000fe400078e001dULL, 0x000000ffff1b7224ULL, 0x000fe400078e0016ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0015ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0014ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0013ULL, 0x000000ffff117224ULL, 0x000fe200078e0010ULL,
0x000000051800720cULL, 0x002fda0003f06070ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x0180000059027836ULL, 0x000fca0000000000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0059ULL, 0x00007f50000c7802ULL, 0x000fce0000000f00ULL,
0x000000b400507944ULL, 0x010fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005900027308ULL, 0x000e640000001000ULL, 0xbf80000002047423ULL, 0x002fc80000000059ULL,
0x800000ff04057221ULL, 0x000fc80000010100ULL, 0x0000000502027223ULL, 0x000fce0000000002ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff0b7819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x008fea0003800000ULL,
0x00001f0b02047589ULL, 0x000e6800000e0000ULL, 0x00001f0502057589ULL, 0x000ea200000e0000ULL,
0x0000002c042c7220ULL, 0x042fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x040fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000000e040e7220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x000fe20000410000ULL,
0x0000002e052e7220ULL, 0x044fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000000605067220ULL, 0x040fe20000410000ULL,
0x0000000805087220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x000fce0000410000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000271e13723eULL, 0x000fe400000010ffULL,
0x0000000b551e7819ULL, 0x000fe200000006ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002c2d14723eULL, 0x000fc400000010ffULL, 0x000000303115723eULL, 0x000fe400000010ffULL,
0x000000343516723eULL, 0x000fe400000010ffULL, 0x000000383917723eULL, 0x000fe400000010ffULL,
0x000000110d11723eULL, 0x000fe400000010ffULL, 0x0000001b0606723eULL, 0x000fe400000010ffULL,
0x00000032330d723eULL, 0x000fc400000010ffULL, 0x000000010a00780cULL, 0x000fe40003f05270ULL,
0x00000003ff197819ULL, 0x002fe40000011602ULL, 0xfffffff8ff057812ULL, 0x000fe400078ee202ULL,
0x0000000319047812ULL, 0x000fe400078ec0ffULL, 0x00000008050b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000805107824ULL, 0x040fe200078e00ffULL, 0x0000000203287210ULL, 0x000fe20007ffe0ffULL,
0x0000000805217824ULL, 0x000fe200078e00ffULL, 0x000000030b237819ULL, 0x000fe200000006ffULL,
0x0000000104057824ULL, 0x000fc400078e0205ULL, 0x00000001040c7824ULL, 0x000fe400078e020bULL,
0x000000080b127824ULL, 0x000fe200078e00ffULL, 0xfffffff8101d7812ULL, 0x000fe200078ee205ULL,
0x0000000c050b7836ULL, 0x000fe20000000000ULL, 0xfffffff823237812ULL, 0x000fe200078ee20cULL,
0x0000000405047836ULL, 0x000fe20000000000ULL, 0x0000001c1a05723eULL, 0x000fe400000010ffULL,
0xfffffff812257812ULL, 0x000fe200078ee20bULL, 0x00001000000b7824ULL, 0x000fe200078e0207ULL,
0x000000081f07723eULL, 0x000fc400000010ffULL, 0xfffffff821217812ULL, 0x000fe200078ee204ULL,
0x000000010b087824ULL, 0x000fe200078e021eULL, 0x0000003c3d10723eULL, 0x000fe200000010ffULL,
0x0000001028297824ULL, 0x000fe200078e020bULL, 0x0000000f0e12723eULL, 0x000fe200000010ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0208ULL, 0x0000002e2f0c723eULL, 0x000fe200000010ffULL,
0x00000010211a7824ULL, 0x100fe200078e0208ULL, 0x00000036370e723eULL, 0x000fe200000010ffULL,
0x00000010231b7824ULL, 0x100fe200078e0208ULL, 0x0000003a3b0f723eULL, 0x000fe200000010ffULL,
0x00000010251c7824ULL, 0x000fe200078e0208ULL, 0x0000003e3f04723eULL, 0x000fe200000010ffULL,
0x000000141d007844ULL, 0x000fe20000000200ULL, 0x000000ff001f7306ULL, 0x000e660000202400ULL,
0x000000101a007844ULL, 0x000fe80000000200ULL, 0x0000000c1b007844ULL, 0x000fe80000000200ULL,
0x000000041c007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000292c7984ULL, 0x000e680000000c00ULL, 0x0004000029247984ULL, 0x000ea80000000c00ULL,
0x0008000029307984ULL, 0x000ee80000000c00ULL, 0x000c000029207984ULL, 0x000f620000000c00ULL,
0x0000002f1f2f7230ULL, 0x002fc40000200800ULL, 0x0000002e1f2e7230ULL, 0x040fe40000200800ULL,
0x0000002d1f2d7230ULL, 0x040fe40000200800ULL, 0x0000002c1f2c7230ULL, 0x040fe40000200800ULL,
0x000000271f277230ULL, 0x044fe40000200800ULL, 0x000000261f117230ULL, 0x040fe40000200800ULL,
0x000000251f257230ULL, 0x000fc40000200800ULL, 0x000000241f107230ULL, 0x000fe40000200800ULL,
0x000000332f077230ULL, 0x008fe40000200000ULL, 0x000000322e067230ULL, 0x000fe40000200000ULL,
0x000000312d057230ULL, 0x000fe40000200000ULL, 0x000000302c047230ULL, 0x000fe40000200000ULL,
0x0000002327237230ULL, 0x020fc40000200000ULL, 0x0000002211227230ULL, 0x000fe20000200000ULL,
0x0000000429007388ULL, 0x0003e20000000c00ULL, 0x0000002125217230ULL, 0x000fe40000200000ULL,
0x0000002010207230ULL, 0x000fca0000200000ULL, 0x0004002029007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000028001c8947ULL, 0x000fea0003800000ULL,
0x00000400ff1b7b82ULL, 0x000ea20000000800ULL, 0x0000000000147919ULL, 0x000ee20000002600ULL,
0x0000004028217836ULL, 0x002fe20000000000ULL, 0x0000000000137919ULL, 0x000eea0000002700ULL,
0x00009600ff047b82ULL, 0x000eb00000000800ULL, 0x00009a00ff107b82ULL, 0x000e620000000a00ULL,
0x000000041b057224ULL, 0x004fc800078e02ffULL, 0x0000000a050c7224ULL, 0x0c0fe200078e02ffULL,
0x0000000f051f7811ULL, 0x000fe200078e10ffULL, 0x0000001b131b7224ULL, 0x008fe200078e0214ULL,
0x0000000029047984ULL, 0x0004e40000000c00ULL, 0xfffffff01f1f7812ULL, 0x000fe200078ec0ffULL,
0x0000000a1b1a7224ULL, 0x000fc800078e02ffULL, 0x000000800c1d7824ULL, 0x000fe400078e021fULL,
0x000000011a187824ULL, 0x000fe400078e0218ULL, 0x000000800c127824ULL, 0x000fe400078e021dULL,
0x00040000290c7984ULL, 0x0004a60000000c00ULL, 0x0000007f12127810ULL, 0x000fc80007ffe0ffULL,
0xffffff8012137812ULL, 0x000fc800078ec0ffULL, 0x0000001013157210ULL, 0x002fc80007f1e0ffULL,
0x0000001518147211ULL, 0x000fe200078260ffULL, 0x000000ffff157224ULL, 0x000fe200000e0611ULL,
0x0000000155ff7812ULL, 0x000fc8000780f848ULL, 0x0000001518157211ULL, 0x000fe400008f64ffULL,
0x000000101f257210ULL, 0x000fe20007f3e0ffULL, 0x0000080000147825ULL, 0x000fc800078e0014ULL,
0x000000ffff277224ULL, 0x000fe400008e0611ULL, 0x0000001028167825ULL, 0x000fc800078e0014ULL,
0x0000001021147825ULL, 0x000fe200078e0014ULL, 0x0000000000400947ULL, 0x008fec0003800000ULL,
0x00000004021c7819ULL, 0x000fe200000006ffULL, 0x0000008018127824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fe40000011602ULL, 0x000000701c237812ULL, 0x000fe400078ec0ffULL,
0x0000001012227210ULL, 0x000fe40007ebe01dULL, 0x00000019ff187819ULL, 0x000fe40000011618ULL,
0x0000000c20217812ULL, 0x000fc400078ec0ffULL, 0x0000002523127210ULL, 0x000fe40007a3e012ULL,
0x00000011181c7210ULL, 0x000fe40002fec4ffULL, 0x0000001221207210ULL, 0x000fe40007fbe0ffULL,
0x00000027ff187210ULL, 0x000fe40000fe4418ULL, 0x0000002221227210ULL, 0x000fc60007c7e023ULL,
0x000000ffff217224ULL, 0x000fe200028e0618ULL, 0x0000001cff237210ULL, 0x000fc80001fe84ffULL,
0x0000005620007986ULL, 0x0003e8000c101906ULL, 0x0000005922007986ULL, 0x0003e4000c101906ULL,
0x000000ff0200720cULL, 0x000fe20000705670ULL, 0x0000000416007986ULL, 0x0007e8000c101d06ULL,
0x0000000c14007986ULL, 0x0047e2000c101d06ULL, 0x0000000000007b1dULL, 0x000fee0000000000ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x00009a00ff047b82ULL, 0x008ea20000000a00ULL,
0xffffffff0a077836ULL, 0x000fe40000000000ULL, 0x000000041b047825ULL, 0x004fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000007040479a8ULL, 0x00052200099ee1c6ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000070400720cULL, 0x010fc80003f05270ULL,
0x00000001ff047807ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000004ff007988ULL, 0x0007e60008000004ULL, 0x0000000000057919ULL, 0x00cea20000008800ULL,
0x00000400001c7802ULL, 0x000fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000654051c7816ULL, 0x004fca000000001cULL,
0x000000001c047984ULL, 0x000ea40000000000ULL, 0x000000ff0400720cULL, 0x004fda0003f05270ULL,
0x0000002000c08947ULL, 0x000fea0003800000ULL, 0x000000ff4800720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x0000001002057824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fe40000011602ULL, 0x000000251a047211ULL, 0x000fe400078038ffULL,
0x0000007005077812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fe400078ec0ffULL,
0x000000271a057211ULL, 0x000fe400000f3cffULL, 0x0000000406047210ULL, 0x000fc8000791e007ULL,
0x00000005ff057210ULL, 0x000fca00007e24ffULL, 0x0000000604067981ULL, 0x000528000c1e1900ULL,
0x0000800604077981ULL, 0x000522000c1e1900ULL, 0x000000020a00780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x004fea0003800000ULL, 0x00010006040d7981ULL, 0x000522000c1e1900ULL,
0x000000040a00780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x004fea0003800000ULL,
0x00018006040f7981ULL, 0x000522000c1e1900ULL, 0x000000040a00780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x004fea0003800000ULL, 0x0002000604157981ULL, 0x000522000c1e1900ULL,
0x000000060a00780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x004fea0003800000ULL,
0x0002800604177981ULL, 0x000522000c1e1900ULL, 0x000000060a00780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x004fea0003800000ULL, 0x000000080a00780cULL, 0x000fe20003f06070ULL,
0x0003000604197981ULL, 0x000518000c1e1900ULL, 0x00038006041b0981ULL, 0x000524000c1e1900ULL,
0x000000070a047810ULL, 0x004fc80007ffe0ffULL, 0x00000003ff0c7819ULL, 0x000fc80000011604ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x0000001f1a057211ULL, 0x040fe200078038ffULL, 0x000000ffff217224ULL, 0x012fe200078e0006ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000001005107210ULL, 0x000fe40007f3e0ffULL, 0x000000ff1a047211ULL, 0x000fe400000f3cffULL,
0x0000078010237810ULL, 0x000fc80007f5e0ffULL, 0x00000004ff117210ULL, 0x000fd200017e2411ULL,
0x000000040a007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050c007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000002106067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000423047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0611ULL,
0xfffc800604217981ULL, 0x000326000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000000706067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000423047210ULL, 0x000fc80007f3e0ffULL, 0x00000011ff057210ULL, 0x000fca0000ffe4ffULL,
0xfffd000604077981ULL, 0x000328000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000000d06067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000423047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0611ULL,
0xfffd8006040d7981ULL, 0x000326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000000f06067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000423047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0611ULL,
0xfffe0006040f7981ULL, 0x000326000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x0000001506067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000402047819ULL, 0x002fe400000006ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000423047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0611ULL,
0xfffe800604157981ULL, 0x000326000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x0000001706067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000423047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0611ULL,
0xffff000604177981ULL, 0x000326000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001906067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000423047210ULL, 0x000fc80007f3e0ffULL, 0x00000011ff057210ULL, 0x000fca0000ffe4ffULL,
0xffff800604197981ULL, 0x000328000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000001b06067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000423047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0611ULL,
0x00000006041b7981ULL, 0x000326000c1e1900ULL, 0x0000040023237810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc8000fffe03fULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0xfffffff8002c8947ULL, 0x000fee000383ffffULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff077819ULL, 0x010fc80000011602ULL,
0x0000007004057812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fc800078ec0ffULL,
0x0000001c07057210ULL, 0x000fca0007ffe005ULL, 0x0000000605007388ULL, 0x0003e40000000800ULL,
0x00009a00ff247b82ULL, 0x000ea20000000a00ULL, 0x000000070200780cULL, 0x040fe20003f04070ULL,
0x0000001002217824ULL, 0x002fe200078e00ffULL, 0x0000000155067812ULL, 0x000fe200078ec0ffULL,
0x0000006002117836ULL, 0x000fe20000000000ULL, 0x0000000b481b7819ULL, 0x000fe400000006ffULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000001ff207819ULL, 0x000fe40000011602ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x000008001b1b7812ULL, 0x000fe400078ee2ffULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x00000040020f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x0000007021217812ULL, 0x000fe200078ec0ffULL,
0x0000020055058824ULL, 0x140fe200078e021cULL, 0x0000000c20207812ULL, 0x000fe200078ec0ffULL,
0x00000200550d8824ULL, 0x000fe200078e021cULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000500078211ULL, 0x040fe200078e40ffULL,
0x00000100000d8824ULL, 0x000fe200078e020dULL, 0x0000001c20237210ULL, 0x080fe20007ffe021ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002413187210ULL, 0x004fe20007f3e0ffULL,
0x0000000155137824ULL, 0x040fe200078e021aULL, 0x000000241f1f7210ULL, 0x000fe20007f7e0ffULL,
0x0000008006178824ULL, 0x040fe200078e0207ULL, 0x0000001c55077211ULL, 0x000fe200078e68ffULL,
0x000000ffff197224ULL, 0x000fe200008e0625ULL, 0x000000241d1d7210ULL, 0x000fe20007f3e0ffULL,
0x0000008006278824ULL, 0x000fe200078e020dULL, 0x000008001e0d7812ULL, 0x000fe200078ec0ffULL,
0x0000100013047825ULL, 0x000fe200078e0018ULL, 0x0000000023237984ULL, 0x000e620000000800ULL,
0x0000001702178211ULL, 0x000fc400078e20ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00001000001e7824ULL, 0x000fe200078e0207ULL, 0x0000001b04047210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff227224ULL, 0x000fe200008e0625ULL, 0x0000001d13108211ULL, 0x040fe200078238ffULL,
0x000000011e0d7824ULL, 0x000fe200078e020dULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff057224ULL, 0x000fe200010e0605ULL, 0x0000001f13128211ULL, 0x000fe200078438ffULL,
0x0000002002077836ULL, 0x000fe20000000000ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000001002157824ULL, 0x000fe200078e020dULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000ffff247224ULL, 0x000fe200018e0625ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000100f0c7825ULL, 0x000fe200078e0004ULL, 0x0000000000347805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x00000010110e7825ULL, 0x100fe200078e0004ULL,
0x0000002213118211ULL, 0x000fe400008f3cffULL, 0x0000000a5500720cULL, 0x000fe20003f26070ULL,
0x0000001007067825ULL, 0x000fe200078e0004ULL, 0x0000002413138211ULL, 0x000fc600010f3cffULL,
0x0000001002047825ULL, 0x000fc800078e0004ULL, 0x0000001002108825ULL, 0x040fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004157faeULL, 0x000fe6000b901c46ULL,
0x0000001002298824ULL, 0x040fe200078e0227ULL, 0x0038000006157faeULL, 0x000fe2000b901c46ULL,
0x0000001002128825ULL, 0x000fe200078e0012ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x005800000c157faeULL, 0x000fe2000b901c46ULL, 0x000000ffff257224ULL, 0x000fc400078e00ffULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x007800000e157faeULL, 0x000fe2000b901c46ULL,
0x000000ffff467224ULL, 0x000fc600078e00ffULL, 0x0458000010178faeULL, 0x000fe8000b901c46ULL,
0x0418000012298faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000287805ULL, 0x004fe2000001ff00ULL, 0x0000000800b81947ULL, 0x002fec0003800000ULL,
0x00000003ff047819ULL, 0x100fe20000011602ULL, 0x000000ffff477224ULL, 0x000fe200078e0055ULL,
0xfffffff8ff057812ULL, 0x000fe400078ee202ULL, 0x0000000304047812ULL, 0x000fe400078ec0ffULL,
0x0000000805077810ULL, 0x000fe20007ffe0ffULL, 0x0000000805067824ULL, 0x040fe200078e00ffULL,
0x00000002ff4f7819ULL, 0x000fe20000011602ULL, 0x0000000805487824ULL, 0x000fe200078e00ffULL,
0x00000003070d7819ULL, 0x000fe200000006ffULL, 0x0000000104057824ULL, 0x040fe200078e0205ULL,
0x000000ff00257202ULL, 0x000fe20000000f00ULL, 0x00000001044c7824ULL, 0x000fc400078e0207ULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0xfffffff848487812ULL, 0x000fe200078ee205ULL,
0x00000004054d7836ULL, 0x000fe20000000000ULL, 0xfffffff80d4c7812ULL, 0x000fe200078ee24cULL,
0x0000000c054e7836ULL, 0x000fe40000000000ULL, 0x0000020055057824ULL, 0x000fe200078e021cULL,
0xfffffff8064d7812ULL, 0x000fe200078ee24dULL, 0x000000084f457836ULL, 0x000fe20000000000ULL,
0xfffffff8074e7812ULL, 0x000fe200078ee24eULL, 0x0000010000507824ULL, 0x000fce00078e0205ULL,
0x0000000147077836ULL, 0x000fca0000000000ULL, 0x0000000a0700720cULL, 0x000fda0003f06070ULL,
0x0000000000a00947ULL, 0x000fea0003800000ULL, 0x000000070200780cULL, 0x000fe20003f44070ULL,
0x0000080007067824ULL, 0x040fe200078e00ffULL, 0x000000071a0d7210ULL, 0x000fe20007ffe0ffULL,
0x0000004002537836ULL, 0x000fe20000000000ULL, 0x0000000107517812ULL, 0x000fe200078ec0ffULL,
0x0000006002577836ULL, 0x010fe40000000000ULL, 0x000010000d047825ULL, 0x000fc600078e0018ULL,
0x0000001b040e7210ULL, 0x000fc60007f1e0ffULL, 0x00000200550fa824ULL, 0x100fe200078e021cULL,
0x0000001f0d0ca211ULL, 0x000fe200078238ffULL, 0x000002005507a824ULL, 0x000fe400078e021cULL,
0x000001000050a824ULL, 0x000fe200078e020fULL, 0x00000005ff0f7210ULL, 0x000fe400007fe4ffULL,
0x0000080006057812ULL, 0x000fe200078ec0ffULL, 0x000000805117a824ULL, 0x000fe200078e0250ULL,
0x0000001d0d10a211ULL, 0x040fe200078038ffULL, 0x000001000050a824ULL, 0x000fe200078e0207ULL,
0x000000051e057210ULL, 0x000fe20007ffe0ffULL, 0x0000002002077836ULL, 0x000fe20000000000ULL,
0x000000220d11a211ULL, 0x040fe200000f3cffULL, 0x0000001002127825ULL, 0x000fe200078e000eULL,
0x000000240d0da211ULL, 0x000fc600008f3cffULL, 0x0000001002157824ULL, 0x040fe400078e0205ULL,
0x000000805151a824ULL, 0x000fe400078e0250ULL, 0x0000001007047825ULL, 0x100fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000012157faeULL, 0x0003e4000b901c46ULL,
0x000000510251a211ULL, 0x040fe200078e20ffULL, 0x0000001053067825ULL, 0x100fe200078e000eULL,
0x0038000004157faeULL, 0x0003e6000b901c46ULL, 0x00000010570e7825ULL, 0x000fe200078e000eULL,
0x0058000006157faeULL, 0x0003e6000b901c46ULL, 0x000000100210a825ULL, 0x040fe200078e0010ULL,
0x007800000e157faeULL, 0x0003e6000b901c46ULL, 0x000000100217a824ULL, 0x000fc400078e0217ULL,
0x00000010020ca825ULL, 0x000fc600078e000cULL, 0x045800001017afaeULL, 0x0003e8000b901c46ULL,
0x041800000c51afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000008047047824ULL, 0x002fca00078e00ffULL, 0x0000008004047812ULL, 0x000fc800078ec0ffULL,
0x0000005021057210ULL, 0x000fe20007ffe004ULL, 0x0000080047047824ULL, 0x000fe400078e00ffULL,
0x0000000247477836ULL, 0x000fe40000000000ULL, 0x0000000120517824ULL, 0x000fe200078e0205ULL,
0x0000080004057812ULL, 0x000fe400078ec0ffULL, 0x0000000a4700720cULL, 0x000fe40003f06070ULL,
0x000001801e157810ULL, 0x000fe20007ffe005ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800051127984ULL, 0x000e620000000800ULL, 0x0000001048047824ULL, 0x100fe200078e0215ULL,
0x000000154d0c7211ULL, 0x000fe200078e20ffULL, 0x000000104c107824ULL, 0x100fe200078e0215ULL,
0x0045800051537984ULL, 0x000fe20000000800ULL, 0x000000104e157824ULL, 0x000fc600078e0215ULL,
0x000000000404783bULL, 0x000ea80000000200ULL, 0x000000000c0c783bULL, 0x000ee20000000200ULL,
0x0000001223147221ULL, 0x002fc60000010100ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x3fb8aa3b14567820ULL, 0x000fc60000410000ULL, 0x000000001514783bULL, 0x000f620000000200ULL,
0x0001000004517824ULL, 0x044fe200078e00ffULL, 0x0000763204047816ULL, 0x000fe20000000004ULL,
0x0000005600567308ULL, 0x000ea20000000800ULL, 0x0000763205527816ULL, 0x040fe20000000052ULL,
0x0001000005057824ULL, 0x000fe200078e00ffULL, 0x000076320f597816ULL, 0x048fe20000000059ULL,
0x0001000004047824ULL, 0x000fe200078e00ffULL, 0x000000100f5a7819ULL, 0x000fe200000006ffULL,
0x000100000c577824ULL, 0x010fe200078e00ffULL, 0x0000763207547816ULL, 0x040fe20000000054ULL,
0x0001000007077824ULL, 0x000fe200078e00ffULL, 0x000076320e587816ULL, 0x040fe20000000058ULL,
0x000100000e0e7824ULL, 0x000fe200078e00ffULL, 0x0000001052527819ULL, 0x000fe200000006ffULL,
0x0001000054547824ULL, 0x000fc400078e00ffULL, 0x0000005356627220ULL, 0x004fe20000410000ULL,
0x000076320c567816ULL, 0x000fe40000000056ULL, 0x0000763206537816ULL, 0x000fe20000000053ULL,
0x0000004662467221ULL, 0x000fe20000010000ULL, 0x00001f4f62637589ULL, 0x000ea200000e0000ULL,
0x000076320d0c7816ULL, 0x040fe2000000000cULL, 0x000100000d0d7824ULL, 0x000fe200078e00ffULL,
0x0000001006067819ULL, 0x000fe200000006ffULL, 0x00001f4562627589ULL, 0x000ee200000e0000ULL,
0x0001000053537824ULL, 0x000fc400078e00ffULL, 0x000100000c0c7824ULL, 0x000fe200078e00ffULL,
0x00007632100f7816ULL, 0x042fe2000000000fULL, 0x00010000105b7824ULL, 0x000fe200078e00ffULL,
0x0000763211107816ULL, 0x040fe20000000010ULL, 0x00010000115c7824ULL, 0x000fe200078e00ffULL,
0x0000763212117816ULL, 0x040fe20000000011ULL, 0x00010000125d7824ULL, 0x000fe200078e00ffULL,
0x00007632145e7816ULL, 0x020fe2000000005eULL, 0x0001000016617824ULL, 0x000fe200078e00ffULL,
0x00000010145f7819ULL, 0x000fe200000006ffULL, 0x000100000f0f7824ULL, 0x000fe200078e00ffULL,
0x0000763216607816ULL, 0x000fe20000000060ULL, 0x0001000010107824ULL, 0x000fc400078e00ffULL,
0x0000006305367223ULL, 0x084fe20000010036ULL, 0x0000006304377223ULL, 0x080fe20000010037ULL,
0x0001000056057824ULL, 0x000fe200078e00ffULL, 0x0000763213127816ULL, 0x000fe20000000012ULL,
0x0001000059047824ULL, 0x000fe200078e00ffULL, 0x0000763215147816ULL, 0x000fe20000000014ULL,
0x00000063053c7223ULL, 0x080fe2000001003cULL, 0x0000763217167816ULL, 0x000fe20000000016ULL,
0x0000006304397223ULL, 0x000fe20000010039ULL, 0x0000001058057819ULL, 0x000fe200000006ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x0000001012127819ULL, 0x000fe200000006ffULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x0000001016167819ULL, 0x000fe200000006ffULL,
0x0001000017177824ULL, 0x000fc400078e00ffULL, 0x0000006351387223ULL, 0x080fe20000010038ULL,
0x0001000011047824ULL, 0x000fe400078e00ffULL, 0x0000006352357223ULL, 0x080fe20000010035ULL,
0x000100005e5e7824ULL, 0x000fe400078e00ffULL, 0x0000006306437223ULL, 0x080fe20000010043ULL,
0x0001000014147824ULL, 0x000fe400078e00ffULL, 0x00000063533e7223ULL, 0x000fe2000001003eULL,
0x0001000060607824ULL, 0x000fc400078e00ffULL, 0x0000006307427223ULL, 0x080fe20000010042ULL,
0x00000063543d7223ULL, 0x080fe2000001003dULL, 0x0000006357407223ULL, 0x080fe20000010040ULL,
0x000000630d447223ULL, 0x080fe20000010044ULL, 0x000000630c3b7223ULL, 0x080fe2000001003bULL,
0x000000630e417223ULL, 0x080fe20000010041ULL, 0x00000063053a7223ULL, 0x080fe2000001003aULL,
0x000000635a3f7223ULL, 0x000fe2000001003fULL, 0x000000625b347223ULL, 0x088fe20000010034ULL,
0x000000620f2e7223ULL, 0x080fe2000001002eULL, 0x000000625c2d7223ULL, 0x080fe2000001002dULL,
0x0000006210337223ULL, 0x080fe20000010033ULL, 0x000000625d327223ULL, 0x080fe20000010032ULL,
0x0000006204317223ULL, 0x080fe20000010031ULL, 0x00000062132c7223ULL, 0x080fe2000001002cULL,
0x00000062122b7223ULL, 0x080fe2000001002bULL, 0x000000625f2a7223ULL, 0x080fe2000001002aULL,
0x000000625e297223ULL, 0x080fe20000010029ULL, 0x0000006215307223ULL, 0x080fe20000010030ULL,
0x00000062142f7223ULL, 0x080fe2000001002fULL, 0x0000006261287223ULL, 0x080fe20000010028ULL,
0x0000006260277223ULL, 0x080fe20000010027ULL, 0x0000006217267223ULL, 0x080fe20000010026ULL,
0x0000006216257223ULL, 0x000fe20000010025ULL, 0xfffffff400a08947ULL, 0x000fec000383ffffULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe20000011602ULL,
0x000049801c027836ULL, 0x000fc60000000000ULL, 0x0000007004077812ULL, 0x000fe400078ec0ffULL,
0x0000000c05067812ULL, 0x000fca00078ec0ffULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x00000080551c7824ULL, 0x000fe400078e021cULL,
0x0000001004057824ULL, 0x002fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fc80000011604ULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000001c04057210ULL, 0x000fca0007ffe005ULL, 0x0049804605007388ULL, 0x0003e40000000800ULL,
0x0000000206027210ULL, 0x000fe20007ffe007ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002047984ULL, 0x000ea80000000800ULL, 0x0000800002057984ULL, 0x002e620000000800ULL,
0x00000004ff047221ULL, 0x004fc80000010000ULL, 0x0000000504047221ULL, 0x002fca0000010000ULL,
0x0180000004057810ULL, 0x000fc80007ffe0ffULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000a810000c7802ULL, 0x000fce0000000f00ULL,
0x0000008c00207944ULL, 0x010fea0003c00000ULL, 0x000000ffff057224ULL, 0x008fe200078e0002ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000400057308ULL, 0x000e640000001000ULL,
0xbf80000004027423ULL, 0x002fc80000000005ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000205057223ULL, 0x000fce0000000005ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x00000002ff047819ULL, 0x102fe40000011602ULL, 0x0000000802107811ULL, 0x000fe400078ff0ffULL,
0x00000003ff197819ULL, 0x000fe20000011602ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0405047589ULL, 0x000e6800000e0000ULL, 0x00001f1005107589ULL, 0x0004e200000e0000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0xfffffff8ff057812ULL, 0x004fca00078ee202ULL,
0x0000000805157836ULL, 0x000fe40000000000ULL, 0x0000000805187824ULL, 0x040fe400078e00ffULL,
0x00000008051b7824ULL, 0x000fe400078e00ffULL, 0x0000003804387220ULL, 0x042fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000003604367220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000004304067220ULL, 0x040fe20000410000ULL,
0x0000003e04077220ULL, 0x040fe20000410000ULL, 0x0000004204427220ULL, 0x040fe20000410000ULL,
0x0000003d043d7220ULL, 0x040fe20000410000ULL, 0x00000040040c7220ULL, 0x040fe20000410000ULL,
0x0000003c040d7220ULL, 0x040fe20000410000ULL, 0x0000004404447220ULL, 0x040fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x00000041040e7220ULL, 0x040fe20000410000ULL,
0x0000003a040f7220ULL, 0x040fe20000410000ULL, 0x0000003f043f7220ULL, 0x040fe20000410000ULL,
0x00000039040a7220ULL, 0x000fe20000410000ULL, 0x0000000319047812ULL, 0x000fe200078ec0ffULL,
0x0000003410347220ULL, 0x048fe20000410000ULL, 0x0000002e10117220ULL, 0x040fe20000410000ULL,
0x0000002d102d7220ULL, 0x040fe20000410000ULL, 0x0000000504057210ULL, 0x000fe20007ffe0ffULL,
0x0000003310127220ULL, 0x040fe20000410000ULL, 0x0000003210327220ULL, 0x040fe20000410000ULL,
0x0000003110317220ULL, 0x040fe20000410000ULL, 0x0000002c10137220ULL, 0x040fe20000410000ULL,
0x0000002b10147220ULL, 0x040fe20000410000ULL, 0x0000002a102a7220ULL, 0x040fe20000410000ULL,
0x0000002910297220ULL, 0x040fe20000410000ULL, 0x0000003010307220ULL, 0x040fe20000410000ULL,
0x0000002f102f7220ULL, 0x040fe20000410000ULL, 0x0000002810287220ULL, 0x040fe20000410000ULL,
0x0000002710277220ULL, 0x040fe20000410000ULL, 0x0000002610267220ULL, 0x040fe20000410000ULL,
0x0000002510257220ULL, 0x000fe20000410000ULL, 0x0000000104107824ULL, 0x000fe200078e0215ULL,
0x0000000c05167810ULL, 0x000fe20007ffe0ffULL, 0x0000000405047836ULL, 0x000fe20000000000ULL,
0xfffffff818057812ULL, 0x000fe200078ee205ULL, 0x0000000815177824ULL, 0x000fe200078e00ffULL,
0x0000000e0f0e723eULL, 0x000fe200000010ffULL, 0x00000008151d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b157812ULL, 0x000fe200078ee204ULL, 0x0000001005187824ULL, 0x000fe200078e0208ULL,
0xfffffff817177812ULL, 0x000fc400078ee210ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee216ULL,
0x00000010151a7824ULL, 0x100fe200078e0208ULL, 0x000000060706723eULL, 0x000fe200000010ffULL,
0x00000010171b7824ULL, 0x100fe200078e0208ULL, 0x0000003f0a0f723eULL, 0x000fe200000010ffULL,
0x000000101d087824ULL, 0x000fe200078e0208ULL, 0x000000383704723eULL, 0x000fe400000010ffULL,
0x000000363505723eULL, 0x000fe400000010ffULL, 0x000000423d07723eULL, 0x000fc400000010ffULL,
0x0000000c0d0c723eULL, 0x000fe400000010ffULL, 0x000000341110723eULL, 0x000fe200000010ffULL,
0x0000000418007844ULL, 0x000fe20000000200ULL, 0x00000002030a7210ULL, 0x000fe40007ffe0ffULL,
0x000000443b0d723eULL, 0x000fe200000010ffULL, 0x000000ff00037306ULL, 0x000e620000202400ULL,
0x0000002d1211723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x000fe200078e020bULL,
0x000000323112723eULL, 0x000fe200000010ffULL, 0x0000000c1a007844ULL, 0x000fe20000000200ULL,
0x000000131413723eULL, 0x000fc400000010ffULL, 0x0000002a2914723eULL, 0x000fe400000010ffULL,
0x000000302f15723eULL, 0x000fe200000010ffULL, 0x000000101b007844ULL, 0x000fe20000000200ULL,
0x000000282716723eULL, 0x000fe400000010ffULL, 0x000000262517723eULL, 0x000fca00000010ffULL,
0x0000001408007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000a1c7984ULL, 0x000e680000000c00ULL, 0x000400000a247984ULL, 0x000ea80000000c00ULL,
0x000800000a207984ULL, 0x000ee80000000c00ULL, 0x000c00000a287984ULL, 0x000f620000000c00ULL,
0x0000001f031f7230ULL, 0x002fc40000200800ULL, 0x0000001e031e7230ULL, 0x040fe40000200800ULL,
0x0000001d031d7230ULL, 0x040fe40000200800ULL, 0x0000001c031c7230ULL, 0x040fe40000200800ULL,
0x0000002703277230ULL, 0x044fe40000200800ULL, 0x0000002603267230ULL, 0x040fe40000200800ULL,
0x0000002503257230ULL, 0x000fc40000200800ULL, 0x0000002403247230ULL, 0x000fe40000200800ULL,
0x000000231f1f7230ULL, 0x008fe40000200000ULL, 0x000000221e1e7230ULL, 0x000fe40000200000ULL,
0x000000211d1d7230ULL, 0x000fe40000200000ULL, 0x000000201c1c7230ULL, 0x000fe40000200000ULL,
0x0000002b27277230ULL, 0x020fc40000200000ULL, 0x0000002a26267230ULL, 0x000fe20000200000ULL,
0x0000001c0a007388ULL, 0x0003e20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000200000ULL,
0x0000002824247230ULL, 0x000fca0000200000ULL, 0x000400240a007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff5500720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x000000491900720cULL, 0x000fe20003f06070ULL, 0x0000840000057ab9ULL, 0x000fe40000000800ULL,
0x00000005040472a4ULL, 0x004fd4000f8e023fULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00008600ff0a7b82ULL, 0x002e620000000800ULL, 0x0000000119037824ULL, 0x000fe200078e0202ULL,
0x000000194a197211ULL, 0x000fe200078e20ffULL, 0xffffffffff057424ULL, 0x000fe200078e00ffULL,
0x0000880000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000409067c24ULL, 0x000fe2000f8e02ffULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x0000002002147836ULL, 0x000fc60000000000ULL,
0x0ffffff803047812ULL, 0x000fe400078ef802ULL, 0x00000003ff077819ULL, 0x000fc60000011614ULL,
0x0000001004037824ULL, 0x000fca00078e020bULL, 0x00000000030c7984ULL, 0x0004e20000000c00ULL,
0x0000000a05107219ULL, 0x082fe400000006ffULL, 0x0000000a4b127219ULL, 0x000fe400000006ffULL,
0x0000001019057212ULL, 0x000fe400078e30ffULL, 0x0000000aff047219ULL, 0x000fe40000011619ULL,
0x0000000702037812ULL, 0x004fe200078ec0ffULL, 0x0000000112057824ULL, 0x000fc800078e0205ULL,
0x0000000904057224ULL, 0x000fe400078e0205ULL, 0x0000000800037824ULL, 0x000fc600078e0203ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe400080f4408ULL,
0x000000490700720cULL, 0x000fe20003f06070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0083ee000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000714037210ULL, 0x000fe20007ffe0ffULL, 0x000000104a077824ULL, 0x000fe200078e0207ULL,
0x0000004002117810ULL, 0x000fe40007ffe0ffULL, 0x0000000703037812ULL, 0x000fe400078ec0ffULL,
0x0000001007057212ULL, 0x002fe400078e30ffULL, 0x0ffffff803047812ULL, 0x000fc600078ef814ULL,
0x0000000112057824ULL, 0x000fe400078e0205ULL, 0x0000001004037824ULL, 0x000fe200078e020bULL,
0x0000000aff047219ULL, 0x000fe40000011607ULL, 0x0000000714077812ULL, 0x000fe400078ec0ffULL,
0x00000000030c7984ULL, 0x0002a20000000c00ULL, 0x0000000904057224ULL, 0x000fe400078e0205ULL,
0x0000000800077824ULL, 0x000fc600078e0207ULL, 0x0000000506057210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff037819ULL, 0x002fc60000011611ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe400080f4408ULL,
0x000000490300720cULL, 0x000fe20003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000111047824ULL, 0x102fe400078e0203ULL, 0x000000104a037824ULL, 0x000fe400078e0203ULL,
0x0000006002137836ULL, 0x000fe20000000000ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000001003057212ULL, 0x000fe400078e30ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef811ULL,
0x0000000aff087219ULL, 0x000fc40000011603ULL, 0x0000000512057210ULL, 0x000fe20007ffe0ffULL,
0x0000001004047824ULL, 0x000fc800078e020bULL, 0x0000000908057224ULL, 0x000fe200078e0205ULL,
0x00000000040c7984ULL, 0x0002a80000000c00ULL, 0x0000000506037210ULL, 0x000fe40007f1e0ffULL,
0x0000000711057812ULL, 0x000fe400078ec0ffULL, 0x00000003ff047819ULL, 0x002fe20000011613ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fe2000f8040ffULL,
0x0000000800057824ULL, 0x000fc400078e0205ULL, 0x0000000113077824ULL, 0x000fe200078e0204ULL,
0x0000000903037c11ULL, 0x000fe400080f4408ULL, 0x000000490400720cULL, 0x000fe40003f06070ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x0000001005027825ULL, 0x000fc600078e0002ULL,
0xfffffff807087812ULL, 0x000fe400078ef813ULL, 0x0000000c02007986ULL, 0x0043ea000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000b08087211ULL, 0x000fe200078e20ffULL,
0x000000104a047824ULL, 0x000fe200078e0204ULL, 0x0000000713057812ULL, 0x000fc600078ec0ffULL,
0x00000000080c7984ULL, 0x002e620000000c00ULL, 0x0000001004027212ULL, 0x000fe200078e30ffULL,
0x0000000800057824ULL, 0x000fe200078e0205ULL, 0x0000000aff047219ULL, 0x000fc60000011604ULL,
0x0000000112027824ULL, 0x000fc800078e0202ULL, 0x0000000904097224ULL, 0x000fca00078e0202ULL,
0x0000000906097210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000000809027c11ULL, 0x000fc8000f8040ffULL, 0x0000000909037c11ULL, 0x000fc600080f4404ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff097819ULL, 0x000fe20000011648ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x00008e00ff107b82ULL, 0x000e620000000a00ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x000000094c097211ULL, 0x000fc800078e08ffULL,
0x000000060900720cULL, 0x000fda0003f06070ULL, 0x00009400ff0d8b82ULL, 0x000ea20000000800ULL,
0x000000024d028824ULL, 0x000fce00078e00ffULL, 0x00009000ff148b82ULL, 0x000ee20000000a00ULL,
0x0000000d020d8224ULL, 0x004fc800078e0209ULL, 0x000000040d148825ULL, 0x008fe400078e0014ULL,
0x01b6000c070c79a7ULL, 0x0004a6000850003fULL, 0x0000000614048981ULL, 0x000ee2000c1e1900ULL,
0x000000014c0e7836ULL, 0x000fe20000000000ULL, 0x0000000703037819ULL, 0x000fe200000006ffULL,
0x0000004048027824ULL, 0x000fe400078e00ffULL, 0x000000804b4b7824ULL, 0x000fe200078e00ffULL,
0x000000050e00720cULL, 0x000fe20003f06070ULL, 0x000001004c0e7824ULL, 0x000fca00078e0202ULL,
0x000000404b137812ULL, 0x000fe200078ef80eULL, 0x0000000304177224ULL, 0x008fc800078e02ffULL,
0x0000010017107825ULL, 0x002fe400078e0010ULL, 0x0000000c00208947ULL, 0x004fea0003800000ULL,
0x00000003ff257819ULL, 0x000fe40000011608ULL, 0x0000000e0f127248ULL, 0x000fe40007fe0000ULL,
0x0000001825377810ULL, 0x000fe20007ffe0ffULL, 0x00000008251d7836ULL, 0x000fe20000000000ULL,
0x000000120e127210ULL, 0x000fe20007ffe1ffULL, 0x0000000425157836ULL, 0x000fe20000000000ULL,
0x0000002825357810ULL, 0x000fe20007ffe0ffULL, 0x000000081d187824ULL, 0x000fe200078e00ffULL,
0x000000081d177210ULL, 0x000fe20007ffe0ffULL, 0x0000000113167824ULL, 0x000fe200078e0215ULL,
0x000000121500720cULL, 0x000fe20003fa6070ULL, 0x0000001025217836ULL, 0x000fe20000000000ULL,
0xfffffff818397812ULL, 0x000fe200078ee217ULL, 0x0000000113147824ULL, 0x000fc400078e0225ULL,
0x00000001150e7824ULL, 0x040fe400078e0208ULL, 0x00000008152f7824ULL, 0x000fe400078e00ffULL,
0x0000010016167825ULL, 0x000fc600078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20eULL,
0x00000001212b7824ULL, 0x040fe200078e0208ULL, 0x0000007016197812ULL, 0x000fe200078ef80bULL,
0x0000000821187824ULL, 0x000fe400078e00ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000001910167210ULL, 0x000fe40007f3e0ffULL, 0xfffffff8182b7812ULL, 0x000fe200078ee22bULL,
0x0000000c251f7836ULL, 0x000fe20000000000ULL, 0x00000070141b7812ULL, 0x000fe200078ef80bULL,
0x0000000113187824ULL, 0x040fe200078e021dULL, 0x0000001711177210ULL, 0x000fe20000ffe4ffULL,
0x00000001131a7824ULL, 0x000fe200078e021fULL, 0x0000001b10147210ULL, 0x000fe20007f1e0ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000121d00720cULL, 0x000fc40003f26070ULL,
0x000000081f0e7210ULL, 0x000fe20007ffe0ffULL, 0x00000001131c7824ULL, 0x000fe200078e0221ULL,
0x0000007018237812ULL, 0x000fe200078ef80bULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x000000121f00720cULL, 0x080fe40003f46070ULL, 0x0000002310207210ULL, 0x000fe20007f7e0ffULL,
0x00000014252d7836ULL, 0x000fe40000000000ULL, 0x0000000111157824ULL, 0x000fe200000e0615ULL,
0x000000122100720cULL, 0x000fe20003f06070ULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x000000701a217812ULL, 0x000fc400078ef80bULL, 0x000000032d3d7819ULL, 0x000fe200000006ffULL,
0x00000001131e7824ULL, 0x000fe200078e022dULL, 0x000000701c237812ULL, 0x000fe200078ef80bULL,
0x000000081f3b7824ULL, 0x000fe200078e00ffULL, 0x0000002110227210ULL, 0x000fe20007f9e0ffULL,
0x000001001e1e7825ULL, 0x000fc600078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20eULL,
0x0000000113267824ULL, 0x000fe400078e0237ULL, 0x0000000111217824ULL, 0x040fe200018e0619ULL,
0x00000023101c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000111237824ULL, 0x000fe200020e061bULL,
0x000000701e1b7812ULL, 0x000fe200078ef80bULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0x0000001d111d7210ULL, 0x000fe40001ffe4ffULL, 0x0000001b101a7210ULL, 0x000fe20007f7e0ffULL,
0x0000001c25417836ULL, 0x000fe20000000000ULL, 0x0000007026197812ULL, 0x000fe200078ef80bULL,
0x0000000125247824ULL, 0x000fc400078e0208ULL, 0x00000001131e7824ULL, 0x000fe200078e0241ULL,
0x0000001910187210ULL, 0x000fe20007f9e0ffULL, 0x00000001111b7824ULL, 0x000fe200018e061fULL,
0x0000000724297812ULL, 0x000fe200078ec0ffULL, 0x000001001e1e7825ULL, 0x000fe200078e00ffULL,
0x0000002711197210ULL, 0x000fe400027fe4ffULL, 0x0ffffff829297812ULL, 0x000fe200078ef808ULL,
0x0000002025317836ULL, 0x000fe20000000000ULL, 0x000000701e277812ULL, 0x000fe200078ef80bULL,
0x00004000480e7824ULL, 0x000fe200078e0207ULL, 0x000000122500720cULL, 0x080fe20003f86070ULL,
0x0000000113267824ULL, 0x000fe200078e0231ULL, 0x00000027101e7210ULL, 0x000fe20007fde0ffULL,
0x000010000e0e7836ULL, 0x000fe20000000000ULL, 0x000000122d00720cULL, 0x000fe20003f66070ULL,
0x0000010026267825ULL, 0x000fc800078e00ffULL, 0x0000002425337836ULL, 0x000fe40000000000ULL,
0x000000012d247824ULL, 0x000fe400078e0208ULL, 0x00000010292d7824ULL, 0x000fe200078e020eULL,
0x0000007026297812ULL, 0x000fe200078ef80bULL, 0x0000000113287824ULL, 0x000fe200078e0233ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee224ULL, 0x00000001111f7824ULL, 0x000fe200030e061fULL,
0x0000002910267210ULL, 0x000fe20007fde0ffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000142d7faeULL, 0x0003e2000e101c46ULL,
0x000000123700720cULL, 0x000fc40003f86070ULL, 0x0000000113247824ULL, 0x000fe400078e0235ULL,
0x0000000111277824ULL, 0x000fe400030e0627ULL, 0x00000001372a7824ULL, 0x040fe400078e0208ULL,
0x00000008373f7824ULL, 0x000fe200078e00ffULL, 0x0000002c25377810ULL, 0x000fe20007ffe0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e020eULL, 0x0000000e2f2d7211ULL, 0x002fe200078e20ffULL,
0x0000010024147825ULL, 0x000fe200078e00ffULL, 0x00000070282f7812ULL, 0x000fc400078ef80bULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee22aULL, 0x00000000162d7faeULL, 0x0003e2000e901c46ULL,
0x0000002f10287210ULL, 0x000fe20007fde0ffULL, 0x0000000141247824ULL, 0x100fe200078e0208ULL,
0x00000070142f7812ULL, 0x000fe200078ef80bULL, 0x00000001332a7824ULL, 0x000fe200078e0208ULL,
0x000000124100720cULL, 0x000fe20003fa6070ULL, 0x0000000111297824ULL, 0x000fe200030e0629ULL,
0x0000002f10147210ULL, 0x000fe20007fde0ffULL, 0x00000010392f7824ULL, 0x000fe400078e020eULL,
0x0000000841417824ULL, 0x000fc400078e00ffULL, 0x0000000113167824ULL, 0x002fe200078e0237ULL,
0x00000000202f7faeULL, 0x0003e2000c901c46ULL, 0x000000103b2d7824ULL, 0x100fe200078e020eULL,
0xfffffff841417812ULL, 0x000fe200078ee224ULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000123100720cULL, 0x0c0fe40003f26070ULL, 0x00000000222d7faeULL, 0x0005e2000d101c46ULL,
0x0000000831247210ULL, 0x000fe20007ffe0ffULL, 0x0000000831397824ULL, 0x000fe200078e00ffULL,
0x000000123300720cULL, 0x040fe20003f46070ULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x0000007016317812ULL, 0x000fe200078ef80bULL, 0x0000000111157824ULL, 0x000fe200030e0615ULL,
0x000000001c2b7faeULL, 0x0007e2000c101c46ULL, 0x000000103d217824ULL, 0x002fe200078e020eULL,
0x0000003110167210ULL, 0x000fc40007fde0ffULL, 0xfffffff833317812ULL, 0x000fe200078ee22aULL,
0x0000003025337836ULL, 0x000fe20000000000ULL, 0x000000001a217faeULL, 0x0003e2000d901c46ULL,
0x000000103f237824ULL, 0x104fe200078e020eULL, 0x0000001711177210ULL, 0x000fe200037fe4ffULL,
0x00000010412d7824ULL, 0x100fe200078e020eULL, 0xfffffff8392f7812ULL, 0x000fe200078ee224ULL,
0x0000003825397836ULL, 0x000fe20000000000ULL, 0x0000000018237faeULL, 0x0005e2000e101c46ULL,
0x00000001131c7824ULL, 0x008fe200078e0233ULL, 0x0000000e31317211ULL, 0x000fe200078e20ffULL,
0x00000034252b7836ULL, 0x000fe20000000000ULL, 0x000000001e2d7faeULL, 0x0007e2000e901c46ULL,
0x000000102f2f7824ULL, 0x000fe200078e020eULL, 0x0000003c25257810ULL, 0x000fe20007ffe0ffULL,
0x00000001131a7824ULL, 0x002fe200078e022bULL, 0x000000123500720cULL, 0x080fe20003fa6070ULL,
0x0000000113207824ULL, 0x000fe200078e0239ULL, 0x00000000262f7faeULL, 0x0003e2000c901c46ULL,
0x000000123700720cULL, 0x080fe20003f86070ULL, 0x000001001c187825ULL, 0x004fe200078e00ffULL,
0x000000123300720cULL, 0x080fe20003f66070ULL, 0x0000000028317faeULL, 0x0005e2000d101c46ULL,
0x000000122b00720cULL, 0x080fe20003f46070ULL, 0x00000001351c7824ULL, 0x040fe200078e0208ULL,
0x00000070181b7812ULL, 0x000fe200078ef80bULL, 0x00000008351f7824ULL, 0x008fe200078e00ffULL,
0x000000123900720cULL, 0x000fe20003f26070ULL, 0x0000000833237824ULL, 0x000fe200078e00ffULL,
0x0000001b10187210ULL, 0x000fe20007fde0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fc400078ee21cULL, 0x000000122500720cULL, 0x000fe20003f06070ULL,
0x0000000111197824ULL, 0x000fe200030e0619ULL, 0x000000701a1d7812ULL, 0x000fe200078ef80bULL,
0x00000001331a7824ULL, 0x100fe200078e0208ULL, 0x0000000837127210ULL, 0x000fe20007ffe0ffULL,
0x0000000837217824ULL, 0x000fe200078e00ffULL, 0x0000001d101c7210ULL, 0x000fe20007fde0ffULL,
0x0000000113137824ULL, 0x000fe200078e0225ULL, 0xfffffff823237812ULL, 0x000fe200078ee21aULL,
0x000000012b1e7824ULL, 0x000fe200078e0208ULL, 0x0000001b111d7210ULL, 0x000fe200037fe4ffULL,
0x00000100201a7825ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fc600078ee212ULL,
0x0000010013127825ULL, 0x000fe200078e00ffULL, 0x000000701a277812ULL, 0x002fe400078ef80bULL,
0x0000000e21217211ULL, 0x000fe200078e20ffULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x00000027101a7210ULL, 0x000fe20007fde0ffULL, 0x0000000139207824ULL, 0x140fe200078e0208ULL,
0x0000000339397819ULL, 0x000fe200000006ffULL, 0x0000000125087824ULL, 0x040fe200078e0208ULL,
0x00000070120b7812ULL, 0x000fe200078ef80bULL, 0x0000000825297824ULL, 0x004fe200078e00ffULL,
0xfffffff82b257812ULL, 0x000fe200078ee21eULL, 0x00000001111b7824ULL, 0x000fe200030e061bULL,
0xfffffff839277812ULL, 0x000fe200078ee220ULL, 0x000000101f1f7824ULL, 0x100fe200078e020eULL,
0xfffffff829297812ULL, 0x000fe200078ee208ULL, 0x0000001023237824ULL, 0x100fe200078e020eULL,
0x0000000b10107210ULL, 0x000fe20007fde0ffULL, 0x0000001025257824ULL, 0x100fe200078e020eULL,
0x00000000141f7faeULL, 0x0003e2000e901c46ULL, 0x0000001027277824ULL, 0x100fe200078e020eULL,
0x0000001311117210ULL, 0x000fe200037fe4ffULL, 0x0000001029297824ULL, 0x000fe200078e020eULL,
0x0000000016217faeULL, 0x0003e8000e101c46ULL, 0x0000000018237faeULL, 0x0003e8000d901c46ULL,
0x000000001c257faeULL, 0x0003e8000d101c46ULL, 0x000000001a277faeULL, 0x0003e8000c901c46ULL,
0x0000000010297faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x0000000c081e7811ULL, 0x040fe400078fe8ffULL, 0x0000001008227811ULL, 0x040fe400078fe8ffULL,
0x00000004081a7811ULL, 0x000fe200078fe8ffULL, 0x000000081e317824ULL, 0x000fe200078e00ffULL,
0x000000081e147210ULL, 0x000fe20007ffe0ffULL, 0x0000000122157824ULL, 0x100fe200078e0208ULL,
0x0000001408247811ULL, 0x000fe200078fe8ffULL, 0x0000000822167824ULL, 0x000fe200078e00ffULL,
0x0000001c08267811ULL, 0x000fe200078fe8ffULL, 0x000000011a0e7824ULL, 0x100fe200078e0208ULL,
0x00000008081c7811ULL, 0x000fe200078fe8ffULL, 0x000000081a357824ULL, 0x000fe200078e00ffULL,
0x0000001808257811ULL, 0x000fe200078fe8ffULL, 0x0000000826297824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ee214ULL, 0x0000000124147824ULL, 0x100fe200078e0208ULL,
0xfffffff8162f7812ULL, 0x000fe200078ee215ULL, 0x0000000126167824ULL, 0x100fe200078e0208ULL,
0x00000003242d7819ULL, 0x000fe200000006ffULL, 0x000000011c127824ULL, 0x100fe200078e0208ULL,
0x0000002808177811ULL, 0x000fe200078fe8ffULL, 0x000000081c337824ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee20eULL, 0x0000000125157824ULL, 0x140fe200078e0208ULL,
0x0000002c08207811ULL, 0x040fe200078fe8ffULL, 0x0000000825187824ULL, 0x000fe200078e00ffULL,
0x00000020080e7811ULL, 0x000fe200078fe8ffULL, 0x00000001133e7824ULL, 0x000fe200078e0217ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee214ULL, 0x0000000117147824ULL, 0x140fe200078e0208ULL,
0xfffffff829297812ULL, 0x000fe200078ee216ULL, 0x0000000120167824ULL, 0x040fe200078e0208ULL,
0x00000003173d7819ULL, 0x000fe200000006ffULL, 0x0000000820197824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee212ULL, 0x000000080e397824ULL, 0x000fe200078e00ffULL,
0xfffffff8182b7812ULL, 0x000fe200078ee215ULL, 0x000001003e3e7825ULL, 0x000fe200078e00ffULL,
0x000000080e127210ULL, 0x000fc40007ffe0ffULL, 0x0000002408157811ULL, 0x040fe400078fe8ffULL,
0xfffffff83d3d7812ULL, 0x000fe400078ee214ULL, 0x00000034081d7811ULL, 0x040fe200078fe8ffULL,
0x00000008153b7824ULL, 0x040fe200078e00ffULL, 0x0000003008347811ULL, 0x000fe400078fe8ffULL,
0xfffffff819197812ULL, 0x000fe200078ee216ULL, 0x000000011c167824ULL, 0x100fe200078e0213ULL,
0x0000000808147211ULL, 0x000fe200078fe8ffULL, 0x00000001241c7824ULL, 0x000fe200078e0213ULL,
0xfffffff839397812ULL, 0x000fe200078ee212ULL, 0x0000000115127824ULL, 0x000fe200078e0208ULL,
0x00000038081f7811ULL, 0x000fe200078fe8ffULL, 0x0000000113247824ULL, 0x040fe200078e020eULL,
0x0000000714237812ULL, 0x000fe200078ec0ffULL, 0x0000000113307824ULL, 0x000fe200078e021dULL,
0x000000131a147210ULL, 0x000fe20007ffe0ffULL, 0x000000011d0e7824ULL, 0x140fe200078e0208ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee212ULL, 0x0000000134187824ULL, 0x100fe200078e0208ULL,
0x0000003c08217811ULL, 0x000fe200078fe8ffULL, 0x00000008341b7824ULL, 0x000fe200078e00ffULL,
0x0000001308127211ULL, 0x000fe200078fe8ffULL, 0x000000081d1d7824ULL, 0x000fe200078e00ffULL,
0x0000002013207210ULL, 0x000fe20007ffe0ffULL, 0x00000001221a7824ULL, 0x100fe200078e0213ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee218ULL, 0x0000000126227824ULL, 0x000fe200078e0213ULL,
0xfffffff81d2a7812ULL, 0x000fe200078ee20eULL, 0x0000000113267824ULL, 0x000fe200078e0215ULL,
0x0000001f132c7210ULL, 0x000fe20007ffe0ffULL, 0x000000011f157824ULL, 0x040fe200078e0208ULL,
0x0ffffff823237812ULL, 0x000fe200078ef808ULL, 0x000000081f2e7824ULL, 0x000fc400078e00ffULL,
0x000000011e187824ULL, 0x000fe200078e0213ULL, 0x00000013251e7210ULL, 0x000fe20007ffe0ffULL,
0x00004000480e7824ULL, 0x000fe200078e0207ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee215ULL,
0x0000000113347824ULL, 0x040fe400078e0234ULL, 0x0000000113287824ULL, 0x000fe400078e0221ULL,
0x0000000121087824ULL, 0x040fe200078e0208ULL, 0x0000000321217819ULL, 0x000fe200000006ffULL,
0x0000010012127825ULL, 0x000fc600078e00ffULL, 0xfffffff821327812ULL, 0x000fe200078ee208ULL,
0x000010000e367836ULL, 0x000fe20000000000ULL, 0x00000070121d7812ULL, 0x000fe200078ef80bULL,
0x0000010014147825ULL, 0x000fc600078e00ffULL, 0x0000001d10127210ULL, 0x000fe20007f1e0ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x000000361b0e7211ULL, 0x080fe400078e20ffULL,
0x0000003633337211ULL, 0x000fe200078e20ffULL, 0x0000001019087824ULL, 0x100fe200078e0236ULL,
0x0000007014197812ULL, 0x000fe200078ef80bULL, 0x0000000111137824ULL, 0x000fe200000e0613ULL,
0x00000070161d7812ULL, 0x000fe200078ef80bULL, 0x0000001023377824ULL, 0x000fe200078e0236ULL,
0x0000001910147210ULL, 0x000fe20007f3e0ffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000001d10167210ULL, 0x000fc40007f1e0ffULL, 0x0000001511157210ULL, 0x000fe20000ffe4ffULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x0000007018217812ULL, 0x000fe200078ef80bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012377faeULL, 0x0003e2000b901c46ULL,
0x0000003629297211ULL, 0x000fe200078e20ffULL, 0x0000000111177824ULL, 0x000fe200000e0617ULL,
0x0000002110187210ULL, 0x000fe20007f1e0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x000000701c237812ULL, 0x000fc600078ef80bULL, 0x0000000111197824ULL, 0x000fe200000e0619ULL,
0x000000701a257812ULL, 0x000fe200078ef80bULL, 0x000001001e1e7825ULL, 0x000fe200078e00ffULL,
0x00000023101c7210ULL, 0x000fe40007f1e0ffULL, 0x00000025101a7210ULL, 0x000fe20007f3e0ffULL,
0x0000010022227825ULL, 0x000fe200078e00ffULL, 0x000000701e217812ULL, 0x000fc600078ef80bULL,
0x0000010024247825ULL, 0x000fe200078e00ffULL, 0x0000007022437812ULL, 0x000fe400078ef80bULL,
0x00000021101e7210ULL, 0x000fe20007f5e0ffULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0x0000007024217812ULL, 0x000fe400078ef80bULL, 0x0000001f111f7210ULL, 0x000fe200017fe4ffULL,
0x00000001111d7824ULL, 0x000fe200000e061dULL, 0x0000007026457812ULL, 0x000fe200078ef80bULL,
0x0000010020407825ULL, 0x000fe200078e00ffULL, 0x0000004310207210ULL, 0x000fc40007f1e0ffULL,
0x000000703e437812ULL, 0x000fe200078ef80bULL, 0x00000001111b7824ULL, 0x040fe200008e061bULL,
0x0000002110227210ULL, 0x000fe20007f3e0ffULL, 0x0000000111217824ULL, 0x040fe200000e0623ULL,
0x0000004510247210ULL, 0x000fe20007f1e0ffULL, 0x000001002c447825ULL, 0x000fe200078e00ffULL,
0x0000004310267210ULL, 0x000fe40007f5e0ffULL, 0x0000007040437812ULL, 0x000fe200078ef80bULL,
0x0000000111237824ULL, 0x040fe200008e0625ULL, 0x0000007044497812ULL, 0x000fe200078ef80bULL,
0x0000000111257824ULL, 0x040fe200000e0627ULL, 0x0000004310407210ULL, 0x000fe20007f1e0ffULL,
0x0000000111277824ULL, 0x000fe200010e063fULL, 0x0000004910447210ULL, 0x000fe20007f5e0ffULL,
0x00000100343e7825ULL, 0x000fe200078e00ffULL, 0x0000004111417210ULL, 0x000fc600007fe4ffULL,
0x0000010030427825ULL, 0x000fe200078e00ffULL, 0x000000703e517812ULL, 0x000fc600078ef80bULL,
0x0000001035357824ULL, 0x100fe200078e0236ULL, 0x00000070424f7812ULL, 0x000fe200078ef80bULL,
0x0000010028467825ULL, 0x000fe200078e00ffULL, 0x00000051103e7210ULL, 0x000fe40007f1e0ffULL,
0x0000000014357faeULL, 0x0003e2000b901c46ULL, 0x0000001031317824ULL, 0x100fe200078e0236ULL,
0x00000070460b7812ULL, 0x000fe200078ef80bULL, 0x000000102f2f7824ULL, 0x100fe200078e0236ULL,
0x0000000016337faeULL, 0x0003e2000b901c46ULL, 0x000000102d2d7824ULL, 0x100fe200078e0236ULL,
0x0000004f10427210ULL, 0x000fe20007f3e0ffULL, 0x000000102b2b7824ULL, 0x100fe200078e0236ULL,
0x0000000018317faeULL, 0x0003e2000b901c46ULL, 0x0000001039397824ULL, 0x100fe200078e0236ULL,
0x0000000b10107210ULL, 0x000fe20007f7e0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0236ULL,
0x000000001a2f7faeULL, 0x0003e2000b901c46ULL, 0x000000103d3d7824ULL, 0x000fc400078e0236ULL,
0x00000001113f7824ULL, 0x040fe200000e063fULL, 0x000000001c2d7faeULL, 0x0003e2000b901c46ULL,
0x000000102a2a7824ULL, 0x100fe400078e0236ULL, 0x0000000111437824ULL, 0x040fe200008e0643ULL,
0x000000001e2b7faeULL, 0x0003e2000b901c46ULL, 0x000000102e2e7824ULL, 0x100fe400078e0236ULL,
0x0000000111457824ULL, 0x000fe200010e0645ULL, 0x0000000020297faeULL, 0x0003e2000b901c46ULL,
0x0000001032327824ULL, 0x000fc400078e0236ULL, 0x0000000111117824ULL, 0x000fe200018e0647ULL,
0x0000000022397faeULL, 0x0003e8000b901c46ULL, 0x00000000243b7faeULL, 0x0003e8000b901c46ULL,
0x00000000263d7faeULL, 0x0003e8000b901c46ULL, 0x0000000040087faeULL, 0x0003e8000b901c46ULL,
0x000000003e0e7faeULL, 0x0003e8000b901c46ULL, 0x00000000422a7faeULL, 0x0003e8000b901c46ULL,
0x00000000442e7faeULL, 0x0003e8000b901c46ULL, 0x0000000010327faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000107805ULL, 0x002fe20000015200ULL,
0x01b6000d070075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ff000e7202ULL, 0x000fce0000000f00ULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012100b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113127824ULL, 0x000fe200000e0e11ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011412ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e0612ULL, 0x0000000208087819ULL, 0x000fc8000000120bULL,
0x000000080000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x01b6000d070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000054c00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00009400ff087b82ULL, 0x000e620000000800ULL,
0x00000000000c7919ULL, 0x000ea20000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x00000007484a7211ULL, 0x040fe200078e18ffULL, 0x0000001f09047890ULL, 0x000fe4000fffe03fULL,
0x800000090f0e7c36ULL, 0x000fe20008000000ULL, 0xffffffff09057890ULL, 0x000fe2000fffe03fULL,
0x0000002048497824ULL, 0x000fe200078e0207ULL, 0x000000043f047899ULL, 0x000fe40008011604ULL,
0x00000008ff0e7819ULL, 0x000fe2000001160eULL, 0x0000000909087890ULL, 0x000fc4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL, 0x000000084d4d7224ULL, 0x002fd600078e02ffULL,
0x00008e00ff767b82ULL, 0x002e620000000a00ULL, 0x000000014c087836ULL, 0x000fe40000000000ULL,
0x000001004c0d7824ULL, 0x000fe400078e0202ULL, 0x0000000403117224ULL, 0x000fe200078e02ffULL,
0x000000050800720cULL, 0x000fe40003f06070ULL, 0x000000400d047812ULL, 0x000fca00078ec0ffULL,
0x000000014b157824ULL, 0x000fe400078e0204ULL, 0x0000010011107825ULL, 0x002fc800078e0076ULL,
0x0000000800f08947ULL, 0x000fea0003800000ULL, 0x00000003ff0b7819ULL, 0x104fe4000001160cULL,
0x000000040c737819ULL, 0x040fe400000006ffULL, 0x000000ff00137202ULL, 0x000fe20000000f00ULL,
0x000000040b197836ULL, 0x000fe20000000000ULL, 0x0000007073737812ULL, 0x000fe200078ec0ffULL,
0x000000010b177824ULL, 0x000fe200078e0215ULL, 0x0ffffff80c727812ULL, 0x000fe200078ec0ffULL,
0x0000000119047824ULL, 0x000fe200078e020cULL, 0x0000008073127812ULL, 0x000fe200078efcffULL,
0x00000008192b7824ULL, 0x000fe200078e00ffULL, 0x0000000748717211ULL, 0x000fe200078e70ffULL,
0x000000080b1b7836ULL, 0x000fe20000000000ULL, 0x000000180b357810ULL, 0x000fe20007ffe0ffULL,
0x0000010017167825ULL, 0x000fe200078e0012ULL, 0xfffffff82b2b7812ULL, 0x000fc400078ee204ULL,
0x0000000d0f047248ULL, 0x000fe20007fe0000ULL, 0x000000081b2d7824ULL, 0x000fe200078e00ffULL,
0x0000000c1b087210ULL, 0x000fe20007ffe0ffULL, 0x000000100b237836ULL, 0x000fe20000000000ULL,
0x000000040d047210ULL, 0x000fe20007ffe1ffULL, 0x0000000c0b1f7836ULL, 0x000fe20000000000ULL,
0x0000001610167210ULL, 0x000fe20007f1e0ffULL, 0x0000000123147824ULL, 0x000fe200078e020cULL,
0x000000041b00720cULL, 0x0c0fe20003f26070ULL, 0x000000011b1b7824ULL, 0x000fe200078e0215ULL,
0x000000041900720cULL, 0x080fe20003f86070ULL, 0x0000000111177824ULL, 0x000fe200000e0617ULL,
0x000000042300720cULL, 0x000fe20003f06070ULL, 0x000001001b1a7825ULL, 0x000fe200078e0012ULL,
0xfffffff82d2d7812ULL, 0x000fc400078ee208ULL, 0x000000041f00720cULL, 0x000fe20003f46070ULL,
0x0000000823317824ULL, 0x000fe200078e00ffULL, 0x0000001a101c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000119197824ULL, 0x100fe400078e0215ULL, 0x0000000123237824ULL, 0x000fe200078e0215ULL,
0xfffffff831317812ULL, 0x000fe200078ee214ULL, 0x0000010019187825ULL, 0x000fc800078e0012ULL,
0x0000010023227825ULL, 0x000fe200078e0012ULL, 0x0000001810267210ULL, 0x000fc60007f7e0ffULL,
0x000000011f087824ULL, 0x040fe400078e020cULL, 0x000000081f2f7824ULL, 0x000fe200078e00ffULL,
0x000000151f1f7210ULL, 0x000fe20007ffe0ffULL, 0x00000001111d7824ULL, 0x000fe200028e061bULL,
0x0000002210187210ULL, 0x000fe20007fbe0ffULL, 0x000000140b297836ULL, 0x000fe20000000000ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee208ULL, 0x000001001f1e7825ULL, 0x000fc800078e0012ULL,
0x0000000111277824ULL, 0x040fe200018e0619ULL, 0x0000001e10207210ULL, 0x000fe20007f7e0ffULL,
0x0000000111197824ULL, 0x000fe200028e0623ULL, 0x000000040b00720cULL, 0x0c0fe20003fa6070ULL,
0x000000010b237824ULL, 0x000fe400078e020cULL, 0x0000000129257824ULL, 0x000fe400078e0215ULL,
0x0000000111217824ULL, 0x000fe200018e061fULL, 0x0000000772237812ULL, 0x000fe200078ef823ULL,
0x0000010025247825ULL, 0x000fe200078e0012ULL, 0x000000042900720cULL, 0x000fc60003f66070ULL,
0x00003000714e7836ULL, 0x000fe20000000000ULL, 0x00000024101a7210ULL, 0x000fe20007fde0ffULL,
0x0000001c0b377836ULL, 0x000fe40000000000ULL, 0x00000001351f7824ULL, 0x000fe400078e0215ULL,
0x0000000129087824ULL, 0x040fe400078e020cULL, 0x0000000829337824ULL, 0x000fe400078e00ffULL,
0x0000001023297824ULL, 0x000fe200078e024eULL, 0x0000001537237210ULL, 0x000fe20007ffe0ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0012ULL, 0xfffffff833337812ULL, 0x000fc400078ee208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016297faeULL, 0x0003e2000e901c46ULL,
0x000000200b397836ULL, 0x000fe20000000000ULL, 0x000000043500720cULL, 0x080fe20003fa6070ULL,
0x00000001111b7824ULL, 0x000fe200030e0625ULL, 0x0000001e101e7210ULL, 0x000fe20007fde0ffULL,
0x000000102b2b7824ULL, 0x000fe400078e024eULL, 0x0000010023227825ULL, 0x000fe200078e0012ULL,
0x0000001f111f7210ULL, 0x000fe400037fe4ffULL, 0x00000000262b7faeULL, 0x0005e2000e101c46ULL,
0x0000000139257824ULL, 0x000fe200078e0215ULL, 0x0000002210227210ULL, 0x000fe20007fde0ffULL,
0x0000000135087824ULL, 0x000fe200078e020cULL, 0x000000043700720cULL, 0x000fe20003f86070ULL,
0x0000000835357824ULL, 0x000fe200078e00ffULL, 0x0000004e2f297211ULL, 0x002fe200078e20ffULL,
0x0000010025247825ULL, 0x000fc800078e0012ULL, 0x0000000137147824ULL, 0x040fe200078e020cULL,
0x0000000337377819ULL, 0x000fe200000006ffULL, 0x000000102d277824ULL, 0x004fe200078e024eULL,
0xfffffff8352b7812ULL, 0x000fe200078ee208ULL, 0x0000000111237824ULL, 0x000fe200030e0623ULL,
0x0000002410167210ULL, 0x000fe20007fde0ffULL, 0x000000240b2d7836ULL, 0x000fe20000000000ULL,
0x000000001c277faeULL, 0x0003e2000c901c46ULL, 0x000000043900720cULL, 0x0c0fe20003f26070ULL,
0x0000000139087824ULL, 0x140fe200078e020cULL, 0xfffffff837357812ULL, 0x000fe200078ee214ULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x000000032d2f7819ULL, 0x040fe200000006ffULL,
0x000000012d147824ULL, 0x000fe200078e020cULL, 0x0000000020297faeULL, 0x0005e2000d101c46ULL,
0x0000000111177824ULL, 0x000fe200030e0625ULL, 0x000000042d00720cULL, 0x040fe20003f46070ULL,
0x000000012d257824ULL, 0x000fe200078e0215ULL, 0xfffffff8392d7812ULL, 0x000fe200078ee208ULL,
0x00000010311d7824ULL, 0x102fe200078e024eULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee214ULL,
0x000000102b277824ULL, 0x000fc400078e024eULL, 0x000000102d2b7824ULL, 0x100fe200078e024eULL,
0x00000000181d7faeULL, 0x0003e2000c101c46ULL, 0x000000102f2d7824ULL, 0x100fe200078e024eULL,
0x0000004e35297211ULL, 0x004fe200078e20ffULL, 0x0000001033217824ULL, 0x000fe200078e024eULL,
0x000000300b337810ULL, 0x000fe20007ffe0ffULL, 0x000000280b2f7836ULL, 0x000fe40000000000ULL,
0x0000010025247825ULL, 0x000fe200078e0012ULL, 0x000000001a217faeULL, 0x000fe2000d901c46ULL,
0x000000043300720cULL, 0x000fc40003f66070ULL, 0x0000002c0b317836ULL, 0x000fe20000000000ULL,
0x000000001e277faeULL, 0x0005e2000e901c46ULL, 0x000000340b357836ULL, 0x000fe20000000000ULL,
0x0000002410247210ULL, 0x000fe20007fde0ffULL, 0x000000380b377836ULL, 0x000fe20000000000ULL,
0x0000000022297faeULL, 0x000fe2000e101c46ULL, 0x0000000131197824ULL, 0x002fe200078e0215ULL,
0x000000042f00720cULL, 0x080fe20003fa6070ULL, 0x0000000111257824ULL, 0x000fe200030e0625ULL,
0x00000000162b7faeULL, 0x0003e2000c901c46ULL, 0x0000010019187825ULL, 0x000fe200078e0012ULL,
0x000000043100720cULL, 0x000fc40003f86070ULL, 0x00000000242d7faeULL, 0x0007e2000d101c46ULL,
0x0000003c0b277836ULL, 0x004fe20000000000ULL, 0x000000043500720cULL, 0x080fe20003f46070ULL,
0x000000012f0b7824ULL, 0x100fe200078e0215ULL, 0x000000043700720cULL, 0x080fe20003f26070ULL,
0x00000001331b7824ULL, 0x100fe200078e0215ULL, 0x000000042700720cULL, 0x000fe20003f06070ULL,
0x00000001351d7824ULL, 0x000fe200078e0215ULL, 0x0000000c31047210ULL, 0x000fe20007ffe0ffULL,
0x000001000b167825ULL, 0x002fe200078e0012ULL, 0x0000000c2f087210ULL, 0x000fc60007ffe0ffULL,
0x000001001b1a7825ULL, 0x000fe200078e0012ULL, 0x0000001610167210ULL, 0x000fc60007fde0ffULL,
0x000001001d1c7825ULL, 0x000fc800078e0012ULL, 0x0000000111177824ULL, 0x000fe200030e0617ULL,
0x0000001810187210ULL, 0x000fe20007fde0ffULL, 0x0000000831237824ULL, 0x000fe400078e00ffULL,
0x00000001370b7824ULL, 0x000fe400078e0215ULL, 0x0000000111197824ULL, 0x000fe200030e0619ULL,
0x0000001a101e7210ULL, 0x000fe20007fde0ffULL, 0x000000082f217824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee204ULL, 0x0000000133047824ULL, 0x000fe200078e020cULL,
0x0000001b111f7210ULL, 0x000fe200037fe4ffULL, 0x000001000b1a7825ULL, 0x000fe200078e0012ULL,
0x0000001c10147210ULL, 0x000fc40007fde0ffULL, 0x00000015270b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee208ULL,
0x0000000111157824ULL, 0x000fe200030e061dULL, 0x0000001a101a7210ULL, 0x000fe20007fde0ffULL,
0x0000000135087824ULL, 0x040fe200078e020cULL, 0xfffffff8331d7812ULL, 0x000fe200078ee204ULL,
0x0000000835257824ULL, 0x008fe400078e00ffULL, 0x000001000b127825ULL, 0x000fe200078e0012ULL,
0x0000004e1d1d7211ULL, 0x000fc400078e20ffULL, 0xfffffff825257812ULL, 0x000fe200078ee208ULL,
0x0000000137047824ULL, 0x000fe200078e020cULL, 0x0000000c27087210ULL, 0x000fe20007ffe0ffULL,
0x00000001111b7824ULL, 0x000fe200030e061bULL, 0x0000001210107210ULL, 0x000fe20007fde0ffULL,
0x0000000837377824ULL, 0x000fe400078e00ffULL, 0x0000000827297824ULL, 0x000fe400078e00ffULL,
0x00000010210b7824ULL, 0x100fe200078e024eULL, 0xfffffff837277812ULL, 0x000fe200078ee204ULL,
0x0000000111117824ULL, 0x000fe200030e0613ULL, 0xfffffff829297812ULL, 0x000fe200078ee208ULL,
0x0000001023137824ULL, 0x100fe200078e024eULL, 0x00000000160b7faeULL, 0x0003e2000e901c46ULL,
0x0000001025217824ULL, 0x000fc400078e024eULL, 0x0000001027237824ULL, 0x100fe200078e024eULL,
0x0000000018137faeULL, 0x0003e2000e101c46ULL, 0x0000001029257824ULL, 0x000fc600078e024eULL,
0x000000001e1d7faeULL, 0x0003e8000d901c46ULL, 0x0000000014217faeULL, 0x0003e8000d101c46ULL,
0x000000001a237faeULL, 0x0003e8000c901c46ULL, 0x0000000010257faeULL, 0x0003e2000c101c46ULL,
0x0000000800a07947ULL, 0x000fea0003800000ULL, 0x0000000c0c217811ULL, 0x044fe200078fe8ffULL,
0x000000100c737824ULL, 0x040fe200078e00ffULL, 0x0000001c0c2d7811ULL, 0x000fe200078fe8ffULL,
0x0000400048717824ULL, 0x000fe200078e0207ULL, 0x0000002c0c257811ULL, 0x040fe200078fe8ffULL,
0x00000001214f7824ULL, 0x140fe200078e020cULL, 0x000000080c1d7811ULL, 0x040fe200078fe8ffULL,
0x0000000821127824ULL, 0x000fe200078e00ffULL, 0x000000040c177811ULL, 0x040fe200078fe8ffULL,
0x000000012d417824ULL, 0x100fe200078e020cULL, 0x000000180c297811ULL, 0x040fe200078fe8ffULL,
0x0000000125337824ULL, 0x100fe200078e020cULL, 0xfffffff8124f7812ULL, 0x000fe200078ee24fULL,
0x000000082d127824ULL, 0x000fe200078e00ffULL, 0x000000100c237811ULL, 0x040fe200078fe8ffULL,
0x000000011d517824ULL, 0x100fe200078e020cULL, 0x0000000317047819ULL, 0x000fe200000006ffULL,
0x000000081d087824ULL, 0x000fe200078e00ffULL, 0xfffffff812417812ULL, 0x000fe200078ee241ULL,
0x0000000117537824ULL, 0x100fe200078e020cULL, 0x0000000325127819ULL, 0x000fe200000006ffULL,
0x0000000129437824ULL, 0x100fe200078e020cULL, 0x000000140c277811ULL, 0x040fe200078fe8ffULL,
0x0000000823147824ULL, 0x000fe200078e00ffULL, 0xfffffff812337812ULL, 0x000fe200078ee233ULL,
0x0000000117177824ULL, 0x100fe200078e0215ULL, 0x0000003c0c127811ULL, 0x000fe200078fe8ffULL,
0x0000000127457824ULL, 0x100fe200078e020cULL, 0xfffffff808517812ULL, 0x000fe200078ee251ULL,
0x0000000121217824ULL, 0x100fe200078e0215ULL, 0x0000000329087819ULL, 0x000fe200000006ffULL,
0x0000000112577824ULL, 0x100fe200078e0215ULL, 0x000000280c2b7811ULL, 0x000fe200078fe8ffULL,
0x00000001123f7824ULL, 0x140fe200078e020cULL, 0x0000007073737812ULL, 0x000fe200078ec0ffULL,
0x0000000812127824ULL, 0x000fe200078e00ffULL, 0xfffffff804537812ULL, 0x000fe200078ee253ULL,
0x0000000827047824ULL, 0x000fe200078e00ffULL, 0x0000000c23477210ULL, 0x000fe20007ffe0ffULL,
0x000000012b357824ULL, 0x100fe200078e020cULL, 0x000000200c2f7811ULL, 0x040fe200078fe8ffULL,
0x0000000123237824ULL, 0x100fe200078e0215ULL, 0x000000240c317811ULL, 0x040fe200078fe8ffULL,
0x0000000127277824ULL, 0x100fe200078e0215ULL, 0xfffffff808437812ULL, 0x000fe200078ee243ULL,
0x000000082b087824ULL, 0x000fe200078e00ffULL, 0x0000008073187812ULL, 0x000fe200078efcffULL,
0x000000012f397824ULL, 0x000fe200078e020cULL, 0x000000150c137211ULL, 0x040fe200078fe8ffULL,
0x0000000129297824ULL, 0x100fe200078e0215ULL, 0x000000ff00197202ULL, 0x000fe20000000f00ULL,
0x000000012b2b7824ULL, 0x000fe200078e0215ULL, 0xfffffff814477812ULL, 0x000fe200078ee247ULL,
0x000000082f147824ULL, 0x000fe200078e00ffULL, 0xfffffff804457812ULL, 0x000fe200078ee245ULL,
0x0000000831047824ULL, 0x000fe200078e00ffULL, 0xfffffff8123f7812ULL, 0x000fe200078ee23fULL,
0x0000010013127825ULL, 0x000fe200078e0018ULL, 0x000000300c1f7811ULL, 0x000fc400078fe8ffULL,
0x0000000c31377210ULL, 0x000fe20007ffe0ffULL, 0x0000010017167825ULL, 0x000fe200078e0018ULL,
0xfffffff808357812ULL, 0x000fe400078ee235ULL, 0x000000380c087811ULL, 0x000fe200078fe8ffULL,
0x000000011f0b7824ULL, 0x040fe200078e020cULL, 0xfffffff814397812ULL, 0x000fe200078ee239ULL,
0x000000081f147824ULL, 0x000fe200078e00ffULL, 0xfffffff804377812ULL, 0x000fe200078ee237ULL,
0x0000010021207825ULL, 0x000fe200078e0018ULL, 0x000000151d1d7210ULL, 0x000fc40007ffe0ffULL,
0x000000340c047811ULL, 0x000fe200078fe8ffULL, 0x0000000108557824ULL, 0x000fe200078e0215ULL,
0x0000001210127210ULL, 0x000fe20007f1e0ffULL, 0x0000010023227825ULL, 0x000fe200078e0018ULL,
0x000000152d2d7210ULL, 0x000fe40007ffe0ffULL, 0x0000001610167210ULL, 0x000fe20007f3e0ffULL,
0x000000012f2f7824ULL, 0x000fe200078e0215ULL, 0xfffffff8140b7812ULL, 0x000fe200078ee20bULL,
0x000001001d1c7825ULL, 0x000fe200078e0018ULL, 0x000000151f1f7210ULL, 0x000fc40007ffe0ffULL,
0x0ffffff80c727812ULL, 0x000fe200078ec0ffULL, 0x0000000131317824ULL, 0x100fe200078e0215ULL,
0x0000001c101c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000125257824ULL, 0x100fe200078e0215ULL,
0x00003000714e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001041b7824ULL, 0x000fe200078e0215ULL,
0x0000000c083d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000111137824ULL, 0x000fe200000e0613ULL,
0x0000002010207210ULL, 0x000fe20007f1e0ffULL, 0x0000010055147825ULL, 0x000fe200078e0018ULL,
0x0000000c0c557211ULL, 0x000fc400078fe8ffULL, 0x0000004e53537211ULL, 0x080fe200078e20ffULL,
0x000001002d2c7825ULL, 0x000fe200078e0018ULL, 0x0000000772557812ULL, 0x000fe400078ef855ULL,
0x0000004e43437211ULL, 0x080fe200078e20ffULL, 0x0000000111177824ULL, 0x000fe200008e0617ULL,
0x0000002210227210ULL, 0x000fe20007f3e0ffULL, 0x000001002f2e7825ULL, 0x100fe200078e0018ULL,
0x0000004e33337211ULL, 0x000fe400078e20ffULL, 0x0000002311237210ULL, 0x000fe20000ffe4ffULL,
0x0000010027267825ULL, 0x000fe200078e0018ULL, 0x0000002e102e7210ULL, 0x000fc60007f3e0ffULL,
0x0000010029287825ULL, 0x000fc800078e0018ULL, 0x0000000111217824ULL, 0x000fe200000e0621ULL,
0x0000002c102c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010025247825ULL, 0x000fe200078e0018ULL,
0x0000002810287210ULL, 0x000fc60007f7e0ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0018ULL,
0x00000001111d7824ULL, 0x000fe200010e061dULL, 0x0000002610267210ULL, 0x000fe20007f5e0ffULL,
0x0000010031307825ULL, 0x000fc800078e0018ULL, 0x000001002b2a7825ULL, 0x000fc800078e0018ULL,
0x0000001055557824ULL, 0x000fe400078e024eULL, 0x00000001112d7824ULL, 0x040fe200000e062dULL,
0x0000002410247210ULL, 0x000fe20007f1e0ffULL, 0x00000001043b7824ULL, 0x040fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012557faeULL, 0x0003e2000b901c46ULL,
0x00000001112f7824ULL, 0x000fe200008e062fULL, 0x0000001e101e7210ULL, 0x000fe20007f3e0ffULL,
0x0000001051517824ULL, 0x000fe200078e024eULL, 0x0000000016537faeULL, 0x0003e2000b901c46ULL,
0x0000000804047824ULL, 0x000fc400078e00ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0018ULL,
0x000000001c517faeULL, 0x0003e4000b901c46ULL, 0xfffffff8043b7812ULL, 0x000fe200078ee23bULL,
0x000000104f4f7824ULL, 0x100fe400078e024eULL, 0x0000000808087824ULL, 0x000fe400078e00ffULL,
0x0000000111277824ULL, 0x040fe200010e0627ULL, 0x0000003010307210ULL, 0x000fe20007f5e0ffULL,
0x0000000111297824ULL, 0x000fe200018e0629ULL, 0x0000002a102a7210ULL, 0x000fe20007f7e0ffULL,
0x0000001047477824ULL, 0x000fe200078e024eULL, 0x00000000204f7faeULL, 0x0003e2000b901c46ULL,
0x0000010057187825ULL, 0x000fe200078e0018ULL, 0xfffffff8083d7812ULL, 0x000fc400078ee23dULL,
0x0000003111317210ULL, 0x000fe200017fe4ffULL, 0x0000001045457824ULL, 0x100fe200078e024eULL,
0x0000000022477faeULL, 0x0003e2000b901c46ULL, 0x0000000111257824ULL, 0x000fe200000e0625ULL,
0x0000001a101a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001041417824ULL, 0x100fe200078e024eULL,
0x0000000026457faeULL, 0x0003e2000b901c46ULL, 0x00000001111f7824ULL, 0x000fe200008e061fULL,
0x0000001410147210ULL, 0x000fe20007f3e0ffULL, 0x0000001039397824ULL, 0x100fe200078e024eULL,
0x0000001810107210ULL, 0x000fe20007f5e0ffULL, 0x0000001037377824ULL, 0x000fe200078e024eULL,
0x0000000028437faeULL, 0x0003e2000b901c46ULL, 0x00000001112b7824ULL, 0x000fc400018e062bULL,
0x0000001035357824ULL, 0x100fe200078e024eULL, 0x000000002c417faeULL, 0x0003e2000b901c46ULL,
0x000000100b0b7824ULL, 0x100fe400078e024eULL, 0x00000001111b7824ULL, 0x000fe200000e061bULL,
0x000000002e397faeULL, 0x0003e2000b901c46ULL, 0x000000103b3b7824ULL, 0x100fe400078e024eULL,
0x0000000111157824ULL, 0x000fe200008e0615ULL, 0x0000000030377faeULL, 0x0003e2000b901c46ULL,
0x000000103d3d7824ULL, 0x000fc400078e024eULL, 0x0000000111117824ULL, 0x000fe200010e0619ULL,
0x000000002a357faeULL, 0x0003e2000b901c46ULL, 0x000000103f3f7824ULL, 0x000fc600078e024eULL,
0x0000000024337faeULL, 0x0003e8000b901c46ULL, 0x000000001e0b7faeULL, 0x0003e8000b901c46ULL,
0x000000001a3b7faeULL, 0x0003e8000b901c46ULL, 0x00000000143d7faeULL, 0x0003e8000b901c46ULL,
0x00000000103f7faeULL, 0x0003e4000b901c46ULL, 0x0000000209097810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000060900720cULL, 0x000fda0003f06070ULL, 0x00009000ff108b82ULL, 0x002e620000000a00ULL,
0x000000024d0b8824ULL, 0x000fe200078e0209ULL, 0x00000004ff607819ULL, 0x100fe4000001160cULL,
0x00000003ff087819ULL, 0x000fe2000001160cULL, 0x0000100071717836ULL, 0x000fe20000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000040b108825ULL, 0x002fca00078e0010ULL,
0x0000000610048981ULL, 0x0002a2000c1e1900ULL, 0x00000008603c7824ULL, 0x000fe200078e00ffULL,
0x000000070c0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000108137812ULL, 0x000fe400078ec0ffULL,
0x000000080b4f7812ULL, 0x000fe400078ef80cULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee20bULL,
0x000000044f157819ULL, 0x000fe200000006ffULL, 0x0000000160607824ULL, 0x000fe200078e024fULL,
0x000000203c397810ULL, 0x000fe20007ffe0ffULL, 0x00000001133b7824ULL, 0x000fc400078e023cULL,
0x000000083c747824ULL, 0x000fe200078e00ffULL, 0xfffffff015107812ULL, 0x002fe200078ee260ULL,
0x000000103c3a7836ULL, 0x000fe20000000000ULL, 0x000000023b6d7810ULL, 0x000fe20007ffe0ffULL,
0x000000104f127824ULL, 0x000fe200078e00ffULL, 0xfffffff874747812ULL, 0x000fe200078ee23bULL,
0x0000000260117836ULL, 0x000fe20000000000ULL, 0x000000323b697810ULL, 0x000fe20007ffe0ffULL,
0x0000000113707824ULL, 0x000fe200078e023aULL, 0x0000007174147211ULL, 0x000fe200078e20ffULL,
0x000000083a197824ULL, 0x000fe200078e00ffULL, 0xfffffff012127812ULL, 0x000fe200078ee211ULL,
0x000000303c387836ULL, 0x000fe20000000000ULL, 0x000000263b627810ULL, 0x000fe20007ffe0ffULL,
0x0000001010107824ULL, 0x000fe200078e0207ULL, 0xfffffff819707812ULL, 0x000fe200078ee270ULL,
0x0000000838117824ULL, 0x000fe200078e00ffULL, 0x00000038136e7210ULL, 0x000fe20007ffe0ffULL,
0x000000001414783bULL, 0x000fe20000000200ULL, 0x000000083c187824ULL, 0x000fc400078e00ffULL,
0x0000001070347824ULL, 0x000fe200078e0271ULL, 0x000000001028783bULL, 0x0002e20000000200ULL,
0xfffffff8116e7812ULL, 0x000fe200078ee26eULL, 0x00000001136f7824ULL, 0x000fe200078e0239ULL,
0xfffffff8186d7812ULL, 0x000fe200078ee26dULL, 0x000000123b6a7836ULL, 0x000fe20000000000ULL,
0x000000003434783bULL, 0x000f220000000200ULL, 0x000000106e2c7824ULL, 0x100fe200078e0271ULL,
0x000000033a117819ULL, 0x000fe200000006ffULL, 0x0000000839107824ULL, 0x002fe400078e00ffULL,
0x000000106d587824ULL, 0x000fe200078e0271ULL, 0xfffffff8116a7812ULL, 0x000fe200078ee26aULL,
0x000000002c2c783bULL, 0x000e620000000200ULL, 0xfffffff8106f7812ULL, 0x000fe200078ee26fULL,
0x0000001012127824ULL, 0x000fc400078e0207ULL, 0x000000005858783bULL, 0x000fe20000000200ULL,
0x000000106a107824ULL, 0x100fe400078e0271ULL, 0x000000106f307824ULL, 0x000fe200078e0271ULL,
0x000000001220783bULL, 0x000f620000000200ULL, 0x000000223b687836ULL, 0x000fe40000000000ULL,
0x0000000839197824ULL, 0x000fe200078e00ffULL, 0x000000001010783bULL, 0x000fe20000000200ULL,
0x000000343b647836ULL, 0x000fe40000000000ULL, 0x000000043b6c7836ULL, 0x000fe20000000000ULL,
0x000000003030783bULL, 0x000f620000000200ULL, 0xfffffff819687812ULL, 0x000fe200078ee268ULL,
0x000000143b677836ULL, 0x000fc40000000000ULL, 0x000000243b657836ULL, 0x000fe40000000000ULL,
0x0000001068187824ULL, 0x000fe400078e0271ULL, 0x000000363b617836ULL, 0x000fe40000000000ULL,
0x000000063b667836ULL, 0x000fe20000000000ULL, 0x000000142824723cULL, 0x008fe200000418ffULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x000000163b637836ULL, 0x000fc80000000000ULL,
0x000000162814723cULL, 0x000fec00000418ffULL, 0x000000342854723cULL, 0x010fec00000418ffULL,
0x0000002c281c723cULL, 0x002fec00000418ffULL, 0x000000362834723cULL, 0x000fe200000418ffULL,
0x00000008382c7824ULL, 0x000fca00078e00ffULL, 0xfffffff82c697812ULL, 0x000fe200078ee269ULL,
0x000000582024723cULL, 0x020fe80000041824ULL, 0x00000010692c7824ULL, 0x000fe400078e0271ULL,
0x0000005a2058723cULL, 0x000fec0000041814ULL, 0x000000302814723cULL, 0x000fec00000418ffULL,
0x000000322830723cULL, 0x000fec00000418ffULL, 0x0000002e2828723cULL, 0x000fe200000418ffULL,
0x000000002c2c783bULL, 0x000e6a0000000200ULL, 0x000000102054723cULL, 0x000fec0000041854ULL,
0x000000182014723cULL, 0x008fe20000041814ULL, 0x000000104f117824ULL, 0x000fc400078e00ffULL,
0x0000000460107836ULL, 0x000fc80000000000ULL, 0x000000104f197824ULL, 0x000fe200078e00ffULL,
0xfffffff0113e7812ULL, 0x000fe400078ee210ULL, 0x000000122010723cULL, 0x000fe40000041834ULL,
0x000000073e3e7211ULL, 0x000fca00078e20ffULL, 0x0000000838377824ULL, 0x000fe200078e00ffULL,
0x000000033c357819ULL, 0x000fe200000006ffULL, 0x000000083a347824ULL, 0x000fe200078e00ffULL,
0x0000000339367819ULL, 0x040fe200000006ffULL, 0x000000003e3c783bULL, 0x000fe20000000200ULL,
0xfffffff837647812ULL, 0x000fe200078ee264ULL, 0x0000000838387824ULL, 0x000fe200078e00ffULL,
0xfffffff8356c7812ULL, 0x000fe200078ee26cULL, 0x000000083a3a7824ULL, 0x000fe200078e00ffULL,
0x0000007164407211ULL, 0x000fe200078e20ffULL, 0x0000000839397824ULL, 0x000fe200078e00ffULL,
0xfffffff834677812ULL, 0x000fe200078ee267ULL, 0x000000106c5c7824ULL, 0x100fe200078e0271ULL,
0xfffffff836657812ULL, 0x000fe200078ee265ULL, 0x0000000660347836ULL, 0x000fe20000000000ULL,
0x000000004040783bULL, 0x000ee20000000200ULL, 0x0000001067507824ULL, 0x100fe200078e0271ULL,
0xfffffff838617812ULL, 0x000fe200078ee261ULL, 0x0000001065447824ULL, 0x000fe200078e0271ULL,
0x000000005c5c783bULL, 0x000f220000000200ULL, 0xfffffff019347812ULL, 0x000fe200078ee234ULL,
0x0000002c201c723cULL, 0x002fe2000004181cULL, 0xfffffff835667812ULL, 0x000fe200078ee266ULL,
0x000000005050783bULL, 0x000e620000000200ULL, 0xfffffff83a637812ULL, 0x000fe200078ee263ULL,
0x00000010346b7824ULL, 0x000fe200078e0207ULL, 0xfffffff839627812ULL, 0x000fe200078ee262ULL,
0x000000004444783bULL, 0x000f620000000200ULL, 0x0000001a2018723cULL, 0x000fe20000041830ULL,
0x00000010612c7824ULL, 0x000fc400078e0271ULL, 0x0000001066387824ULL, 0x100fe400078e0271ULL,
0x0000001063347824ULL, 0x000fe200078e0271ULL, 0x0000002e2020723cULL, 0x000fe20000041828ULL,
0x0000007162307211ULL, 0x000fe200078e20ffULL, 0x000000006b28783bULL, 0x0007e80000000200ULL,
0x000000002c2c783bULL, 0x000f680000000200ULL, 0x000000003838783bULL, 0x000f620000000200ULL,
0x000000010a6b7824ULL, 0x008fc600078e024cULL, 0x000000003434783bULL, 0x000ee80000000200ULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x000000403c1c723cULL, 0x000fec000004181cULL,
0x000000423c20723cULL, 0x000fec0000041820ULL, 0x0000005c3c24723cULL, 0x010fec0000041824ULL,
0x0000005e3c58723cULL, 0x000fec0000041858ULL, 0x000000503c54723cULL, 0x002fec0000041854ULL,
0x000000523c10723cULL, 0x000fec0000041810ULL, 0x000000443c14723cULL, 0x020fec0000041814ULL,
0x000000463c18723cULL, 0x000fec0000041818ULL, 0x0000002c281c723cULL, 0x000fec000004181cULL,
0x0000002e282c723cULL, 0x000fec0000041820ULL, 0x000000382824723cULL, 0x000fe20000041824ULL,
0x000000016b207836ULL, 0x000fca0000000000ULL, 0x000000052000720cULL, 0x000fe20003f06070ULL,
0x0000003a2858723cULL, 0x000fec0000041858ULL, 0x000000342854723cULL, 0x008fec0000041854ULL,
0x000000362810723cULL, 0x000fe20000041810ULL, 0x0000000304217224ULL, 0x004fca00078e02ffULL,
0x000000302814723cULL, 0x000fe20000041814ULL, 0x0000010021767825ULL, 0x000fca00078e0076ULL,
0x000000322818723cULL, 0x000fee0000041818ULL, 0x000001006b287824ULL, 0x000fca00078e0202ULL,
0x0000004028227812ULL, 0x000fc800078ec0ffULL, 0x000000224b227210ULL, 0x000fe20007ffe0ffULL,
0x0000000c00108947ULL, 0x000fee0003800000ULL, 0x000000280f237248ULL, 0x000fe20007fe0000ULL,
0x0000000408297836ULL, 0x000fe20000000000ULL, 0x0000000c08377810ULL, 0x000fe20007ffe0ffULL,
0x0000000808317836ULL, 0x000fe20000000000ULL, 0x0000003c08457810ULL, 0x000fe20007ffe0ffULL,
0x0000000108217824ULL, 0x040fe200078e020cULL, 0x00000003292b7819ULL, 0x000fe200000006ffULL,
0x0000000123237824ULL, 0x000fe400078e0a28ULL, 0x0000000108287824ULL, 0x040fe200078e0222ULL,
0x0000000772727812ULL, 0x000fe200078ef821ULL, 0x0000000131427824ULL, 0x100fe200078e020cULL,
0x000000232900720cULL, 0x080fe20003f46070ULL, 0x0000000831337824ULL, 0x000fe200078e00ffULL,
0x0000000337217819ULL, 0x000fe200000006ffULL, 0x00000001293c7824ULL, 0x000fe200078e020cULL,
0x000000233100720cULL, 0x080fe20003f66070ULL, 0x0000000129207824ULL, 0x000fe200078e0222ULL,
0xfffffff833427812ULL, 0x000fe200078ee242ULL, 0x0000000137407824ULL, 0x000fe200078e020cULL,
0xfffffff82b3c7812ULL, 0x000fe200078ee23cULL, 0x0000001008397836ULL, 0x000fe20000000000ULL,
0x000000230800720cULL, 0x000fe20003f26070ULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0xfffffff821407812ULL, 0x000fc400078ee240ULL, 0x000000233900720cULL, 0x040fe20003f86070ULL,
0x00000001393e7824ULL, 0x040fe200078e020cULL, 0x00000073282b7212ULL, 0x000fe200078efcffULL,
0x0000000839337824ULL, 0x000fe200078e00ffULL, 0x000000233700720cULL, 0x000fe20003fa6070ULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000002b762a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff8333e7812ULL, 0x000fe200078ee23eULL, 0x0000000131307824ULL, 0x100fe200078e0222ULL,
0x0000007320337212ULL, 0x000fe200078efcffULL, 0x0000000137287824ULL, 0x000fe200078e0222ULL,
0x00000029772b7210ULL, 0x000fe200007fe4ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x0000003376327210ULL, 0x000fc60007f1e0ffULL, 0x0000000139207824ULL, 0x000fe200078e0222ULL,
0x0000007330397212ULL, 0x080fe200078efcffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x0000002177337210ULL, 0x000fe400007fe4ffULL, 0x0000003976307210ULL, 0x000fe20007f1e0ffULL,
0x0000001408357836ULL, 0x000fe20000000000ULL, 0x0000007328377212ULL, 0x000fe200078efcffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000007172397211ULL, 0x000fe400078e20ffULL,
0x0000003776287210ULL, 0x000fe20007fde0ffULL, 0x0000000177317824ULL, 0x000fe200000e0631ULL,
0x000000233500720cULL, 0x040fe20003f06070ULL, 0x0000000135367824ULL, 0x040fe200078e020cULL,
0x0000007320377212ULL, 0x000fe200078efcffULL, 0x00000008353b7824ULL, 0x040fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a397faeULL, 0x0003e2000c901c46ULL,
0x0000000135357824ULL, 0x000fc400078e0222ULL, 0x0000000177297824ULL, 0x040fe200030e0629ULL,
0x0000003776207210ULL, 0x000fe20007fde0ffULL, 0x00000020083f7836ULL, 0x000fe20000000000ULL,
0xfffffff83b367812ULL, 0x000fe200078ee236ULL, 0x00000018083b7836ULL, 0x000fe40000000000ULL,
0x0000000177217824ULL, 0x000fe400030e0621ULL, 0x000000013b387824ULL, 0x000fe200078e020cULL,
0x000000223b377210ULL, 0x000fe20007ffe0ffULL, 0x00000100352a7825ULL, 0x002fe200078e00ffULL,
0x000000233b00720cULL, 0x000fc40003f26070ULL, 0x000000713c397211ULL, 0x000fe200078e20ffULL,
0x000000083b3d7824ULL, 0x000fe200078e00ffULL, 0x000000732a357212ULL, 0x000fe200078efcffULL,
0x000000013f3b7824ULL, 0x040fe400078e020cULL, 0x000000083f447824ULL, 0x000fe200078e00ffULL,
0x0000003576347210ULL, 0x000fe20007fde0ffULL, 0x0000000032397faeULL, 0x0003e2000d101c46ULL,
0xfffffff83d387812ULL, 0x000fe200078ee238ULL, 0x0000001c083d7836ULL, 0x000fe20000000000ULL,
0xfffffff8443c7812ULL, 0x000fe200078ee23bULL, 0x0000000177357824ULL, 0x000fc400030e062bULL,
0x00000100372a7825ULL, 0x000fe200078e00ffULL, 0x000000233d00720cULL, 0x000fc60003f46070ULL,
0x00000010423b7824ULL, 0x000fe200078e0271ULL, 0x000000732a377212ULL, 0x000fe200078efcffULL,
0x000000013d2a7824ULL, 0x040fe400078e0222ULL, 0x000000013d3a7824ULL, 0x000fe200078e020cULL,
0x00000000303b7faeULL, 0x0005e2000d901c46ULL, 0x0000003776327210ULL, 0x002fe20007fde0ffULL,
0x000000013f377824ULL, 0x040fe200078e0222ULL, 0x000000233f00720cULL, 0x000fe20003f66070ULL,
0x00000024083f7836ULL, 0x000fe20000000000ULL, 0x0000002b77337210ULL, 0x000fe200037fe4ffULL,
0x000000083d417824ULL, 0x000fc400078e00ffULL, 0x00000010403d7824ULL, 0x000fe400078e0271ULL,
0x000000013f407824ULL, 0x040fe200078e020cULL, 0xfffffff8413a7812ULL, 0x000fe200078ee23aULL,
0x000001002a307825ULL, 0x004fe200078e00ffULL, 0x00000000283d7faeULL, 0x0003e2000e901c46ULL,
0x000000233f00720cULL, 0x000fe40003fa6070ULL, 0x00000100372a7825ULL, 0x000fe200078e00ffULL,
0x0000007330377212ULL, 0x000fc600078efcffULL, 0x000000083f3b7824ULL, 0x000fe200078e00ffULL,
0x0000003776307210ULL, 0x000fe20007fde0ffULL, 0x0000003408417836ULL, 0x000fe20000000000ULL,
0x000000223f377210ULL, 0x000fe20007ffe0ffULL, 0x00000030083f7836ULL, 0x000fe20000000000ULL,
0x000000732a397212ULL, 0x000fe200078efcffULL, 0x0000000177317824ULL, 0x000fe200030e0631ULL,
0xfffffff83b407812ULL, 0x000fe200078ee240ULL, 0x0000010037287825ULL, 0x002fe200078e00ffULL,
0x00000039762a7210ULL, 0x000fc60007fde0ffULL, 0x00000028083b7836ULL, 0x000fe20000000000ULL,
0x0000007328377212ULL, 0x000fe200078efcffULL, 0x000000103e397824ULL, 0x000fe400078e0271ULL,
0x00000001772b7824ULL, 0x000fe200030e062bULL, 0x0000003776287210ULL, 0x000fe20007fde0ffULL,
0x000000083b3d7824ULL, 0x040fe200078e00ffULL, 0x0000000c3b3e7210ULL, 0x000fe20007ffe0ffULL,
0x000000013b377824ULL, 0x140fe200078e0222ULL, 0x0000000020397faeULL, 0x0003e2000e101c46ULL,
0x000000233b00720cULL, 0x080fe20003f86070ULL, 0x00000010363b7824ULL, 0x000fe200078e0271ULL,
0xfffffff83d3e7812ULL, 0x000fe200078ee23eULL, 0x0000000177297824ULL, 0x000fe200030e0629ULL,
0x0000002c083d7810ULL, 0x000fe20007ffe0ffULL, 0x0000003808437836ULL, 0x000fe20000000000ULL,
0x00000000343b7faeULL, 0x0005e4000c101c46ULL, 0x000000233d00720cULL, 0x040fe20003f06070ULL,
0x000000013d367824ULL, 0x000fc400078e0222ULL, 0x0000010037207825ULL, 0x002fe200078e00ffULL,
0x000000223f397210ULL, 0x000fc60007ffe0ffULL, 0x000000013d427824ULL, 0x040fe200078e020cULL,
0x0000007320377212ULL, 0x080fe200078efcffULL, 0x000000083d3d7824ULL, 0x000fe400078e00ffULL,
0x00000010383b7824ULL, 0x004fe200078e0271ULL, 0x0000003776207210ULL, 0x000fe20007fde0ffULL,
0x0000010036367825ULL, 0x000fe200078e00ffULL, 0xfffffff83d427812ULL, 0x000fe400078ee242ULL,
0x00000000323b7faeULL, 0x0003e2000c901c46ULL, 0x0000010039347825ULL, 0x000fe200078e00ffULL,
0x0000007336397212ULL, 0x000fc400078efcffULL, 0x000000233f00720cULL, 0x000fe20003f26070ULL,
0x0000000177217824ULL, 0x000fe400030e0621ULL, 0x000000103a3d7824ULL, 0x100fe400078e0271ULL,
0x000000013f367824ULL, 0x040fe400078e020cULL, 0x000000083f3f7824ULL, 0x000fe200078e00ffULL,
0x0000003976327210ULL, 0x002fe20007fde0ffULL, 0x00000000303d7faeULL, 0x0003e2000d101c46ULL,
0x0000007334397212ULL, 0x000fe200078efcffULL, 0x000000103c3b7824ULL, 0x100fe200078e0271ULL,
0x0000003777337210ULL, 0x000fe200037fe4ffULL, 0x0000000141377824ULL, 0x000fe200078e0222ULL,
0xfffffff83f367812ULL, 0x000fe200078ee236ULL, 0x00000010403f7824ULL, 0x000fe200078e0271ULL,
0x0000003976347210ULL, 0x000fe20007fde0ffULL, 0x000000002a3b7faeULL, 0x0005e2000d901c46ULL,
0x000000234300720cULL, 0x0c0fe20003f66070ULL, 0x0000000843387824ULL, 0x000fe200078e00ffULL,
0x0000003577357210ULL, 0x000fe200037fe4ffULL, 0x0000010037307825ULL, 0x002fe200078e00ffULL,
0x00000000283f7faeULL, 0x0003e2000e901c46ULL, 0x000000234100720cULL, 0x000fc40003fa6070ULL,
0x0000000143377824ULL, 0x100fe200078e0222ULL, 0x0000007330397212ULL, 0x000fe200078efcffULL,
0x0000000145227824ULL, 0x040fe200078e0222ULL, 0x000000234500720cULL, 0x000fe20003f46070ULL,
0x00000100372a7825ULL, 0x004fc800078e00ffULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x0000003976287210ULL, 0x002fe40007fde0ffULL, 0x0000000c45397210ULL, 0x000fe20007ffe0ffULL,
0x0000000141307824ULL, 0x140fe200078e020cULL, 0x0000000341417819ULL, 0x000fe200000006ffULL,
0x0000000177297824ULL, 0x000fe200030e0631ULL, 0x000000732a317212ULL, 0x080fe200078efcffULL,
0x0000000143377824ULL, 0x000fe200078e020cULL, 0x0000007322737212ULL, 0x000fe200078efcffULL,
0x00000008453a7824ULL, 0x000fe200078e00ffULL, 0x00000031762a7210ULL, 0x000fe20007fde0ffULL,
0x000000103e317824ULL, 0x000fe200078e0271ULL, 0xfffffff841307812ULL, 0x000fc400078ee230ULL,
0xfffffff838387812ULL, 0x000fe200078ee237ULL, 0x00000001772b7824ULL, 0x040fe200030e062bULL,
0x0000007376227210ULL, 0x000fe20007fde0ffULL, 0x00000010303b7824ULL, 0x100fe200078e0271ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee239ULL, 0x0000001036397824ULL, 0x100fe200078e0271ULL,
0x0000007142377211ULL, 0x080fe200078e20ffULL, 0x00000010383d7824ULL, 0x000fe200078e0271ULL,
0x000000713a717211ULL, 0x000fe200078e20ffULL, 0x0000000177237824ULL, 0x000fe200030e0623ULL,
0x0000000020317faeULL, 0x0003e8000e101c46ULL, 0x0000000032377faeULL, 0x0003e8000c101c46ULL,
0x0000000034397faeULL, 0x0003e8000c901c46ULL, 0x00000000283b7faeULL, 0x0003e8000e901c46ULL,
0x000000002a3d7faeULL, 0x0003e8000d901c46ULL, 0x0000000022717faeULL, 0x0003e2000d101c46ULL,
0x0000000800c47947ULL, 0x000fea0003800000ULL, 0x0000000408317836ULL, 0x000fe20000000000ULL,
0x0000002208207210ULL, 0x000fe20007ffe0ffULL, 0x0000000808467836ULL, 0x000fe20000000000ULL,
0x0000000c08797810ULL, 0x000fe20007ffe0ffULL, 0x00000001312a7824ULL, 0x000fe200078e0222ULL,
0x0000000c317a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000108237824ULL, 0x000fe200078e020cULL,
0x0000002279347210ULL, 0x000fe20007ffe0ffULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x00000024085d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000772367812ULL, 0x000fe200078ef823ULL,
0x0000000146287824ULL, 0x000fe200078e0222ULL, 0x0000007320237212ULL, 0x000fe200078efcffULL,
0x0000001408757836ULL, 0x000fe20000000000ULL, 0x0000002c08537810ULL, 0x000fe20007ffe0ffULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x0000002376207210ULL, 0x000fc40007f1e0ffULL,
0x0000002275307210ULL, 0x000fe20007ffe0ffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x000000732a457212ULL, 0x000fe400078efcffULL, 0x0000007136237211ULL, 0x000fe200078e20ffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x0000007328437212ULL, 0x080fe200078efcffULL,
0x0000010034347825ULL, 0x000fe200078e00ffULL, 0x0000004576447210ULL, 0x000fe40007f3e0ffULL,
0xfffffff8317a7812ULL, 0x000fe200078ee27aULL, 0x0000001808727836ULL, 0x000fe20000000000ULL,
0x0000007334417212ULL, 0x000fe200078efcffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x0000004376427210ULL, 0x000fc40007f5e0ffULL, 0x0000003008527810ULL, 0x000fe20007ffe0ffULL,
0x0000001c085f7836ULL, 0x000fe20000000000ULL, 0x00000073303d7212ULL, 0x000fe200078efcffULL,
0x0000000177217824ULL, 0x040fe200000e0621ULL, 0x0000004176407210ULL, 0x000fe20007f1e0ffULL,
0x00000001722a7824ULL, 0x100fe400078e0222ULL, 0x0000000177457824ULL, 0x000fe200008e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e2000b901c46ULL,
0x000000015f287824ULL, 0x000fe400078e0222ULL, 0x000001002a2a7825ULL, 0x000fc800078e00ffULL,
0x00000020085e7836ULL, 0x000fe20000000000ULL, 0x000000732a3b7212ULL, 0x000fe200078efcffULL,
0x0000000177437824ULL, 0x040fe400010e0629ULL, 0x0000000177417824ULL, 0x000fe200000e0635ULL,
0x0000003d763c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001008787836ULL, 0x000fe20000000000ULL,
0x0000003b763a7210ULL, 0x000fe20007f5e0ffULL, 0x0000010028287825ULL, 0x000fc800078e00ffULL,
0x000000015e307824ULL, 0x100fe200078e0222ULL, 0x0000007328397212ULL, 0x000fe200078efcffULL,
0x0000000178327824ULL, 0x000fe400078e0222ULL, 0x00000001773d7824ULL, 0x000fe200000e0631ULL,
0x0000003976387210ULL, 0x000fe20007f1e0ffULL, 0x0000010030307825ULL, 0x000fc800078e00ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x0000007330377212ULL, 0x000fc600078efcffULL,
0x000000015d2a7824ULL, 0x000fe200078e0222ULL, 0x00000073323f7212ULL, 0x000fe200078efcffULL,
0x00000028085c7836ULL, 0x000fe40000000000ULL, 0x00000001773b7824ULL, 0x000fe200010e062bULL,
0x0000003f763e7210ULL, 0x000fe20007f3e0ffULL, 0x000001002a2a7825ULL, 0x000fc600078e00ffULL,
0x00000033773f7210ULL, 0x000fe20000ffe4ffULL, 0x000000015c287824ULL, 0x100fe200078e0222ULL,
0x000000732a357212ULL, 0x000fe200078efcffULL, 0x0000000177397824ULL, 0x000fe200000e0629ULL,
0x0000003776367210ULL, 0x000fe20007f1e0ffULL, 0x0000000153327824ULL, 0x000fe400078e0222ULL,
0x0000010028287825ULL, 0x000fc800078e00ffULL, 0x0000010032207825ULL, 0x002fe200078e00ffULL,
0x0000007328337212ULL, 0x000fc600078efcffULL, 0x0000000177377824ULL, 0x040fe200000e0631ULL,
0x0000003576347210ULL, 0x000fe20007f1e0ffULL, 0x0000003408517836ULL, 0x000fe20000000000ULL,
0x0000007320317212ULL, 0x000fe200078efcffULL, 0x0000000152287824ULL, 0x000fe200078e0222ULL,
0x0000003376327210ULL, 0x000fe20007f3e0ffULL, 0x0000000177357824ULL, 0x040fe200000e062bULL,
0x0000003176307210ULL, 0x000fe20007f1e0ffULL, 0x0000003808507836ULL, 0x000fe20000000000ULL,
0x0000002251207210ULL, 0x000fe20007ffe0ffULL, 0x0000000177337824ULL, 0x000fc400008e0629ULL,
0x0000000177317824ULL, 0x000fe400000e0621ULL, 0x0000010028287825ULL, 0x000fc800078e00ffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x00000073282b7212ULL, 0x000fc600078efcffULL,
0x0000003c08477836ULL, 0x000fe20000000000ULL, 0x0000007320237212ULL, 0x000fe200078efcffULL,
0x00000001527c7824ULL, 0x000fe200078e020cULL, 0x0000002b762a7210ULL, 0x000fe20007f1e0ffULL,
0x00000008477d7824ULL, 0x000fe200078e00ffULL, 0x0000002376287210ULL, 0x000fe40007f3e0ffULL,
0x0000002250207210ULL, 0x000fe20007ffe0ffULL, 0x00000001772b7824ULL, 0x040fe400000e0629ULL,
0x0000000177297824ULL, 0x000fc400008e0621ULL, 0x0000010020207825ULL, 0x000fc800078e00ffULL,
0x0000000147227824ULL, 0x000fe200078e0222ULL, 0x0000007320237212ULL, 0x000fc800078efcffULL,
0x0000002376207210ULL, 0x000fe20007f1e0ffULL, 0x0000010022227825ULL, 0x000fc800078e00ffULL,
0x0000000177217824ULL, 0x000fe200000e0621ULL, 0x0000007322737212ULL, 0x000fc800078efcffULL,
0x0000007376227210ULL, 0x000fe20007f1e0ffULL, 0x0000000146767824ULL, 0x100fe400078e020cULL,
0x000000107a737824ULL, 0x000fe200078e0271ULL, 0x0000002377237210ULL, 0x000fe200007fe4ffULL,
0x0000000846777824ULL, 0x000fe400078e00ffULL, 0x0000000179467824ULL, 0x140fe200078e020cULL,
0x0000000044737faeULL, 0x0003e2000b901c46ULL, 0x0000000879797824ULL, 0x000fe200078e00ffULL,
0xfffffff877767812ULL, 0x000fe200078ee276ULL, 0x000000015c7a7824ULL, 0x000fc600078e020cULL,
0x0000007176777211ULL, 0x080fe200078e20ffULL, 0x0000000178767824ULL, 0x140fe200078e020cULL,
0xfffffff879467812ULL, 0x000fe400078ee246ULL, 0x0000000378797819ULL, 0x000fe200000006ffULL,
0x0000000042777faeULL, 0x0005e2000b901c46ULL, 0x000000015e787824ULL, 0x100fe400078e020cULL,
0x0000000172457824ULL, 0x142fe200078e020cULL, 0x0000000372727819ULL, 0x000fe200000006ffULL,
0x0000000175447824ULL, 0x140fe200078e020cULL, 0xfffffff879767812ULL, 0x000fe200078ee276ULL,
0x0000000875757824ULL, 0x000fe200078e00ffULL, 0xfffffff872727812ULL, 0x000fe200078ee245ULL,
0x0000000147457824ULL, 0x100fe200078e020cULL, 0x000000035e437819ULL, 0x004fe200000006ffULL,
0x000000015f427824ULL, 0x140fe200078e020cULL, 0xfffffff875447812ULL, 0x000fe200078ee244ULL,
0x000000085f5f7824ULL, 0x000fe200078e00ffULL, 0xfffffff843787812ULL, 0x000fe200078ee278ULL,
0x000000015d5e7824ULL, 0x140fe200078e020cULL, 0x000000035c437819ULL, 0x000fe200000006ffULL,
0x000000085d5d7824ULL, 0x000fe200078e00ffULL, 0xfffffff85f427812ULL, 0x000fe200078ee242ULL,
0x00000001535c7824ULL, 0x140fe200078e020cULL, 0xfffffff8437a7812ULL, 0x000fe200078ee27aULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0x0000000352437819ULL, 0x000fe200000006ffULL,
0x0000000151527824ULL, 0x140fe200078e020cULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee245ULL,
0x0000000851517824ULL, 0x000fe200078e00ffULL, 0xfffffff8437c7812ULL, 0x000fe200078ee27cULL,
0x0000000150437824ULL, 0x040fe200078e020cULL, 0x0000000350507819ULL, 0x000fe200000006ffULL,
0x0000001044477824ULL, 0x100fe200078e0271ULL, 0xfffffff85d5e7812ULL, 0x000fe200078ee25eULL,
0x000000107a737824ULL, 0x100fe200078e0271ULL, 0xfffffff850507812ULL, 0x000fe200078ee243ULL,
0x0000001046437824ULL, 0x100fe200078e0271ULL, 0x0000007176457211ULL, 0x080fe200078e20ffULL,
0x000000105e5f7824ULL, 0x100fe200078e0271ULL, 0xfffffff851527812ULL, 0x000fe200078ee252ULL,
0x0000001072517824ULL, 0x100fe200078e0271ULL, 0xfffffff8535c7812ULL, 0x000fe200078ee25cULL,
0x0000001042537824ULL, 0x100fe200078e0271ULL, 0x00000071785d7211ULL, 0x080fe200078e20ffULL,
0x0000000040437faeULL, 0x0003e2000b901c46ULL, 0x000000717c777211ULL, 0x000fe200078e20ffULL,
0x000000105c757824ULL, 0x000fc400078e0271ULL, 0x000000003e457faeULL, 0x0003e2000b901c46ULL,
0x0000001052797824ULL, 0x100fe400078e0271ULL, 0x00000010507b7824ULL, 0x100fe200078e0271ULL,
0x000000003c477faeULL, 0x0003e2000b901c46ULL, 0x000000107d7d7824ULL, 0x000fc600078e0271ULL,
0x000000003a517faeULL, 0x0003e8000b901c46ULL, 0x0000000038537faeULL, 0x0003e8000b901c46ULL,
0x00000000365d7faeULL, 0x0003e8000b901c46ULL, 0x00000000345f7faeULL, 0x0003e8000b901c46ULL,
0x0000000032737faeULL, 0x0003e8000b901c46ULL, 0x0000000030757faeULL, 0x0003e8000b901c46ULL,
0x000000002a777faeULL, 0x0003e8000b901c46ULL, 0x0000000028797faeULL, 0x0003e8000b901c46ULL,
0x00000000207b7faeULL, 0x0003e8000b901c46ULL, 0x00000000227d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000104f217824ULL, 0x042fe200078e00ffULL,
0x0000000860207810ULL, 0x000fe20007ffe0ffULL, 0x00000010743c7824ULL, 0x100fe200078e024eULL,
0x0000004e70407211ULL, 0x080fe200078e20ffULL, 0x000000106e307824ULL, 0x100fe200078e024eULL,
0xfffffff021207812ULL, 0x000fe200078ee220ULL, 0x0000000a60287836ULL, 0x000fe20000000000ULL,
0x000000044f297819ULL, 0x000fe200000006ffULL, 0x000000106d347824ULL, 0x100fe200078e024eULL,
0x0000004e68687211ULL, 0x080fe200078e20ffULL, 0x0000001020387824ULL, 0x000fe200078e0207ULL,
0xfffffff029287812ULL, 0x000fe200078ee228ULL, 0x000000106f207824ULL, 0x100fe200078e024eULL,
0x0000004e6c6c7211ULL, 0x000fe200078e20ffULL, 0x00000010645c7824ULL, 0x000fc400078e024eULL,
0x0000001028287824ULL, 0x000fe400078e0207ULL, 0x0000001066507824ULL, 0x000fe200078e024eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003c3c783bULL, 0x000fe80000000200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000004040783bULL, 0x000ea80000000200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000002020783bULL, 0x000f280000000200ULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000f680000000200ULL,
0x000000005c5c783bULL, 0x000fe80000000200ULL, 0x000000005050783bULL, 0x000fe20000000200ULL,
0x0000003c3824723cULL, 0x002fec0000041824ULL, 0x0000003e3858723cULL, 0x000fe20000041858ULL,
0x000000106a3c7824ULL, 0x000fca00078e024eULL, 0x000000403854723cULL, 0x004fe20000041854ULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x00000030381c723cULL, 0x008fe2000004181cULL,
0x000000104f407824ULL, 0x040fe200078e00ffULL, 0x000000044f4f7819ULL, 0x000fc800000006ffULL,
0x000000203814723cULL, 0x010fe20000041814ULL, 0x0000000c60317836ULL, 0x000fe40000000000ULL,
0x0000001069307824ULL, 0x000fe400078e024eULL, 0x0000000e60607836ULL, 0x000fe20000000000ULL,
0xfffffff040407812ULL, 0x000fe200078ee231ULL, 0x000000223820723cULL, 0x000fe20000041818ULL,
0x000000006818783bULL, 0x000ea40000000200ULL, 0xfffffff04f607812ULL, 0x000fe200078ee260ULL,
0x0000001040407824ULL, 0x000fc400078e0207ULL, 0x000000423810723cULL, 0x000fe20000041810ULL,
0x0000000760447211ULL, 0x000fc600078e20ffULL, 0x000000004040783bULL, 0x000fe40000000200ULL,
0x00000032382c723cULL, 0x000fe4000004182cULL, 0x000000003030783bULL, 0x000ee80000000200ULL,
0x000000342838723cULL, 0x020fe20000041824ULL, 0x000000004444783bULL, 0x000fe80000000200ULL,
0x000000006c24783bULL, 0x000f220000000200ULL, 0x0000003c2854723cULL, 0x002fe20000041854ULL,
0x0000001067347824ULL, 0x000fca00078e024eULL, 0x000000362858723cULL, 0x000fe20000041858ULL,
0x00000010653c7824ULL, 0x100fe200078e024eULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x0000003e2810723cULL, 0x000fe20000041810ULL, 0x000000003c3c783bULL, 0x000f6a0000000200ULL,
0x000000182814723cULL, 0x004fec0000041814ULL, 0x0000001a2820723cULL, 0x000fe20000041820ULL,
0x0000001063187824ULL, 0x000fca00078e024eULL, 0x00000030281c723cULL, 0x008fe2000004181cULL,
0x000000001818783bULL, 0x000eaa0000000200ULL, 0x00000032282c723cULL, 0x000fec000004182cULL,
0x000000244038723cULL, 0x010fe20000041838ULL, 0x0000001062287824ULL, 0x000fca00078e024eULL,
0x000000264058723cULL, 0x000fe20000041858ULL, 0x0000001061247824ULL, 0x000fe200078e024eULL,
0x000000002828783bULL, 0x000ee80000000200ULL, 0x000000344054723cULL, 0x002fe20000041854ULL,
0x000000002424783bULL, 0x000e6a0000000200ULL, 0x0000003e4020723cULL, 0x020fec0000041820ULL,
0x000000364010723cULL, 0x000fec0000041810ULL, 0x0000003c4014723cULL, 0x000fec0000041814ULL,
0x0000005c401c723cULL, 0x000fec000004181cULL, 0x0000005e402c723cULL, 0x000fec000004182cULL,
0x000000184454723cULL, 0x004fec0000041854ULL, 0x0000002a4420723cULL, 0x008fe20000041820ULL,
0x0000000100197802ULL, 0x000fca0000000f00ULL, 0x000000504438723cULL, 0x000fe20000041838ULL,
0x01b688194a1879a7ULL, 0x000eaa000850003fULL, 0x000000524458723cULL, 0x000fec0000041858ULL,
0x0000001a4410723cULL, 0x000fe20000041810ULL, 0x3db504f354547820ULL, 0x000fe20000410000ULL,
0x3db504f355557820ULL, 0x000fe20000410000ULL, 0x3db504f356567820ULL, 0x000fe20000410000ULL,
0x3db504f357577820ULL, 0x000fc40000410000ULL, 0x000000284414723cULL, 0x000fe20000041814ULL,
0x3db504f320307820ULL, 0x000fe20000410000ULL, 0x3db504f321317820ULL, 0x000fe20000410000ULL,
0x3db504f322227820ULL, 0x000fe20000410000ULL, 0x3db504f323237820ULL, 0x000fe40000410000ULL,
0x00000024441c723cULL, 0x002fe2000004181cULL, 0x3db504f3381b7820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fc40000410000ULL, 0x00000026442c723cULL, 0x000fe2000004182cULL,
0x3db504f358587820ULL, 0x000fe20000410000ULL, 0x3db504f359597820ULL, 0x000fe20000410000ULL,
0x3db504f35a5a7820ULL, 0x000fe20000410000ULL, 0x3db504f35b5b7820ULL, 0x000fe40000410000ULL,
0x3db504f3101a7820ULL, 0x000fe20000410000ULL, 0x3db504f311257820ULL, 0x000fe20000410000ULL,
0x3db504f312247820ULL, 0x000fe20000410000ULL, 0x3db504f313277820ULL, 0x000fc60000410000ULL,
0x3db504f314297820ULL, 0x000fe20000410000ULL, 0x3db504f3152a7820ULL, 0x000fe20000410000ULL,
0x3db504f316287820ULL, 0x000fe20000410000ULL, 0x3db504f317267820ULL, 0x000fc60000410000ULL,
0x3db504f31c327820ULL, 0x000fe20000410000ULL, 0x3db504f31d337820ULL, 0x000fe20000410000ULL,
0x3db504f31e207820ULL, 0x000fe20000410000ULL, 0x3db504f31f217820ULL, 0x000fc60000410000ULL,
0x3db504f32c2c7820ULL, 0x000fe20000410000ULL, 0x3db504f32d2d7820ULL, 0x000fe20000410000ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fe20000410000ULL,
0x0000000000107805ULL, 0x000fe20000015200ULL, 0x01b688194a0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff147224ULL, 0x000fce00078e00ffULL,
0x000000101400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fce0007ffe0ffULL,
0x01b688194a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000040c107824ULL, 0x000fe200078e00ffULL, 0x0000000e4c00720cULL, 0x000fe20003f06070ULL,
0x00000080482b7824ULL, 0x000fc600078e0207ULL, 0xfffffff010107812ULL, 0x000fca00078ec0ffULL,
0x000000012b2b7824ULL, 0x000fca00078e0210ULL, 0x01b400002b107984ULL, 0x0002a20000000c00ULL,
0x0000001000c08947ULL, 0x000fea0003800000ULL, 0x000000010c347819ULL, 0x000fe200000006ffULL,
0x0000860000097ab9ULL, 0x000fe20000000800ULL, 0x0000000d0f147248ULL, 0x000fe20007fe0000ULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x0000000634347812ULL, 0x000fe400078ec0ffULL,
0x000000000c167211ULL, 0x000fe200078ff0ffULL, 0x00000001140d7824ULL, 0x000fe200078e0a0dULL,
0x0000000a34367c10ULL, 0x000fe2000fffe0ffULL, 0x00008c00ff147b82ULL, 0x000ee20000000a00ULL,
0x0000000834187c36ULL, 0x000fe20008000000ULL, 0x00000009ff177c19ULL, 0x000fe20008011616ULL,
0x000000ffff4f7224ULL, 0x000fe200078e0a0dULL, 0x0000000d3600720cULL, 0x080fe20003f06070ULL,
0x0000000816167836ULL, 0x000fe20000000000ULL, 0x0000000d1800720cULL, 0x000fc40003f26070ULL,
0x0000000518187e46ULL, 0x000fe4000b80004fULL, 0x0000000517177c48ULL, 0x000fe4000bfe0000ULL,
0x0000000536457e46ULL, 0x000fe4000b80004fULL, 0x00000004ff187819ULL, 0x000fe20000011618ULL,
0x00000004175c7c24ULL, 0x000fe2000f8e02ffULL, 0x00000009ff167c19ULL, 0x000fe40008011616ULL,
0x000000ff45457207ULL, 0x000fc40000000000ULL, 0x000000ff18177207ULL, 0x000fe40000800000ULL,
0x0000000516167c48ULL, 0x000fe4000bfe0000ULL, 0x0000005c451f7211ULL, 0x000fe200078fe0ffULL,
0x000000015c197824ULL, 0x000fe200078e0217ULL, 0x0000001034387812ULL, 0x000fe200078efcffULL,
0x00000004165e7c24ULL, 0x000fe4000f8e02ffULL, 0x000000021f1e7825ULL, 0x008fc800078e0014ULL,
0x0000000a383c7c36ULL, 0x000fe20008000000ULL, 0x000000061e517981ULL, 0x000722000c1e9500ULL,
0x0000000219187825ULL, 0x000fe200078e0014ULL, 0x0000002034407812ULL, 0x000fc600078efcffULL,
0x0000000117177824ULL, 0x000fe200078e025eULL, 0x0000000d3c00720cULL, 0x080fe20003f06070ULL,
0x0000000618527981ULL, 0x000b22000c1e9500ULL, 0x000000053c357e46ULL, 0x000fe2000b80004fULL,
0x0000000217167825ULL, 0x100fe200078e0014ULL, 0x00000008381e7c10ULL, 0x008fe4000fffe0ffULL,
0x0000005e451d7211ULL, 0x000fe400078fe0ffULL, 0x000000ff35357207ULL, 0x000fe20000000000ULL,
0x0000000a40427c36ULL, 0x000fe20008000000ULL, 0x0000000616507981ULL, 0x0044e2000c1e9500ULL,
0x000000051e187e46ULL, 0x022fe2000b80004fULL, 0x000000021d1c7825ULL, 0x000fe200078e0014ULL,
0x0000000d1e00720cULL, 0x000fc40003f26070ULL, 0x00000004ff187819ULL, 0x000fe40000011618ULL,
0x0000000d4200720cULL, 0x000fe20003f06070ULL, 0x000000061c477981ULL, 0x0002e2000c1e9500ULL,
0x0000005c35177211ULL, 0x004fe400078fe0ffULL, 0x00000005423f7e46ULL, 0x000fe4000b80004fULL,
0x0000000840467c10ULL, 0x000fe2000fffe0ffULL, 0x0000000217167825ULL, 0x000fe200078e0014ULL,
0x000000ff3f3f7207ULL, 0x000fc40000000000ULL, 0x000000ff181d7207ULL, 0x002fe40000800000ULL,
0x0000005e351f7211ULL, 0x000fe200078fe0ffULL, 0x0000000616377981ULL, 0x0002a2000c1e9500ULL,
0x0000000546417e46ULL, 0x000fe2000b80004fULL, 0x000000015c197824ULL, 0x000fe200078e021dULL,
0x0000000d4600720cULL, 0x000fe20003f26070ULL, 0x000000011d3d7824ULL, 0x000fe200078e025eULL,
0x0000003034467812ULL, 0x000fe200078efcffULL, 0x000000021f1c7825ULL, 0x000fe200078e0014ULL,
0x00000004ff417819ULL, 0x000fc40000011641ULL, 0x0000005c3f177211ULL, 0x002fe200078fe0ffULL,
0x0000000219187825ULL, 0x000fe200078e0014ULL, 0x000000ff41437207ULL, 0x000fc60000800000ULL,
0x000000023d1e7825ULL, 0x100fe200078e0014ULL, 0x00000006183e7981ULL, 0x0002a6000c1e9500ULL,
0x0000000217167825ULL, 0x000fe200078e0014ULL, 0x000000061c3d7981ULL, 0x000aa6000c1e9500ULL,
0x0000000846607c36ULL, 0x000fe20008000000ULL, 0x000000061e447981ULL, 0x000aa2000c1e9500ULL,
0x0000000a464c7c10ULL, 0x000fe2000fffe0ffULL, 0x000000015c197824ULL, 0x002fc400078e0243ULL,
0x0000000616417981ULL, 0x0002a2000c1e9500ULL, 0x0000005e3f1d7211ULL, 0x020fe200078fe0ffULL,
0x00000001431f7824ULL, 0x000fe200078e025eULL, 0x0000000560167e46ULL, 0x002fc6000b80004fULL,
0x000000021f1e7825ULL, 0x100fe200078e0014ULL, 0x0000000d4c00720cULL, 0x080fe40003f06070ULL,
0x000000054c4f7e46ULL, 0x000fe2000b80004fULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x0000000d6000720cULL, 0x000fe20003f26070ULL, 0x000000061e1e7981ULL, 0x000f62000c1e9500ULL,
0x00000004ff167819ULL, 0x000fe20000011616ULL, 0x000000021d1c7825ULL, 0x000fe200078e0014ULL,
0x000000ff4f4f7207ULL, 0x000fe20000000000ULL, 0x00000006184e7981ULL, 0x000362000c1e9500ULL,
0x000000ff16537207ULL, 0x000fc60000800000ULL, 0x000000061c437981ULL, 0x000362000c1e9500ULL,
0x0000005c4f177211ULL, 0x000fe200078fe0ffULL, 0x000000015c197824ULL, 0x002fc800078e0253ULL,
0x0000000217167825ULL, 0x000fc800078e0014ULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x0000005e4f1d7211ULL, 0x000fe200078fe0ffULL, 0x0000000616167981ULL, 0x000368000c1e9500ULL,
0x0000000618197981ULL, 0x000362000c1e9500ULL, 0x0000000153537824ULL, 0x000fe400078e025eULL,
0x000000021d1c7825ULL, 0x000fc800078e0014ULL, 0x0000000253147825ULL, 0x000fe400078e0014ULL,
0x000000061c1c7981ULL, 0x000f68000c1e9500ULL, 0x0000000614157981ULL, 0x000362000c1e9500ULL,
0xfffffff0455c7812ULL, 0x000fca00078ec0ffULL, 0x000000010d177824ULL, 0x002fe200078e025cULL,
0x00000001001f7802ULL, 0x000fc60000000f00ULL, 0x0000000136627824ULL, 0x000fe200078e0a17ULL,
0x00000008345c7812ULL, 0x040fe400078efcffULL, 0x00000009345e7812ULL, 0x000fe400078efcffULL,
0x000000621f627219ULL, 0x000fe400000006ffULL, 0x0000000a5c187c10ULL, 0x000fe2000fffe0ffULL,
0x0000000a5e147c36ULL, 0x000fc80008000000ULL, 0x0000000118667824ULL, 0x000fe200078e0a17ULL,
0x0000001417687210ULL, 0x000fe40007ffe1ffULL, 0x0000001834787812ULL, 0x040fe400078efcffULL,
0xfffffff035357812ULL, 0x000fe400078ec0ffULL, 0x000000661f667219ULL, 0x040fe400000006ffULL,
0x000000681f687219ULL, 0x000fe400000006ffULL, 0xfffffff03f457812ULL, 0x000fe200078ec0ffULL,
0x000000010d3f7824ULL, 0x000fe200078e0235ULL, 0x0000001934767812ULL, 0x000fc400078efcffULL,
0x00000011347a7812ULL, 0x040fe400078efcffULL, 0x00000021346c7812ULL, 0x040fe400078efcffULL,
0x00000028346a7812ULL, 0x000fe200078efcffULL, 0x0000000a767c7c36ULL, 0x000fe20008000000ULL,
0xfffffff04f4f7812ULL, 0x000fe200078ec0ffULL, 0x0000000a7a1d7c36ULL, 0x000fe20008000000ULL,
0x0000000a6c727c10ULL, 0x000fe2000fffe0ffULL, 0x0000000a6a707c36ULL, 0x000fe20008000000ULL,
0x0000004f0d5d7210ULL, 0x000fe20007ffe0ffULL, 0x000000011d4f7824ULL, 0x000fe200078e0a3fULL,
0x0000007c3f537210ULL, 0x000fc60007ffe1ffULL, 0x000000014c677824ULL, 0x000fe200078e0a5dULL,
0x0000004f1f4f7219ULL, 0x000fc800000006ffULL, 0x000000671f677219ULL, 0x000fe400000006ffULL,
0x0000541051517816ULL, 0x010fe40000000052ULL, 0x0000000134527812ULL, 0x000fe400078efcffULL,
0x0000005162ff7212ULL, 0x000fc6000780c0ffULL, 0x0000000a52607c36ULL, 0x000fe20008000000ULL,
0x0000000d3600720cULL, 0x000fc60000701470ULL, 0x0000000160647824ULL, 0x000fe200078e0a17ULL,
0x0000000d3400720cULL, 0x000fe20000701070ULL, 0x0000000a78177c36ULL, 0x000fe20008000000ULL,
0x0000541047477816ULL, 0x008fe40000000050ULL, 0x000000641f647219ULL, 0x000fe400000006ffULL,
0xff8000001b1b7808ULL, 0x000fe40000000000ULL, 0x0000004762ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004766ff7212ULL, 0x000fc400078cc0ffULL, 0x0000004768ff7212ULL, 0x080fe4000780c0ffULL,
0x0000004764ff7212ULL, 0x040fe200078ac0ffULL, 0x000000010d477824ULL, 0x000fe200078e0245ULL,
0x0000005164ff7212ULL, 0x080fe2000786c0ffULL, 0x000000013c457824ULL, 0x100fe200078e0a3fULL,
0x0000005166ff7212ULL, 0x080fe4000784c0ffULL, 0x0000005168ff7212ULL, 0x000fe2000782c0ffULL,
0x0000000117517824ULL, 0x000fe200078e0a3fULL, 0x0000000d3600720cULL, 0x000fc40002781470ULL,
0x0000000d1800720cULL, 0x080fe400037c1470ULL, 0x0000000d1400720cULL, 0x080fe40000701470ULL,
0x0000000d3400720cULL, 0x080fe40002781070ULL, 0x0000000d5c00720cULL, 0x080fe400037c1070ULL,
0x0000000d5e00720cULL, 0x000fe40000701070ULL, 0x0000002934687812ULL, 0x000fc400078efcffULL,
0x000000451f457219ULL, 0x040fe400000006ffULL, 0x000000511f517219ULL, 0x000fe400000006ffULL,
0x00005410373e7816ULL, 0x004fe4000000003eULL, 0x000054103d447816ULL, 0x000fe40000000044ULL,
0x0000003934507812ULL, 0x040fe400078efcffULL, 0x0000003134647812ULL, 0x000fc400078efcffULL,
0x0000003834627812ULL, 0x000fe400078efcffULL, 0x0000000d1400720cULL, 0x000fe40000f21470ULL,
0xff8000003a3a7808ULL, 0x000fe40002000000ULL, 0xff8000005a5a7808ULL, 0x000fe40003000000ULL,
0xff8000005b5b7808ULL, 0x000fe20000000000ULL, 0x0000000a686e7c36ULL, 0x000fe20008000000ULL,
0x0000003e45ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004445ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004451ff7212ULL, 0x000fe2000780c0ffULL, 0x0000000a50357c36ULL, 0x000fe20008000000ULL,
0x0000000a62747c10ULL, 0x000fe2000fffe0ffULL, 0x0000000a64667c36ULL, 0x000fe20008000000ULL,
0x0000000d5e00720cULL, 0x080fe20000f21070ULL, 0x00000001425f7824ULL, 0x000fe200078e0a47ULL,
0x0000000d6000720cULL, 0x0c0fe40001f61470ULL, 0x0000000d6000720cULL, 0x000fc40002fa1470ULL,
0x0000000d1800720cULL, 0x080fe40001741470ULL, 0x0000000d3c00720cULL, 0x0c0fe40002781470ULL,
0x0000000d3c00720cULL, 0x080fe400037c1470ULL, 0x0000000d1700720cULL, 0x000fe20000701470ULL,
0x0000000172617824ULL, 0x100fe200078e0a47ULL, 0x0000006e47657210ULL, 0x000fe20007ffe1ffULL,
0x0000000170637824ULL, 0x000fe200078e0a47ULL, 0x000000355d477210ULL, 0x000fe20007ffe1ffULL,
0x0000000166697824ULL, 0x100fe200078e0a5dULL, 0xff80000059597808ULL, 0x000fe20000800000ULL,
0x00000001743f7824ULL, 0x000fe200078e0a5dULL, 0x000000531f5d7219ULL, 0x000fc400000006ffULL,
0x0000000d5200720cULL, 0x0c0fe40001f61070ULL, 0x0000000d5200720cULL, 0x080fe40002fa1070ULL,
0x0000000d5c00720cULL, 0x080fe40001741070ULL, 0x0000000d3800720cULL, 0x0c0fe40002721070ULL,
0x0000000d3800720cULL, 0x080fe400037c1070ULL, 0x0000000d7800720cULL, 0x000fc40000701070ULL,
0x0000005f1f537219ULL, 0x000fe400000006ffULL, 0x00005410414e7816ULL, 0x020fe4000000004eULL,
0x00005410431e7816ULL, 0x000fe4000000001eULL, 0xff80000039397808ULL, 0x000fe40001800000ULL,
0xff8000003b3b7808ULL, 0x000fe40002800000ULL, 0xff80000058587808ULL, 0x000fc40001000000ULL,
0xff80000054547808ULL, 0x000fe40000800000ULL, 0xff80000056567808ULL, 0x000fe40003000000ULL,
0xff80000024247808ULL, 0x000fe40000000000ULL, 0x0000003e4fff7212ULL, 0x080fe4000786c0ffULL,
0x0000003e51ff7212ULL, 0x080fe400078ac0ffULL, 0x0000003e5dff7212ULL, 0x000fc4000784c0ffULL,
0x000000444fff7212ULL, 0x080fe4000788c0ffULL, 0x000000445dff7212ULL, 0x000fe4000782c0ffULL,
0x0000004e53ff7212ULL, 0x040fe400078cc0ffULL, 0x0000001e53ff7212ULL, 0x000fe4000780c0ffULL,
0x0000000d1d00720cULL, 0x0c0fe40001f61470ULL, 0x0000000d1d00720cULL, 0x000fc40002781470ULL,
0x0000000d1700720cULL, 0x080fe40002fa1470ULL, 0x0000000d7c00720cULL, 0x0c0fe40001741470ULL,
0x0000000d7c00720cULL, 0x080fe40000f21470ULL, 0x0000000d4200720cULL, 0x0c0fe400037c1470ULL,
0x0000000d4200720cULL, 0x080fe40000701470ULL, 0x0000000d7a00720cULL, 0x000fc40001f61070ULL,
0x0000000d7a00720cULL, 0x080fe40002781070ULL, 0x0000000d7800720cULL, 0x080fe40002fa1070ULL,
0x0000000d7600720cULL, 0x0c0fe40001741070ULL, 0x0000000d7600720cULL, 0x080fe40000f21070ULL,
0x0000000d4000720cULL, 0x0c0fe400037c1070ULL, 0x0000000d4000720cULL, 0x000fc40000701070ULL,
0x000000611f617219ULL, 0x040fe400000006ffULL, 0x000000631f637219ULL, 0x040fe400000006ffULL,
0x000000651f657219ULL, 0x000fe400000006ffULL, 0x0000541016167816ULL, 0x000fe40000000019ULL,
0xff80000055557808ULL, 0x000fe40001800000ULL, 0xff80000057577808ULL, 0x000fc40002000000ULL,
0xff8000001a1a7808ULL, 0x000fe40002800000ULL, 0xff80000025257808ULL, 0x000fe40001000000ULL,
0xff80000027277808ULL, 0x000fe40000800000ULL, 0xff80000029297808ULL, 0x000fe40003000000ULL,
0xff80000028287808ULL, 0x000fe40000000000ULL, 0x0000004e61ff7212ULL, 0x000fc4000786c0ffULL,
0x0000004e63ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004e65ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001e61ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001e63ff7212ULL, 0x080fe4000782c0ffULL,
0x0000001e65ff7212ULL, 0x000fe400078cc0ffULL, 0x0000001667ff7212ULL, 0x000fc4000780c0ffULL,
0x0000000d7200720cULL, 0x0c0fe40001f61470ULL, 0x0000000d7200720cULL, 0x080fe40001741470ULL,
0x0000000d7000720cULL, 0x0c0fe40002781470ULL, 0x0000000d7000720cULL, 0x080fe40000f21470ULL,
0x0000000d6e00720cULL, 0x0c0fe40002fa1470ULL, 0x0000000d6e00720cULL, 0x000fc400037c1470ULL,
0x0000000d4c00720cULL, 0x080fe40000701470ULL, 0x0000000d6c00720cULL, 0x0c0fe40001f61070ULL,
0x0000000d6c00720cULL, 0x080fe40001741070ULL, 0x0000000d6a00720cULL, 0x0c0fe40002781070ULL,
0x0000000d6a00720cULL, 0x080fe40000f21070ULL, 0x0000000d6800720cULL, 0x000fc40002fa1070ULL,
0x0000000d6800720cULL, 0x080fe400037c1070ULL, 0x0000000d4600720cULL, 0x000fe40000701070ULL,
0x000000691f697219ULL, 0x040fe400000006ffULL, 0x0000003f1f3f7219ULL, 0x040fe400000006ffULL,
0x000000471f477219ULL, 0x000fe400000006ffULL, 0x000054101c1c7816ULL, 0x000fc40000000015ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff80000026267808ULL, 0x000fe40001000000ULL,
0xff80000030307808ULL, 0x000fe40002000000ULL, 0xff80000022227808ULL, 0x000fe40000800000ULL,
0xff80000031317808ULL, 0x000fe40002800000ULL, 0xff80000023237808ULL, 0x000fc40003000000ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0x0000001669ff7212ULL, 0x080fe4000786c0ffULL,
0x000000163fff7212ULL, 0x080fe4000784c0ffULL, 0x0000001647ff7212ULL, 0x000fe4000788c0ffULL,
0x0000001c67ff7212ULL, 0x080fe4000782c0ffULL, 0x0000001c69ff7212ULL, 0x000fc400078ac0ffULL,
0x0000001c3fff7212ULL, 0x080fe400078cc0ffULL, 0x0000001c47ff7212ULL, 0x000fe4000780c0ffULL,
0x0000000d4c00720cULL, 0x080fe40000f21470ULL, 0x0000000d6600720cULL, 0x0c0fe40001f61470ULL,
0x0000000d6600720cULL, 0x080fe40002fa1470ULL, 0x0000000d7400720cULL, 0x000fc40001741470ULL,
0x0000000d7400720cULL, 0x080fe400037c1470ULL, 0x0000000d3500720cULL, 0x0c0fe40002781470ULL,
0x0000000d3500720cULL, 0x080fe40000701470ULL, 0x0000000d4600720cULL, 0x080fe40000f21070ULL,
0x0000000d6400720cULL, 0x0c0fe40001f61070ULL, 0x0000000d6400720cULL, 0x000fc40002fa1070ULL,
0x0000000d6200720cULL, 0x0c0fe40001741070ULL, 0x0000000d6200720cULL, 0x080fe400037c1070ULL,
0x0000000d5000720cULL, 0x0c0fe40002781070ULL, 0x0000000d5000720cULL, 0x000fe40000701070ULL,
0xff80000033337808ULL, 0x000fe40001800000ULL, 0xff8000002c2c7808ULL, 0x000fc40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40002000000ULL, 0xff80000020207808ULL, 0x000fe40000800000ULL,
0xff80000021217808ULL, 0x000fe40002800000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fce0000000000ULL, 0x0000001b1000720bULL, 0x004fe20003f1e000ULL,
0x3f80000000097882ULL, 0x000fe20000000000ULL, 0x0000000308087812ULL, 0x000fe200078ec0ffULL,
0x00000009ff197e24ULL, 0x000fe2000f8e00ffULL, 0x000000101b107208ULL, 0x000fe20004000000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e006bULL, 0xfffffff8ff0b7812ULL, 0x000fe400078ee20bULL,
0x000000391000720bULL, 0x000fc80003f1e000ULL, 0x00000010390d7208ULL, 0x000fc80004000000ULL,
0x000000580d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d58107208ULL, 0x000fc80004000000ULL,
0x000000591000720bULL, 0x000fc80003f1e000ULL, 0x00000010590d7208ULL, 0x000fc80004000000ULL,
0x000000540d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d54107208ULL, 0x000fc80004000000ULL,
0x000000551000720bULL, 0x000fc80003f1e000ULL, 0x00000010550d7208ULL, 0x000fc80004000000ULL,
0x0000001a0d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d1a107208ULL, 0x000fc80004000000ULL,
0x000000251000720bULL, 0x000fc80003f1e000ULL, 0x0000001025107208ULL, 0x000fc80004000000ULL,
0x000000291000720bULL, 0x000fc80003f1e000ULL, 0x00000010290d7208ULL, 0x000fc80004000000ULL,
0x0000002a0d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d2a0d7208ULL, 0x000fc80004000000ULL,
0x000000300d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d30107208ULL, 0x000fe40004000000ULL,
0x0000003a1100720bULL, 0x000fe40003f1e000ULL, 0x000000311000720bULL, 0x000fc80003f3e000ULL,
0x00000010310d7208ULL, 0x000fe40004800000ULL, 0x000000113a107208ULL, 0x000fe40004000000ULL,
0x000000320d00720bULL, 0x000fe40003f3e000ULL, 0x0000003b1000720bULL, 0x000fe40003f1e000ULL,
0x0000000d32147208ULL, 0x000fe40004800000ULL, 0x000000103b0d7208ULL, 0x000fc40004000000ULL,
0x000000331400720bULL, 0x000fe40003f3e000ULL, 0x0000005a0d00720bULL, 0x000fe40003f1e000ULL,
0x0000001433117208ULL, 0x000fe40004800000ULL, 0x0000000d5a107208ULL, 0x000fe40004000000ULL,
0x0000002c1100720bULL, 0x000fe40003f3e000ULL, 0x0000005b1000720bULL, 0x000fc40003f1e000ULL,
0x000000112c147208ULL, 0x000fe40004800000ULL, 0x000000105b0d7208ULL, 0x000fe40004000000ULL,
0x0000002d1400720bULL, 0x000fe40003f3e000ULL, 0x000000560d00720bULL, 0x000fe40003f1e000ULL,
0x000000142d147208ULL, 0x000fe40004800000ULL, 0x0000000d56107208ULL, 0x000fc60004000000ULL,
0x0c401f0014117f89ULL, 0x000ea200000e0000ULL, 0x000000571000720bULL, 0x000fc80003f1e000ULL,
0x00000010570d7208ULL, 0x000fc80004000000ULL, 0x000000240d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d24107208ULL, 0x000fc80004000000ULL, 0x000000271000720bULL, 0x000fc80003f1e000ULL,
0x00000010270d7208ULL, 0x000fe40004000000ULL, 0x000000111400720bULL, 0x004fe40003f3e000ULL,
0x000000280d00720bULL, 0x000fe40003f1e000ULL, 0x0000001411117208ULL, 0x000fe40004800000ULL,
0x0000000d280d7208ULL, 0x000fc60004000000ULL, 0x0c201f0011147f89ULL, 0x000ea200000e0000ULL,
0x000000260d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d260d7208ULL, 0x000fc80004000000ULL,
0x000000220d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d22107208ULL, 0x000fc80004000000ULL,
0x000000231000720bULL, 0x000fc80003f1e000ULL, 0x00000010230d7208ULL, 0x000fe40004000000ULL,
0x000000141100720bULL, 0x004fe40003f3e000ULL, 0x000000200d00720bULL, 0x000fe40003f1e000ULL,
0x0000001114107208ULL, 0x000fe40004800000ULL, 0x0000000d20147208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b10167820ULL, 0x000fe20000410000ULL, 0x000000211400720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b31157823ULL, 0x100fe20000010816ULL, 0x00000014210d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b33317823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b58587823ULL, 0x100fe20000010816ULL, 0x0000002e0d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b59597823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010816ULL, 0x0000000d2e147208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2a347823ULL, 0x100fe20000010816ULL, 0x0000001a001e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c2a7823ULL, 0x100fe20000010816ULL, 0x0000002f1400720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b30357823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010816ULL, 0x000000142f147208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010816ULL, 0x0000001500367308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b32307823ULL, 0x100fe20000010816ULL,
0x0c401f00140d7f89ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b2d2d7823ULL, 0x000fc80000010816ULL,
0x0000001b001b7308ULL, 0x000ff00000000800ULL, 0x0000003900187308ULL, 0x000ff00000000800ULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0x0000000d1400720bULL, 0x004fc80003f1e000ULL,
0x000000140d117208ULL, 0x000fc60004000000ULL, 0x0000005900597308ULL, 0x000ea40000000800ULL,
0x0c201f0011147f89ULL, 0x000eec00000e0000ULL, 0x00000029000d7308ULL, 0x000fe20000000800ULL,
0x000000585916723eULL, 0x004fce00000010ffULL, 0x00000054001c7308ULL, 0x000ff00000000800ULL,
0x0000005500557308ULL, 0x000ea20000000800ULL, 0x000000141100720bULL, 0x008fc80003f1e000ULL,
0x0000001114117208ULL, 0x000fc60004000000ULL, 0x0000002500257308ULL, 0x000ee20000000800ULL,
0x0000001b1814723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b11337820ULL, 0x000fe20000410000ULL,
0x0000001c551c723eULL, 0x004fc600000010ffULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b5b5b7823ULL, 0x100fe20000010833ULL, 0x0000003a00157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b28377823ULL, 0x100fe20000010833ULL, 0x3f8000001928783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b56567823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010833ULL,
0x000000ffff297224ULL, 0x000fe200078e0028ULL, 0x0000003b001a7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010833ULL, 0x0000001e251e723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b23397823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010833ULL,
0x0c401f0012237f89ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010833ULL, 0x0000005a00177308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b20207823ULL, 0x000fe20000010833ULL, 0x000000151a15723eULL, 0x004fcc00000010ffULL,
0x0000005b002c7308ULL, 0x000eb00000000800ULL, 0x00000056001d7308ULL, 0x000fe20000000800ULL,
0x000000231200720bULL, 0x008fe40003f1e000ULL, 0x000000172c17723eULL, 0x004fca00000010ffULL,
0x0000005700327308ULL, 0x000ea20000000800ULL, 0x0000001223127208ULL, 0x000fe20004000000ULL,
0x000000281418723cULL, 0x000fec00000418ffULL, 0x00000024001f7308ULL, 0x0007e20000000800ULL,
0x0000001d321d723eULL, 0x004fce00000010ffULL, 0x0000002700387308ULL, 0x0005220000000800ULL,
0x3fb8aa3b22247823ULL, 0x008fe40000010833ULL, 0x0c401f0013227f89ULL, 0x000eea00000e0000ULL,
0x00000026002c7308ULL, 0x000be20000000800ULL, 0x0000002800277202ULL, 0x004fe40000000f00ULL,
0x0000001f381f723eULL, 0x010fca00000010ffULL, 0x0000002400297308ULL, 0x0005e20000000800ULL,
0x000000ffff267224ULL, 0x022fce00078e0028ULL, 0x0000003900327308ULL, 0x000e620000000800ULL,
0x000000261c24723cULL, 0x004fe20000041818ULL, 0x000000221300720bULL, 0x008fc80003f3e000ULL,
0x0000001322137208ULL, 0x000fe40004800000ULL, 0x0000003400347308ULL, 0x000ea20000000800ULL,
0x00000029321b723eULL, 0x002fce00000010ffULL, 0x0000003500357308ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e0028ULL, 0x0000000d3418723eULL, 0x004fcc00000010ffULL,
0x0000003700377308ULL, 0x000ea20000000800ULL, 0x00000001080d7824ULL, 0x000fe200078e020bULL,
0x00000035361a723eULL, 0x002fcc00000010ffULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000ffff367224ULL, 0x000fe200078e0028ULL, 0x000000372c19723eULL, 0x004fcc00000010ffULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x000000080b2c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fe200078e0028ULL, 0x000000281824723cULL, 0x000fe80000041824ULL,
0x0000002a002a7308ULL, 0x000fe60000000800ULL, 0xfffffff82c297812ULL, 0x000fc400078ee20dULL,
0x000000040d2c7810ULL, 0x000fc60007ffe0ffULL, 0x0000002d002d7308ULL, 0x000e700000000800ULL,
0x0000002000387308ULL, 0x0005e20000000800ULL, 0x0000002a2d22723eULL, 0x002fce00000010ffULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x000000303120723eULL, 0x004fe200000010ffULL,
0x000000080b317824ULL, 0x000fe200078e00ffULL, 0x000000080b2d7810ULL, 0x000fe20007ffe0ffULL,
0x00000800482a7824ULL, 0x000fe200078e0207ULL, 0x0c201f00120b7f89ULL, 0x000ea200000e0000ULL,
0x000000ffff307224ULL, 0x000fe200078e0018ULL, 0x000000032d337819ULL, 0x040fe200000006ffULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000082d287824ULL, 0x000fe200078e00ffULL,
0x0000002000327202ULL, 0x000fe20000000f00ULL, 0x000110002a2a7836ULL, 0x000fc40000000000ULL,
0x000000ffff187224ULL, 0x000fe200078e0019ULL, 0x0000001b00197202ULL, 0x000fe20000000f00ULL,
0x0000001029297824ULL, 0x000fe200078e022aULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x000000382121723eULL, 0x002fe400000010ffULL, 0x0000000b1200720bULL, 0x004fe40003f1e000ULL,
0x0000002e2f23723eULL, 0x008fe200000010ffULL, 0x00000001082e7824ULL, 0x000fe200078e022dULL,
0x000000120b127208ULL, 0x000fe20004000000ULL, 0x0c201f0013087f89ULL, 0x000e6200000e0000ULL,
0x0000000c0d2f7836ULL, 0x000fe20000000000ULL, 0x000000030cff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff1b7224ULL, 0x000fe200078e0023ULL, 0x000000362024723cULL, 0x000fe20000041824ULL,
0xfffffff8332d7812ULL, 0x000fca00078ee22eULL, 0x000000ffff337224ULL, 0x000fe200078e0022ULL,
0xfffffff8310d7812ULL, 0x000fe200078ee22cULL, 0x000000ffff2c7224ULL, 0x000fe200078e0014ULL,
0xfffffff828357812ULL, 0x000fe200078ee22fULL, 0x000000ffff2f7224ULL, 0x000fe200078e001eULL,
0x0000001c002e7202ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x0000002a0d0d7211ULL, 0x000fe200078e20ffULL, 0x000000ffff317224ULL, 0x000fe200078e001aULL,
0x0000001700157202ULL, 0x000fe20000000f00ULL, 0x000000ffff177224ULL, 0x000fc400078e001fULL,
0x0000001035357824ULL, 0x100fe400078e022aULL, 0x000000ffff1a7224ULL, 0x000fe400078e0021ULL,
0x000000102d257824ULL, 0x000fe200078e022aULL, 0x000000081300720bULL, 0x002fe20003f3e000ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0016ULL, 0x000000ffff167224ULL, 0x000fe200078e001dULL,
0x0000001308137208ULL, 0x000fe20004800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0024ULL,
0x00000026001d7202ULL, 0x000fe20000000f00ULL, 0x0000002c29007844ULL, 0x0003e20000000200ULL,
0x00000001ff087424ULL, 0x000fc600078e00ffULL, 0x000000300d007844ULL, 0x0003e80000000200ULL,
0x0000001425007844ULL, 0x0003e80000000200ULL, 0x0000001835007844ULL, 0x0003e80000000200ULL,
0x01b000102b008388ULL, 0x0003e80000000c00ULL, 0x01b2001c2b008388ULL, 0x0003e20000000a00ULL,
0x000000056b00720cULL, 0x000fe20003f06070ULL, 0x01b6080849ff79a7ULL, 0x0003e2000850003fULL,
0x01b6100849ff79a7ULL, 0x0003e2000850003fULL, 0x01b6180849ff79a7ULL, 0x0003e2000850003fULL,
0x01b6200849ff79a7ULL, 0x0003f2000850003fULL, 0xffffff9c00208947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000004027836ULL, 0x000fe20000000000ULL,
0x0000013000007945ULL, 0x000fe80003800000ULL, 0x7f80000002057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000400028308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000205ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff04ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000004047812ULL, 0x002fe400078ec0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000205ff7212ULL, 0x000fda000780c0ffULL, 0x0080000004020812ULL, 0x000fe400078efcffULL,
0x0000000400028202ULL, 0x000fe20000000f00ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000400027308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x006fe400078e000cULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffffec8047c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000495ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000210ULL, 0x0000001400000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000820ULL, 0x00000000000000f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000918ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000096cULL, 0x0000000000000460ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dd0ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dd0ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000e18ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000013700ULL, 0x0000001400000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014580ULL, 0x000000000000003cULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000145c0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000145c0ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000014bb0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000014bb0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000e18ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013700ULL,
0x0000000000013700ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014580ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000145c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_16_sm_90_cubin_len = 85248;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
