/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c7c0ULL, 0x000000000001c440ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45346a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL,
0x6a4c4545346a4c6aULL, 0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL,
0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL,
0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL,
0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL,
0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL,
0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL,
0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000028ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b002200000377ULL, 0x000000000001abf0ULL, 0x0000000000000170ULL,
0x000b0022000003aaULL, 0x000000000001ad60ULL, 0x0000000000000040ULL, 0x000b0022000003d5ULL,
0x000000000001ada0ULL, 0x0000000000000050ULL, 0x000b0022000003ffULL, 0x000000000001adf0ULL,
0x0000000000000110ULL, 0x000a00030000046dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000048dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000001af00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001abf000000000ULL, 0x0000040400000000ULL,
0x810c000001500400ULL, 0x0069a00400288080ULL, 0x0000000000000000ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808892ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001abf000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080a50828808081ULL, 0xc108288080a60828ULL,
0x288080d208288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080d2ULL,
0x0000001cffffffffULL, 0x000000e000000000ULL, 0x0001ad6000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080a60828808081ULL, 0xa508288080c10828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a5920000ULL, 0x0000000000000022ULL,
0x0000002cffffffffULL, 0x0000016000000000ULL, 0x0001ada000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x80a6288080a50900ULL, 0x0000000000002880ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080a50828808081ULL, 0xa608288080c10828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080a6920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000001f000000000ULL,
0x0001adf000000000ULL, 0x0000011000000000ULL, 0x0000000000000000ULL, 0x0000001700082f04ULL,
0x00082304000000e1ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000011ULL, 0x0000001100081204ULL,
0x0008110400000000ULL, 0x0000000000000011ULL, 0x0000001000082304ULL, 0x0008120400000000ULL,
0x0000000000000010ULL, 0x0000001000081104ULL, 0x0008230400000000ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0060016000000014ULL, 0x000c170400601903ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000ab000043104ULL,
0xffffffff01cc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000013001cc2804ULL, 0x000004c000000340ULL,
0x00002de000001cb0ULL, 0x00002f9000002e80ULL, 0x0000327000003100ULL, 0x000035e0000033d0ULL,
0x0000363000003620ULL, 0x00003fd000003660ULL, 0x00004fc000004f20ULL, 0x00005250000050e0ULL,
0x00005520000053c0ULL, 0x0000576000005720ULL, 0x000057a000005770ULL, 0x00006e4000005e30ULL,
0x00006ff000006ed0ULL, 0x000072d000007160ULL, 0x0000763000007430ULL, 0x0000768000007670ULL,
0x00007cc0000076b0ULL, 0x00008d5000008cc0ULL, 0x00008fe000008e70ULL, 0x000092b000009150ULL,
0x000094f0000094b0ULL, 0x0000953000009500ULL, 0x00009ca000009c90ULL, 0x00009cc000009cb0ULL,
0x0000cab00000ca70ULL, 0x0000cb600000cae0ULL, 0x0000d7300000d700ULL, 0x0000d8d00000d750ULL,
0x00018300000182c0ULL, 0x0001832000018310ULL, 0x0001839000018370ULL, 0x000183c0000183b0ULL,
0x00019850000197f0ULL, 0x00019920000198c0ULL, 0x000199e000019980ULL, 0x00019ac000019a50ULL,
0x00019ba000019b30ULL, 0x00019c6000019c00ULL, 0x00019d3000019cd0ULL, 0x00019df000019d90ULL,
0x00019ed000019e60ULL, 0x00019fb000019f40ULL, 0x0001a0700001a010ULL, 0x0001a1400001a0e0ULL,
0x0001a2000001a1a0ULL, 0x0001a2e00001a270ULL, 0x0001a3c00001a350ULL, 0x0001a4800001a420ULL,
0x0001a5500001a4f0ULL, 0x0001a6100001a5b0ULL, 0x0001a6f00001a680ULL, 0x0001a7d00001a760ULL,
0x0001a8d00001a850ULL, 0x0001a9d00001a950ULL, 0x0001aad00001aa50ULL, 0x0001abd00001ab50ULL,
0x0000041002003904ULL, 0x0001e600000000ffULL, 0x00000450003f0100ULL, 0x0001e60800000007ULL,
0x00000490003f0120ULL, 0x0001e68800000007ULL, 0x00000ad0003f0120ULL, 0x0001e600000000ffULL,
0x00000cd0003f0107ULL, 0x0001e68c00000018ULL, 0x00000da0003f0102ULL, 0x0001e68800000018ULL,
0x00002af0003f0101ULL, 0x0001e60800000000ULL, 0x00002b10003f0101ULL, 0x0001e60c00000000ULL,
0x00002ce0003f0105ULL, 0x0001e60c00000000ULL, 0x00003f50003f0105ULL, 0x0001e68800000022ULL,
0x00004c60003f0101ULL, 0x0001e62800000021ULL, 0x00004c80003f0101ULL, 0x0001e62c00000021ULL,
0x00004e50003f0105ULL, 0x0001e62c00000021ULL, 0x00005de0003f0105ULL, 0x0000000000000024ULL,
0x00006b80003f0101ULL, 0x0001e64800000022ULL, 0x00006ba0003f0101ULL, 0x0001e64c00000022ULL,
0x00006d70003f0105ULL, 0x0001e64c00000022ULL, 0x00007ca0003f0105ULL, 0x0000000000000024ULL,
0x00008a10003f0101ULL, 0x0001e66800000062ULL, 0x00008a30003f0101ULL, 0x0001e66c00000062ULL,
0x00008c00003f0105ULL, 0x0001e66c00000062ULL, 0x00009af0003f0105ULL, 0x0000000000000000ULL,
0x0000f250003f0101ULL, 0x0001e600000000ffULL, 0x00010a70003f0101ULL, 0x0001e604000000ffULL,
0x00010c40003f0105ULL, 0x0001e604000000ffULL, 0x00015640003f0105ULL, 0x000000000000009cULL,
0x000158e0003f0101ULL, 0x000000040000009cULL, 0x00015ab0003f0105ULL, 0x000000040000009cULL,
0x00019640003f0105ULL, 0x0001e6080000009eULL, 0x000196a0003f0101ULL, 0x0001e6100000009eULL,
0x00019700003f0101ULL, 0x0001e6180000009eULL, 0x00019770003f0101ULL, 0x0001e6200000009eULL,
0x00033803003f0101ULL, 0x0000e5a000301c04ULL, 0x0000e7a00000e5d0ULL, 0x0000ea600000e900ULL,
0x0000ed200000ebc0ULL, 0x0000f0100000ee80ULL, 0x00010ca00000f110ULL, 0x00000401000197b0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000025cULL, 0x0000001700000002ULL, 0x00000000000001ccULL,
0x0000001700000002ULL, 0x000000000000014cULL, 0x0000001700000002ULL, 0x00000000000000ccULL,
0x0000001700000002ULL, 0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000232ULL,
0x0000001700000002ULL, 0x00000000000001a2ULL, 0x0000001700000002ULL, 0x0000000000000127ULL,
0x0000001700000002ULL, 0x00000000000000a8ULL, 0x0000001700000002ULL, 0x000000000001e700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0c7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000087919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000c857a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000097919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000a27919ULL, 0x000ee20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fe20007ffe0ffULL,
0x00000005ff1d7e24ULL, 0x010fe2000f8e00ffULL, 0x00000005ff1e7819ULL, 0x004fc80000011609ULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x00001fff1e1e7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003837a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a83ULL,
0x0000040003007624ULL, 0x000fca00078e020cULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000183830810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000183831810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff83aa12ULL, 0x000fc800078e33ffULL, 0x0000008300007306ULL, 0x000e620000209000ULL,
0x000000ff8300720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000383047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000000603157227ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee40000002200ULL,
0x000000ffff007224ULL, 0x000fc800078e0a15ULL, 0x0000000083007224ULL, 0x000fca00078e0206ULL,
0x000000830000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe200078e0a83ULL,
0x0000000115150810ULL, 0x000fe20007ffe0ffULL, 0x0000010008027a24ULL, 0x008fc600078e0203ULL,
0x000000830000720cULL, 0x000fe20003f26070ULL, 0x0000000002077a24ULL, 0x000fe400078e0209ULL,
0x00001fff08097589ULL, 0x000e6600000e0000ULL, 0x000000ff0700720cULL, 0x040fe40003f65270ULL,
0x0000000f0700780cULL, 0x040fe40003f84070ULL, 0x000000030700780cULL, 0x000fc60003f04070ULL,
0x0000000115151810ULL, 0x000fe40007ffe0ffULL, 0x00000083ff15a212ULL, 0x000fe400078e33ffULL,
0x0000007f0700780cULL, 0x000fe40003f24070ULL, 0x3fffff80ff02b424ULL, 0x000fe200078e00ffULL,
0x7fffff800003b802ULL, 0x000fe20000000f00ULL, 0x000000ffff007224ULL, 0x000fe200078e0a15ULL,
0x00005a0015827a19ULL, 0x000fe200000006ffULL, 0x3fffffc0ff04c424ULL, 0x000fc400078e00ffULL,
0x0000000083837224ULL, 0x000fe200078e0206ULL, 0x01e60002ff00b388ULL, 0x0005e20000000a00ULL,
0x7fffffc0ff05c424ULL, 0x000fe400078e00ffULL, 0x0000002083007824ULL, 0x000fe400078e00ffULL,
0xff317217ff069424ULL, 0x000fe200078e00ffULL, 0x01e608040700c388ULL, 0x0007e20000008a00ULL,
0x3fffff60ff028424ULL, 0x004fc600078e00ffULL, 0x01e4000607009388ULL, 0x000fe20000004800ULL,
0x7fffff60ff038424ULL, 0x000fca00078e00ffULL, 0x01e6880207008388ULL, 0x000fe20000008a00ULL,
0x0000000400047c10ULL, 0x048fe2000fffe1ffULL, 0x0000000409057824ULL, 0x002fe400078e021eULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000400007c0cULL, 0x000fe2000bf03070ULL,
0x0000000405057824ULL, 0x000fe200078e00ffULL, 0x0000002004047817ULL, 0x000fc80003800000ULL,
0x000000ff04817207ULL, 0x000fe20000000000ULL, 0x00005800a2047a24ULL, 0x000fc600078e02ffULL,
0x000000208100780cULL, 0x000fe20003f05270ULL, 0x0000008504047224ULL, 0x000fd800078e0282ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000000581027217ULL, 0x000fe20007800000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe4000800063fULL,
0x0000000102027824ULL, 0x000fe200078e0a05ULL, 0x00000004ff037819ULL, 0x002fc8000001161cULL,
0x0000000203087810ULL, 0x000fe40007ffe0ffULL, 0x00000003050d7210ULL, 0x000fe40007ffe0ffULL,
0x000000020300720cULL, 0x080fe20003f06070ULL, 0x00000001050f7824ULL, 0x000fe200078e0208ULL,
0x000000020800720cULL, 0x000fe20003f26070ULL, 0x0000000100067824ULL, 0x040fe400078e020dULL,
0x00000001000a7824ULL, 0x000fe400078e020fULL, 0x000000101c057824ULL, 0x000fe200078e00ffULL,
0x0000000406077c12ULL, 0x000fe2000f8e30ffULL, 0x000000010f087824ULL, 0x000fe200078e021cULL,
0x000000040a0b7c12ULL, 0x000fc4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x000fe20000011606ULL,
0x0000000104077824ULL, 0x040fe200078e0207ULL, 0x00005a00ff0a7a19ULL, 0x000fe2000001160aULL,
0x00000001040b7824ULL, 0x000fe200078e020bULL, 0x000000040f0f7819ULL, 0x000fe200000006ffULL,
0x0000008506037224ULL, 0x080fe400078e0207ULL, 0x000000850a067224ULL, 0x000fe200078e020bULL,
0x000000f0050b7812ULL, 0x000fe200078ec0ffULL, 0x0000010003027825ULL, 0x000fe200078e00ffULL,
0xfffffff00f087812ULL, 0x000fc600078ee208ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000b02027212ULL, 0x000fc600078efcffULL, 0x000000010d047824ULL, 0x040fe200078e021cULL,
0x0000000b06067212ULL, 0x000fe200078efcffULL, 0x000000100d0d7824ULL, 0x000fe200078e00ffULL,
0x00005e0002027a10ULL, 0x000fe40007f5e0ffULL, 0x00005e0006067a10ULL, 0x000fe40007f7e0ffULL,
0xfffffff00d047812ULL, 0x000fe200078ee204ULL, 0x00000010080d7824ULL, 0x000fe200078e00ffULL,
0x00005f0003037a10ULL, 0x000fe400017fe4ffULL, 0x00005f0007077a10ULL, 0x000fe20001ffe4ffULL,
0x00000010040b7824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000c101c48ULL, 0x00000000060d7faeULL, 0x0003e2000c901c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00000000001c7919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x000000051c0b7211ULL, 0x002fc800078fe0ffULL,
0x000000020b0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000100027824ULL, 0x000fc800078e020bULL,
0x0000000100057824ULL, 0x000fe200078e020dULL, 0x0000000402037c12ULL, 0x000fe2000f8e30ffULL,
0x000000010d087824ULL, 0x000fe200078e021cULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000405077c12ULL, 0x000fe2000f8e30ffULL, 0x0000000104037824ULL, 0x000fe200078e0203ULL,
0x000000040d0d7819ULL, 0x000fc600000006ffULL, 0x0000000104077824ULL, 0x000fe200078e0207ULL,
0x00005a00ff047a19ULL, 0x000fe20000011605ULL, 0x0000008502027224ULL, 0x080fe200078e0203ULL,
0xfffffff00d087812ULL, 0x000fe200078ee208ULL, 0x000000101c057824ULL, 0x000fe400078e00ffULL,
0x0000008504077224ULL, 0x000fe400078e0207ULL, 0x0000010002027825ULL, 0x000fe200078e00ffULL,
0x000000f0050f7812ULL, 0x000fc600078ec0ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000f02027212ULL, 0x000fc600078efcffULL, 0x000000010b047824ULL, 0x040fe200078e021cULL,
0x0000000f06067212ULL, 0x000fe200078efcffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0x00005e0002027a10ULL, 0x000fe20007f1e0ffULL, 0x00000010080d7824ULL, 0x000fe200078e00ffULL,
0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00b047812ULL, 0x000fe400078ee204ULL,
0x00005f0003037a10ULL, 0x000fe400007fe4ffULL, 0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL,
0x00000010040b7824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000b901c48ULL, 0x00000000060d7faeULL, 0x0003e4000b901c48ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000000000047806ULL, 0x000fe200038e0000ULL,
0x00000004ff077424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400027300ULL, 0x000e7000000e0000ULL, 0x0000000400067309ULL, 0x000ea20000000000ULL,
0x000000030200720cULL, 0x002fe20003f02070ULL, 0x00006600a2027625ULL, 0x000fc800078e0007ULL,
0x000000ffff067224ULL, 0x004fd000078e0a06ULL, 0x01e60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01e60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000008021b7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe40003f05270ULL,
0x0000007f1b1a7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff1b197810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff1a7819ULL, 0x000fe4000001161aULL, 0x00000008ff197819ULL, 0x000fca0000011619ULL,
0x0000e51000008947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe2000001161eULL,
0x000000081e187824ULL, 0x000fe400078e00ffULL, 0x00000003ff097424ULL, 0x000fe200078e00ffULL,
0x01ffffff00007812ULL, 0x000fe200078ec0ffULL, 0xffffffffff1f7424ULL, 0x000fc800078e00ffULL,
0x000000021d207824ULL, 0x000fca00078e0200ULL, 0x0000001a2000720cULL, 0x000fda0003f06070ULL,
0x00000002a2008824ULL, 0x000fe400078e00ffULL, 0x00006800ff038624ULL, 0x000fc800078e00ffULL,
0x0000680000038624ULL, 0x000fca00078e0203ULL, 0x0000000320038210ULL, 0x000fe20007ffe0ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e68c0918ff738cULL, 0x0005e20000000000ULL,
0x0000640003028625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000008021f8981ULL, 0x000ee2000c1e1900ULL, 0x000000011d047810ULL, 0x000fe20007ffe0ffULL,
0x0000008015157824ULL, 0x000fe200078e00ffULL, 0x00000001ff177819ULL, 0x000fe2000001161eULL,
0x00000100ff077424ULL, 0x000fe200078e00ffULL, 0x000000190400720cULL, 0x000fe20003f06070ULL,
0x01e6880018ff7f8cULL, 0x0003e2000c80043fULL, 0x000000011e147812ULL, 0x000fe200078ec0ffULL,
0x0000002017167824ULL, 0x000fc800078e00ffULL, 0x000001001d047824ULL, 0x000fca00078e0216ULL,
0x00000060152e7812ULL, 0x000fe200078ef804ULL, 0x000059001f007a24ULL, 0x008fc800078e02ffULL,
0x0000008000007824ULL, 0x000fc800078e00ffULL, 0x0000620000027625ULL, 0x000fe200078e0007ULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff137819ULL, 0x002fe2000001161cULL,
0x0000000217227824ULL, 0x000fe200078e0214ULL, 0x000000041b007217ULL, 0x000fe40007800000ULL,
0x0000000413097810ULL, 0x044fe40007ffe0ffULL, 0x0000000c13117810ULL, 0x040fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a04ULL, 0x00000008130b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109047824ULL, 0x100fe200078e021cULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x0000000809237824ULL, 0x000fe200078e00ffULL, 0x0000001c11077210ULL, 0x040fe20007ffe0ffULL,
0x0000000811087824ULL, 0x000fe200078e00ffULL, 0x0000002000007817ULL, 0x000fe20003800000ULL,
0x000000010b067824ULL, 0x000fe200078e021cULL, 0xfffffff823237812ULL, 0x000fe200078ee204ULL,
0x000000080b257824ULL, 0x000fe200078e00ffULL, 0xfffffff808277812ULL, 0x000fe200078ee207ULL,
0x0000008014047824ULL, 0x000fe200078e0205ULL, 0x000000000900720cULL, 0x080fe20003f86070ULL,
0x000000012e077824ULL, 0x040fe200078e0213ULL, 0xfffffff825257812ULL, 0x000fe200078ee206ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x00000014132b7810ULL, 0x040fe20007ffe0ffULL,
0x000000012e097824ULL, 0x000fe200078e0209ULL, 0x0000001013217810ULL, 0x000fe20007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000000b00720cULL, 0x000fc40003f66070ULL,
0x000000001100720cULL, 0x000fe20003f46070ULL, 0x0000010009087825ULL, 0x000fe200078e0004ULL,
0x00000006020c7210ULL, 0x040fe40007f1e0ffULL, 0x000000001300720cULL, 0x000fe20003fa6070ULL,
0x000000012b0d7824ULL, 0x140fe200078e021cULL, 0x00000008020e7210ULL, 0x000fe20007f3e0ffULL,
0x000000082b107824ULL, 0x000fe200078e00ffULL, 0x0001600022227811ULL, 0x000fe200078e68ffULL,
0x00000001210a7824ULL, 0x000fe200078e021cULL, 0x00000009030f7210ULL, 0x000fe20000ffe4ffULL,
0x0000000821297824ULL, 0x000fe200078e00ffULL, 0xfffffff8102d7812ULL, 0x000fe200078ee20dULL,
0x00000001030d7824ULL, 0x000fe200000e0607ULL, 0x000000002100720cULL, 0x000fe20003f26070ULL,
0x000000012e077824ULL, 0x040fe200078e020bULL, 0xfffffff829297812ULL, 0x000fe200078ee20aULL,
0x000000012e097824ULL, 0x000fe200078e0211ULL, 0x0000001c13317810ULL, 0x000fe20007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x0000002223237211ULL, 0x000fc400078e20ffULL,
0x0000002229297211ULL, 0x000fe200078e20ffULL, 0x00000001130a7824ULL, 0x000fe200078e021cULL,
0x0000000602107210ULL, 0x000fe20007f1e0ffULL, 0x0000010009087825ULL, 0x000fc800078e0004ULL,
0x000000012e0b7824ULL, 0x000fe200078e0221ULL, 0x000000070a217812ULL, 0x000fe200078ec0ffULL,
0x0000000103117824ULL, 0x000fe200000e0607ULL, 0x0000000802087210ULL, 0x000fe20007fde0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0004ULL, 0x000000002b00720cULL, 0x000fe40003f06070ULL,
0x0ffffff821217812ULL, 0x000fe200078ef81cULL, 0x000000012e077824ULL, 0x000fe200078e022bULL,
0x00000018132b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103097824ULL, 0x000fe200030e0609ULL,
0x0000000a020a7210ULL, 0x000fe20007fde0ffULL, 0x0000010007067825ULL, 0x000fc800078e0004ULL,
0x00000001030b7824ULL, 0x000fe200030e060bULL, 0x0000000602127210ULL, 0x000fe20007fde0ffULL,
0x000000012e2f7824ULL, 0x000fe400078e022bULL, 0x0000001021217824ULL, 0x000fe400078e0222ULL,
0x0000000103137824ULL, 0x000fe400030e0607ULL, 0x000001002f067825ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c217faeULL, 0x0003e2000e901c48ULL,
0x000000002b00720cULL, 0x000fc40003fa6070ULL, 0x000000012e337824ULL, 0x000fe200078e0231ULL,
0x000000000e237faeULL, 0x0005e2000e101c48ULL, 0x000000003100720cULL, 0x000fe20003f86070ULL,
0x000000012b007824ULL, 0x000fe200078e021cULL, 0x0000000602067210ULL, 0x000fe20007fde0ffULL,
0x0000010033047825ULL, 0x000fc800078e0004ULL, 0x000000082b0d7824ULL, 0x002fe400078e00ffULL,
0x00000001310c7824ULL, 0x040fe400078e021cULL, 0x00000008310f7824ULL, 0x004fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee200ULL, 0x0000000103077824ULL, 0x000fe200030e0607ULL,
0x0000000402027210ULL, 0x000fe20007fde0ffULL, 0x0000001025257824ULL, 0x000fe200078e0222ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee20cULL, 0x0000001027277824ULL, 0x000fc400078e0222ULL,
0x000000102d2d7824ULL, 0x100fe200078e0222ULL, 0x0000000010257faeULL, 0x0003e2000d901c48ULL,
0x000000100d0d7824ULL, 0x100fe400078e0222ULL, 0x000000100f0f7824ULL, 0x000fe200078e0222ULL,
0x0000000008277faeULL, 0x0003e2000d101c48ULL, 0x0000000103037824ULL, 0x000fc600030e0605ULL,
0x000000000a297faeULL, 0x0003e8000c901c48ULL, 0x00000000122d7faeULL, 0x0003e8000c101c48ULL,
0x00000000060d7faeULL, 0x0003e8000e901c48ULL, 0x00000000020f7faeULL, 0x0003e2000e101c48ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x000000041c097811ULL, 0x046fe400078fe8ffULL,
0x000000081c0b7811ULL, 0x000fc400078fe8ffULL, 0x000000181c137811ULL, 0x040fe200078fe8ffULL,
0x0000000109007824ULL, 0x140fe200078e021cULL, 0x0000000c1c0d7811ULL, 0x040fe200078fe8ffULL,
0x0000000809077824ULL, 0x000fe200078e00ffULL, 0x000000141c117811ULL, 0x040fe200078fe8ffULL,
0x000000010b047824ULL, 0x040fe400078e021cULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff807227812ULL, 0x000fe200078ee200ULL, 0x0000000113077824ULL, 0x040fe400078e021cULL,
0x00000008132c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f247812ULL, 0x000fe200078ee204ULL,
0x000000010d007824ULL, 0x140fe200078e021cULL, 0x000000101c0f7811ULL, 0x000fe200078fe8ffULL,
0x000000080d217824ULL, 0x000fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee207ULL,
0x0000000111067824ULL, 0x000fe200078e021cULL, 0x0000007005077812ULL, 0x000fe200078ec0ffULL,
0x000000080f237824ULL, 0x000fe200078e00ffULL, 0xfffffff821267812ULL, 0x000fe200078ee200ULL,
0x0000000811257824ULL, 0x000fe200078e00ffULL, 0x0000001c0f047210ULL, 0x080fe20007ffe0ffULL,
0x0000008014127824ULL, 0x000fe200078e0207ULL, 0x0000001c1c007211ULL, 0x000fe200078fe8ffULL,
0x000000012e217824ULL, 0x000fe200078e0213ULL, 0x0000001c1c057811ULL, 0x000fe200078fe8ffULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0xfffffff823287812ULL, 0x000fe200078ee204ULL,
0x0000000217047824ULL, 0x000fe200078e0214ULL, 0xfffffff8252a7812ULL, 0x000fe200078ee206ULL,
0x0000000805257824ULL, 0x040fe200078e00ffULL, 0x0000000700077812ULL, 0x000fe200078ec0ffULL,
0x0000000105007824ULL, 0x000fe200078e021cULL, 0x0000000f2e0f7210ULL, 0x040fe20007ffe0ffULL,
0x000000012e237824ULL, 0x000fe200078e0205ULL, 0x0000002e1c057211ULL, 0x000fe200078fe8ffULL,
0x000000012e097824ULL, 0x000fe200078e0209ULL, 0x00016000042f7811ULL, 0x000fe200078e68ffULL,
0x000000012e0b7824ULL, 0x000fc400078e020bULL, 0x000000012e0d7824ULL, 0x000fe200078e020dULL,
0x0000002f28297211ULL, 0x000fe200078e20ffULL, 0x000000012e117824ULL, 0x000fe200078e0211ULL,
0xfffffff8252e7812ULL, 0x000fe200078ee200ULL, 0x0000010005047825ULL, 0x000fe200078e0012ULL,
0x0ffffff807007812ULL, 0x000fc600078ef81cULL, 0x0000010009067825ULL, 0x000fe200078e0012ULL,
0x0000000402047210ULL, 0x000fc60007f1e0ffULL, 0x000001000b087825ULL, 0x000fe200078e0012ULL,
0x0000000602067210ULL, 0x000fc60007f3e0ffULL, 0x000001000d0a7825ULL, 0x000fe200078e0012ULL,
0x0000000802087210ULL, 0x000fc60007f5e0ffULL, 0x000001000f0c7825ULL, 0x000fe200078e0012ULL,
0x0000000a020a7210ULL, 0x000fc60007f7e0ffULL, 0x00000100110e7825ULL, 0x000fc800078e0012ULL,
0x0000010021107825ULL, 0x000fc800078e0012ULL, 0x0000010023127825ULL, 0x000fc800078e0012ULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000000c020c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000103077824ULL, 0x040fe200008e0607ULL, 0x0000000e020e7210ULL, 0x000fe20007f3e0ffULL,
0x0000001000217824ULL, 0x000fe400078e022fULL, 0x0000000103097824ULL, 0x000fe200010e0609ULL,
0x0000001002107210ULL, 0x000fe20007f5e0ffULL, 0x0000001022237824ULL, 0x100fe200078e022fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004217faeULL, 0x0003e2000b901c48ULL,
0x0000001024257824ULL, 0x000fc400078e022fULL, 0x00000001030b7824ULL, 0x040fe200018e060bULL,
0x0000001202027210ULL, 0x000fe20007f7e0ffULL, 0x0000001026277824ULL, 0x000fe200078e022fULL,
0x0000000006237faeULL, 0x0003e2000b901c48ULL, 0x00000001030d7824ULL, 0x040fe400000e060dULL,
0x000000102a2b7824ULL, 0x000fe200078e022fULL, 0x0000000008257faeULL, 0x0003e2000b901c48ULL,
0x00000001030f7824ULL, 0x040fe400008e060fULL, 0x000000102c2d7824ULL, 0x000fe200078e022fULL,
0x000000000a277faeULL, 0x0003e2000b901c48ULL, 0x0000000103117824ULL, 0x040fe200010e0611ULL,
0x0000001303037210ULL, 0x000fe20001ffe4ffULL, 0x000000102e2f7824ULL, 0x000fe200078e022fULL,
0x000000000c297faeULL, 0x0003e8000b901c48ULL, 0x000000000e2b7faeULL, 0x0003e8000b901c48ULL,
0x00000000102d7faeULL, 0x0003e8000b901c48ULL, 0x00000000022f7faeULL, 0x0003e4000b901c48ULL,
0x000000191d00720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff217424ULL, 0x002fe200078e00ffULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x00007ef000000947ULL, 0x000fea0003800000ULL, 0x00000002a2137824ULL, 0x000fe400078e00ffULL,
0x00006800ff007624ULL, 0x000fc400078e00ffULL, 0xff317217ff217424ULL, 0x000fe400078e00ffULL,
0x000000ffff637224ULL, 0x000fe400078e00ffULL, 0x0000680013137624ULL, 0x000fc400078e0200ULL,
0x000000101e007824ULL, 0x000fe200078e00ffULL, 0x000000011d027810ULL, 0x000fe20007ffe0ffULL,
0x000059001f1f7a24ULL, 0x010fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe000007812ULL, 0x000fe200078ec0ffULL, 0x00000100ff037424ULL, 0x000fe200078e00ffULL,
0x000000190200720cULL, 0x000fe20003f06070ULL, 0x000000801f027824ULL, 0x000fe400078e00ffULL,
0x000001001d007824ULL, 0x000fe400078e0200ULL, 0x0000620002027625ULL, 0x000fc600078e0003ULL,
0x0000004000057810ULL, 0x020fc80007ffe0ffULL, 0x0000006005007812ULL, 0x000fc800078ec0ffULL,
0x00000000156f7210ULL, 0x000fe20007ffe0ffULL, 0x0000068000008947ULL, 0x000fea0003800000ULL,
0x000000051b007217ULL, 0x000fe20007800000ULL, 0x000000101c067824ULL, 0x000fe200078e00ffULL,
0x00000003ff6b7819ULL, 0x100fe2000001161cULL, 0x000000801e047824ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fe200078e0a05ULL, 0x000000046b097810ULL, 0x040fe20007ffe0ffULL,
0x000020001e057824ULL, 0x000fe200078e00ffULL, 0x0000007006077812ULL, 0x000fe400078ec0ffULL,
0x000000086b0b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008090c7824ULL, 0x000fe200078e00ffULL,
0x0000200005067812ULL, 0x000fe200078ec0ffULL, 0x0000000109057824ULL, 0x000fe200078e021cULL,
0x0000000c6b1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080b127824ULL, 0x000fe200078e00ffULL,
0x0000008007047812ULL, 0x000fe200078ef804ULL, 0x000000010b077824ULL, 0x100fe200078e021cULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL, 0x000000011f057824ULL, 0x000fe200078e021cULL,
0x000000106b6d7810ULL, 0x000fe20007ffe0ffULL, 0x0000400017177824ULL, 0x000fe200078e0206ULL,
0x000000031f227819ULL, 0x000fc400000006ffULL, 0xfffffff812127812ULL, 0x000fe200078ee207ULL,
0x000000016d067824ULL, 0x040fe200078e021cULL, 0xfffffff822227812ULL, 0x000fe200078ee205ULL,
0x000000086d257824ULL, 0x000fe200078e00ffULL, 0x000000146b717810ULL, 0x040fe20007ffe0ffULL,
0x000000016b077824ULL, 0x000fe200078e026fULL, 0x0000002000007817ULL, 0x000fe20003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0xfffffff8256c7812ULL, 0x000fe200078ee206ULL,
0x0000000171087824ULL, 0x000fe200078e021cULL, 0x000000000900720cULL, 0x080fe20003f66070ULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000000b00720cULL, 0x000fc40003f06070ULL,
0x000000001f00720cULL, 0x000fe20003f26070ULL, 0x0000000871277824ULL, 0x000fe200078e00ffULL,
0x0000000602247210ULL, 0x000fe20007f5e0ffULL, 0x0000000109097824ULL, 0x100fe200078e026fULL,
0x000000006b00720cULL, 0x000fe20003f86070ULL, 0x000000010b0b7824ULL, 0x000fe200078e026fULL,
0xfffffff8276e7812ULL, 0x000fe200078ee208ULL, 0x000000016b087824ULL, 0x000fe200078e021cULL,
0x0000000703257210ULL, 0x000fe200017fe4ffULL, 0x0000010009067825ULL, 0x000fe200078e0004ULL,
0x0001700017177810ULL, 0x000fc40007ffe0ffULL, 0x0000000708277812ULL, 0x000fe200078ec0ffULL,
0x000001000b087825ULL, 0x000fe200078e0004ULL, 0x0000000602267210ULL, 0x040fe40007f5e0ffULL,
0x0ffffff827067812ULL, 0x000fe200078ef81cULL, 0x000000011f1f7824ULL, 0x000fe200078e026fULL,
0x0000000802687210ULL, 0x000fe20007fbe0ffULL, 0x0000000103277824ULL, 0x000fe200010e0607ULL,
0x000000186b737810ULL, 0x000fe20007ffe0ffULL, 0x000001001f0a7825ULL, 0x000fe200078e0004ULL,
0x0000001c6b757810ULL, 0x000fc40007ffe0ffULL, 0x000000006d00720cULL, 0x040fe20003f46070ULL,
0x000000016d077824ULL, 0x000fe200078e026fULL, 0x0000000a020a7210ULL, 0x000fe20007fde0ffULL,
0x0000000103697824ULL, 0x000fe200028e0609ULL, 0x000000007100720cULL, 0x000fe20003fa6070ULL,
0x0000001006097824ULL, 0x000fe400078e0217ULL, 0x0000010007067825ULL, 0x000fc600078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024097faeULL, 0x0003e2000e101c48ULL,
0x00000001716b7824ULL, 0x000fe200078e026fULL, 0x000000007300720cULL, 0x000fe20003f86070ULL,
0x00000001030b7824ULL, 0x000fe200030e060bULL, 0x00000006026a7210ULL, 0x000fe20007fde0ffULL,
0x000000100c1f7824ULL, 0x000fe400078e0217ULL, 0x00000001736d7824ULL, 0x000fe400078e026fULL,
0x00000001750c7824ULL, 0x040fe200078e021cULL, 0x00000000261f7faeULL, 0x0005e2000d901c48ULL,
0x000000007500720cULL, 0x000fe20003f66070ULL, 0x000001006b087825ULL, 0x002fe200078e0004ULL,
0x0000001c73007210ULL, 0x000fc60007ffe0ffULL, 0x00000001036b7824ULL, 0x000fe200030e0607ULL,
0x0000000802087210ULL, 0x000fe20007fde0ffULL, 0x000001006d067825ULL, 0x000fc800078e0004ULL,
0x00000001751f7824ULL, 0x004fe400078e026fULL, 0x0000000103097824ULL, 0x000fe200030e0609ULL,
0x0000000602067210ULL, 0x000fe20007fde0ffULL, 0x0000000873737824ULL, 0x000fe400078e00ffULL,
0x000001001f047825ULL, 0x000fc600078e0004ULL, 0xfffffff873007812ULL, 0x000fe200078ee200ULL,
0x0000000875757824ULL, 0x000fe400078e00ffULL, 0x0000000103077824ULL, 0x000fe200030e0607ULL,
0x0000000402027210ULL, 0x000fe20007fde0ffULL, 0x00000010121f7824ULL, 0x100fe200078e0217ULL,
0xfffffff8750c7812ULL, 0x000fe200078ee20cULL, 0x0000001022257824ULL, 0x100fe400078e0217ULL,
0x000000106c277824ULL, 0x100fe200078e0217ULL, 0x00000000681f7faeULL, 0x0003e2000c101c48ULL,
0x000000106e6d7824ULL, 0x000fc400078e0217ULL, 0x00000010006f7824ULL, 0x000fe200078e0217ULL,
0x000000170c177211ULL, 0x000fe200078e20ffULL, 0x0000000103037824ULL, 0x000fe200030e0605ULL,
0x000000000a257faeULL, 0x0003e8000c901c48ULL, 0x000000006a277faeULL, 0x0003e8000d101c48ULL,
0x00000000086d7faeULL, 0x0003e8000e901c48ULL, 0x00000000066f7faeULL, 0x0003e8000e101c48ULL,
0x0000000002177faeULL, 0x0003e2000d901c48ULL, 0x000005b000007947ULL, 0x000fea0003800000ULL,
0x000000101c007824ULL, 0x040fe200078e00ffULL, 0x000000041c077811ULL, 0x000fe200078fe8ffULL,
0x000000801e6b7824ULL, 0x000fe200078e00ffULL, 0x000000101c257811ULL, 0x000fe200078fe8ffULL,
0x000020001e047824ULL, 0x000fe200078e00ffULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x00000008076d7824ULL, 0x000fe200078e00ffULL, 0x000000081c097811ULL, 0x000fe200078fe8ffULL,
0x0000000825757824ULL, 0x000fe200078e00ffULL, 0x00000080006a7812ULL, 0x000fe200078ef86bULL,
0x0000000107007824ULL, 0x100fe200078e021cULL, 0x0000200004047812ULL, 0x000fe200078ec0ffULL,
0x0000000109057824ULL, 0x040fe200078e021cULL, 0x0000000c1c0b7811ULL, 0x040fe200078fe8ffULL,
0x0000000809087824ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee200ULL,
0x0000000125007824ULL, 0x000fe200078e021cULL, 0x000000141c277811ULL, 0x000fe200078fe8ffULL,
0x0000400017047824ULL, 0x000fe200078e0204ULL, 0xfffffff808717812ULL, 0x000fe200078ee205ULL,
0x000000010b067824ULL, 0x000fe200078e021cULL, 0xfffffff875757812ULL, 0x000fe200078ee200ULL,
0x0000000127057824ULL, 0x140fe200078e021cULL, 0x0000001c1c007211ULL, 0x040fe200078fe8ffULL,
0x0000000827087824ULL, 0x000fe200078e00ffULL, 0x0000001c1c177811ULL, 0x040fe200078fe8ffULL,
0x000000ffff6b7224ULL, 0x000fe200078e00ffULL, 0x000000030b737819ULL, 0x000fe200000006ffULL,
0x0000000107077824ULL, 0x000fe200078e026fULL, 0x000000181c697811ULL, 0x000fe200078fe8ffULL,
0x00000008177b7824ULL, 0x040fe200078e00ffULL, 0x00000007001f7812ULL, 0x000fe200078ec0ffULL,
0x0000000117007824ULL, 0x000fe200078e021cULL, 0xfffffff873737812ULL, 0x000fe200078ee206ULL,
0x0000000169067824ULL, 0x040fe200078e021cULL, 0xfffffff808777812ULL, 0x000fe200078ee205ULL,
0x0000000869797824ULL, 0x000fe200078e00ffULL, 0x0000006f1c057211ULL, 0x000fe200078fe8ffULL,
0x0000000109097824ULL, 0x100fe200078e026fULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee200ULL,
0x000000010b0b7824ULL, 0x000fe200078e026fULL, 0x0001700004007810ULL, 0x000fe20007ffe0ffULL,
0x0000010005047825ULL, 0x000fe200078e006aULL, 0xfffffff879797812ULL, 0x000fc400078ee206ULL,
0x0000006f27277210ULL, 0x000fe20007ffe0ffULL, 0x0000010007067825ULL, 0x000fe200078e006aULL,
0x0000000402047210ULL, 0x040fe40007f1e0ffULL, 0x0ffffff81f1f7812ULL, 0x000fe200078ef81cULL,
0x0000000125257824ULL, 0x000fe200078e026fULL, 0x0000000602067210ULL, 0x000fe20007f3e0ffULL,
0x0000010009087825ULL, 0x000fc800078e006aULL, 0x000001000b0a7825ULL, 0x000fe200078e006aULL,
0x0000000802087210ULL, 0x000fc60007f5e0ffULL, 0x0000000169697824ULL, 0x100fe200078e026fULL,
0x0000000a020a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000117177824ULL, 0x000fe400078e026fULL,
0x0000010025247825ULL, 0x000fc800078e006aULL, 0x0000010027267825ULL, 0x000fc800078e006aULL,
0x0000010069687825ULL, 0x000fc800078e006aULL, 0x00000100176a7825ULL, 0x000fc800078e006aULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000002402247210ULL, 0x040fe20007f1e0ffULL,
0x0000000103077824ULL, 0x000fe200008e0607ULL, 0x0000002602267210ULL, 0x040fe20007f3e0ffULL,
0x000000101f177824ULL, 0x100fe400078e0200ULL, 0x0000000103097824ULL, 0x000fe200010e0609ULL,
0x0000006802687210ULL, 0x040fe20007f5e0ffULL, 0x000000106d1f7824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c48ULL,
0x00000001030b7824ULL, 0x000fe200018e060bULL, 0x0000006a02027210ULL, 0x000fe20007f7e0ffULL,
0x00000010716d7824ULL, 0x100fe200078e0200ULL, 0x00000000061f7faeULL, 0x0003e2000b901c48ULL,
0x00000010736f7824ULL, 0x100fe200078e0200ULL, 0x0000000077737211ULL, 0x000fe200078e20ffULL,
0x0000001075717824ULL, 0x000fe200078e0200ULL, 0x00000000086d7faeULL, 0x0003e2000b901c48ULL,
0x0000000103257824ULL, 0x000fc400000e0625ULL, 0x0000000103277824ULL, 0x000fe200008e0627ULL,
0x000000000a6f7faeULL, 0x0003e2000b901c48ULL, 0x0000001079757824ULL, 0x100fe400078e0200ULL,
0x0000000103697824ULL, 0x000fe200010e0669ULL, 0x0000000024717faeULL, 0x0003e2000b901c48ULL,
0x000000107b777824ULL, 0x000fe400078e0200ULL, 0x0000000103037824ULL, 0x000fe200018e066bULL,
0x0000000026737faeULL, 0x0003e8000b901c48ULL, 0x0000000068757faeULL, 0x0003e8000b901c48ULL,
0x0000000002777faeULL, 0x0003e4000b901c48ULL, 0x0000000120027812ULL, 0x002fe200078ec0ffULL,
0xffffffffff1f7424ULL, 0x000fe200078e00ffULL, 0x0000030000007a02ULL, 0x000fe20000000f00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000010200780cULL, 0x000fc40003f05070ULL,
0xffffffff00007811ULL, 0x000fc800078e08ffULL, 0x0000000100037807ULL, 0x000fca0004000000ULL,
0x0000000103207824ULL, 0x000fca00078e0220ULL, 0x0000001a2000720cULL, 0x000fda0003f06070ULL,
0x0000000113028824ULL, 0x000fe400078e0220ULL, 0x00000004ff038424ULL, 0x000fc800078e00ffULL,
0x0000640002028625ULL, 0x000fca00078e0003ULL, 0x00000008021f8981ULL, 0x000322000c1e1900ULL,
0xffffffe018007812ULL, 0x040fe400078ec0ffULL, 0x0000001018057812ULL, 0x040fe400078ec0ffULL,
0x0000000818047812ULL, 0x000fc800078ec0ffULL, 0x0000000004007210ULL, 0x000fe20007ffe005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6080000067f8cULL, 0x0022a4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x01e60c0000057984ULL, 0x000ee40000000800ULL,
0x8000000005ff7812ULL, 0x00cfe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402097210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000904047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e60c0000057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x004fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101c127824ULL, 0x000fe200078e00ffULL,
0x00000001ff807819ULL, 0x000fe2000001161cULL, 0x000000201e007824ULL, 0x002fc600078e00ffULL,
0x0000007012127812ULL, 0x000fe400078ec0ffULL, 0xffffff8000037812ULL, 0x000fe400078ec0ffULL,
0x0000000c80807812ULL, 0x000fc800078ec0ffULL, 0x0000000380037210ULL, 0x000fca0007ffe012ULL,
0x01e0000003007984ULL, 0x000e680000000800ULL, 0x01e2000003027984ULL, 0x0004e20000000800ULL,
0x000000210000720bULL, 0x002fe20003f1d000ULL, 0x000169e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x004fc800000e0100ULL, 0x000000ff0300720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff177224ULL, 0x000fd400078e0021ULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x00000002ff057819ULL, 0x000fe4000001161eULL, 0x000000210000720bULL, 0x000fe40003f54000ULL,
0x0000001e0500720cULL, 0x000fe20003f25270ULL, 0x000169a27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000047806ULL, 0x000fc400010e0100ULL, 0x000000801e059824ULL, 0x000fe200078e0212ULL,
0x0000002100177209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000180069824ULL, 0x000fca00078e0205ULL, 0x01e4001706009388ULL, 0x0003e20000000800ULL,
0x000000ff0400720cULL, 0x000fda0003f25270ULL, 0x000005e000009947ULL, 0x000fea0003800000ULL,
0x0000002117057221ULL, 0x002fe20000010100ULL, 0x000000ff04ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b05057820ULL, 0x000fcc0000410000ULL,
0x0000000500057308ULL, 0x000e640000000800ULL, 0x0000000523237220ULL, 0x002fe40000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x000fe2000001161cULL,
0x000168f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2405247589ULL, 0x0002a400000e0000ULL,
0x0000002464647220ULL, 0x084fe40000410000ULL, 0x0000002465657220ULL, 0x080fe40000410000ULL,
0x0000002428287220ULL, 0x080fe40000410000ULL, 0x0000002429297220ULL, 0x000fc40000410000ULL,
0x000000242c2c7220ULL, 0x080fe40000410000ULL, 0x000000242d2d7220ULL, 0x080fe40000410000ULL,
0x0000002430307220ULL, 0x080fe40000410000ULL, 0x0000002431317220ULL, 0x080fe40000410000ULL,
0x0000002434347220ULL, 0x080fe40000410000ULL, 0x0000002435357220ULL, 0x000fc40000410000ULL,
0x0000002438387220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x080fe40000410000ULL, 0x0000002441417220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0004ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x000000081c247811ULL, 0x000fe200078ff0ffULL, 0x000167e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2405247589ULL, 0x00046400000e0000ULL, 0x0000002466667220ULL, 0x086fe40000410000ULL,
0x0000002467677220ULL, 0x080fe40000410000ULL, 0x000000242a2a7220ULL, 0x080fe40000410000ULL,
0x000000242b2b7220ULL, 0x080fe40000410000ULL, 0x000000242e2e7220ULL, 0x080fe40000410000ULL,
0x000000242f2f7220ULL, 0x000fc40000410000ULL, 0x0000002432327220ULL, 0x080fe40000410000ULL,
0x0000002433337220ULL, 0x080fe40000410000ULL, 0x0000002436367220ULL, 0x080fe40000410000ULL,
0x0000002437377220ULL, 0x080fe40000410000ULL, 0x000000243a3a7220ULL, 0x080fe40000410000ULL,
0x000000243b3b7220ULL, 0x000fc40000410000ULL, 0x000000243e3e7220ULL, 0x080fe40000410000ULL,
0x000000243f3f7220ULL, 0x080fe40000410000ULL, 0x0000002442427220ULL, 0x080fe40000410000ULL,
0x0000002443437220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000004ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x000000101c247811ULL, 0x000fe200078ff0ffULL,
0x000166d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2405247589ULL, 0x00046400000e0000ULL,
0x0000002444447220ULL, 0x086fe40000410000ULL, 0x0000002445457220ULL, 0x080fe40000410000ULL,
0x0000002448487220ULL, 0x080fe40000410000ULL, 0x0000002449497220ULL, 0x080fe40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000244d4d7220ULL, 0x000fc40000410000ULL,
0x0000002450507220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x080fe40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002459597220ULL, 0x000fc40000410000ULL,
0x000000245c5c7220ULL, 0x080fe40000410000ULL, 0x000000245d5d7220ULL, 0x080fe40000410000ULL,
0x0000002460607220ULL, 0x080fe40000410000ULL, 0x0000002461617220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000004ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x000000181c247811ULL, 0x000fe200078ff0ffULL,
0x000165d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2405247589ULL, 0x00046400000e0000ULL,
0x0000002446467220ULL, 0x086fe40000410000ULL, 0x0000002447477220ULL, 0x080fe40000410000ULL,
0x000000244a4a7220ULL, 0x080fe40000410000ULL, 0x000000244b4b7220ULL, 0x080fe40000410000ULL,
0x000000244e4e7220ULL, 0x080fe40000410000ULL, 0x000000244f4f7220ULL, 0x000fc40000410000ULL,
0x0000002452527220ULL, 0x080fe40000410000ULL, 0x0000002453537220ULL, 0x080fe40000410000ULL,
0x0000002456567220ULL, 0x080fe40000410000ULL, 0x0000002457577220ULL, 0x080fe40000410000ULL,
0x000000245a5a7220ULL, 0x080fe40000410000ULL, 0x000000245b5b7220ULL, 0x000fc40000410000ULL,
0x000000245e5e7220ULL, 0x080fe40000410000ULL, 0x000000245f5f7220ULL, 0x080fe40000410000ULL,
0x0000002462627220ULL, 0x080fe40000410000ULL, 0x0000002463637220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000000403ff7212ULL, 0x000fda00078230ffULL,
0x8000001700001221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b00001820ULL, 0x000fc80000410000ULL, 0x0000000000111308ULL, 0x000e640000000800ULL,
0x0000001102021220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002302237221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000011ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x000fe4000001161cULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000164227f007947ULL, 0x000fea000b800000ULL,
0x00001f0300107589ULL, 0x0002a400000e0000ULL, 0x0000000803247810ULL, 0x000fe20007ffe0ffULL,
0x000164727f007947ULL, 0x000fea000b800000ULL, 0x0000001003057810ULL, 0x000fe20007ffe0ffULL,
0x00001f24000f7589ULL, 0x00066800000e0000ULL, 0x00001f05000e7589ULL, 0x0006a400000e0000ULL,
0x0000001803247810ULL, 0x008fe20007ffe0ffULL, 0x000165027f007947ULL, 0x000fea000b800000ULL,
0x00001f24000d7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021e227824ULL, 0x000fe200078e00ffULL, 0x000000081c037812ULL, 0x002fe200078ec0ffULL,
0x000020001e217824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000002c000007945ULL, 0x000fe20003800000ULL, 0x0000000422057812ULL, 0x000fc400078ec0ffULL,
0x0000000703037812ULL, 0x000fe400078ef81cULL, 0x000000051c007211ULL, 0x048fe400078fe0ffULL,
0x00000010037d7812ULL, 0x040fe200078efcffULL, 0x0000000803077824ULL, 0x040fe200078e00ffULL,
0x000000031c027211ULL, 0x000fe200078fe0ffULL, 0x00000001030c7824ULL, 0x040fe200078e0200ULL,
0x0000000303277819ULL, 0x000fe200000006ffULL, 0x00000001000b7824ULL, 0x000fe200078e027dULL,
0x00000002020a7810ULL, 0x000fe20007ffe0ffULL, 0x000004001e007824ULL, 0x000fe200078e00ffULL,
0xfffffff8070c7812ULL, 0x000fe200078ee20cULL, 0x000000087d047824ULL, 0x000fe200078e00ffULL,
0xfffffff8070a7812ULL, 0x000fe200078ee20aULL, 0x0000000803097824ULL, 0x040fe200078e00ffULL,
0xfffff00000007812ULL, 0x000fe200078ec0ffULL, 0x0000000803257824ULL, 0x000fe200078e00ffULL,
0xffffc00021077812ULL, 0x000fc400078ec0ffULL, 0xfffffff8040b7812ULL, 0x000fe400078ee20bULL,
0x00012000007c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000402087810ULL, 0x000fe40007ffe0ffULL,
0xfffffff809097812ULL, 0x000fe200078ee202ULL, 0x000000100c787824ULL, 0x000fe200078e027cULL,
0x0000000602047810ULL, 0x000fe20007ffe0ffULL, 0x0000200014027824ULL, 0x000fe200078e0207ULL,
0xfffffff825087812ULL, 0x000fe200078ee208ULL, 0x000000100b247824ULL, 0x000fe200078e027cULL,
0xfffffff827077812ULL, 0x000fe200078ee204ULL, 0x000000007878783bULL, 0x000e620000000200ULL,
0x0001600002027810ULL, 0x000fc60007ffe0ffULL, 0x000000002424783bULL, 0x000ee40000000200ULL,
0x0000001009747824ULL, 0x100fe400078e0202ULL, 0x000000100a707824ULL, 0x100fe400078e0202ULL,
0x00000010086c7824ULL, 0x000fe200078e0202ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001078787231ULL, 0x086fe400003400ffULL, 0x000000107a7a7231ULL, 0x000fe400003400ffULL,
0x0000000f79797231ULL, 0x000fc400003400ffULL, 0x0000000f7b7b7231ULL, 0x000fe400003400ffULL,
0x0000000e24247231ULL, 0x088fe400003400ffULL, 0x0000000e26267231ULL, 0x000fe400003400ffULL,
0x0000000d25257231ULL, 0x080fe400003400ffULL, 0x0000000d27277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000006c6c783bULL, 0x000ee20000004200ULL,
0x0000001007687824ULL, 0x000fe200078e0202ULL, 0x0000000205057812ULL, 0x000fe200078efcffULL,
0x000000087d027824ULL, 0x040fe200078e00ffULL, 0x000000007474783bULL, 0x000fe20000004200ULL,
0x00000001ff7e7819ULL, 0x000fe2000001161eULL, 0x0000037000007945ULL, 0x000fe20003800000ULL,
0x000000051c007211ULL, 0x040fe200078fe0ffULL, 0x000000006868783bULL, 0x000ea60000004200ULL,
0x000000007d057210ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x0000000103067824ULL, 0x000fe200078e0200ULL, 0x0000007d1c007211ULL, 0x000fc400078fe0ffULL,
0xfffffff802057812ULL, 0x000fe400078ee205ULL, 0x0000000400027810ULL, 0x000fe20007ffe0ffULL,
0x0000006c7834723cULL, 0x08af700000041834ULL, 0x0000006c2454723cULL, 0x000b6e0000041854ULL,
0x00000008036d7824ULL, 0x020fe200078e00ffULL, 0x00000068783c723cULL, 0x004f62000004183cULL,
0x000000087d037824ULL, 0x000fc400078e00ffULL, 0x000000087d6c7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d067812ULL, 0x000fe400078ee206ULL, 0xfffffff803047812ULL, 0x000fe400078ee200ULL,
0x00000068245c723cULL, 0x000b62000004185cULL, 0x0000000200037810ULL, 0x040fe40007ffe0ffULL,
0x0000000600007810ULL, 0x000fe40007ffe0ffULL, 0xfffffff86c037812ULL, 0x000fc400078ee203ULL,
0x000000087d697824ULL, 0x060fe200078e00ffULL, 0x000000747864723cULL, 0x040f620000041864ULL,
0x000000027e687824ULL, 0x000fe400078e0214ULL, 0x000000087d7d7824ULL, 0x000fe200078e00ffULL,
0xfffffff869027812ULL, 0x000fe400078ee202ULL, 0x0001600068697811ULL, 0x000fe400078e68ffULL,
0x000000767828723cULL, 0x000f620000041828ULL, 0xfffffff87d007812ULL, 0x000fc400078ee200ULL,
0x00000010046c7824ULL, 0x000fca00078e0269ULL, 0x00000070782c723cULL, 0x040f70000004182cULL,
0x000000727830723cULL, 0x040f700000041830ULL, 0x0000006e7838723cULL, 0x040f700000041838ULL,
0x0000006a7840723cULL, 0x000b6e0000041840ULL, 0x0000001006787824ULL, 0x120fe200078e027cULL,
0x000000742444723cULL, 0x040b6a0000041844ULL, 0x000000007878783bULL, 0x000e640000000200ULL,
0x0000001003747824ULL, 0x120fe200078e0269ULL, 0x000000762448723cULL, 0x040f700000041848ULL,
0x00000070244c723cULL, 0x040b6e000004184cULL, 0x0000001002707824ULL, 0x020fe200078e0269ULL,
0x000000722450723cULL, 0x040f700000041850ULL, 0x0000006e2458723cULL, 0x040f700000041858ULL,
0x0000006a2460723cULL, 0x000b6e0000041860ULL, 0x0000001005247824ULL, 0x020fcc00078e027cULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001078787231ULL, 0x082fe400003400ffULL, 0x000000107a7a7231ULL, 0x000fe400003400ffULL,
0x0000000f79797231ULL, 0x080fe400003400ffULL, 0x0000000f7b7b7231ULL, 0x000fe400003400ffULL,
0x0000000e24247231ULL, 0x084fe400003400ffULL, 0x0000000e26267231ULL, 0x000fc400003400ffULL,
0x0000000d25257231ULL, 0x080fe400003400ffULL, 0x0000000d27277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x0000006900687211ULL, 0x000fe200078e20ffULL,
0x000000006c6c783bULL, 0x000e620000004200ULL, 0x000059001f1f7a24ULL, 0x010fe200078e02ffULL,
0xfffffff822227812ULL, 0x000fe400078ec0ffULL, 0x000000007474783bULL, 0x000ee80000004200ULL,
0x000000007070783bULL, 0x000ea80000004200ULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x0000006c7864723cULL, 0x042f700000041864ULL, 0x0000006e7828723cULL, 0x040f700000041828ULL,
0x00000074782c723cULL, 0x048f70000004182cULL, 0x000000767830723cULL, 0x040f700000041830ULL,
0x000000707834723cULL, 0x044f700000041834ULL, 0x000000727838723cULL, 0x040f700000041838ULL,
0x00000068783c723cULL, 0x040f70000004183cULL, 0x0000006a7840723cULL, 0x000f700000041840ULL,
0x00000074244c723cULL, 0x040f70000004184cULL, 0x000000762450723cULL, 0x040f700000041850ULL,
0x000000702454723cULL, 0x040f700000041854ULL, 0x000000722458723cULL, 0x040f700000041858ULL,
0x0000006c2444723cULL, 0x040f700000041844ULL, 0x0000006e2448723cULL, 0x040f700000041848ULL,
0x00000068245c723cULL, 0x040f70000004185cULL, 0x0000006a2460723cULL, 0x000b6e0000041860ULL,
0x000000081d247824ULL, 0x020fe200078e027eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x000000011d687810ULL, 0x000fe20007ffe0ffULL, 0x01e6880022ff7f8cULL, 0x0003e2000c80043fULL,
0x0000008024267811ULL, 0x000fe200078e28ffULL, 0x00000100ff6a7424ULL, 0x000fe200078e00ffULL,
0x000000196800720cULL, 0x000fe20003f06070ULL, 0x000000801f1f7824ULL, 0x000fe200078e00ffULL,
0x0000006026247812ULL, 0x000fc600078ec0ffULL, 0x000062001f687625ULL, 0x000fc800078e006aULL,
0x00000001157d7824ULL, 0x000fe200078e0224ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff227819ULL, 0x102fe2000001161cULL,
0x000000801e257824ULL, 0x000fe200078e00ffULL, 0x000000261b1f7217ULL, 0x000fe40007800000ULL,
0x00000008226c7810ULL, 0x040fe40007ffe0ffULL, 0x00000004226a7810ULL, 0x000fe40007ffe0ffULL,
0x0000001f261f7210ULL, 0x000fe20007ffe1ffULL, 0x000000016c247824ULL, 0x040fe200078e021cULL,
0x0000200021217812ULL, 0x000fe200078ec0ffULL, 0x000000086c277824ULL, 0x000fe200078e00ffULL,
0x000000201f1f7817ULL, 0x000fe20003800000ULL, 0x000000016a6b7824ULL, 0x000fe200078e027dULL,
0x0000001422847810ULL, 0x000fe20007ffe0ffULL, 0x000040007e7e7824ULL, 0x000fe200078e0221ULL,
0xfffffff827767812ULL, 0x000fe200078ee224ULL, 0x0000000122277824ULL, 0x000fe200078e027dULL,
0x0000008012247812ULL, 0x000fe200078ef825ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x0000001f6a00720cULL, 0x040fe20003f86070ULL, 0x000000016a217824ULL, 0x000fe200078e021cULL,
0x0000000c22727810ULL, 0x040fe20007ffe0ffULL, 0x0000010027267825ULL, 0x000fe200078e0024ULL,
0x00000010227a7810ULL, 0x000fc40007ffe0ffULL, 0x0000001f7200720cULL, 0x080fe20003f46070ULL,
0x000000086a747824ULL, 0x000fe200078e00ffULL, 0x00000026686e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001846f7824ULL, 0x000fe200078e021cULL, 0x0000001f6c00720cULL, 0x080fe20003f66070ULL,
0x0000000884867824ULL, 0x000fe200078e00ffULL, 0xfffffff874747812ULL, 0x000fe200078ee221ULL,
0x000001006b6a7825ULL, 0x000fe200078e0024ULL, 0x0000001f2200720cULL, 0x000fe40003fa6070ULL,
0xfffffff886867812ULL, 0x000fe200078ee26fULL, 0x0000000172217824ULL, 0x000fe200078e021cULL,
0x0000006a68707210ULL, 0x000fe20007f3e0ffULL, 0x0000000872787824ULL, 0x000fc400078e00ffULL,
0x00000001696f7824ULL, 0x040fe200000e0627ULL, 0x0000007d6c277210ULL, 0x000fe20007ffe0ffULL,
0x0000000169717824ULL, 0x000fe200008e066bULL, 0xfffffff878787812ULL, 0x000fe200078ee221ULL,
0x000000017a6d7824ULL, 0x140fe200078e021cULL, 0x0000001f7a00720cULL, 0x040fe20003f26070ULL,
0x000000087a7c7824ULL, 0x000fe400078e00ffULL, 0x00000001726b7824ULL, 0x000fe400078e027dULL,
0x0000000122217824ULL, 0x000fe200078e021cULL, 0xfffffff87c7c7812ULL, 0x000fe200078ee26dULL,
0x0000010027267825ULL, 0x000fc600078e0024ULL, 0x0000000721757812ULL, 0x000fe200078ec0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0024ULL, 0x0000002668727210ULL, 0x000fe40007f1e0ffULL,
0x000160007e217810ULL, 0x000fe20007ffe0ffULL, 0x000000017a6d7824ULL, 0x000fe200078e027dULL,
0x0000006a686a7210ULL, 0x000fe20007fde0ffULL, 0x0000000169737824ULL, 0x000fe200000e0627ULL,
0x0ffffff875267812ULL, 0x000fe200078ef81cULL, 0x000001006d6c7825ULL, 0x000fe200078e0024ULL,
0x00000018227a7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c227e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000184277824ULL, 0x000fe200078e027dULL, 0x0000007d7a7b7210ULL, 0x000fe20007ffe0ffULL,
0x00000001696b7824ULL, 0x000fe200030e066bULL, 0x0000006c686c7210ULL, 0x000fe20007fde0ffULL,
0x0000001026777824ULL, 0x000fe200078e0221ULL, 0x0000001f8400720cULL, 0x000fe20003f06070ULL,
0x0000010027267825ULL, 0x000fc600078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e777faeULL, 0x0003e2000e901c48ULL, 0x00000001696d7824ULL, 0x000fe200030e066dULL,
0x0000001f7a00720cULL, 0x000fe20003fa6070ULL, 0x0000001074797824ULL, 0x000fe200078e0221ULL,
0x0000002668747210ULL, 0x000fe20007fde0ffULL, 0x000000017a227824ULL, 0x000fc600078e021cULL,
0x0000000070797faeULL, 0x0005e2000e101c48ULL, 0x0000000169757824ULL, 0x000fe200030e0627ULL,
0x0000001f7e00720cULL, 0x000fe20003f86070ULL, 0x000001007b267825ULL, 0x000fe200078e0024ULL,
0x0000002186777211ULL, 0x002fc600078e20ffULL, 0x000000017e1f7824ULL, 0x000fe200078e027dULL,
0x0000002668267210ULL, 0x000fe20007fde0ffULL, 0x000000087a6f7824ULL, 0x000fe400078e00ffULL,
0x000000017e6e7824ULL, 0x040fe400078e021cULL, 0x000000087e717824ULL, 0x004fe200078e00ffULL,
0xfffffff86f227812ULL, 0x000fe200078ee222ULL, 0x000001001f247825ULL, 0x000fc600078e0024ULL,
0xfffffff8716e7812ULL, 0x000fe200078ee26eULL, 0x0000000169277824ULL, 0x040fe200030e0627ULL,
0x0000002468247210ULL, 0x000fe20007fde0ffULL, 0x00000010761f7824ULL, 0x100fe400078e0221ULL,
0x00000010786f7824ULL, 0x100fe400078e0221ULL, 0x000000107c717824ULL, 0x100fe200078e0221ULL,
0x00000000721f7faeULL, 0x0003e2000d901c48ULL, 0x0000001022797824ULL, 0x100fe400078e0221ULL,
0x000000106e217824ULL, 0x000fe200078e0221ULL, 0x000000006a6f7faeULL, 0x0003e2000d101c48ULL,
0x0000000169257824ULL, 0x000fc600030e0625ULL, 0x000000006c717faeULL, 0x0003e8000c901c48ULL,
0x0000000074777faeULL, 0x0003e8000c101c48ULL, 0x0000000026797faeULL, 0x0003e8000e901c48ULL,
0x0000000024217faeULL, 0x0003e2000e101c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000c1c6d7811ULL, 0x002fe200078fe8ffULL, 0x000000801e757824ULL, 0x000fe200078e00ffULL,
0x000000041c277811ULL, 0x000fc400078fe8ffULL, 0x000000101c6f7811ULL, 0x040fe200078fe8ffULL,
0x000000016d227824ULL, 0x100fe200078e021cULL, 0x0000200021217812ULL, 0x000fe200078ec0ffULL,
0x000000086d7b7824ULL, 0x000fe200078e00ffULL, 0x000000081c6b7811ULL, 0x040fe200078fe8ffULL,
0x00000001271f7824ULL, 0x040fe200078e021cULL, 0x000000181c737811ULL, 0x040fe200078fe8ffULL,
0x0000000827247824ULL, 0x000fe200078e00ffULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee222ULL,
0x000000086f227824ULL, 0x000fe200078e00ffULL, 0x000000141c717811ULL, 0x000fe200078fe8ffULL,
0x000040007e7e7824ULL, 0x000fe200078e0221ULL, 0xfffffff824777812ULL, 0x000fe200078ee21fULL,
0x000000016b217824ULL, 0x100fe200078e021cULL, 0x0000001c6f1f7210ULL, 0x080fe20007ffe0ffULL,
0x000000086b267824ULL, 0x000fe200078e00ffULL, 0x0000008012747812ULL, 0x000fe200078ef875ULL,
0x0000000873897824ULL, 0x040fe200078e00ffULL, 0xfffffff8227f7812ULL, 0x000fe200078ee21fULL,
0x0000000173227824ULL, 0x100fe200078e021cULL, 0xfffffff826797812ULL, 0x000fe200078ee221ULL,
0x0000000171217824ULL, 0x040fe200078e021cULL, 0x0000007d1c257211ULL, 0x0c0fe200078fe8ffULL,
0x0000000871247824ULL, 0x000fe200078e00ffULL, 0xfffffff889897812ULL, 0x000fe200078ee222ULL,
0x000000ffff757224ULL, 0x000fe200078e00ffULL, 0x0000001c1c227811ULL, 0x000fe200078fe8ffULL,
0x0000000127277824ULL, 0x000fe200078e027dULL, 0xfffffff824877812ULL, 0x000fe200078ee221ULL,
0x000000016b6b7824ULL, 0x100fe200078e027dULL, 0x0000001c1c1f7211ULL, 0x000fe200078fe8ffULL,
0x0000000122247824ULL, 0x040fe200078e021cULL, 0x0000007d71717210ULL, 0x000fe20007ffe0ffULL,
0x00000008228b7824ULL, 0x000fe200078e00ffULL, 0x000000071f217812ULL, 0x000fe200078ec0ffULL,
0x000000016d6d7824ULL, 0x000fe200078e027dULL, 0x000160007e7e7810ULL, 0x000fe20007ffe0ffULL,
0x0000010027267825ULL, 0x000fe200078e0074ULL, 0xfffffff88b8b7812ULL, 0x000fc400078ee224ULL,
0x0ffffff821217812ULL, 0x000fe200078ef81cULL, 0x0000010025247825ULL, 0x000fe200078e0074ULL,
0x0000002668267210ULL, 0x000fc60007f3e0ffULL, 0x000000016f6f7824ULL, 0x000fe200078e027dULL,
0x0000002468247210ULL, 0x000fe20007f1e0ffULL, 0x000001006b6a7825ULL, 0x000fc800078e0074ULL,
0x000001006d6c7825ULL, 0x000fe200078e0074ULL, 0x0000006a686a7210ULL, 0x000fc60007f5e0ffULL,
0x0000000173737824ULL, 0x100fe200078e027dULL, 0x0000006c686c7210ULL, 0x000fe20007f7e0ffULL,
0x00000001221f7824ULL, 0x000fe200078e027dULL, 0x0000007e877d7211ULL, 0x000fe200078e20ffULL,
0x000001006f6e7825ULL, 0x000fc800078e0074ULL, 0x0000010071707825ULL, 0x000fc800078e0074ULL,
0x0000010073727825ULL, 0x000fc800078e0074ULL, 0x000001001f747825ULL, 0x000fc800078e0074ULL,
0x0000000169257824ULL, 0x040fe200000e0625ULL, 0x0000006e686e7210ULL, 0x040fe20007f1e0ffULL,
0x0000000169277824ULL, 0x000fe200008e0627ULL, 0x0000007068707210ULL, 0x040fe20007f3e0ffULL,
0x00000010211f7824ULL, 0x100fe400078e027eULL, 0x00000001696b7824ULL, 0x000fe200010e066bULL,
0x0000007268727210ULL, 0x040fe20007f5e0ffULL, 0x0000001077217824ULL, 0x100fe200078e027eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000241f7faeULL, 0x0003e2000b901c48ULL,
0x00000001696d7824ULL, 0x000fe200018e066dULL, 0x0000007468747210ULL, 0x000fe20007f7e0ffULL,
0x0000001079777824ULL, 0x100fe200078e027eULL, 0x0000000026217faeULL, 0x0003e2000b901c48ULL,
0x000000107b797824ULL, 0x000fc400078e027eULL, 0x000000107f7b7824ULL, 0x100fe200078e027eULL,
0x000000006a777faeULL, 0x0003e2000b901c48ULL, 0x00000001696f7824ULL, 0x040fe400000e066fULL,
0x0000000169717824ULL, 0x000fe200008e0671ULL, 0x000000006c797faeULL, 0x0003e2000b901c48ULL,
0x00000010897f7824ULL, 0x100fe400078e027eULL, 0x0000000169737824ULL, 0x000fe200010e0673ULL,
0x000000006e7b7faeULL, 0x0003e2000b901c48ULL, 0x000000108b877824ULL, 0x000fc400078e027eULL,
0x0000000169757824ULL, 0x000fe200018e0675ULL, 0x00000000707d7faeULL, 0x0003e8000b901c48ULL,
0x00000000727f7faeULL, 0x0003e8000b901c48ULL, 0x0000000074877faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe0181f7812ULL, 0x002fc400078ec0ffULL,
0x0000001018227812ULL, 0x040fe400078ec0ffULL, 0x0000000818217812ULL, 0x000fc800078ec0ffULL,
0x0000001f21217210ULL, 0x000fe20007ffe022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e62800216a7f8cULL, 0x0002a4000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x01e62c00211f7984ULL, 0x000ee40000000800ULL, 0x800000001fff7812ULL, 0x00cfe4000780486bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ff006c7202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624227210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e25ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011426ULL,
0x000000221f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0626ULL,
0x000000021f1f7819ULL, 0x000fc80000001222ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016c6c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e62c00211f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x004fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201e1f7824ULL, 0x000fca00078e00ffULL, 0xffffff801f1f7812ULL, 0x000fc800078ec0ffULL,
0x00000080121f7810ULL, 0x000fca0007ffe01fULL, 0x00000001801f7824ULL, 0x000fca00078e021fULL,
0x01e000001f227984ULL, 0x000ea80000000800ULL, 0x01e200001f6c7984ULL, 0x0006620000000800ULL,
0x000000172200720bULL, 0x004fe20003f1d000ULL, 0x00014cb27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001f7806ULL, 0x008fc800000e0100ULL, 0x000000ff1f00720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff217224ULL, 0x002fd400078e0017ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000011e217811ULL, 0x000fe400078ff0ffULL, 0x000000172200720bULL, 0x000fe40003f34000ULL,
0x0000001e2100720cULL, 0x000fe20003f05270ULL, 0x00014c727f007947ULL, 0x000fd4000b800000ULL,
0x00000000006e7806ULL, 0x000fc400008e0100ULL, 0x000000801e258824ULL, 0x000fe200078e0212ULL,
0x0000001722218209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe60003800000ULL,
0x0000002580248210ULL, 0x000fca0007ffe0ffULL, 0x01e4002124008388ULL, 0x0003e20000000800ULL,
0x000000ff6e00720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000001722247209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff6eff7812ULL, 0x000fc6000780c0ffULL, 0x0000001724217221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b21217820ULL, 0x000fc80000410000ULL, 0x0000002100707308ULL, 0x000e640000000800ULL,
0x0000007023237220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x000fe2000001161cULL, 0x00014bb27f007947ULL, 0x000fea000b800000ULL,
0x00001f2470247589ULL, 0x0002a400000e0000ULL, 0x0000002464647220ULL, 0x084fe40000410000ULL,
0x0000002465657220ULL, 0x080fe40000410000ULL, 0x0000002428287220ULL, 0x080fe40000410000ULL,
0x0000002429297220ULL, 0x000fc40000410000ULL, 0x000000242c2c7220ULL, 0x080fe40000410000ULL,
0x000000242d2d7220ULL, 0x080fe40000410000ULL, 0x0000002430307220ULL, 0x080fe40000410000ULL,
0x0000002431317220ULL, 0x080fe40000410000ULL, 0x0000002434347220ULL, 0x080fe40000410000ULL,
0x0000002435357220ULL, 0x000fc40000410000ULL, 0x0000002438387220ULL, 0x080fe40000410000ULL,
0x0000002439397220ULL, 0x080fe40000410000ULL, 0x000000243c3c7220ULL, 0x080fe40000410000ULL,
0x000000243d3d7220ULL, 0x080fe40000410000ULL, 0x0000002440407220ULL, 0x080fe40000410000ULL,
0x0000002441417220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006eff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081c247811ULL, 0x000fe200078ff0ffULL,
0x00014aa27f007947ULL, 0x000fea000b800000ULL, 0x00001f2470247589ULL, 0x0004e400000e0000ULL,
0x0000002466667220ULL, 0x08cfe40000410000ULL, 0x0000002467677220ULL, 0x080fe40000410000ULL,
0x000000242a2a7220ULL, 0x080fe40000410000ULL, 0x000000242b2b7220ULL, 0x080fe40000410000ULL,
0x000000242e2e7220ULL, 0x080fe40000410000ULL, 0x000000242f2f7220ULL, 0x000fc40000410000ULL,
0x0000002432327220ULL, 0x080fe40000410000ULL, 0x0000002433337220ULL, 0x080fe40000410000ULL,
0x0000002436367220ULL, 0x080fe40000410000ULL, 0x0000002437377220ULL, 0x080fe40000410000ULL,
0x000000243a3a7220ULL, 0x080fe40000410000ULL, 0x000000243b3b7220ULL, 0x000fc40000410000ULL,
0x000000243e3e7220ULL, 0x080fe40000410000ULL, 0x000000243f3f7220ULL, 0x080fe40000410000ULL,
0x0000002442427220ULL, 0x080fe40000410000ULL, 0x0000002443437220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006eff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101c247811ULL, 0x000fe200078ff0ffULL, 0x000149927f007947ULL, 0x000fea000b800000ULL,
0x00001f2470247589ULL, 0x0004e400000e0000ULL, 0x0000002444447220ULL, 0x08cfe40000410000ULL,
0x0000002445457220ULL, 0x080fe40000410000ULL, 0x0000002448487220ULL, 0x080fe40000410000ULL,
0x0000002449497220ULL, 0x080fe40000410000ULL, 0x000000244c4c7220ULL, 0x080fe40000410000ULL,
0x000000244d4d7220ULL, 0x000fc40000410000ULL, 0x0000002450507220ULL, 0x080fe40000410000ULL,
0x0000002451517220ULL, 0x080fe40000410000ULL, 0x0000002454547220ULL, 0x080fe40000410000ULL,
0x0000002455557220ULL, 0x080fe40000410000ULL, 0x0000002458587220ULL, 0x080fe40000410000ULL,
0x0000002459597220ULL, 0x000fc40000410000ULL, 0x000000245c5c7220ULL, 0x080fe40000410000ULL,
0x000000245d5d7220ULL, 0x080fe40000410000ULL, 0x0000002460607220ULL, 0x080fe40000410000ULL,
0x0000002461617220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006eff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181c247811ULL, 0x000fe200078ff0ffULL, 0x000148927f007947ULL, 0x000fea000b800000ULL,
0x00001f2470247589ULL, 0x0004e400000e0000ULL, 0x0000002446467220ULL, 0x08cfe40000410000ULL,
0x0000002447477220ULL, 0x080fe40000410000ULL, 0x000000244a4a7220ULL, 0x080fe40000410000ULL,
0x000000244b4b7220ULL, 0x080fe40000410000ULL, 0x000000244e4e7220ULL, 0x080fe40000410000ULL,
0x000000244f4f7220ULL, 0x000fc40000410000ULL, 0x0000002452527220ULL, 0x080fe40000410000ULL,
0x0000002453537220ULL, 0x080fe40000410000ULL, 0x0000002456567220ULL, 0x080fe40000410000ULL,
0x0000002457577220ULL, 0x080fe40000410000ULL, 0x000000245a5a7220ULL, 0x080fe40000410000ULL,
0x000000245b5b7220ULL, 0x000fc40000410000ULL, 0x000000245e5e7220ULL, 0x080fe40000410000ULL,
0x000000245f5f7220ULL, 0x080fe40000410000ULL, 0x0000002462627220ULL, 0x080fe40000410000ULL,
0x0000002463637220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006e1fff7212ULL, 0x000fe400078030ffULL, 0x0000001722217209ULL, 0x000fd60007810000ULL,
0x8000002122220221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200110308ULL, 0x000e640000000800ULL, 0x000000116c6c0220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000236c237221ULL, 0x000fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000011ff0d723eULL, 0x000fe400000010ffULL, 0x00000002ff227819ULL, 0x000fe4000001161cULL,
0x000054100d0d7816ULL, 0x000fe2000000000dULL, 0x000146f27f007947ULL, 0x000fea000b800000ULL,
0x00001f220d107589ULL, 0x0002a400000e0000ULL, 0x0000000822247810ULL, 0x000fe20007ffe0ffULL,
0x000147427f007947ULL, 0x000fea000b800000ULL, 0x00000010220e7810ULL, 0x000fe20007ffe0ffULL,
0x00001f240d0f7589ULL, 0x00066a00000e0000ULL, 0x00001f0e0d0e7589ULL, 0x0006a400000e0000ULL,
0x0000001822247810ULL, 0x008fe20007ffe0ffULL, 0x000147d27f007947ULL, 0x000fea000b800000ULL,
0x00001f240d0d7589ULL, 0x0022e400000e0000ULL, 0x000004001e177824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000020001e1f7824ULL, 0x000fe200078e00ffULL,
0x0000016000007945ULL, 0x000fe40003800000ULL, 0xfffff00017177812ULL, 0x000fc400078ec0ffULL,
0xffffc0001f257812ULL, 0x000fe400078ec0ffULL, 0x0001300017177810ULL, 0x000fc60007ffe0ffULL,
0x0000200014227824ULL, 0x000fe200078e0225ULL, 0x000000170c7c7211ULL, 0x000fe200078e20ffULL,
0x000000100b177824ULL, 0x000fc600078e0217ULL, 0x0001700022227810ULL, 0x000fe40007ffe0ffULL,
0x000000007c7c783bULL, 0x000e660000000200ULL, 0x0000001009787824ULL, 0x100fe200078e0222ULL,
0x000000001724783bULL, 0x0022e20000000200ULL, 0x000000100a747824ULL, 0x100fe400078e0222ULL,
0x0000001008707824ULL, 0x000fe200078e0222ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x000000107c7c7231ULL, 0x084fe400003400ffULL, 0x000000107e7e7231ULL, 0x000fc400003400ffULL,
0x0000000f7d7d7231ULL, 0x080fe400003400ffULL, 0x0000000f7f7f7231ULL, 0x000fe400003400ffULL,
0x0000000e24247231ULL, 0x088fe400003400ffULL, 0x0000000e26267231ULL, 0x000fe400003400ffULL,
0x0000000d25257231ULL, 0x080fe400003400ffULL, 0x0000000d27277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010076c7824ULL, 0x000fe200078e0222ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x00000002ff227819ULL, 0x100fe2000001161eULL,
0x0000028000007945ULL, 0x000fe20003800000ULL, 0x00000001ff177819ULL, 0x002fe2000001161eULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x00013000226a7811ULL, 0x000fc600078e60ffULL,
0x000000007070783bULL, 0x000ee20000004200ULL, 0x00000002176b7824ULL, 0x000fc600078e0214ULL,
0x000000006c6c783bULL, 0x000ea40000004200ULL, 0x000170006b6b7811ULL, 0x000fe200078e68ffULL,
0x000000787c64723cULL, 0x050f700000041864ULL, 0x0000007a7c28723cULL, 0x040f700000041828ULL,
0x000000747c2c723cULL, 0x042f70000004182cULL, 0x000000767c30723cULL, 0x040f700000041830ULL,
0x000000707c34723cULL, 0x048f700000041834ULL, 0x000000727c38723cULL, 0x040f700000041838ULL,
0x0000006c7c3c723cULL, 0x044f70000004183cULL, 0x0000006e7c40723cULL, 0x000b6e0000041840ULL,
0x00000010067c7824ULL, 0x120fe200078e026aULL, 0x000000782444723cULL, 0x040b6a0000041844ULL,
0x000000007c7c783bULL, 0x000e640000000200ULL, 0x0000001004787824ULL, 0x120fe200078e026bULL,
0x0000007a2448723cULL, 0x040f700000041848ULL, 0x00000074244c723cULL, 0x040b6e000004184cULL,
0x0000001003747824ULL, 0x020fe200078e026bULL, 0x000000762450723cULL, 0x040f700000041850ULL,
0x000000702454723cULL, 0x040b6e0000041854ULL, 0x0000006b02707211ULL, 0x020fe200078e20ffULL,
0x000000722458723cULL, 0x040f700000041858ULL, 0x0000006c245c723cULL, 0x040f70000004185cULL,
0x0000006e2460723cULL, 0x000b6e0000041860ULL, 0x0000001005247824ULL, 0x020fcc00078e026aULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x000000107c7c7231ULL, 0x082fe400003400ffULL, 0x000000107e7e7231ULL, 0x000fe400003400ffULL,
0x0000000f7d7d7231ULL, 0x080fe400003400ffULL, 0x0000000f7f7f7231ULL, 0x000fe400003400ffULL,
0x0000000e24247231ULL, 0x084fe400003400ffULL, 0x0000000e26267231ULL, 0x000fc400003400ffULL,
0x0000000d25257231ULL, 0x080fe400003400ffULL, 0x0000000d27277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x00000010006c7824ULL, 0x000fe200078e026bULL,
0x000000007878783bULL, 0x000e680000004200ULL, 0x000000007474783bULL, 0x000ee80000004200ULL,
0x000000007070783bULL, 0x000f280000004200ULL, 0x000000006c6c783bULL, 0x000ea20000004200ULL,
0x000000787c64723cULL, 0x042f700000041864ULL, 0x0000007a7c28723cULL, 0x040f700000041828ULL,
0x000000747c2c723cULL, 0x048f70000004182cULL, 0x000000767c30723cULL, 0x040f700000041830ULL,
0x000000707c34723cULL, 0x050f700000041834ULL, 0x000000727c38723cULL, 0x040f700000041838ULL,
0x0000006c7c3c723cULL, 0x044f70000004183cULL, 0x0000006e7c40723cULL, 0x000f700000041840ULL,
0x000000782444723cULL, 0x040f700000041844ULL, 0x0000007a2448723cULL, 0x040f700000041848ULL,
0x00000074244c723cULL, 0x040f70000004184cULL, 0x000000762450723cULL, 0x040f700000041850ULL,
0x000000702454723cULL, 0x040f700000041854ULL, 0x000000722458723cULL, 0x040f700000041858ULL,
0x0000006c245c723cULL, 0x040f70000004185cULL, 0x0000006e2460723cULL, 0x000b6e0000041860ULL,
0x000000081d257824ULL, 0x020fe200078e0217ULL, 0x0001e69022247811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x000000011d6a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000024ff7f8cULL, 0x0003e2000c80043fULL, 0x000000c025257811ULL, 0x000fc400078e28ffULL,
0x000000196a00720cULL, 0x000fe40003f06070ULL, 0x0000006025267812ULL, 0x000fca00078ec0ffULL,
0x0000000115777824ULL, 0x000fe200078e0226ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff747819ULL, 0x102fe4000001161cULL,
0x000000251b247217ULL, 0x000fe40007800000ULL, 0x0000000474267810ULL, 0x040fe40007ffe0ffULL,
0x0000000c74727810ULL, 0x000fe20007ffe0ffULL, 0x0000000124257824ULL, 0x000fe200078e0a25ULL,
0x000000071e277819ULL, 0x000fe200000006ffULL, 0x0000000126247824ULL, 0x100fe200078e021cULL,
0x00000008746c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008267b7824ULL, 0x000fe200078e00ffULL,
0x0000002025757817ULL, 0x000fe20003800000ULL, 0x00000001726b7824ULL, 0x000fe200078e021cULL,
0x0000001074787810ULL, 0x000fe20007ffe0ffULL, 0x00000008726e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee224ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x0000008012247812ULL, 0x000fe200078ef827ULL, 0x0000000174277824ULL, 0x000fe200078e0277ULL,
0xfffffff86e7f7812ULL, 0x000fe200078ee26bULL, 0x000000016c6a7824ULL, 0x000fe200078e021cULL,
0x00000014747a7810ULL, 0x000fe20007ffe0ffULL, 0x000000086c7d7824ULL, 0x000fe200078e00ffULL,
0x000000752600720cULL, 0x0c0fe20003f86070ULL, 0x00000001266b7824ULL, 0x000fe200078e0277ULL,
0x000000757200720cULL, 0x000fe20003f46070ULL, 0x0000010027267825ULL, 0x000fe200078e0024ULL,
0xfffffff87d7d7812ULL, 0x000fc400078ee26aULL, 0x000000756c00720cULL, 0x080fe20003f66070ULL,
0x00000001786d7824ULL, 0x000fe200078e021cULL, 0x00000026686e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000878707824ULL, 0x000fe200078e00ffULL, 0x000020001f267812ULL, 0x000fe200078ec0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0024ULL, 0x000000757400720cULL, 0x000fe40003fa6070ULL,
0xfffffff870877812ULL, 0x000fe200078ee26dULL, 0x000000017a6f7824ULL, 0x000fe200078e021cULL,
0x0000006a68707210ULL, 0x000fe20007f3e0ffULL, 0x000000087a767824ULL, 0x000fc400078e00ffULL,
0x00000001741f7824ULL, 0x000fe400078e021cULL, 0x0000000169717824ULL, 0x040fe200008e066bULL,
0xfffffff876897812ULL, 0x000fe200078ee26fULL, 0x00000001696f7824ULL, 0x000fe200000e0627ULL,
0x0000002617767211ULL, 0x000fe200078e70ffULL, 0x000000016c277824ULL, 0x100fe200078e0277ULL,
0x000000071f1f7812ULL, 0x000fe200078ec0ffULL, 0x00000001726b7824ULL, 0x000fe200078e0277ULL,
0x0001700076767810ULL, 0x000fe20007ffe0ffULL, 0x0000010027267825ULL, 0x000fe200078e0024ULL,
0x0ffffff81f1f7812ULL, 0x000fc400078ef81cULL, 0x000000757800720cULL, 0x000fe20003f26070ULL,
0x000001006b6a7825ULL, 0x000fe200078e0024ULL, 0x0000002668727210ULL, 0x000fc60007f1e0ffULL,
0x00000001786d7824ULL, 0x000fe200078e0277ULL, 0x0000006a686a7210ULL, 0x000fe20007fde0ffULL,
0x0000000169737824ULL, 0x000fe200000e0627ULL, 0x0000001874787810ULL, 0x000fe20007ffe0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0024ULL, 0x000000757a00720cULL, 0x000fc60003f06070ULL,
0x000000017a277824ULL, 0x000fe200078e0277ULL, 0x0000001c747a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001696b7824ULL, 0x000fe200030e066bULL, 0x0000006c686c7210ULL, 0x000fe20007fde0ffULL,
0x0000010027267825ULL, 0x000fc800078e0024ULL, 0x000000101f797824ULL, 0x100fe400078e0276ULL,
0x000000107b7b7824ULL, 0x100fe400078e0276ULL, 0x00000001696d7824ULL, 0x000fe200030e066dULL,
0x0000002668747210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e797faeULL, 0x0003e2000e901c48ULL, 0x00000001781f7824ULL, 0x140fe200078e0277ULL,
0x000000757800720cULL, 0x080fe20003fa6070ULL, 0x000000017a777824ULL, 0x040fe200078e0277ULL,
0x00000000707b7faeULL, 0x0005e2000e101c48ULL, 0x000000757a00720cULL, 0x000fe20003f86070ULL,
0x000000107d7d7824ULL, 0x000fe200078e0276ULL, 0x0000002769757210ULL, 0x000fe200037fe4ffULL,
0x000001001f267825ULL, 0x000fc600078e0024ULL, 0x00000000727d7faeULL, 0x0005e2000d901c48ULL,
0x00000001781f7824ULL, 0x100fe200078e021cULL, 0x0000002668267210ULL, 0x000fe20007fde0ffULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x000000017a6e7824ULL, 0x042fe400078e021cULL,
0x000000087a6f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8781f7812ULL, 0x000fe200078ee21fULL,
0x0000010077247825ULL, 0x000fc600078e0024ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee26eULL,
0x0000000169277824ULL, 0x000fe200030e0627ULL, 0x0000002468247210ULL, 0x000fe20007fde0ffULL,
0x000000107f7f7824ULL, 0x100fe200078e0276ULL, 0x000000761f1f7211ULL, 0x000fe200078e20ffULL,
0x0000001087877824ULL, 0x100fe400078e0276ULL, 0x0000001089897824ULL, 0x100fe200078e0276ULL,
0x000000006a7f7faeULL, 0x0005e2000d101c48ULL, 0x000000106f6f7824ULL, 0x000fe400078e0276ULL,
0x0000000169257824ULL, 0x000fe200030e0625ULL, 0x000000006c877faeULL, 0x0005e8000c901c48ULL,
0x0000000074897faeULL, 0x0005e8000c101c48ULL, 0x00000000261f7faeULL, 0x0005e8000e901c48ULL,
0x00000000246f7faeULL, 0x0005e2000e101c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x000000081c6b7811ULL, 0x002fe200078fe8ffULL, 0x000000801e757824ULL, 0x000fe200078e00ffULL,
0x000000041c277811ULL, 0x000fc400078fe8ffULL, 0x000000101c6f7811ULL, 0x040fe200078fe8ffULL,
0x000000016b257824ULL, 0x140fe200078e021cULL, 0x0000000c1c6d7811ULL, 0x040fe200078fe8ffULL,
0x000000086b267824ULL, 0x000fe200078e00ffULL, 0x000000141c717811ULL, 0x040fe200078fe8ffULL,
0x0000000127247824ULL, 0x140fe200078e021cULL, 0x000000181c737811ULL, 0x000fe200078fe8ffULL,
0x00000008277b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8267d7812ULL, 0x000fe200078ee225ULL,
0x000000016f257824ULL, 0x000fe200078e021cULL, 0x0000001c71267210ULL, 0x080fe20007ffe0ffULL,
0x000000086f6c7824ULL, 0x000fe200078e00ffULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee224ULL,
0x000000016d247824ULL, 0x140fe200078e021cULL, 0x0000008012747812ULL, 0x000fe200078ef875ULL,
0x000000086d7f7824ULL, 0x000fe200078e00ffULL, 0xfffffff86c877812ULL, 0x000fe200078ee225ULL,
0x0000000871897824ULL, 0x000fe200078e00ffULL, 0x0000001c1c257811ULL, 0x040fe200078fe8ffULL,
0x00000001736a7824ULL, 0x000fe200078e021cULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee224ULL,
0x00000008738b7824ULL, 0x000fe200078e00ffULL, 0x000020001f247812ULL, 0x000fe200078ec0ffULL,
0x0000000825757824ULL, 0x000fe200078e00ffULL, 0x0000001c1c1f7211ULL, 0x0c0fe200078fe8ffULL,
0x0000000127277824ULL, 0x100fe200078e0277ULL, 0xfffffff889897812ULL, 0x000fe200078ee226ULL,
0x0000400017247824ULL, 0x000fe200078e0224ULL, 0x0000001c25267210ULL, 0x000fe20007ffe0ffULL,
0x000000016b6b7824ULL, 0x100fe200078e0277ULL, 0x000000071f797812ULL, 0x000fe200078ec0ffULL,
0x00000001251f7824ULL, 0x100fe200078e0277ULL, 0x000000771c257211ULL, 0x000fe200078fe8ffULL,
0x000000016d6d7824ULL, 0x100fe200078e0277ULL, 0x0001700024767810ULL, 0x000fe20007ffe0ffULL,
0x000000016f6f7824ULL, 0x100fe200078e0277ULL, 0xfffffff88b8b7812ULL, 0x000fe200078ee26aULL,
0x0000000171717824ULL, 0x100fe200078e0277ULL, 0x0ffffff879797812ULL, 0x000fe200078ef81cULL,
0x0000000173737824ULL, 0x000fe200078e0277ULL, 0xfffffff875777812ULL, 0x000fe200078ee226ULL,
0x000000ffff757224ULL, 0x000fe200078e00ffULL, 0x000000768b8b7211ULL, 0x000fe200078e20ffULL,
0x0000001079797824ULL, 0x000fc400078e0276ULL, 0x0000010025247825ULL, 0x000fc800078e0074ULL,
0x0000010027267825ULL, 0x000fe200078e0074ULL, 0x0000002468247210ULL, 0x000fc60007f1e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0074ULL, 0x0000002668267210ULL, 0x000fc60007f3e0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0074ULL, 0x0000006a686a7210ULL, 0x000fc60007f5e0ffULL,
0x000001006f6e7825ULL, 0x000fe200078e0074ULL, 0x0000006c686c7210ULL, 0x000fc60007f7e0ffULL,
0x0000010071707825ULL, 0x000fc800078e0074ULL, 0x0000010073727825ULL, 0x000fc800078e0074ULL,
0x000001001f747825ULL, 0x000fc800078e0074ULL, 0x0000000169257824ULL, 0x040fe200000e0625ULL,
0x0000006e686e7210ULL, 0x040fe20007f1e0ffULL, 0x0000000169277824ULL, 0x040fe200008e0627ULL,
0x0000007068707210ULL, 0x040fe20007f3e0ffULL, 0x00000001696b7824ULL, 0x000fe200010e066bULL,
0x0000007268727210ULL, 0x040fe20007f5e0ffULL, 0x000000107b7b7824ULL, 0x100fe200078e0276ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024797faeULL, 0x0003e2000b901c48ULL,
0x00000001696d7824ULL, 0x000fe200018e066dULL, 0x0000007468687210ULL, 0x000fe20007f7e0ffULL,
0x000000107d7d7824ULL, 0x100fe200078e0276ULL, 0x00000000267b7faeULL, 0x0003e2000b901c48ULL,
0x000000107f7f7824ULL, 0x000fc400078e0276ULL, 0x0000001087877824ULL, 0x100fe200078e0276ULL,
0x000000006a7d7faeULL, 0x0003e2000b901c48ULL, 0x00000001696f7824ULL, 0x000fe400000e066fULL,
0x0000001089897824ULL, 0x100fe200078e0276ULL, 0x000000006c7f7faeULL, 0x0003e2000b901c48ULL,
0x0000000169717824ULL, 0x040fe400008e0671ULL, 0x0000000169737824ULL, 0x000fe200010e0673ULL,
0x000000006e877faeULL, 0x0003e2000b901c48ULL, 0x0000001077777824ULL, 0x000fc400078e0276ULL,
0x0000000169697824ULL, 0x000fe200018e0675ULL, 0x0000000070897faeULL, 0x0003e8000b901c48ULL,
0x00000000728b7faeULL, 0x0003e8000b901c48ULL, 0x0000000068777faeULL, 0x0003e4000b901c48ULL,
0x00000300ff1f7624ULL, 0x004fe200078e00ffULL, 0x0000000120247812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000012400780cULL, 0x000fc40003f05070ULL,
0xffffffff1f1f7811ULL, 0x000fc800078e08ffULL, 0x000000011f1f7807ULL, 0x000fc80004000000ULL,
0x0000001f20207210ULL, 0x000fe20007ffe0ffULL, 0xffffffffff1f7424ULL, 0x000fc600078e00ffULL,
0x0000001a2000720cULL, 0x000fda0003f06070ULL, 0x0000000120248824ULL, 0x000fe400078e0213ULL,
0x00000004ff258424ULL, 0x000fc800078e00ffULL, 0x0000640024248625ULL, 0x000fca00078e0025ULL,
0x00000008241f8981ULL, 0x000322000c1e1900ULL, 0x0000001018277812ULL, 0x000fca00078ec0ffULL,
0x0000002022227824ULL, 0x000fe200078e0227ULL, 0x0000000818277812ULL, 0x000fca00078ec0ffULL,
0x0000000127227824ULL, 0x000fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6480022687f8cULL, 0x0022a4000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x01e64c0022277984ULL, 0x000ee40000000800ULL, 0x8000000027ff7812ULL, 0x00cfe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026246b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09006b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000006b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e64c0022277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201e227824ULL, 0x002fca00078e00ffULL, 0xffffff8022257812ULL, 0x000fc800078ec0ffULL,
0x0000010012257810ULL, 0x000fca0007ffe025ULL, 0x0000000180257824ULL, 0x000fca00078e0225ULL,
0x01e0000025227984ULL, 0x000e680000000800ULL, 0x01e2000025687984ULL, 0x0004e20000000800ULL,
0x000000212200720bULL, 0x002fe20003f1d000ULL, 0x000131a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000697806ULL, 0x004fc800000e0100ULL, 0x000000ff6900720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x000000021e257811ULL, 0x000fe400078ff0ffULL,
0x000000212200720bULL, 0x000fe40003f34000ULL, 0x0000001e2500720cULL, 0x000fe20003f05270ULL,
0x000131727f007947ULL, 0x000fd4000b800000ULL, 0x00000000006c7806ULL, 0x000fc400008e0100ULL,
0x000000801e258824ULL, 0x000fe200078e0212ULL, 0x0000002122248209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000180258824ULL, 0x000fca00078e0225ULL,
0x01e4002425008388ULL, 0x0003e20000000800ULL, 0x000000ff6c00720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002122247209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff6cff7812ULL, 0x000fc6000780c0ffULL,
0x0000002124247221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x00000024006e7308ULL, 0x000e640000000800ULL, 0x0000006e23237220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x000fe2000001161cULL,
0x000130b27f007947ULL, 0x000fea000b800000ULL, 0x00001f246e247589ULL, 0x0002a400000e0000ULL,
0x0000002464647220ULL, 0x084fe40000410000ULL, 0x0000002465657220ULL, 0x080fe40000410000ULL,
0x0000002428287220ULL, 0x080fe40000410000ULL, 0x0000002429297220ULL, 0x000fc40000410000ULL,
0x000000242c2c7220ULL, 0x080fe40000410000ULL, 0x000000242d2d7220ULL, 0x080fe40000410000ULL,
0x0000002430307220ULL, 0x080fe40000410000ULL, 0x0000002431317220ULL, 0x080fe40000410000ULL,
0x0000002434347220ULL, 0x080fe40000410000ULL, 0x0000002435357220ULL, 0x000fc40000410000ULL,
0x0000002438387220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x080fe40000410000ULL, 0x0000002441417220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081c247811ULL, 0x000fe200078ff0ffULL, 0x00012fa27f007947ULL, 0x000fea000b800000ULL,
0x00001f246e247589ULL, 0x00046400000e0000ULL, 0x0000002466667220ULL, 0x086fe40000410000ULL,
0x0000002467677220ULL, 0x080fe40000410000ULL, 0x000000242a2a7220ULL, 0x080fe40000410000ULL,
0x000000242b2b7220ULL, 0x080fe40000410000ULL, 0x000000242e2e7220ULL, 0x080fe40000410000ULL,
0x000000242f2f7220ULL, 0x000fc40000410000ULL, 0x0000002432327220ULL, 0x080fe40000410000ULL,
0x0000002433337220ULL, 0x080fe40000410000ULL, 0x0000002436367220ULL, 0x080fe40000410000ULL,
0x0000002437377220ULL, 0x080fe40000410000ULL, 0x000000243a3a7220ULL, 0x080fe40000410000ULL,
0x000000243b3b7220ULL, 0x000fc40000410000ULL, 0x000000243e3e7220ULL, 0x080fe40000410000ULL,
0x000000243f3f7220ULL, 0x080fe40000410000ULL, 0x0000002442427220ULL, 0x080fe40000410000ULL,
0x0000002443437220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101c247811ULL, 0x000fe200078ff0ffULL,
0x00012e927f007947ULL, 0x000fea000b800000ULL, 0x00001f246e247589ULL, 0x00046400000e0000ULL,
0x0000002444447220ULL, 0x086fe40000410000ULL, 0x0000002445457220ULL, 0x080fe40000410000ULL,
0x0000002448487220ULL, 0x080fe40000410000ULL, 0x0000002449497220ULL, 0x080fe40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000244d4d7220ULL, 0x000fc40000410000ULL,
0x0000002450507220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x080fe40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002459597220ULL, 0x000fc40000410000ULL,
0x000000245c5c7220ULL, 0x080fe40000410000ULL, 0x000000245d5d7220ULL, 0x080fe40000410000ULL,
0x0000002460607220ULL, 0x080fe40000410000ULL, 0x0000002461617220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000006cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181c247811ULL, 0x000fe200078ff0ffULL,
0x00012d927f007947ULL, 0x000fea000b800000ULL, 0x00001f246e247589ULL, 0x00046400000e0000ULL,
0x0000002446467220ULL, 0x086fe40000410000ULL, 0x0000002447477220ULL, 0x080fe40000410000ULL,
0x000000244a4a7220ULL, 0x080fe40000410000ULL, 0x000000244b4b7220ULL, 0x080fe40000410000ULL,
0x000000244e4e7220ULL, 0x080fe40000410000ULL, 0x000000244f4f7220ULL, 0x000fc40000410000ULL,
0x0000002452527220ULL, 0x080fe40000410000ULL, 0x0000002453537220ULL, 0x080fe40000410000ULL,
0x0000002456567220ULL, 0x080fe40000410000ULL, 0x0000002457577220ULL, 0x080fe40000410000ULL,
0x000000245a5a7220ULL, 0x080fe40000410000ULL, 0x000000245b5b7220ULL, 0x000fc40000410000ULL,
0x000000245e5e7220ULL, 0x080fe40000410000ULL, 0x000000245f5f7220ULL, 0x080fe40000410000ULL,
0x0000002462627220ULL, 0x080fe40000410000ULL, 0x0000002463637220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006c69ff7212ULL, 0x000fe400078030ffULL,
0x0000002122217209ULL, 0x000fd60007810000ULL, 0x8000002122220221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL, 0x0000002200110308ULL, 0x000e640000000800ULL,
0x0000001168680220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002368237221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000011ff0d723eULL, 0x000fe400000010ffULL,
0x00000002ff227819ULL, 0x000fe4000001161cULL, 0x000054100d0d7816ULL, 0x000fe2000000000dULL,
0x00012bf27f007947ULL, 0x000fea000b800000ULL, 0x00001f220d107589ULL, 0x0002a400000e0000ULL,
0x0000000822247810ULL, 0x000fe20007ffe0ffULL, 0x00012c427f007947ULL, 0x000fea000b800000ULL,
0x00000010220e7810ULL, 0x000fe20007ffe0ffULL, 0x00001f240d0f7589ULL, 0x00066a00000e0000ULL,
0x00001f0e0d0e7589ULL, 0x0006a400000e0000ULL, 0x0000001822247810ULL, 0x008fe20007ffe0ffULL,
0x00012cd27f007947ULL, 0x000fea000b800000ULL, 0x00001f240d0d7589ULL, 0x0022e400000e0000ULL,
0x000004001e227824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000217257824ULL, 0x000fe200078e0214ULL, 0x0000015000007945ULL, 0x000fe40003800000ULL,
0xfffff00022247812ULL, 0x002fe200078ec0ffULL, 0x0000200025227824ULL, 0x000fc600078e00ffULL,
0x0001400024247810ULL, 0x000fe40007ffe0ffULL, 0x00016000227d7810ULL, 0x000fc60007ffe0ffULL,
0x000000100c687824ULL, 0x100fe400078e0224ULL, 0x000000100b247824ULL, 0x000fe400078e0224ULL,
0x00000010096c7824ULL, 0x100fe400078e027dULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0x000000100a707824ULL, 0x100fe400078e027dULL, 0x0000001008747824ULL, 0x000fe200078e027dULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001068687231ULL, 0x086fe400003400ffULL, 0x000000106a6a7231ULL, 0x000fc400003400ffULL,
0x0000000f69697231ULL, 0x080fe400003400ffULL, 0x0000000f6b6b7231ULL, 0x000fe400003400ffULL,
0x0000000e24247231ULL, 0x088fe400003400ffULL, 0x0000000e26267231ULL, 0x000fe400003400ffULL,
0x0000000d25257231ULL, 0x080fe400003400ffULL, 0x0000000d27277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001007787824ULL, 0x100fe200078e027dULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x00000002ff7c7819ULL, 0x000fe2000001161eULL,
0x0000025000007945ULL, 0x000fe40003800000ULL, 0x000000007070783bULL, 0x000ea80000004200ULL,
0x000000007474783bULL, 0x000e680000004200ULL, 0x000000007878783bULL, 0x000e640000004200ULL,
0x0000006c6864723cULL, 0x04af700000041864ULL, 0x0000006e6828723cULL, 0x040f700000041828ULL,
0x00000070682c723cULL, 0x044f70000004182cULL, 0x000000726830723cULL, 0x040f700000041830ULL,
0x000000746834723cULL, 0x040f700000041834ULL, 0x000000766838723cULL, 0x040f700000041838ULL,
0x00000078683c723cULL, 0x040f70000004183cULL, 0x0000007a6840723cULL, 0x000b6e0000041840ULL,
0x000140007c687811ULL, 0x020fe200078e60ffULL, 0x00000078245c723cULL, 0x040f70000004185cULL,
0x0000006c2444723cULL, 0x040b6e0000041844ULL, 0x00000010036c7824ULL, 0x120fe200078e027dULL,
0x0000006e2448723cULL, 0x040f700000041848ULL, 0x00000070244c723cULL, 0x040b6e000004184cULL,
0x0000001002707824ULL, 0x020fe200078e027dULL, 0x000000722450723cULL, 0x040f700000041850ULL,
0x000000742454723cULL, 0x040f700000041854ULL, 0x000000762458723cULL, 0x040f700000041858ULL,
0x0000007a2478723cULL, 0x000b6e0000041860ULL, 0x0000006806607211ULL, 0x020fe200078e20ffULL,
0x0000001005247824ULL, 0x000fc400078e0268ULL, 0x0000001004687824ULL, 0x000fc600078e027dULL,
0x000000006060783bULL, 0x000e680000000200ULL, 0x000000002424783bULL, 0x000ea20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001060607231ULL, 0x082fe400003400ffULL,
0x0000001062627231ULL, 0x000fe400003400ffULL, 0x0000000f61617231ULL, 0x080fe400003400ffULL,
0x0000000f63637231ULL, 0x000fc400003400ffULL, 0x0000000e24247231ULL, 0x084fe400003400ffULL,
0x0000000e26267231ULL, 0x000fe400003400ffULL, 0x0000000d25257231ULL, 0x080fe400003400ffULL,
0x0000000d27277231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000747824ULL, 0x000fe200078e027dULL, 0x000000006868783bULL, 0x000ee80000004200ULL,
0x000000006c6c783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000e680000004200ULL,
0x000000007474783bULL, 0x000e640000004200ULL, 0x000000686064723cULL, 0x04af700000041864ULL,
0x0000006a6028723cULL, 0x040f700000041828ULL, 0x0000006c602c723cULL, 0x044f70000004182cULL,
0x0000006e6030723cULL, 0x040f700000041830ULL, 0x000000706034723cULL, 0x040f700000041834ULL,
0x000000726038723cULL, 0x040f700000041838ULL, 0x00000074603c723cULL, 0x040f70000004183cULL,
0x000000766040723cULL, 0x000f700000041840ULL, 0x000000682444723cULL, 0x040f700000041844ULL,
0x0000006a2448723cULL, 0x040f700000041848ULL, 0x0000006c244c723cULL, 0x040f70000004184cULL,
0x0000006e2450723cULL, 0x040f700000041850ULL, 0x000000702454723cULL, 0x040f700000041854ULL,
0x000000722458723cULL, 0x040f700000041858ULL, 0x00000074245c723cULL, 0x040f70000004185cULL,
0x000000762478723cULL, 0x000b6e0000041878ULL, 0x0001e6987c247811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x000003001d1d7a10ULL, 0x000fe20007ffe0ffULL,
0x0000000024ff7f8cULL, 0x0003e6000c80043fULL, 0x000000191d00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000c9000000947ULL, 0x000fea0003800000ULL,
0x000000011d267810ULL, 0x002fe20007ffe0ffULL, 0x000059001f247a24ULL, 0x010fe400078e02ffULL,
0x000001001d277824ULL, 0x000fe200078e0216ULL, 0x000000192600720cULL, 0x000fe20003f06070ULL,
0x0000008024257824ULL, 0x000fe400078e00ffULL, 0x00000100ff267424ULL, 0x000fe200078e00ffULL,
0x0000006027247812ULL, 0x000fca00078ec0ffULL, 0x0000000115757824ULL, 0x000fe400078e0224ULL,
0x0000620025247625ULL, 0x000fe400078e0026ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff707819ULL, 0x100fe4000001161cULL, 0x000000271b267217ULL, 0x000fe40007800000ULL,
0x0000000470607810ULL, 0x040fe40007ffe0ffULL, 0x0000000870687810ULL, 0x000fe20007ffe0ffULL,
0x0000000126267824ULL, 0x000fe200078e0a27ULL, 0x0000001c60277210ULL, 0x040fe20007ffe0ffULL,
0x00000008606a7824ULL, 0x000fe200078e00ffULL, 0x0000000c706e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000168617824ULL, 0x100fe200078e021cULL, 0x0000002026717817ULL, 0x000fe20003800000ULL,
0x00000008686c7824ULL, 0x000fe200078e00ffULL, 0xfffffff86a7d7812ULL, 0x000fe200078ee227ULL,
0x000000801e277824ULL, 0x000fe200078e00ffULL, 0x000000716000720cULL, 0x080fe20003f86070ULL,
0x000000016e627824ULL, 0x000fe200078e021cULL, 0xfffffff86c7f7812ULL, 0x000fe200078ee261ULL,
0x000000086e877824ULL, 0x000fe200078e00ffULL, 0x0000008012267812ULL, 0x000fe200078ef827ULL,
0x0000000170617824ULL, 0x140fe200078e0275ULL, 0x0000001470747810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0xfffffff887877812ULL, 0x000fe200078ee262ULL,
0x0000000160637824ULL, 0x000fe200078e0275ULL, 0x0000001070727810ULL, 0x000fe20007ffe0ffULL,
0x0000010061607825ULL, 0x000fe200078e0026ULL, 0x000000716800720cULL, 0x000fc40003f66070ULL,
0x0000000372767819ULL, 0x000fe200000006ffULL, 0x0000010063627825ULL, 0x000fe200078e0026ULL,
0x00000060246a7210ULL, 0x000fe40007f1e0ffULL, 0x000000716e00720cULL, 0x080fe20003f46070ULL,
0x00000001746b7824ULL, 0x100fe200078e021cULL, 0x00000062246c7210ULL, 0x000fe20007f3e0ffULL,
0x00000008747e7824ULL, 0x000fe200078e00ffULL, 0x000000717000720cULL, 0x000fe20003fa6070ULL,
0x000020001e607824ULL, 0x000fe400078e00ffULL, 0x0000000170627824ULL, 0x000fe200078e021cULL,
0xfffffff87e8b7812ULL, 0x000fe200078ee26bULL, 0x00000001256b7824ULL, 0x000fc400000e0661ULL,
0x0000000168617824ULL, 0x000fe200078e0275ULL, 0x0000200060687812ULL, 0x000fe200078ec0ffULL,
0x00000001256d7824ULL, 0x000fe200008e0663ULL, 0x0000000762737812ULL, 0x000fe200078ec0ffULL,
0x0000000172697824ULL, 0x140fe200078e021cULL, 0x000000717200720cULL, 0x000fe20003f26070ULL,
0x000000016e637824ULL, 0x000fe200078e0275ULL, 0x0ffffff873737812ULL, 0x000fe200078ef81cULL,
0x0000010061607825ULL, 0x000fe200078e0026ULL, 0xfffffff876897812ULL, 0x000fe400078ee269ULL,
0x0000001c70767810ULL, 0x000fe20007ffe0ffULL, 0x0000010063627825ULL, 0x000fe200078e0026ULL,
0x00000060246e7210ULL, 0x000fc60007f1e0ffULL, 0x0000000172697824ULL, 0x000fe200078e0275ULL,
0x0000006224627210ULL, 0x000fe20007fde0ffULL, 0x0000400017727824ULL, 0x000fe200078e0268ULL,
0x00000061256f7210ULL, 0x000fe200007fe4ffULL, 0x0000010069687825ULL, 0x000fe200078e0026ULL,
0x000000717400720cULL, 0x000fe40003f06070ULL, 0x0001600072727810ULL, 0x000fe20007ffe0ffULL,
0x0000000174617824ULL, 0x000fe200078e0275ULL, 0x0000001870747810ULL, 0x000fe20007ffe0ffULL,
0x0000000125637824ULL, 0x000fe200030e0663ULL, 0x0000006824687210ULL, 0x000fe20007fde0ffULL,
0x0000010061607825ULL, 0x000fc800078e0026ULL, 0x0000001073777824ULL, 0x100fe400078e0272ULL,
0x000000107d7d7824ULL, 0x000fe400078e0272ULL, 0x0000000125697824ULL, 0x040fe200030e0669ULL,
0x0000006024707210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a777faeULL, 0x0003e2000e901c48ULL, 0x0000000174737824ULL, 0x140fe200078e0275ULL,
0x000000717400720cULL, 0x080fe20003fa6070ULL, 0x0000000176757824ULL, 0x040fe200078e0275ULL,
0x000000006c7d7faeULL, 0x0005e2000e101c48ULL, 0x000000717600720cULL, 0x000fe20003f86070ULL,
0x0000000125717824ULL, 0x000fc400030e0661ULL, 0x0000010073607825ULL, 0x000fc800078e0026ULL,
0x00000001746a7824ULL, 0x002fe200078e021cULL, 0x0000006024607210ULL, 0x000fe20007fde0ffULL,
0x00000008746b7824ULL, 0x000fe400078e00ffULL, 0x00000008766d7824ULL, 0x044fe200078e00ffULL,
0x0000001c766c7210ULL, 0x000fe20007ffe0ffULL, 0x0000010075267825ULL, 0x000fe200078e0026ULL,
0xfffffff86b6b7812ULL, 0x000fe400078ee26aULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee26cULL,
0x0000000125617824ULL, 0x000fe200030e0661ULL, 0x0000002624247210ULL, 0x000fe20007fde0ffULL,
0x000000107f7f7824ULL, 0x000fc400078e0272ULL, 0x0000001087877824ULL, 0x100fe400078e0272ULL,
0x0000001089897824ULL, 0x100fe200078e0272ULL, 0x000000006e7f7faeULL, 0x0003e2000d901c48ULL,
0x000000108b8b7824ULL, 0x100fe400078e0272ULL, 0x000000106b6b7824ULL, 0x100fe200078e0272ULL,
0x0000000062877faeULL, 0x0003e2000d101c48ULL, 0x000000106d6d7824ULL, 0x000fe400078e0272ULL,
0x0000000125257824ULL, 0x000fe200030e0627ULL, 0x0000000068897faeULL, 0x0003e8000c901c48ULL,
0x00000000708b7faeULL, 0x0003e8000c101c48ULL, 0x00000000606b7faeULL, 0x0003e8000e901c48ULL,
0x00000000246d7faeULL, 0x0003e2000e101c48ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x000000041c617811ULL, 0x000fe200078fe8ffULL, 0x000000801e717824ULL, 0x000fe200078e00ffULL,
0x000000081c637811ULL, 0x000fc400078fe8ffULL, 0x00000003617d7819ULL, 0x040fe200000006ffULL,
0x0000000161267824ULL, 0x100fe200078e021cULL, 0x0000000c1c697811ULL, 0x040fe200078fe8ffULL,
0x0000000163277824ULL, 0x040fe200078e021cULL, 0x000000101c6b7811ULL, 0x040fe200078fe8ffULL,
0x0000000863607824ULL, 0x000fe200078e00ffULL, 0x000000141c6d7811ULL, 0x000fe200078fe8ffULL,
0x0000000869877824ULL, 0x000fe200078e00ffULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee226ULL,
0x0000000169267824ULL, 0x100fe200078e021cULL, 0xfffffff8607f7812ULL, 0x000fe200078ee227ULL,
0x000000016b277824ULL, 0x040fe200078e021cULL, 0x0000001c1c737811ULL, 0x000fe200078fe8ffULL,
0x000000086b687824ULL, 0x000fe200078e00ffULL, 0xfffffff887877812ULL, 0x000fe200078ee226ULL,
0x000000016d607824ULL, 0x040fe200078e021cULL, 0x0000000d1e267819ULL, 0x000fe200000006ffULL,
0x000000086d8b7824ULL, 0x000fe200078e00ffULL, 0x000000181c6f7811ULL, 0x000fe200078fe8ffULL,
0x0000000161617824ULL, 0x000fe200078e0275ULL, 0xfffffff868897812ULL, 0x000fe200078ee227ULL,
0x0000000163637824ULL, 0x000fe200078e0275ULL, 0xfffffff88b8b7812ULL, 0x000fe200078ee260ULL,
0x0000000173607824ULL, 0x100fe200078e021cULL, 0x0000001c1c277211ULL, 0x000fe200078fe8ffULL,
0x000000016f627824ULL, 0x000fe200078e021cULL, 0x0000008012707812ULL, 0x000fe200078ef871ULL,
0x0000000873717824ULL, 0x000fe200078e00ffULL, 0x0000200026267812ULL, 0x000fe200078ec0ffULL,
0x000000086f8d7824ULL, 0x000fe200078e00ffULL, 0x0000000727777812ULL, 0x000fe200078ec0ffULL,
0x0000000169697824ULL, 0x100fe200078e0275ULL, 0x000000751c277211ULL, 0x000fe200078fe8ffULL,
0x000000016b6b7824ULL, 0x100fe200078e0275ULL, 0x0000002617267211ULL, 0x000fe200078e70ffULL,
0x000000016d6d7824ULL, 0x100fe200078e0275ULL, 0xfffffff88d8d7812ULL, 0x000fe200078ee262ULL,
0x000000016f6f7824ULL, 0x100fe200078e0275ULL, 0x0001600026727810ULL, 0x000fe20007ffe0ffULL,
0x0000000173737824ULL, 0x000fe200078e0275ULL, 0xfffffff871757812ULL, 0x000fe200078ee260ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x0ffffff877777812ULL, 0x000fe200078ef81cULL,
0x000000107d7d7824ULL, 0x000fc400078e0272ULL, 0x0000010027267825ULL, 0x000fc800078e0070ULL,
0x0000010061607825ULL, 0x000fe200078e0070ULL, 0x0000002624267210ULL, 0x000fc60007f1e0ffULL,
0x0000010063627825ULL, 0x000fe200078e0070ULL, 0x0000006024607210ULL, 0x000fc60007f3e0ffULL,
0x0000010069687825ULL, 0x100fe200078e0070ULL, 0x0000006224627210ULL, 0x040fe40007f5e0ffULL,
0x0000006125617210ULL, 0x000fe20000ffe4ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0070ULL,
0x0000006824687210ULL, 0x000fc60007f7e0ffULL, 0x000001006d6c7825ULL, 0x000fc800078e0070ULL,
0x000001006f6e7825ULL, 0x000fe200078e0070ULL, 0x0000006c246c7210ULL, 0x000fc60007f3e0ffULL,
0x0000010073707825ULL, 0x000fc800078e0070ULL, 0x0000000125277824ULL, 0x000fe200000e0627ULL,
0x0000006a246a7210ULL, 0x040fe20007f1e0ffULL, 0x0000001077777824ULL, 0x100fe400078e0272ULL,
0x0000000125637824ULL, 0x040fe200010e0663ULL, 0x0000006e246e7210ULL, 0x040fe20007f5e0ffULL,
0x0000000125697824ULL, 0x000fe200018e0669ULL, 0x0000007024247210ULL, 0x000fe20007f7e0ffULL,
0x000000107f7f7824ULL, 0x100fe200078e0272ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026777faeULL, 0x0003e2000b901c48ULL, 0x0000001087877824ULL, 0x000fc400078e0272ULL,
0x0000001089897824ULL, 0x100fe200078e0272ULL, 0x00000000607d7faeULL, 0x0003e2000b901c48ULL,
0x00000001256b7824ULL, 0x000fe400000e066bULL, 0x000000108b8b7824ULL, 0x100fe200078e0272ULL,
0x00000000627f7faeULL, 0x0003e2000b901c48ULL, 0x00000001256d7824ULL, 0x000fe400008e066dULL,
0x000000108d8d7824ULL, 0x000fe200078e0272ULL, 0x0000000068877faeULL, 0x0003e2000b901c48ULL,
0x00000001256f7824ULL, 0x000fc400010e066fULL, 0x0000001075757824ULL, 0x000fe200078e0272ULL,
0x000000006a897faeULL, 0x0003e2000b901c48ULL, 0x0000000125257824ULL, 0x000fc600018e0671ULL,
0x000000006c8b7faeULL, 0x0003e8000b901c48ULL, 0x000000006e8d7faeULL, 0x0003e8000b901c48ULL,
0x0000000024757faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x0000001018257812ULL, 0x040fe400078ec0ffULL, 0x0000000818247812ULL, 0x000fc600078ec0ffULL,
0x000000207c257824ULL, 0x000fc800078e0225ULL, 0x0000000124627824ULL, 0x000fe200078e0225ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6680062607f8cULL, 0x0002a4000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x01e66c0062277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x00cfe40007804861ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624637210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09006300780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406300780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000006326267211ULL, 0x000fc800078110ffULL,
0x00000027ff277210ULL, 0x000fc800007fe4ffULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e66c0062277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe40007804861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000031e257811ULL, 0x000fca00078ff0ffULL,
0x0000008025257824ULL, 0x000fc800078e0212ULL, 0x0000000180257824ULL, 0x000fca00078e0225ULL,
0x01e0000025607984ULL, 0x000ea80000000800ULL, 0x01e2000025627984ULL, 0x0022e20000000800ULL,
0x000000216000720bULL, 0x004fe20003f1d000ULL, 0x000117327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000617806ULL, 0x002fc800000e0100ULL, 0x000000ff6100720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x000000031e257811ULL, 0x000fe400078ff0ffULL,
0x000000216000720bULL, 0x000fe40003f34000ULL, 0x0000001e2500720cULL, 0x000fe20003f05270ULL,
0x000117027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000687806ULL, 0x000fc400008e0100ULL,
0x000000801e258824ULL, 0x000fe200078e0212ULL, 0x0000002160128209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000180258824ULL, 0x000fca00078e0225ULL,
0x01e4001225008388ULL, 0x0003e20000000800ULL, 0x000000ff6800720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002160127209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff68ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002112127221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b12127820ULL, 0x000fcc0000410000ULL,
0x0000001200127308ULL, 0x000e640000000800ULL, 0x0000001223237220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x000fe2000001161cULL,
0x000116427f007947ULL, 0x000fea000b800000ULL, 0x00001f2412247589ULL, 0x0002a400000e0000ULL,
0x0000002464647220ULL, 0x084fe40000410000ULL, 0x0000002465657220ULL, 0x080fe40000410000ULL,
0x0000002428287220ULL, 0x080fe40000410000ULL, 0x0000002429297220ULL, 0x000fc40000410000ULL,
0x000000242c2c7220ULL, 0x080fe40000410000ULL, 0x000000242d2d7220ULL, 0x080fe40000410000ULL,
0x0000002430307220ULL, 0x080fe40000410000ULL, 0x0000002431317220ULL, 0x080fe40000410000ULL,
0x0000002434347220ULL, 0x080fe40000410000ULL, 0x0000002435357220ULL, 0x000fc40000410000ULL,
0x0000002438387220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x080fe40000410000ULL, 0x0000002441417220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0068ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081c247811ULL, 0x000fe200078ff0ffULL, 0x000115327f007947ULL, 0x000fea000b800000ULL,
0x00001f2412247589ULL, 0x00046400000e0000ULL, 0x0000002466667220ULL, 0x086fe40000410000ULL,
0x0000002467677220ULL, 0x080fe40000410000ULL, 0x000000242a2a7220ULL, 0x080fe40000410000ULL,
0x000000242b2b7220ULL, 0x080fe40000410000ULL, 0x000000242e2e7220ULL, 0x080fe40000410000ULL,
0x000000242f2f7220ULL, 0x000fc40000410000ULL, 0x0000002432327220ULL, 0x080fe40000410000ULL,
0x0000002433337220ULL, 0x080fe40000410000ULL, 0x0000002436367220ULL, 0x080fe40000410000ULL,
0x0000002437377220ULL, 0x080fe40000410000ULL, 0x000000243a3a7220ULL, 0x080fe40000410000ULL,
0x000000243b3b7220ULL, 0x000fc40000410000ULL, 0x000000243e3e7220ULL, 0x080fe40000410000ULL,
0x000000243f3f7220ULL, 0x080fe40000410000ULL, 0x0000002442427220ULL, 0x080fe40000410000ULL,
0x0000002443437220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000068ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101c247811ULL, 0x000fe200078ff0ffULL,
0x000114227f007947ULL, 0x000fea000b800000ULL, 0x00001f2412247589ULL, 0x00046400000e0000ULL,
0x0000002444447220ULL, 0x086fe40000410000ULL, 0x0000002445457220ULL, 0x080fe40000410000ULL,
0x0000002448487220ULL, 0x080fe40000410000ULL, 0x0000002449497220ULL, 0x080fe40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000244d4d7220ULL, 0x000fc40000410000ULL,
0x0000002450507220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x080fe40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002459597220ULL, 0x000fc40000410000ULL,
0x000000245c5c7220ULL, 0x080fe40000410000ULL, 0x000000245d5d7220ULL, 0x080fe40000410000ULL,
0x0000002478787220ULL, 0x080fe40000410000ULL, 0x0000002479797220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000068ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181c247811ULL, 0x000fe200078ff0ffULL,
0x000113227f007947ULL, 0x000fea000b800000ULL, 0x00001f2412247589ULL, 0x00046400000e0000ULL,
0x0000002446467220ULL, 0x086fe40000410000ULL, 0x0000002447477220ULL, 0x080fe40000410000ULL,
0x000000244a4a7220ULL, 0x080fe40000410000ULL, 0x000000244b4b7220ULL, 0x080fe40000410000ULL,
0x000000244e4e7220ULL, 0x080fe40000410000ULL, 0x000000244f4f7220ULL, 0x000fc40000410000ULL,
0x0000002452527220ULL, 0x080fe40000410000ULL, 0x0000002453537220ULL, 0x080fe40000410000ULL,
0x0000002456567220ULL, 0x080fe40000410000ULL, 0x0000002457577220ULL, 0x080fe40000410000ULL,
0x000000245a5a7220ULL, 0x080fe40000410000ULL, 0x000000245b5b7220ULL, 0x000fc40000410000ULL,
0x000000245e5e7220ULL, 0x080fe40000410000ULL, 0x000000245f5f7220ULL, 0x080fe40000410000ULL,
0x000000247a7a7220ULL, 0x080fe40000410000ULL, 0x000000247b7b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006861ff7212ULL, 0x000fe400078030ffULL,
0x0000002160217209ULL, 0x000fd60007810000ULL, 0x8000002160600221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b60600820ULL, 0x000fc80000410000ULL, 0x0000006000110308ULL, 0x000e640000000800ULL,
0x0000001162620220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002362237221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000011ff0d723eULL, 0x000fe400000010ffULL,
0x00000002ff127819ULL, 0x000fe4000001161cULL, 0x000054100d0d7816ULL, 0x000fe2000000000dULL,
0x000111827f007947ULL, 0x000fea000b800000ULL, 0x00001f120d107589ULL, 0x0002a400000e0000ULL,
0x0000000812247810ULL, 0x000fe20007ffe0ffULL, 0x000111d27f007947ULL, 0x000fea000b800000ULL,
0x00000010120e7810ULL, 0x000fe20007ffe0ffULL, 0x00001f240d0f7589ULL, 0x00066a00000e0000ULL,
0x00001f0e0d0e7589ULL, 0x0006a400000e0000ULL, 0x0000001812247810ULL, 0x008fe20007ffe0ffULL,
0x000112627f007947ULL, 0x000fea000b800000ULL, 0x00001f240d0d7589ULL, 0x0022e400000e0000ULL,
0x000000031e127811ULL, 0x000fe200078ff0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0001700022757810ULL, 0x000fe20007ffe0ffULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0001200012127811ULL, 0x000fc600078e60ffULL, 0x00000010096c7824ULL, 0x100fe400078e0275ULL,
0x000000100b0b7824ULL, 0x100fe400078e0212ULL, 0x000000100c0c7824ULL, 0x000fe400078e0212ULL,
0x000000100a687824ULL, 0x100fe400078e0275ULL, 0x0000001008607824ULL, 0x000fe200078e0275ULL,
0x000000000c70783bULL, 0x0002e80000000200ULL, 0x000000000b08783bULL, 0x000ea20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001070707231ULL, 0x08cfe400003400ffULL,
0x0000001072727231ULL, 0x000fc400003400ffULL, 0x0000000f71717231ULL, 0x080fe400003400ffULL,
0x0000000f73737231ULL, 0x000fe400003400ffULL, 0x0000000e08087231ULL, 0x080fe400003400ffULL,
0x0000000e0a0a7231ULL, 0x000fe400003400ffULL, 0x0000000d09097231ULL, 0x080fe400003400ffULL,
0x0000000d0b0b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001007247824ULL, 0x102fe200078e0275ULL, 0x000000006c6c783bULL, 0x000e620000004200ULL,
0x0000001206067211ULL, 0x000fe200078e20ffULL, 0x0000001005127824ULL, 0x000fe200078e0212ULL,
0x0000023000007945ULL, 0x000fe20003800000ULL, 0x000000006868783bULL, 0x000fe20000004200ULL,
0x00000010040c7824ULL, 0x000fc400078e0275ULL, 0x0000001003037824ULL, 0x100fe200078e0275ULL,
0x000000006060783bULL, 0x000ee20000004200ULL, 0x0000001002027824ULL, 0x000fc600078e0275ULL,
0x000000002424783bULL, 0x000ea80000004200ULL, 0x000000000604783bULL, 0x000ea40000000200ULL,
0x0000006c0844723cULL, 0x006f700000041844ULL, 0x000000607034723cULL, 0x048f700000041834ULL,
0x000000627038723cULL, 0x000f700000041838ULL, 0x0000006e0848723cULL, 0x040f700000041848ULL,
0x00000068084c723cULL, 0x040f70000004184cULL, 0x0000006a0850723cULL, 0x040f700000041850ULL,
0x000000600854723cULL, 0x040f700000041854ULL, 0x000000620858723cULL, 0x040b640000041858ULL,
0x000000001260783bULL, 0x0202ac0000000200ULL, 0x00000024085c723cULL, 0x000b70000004185cULL,
0x0000006c7064723cULL, 0x040b700000041864ULL, 0x0000006e7028723cULL, 0x040b700000041828ULL,
0x00000068702c723cULL, 0x040b70000004182cULL, 0x0000006a7030723cULL, 0x040b700000041830ULL,
0x00000024703c723cULL, 0x040b70000004183cULL, 0x000000267040723cULL, 0x080b700000041840ULL,
0x000000260808723cULL, 0x000b620000041878ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x0000001004047231ULL, 0x086fe400003400ffULL,
0x0000001006067231ULL, 0x000fc400003400ffULL, 0x0000000f05057231ULL, 0x080fe400003400ffULL,
0x0000000f07077231ULL, 0x000fe400003400ffULL, 0x0000000e60607231ULL, 0x080fe400003400ffULL,
0x0000000e62627231ULL, 0x000fe400003400ffULL, 0x0000000d61617231ULL, 0x080fe400003400ffULL,
0x0000000d63637231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x0000001000007824ULL, 0x000fe200078e0275ULL, 0x000000000c24783bULL, 0x020e680000004200ULL,
0x000000000368783bULL, 0x000ea80000004200ULL, 0x00000000026c783bULL, 0x000ee80000004200ULL,
0x000000000070783bULL, 0x0002a40000004200ULL, 0x00000002ff007819ULL, 0x002fc8000001161eULL,
0x0001e6a000007811ULL, 0x000fe200078e18ffULL, 0x000000246044723cULL, 0x040b700000041844ULL,
0x000000266048723cULL, 0x040b700000041848ULL, 0x00000068604c723cULL, 0x044b70000004184cULL,
0x0000006a6050723cULL, 0x040b700000041850ULL, 0x0000006c6054723cULL, 0x048b700000041854ULL,
0x0000006e6058723cULL, 0x040b700000041858ULL, 0x00000070605c723cULL, 0x000b70000004185cULL,
0x000000240464723cULL, 0x040b700000041864ULL, 0x000000260428723cULL, 0x040b700000041828ULL,
0x00000068042c723cULL, 0x040b70000004182cULL, 0x0000006a0430723cULL, 0x040b700000041830ULL,
0x0000006c0434723cULL, 0x040b700000041834ULL, 0x0000006e0438723cULL, 0x040b700000041838ULL,
0x00000070043c723cULL, 0x040b70000004183cULL, 0x000000720440723cULL, 0x080b700000041840ULL,
0x000000726060723cULL, 0x000b620000041808ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000191d00720cULL, 0x000fe20003f06070ULL, 0x0000000000ff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff816000007947ULL, 0x000fea000383ffffULL,
0x0000000000067919ULL, 0x020e640000002500ULL, 0x000000190600720cULL, 0x002fda0003f06070ULL,
0x0000058000000947ULL, 0x000fea0003800000ULL, 0x0180000023007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0023ULL, 0x00009bd000087802ULL, 0x000fc40000000f00ULL,
0x0001102000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002300007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000023ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001803057811ULL, 0x046fe400078ff0ffULL,
0x00000002ff077819ULL, 0x000fe40000011603ULL, 0x0000000803097811ULL, 0x040fe400078ff0ffULL,
0x00000010030b7811ULL, 0x000fe200078ff0ffULL, 0x00001f0700027589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea800000e0000ULL, 0x00001f0900037589ULL, 0x000ee800000e0000ULL,
0x00001f0b00047589ULL, 0x000ea200000e0000ULL, 0x0000006402647220ULL, 0x002fc40000410000ULL,
0x0000006502657220ULL, 0x040fe40000410000ULL, 0x0000002802287220ULL, 0x040fe40000410000ULL,
0x0000002902297220ULL, 0x040fe40000410000ULL, 0x0000002c022c7220ULL, 0x040fe40000410000ULL,
0x0000002d022d7220ULL, 0x040fe40000410000ULL, 0x0000003002307220ULL, 0x000fc40000410000ULL,
0x0000003102317220ULL, 0x040fe40000410000ULL, 0x0000003402347220ULL, 0x040fe40000410000ULL,
0x0000003502357220ULL, 0x040fe40000410000ULL, 0x0000003802387220ULL, 0x040fe40000410000ULL,
0x0000003902397220ULL, 0x040fe40000410000ULL, 0x0000003c023c7220ULL, 0x000fc40000410000ULL,
0x0000003d023d7220ULL, 0x040fe40000410000ULL, 0x0000004002407220ULL, 0x040fe40000410000ULL,
0x0000004102417220ULL, 0x000fe40000410000ULL, 0x0000004605467220ULL, 0x044fe40000410000ULL,
0x0000004705477220ULL, 0x040fe40000410000ULL, 0x0000004a054a7220ULL, 0x000fc40000410000ULL,
0x0000004b054b7220ULL, 0x040fe40000410000ULL, 0x0000004e054e7220ULL, 0x040fe40000410000ULL,
0x0000004f054f7220ULL, 0x040fe40000410000ULL, 0x0000005205527220ULL, 0x040fe40000410000ULL,
0x0000005305537220ULL, 0x040fe40000410000ULL, 0x0000005605567220ULL, 0x000fc40000410000ULL,
0x0000005705577220ULL, 0x040fe40000410000ULL, 0x0000005a055a7220ULL, 0x040fe40000410000ULL,
0x0000005b055b7220ULL, 0x040fe40000410000ULL, 0x0000005e055e7220ULL, 0x040fe40000410000ULL,
0x0000005f055f7220ULL, 0x040fe40000410000ULL, 0x0000006205627220ULL, 0x000fc40000410000ULL,
0x0000006305637220ULL, 0x000fe40000410000ULL, 0x0000000366667220ULL, 0x088fe40000410000ULL,
0x0000000367677220ULL, 0x080fe40000410000ULL, 0x000000032a2a7220ULL, 0x080fe40000410000ULL,
0x000000032b2b7220ULL, 0x080fe40000410000ULL, 0x000000032e2e7220ULL, 0x000fc40000410000ULL,
0x000000032f2f7220ULL, 0x080fe40000410000ULL, 0x0000000332327220ULL, 0x080fe40000410000ULL,
0x0000000333337220ULL, 0x080fe40000410000ULL, 0x0000000336367220ULL, 0x080fe40000410000ULL,
0x0000000337377220ULL, 0x080fe40000410000ULL, 0x000000033a3a7220ULL, 0x000fc40000410000ULL,
0x000000033b3b7220ULL, 0x080fe40000410000ULL, 0x000000033e3e7220ULL, 0x080fe40000410000ULL,
0x000000033f3f7220ULL, 0x080fe40000410000ULL, 0x0000000342427220ULL, 0x080fe40000410000ULL,
0x0000000343437220ULL, 0x000fe40000410000ULL, 0x0000000444447220ULL, 0x000fc40000410000ULL,
0x0000000445457220ULL, 0x080fe40000410000ULL, 0x0000000448487220ULL, 0x080fe40000410000ULL,
0x0000000449497220ULL, 0x080fe40000410000ULL, 0x000000044c4c7220ULL, 0x080fe40000410000ULL,
0x000000044d4d7220ULL, 0x080fe40000410000ULL, 0x0000000450507220ULL, 0x000fc40000410000ULL,
0x0000000451517220ULL, 0x080fe40000410000ULL, 0x0000000454547220ULL, 0x080fe40000410000ULL,
0x0000000455557220ULL, 0x080fe40000410000ULL, 0x0000000458587220ULL, 0x080fe40000410000ULL,
0x0000000459597220ULL, 0x080fe40000410000ULL, 0x000000045c5c7220ULL, 0x000fc40000410000ULL,
0x000000045d5d7220ULL, 0x080fe40000410000ULL, 0x0000000460607220ULL, 0x080fe40000410000ULL,
0x0000000461617220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x000000282905723eULL, 0x000fe400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002c2d07723eULL, 0x000fc400000010ffULL,
0x0000002e2f2e723eULL, 0x000fe400000010ffULL, 0x000000646504723eULL, 0x000fe400000010ffULL,
0x000000303108723eULL, 0x000fe400000010ffULL, 0x00000034350a723eULL, 0x000fe400000010ffULL,
0x00000038390b723eULL, 0x000fe400000010ffULL, 0x0000003c3d0c723eULL, 0x000fc400000010ffULL,
0x00000002ff1a7819ULL, 0x002fe40000011603ULL, 0x00000008032d7811ULL, 0x000fe400078ff0ffULL,
0x000000041a197810ULL, 0x040fe20007ffe0ffULL, 0x000000081a1b7824ULL, 0x040fe200078e00ffULL,
0x000000031a207819ULL, 0x040fe200000006ffULL, 0x000000081a1d7824ULL, 0x040fe200078e00ffULL,
0x000000011a007810ULL, 0x040fe20007ffe0ffULL, 0x000000081a1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff820257812ULL, 0x000fe200078ee219ULL, 0x000000081a197824ULL, 0x040fe200078e00ffULL,
0x000000021a027810ULL, 0x040fe20007ffe0ffULL, 0x000000081a277824ULL, 0x040fe200078e00ffULL,
0x000000031a097810ULL, 0x040fe20007ffe0ffULL, 0x000000081a297824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fc400078ee200ULL, 0xfffffff81d1d7812ULL, 0x000fe400078ee202ULL,
0xfffffff81c1f7812ULL, 0x010fe200078ee209ULL, 0x000000082d1c7824ULL, 0x000fe200078e00ffULL,
0x000000051a007810ULL, 0x040fe40007ffe0ffULL, 0x000000061a027810ULL, 0x040fe40007ffe0ffULL,
0xffffffff1a097810ULL, 0x040fe40007ffe0ffULL, 0xfffffff819197812ULL, 0x000fe200078ee21aULL,
0x000000081a1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee200ULL,
0x0000200014007824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fc400078ee202ULL,
0xfffffff81a2b7812ULL, 0x000fe200078ee209ULL, 0x0000100017097824ULL, 0x000fe200078e00ffULL,
0x00000010032f7811ULL, 0x040fe200078ff0ffULL, 0x00000004031a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c2d7812ULL, 0x000fe400078ee22dULL, 0x0000000900027210ULL, 0x000fe20007ffe0ffULL,
0x000000082f1c7824ULL, 0x000fe200078e00ffULL, 0x0000000c1a1a7812ULL, 0x000fe400078ec0ffULL,
0x0000001803317811ULL, 0x000fe200078ff0ffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x00000040410d723eULL, 0x000fe200000010ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0xfffffff81c2f7812ULL, 0x000fe200078ee22fULL, 0x000000101d1d7824ULL, 0x100fe200078e0202ULL,
0x000000666766723eULL, 0x000fe200000010ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x000000323332723eULL, 0x000fe200000010ffULL, 0x0000001025257824ULL, 0x000fe200078e0202ULL,
0x000000363736723eULL, 0x000fe200000010ffULL, 0x0000000119197824ULL, 0x000fe200078e021aULL,
0x0000003a3b3a723eULL, 0x000fe200000010ffULL, 0x0000001027277824ULL, 0x100fe200078e0202ULL,
0x0000003e3f3e723eULL, 0x000fe200000010ffULL, 0x000000011a1b7824ULL, 0x040fe200078e021bULL,
0x0000000419007388ULL, 0x000fe20000000800ULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x000000424342723eULL, 0x000fe200000010ffULL, 0x000000011a1d7824ULL, 0x040fe200078e021dULL,
0x000000051b007388ULL, 0x0003e20000000800ULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0x000000444544723eULL, 0x000fe200000010ffULL, 0x000000011a1f7824ULL, 0x040fe200078e021fULL,
0x000000071d007388ULL, 0x000fe20000000800ULL, 0x000000102d2d7824ULL, 0x100fe200078e0202ULL,
0x000000484948723eULL, 0x000fe200000010ffULL, 0x000000011a257824ULL, 0x040fe200078e0225ULL,
0x000000081f007388ULL, 0x000fe20000000800ULL, 0x000000011a277824ULL, 0x040fe200078e0227ULL,
0x0000004c4d4c723eULL, 0x000fe200000010ffULL, 0x000000011a297824ULL, 0x040fe200078e0229ULL,
0x0000000a25007388ULL, 0x000fe20000000800ULL, 0x000000011a2b7824ULL, 0x040fe200078e022bULL,
0x000000505150723eULL, 0x000fe200000010ffULL, 0x000000011a2d7824ULL, 0x000fe200078e022dULL,
0x0000000b27007388ULL, 0x0005e20000000800ULL, 0x0000000831207824ULL, 0x000fe200078e00ffULL,
0x000000545554723eULL, 0x000fe200000010ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0202ULL,
0x0000000c29007388ULL, 0x000fe20000000800ULL, 0x000000585958723eULL, 0x000fe200000010ffULL,
0x000000ff00057306ULL, 0x002fe20000205400ULL, 0xfffffff820317812ULL, 0x000fe200078ee231ULL,
0x0000000d2b007388ULL, 0x000fe20000000800ULL, 0x000000011a2f7824ULL, 0x000fe200078e022fULL,
0x0000005c5d5c723eULL, 0x000fe200000010ffULL, 0x00000001160b7824ULL, 0x004fe200078e0203ULL,
0x000000662d007388ULL, 0x000fe20000000800ULL, 0x0000000231317211ULL, 0x000fe200078e20ffULL,
0x000000ff00087306ULL, 0x000e620000209400ULL, 0x000000606160723eULL, 0x000fe200000010ffULL,
0x0004002a1b007388ULL, 0x000fe20000000800ULL, 0x00000046470e723eULL, 0x000fe200000010ffULL,
0x000000100b0a7824ULL, 0x000fe200078e0200ULL, 0x000000311a317210ULL, 0x000fe20007ffe0ffULL,
0x0004002e1d007388ULL, 0x000fe20000000800ULL, 0x0000004a4b0f723eULL, 0x000fe200000010ffULL,
0x000000ff00047306ULL, 0x000ea2000020d400ULL, 0x0000004e4f10723eULL, 0x000fe200000010ffULL,
0x000400321f007388ULL, 0x000fe20000000800ULL, 0x000000525311723eULL, 0x000fc400000010ffULL,
0x000000565712723eULL, 0x000fe200000010ffULL, 0x0004003625007388ULL, 0x000fe20000000800ULL,
0x0000005a5b13723eULL, 0x000fe400000010ffULL, 0x0000005e5f15723eULL, 0x000fe200000010ffULL,
0x0004003a27007388ULL, 0x000fe20000000800ULL, 0x000000626318723eULL, 0x000fe400000010ffULL,
0x000000050800720bULL, 0x002fe20003f1d000ULL, 0x0004003e29007388ULL, 0x000fe80000000800ULL,
0x000400422b007388ULL, 0x000fe80000000800ULL, 0x000000442f007388ULL, 0x000fe80000000800ULL,
0x000800481b007388ULL, 0x000fe20000000800ULL, 0x0000000104040812ULL, 0x004fc600078efcffULL,
0x0008004c1d007388ULL, 0x000fe20000000800ULL, 0x000000040407723eULL, 0x000fc600000010ffULL,
0x000800501f007388ULL, 0x000fe80000000800ULL, 0x0008005425007388ULL, 0x000fe80000000800ULL,
0x0008005827007388ULL, 0x000fe80000000800ULL, 0x0008005c29007388ULL, 0x000fe80000000800ULL,
0x000800602b007388ULL, 0x000fe80000000800ULL, 0x0000000e31007388ULL, 0x000fe80000000800ULL,
0x000c000f1b007388ULL, 0x000fe80000000800ULL, 0x000c00101d007388ULL, 0x0003e80000000800ULL,
0x000c00111f007388ULL, 0x000fe80000000800ULL, 0x000c001225007388ULL, 0x000fe20000000800ULL,
0x00000300ff1d7624ULL, 0x002fc600078e00ffULL, 0x000c001327007388ULL, 0x000fe40000000800ULL,
0x000000011d00780cULL, 0x000fe40003f05270ULL, 0x000c001529007388ULL, 0x000fe80000000800ULL,
0x000c00182b007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000a0c7984ULL, 0x000e680000000c00ULL, 0x000400000a307984ULL, 0x000ea80000000c00ULL,
0x000800000a107984ULL, 0x000ee80000000c00ULL, 0x000c00000a187984ULL, 0x000ee80000000c00ULL,
0x001000000a2c7984ULL, 0x000ee80000000c00ULL, 0x001400000a347984ULL, 0x000ee80000000c00ULL,
0x001800000a247984ULL, 0x000ee80000000c00ULL, 0x001c00000a287984ULL, 0x000ee20000000c00ULL,
0x3f803f80070f7831ULL, 0x002fc4000020000fULL, 0x3f803f80070e7831ULL, 0x040fe4000020000eULL,
0x3f803f80070d7831ULL, 0x040fe4000020000dULL, 0x3f803f80070c7831ULL, 0x040fe4000020000cULL,
0x3f803f8007337831ULL, 0x044fe40000200033ULL, 0x3f803f8007327831ULL, 0x040fe40000200032ULL,
0x3f803f8007317831ULL, 0x000fc40000200031ULL, 0x3f803f8007307831ULL, 0x040fe40000200030ULL,
0x3f803f8007137831ULL, 0x048fe40000200013ULL, 0x3f803f8007127831ULL, 0x040fe40000200012ULL,
0x3f803f8007117831ULL, 0x040fe40000200011ULL, 0x3f803f8007107831ULL, 0x040fe40000200010ULL,
0x3f803f80071b7831ULL, 0x000fc4000020001bULL, 0x3f803f80071a7831ULL, 0x040fe4000020001aULL,
0x3f803f8007197831ULL, 0x040fe40000200019ULL, 0x3f803f8007187831ULL, 0x000fe40000200018ULL,
0x3f803f800f0f7831ULL, 0x000fe4000020002fULL, 0x3f803f800e0e7831ULL, 0x000fe4000020002eULL,
0x3f803f800d0d7831ULL, 0x000fc4000020002dULL, 0x3f803f800c0c7831ULL, 0x000fe4000020002cULL,
0x3f803f8033337831ULL, 0x000fe40000200037ULL, 0x3f803f8032327831ULL, 0x000fe20000200036ULL,
0x0000000c0a007388ULL, 0x000fe20000000c00ULL, 0x3f803f8031317831ULL, 0x000fe40000200035ULL,
0x3f803f8030307831ULL, 0x000fe40000200034ULL, 0x3f803f8013137831ULL, 0x000fc40000200027ULL,
0x3f803f8012127831ULL, 0x000fe20000200026ULL, 0x000400300a007388ULL, 0x000fe20000000c00ULL,
0x3f803f8011117831ULL, 0x000fe40000200025ULL, 0x3f803f8010107831ULL, 0x000fe40000200024ULL,
0x3f803f801b1b7831ULL, 0x000fe4000020002bULL, 0x3f803f801a1a7831ULL, 0x000fe2000020002aULL,
0x000800100a007388ULL, 0x000fe20000000c00ULL, 0x3f803f8019197831ULL, 0x000fc40000200029ULL,
0x3f803f8018187831ULL, 0x000fca0000200028ULL, 0x000c00180a007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000395000008947ULL, 0x000fea0003800000ULL,
0x00000400ff057624ULL, 0x000fe200078e00ffULL, 0x0000000000087919ULL, 0x000e620000002600ULL,
0x000000800b0f7810ULL, 0x000fc40007ffe0ffULL, 0x00006a0005057a24ULL, 0x000fe200078e02ffULL,
0x00000000000d7919ULL, 0x000e620000002700ULL, 0x000000c00b117810ULL, 0x000fc60007ffe0ffULL,
0x0000000f05077811ULL, 0x040fe200078e10ffULL, 0x0000030005057a24ULL, 0x000fe200078e02ffULL,
0x000000000a187984ULL, 0x000ea40000000c00ULL, 0xfffffff007207812ULL, 0x000fe400078ec0ffULL,
0x000400000a247984ULL, 0x000ee60000000c00ULL, 0x0000008005227824ULL, 0x040fe200078e0220ULL,
0x000800000a287984ULL, 0x000ea60000000c00ULL, 0x0000008005057824ULL, 0x000fe200078e0222ULL,
0x000c00000a2c7984ULL, 0x0008a80000000c00ULL, 0x0000007f05077810ULL, 0x000fe20007ffe0ffULL,
0x000004000d087a24ULL, 0x002fe200078e0208ULL, 0x000000400b0d7810ULL, 0x000fc40007ffe0ffULL,
0xffffff8007157812ULL, 0x000fe200078ec0ffULL, 0x0000030008057a24ULL, 0x000fc600078e02ffULL,
0x00006e0015077a10ULL, 0x000fe20007f1e0ffULL, 0x0000000105107824ULL, 0x000fca00078e0206ULL,
0x0000000710067211ULL, 0x000fe200078268ffULL, 0x00006f00ff077624ULL, 0x000fe200000e06ffULL,
0x0000000117ff7812ULL, 0x000fc8000780f81eULL, 0x0000000710077211ULL, 0x000fe400008f6cffULL,
0x00006e00201c7a10ULL, 0x000fc60007f3e0ffULL, 0x0000100014067825ULL, 0x000fc800078e0006ULL,
0x00006f00ff307624ULL, 0x000fe400008e06ffULL, 0x000000100b0a7825ULL, 0x010fc800078e0006ULL,
0x000000100d0c7825ULL, 0x000fc800078e0006ULL, 0x000000100f0e7825ULL, 0x000fc800078e0006ULL,
0x0000001011067825ULL, 0x000fe200078e0006ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x0000001003127824ULL, 0x00cfe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe40000011603ULL,
0x0000000710117819ULL, 0x000fe400000006ffULL, 0x00000070121f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c13327812ULL, 0x000fe400078ec0ffULL, 0x00006e0011127a10ULL, 0x000fc40007ebe022ULL,
0x00000019ff137819ULL, 0x000fe40000011610ULL, 0x0000001c1f117210ULL, 0x000fe40007a3e011ULL,
0x0000001232127210ULL, 0x040fe40007c7e01fULL, 0x00006f00131f7a10ULL, 0x000fe40002fec4ffULL,
0x0000001132107210ULL, 0x000fe40007fbe0ffULL, 0x00000030ff117210ULL, 0x000fc40000fe4413ULL,
0x0000001fff137210ULL, 0x000fc60001fe84ffULL, 0x000000ffff117224ULL, 0x000fca00028e0611ULL,
0x0000002110007986ULL, 0x0003e8000c101908ULL, 0x0000002312007986ULL, 0x0003e4000c101908ULL,
0x000000ff0300720cULL, 0x00cfe20000705670ULL, 0x000000180a007986ULL, 0x000fe2000c101d08ULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x000000240c007986ULL, 0x000fe8000c101d08ULL,
0x000000280e007986ULL, 0x000fe8000c101d08ULL, 0x0000002c06007986ULL, 0x000fe8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff077424ULL, 0x000fe200078e00ffULL, 0xffffffff1d0b7810ULL, 0x000fc60007ffe0ffULL,
0x00006e0008067625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000b060679a8ULL, 0x000ea400099ee1c8ULL, 0x0000000b0600720cULL, 0x004fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000008ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff067984ULL, 0x000ee40000000000ULL,
0x000000ff0600720cULL, 0x008fda0003f05270ULL, 0x0000345000008947ULL, 0x000fea0003800000ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x004fe40000011603ULL,
0x0000001c05067211ULL, 0x000fe400078038ffULL, 0x00000070070b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fe400078ec0ffULL, 0x0000003005077211ULL, 0x000fe400000f3cffULL,
0x0000000608067210ULL, 0x000fc8000791e00bULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x00000008060a7981ULL, 0x000528000c1e1900ULL, 0x00008008060b7981ULL, 0x000522000c1e1900ULL,
0x000000021d00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010008060d7981ULL, 0x004522000c1e1900ULL, 0x000000041d00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x00018008060f7981ULL, 0x004522000c1e1900ULL,
0x000000041d00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000806117981ULL, 0x006322000c1e1900ULL, 0x000000061d00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800806137981ULL, 0x002322000c1e1900ULL,
0x000000061d00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081d00780cULL, 0x002fe20003f06070ULL, 0x0003000806197981ULL, 0x000318000c1e1900ULL,
0x00038008061b0981ULL, 0x000324000c1e1900ULL, 0x000000071d067810ULL, 0x006fc80007ffe0ffULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x00000020051f7211ULL, 0x000fe200078038ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1d7224ULL, 0x010fe200078e000aULL, 0x00006e001f1f7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff050c7211ULL, 0x000fe400000f3cffULL, 0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL,
0x00006f00ff0c7a10ULL, 0x000fc400017e240cULL, 0x000003000e007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000408007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x000000080e067810ULL, 0x040fe40007ffe0ffULL,
0x000000010e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001d0a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061f067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffc8008061d7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x000000090e067810ULL, 0x042fe40007ffe0ffULL,
0x000000020e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000b0a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061f067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffd0008060b7981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000030e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061f067210ULL, 0x000fc80007f3e0ffULL,
0x0000000cff077210ULL, 0x000fca0000ffe4ffULL, 0xfffd8008060d7981ULL, 0x000328000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000040e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000f0a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061f067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffe0008060f7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000050e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000110a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061f067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffe800806117981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000060e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000130a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061f067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xffff000806137981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000070e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000190a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061f067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xffff800806197981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e067810ULL, 0x002fe40007ffe0ffULL,
0x0000001b0a0a7209ULL, 0x000fe40007810000ULL, 0x0000030006007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061f067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0x00000008061b7981ULL, 0x000326000c1e1900ULL,
0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL, 0x000000080e0e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000cff0c7210ULL, 0x000fe20000ffe4ffULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003067824ULL, 0x006fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fca00078ec0ffULL, 0x0000000106077824ULL, 0x000fca00078e0207ULL,
0x0000000a07007388ULL, 0x0103e40000000800ULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x0000000117247824ULL, 0x000fe200078e0205ULL, 0x00006e0015067a10ULL, 0x000fe20007f3e0ffULL,
0x0000100014087824ULL, 0x004fe200078e00ffULL, 0x00000001170c7812ULL, 0x000fe200078ec0ffULL,
0x0000001003527824ULL, 0x040fe200078e00ffULL, 0x00000001ff537819ULL, 0x000fe20000011603ULL,
0x00006f00ff077624ULL, 0x002fe200008e06ffULL, 0x0000004003117810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002170d8824ULL, 0x100fe200078e0214ULL,
0x0000006003137810ULL, 0x000fe20007ffe0ffULL, 0x00000002170f8824ULL, 0x000fe200078e0214ULL,
0x0000008003197810ULL, 0x040fe20007ffe0ffULL, 0x00002000240a7825ULL, 0x000fe200078e0006ULL,
0x000000a0031b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000c0031d7810ULL, 0x000fe20007ffe0ffULL, 0x000000020d268824ULL, 0x100fe200078e020cULL,
0x000000080a0a7210ULL, 0x000fe20007f3e0ffULL, 0x000000020f288824ULL, 0x000fe200078e020cULL,
0x00001000090c7812ULL, 0x000fe200078ec0ffULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000017097211ULL, 0x000fe200078e70ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x00000020030f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000828288824ULL, 0x000fe200078e0203ULL,
0x000000e0031f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001090c7824ULL, 0x000fe200078e020cULL,
0x0000007052527812ULL, 0x000fe200078ec0ffULL, 0x000000100f0e7825ULL, 0x000fe200078e000aULL,
0x0000000c53537812ULL, 0x000fe200078ec0ffULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00006e00204f7a10ULL, 0x000fe20007f5e0ffULL, 0x0000001003157824ULL, 0x000fe200078e020cULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000001011107825ULL, 0x100fe200078e000aULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000001013127825ULL, 0x100fe200078e000aULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000001019187825ULL, 0x100fe200078e000aULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000101b1a7825ULL, 0x100fe200078e000aULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000000101d1c7825ULL, 0x100fe200078e000aULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x000000ff00547202ULL, 0x000fe20000000f00ULL, 0x000000101f1e7825ULL, 0x000fc800078e000aULL,
0x00000010030c7825ULL, 0x000fe200078e000aULL, 0x00006e00220b7a10ULL, 0x000fc60007f3e0ffULL,
0x0000000152237824ULL, 0x000fe400078e0253ULL, 0x00006f00ff507624ULL, 0x000fe200008e06ffULL,
0x0000000b24208211ULL, 0x040fe200078238ffULL, 0x00006f00ff517624ULL, 0x000fe200010e06ffULL,
0x00000000230a7984ULL, 0x0002a20000000800ULL, 0x0000004f24228211ULL, 0x040fe200078438ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e00ffULL, 0x0000005024218211ULL, 0x000fe200008f3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c157faeULL, 0x0007e2000b901c48ULL,
0x0000030017007a0cULL, 0x000fc60003f26070ULL, 0x003800000e157faeULL, 0x0009e2000b901c48ULL,
0x0000005124238211ULL, 0x002fe400010f3cffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0058000010157faeULL, 0x0003e8000b901c48ULL, 0x0078000012157faeULL, 0x0003e2000b901c48ULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x00000008260f8824ULL, 0x010fc400078e0203ULL,
0x0098000018157faeULL, 0x0007e2000b901c48ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000001003108825ULL, 0x002fe200078e0020ULL, 0x000085800f0f8811ULL, 0x000fe200078e20ffULL,
0x00b800001a157faeULL, 0x0003e2000b901c48ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000001003128825ULL, 0x000fe400078e0022ULL, 0x00d800001c157faeULL, 0x0009e2000b901c48ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000818028198811ULL, 0x008fc400078e20ffULL,
0x00f800001e157faeULL, 0x0007e2000b901c48ULL, 0x0000000000287805ULL, 0x000fc6000001ff00ULL,
0x00000000100f8faeULL, 0x0005e2000b901c48ULL, 0x00000000001a7805ULL, 0x002fc6000001ff00ULL,
0x0000000012198faeULL, 0x0003e2000b901c48ULL, 0x00000000001c7805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000001e7805ULL, 0x008fe2000001ff00ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x004fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x002fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000012f000001947ULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e00ffULL, 0x000000ffff557224ULL, 0x000fca00078e0017ULL,
0x0000000155567810ULL, 0x000fc80007ffe0ffULL, 0x0000030056007a0cULL, 0x000fda0003f06070ULL,
0x0000034000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x000fe20003f44070ULL,
0x00000001056a7824ULL, 0x000fe200078e0256ULL, 0x0000000156577812ULL, 0x040fe200078ec0ffULL,
0x0000100056567824ULL, 0x000fe200078e00ffULL, 0x0000002003597810ULL, 0x040fe20007ffe0ffULL,
0x000020006a527825ULL, 0x000fe200078e0006ULL, 0x00000040035b7810ULL, 0x000fe40007ffe0ffULL,
0x0000100056567812ULL, 0x000fe400078ec0ffULL, 0x0000000852527210ULL, 0x000fc40007f1e0ffULL,
0x00000060035d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109567824ULL, 0x000fe200078e0256ULL,
0x00000080035f7810ULL, 0x000fe20007ffe0ffULL, 0x000000021768a824ULL, 0x100fe200078e0214ULL,
0x000000a003617810ULL, 0x000fe20007ffe0ffULL, 0x000000021758a824ULL, 0x000fe200078e0214ULL,
0x000000c003637810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff537224ULL, 0x000fe200000e0653ULL,
0x000000e003657810ULL, 0x040fe20007ffe0ffULL, 0x000000026868a824ULL, 0x100fe200078e0257ULL,
0x0000005603697211ULL, 0x040fe200078e20ffULL, 0x00000002586ca824ULL, 0x000fe200078e0257ULL,
0x0000000b6a64a211ULL, 0x040fe200078038ffULL, 0x0000001003567825ULL, 0x000fe200078e0052ULL,
0x0000004f6a66a211ULL, 0x000fc600078238ffULL, 0x0000001059587825ULL, 0x100fe200078e0052ULL,
0x000000516a67a211ULL, 0x000fe200008f3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000056697faeULL, 0x0003e4000b901c48ULL, 0x000000105b5a7825ULL, 0x100fe400078e0052ULL,
0x0038000058697faeULL, 0x0005e4000b901c48ULL, 0x000000105d5c7825ULL, 0x100fe400078e0052ULL,
0x005800005a697faeULL, 0x0007e4000b901c48ULL, 0x000000105f5e7825ULL, 0x000fc400078e0052ULL,
0x007800005c697faeULL, 0x0007e4000b901c48ULL, 0x0000001061607825ULL, 0x100fe400078e0052ULL,
0x009800005e697faeULL, 0x0007e4000b901c48ULL, 0x0000001063627825ULL, 0x100fe400078e0052ULL,
0x00b8000060697faeULL, 0x0007e4000b901c48ULL, 0x0000001065527825ULL, 0x000fe200078e0052ULL,
0x000000506a65a211ULL, 0x000fe200000f3cffULL, 0x00d8000062697faeULL, 0x0007e4000b901c48ULL,
0x000000086868a824ULL, 0x000fc400078e0203ULL, 0x000000086c6ca824ULL, 0x000fe200078e0203ULL,
0x00f8000052697faeULL, 0x0007e2000b901c48ULL, 0x000000100364a825ULL, 0x040fe200078e0064ULL,
0x00008580686ba811ULL, 0x000fe400078e20ffULL, 0x000081806c59a811ULL, 0x004fe200078e20ffULL,
0x000000100356a825ULL, 0x002fe400078e0066ULL, 0x00000000646bafaeULL, 0x0007e8000b901c48ULL,
0x000000005659afaeULL, 0x0007e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000008055527824ULL, 0x008fe200078e00ffULL, 0x00000001ff587819ULL, 0x100fe20000011603ULL,
0x0000000217577824ULL, 0x000fe200078e0214ULL, 0x00000002ff5c7819ULL, 0x000fe20000011603ULL,
0x0000001003537824ULL, 0x000fe200078e00ffULL, 0x0000008052527812ULL, 0x000fc400078ec0ffULL,
0x000000085c6c7810ULL, 0x040fe20007ffe0ffULL, 0x000000085c617824ULL, 0x040fe200078e00ffULL,
0x000000105c6e7810ULL, 0x040fe20007ffe0ffULL, 0x0000010057567824ULL, 0x000fe200078e0052ULL,
0x0000007053527812ULL, 0x000fe200078ec0ffULL, 0x000000085c637824ULL, 0x000fe200078e00ffULL,
0x0000000c58537812ULL, 0x000fe200078ec0ffULL, 0x000000085c5b7824ULL, 0x040fe200078e00ffULL,
0x000000025c587810ULL, 0x000fe20007ffe0ffULL, 0x000000086e5d7824ULL, 0x000fe200078e00ffULL,
0x0000005653577210ULL, 0x000fe20007ffe052ULL, 0x000000085c657824ULL, 0x040fe200078e00ffULL,
0x000000015c567810ULL, 0x040fe20007ffe0ffULL, 0x000000085c677824ULL, 0x040fe200078e00ffULL,
0xfffffff863637812ULL, 0x000fe200078ee258ULL, 0x000000085c6f7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0081800057597984ULL, 0x000e620000000800ULL,
0xfffffff861617812ULL, 0x000fe200078ee256ULL, 0x0000100055567824ULL, 0x000fe200078e00ffULL,
0x0000000203587819ULL, 0x000fe200000006ffULL, 0x00858000575f7984ULL, 0x0004e20000000800ULL,
0x000000035c5a7810ULL, 0x040fe20007ffe0ffULL, 0x000000085c6d7824ULL, 0x000fe200078e00ffULL,
0x0000100056567812ULL, 0x000fe400078ec0ffULL, 0x0000000c58687812ULL, 0x000fe400078ec0ffULL,
0x0000018009567810ULL, 0x000fc40007ffe056ULL, 0xfffffff85b577812ULL, 0x004fe200078ee25cULL,
0x000000086c5b7824ULL, 0x000fe200078e00ffULL, 0x000000185c707810ULL, 0x040fe40007ffe0ffULL,
0xfffffff865657812ULL, 0x000fe200078ee25aULL, 0x0000001057577824ULL, 0x000fe200078e0256ULL,
0x000000045c607810ULL, 0x000fe20007ffe0ffULL, 0x0000000870697824ULL, 0x000fe200078e00ffULL,
0x000000055c627810ULL, 0x000fe20007ffe0ffULL, 0x0000000168577824ULL, 0x000fe200078e0257ULL,
0xfffffff867677812ULL, 0x000fc400078ee260ULL, 0x000000065c607810ULL, 0x040fe40007ffe0ffULL,
0x00000000575e7984ULL, 0x0005220000000800ULL, 0xfffffff86d6d7812ULL, 0x000fe400078ee262ULL,
0xfffffff86f6f7812ULL, 0x000fe400078ee260ULL, 0xffffffff5c627810ULL, 0x000fe40007ffe0ffULL,
0x0000000255557810ULL, 0x000fe20007ffe0ffULL, 0x0000001063577824ULL, 0x004fc600078e0256ULL,
0x0000030055007a0cULL, 0x000fe20003f06070ULL, 0x0000000168577824ULL, 0x000fe400078e0257ULL,
0x000000590a587221ULL, 0x002fe20000010100ULL, 0xfffffff85b597812ULL, 0x000fe400078ee26cULL,
0xfffffff85d5b7812ULL, 0x000fe200078ee26eULL, 0x3fb8aa3b58587820ULL, 0x000fe20000410000ULL,
0xfffffff8695d7812ULL, 0x000fe200078ee270ULL, 0x0000001059597824ULL, 0x100fe400078e0256ULL,
0x00000058005a7308ULL, 0x0002e20000000800ULL, 0x000000105b5b7824ULL, 0x000fc400078e0256ULL,
0x0000005968597210ULL, 0x040fe20007ffe0ffULL, 0x000000105d5d7824ULL, 0x100fe400078e0256ULL,
0x00000001685b7824ULL, 0x040fe400078e025bULL, 0x0000000059697984ULL, 0x0005e20000000800ULL,
0x00000001685d7824ULL, 0x040fe400078e025dULL, 0x0000001061587824ULL, 0x002fe200078e0256ULL,
0x000000005b6a7984ULL, 0x0003e60000000800ULL, 0x0000000168587824ULL, 0x000fe200078e0258ULL,
0x000000005d6b7984ULL, 0x0009e20000000800ULL, 0x0000005f5a5f7220ULL, 0x008fe20000410000ULL,
0x00000056675a7211ULL, 0x000fe200078e20ffULL, 0x0000001065597824ULL, 0x004fe200078e0256ULL,
0x0000000058647984ULL, 0x000fe20000000800ULL, 0x000000085c5b7824ULL, 0x002fc400078e00ffULL,
0x0000000168597824ULL, 0x040fe200078e0259ULL, 0x00001f5c5f607589ULL, 0x0002a200000e0000ULL,
0x00000001685a7824ULL, 0x040fe200078e025aULL, 0xfffffff85b5d7812ULL, 0x010fe200078ee262ULL,
0x000000106d5b7824ULL, 0x000fe200078e0256ULL, 0x00001f6c5f617589ULL, 0x000ee200000e0000ULL,
0x000000545f547221ULL, 0x000fe40000010000ULL, 0x00000001685b7824ULL, 0x000fe200078e025bULL,
0x00001f6e5f627589ULL, 0x000f2200000e0000ULL, 0x000000106f5c7824ULL, 0x002fc400078e0256ULL,
0x000000105d567824ULL, 0x000fe200078e0256ULL, 0x00005410ff5d7816ULL, 0x000fe2000000005eULL,
0x0000000057657984ULL, 0x000fe20000000800ULL, 0x00000001685c7824ULL, 0x040fe200078e025cULL,
0x00007610ff5e7816ULL, 0x000fe2000000005eULL, 0x0000000168567824ULL, 0x000fe200078e0256ULL,
0x00001f705f637589ULL, 0x000e6800000e0000ULL, 0x0000000059667984ULL, 0x000e620000000800ULL,
0x000000605d4e7223ULL, 0x004fe2000001004eULL, 0x00007610ff5d7816ULL, 0x000fc40000000069ULL,
0x000000005a677984ULL, 0x000ea20000000800ULL, 0x000000605e4d7223ULL, 0x000fe2000001004dULL,
0x00005410ff5e7816ULL, 0x000fe20000000069ULL, 0x000000615d427223ULL, 0x088fe20000010042ULL,
0x00005410ff5d7816ULL, 0x000fe2000000006aULL, 0x000000005b687984ULL, 0x000ee40000000800ULL,
0x000000615e157223ULL, 0x000fe40000010015ULL, 0x000000625d227223ULL, 0x010fe20000010022ULL,
0x00007610ff5d7816ULL, 0x000fe2000000006aULL, 0x000000005c5f7984ULL, 0x000f220000000800ULL,
0x00007610ff5e7816ULL, 0x000fc60000000064ULL, 0x000000625d3a7223ULL, 0x000fe2000001003aULL,
0x00005410ff5d7816ULL, 0x000fe2000000006bULL, 0x0000000056697984ULL, 0x000f220000000800ULL,
0x000000605e4b7223ULL, 0x000fc6000001004bULL, 0x000000635d207223ULL, 0x082fe20000010020ULL,
0x00007610ff5d7816ULL, 0x000fe2000000006bULL, 0x00040000586a7984ULL, 0x000e680000000800ULL,
0x000000635d327223ULL, 0x000fe20000010032ULL, 0x00005410ff5d7816ULL, 0x000fe20000000064ULL,
0x00040000576b7984ULL, 0x000e620000000800ULL, 0x00007610ff5e7816ULL, 0x000fc60000000065ULL,
0x0004000059647984ULL, 0x000e620000000800ULL, 0x000000605d4c7223ULL, 0x080fe2000001004cULL,
0x00005410ff5d7816ULL, 0x000fe20000000065ULL, 0x000000605e497223ULL, 0x080fe20000010049ULL,
0x00007610ff5e7816ULL, 0x000fe20000000066ULL, 0x000400005a657984ULL, 0x000e640000000800ULL,
0x000000605d4a7223ULL, 0x080fe2000001004aULL, 0x00005410ff5d7816ULL, 0x000fe20000000066ULL,
0x000000605e477223ULL, 0x000fe20000010047ULL, 0x000400005b667984ULL, 0x000e620000000800ULL,
0x00007610ff5e7816ULL, 0x004fc40000000067ULL, 0x000000605d487223ULL, 0x080fe20000010048ULL,
0x00005410ff5d7816ULL, 0x000fe40000000067ULL, 0x000000605e457223ULL, 0x080fe20000010045ULL,
0x00007610ff5e7816ULL, 0x008fe20000000068ULL, 0x000400005c677984ULL, 0x000ea20000000800ULL,
0x000000605d467223ULL, 0x080fe20000010046ULL, 0x00005410ff5d7816ULL, 0x000fe40000000068ULL,
0x0004000056687984ULL, 0x000ee20000000800ULL, 0x000000605e197223ULL, 0x080fe20000010019ULL,
0x00005410ff5e7816ULL, 0x110fe2000000005fULL, 0x000000605d2c7223ULL, 0x000fe2000001002cULL,
0x00007610ff5d7816ULL, 0x000fc4000000005fULL, 0x00080000585f7984ULL, 0x000fe20000000800ULL,
0x000000605e2b7223ULL, 0x080fe2000001002bULL, 0x00007610ff5e7816ULL, 0x100fe20000000069ULL,
0x000000605d447223ULL, 0x080fe20000010044ULL, 0x00005410ff5d7816ULL, 0x000fe40000000069ULL,
0x000c000058697984ULL, 0x0008e20000000800ULL, 0x000000605e437223ULL, 0x080fe20000010043ULL,
0x00005410ff5e7816ULL, 0x002fe2000000006aULL, 0x000000605d2a7223ULL, 0x000fe2000001002aULL,
0x00005410ff5d7816ULL, 0x000fe2000000006bULL, 0x000800005a607984ULL, 0x000fe40000000800ULL,
0x000000615e297223ULL, 0x080fe20000010029ULL, 0x00007610ff587816ULL, 0x010fe2000000006aULL,
0x00080000575e7984ULL, 0x000e620000000800ULL, 0x000000615d287223ULL, 0x000fe20000010028ULL,
0x00007610ff5d7816ULL, 0x000fc4000000006bULL, 0x0000006158417223ULL, 0x080fe20000010041ULL,
0x00005410ff587816ULL, 0x000fe20000000064ULL, 0x000c0000576a7984ULL, 0x0008620000000800ULL,
0x000000615d407223ULL, 0x000fc60000010040ULL, 0x0000006158277223ULL, 0x000fe20000010027ULL,
0x00007610ff587816ULL, 0x000fe20000000064ULL, 0x00080000595d7984ULL, 0x000e620000000800ULL,
0x00005410ff577816ULL, 0x010fc60000000065ULL, 0x00000061583f7223ULL, 0x080fe2000001003fULL,
0x00005410ff587816ULL, 0x000fe20000000066ULL, 0x000c000059647984ULL, 0x000f220000000800ULL,
0x0000006157267223ULL, 0x080fe20000010026ULL, 0x00007610ff577816ULL, 0x000fe40000000065ULL,
0x0000006158257223ULL, 0x080fe20000010025ULL, 0x00007610ff587816ULL, 0x000fe20000000066ULL,
0x000c00005a657984ULL, 0x000f220000000800ULL, 0x00000061573e7223ULL, 0x000fe2000001003eULL,
0x00005410ff577816ULL, 0x004fc40000000067ULL, 0x00000061583d7223ULL, 0x080fe2000001003dULL,
0x00005410ff587816ULL, 0x008fe20000000068ULL, 0x000800005b597984ULL, 0x000ea20000000800ULL,
0x0000006157247223ULL, 0x080fe20000010024ULL, 0x00007610ff577816ULL, 0x000fe40000000067ULL,
0x0000006158237223ULL, 0x080fe20000010023ULL, 0x00007610ff587816ULL, 0x000fe20000000068ULL,
0x000800005c5a7984ULL, 0x000fe20000000800ULL, 0x00000061573c7223ULL, 0x000fe2000001003cULL,
0x00005410ff577816ULL, 0x000fc40000000069ULL, 0x00000061583b7223ULL, 0x000fe2000001003bULL,
0x00005410ff587816ULL, 0x000fe2000000005fULL, 0x000c00005b617984ULL, 0x000ee20000000800ULL,
0x0000006357187223ULL, 0x000fe20000010018ULL, 0x00007610ff577816ULL, 0x002fe4000000005eULL,
0x0000006258217223ULL, 0x080fe20000010021ULL, 0x00007610ff587816ULL, 0x000fe2000000005fULL,
0x00080000565b7984ULL, 0x000e620000000800ULL, 0x0000006257387223ULL, 0x000fe20000010038ULL,
0x00007610ff577816ULL, 0x000fc4000000006aULL, 0x0000006258397223ULL, 0x080fe20000010039ULL,
0x00007610ff587816ULL, 0x000fe20000000069ULL, 0x000c00005c5f7984ULL, 0x000fe20000000800ULL,
0x0000006357307223ULL, 0x080fe20000010030ULL, 0x00005410ff577816ULL, 0x000fe4000000005dULL,
0x0000006358317223ULL, 0x000fe20000010031ULL, 0x00005410ff587816ULL, 0x000fe4000000005eULL,
0x00000062571e7223ULL, 0x000fe2000001001eULL, 0x00005410ff577816ULL, 0x010fc40000000064ULL,
0x00000062581f7223ULL, 0x080fe2000001001fULL, 0x00005410ff587816ULL, 0x000fe4000000006aULL,
0x0000006357127223ULL, 0x080fe20000010012ULL, 0x00007610ff577816ULL, 0x000fe40000000060ULL,
0x0000006358137223ULL, 0x000fe40000010013ULL, 0x000c000056587984ULL, 0x0008620000000800ULL,
0x0000006257367223ULL, 0x000fe20000010036ULL, 0x00007610ff577816ULL, 0x000fca0000000065ULL,
0x00000063572e7223ULL, 0x000fe2000001002eULL, 0x00007610ff567816ULL, 0x010fe4000000005dULL,
0x00005410ff577816ULL, 0x004fc60000000059ULL, 0x0000006256377223ULL, 0x080fe20000010037ULL,
0x00007610ff567816ULL, 0x000fe20000000064ULL, 0x00000062571c7223ULL, 0x000fe2000001001cULL,
0x00005410ff577816ULL, 0x008fc60000000061ULL, 0x00000063562f7223ULL, 0x080fe2000001002fULL,
0x00005410ff567816ULL, 0x000fe20000000060ULL, 0x0000006357107223ULL, 0x000fe20000010010ULL,
0x00007610ff577816ULL, 0x000fc6000000005aULL, 0x00000062561d7223ULL, 0x080fe2000001001dULL,
0x00005410ff567816ULL, 0x000fe20000000065ULL, 0x0000006257347223ULL, 0x000fe20000010034ULL,
0x00005410ff577816ULL, 0x002fc6000000005bULL, 0x0000006356117223ULL, 0x000fe20000010011ULL,
0x00007610ff567816ULL, 0x000fe20000000059ULL, 0x00000062571a7223ULL, 0x000fc8000001001aULL,
0x0000006256357223ULL, 0x000fe20000010035ULL, 0x00007610ff567816ULL, 0x000fe40000000061ULL,
0x00005410ff577816ULL, 0x000fc60000000058ULL, 0x00000063560f7223ULL, 0x080fe2000001000fULL,
0x00005410ff567816ULL, 0x000fe2000000005aULL, 0x00000063570e7223ULL, 0x000fe2000001000eULL,
0x00007610ff577816ULL, 0x000fc60000000058ULL, 0x00000062561b7223ULL, 0x000fe2000001001bULL,
0x00005410ff567816ULL, 0x000fe2000000005fULL, 0x00000063570c7223ULL, 0x000fc8000001000cULL,
0x00000063560d7223ULL, 0x000fe2000001000dULL, 0x00007610ff567816ULL, 0x000fca000000005fULL,
0x00000063562d7223ULL, 0x000fe2000001002dULL, 0x00007610ff567816ULL, 0x000fca000000005bULL,
0x0000006256337223ULL, 0x000fe20000010033ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffed3000007947ULL, 0x000fea000383ffffULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x0000017000007945ULL, 0x000fd80003800000ULL, 0x0000008017068824ULL, 0x000fe200078e0252ULL,
0x0000005352527210ULL, 0x000fc60007ffe0ffULL, 0x0000000153038824ULL, 0x000fca00078e0206ULL,
0x0089805403008388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0089800052057984ULL, 0x000e680000000800ULL, 0x008a000052067984ULL, 0x000ea20000000800ULL,
0x00000005ff057221ULL, 0x002fc80000010000ULL, 0x0000000605057221ULL, 0x004fca0000010000ULL,
0x0180000005067810ULL, 0x000fc80007ffe0ffULL, 0x7f80000006067812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0600780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000d63000087802ULL, 0x000fc40000000f00ULL,
0x0000d5c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff067224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000500067308ULL, 0x000e640000001000ULL,
0xbf80000005037423ULL, 0x002fc80000000006ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000306067223ULL, 0x000fc40000000006ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x000000040404723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff517819ULL, 0x004fe40000011603ULL,
0x0000000803537811ULL, 0x040fe400078ff0ffULL, 0x0000001003557811ULL, 0x040fe200078ff0ffULL,
0x00001f5106057589ULL, 0x002e6200000e0000ULL, 0x0000001803577811ULL, 0x000fe200078ff0ffULL,
0x0000000851507824ULL, 0x000fc400078e00ffULL, 0x00001f5306087589ULL, 0x000ea200000e0000ULL,
0x00000008515b7824ULL, 0x000fc600078e00ffULL, 0x00001f55064f7589ULL, 0x000ee200000e0000ULL,
0x0000004e054e7220ULL, 0x042fe40000410000ULL, 0x0000004d054d7220ULL, 0x040fe40000410000ULL,
0x0000004c054c7220ULL, 0x040fe40000410000ULL, 0x0000004b054b7220ULL, 0x000fe20000410000ULL,
0x0000004e4d4d723eULL, 0x000fe200000010ffULL, 0x0000004a054a7220ULL, 0x040fe40000410000ULL,
0x0000004905497220ULL, 0x000fe20000410000ULL, 0x0000004c4b4b723eULL, 0x000fe200000010ffULL,
0x0000004805487220ULL, 0x000fc40000410000ULL, 0x0000004705477220ULL, 0x000fe20000410000ULL,
0x0000004a4949723eULL, 0x000fe200000010ffULL, 0x0000004605467220ULL, 0x040fe40000410000ULL,
0x0000004505457220ULL, 0x000fe20000410000ULL, 0x000000484747723eULL, 0x000fe200000010ffULL,
0x0000002c052c7220ULL, 0x040fe40000410000ULL, 0x0000001905197220ULL, 0x000fe20000410000ULL,
0x000000464545723eULL, 0x000fe200000010ffULL, 0x0000002b052b7220ULL, 0x000fc40000410000ULL,
0x0000004405447220ULL, 0x000fe20000410000ULL, 0x0000002c1919723eULL, 0x000fe200000010ffULL,
0x0000002a052a7220ULL, 0x040fe40000410000ULL, 0x0000004305057220ULL, 0x000fe20000410000ULL,
0x0000002b442b723eULL, 0x000fe200000010ffULL, 0x00001f5706437589ULL, 0x00032200000e0000ULL,
0x0000004008077220ULL, 0x044fe40000410000ULL, 0x0000001508157220ULL, 0x040fe20000410000ULL,
0x0000002a0505723eULL, 0x000fe200000010ffULL, 0x0000004208427220ULL, 0x000fc40000410000ULL,
0x0000002908297220ULL, 0x040fe40000410000ULL, 0x00000041080a7220ULL, 0x040fe20000410000ULL,
0x0000000351417810ULL, 0x000fe20007ffe0ffULL, 0x0000002808287220ULL, 0x000fe20000410000ULL,
0x000000154215723eULL, 0x000fe200000010ffULL, 0x0000002708277220ULL, 0x000fe20000410000ULL,
0xfffffff850417812ULL, 0x000fe200078ee241ULL, 0x0000003f08407220ULL, 0x040fe20000410000ULL,
0x000000280707723eULL, 0x000fe200000010ffULL, 0x0000002608267220ULL, 0x000fe20000410000ULL,
0x000000290a0a723eULL, 0x000fe200000010ffULL, 0x0000003e08097220ULL, 0x040fe20000410000ULL,
0x00000002513e7810ULL, 0x000fe20007ffe0ffULL, 0x0000002508257220ULL, 0x000fe20000410000ULL,
0x000000274027723eULL, 0x000fe200000010ffULL, 0x0000003d08067220ULL, 0x042fe20000410000ULL,
0x000000260909723eULL, 0x000fe200000010ffULL, 0x0000002408247220ULL, 0x000fc40000410000ULL,
0x0000003c080b7220ULL, 0x040fe20000410000ULL, 0x00000001513c7810ULL, 0x000fe20007ffe0ffULL,
0x0000002308237220ULL, 0x000fe20000410000ULL, 0x000000250606723eULL, 0x000fe200000010ffULL,
0x0000003b08087220ULL, 0x000fe20000410000ULL, 0x000000240b0b723eULL, 0x000fe200000010ffULL,
0x00000008513f7824ULL, 0x000fe400078e00ffULL, 0x0000003a4f3b7220ULL, 0x048fe20000410000ULL,
0x000000230808723eULL, 0x000fe200000010ffULL, 0x000000394f3a7220ULL, 0x000fe20000410000ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee23eULL, 0x0000003243397220ULL, 0x010fc40000410000ULL,
0x000000224f227220ULL, 0x040fe40000410000ULL, 0x000000214f217220ULL, 0x040fe40000410000ULL,
0x0000001f4f1f7220ULL, 0x000fe20000410000ULL, 0x000000223b22723eULL, 0x000fe200000010ffULL,
0x000000384f387220ULL, 0x040fe20000410000ULL, 0x000000213a21723eULL, 0x000fe200000010ffULL,
0x0000001e4f1e7220ULL, 0x040fe40000410000ULL, 0x000000374f377220ULL, 0x040fe20000410000ULL,
0x0000001f381f723eULL, 0x000fe200000010ffULL, 0x0000001d4f1d7220ULL, 0x000fc40000410000ULL,
0x000000364f367220ULL, 0x000fe20000410000ULL, 0x0000001e371e723eULL, 0x000fe200000010ffULL,
0x0000001c4f1c7220ULL, 0x040fe40000410000ULL, 0x000000354f357220ULL, 0x040fe20000410000ULL,
0x0000001d361d723eULL, 0x000fe200000010ffULL, 0x0000001b4f1b7220ULL, 0x040fe40000410000ULL,
0x000000344f347220ULL, 0x000fe20000410000ULL, 0x0000001c351c723eULL, 0x000fe200000010ffULL,
0x0000001a4f1a7220ULL, 0x000fc40000410000ULL, 0x000000334f337220ULL, 0x000fe20000410000ULL,
0x0000001b341b723eULL, 0x000fe200000010ffULL, 0x0000002043207220ULL, 0x040fe40000410000ULL,
0x0000001843187220ULL, 0x000fe20000410000ULL, 0x0000001a331a723eULL, 0x000fe200000010ffULL,
0x0000003143317220ULL, 0x000fe20000410000ULL, 0x000000203920723eULL, 0x000fe200000010ffULL,
0x0000001343137220ULL, 0x040fe40000410000ULL, 0x0000003043307220ULL, 0x000fe20000410000ULL,
0x000000183118723eULL, 0x000fe200000010ffULL, 0x0000001243127220ULL, 0x000fc40000410000ULL,
0x0000002f432f7220ULL, 0x040fe20000410000ULL, 0x000000133013723eULL, 0x000fe200000010ffULL,
0x0000001143117220ULL, 0x040fe40000410000ULL, 0x0000002e432e7220ULL, 0x000fe20000410000ULL,
0x000000122f12723eULL, 0x000fe200000010ffULL, 0x0000001043107220ULL, 0x040fe40000410000ULL,
0x0000000f430f7220ULL, 0x040fe20000410000ULL, 0x000000112e11723eULL, 0x000fe200000010ffULL,
0x0000000d430d7220ULL, 0x000fc40000410000ULL, 0x0000002d43327220ULL, 0x000fe20000410000ULL,
0x00000005512d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000e430e7220ULL, 0x000fe20000410000ULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x00000008513d7824ULL, 0x000fe200078e00ffULL,
0xfffffff850597812ULL, 0x000fe200078ee22dULL, 0x0000000c43437220ULL, 0x000fe20000410000ULL,
0x00000004510c7810ULL, 0x040fe20007ffe0ffULL, 0x00000008514f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee23cULL, 0x00000008513e7824ULL, 0x040fe200078e00ffULL,
0x00000006513c7810ULL, 0x000fe20007ffe0ffULL, 0x000000103f3f7824ULL, 0x000fe200078e0202ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee20cULL, 0x000000103d3d7824ULL, 0x100fe200078e0202ULL,
0xffffffff510c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001041417824ULL, 0x000fe200078e0202ULL,
0xfffffff83e2d7812ULL, 0x000fe200078ee251ULL, 0x0000000851517824ULL, 0x000fe200078e00ffULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee23cULL, 0x00000008533c7824ULL, 0x000fe200078e00ffULL,
0x0000000357507819ULL, 0x000fe200000006ffULL, 0x00000008553e7824ULL, 0x000fe200078e00ffULL,
0xfffffff851517812ULL, 0x000fe200078ee20cULL, 0x00000004030c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c537812ULL, 0x000fe200078ee253ULL, 0x000000102d2d7824ULL, 0x100fe200078e0202ULL,
0xfffffff850577812ULL, 0x000fe200078ee257ULL, 0x000000104f4f7824ULL, 0x100fe200078e0202ULL,
0xfffffff83e557812ULL, 0x000fe200078ee255ULL, 0x0000001059597824ULL, 0x100fe200078e0202ULL,
0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000105b5b7824ULL, 0x100fe200078e0202ULL,
0x0000000255557211ULL, 0x000fe200078e20ffULL, 0x0000001051517824ULL, 0x100fe200078e0202ULL,
0x0000000d320d723eULL, 0x000fe200000010ffULL, 0x0000001053537824ULL, 0x100fe200078e0202ULL,
0x000000550c557210ULL, 0x000fe20007ffe0ffULL, 0x0000001057577824ULL, 0x000fe200078e0202ULL,
0x0000000e430e723eULL, 0x000fe200000010ffULL, 0x000000012d027824ULL, 0x000fc400078e020cULL,
0x000000010c3d7824ULL, 0x040fe400078e023dULL, 0x000000010c107824ULL, 0x040fe200078e023fULL,
0x0000004d02007388ULL, 0x000fe20000000800ULL, 0x000000010c417824ULL, 0x040fe400078e0241ULL,
0x000000010c287824ULL, 0x040fe200078e024fULL, 0x0000004b3d007388ULL, 0x000fe20000000800ULL,
0x000000010c597824ULL, 0x040fe400078e0259ULL, 0x000000010c307824ULL, 0x040fe200078e025bULL,
0x0000004910007388ULL, 0x000fe20000000800ULL, 0x000000010c517824ULL, 0x000fc400078e0251ULL,
0x000000010c247824ULL, 0x040fe200078e0253ULL, 0x0000004741007388ULL, 0x000fe20000000800ULL,
0x000000010c577824ULL, 0x000fc600078e0257ULL, 0x0000004528007388ULL, 0x000fe80000000800ULL,
0x0000001959007388ULL, 0x000fe80000000800ULL, 0x0000002b30007388ULL, 0x000fe80000000800ULL,
0x0000000551007388ULL, 0x0003e80000000800ULL, 0x0000001524007388ULL, 0x000fe80000000800ULL,
0x0004000a3d007388ULL, 0x000fe20000000800ULL, 0x0000000116057824ULL, 0x002fc600078e0203ULL,
0x0004000710007388ULL, 0x000fe20000000800ULL, 0x0000001005057824ULL, 0x000fc600078e0200ULL,
0x0004002741007388ULL, 0x000fe80000000800ULL, 0x0004000928007388ULL, 0x000fe80000000800ULL,
0x0004000659007388ULL, 0x000fe80000000800ULL, 0x0004000b30007388ULL, 0x000fe80000000800ULL,
0x0004000851007388ULL, 0x000fe80000000800ULL, 0x0000002255007388ULL, 0x000fe80000000800ULL,
0x000800213d007388ULL, 0x000fe80000000800ULL, 0x0008001f10007388ULL, 0x000fe80000000800ULL,
0x0008001e41007388ULL, 0x000fe80000000800ULL, 0x0008001d28007388ULL, 0x000fe80000000800ULL,
0x0008001c59007388ULL, 0x000fe80000000800ULL, 0x0008001b30007388ULL, 0x000fe80000000800ULL,
0x0008001a51007388ULL, 0x000fe80000000800ULL, 0x0000002057007388ULL, 0x000fe80000000800ULL,
0x000c00183d007388ULL, 0x000fe80000000800ULL, 0x000c001310007388ULL, 0x000fe80000000800ULL,
0x000c001241007388ULL, 0x000fe80000000800ULL, 0x000c001128007388ULL, 0x000fe80000000800ULL,
0x000c000f59007388ULL, 0x000fe80000000800ULL, 0x000c000d30007388ULL, 0x000fe80000000800ULL,
0x000c000e51007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000005087984ULL, 0x000e680000000c00ULL, 0x00040000051c7984ULL, 0x000ea80000000c00ULL,
0x0008000005247984ULL, 0x000ee80000000c00ULL, 0x000c000005287984ULL, 0x000f280000000c00ULL,
0x0010000005187984ULL, 0x000ee80000000c00ULL, 0x0014000005207984ULL, 0x000f280000000c00ULL,
0x0018000005107984ULL, 0x000f280000000c00ULL, 0x001c0000052c7984ULL, 0x000f220000000c00ULL,
0x3f803f80040b7831ULL, 0x002fc4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x040fe40000200008ULL,
0x3f803f80041f7831ULL, 0x044fe4000020001fULL, 0x3f803f80041e7831ULL, 0x040fe4000020001eULL,
0x3f803f80041d7831ULL, 0x000fc4000020001dULL, 0x3f803f80041c7831ULL, 0x040fe4000020001cULL,
0x3f803f8004277831ULL, 0x048fe40000200027ULL, 0x3f803f8004267831ULL, 0x040fe40000200026ULL,
0x3f803f8004257831ULL, 0x040fe40000200025ULL, 0x3f803f8004247831ULL, 0x040fe40000200024ULL,
0x3f803f80042b7831ULL, 0x010fc4000020002bULL, 0x3f803f80042a7831ULL, 0x040fe4000020002aULL,
0x3f803f8004297831ULL, 0x040fe40000200029ULL, 0x3f803f8004287831ULL, 0x000fe40000200028ULL,
0x3f803f800b0b7831ULL, 0x000fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe4000020001aULL,
0x3f803f8009097831ULL, 0x000fc40000200019ULL, 0x3f803f8008087831ULL, 0x000fe40000200018ULL,
0x3f803f801f1f7831ULL, 0x000fe40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x0000000805007388ULL, 0x000fe20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fe40000200021ULL,
0x3f803f801c1c7831ULL, 0x000fe40000200020ULL, 0x3f803f8027277831ULL, 0x000fc40000200013ULL,
0x3f803f8026267831ULL, 0x000fe20000200012ULL, 0x0004001c05007388ULL, 0x000fe20000000c00ULL,
0x3f803f8025257831ULL, 0x000fe40000200011ULL, 0x3f803f8024247831ULL, 0x000fe40000200010ULL,
0x3f803f802b2b7831ULL, 0x000fe4000020002fULL, 0x3f803f802a2a7831ULL, 0x000fe2000020002eULL,
0x0008002405007388ULL, 0x000fe20000000c00ULL, 0x3f803f8029297831ULL, 0x000fc4000020002dULL,
0x3f803f8028287831ULL, 0x000fca000020002cULL, 0x000c002805007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff1700720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x000fc80000011603ULL,
0x000000810200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000000102047824ULL, 0x000fe200078e0203ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x0000002083027824ULL, 0x000fe200078e0202ULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x00000020030d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000580000067ab9ULL, 0x000fe20000000800ULL, 0x0000000703077812ULL, 0x000fc400078ec0ffULL,
0x0ffffff804057812ULL, 0x000fc600078ef803ULL, 0x0000000814077824ULL, 0x000fe400078e0207ULL,
0x0000001005047824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000004087984ULL, 0x0045220000000c00ULL,
0x0000000182057824ULL, 0x000fe200078e0205ULL, 0x00000006040472a4ULL, 0x008fc6000f8e023fULL,
0x0000008502057224ULL, 0x000fc600078e0205ULL, 0x0000000485067c24ULL, 0x000fca000f8e02ffULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x004fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc6000001160dULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0105f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x104fe200078e0202ULL,
0x00000040030f7810ULL, 0x000fe20007ffe0ffULL, 0x0000002083027824ULL, 0x000fc600078e0202ULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804057812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000005077211ULL, 0x000fe400078e20ffULL,
0x0000000502057c12ULL, 0x000fe2000f8e30ffULL, 0x00000008140d7824ULL, 0x000fe200078e020dULL,
0x00005a00ff027a19ULL, 0x000fe20000011602ULL, 0x0000000007087984ULL, 0x000ea40000000c00ULL,
0x0000000182057824ULL, 0x000fc800078e0205ULL, 0x0000008502057224ULL, 0x000fca00078e0205ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc6000001160fULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0045f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010f047824ULL, 0x104fe200078e0202ULL,
0x0000006003117810ULL, 0x002fe20007ffe0ffULL, 0x0000002083027824ULL, 0x000fe200078e0202ULL,
0x000000070f0d7812ULL, 0x000fc400078ec0ffULL, 0x0000000704047812ULL, 0x000fc600078ec0ffULL,
0x00000008140d7824ULL, 0x000fe200078e020dULL, 0x0ffffff804057812ULL, 0x000fca00078ef80fULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000000182057824ULL, 0x000fc800078e0205ULL, 0x0000008502057224ULL, 0x000fca00078e0205ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc60000011611ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000211047210ULL, 0x002fe20007ffe0ffULL,
0x0000002083027824ULL, 0x000fe200078e0202ULL, 0x00000080030f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000007110d7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff804057812ULL, 0x000fc600078ef811ULL, 0x00000008140d7824ULL, 0x000fe400078e020dULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000000182057824ULL, 0x000fc800078e0205ULL, 0x0000008502057224ULL, 0x000fca00078e0205ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc6000001160fULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010f047824ULL, 0x102fe200078e0202ULL,
0x000000a003117810ULL, 0x000fe20007ffe0ffULL, 0x0000002083027824ULL, 0x000fe200078e0202ULL,
0x000000070f0d7812ULL, 0x000fc400078ec0ffULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000000d140d7211ULL, 0x000fe400078e18ffULL, 0x0ffffff804057812ULL, 0x000fca00078ef80fULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000000182057824ULL, 0x000fc800078e0205ULL, 0x0000008502057224ULL, 0x000fca00078e0205ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc60000011611ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000111047824ULL, 0x102fe200078e0202ULL,
0x000000c0030f7810ULL, 0x000fe20007ffe0ffULL, 0x0000002083027824ULL, 0x000fe200078e0202ULL,
0x00000007110d7812ULL, 0x000fc400078ec0ffULL, 0x0000000704047812ULL, 0x000fc600078ec0ffULL,
0x00000008140d7824ULL, 0x000fe200078e020dULL, 0x0ffffff804057812ULL, 0x000fca00078ef811ULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000000182057824ULL, 0x000fc800078e0205ULL, 0x0000008502057224ULL, 0x000fca00078e0205ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc6000001160fULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010f047824ULL, 0x102fe200078e0202ULL,
0x000000e0030d7810ULL, 0x000fe20007ffe0ffULL, 0x0000002083027824ULL, 0x000fc600078e0202ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0000000502077c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff804057812ULL, 0x000fe400078ef80fULL, 0x00005a00ff027a19ULL, 0x000fe20000011602ULL,
0x0000000182077824ULL, 0x000fe200078e0207ULL, 0x00000003ff047819ULL, 0x000fe2000001160dULL,
0x0000001005057824ULL, 0x000fe400078e0200ULL, 0x0000008502077224ULL, 0x000fc600078e0207ULL,
0x0000000005087984ULL, 0x0002a40000000c00ULL, 0x00000007060c7210ULL, 0x000fe40007f1e0ffULL,
0x000000070f077812ULL, 0x000fe400078ec0ffULL, 0x000000ffff037210ULL, 0x000fe400007fe4ffULL,
0x00005c000c027a11ULL, 0x000fe200078040ffULL, 0x0000000814077824ULL, 0x000fe400078e0207ULL,
0x000000010d057824ULL, 0x002fe200078e0204ULL, 0x00005d000c037a11ULL, 0x000fc400000f4403ULL,
0x000000810400720cULL, 0x000fe40003f06070ULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x0000001007027825ULL, 0x000fc600078e0002ULL, 0xfffffff805057812ULL, 0x000fe400078ef80dULL,
0x0000000802007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001005007824ULL, 0x000fe200078e0200ULL, 0x000000070d057812ULL, 0x000fe200078ec0ffULL,
0x0000002083047824ULL, 0x000fc600078e0204ULL, 0x0000000000087984ULL, 0x002e620000000c00ULL,
0x0000000814057824ULL, 0x000fe200078e0205ULL, 0x0000000504037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fc60000011604ULL, 0x0000000182037824ULL, 0x000fc800078e0203ULL,
0x0000008504037224ULL, 0x000fca00078e0203ULL, 0x0000000306037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff047819ULL, 0x000fca000001161eULL, 0x000000021d047824ULL, 0x000fca00078e0204ULL,
0x0000001a0400720cULL, 0x000fda0003f06070ULL, 0x00000002a2038824ULL, 0x000fc800078e00ffULL,
0x0000680003088a24ULL, 0x000fe400078e0204ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x0000640008088625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000808038981ULL, 0x000ea2000c1e1900ULL, 0x000000011d027810ULL, 0x000fe20007ffe0ffULL,
0x000000401ea07824ULL, 0x000fe200078e00ffULL, 0x000000070c9f7819ULL, 0x000fe200000006ffULL,
0x00000100ff0d7424ULL, 0x000fe200078e00ffULL, 0x000000190200720cULL, 0x000fe20003f06070ULL,
0x0000008015027824ULL, 0x000fe200078e00ffULL, 0x01e60000ff067f8cULL, 0x002e62000c80043fULL,
0x000001001d0b7824ULL, 0x000fca00078e02a0ULL, 0x0000004002387812ULL, 0x000fe200078ef80bULL,
0x0000009f030a7224ULL, 0x004fc800078e02ffULL, 0x000062000a087625ULL, 0x000fe200078e000dULL,
0x00000c7000008947ULL, 0x000fea0003800000ULL, 0x00000003ff377819ULL, 0x102fe4000001161cULL,
0x0000000b1b0a7217ULL, 0x000fe40007800000ULL, 0x00000004370d7810ULL, 0x040fe40007ffe0ffULL,
0x0000001037137810ULL, 0x040fe20007ffe0ffULL, 0x000000010a187824ULL, 0x000fe200078e0a0bULL,
0x00000008370f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0b7824ULL, 0x040fe200078e021cULL,
0x0000000d380c7210ULL, 0x040fe20007ffe0ffULL, 0x000000080d287824ULL, 0x040fe200078e00ffULL,
0x000000180d00720cULL, 0x000fe20003fa6070ULL, 0x00000001380a7824ULL, 0x000fe200078e0237ULL,
0x00000018372b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000813217824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee20bULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002b38127210ULL, 0x000fc40007ffe0ffULL, 0x0000001437277810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0e7824ULL, 0x100fe200078e021cULL, 0x000000700a157812ULL, 0x000fe200078ef805ULL,
0x00000001130a7824ULL, 0x000fe200078e021cULL, 0x0000001c37337810ULL, 0x000fe20007ffe0ffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0x0000001508147210ULL, 0x000fe20007f1e0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff8212e7812ULL, 0x000fe400078ee20aULL,
0xfffffff8112a7812ULL, 0x000fe200078ee20eULL, 0x00000001380a7824ULL, 0x000fe200078e020fULL,
0x0000000c37117810ULL, 0x000fe20007ffe0ffULL, 0x0000000109157824ULL, 0x000fe200000e060bULL,
0x000000700c177812ULL, 0x000fe200078ef805ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000181300720cULL, 0x000fc40003f06070ULL, 0x0000001708167210ULL, 0x000fe20007f3e0ffULL,
0x00000001110e7824ULL, 0x040fe200078e021cULL, 0x000000700a217812ULL, 0x000fe200078ef805ULL,
0x00000008111f7824ULL, 0x040fe200078e00ffULL, 0x000000181100720cULL, 0x080fe20003f46070ULL,
0x00000001380c7824ULL, 0x000fe200078e0211ULL, 0x0000002108207210ULL, 0x000fe20007f7e0ffULL,
0x0000000109177824ULL, 0x000fe200008e060dULL, 0xfffffff81f2c7812ULL, 0x000fe200078ee20eULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000180f00720cULL, 0x000fc40003f26070ULL,
0x00000020372d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001380e7824ULL, 0x000fe200078e0213ULL,
0x000000700c237812ULL, 0x000fe200078ef805ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x00000024372f7810ULL, 0x000fe40007ffe0ffULL, 0x0000002308227210ULL, 0x000fe20007f9e0ffULL,
0x0000000109217824ULL, 0x000fe200018e060bULL, 0x00000070120b7812ULL, 0x000fe200078ef805ULL,
0x0000000138107824ULL, 0x040fe200078e0227ULL, 0x0000002837317810ULL, 0x040fe20007ffe0ffULL,
0x00000001380a7824ULL, 0x000fe200078e0233ULL, 0x0000000b08127210ULL, 0x000fe20007fde0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000003837357810ULL, 0x000fc60007ffe0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000700e1f7812ULL, 0x000fc600078ef805ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001f080e7210ULL, 0x000fe40007f7e0ffULL,
0x000020001e1f7811ULL, 0x000fe200078e70ffULL, 0x0000000109237824ULL, 0x000fe200020e060dULL,
0x00000070100d7812ULL, 0x100fe200078ef805ULL, 0x00000001370c7824ULL, 0x100fe200078e021cULL,
0x000000700a257812ULL, 0x000fe200078ef805ULL, 0x0000000109137824ULL, 0x040fe200030e0613ULL,
0x0000000d08107210ULL, 0x000fe20007f9e0ffULL, 0x00000001380a7824ULL, 0x000fe200078e022dULL,
0x0000002508247210ULL, 0x000fe20007fde0ffULL, 0x00000001090f7824ULL, 0x040fe200018e060fULL,
0x000000070c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000109117824ULL, 0x000fe200020e0611ULL,
0x000000182700720cULL, 0x0c0fe20003f66070ULL, 0x0000000127267824ULL, 0x100fe200078e021cULL,
0x000000183700720cULL, 0x000fe20003f86070ULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x0ffffff80d0c7812ULL, 0x000fe200078ef81cULL, 0x0000000109257824ULL, 0x000fc400030e060bULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff827307812ULL, 0x000fe400078ee226ULL,
0x0000001f0c297211ULL, 0x000fe200078e20ffULL, 0x00000001380c7824ULL, 0x000fe200078e022fULL,
0x000000700a277812ULL, 0x000fe200078ef805ULL, 0x00000001380a7824ULL, 0x000fe400078e0231ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000002708267210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014297faeULL, 0x0003e2000e101c48ULL,
0x000000182b00720cULL, 0x040fe20003f86070ULL, 0x000000012b327824ULL, 0x000fc400078e021cULL,
0x000000082b2b7824ULL, 0x000fe400078e00ffULL, 0x0000000109277824ULL, 0x000fe400030e060bULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff82b327812ULL, 0x000fc600078ee232ULL,
0x0000001028297824ULL, 0x002fe200078e021fULL, 0x000000700c157812ULL, 0x100fe200078ef805ULL,
0x0000000133287824ULL, 0x040fe400078e021cULL, 0x00000008332b7824ULL, 0x040fe200078e00ffULL,
0x00000015080c7210ULL, 0x000fe20007fde0ffULL, 0x0000000016297faeULL, 0x0003e2000e901c48ULL,
0x000000183300720cULL, 0x000fe40003fa6070ULL, 0x000000700a157812ULL, 0x000fe200078ef805ULL,
0x00000001090d7824ULL, 0x000fe200030e060dULL, 0x0000002c37337810ULL, 0x000fc40007ffe0ffULL,
0x0000001508147210ULL, 0x000fe40007fde0ffULL, 0xfffffff82b347812ULL, 0x000fe200078ee228ULL,
0x00000001380a7824ULL, 0x000fe200078e0233ULL, 0x0000001f2a2b7211ULL, 0x000fe200078e20ffULL,
0x0000000109157824ULL, 0x000fe400030e060bULL, 0x000000102c297824ULL, 0x002fe400078e021fULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x00000000202b7faeULL, 0x0003e2000c901c48ULL,
0x000000182d00720cULL, 0x000fc40003f26070ULL, 0x000000012d177824ULL, 0x140fe200078e021cULL,
0x0000000022297faeULL, 0x0005e2000d101c48ULL, 0x000000082d2a7824ULL, 0x000fe200078e00ffULL,
0x000000700a2d7812ULL, 0x000fe200078ef805ULL, 0x000000012f287824ULL, 0x040fe200078e021cULL,
0x000000182f00720cULL, 0x040fe20003f46070ULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x0000002d08167210ULL, 0x000fe40007fde0ffULL, 0xfffffff82a0a7812ULL, 0x000fe200078ee217ULL,
0x000000102e217824ULL, 0x002fe200078e021fULL, 0xfffffff82f287812ULL, 0x000fe200078ee228ULL,
0x0000000109177824ULL, 0x000fe200030e060bULL, 0x00000030372f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010300b7824ULL, 0x100fe200078e021fULL, 0x0000001f32237211ULL, 0x004fe200078e20ffULL,
0x000000100a2b7824ULL, 0x000fe200078e021fULL, 0x000000000e217faeULL, 0x0003e2000c101c48ULL,
0x00000001380a7824ULL, 0x000fc400078e022fULL, 0x0000001034297824ULL, 0x100fe200078e021fULL,
0x00000000100b7faeULL, 0x0005e2000d901c48ULL, 0x00000010282d7824ULL, 0x000fe200078e021fULL,
0x000000182f00720cULL, 0x0c0fe20003f66070ULL, 0x000000082f207824ULL, 0x000fe200078e00ffULL,
0x0000000012237faeULL, 0x0007e2000e101c48ULL, 0x000000183300720cULL, 0x080fe40003f86070ULL,
0x0000003437217810ULL, 0x002fe20007ffe0ffULL, 0x0000000024297faeULL, 0x0003e2000e901c48ULL,
0x00000001310f7824ULL, 0x000fe200078e021cULL, 0x0000003c37377810ULL, 0x000fe20007ffe0ffULL,
0x000001000a0a7825ULL, 0x004fe200078e00ffULL, 0x00000000262b7faeULL, 0x0005e2000c901c48ULL,
0x000000183100720cULL, 0x000fc40003fa6070ULL, 0x0000000138107824ULL, 0x000fe200078e0221ULL,
0x000000000c2d7faeULL, 0x0009e2000d101c48ULL, 0x0000000831127824ULL, 0x008fe200078e00ffULL,
0x000000182100720cULL, 0x0c0fe20003f46070ULL, 0x0000000121137824ULL, 0x100fe200078e021cULL,
0x000000183500720cULL, 0x080fe20003f26070ULL, 0x0000000821227824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee20fULL, 0x0000000135217824ULL, 0x000fe200078e021cULL,
0x000000183700720cULL, 0x000fe20003f06070ULL, 0x0000000835247824ULL, 0x002fc400078e00ffULL,
0x0000000137237824ULL, 0x100fe200078e021cULL, 0x000000700a0d7812ULL, 0x010fe200078ef805ULL,
0x00000001330a7824ULL, 0x040fe400078e021cULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x0000000d080e7210ULL, 0x000fe20007fde0ffULL, 0x00000100100c7825ULL, 0x000fc600078e00ffULL,
0xfffffff833187812ULL, 0x000fe200078ee20aULL, 0x00000001090f7824ULL, 0x000fe200030e060bULL,
0x000000700c117812ULL, 0x000fe200078ef805ULL, 0x00000001380c7824ULL, 0x000fe200078e0235ULL,
0x0000001c2f0b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000837267824ULL, 0x004fe200078e00ffULL,
0x0000001108107210ULL, 0x000fe40007fde0ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x000001000c0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff8221c7812ULL, 0x000fc400078ee213ULL,
0xfffffff824227812ULL, 0x000fe200078ee221ULL, 0x00000001380c7824ULL, 0x000fe200078e0237ULL,
0x000000700a257812ULL, 0x000fe200078ef805ULL, 0x0000000109117824ULL, 0x000fe200030e060dULL,
0xfffffff826247812ULL, 0x000fe200078ee223ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x00000025080a7210ULL, 0x000fc60007fde0ffULL, 0x0000001018137824ULL, 0x000fe200078e021fULL,
0x000000700c237812ULL, 0x000fe200078ef805ULL, 0x0000001012057824ULL, 0x100fe200078e021fULL,
0x0000000b090b7210ULL, 0x040fe200037fe4ffULL, 0x0000001020217824ULL, 0x100fe200078e021fULL,
0x0000002308087210ULL, 0x000fe20007fde0ffULL, 0x000000101c237824ULL, 0x100fe200078e021fULL,
0x0000000014057faeULL, 0x0003e2000e901c48ULL, 0x0000001022257824ULL, 0x100fe400078e021fULL,
0x00000010241f7824ULL, 0x000fe200078e021fULL, 0x0000000016137faeULL, 0x0003e2000e101c48ULL,
0x0000000109097824ULL, 0x000fc600030e060dULL, 0x000000000e217faeULL, 0x0003e8000d901c48ULL,
0x0000000010237faeULL, 0x0003e8000d101c48ULL, 0x000000000a257faeULL, 0x0003e8000c901c48ULL,
0x00000000081f7faeULL, 0x0003e2000c101c48ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x000000081c137811ULL, 0x042fe400078fe8ffULL, 0x0000000c1c2b7811ULL, 0x000fc400078fe8ffULL,
0x0000001c1c3f7811ULL, 0x040fe200078fe8ffULL, 0x00000001130b7824ULL, 0x100fe200078e021cULL,
0x000000041c117811ULL, 0x040fe200078fe8ffULL, 0x000000012b0c7824ULL, 0x100fe200078e021cULL,
0x00000003130e7819ULL, 0x000fe200000006ffULL, 0x000000082b377824ULL, 0x000fe200078e00ffULL,
0x000000141c2f7811ULL, 0x040fe200078fe8ffULL, 0x000000013f0d7824ULL, 0x140fe200078e021cULL,
0x000000181c317811ULL, 0x000fe200078fe8ffULL, 0x000000083f107824ULL, 0x000fe200078e00ffULL,
0xfffffff80e357812ULL, 0x000fe200078ee20bULL, 0x00000001110a7824ULL, 0x000fe200078e021cULL,
0xfffffff837377812ULL, 0x000fe200078ee20cULL, 0x0000000811337824ULL, 0x000fe200078e00ffULL,
0x000000101c2d7811ULL, 0x000fe200078fe8ffULL, 0x000000012f0b7824ULL, 0x140fe200078e021cULL,
0xfffffff810417812ULL, 0x000fe200078ee20dULL, 0x000000082f0e7824ULL, 0x000fe200078e00ffULL,
0x000000241c0d7811ULL, 0x000fe200078fe8ffULL, 0x00000001310c7824ULL, 0x000fe200078e021cULL,
0xfffffff833337812ULL, 0x000fe200078ee20aULL, 0x00000008313d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3b7812ULL, 0x000fe200078ee20bULL, 0x000000012d0a7824ULL, 0x040fe200078e021cULL,
0x000000201c0b7811ULL, 0x040fe200078fe8ffULL, 0x000000082d397824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL, 0x000000010d0c7824ULL, 0x040fe200078e021cULL,
0x000000281c0f7811ULL, 0x040fe200078fe8ffULL, 0x000000080d177824ULL, 0x000fe200078e00ffULL,
0x0000002c1c1f7811ULL, 0x040fe200078fe8ffULL, 0x000000080b157824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee20aULL, 0x000000010f0e7824ULL, 0x000fe200078e021cULL,
0x0000001c0b0a7210ULL, 0x080fe20007ffe0ffULL, 0x000000080f217824ULL, 0x000fe200078e00ffULL,
0xfffffff817167812ULL, 0x000fe200078ee20cULL, 0x000000011f107824ULL, 0x040fe200078e021cULL,
0x0000001c1c0c7211ULL, 0x000fe200078fe8ffULL, 0x000000081f237824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee20aULL, 0x00000001382a7824ULL, 0x000fe200078e020bULL,
0x0000003c1c277811ULL, 0x000fe200078fe8ffULL, 0x00000001382c7824ULL, 0x000fe200078e020fULL,
0xfffffff821177812ULL, 0x000fe200078ee20eULL, 0x00000001130e7824ULL, 0x100fe200078e0238ULL,
0x000000381c0a7211ULL, 0x000fe200078fe8ffULL, 0x0000000827267824ULL, 0x000fe200078e00ffULL,
0x000000070c297812ULL, 0x000fe200078ec0ffULL, 0x00000001110c7824ULL, 0x000fe200078e0238ULL,
0x000000301c217811ULL, 0x000fe200078fe8ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff823207812ULL, 0x000fc400078ee210ULL, 0x000000382d117210ULL, 0x000fe20007ffe0ffULL,
0x00000001382d7824ULL, 0x000fe200078e021fULL, 0x000000341c237811ULL, 0x040fe200078fe8ffULL,
0x000000012b107824ULL, 0x000fe200078e0238ULL, 0x000000381c257811ULL, 0x000fe200078fe8ffULL,
0x00000001271f7824ULL, 0x100fe200078e021cULL, 0x0000002338347210ULL, 0x040fe20007ffe0ffULL,
0x00000001382b7824ULL, 0x000fe200078e020dULL, 0x0ffffff829297812ULL, 0x100fe200078ef81cULL,
0x00000001210d7824ULL, 0x040fe400078e021cULL, 0x0000000821227824ULL, 0x000fc400078e00ffULL,
0x00000001230f7824ULL, 0x140fe400078e021cULL, 0x0000000823247824ULL, 0x000fe200078e00ffULL,
0xfffffff826237812ULL, 0x000fe200078ee21fULL, 0x0000000125147824ULL, 0x040fe200078e021cULL,
0x000000700a1f7812ULL, 0x000fe200078ef805ULL, 0x0000000138367824ULL, 0x000fe200078e0225ULL,
0xfffffff8221c7812ULL, 0x000fe200078ee20dULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0x000020001e0a7811ULL, 0x000fe200078e70ffULL, 0x000001000c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff825227812ULL, 0x000fe200078ee214ULL, 0x0000000138327824ULL, 0x000fe200078e0221ULL,
0xfffffff824217812ULL, 0x000fe200078ee20fULL, 0x0000001017457824ULL, 0x000fe200078e020aULL,
0x000000700c177812ULL, 0x100fe200078ef805ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001f08147210ULL, 0x000fe40007f1e0ffULL, 0x0000000a214b7211ULL, 0x080fe200078e20ffULL,
0x000000013f187824ULL, 0x000fe200078e0238ULL, 0x0000000a35357211ULL, 0x000fe200078e20ffULL,
0x0000001016437824ULL, 0x100fe200078e020aULL, 0x0000001708167210ULL, 0x000fe20007f3e0ffULL,
0x00000010413f7824ULL, 0x100fe200078e020aULL, 0x000000700e217812ULL, 0x000fe200078ef805ULL,
0x0000001015417824ULL, 0x000fc400078e020aULL, 0x00000010291f7824ULL, 0x100fe400078e020aULL,
0x0000001033337824ULL, 0x100fe400078e020aULL, 0x0000001037377824ULL, 0x100fe400078e020aULL,
0x0000001039397824ULL, 0x100fe400078e020aULL, 0x000000103b3b7824ULL, 0x100fe400078e020aULL,
0x000000103d3d7824ULL, 0x000fc400078e020aULL, 0x0000001020477824ULL, 0x100fe400078e020aULL,
0x000000101c497824ULL, 0x100fe400078e020aULL, 0x00000010224d7824ULL, 0x100fe400078e020aULL,
0x00000010234f7824ULL, 0x000fe400078e020aULL, 0x0000000109157824ULL, 0x000fe200000e060bULL,
0x0000002108207210ULL, 0x000fe20007f1e0ffULL, 0x00000100100a7825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e2000b901c48ULL,
0x000000012f127824ULL, 0x100fe200078e0238ULL, 0x000000700a237812ULL, 0x000fe200078ef805ULL,
0x0000000109177824ULL, 0x000fe400008e060dULL, 0x0000000131137824ULL, 0x000fe400078e0238ULL,
0x00000100110c7825ULL, 0x000fe200078e00ffULL, 0x0000000016337faeULL, 0x0003e6000b901c48ULL,
0x0000010012107825ULL, 0x000fe200078e00ffULL, 0x000000700c257812ULL, 0x000fc600078ef805ULL,
0x0000010013127825ULL, 0x000fe200078e00ffULL, 0x0000002508247210ULL, 0x000fc60007f3e0ffULL,
0x0000000109217824ULL, 0x040fe200000e060fULL, 0x0000002308227210ULL, 0x000fe20007f1e0ffULL,
0x0000000138387824ULL, 0x000fe200078e0227ULL, 0x0000007012297812ULL, 0x000fe200078ef805ULL,
0x0000000109257824ULL, 0x040fe200008e060dULL, 0x0000007010277812ULL, 0x000fe200078ef805ULL,
0x0000000109237824ULL, 0x000fe200000e060bULL, 0x0000002908287210ULL, 0x000fe20007f5e0ffULL,
0x00000100180a7825ULL, 0x000fe200078e00ffULL, 0x0000002708267210ULL, 0x000fe20007f1e0ffULL,
0x0000000020357faeULL, 0x0003e4000b901c48ULL, 0x000001002a0c7825ULL, 0x000fc400078e00ffULL,
0x0000000022377faeULL, 0x0003e4000b901c48ULL, 0x000001002b0e7825ULL, 0x000fe200078e00ffULL,
0x000000700a2b7812ULL, 0x000fe200078ef805ULL, 0x0000000024397faeULL, 0x0003e4000b901c48ULL,
0x0000000109297824ULL, 0x000fe200010e0613ULL, 0x000000700e2f7812ULL, 0x100fe200078ef805ULL,
0x000001002d127825ULL, 0x000fe200078e00ffULL, 0x000000700c2d7812ULL, 0x000fc600078ef805ULL,
0x0000000109277824ULL, 0x040fe200000e0611ULL, 0x0000002b082a7210ULL, 0x000fe20007f1e0ffULL,
0x000001002c107825ULL, 0x000fe200078e00ffULL, 0x0000002d082c7210ULL, 0x000fe40007f3e0ffULL,
0x00000000263b7faeULL, 0x0003e2000b901c48ULL, 0x00000001092b7824ULL, 0x040fe200000e060bULL,
0x0000007010317812ULL, 0x000fe200078ef805ULL, 0x00000100320a7825ULL, 0x000fe200078e00ffULL,
0x0000002f082e7210ULL, 0x000fe20007f1e0ffULL, 0x00000000283d7faeULL, 0x0003e2000b901c48ULL,
0x0000000d092d7210ULL, 0x000fc40000ffe4ffULL, 0x00000070120d7812ULL, 0x000fe200078ef805ULL,
0x00000001092f7824ULL, 0x040fe200000e060fULL, 0x0000003108307210ULL, 0x000fe20007f5e0ffULL,
0x00000100360e7825ULL, 0x000fe200078e00ffULL, 0x0000000d08127210ULL, 0x000fe20007f1e0ffULL,
0x000000002a3f7faeULL, 0x0003e2000b901c48ULL, 0x000000700a557812ULL, 0x100fe200078ef805ULL,
0x00000100340c7825ULL, 0x000fe200078e00ffULL, 0x000000700e517812ULL, 0x000fe200078ef805ULL,
0x000000002c417faeULL, 0x0003e4000b901c48ULL, 0x0000000109317824ULL, 0x040fe200010e0611ULL,
0x000000700c537812ULL, 0x000fe200078ef805ULL, 0x0000010038107825ULL, 0x000fe200078e00ffULL,
0x00000051080e7210ULL, 0x040fe20007f5e0ffULL, 0x000000002e437faeULL, 0x0003e2000b901c48ULL,
0x00000053080c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000109137824ULL, 0x040fe200000e0613ULL,
0x0000007010057812ULL, 0x000fe200078ef805ULL, 0x00000001090f7824ULL, 0x040fe200010e060fULL,
0x00000055080a7210ULL, 0x040fe20007f1e0ffULL, 0x00000001090d7824ULL, 0x040fe200008e060dULL,
0x0000000508087210ULL, 0x000fe20007f7e0ffULL, 0x0000000030457faeULL, 0x0003e4000b901c48ULL,
0x00000001090b7824ULL, 0x000fc400000e060bULL, 0x0000000109097824ULL, 0x000fe200018e0611ULL,
0x0000000012477faeULL, 0x0003e8000b901c48ULL, 0x000000000a497faeULL, 0x0003e8000b901c48ULL,
0x000000000c4b7faeULL, 0x0003e8000b901c48ULL, 0x000000000e4d7faeULL, 0x0003e8000b901c48ULL,
0x00000000084f7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01e60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000191d00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000009d7919ULL, 0x000e620000000000ULL,
0x00005800009a7a02ULL, 0x000fe20000000f00ULL, 0x00006800a2a27a24ULL, 0x000fe200078e02ffULL,
0x800058001b997a10ULL, 0x000fe20007ffe0ffULL, 0x000000201e9e7824ULL, 0x000fe200078e00ffULL,
0x0000001f9a057810ULL, 0x040fe40007ffe0ffULL, 0xffffffff9a9b7810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff057819ULL, 0x000fe40000011605ULL, 0x0001e6881e9c7811ULL, 0x000fc400078e18ffULL,
0x000000099a9a7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff997819ULL, 0x000fe40000011699ULL,
0x0ffffffe05987812ULL, 0x000fc400078ec0ffULL, 0x000000011d067810ULL, 0x040fe20007ffe0ffULL,
0x000001001d237824ULL, 0x000fe200078e02a0ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000100ffa17424ULL, 0x000fe200078e00ffULL, 0x000000190600720cULL, 0x000fe20003f06070ULL,
0x000000039f067224ULL, 0x000fe200078e02ffULL, 0x0000004023037812ULL, 0x000fc600078ec0ffULL,
0x0000620006067625ULL, 0x000fc800078e00a1ULL, 0x0000000102187824ULL, 0x000fc800078e0203ULL,
0x00000bb000008947ULL, 0x00cfea0003800000ULL, 0x000000109d227824ULL, 0x002fe200078e00ffULL,
0x00000003ff1c7819ULL, 0x100fe4000001169dULL, 0x000000ff00097202ULL, 0x000fe40000000f00ULL,
0x0000007022227812ULL, 0x000fe200078ec0ffULL, 0x000000011c0b7824ULL, 0x040fe200078e0218ULL,
0x000000041c0e7810ULL, 0x000fe40007ffe0ffULL, 0x0000008022087812ULL, 0x000fe400078efcffULL,
0x000000081c107810ULL, 0x000fe20007ffe0ffULL, 0x000000010e037824ULL, 0x000fe200078e029dULL,
0x000000101c167810ULL, 0x000fe20007ffe0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0008ULL,
0x000000231b0c7217ULL, 0x000fc40007800000ULL, 0x0000000c1c147810ULL, 0x000fe20007ffe0ffULL,
0x000000080e207824ULL, 0x000fe200078e00ffULL, 0x0000000a06127210ULL, 0x000fe20007f1e0ffULL,
0x0000000110057824ULL, 0x000fe200078e029dULL, 0x000000141c267810ULL, 0x000fe20007ffe0ffULL,
0x00000008102a7824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee203ULL,
0x00000001160d7824ULL, 0x000fe200078e029dULL, 0x0000001826117210ULL, 0x000fe20007ffe0ffULL,
0x00000008162e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee205ULL,
0x0000000107137824ULL, 0x000fe200000e060bULL, 0x000000181c287810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0b7824ULL, 0x000fe200078e0218ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20dULL,
0x000000010c037824ULL, 0x000fe200078e0a23ULL, 0x0ffffff89d217812ULL, 0x000fe200078ec0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x0000001c1c327810ULL, 0x000fc40007ffe0ffULL,
0x000000031400720cULL, 0x0c0fe20003f66070ULL, 0x0000000114057824ULL, 0x000fe200078e029dULL,
0x000000031600720cULL, 0x080fe20003f06070ULL, 0x00000008142c7824ULL, 0x000fe200078e00ffULL,
0x000000030e00720cULL, 0x080fe20003f86070ULL, 0x00000001100d7824ULL, 0x140fe200078e0218ULL,
0x000000031000720cULL, 0x000fe20003f46070ULL, 0x00000001140f7824ULL, 0x000fe200078e0218ULL,
0x0000000a06147210ULL, 0x000fe20007f3e0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0008ULL,
0xfffffff82c2c7812ULL, 0x000fc400078ee205ULL, 0x000000201c347810ULL, 0x000fe20007ffe0ffULL,
0x0000000116057824ULL, 0x000fe200078e0218ULL, 0x0000000c06167210ULL, 0x000fe20007fbe0ffULL,
0x0000000107157824ULL, 0x000fe400008e060bULL, 0x00000100050a7825ULL, 0x000fc800078e0008ULL,
0x000001000f0e7825ULL, 0x000fc800078e0008ULL, 0x0000000107177824ULL, 0x000fe200028e060dULL,
0x0000000a06247210ULL, 0x040fe20007fbe0ffULL, 0x0000010011107825ULL, 0x000fe200078e0008ULL,
0x0000000e060e7210ULL, 0x000fc60007f3e0ffULL, 0x0000000128057824ULL, 0x000fe200078e0218ULL,
0x0000001006107210ULL, 0x000fe20007fde0ffULL, 0x0000000107257824ULL, 0x000fe200028e060bULL,
0x000000031c00720cULL, 0x000fe20003fa6070ULL, 0x00000100050a7825ULL, 0x000fe200078e0008ULL,
0x000040001e057811ULL, 0x000fc600078e70ffULL, 0x00000001070f7824ULL, 0x040fe200008e060fULL,
0x000000032600720cULL, 0x000fe20003f26070ULL, 0x0000000107117824ULL, 0x000fe400030e0611ULL,
0x000000011c0c7824ULL, 0x100fe400078e029dULL, 0x00000001260d7824ULL, 0x040fe400078e029dULL,
0x0000000826307824ULL, 0x000fe200078e00ffULL, 0x0000000a06267210ULL, 0x000fe20007fde0ffULL,
0x00000010202b7824ULL, 0x000fe200078e0205ULL, 0x00000007210c7812ULL, 0x000fe200078ef80cULL,
0x0000000128207824ULL, 0x000fe200078e029dULL, 0xfffffff830307812ULL, 0x000fe200078ee20dULL,
0x0000000107277824ULL, 0x000fe200030e060bULL, 0x000000050c1f7211ULL, 0x000fe200078e20ffULL,
0x00000001320b7824ULL, 0x000fc400078e0218ULL, 0x00000008282d7824ULL, 0x040fe400078e00ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121f7faeULL, 0x0003e2000e901c48ULL, 0x000000032800720cULL, 0x080fe40003fa6070ULL,
0x00000001340d7824ULL, 0x000fe200078e0218ULL, 0x0000000a06287210ULL, 0x000fe20007fde0ffULL,
0x00000000142b7faeULL, 0x0005e2000e101c48ULL, 0x00000001320a7824ULL, 0x040fe200078e029dULL,
0x000000033200720cULL, 0x000fe20003f86070ULL, 0x000001000d0c7825ULL, 0x000fe200078e0008ULL,
0xfffffff82d207812ULL, 0x000fc400078ee220ULL, 0x000000241c127810ULL, 0x002fe20007ffe0ffULL,
0x0000000832137824ULL, 0x000fe200078e00ffULL, 0x000000052c1f7211ULL, 0x000fe200078e20ffULL,
0x0000000107297824ULL, 0x000fe200030e060bULL, 0x0000000c060c7210ULL, 0x000fe20007fde0ffULL,
0x000000102a157824ULL, 0x004fe200078e0205ULL, 0xfffffff813147812ULL, 0x000fe200078ee20aULL,
0x00000001120b7824ULL, 0x000fe200078e0218ULL, 0x0000003c1c2c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000134137824ULL, 0x000fe200078e029dULL, 0x0000000016157faeULL, 0x0003e2000d101c48ULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x000000031200720cULL, 0x000fc40003f46070ULL,
0x000000000e1f7faeULL, 0x0005e2000d901c48ULL, 0x000000033400720cULL, 0x040fe20003f66070ULL,
0x0000000834347824ULL, 0x000fe400078e00ffULL, 0x00000001070d7824ULL, 0x000fe400030e060dULL,
0x00000001122a7824ULL, 0x040fe400078e029dULL, 0x00000008122b7824ULL, 0x000fe200078e00ffULL,
0x0000000a06127210ULL, 0x000fe20007fde0ffULL, 0x000000102e157824ULL, 0x002fe200078e0205ULL,
0xfffffff8340a7812ULL, 0x000fe200078ee213ULL, 0x0000001014177824ULL, 0x000fe200078e0205ULL,
0xfffffff82b2a7812ULL, 0x000fe200078ee22aULL, 0x0000000107137824ULL, 0x000fe200030e060bULL,
0x000000050a1f7211ULL, 0x004fe200078e20ffULL, 0x00000010300b7824ULL, 0x100fe200078e0205ULL,
0x000000281c0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000024157faeULL, 0x0003e2000c101c48ULL,
0x00000010200f7824ULL, 0x000fe200078e0205ULL, 0x0000002c1c0e7810ULL, 0x000fc40007ffe0ffULL,
0x00000000100b7faeULL, 0x0005e2000c901c48ULL, 0x000000080a147824ULL, 0x000fe200078e00ffULL,
0x000000301c167810ULL, 0x000fe40007ffe0ffULL, 0x00000000260f7faeULL, 0x0007e2000e901c48ULL,
0x000000030a00720cULL, 0x080fe40003fc6070ULL, 0x000000341c207810ULL, 0x040fe20007ffe0ffULL,
0x0000000028177faeULL, 0x0009e2000e101c48ULL, 0x000000381c247810ULL, 0x002fe20007ffe0ffULL,
0x000000080e1c7824ULL, 0x040fe200078e00ffULL, 0x000000030e00720cULL, 0x080fe20003fa6070ULL,
0x000000010a0b7824ULL, 0x004fe200078e029dULL, 0x000000000c1f7faeULL, 0x0003e2000d901c48ULL,
0x000000102a117824ULL, 0x000fe200078e0205ULL, 0x000000031600720cULL, 0x080fe20003f86070ULL,
0x000000010e0f7824ULL, 0x008fe200078e029dULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x000000010a0b7824ULL, 0x000fe200078e0218ULL, 0x0000000012117faeULL, 0x0005e2000d101c48ULL,
0x0000000116107824ULL, 0x000fe200078e029dULL, 0x000000032000720cULL, 0x080fe20003f66070ULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x000000032400720cULL, 0x000fc40003f26070ULL,
0x000000032c00720cULL, 0x000fe20003f06070ULL, 0x000000010e0d7824ULL, 0x002fe200078e0218ULL,
0x0000000a060e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000816157824ULL, 0x000fe400078e00ffULL,
0x000001000d0c7825ULL, 0x000fc800078e0008ULL, 0x0000000116037824ULL, 0x000fe200078e0218ULL,
0xfffffff81c167812ULL, 0x000fe200078ee20fULL, 0x0000000820137824ULL, 0x004fe200078e00ffULL,
0xfffffff8151c7812ULL, 0x000fe200078ee210ULL, 0x0000000124157824ULL, 0x000fe200078e0218ULL,
0x0000000b070f7210ULL, 0x000fe200017fe4ffULL, 0x00000100030a7825ULL, 0x000fe200078e0008ULL,
0x0000000c06107210ULL, 0x000fc60007f5e0ffULL, 0x00000001200c7824ULL, 0x040fe400078e029dULL,
0x0000000120037824ULL, 0x000fe400078e0218ULL, 0x0000000107117824ULL, 0x000fe200010e060dULL,
0x0000000a06127210ULL, 0x000fe20007f5e0ffULL, 0x0000000124177824ULL, 0x010fe200078e029dULL,
0xfffffff813207812ULL, 0x000fe200078ee20cULL, 0x00000100030c7825ULL, 0x000fc800078e0008ULL,
0x0000000107137824ULL, 0x000fe200010e060bULL, 0x0000000c060c7210ULL, 0x000fe20007f5e0ffULL,
0x00000100150a7825ULL, 0x000fc800078e0008ULL, 0x000000012c037824ULL, 0x000fe400078e0218ULL,
0x00000001070d7824ULL, 0x000fe200010e060dULL, 0x0000000a060a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000824187824ULL, 0x000fe200078e00ffULL, 0x000000032c247819ULL, 0x040fe200000006ffULL,
0x000000012c157824ULL, 0x000fe400078e029dULL, 0x0000010003087825ULL, 0x000fe200078e0008ULL,
0xfffffff818187812ULL, 0x000fe400078ee217ULL, 0xfffffff824247812ULL, 0x000fe200078ee215ULL,
0x00000001070b7824ULL, 0x000fe200010e060bULL, 0x0000000806067210ULL, 0x000fe20007f5e0ffULL,
0x0000001014037824ULL, 0x000fc400078e0205ULL, 0x0000001016157824ULL, 0x100fe400078e0205ULL,
0x000000101c177824ULL, 0x100fe200078e0205ULL, 0x000000000e037faeULL, 0x0003e2000f101c48ULL,
0x00000010201f7824ULL, 0x100fe400078e0205ULL, 0x0000001018257824ULL, 0x100fe200078e0205ULL,
0x0000000010157faeULL, 0x0003e2000e901c48ULL, 0x0000001024057824ULL, 0x000fe400078e0205ULL,
0x0000000107077824ULL, 0x000fe200010e0609ULL, 0x0000000012177faeULL, 0x0003e8000e101c48ULL,
0x000000000c1f7faeULL, 0x0003e8000d901c48ULL, 0x000000000a257faeULL, 0x0003e8000c901c48ULL,
0x0000000006057faeULL, 0x0003e2000c101c48ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x000000049d0b7811ULL, 0x042fe200078fe8ffULL, 0x000000109d227824ULL, 0x040fe200078e00ffULL,
0x000000089d0d7811ULL, 0x000fe200078fe8ffULL, 0x000000ffff337224ULL, 0x000fe200078e00ffULL,
0x000000030b0a7819ULL, 0x040fe200000006ffULL, 0x000000010b037824ULL, 0x100fe200078e029dULL,
0x0000000c9d0f7811ULL, 0x000fe200078fe8ffULL, 0x000000010d087824ULL, 0x000fe200078e029dULL,
0x000000109d117811ULL, 0x000fe200078fe8ffULL, 0x000000080d1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a057812ULL, 0x000fe200078ee203ULL, 0x000000010f037824ULL, 0x100fe200078e029dULL,
0x000000189d157811ULL, 0x000fe200078fe8ffULL, 0x000000080f0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x0000000111087824ULL, 0x000fe200078e029dULL,
0x000000149d137811ULL, 0x000fe200078fe8ffULL, 0x0000000811377824ULL, 0x000fe200078e00ffULL,
0x0000001c9d177811ULL, 0x000fe200078fe8ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0218ULL,
0xfffffff80a357812ULL, 0x000fe200078ee203ULL, 0x0000000115037824ULL, 0x100fe200078e029dULL,
0x000000249d277811ULL, 0x000fe200078fe8ffULL, 0x00000008150a7824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee208ULL, 0x0000000113097824ULL, 0x000fe200078e029dULL,
0x000000209d257811ULL, 0x000fe200078fe8ffULL, 0x00000008130c7824ULL, 0x000fe200078e00ffULL,
0x0000009d17087210ULL, 0x0c0fe20007ffe0ffULL, 0x00000008173d7824ULL, 0x000fe200078e00ffULL,
0x000000289d297811ULL, 0x000fe200078fe8ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0218ULL,
0xfffffff80a3b7812ULL, 0x000fe200078ee203ULL, 0x0000000127037824ULL, 0x040fe200078e029dULL,
0xfffffff80c397812ULL, 0x000fe200078ee209ULL, 0x00000008270a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee208ULL, 0x0000000125097824ULL, 0x100fe200078e029dULL,
0x000000309d2d7811ULL, 0x000fe200078fe8ffULL, 0x00000008250c7824ULL, 0x000fe200078e00ffULL,
0x0000002c9d2b7811ULL, 0x000fe200078fe8ffULL, 0x0000000129087824ULL, 0x000fe200078e029dULL,
0x000000349d2f7811ULL, 0x000fe200078fe8ffULL, 0x0000000829437824ULL, 0x000fe200078e00ffULL,
0xfffffff80a417812ULL, 0x000fe200078ee203ULL, 0x000000012d037824ULL, 0x000fe200078e029dULL,
0xfffffff80c3f7812ULL, 0x000fe200078ee209ULL, 0x000000012b097824ULL, 0x100fe200078e029dULL,
0xfffffff843437812ULL, 0x000fe200078ee208ULL, 0x000000082b0c7824ULL, 0x000fe200078e00ffULL,
0x000000032d0a7819ULL, 0x000fe200000006ffULL, 0x000000012f087824ULL, 0x000fe200078e029dULL,
0x0000003c9d4d7811ULL, 0x000fe200078fe8ffULL, 0x000000082f497824ULL, 0x000fe200078e00ffULL,
0x000000389d317811ULL, 0x000fe200078fe8ffULL, 0x000000010f0f7824ULL, 0x000fe200078e0218ULL,
0xfffffff80a477812ULL, 0x000fe200078ee203ULL, 0x000000014d037824ULL, 0x040fe200078e029dULL,
0xfffffff80c457812ULL, 0x000fe200078ee209ULL, 0x000000084d0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee208ULL, 0x0000000131097824ULL, 0x000fe200078e029dULL,
0x0000009d9d087211ULL, 0x000fe200078fe8ffULL, 0x00000008310c7824ULL, 0x000fe200078e00ffULL,
0x0ffffff89d217812ULL, 0x000fe200078ec0ffULL, 0x0000000113137824ULL, 0x100fe200078e0218ULL,
0x0000007022227812ULL, 0x000fe200078ec0ffULL, 0x0000000115157824ULL, 0x100fe200078e0218ULL,
0xfffffff80a4f7812ULL, 0x000fe200078ee203ULL, 0x0000000117177824ULL, 0x100fe200078e0218ULL,
0xfffffff80c4b7812ULL, 0x000fe200078ee209ULL, 0x0000000125257824ULL, 0x100fe200078e0218ULL,
0x000040001e0a7811ULL, 0x000fe200078e70ffULL, 0x0000000127277824ULL, 0x000fe200078e0218ULL,
0x0000000721037812ULL, 0x000fe200078ef808ULL, 0x0000000129297824ULL, 0x000fe200078e0218ULL,
0x000000189d097211ULL, 0x000fe200078fe8ffULL, 0x0000001005057824ULL, 0x100fe200078e020aULL,
0x0000008022327812ULL, 0x000fe200078efcffULL, 0x0000001003037824ULL, 0x100fe200078e020aULL,
0x0000000a43437211ULL, 0x000fe200078e20ffULL, 0x000000101f1f7824ULL, 0x100fe200078e020aULL,
0x0000001811117210ULL, 0x080fe20007ffe0ffULL, 0x0000001035357824ULL, 0x100fe200078e020aULL,
0x000000184d4d7210ULL, 0x000fe20007ffe0ffULL, 0x0000001037377824ULL, 0x000fc400078e020aULL,
0x0000001039397824ULL, 0x100fe400078e020aULL, 0x000000103b3b7824ULL, 0x100fe400078e020aULL,
0x000000103d3d7824ULL, 0x100fe400078e020aULL, 0x000000103f3f7824ULL, 0x100fe400078e020aULL,
0x0000001041417824ULL, 0x100fe400078e020aULL, 0x0000001045457824ULL, 0x000fc400078e020aULL,
0x0000001047477824ULL, 0x100fe400078e020aULL, 0x0000001049497824ULL, 0x100fe400078e020aULL,
0x000000104b4b7824ULL, 0x100fe400078e020aULL, 0x000000104f4f7824ULL, 0x000fe400078e020aULL,
0x0000010009087825ULL, 0x000fc800078e0032ULL, 0x000001000b0a7825ULL, 0x000fe200078e0032ULL,
0x0000000806087210ULL, 0x000fc60007f1e0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0032ULL,
0x0000000a060a7210ULL, 0x000fc60007f3e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0032ULL,
0x0000000c060c7210ULL, 0x000fc60007f5e0ffULL, 0x0000010011107825ULL, 0x000fe200078e0032ULL,
0x0000000e060e7210ULL, 0x000fc60007f7e0ffULL, 0x0000010013127825ULL, 0x000fc800078e0032ULL,
0x0000010015147825ULL, 0x000fc800078e0032ULL, 0x0000010017167825ULL, 0x000fc800078e0032ULL,
0x0000000107097824ULL, 0x040fe200000e0609ULL, 0x0000001006107210ULL, 0x040fe20007f1e0ffULL,
0x00000001070b7824ULL, 0x000fe200008e060bULL, 0x0000001206127210ULL, 0x040fe20007f3e0ffULL,
0x000000012b2b7824ULL, 0x000fe200078e0218ULL, 0x0000001107117210ULL, 0x000fe200007fe4ffULL,
0x0000010025247825ULL, 0x000fe200078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008037faeULL, 0x0003e6000b901c48ULL, 0x00000001070d7824ULL, 0x000fe200010e060dULL,
0x0000001406147210ULL, 0x040fe20007f5e0ffULL, 0x0000010027267825ULL, 0x000fe200078e0032ULL,
0x0000002406247210ULL, 0x000fe20007f1e0ffULL, 0x000000000a057faeULL, 0x0003e4000b901c48ULL,
0x000000012d2d7824ULL, 0x000fc400078e0218ULL, 0x0000010029287825ULL, 0x000fe200078e0032ULL,
0x000000000c1f7faeULL, 0x0003e6000b901c48ULL, 0x00000001070f7824ULL, 0x000fe200018e060fULL,
0x0000001606167210ULL, 0x000fe20007f7e0ffULL, 0x000000012f2f7824ULL, 0x100fe400078e0218ULL,
0x0000000131317824ULL, 0x000fe200078e0218ULL, 0x000000000e357faeULL, 0x0003e2000b901c48ULL,
0x000001002b2a7825ULL, 0x000fc600078e0032ULL, 0x0000000010377faeULL, 0x0003e2000b901c48ULL,
0x0000000107137824ULL, 0x000fe200008e0613ULL, 0x0000002606267210ULL, 0x000fe20007f3e0ffULL,
0x000001002d2c7825ULL, 0x000fc600078e0032ULL, 0x0000000012397faeULL, 0x0003e2000b901c48ULL,
0x0000000107157824ULL, 0x000fe200010e0615ULL, 0x0000002806287210ULL, 0x000fe20007f5e0ffULL,
0x000001002f2e7825ULL, 0x000fc600078e0032ULL, 0x00000000143b7faeULL, 0x0003e2000b901c48ULL,
0x0000010031307825ULL, 0x000fc800078e0032ULL, 0x0000000107177824ULL, 0x000fe200018e0617ULL,
0x0000002a062a7210ULL, 0x000fe20007f7e0ffULL, 0x000001004d327825ULL, 0x000fc600078e0032ULL,
0x00000000163d7faeULL, 0x0003e2000b901c48ULL, 0x0000000107257824ULL, 0x040fe200000e0625ULL,
0x0000002c062c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000107277824ULL, 0x040fe200008e0627ULL,
0x0000002e062e7210ULL, 0x040fe20007f3e0ffULL, 0x0000000107297824ULL, 0x040fe200010e0629ULL,
0x0000003006307210ULL, 0x040fe20007f5e0ffULL, 0x00000001072b7824ULL, 0x040fe200018e062bULL,
0x0000003206067210ULL, 0x000fe20007f7e0ffULL, 0x00000001072d7824ULL, 0x040fe200000e062dULL,
0x00000000243f7faeULL, 0x0003e2000b901c48ULL, 0x00000001072f7824ULL, 0x000fc400008e062fULL,
0x0000000107317824ULL, 0x040fe200010e0631ULL, 0x0000000026417faeULL, 0x0003e2000b901c48ULL,
0x0000003307077210ULL, 0x000fc60001ffe4ffULL, 0x0000000028437faeULL, 0x0003e8000b901c48ULL,
0x000000002a457faeULL, 0x0003e8000b901c48ULL, 0x000000002c477faeULL, 0x0003e8000b901c48ULL,
0x000000002e497faeULL, 0x0003e8000b901c48ULL, 0x00000000304b7faeULL, 0x0003e8000b901c48ULL,
0x00000000064f7faeULL, 0x0003e4000b901c48ULL, 0x0000000204047810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff037424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000001a0400720cULL, 0x000fda0003f06070ULL, 0x00000002a2068824ULL, 0x000fe400078e0204ULL,
0x00000004ff078424ULL, 0x000fc800078e00ffULL, 0x0000640006068625ULL, 0x000fe200078e0007ULL,
0x000000089d207812ULL, 0x000fe400078ec0ffULL, 0x00000004ff147819ULL, 0x000fe2000001169dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000806038981ULL, 0x000322000c1e1900ULL,
0x0000000720207812ULL, 0x000fe200078ef89dULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000079d6c7812ULL, 0x000fc600078ec0ffULL, 0x00000001141f7824ULL, 0x000fe400078e0220ULL,
0x0000001020087824ULL, 0x000fca00078e00ffULL, 0xfffffff008057812ULL, 0x000fca00078ee21fULL,
0x0000001005647824ULL, 0x000fc400078e00ffULL, 0x0000000814057824ULL, 0x002fe200078e00ffULL,
0x00000003ff1c7819ULL, 0x000fe2000001169dULL, 0x00000010200c7824ULL, 0x040fe200078e00ffULL,
0x0000001020177812ULL, 0x000fe200078efcffULL, 0x000040001e187824ULL, 0x000fe200078e00ffULL,
0xfffffff8056c7812ULL, 0x000fe200078ee26cULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0x000000011c097812ULL, 0x000fe200078ec0ffULL, 0x00000010170b7824ULL, 0x000fe200078e00ffULL,
0x0000001714147210ULL, 0x000fe20007ffe0ffULL, 0x000000086c067824ULL, 0x040fe200078e00ffULL,
0x000000021f077810ULL, 0x000fe20007ffe0ffULL, 0x0000000109057824ULL, 0x000fe200078e026cULL,
0x000000106c7c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010170d7824ULL, 0x000fe200078e00ffULL,
0xfffffff00c0c7812ULL, 0x000fe200078ee207ULL, 0x000000086c257824ULL, 0x000fe200078e00ffULL,
0xfffffff806157812ULL, 0x000fe200078ee205ULL, 0x0000000109137824ULL, 0x000fe200078e027cULL,
0xfffffff00b067812ULL, 0x000fe200078ee214ULL, 0x000000087c0a7824ULL, 0x000fe200078e00ffULL,
0x000000206c077810ULL, 0x000fe20007ffe0ffULL, 0x000000100c0c7824ULL, 0x000fe200078e00ffULL,
0x0000200018167810ULL, 0x000fe20007ffe0ffULL, 0x0000001006687824ULL, 0x000fe200078e00ffULL,
0x000000306c067810ULL, 0x000fe20007ffe0ffULL, 0x0000000109127824ULL, 0x000fe200078e0207ULL,
0x0000000214087810ULL, 0x000fe20007ffe0ffULL, 0x0000001015607824ULL, 0x000fe200078e0216ULL,
0x00000003060e7819ULL, 0x000fe200000006ffULL, 0x0000000109117824ULL, 0x000fe200078e0206ULL,
0xfffffff80a137812ULL, 0x000fe200078ee213ULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0xfffffff00d0d7812ULL, 0x000fe200078ee208ULL, 0x000000006060783bULL, 0x000e620000000200ULL,
0xfffffff80e117812ULL, 0x000fe200078ee211ULL, 0x0000001013087824ULL, 0x000fe200078e0216ULL,
0xfffffff809127812ULL, 0x000fe200078ee212ULL, 0x000000006868783bULL, 0x000ea20000000200ULL,
0x000000087c0e7824ULL, 0x000fe200078e00ffULL, 0x00000012050f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010113c7824ULL, 0x100fe200078e0216ULL, 0x000000000808783bULL, 0x000ee20000000200ULL,
0x0000001012787824ULL, 0x100fe200078e0216ULL, 0x0000000205107810ULL, 0x000fe20007ffe0ffULL,
0x0000000807297824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0f7812ULL, 0x000fe200078ee20fULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x000000100d247824ULL, 0x000fe200078e00ffULL,
0x00000022050e7810ULL, 0x040fe20007ffe0ffULL, 0x000000086c717824ULL, 0x000fe200078e00ffULL,
0x000000007878783bULL, 0x000ee20000000200ULL, 0x0000003205287810ULL, 0x000fe20007ffe0ffULL,
0x000000100f5c7824ULL, 0x000fe200078e0216ULL, 0x00000003060d7819ULL, 0x000fe200000006ffULL,
0x000000000c54783bULL, 0x0003e20000000200ULL, 0xfffffff825107812ULL, 0x000fe200078ee210ULL,
0x000000087c887824ULL, 0x000fe200078e00ffULL, 0xfffffff8290e7812ULL, 0x000fe200078ee20eULL,
0x000000002424783bULL, 0x000fe20000000200ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee228ULL,
0x0000001010387824ULL, 0x100fe200078e0216ULL, 0x00000003078a7819ULL, 0x000fe200000006ffULL,
0x000000100e747824ULL, 0x100fe200078e0216ULL, 0x000000005c5c783bULL, 0x000fe20000000200ULL,
0x000000100d287824ULL, 0x000fe200078e0216ULL, 0x000000041f0c7810ULL, 0x002fe20007ffe0ffULL,
0x00000008068c7824ULL, 0x000fe200078e00ffULL, 0x000000003838783bULL, 0x000e620000000200ULL,
0x0000002605877810ULL, 0x000fc60007ffe0ffULL, 0x000000007474783bULL, 0x000e620000000200ULL,
0x00000060642c723cULL, 0x080f6600000418ffULL, 0x000000002828783bULL, 0x000e6a0000000200ULL,
0x000000606830723cULL, 0x004f7000000418ffULL, 0x000000626434723cULL, 0x080f7000000418ffULL,
0x000000626860723cULL, 0x000f7000000418ffULL, 0x000000086440723cULL, 0x048f7000000418ffULL,
0x0000000a6444723cULL, 0x040f7000000418ffULL, 0x000000786448723cULL, 0x040f7000000418ffULL,
0x0000007a644c723cULL, 0x040f7000000418ffULL, 0x0000003c6450723cULL, 0x040f7000000418ffULL,
0x0000003e6464723cULL, 0x000f7000000418ffULL, 0x000000086858723cULL, 0x040f7000000418ffULL,
0x0000000a6808723cULL, 0x000ff000000418ffULL, 0x00000038542c723cULL, 0x0a2ff0000004182cULL,
0x000000382430723cULL, 0x000ff00000041830ULL, 0x0000003a5434723cULL, 0x080ff00000041834ULL,
0x0000003a2438723cULL, 0x000ff00000041860ULL, 0x0000005c5440723cULL, 0x040ff00000041840ULL,
0x0000005e5444723cULL, 0x040ff00000041844ULL, 0x000000745448723cULL, 0x040ff00000041848ULL,
0x00000076544c723cULL, 0x040ff0000004184cULL, 0x000000285450723cULL, 0x000ff00000041850ULL,
0x000000786860723cULL, 0x040f7000000418ffULL, 0x0000003c6880723cULL, 0x000ff000000418ffULL,
0x0000002a5454723cULL, 0x000bee0000041864ULL, 0x0000001020657824ULL, 0x020fe200078e00ffULL,
0x0000007a6878723cULL, 0x000f6200000418ffULL, 0x0000001017677824ULL, 0x000fe200078e00ffULL,
0x0000000614667810ULL, 0x000fc40007ffe0ffULL, 0xfffffff065647812ULL, 0x000fe400078ee20cULL,
0x00000004050c7810ULL, 0x000fe40007ffe0ffULL, 0x0000003e683c723cULL, 0x000b6200000418ffULL,
0x0000001064647824ULL, 0x000fcc00078e00ffULL, 0x0000001020687824ULL, 0x020fe200078e00ffULL,
0x0000005c2458723cULL, 0x000b620000041858ULL, 0x0000001017697824ULL, 0x000fca00078e00ffULL,
0xfffffff069867812ULL, 0x000fe200078ee266ULL, 0x0000000806667824ULL, 0x000fe200078e00ffULL,
0x000000061f5d7810ULL, 0x020fe20007ffe0ffULL, 0x000000742460723cULL, 0x040fe20000041860ULL,
0x00000004145c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff068857812ULL, 0x000fe400078ee25dULL,
0xfffffff067657812ULL, 0x000fe200078ee25cULL, 0x000000086c677824ULL, 0x000fe200078e00ffULL,
0x0000000307697819ULL, 0x000fe200000006ffULL, 0x0000005e245c723cULL, 0x000be20000041808ULL,
0x0000001605077810ULL, 0x000fe20007ffe0ffULL, 0x00000010656c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8670c7812ULL, 0x000fe200078ee20cULL, 0x0000001085857824ULL, 0x000fe200078e00ffULL,
0xfffffff888077812ULL, 0x000fc400078ee207ULL, 0x000000087c087824ULL, 0x020fe200078e00ffULL,
0x00000014050b7810ULL, 0x040fe20007ffe0ffULL, 0x000000006c6c783bULL, 0x000fe20000000200ULL,
0x0000003405097810ULL, 0x000fe20007ffe0ffULL, 0x000000100c687824ULL, 0x100fe200078e0216ULL,
0xfffffff8080b7812ULL, 0x000fe200078ee20bULL, 0x0000001007907824ULL, 0x100fe200078e0216ULL,
0xfffffff866097812ULL, 0x000fe200078ee209ULL, 0x000000762474723cULL, 0x000fe20000041878ULL,
0x0000000605087810ULL, 0x000fe20007ffe0ffULL, 0x000000100b707824ULL, 0x100fe200078e0216ULL,
0x000000006464783bULL, 0x000fe20000000200ULL, 0x00000010097d7824ULL, 0x000fe200078e0216ULL,
0xfffffff871087812ULL, 0x000fc400078ee208ULL, 0x00000024050a7810ULL, 0x040fe20007ffe0ffULL,
0x000000007070783bULL, 0x000e620000000200ULL, 0x0000003605057810ULL, 0x000fe20007ffe0ffULL,
0x000000282480723cULL, 0x040b620000041880ULL, 0xfffffff8690a7812ULL, 0x000fe200078ee20aULL,
0x000000007d7c783bULL, 0x000ea20000000200ULL, 0xfffffff88c057812ULL, 0x000fe200078ee205ULL,
0x00000010868c7824ULL, 0x000fe200078e00ffULL, 0xfffffff88a067812ULL, 0x000fe200078ee287ULL,
0x000000100a847824ULL, 0x100fe200078e0216ULL, 0x000000006868783bULL, 0x000ee20000000200ULL,
0x0000001005287824ULL, 0x120fe200078e0216ULL, 0x0000002a243c723cULL, 0x000b62000004183cULL,
0x0000001008887824ULL, 0x100fe200078e0216ULL, 0x000000008478783bULL, 0x000ea20000000200ULL,
0x0000001006947824ULL, 0x000fc600078e0216ULL, 0x000000008584783bULL, 0x000fe80000000200ULL,
0x000000008c8c783bULL, 0x000fe80000000200ULL, 0x000000009090783bULL, 0x000ee80000000200ULL,
0x000000002824783bULL, 0x020ee80000000200ULL, 0x000000008888783bULL, 0x000ee80000000200ULL,
0x000000009494783bULL, 0x000ee20000000200ULL, 0x000000706440723cULL, 0x082f700000041840ULL,
0x000000706c58723cULL, 0x000f700000041858ULL, 0x0000007c6450723cULL, 0x084f700000041850ULL,
0x0000007c6c80723cULL, 0x000f700000041880ULL, 0x0000007e6454723cULL, 0x080f700000041854ULL,
0x0000007e6c3c723cULL, 0x000f70000004183cULL, 0x00000068642c723cULL, 0x088f70000004182cULL,
0x000000686c30723cULL, 0x000f700000041830ULL, 0x0000006a6434723cULL, 0x080f700000041834ULL,
0x0000006a6c38723cULL, 0x000f700000041838ULL, 0x000000726444723cULL, 0x040f700000041844ULL,
0x000000786448723cULL, 0x040f700000041848ULL, 0x0000007a644c723cULL, 0x000f70000004184cULL,
0x000000726c5c723cULL, 0x040f70000004185cULL, 0x000000786c60723cULL, 0x040f700000041860ULL,
0x0000007a6c74723cULL, 0x000f700000041874ULL, 0x000000908440723cULL, 0x0a0f700000041840ULL,
0x000000908c58723cULL, 0x000b6e0000041858ULL, 0x000003001d907a10ULL, 0x020fe20007ffe0ffULL,
0x000000248450723cULL, 0x080f700000041850ULL, 0x000000248c80723cULL, 0x000b6e0000041880ULL,
0x0000000190247810ULL, 0x020fe20007ffe0ffULL, 0x000000268454723cULL, 0x000f660000041854ULL,
0x000000192400720cULL, 0x000fe20003f06070ULL, 0x0000009f03247224ULL, 0x010fc800078e02ffULL,
0x000000268c3c723cULL, 0x000b62000004183cULL, 0x0000620024247625ULL, 0x000fcc00078e00a1ULL,
0x0000010090267824ULL, 0x020fe200078e02a0ULL, 0x00000088842c723cULL, 0x000b68000004182cULL,
0x0000004026697812ULL, 0x000fc800078ec0ffULL, 0x000000888c30723cULL, 0x000b620000041830ULL,
0x0000000102697824ULL, 0x000fce00078e0269ULL, 0x0000008a8434723cULL, 0x080b700000041834ULL,
0x0000008a8c38723cULL, 0x000b700000041838ULL, 0x000000928444723cULL, 0x040b700000041844ULL,
0x000000948448723cULL, 0x040b700000041848ULL, 0x00000096844c723cULL, 0x000b70000004184cULL,
0x000000928c5c723cULL, 0x040b70000004185cULL, 0x000000948c60723cULL, 0x040b700000041860ULL,
0x000000968c74723cULL, 0x000b620000041874ULL, 0x00000c4000008947ULL, 0x000fce0003800000ULL,
0x000000041c2a7810ULL, 0x040fe40007ffe0ffULL, 0x000000081c667810ULL, 0x000fc40007ffe0ffULL,
0x000000261b6b7217ULL, 0x000fe20007800000ULL, 0x000000012a277824ULL, 0x100fe200078e029dULL,
0x000000101c6a7810ULL, 0x000fe20007ffe0ffULL, 0x000000082a647824ULL, 0x000fe200078e00ffULL,
0x0000009d1c287210ULL, 0x080fe20007ffe0ffULL, 0x0000000166297824ULL, 0x000fe200078e029dULL,
0x000000141c707810ULL, 0x000fe20007ffe0ffULL, 0x0000000866687824ULL, 0x000fe200078e00ffULL,
0xfffffff864737812ULL, 0x000fe200078ee227ULL, 0x000000016b6b7824ULL, 0x000fe200078e0a26ULL,
0x0000000721717812ULL, 0x000fe200078ef828ULL, 0x000000011c267824ULL, 0x000fe200078e0269ULL,
0xfffffff868797812ULL, 0x000fe200078ee229ULL, 0x000000086a6c7824ULL, 0x000fe200078e00ffULL,
0x0000000c1c687810ULL, 0x000fe20007ffe0ffULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0x0000009d6a297210ULL, 0x000fc40007ffe0ffULL, 0x0000006b2a00720cULL, 0x040fe20003f46070ULL,
0x000000012a287824ULL, 0x000fe200078e0269ULL, 0x0000002226657212ULL, 0x080fe200078efcffULL,
0x0000000168217824ULL, 0x000fe200078e029dULL, 0xfffffff86c7d7812ULL, 0x000fe200078ee229ULL,
0x00000008682a7824ULL, 0x000fe200078e00ffULL, 0x0000006524647210ULL, 0x000fe20007f1e0ffULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x0000006b6600720cULL, 0x080fe40003f66070ULL,
0xfffffff82a7b7812ULL, 0x000fe200078ee221ULL, 0x0000000170267824ULL, 0x000fe200078e029dULL,
0x0000002228677212ULL, 0x000fe200078efcffULL, 0x00000008707f7824ULL, 0x000fe200078e00ffULL,
0x000000181c727810ULL, 0x000fe20007ffe0ffULL, 0x00000001682a7824ULL, 0x000fe200078e0269ULL,
0x0000006b1c00720cULL, 0x000fe20003f26070ULL, 0x0000000125657824ULL, 0x000fe200000e0627ULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee226ULL, 0x0000000166267824ULL, 0x000fe200078e0269ULL,
0x0000006724667210ULL, 0x000fe20007f1e0ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000006b6800720cULL, 0x000fc40003fa6070ULL, 0x0000000372857819ULL, 0x020fe200000006ffULL,
0x000000016a287824ULL, 0x000fe200078e0269ULL, 0x000000222a6f7212ULL, 0x080fe200078efcffULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x0000006b6a00720cULL, 0x000fe40003f86070ULL,
0x0000006f246e7210ULL, 0x000fe20007fde0ffULL, 0x0000000125677824ULL, 0x000fe200000e0629ULL,
0x00000022266d7212ULL, 0x000fe200078efcffULL, 0x0000010028287825ULL, 0x000fc600078e00ffULL,
0x0000006d246c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001256f7824ULL, 0x040fe200030e062bULL,
0x0000002228217212ULL, 0x000fe200078efcffULL, 0x0000000170287824ULL, 0x000fe400078e0269ULL,
0x00000001256d7824ULL, 0x040fe200000e0627ULL, 0x0000002124267210ULL, 0x000fe20007fde0ffULL,
0x0000000172687824ULL, 0x000fe200078e029dULL, 0x0000006b7000720cULL, 0x000fe20003f06070ULL,
0x00000001722a7824ULL, 0x000fe200078e0269ULL, 0x000000201c707810ULL, 0x000fe20007ffe0ffULL,
0x0000000125277824ULL, 0x000fe200030e0629ULL, 0xfffffff885857812ULL, 0x000fe200078ee268ULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x0000001c1c687810ULL, 0x000fc60007ffe0ffULL,
0x0000001071217824ULL, 0x000fe200078e0216ULL, 0x00000022282b7212ULL, 0x000fe200078efcffULL,
0x00000001686a7824ULL, 0x040fe400078e029dULL, 0x0000000868877824ULL, 0x000fe200078e00ffULL,
0x0000002b24287210ULL, 0x000fe20007fde0ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c901c48ULL,
0x0000006b7200720cULL, 0x000fe40003f26070ULL, 0x0000000125297824ULL, 0x000fe200030e0629ULL,
0x0000000370727819ULL, 0x040fe200000006ffULL, 0x0000000170717824ULL, 0x000fe200078e029dULL,
0xfffffff887877812ULL, 0x000fc400078ee26aULL, 0x000000241c6a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff872897812ULL, 0x000fe200078ee271ULL, 0x0000001079717824ULL, 0x100fe200078e0216ULL,
0x000000222a657212ULL, 0x002fe200078efcffULL, 0x0000001073217824ULL, 0x000fe200078e0216ULL,
0x000000301c727810ULL, 0x000fe20007ffe0ffULL, 0x0000000168647824ULL, 0x000fe200078e0269ULL,
0x00000065242a7210ULL, 0x000fe20007fde0ffULL, 0x000000086a797824ULL, 0x000fe200078e00ffULL,
0x0000000066217faeULL, 0x0003e2000d101c48ULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0x0000006b6800720cULL, 0x000fc40003f46070ULL, 0x000000006c717faeULL, 0x0005e2000d901c48ULL,
0x0000000170687824ULL, 0x000fe200078e0269ULL, 0x0000002264737212ULL, 0x000fe200078efcffULL,
0x00000001252b7824ULL, 0x000fe200030e062bULL, 0x0000006b7000720cULL, 0x000fe40003f66070ULL,
0x0000007324647210ULL, 0x000fe20007fde0ffULL, 0x000000107d737824ULL, 0x000fe400078e0216ULL,
0x0000010068667825ULL, 0x002fe200078e00ffULL, 0x000000696a6c7210ULL, 0x004fc60007ffe0ffULL,
0x000000016a687824ULL, 0x000fe200078e029dULL, 0x00000022666d7212ULL, 0x080fe200078efcffULL,
0x000000107b217824ULL, 0x000fe400078e0216ULL, 0x0000000125657824ULL, 0x000fe200030e0665ULL,
0x0000006d24667210ULL, 0x000fe20007fde0ffULL, 0x000001006c6c7825ULL, 0x000fe200078e00ffULL,
0xfffffff879797812ULL, 0x000fe200078ee268ULL, 0x000000006e217faeULL, 0x0003e2000e901c48ULL,
0x000000281c687810ULL, 0x000fe20007ffe0ffULL, 0x0000000125677824ULL, 0x000fe200030e0667ULL,
0x0000006b6a00720cULL, 0x080fe20003fa6070ULL, 0x0000000026737faeULL, 0x0005e2000e101c48ULL,
0x000000226c717212ULL, 0x000fe200078efcffULL, 0x00000008686a7824ULL, 0x040fe200078e00ffULL,
0x0000006b6800720cULL, 0x000fc40003f86070ULL, 0x0000007124707210ULL, 0x000fe20007fde0ffULL,
0x0000000168217824ULL, 0x042fe400078e029dULL, 0x0000000168687824ULL, 0x000fe400078e0269ULL,
0x0000000125717824ULL, 0x000fe200030e066dULL, 0xfffffff86a7b7812ULL, 0x000fe200078ee221ULL,
0x0000010068267825ULL, 0x004fe200078e00ffULL, 0x0000002c1c6a7810ULL, 0x000fc60007ffe0ffULL,
0x00000001726e7824ULL, 0x100fe200078e0269ULL, 0x00000022266d7212ULL, 0x000fe200078efcffULL,
0x000000016a6c7824ULL, 0x040fe200078e0269ULL, 0x0000009d6a687210ULL, 0x000fe20007ffe0ffULL,
0x000000107f217824ULL, 0x000fe200078e0216ULL, 0x0000006d24267210ULL, 0x000fe20007fde0ffULL,
0x000001006c6c7825ULL, 0x000fc600078e00ffULL, 0x0000000028217faeULL, 0x0003e2000c101c48ULL,
0x000001006e6e7825ULL, 0x000fe200078e00ffULL, 0x0000006b6a00720cULL, 0x000fc60003f06070ULL,
0x0000000125277824ULL, 0x000fe200030e0627ULL, 0x000000226e737212ULL, 0x080fe200078efcffULL,
0x000000086a7d7824ULL, 0x000fe200078e00ffULL, 0x000000341c6e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008727f7824ULL, 0x000fe200078e00ffULL, 0x000000226c297212ULL, 0x002fe200078efcffULL,
0x0000001085217824ULL, 0x000fe200078e0216ULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee268ULL,
0x0000000172687824ULL, 0x000fe200078e029dULL, 0x0000002924287210ULL, 0x000fe40007fde0ffULL,
0x000000002a217faeULL, 0x0003e2000c901c48ULL, 0x0000006b7200720cULL, 0x000fc40003f26070ULL,
0x0000000125297824ULL, 0x000fe200030e066dULL, 0x00000073246c7210ULL, 0x000fe20007fde0ffULL,
0x0000001087737824ULL, 0x000fe200078e0216ULL, 0xfffffff87f7f7812ULL, 0x000fe400078ee268ULL,
0x0000006f256d7210ULL, 0x000fe200037fe4ffULL, 0x00000010796f7824ULL, 0x100fe200078e0216ULL,
0x000000381c687810ULL, 0x000fe20007ffe0ffULL, 0x0000000064737faeULL, 0x0005e2000d101c48ULL,
0x000000016e2a7824ULL, 0x002fe200078e0269ULL, 0x0000003c1c727810ULL, 0x000fe20007ffe0ffULL,
0x0000001089217824ULL, 0x000fc400078e0216ULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000006b7200720cULL, 0x080fe40003f46070ULL, 0x0000000066217faeULL, 0x0003e2000d901c48ULL,
0x0000006b6800720cULL, 0x080fe20003f66070ULL, 0x000000016e1c7824ULL, 0x000fe200078e029dULL,
0x000000222a797212ULL, 0x000fe200078efcffULL, 0x00000001682a7824ULL, 0x100fe200078e0269ULL,
0x00000000706f7faeULL, 0x0007e2000e901c48ULL, 0x0000006b6e00720cULL, 0x000fe20003fa6070ULL,
0x0000000172647824ULL, 0x004fe200078e0269ULL, 0x00000079246a7210ULL, 0x000fe20007fde0ffULL,
0x000000086e737824ULL, 0x000fc400078e00ffULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0x0000009d72677210ULL, 0x002fc60007ffe0ffULL, 0x00000001256b7824ULL, 0x000fe400030e062bULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x00000022646f7212ULL, 0x088fe400078efcffULL,
0xfffffff873717812ULL, 0x000fe200078ee21cULL, 0x0000000168667824ULL, 0x000fe200078e029dULL,
0x000000222a217212ULL, 0x000fe200078efcffULL, 0x0000000868697824ULL, 0x000fe400078e00ffULL,
0x0000000872727824ULL, 0x000fe200078e00ffULL, 0x00000021242a7210ULL, 0x000fe20007fde0ffULL,
0x000000107b217824ULL, 0x000fe200078e0216ULL, 0xfffffff869737812ULL, 0x000fe200078ee266ULL,
0x000000107f697824ULL, 0x100fe200078e0216ULL, 0xfffffff872797812ULL, 0x000fe200078ee267ULL,
0x00000001252b7824ULL, 0x000fe200030e062bULL, 0x0000006f24247210ULL, 0x000fe20007fde0ffULL,
0x000000107d677824ULL, 0x100fe200078e0216ULL, 0x0000000026217faeULL, 0x0003e2000e101c48ULL,
0x00000010716f7824ULL, 0x000fc400078e0216ULL, 0x0000001073717824ULL, 0x100fe200078e0216ULL,
0x0000000028677faeULL, 0x0003e2000c101c48ULL, 0x0000001079737824ULL, 0x000fe400078e0216ULL,
0x0000000125257824ULL, 0x000fe200030e0665ULL, 0x000000006c697faeULL, 0x0003e8000c901c48ULL,
0x000000006a6f7faeULL, 0x0003e8000e901c48ULL, 0x000000002a717faeULL, 0x0003e8000d901c48ULL,
0x0000000024737faeULL, 0x0003e2000d101c48ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x0000000c1c647810ULL, 0x040fe40007ffe0ffULL, 0x000000081c2a7810ULL, 0x000fc40007ffe0ffULL,
0x000000041c287810ULL, 0x000fe20007ffe0ffULL, 0x0000000164667824ULL, 0x100fe200078e029dULL,
0x0000009d1c267210ULL, 0x000fe20007ffe0ffULL, 0x00000008646b7824ULL, 0x000fe200078e00ffULL,
0x0000001c1c6c7810ULL, 0x000fe20007ffe0ffULL, 0x000000012a2b7824ULL, 0x140fe200078e029dULL,
0x0000000721297812ULL, 0x000fe200078ef826ULL, 0x000000082a6a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee266ULL, 0x0000000128277824ULL, 0x000fe200078e029dULL,
0x000000101c667810ULL, 0x000fe20007ffe0ffULL, 0x0000000828687824ULL, 0x000fe200078e00ffULL,
0xfffffff86a677812ULL, 0x000fe200078ee22bULL, 0x000000016c2b7824ULL, 0x100fe200078e029dULL,
0x000000181c6a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000166217824ULL, 0x000fe200078e029dULL,
0xfffffff868657812ULL, 0x000fe200078ee227ULL, 0x00000008666e7824ULL, 0x000fe200078e00ffULL,
0x000000141c687810ULL, 0x000fe20007ffe0ffULL, 0x000000016a277824ULL, 0x000fe200078e029dULL,
0x0000002c1c787810ULL, 0x000fe20007ffe0ffULL, 0x000000086a707824ULL, 0x000fe200078e00ffULL,
0xfffffff86e6d7812ULL, 0x000fe200078ee221ULL, 0x000000086c727824ULL, 0x000fe200078e00ffULL,
0x000000201c6e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000168267824ULL, 0x000fe200078e029dULL,
0xfffffff870717812ULL, 0x000fe200078ee227ULL, 0x00000008787e7824ULL, 0x000fe200078e00ffULL,
0x00000003686f7819ULL, 0x000fe200000006ffULL, 0x000000016e217824ULL, 0x000fe200078e029dULL,
0x000000241c707810ULL, 0x000fe20007ffe0ffULL, 0x000000086e7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff872737812ULL, 0x000fe200078ee22bULL, 0x00000001782b7824ULL, 0x100fe200078e029dULL,
0x000000281c727810ULL, 0x000fe20007ffe0ffULL, 0x00000008707b7824ULL, 0x040fe200078e00ffULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee226ULL, 0x0000000170267824ULL, 0x100fe200078e029dULL,
0x00000003727c7819ULL, 0x040fe200000006ffULL, 0x0000000172277824ULL, 0x000fe200078e029dULL,
0xfffffff87a797812ULL, 0x000fe200078ee221ULL, 0x0000000128287824ULL, 0x100fe200078e0269ULL,
0x000000301c7a7810ULL, 0x000fe20007ffe0ffULL, 0x000000012a2a7824ULL, 0x100fe200078e0269ULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee226ULL, 0x000000011c267824ULL, 0x000fe200078e0269ULL,
0xfffffff87c7d7812ULL, 0x000fe200078ee227ULL, 0x000000017a217824ULL, 0x000fe200078e029dULL,
0x000000341c7c7810ULL, 0x000fe20007ffe0ffULL, 0x000000087a8c7824ULL, 0x020fe200078e00ffULL,
0x000000381c847810ULL, 0x000fe20007ffe0ffULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0x0000003c1c887810ULL, 0x000fc40007ffe0ffULL, 0xfffffff87e7f7812ULL, 0x000fe200078ee22bULL,
0x0000000164647824ULL, 0x100fe200078e0269ULL, 0x000000696c6c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000166667824ULL, 0x100fe200078e0269ULL, 0x000000037c8e7819ULL, 0x000fe200000006ffULL,
0x0000000168687824ULL, 0x100fe200078e0269ULL, 0x000000166b8d7211ULL, 0x000fe200078e20ffULL,
0x000000016a6a7824ULL, 0x100fe400078e0269ULL, 0x000000016e6e7824ULL, 0x100fe400078e0269ULL,
0x0000000170707824ULL, 0x000fc400078e0269ULL, 0x0000000172727824ULL, 0x100fe400078e0269ULL,
0x0000000178787824ULL, 0x100fe400078e0269ULL, 0x000000017a1c7824ULL, 0x100fe400078e0269ULL,
0x000000017c7e7824ULL, 0x100fe400078e0269ULL, 0x0000000184867824ULL, 0x100fe400078e0269ULL,
0x00000001888a7824ULL, 0x000fe200078e0269ULL, 0xfffffff88c697812ULL, 0x000fe200078ee221ULL,
0x000000017c2b7824ULL, 0x000fe200078e029dULL, 0x0000002226217212ULL, 0x000fe200078efcffULL,
0x0000001029877824ULL, 0x000fc400078e0216ULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0xfffffff88e857812ULL, 0x000fe400078ee22bULL, 0x0000002124267210ULL, 0x000fe20007f1e0ffULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x0000002228217212ULL, 0x000fe400078efcffULL,
0x0000001685ab7211ULL, 0x000fe200078e20ffULL, 0x0000001065897824ULL, 0x000fe200078e0216ULL,
0x0000002124287210ULL, 0x000fe20007f3e0ffULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0x000000222a217212ULL, 0x000fc600078efcffULL, 0x00000010678b7824ULL, 0x100fe400078e0216ULL,
0x0000000125277824ULL, 0x000fe200000e0627ULL, 0x00000021242a7210ULL, 0x000fe20007f1e0ffULL,
0x0000010066667825ULL, 0x000fe200078e00ffULL, 0x0000002264217212ULL, 0x080fe400078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026877faeULL, 0x0003e2000b901c48ULL,
0x0000001069a77824ULL, 0x100fe400078e0216ULL, 0x000000106d8f7824ULL, 0x000fe200078e0216ULL,
0x00000022666d7212ULL, 0x000fe200078efcffULL, 0x0000010068687825ULL, 0x000fc800078e00ffULL,
0x00000001252b7824ULL, 0x000fe200000e062bULL, 0x0000002124647210ULL, 0x000fe20007f1e0ffULL,
0x000001006a6a7825ULL, 0x000fe200078e00ffULL, 0x0000002268217212ULL, 0x000fc600078efcffULL,
0x0000000125297824ULL, 0x000fe200008e0629ULL, 0x0000006d24667210ULL, 0x000fe20007f3e0ffULL,
0x000001006c6c7825ULL, 0x000fc600078e00ffULL, 0x0000000028897faeULL, 0x0003e2000b901c48ULL,
0x000000106f917824ULL, 0x100fe200078e0216ULL, 0x000000226a6f7212ULL, 0x080fe200078efcffULL,
0x0000000125657824ULL, 0x000fe200000e0665ULL, 0x0000002124687210ULL, 0x000fe20007f1e0ffULL,
0x0000001071937824ULL, 0x100fe200078e0216ULL, 0x000000226c217212ULL, 0x000fe200078efcffULL,
0x0000010070707825ULL, 0x000fe200078e00ffULL, 0x0000006f246a7210ULL, 0x000fe20007f5e0ffULL,
0x000000002a8b7faeULL, 0x0003e4000b901c48ULL, 0x0000001073957824ULL, 0x000fc400078e0216ULL,
0x000001006e6e7825ULL, 0x000fe200078e00ffULL, 0x00000000648d7faeULL, 0x0003e6000b901c48ULL,
0x0000000125697824ULL, 0x040fe200000e0669ULL, 0x00000021246c7210ULL, 0x000fe20007f1e0ffULL,
0x0000010072727825ULL, 0x000fe200078e00ffULL, 0x0000002270217212ULL, 0x000fe400078efcffULL,
0x0000006d256d7210ULL, 0x000fe200007fe4ffULL, 0x0000001079977824ULL, 0x000fe200078e0216ULL,
0x0000002124707210ULL, 0x000fe20007f1e0ffULL, 0x00000001847a7824ULL, 0x000fc400078e029dULL,
0x0000000884a97824ULL, 0x000fe400078e00ffULL, 0x000000107ba17824ULL, 0x000fe200078e0216ULL,
0x000000226e7b7212ULL, 0x000fe200078efcffULL, 0x0000010078787825ULL, 0x000fe200078e00ffULL,
0xfffffff8a9a97812ULL, 0x000fc600078ee27aULL, 0x00000001887c7824ULL, 0x000fe200078e029dULL,
0x0000002278217212ULL, 0x080fe200078efcffULL, 0x0000000888ad7824ULL, 0x000fe400078e00ffULL,
0x000000107da37824ULL, 0x000fe200078e0216ULL, 0x00000022727d7212ULL, 0x000fe200078efcffULL,
0x0000000125677824ULL, 0x040fe200008e0667ULL, 0x0000007b246e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001256b7824ULL, 0x000fe200010e066bULL, 0xfffffff8adad7812ULL, 0x000fe200078ee27cULL,
0x000001001c7a7825ULL, 0x000fe200078e00ffULL, 0x0000007d24727210ULL, 0x000fe20007f5e0ffULL,
0x00000000668f7faeULL, 0x0003e4000b901c48ULL, 0x000000107fa57824ULL, 0x000fc400078e0216ULL,
0x000001007e7c7825ULL, 0x000fe200078e00ffULL, 0x0000000068917faeULL, 0x0003e6000b901c48ULL,
0x0000000125717824ULL, 0x000fe200000e0671ULL, 0x0000002124787210ULL, 0x000fe20007f1e0ffULL,
0x00000100867e7825ULL, 0x000fe200078e00ffULL, 0x000000227a217212ULL, 0x000fe200078efcffULL,
0x000000006a937faeULL, 0x0003e4000b901c48ULL, 0x000001008a847825ULL, 0x000fc400078e00ffULL,
0x000000006c957faeULL, 0x0003e4000b901c48ULL, 0x00000010a9af7824ULL, 0x100fe200078e0216ULL,
0x000000227ca97212ULL, 0x080fe200078efcffULL, 0x00000010adb37824ULL, 0x000fe200078e0216ULL,
0x000000227ead7212ULL, 0x080fe200078efcffULL, 0x0000000125797824ULL, 0x040fe200000e0679ULL,
0x0000002284b17212ULL, 0x000fe200078efcffULL, 0x00000001256f7824ULL, 0x040fe200008e066fULL,
0x00000021247a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000125737824ULL, 0x000fe200010e0673ULL,
0x000000a9247c7210ULL, 0x000fc40007f3e0ffULL, 0x000000ad247e7210ULL, 0x040fe20007f5e0ffULL,
0x00000001257b7824ULL, 0x040fe200000e067bULL, 0x000000b124247210ULL, 0x000fe20007f7e0ffULL,
0x00000001257d7824ULL, 0x040fe200008e067dULL, 0x000000006e977faeULL, 0x0003e2000b901c48ULL,
0x00000001257f7824ULL, 0x040fe400010e067fULL, 0x0000000125257824ULL, 0x000fe200018e0685ULL,
0x0000000070a17faeULL, 0x0003e8000b901c48ULL, 0x0000000072a37faeULL, 0x0003e8000b901c48ULL,
0x0000000078a57faeULL, 0x0003e8000b901c48ULL, 0x000000007aa77faeULL, 0x0003e8000b901c48ULL,
0x000000007cab7faeULL, 0x0003e8000b901c48ULL, 0x000000007eaf7faeULL, 0x0003e8000b901c48ULL,
0x0000000024b37faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001020217824ULL, 0x002fe200078e00ffULL, 0x000000081f167810ULL, 0x000fc40007ffe0ffULL,
0x00000008141c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000417257819ULL, 0x000fe400000006ffULL,
0x0000400018187810ULL, 0x000fe40007ffe0ffULL, 0xfffffff021167812ULL, 0x000fe400078ee216ULL,
0xfffffff0251c7812ULL, 0x000fe200078ee21cULL, 0x0000001015247824ULL, 0x000fe400078e0218ULL,
0x0000001016167824ULL, 0x000fc400078e00ffULL, 0x000000101c1c7824ULL, 0x000fe400078e00ffULL,
0x00000010126c7824ULL, 0x100fe400078e0218ULL, 0x0000001011687824ULL, 0x000fe200078e0218ULL,
0x0000000a1f117810ULL, 0x000fe20007ffe0ffULL, 0x0000001020127824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002424783bULL, 0x000fe20000000200ULL,
0xfffffff012117812ULL, 0x000fe200078ee211ULL, 0x0000001017157824ULL, 0x000fe200078e00ffULL,
0x0000000a14127810ULL, 0x000fe20007ffe0ffULL, 0x000000001628783bULL, 0x0002a20000000200ULL,
0x0000001010107824ULL, 0x100fe200078e0218ULL, 0x0000000411787819ULL, 0x000fe200000006ffULL,
0x0000001013707824ULL, 0x000fe200078e0218ULL, 0x000000001c64783bULL, 0x000ee20000000200ULL,
0xfffffff015157812ULL, 0x000fe200078ee212ULL, 0x000000100e887824ULL, 0x000fc400078e0218ULL,
0x000000001010783bULL, 0x000fe20000000200ULL, 0x000000100d8c7824ULL, 0x100fe200078e0218ULL,
0x0000000c1f0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0x000000007878783bULL, 0x000f220000000200ULL, 0x00000010200e7824ULL, 0x000fe200078e00ffULL,
0x0000000e1f1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000100f7c7824ULL, 0x000fe200078e0218ULL,
0x000000001584783bULL, 0x0003240000000200ULL, 0x0000001017167824ULL, 0x042fe200078e00ffULL,
0xfffffff00e0d7812ULL, 0x000fe200078ee20dULL, 0x0000001020207824ULL, 0x000fe200078e00ffULL,
0x000000007070783bULL, 0x000e620000000200ULL, 0x0000001017177824ULL, 0x000fc400078e00ffULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0x000000006c6c783bULL, 0x000e620000000200ULL,
0x0000000c14157810ULL, 0x000fe20007ffe0ffULL, 0x0000001008087824ULL, 0x100fe200078e0218ULL,
0x0000000e14147810ULL, 0x000fe20007ffe0ffULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0xfffffff016157812ULL, 0x000fe200078ee215ULL, 0x0000001007167824ULL, 0x000fe200078e0218ULL,
0xfffffff0201f7812ULL, 0x000fe200078ee21fULL, 0x000000007c7c783bULL, 0x000e620000000200ULL,
0xfffffff017077812ULL, 0x000fe200078ee214ULL, 0x0000001015157824ULL, 0x000fc400078e00ffULL,
0x000000008888783bULL, 0x000e620000000200ULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0x0000000407077819ULL, 0x000fe200000006ffULL, 0x00000024282c723cULL, 0x084f62000004182cULL,
0x000000008c8c783bULL, 0x000eae0000000200ULL, 0x000000246430723cULL, 0x008b6e0000041830ULL,
0x000000100b247824ULL, 0x120fe200078e0218ULL, 0x000000262834723cULL, 0x080f700000041834ULL,
0x000000266438723cULL, 0x000b640000041838ULL, 0x000000002424783bULL, 0x020fec0000000200ULL,
0x00000010782c723cULL, 0x090ff0000004182cULL, 0x000000108430723cULL, 0x000bee0000041830ULL,
0x000000100c107824ULL, 0x120fe200078e0218ULL, 0x000000127834723cULL, 0x080fe20000041834ULL,
0x000000000d0c783bULL, 0x000fee0000000200ULL, 0x000000128438723cULL, 0x000be40000041838ULL,
0x000000001010783bULL, 0x020eec0000000200ULL, 0x000000702840723cULL, 0x042f700000041840ULL,
0x000000722844723cULL, 0x040f700000041844ULL, 0x0000006c2848723cULL, 0x040f700000041848ULL,
0x0000006e284c723cULL, 0x040f70000004184cULL, 0x000000682850723cULL, 0x040f700000041850ULL,
0x0000006a2854723cULL, 0x000b6e0000041854ULL, 0x000000180a287211ULL, 0x020fe200078e20ffULL,
0x000000706458723cULL, 0x040b6a0000041858ULL, 0x000000002828783bULL, 0x000e640000000200ULL,
0x0000001005707824ULL, 0x120fe200078e0218ULL, 0x00000072645c723cULL, 0x040b6a000004185cULL,
0x000000007070783bULL, 0x020fe60000000200ULL, 0x0000006c6460723cULL, 0x040f700000041860ULL,
0x0000006e6474723cULL, 0x040b640000041874ULL, 0x000000001f6c783bULL, 0x020fec0000000200ULL,
0x000000686480723cULL, 0x040b6e0000041880ULL, 0x0000001009687824ULL, 0x120fe200078e0218ULL,
0x0000006a643c723cULL, 0x000b62000004183cULL, 0x000000000808783bULL, 0x000fe80000000200ULL,
0x000000006868783bULL, 0x020f260000000200ULL, 0x0000007c7840723cULL, 0x040f620000041840ULL,
0x000000001564783bULL, 0x000e680000000200ULL, 0x000000001614783bULL, 0x000fe60000000200ULL,
0x0000007e7844723cULL, 0x040f700000041844ULL, 0x000000887848723cULL, 0x040f700000041848ULL,
0x0000008a784c723cULL, 0x040f70000004184cULL, 0x0000008c7850723cULL, 0x044f700000041850ULL,
0x0000008e7854723cULL, 0x000f700000041854ULL, 0x0000007c8458723cULL, 0x040f700000041858ULL,
0x0000007e845c723cULL, 0x040f70000004185cULL, 0x000000888460723cULL, 0x040f700000041860ULL,
0x0000008a8474723cULL, 0x040f700000041874ULL, 0x0000008c8480723cULL, 0x040f700000041880ULL,
0x0000008e8484723cULL, 0x000b6e000004183cULL, 0x00000010063c7824ULL, 0x020fe200078e0218ULL,
0x000000100c78723cULL, 0x048be4000004182cULL, 0x00000000072c783bULL, 0x020fe80000000200ULL,
0x000000003c3c783bULL, 0x000ea40000000200ULL, 0x000000120c34723cULL, 0x040ff00000041834ULL,
0x000000240c40723cULL, 0x040ff00000041840ULL, 0x000000260c44723cULL, 0x040ff00000041844ULL,
0x000000280c48723cULL, 0x042ff00000041848ULL, 0x0000002a0c4c723cULL, 0x040f70000004184cULL,
0x000000680c50723cULL, 0x050ff00000041850ULL, 0x0000006a0c54723cULL, 0x000ff00000041854ULL,
0x000000106430723cULL, 0x040ff00000041830ULL, 0x000000126438723cULL, 0x040ff00000041838ULL,
0x00000024640c723cULL, 0x040ff00000041858ULL, 0x00000026645c723cULL, 0x040ff0000004185cULL,
0x000000286410723cULL, 0x040ff00000041860ULL, 0x0000002a6474723cULL, 0x040ff00000041874ULL,
0x000000686424723cULL, 0x040ff00000041880ULL, 0x0000006a6484723cULL, 0x000ff00000041884ULL,
0x0000003e6c4c723cULL, 0x064f70000004184cULL, 0x000000086c78723cULL, 0x040f700000041878ULL,
0x0000000a6c34723cULL, 0x040f700000041834ULL, 0x000000146c40723cULL, 0x000f640000041840ULL,
0x3db504f34d1c7820ULL, 0x020fc40000410000ULL, 0x3db504f34c207820ULL, 0x000fe40000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe40000410000ULL, 0x3db504f34f4f7820ULL, 0x000fe20000410000ULL,
0x000000166c44723cULL, 0x000f620000041844ULL, 0x3db504f378077820ULL, 0x000fe40000410000ULL,
0x3db504f379797820ULL, 0x000fe40000410000ULL, 0x3db504f37a7a7820ULL, 0x000fc40000410000ULL,
0x3db504f37b217820ULL, 0x000fe20000410000ULL, 0x0000003c6c48723cULL, 0x040f620000041848ULL,
0x3db504f336227820ULL, 0x000fe40000410000ULL, 0x3db504f334347820ULL, 0x000fe40000410000ULL,
0x3db504f335357820ULL, 0x000fe40000410000ULL, 0x3db504f337377820ULL, 0x000fe20000410000ULL,
0x000000706c50723cULL, 0x000f620000041850ULL, 0x3db504f340407820ULL, 0x000fc40000410000ULL,
0x3db504f341417820ULL, 0x000fe40000410000ULL, 0x3db504f342427820ULL, 0x000fe40000410000ULL,
0x3db504f343437820ULL, 0x000fe20000410000ULL, 0x000000082c30723cULL, 0x000f640000041830ULL,
0x3db504f347287820ULL, 0x020fe40000410000ULL, 0x3db504f344447820ULL, 0x000fe40000410000ULL,
0x3db504f345457820ULL, 0x000fc40000410000ULL, 0x3db504f346467820ULL, 0x000fe20000410000ULL,
0x000000142c0c723cULL, 0x040f62000004180cULL, 0x3db504f349187820ULL, 0x000fe40000410000ULL,
0x3db504f34a297820ULL, 0x000fe40000410000ULL, 0x3db504f34b2a7820ULL, 0x000fe40000410000ULL,
0x3db504f348487820ULL, 0x000fe20000410000ULL, 0x0000003c2c10723cULL, 0x000f620000041810ULL,
0x3db504f3501f7820ULL, 0x000fc40000410000ULL, 0x3db504f351517820ULL, 0x000fe40000410000ULL,
0x3db504f352527820ULL, 0x000fe40000410000ULL, 0x3db504f353537820ULL, 0x000fe20000410000ULL,
0x000000726c54723cULL, 0x000f620000041854ULL, 0x3db504f3334d7820ULL, 0x000fe40000410000ULL,
0x3db504f330307820ULL, 0x000fe40000410000ULL, 0x3db504f3324c7820ULL, 0x000fc60000410000ULL,
0x0000000a2c08723cULL, 0x000b640000041838ULL, 0x3db504f30c057820ULL, 0x020fe40000410000ULL,
0x3db504f30d067820ULL, 0x000fc60000410000ULL, 0x3db504f331397820ULL, 0x000fe20000410000ULL,
0x000000162c14723cULL, 0x000f62000004185cULL, 0x3db504f30e387820ULL, 0x000fe40000410000ULL,
0x3db504f3125a7820ULL, 0x000fe40000410000ULL, 0x3db504f3135b7820ULL, 0x000fc60000410000ULL,
0x0000003e2c3c723cULL, 0x040f620000041874ULL, 0x3db504f356367820ULL, 0x000fe40000410000ULL,
0x3db504f354547820ULL, 0x000fe40000410000ULL, 0x3db504f355557820ULL, 0x000fe40000410000ULL,
0x3db504f357577820ULL, 0x000fe20000410000ULL, 0x000000702c24723cULL, 0x000f620000041824ULL,
0x3db504f3083a7820ULL, 0x000fe40000410000ULL, 0x3db504f3093b7820ULL, 0x000fc40000410000ULL,
0x3db504f30a337820ULL, 0x000fe40000410000ULL, 0x3db504f30b507820ULL, 0x000fe20000410000ULL,
0x000000722c2c723cULL, 0x000f620000041884ULL, 0x3db504f30f567820ULL, 0x000fe40000410000ULL,
0x3db504f314087820ULL, 0x020fe40000410000ULL, 0x3db504f315097820ULL, 0x000fe40000410000ULL,
0x3db504f316587820ULL, 0x000fc40000410000ULL, 0x3db504f317597820ULL, 0x000fe40000410000ULL,
0x3db504f3100a7820ULL, 0x000fe40000410000ULL, 0x3db504f3110b7820ULL, 0x000fe40000410000ULL,
0x3db504f33c2b7820ULL, 0x000fe40000410000ULL, 0x3db504f33d3d7820ULL, 0x000fe40000410000ULL,
0x3db504f33e5c7820ULL, 0x000fc40000410000ULL, 0x3db504f33f5d7820ULL, 0x000fe40000410000ULL,
0x3db504f324477820ULL, 0x000fe40000410000ULL, 0x3db504f325497820ULL, 0x000fe40000410000ULL,
0x3db504f3265e7820ULL, 0x000fe40000410000ULL, 0x3db504f3275f7820ULL, 0x000fe40000410000ULL,
0x3db504f32c4a7820ULL, 0x000fc40000410000ULL, 0x3db504f32d4b7820ULL, 0x000fe40000410000ULL,
0x3db504f32e607820ULL, 0x000fe40000410000ULL, 0x3db504f32f617820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ffff317224ULL, 0x000fe200078e0052ULL,
0x0000005300327202ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fe200078e0045ULL,
0x000000009c527f8cULL, 0x0002a2000c80043fULL, 0x000000ffff247224ULL, 0x000fe200078e0037ULL,
0x0000005400177202ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe200078e0046ULL,
0x0000003d00467202ULL, 0x000fe20000000f00ULL, 0x000000ffff2c7224ULL, 0x000fc400078e004eULL,
0x000000ffff2f7224ULL, 0x000fe400078e004fULL, 0x000000ffff0d7224ULL, 0x000fe400078e0034ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0035ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0040ULL,
0x000000ffff107224ULL, 0x000fe400078e0041ULL, 0x000000ffff117224ULL, 0x000fc400078e0044ULL,
0x000000ffff137224ULL, 0x000fe400078e0048ULL, 0x000000ffff257224ULL, 0x000fe400078e0042ULL,
0x000000ffff267224ULL, 0x000fe400078e0043ULL, 0x000000ffff377224ULL, 0x000fe200078e0030ULL,
0x0000005e00307202ULL, 0x000fe20000000f00ULL, 0x000000ffff457224ULL, 0x000fe400078e002bULL,
0x000000ffff4f7224ULL, 0x000fc400078e0033ULL, 0x000000ffff4e7224ULL, 0x000fe400078e0038ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0079ULL, 0x000000ffff167224ULL, 0x000fe400078e0051ULL,
0x000000ffff157224ULL, 0x000fe400078e0055ULL, 0x000000ffff147224ULL, 0x000fe400078e007aULL,
0x000000ffff357224ULL, 0x000fc400078e0057ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0005ULL,
0x000000ffff3f7224ULL, 0x000fe400078e0006ULL, 0x000000ffff417224ULL, 0x000fe400078e0008ULL,
0x000000ffff427224ULL, 0x000fe400078e0009ULL, 0x000000ffff437224ULL, 0x000fe400078e000aULL,
0x000000ffff447224ULL, 0x000fc400078e000bULL, 0x000000ffff487224ULL, 0x000fe400078e0056ULL,
0x000000ffff3d7224ULL, 0x000fe400078e0058ULL, 0x000000ffff3e7224ULL, 0x000fe400078e0059ULL,
0x000000ffff407224ULL, 0x000fe400078e005aULL, 0x000000ffff2e7224ULL, 0x000fe400078e005bULL,
0x000000ffff2b7224ULL, 0x000fc400078e005cULL, 0x000000ffff2d7224ULL, 0x000fe400078e005dULL,
0x000000ffff337224ULL, 0x000fe400078e005fULL, 0x000000ffff347224ULL, 0x000fe400078e0060ULL,
0x000000ffff387224ULL, 0x000fc400078e0061ULL, 0x0000000000087805ULL, 0x006fca0000015200ULL,
0x000004009c057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804853ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff517224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000105100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08067210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e09ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140aULL,
0x0000000605057211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e060aULL,
0x0000000205057819ULL, 0x000fc80000001206ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000151517810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004009c057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000049d067824ULL, 0x000fe200078e00ffULL, 0x000000991d00720cULL, 0x000fc80003f06070ULL,
0xfffffff006057812ULL, 0x000fca00078ec0ffULL, 0x000000801e057824ULL, 0x000fca00078e0205ULL,
0x01e4000005087984ULL, 0x0002a20000000c00ULL, 0x00001f5000008947ULL, 0x000fea0003800000ULL,
0x000000029d527824ULL, 0x000fe200078e00ffULL, 0x000000231b547217ULL, 0x000fe20007800000ULL,
0x00000002ff697424ULL, 0x000fe200078e00ffULL, 0x000000009d1d7211ULL, 0x000fe400078ff0ffULL,
0x0000000652527812ULL, 0x000fe400078ec0ffULL, 0x0000005423237210ULL, 0x000fe40007ffe1ffULL,
0x00005a00ff567a19ULL, 0x000fe2000001161dULL, 0x000000019a587824ULL, 0x000fe200078e0252ULL,
0x0000580052547a10ULL, 0x000fc40007ffe0ffULL, 0x000000081d517810ULL, 0x040fe40007ffe0ffULL,
0x000000235800720cULL, 0x040fe20003f26070ULL, 0x0000000158587824ULL, 0x100fe200078e0a23ULL,
0x000000101d537810ULL, 0x040fe40007ffe0ffULL, 0x000000181d557810ULL, 0x000fe40007ffe0ffULL,
0x000000569b1d7217ULL, 0x000fe20003800000ULL, 0x0000000154567824ULL, 0x000fe200078e0a23ULL,
0x00005a00ff5a7a19ULL, 0x000fc40000011651ULL, 0x000000589b587217ULL, 0x040fe20003800000ULL,
0x0000001d987c7224ULL, 0x000fe200078e02ffULL, 0x0000005a9b517217ULL, 0x040fe40003800000ULL,
0x000000235400720cULL, 0x000fe40003f06070ULL, 0x000000569b567217ULL, 0x000fe20003800000ULL,
0x0000005198827224ULL, 0x000fe200078e02ffULL, 0x00000004ff587819ULL, 0x000fe40000011658ULL,
0x00005a00ff5e7a19ULL, 0x000fc40000011655ULL, 0x000000ff56677207ULL, 0x000fe40000000000ULL,
0x00005a00ff5c7a19ULL, 0x000fe40000011653ULL, 0x000000ff58537207ULL, 0x000fe40000800000ULL,
0x0000005e9b517217ULL, 0x000fe40003800000ULL, 0x0000007c67587211ULL, 0x000fe200078fe0ffULL,
0x000000017c567824ULL, 0x000fe200078e0253ULL, 0x0000005c9b1d7217ULL, 0x000fe20003800000ULL,
0x0000005198867224ULL, 0x000fe200078e02ffULL, 0x00000082675a7211ULL, 0x000fe200078fe0ffULL,
0x0000600058587625ULL, 0x000fc800078e0069ULL, 0x0000600056567625ULL, 0x000fc800078e0069ULL,
0x0000000153647824ULL, 0x000fe400078e0286ULL, 0x0000001d98847224ULL, 0x000fe200078e02ffULL,
0x0000000856567981ULL, 0x000722000c1e9500ULL, 0x000060005a5a7625ULL, 0x000fc600078e0069ULL,
0x00000008581d7981ULL, 0x000322000c1e9500ULL, 0x00000084675c7211ULL, 0x000fe200078fe0ffULL,
0x0000000153607824ULL, 0x040fe400078e0282ULL, 0x0000000153627824ULL, 0x000fe200078e0284ULL,
0x000000085a517981ULL, 0x000522000c1e9500ULL, 0x0000600064587625ULL, 0x002fe200078e0069ULL,
0x0000001052647812ULL, 0x000fc800078efcffULL, 0x0000580064667a10ULL, 0x000fe20007ffe0ffULL,
0x0000600060607625ULL, 0x080fe200078e0069ULL, 0x00000086675e7211ULL, 0x000fe200078fe0ffULL,
0x0000000858687981ULL, 0x000324000c1e9500ULL, 0x0000600062627625ULL, 0x000fc800078e0069ULL,
0x000000019a6a7824ULL, 0x000fe200078e0264ULL, 0x0000000860607981ULL, 0x000322000c1e9500ULL,
0x000060005c5c7625ULL, 0x000fc800078e0069ULL, 0x00000001665a7824ULL, 0x044fe200078e0a23ULL,
0x0000006a236c7210ULL, 0x000fe20007ffe1ffULL, 0x000000085c537981ULL, 0x000522000c1e9500ULL,
0x000000236600720cULL, 0x000fe40003f06070ULL, 0x0000005a9b5a7217ULL, 0x040fe20003800000ULL,
0x0000000862627981ULL, 0x000522000c1e9500ULL, 0x0000006c9b6c7217ULL, 0x000fe40003800000ULL,
0x000000ff5a737207ULL, 0x000fe20000000000ULL, 0x000060005e5e7625ULL, 0x000fe200078e0069ULL,
0x000000236a00720cULL, 0x000fc40003f26070ULL, 0x00000004ff6c7819ULL, 0x000fe4000001166cULL,
0x0000007c73587211ULL, 0x002fe200078fe0ffULL, 0x000000085e557981ULL, 0x000322000c1e9500ULL,
0x000000ff6c5d7207ULL, 0x004fc60000800000ULL, 0x0000600058587625ULL, 0x080fe200078e0069ULL,
0x00000082735a7211ULL, 0x000fe400078fe0ffULL, 0x0000002052747812ULL, 0x000fe200078efcffULL,
0x000000017c6a7824ULL, 0x000fe200078e025dULL, 0x0000000858577981ULL, 0x0084e2000c1e9500ULL,
0x000000015d707824ULL, 0x040fe400078e0282ULL, 0x000000015d6c7824ULL, 0x000fe400078e0284ULL,
0x000060006a6a7625ULL, 0x000fc800078e0069ULL, 0x0000600070707625ULL, 0x080fe200078e0069ULL,
0x0000580074767a10ULL, 0x000fe20007ffe0ffULL, 0x000000086a6a7981ULL, 0x0002e4000c1e9500ULL,
0x000060006c587625ULL, 0x084fe400078e0069ULL, 0x0000000870707981ULL, 0x0004e4000c1e9500ULL,
0x000060005a5a7625ULL, 0x000fe200078e0069ULL, 0x00000084735c7211ULL, 0x000fe200078fe0ffULL,
0x0000000858727981ULL, 0x0004e4000c1e9500ULL, 0x000000019a6c7824ULL, 0x000fc400078e0274ULL,
0x000000085a617981ULL, 0x0004e4000c1e9500ULL, 0x000000016c6e7824ULL, 0x000fe200078e0a23ULL,
0x00000086735e7211ULL, 0x002fe200078fe0ffULL, 0x000000015d787824ULL, 0x000fc600078e0286ULL,
0x0000006e9b6e7217ULL, 0x040fe20003800000ULL, 0x00000001765a7824ULL, 0x044fe200078e0a23ULL,
0x000000237600720cULL, 0x000fe20003f06070ULL, 0x0000600078787625ULL, 0x000fe200078e0069ULL,
0x000000236c00720cULL, 0x000fe40003f26070ULL, 0x0000005a9b5a7217ULL, 0x000fe20003800000ULL,
0x000060005c5c7625ULL, 0x080fe200078e0069ULL, 0x00000004ff6e7819ULL, 0x000fe2000001166eULL,
0x0000000878787981ULL, 0x0002a4000c1e9500ULL, 0x000060005e5e7625ULL, 0x000fe200078e0069ULL,
0x000000ff5a777207ULL, 0x000fe20000000000ULL, 0x000000085c637981ULL, 0x0002a2000c1e9500ULL,
0x000000ff6e597207ULL, 0x000fc60000800000ULL, 0x000000085e657981ULL, 0x0002a2000c1e9500ULL,
0x00000082776e7211ULL, 0x080fe400078fe0ffULL, 0x00000082596c7210ULL, 0x000fe40007ffe0ffULL,
0x0000007c775a7211ULL, 0x000fe200078fe0ffULL, 0x000060006e6e7625ULL, 0x000fc800078e0069ULL,
0x000060006c6c7625ULL, 0x080fe200078e0069ULL, 0x000000086e717981ULL, 0x0002a4000c1e9500ULL,
0x00000084775e7211ULL, 0x042fe200078fe0ffULL, 0x000060005a5a7625ULL, 0x000fe200078e0069ULL,
0x000000086cd47981ULL, 0x0002a2000c1e9500ULL, 0x0000008677587211ULL, 0x000fe400078fe0ffULL,
0x000000017c7a7824ULL, 0x000fe200078e0259ULL, 0x0000003052ba7812ULL, 0x000fe200078efcffULL,
0x00000001597e7824ULL, 0x040fe200078e0286ULL, 0x000000085a6b7981ULL, 0x0002a2000c1e9500ULL,
0x00000001595c7824ULL, 0x000fc400078e0284ULL, 0x000060007a7a7625ULL, 0x000fe200078e0069ULL,
0x00005800babc7a10ULL, 0x000fc60007ffe0ffULL, 0x000060005e5e7625ULL, 0x080fe400078e0069ULL,
0x000000087a7a7981ULL, 0x0002a4000c1e9500ULL, 0x000060007e5a7625ULL, 0x082fe400078e0069ULL,
0x000000085e757981ULL, 0x0002a4000c1e9500ULL, 0x0000600058587625ULL, 0x080fe400078e0069ULL,
0x000000085a837981ULL, 0x0002a4000c1e9500ULL, 0x000060005c5c7625ULL, 0x000fc400078e0069ULL,
0x0000000858dc7981ULL, 0x0002a4000c1e9500ULL, 0x000000019a7e7824ULL, 0x000fe400078e02baULL,
0x000000085cd87981ULL, 0x0002a4000c1e9500ULL, 0x000000017e807824ULL, 0x100fe400078e0a23ULL,
0x00000001bc6e7824ULL, 0x000fc600078e0a23ULL, 0x000000809b807217ULL, 0x040fe40003800000ULL,
0x000000237e00720cULL, 0x080fe40003f26070ULL, 0x00000023bc00720cULL, 0x000fe40003f06070ULL,
0x0000006e9b6e7217ULL, 0x000fe40003800000ULL, 0x00000004ff807819ULL, 0x000fe40000011680ULL,
0x000000ff6e797207ULL, 0x000fc40000000000ULL, 0x000000ff807b7207ULL, 0x000fe40000800000ULL,
0x0000007c796c7211ULL, 0x040fe400078fe0ffULL, 0x00000084795a7211ULL, 0x002fe200078fe0ffULL,
0x000000017c6e7824ULL, 0x000fe400078e027bULL, 0x000000017b5e7824ULL, 0x000fe400078e0284ULL,
0x000060006c6c7625ULL, 0x000fc800078e0069ULL, 0x000060006e6e7625ULL, 0x080fe200078e0069ULL,
0x000000086cbe7981ULL, 0x0002a6000c1e9500ULL, 0x000060005a5a7625ULL, 0x080fe200078e0069ULL,
0x000000086e7d7981ULL, 0x0002a6000c1e9500ULL, 0x000060005e5e7625ULL, 0x000fe200078e0069ULL,
0x000000085ada7981ULL, 0x0002a2000c1e9500ULL, 0x0000008279587211ULL, 0x000fc600078fe0ffULL,
0x000000085e817981ULL, 0x0002a2000c1e9500ULL, 0x000000017b5c7824ULL, 0x000fe400078e0282ULL,
0x0000600058587625ULL, 0x000fc800078e0069ULL, 0x000060005c5c7625ULL, 0x080fe200078e0069ULL,
0x0000000858d67981ULL, 0x0002a4000c1e9500ULL, 0x00000086796c7211ULL, 0x002fe400078fe0ffULL,
0x000000085c7f7981ULL, 0x0002a2000c1e9500ULL, 0x000000017b6e7824ULL, 0x000fe400078e0286ULL,
0x000060006c6c7625ULL, 0x000fc800078e0069ULL, 0x000060006e6e7625ULL, 0x000fe200078e0069ULL,
0x000000086cde7981ULL, 0x0002a8000c1e9500ULL, 0x000000086e857981ULL, 0x0002a2000c1e9500ULL,
0xfffffff067587812ULL, 0x000fca00078ec0ffULL, 0x0000000123597824ULL, 0x000fe200078e0258ULL,
0x0000000100d27802ULL, 0x000fc60000000f00ULL, 0x0000000154587824ULL, 0x000fe200078e0a59ULL,
0x00000001527c7812ULL, 0x000fc800078efcffULL, 0x00000058d2587219ULL, 0x000fe400000006ffULL,
0x000058007c5a7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0735c7812ULL, 0x002fc600078ec0ffULL,
0x000000015a5b7824ULL, 0x100fe200078e0a59ULL, 0x00000008527e7812ULL, 0x040fe200078efcffULL,
0x00000001235f7824ULL, 0x000fe200078e025cULL, 0x0000000952807812ULL, 0x000fe400078efcffULL,
0x0000005bd25c7219ULL, 0x000fe400000006ffULL, 0x000058007e5e7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800806e7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0776c7812ULL, 0x000fe200078ec0ffULL,
0x000000015e5d7824ULL, 0x100fe200078e0a59ULL, 0xfffffff079827812ULL, 0x000fe200078ec0ffULL,
0x000000016e597824ULL, 0x000fc400078e0a59ULL, 0x0000000123677824ULL, 0x040fe200078e026cULL,
0x0000005dd26c7219ULL, 0x040fe200000006ffULL, 0x0000000123737824ULL, 0x000fe200078e0282ULL,
0x00000059d2827219ULL, 0x000fe400000006ffULL, 0x0000001152867812ULL, 0x000fe200078efcffULL,
0x0000000166597824ULL, 0x000fc600078e0a5fULL, 0x0000580086887a10ULL, 0x000fe40007ffe0ffULL,
0x000054101d1d7816ULL, 0x010fc80000000056ULL, 0x0000001d58ff7212ULL, 0x000fc800078ac0ffULL,
0x000000235400720cULL, 0x000fc80002fa1470ULL, 0x000000235200720cULL, 0x000fe40002fa1070ULL,
0x0000001d5cff7212ULL, 0x000fe4000782c0ffULL, 0xff80000007077808ULL, 0x000fe40002800000ULL,
0x0000541051517816ULL, 0x000fc80000000060ULL, 0x0000005158ff7212ULL, 0x080fe4000784c0ffULL,
0x000000515cff7212ULL, 0x000fe400078ac0ffULL, 0x0000541053537816ULL, 0x000fc80000000062ULL,
0x0000005358ff7212ULL, 0x000fe4000788c0ffULL, 0x000000235400720cULL, 0x0c0fe40001741470ULL,
0x000000235400720cULL, 0x080fe40002781470ULL, 0x000000235a00720cULL, 0x0c0fe40000f21470ULL,
0x000000235a00720cULL, 0x080fe40002fa1470ULL, 0x000000235200720cULL, 0x000fc40001741070ULL,
0x000000235200720cULL, 0x080fe40002781070ULL, 0x000000237c00720cULL, 0x0c0fe40000f21070ULL,
0x000000237c00720cULL, 0x000fe40002fa1070ULL, 0x0000541055557816ULL, 0x000fe40000000068ULL,
0xff80000014147808ULL, 0x000fe40001000000ULL, 0xff80000037377808ULL, 0x000fc40002000000ULL,
0xff8000000c0c7808ULL, 0x000fe40000800000ULL, 0xff80000021217808ULL, 0x000fe40002800000ULL,
0x0000001d6cff7212ULL, 0x000fe4000786c0ffULL, 0x0000005558ff7212ULL, 0x000fe4000780c0ffULL,
0x000000535cff7212ULL, 0x040fe4000784c0ffULL, 0x000000555cff7212ULL, 0x000fc4000788c0ffULL,
0x0000005182ff7212ULL, 0x000fe4000782c0ffULL, 0x000000536cff7212ULL, 0x000fe400078ac0ffULL,
0x000000235400720cULL, 0x080fe40000701470ULL, 0x000000235a00720cULL, 0x0c0fe40001741470ULL,
0x000000235a00720cULL, 0x080fe40002781470ULL, 0x000000235e00720cULL, 0x000fc40001f61470ULL,
0x000000235e00720cULL, 0x080fe40002fa1470ULL, 0x000000236e00720cULL, 0x080fe40000f21470ULL,
0x000000885f5b7210ULL, 0x000fe40007ffe1ffULL, 0x00000018528c7812ULL, 0x040fe400078efcffULL,
0x0000001952947812ULL, 0x040fe400078efcffULL, 0x000000235200720cULL, 0x000fc40000701070ULL,
0x000000237c00720cULL, 0x0c0fe40001741070ULL, 0x000000237c00720cULL, 0x080fe40002781070ULL,
0x000000237e00720cULL, 0x0c0fe40001f61070ULL, 0x000000237e00720cULL, 0x080fe40002fa1070ULL,
0x000000238000720cULL, 0x000fe40000f21070ULL, 0x00000059d2847219ULL, 0x000fc400000006ffULL,
0x0000005bd28a7219ULL, 0x000fe400000006ffULL, 0x0000541057577816ULL, 0x008fe4000000006aULL,
0x0000541061617816ULL, 0x000fe40000000070ULL, 0x000058008c8e7a10ULL, 0x000fe40007ffe0ffULL,
0x0000580094967a10ULL, 0x000fe40007ffe0ffULL, 0xff8000004c4c7808ULL, 0x000fc40000000000ULL,
0xff80000039397808ULL, 0x000fe40001000000ULL, 0xff8000004d4d7808ULL, 0x000fe40002000000ULL,
0xff8000000d0d7808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40002800000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0x000000516cff7212ULL, 0x000fc4000780c0ffULL,
0x0000005382ff7212ULL, 0x000fe4000784c0ffULL, 0x000000556cff7212ULL, 0x080fe4000788c0ffULL,
0x0000005582ff7212ULL, 0x000fe4000786c0ffULL, 0x000000578aff7212ULL, 0x000fe400078ac0ffULL,
0x0000006184ff7212ULL, 0x000fe2000782c0ffULL, 0x000000018e5d7824ULL, 0x100fe200078e0a5fULL,
0x000000235e00720cULL, 0x080fe20000701470ULL, 0x00000001965f7824ULL, 0x000fe200078e0a5fULL,
0x000000235e00720cULL, 0x000fc40002781470ULL, 0x000000236e00720cULL, 0x0c0fe40001741470ULL,
0x000000236e00720cULL, 0x080fe40001f61470ULL, 0x000000236600720cULL, 0x080fe40000f21470ULL,
0x000000238800720cULL, 0x080fe40002fa1470ULL, 0x000000237e00720cULL, 0x0c0fe40000701070ULL,
0x000000237e00720cULL, 0x000fc40002781070ULL, 0x000000238000720cULL, 0x0c0fe40001741070ULL,
0x000000238000720cULL, 0x080fe40001f61070ULL, 0x000000236400720cULL, 0x080fe40000f21070ULL,
0x000000238600720cULL, 0x000fe40002fa1070ULL, 0x0000005dd2927219ULL, 0x040fe400000006ffULL,
0x0000005fd2a47219ULL, 0x000fc400000006ffULL, 0x0000541063637816ULL, 0x004fe40000000072ULL,
0x0000541065657816ULL, 0x000fe40000000078ULL, 0xff80000022227808ULL, 0x000fe40000000000ULL,
0xff8000004f4f7808ULL, 0x000fe40002000000ULL, 0xff8000003b3b7808ULL, 0x000fe40001000000ULL,
0xff80000050507808ULL, 0x000fc40001800000ULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff80000010107808ULL, 0x000fe40002800000ULL, 0x0000005784ff7212ULL, 0x080fe4000780c0ffULL,
0x0000005792ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006384ff7212ULL, 0x040fe4000784c0ffULL,
0x0000006584ff7212ULL, 0x000fc4000786c0ffULL, 0x000000638aff7212ULL, 0x000fe4000782c0ffULL,
0x00000061a4ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000176697824ULL, 0x000fe200078e0a67ULL,
0x000000236600720cULL, 0x0c0fe40000701470ULL, 0x000000236600720cULL, 0x0c0fe40001741470ULL,
0x000000236600720cULL, 0x080fe40001f61470ULL, 0x000000238800720cULL, 0x000fc40000f21470ULL,
0x000000238e00720cULL, 0x080fe40002781470ULL, 0x000000239600720cULL, 0x080fe40002fa1470ULL,
0x0000002152a87812ULL, 0x000fe400078efcffULL, 0x000000236400720cULL, 0x0c0fe40000701070ULL,
0x000000236400720cULL, 0x0c0fe40001741070ULL, 0x000000236400720cULL, 0x000fc40001f61070ULL,
0x000000238600720cULL, 0x080fe40000f21070ULL, 0x000000238c00720cULL, 0x080fe40002781070ULL,
0x000000239400720cULL, 0x000fe40002fa1070ULL, 0x00000069d2a67219ULL, 0x000fe400000006ffULL,
0x0000541071717816ULL, 0x000fe400000000d4ULL, 0x00005800a8aa7a10ULL, 0x000fc40007ffe0ffULL,
0xff8000000f0f7808ULL, 0x000fe40000000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff8000004e4e7808ULL, 0x000fe40001800000ULL, 0xff8000003f3f7808ULL, 0x000fe40000800000ULL,
0xff80000011117808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fc40002800000ULL,
0x000000618aff7212ULL, 0x040fe4000780c0ffULL, 0x000000658aff7212ULL, 0x000fe4000784c0ffULL,
0x0000006192ff7212ULL, 0x000fe4000786c0ffULL, 0x00000063a4ff7212ULL, 0x040fe4000782c0ffULL,
0x00000065a4ff7212ULL, 0x000fe4000788c0ffULL, 0x00000071a6ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001aa6d7824ULL, 0x000fe200078e0a67ULL, 0x000000238800720cULL, 0x000fc40000701470ULL,
0x000000238800720cULL, 0x080fe40001741470ULL, 0x000000238e00720cULL, 0x080fe40001f61470ULL,
0x000000239600720cULL, 0x0c0fe40000f21470ULL, 0x000000239600720cULL, 0x080fe40002781470ULL,
0x000000237600720cULL, 0x000fe40002fa1470ULL, 0x0000002852ae7812ULL, 0x000fc400078efcffULL,
0x0000002952b47812ULL, 0x000fe400078efcffULL, 0x000000238600720cULL, 0x0c0fe40000701070ULL,
0x000000238600720cULL, 0x080fe40001741070ULL, 0x000000238c00720cULL, 0x080fe40001f61070ULL,
0x000000239400720cULL, 0x0c0fe40000f21070ULL, 0x000000239400720cULL, 0x000fc40002781070ULL,
0x000000237400720cULL, 0x000fe40002fa1070ULL, 0x0000006dd2ac7219ULL, 0x000fe400000006ffULL,
0x000054106b6b7816ULL, 0x000fe4000000007aULL, 0x0000541075757816ULL, 0x000fe400000000d8ULL,
0x00005410dc837816ULL, 0x000fe40000000083ULL, 0x00005800aeb07a10ULL, 0x000fc40007ffe0ffULL,
0x00005800b4b67a10ULL, 0x000fe40007ffe0ffULL, 0xff80000026267808ULL, 0x000fe40000000000ULL,
0xff80000048487808ULL, 0x000fe40001000000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff80000042427808ULL, 0x000fe40000800000ULL, 0xff8000003e3e7808ULL, 0x000fc40002000000ULL,
0xff80000029297808ULL, 0x000fe40002800000ULL, 0x0000001d82ff7212ULL, 0x000fe400078cc0ffULL,
0x0000006392ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006592ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006ba6ff7212ULL, 0x040fe4000786c0ffULL, 0x00000075a6ff7212ULL, 0x000fc4000782c0ffULL,
0x00000083a6ff7212ULL, 0x000fe4000788c0ffULL, 0x00000075acff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b06f7824ULL, 0x100fe200078e0a67ULL, 0x000000236e00720cULL, 0x080fe200037c1470ULL,
0x00000001b6677824ULL, 0x000fe200078e0a67ULL, 0x000000238e00720cULL, 0x0c0fe40000701470ULL,
0x000000238e00720cULL, 0x080fe40001741470ULL, 0x000000237600720cULL, 0x000fc40001f61470ULL,
0x000000237600720cULL, 0x0c0fe40000f21470ULL, 0x000000237600720cULL, 0x080fe40002781470ULL,
0x00000023aa00720cULL, 0x080fe40002fa1470ULL, 0x000000238000720cULL, 0x080fe400037c1070ULL,
0x000000238c00720cULL, 0x0c0fe40000701070ULL, 0x000000238c00720cULL, 0x000fc40001741070ULL,
0x000000237400720cULL, 0x0c0fe40001f61070ULL, 0x000000237400720cULL, 0x0c0fe40000f21070ULL,
0x000000237400720cULL, 0x080fe40002781070ULL, 0x00000023a800720cULL, 0x000fe40002fa1070ULL,
0x0000006fd2b27219ULL, 0x040fe400000006ffULL, 0x00000067d2b87219ULL, 0x000fc400000006ffULL,
0xff8000000e0e7808ULL, 0x000fe40003000000ULL, 0xff80000041417808ULL, 0x000fe40000000000ULL,
0xff8000003d3d7808ULL, 0x000fe40001000000ULL, 0xff80000013137808ULL, 0x000fe40001800000ULL,
0xff80000043437808ULL, 0x000fe40000800000ULL, 0xff80000040407808ULL, 0x000fc40002000000ULL,
0xff80000044447808ULL, 0x000fe40002800000ULL, 0x00000057a4ff7212ULL, 0x000fe400078cc0ffULL,
0x0000006bacff7212ULL, 0x080fe4000780c0ffULL, 0x0000006bb2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000071acff7212ULL, 0x040fe4000786c0ffULL, 0x00000083acff7212ULL, 0x000fc4000782c0ffULL,
0x00000071b2ff7212ULL, 0x000fe4000788c0ffULL, 0x00000075b8ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001bc777824ULL, 0x000fe200078e0a73ULL, 0x000000239600720cULL, 0x080fe400037c1470ULL,
0x00000023aa00720cULL, 0x0c0fe40000701470ULL, 0x00000023aa00720cULL, 0x0c0fe40001f61470ULL,
0x00000023aa00720cULL, 0x000fc40000f21470ULL, 0x00000023b000720cULL, 0x0c0fe40001741470ULL,
0x00000023b000720cULL, 0x080fe40002781470ULL, 0x00000023b600720cULL, 0x080fe40002fa1470ULL,
0x0000003152c27812ULL, 0x040fe400078efcffULL, 0x0000003852c87812ULL, 0x000fe400078efcffULL,
0x000000239400720cULL, 0x000fc400037c1070ULL, 0x00000023a800720cULL, 0x0c0fe40000701070ULL,
0x00000023a800720cULL, 0x0c0fe40001f61070ULL, 0x00000023a800720cULL, 0x080fe40000f21070ULL,
0x00000023ae00720cULL, 0x0c0fe40001741070ULL, 0x00000023ae00720cULL, 0x080fe40002781070ULL,
0x00000023b400720cULL, 0x000fc40002fa1070ULL, 0x00000077d2c07219ULL, 0x000fe400000006ffULL,
0x00005410be7d7816ULL, 0x000fe4000000007dULL, 0x00005410da817816ULL, 0x000fe40000000081ULL,
0x0000003952ce7812ULL, 0x000fe400078efcffULL, 0x00005800c2c47a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c8ca7a10ULL, 0x000fc40007ffe0ffULL, 0xff80000012127808ULL, 0x000fe40003000000ULL,
0xff80000018187808ULL, 0x000fe40000000000ULL, 0xff8000002a2a7808ULL, 0x000fe40001800000ULL,
0xff8000002e2e7808ULL, 0x000fe40000800000ULL, 0xff80000020207808ULL, 0x000fe40001000000ULL,
0xff8000002c2c7808ULL, 0x000fc40002000000ULL, 0xff80000046467808ULL, 0x000fe40002800000ULL,
0x0000006bb8ff7212ULL, 0x040fe400078cc0ffULL, 0x00000071b8ff7212ULL, 0x000fe4000780c0ffULL,
0x00000075b2ff7212ULL, 0x040fe4000786c0ffULL, 0x00000083b2ff7212ULL, 0x080fe4000782c0ffULL,
0x00000083b8ff7212ULL, 0x000fc4000784c0ffULL, 0x0000007dc0ff7212ULL, 0x040fe4000788c0ffULL,
0x00000081c0ff7212ULL, 0x000fe400078ac0ffULL, 0x00005800ced07a10ULL, 0x000fe20007ffe0ffULL,
0x00000001c4797824ULL, 0x100fe200078e0a73ULL, 0x00000023b000720cULL, 0x080fe20001f61470ULL,
0x00000001ca7b7824ULL, 0x000fe200078e0a73ULL, 0x00000023b000720cULL, 0x080fe40000f21470ULL,
0x00000023b600720cULL, 0x000fc400037c1470ULL, 0x00000023b600720cULL, 0x0c0fe40000701470ULL,
0x00000023b600720cULL, 0x080fe40001741470ULL, 0x00000023bc00720cULL, 0x0c0fe40002781470ULL,
0x00000023bc00720cULL, 0x000fe40002fa1470ULL, 0x000000d073737210ULL, 0x000fe40007ffe1ffULL,
0x00000079d2c67219ULL, 0x000fc400000006ffULL, 0x0000007bd2cc7219ULL, 0x000fe400000006ffULL,
0x00000023ae00720cULL, 0x0c0fe40001f61070ULL, 0x00000023ae00720cULL, 0x080fe40000f21070ULL,
0x00000023b400720cULL, 0x0c0fe400037c1070ULL, 0x00000023b400720cULL, 0x0c0fe40000701070ULL,
0x00000023b400720cULL, 0x000fc40001741070ULL, 0x00000023ba00720cULL, 0x0c0fe40002781070ULL,
0x00000023ba00720cULL, 0x000fe40002fa1070ULL, 0x00000073d2d27219ULL, 0x000fe400000006ffULL,
0x00005410d67f7816ULL, 0x000fe4000000007fULL, 0xff80000045457808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fc40000800000ULL, 0xff8000001c1c7808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fe40002000000ULL, 0xff80000047477808ULL, 0x000fe40002800000ULL,
0x0000007dc6ff7212ULL, 0x000fc4000786c0ffULL, 0x0000007dccff7212ULL, 0x080fe4000782c0ffULL,
0x0000007dd2ff7212ULL, 0x000fe400078cc0ffULL, 0x0000007fc0ff7212ULL, 0x080fe4000780c0ffULL,
0x0000007fc6ff7212ULL, 0x080fe4000784c0ffULL, 0x0000007fccff7212ULL, 0x000fe4000788c0ffULL,
0x00000081c6ff7212ULL, 0x000fc400078ac0ffULL, 0x00000023bc00720cULL, 0x080fe40000701470ULL,
0x00000023c400720cULL, 0x0c0fe40001f61470ULL, 0x00000023c400720cULL, 0x0c0fe40001741470ULL,
0x00000023c400720cULL, 0x080fe40002fa1470ULL, 0x00000023ca00720cULL, 0x080fe40000f21470ULL,
0x00000023d000720cULL, 0x000fc400037c1470ULL, 0x00000023ca00720cULL, 0x080fe40002781470ULL,
0x00000023ba00720cULL, 0x080fe40000701070ULL, 0x00000023c200720cULL, 0x0c0fe40001f61070ULL,
0x00000023c200720cULL, 0x0c0fe40001741070ULL, 0x00000023c200720cULL, 0x080fe40002fa1070ULL,
0x00000023c800720cULL, 0x000fc40000f21070ULL, 0x00000023ce00720cULL, 0x080fe400037c1070ULL,
0x00000023c800720cULL, 0x000fe40002781070ULL, 0x00005410de857816ULL, 0x000fe40000000085ULL,
0xff80000031317808ULL, 0x000fe40000000000ULL, 0xff80000016167808ULL, 0x000fe40001800000ULL,
0xff80000032327808ULL, 0x000fc40001000000ULL, 0xff80000049497808ULL, 0x000fe40002800000ULL,
0xff80000017177808ULL, 0x000fe40000800000ULL, 0xff80000015157808ULL, 0x000fe40003000000ULL,
0xff80000036367808ULL, 0x000fe40002000000ULL, 0x0000007fd2ff7212ULL, 0x000fe4000780c0ffULL,
0x00000081ccff7212ULL, 0x000fc4000786c0ffULL, 0x00000081d2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000085c0ff7212ULL, 0x080fe400078ac0ffULL, 0x00000085c6ff7212ULL, 0x080fe4000782c0ffULL,
0x00000085ccff7212ULL, 0x080fe400078cc0ffULL, 0x00000085d2ff7212ULL, 0x000fe4000788c0ffULL,
0x00000023bc00720cULL, 0x000fc40002fa1470ULL, 0x00000023c400720cULL, 0x080fe40000f21470ULL,
0x00000023ca00720cULL, 0x0c0fe40001f61470ULL, 0x00000023ca00720cULL, 0x080fe400037c1470ULL,
0x00000023d000720cULL, 0x0c0fe40000701470ULL, 0x00000023d000720cULL, 0x0c0fe40001741470ULL,
0x00000023d000720cULL, 0x000fc40002781470ULL, 0x00000023ba00720cULL, 0x080fe40002fa1070ULL,
0x00000023c200720cULL, 0x080fe40000f21070ULL, 0x00000023ce00720cULL, 0x080fe40000701070ULL,
0x00000023c800720cULL, 0x0c0fe40001f61070ULL, 0x00000023c800720cULL, 0x080fe400037c1070ULL,
0x00000023ce00720cULL, 0x000fc40001741070ULL, 0x00000023ce00720cULL, 0x000fe40002781070ULL,
0xff80000035357808ULL, 0x000fe40000000000ULL, 0xff8000004a4a7808ULL, 0x000fe40001800000ULL,
0xff8000004b4b7808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40002800000ULL,
0xff80000033337808ULL, 0x000fc40000800000ULL, 0xff80000034347808ULL, 0x000fe40003000000ULL,
0xff80000038387808ULL, 0x000fc40002000000ULL, 0x000000070800720bULL, 0x004fe40003f1e000ULL,
0x000000140900720bULL, 0x000fe40003f3e000ULL, 0x000000370a00720bULL, 0x000fe40003f5e000ULL,
0x0000004c0b00720bULL, 0x000fe40003f7e000ULL, 0x00000008071d7208ULL, 0x000fc40004000000ULL,
0x0000000914087208ULL, 0x000fe40004800000ULL, 0x0000000a370a7208ULL, 0x000fe40005000000ULL,
0x0000000b4c527208ULL, 0x000fe40005800000ULL, 0x0000000c1d00720bULL, 0x000fe40003f1e000ULL,
0x000000210800720bULL, 0x000fe40003f3e000ULL, 0x000000390a00720bULL, 0x000fc40003f5e000ULL,
0x0000004d5200720bULL, 0x000fe40003f7e000ULL, 0x0000001d0c547208ULL, 0x000fe40004000000ULL,
0x0000000821097208ULL, 0x000fe40004800000ULL, 0x0000000a390b7208ULL, 0x000fe40005000000ULL,
0x000000524d527208ULL, 0x000fe40005800000ULL, 0x0000000d5400720bULL, 0x000fc40003f1e000ULL,
0x000000220900720bULL, 0x000fe40003f3e000ULL, 0x0000003a0b00720bULL, 0x000fe40003f5e000ULL,
0x0000004f5200720bULL, 0x000fe40003f7e000ULL, 0x000000540d1d7208ULL, 0x000fe40004000000ULL,
0x0000000922097208ULL, 0x000fe40004800000ULL, 0x0000000b3a087208ULL, 0x000fc40005000000ULL,
0x000000524f0b7208ULL, 0x000fe40005800000ULL, 0x0000000e1d00720bULL, 0x000fe40003f1e000ULL,
0x000000240900720bULL, 0x000fe40003f3e000ULL, 0x0000003b0800720bULL, 0x000fe40003f5e000ULL,
0x000000500b00720bULL, 0x000fe40003f7e000ULL, 0x0000001d0e0a7208ULL, 0x000fc40004000000ULL,
0x0000000924527208ULL, 0x000fe40004800000ULL, 0x000000083b097208ULL, 0x000fe40005000000ULL,
0x0000000b500b7208ULL, 0x000fe40005800000ULL, 0x0000000f0a00720bULL, 0x000fe40003f1e000ULL,
0x000000255200720bULL, 0x000fe40003f3e000ULL, 0x0000003c0900720bULL, 0x000fc40003f5e000ULL,
0x0000004e0b00720bULL, 0x000fe40003f7e000ULL, 0x0000000a0f1d7208ULL, 0x000fe40004000000ULL,
0x0000005225237208ULL, 0x000fe40004800000ULL, 0x000000093c087208ULL, 0x000fe40005000000ULL,
0x0000000b4e0b7208ULL, 0x000fe40005800000ULL, 0x000000101d00720bULL, 0x000fc40003f1e000ULL,
0x000000262300720bULL, 0x000fe40003f3e000ULL, 0x0000003f0800720bULL, 0x000fe40003f5e000ULL,
0x000000480b00720bULL, 0x000fe40003f7e000ULL, 0x0000001d100a7208ULL, 0x000fe40004000000ULL,
0x0000002326527208ULL, 0x000fe40004800000ULL, 0x000000083f087208ULL, 0x000fc40005000000ULL,
0x0000000b48547208ULL, 0x000fe40005800000ULL, 0x000000110a00720bULL, 0x000fe40003f1e000ULL,
0x000000275200720bULL, 0x000fe40003f3e000ULL, 0x000000410800720bULL, 0x000fe40003f5e000ULL,
0x0000003d5400720bULL, 0x000fe40003f7e000ULL, 0x0000000a11097208ULL, 0x000fc40004000000ULL,
0x00000052270b7208ULL, 0x000fe40004800000ULL, 0x00000008411d7208ULL, 0x000fe40005000000ULL,
0x000000543d237208ULL, 0x000fe40005800000ULL, 0x000000120900720bULL, 0x000fe40003f1e000ULL,
0x000000280b00720bULL, 0x000fe40003f3e000ULL, 0x000000421d00720bULL, 0x000fc40003f5e000ULL,
0x0000003e2300720bULL, 0x000fe40003f7e000ULL, 0x0000000912087208ULL, 0x000fe40004000000ULL,
0x0000000b280a7208ULL, 0x000fe40004800000ULL, 0x0000001d42527208ULL, 0x000fe40005000000ULL,
0x000000233e237208ULL, 0x000fe40005800000ULL, 0x000000130800720bULL, 0x000fc40003f1e000ULL,
0x000000290a00720bULL, 0x000fe40003f3e000ULL, 0x000000435200720bULL, 0x000fe40003f5e000ULL,
0x000000402300720bULL, 0x000fe40003f7e000ULL, 0x0000000813097208ULL, 0x000fe40004000000ULL,
0x0000000a290b7208ULL, 0x000fe40004800000ULL, 0x00000052431d7208ULL, 0x000fc40005000000ULL,
0x0000002340237208ULL, 0x000fe40005800000ULL, 0x000000180900720bULL, 0x000fe40003f1e000ULL,
0x0000002a0b00720bULL, 0x000fe40003f3e000ULL, 0x000000441d00720bULL, 0x000fe40003f5e000ULL,
0x0000002e2300720bULL, 0x000fe40003f7e000ULL, 0x0000000918097208ULL, 0x000fc40004000000ULL,
0x0000000b2a0b7208ULL, 0x000fe40004800000ULL, 0x0000001d44087208ULL, 0x000fe40005000000ULL,
0x000000232e0a7208ULL, 0x000fe40005800000ULL, 0x000000200900720bULL, 0x000fe40003f1e000ULL,
0x0000002c0b00720bULL, 0x000fe40003f3e000ULL, 0x000000450800720bULL, 0x000fc40003f5e000ULL,
0x0000002b0a00720bULL, 0x000fe40003f7e000ULL, 0x0000000920097208ULL, 0x000fe40004000000ULL,
0x0000000b2c527208ULL, 0x000fe40004800000ULL, 0x00000008450b7208ULL, 0x000fe40005000000ULL,
0x0000000a2b0a7208ULL, 0x000fe40005800000ULL, 0x0000001c0900720bULL, 0x000fc40003f1e000ULL,
0x0000002f5200720bULL, 0x000fe40003f3e000ULL, 0x000000460b00720bULL, 0x000fe40003f5e000ULL,
0x0000002d0a00720bULL, 0x000fe40003f7e000ULL, 0x000000091c087208ULL, 0x000fe40004000000ULL,
0x000000522f527208ULL, 0x000fe40004800000ULL, 0x0000000b46547208ULL, 0x000fc40005000000ULL,
0x0000000a2d097208ULL, 0x000fe40005800000ULL, 0x0000001f0800720bULL, 0x000fe40003f1e000ULL,
0x000000315200720bULL, 0x000fe40003f3e000ULL, 0x000000475400720bULL, 0x000fe40003f5e000ULL,
0x000000300900720bULL, 0x000fe40003f7e000ULL, 0x000000081f0b7208ULL, 0x000fc40004000000ULL,
0x00000052311d7208ULL, 0x000fe40004800000ULL, 0x0000005447547208ULL, 0x000fe40005000000ULL,
0x0000000930087208ULL, 0x000fe40005800000ULL, 0x000000160b00720bULL, 0x000fe40003f1e000ULL,
0x000000321d00720bULL, 0x000fe40003f3e000ULL, 0x000000495400720bULL, 0x000fc40003f5e000ULL,
0x000000330800720bULL, 0x000fe40003f7e000ULL, 0x0000000b160a7208ULL, 0x000fe40004000000ULL,
0x0000001d321d7208ULL, 0x000fe40004800000ULL, 0x0000005449097208ULL, 0x000fe40005000000ULL,
0x00000008330b7208ULL, 0x000fe40005800000ULL, 0x000000170a00720bULL, 0x000fc40003f1e000ULL,
0x000000361d00720bULL, 0x000fe40003f3e000ULL, 0x0000004a0900720bULL, 0x000fe40003f5e000ULL,
0x000000340b00720bULL, 0x000fe40003f7e000ULL, 0x0000000a170a7208ULL, 0x000fe40004000000ULL,
0x0000001d36087208ULL, 0x000fe40004800000ULL, 0x000000094a527208ULL, 0x000fc40005000000ULL,
0x0000000b340b7208ULL, 0x000fe40005800000ULL, 0x000000150a00720bULL, 0x000fe40003f1e000ULL,
0x000000350800720bULL, 0x000fe40003f3e000ULL, 0x0000004b5200720bULL, 0x000fe40003f5e000ULL,
0x000000380b00720bULL, 0x000fe40003f7e000ULL, 0x0000000a15097208ULL, 0x000fc40004000000ULL,
0x0000000835237208ULL, 0x000fe40004800000ULL, 0x000000524b517208ULL, 0x000fe40005000000ULL,
0x0000000b38557208ULL, 0x000fe20005800000ULL, 0x000025427f007947ULL, 0x000fea000b800000ULL,
0x0c401f0009087f89ULL, 0x0004e400000e0000ULL, 0x000000080900720bULL, 0x008fc80003f1e000ULL,
0x0000000908577208ULL, 0x000fe20004000000ULL, 0x000025827f007947ULL, 0x000fea000b800000ULL,
0x0c401f0023087f89ULL, 0x000ee800000e0000ULL, 0x0c401f0051097f89ULL, 0x004ea800000e0000ULL,
0x0c401f00550a7f89ULL, 0x000f2200000e0000ULL, 0x000000082300720bULL, 0x008fc40003f1e000ULL,
0x000000095100720bULL, 0x004fe40003f3e000ULL, 0x00000023080b7208ULL, 0x002fe40004000000ULL,
0x00000051091d7208ULL, 0x000fe20004800000ULL, 0x0c201f0057087f89ULL, 0x000e6200000e0000ULL,
0x0000000a5500720bULL, 0x010fc60003f1e000ULL, 0x0c201f000b527f89ULL, 0x000ea200000e0000ULL,
0x000000550a237208ULL, 0x000fc60004000000ULL, 0x0c201f001d547f89ULL, 0x000ee800000e0000ULL,
0x0c201f0023587f89ULL, 0x0002e400000e0000ULL, 0x000000085700720bULL, 0x002fe40003f1e000ULL,
0x000000520b00720bULL, 0x004fe40003f3e000ULL, 0x0000005708087208ULL, 0x000fc40004000000ULL,
0x000000541d00720bULL, 0x008fe40003f5e000ULL, 0x0000000b52097208ULL, 0x000fe40004800000ULL,
0x0000001d540a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b080b7820ULL, 0x002fe20000410000ULL,
0x000000582300720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe40000000000ULL,
0x3fb8aa3b07077823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b18547823ULL, 0x000fc4000001080bULL,
0x00000007001d7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL, 0x0000000c000c7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b1f077823ULL, 0x102fe4000001080bULL, 0x3fb8aa3b10107823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b11117823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b12127823ULL, 0x100fe2000001080bULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b13517823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b20537823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1c567823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b16187823ULL, 0x100fe2000001080bULL, 0x0000000e000e7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b171f7823ULL, 0x100fe2000001080bULL, 0x0000001d0c0c723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b15527823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b090b7820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b0a167820ULL, 0x000fe20000410000ULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b14147823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001080bULL,
0x00000032005c7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001080bULL,
0x0000000d0e0e723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b25257823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001080bULL,
0x0000001000107308ULL, 0x000e620000000800ULL, 0x3fb8aa3b28287823ULL, 0x000fe2000001080bULL,
0x00000002ff327819ULL, 0x004fe2000001169dULL, 0x3fb8aa3b29297823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080bULL, 0x0000000132177810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080bULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b31557823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b36367823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b350b7823ULL, 0x000fe2000001080bULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x00000008321c7824ULL, 0x000fe200078e00ffULL,
0x0000000f1010723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b37377823ULL, 0x100fe40000010816ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010816ULL, 0xfffffff81c577812ULL, 0x000fe200078ee217ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010816ULL, 0x0000000b00357308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010816ULL, 0x00000002321c7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b3c3c7823ULL, 0x000fc40000010816ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe40000010816ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010816ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x00000023580b7208ULL, 0x002fe20004000000ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010816ULL,
0x00000014210d723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010816ULL,
0x0000000432237810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010816ULL,
0x000000039dff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010816ULL,
0x0000002400137308ULL, 0x000e620000000800ULL, 0x3fb8aa3b46467823ULL, 0x000fc40000010816ULL,
0x3fb8aa3b47477823ULL, 0x100fe40000010816ULL, 0x3fb8aa3b49497823ULL, 0x100fe40000010816ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010816ULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4b167823ULL, 0x000fe40000010816ULL, 0x3fb8aa3b0b4b7820ULL, 0x000fe40000410000ULL,
0x0000000832597824ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe2000001084bULL,
0x0000001200127308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe2000001084bULL,
0xfffffff859597812ULL, 0x000fe200078ee21cULL, 0x3fb8aa3b50507823ULL, 0x100fe2000001084bULL,
0x00000022130f723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe2000001084bULL,
0x0000000632227810ULL, 0x000fe20007ffe0ffULL, 0x00000004ff1c7e24ULL, 0x000fe2000f8e00ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b48487823ULL, 0x000fc4000001084bULL, 0x3f8000001c1c783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe4000001084bULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe2000001084bULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000ffff1d7224ULL, 0x000fe200078e001cULL,
0x000000111212723eULL, 0x004fe200000010ffULL, 0x00000008325d7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b40407823ULL, 0x100fe4000001084bULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001084bULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee222ULL,
0x3fb8aa3b2b2b7823ULL, 0x000fc4000001084bULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe4000001084bULL,
0x3fb8aa3b34347823ULL, 0x100fe4000001084bULL, 0x0000002800287308ULL, 0x000ea20000000800ULL,
0x000000252611723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b38387823ULL, 0x000fcc000001084bULL,
0x0000004c00157308ULL, 0x0003f00000000800ULL, 0x0000004d00247308ULL, 0x000ee20000000800ULL,
0x000000272813723eULL, 0x004fe200000010ffULL, 0x000000ffff4c7224ULL, 0x002fcc00078e001cULL,
0x0000003700377308ULL, 0x000ff00000000800ULL, 0x0000003900207308ULL, 0x000e620000000800ULL,
0x000000152415723eULL, 0x008fe400000010ffULL, 0x0000001c0c24723cULL, 0x000b6a00000418ffULL,
0x0000003a003a7308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b3e1d7823ULL, 0x020fc4000001084bULL,
0x000000ffff3e7224ULL, 0x000fc800078e001cULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x000000372014723eULL, 0x002fe400000010ffULL, 0x0000000532207810ULL, 0x040fe40007ffe0ffULL,
0xffffffff32377810ULL, 0x000fc60007ffe0ffULL, 0x0000004f00177308ULL, 0x0003f00000000800ULL,
0x0000005000507308ULL, 0x000ea20000000800ULL, 0x00000003324f7819ULL, 0x002fc800000006ffULL,
0xfffffff84f4f7812ULL, 0x000fc600078ee220ULL, 0x0000003f00317308ULL, 0x0003f00000000800ULL,
0x0000001600397308ULL, 0x0007e20000000800ULL, 0x00000008323f7824ULL, 0x002fe200078e00ffULL,
0x000000175017723eULL, 0x004fcc00000010ffULL, 0x0000002a005a7308ULL, 0x000fe20000000800ULL,
0x0000000332167810ULL, 0x008fc80007ffe0ffULL, 0xfffffff83f4d7812ULL, 0x000fe200078ee216ULL,
0x000000ffff3f7224ULL, 0x000fe200078e001cULL, 0x0000003a3b16723eULL, 0x000fe200000010ffULL,
0x0000003c002a7308ULL, 0x0002a20000000800ULL, 0x00000008323a7824ULL, 0x000fca00078e00ffULL,
0xfffffff83a5f7812ULL, 0x000fe200078ee237ULL, 0x3fb8aa3b30377823ULL, 0x100fe2000001084bULL,
0x0000004e00217308ULL, 0x000fe20000000800ULL, 0x00000008323c7824ULL, 0x002fe400078e00ffULL,
0x3fb8aa3b333a7823ULL, 0x000fc6000001084bULL, 0xfffffff83c5b7812ULL, 0x000fe400078ee223ULL,
0x0000003d00237308ULL, 0x0003e20000000800ULL, 0x0000002a3120723eULL, 0x004fe400000010ffULL,
0x0000001032317810ULL, 0x040fe40007ffe0ffULL, 0x00000008322a7810ULL, 0x000fc60007ffe0ffULL,
0x0000004800487308ULL, 0x000ea20000000800ULL, 0x0000003e143c723cULL, 0x002f6200000418ffULL,
0x000000082a3b7824ULL, 0x000fca00078e00ffULL, 0xfffffff83b4b7812ULL, 0x000fe200078ee22aULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x00000003323b7819ULL, 0x000fc800000006ffULL,
0xfffffff83b3b7812ULL, 0x000fe400078ee232ULL, 0x0000001832327810ULL, 0x000fe20007ffe0ffULL,
0x0000004200427308ULL, 0x000e620000000800ULL, 0x000000214821723eULL, 0x004fe200000010ffULL,
0x000000ffff487224ULL, 0x000fcc00078e001cULL, 0x0000001d00287308ULL, 0x0004f00000000800ULL,
0x00000049005e7308ULL, 0x0009e20000000800ULL, 0x000000ffff1d7224ULL, 0x004fe200078e001cULL,
0x000000414222723eULL, 0x002fc400000010ffULL, 0x000000232823723eULL, 0x008fe200000010ffULL,
0x000000ffff497224ULL, 0x010fc600078e001cULL, 0x0000001c1024723cULL, 0x000b620000041824ULL,
0x0000000831287824ULL, 0x000fe200078e00ffULL, 0x0000005100517308ULL, 0x000fe80000000800ULL,
0xfffffff828617812ULL, 0x000fe400078ee231ULL, 0x00000048203c723cULL, 0x020f64000004183cULL,
0x0000005400547308ULL, 0x000e700000000800ULL, 0x0000005300537308ULL, 0x000ff00000000800ULL,
0x0000005600567308ULL, 0x000ea20000000800ULL, 0x000000515428723eULL, 0x002fe200000010ffULL,
0x0000000832517824ULL, 0x000fca00078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee232ULL,
0x0000002900297308ULL, 0x000e700000000800ULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x00000053562a723eULL, 0x004fce00000010ffULL, 0x0000002f002f7308ULL, 0x000ea20000000800ULL,
0x000000295a29723eULL, 0x002fce00000010ffULL, 0x0000004000407308ULL, 0x000ff00000000800ULL,
0x0000002e001d7308ULL, 0x000ff00000000800ULL, 0x0000004300437308ULL, 0x000ff00000000800ULL,
0x0000004400447308ULL, 0x000e700000000800ULL, 0x0000004500457308ULL, 0x000ff00000000800ULL,
0x0000004600467308ULL, 0x000ef00000000800ULL, 0x0000002b00307308ULL, 0x0005f00000000800ULL,
0x0000002d00317308ULL, 0x0009220000000800ULL, 0x0000002c2f2b723eULL, 0x004fc400000010ffULL,
0x00000043442c723eULL, 0x002fe400000010ffULL, 0x00000045462e723eULL, 0x008fc600000010ffULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x000000401d2d723eULL, 0x010fe200000010ffULL,
0x000000ffff1d7224ULL, 0x000fcc00078e001cULL, 0x0000001800187308ULL, 0x000e620000000800ULL,
0x00000030312f723eULL, 0x000fe400000010ffULL, 0x000000482830723cULL, 0x000b6a0000041824ULL,
0x0000001f001f7308ULL, 0x000fe40000000800ULL, 0x0000000c06497812ULL, 0x020fe200078ec0ffULL,
0x0000001c2c3c723cULL, 0x000bea000004183cULL, 0x0000005200527308ULL, 0x000ea20000000800ULL,
0x000000071824723eULL, 0x002fc400000010ffULL, 0x000120001e187811ULL, 0x000fc800078e60ffULL,
0x000000185f447211ULL, 0x000fe200078e20ffULL, 0x0000003600367308ULL, 0x000e620000000800ULL,
0x000000103b067824ULL, 0x100fe400078e0218ULL, 0x00000010593b7824ULL, 0x100fe400078e0218ULL,
0x000000104d407824ULL, 0x100fe400078e0218ULL, 0x000000105b417824ULL, 0x100fe200078e0218ULL,
0x0000003700377308ULL, 0x000fe20000000800ULL, 0x0000001f5226723eULL, 0x004fe200000010ffULL,
0x00000010571f7824ULL, 0x000fe200078e0218ULL, 0x0000003b493b7210ULL, 0x040fe20007ffe0ffULL,
0x00000001491d7824ULL, 0x020fc400078e0206ULL, 0x000000ffff4d7224ULL, 0x000fe400078e001cULL,
0x0000003a003a7308ULL, 0x000ea20000000800ULL, 0x000000363527723eULL, 0x002fe200000010ffULL,
0x000000104f427824ULL, 0x100fe200078e0218ULL, 0x0000000c1d007388ULL, 0x0003e20000000800ULL,
0x00000001491f7824ULL, 0x000fe400078e021fULL, 0x000000105d437824ULL, 0x000fe400078e0218ULL,
0x0000005500557308ULL, 0x000ee20000000800ULL, 0x0000000149407824ULL, 0x000fe200078e0240ULL,
0x0000000e1f007388ULL, 0x0003e20000000800ULL, 0x000000104b067824ULL, 0x000fc400078e0218ULL,
0x0000000149417824ULL, 0x040fe200078e0241ULL, 0x000000103b007388ULL, 0x0003e20000000800ULL,
0x0000000149427824ULL, 0x040fe200078e0242ULL, 0x0000004a004a7308ULL, 0x000f220000000800ULL,
0x000000373a35723eULL, 0x004fe200000010ffULL, 0x0000000149437824ULL, 0x040fe200078e0243ULL,
0x0000001240007388ULL, 0x0003e20000000800ULL, 0x0000000149447824ULL, 0x040fe400078e0244ULL,
0x0000000149067824ULL, 0x000fe200078e0206ULL, 0x0000002841007388ULL, 0x0003e20000000800ULL,
0x0000003400077308ULL, 0x000fe20000000800ULL, 0x000000555c25723eULL, 0x008fe200000010ffULL,
0x0000001061457824ULL, 0x100fe200078e0218ULL, 0x0000002a42007388ULL, 0x0003e20000000800ULL,
0x0000001051187824ULL, 0x000fc400078e0218ULL, 0x0000000149457824ULL, 0x000fe200078e0245ULL,
0x0000002443007388ULL, 0x0003e20000000800ULL, 0x0000003800387308ULL, 0x000ea20000000800ULL,
0x0000004a3936723eULL, 0x010fe200000010ffULL, 0x000000ffff397224ULL, 0x000fe200078e001cULL,
0x0000004c2430723cULL, 0x000f620000041830ULL, 0x0000002644007388ULL, 0x0003e20000000800ULL,
0x0000000149187824ULL, 0x000fc600078e0218ULL, 0x0000004700477308ULL, 0x000ee20000000800ULL,
0x0000000d06007388ULL, 0x0003e80000000800ULL, 0x0004000f1f007388ULL, 0x0003e20000000800ULL,
0x000000073837723eULL, 0x004fe200000010ffULL, 0x000000ffff387224ULL, 0x000fe400078e001cULL,
0x000400113b007388ULL, 0x0003e80000000800ULL, 0x0004001340007388ULL, 0x0003e20000000800ULL,
0x000000475e34723eULL, 0x008fc600000010ffULL, 0x0004002941007388ULL, 0x0003e40000000800ULL,
0x000000ffff317224ULL, 0x020fe400078e0032ULL, 0x0004002b42007388ULL, 0x0003e20000000800ULL,
0x00000038343c723cULL, 0x000f66000004183cULL, 0x0004002543007388ULL, 0x0003e80000000800ULL,
0x0004002744007388ULL, 0x0003e80000000800ULL, 0x0000001445007388ULL, 0x0003e80000000800ULL,
0x000800161f007388ULL, 0x0003e80000000800ULL, 0x000800203b007388ULL, 0x0003e80000000800ULL,
0x0008002240007388ULL, 0x0003e20000000800ULL, 0x0000003c00327202ULL, 0x020fe20000000f00ULL,
0x000000ffff337224ULL, 0x000fc400078e003eULL, 0x0008002c41007388ULL, 0x0003e80000000800ULL,
0x0008002e42007388ULL, 0x0003e80000000800ULL, 0x0008003443007388ULL, 0x0003e80000000800ULL,
0x0008003644007388ULL, 0x0003e80000000800ULL, 0x0000001518007388ULL, 0x0003e80000000800ULL,
0x000c00171f007388ULL, 0x0003e80000000800ULL, 0x000c00213b007388ULL, 0x0003e80000000800ULL,
0x000c002340007388ULL, 0x0003e80000000800ULL, 0x000c002d41007388ULL, 0x0003e80000000800ULL,
0x000c002f42007388ULL, 0x0003e80000000800ULL, 0x000c003543007388ULL, 0x0003e80000000800ULL,
0x000c003744007388ULL, 0x0003e80000000800ULL, 0x01e0000805008388ULL, 0x0003e80000000c00ULL,
0x01e2003005008388ULL, 0x0003e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e608009eff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e610009eff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e618009eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000199000720cULL, 0x000fe20003f06070ULL, 0x01e620009eff7f8cULL, 0x0003e4000c80043fULL,
0x000000ffff1d7224ULL, 0x002fd400078e0090ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff75c000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff247807ULL, 0x004fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001980000267802ULL, 0x000fc40000000f00ULL, 0x000015f000007944ULL, 0x018fea0003c00000ULL,
0x0000002400037202ULL, 0x000fe20000000f00ULL, 0xfffe95d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20005000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001986000267802ULL, 0x000fc40000000f00ULL, 0x0000159000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e0024ULL, 0xfffe961000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0005ULL, 0x000198d000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000014d000007944ULL, 0x018fea0003c00000ULL, 0xfffe96c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0005ULL, 0xffffffff00277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x0001993000257802ULL, 0x000fc40000000f00ULL,
0x0000147000007944ULL, 0x01afea0003c00000ULL, 0xfffe97d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0005ULL, 0x0001999000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000141000007944ULL, 0x01afea0003c00000ULL, 0xfffe98e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0005ULL, 0x000199f000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000013b000007944ULL, 0x01afea0003c00000ULL, 0xfffe99e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0000ULL, 0x00019a6000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fe400078e0003ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000134000007944ULL, 0x010fea0003c00000ULL,
0x0000002400107202ULL, 0x004fe20000000f00ULL, 0xfffe9b7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0000ULL, 0x00019ad000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000012d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0024ULL,
0x0000001003247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0000ULL,
0x00019b4000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000126000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0024ULL, 0xfffe9ae000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0000ULL, 0xffffffff00277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x00019bb000257802ULL, 0x000fc40000000f00ULL,
0x000011f000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0024ULL,
0xfffe9aa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x008fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00019c1000267802ULL, 0x000fc40000000f00ULL,
0x000011e000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0024ULL,
0xfffeb30000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe20004800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00019c7000267802ULL, 0x000fc40000000f00ULL,
0x0000118000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6e7224ULL, 0x000fe200078e0024ULL,
0xfffeb34000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0070ULL,
0x00019ce000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000010c000007944ULL, 0x000fea0003c00000ULL,
0xfffeb40000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0070ULL,
0x00019d4000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000106000007944ULL, 0x002fea0003c00000ULL,
0xfffeb51000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0070ULL,
0x00019da000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000100000007944ULL, 0x002fea0003c00000ULL,
0xfffeb62000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0070ULL,
0x0000001f006a7802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00019e0000257802ULL, 0x000fc40000000f00ULL, 0x00000fa000007944ULL, 0x002fea0003c00000ULL,
0xfffeb72000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x00019e7000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff247224ULL, 0x000fc400078e0022ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000f3000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0024ULL,
0xfffeb8a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x00019ee000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000ec000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0024ULL, 0x0000001022247810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x0000000d00267202ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00019f5000257802ULL, 0x000fc40000000f00ULL,
0x00000e5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0024ULL,
0xfffeb81000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x00019fc000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000de000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0024ULL, 0xfffeb7d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x004fe40004000000ULL, 0xffffffff00257802ULL, 0x000fe40000000f00ULL,
0x0001a02000267802ULL, 0x000fc40000000f00ULL, 0x00000dd000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff697224ULL, 0x000fe200078e0024ULL, 0xfffece1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20004800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001a08000267802ULL, 0x000fc40000000f00ULL, 0x00000d7000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x000fe200078e0024ULL, 0xfffece4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006eULL, 0x0001a0f000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000cb000007944ULL, 0x018fea0003c00000ULL, 0xfffecf0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006eULL, 0xffffffff00277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x0001a15000257802ULL, 0x000fc40000000f00ULL,
0x00000c5000007944ULL, 0x01afea0003c00000ULL, 0xfffed01000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006eULL, 0x0001a1b000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000bf000007944ULL, 0x01afea0003c00000ULL, 0xfffed12000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006eULL, 0x0001a21000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000b9000007944ULL, 0x01afea0003c00000ULL, 0xfffed22000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000dULL, 0x0001a28000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fc400078e0022ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000b2000007944ULL, 0x010fea0003c00000ULL,
0x0000002400107202ULL, 0x004fe20000000f00ULL, 0xfffed3a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000dULL, 0x0001a2f000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000ab000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0024ULL,
0x0000001022247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x0001a36000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000a4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0024ULL, 0xfffed31000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000dULL, 0xffffffff00277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x0001a3d000257802ULL, 0x000fc40000000f00ULL,
0x000009d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0024ULL,
0xfffed2d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x002fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001a43000267802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff617224ULL, 0x000fe200078e0024ULL,
0xfffee88000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe20004800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001a49000267802ULL, 0x000fc40000000f00ULL,
0x0000096000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff687224ULL, 0x000fe200078e0024ULL,
0xfffee8b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0xffffffff00277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x0001a50000257802ULL, 0x000fc40000000f00ULL, 0x000008a000007944ULL, 0x018fea0003c00000ULL,
0xfffee97000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0x0001a56000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000084000007944ULL, 0x01afea0003c00000ULL,
0xfffeea8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0x0001a5c000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000007e000007944ULL, 0x01afea0003c00000ULL,
0xfffeeb9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0x0001a62000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000078000007944ULL, 0x01afea0003c00000ULL,
0xfffeec9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x0000001200247202ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x0001a69000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000071000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0024ULL,
0xfffeee1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x0001a70000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000006a000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0024ULL, 0x0000001012247810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e000dULL, 0x0001a77000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x000fea0003c00000ULL, 0x00000024000e7202ULL, 0x004fe20000000f00ULL,
0xfffeed8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x0001a7e000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0024ULL, 0xfffeed4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0b7224ULL, 0x000fe200078e0009ULL, 0x0001a86000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff547424ULL, 0x000fc400078e00ffULL, 0x0000001fff587424ULL, 0x000fe400078e00ffULL,
0xffffffffff597424ULL, 0x000fc400078e00ffULL, 0x0000050000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0058ULL, 0xffffda5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0b7224ULL, 0x002fe200078e0023ULL, 0x0001a8e000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff547424ULL, 0x000fe400078e00ffULL, 0x0000001fff587424ULL, 0x000fe400078e00ffULL,
0xffffffffff597424ULL, 0x000fc400078e00ffULL, 0x0000048000007944ULL, 0x004fea0003c00000ULL,
0x000000582300720bULL, 0x004fe20003f1e000ULL, 0x00000002ff547424ULL, 0x002fe200078e00ffULL,
0x00000051000b7202ULL, 0x000fe20000000f00ULL, 0xffffffffff597424ULL, 0x000fe200078e00ffULL,
0x0000002358097208ULL, 0x000fe20004000000ULL, 0x0000001fff587424ULL, 0x000fe200078e00ffULL,
0x0001a96000527802ULL, 0x000fc40000000f00ULL, 0x0000040000007944ULL, 0x000fea0003c00000ULL,
0x000000585100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0055ULL,
0x0001a9e000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff547424ULL, 0x000fe200078e00ffULL,
0x00000051581d7208ULL, 0x000fe20004000000ULL, 0x0000001fff587424ULL, 0x000fc400078e00ffULL,
0xffffffffff597424ULL, 0x000fc400078e00ffULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x000000585500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0057ULL,
0x0001aa6000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff547424ULL, 0x000fe200078e00ffULL,
0x0000005558237208ULL, 0x000fe20004000000ULL, 0xffffffffff597424ULL, 0x000fe200078e00ffULL,
0x0000001f00587802ULL, 0x000fc40000000f00ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000585700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0009ULL,
0x0001aae000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff547424ULL, 0x000fe200078e00ffULL,
0x0000005758087208ULL, 0x000fe20004000000ULL, 0x0000001fff587424ULL, 0x000fc400078e00ffULL,
0xffffffffff597424ULL, 0x000fc400078e00ffULL, 0x0000028000007944ULL, 0x000fea0003c00000ULL,
0x000000580900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e001dULL,
0x0001ab6000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff547424ULL, 0x000fe200078e00ffULL,
0x0000000958097208ULL, 0x000fe20004000000ULL, 0x0000001fff587424ULL, 0x000fe400078e00ffULL,
0xffffffffff597424ULL, 0x000fc400078e00ffULL, 0x0000020000007944ULL, 0x000fea0003c00000ULL,
0x000000581d00720bULL, 0x004fe20003f1e000ULL, 0x00000001ff547424ULL, 0x002fe200078e00ffULL,
0x00000023000b7202ULL, 0x000fe20000000f00ULL, 0xffffffffff597424ULL, 0x000fe200078e00ffULL,
0x0000001d580a7208ULL, 0x000fe20004000000ULL, 0x0000001fff587424ULL, 0x000fe200078e00ffULL,
0x0001abe000527802ULL, 0x000fc40000000f00ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffd84000007947ULL, 0x000fea000383ffffULL, 0x0180000005037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000500038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff687807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000368ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000005057812ULL, 0x002fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000368ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000500037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffe52a008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff537424ULL, 0x000fe200078e00ffULL, 0x0000005900007348ULL, 0x000fe80003800000ULL,
0x0c0000540b587389ULL, 0x0002a200000e0058ULL, 0xfffe526052007950ULL, 0x000fea0003c3ffffULL,
0x0000002700007348ULL, 0x000fe80003800000ULL, 0x0000002426247389ULL, 0x0002a400000e006aULL,
0x000000ffff267224ULL, 0x002fc400078e0025ULL, 0x00000000ff277424ULL, 0x000fc800078e00ffULL,
0xfffe521026007950ULL, 0x000fea0003c3ffffULL, 0x000000012400780cULL, 0x000fe20003f45070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000002500007348ULL, 0x000ff60003800000ULL,
0x0000000000247806ULL, 0x000fc800050e0100ULL, 0x0000002524247212ULL, 0x000fe200078ec0ffULL,
0xfffe51b026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004ccULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000628ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000868ULL,
0x0000000000000270ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ad8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b98ULL,
0x00000000000006c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001258ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001268ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012f8ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012fcULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x000000000001af00ULL, 0xe100001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c400ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c440ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001c7c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012f8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001b108ULL,
0x000000000001b108ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001c400ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001c7c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_32_sm_80_cubin_len = 116896;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
