/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016dc0ULL, 0x0000000000016a40ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x4545386a4c45386aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c00010000036aULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000003afULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0022000003f5ULL, 0x0000000000015130ULL, 0x0000000000000170ULL, 0x000b002200000428ULL,
0x00000000000152a0ULL, 0x0000000000000040ULL, 0x000b002200000453ULL, 0x00000000000152e0ULL,
0x0000000000000050ULL, 0x000b00220000047dULL, 0x0000000000015330ULL, 0x0000000000000150ULL,
0x000a0003000004ebULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000400030000050bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000700030000053bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015480ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001513000000000ULL, 0x0000040400000000ULL, 0x810c000001200400ULL,
0x00531c0400288080ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8408288080830828ULL, 0x2880808708288080ULL, 0x8090082880808e08ULL, 0x0828808093082880ULL,
0x8080960828808094ULL, 0x9908288080980828ULL, 0x2880809a08288080ULL, 0x809c082880809b08ULL,
0x082880809d082880ULL, 0x8080c608288080c4ULL, 0x80162880808a0828ULL, 0x0000000310288082ULL,
0x808a920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001513000000000ULL, 0x0000017000000000ULL, 0x0000480400000000ULL, 0x8080288080830900ULL,
0x0000000000002880ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL,
0x2880808708288080ULL, 0x808e082880808a08ULL, 0x0828808090082880ULL, 0x8080940828808093ULL,
0x9908288080980828ULL, 0x2880809a08288080ULL, 0x809d082880809c08ULL, 0x08288080b9082880ULL,
0x8080c608288080c4ULL, 0x8016288080b60828ULL, 0x0000000310288082ULL, 0x80b6920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000014800000000ULL, 0x000152a000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8408288080830828ULL, 0x2880808708288080ULL, 0x808e082880808a08ULL, 0x0828808090082880ULL,
0x8080940828808093ULL, 0x9908288080980828ULL, 0x2880809a08288080ULL, 0x809c082880809b08ULL,
0x08288080c4082880ULL, 0x80809d08288080c6ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880809d92ULL, 0x0000002cffffffffULL, 0x0000021000000000ULL, 0x000152e000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x80902880809d0900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL, 0x2880808708288080ULL,
0x808e082880808a08ULL, 0x0828808090082880ULL, 0x8080940828808093ULL, 0x9908288080980828ULL,
0x2880809c08288080ULL, 0x80c4082880809d08ULL, 0x08288080c6082880ULL, 0x808280162880809aULL,
0x0000000000031028ULL, 0x2880809a92000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x000002e000000000ULL, 0x0001533000000000ULL, 0x0000015000000000ULL, 0x0000180400000000ULL,
0x80902880809a0900ULL, 0x0000000000002880ULL, 0x0000001800082f04ULL, 0x0008230400000080ULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL,
0x0000000000000012ULL, 0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000001100081104ULL, 0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL,
0x0008110400000000ULL, 0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0050016000000015ULL, 0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000003000043104ULL, 0xffffffff01542904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000f001542804ULL, 0x0000033000000120ULL, 0x000029c0000016a0ULL, 0x00002b7000002a60ULL,
0x00002ef000002ce0ULL, 0x00002f9000002f20ULL, 0x000036d000003000ULL, 0x0000492000004880ULL,
0x00004ba000004a40ULL, 0x00004de000004db0ULL, 0x00004ec000004e50ULL, 0x00006530000052c0ULL,
0x00006700000065d0ULL, 0x00006a7000006860ULL, 0x00006b1000006aa0ULL, 0x00006fa000006b80ULL,
0x000081c000008120ULL, 0x00008440000082e0ULL, 0x0000867000008640ULL, 0x00008750000086e0ULL,
0x00008bc000008bb0ULL, 0x0000af400000aed0ULL, 0x0000b7300000b6f0ULL, 0x000135d000013590ULL,
0x000135f0000135e0ULL, 0x0001366000013640ULL, 0x0001369000013680ULL, 0x0001439000014330ULL,
0x0001447000014400ULL, 0x00014570000144f0ULL, 0x00014630000145d0ULL, 0x00014710000146a0ULL,
0x0001480000014790ULL, 0x000148c000014860ULL, 0x000149a000014930ULL, 0x00014a9000014a20ULL,
0x00014b5000014af0ULL, 0x00014c2000014bb0ULL, 0x00014d1000014ca0ULL, 0x00014e0000014d80ULL,
0x00014f0000014e80ULL, 0x0001500000014f80ULL, 0x0001510000015080ULL, 0x000001f002003904ULL,
0x0001b600000000ffULL, 0x00000270003f0100ULL, 0x0001b6080000000dULL, 0x00000310003f0120ULL,
0x0001b6880000000dULL, 0x00000410003f0120ULL, 0x0001b600000000ffULL, 0x000005c0003f0107ULL,
0x0001b68c00000059ULL, 0x00000670003f0102ULL, 0x0001b68800000059ULL, 0x000026d0003f0101ULL,
0x0001b60800000074ULL, 0x000026f0003f0101ULL, 0x0001b60c00000074ULL, 0x000028c0003f0105ULL,
0x0001b60c00000074ULL, 0x00003670003f0105ULL, 0x0001b6880000005eULL, 0x000045e0003f0101ULL,
0x0001b62800000074ULL, 0x00004600003f0101ULL, 0x0001b62c00000074ULL, 0x000047d0003f0105ULL,
0x0001b62c00000074ULL, 0x00005270003f0105ULL, 0x0001b6900000005eULL, 0x00006250003f0101ULL,
0x0001b64800000074ULL, 0x000062b0003f0101ULL, 0x0001b64c00000074ULL, 0x00006480003f0105ULL,
0x0001b64c00000074ULL, 0x00006f30003f0105ULL, 0x0001b6980000005eULL, 0x00007e80003f0101ULL,
0x0001b66800000074ULL, 0x00007ea0003f0101ULL, 0x0001b66c00000074ULL, 0x00008070003f0105ULL,
0x0001b66c00000074ULL, 0x000089f0003f0105ULL, 0x0001b6a00000005eULL, 0x0000c310003f0101ULL,
0x0001b600000000ffULL, 0x0000df40003f0101ULL, 0x0001b604000000ffULL, 0x0000e110003f0105ULL,
0x0001b604000000ffULL, 0x000129c0003f0105ULL, 0x0000000000000004ULL, 0x00012ae0003f0101ULL,
0x0000000400000004ULL, 0x00012cb0003f0105ULL, 0x0000000400000004ULL, 0x00014180003f0105ULL,
0x0001b60800000002ULL, 0x000141e0003f0101ULL, 0x0001b61000000002ULL, 0x00014240003f0101ULL,
0x0001b61800000002ULL, 0x000142b0003f0101ULL, 0x0001b62000000002ULL, 0x00033803003f0101ULL,
0x0000bf7000141c04ULL, 0x0000e1700000c1e0ULL, 0x000142f00000e200ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000038cULL, 0x0000001800000002ULL, 0x00000000000002bcULL,
0x0000001800000002ULL, 0x00000000000001fcULL, 0x0000001800000002ULL, 0x0000000000000124ULL,
0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL, 0x0000000000000363ULL,
0x0000001800000002ULL, 0x0000000000000298ULL, 0x0000001800000002ULL, 0x00000000000001d5ULL,
0x0000001800000002ULL, 0x00000000000000fdULL, 0x0000001800000002ULL, 0x000000000001b700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x00005800ff147624ULL, 0x000fe200078e00ffULL, 0x0000000000127806ULL, 0x000fe200038e0000ULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000ea20000002300ULL,
0x0000000814067824ULL, 0x000fe200078e00ffULL, 0x0000001200087300ULL, 0x000ee200000e0000ULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x0000000000007919ULL, 0x000ea80000002200ULL,
0x0000000000107919ULL, 0x000ee40000002600ULL, 0x0000001200157309ULL, 0x0004a40000000000ULL,
0x0000000000057919ULL, 0x000ee80000002700ULL, 0x0000000000097919ULL, 0x000ee20000000000ULL,
0x00000005ff0e7819ULL, 0x002fcc000001160dULL, 0x00001fff0e0e7589ULL, 0x000fe200000e0000ULL,
0x00000004ff587e24ULL, 0x010fe4000f8e00ffULL, 0x0000010007007a24ULL, 0x004fe400078e0200ULL,
0x00001fff07077589ULL, 0x000e6200000e0000ULL, 0x0000000810047824ULL, 0x008fe400078e00ffULL,
0x00000000000d7a24ULL, 0x000fe400078e020dULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000506047224ULL, 0x000fc400078e0204ULL, 0x000000ff0d00720cULL, 0x040fe40003f05270ULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x0000007f0d00780cULL, 0x000fe40003f44070ULL,
0x000000090800720cULL, 0x000fce0003f62070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x0000000407067824ULL, 0x002fe400078e020eULL,
0x3fffffc0ff089424ULL, 0x000fe200078e00ffULL, 0x01b60002ff008388ULL, 0x0003e20000000a00ULL,
0x000000030d00780cULL, 0x000fe20003f04070ULL, 0x0000000206067824ULL, 0x000fe200078e00ffULL,
0x00000004ff0f7819ULL, 0x004fe20000011600ULL, 0x7fffffc0ff099424ULL, 0x000fc400078e00ffULL,
0xff317217ff0ca424ULL, 0x000fe200078e00ffULL, 0x00000008060b7817ULL, 0x040fe20007800000ULL,
0x0000000106117824ULL, 0x000fe200078e020fULL, 0x01b608080d009388ULL, 0x0005e20000008a00ULL,
0x00000100ff037424ULL, 0x002fe400078e00ffULL, 0x0000000104027824ULL, 0x000fe200078e0211ULL,
0x01b4000c0d00a388ULL, 0x000fe20000004800ULL, 0x000000010b047824ULL, 0x000fe400078e0a06ULL,
0x0000001000067824ULL, 0x000fc400078e00ffULL, 0x3fffff60ff0a8424ULL, 0x000fe400078e00ffULL,
0x7fffff60ff0b8424ULL, 0x000fe200078e00ffULL, 0x000000f006137812ULL, 0x000fe200078ec0ffULL,
0x00005c0002027625ULL, 0x000fc600078e0003ULL, 0x01b6880a0d008388ULL, 0x000fe20000008a00ULL,
0x0000000111097824ULL, 0x004fc600078e0200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001011127824ULL, 0x000fe200078e00ffULL, 0x000000040f00720cULL, 0x000fe20003f06070ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0a15ULL, 0x0000001302087210ULL, 0x000fe20007f3e0ffULL,
0x00000004ff047424ULL, 0x000fe200078e00ffULL, 0xfffffff012027812ULL, 0x000fc600078ee209ULL,
0x000000ffff097224ULL, 0x000fe400008e0603ULL, 0x00000010020f7824ULL, 0x000fe400078e00ffULL,
0x0000620005027625ULL, 0x000fc600078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080f7faeULL, 0x0003e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x01b6040cffff338cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000006020f7981ULL, 0x002ea2000c1e1900ULL,
0x000000ff0700720cULL, 0x000fc40003f05270ULL, 0x0000007f0f0d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff0f0b7810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff0d7819ULL, 0x000fe4000001160dULL,
0x00000008ff0b7819ULL, 0x000fca000001160bULL, 0x0000bcf000008947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x000fe2000001160eULL, 0x000000080e597824ULL, 0x000fe400078e00ffULL,
0x00000003ff067424ULL, 0x000fe200078e00ffULL, 0x01ffffff02037812ULL, 0x000fe200078ec0ffULL,
0xffffffffff0a7424ULL, 0x000fc800078e00ffULL, 0x00000002580c7824ULL, 0x000fca00078e0203ULL,
0x0000000d0c00720cULL, 0x000fda0003f06070ULL, 0x0000000205028824ULL, 0x000fe400078e00ffULL,
0x00006400ff038624ULL, 0x000fc800078e00ffULL, 0x0000640002038624ULL, 0x000fc800078e0203ULL,
0x000000010c038824ULL, 0x000fe200078e0203ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b68c0659ff738cULL, 0x0003e20000000000ULL, 0x0000600003028625ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006020a8981ULL, 0x000ea2000c1e1900ULL,
0x0000000158047810ULL, 0x000fe20007ffe0ffULL, 0x0000008010087824ULL, 0x000fe200078e00ffULL,
0x00000001ff5b7819ULL, 0x000fe2000001160eULL, 0x01b6880059ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000b0400720cULL, 0x000fe40003f06070ULL, 0x000000010e5a7812ULL, 0x000fe200078ec0ffULL,
0x000000205b097824ULL, 0x000fc800078e00ffULL, 0x0000010058137824ULL, 0x000fca00078e0209ULL,
0x00000060081e7812ULL, 0x000fe200078ef813ULL, 0x000058000a047a24ULL, 0x004fc800078e02ffULL,
0x0000008004207824ULL, 0x000fe200078e00ffULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x00000003ff157819ULL, 0x108fe20000011600ULL, 0x000000085a1f7824ULL, 0x000fe200078e00ffULL,
0x000000130f027217ULL, 0x000fe40007800000ULL, 0x0000000415077810ULL, 0x040fe40007ffe0ffULL,
0x0000000815117810ULL, 0x040fe20007ffe0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a13ULL,
0x0000000c151b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107037824ULL, 0x100fe200078e0200ULL,
0x0000001015277810ULL, 0x000fe20007ffe0ffULL, 0x0000000807047824ULL, 0x000fe200078e00ffULL,
0x0000001415297810ULL, 0x000fe20007ffe0ffULL, 0x0000000111067824ULL, 0x002fe200078e0200ULL,
0x00000018152b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000811237824ULL, 0x000fe200078e00ffULL,
0xfffffff804217812ULL, 0x000fe200078ee203ULL, 0x000000011e037824ULL, 0x000fe200078e0215ULL,
0x0000002002047817ULL, 0x000fe20003800000ULL, 0x000000011e027824ULL, 0x040fe200078e021bULL,
0xfffffff823237812ULL, 0x000fe200078ee206ULL, 0x000000081b257824ULL, 0x000fe200078e00ffULL,
0x000000040700720cULL, 0x000fe20003f06070ULL, 0x000000011e077824ULL, 0x000fe200078e0207ULL,
0x0000000320037210ULL, 0x000fc40007f5e0ffULL, 0x000000041100720cULL, 0x000fe20003f26070ULL,
0x000000011e117824ULL, 0x000fe200078e0211ULL, 0x0000000720077210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff067224ULL, 0x000fe200010e06ffULL, 0x00005e0003167a11ULL, 0x040fe400078440ffULL,
0x0000001120117210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x0000000220027210ULL, 0x000fe40007fbe0ffULL, 0x00005f0003177a11ULL, 0x000fe200010f4406ULL,
0x000000ffff147224ULL, 0x000fe200020e06ffULL, 0x00005e0007127a11ULL, 0x000fe200078440ffULL,
0x000000ffff037224ULL, 0x000fe200028e06ffULL, 0x00005e0002067a11ULL, 0x000fc400078840ffULL,
0x00005f0007137a11ULL, 0x000fe400010f4418ULL, 0x00005f0002077a11ULL, 0x000fe200020f4403ULL,
0x000000011e027824ULL, 0x040fe200078e0227ULL, 0x00005e0011107a11ULL, 0x000fe200078640ffULL,
0x000000011e037824ULL, 0x000fe200078e0229ULL, 0x0000001c152d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000220197210ULL, 0x000fe40007f5e0ffULL, 0x00005f0011117a11ULL, 0x000fe200018f4414ULL,
0x000000011e147824ULL, 0x000fe200078e022bULL, 0x00005e0019027a11ULL, 0x000fe200078640ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x00000003201a7210ULL, 0x000fe20007fbe0ffULL,
0x000000011e187824ULL, 0x000fe200078e022dULL, 0x0000001420227210ULL, 0x000fe20007f9e0ffULL,
0x000000011b1e7824ULL, 0x000fe200078e0200ULL, 0x00005f0019037a11ULL, 0x000fe200018f441cULL,
0x000000ffff1d7224ULL, 0x000fe200028e06ffULL, 0x000000041500720cULL, 0x040fe20003f66070ULL,
0x0000000115157824ULL, 0x000fe200078e0200ULL, 0x00005e001a147a11ULL, 0x000fe200078a40ffULL,
0x000000025b1c7824ULL, 0x000fe200078e025aULL, 0x0000001820207210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200020e06ffULL, 0x0000000715197812ULL, 0x000fc400078ec0ffULL,
0x00005f001a157a11ULL, 0x000fe400028f441dULL, 0x000130001c1c7811ULL, 0x000fe400078e68ffULL,
0x0ffffff819197812ULL, 0x100fe400078ef800ULL, 0xfffffff81f1d7812ULL, 0x000fe200078ee200ULL,
0x0000001021217824ULL, 0x100fe200078e021cULL, 0x00005e00221a7a11ULL, 0x000fe200078840ffULL,
0x00000010191f7824ULL, 0x000fe200078e021cULL, 0x00005e0020187a11ULL, 0x000fe200078a40ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x000000041b00720cULL, 0x000fe20003f46070ULL,
0x000000101d167825ULL, 0x000fe200078e0016ULL, 0x00005f00221b7a11ULL, 0x000fc400020f442fULL,
0x00005f0020197a11ULL, 0x000fe200028f4419ULL, 0x000000012b207824ULL, 0x000fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000161f7faeULL, 0x0003e2000d901c46ULL,
0x000000042700720cULL, 0x080fe20003f66070ULL, 0x000000101d127825ULL, 0x000fe200078e0012ULL,
0x000000042900720cULL, 0x080fe40003f86070ULL, 0x000000042b00720cULL, 0x0c0fe20003fa6070ULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x000000042d00720cULL, 0x000fe20003fc6070ULL,
0x0000000127047824ULL, 0x000fe200078e0200ULL, 0xfffffff825257812ULL, 0x000fe200078ee21eULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x0000000012217faeULL, 0x0005e2000c101c46ULL,
0x00000001291e7824ULL, 0x000fc400078e0200ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0xfffffff827177812ULL, 0x002fe200078ee204ULL, 0x000000012d167824ULL, 0x000fe200078e0200ULL,
0xfffffff82b277812ULL, 0x000fe200078ee220ULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8291f7812ULL, 0x000fe200078ee21eULL, 0x0000001023237824ULL, 0x000fe400078e021cULL,
0x000000101d107825ULL, 0x000fe200078e0010ULL, 0xfffffff82d297812ULL, 0x000fc600078ee216ULL,
0x0000001025257824ULL, 0x000fe200078e021cULL, 0x0000000010237faeULL, 0x0005e2000c901c46ULL,
0x000000101d067825ULL, 0x000fc800078e0006ULL, 0x0000001017177824ULL, 0x000fe200078e021cULL,
0x0000000006257faeULL, 0x0005e2000d101c46ULL, 0x000000101d027825ULL, 0x000fc800078e0002ULL,
0x000000101f1f7824ULL, 0x000fe200078e021cULL, 0x0000000002177faeULL, 0x0005e2000d901c46ULL,
0x000000101d147825ULL, 0x000fc800078e0014ULL, 0x0000001027277824ULL, 0x000fe200078e021cULL,
0x00000000141f7faeULL, 0x0005e2000e101c46ULL, 0x000000101d1a7825ULL, 0x000fc800078e001aULL,
0x0000001029297824ULL, 0x000fe200078e021cULL, 0x000000001a277faeULL, 0x0005e2000e901c46ULL,
0x000000101d187825ULL, 0x000fca00078e0018ULL, 0x0000000018297faeULL, 0x0005e2000f101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x0000000400077811ULL, 0x008fe200078fe8ffULL,
0x000000085a2d7824ULL, 0x000fe200078e00ffULL, 0x0000000800117811ULL, 0x040fe400078fe8ffULL,
0x0000000c00137811ULL, 0x040fe200078fe8ffULL, 0x0000000107027824ULL, 0x140fe200078e0200ULL,
0x0000001800197811ULL, 0x000fe200078fe8ffULL, 0x0000000807157824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x100fe200078ee200ULL, 0x0000000111037824ULL, 0x000fc400078e0200ULL,
0x0000000811127824ULL, 0x000fe200078e00ffULL, 0xfffffff815107812ULL, 0x000fe200078ee202ULL,
0x0000000113047824ULL, 0x140fe200078e0200ULL, 0x0000001e00027211ULL, 0x040fe200078fe8ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000001000157811ULL, 0x000fe200078fe8ffULL,
0x0000000119067824ULL, 0x142fe200078e0200ULL, 0x00000002201b7210ULL, 0x000fe20007f1e0ffULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee203ULL,
0x0000000115037824ULL, 0x000fe200078e0200ULL, 0xfffffff817147812ULL, 0x000fe200078ee204ULL,
0x0000000815167824ULL, 0x000fe200078e00ffULL, 0x0000001400177811ULL, 0x000fe200078fe8ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005e001b027a11ULL, 0x000fe200078040ffULL,
0x000000011e077824ULL, 0x000fe200078e0207ULL, 0xfffffff816167812ULL, 0x000fe200078ee203ULL,
0x0000000117047824ULL, 0x000fe200078e0200ULL, 0x00005f001b037a11ULL, 0x000fe200000f441cULL,
0x00000008171d7824ULL, 0x000fe200078e00ffULL, 0x0000001c001b7811ULL, 0x000fe200078fe8ffULL,
0x000000011e117824ULL, 0x040fe200078e0211ULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee206ULL,
0x000000011e137824ULL, 0x040fe200078e0213ULL, 0xfffffff81d187812ULL, 0x000fe200078ee204ULL,
0x000000011e157824ULL, 0x000fe200078e0215ULL, 0x0000000000047211ULL, 0x000fe200078fe8ffULL,
0x000000011e177824ULL, 0x000fe200078e0217ULL, 0x00000007201d7210ULL, 0x000fe20007fde0ffULL,
0x000000011e197824ULL, 0x000fe200078e0219ULL, 0x0000000704077812ULL, 0x000fe200078ec0ffULL,
0x000000011e067824ULL, 0x000fe200078e021bULL, 0x00000011201e7210ULL, 0x040fe20007fbe0ffULL,
0x000000025b1f7824ULL, 0x000fe200078e025aULL, 0x0000001320137210ULL, 0x040fe20007f9e0ffULL,
0x000000011b117824ULL, 0x040fe200078e0200ULL, 0x0000001520157210ULL, 0x040fe20007f7e0ffULL,
0x000000081b227824ULL, 0x000fe200078e00ffULL, 0x0000001720177210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200028e06ffULL, 0x0000001920197210ULL, 0x040fe20007f5e0ffULL,
0x000000102d027825ULL, 0x000fe200078e0002ULL, 0x00000006201c7210ULL, 0x000fc40007f3e0ffULL,
0x000130001f2b7811ULL, 0x000fe200078e68ffULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x00005e001d067a11ULL, 0x000fe400078c40ffULL, 0x0ffffff807047812ULL, 0x000fe200078ef800ULL,
0x00000010101f7824ULL, 0x000fe200078e022bULL, 0xfffffff822117812ULL, 0x000fe200078ee211ULL,
0x0000001012217824ULL, 0x100fe200078e022bULL, 0x00005f001d077a11ULL, 0x000fe200030f4420ULL,
0x00000010041d7824ULL, 0x100fe200078e022bULL, 0x00005e001e107a11ULL, 0x000fe200078a40ffULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x00005e0013127a11ULL, 0x040fe200078840ffULL,
0x0000001014237824ULL, 0x100fe200078e022bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000021d7faeULL, 0x0003e2000b901c46ULL, 0x0000001016257824ULL, 0x100fe200078e022bULL,
0x00005f0013137a11ULL, 0x000fe200020f4404ULL, 0x0000001018277824ULL, 0x000fc400078e022bULL,
0x000000101a297824ULL, 0x100fe400078e022bULL, 0x00000010112b7824ULL, 0x000fe200078e022bULL,
0x00005f001e117a11ULL, 0x000fe200028f441bULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078640ffULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0x00005e0017167a11ULL, 0x000fe200078040ffULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078440ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e06ffULL,
0x00005e001c1a7a11ULL, 0x000fe200078240ffULL, 0x000000102d067825ULL, 0x000fe200078e0006ULL,
0x00005f0015157a11ULL, 0x000fc400018f4420ULL, 0x00005f0017177a11ULL, 0x000fe200000f441eULL,
0x000000102d107825ULL, 0x000fe200078e0010ULL, 0x00005f0019197a11ULL, 0x000fe200010f4404ULL,
0x00000000061f7faeULL, 0x0003e2000b901c46ULL, 0x00005f001c1b7a11ULL, 0x000fe200008f441bULL,
0x000000102d127825ULL, 0x040fe400078e0012ULL, 0x0000000010217faeULL, 0x0003e4000b901c46ULL,
0x000000102d147825ULL, 0x040fe400078e0014ULL, 0x0000000012237faeULL, 0x0003e4000b901c46ULL,
0x000000102d167825ULL, 0x000fc400078e0016ULL, 0x0000000014257faeULL, 0x0003e4000b901c46ULL,
0x000000102d187825ULL, 0x040fe400078e0018ULL, 0x0000000016277faeULL, 0x0003e4000b901c46ULL,
0x000000102d1a7825ULL, 0x000fe400078e001aULL, 0x0000000018297faeULL, 0x0003e8000b901c46ULL,
0x000000001a2b7faeULL, 0x0003e4000b901c46ULL, 0x0000000b5800720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff777424ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x006fe2000001ff00ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000747000000947ULL, 0x000fea0003800000ULL,
0x0000000205027824ULL, 0x000fe400078e00ffULL, 0x00006400ff037624ULL, 0x000fc400078e00ffULL,
0xff317217ff777424ULL, 0x000fe400078e00ffULL, 0x000000ffff7a7224ULL, 0x000fe400078e00ffULL,
0x0000640002027624ULL, 0x000fe400078e0203ULL, 0x000000ffff177224ULL, 0x000fc400078e00ffULL,
0x0000010058067824ULL, 0x000fca00078e00ffULL, 0x0000000f0600720cULL, 0x000fda0003f06070ULL,
0x000073a000000947ULL, 0x030fea0003800000ULL, 0x000000100e067824ULL, 0x000fe200078e00ffULL,
0x0000000158107810ULL, 0x000fe20007ffe0ffULL, 0x000058000a0a7a24ULL, 0x000fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000b1000720cULL, 0x000fe20003f06070ULL,
0x000000ffff767224ULL, 0x000fe200078e000cULL, 0xffffffe006117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff067224ULL, 0x000fe400078e007aULL, 0x000000800a0a7824ULL, 0x000fe400078e00ffULL,
0x0000010058117824ULL, 0x000fca00078e0211ULL, 0x0000004011137810ULL, 0x000fc80007ffe0ffULL,
0x0000006008197812ULL, 0x000fe200078ef813ULL, 0x0000078000008947ULL, 0x000fea0003800000ULL,
0x000020000e117824ULL, 0x000fe200078e00ffULL, 0x000000130f107217ULL, 0x000fe20007800000ULL,
0x000000085a187824ULL, 0x000fe200078e00ffULL, 0x00000003ff217819ULL, 0x000fe40000011600ULL,
0x0000200011127812ULL, 0x000fe200078ec0ffULL, 0x000010007a117824ULL, 0x000fe200078e00ffULL,
0x00000004211b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a13ULL,
0x00000008211d7810ULL, 0x000fe20007ffe0ffULL, 0x000040005b127824ULL, 0x000fe200078e0212ULL,
0x0000100011137812ULL, 0x000fe200078e0cffULL, 0x0000000121117824ULL, 0x000fe200078e0219ULL,
0x0000000700257812ULL, 0x000fe200078ec0ffULL, 0x000000011d297824ULL, 0x100fe200078e0200ULL,
0x0001300012247810ULL, 0x000fe20007ffe013ULL, 0x000000011b277824ULL, 0x040fe200078e0200ULL,
0x000000110a127210ULL, 0x000fe20007f1e0ffULL, 0x000000011b117824ULL, 0x000fe200078e0219ULL,
0x0000000c212f7810ULL, 0x000fc40007ffe0ffULL, 0x0000002010267817ULL, 0x000fe20003800000ULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x00005e0012227a11ULL, 0x040fe200078040ffULL,
0x000000081d107824ULL, 0x000fe200078e00ffULL, 0x00000010214d7810ULL, 0x000fe20007ffe0ffULL,
0x000000012f2a7824ULL, 0x040fe200078e0200ULL, 0x00005f0012237a11ULL, 0x000fe200000f4413ULL,
0x000000012f137824ULL, 0x100fe200078e0219ULL, 0x000000110a127210ULL, 0x000fe20007f1e0ffULL,
0x000000011d117824ULL, 0x000fe200078e0219ULL, 0x0000000818257812ULL, 0x000fe200078ee225ULL,
0x000000081b187824ULL, 0x040fe200078e00ffULL, 0x000000261b00720cULL, 0x080fe20003f46070ULL,
0x000000014d1b7824ULL, 0x000fe200078e0219ULL, 0x000000261d00720cULL, 0x000fe20003f26070ULL,
0x000000ffff1f7224ULL, 0x000fe200000e06ffULL, 0xfffffff810297812ULL, 0x000fe200078ee229ULL,
0x0000001025227825ULL, 0x000fe200078e0022ULL, 0x000000110a1d7210ULL, 0x000fc40007f7e0ffULL,
0x00005e0012107a11ULL, 0x000fe200078040ffULL, 0x000000082f557824ULL, 0x000fe200078e00ffULL,
0x000000130a137210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0x0000001b0a1b7210ULL, 0x000fe20007fbe0ffULL, 0x0000001029297824ULL, 0x000fe200078e0224ULL,
0x00005f0012117a11ULL, 0x000fe200000f441fULL, 0x000000ffff1a7224ULL, 0x000fe200020e06ffULL,
0xfffffff818277812ULL, 0x000fe200078ee227ULL, 0x000000ffff187224ULL, 0x000fe200028e06ffULL,
0x00005e001d1e7a11ULL, 0x000fe200078040ffULL, 0x0000001025107825ULL, 0x000fe200078e0010ULL,
0x00005e00131c7a11ULL, 0x000fc400078640ffULL, 0x00005e001b127a11ULL, 0x000fe200078840ffULL,
0x0000001027277824ULL, 0x000fe200078e0224ULL, 0x00000014214f7810ULL, 0x000fe40007ffe0ffULL,
0x00005f001d1f7a11ULL, 0x000fe400000f4420ULL, 0x00005f00131d7a11ULL, 0x000fe200018f441aULL,
0x00000001211a7824ULL, 0x000fe200078e0200ULL, 0x00005f001b137a11ULL, 0x000fe200020f4418ULL,
0x000000014f1b7824ULL, 0x000fe200078e0219ULL, 0x0000001821517810ULL, 0x000fe20007ffe0ffULL,
0x00000010251e7825ULL, 0x000fe200078e001eULL, 0x0000001c21537810ULL, 0x000fc40007ffe0ffULL,
0x0000001b0a187210ULL, 0x000fe20007f1e0ffULL, 0x00000001511b7824ULL, 0x100fe200078e0219ULL,
0x000000071a2d7812ULL, 0x000fe200078ec0ffULL, 0x0000000153197824ULL, 0x000fe200078e0219ULL,
0x000000262100720cULL, 0x000fe20003f66070ULL, 0x000000ffff2b7224ULL, 0x000fe200000e06ffULL,
0x00005e00181a7a11ULL, 0x000fe200078040ffULL, 0x00000010251c7825ULL, 0x000fe200078e001cULL,
0x000000190a197210ULL, 0x040fe40007fbe0ffULL, 0x0ffffff82d2d7812ULL, 0x000fe200078ef800ULL,
0x0000001025127825ULL, 0x000fe200078e0012ULL, 0x0000001b0a217210ULL, 0x000fc40007f9e0ffULL,
0x00005f00181b7a11ULL, 0x000fe200000f442bULL, 0x000000102d2b7824ULL, 0x000fe200078e0224ULL,
0x000000262f00720cULL, 0x080fe20003f06070ULL, 0x000000ffff0a7224ULL, 0x000fe200028e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078a40ffULL, 0x000000ffff287224ULL, 0x000fe200020e06ffULL,
0x00005e0021207a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000222b7faeULL, 0x0003e2000d901c46ULL, 0x00005f0019197a11ULL, 0x000fe200028f440aULL,
0x000000014d0a7824ULL, 0x000fe200078e0200ULL, 0x00005f0021217a11ULL, 0x000fe200020f4428ULL,
0x000000084f2f7824ULL, 0x000fe200078e00ffULL, 0x000000264d00720cULL, 0x0c0fe20003f66070ULL,
0x000000084d4d7824ULL, 0x000fe200078e00ffULL, 0x000000264f00720cULL, 0x080fe20003f86070ULL,
0x0000000151287824ULL, 0x140fe200078e0200ULL, 0x000000265100720cULL, 0x0c0fe20003fa6070ULL,
0x0000000851517824ULL, 0x000fe200078e00ffULL, 0x000000265300720cULL, 0x000fe20003fc6070ULL,
0x000000014f267824ULL, 0x000fe200078e0200ULL, 0xfffffff8552d7812ULL, 0x000fe200078ee22aULL,
0x0000000153227824ULL, 0x002fe200078e0200ULL, 0xfffffff84d2b7812ULL, 0x000fe200078ee20aULL,
0x00000008534f7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee226ULL,
0x000000102d237824ULL, 0x000fe200078e0224ULL, 0xfffffff8514d7812ULL, 0x000fe200078ee228ULL,
0x000000102b2b7824ULL, 0x000fe200078e0224ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee222ULL,
0x000000102f2d7824ULL, 0x000fe200078e0224ULL, 0x0000000010277faeULL, 0x0003e2000d101c46ULL,
0x00000010251a7825ULL, 0x000fc600078e001aULL, 0x000000001e297faeULL, 0x0003e2000c901c46ULL,
0x000000104d2f7824ULL, 0x000fe400078e0224ULL, 0x0000001025207825ULL, 0x000fe200078e0020ULL,
0x000000001c237faeULL, 0x0003e6000c101c46ULL, 0x000000104f4d7824ULL, 0x000fe200078e0224ULL,
0x00000000122b7faeULL, 0x0003e2000d901c46ULL, 0x0000001025187825ULL, 0x000fc600078e0018ULL,
0x000000001a2d7faeULL, 0x0003e8000e101c46ULL, 0x00000000202f7faeULL, 0x0003e8000e901c46ULL,
0x00000000184d7faeULL, 0x0003e2000f101c46ULL, 0x000006b000007947ULL, 0x000fea0003800000ULL,
0x00000008001d7811ULL, 0x000fe200078fe8ffULL, 0x000000085a127824ULL, 0x000fe200078e00ffULL,
0x0000000c001f7811ULL, 0x000fe200078fe8ffULL, 0x000020000e107824ULL, 0x000fe200078e00ffULL,
0x0000000700257812ULL, 0x040fe200078ec0ffULL, 0x000000011d247824ULL, 0x140fe200078e0200ULL,
0x00000004001b7811ULL, 0x000fe200078fe8ffULL, 0x000000081d137824ULL, 0x000fe200078e00ffULL,
0x0000000812257812ULL, 0x000fe200078ee225ULL, 0x000000011f267824ULL, 0x040fe200078e0200ULL,
0x0000200010107812ULL, 0x000fe200078ec0ffULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0xfffffff813247812ULL, 0x000fe200078ee224ULL, 0x000000011b117824ULL, 0x040fe200078e0200ULL,
0x0000001900137211ULL, 0x040fe200078fe8ffULL, 0x000000081b127824ULL, 0x000fe200078e00ffULL,
0xfffffff821267812ULL, 0x000fe200078ee226ULL, 0x000000011b1b7824ULL, 0x100fe200078e0219ULL,
0x0000001000217811ULL, 0x040fe200078fe8ffULL, 0x000040005b5b7824ULL, 0x000fe200078e0210ULL,
0x0000001400237811ULL, 0x040fe200078fe8ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0219ULL,
0x0000001800297811ULL, 0x000fe200078fe8ffULL, 0x0000000121187824ULL, 0x140fe200078e0200ULL,
0x000000130a137210ULL, 0x000fe20007f1e0ffULL, 0x00000008214d7824ULL, 0x000fe200078e00ffULL,
0xfffffff812117812ULL, 0x000fe200078ee211ULL, 0x0000000123277824ULL, 0x140fe200078e0200ULL,
0x0000001c00207811ULL, 0x000fe200078fe8ffULL, 0x00000008231c7824ULL, 0x000fe200078e00ffULL,
0x0000001b0a1b7210ULL, 0x000fe20007f7e0ffULL, 0x00000001291a7824ULL, 0x000fe200078e0200ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee218ULL, 0x00000008294f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c277812ULL, 0x000fe200078ee227ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078040ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0219ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee21aULL, 0x0000000121217824ULL, 0x100fe200078e0219ULL,
0x00005f0013137a11ULL, 0x000fe200000f4410ULL, 0x0000000123237824ULL, 0x100fe200078e0219ULL,
0x0000001d0a187210ULL, 0x040fe20007f3e0ffULL, 0x0000000129297824ULL, 0x100fe200078e0219ULL,
0x0000001f0a107210ULL, 0x000fe20007f1e0ffULL, 0x0000000120197824ULL, 0x000fe200078e0219ULL,
0x00005e001b1a7a11ULL, 0x040fe200078c40ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x000000210a1f7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x000000230a1d7210ULL, 0x000fe20007f9e0ffULL, 0x0000000820517824ULL, 0x000fe200078e00ffULL,
0x000000290a297210ULL, 0x000fe20007fbe0ffULL, 0x000010007a1e7824ULL, 0x000fe200078e00ffULL,
0x000000190a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x00005f001b1b7a11ULL, 0x000fe200030f441cULL, 0x00000001201c7824ULL, 0x000fe200078e0200ULL,
0x00005e0018227a11ULL, 0x000fe200078240ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00005e0010207a11ULL, 0x000fe200078040ffULL, 0x000000ffff287224ULL, 0x000fe200020e06ffULL,
0x00005f0018237a11ULL, 0x000fe200008f4421ULL, 0x000000ffff537224ULL, 0x000fe200018e06ffULL,
0x00005f0010217a11ULL, 0x000fe200000f4419ULL, 0x000000ffff107224ULL, 0x000fe200028e06ffULL,
0x0000000000197211ULL, 0x000fe200078fe8ffULL, 0x0000001025127825ULL, 0x000fe200078e0012ULL,
0x000010001e1e7812ULL, 0x000fc400078e0cffULL, 0x00005e0029187a11ULL, 0x000fe200078440ffULL,
0x00000010251a7825ULL, 0x000fe200078e001aULL, 0x00000007192b7812ULL, 0x000fe400078ec0ffULL,
0x000130005b2c7810ULL, 0x000fe20007ffe01eULL, 0x0000001025227825ULL, 0x000fe200078e0022ULL,
0x00005e001f1e7a11ULL, 0x000fe400078040ffULL, 0x00005f0029197a11ULL, 0x000fe200010f4410ULL,
0x00000010242d7824ULL, 0x000fe200078e022cULL, 0xfffffff851517812ULL, 0x000fe200078ee21cULL,
0x00000010262f7824ULL, 0x000fe200078e022cULL, 0x0ffffff82b297812ULL, 0x000fe200078ef800ULL,
0x00000010112b7824ULL, 0x000fe200078e022cULL, 0x00005e001d1c7a11ULL, 0x000fe200078240ffULL,
0x0000001025207825ULL, 0x000fe200078e0020ULL, 0x00005f001f1f7a11ULL, 0x000fc400000f442aULL,
0x00005e000a107a11ULL, 0x040fe200078040ffULL, 0x0000001029297824ULL, 0x000fe200078e022cULL,
0x00005f001d1d7a11ULL, 0x000fe200008f4428ULL, 0x000000104d4d7824ULL, 0x000fe200078e022cULL,
0x00005f000a117a11ULL, 0x000fe200000f4453ULL, 0x00000010251e7825ULL, 0x000fe200078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012297faeULL, 0x0003e6000b901c46ULL,
0x0000001027277824ULL, 0x000fe200078e022cULL, 0x000000001a2b7faeULL, 0x0003e2000b901c46ULL,
0x00000010251c7825ULL, 0x000fc600078e001cULL, 0x00000000222d7faeULL, 0x0003e2000b901c46ULL,
0x000000104f4f7824ULL, 0x000fe400078e022cULL, 0x0000001025187825ULL, 0x000fe200078e0018ULL,
0x00000000202f7faeULL, 0x0003e6000b901c46ULL, 0x0000001051517824ULL, 0x000fe200078e022cULL,
0x000000001e4d7faeULL, 0x0003e2000b901c46ULL, 0x0000001025107825ULL, 0x000fc600078e0010ULL,
0x000000001c277faeULL, 0x0003e8000b901c46ULL, 0x00000000184f7faeULL, 0x0003e8000b901c46ULL,
0x0000000010517faeULL, 0x0003e4000b901c46ULL, 0x00000300ff757624ULL, 0x000fe200078e00ffULL,
0x000000010c0a7812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000010a00780cULL, 0x000fe20003f05070ULL, 0xffffffffff0a7424ULL, 0x000fe200078e00ffULL,
0xffffffff75757811ULL, 0x000fc800078e08ffULL, 0x0000000175757807ULL, 0x000fca0004000000ULL,
0x000000010c0c7824ULL, 0x000fca00078e0275ULL, 0x0000000d0c00720cULL, 0x000fda0003f06070ULL,
0x0000007502108210ULL, 0x002fe20007ffe076ULL, 0x00000004ff118424ULL, 0x000fc800078e00ffULL,
0x0000600010108625ULL, 0x000fca00078e0011ULL, 0x00000006100a8981ULL, 0x000322000c1e1900ULL,
0xffffffe059747812ULL, 0x040fe400078ec0ffULL, 0x0000001059137812ULL, 0x040fe400078ec0ffULL,
0x0000000859127812ULL, 0x000fc800078ec0ffULL, 0x0000007412747210ULL, 0x000fe20007ffe013ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080074187f8cULL, 0x0022a4000c80043fULL,
0x0000000000107805ULL, 0x000fc40000015200ULL, 0x01b60c0074137984ULL, 0x000ee40000000800ULL,
0x8000000013ff7812ULL, 0x00cfe40007804819ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012101b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001b12127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b60c0074137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x004fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000637824ULL, 0x000fe200078e00ffULL,
0x00000001ff607819ULL, 0x000fe20000011600ULL, 0x000000200e617824ULL, 0x000fc600078e00ffULL,
0x0000007063637812ULL, 0x000fe400078ec0ffULL, 0xffffff8061617812ULL, 0x000fe400078ec0ffULL,
0x0000000c60607812ULL, 0x000fc800078ec0ffULL, 0x0000006160107210ULL, 0x000fca0007ffe063ULL,
0x01b0000010127984ULL, 0x000ea80000000800ULL, 0x01b2000010187984ULL, 0x0006620000000800ULL,
0x000000771200720bULL, 0x004fe20003f1d000ULL, 0x000119427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x008fc800000e0100ULL, 0x0000ffff101e7812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff627224ULL, 0x000fd400078e0077ULL, 0x0000044000009947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fe4000001160eULL, 0x000000771200720bULL, 0x000fe40003f54000ULL,
0x0000000e1100720cULL, 0x000fe20003f25270ULL, 0x000119027f007947ULL, 0x000fd4000b800000ULL,
0x0000000000137806ULL, 0x000fc400010e0100ULL, 0x000000800e119824ULL, 0x000fe200078e0263ULL,
0x0000001277627209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991013107816ULL, 0x000fe200000000ffULL, 0x0000000160119824ULL, 0x000fca00078e0211ULL,
0x01b4006211009388ULL, 0x0005e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f25270ULL,
0x0000030000009947ULL, 0x000fea0003800000ULL, 0x8000006277107221ULL, 0x004fe20000010000ULL,
0x000000ff13ff7812ULL, 0x000fe2000782c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000197308ULL, 0x0004ec0000000800ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x004fe20000011600ULL,
0x000118527f007947ULL, 0x000fea000b800000ULL, 0x00001f1019107589ULL, 0x0084e400000e0000ULL,
0x0000001048487220ULL, 0x088fe40000410000ULL, 0x0000001049497220ULL, 0x080fe40000410000ULL,
0x0000001044447220ULL, 0x000fc40000410000ULL, 0x0000001045457220ULL, 0x080fe40000410000ULL,
0x0000001040407220ULL, 0x080fe40000410000ULL, 0x0000001041417220ULL, 0x080fe40000410000ULL,
0x000000103c3c7220ULL, 0x080fe40000410000ULL, 0x000000103d3d7220ULL, 0x080fe40000410000ULL,
0x0000001038387220ULL, 0x000fc40000410000ULL, 0x0000001039397220ULL, 0x080fe40000410000ULL,
0x0000001034347220ULL, 0x080fe40000410000ULL, 0x0000001035357220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x080fe40000410000ULL,
0x0000001014147220ULL, 0x000fc40000410000ULL, 0x0000001015157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0013ff7812ULL, 0x000fe2000782c0ffULL,
0x0000001907077220ULL, 0x008fd80000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x004fe200078ff0ffULL, 0x000117527f007947ULL, 0x000fea000b800000ULL,
0x00001f1019107589ULL, 0x0004e400000e0000ULL, 0x000000104a4a7220ULL, 0x088fe40000410000ULL,
0x000000104b4b7220ULL, 0x080fe40000410000ULL, 0x0000001046467220ULL, 0x080fe40000410000ULL,
0x0000001047477220ULL, 0x080fe40000410000ULL, 0x0000001042427220ULL, 0x080fe40000410000ULL,
0x0000001043437220ULL, 0x000fc40000410000ULL, 0x000000103e3e7220ULL, 0x080fe40000410000ULL,
0x000000103f3f7220ULL, 0x080fe40000410000ULL, 0x000000103a3a7220ULL, 0x080fe40000410000ULL,
0x000000103b3b7220ULL, 0x080fe40000410000ULL, 0x0000001036367220ULL, 0x080fe40000410000ULL,
0x0000001037377220ULL, 0x000fc40000410000ULL, 0x0000001032327220ULL, 0x080fe40000410000ULL,
0x0000001033337220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001017177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff1eff7812ULL, 0x000fda0007826013ULL, 0x8000006212121221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b12121820ULL, 0x000fc80000410000ULL,
0x0000001200051308ULL, 0x000ea40000000800ULL, 0x0000000518181220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000718077221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000005ff03723eULL, 0x000fe400000010ffULL,
0x00000002ff127819ULL, 0x000fe40000011600ULL, 0x0000541003137816ULL, 0x000fe20000000003ULL,
0x000115b27f007947ULL, 0x000fea000b800000ULL, 0x00001f1213037589ULL, 0x0002a400000e0000ULL,
0x0000000812047810ULL, 0x000fe20007ffe0ffULL, 0x000116027f007947ULL, 0x000fea000b800000ULL,
0x00001f0413047589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001012107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200078e0013ULL,
0x00002fa0001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0001234000007944ULL, 0x01efea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001812107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x004fe200078e0013ULL, 0x00003010001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000122d000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000007005d7812ULL, 0x000fe200078ec0ffULL, 0x000000020e5e7824ULL, 0x040fe200078e00ffULL,
0x00000004ff187819ULL, 0x100fe20000011600ULL, 0x000002000e127824ULL, 0x002fe200078e00ffULL,
0x000000085d107812ULL, 0x000fe200078ef800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000045e117812ULL, 0x000fc400078ec0ffULL, 0xfffff800125c7812ULL, 0x000fe200078ec0ffULL,
0x00000008101a7824ULL, 0x040fe200078e00ffULL, 0x0000001110117210ULL, 0x000fc80007ffe018ULL,
0xfffffff81a5f7812ULL, 0x000fe400078ee211ULL, 0x0000000800117812ULL, 0x000fc600078ec0ffULL,
0x000000105f5f7824ULL, 0x000fc800078e025cULL, 0x0000000711117812ULL, 0x000fe200078ef800ULL,
0x011000005f2c783bULL, 0x000e620000000200ULL, 0x00000001ff5b7819ULL, 0x000fe2000001160eULL,
0x000020005a6c7824ULL, 0x000fe200078e00ffULL, 0x00000010111b7812ULL, 0x044fe200078efcffULL,
0x0000000118127824ULL, 0x000fe200078e0211ULL, 0xfffffff85e5e7812ULL, 0x000fe200078ec0ffULL,
0x0000000811197824ULL, 0x040fe200078e00ffULL, 0x0000001b006a7211ULL, 0x000fe200078fe0ffULL,
0x0000000811737824ULL, 0x000fe200078e00ffULL, 0x0000000212727810ULL, 0x040fe20007ffe0ffULL,
0x000000045b137824ULL, 0x008fe200078e0218ULL, 0x0000000412717810ULL, 0x040fe20007ffe0ffULL,
0x00000008111a7824ULL, 0x000fe200078e00ffULL, 0xfffffff819727812ULL, 0x000fe200078ee272ULL,
0x000000025b197824ULL, 0x000fe200078e025aULL, 0x00000006126f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008111c7824ULL, 0x000fe200078e00ffULL, 0xfffffff873737812ULL, 0x000fe200078ee212ULL,
0x0000000219187824ULL, 0x000fe200078e027aULL, 0x0000000213137810ULL, 0x000fe20007ffe010ULL,
0x0000000810127824ULL, 0x000fe200078e00ffULL, 0xfffffff81a717812ULL, 0x000fe200078ee271ULL,
0x000040005b1d7824ULL, 0x000fe200078e026cULL, 0x0001300018107811ULL, 0x000fe200078e60ffULL,
0x000000081b187824ULL, 0x000fe200078e00ffULL, 0xfffffff81c6f7812ULL, 0x000fe200078ee26fULL,
0x000010007a1d7824ULL, 0x000fe200078e021dULL, 0xfffffff812197812ULL, 0x000fe200078ee213ULL,
0x0000001073547824ULL, 0x100fe200078e0210ULL, 0x000000026a697810ULL, 0x000fe20007ffe0ffULL,
0x0000001072507824ULL, 0x100fe200078e0210ULL, 0x000000046a687810ULL, 0x040fe20007ffe0ffULL,
0x00000010714c7824ULL, 0x100fe200078e0210ULL, 0x000000066a667810ULL, 0x000fe20007ffe0ffULL,
0x000000106f107824ULL, 0x000fe200078e0210ULL, 0x000000005454783bULL, 0x000ea20000004200ULL,
0x000000081b217824ULL, 0x040fe200078e00ffULL, 0xfffffff818697812ULL, 0x000fe200078ee269ULL,
0x000000081b1f7824ULL, 0x040fe200078e00ffULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x000000081b237824ULL, 0x000fe200078e00ffULL, 0x000130001d1d7810ULL, 0x000fe20007ffe0ffULL,
0x00000010195c7824ULL, 0x000fe200078e025cULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0xfffffff821687812ULL, 0x000fe200078ee268ULL, 0x000000032c2c0231ULL, 0x082fe200003400ffULL,
0xfffffff81f6a7812ULL, 0x000fe200078ee26aULL, 0x000000001010783bULL, 0x000fe20000004200ULL,
0xfffffff823667812ULL, 0x000fe200078ee266ULL, 0x0000001069287824ULL, 0x100fe200078e021dULL,
0x000000032e2e0231ULL, 0x000fe200003400ffULL, 0x011000005c18783bULL, 0x000e620000000200ULL,
0x0000001068247824ULL, 0x100fe200078e021dULL, 0x000000042d2d0231ULL, 0x080fe200003400ffULL,
0x000000106a207824ULL, 0x100fe200078e021dULL, 0x000000002828783bULL, 0x000e620000004200ULL,
0x00000010661d7824ULL, 0x000fe200078e021dULL, 0x000000042f2f0231ULL, 0x000fc400003400ffULL,
0x000000002424783bULL, 0x000e680000004200ULL, 0x000000002020783bULL, 0x000e680000004200ULL,
0x000000001d1c783bULL, 0x000e620000004200ULL, 0x000000542c48723cULL, 0x044ff00000041848ULL,
0x000000562c44723cULL, 0x040ff00000041844ULL, 0x000000502c40723cULL, 0x008f620000041840ULL,
0x0000000318180231ULL, 0x002fc400003400ffULL, 0x000000031a1a0231ULL, 0x000fe400003400ffULL,
0x0000000419190231ULL, 0x080fe400003400ffULL, 0x000000041b1b0231ULL, 0x000fe200003400ffULL,
0x000000522c3c723cULL, 0x040f70000004183cULL, 0x0000004c2c38723cULL, 0x040f700000041838ULL,
0x0000004e2c34723cULL, 0x040f700000041834ULL, 0x000000102c30723cULL, 0x040f700000041830ULL,
0x000000122c14723cULL, 0x000f700000041814ULL, 0x000000281840723cULL, 0x060b700000041840ULL,
0x0000002a183c723cULL, 0x040b70000004183cULL, 0x000000241838723cULL, 0x040b700000041838ULL,
0x000000261834723cULL, 0x040b700000041834ULL, 0x000000201848723cULL, 0x040b700000041848ULL,
0x000000221844723cULL, 0x040b700000041844ULL, 0x0000001c1830723cULL, 0x040b700000041830ULL,
0x0000001e1814723cULL, 0x000b620000041814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000004058107811ULL, 0x000fe200078e40ffULL, 0x01b688005eff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff777224ULL, 0x000fe200078e0062ULL, 0x000000017a7a7812ULL, 0x000fc400078e0cffULL,
0x0000000f1000720cULL, 0x000fda0003f06070ULL, 0x0000535000000947ULL, 0x000fea0003800000ULL,
0x000000100e107824ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe010117812ULL, 0x000fe200078ec0ffULL, 0x000058000a787a24ULL, 0x010fe200078e02ffULL,
0x0000000158107810ULL, 0x000fc60007ffe0ffULL, 0x0000010058117824ULL, 0x000fe200078e0211ULL,
0x0000000b1000720cULL, 0x000fe20003f06070ULL, 0x0000008078787824ULL, 0x000fc600078e00ffULL,
0x0000008011127810ULL, 0x000fc80007ffe0ffULL, 0x00000060081f7812ULL, 0x020fca00078ef812ULL,
0x0000077000008947ULL, 0x000fea0003800000ULL, 0x000000120f117217ULL, 0x000fe20007800000ULL,
0x000020000e107824ULL, 0x000fe200078e00ffULL, 0x00000003ff257819ULL, 0x000fc60000011600ULL,
0x0000000111117824ULL, 0x000fe200078e0a12ULL, 0x0000000425197810ULL, 0x040fe20007ffe0ffULL,
0x0000000125137824ULL, 0x100fe200078e021fULL, 0x0000200010187812ULL, 0x000fe200078ec0ffULL,
0x0000100006107824ULL, 0x000fe200078e00ffULL, 0x0000002011267817ULL, 0x000fe20003800000ULL,
0x0000000119117824ULL, 0x100fe200078e021fULL, 0x0000001378137210ULL, 0x040fe20007f3e0ffULL,
0x000040005b5b7824ULL, 0x000fe200078e0218ULL, 0x00000014252b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000119297824ULL, 0x100fe200078e0200ULL, 0x00000008251b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0x0000001178117210ULL, 0x000fe20007f5e0ffULL,
0x000000012b1d7824ULL, 0x100fe200078e021fULL, 0x00005e0013227a11ULL, 0x000fe200078240ffULL,
0x000000011b277824ULL, 0x040fe200078e0200ULL, 0x0000100010107812ULL, 0x000fe200078ec0ffULL,
0x000000081b1c7824ULL, 0x000fe200078e00ffULL, 0x00000010252d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x00005f0013237a11ULL, 0x000fe200008f4418ULL,
0x000000011b137824ULL, 0x100fe200078e021fULL, 0x000130005b247810ULL, 0x000fe20007ffe010ULL,
0x00000008191a7824ULL, 0x000fe200078e00ffULL, 0x000000261b00720cULL, 0x000fe20003f26070ULL,
0x000000012d1b7824ULL, 0x000fe200078e021fULL, 0x00005e0011107a11ULL, 0x000fc400078440ffULL,
0x0000001d781d7210ULL, 0x000fe40007f7e0ffULL, 0x0000000c25217810ULL, 0x000fe40007ffe0ffULL,
0x00005f0011117a11ULL, 0x000fe200010f4412ULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x000000261900720cULL, 0x000fe20003f06070ULL, 0x0000000121197824ULL, 0x040fe200078e021fULL,
0xfffffff81c277812ULL, 0x000fe200078ee227ULL, 0x00000001212c7824ULL, 0x040fe200078e0200ULL,
0x0000001b781b7210ULL, 0x000fe20007f5e0ffULL, 0x00000008214f7824ULL, 0x000fe200078e00ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078640ffULL, 0x0000001027277824ULL, 0x000fe200078e0224ULL,
0xfffffff81a297812ULL, 0x000fe200078ee229ULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x0000001378137210ULL, 0x000fc40007f9e0ffULL, 0x00005f001d1d7a11ULL, 0x000fe200018f441eULL,
0x00000001251e7824ULL, 0x000fe200078e0200ULL, 0x0000001978197210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0x00005e001b1a7a11ULL, 0x000fe200078440ffULL,
0x0000001029297824ULL, 0x000fe200078e0224ULL, 0x0000001825517810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff287224ULL, 0x000fe200028e06ffULL, 0x0000001c25537810ULL, 0x000fe40007ffe0ffULL,
0x00005f001b1b7a11ULL, 0x000fe200010f4420ULL, 0x000000085a207824ULL, 0x000fe200078e00ffULL,
0x00005e0013127a11ULL, 0x000fe200078840ffULL, 0x00000001512f7824ULL, 0x100fe200078e021fULL,
0x000000071e4d7812ULL, 0x000fe200078ec0ffULL, 0x00000001531f7824ULL, 0x000fe200078e021fULL,
0x00005e0019187a11ULL, 0x000fc400078a40ffULL, 0x000000262500720cULL, 0x000fe40003f66070ULL,
0x00005f0013137a11ULL, 0x000fe400020f442aULL, 0x0ffffff84d4d7812ULL, 0x000fe400078ef800ULL,
0x00005f0019197a11ULL, 0x000fe400028f4428ULL, 0x0000000820257812ULL, 0x000fe400078ee25dULL,
0x0000002f782a7210ULL, 0x040fe20007f5e0ffULL, 0x000000104d2f7824ULL, 0x000fe200078e0224ULL,
0x0000001f78287210ULL, 0x000fe20007fbe0ffULL, 0x0000001025227825ULL, 0x000fe200078e0022ULL,
0x00005e002a1e7a11ULL, 0x000fc400078840ffULL, 0x000000ffff4d7210ULL, 0x000fe20002ffe4ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e06ffULL, 0x00005e0028207a11ULL, 0x000fe200078a40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000222f7faeULL, 0x0003e2000d901c46ULL,
0x000000262100720cULL, 0x080fe20003f46070ULL, 0x0000001025107825ULL, 0x000fe200078e0010ULL,
0x00005f002a1f7a11ULL, 0x000fe400020f441fULL, 0x00005f0028217a11ULL, 0x000fe200028f444dULL,
0x000000012b287824ULL, 0x100fe200078e0200ULL, 0x000000262d00720cULL, 0x080fe20003f66070ULL,
0x000000082b4d7824ULL, 0x040fe200078e00ffULL, 0x000000262b00720cULL, 0x080fe20003f86070ULL,
0x00000001512a7824ULL, 0x140fe200078e0200ULL, 0x000000265100720cULL, 0x0c0fe20003fa6070ULL,
0x0000000851517824ULL, 0x000fe200078e00ffULL, 0x000000265300720cULL, 0x000fe20003fc6070ULL,
0x000000012d267824ULL, 0x000fe200078e0200ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee22cULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8512f7812ULL, 0x002fe200078ee22aULL,
0x0000000153227824ULL, 0x040fe200078e0200ULL, 0x0000000010297faeULL, 0x0003e2000c101c46ULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2b7812ULL, 0x000fe200078ee226ULL,
0x0000001025127825ULL, 0x000fe200078e0012ULL, 0xfffffff84d2d7812ULL, 0x000fc400078ee228ULL,
0xfffffff8534d7812ULL, 0x000fe200078ee222ULL, 0x000000104f237824ULL, 0x000fe200078e0224ULL,
0x0000000012277faeULL, 0x0003e2000c901c46ULL, 0x0000001025187825ULL, 0x000fc800078e0018ULL,
0x000000102b2b7824ULL, 0x000fe200078e0224ULL, 0x0000000018237faeULL, 0x0003e2000d101c46ULL,
0x00000010251a7825ULL, 0x000fc800078e001aULL, 0x000000102d2d7824ULL, 0x000fe200078e0224ULL,
0x000000001a2b7faeULL, 0x0003e2000d901c46ULL, 0x00000010251c7825ULL, 0x000fc800078e001cULL,
0x000000102f2f7824ULL, 0x000fe200078e0224ULL, 0x000000001c2d7faeULL, 0x0003e2000e101c46ULL,
0x00000010251e7825ULL, 0x000fc800078e001eULL, 0x000000104d4d7824ULL, 0x000fe200078e0224ULL,
0x000000001e2f7faeULL, 0x0003e2000e901c46ULL, 0x0000001025207825ULL, 0x000fca00078e0020ULL,
0x00000000204d7faeULL, 0x0003e2000f101c46ULL, 0x000006a000007947ULL, 0x000fea0003800000ULL,
0x000020000e107824ULL, 0x000fe200078e00ffULL, 0x00000010001b7811ULL, 0x000fe200078fe8ffULL,
0x000000085a2c7824ULL, 0x000fe200078e00ffULL, 0x0000000400127811ULL, 0x000fe400078fe8ffULL,
0x0000200010107812ULL, 0x000fe200078ec0ffULL, 0x000000011b267824ULL, 0x140fe200078e0200ULL,
0x0000000c00197811ULL, 0x040fe200078fe8ffULL, 0x000000081b117824ULL, 0x000fe200078e00ffULL,
0x00000014001d7811ULL, 0x000fe200078fe8ffULL, 0x00000001122b7824ULL, 0x000fe200078e0200ULL,
0x0000000800137811ULL, 0x000fe200078fe8ffULL, 0x0000000812187824ULL, 0x000fe200078e00ffULL,
0xfffffff811267812ULL, 0x000fe200078ee226ULL, 0x000040005b287824ULL, 0x000fe200078e0210ULL,
0x0000001f00117211ULL, 0x000fe200078fe8ffULL, 0x0000000119277824ULL, 0x140fe200078e0200ULL,
0xfffffff8182b7812ULL, 0x000fe200078ee22bULL, 0x0000000819107824ULL, 0x000fe200078e00ffULL,
0x000000082c537812ULL, 0x000fe200078ee25dULL, 0x000000011d217824ULL, 0x000fc400078e0200ULL,
0x000000081d187824ULL, 0x000fe200078e00ffULL, 0xfffffff810277812ULL, 0x000fe200078ee227ULL,
0x0000000113297824ULL, 0x140fe200078e0200ULL, 0x0000001178107210ULL, 0x000fe20007f1e0ffULL,
0x00000008131a7824ULL, 0x040fe200078e00ffULL, 0xfffffff818217812ULL, 0x000fe200078ee221ULL,
0x0000000112117824ULL, 0x100fe200078e021fULL, 0x0000001800187811ULL, 0x000fe200078fe8ffULL,
0x0000000113137824ULL, 0x000fe200078e021fULL, 0xfffffff81a297812ULL, 0x000fe200078ee229ULL,
0x000000ffff237224ULL, 0x000fe200000e06ffULL, 0x0000001c001a7811ULL, 0x000fe200078fe8ffULL,
0x0000000119197824ULL, 0x100fe200078e021fULL, 0x0000001178117210ULL, 0x000fe20007f3e0ffULL,
0x000000011b1b7824ULL, 0x100fe200078e021fULL, 0x00005e0010227a11ULL, 0x000fe200078040ffULL,
0x000000011d1d7824ULL, 0x100fe200078e021fULL, 0x0000001378137210ULL, 0x000fe20007f5e0ffULL,
0x00000001182d7824ULL, 0x000fe200078e021fULL, 0x00005f0010237a11ULL, 0x000fe200000f4423ULL,
0x0000000118257824ULL, 0x040fe200078e0200ULL, 0x00005e0011107a11ULL, 0x000fe200078040ffULL,
0x0000000818187824ULL, 0x000fc400078e00ffULL, 0x000000011a1f7824ULL, 0x040fe400078e021fULL,
0x000000011a247824ULL, 0x000fe200078e0200ULL, 0xfffffff818257812ULL, 0x000fe200078ee225ULL,
0x000000081a2f7824ULL, 0x000fe400078e00ffULL, 0x0000100006127824ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0xfffffff82f247812ULL, 0x000fe200078ee224ULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00001000122f7812ULL, 0x000fe200078ec0ffULL,
0x0000001053227825ULL, 0x000fe200078e0022ULL, 0x00005f0011117a11ULL, 0x000fc400000f441aULL,
0x00005e0013127a11ULL, 0x000fe400078240ffULL, 0x0000001978197210ULL, 0x040fe20007f1e0ffULL,
0x0000001053107825ULL, 0x000fe200078e0010ULL, 0x00005f0013137a11ULL, 0x000fe400008f4418ULL,
0x0000001b781b7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200000e06ffULL,
0x0000001d781d7210ULL, 0x000fe20007f5e0ffULL, 0x0000001053127825ULL, 0x000fe200078e0012ULL,
0x00005e0019187a11ULL, 0x000fc400078040ffULL, 0x0001300028287810ULL, 0x000fe20007ffe02fULL,
0x000000ffff207224ULL, 0x000fe200008e06ffULL, 0x00005f0019197a11ULL, 0x000fe200000f442aULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x00005e001b1a7a11ULL, 0x000fe200078240ffULL,
0x000000102b2b7824ULL, 0x100fe200078e0228ULL, 0x0000002d782d7210ULL, 0x000fe20007f1e0ffULL,
0x00000010214d7824ULL, 0x100fe200078e0228ULL, 0x00005e001d1c7a11ULL, 0x000fe200078440ffULL,
0x0000001029297824ULL, 0x100fe200078e0228ULL, 0x00000000002a7211ULL, 0x000fe200078fe8ffULL,
0x0000001027277824ULL, 0x000fe200078e0228ULL, 0x00005f001b1b7a11ULL, 0x000fe200008f4420ULL,
0x000000ffff207224ULL, 0x000fe200000e06ffULL, 0x00005f001d1d7a11ULL, 0x000fe200010f441eULL,
0x0000001053187825ULL, 0x000fe200078e0018ULL, 0x00005e002d1e7a11ULL, 0x000fc400078040ffULL,
0x000000072a2f7812ULL, 0x000fe200078ec0ffULL, 0x00000010531a7825ULL, 0x000fe200078e001aULL,
0x0000001f782a7210ULL, 0x000fe40007f3e0ffULL, 0x00005f002d1f7a11ULL, 0x000fe200000f4420ULL,
0x00000010531c7825ULL, 0x000fe200078e001cULL, 0x0ffffff82f2d7812ULL, 0x000fe400078ef800ULL,
0x00005e002a207a11ULL, 0x000fe200078040ffULL, 0x000000ffff517224ULL, 0x000fe400008e06ffULL,
0x000000102d2d7824ULL, 0x000fc400078e0228ULL, 0x00000010262f7824ULL, 0x100fe200078e0228ULL,
0x00005f002a217a11ULL, 0x000fe200000f4451ULL, 0x0000001025257824ULL, 0x000fe200078e0228ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000222d7faeULL, 0x0003e2000b901c46ULL,
0x00000010531e7825ULL, 0x000fc600078e001eULL, 0x00000000102b7faeULL, 0x0003e2000b901c46ULL,
0x00000010244f7824ULL, 0x000fe400078e0228ULL, 0x0000001053207825ULL, 0x000fe200078e0020ULL,
0x0000000012297faeULL, 0x0003e8000b901c46ULL, 0x0000000018277faeULL, 0x0003e8000b901c46ULL,
0x000000001a2f7faeULL, 0x0003e8000b901c46ULL, 0x000000001c4d7faeULL, 0x0003e8000b901c46ULL,
0x000000001e257faeULL, 0x0003e8000b901c46ULL, 0x00000000204f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6280074107f8cULL, 0x0022a4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x01b62c0074197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x00cfc40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018121b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e13ULL, 0x003d09001b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011419ULL,
0x0000001b18187211ULL, 0x000fca00078110ffULL, 0x000000ffff197224ULL, 0x000fca00000e0619ULL,
0x0000000218187819ULL, 0x000fc80000001219ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b62c0074197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008063117810ULL, 0x000fca0007ffe061ULL, 0x0000000160117824ULL, 0x000fca00078e0211ULL,
0x01b0000011137984ULL, 0x000ea80000000800ULL, 0x01b2000011127984ULL, 0x0006620000000800ULL,
0x000000621300720bULL, 0x004fe20003f1d000ULL, 0x0000fd227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x008fc800000e0100ULL, 0x0000ffff101f7812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff777224ULL, 0x000fd400078e0062ULL, 0x0000044000009947ULL, 0x000fea0003800000ULL,
0x000000010e117811ULL, 0x000fe400078ff0ffULL, 0x000000621300720bULL, 0x000fe40003f54000ULL,
0x0000000e1100720cULL, 0x000fe20003f25270ULL, 0x0000fce27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000187806ULL, 0x000fc400010e0100ULL, 0x000000800e119824ULL, 0x000fe200078e0263ULL,
0x0000006213777209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991018107816ULL, 0x000fe200000000ffULL, 0x00000001601a9824ULL, 0x000fca00078e0211ULL,
0x01b400771a009388ULL, 0x0005e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f25270ULL,
0x0000030000009947ULL, 0x000fea0003800000ULL, 0x0000006277107221ULL, 0x004fe20000010100ULL,
0x000000ff18ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x00000010001a7308ULL, 0x000ea40000000800ULL,
0x0000001a07077220ULL, 0x004fc80000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x0000fc227f007947ULL, 0x000fea000b800000ULL,
0x00001f101a107589ULL, 0x0004e400000e0000ULL, 0x0000001048487220ULL, 0x088fe40000410000ULL,
0x0000001049497220ULL, 0x080fe40000410000ULL, 0x0000001044447220ULL, 0x080fe40000410000ULL,
0x0000001045457220ULL, 0x080fe40000410000ULL, 0x0000001040407220ULL, 0x080fe40000410000ULL,
0x0000001041417220ULL, 0x000fc40000410000ULL, 0x000000103c3c7220ULL, 0x080fe40000410000ULL,
0x000000103d3d7220ULL, 0x080fe40000410000ULL, 0x0000001038387220ULL, 0x080fe40000410000ULL,
0x0000001039397220ULL, 0x080fe40000410000ULL, 0x0000001034347220ULL, 0x080fe40000410000ULL,
0x0000001035357220ULL, 0x000fc40000410000ULL, 0x0000001030307220ULL, 0x080fe40000410000ULL,
0x0000001031317220ULL, 0x080fe40000410000ULL, 0x0000001014147220ULL, 0x080fe40000410000ULL,
0x0000001015157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0018ff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x000fe200078ff0ffULL, 0x0000fb327f007947ULL, 0x000fea000b800000ULL,
0x00001f101a107589ULL, 0x0006a400000e0000ULL, 0x000000104a4a7220ULL, 0x084fe40000410000ULL,
0x000000104b4b7220ULL, 0x080fe40000410000ULL, 0x0000001046467220ULL, 0x080fe40000410000ULL,
0x0000001047477220ULL, 0x080fe40000410000ULL, 0x0000001042427220ULL, 0x080fe40000410000ULL,
0x0000001043437220ULL, 0x000fc40000410000ULL, 0x000000103e3e7220ULL, 0x080fe40000410000ULL,
0x000000103f3f7220ULL, 0x080fe40000410000ULL, 0x000000103a3a7220ULL, 0x080fe40000410000ULL,
0x000000103b3b7220ULL, 0x080fe40000410000ULL, 0x0000001036367220ULL, 0x080fe40000410000ULL,
0x0000001037377220ULL, 0x000fc40000410000ULL, 0x0000001032327220ULL, 0x080fe40000410000ULL,
0x0000001033337220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001017177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff1fff7812ULL, 0x000fda0007826018ULL, 0x0000001377131221ULL, 0x000fe20000010100ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b13131820ULL, 0x000fc80000410000ULL,
0x0000001300051308ULL, 0x000ea40000000800ULL, 0x0000000512121220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000712077221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000005ff03723eULL, 0x000fe400000010ffULL,
0x00000002ff137819ULL, 0x000fe40000011600ULL, 0x0000541003127816ULL, 0x000fe20000000003ULL,
0x0000f9927f007947ULL, 0x000fea000b800000ULL, 0x00001f1312037589ULL, 0x0002a400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x0000f9e27f007947ULL, 0x000fea000b800000ULL,
0x00001f1012047589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200078e0012ULL,
0x00004e60001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0001048000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x004fe200078e0012ULL, 0x00004ed0001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0001041000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000100006797824ULL, 0x000fe200078e00ffULL,
0x00000001ff5b7819ULL, 0x000fe2000001160eULL, 0x011800005f28783bULL, 0x000f260000000200ULL,
0x0000100079797812ULL, 0x000fe200078e0cffULL, 0x000000025b107824ULL, 0x002fc400078e025aULL,
0x000040005b187824ULL, 0x000fe400078e026cULL, 0x0000200010107824ULL, 0x000fc600078e0079ULL,
0x0001300018197810ULL, 0x000fe40007ffe079ULL, 0x0001300010107810ULL, 0x000fc60007ffe0ffULL,
0x000000106a677824ULL, 0x100fe400078e0219ULL, 0x0000001073707824ULL, 0x100fe400078e0210ULL,
0x00000010726e7824ULL, 0x100fe200078e0210ULL, 0x000000006724783bULL, 0x000fe20000004200ULL,
0x00000010716d7824ULL, 0x100fe400078e0210ULL, 0x000000106f6b7824ULL, 0x000fe200078e0210ULL,
0x000000007054783bULL, 0x000e620000004200ULL, 0x0000001069657824ULL, 0x000fc400078e0219ULL,
0x0000001068647824ULL, 0x100fe200078e0219ULL, 0x000000006e50783bULL, 0x000ee20000004200ULL,
0x0000001066627824ULL, 0x000fc600078e0219ULL, 0x000000006d4c783bULL, 0x000fe80000004200ULL,
0x000000006b2c783bULL, 0x000fe20000004200ULL, 0x0000000328280231ULL, 0x014fc600003400ffULL,
0x011800005c10783bULL, 0x000ea20000000200ULL, 0x000000032a2a0231ULL, 0x000fe400003400ffULL,
0x0000000429290231ULL, 0x088fe200003400ffULL, 0x000000006520783bULL, 0x000ee20000004200ULL,
0x000000042b2b0231ULL, 0x000fc600003400ffULL, 0x00000000641c783bULL, 0x000f280000004200ULL,
0x000000006218783bULL, 0x000ee20000004200ULL, 0x000000542848723cULL, 0x042f700000041848ULL,
0x000000562844723cULL, 0x040f700000041844ULL, 0x000000502840723cULL, 0x000f620000041840ULL,
0x0000000310100231ULL, 0x004fc400003400ffULL, 0x0000000312120231ULL, 0x000fe400003400ffULL,
0x0000000411110231ULL, 0x080fe400003400ffULL, 0x0000000413130231ULL, 0x000fe200003400ffULL,
0x00000052283c723cULL, 0x040f70000004183cULL, 0x0000004c2838723cULL, 0x040f700000041838ULL,
0x0000004e2834723cULL, 0x040f700000041834ULL, 0x0000002c2830723cULL, 0x040f700000041830ULL,
0x0000002e2814723cULL, 0x000f700000041814ULL, 0x000000241048723cULL, 0x060b700000041848ULL,
0x000000261044723cULL, 0x040b700000041844ULL, 0x000000201040723cULL, 0x048b700000041840ULL,
0x00000022103c723cULL, 0x040b70000004183cULL, 0x0000001c1038723cULL, 0x050b700000041838ULL,
0x0000001e1034723cULL, 0x040b700000041834ULL, 0x000000181030723cULL, 0x040b700000041830ULL,
0x0000001a1014723cULL, 0x000b620000041814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000008058107811ULL, 0x020fe200078e40ffULL, 0x01b690005eff7f8cULL, 0x0003e2000c80043fULL,
0x00000001067a7812ULL, 0x000fc400078ec0ffULL, 0x0000000f1000720cULL, 0x000fda0003f06070ULL,
0x0000376000000947ULL, 0x000fea0003800000ULL, 0x000000100e0a7824ULL, 0x002fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe00a117812ULL, 0x000fe400078ec0ffULL,
0x00000001580a7810ULL, 0x000fc60007ffe0ffULL, 0x0000010058117824ULL, 0x000fe200078e0211ULL,
0x0000000b0a00720cULL, 0x000fc80003f06070ULL, 0x000000c011137810ULL, 0x000fc80007ffe0ffULL,
0x0000006008117812ULL, 0x000fca00078ef813ULL, 0x0000075000008947ULL, 0x000fea0003800000ULL,
0x000020000e0c7824ULL, 0x000fe200078e00ffULL, 0x000000130f0a7217ULL, 0x000fe20007800000ULL,
0x000000085a267824ULL, 0x000fe200078e00ffULL, 0x00000003ff237819ULL, 0x000fe40000011600ULL,
0x000020000c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000010a247824ULL, 0x000fe200078e0a13ULL,
0x00000004231b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000123137824ULL, 0x040fe200078e0211ULL,
0x00000008231d7810ULL, 0x000fe20007ffe0ffULL, 0x000040005b0c7824ULL, 0x000fe200078e020cULL,
0x0000000c23217810ULL, 0x000fe20007ffe0ffULL, 0x000000011b0a7824ULL, 0x140fe200078e0200ULL,
0x0000001378107210ULL, 0x000fe20007f1e0ffULL, 0x000000081b197824ULL, 0x000fe200078e00ffULL,
0x000130000c797810ULL, 0x000fe20007ffe079ULL, 0x000000011d0c7824ULL, 0x040fe200078e0200ULL,
0x0000002024247817ULL, 0x000fe20003800000ULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8190a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x00005e00101e7a11ULL, 0x040fe200078040ffULL, 0x000000011b137824ULL, 0x000fe200078e0211ULL,
0xfffffff81f0c7812ULL, 0x000fe200078ee20cULL, 0x0000000121287824ULL, 0x040fe200078e0200ULL,
0x00005f00101f7a11ULL, 0x000fe200000f4419ULL, 0x0000000121197824ULL, 0x100fe200078e0211ULL,
0x0000001378107210ULL, 0x000fe20007f1e0ffULL, 0x000000011d137824ULL, 0x100fe200078e0211ULL,
0x0000001023277810ULL, 0x000fe20007ffe0ffULL, 0x00000008214f7824ULL, 0x000fe200078e00ffULL,
0x000000241d00720cULL, 0x080fe20003f26070ULL, 0x000000ffff1d7224ULL, 0x000fe200000e06ffULL,
0x000000241b00720cULL, 0x000fe20003f46070ULL, 0x00000001271b7824ULL, 0x000fe200078e0211ULL,
0x00005e00101c7a11ULL, 0x000fc400078040ffULL, 0x0000001378227210ULL, 0x040fe40007f7e0ffULL,
0x0000001423297810ULL, 0x000fe40007ffe0ffULL, 0x0000001978197210ULL, 0x000fe40007f9e0ffULL,
0x00005f00101d7a11ULL, 0x000fe200000f441dULL, 0x0000000129257824ULL, 0x000fe200078e0211ULL,
0x0000001b78107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e06ffULL,
0x00005e00221a7a11ULL, 0x000fe200078040ffULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078640ffULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0x00000018232d7810ULL, 0x000fc40007ffe0ffULL, 0x00005f00221b7a11ULL, 0x000fe200000f441bULL,
0x0000000123227824ULL, 0x040fe200078e0200ULL, 0x0000001c232b7810ULL, 0x000fe20007ffe0ffULL,
0x000000082d2a7824ULL, 0x000fe200078e00ffULL, 0x0000002578257210ULL, 0x000fe40007f1e0ffULL,
0x00005e0010127a11ULL, 0x040fe200078840ffULL, 0x000000082b2c7824ULL, 0x000fe200078e00ffULL,
0x00005f0019197a11ULL, 0x000fe200018f4420ULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x000000242300720cULL, 0x000fe20003f66070ULL, 0x000000012d237824ULL, 0x000fe200078e0211ULL,
0x00005f0010137a11ULL, 0x000fe200020f4413ULL, 0x000000012b117824ULL, 0x000fe200078e0211ULL,
0x00005e0025107a11ULL, 0x000fc400078040ffULL, 0x00000007222f7812ULL, 0x000fe400078ec0ffULL,
0x0000002378237210ULL, 0x040fe40007f9e0ffULL, 0x0000001178787210ULL, 0x000fe40007fbe0ffULL,
0x00005f0025117a11ULL, 0x000fe400000f4420ULL, 0x0ffffff82f207812ULL, 0x000fe200078ef800ULL,
0x000000ffff4d7224ULL, 0x000fe200028e06ffULL, 0x0000000826257812ULL, 0x000fe200078ee25dULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x00005e0023227a11ULL, 0x000fe200078840ffULL,
0x00000010202f7824ULL, 0x000fe200078e0279ULL, 0x00005e0078207a11ULL, 0x000fe200078a40ffULL,
0x00000010251e7825ULL, 0x000fe200078e001eULL, 0x000000242100720cULL, 0x000fc40003f06070ULL,
0x00005f0023237a11ULL, 0x000fe200020f4426ULL, 0x0000000129267824ULL, 0x000fe200078e0200ULL,
0x00005f0078217a11ULL, 0x000fe200028f444dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e2f7faeULL, 0x0003e2000d901c46ULL, 0x000000242700720cULL, 0x0c0fe20003f66070ULL,
0x00000008274d7824ULL, 0x000fe200078e00ffULL, 0x000000242900720cULL, 0x0c0fe20003f86070ULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x000000242d00720cULL, 0x080fe20003fa6070ULL,
0x00000010251c7825ULL, 0x000fe200078e001cULL, 0x000000242b00720cULL, 0x000fc40003fc6070ULL,
0xfffffff84f287812ULL, 0x000fe200078ee228ULL, 0x0000000127247824ULL, 0x000fe200078e0200ULL,
0xfffffff829267812ULL, 0x000fe200078ee226ULL, 0x000000012d277824ULL, 0x100fe400078e0200ULL,
0x000000012b1f7824ULL, 0x002fe200078e0200ULL, 0xfffffff84d247812ULL, 0x000fe200078ee224ULL,
0x00000010251a7825ULL, 0x000fe200078e001aULL, 0xfffffff82a1e7812ULL, 0x000fe400078ee227ULL,
0xfffffff82c2a7812ULL, 0x000fe200078ee21fULL, 0x000000100a1f7824ULL, 0x000fc400078e0279ULL,
0x000000100c277824ULL, 0x100fe400078e0279ULL, 0x0000001028297824ULL, 0x000fe200078e0279ULL,
0x000000001c1f7faeULL, 0x0003e2000d101c46ULL, 0x0000001025187825ULL, 0x000fc600078e0018ULL,
0x000000001a277faeULL, 0x0003e2000c901c46ULL, 0x00000010242b7824ULL, 0x000fe400078e0279ULL,
0x0000001025127825ULL, 0x040fe200078e0012ULL, 0x0000000018297faeULL, 0x0003e6000c101c46ULL,
0x00000010262d7824ULL, 0x000fe200078e0279ULL, 0x00000000122b7faeULL, 0x0003e2000d901c46ULL,
0x0000001025107825ULL, 0x000fc800078e0010ULL, 0x000000101e2f7824ULL, 0x000fe200078e0279ULL,
0x00000000102d7faeULL, 0x0003e2000e101c46ULL, 0x0000001025227825ULL, 0x000fc800078e0022ULL,
0x000000102a797824ULL, 0x000fe200078e0279ULL, 0x00000000222f7faeULL, 0x0003e2000e901c46ULL,
0x0000001025207825ULL, 0x000fca00078e0020ULL, 0x0000000020797faeULL, 0x0003e2000f101c46ULL,
0x0000068000007947ULL, 0x000fea0003800000ULL, 0x00000008001b7811ULL, 0x000fe200078fe8ffULL,
0x000020000e0a7824ULL, 0x000fe200078e00ffULL, 0x0000000c001d7811ULL, 0x000fe200078fe8ffULL,
0x000000085a2a7824ULL, 0x000fe200078e00ffULL, 0x0000000400197811ULL, 0x040fe200078fe8ffULL,
0x000000011b267824ULL, 0x140fe200078e0200ULL, 0x0000001000217811ULL, 0x040fe200078fe8ffULL,
0x000000081b137824ULL, 0x000fe200078e00ffULL, 0x0000001400237811ULL, 0x000fe200078fe8ffULL,
0x000000011d247824ULL, 0x040fe200078e0200ULL, 0x000020000a0a7812ULL, 0x000fe200078ec0ffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff813267812ULL, 0x000fe200078ee226ULL,
0x0000000119257824ULL, 0x040fe200078e0200ULL, 0x0000001100137211ULL, 0x000fe200078fe8ffULL,
0x00000008190c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f247812ULL, 0x000fe200078ee224ULL,
0x00000001211f7824ULL, 0x140fe200078e0200ULL, 0x0000001378137210ULL, 0x000fe20007f1e0ffULL,
0x0000000821187824ULL, 0x000fe200078e00ffULL, 0x0000001800277811ULL, 0x000fe200078fe8ffULL,
0x0000000119197824ULL, 0x000fe200078e0211ULL, 0xfffffff80c257812ULL, 0x000fe200078ee225ULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078040ffULL,
0x000000011b1b7824ULL, 0x000fe200078e0211ULL, 0xfffffff8181f7812ULL, 0x000fe200078ee21fULL,
0x00000001230c7824ULL, 0x000fe200078e0200ULL, 0x00005f0013137a11ULL, 0x000fe200000f4410ULL,
0x0000000823297824ULL, 0x000fe200078e00ffULL, 0x0000001c00107811ULL, 0x000fe200078fe8ffULL,
0x000000011d1d7824ULL, 0x100fe200078e0211ULL, 0x0000001978187210ULL, 0x040fe20007f9e0ffULL,
0x000040005b1e7824ULL, 0x000fe200078e020aULL, 0x0000001b78287210ULL, 0x040fe20007f7e0ffULL,
0x00000001270a7824ULL, 0x000fe200078e0200ULL, 0xfffffff8290c7812ULL, 0x000fe200078ee20cULL,
0x00000008272b7824ULL, 0x000fe200078e00ffULL, 0x0000001d781b7210ULL, 0x000fe20007f1e0ffULL,
0x0000000121217824ULL, 0x000fe200078e0211ULL, 0x000130001e797810ULL, 0x000fe20007ffe079ULL,
0x0000000123237824ULL, 0x100fe200078e0211ULL, 0xfffffff82b0a7812ULL, 0x000fe200078ee20aULL,
0x0000000127277824ULL, 0x100fe200078e0211ULL, 0x0000002178197210ULL, 0x000fe20007f3e0ffULL,
0x0000000110117824ULL, 0x000fe200078e0211ULL, 0x0000002378237210ULL, 0x000fe20007f5e0ffULL,
0x00000001101a7824ULL, 0x000fc400078e0200ULL, 0x0000000810297824ULL, 0x000fe200078e00ffULL,
0x00005e0018107a11ULL, 0x000fe200078c40ffULL, 0x000000ffff1d7224ULL, 0x000fe200020e06ffULL,
0x0000002778217210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff227224ULL, 0x000fe200000e06ffULL,
0x0000001178787210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff207224ULL, 0x000fe200008e06ffULL,
0x00005f0018117a11ULL, 0x000fe200030f441dULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0xfffffff829277812ULL, 0x000fe200078ee21aULL, 0x000000ffff1e7224ULL, 0x000fe200020e06ffULL,
0x00005e00281c7a11ULL, 0x000fe200078640ffULL, 0x000000ffff537224ULL, 0x000fe200028e06ffULL,
0x00005e001b1a7a11ULL, 0x000fe200078040ffULL, 0x0000001025257824ULL, 0x100fe200078e0279ULL,
0x0000000000297211ULL, 0x000fe200078fe8ffULL, 0x000000101f4d7824ULL, 0x100fe200078e0279ULL,
0x00005e0019187a11ULL, 0x000fe200078240ffULL, 0x00000010262d7824ULL, 0x000fe200078e0279ULL,
0x00005f00281d7a11ULL, 0x000fe200018f441dULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005f001b1b7a11ULL, 0x000fe200000f4422ULL, 0x00000010242f7824ULL, 0x100fe200078e0279ULL,
0x00005e0023227a11ULL, 0x000fe200078040ffULL, 0x000000100c4f7824ULL, 0x100fe200078e0279ULL,
0x00000007292b7812ULL, 0x000fe200078ec0ffULL, 0x000000100a517824ULL, 0x100fe200078e0279ULL,
0x00005f0019197a11ULL, 0x000fe200008f4420ULL, 0x0000001027277824ULL, 0x000fe200078e0279ULL,
0x00005e0021207a11ULL, 0x000fc400078240ffULL, 0x00005f0023237a11ULL, 0x000fe400000f4428ULL,
0x000000082a297812ULL, 0x000fe400078ee25dULL, 0x0ffffff82b287812ULL, 0x000fe400078ef800ULL,
0x00005f0021217a11ULL, 0x000fe200008f441eULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x00005e00781e7a11ULL, 0x000fc600078040ffULL, 0x00000010282b7824ULL, 0x000fe200078e0279ULL,
0x00005f00781f7a11ULL, 0x000fe200000f4453ULL, 0x0000001029107825ULL, 0x000fc600078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000122b7faeULL, 0x0003e2000b901c46ULL,
0x00000010291c7825ULL, 0x000fc600078e001cULL, 0x0000000010257faeULL, 0x0003e2000b901c46ULL,
0x00000010291a7825ULL, 0x000fc600078e001aULL, 0x000000001c2d7faeULL, 0x0003e2000b901c46ULL,
0x0000001029187825ULL, 0x000fc600078e0018ULL, 0x000000001a2f7faeULL, 0x0003e2000b901c46ULL,
0x0000001029227825ULL, 0x000fc600078e0022ULL, 0x00000000184d7faeULL, 0x0003e2000b901c46ULL,
0x0000001029207825ULL, 0x000fc600078e0020ULL, 0x00000000224f7faeULL, 0x0003e2000b901c46ULL,
0x00000010291e7825ULL, 0x000fc600078e001eULL, 0x0000000020517faeULL, 0x0003e8000b901c46ULL,
0x000000001e277faeULL, 0x0003e4000b901c46ULL, 0x00000001760c7824ULL, 0x000fe400078e0275ULL,
0x00000300ff0a7624ULL, 0x000fc600078e00ffULL, 0x000000010c107812ULL, 0x002fe400078ec0ffULL,
0xffffffff0a0a7811ULL, 0x000fe400078e08ffULL, 0x000000011000780cULL, 0x000fc80003f05070ULL,
0x000000010a117807ULL, 0x000fe20004000000ULL, 0xffffffffff0a7424ULL, 0x000fc800078e00ffULL,
0x000000010c0c7824ULL, 0x000fca00078e0211ULL, 0x0000000d0c00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000010c107824ULL, 0x000fe400078e0202ULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x00000006100a7981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6480074107f8cULL, 0x0022a4000c80043fULL,
0x0000000000187805ULL, 0x000fc40000015200ULL, 0xffffffe059747812ULL, 0x042fe400078ec0ffULL,
0x0000001059137812ULL, 0x040fe400078ec0ffULL, 0x0000000859127812ULL, 0x000fc800078ec0ffULL,
0x0000007412747210ULL, 0x000fca0007ffe013ULL, 0x01b64c0074137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012181b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e19ULL,
0x003d09001b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001b12127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b64c0074137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010063117810ULL, 0x000fca0007ffe061ULL,
0x0000000160117824ULL, 0x000fca00078e0211ULL, 0x01b0000011127984ULL, 0x000e680000000800ULL,
0x01b2000011187984ULL, 0x0004e20000000800ULL, 0x000000771200720bULL, 0x002fe20003f1d000ULL,
0x0000e3027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x004fc800000e0100ULL,
0x0000ffff13ff7812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff767224ULL, 0x000fd400078e0077ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x000000020e117811ULL, 0x000fe400078ff0ffULL,
0x000000771200720bULL, 0x000fe40003f34000ULL, 0x0000000e1100720cULL, 0x000fe20003f05270ULL,
0x0000e2c27f007947ULL, 0x000fd4000b800000ULL, 0x00000000001a7806ULL, 0x000fc400008e0100ULL,
0x000000800e118824ULL, 0x000fe200078e0263ULL, 0x0000001277108209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000160198824ULL, 0x000fe200078e0211ULL,
0x000099101a117816ULL, 0x000fc800000000ffULL, 0x01b4001019008388ULL, 0x0003e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000001277107209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff1aff7812ULL, 0x000fc6000780c0ffULL, 0x8000001077107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x00000010001e7308ULL, 0x000e640000000800ULL,
0x0000001e07077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x0000e1f27f007947ULL, 0x000fea000b800000ULL,
0x00001f101e107589ULL, 0x0002a400000e0000ULL, 0x0000001048487220ULL, 0x084fe40000410000ULL,
0x0000001049497220ULL, 0x080fe40000410000ULL, 0x0000001044447220ULL, 0x080fe40000410000ULL,
0x0000001045457220ULL, 0x000fc40000410000ULL, 0x0000001040407220ULL, 0x080fe40000410000ULL,
0x0000001041417220ULL, 0x080fe40000410000ULL, 0x000000103c3c7220ULL, 0x080fe40000410000ULL,
0x000000103d3d7220ULL, 0x080fe40000410000ULL, 0x0000001038387220ULL, 0x080fe40000410000ULL,
0x0000001039397220ULL, 0x000fc40000410000ULL, 0x0000001034347220ULL, 0x080fe40000410000ULL,
0x0000001035357220ULL, 0x080fe40000410000ULL, 0x0000001030307220ULL, 0x080fe40000410000ULL,
0x0000001031317220ULL, 0x080fe40000410000ULL, 0x0000001014147220ULL, 0x080fe40000410000ULL,
0x0000001015157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x000fe200078ff0ffULL, 0x0000e1027f007947ULL, 0x000fea000b800000ULL,
0x00001f101e107589ULL, 0x00046400000e0000ULL, 0x000000104a4a7220ULL, 0x082fe40000410000ULL,
0x000000104b4b7220ULL, 0x080fe40000410000ULL, 0x0000001046467220ULL, 0x080fe40000410000ULL,
0x0000001047477220ULL, 0x080fe40000410000ULL, 0x0000001042427220ULL, 0x080fe40000410000ULL,
0x0000001043437220ULL, 0x000fc40000410000ULL, 0x000000103e3e7220ULL, 0x080fe40000410000ULL,
0x000000103f3f7220ULL, 0x080fe40000410000ULL, 0x000000103a3a7220ULL, 0x080fe40000410000ULL,
0x000000103b3b7220ULL, 0x080fe40000410000ULL, 0x0000001036367220ULL, 0x080fe40000410000ULL,
0x0000001037377220ULL, 0x000fc40000410000ULL, 0x0000001032327220ULL, 0x080fe40000410000ULL,
0x0000001033337220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001017177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff1aff7812ULL, 0x000fe40007800813ULL, 0x0000001277767209ULL, 0x000fd60007810000ULL,
0x8000007612120221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL,
0x0000001200050308ULL, 0x000e640000000800ULL, 0x0000000518180220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000718077221ULL, 0x008fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000005ff03723eULL, 0x000fe400000010ffULL,
0x00000002ff137819ULL, 0x000fe40000011600ULL, 0x0000541003127816ULL, 0x000fe20000000003ULL,
0x0000df627f007947ULL, 0x000fea000b800000ULL, 0x00001f1312037589ULL, 0x0002e400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x0000dfb27f007947ULL, 0x000fea000b800000ULL,
0x00001f1012047589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200078e0012ULL,
0x00006b20001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000e7c000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x004fe200078e0012ULL, 0x00006b90001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000e75000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000100006107824ULL, 0x002fe200078e00ffULL,
0x00000001ff5b7819ULL, 0x000fe2000001160eULL, 0x012000005f28783bULL, 0x000e660000000200ULL,
0x0000100010197812ULL, 0x000fe200078ec0ffULL, 0x000000025b107824ULL, 0x000fc400078e025aULL,
0x000040005b6c7824ULL, 0x000fe400078e026cULL, 0x0000200010107824ULL, 0x000fc600078e0019ULL,
0x000130006c197810ULL, 0x000fe40007ffe019ULL, 0x0001300010107810ULL, 0x000fc60007ffe0ffULL,
0x000000106a247824ULL, 0x100fe400078e0219ULL, 0x0000001073547824ULL, 0x100fe400078e0210ULL,
0x0000001072507824ULL, 0x100fe400078e0210ULL, 0x00000010714c7824ULL, 0x100fe200078e0210ULL,
0x000000002424783bULL, 0x000fe20000004200ULL, 0x000000106f2c7824ULL, 0x000fe400078e0210ULL,
0x0000001069207824ULL, 0x100fe200078e0219ULL, 0x000000005454783bULL, 0x000ee20000004200ULL,
0x00000010681c7824ULL, 0x000fc400078e0219ULL, 0x0000001066197824ULL, 0x000fe200078e0219ULL,
0x000000005050783bULL, 0x000ea80000004200ULL, 0x000000004c4c783bULL, 0x000fe80000004200ULL,
0x000000002c2c783bULL, 0x000fe20000004200ULL, 0x0000000328280231ULL, 0x00afc400003400ffULL,
0x000000032a2a0231ULL, 0x080fe200003400ffULL, 0x012000005c10783bULL, 0x000e620000000200ULL,
0x0000000429290231ULL, 0x084fe400003400ffULL, 0x000000042b2b0231ULL, 0x000fe200003400ffULL,
0x000000002020783bULL, 0x000ea80000004200ULL, 0x000000001c1c783bULL, 0x000ee80000004200ULL,
0x000000001918783bULL, 0x000ea20000004200ULL, 0x000000542848723cULL, 0x040f700000041848ULL,
0x000000562844723cULL, 0x040f700000041844ULL, 0x000000502840723cULL, 0x000f620000041840ULL,
0x0000000310100231ULL, 0x002fc400003400ffULL, 0x0000000312120231ULL, 0x000fe400003400ffULL,
0x0000000411110231ULL, 0x080fe400003400ffULL, 0x0000000413130231ULL, 0x000fe200003400ffULL,
0x00000052283c723cULL, 0x040f70000004183cULL, 0x0000004c2838723cULL, 0x040f700000041838ULL,
0x0000004e2834723cULL, 0x040f700000041834ULL, 0x0000002c2830723cULL, 0x040f700000041830ULL,
0x0000002e2814723cULL, 0x000f700000041814ULL, 0x000000241048723cULL, 0x060b700000041848ULL,
0x000000261044723cULL, 0x040b700000041844ULL, 0x000000201040723cULL, 0x044b700000041840ULL,
0x00000022103c723cULL, 0x040b70000004183cULL, 0x0000001c1038723cULL, 0x048b700000041838ULL,
0x0000001e1034723cULL, 0x040b700000041834ULL, 0x000000181030723cULL, 0x040b700000041830ULL,
0x0000001a1014723cULL, 0x000b620000041814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000c058107811ULL, 0x020fe200078e40ffULL, 0x01b698005eff7f8cULL, 0x0003e2000c80043fULL,
0x00000001067a7812ULL, 0x000fe200078e0cffULL, 0x000000ffff777224ULL, 0x000fe200078e0076ULL,
0x0000000f1000720cULL, 0x000fda0003f06070ULL, 0x00001a9000000947ULL, 0x000fea0003800000ULL,
0x0000030058127a10ULL, 0x002fe20007ffe0ffULL, 0x000058000a117a24ULL, 0x010fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000112107810ULL, 0x040fe20007ffe0ffULL,
0x0000010012137824ULL, 0x000fc600078e0209ULL, 0x0000000b1000720cULL, 0x000fe20003f06070ULL,
0x0000008011107824ULL, 0x000fe200078e00ffULL, 0x0000006008117812ULL, 0x000fd600078ef813ULL,
0x0000077000008947ULL, 0x000fea0003800000ULL, 0x000000130f127217ULL, 0x000fe20007800000ULL,
0x000020000e187824ULL, 0x000fe200078e00ffULL, 0x00000003ff2b7819ULL, 0x000fe20000011600ULL,
0x000000085a1a7824ULL, 0x000fe400078e00ffULL, 0x0000000112127824ULL, 0x000fe200078e0a13ULL,
0x0000200018187812ULL, 0x000fe200078ec0ffULL, 0x0000100006137824ULL, 0x000fe200078e00ffULL,
0x000000042b1b7810ULL, 0x000fe40007ffe0ffULL, 0x0000002012267817ULL, 0x000fe20003800000ULL,
0x000040005b197824ULL, 0x000fe200078e0218ULL, 0x0000100013247812ULL, 0x000fe200078ec0ffULL,
0x000000012b137824ULL, 0x040fe200078e0211ULL, 0x000000082b1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000011b257824ULL, 0x000fe200078e0200ULL, 0x0001300019247810ULL, 0x000fe20007ffe024ULL,
0x000000081b187824ULL, 0x000fe200078e00ffULL, 0x0000001310137210ULL, 0x000fe20007f1e0ffULL,
0x000000011d277824ULL, 0x000fe200078e0200ULL, 0x000000111b197210ULL, 0x000fc40007ffe0ffULL,
0x000000102b297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005e0013227a11ULL, 0x000fe400078040ffULL, 0xfffffff818257812ULL, 0x000fe200078ee225ULL,
0x000000081d187824ULL, 0x000fe200078e00ffULL, 0x00005f0013237a11ULL, 0x000fe400000f4412ULL,
0x0000000c2b137810ULL, 0x000fe20007ffe0ffULL, 0x0000001025257824ULL, 0x000fe200078e0224ULL,
0x0000001910127210ULL, 0x000fe20007f1e0ffULL, 0x000000011d197824ULL, 0x100fe200078e0211ULL,
0x000000261b00720cULL, 0x080fe20003f46070ULL, 0x00000001131b7824ULL, 0x100fe200078e0211ULL,
0x000000261d00720cULL, 0x000fe20003f26070ULL, 0x000000ffff217224ULL, 0x000fe200000e06ffULL,
0x00005e0012207a11ULL, 0x000fe200078040ffULL, 0x00000001291d7824ULL, 0x000fe200078e0211ULL,
0x00000019101f7210ULL, 0x000fe20007f7e0ffULL, 0x00000001132c7824ULL, 0x040fe200078e0200ULL,
0x00005f0012217a11ULL, 0x000fe200000f4421ULL, 0x00000008132f7824ULL, 0x000fe200078e00ffULL,
0x0000001b101b7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x0000001d10127210ULL, 0x000fc40007fbe0ffULL, 0xfffffff818277812ULL, 0x000fe200078ee227ULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0x000000081a5d7812ULL, 0x000fe200078ee25dULL,
0x000000ffff197224ULL, 0x000fe200028e06ffULL, 0x00005e001b1c7a11ULL, 0x000fe200078640ffULL,
0x0000001027277824ULL, 0x000fe200078e0224ULL, 0x00005e00121a7a11ULL, 0x040fe200078840ffULL,
0x000000105d227825ULL, 0x000fe200078e0022ULL, 0x000000142b4d7810ULL, 0x000fe40007ffe0ffULL,
0x00005f001b1d7a11ULL, 0x000fe200018f4418ULL, 0x000000012b187824ULL, 0x000fe200078e0200ULL,
0x00005f00121b7a11ULL, 0x000fe200020f4419ULL, 0x000000014d197824ULL, 0x000fe200078e0211ULL,
0x00005e001f1e7a11ULL, 0x000fe200078040ffULL, 0x000000105d207825ULL, 0x000fe200078e0020ULL,
0x000000182b4f7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c2b517810ULL, 0x000fe20007ffe0ffULL,
0x000000105d1c7825ULL, 0x000fe200078e001cULL, 0x00005f001f1f7a11ULL, 0x000fe400000f4428ULL,
0x0000001910127210ULL, 0x000fe20007f1e0ffULL, 0x000000014f197824ULL, 0x100fe200078e0211ULL,
0x00000007182d7812ULL, 0x000fe200078ec0ffULL, 0x0000000151117824ULL, 0x000fe200078e0211ULL,
0x000000262b00720cULL, 0x000fe20003f66070ULL, 0x000000ffff2b7224ULL, 0x000fe200000e06ffULL,
0x00005e0012187a11ULL, 0x000fe200078040ffULL, 0x000000105d1e7825ULL, 0x000fe200078e001eULL,
0x00000019102a7210ULL, 0x000fc40007f9e0ffULL, 0x0000001110117210ULL, 0x000fe20007fbe0ffULL,
0x000000105d1a7825ULL, 0x000fe200078e001aULL, 0x0ffffff82d2d7812ULL, 0x000fe400078ef800ULL,
0x00005f0012197a11ULL, 0x000fe200000f442bULL, 0x000000ffff2b7224ULL, 0x000fe200020e06ffULL,
0x00005e002a127a11ULL, 0x040fe200078840ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0224ULL,
0x000000261300720cULL, 0x080fe20003f06070ULL, 0x000000ffff287224ULL, 0x000fe200028e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078a40ffULL, 0x000000105d187825ULL, 0x000fe200078e0018ULL,
0x00005f002a137a11ULL, 0x000fe200020f442bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000222d7faeULL, 0x0003e2000d901c46ULL, 0x00005f0011117a11ULL, 0x000fe200028f4428ULL,
0x000000014d287824ULL, 0x100fe200078e0200ULL, 0x000000262900720cULL, 0x080fe20003f66070ULL,
0x000000014f2a7824ULL, 0x100fe200078e0200ULL, 0x000000264d00720cULL, 0x0c0fe20003f86070ULL,
0x000000084d4d7824ULL, 0x000fe200078e00ffULL, 0x000000264f00720cULL, 0x0c0fe20003fa6070ULL,
0x000000084f2b7824ULL, 0x000fe200078e00ffULL, 0x000000265100720cULL, 0x000fe20003fc6070ULL,
0x0000000129267824ULL, 0x000fe200078e0200ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee22cULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee22aULL,
0x0000000151227824ULL, 0x042fe200078e0200ULL, 0x0000000020257faeULL, 0x0003e2000d101c46ULL,
0x00000008512d7824ULL, 0x000fe200078e00ffULL, 0xfffffff829237812ULL, 0x000fe200078ee226ULL,
0x000000102f2f7824ULL, 0x000fe200078e0224ULL, 0xfffffff84d297812ULL, 0x000fe200078ee228ULL,
0x000000102b2b7824ULL, 0x000fe200078e0224ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee222ULL,
0x0000001023237824ULL, 0x100fe200078e0224ULL, 0x000000001e277faeULL, 0x0003e2000c901c46ULL,
0x0000001029297824ULL, 0x000fc400078e0224ULL, 0x000000105d127825ULL, 0x000fe200078e0012ULL,
0x000000001c2f7faeULL, 0x0003e6000c101c46ULL, 0x000000102d2d7824ULL, 0x000fe200078e0224ULL,
0x000000001a237faeULL, 0x0003e2000d901c46ULL, 0x000000105d107825ULL, 0x000fc600078e0010ULL,
0x0000000018297faeULL, 0x0003e8000e101c46ULL, 0x00000000122b7faeULL, 0x0003e8000e901c46ULL,
0x00000000102d7faeULL, 0x0003e2000f101c46ULL, 0x000006a000007947ULL, 0x000fea0003800000ULL,
0x0000000400187811ULL, 0x000fe200078fe8ffULL, 0x000000085a127824ULL, 0x000fe200078e00ffULL,
0x0000000c001b7811ULL, 0x000fe200078fe8ffULL, 0x000020000e227824ULL, 0x000fe200078e00ffULL,
0x0000000800197811ULL, 0x000fe200078fe8ffULL, 0x0000000118287824ULL, 0x100fe200078e0200ULL,
0x0000001800237811ULL, 0x000fe200078fe8ffULL, 0x0000000818137824ULL, 0x000fe200078e00ffULL,
0x00000008125d7812ULL, 0x000fe200078ee25dULL, 0x000000011b267824ULL, 0x040fe200078e0200ULL,
0x0000001400217811ULL, 0x040fe200078fe8ffULL, 0x000000081b1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff813287812ULL, 0x000fe200078ee228ULL, 0x0000000119277824ULL, 0x040fe200078e0200ULL,
0x0000001100137211ULL, 0x000fe200078fe8ffULL, 0x00000008191a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d267812ULL, 0x000fe200078ee226ULL, 0x0000000123247824ULL, 0x140fe200078e0200ULL,
0x0000001310137210ULL, 0x000fe20007f1e0ffULL, 0x00000008231f7824ULL, 0x000fe200078e00ffULL,
0x00000010001d7811ULL, 0x000fe200078fe8ffULL, 0x0000000121257824ULL, 0x100fe200078e0200ULL,
0xfffffff81a277812ULL, 0x000fe200078ee227ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005e00131e7a11ULL, 0x000fe200078040ffULL, 0x000000011d297824ULL, 0x000fe200078e0200ULL,
0xfffffff81f247812ULL, 0x000fe200078ee224ULL, 0x000000081d1a7824ULL, 0x000fe200078e00ffULL,
0x00005f00131f7a11ULL, 0x000fe200000f4412ULL, 0x0000000118137824ULL, 0x000fe200078e0211ULL,
0x0000001c002a7811ULL, 0x000fe200078fe8ffULL, 0x00000008211c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a297812ULL, 0x000fe200078ee229ULL, 0x000000011b1b7824ULL, 0x100fe200078e0211ULL,
0x00000013101a7210ULL, 0x000fe20007f7e0ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0211ULL,
0xfffffff81c257812ULL, 0x000fe200078ee225ULL, 0x0000000119197824ULL, 0x100fe200078e0211ULL,
0x0000200022227812ULL, 0x000fe200078ec0ffULL, 0x0000000121217824ULL, 0x100fe200078e0211ULL,
0x0000001b10127210ULL, 0x040fe20007f1e0ffULL, 0x0000000123237824ULL, 0x100fe200078e0211ULL,
0x0000001d101b7210ULL, 0x000fe20007f5e0ffULL, 0x000000012a117824ULL, 0x000fe200078e0211ULL,
0x0000001910187210ULL, 0x000fe20007f3e0ffULL, 0x00001000061c7824ULL, 0x000fe200078e00ffULL,
0x0000002110197210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x0000002310137210ULL, 0x040fe20007fbe0ffULL, 0x000040005b2b7824ULL, 0x000fe200078e0222ULL,
0x0000001110117210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff237224ULL, 0x000fe200008e06ffULL,
0x00005e001a207a11ULL, 0x000fe200078c40ffULL, 0x000000082a4f7824ULL, 0x000fe200078e00ffULL,
0x000010001c107812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005f001a217a11ULL, 0x000fe200030f441dULL, 0x000000012a1a7824ULL, 0x000fe200078e0200ULL,
0x000130002b2e7810ULL, 0x000fe20007ffe010ULL, 0x000000ffff1d7224ULL, 0x000fe200000e06ffULL,
0x00005e0018227a11ULL, 0x000fe200078240ffULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x00000000002b7211ULL, 0x000fe200078fe8ffULL, 0x000000ffff107224ULL, 0x000fe200028e06ffULL,
0x00005e00121c7a11ULL, 0x000fe200078040ffULL, 0x000000105d1e7825ULL, 0x000fe200078e001eULL,
0x00005f0018237a11ULL, 0x000fc400008f4423ULL, 0x000000072b2b7812ULL, 0x000fe200078ec0ffULL,
0x00000010282d7824ULL, 0x000fe200078e022eULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee21aULL,
0x000000105d207825ULL, 0x000fe200078e0020ULL, 0x00005f00121d7a11ULL, 0x000fe400000f441dULL,
0x00005e0019187a11ULL, 0x000fe200078240ffULL, 0x0000001027277824ULL, 0x000fe200078e022eULL,
0x00005e001b1a7a11ULL, 0x000fe200078040ffULL, 0x000000105d227825ULL, 0x000fe200078e0022ULL,
0x00005e0013127a11ULL, 0x000fc400078440ffULL, 0x0ffffff82b2b7812ULL, 0x000fe200078ef800ULL,
0x00000010262f7824ULL, 0x000fe200078e022eULL, 0x00005f0019197a11ULL, 0x000fe200008f442aULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x00005f001b1b7a11ULL, 0x000fe200000f442cULL,
0x000000102b2b7824ULL, 0x000fe200078e022eULL, 0x00005f0013137a11ULL, 0x000fe200010f4410ULL,
0x000000105d1c7825ULL, 0x000fe200078e001cULL, 0x00005e0011107a11ULL, 0x000fe400078040ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e2b7faeULL, 0x0003e2000b901c46ULL,
0x0000001029297824ULL, 0x000fe200078e022eULL, 0x00005f0011117a11ULL, 0x000fe200000f442aULL,
0x000000105d1a7825ULL, 0x000fe200078e001aULL, 0x00000000202d7faeULL, 0x0003e6000b901c46ULL,
0x0000001025257824ULL, 0x000fe200078e022eULL, 0x0000000022277faeULL, 0x0003e2000b901c46ULL,
0x000000105d187825ULL, 0x000fc600078e0018ULL, 0x000000001c2f7faeULL, 0x0003e2000b901c46ULL,
0x00000010244d7824ULL, 0x000fe400078e022eULL, 0x000000105d127825ULL, 0x000fe200078e0012ULL,
0x000000001a297faeULL, 0x0003e6000b901c46ULL, 0x000000104f4f7824ULL, 0x000fe200078e022eULL,
0x0000000018257faeULL, 0x0003e2000b901c46ULL, 0x000000105d107825ULL, 0x000fc600078e0010ULL,
0x00000000124d7faeULL, 0x0003e8000b901c46ULL, 0x00000000104f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6680074127f8cULL, 0x0022a4000c80043fULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x01b66c0074197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x00cfe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018101b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e11ULL, 0x003d09001b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011419ULL,
0x0000001b18187211ULL, 0x000fca00078110ffULL, 0x000000ffff197224ULL, 0x000fca00000e0619ULL,
0x0000000218187819ULL, 0x000fc80000001219ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b66c0074197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018063617810ULL, 0x000fca0007ffe061ULL, 0x0000000160617824ULL, 0x000fca00078e0261ULL,
0x01b0000061137984ULL, 0x000ea80000000800ULL, 0x01b2000061127984ULL, 0x0006620000000800ULL,
0x000000761300720bULL, 0x004fe20003f1d000ULL, 0x0000c9a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x008fc800000e0100ULL, 0x0000ffff18ff7812ULL, 0x000fe2000782c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff777224ULL, 0x000fd400078e0076ULL, 0x0000043000009947ULL, 0x000fea0003800000ULL,
0x000000030e117811ULL, 0x000fe400078ff0ffULL, 0x000000761300720bULL, 0x000fe40003f34000ULL,
0x0000000e1100720cULL, 0x000fe20003f05270ULL, 0x0000c9627f007947ULL, 0x000fd4000b800000ULL,
0x0000000000197806ULL, 0x000fc400008e0100ULL, 0x000000800e638824ULL, 0x000fe200078e0263ULL,
0x0000007613777209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991019107816ULL, 0x000fe200000000ffULL, 0x0000000160608824ULL, 0x000fca00078e0263ULL,
0x01b4007760008388ULL, 0x0005e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000007677107221ULL, 0x004fe20000010100ULL,
0x000000ff19ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x00000010001a7308ULL, 0x000ea40000000800ULL,
0x0000001a07077220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x0000c8927f007947ULL, 0x000fea000b800000ULL,
0x00001f101a107589ULL, 0x0004e400000e0000ULL, 0x0000001048487220ULL, 0x088fe40000410000ULL,
0x0000001049497220ULL, 0x080fe40000410000ULL, 0x0000001044447220ULL, 0x080fe40000410000ULL,
0x0000001045457220ULL, 0x080fe40000410000ULL, 0x0000001040407220ULL, 0x080fe40000410000ULL,
0x0000001041417220ULL, 0x000fc40000410000ULL, 0x000000103c3c7220ULL, 0x080fe40000410000ULL,
0x000000103d3d7220ULL, 0x080fe40000410000ULL, 0x0000001038387220ULL, 0x080fe40000410000ULL,
0x0000001039397220ULL, 0x080fe40000410000ULL, 0x0000001034347220ULL, 0x080fe40000410000ULL,
0x0000001035357220ULL, 0x000fc40000410000ULL, 0x0000001030307220ULL, 0x080fe40000410000ULL,
0x0000001031317220ULL, 0x080fe40000410000ULL, 0x0000001014147220ULL, 0x080fe40000410000ULL,
0x0000001015157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0019ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x000fe200078ff0ffULL, 0x0000c7a27f007947ULL, 0x000fea000b800000ULL,
0x00001f101a107589ULL, 0x0006a400000e0000ULL, 0x000000104a4a7220ULL, 0x084fe40000410000ULL,
0x000000104b4b7220ULL, 0x080fe40000410000ULL, 0x0000001046467220ULL, 0x080fe40000410000ULL,
0x0000001047477220ULL, 0x080fe40000410000ULL, 0x0000001042427220ULL, 0x080fe40000410000ULL,
0x0000001043437220ULL, 0x000fc40000410000ULL, 0x000000103e3e7220ULL, 0x080fe40000410000ULL,
0x000000103f3f7220ULL, 0x080fe40000410000ULL, 0x000000103a3a7220ULL, 0x080fe40000410000ULL,
0x000000103b3b7220ULL, 0x080fe40000410000ULL, 0x0000001036367220ULL, 0x080fe40000410000ULL,
0x0000001037377220ULL, 0x000fc40000410000ULL, 0x0000001032327220ULL, 0x080fe40000410000ULL,
0x0000001033337220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001017177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff19ff7812ULL, 0x000fda0007800818ULL, 0x0000001377130221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL, 0x0000001300050308ULL, 0x000ea40000000800ULL,
0x0000000512120220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000712077221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff03723eULL, 0x000fe400000010ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x0000541003127816ULL, 0x000fe20000000003ULL, 0x0000c6127f007947ULL, 0x000fea000b800000ULL,
0x00001f1312037589ULL, 0x0002a400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x0000c6627f007947ULL, 0x000fea000b800000ULL, 0x00001f1012047589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200078e0012ULL, 0x000086f0001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000cbf000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x004fe200078e0012ULL,
0x00008760001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000cb8000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x012800005f28783bULL, 0x000f280000000200ULL, 0x000000007054783bULL, 0x000e680000004200ULL,
0x000000006e50783bULL, 0x000fe80000004200ULL, 0x000000006d4c783bULL, 0x000fe80000004200ULL,
0x000000006b2c783bULL, 0x000fe80000004200ULL, 0x012800005c10783bULL, 0x002e680000000200ULL,
0x000000006724783bULL, 0x000ee80000004200ULL, 0x000000006520783bULL, 0x000ea80000004200ULL,
0x00000000641c783bULL, 0x000ea80000004200ULL, 0x000000006218783bULL, 0x00cea20000004200ULL,
0x0000000328280231ULL, 0x010fc400003400ffULL, 0x000000032a2a0231ULL, 0x000fe400003400ffULL,
0x0000000429290231ULL, 0x080fe400003400ffULL, 0x000000042b2b0231ULL, 0x000fce00003400ffULL,
0x000000542848723cULL, 0x000f620000041848ULL, 0x0000000310100231ULL, 0x002fce00003400ffULL,
0x000000562844723cULL, 0x000f620000041844ULL, 0x0000000312120231ULL, 0x000fe400003400ffULL,
0x0000000411110231ULL, 0x080fe400003400ffULL, 0x0000000413130231ULL, 0x000fc600003400ffULL,
0x000000502840723cULL, 0x040f700000041840ULL, 0x00000052283c723cULL, 0x040f70000004183cULL,
0x0000004c2838723cULL, 0x040f700000041838ULL, 0x0000004e2834723cULL, 0x040f700000041834ULL,
0x0000002c2830723cULL, 0x040f700000041830ULL, 0x0000002e2814723cULL, 0x000f700000041814ULL,
0x000000241048723cULL, 0x060b700000041848ULL, 0x000000261044723cULL, 0x040b700000041844ULL,
0x000000201040723cULL, 0x040b700000041840ULL, 0x00000022103c723cULL, 0x040b70000004183cULL,
0x0000001c1038723cULL, 0x040b700000041838ULL, 0x0000001e1034723cULL, 0x040b700000041834ULL,
0x000000181030723cULL, 0x044b700000041830ULL, 0x0000001a1014723cULL, 0x000b620000041814ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01b6a0005eff7f8cULL, 0x0003e2000c80043fULL,
0x00000001067a7812ULL, 0x000fce00078ec0ffULL, 0x0000030058587a10ULL, 0x002fc80007ffe0ffULL,
0x0000000b5800720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff8bf000007947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000e620000002500ULL,
0x000000ffff187224ULL, 0x020fe400078e0017ULL, 0x000000ffff197224ULL, 0x000fe200078e0016ULL,
0x0000000b0200720cULL, 0x002fda0003f06070ULL, 0x0000033000000947ULL, 0x000fea0003800000ULL,
0x0180000007007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x00008b10000a7802ULL, 0x010fc40000000f00ULL,
0x0000c62000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000e640000001000ULL, 0xbf80000000037423ULL, 0x002fc80000000007ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e680000000000ULL,
0x0000000000047919ULL, 0x000ee20000000000ULL, 0x00000002ff037819ULL, 0x002fe40000011603ULL,
0x0000000804057811ULL, 0x008fc800078ff0ffULL, 0x00001f0300037589ULL, 0x004e6800000e0000ULL,
0x00001f0500047589ULL, 0x000ea200000e0000ULL, 0x0000004803487220ULL, 0x042fe40000410000ULL,
0x0000004903497220ULL, 0x040fe40000410000ULL, 0x0000004403447220ULL, 0x040fe40000410000ULL,
0x0000004503457220ULL, 0x000fc40000410000ULL, 0x0000004003407220ULL, 0x040fe40000410000ULL,
0x0000004103417220ULL, 0x040fe40000410000ULL, 0x0000003c033c7220ULL, 0x040fe40000410000ULL,
0x0000003d033d7220ULL, 0x040fe40000410000ULL, 0x0000003803387220ULL, 0x040fe40000410000ULL,
0x0000003903397220ULL, 0x000fc40000410000ULL, 0x0000003403347220ULL, 0x040fe40000410000ULL,
0x0000003503357220ULL, 0x040fe40000410000ULL, 0x0000003003307220ULL, 0x040fe40000410000ULL,
0x0000003103317220ULL, 0x040fe40000410000ULL, 0x0000001403147220ULL, 0x040fe40000410000ULL,
0x0000001503157220ULL, 0x000fc40000410000ULL, 0x0000004a044a7220ULL, 0x044fe40000410000ULL,
0x0000004b044b7220ULL, 0x040fe40000410000ULL, 0x0000004604467220ULL, 0x040fe40000410000ULL,
0x0000004704477220ULL, 0x040fe40000410000ULL, 0x0000004204427220ULL, 0x040fe40000410000ULL,
0x0000004304437220ULL, 0x000fc40000410000ULL, 0x0000003e043e7220ULL, 0x040fe40000410000ULL,
0x0000003f043f7220ULL, 0x040fe40000410000ULL, 0x0000003a043a7220ULL, 0x040fe40000410000ULL,
0x0000003b043b7220ULL, 0x040fe40000410000ULL, 0x0000003604367220ULL, 0x040fe40000410000ULL,
0x0000003704377220ULL, 0x000fc40000410000ULL, 0x0000003204327220ULL, 0x040fe40000410000ULL,
0x0000003304337220ULL, 0x040fe40000410000ULL, 0x0000001904197220ULL, 0x040fe40000410000ULL,
0x0000001804187220ULL, 0x000fc80000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000191818723eULL, 0x000fe400000010ffULL, 0x000000484903723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000444506723eULL, 0x000fc400000010ffULL,
0x000000404108723eULL, 0x000fe400000010ffULL, 0x0000003c3d0a723eULL, 0x010fe400000010ffULL,
0x00000038390c723eULL, 0x000fe400000010ffULL, 0x00000034350d723eULL, 0x000fe400000010ffULL,
0x00000030310f723eULL, 0x000fe400000010ffULL, 0x000000141510723eULL, 0x000fc400000010ffULL,
0x00000002ff1d7819ULL, 0x002fe40000011600ULL, 0x00000008002a7811ULL, 0x000fe400078ff0ffULL,
0x000000011d047810ULL, 0x040fe20007ffe0ffULL, 0x000000081d0b7824ULL, 0x040fe200078e00ffULL,
0x000000021d057810ULL, 0x040fe20007ffe0ffULL, 0x000000081d1e7824ULL, 0x040fe200078e00ffULL,
0x000000061d197810ULL, 0x040fe20007ffe0ffULL, 0x000000081d1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b1c7812ULL, 0x000fe200078ee204ULL, 0x000000081d247824ULL, 0x040fe200078e00ffULL,
0x000000031d047810ULL, 0x040fe20007ffe0ffULL, 0x000000081d267824ULL, 0x040fe200078e00ffULL,
0x000000051d0b7810ULL, 0x040fe20007ffe0ffULL, 0x000000081d227824ULL, 0x040fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee205ULL, 0x000000081d1a7824ULL, 0x040fe200078e00ffULL,
0x000000041d057810ULL, 0x040fe20007ffe0ffULL, 0x000000081d287824ULL, 0x000fe200078e00ffULL,
0xfffffff81b207812ULL, 0x000fe200078ee204ULL, 0x000010005a047824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20bULL, 0x000008005b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee219ULL, 0x0000000400197824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee205ULL, 0x0000000104057824ULL, 0x000fe200078e020bULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee21dULL, 0x000000082a1f7824ULL, 0x000fe200078e00ffULL,
0xffffffff1d1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000101c1c7824ULL, 0x100fe200078e0205ULL,
0x0000000c19197812ULL, 0x000fe200078ec0ffULL, 0x000000101a1a7824ULL, 0x000fe200078e0205ULL,
0xfffffff828287812ULL, 0x000fe200078ee21bULL, 0x000000101e1e7824ULL, 0x100fe200078e0205ULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee22aULL, 0x0000001020207824ULL, 0x100fe200078e0205ULL,
0x0000004a4b11723eULL, 0x000fe200000010ffULL, 0x0000001022227824ULL, 0x000fe200078e0205ULL,
0x000000464712723eULL, 0x000fe200000010ffULL, 0x000000011a1a7824ULL, 0x000fe200078e0219ULL,
0x000000424313723eULL, 0x000fe200000010ffULL, 0x0000001024247824ULL, 0x100fe200078e0205ULL,
0x0000003e3f14723eULL, 0x000fe200000010ffULL, 0x00000001191b7824ULL, 0x000fe200078e021cULL,
0x000000031a007388ULL, 0x0003e20000000800ULL, 0x0000001026267824ULL, 0x100fe200078e0205ULL,
0x0000003a3b15723eULL, 0x000fe200000010ffULL, 0x00000001191e7824ULL, 0x000fe200078e021eULL,
0x000000061b007388ULL, 0x000fe20000000800ULL, 0x0000001028287824ULL, 0x100fe200078e0205ULL,
0x000000363716723eULL, 0x000fe200000010ffULL, 0x00000001191d7824ULL, 0x000fe200078e0220ULL,
0x000000081e007388ULL, 0x0005e20000000800ULL, 0x000000102a2a7824ULL, 0x000fe200078e0205ULL,
0x000000323317723eULL, 0x000fe200000010ffULL, 0x0000000119227824ULL, 0x040fe200078e0222ULL,
0x0000000a1d007388ULL, 0x0007e20000000800ULL, 0x0000000119247824ULL, 0x040fe200078e0224ULL,
0x000000ff00037306ULL, 0x002fe20000205400ULL, 0x0000000119267824ULL, 0x040fe200078e0226ULL,
0x0000000c22007388ULL, 0x000fe20000000800ULL, 0x00000001191f7824ULL, 0x000fc400078e0228ULL,
0x00000001192a7824ULL, 0x000fe200078e022aULL, 0x0000000d24007388ULL, 0x000fe20000000800ULL,
0x0000000109197824ULL, 0x000fe200078e0200ULL, 0x000000ff00087306ULL, 0x004e620000209400ULL,
0x00000300ff1a7624ULL, 0x000fe200078e00ffULL, 0x0000000f26007388ULL, 0x000fe20000000800ULL,
0x00000010190a7824ULL, 0x008fc600078e0204ULL, 0x000000101f007388ULL, 0x000fe40000000800ULL,
0x000000ff00067306ULL, 0x000ea4000020d400ULL, 0x000000112a007388ULL, 0x000fe80000000800ULL,
0x000400121b007388ULL, 0x000fe20000000800ULL, 0x000000030800720bULL, 0x002fc60003f1d000ULL,
0x000400131e007388ULL, 0x000fe80000000800ULL, 0x000400141d007388ULL, 0x0003e80000000800ULL,
0x0004001522007388ULL, 0x000fe40000000800ULL, 0x0000000106060812ULL, 0x004fc400078efcffULL,
0x0004001624007388ULL, 0x000fe20000000800ULL, 0x000000011a00780cULL, 0x000fe40003f05270ULL,
0x000000060614723eULL, 0x002fe200000010ffULL, 0x0004001726007388ULL, 0x000fe80000000800ULL,
0x000400181f007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000a287984ULL, 0x000e680000000c00ULL, 0x000400000a207984ULL, 0x000ea80000000c00ULL,
0x000800000a107984ULL, 0x000ee80000000c00ULL, 0x000c00000a2c7984ULL, 0x000ee20000000c00ULL,
0x3f803f80142b7831ULL, 0x002fc4000020002bULL, 0x3f803f80142a7831ULL, 0x040fe4000020002aULL,
0x3f803f8014297831ULL, 0x040fe40000200029ULL, 0x3f803f8014287831ULL, 0x040fe40000200028ULL,
0x3f803f8014237831ULL, 0x044fe40000200023ULL, 0x3f803f8014227831ULL, 0x040fe40000200022ULL,
0x3f803f8014217831ULL, 0x000fc40000200021ULL, 0x3f803f8014207831ULL, 0x000fe40000200020ULL,
0x3f803f802b2b7831ULL, 0x008fe40000200013ULL, 0x3f803f802a2a7831ULL, 0x000fe40000200012ULL,
0x3f803f8029297831ULL, 0x000fe40000200011ULL, 0x3f803f8028287831ULL, 0x000fe40000200010ULL,
0x3f803f8023237831ULL, 0x000fc4000020002fULL, 0x3f803f8022227831ULL, 0x000fe2000020002eULL,
0x000000280a007388ULL, 0x000fe20000000c00ULL, 0x3f803f8021217831ULL, 0x000fe4000020002dULL,
0x3f803f8020207831ULL, 0x000fca000020002cULL, 0x000400200a007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a2000008947ULL, 0x000fea0003800000ULL,
0x00005800ff037624ULL, 0x000fe200078e00ffULL, 0x00000000000f7919ULL, 0x000e660000002700ULL,
0x0000660003037a24ULL, 0x000fe200078e02ffULL, 0x0000000000087919ULL, 0x000e680000002600ULL,
0x0000000f030d7811ULL, 0x040fe200078e10ffULL, 0x0000030003037a24ULL, 0x000fe200078e02ffULL,
0x000000000a107984ULL, 0x0004e40000000c00ULL, 0xfffffff00d0d7812ULL, 0x000fca00078ec0ffULL,
0x00000080030c7824ULL, 0x000fc800078e020dULL, 0x0000008003037824ULL, 0x000fca00078e020cULL,
0x0000007f03037810ULL, 0x000fe20007ffe0ffULL, 0x000058000f0f7a24ULL, 0x002fc600078e0208ULL,
0xffffff8003037812ULL, 0x000fe200078ec0ffULL, 0x000003000f087a24ULL, 0x000fc600078e02ffULL,
0x00006a0003157a10ULL, 0x000fe20007f1e0ffULL, 0x0000000108027824ULL, 0x000fca00078e0202ULL,
0x0000001502147211ULL, 0x000fe200078258ffULL, 0x00006b00ff157624ULL, 0x000fe200000e06ffULL,
0x000000015bff7812ULL, 0x000fc8000780f80eULL, 0x0000001502157211ULL, 0x000fe400008f5cffULL,
0x00006a000d0a7a10ULL, 0x004fc60007f3e0ffULL, 0x000004005a147825ULL, 0x000fc800078e0014ULL,
0x00006b00ff1b7624ULL, 0x000fe400008e06ffULL, 0x0000001019147825ULL, 0x000fe200078e0014ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x0000001000167824ULL, 0x008fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe20000011600ULL, 0x0000008002177824ULL, 0x000fe200078e00ffULL,
0x00000019ff027819ULL, 0x000fe40000011602ULL, 0x0000007016197812ULL, 0x000fe400078ec0ffULL,
0x0000000c18167812ULL, 0x000fc400078ec0ffULL, 0x00006a0017187a10ULL, 0x000fe40007ebe00cULL,
0x0000000a19177210ULL, 0x000fe40007a3e017ULL, 0x0000001816187210ULL, 0x000fe40007c7e019ULL,
0x00006b0002197a10ULL, 0x000fe40002fec4ffULL, 0x0000001716167210ULL, 0x000fe40007fbe0ffULL,
0x0000001bff027210ULL, 0x000fc40000fe4402ULL, 0x00000019ff197210ULL, 0x000fc60001fe84ffULL,
0x000000ffff177224ULL, 0x000fca00028e0602ULL, 0x0000007716007986ULL, 0x0003e8000c101906ULL,
0x0000000718007986ULL, 0x0003e4000c101906ULL, 0x000000ff0000720cULL, 0x008fe20000705670ULL,
0x0000001014007986ULL, 0x000fe2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000ff00000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff107424ULL, 0x000fe200078e00ffULL, 0xffffffff1a077810ULL, 0x002fc60007ffe0ffULL,
0x00006a000f107625ULL, 0x000fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000007101079a8ULL, 0x000ea400099ee1c6ULL, 0x000000071000720cULL, 0x004fc80003f05270ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000002ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x002e640000000000ULL,
0x000000ff0200720cULL, 0x002fda0003f05270ULL, 0x000025e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fe40000011600ULL,
0x0000000a080e7211ULL, 0x000fe400078038ffULL, 0x00000070020f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fe400078ec0ffULL, 0x0000001b08027211ULL, 0x000fe400000f3cffULL,
0x0000000e070e7210ULL, 0x000fc8000791e00fULL, 0x00000002ff0f7210ULL, 0x000fca00007e24ffULL,
0x000000060e027981ULL, 0x000328000c1e1900ULL, 0x000080060e077981ULL, 0x000322000c1e1900ULL,
0x000000021a00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x000100060e117981ULL, 0x002322000c1e1900ULL, 0x000000041a00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x000180060e137981ULL, 0x002322000c1e1900ULL,
0x000000041a00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x000200060e157981ULL, 0x002322000c1e1900ULL, 0x000000061a00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x000280060e177981ULL, 0x002322000c1e1900ULL,
0x000000061a00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081a00780cULL, 0x002fe20003f06070ULL, 0x000300060e197981ULL, 0x000318000c1e1900ULL,
0x000380060e1b0981ULL, 0x000324000c1e1900ULL, 0x000000071a0a7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x000fc8000001160aULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000d081f7211ULL, 0x040fe200078038ffULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1d7224ULL, 0x010fe200078e0002ULL, 0x00006a001f1f7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff08107211ULL, 0x000fe400000f3cffULL, 0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL,
0x00006b00ff107a10ULL, 0x000fc400017e2410ULL, 0x0000030012007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x000000040a007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x00000008120e7810ULL, 0x040fe40007ffe0ffULL,
0x00000001120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001d02027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011600ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e0610ULL, 0xfffc80060e1d7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x00000009120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000002120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000000702027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000077824ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fc80000011600ULL, 0x0000007007077812ULL, 0x000fc800078ec0ffULL,
0x0000000c070e7812ULL, 0x000fc800078ef80eULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e0610ULL, 0xfffd00060e077981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000003120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001102027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011600ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e0610ULL, 0xfffd80060e117981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000004120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001302027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011600ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e0610ULL, 0xfffe00060e137981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000005120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001502027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011600ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e0610ULL, 0xfffe80060e157981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000006120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001702027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011600ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e0610ULL, 0xffff00060e177981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000007120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001902027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011600ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e0610ULL, 0xffff80060e197981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f120e7810ULL, 0x002fe40007ffe0ffULL,
0x0000001b02027209ULL, 0x000fe40007810000ULL, 0x000003000e007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011600ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e0610ULL, 0x000000060e1b7981ULL, 0x000326000c1e1900ULL,
0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL, 0x0000000812127810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200008e0610ULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000077824ULL, 0x014fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fc80000011600ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fca00078ec0ffULL, 0x0000000107077824ULL, 0x000fca00078e020aULL,
0x0000000207007388ULL, 0x0005e40000000800ULL, 0x00006a0003027a10ULL, 0x004fe20007f3e0ffULL,
0x000000015b117824ULL, 0x040fe200078e0208ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00006b00ff037624ULL, 0x000fe200008e06ffULL, 0x000000015b0a7812ULL, 0x000fe200078ec0ffULL,
0x000004005a077824ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x000fe200078ec0ffULL,
0x00000800110e7825ULL, 0x002fe200078e0002ULL, 0x0000000c12137812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000070e0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000110107824ULL, 0x000fe200078e0213ULL, 0x000008000b137812ULL, 0x000fe200078ec0ffULL,
0x000000025b198824ULL, 0x140fe200078e025aULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x00006a000c0b7a10ULL, 0x000fe20007f3e0ffULL,
0x000000025b158824ULL, 0x000fe200078e025aULL, 0x00006a000d0c7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000219198824ULL, 0x100fe200078e020aULL, 0x00000000102f7984ULL, 0x0002a20000000800ULL,
0x00000002151d8824ULL, 0x000fe200078e020aULL, 0x0000002000157810ULL, 0x000fe20007ffe0ffULL,
0x00006b00ff0d7624ULL, 0x000fe200008e06ffULL, 0x0000000b11168211ULL, 0x000fe200078238ffULL,
0x000020005b0a7824ULL, 0x000fe200078e0204ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00006b00ff2e7624ULL, 0x000fe200010e06ffULL, 0x0000000c111a8211ULL, 0x040fe200078438ffULL,
0x000000010a137824ULL, 0x000fe200078e0213ULL, 0x0000000d11178211ULL, 0x000fe200008f3cffULL,
0x0000000819198824ULL, 0x100fe200078e0200ULL, 0x000003005b007a0cULL, 0x000fe20003f26070ULL,
0x000000081d1d8824ULL, 0x000fe200078e0200ULL, 0x0000002e111b8211ULL, 0x000fe200010f3cffULL,
0x0000001015147825ULL, 0x000fe200078e000eULL, 0x0000458019198811ULL, 0x000fe200078e20ffULL,
0x0000000000107805ULL, 0x002fe2000001ff00ULL, 0x000041801d1f8811ULL, 0x000fe200078e20ffULL,
0x0000001000137824ULL, 0x040fe200078e0213ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000010000e7825ULL, 0x040fe200078e000eULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000001000168825ULL, 0x040fe200078e0016ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e137faeULL, 0x0003e2000b901c46ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000010001a8825ULL, 0x000fe200078e001aULL,
0x0038000014137faeULL, 0x0007e6000b901c46ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x0000000016198faeULL, 0x0009e8000b901c46ULL, 0x000000001a1f8faeULL, 0x0005e2000b901c46ULL,
0x00000000000e7805ULL, 0x002fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000127805ULL, 0x008fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x010fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x004fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000c0000001947ULL, 0x000fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fe400078e00ffULL,
0x000000ffff317224ULL, 0x000fca00078e005bULL, 0x0000000131337810ULL, 0x000fc80007ffe0ffULL,
0x0000030033007a0cULL, 0x000fda0003f06070ULL, 0x0000022000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f64070ULL, 0x00000001083b7824ULL, 0x000fe200078e0233ULL,
0x0000000133357812ULL, 0x040fe200078ec0ffULL, 0x0000080033347824ULL, 0x000fe200078e00ffULL,
0x00000020003f7810ULL, 0x000fe20007ffe0ffULL, 0x000008003b327825ULL, 0x000fd000078e0002ULL,
0x000000025b36b824ULL, 0x140fe400078e025aULL, 0x000000025b38b824ULL, 0x000fe400078e025aULL,
0x00000002363db824ULL, 0x100fe200078e0235ULL, 0x0000000b3b36b211ULL, 0x000fe200078238ffULL,
0x000000023841b824ULL, 0x000fe200078e0235ULL, 0x0000080034357812ULL, 0x000fe200078ec0ffULL,
0x000000083d3db824ULL, 0x100fe200078e0200ULL, 0x0000000732347210ULL, 0x000fe20007f1e0ffULL,
0x000000084141b824ULL, 0x000fe200078e0200ULL, 0x0000000c3b32b211ULL, 0x040fe200078438ffULL,
0x000000010a397824ULL, 0x000fe200078e0235ULL, 0x0000000d3b37b211ULL, 0x040fe200008f3cffULL,
0x000000ffff357224ULL, 0x000fe200000e0633ULL, 0x0000002e3b33b211ULL, 0x000fe200010f3cffULL,
0x00000010003b7824ULL, 0x040fe200078e0239ULL, 0x000045803d3db811ULL, 0x000fe200078e20ffULL,
0x000000100038b825ULL, 0x000fc800078e0036ULL, 0x000000103f367825ULL, 0x000fe200078e0034ULL,
0x00004180413fb811ULL, 0x000fc600078e20ffULL, 0x0000001000347825ULL, 0x000fc800078e0034ULL,
0x000000100032b825ULL, 0x000fe200078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000343b7faeULL, 0x0003e8000b901c46ULL, 0x00380000363b7faeULL, 0x0003e8000b901c46ULL,
0x00000000383dbfaeULL, 0x0003e8000b901c46ULL, 0x00000000323fbfaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000008031327824ULL, 0x002fe200078e00ffULL,
0x00000001ff347819ULL, 0x000fe20000011600ULL, 0x000000025b357824ULL, 0x000fe200078e025aULL,
0x00000002ff427819ULL, 0x000fe20000011600ULL, 0x0000001000337824ULL, 0x000fe200078e00ffULL,
0x0000008032327812ULL, 0x000fc400078ec0ffULL, 0x0000000c34347812ULL, 0x000fe200078ec0ffULL,
0x00000008423c7824ULL, 0x040fe200078e00ffULL, 0x0000007033337812ULL, 0x000fe200078ec0ffULL,
0x0000010035327824ULL, 0x000fe200078e0032ULL, 0x00000008424c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000400357824ULL, 0x000fe200078e00ffULL, 0x0000000242377810ULL, 0x040fe20007ffe0ffULL,
0x0000000842407824ULL, 0x000fe200078e00ffULL, 0x0000003234347210ULL, 0x000fe20007ffe033ULL,
0x0000080031327824ULL, 0x000fe200078e00ffULL, 0x0000000142337810ULL, 0x000fe20007ffe0ffULL,
0x000000084c397824ULL, 0x000fe200078e00ffULL, 0x0000000c35457812ULL, 0x000fe200078ec0ffULL,
0x0000000842357824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee233ULL,
0x00000008423e7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800034367984ULL, 0x000e620000000800ULL, 0x0000080032337812ULL, 0x000fe200078ec0ffULL,
0x0000000842447824ULL, 0x000fe200078e00ffULL, 0xfffffff835327812ULL, 0x000fe200078ee242ULL,
0x0045800034387984ULL, 0x0004e20000000800ULL, 0x000001800a337810ULL, 0x000fe20007ffe033ULL,
0x0000000842467824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee237ULL,
0x00000008423d7824ULL, 0x040fe200078e00ffULL, 0x00000004423b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001032327824ULL, 0x000fe200078e0233ULL, 0x0000000231317810ULL, 0x000fe20007ffe0ffULL,
0x0000000842487824ULL, 0x040fe200078e00ffULL, 0xfffffff839347812ULL, 0x004fe200078ee24cULL,
0x0000000145327824ULL, 0x000fe200078e0232ULL, 0x0000000342397810ULL, 0x000fc40007ffe0ffULL,
0xfffffff844447812ULL, 0x000fe200078ee23bULL, 0x0000001034347824ULL, 0x000fe200078e0233ULL,
0x00000000323a7984ULL, 0x0005220000000800ULL, 0x0000030031007a0cULL, 0x000fe20003f06070ULL,
0x000000362f367221ULL, 0x002fc80000010100ULL, 0x3fb8aa3b36357820ULL, 0x000fe40000410000ULL,
0x0000000145367824ULL, 0x040fe400078e0234ULL, 0x0000003500377308ULL, 0x0002e20000000800ULL,
0x000000103c347824ULL, 0x000fe200078e0233ULL, 0xfffffff83e3c7812ULL, 0x000fe400078ee239ULL,
0x00000000363e7984ULL, 0x0009e20000000800ULL, 0x0000000145347824ULL, 0x000fe200078e0234ULL,
0x0000000542397810ULL, 0x000fe20007ffe0ffULL, 0x000000103c327824ULL, 0x004fc400078e0233ULL,
0x0000001040357824ULL, 0x002fe200078e0233ULL, 0x00040000343f7984ULL, 0x000fe20000000800ULL,
0xfffffff846467812ULL, 0x000fe200078ee239ULL, 0x0000000145327824ULL, 0x040fe200078e0232ULL,
0xffffffff42367810ULL, 0x010fe20007ffe0ffULL, 0x00000000343b7984ULL, 0x0003e20000000800ULL,
0x0000000145357824ULL, 0x000fe400078e0235ULL, 0x0000003837437220ULL, 0x008fe20000410000ULL,
0xfffffff83d4a7812ULL, 0x000fe200078ee236ULL, 0x0004000032417984ULL, 0x000fe20000000800ULL,
0x0000001046367824ULL, 0x100fe200078e0233ULL, 0x0000000642377810ULL, 0x000fe20007ffe0ffULL,
0x0000001044347824ULL, 0x002fe200078e0233ULL, 0x00001f4243387589ULL, 0x000e6200000e0000ULL,
0x0000000145367824ULL, 0x040fe200078e0236ULL, 0xfffffff848487812ULL, 0x000fe200078ee237ULL,
0x0000000145347824ULL, 0x000fe200078e0234ULL, 0x00000000353c7984ULL, 0x000fe20000000800ULL,
0x0000003043307221ULL, 0x000fc40000010000ULL, 0x0000001048377824ULL, 0x100fe200078e0233ULL,
0x00001f4c43397589ULL, 0x0004e200000e0000ULL, 0x000000104a337824ULL, 0x000fe400078e0233ULL,
0x0000000145377824ULL, 0x040fe200078e0237ULL, 0x00000000323d7984ULL, 0x0009e20000000800ULL,
0x0000000145337824ULL, 0x000fc600078e0233ULL, 0x0004000035407984ULL, 0x000ee20000000800ULL,
0x00007610ff437816ULL, 0x104fe4000000003aULL, 0x00005410ff327816ULL, 0x010fe2000000003aULL,
0x0000000034357984ULL, 0x000fe40000000800ULL, 0x00000038432c7223ULL, 0x082fe4000001002cULL,
0x00040000363a7984ULL, 0x000fe20000000800ULL, 0x00000038322d7223ULL, 0x000fe2000001002dULL,
0x00005410ff327816ULL, 0x000fc4000000003eULL, 0x0004000034427984ULL, 0x0002a20000000800ULL,
0x00007610ff3e7816ULL, 0x000fe4000000003eULL, 0x00000039321b7223ULL, 0x088fe4000001001bULL,
0x0000000036327984ULL, 0x0007220000000800ULL, 0x000000393e267223ULL, 0x080fe20000010026ULL,
0x00007610ff3e7816ULL, 0x000fe40000000041ULL, 0x00005410ff347816ULL, 0x102fe4000000003bULL,
0x00007610ff3b7816ULL, 0x000fe2000000003bULL, 0x000000393e237223ULL, 0x000fe20000010023ULL,
0x00005410ff367816ULL, 0x008fe2000000003fULL, 0x00000038342b7223ULL, 0x000fc4000001002bULL,
0x0000000037347984ULL, 0x000e620000000800ULL, 0x000000383b2a7223ULL, 0x000fe4000001002aULL,
0x00000039361a7223ULL, 0x080fe2000001001aULL, 0x00007610ff367816ULL, 0x000fe2000000003fULL,
0x00040000373b7984ULL, 0x0007e80000000800ULL, 0x0000003936257223ULL, 0x000fe20000010025ULL,
0x00005410ff367816ULL, 0x000fc4000000003cULL, 0x00007610ff377816ULL, 0x008fc6000000003cULL,
0x0000003836297223ULL, 0x080fe20000010029ULL, 0x00040000333c7984ULL, 0x000fe20000000800ULL,
0x0000003837287223ULL, 0x000fe20000010028ULL, 0x00005410ff377816ULL, 0x100fe40000000040ULL,
0x0000000033367984ULL, 0x0006620000000800ULL, 0x00007610ff407816ULL, 0x000fe40000000040ULL,
0x00005410ff3e7816ULL, 0x004fe20000000042ULL, 0x0000003937187223ULL, 0x080fe20000010018ULL,
0x00007610ff427816ULL, 0x000fe20000000042ULL, 0x0000003940247223ULL, 0x080fe20000010024ULL,
0x00005410ff337816ULL, 0x008fe2000000003dULL, 0x000000393e157223ULL, 0x080fe20000010015ULL,
0x00007610ff3d7816ULL, 0x000fe2000000003dULL, 0x0000003942227223ULL, 0x000fc40000010022ULL,
0x0000003833207223ULL, 0x080fe20000010020ULL, 0x00005410ff337816ULL, 0x000fe20000000041ULL,
0x000000383d107223ULL, 0x000fc80000010010ULL, 0x0000003933167223ULL, 0x000fe20000010016ULL,
0x00005410ff337816ULL, 0x100fe40000000035ULL, 0x00007610ff357816ULL, 0x000fc60000000035ULL,
0x00000038331f7223ULL, 0x080fe2000001001fULL, 0x00005410ff337816ULL, 0x110fe20000000032ULL,
0x0000003835177223ULL, 0x000fe20000010017ULL, 0x00007610ff327816ULL, 0x000fc60000000032ULL,
0x00000038331e7223ULL, 0x080fe4000001001eULL, 0x0000003832197223ULL, 0x000fe20000010019ULL,
0x00005410ff327816ULL, 0x100fe4000000003aULL, 0x00007610ff3a7816ULL, 0x000fc6000000003aULL,
0x0000003932147223ULL, 0x080fe20000010014ULL, 0x00005410ff327816ULL, 0x002fe20000000034ULL,
0x000000393a137223ULL, 0x000fe20000010013ULL, 0x00005410ff337816ULL, 0x000fe40000000036ULL,
0x00007610ff347816ULL, 0x000fe20000000034ULL, 0x00000038321d7223ULL, 0x080fe2000001001dULL,
0x00005410ff327816ULL, 0x000fe2000000003bULL, 0x00000038331c7223ULL, 0x080fe2000001001cULL,
0x00007610ff367816ULL, 0x000fe20000000036ULL, 0x0000003834117223ULL, 0x000fc40000010011ULL,
0x00000039320f7223ULL, 0x000fe2000001000fULL, 0x00007610ff327816ULL, 0x000fe2000000003bULL,
0x0000003836277223ULL, 0x000fc80000010027ULL, 0x0000003932217223ULL, 0x000fe20000010021ULL,
0x00005410ff327816ULL, 0x100fe4000000003cULL, 0x00007610ff3c7816ULL, 0x000fc6000000003cULL,
0x0000003932127223ULL, 0x080fe40000010012ULL, 0x000000393c0e7223ULL, 0x000fe2000001000eULL,
0xfffff42000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff5a00720cULL, 0x000fe20003f05270ULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007002077812ULL, 0x000fe400078ec0ffULL,
0x0000000c00087812ULL, 0x000fca00078ec0ffULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002007812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc600078ec0ffULL, 0x000000805b007824ULL, 0x000fc800078e0200ULL,
0x0000000103037824ULL, 0x000fca00078e0200ULL, 0x0049803003007388ULL, 0x0003e40000000800ULL,
0x0000000107077824ULL, 0x000fe200078e0208ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0049800007007984ULL, 0x000ea20000000800ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x004a000007037984ULL, 0x002e620000000800ULL, 0x00000000ff007221ULL, 0x004fc80000010000ULL,
0x0000000300007221ULL, 0x002fca0000010000ULL, 0x0180000000027810ULL, 0x000fc80007ffe0ffULL,
0x7f80000002027812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0000ULL, 0x0000b610000a7802ULL, 0x000fc40000000f00ULL,
0x00009b2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000037308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000003ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203027223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000060606723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff0d7819ULL, 0x104fe20000011600ULL,
0x0000000109097824ULL, 0x000fe200078e0200ULL, 0x00000008002f7811ULL, 0x000fe400078ff0ffULL,
0x000000010d0c7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0d02087589ULL, 0x000ea200000e0000ULL,
0x000000080d2e7824ULL, 0x000fe200078e00ffULL, 0x000000032f367819ULL, 0x000fe200000006ffULL,
0x000000080d317824ULL, 0x040fe200078e00ffULL, 0x00001f2f02077589ULL, 0x0022e200000e0000ULL,
0x000000080d307824ULL, 0x040fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee22fULL,
0x000000080d327824ULL, 0x000fc400078e00ffULL, 0x000000080d347824ULL, 0x000fe400078e00ffULL,
0x0000001036367824ULL, 0x000fe400078e0205ULL, 0x0000001009097824ULL, 0x000fe400078e0204ULL,
0x0000002d082d7220ULL, 0x044fe40000410000ULL, 0x0000002c082c7220ULL, 0x040fe40000410000ULL,
0x0000002b082b7220ULL, 0x000fc40000410000ULL, 0x0000002a082a7220ULL, 0x000fe20000410000ULL,
0x0000002d2c2c723eULL, 0x000fe200000010ffULL, 0x0000002908297220ULL, 0x040fe40000410000ULL,
0x0000002808287220ULL, 0x000fe20000410000ULL, 0x0000002b2a2a723eULL, 0x000fe200000010ffULL,
0x0000002008207220ULL, 0x040fe40000410000ULL, 0x0000001008037220ULL, 0x040fe20000410000ULL,
0x000000020d107810ULL, 0x040fe20007ffe0ffULL, 0x0000001f081f7220ULL, 0x000fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x00000017080a7220ULL, 0x040fe20000410000ULL,
0x000000040d177810ULL, 0x000fe20007ffe0ffULL, 0x0000001e081e7220ULL, 0x040fe20000410000ULL,
0xfffffff831107812ULL, 0x000fe200078ee210ULL, 0x0000001908197220ULL, 0x000fe20000410000ULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee217ULL, 0x0000001d081d7220ULL, 0x040fe20000410000ULL,
0x000000060d177810ULL, 0x040fe20007ffe0ffULL, 0x0000001108027220ULL, 0x042fe20000410000ULL,
0x000000030d117810ULL, 0x000fe20007ffe0ffULL, 0x0000001c081c7220ULL, 0x000fe20000410000ULL,
0xfffffff832327812ULL, 0x000fe200078ee217ULL, 0x0000002708277220ULL, 0x000fe20000410000ULL,
0x000000200303723eULL, 0x000fe200000010ffULL, 0x0000002107087220ULL, 0x008fe20000410000ULL,
0x0000001f0a0a723eULL, 0x000fe200000010ffULL, 0x000000080d217824ULL, 0x000fe200078e00ffULL,
0x0000001e1919723eULL, 0x000fe200000010ffULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001d0202723eULL, 0x000fe200000010ffULL, 0x0000002607267220ULL, 0x000fe20000410000ULL,
0x0000001c271c723eULL, 0x000fe200000010ffULL, 0x0000001a071a7220ULL, 0x000fc40000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000001b261b723eULL, 0x000fe200000010ffULL,
0x0000001807187220ULL, 0x040fe40000410000ULL, 0x00000024070b7220ULL, 0x000fe20000410000ULL,
0x0000001a251a723eULL, 0x000fe200000010ffULL, 0x0000001607167220ULL, 0x040fe40000410000ULL,
0x0000002307237220ULL, 0x000fe20000410000ULL, 0x000000180b0b723eULL, 0x000fe200000010ffULL,
0x0000001507157220ULL, 0x000fc40000410000ULL, 0x0000002207227220ULL, 0x000fe20000410000ULL,
0x000000162316723eULL, 0x000fe200000010ffULL, 0x0000001407147220ULL, 0x040fe40000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x000000152215723eULL, 0x000fe200000010ffULL,
0x0000000f070f7220ULL, 0x040fe40000410000ULL, 0x0000001207127220ULL, 0x000fe20000410000ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000000e07077220ULL, 0x000fe20000410000ULL,
0xfffffff8210e7812ULL, 0x000fe200078ee20cULL, 0x000000080d247824ULL, 0x040fe200078e00ffULL,
0xffffffff0d217810ULL, 0x040fe20007ffe0ffULL, 0x000000080d0c7824ULL, 0x040fe200078e00ffULL,
0x0000000f0808723eULL, 0x000fe200000010ffULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0xfffffff824247812ULL, 0x000fe200078ee211ULL, 0x0000001010107824ULL, 0x100fe200078e0205ULL,
0x000000050d117810ULL, 0x000fe20007ffe0ffULL, 0x000000102e2e7824ULL, 0x000fe200078e0205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee20dULL, 0x00000004000d7824ULL, 0x000fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee211ULL, 0x0000001024247824ULL, 0x000fe200078e0205ULL,
0xfffffff834347812ULL, 0x000fe200078ee221ULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x0000000c0d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000001030307824ULL, 0x100fe200078e0205ULL,
0x000000120707723eULL, 0x000fe200000010ffULL, 0x0000001032327824ULL, 0x000fc400078e0205ULL,
0x0000001034347824ULL, 0x000fe400078e0205ULL, 0x000000010c057824ULL, 0x000fe400078e020dULL,
0x000000010d117824ULL, 0x040fe400078e020eULL, 0x000000010d107824ULL, 0x040fe200078e0210ULL,
0x0000002c05007388ULL, 0x000fe20000000800ULL, 0x000000010d247824ULL, 0x040fe400078e0224ULL,
0x000000010d2e7824ULL, 0x040fe200078e022eULL, 0x0000002a11007388ULL, 0x000fe20000000800ULL,
0x000000010d307824ULL, 0x000fc400078e0230ULL, 0x000000010d177824ULL, 0x040fe200078e0232ULL,
0x0000002810007388ULL, 0x000fe20000000800ULL, 0x000000010d347824ULL, 0x040fe400078e0234ULL,
0x000000010d367824ULL, 0x000fe200078e0236ULL, 0x0000000324007388ULL, 0x000fe80000000800ULL,
0x0000000a2e007388ULL, 0x000fe80000000800ULL, 0x0000001930007388ULL, 0x000fe80000000800ULL,
0x0000000217007388ULL, 0x000fe80000000800ULL, 0x0000001c34007388ULL, 0x000fe80000000800ULL,
0x0000001b36007388ULL, 0x000fe80000000800ULL, 0x0004001a11007388ULL, 0x000fe80000000800ULL,
0x0004000b10007388ULL, 0x000fe80000000800ULL, 0x0004001624007388ULL, 0x000fe80000000800ULL,
0x000400152e007388ULL, 0x000fe80000000800ULL, 0x0004001330007388ULL, 0x000fe80000000800ULL,
0x0004000817007388ULL, 0x000fe80000000800ULL, 0x0004000734007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000090c7984ULL, 0x000e680000000c00ULL,
0x00040000091c7984ULL, 0x000ea80000000c00ULL, 0x0008000009187984ULL, 0x000ee80000000c00ULL,
0x000c000009207984ULL, 0x000f220000000c00ULL, 0x3f803f80060f7831ULL, 0x002fc4000020000fULL,
0x3f803f80060e7831ULL, 0x040fe4000020000eULL, 0x3f803f80060d7831ULL, 0x040fe4000020000dULL,
0x3f803f80060c7831ULL, 0x040fe4000020000cULL, 0x3f803f80061f7831ULL, 0x044fe4000020001fULL,
0x3f803f80061e7831ULL, 0x040fe4000020001eULL, 0x3f803f80061d7831ULL, 0x000fc4000020001dULL,
0x3f803f80061c7831ULL, 0x000fe4000020001cULL, 0x3f803f800f0f7831ULL, 0x008fe4000020001bULL,
0x3f803f800e0e7831ULL, 0x000fe4000020001aULL, 0x3f803f800d0d7831ULL, 0x000fe40000200019ULL,
0x3f803f800c0c7831ULL, 0x000fe40000200018ULL, 0x3f803f801f1f7831ULL, 0x010fc40000200023ULL,
0x3f803f801e1e7831ULL, 0x000fe20000200022ULL, 0x0000000c09007388ULL, 0x000fe20000000c00ULL,
0x3f803f801d1d7831ULL, 0x000fe40000200021ULL, 0x3f803f801c1c7831ULL, 0x000fca0000200020ULL,
0x0004001c09007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff5b00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002000127810ULL, 0x000fe20007ffe0ffULL, 0x0000000000067919ULL, 0x000e620000002600ULL,
0x00000003ff077819ULL, 0x000fe20000011600ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff057819ULL, 0x000fe20000011612ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x000000085a117824ULL, 0x000fe200078e00ffULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000107037824ULL, 0x100fe400078e0200ULL, 0x0000000112027824ULL, 0x000fe200078e0205ULL,
0xfffffff811117812ULL, 0x000fc400078ee200ULL, 0x0000000703037812ULL, 0x000fe400078ec0ffULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x0ffffff803097812ULL, 0x000fe400078ef800ULL,
0x0ffffff802037812ULL, 0x000fc600078ef812ULL, 0x0000001009027824ULL, 0x100fe400078e0204ULL,
0x0000001003047824ULL, 0x000fe400078e0204ULL, 0x0000000806107824ULL, 0x042fe200078e00ffULL,
0x0000000002087984ULL, 0x0002e20000000c00ULL, 0x0000000806067824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x00000000040c7984ULL, 0x0005220000000c00ULL,
0xfffffff810037812ULL, 0x000fe200078ee207ULL, 0x000000085a077824ULL, 0x000fe200078e00ffULL,
0xfffffff806057812ULL, 0x000fc400078ee205ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff807077812ULL, 0x000fe200078ee212ULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x002fe200078040ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x004fe400078240ffULL,
0x00005b0003037a11ULL, 0x000fc400000f4410ULL, 0x00005b0005057a11ULL, 0x000fc600008f4406ULL,
0x0000001011027825ULL, 0x000fc800078e0002ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000000c04007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff037819ULL, 0x000fe2000001160eULL,
0xffffffffff0a7424ULL, 0x000fc800078e00ffULL, 0x00000002580c7824ULL, 0x000fca00078e0203ULL,
0x0000000d0c00720cULL, 0x000fda0003f06070ULL, 0x0000000205038824ULL, 0x000fc800078e00ffULL,
0x0000640003128a24ULL, 0x000fc800078e020cULL, 0x0000600012128625ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006120a8981ULL, 0x000ea2000c1e1900ULL,
0x0000000158047810ULL, 0x000fe20007ffe0ffULL, 0x000000400e097824ULL, 0x000fe400078e00ffULL,
0x0000008010087824ULL, 0x000fe200078e00ffULL, 0x0000000b0400720cULL, 0x000fe20003f06070ULL,
0x0000010058157824ULL, 0x000fe200078e0209ULL, 0x01b60000ff027f8cULL, 0x000e62000c80043fULL,
0x0000008014077824ULL, 0x000fc600078e00ffULL, 0x0000004008117812ULL, 0x000fe200078ef815ULL,
0x000000070a047224ULL, 0x004fcc00078e02ffULL, 0x00000e8000008947ULL, 0x000fea0003800000ULL,
0x000000150f127217ULL, 0x002fe40007800000ULL, 0x00000003ff137819ULL, 0x100fe40000011600ULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x0000000112127824ULL, 0x000fe200078e0a15ULL,
0x0000000413177810ULL, 0x000fe20007ffe0ffULL, 0x0000000111157824ULL, 0x000fe200078e0213ULL,
0x0000000813197810ULL, 0x000fe40007ffe0ffULL, 0x000000121700720cULL, 0x0c0fe20003f06070ULL,
0x0000000117107824ULL, 0x100fe200078e0200ULL, 0x0000001504167210ULL, 0x040fe20007f3e0ffULL,
0x0000000111157824ULL, 0x000fe200078e0217ULL, 0x0000000c13277810ULL, 0x000fe20007ffe0ffULL,
0x00000008172d7824ULL, 0x000fe200078e00ffULL, 0x0000001413357810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200008e06ffULL, 0x0000001504157210ULL, 0x000fe20007f5e0ffULL,
0x0000000119147824ULL, 0x000fe200078e0200ULL, 0x00005e0016257a11ULL, 0x040fe200078240ffULL,
0x00000001111b7824ULL, 0x000fe200078e0235ULL, 0x00000010132b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005e00151f7a11ULL, 0x000fe200078440ffULL,
0x00000008192f7824ULL, 0x000fe200078e00ffULL, 0x00005f0016167a11ULL, 0x000fe200008f4417ULL,
0x0000000111177824ULL, 0x000fe200078e0227ULL, 0x00005f0015187a11ULL, 0x000fe200010f4418ULL,
0x0000000111157824ULL, 0x000fe200078e0219ULL, 0x000000121900720cULL, 0x000fe20003f26070ULL,
0x0000000111197824ULL, 0x000fe200078e022bULL, 0x0000001704177210ULL, 0x040fe20007fbe0ffULL,
0x0000000827267824ULL, 0x000fe200078e00ffULL, 0x0000001504157210ULL, 0x040fe20007f9e0ffULL,
0x000000012b207824ULL, 0x000fe200078e0200ULL, 0x0000001b041b7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200028e06ffULL, 0x0000001813377810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x00005e00151d7a11ULL, 0x000fe200078840ffULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee214ULL,
0x0000000113147824ULL, 0x000fe200078e0200ULL, 0x0000001904197210ULL, 0x000fe20007f5e0ffULL,
0x000000082b337824ULL, 0x000fe200078e00ffULL, 0x00005e0017217a11ULL, 0x000fc400078a40ffULL,
0x00005f00151e7a11ULL, 0x000fe200020f441eULL, 0x0000000111157824ULL, 0x000fe200078e0237ULL,
0x00005e001b297a11ULL, 0x000fe200078640ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x00005f00171a7a11ULL, 0x000fe400028f441aULL, 0x00005f001b247a11ULL, 0x000fe400018f4424ULL,
0x0000000714177812ULL, 0x000fe400078ec0ffULL, 0x00005e0019237a11ULL, 0x000fc400078440ffULL,
0x0000001504227210ULL, 0x000fe40007fde0ffULL, 0x0000002506147210ULL, 0x000fe40007f7e0ffULL,
0x00005f00191c7a11ULL, 0x000fe200010f441cULL, 0x0000000127197824ULL, 0x100fe200078e0200ULL,
0x0ffffff8171b7812ULL, 0x000fe200078ef800ULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x000000122700720cULL, 0x000fe20003fa6070ULL, 0x000000ffff157224ULL, 0x000fe200018e0616ULL,
0x00005e0022277a11ULL, 0x000fc400078640ffULL, 0x000000121300720cULL, 0x000fe40003f46070ULL,
0x00005f0022227a11ULL, 0x000fe400018f4417ULL, 0x0000001f06167210ULL, 0x000fe20007f7e0ffULL,
0x00000001351f7824ULL, 0x000fe200078e0200ULL, 0x0000001c13257810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL, 0x000000ffff177224ULL, 0x000fe200018e0618ULL,
0x000010000e107811ULL, 0x000fc400078e70ffULL, 0x0000001d06187210ULL, 0x000fe20007f7e0ffULL,
0x00000001111d7824ULL, 0x000fe200078e0225ULL, 0xfffffff833337812ULL, 0x000fe200078ee220ULL,
0x000000101b1b7824ULL, 0x000fe200078e0210ULL, 0xfffffff826317812ULL, 0x000fe200078ee219ULL,
0x000000ffff197224ULL, 0x000fe200018e061eULL, 0x0000001d04207210ULL, 0x000fe20007fde0ffULL,
0x0000000835267824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141b7faeULL, 0x0003e2000d101c46ULL, 0x000000123700720cULL, 0x080fe20003f66070ULL,
0x000000102d1d7824ULL, 0x000fe200078e0210ULL, 0x000000122b00720cULL, 0x000fc40003f86070ULL,
0x000000123500720cULL, 0x080fe40003f46070ULL, 0xfffffff826357812ULL, 0x000fe200078ee21fULL,
0x000000102f1f7824ULL, 0x000fe200078e0210ULL, 0x00000000161d7faeULL, 0x0005e2000c101c46ULL,
0x000000122500720cULL, 0x040fe20003f06070ULL, 0x0000000125267824ULL, 0x100fe400078e0200ULL,
0x0000000137147824ULL, 0x042fe200078e0200ULL, 0x00000000181f7faeULL, 0x0003e2000c901c46ULL,
0x0000000837377824ULL, 0x000fc400078e00ffULL, 0x000000ffff157224ULL, 0x000fe200030e06ffULL,
0x00005e00202b7a11ULL, 0x040fe200078c40ffULL, 0x00000008252f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8372d7812ULL, 0x000fe200078ee214ULL, 0x00000010331d7824ULL, 0x104fe200078e0210ULL,
0x00005f0020207a11ULL, 0x000fe400030f4415ULL, 0x0000002106147210ULL, 0x040fe40007fde0ffULL,
0x0000002013217810ULL, 0x000fe20007ffe0ffULL, 0x0000001031197824ULL, 0x002fe200078e0210ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee226ULL, 0x000000ffff157224ULL, 0x000fe200030e061aULL,
0x00000023061a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000111237824ULL, 0x000fc400078e0221ULL,
0x0000000121167824ULL, 0x040fe200078e0200ULL, 0x0000000014197faeULL, 0x0003e2000e901c46ULL,
0x0000000821257824ULL, 0x040fe200078e00ffULL, 0x00000023041e7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e061cULL, 0x000000122100720cULL, 0x000fe40003f26070ULL,
0xfffffff825257812ULL, 0x000fe200078ee216ULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x00005e001e237a11ULL, 0x000fe200078c40ffULL, 0x000000001a1d7faeULL, 0x0005e2000e101c46ULL,
0x0000002906167210ULL, 0x000fe20007fbe0ffULL, 0x0000001025257824ULL, 0x000fe200078e0210ULL,
0x00005f001e1e7a11ULL, 0x000fc400030f4417ULL, 0x0000002413177810ULL, 0x000fc80007ffe0ffULL,
0x000000121700720cULL, 0x000fe20003f86070ULL, 0x00000001111f7824ULL, 0x000fe400078e0217ULL,
0x0000000117187824ULL, 0x000fc600078e0200ULL, 0x0000001f041c7210ULL, 0x000fe20007fde0ffULL,
0x00000008171f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff177224ULL, 0x000fe200028e0624ULL,
0x0000002706147210ULL, 0x002fe20007fbe0ffULL, 0x000000ffff217224ULL, 0x000fe200030e06ffULL,
0x00005e001c297a11ULL, 0x040fe400078c40ffULL, 0xfffffff81f277812ULL, 0x000fe200078ee218ULL,
0x00000010351f7824ULL, 0x000fe200078e0210ULL, 0x00005f001c1d7a11ULL, 0x004fe200030f4421ULL,
0x000000ffff157224ULL, 0x000fc400028e0622ULL, 0x000000102d217824ULL, 0x100fe200078e0210ULL,
0x00000000161f7faeULL, 0x0003e2000d101c46ULL, 0x0000002b06187210ULL, 0x040fe20007f5e0ffULL,
0x0000001027277824ULL, 0x000fe200078e0210ULL, 0x00000038132b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000014217faeULL, 0x0005e2000d901c46ULL, 0x00000023061a7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0620ULL, 0x00000029061c7210ULL, 0x000fe20007f5e0ffULL,
0x000000102f237824ULL, 0x000fe200078e0210ULL, 0x0000003413297810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e061eULL, 0x0000003c132d7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e061dULL, 0x0000002c131f7810ULL, 0x002fe20007ffe0ffULL,
0x0000000018237faeULL, 0x0003e2000c101c46ULL, 0x000000122900720cULL, 0x000fc40003f46070ULL,
0x0000002813157810ULL, 0x044fe20007ffe0ffULL, 0x000000001a257faeULL, 0x0005e2000c901c46ULL,
0x0000003013217810ULL, 0x000fe40007ffe0ffULL, 0x000000121500720cULL, 0x080fe20003fa6070ULL,
0x0000000111137824ULL, 0x000fe200078e0215ULL, 0x000000001c277faeULL, 0x0007e2000e101c46ULL,
0x0000000115147824ULL, 0x100fe200078e0200ULL, 0x000000121f00720cULL, 0x0c0fe20003f86070ULL,
0x000000081f187824ULL, 0x042fe200078e00ffULL, 0x0000001304167210ULL, 0x000fe20007f1e0ffULL,
0x000000011f137824ULL, 0x000fe200078e0200ULL, 0x000000122100720cULL, 0x080fe20003f66070ULL,
0x0000000815177824ULL, 0x000fe200078e00ffULL, 0x00005e0016157a11ULL, 0x000fe200078c40ffULL,
0x000000ffff1b7224ULL, 0x004fe200000e06ffULL, 0xfffffff818197812ULL, 0x000fe200078ee213ULL,
0x00000001111f7824ULL, 0x000fe200078e021fULL, 0x000000122b00720cULL, 0x080fe20003f26070ULL,
0x00000008291a7824ULL, 0x000fe200078e00ffULL, 0x000000122d00720cULL, 0x000fe20003f06070ULL,
0x0000001019197824ULL, 0x000fe200078e0210ULL, 0x00005f0016137a11ULL, 0x000fe200030f441bULL,
0x00000008211b7824ULL, 0x000fe200078e00ffULL, 0x0000001506127210ULL, 0x000fe20007fde0ffULL,
0x0000000129157824ULL, 0x000fe200078e0200ULL, 0xfffffff817177812ULL, 0x000fe200078ee214ULL,
0x0000000121147824ULL, 0x000fc400078e0200ULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x0000001f04187210ULL, 0x000fe20007fde0ffULL, 0x0000000111217824ULL, 0x000fe200078e0221ULL,
0xfffffff81a1d7812ULL, 0x008fe200078ee215ULL, 0x0000001017177824ULL, 0x000fe200078e0210ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee214ULL, 0x000000ffff257224ULL, 0x000fe200030e06ffULL,
0x00005e0018237a11ULL, 0x040fe200078c40ffULL, 0x0000000111297824ULL, 0x000fe200078e0229ULL,
0x0000000012177faeULL, 0x0003e2000e901c46ULL, 0x000000012b167824ULL, 0x140fe200078e0200ULL,
0x00005f0018157a11ULL, 0x000fe200030f4425ULL, 0x000000082b1f7824ULL, 0x000fe200078e00ffULL,
0x0000002306147210ULL, 0x000fe20007fde0ffULL, 0x000000012d007824ULL, 0x000fe200078e0200ULL,
0x0000002904297210ULL, 0x040fe20007fbe0ffULL, 0x00000001112b7824ULL, 0x000fe200078e022bULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x0000002104187210ULL, 0x000fe20007fde0ffULL, 0x000000082d217824ULL, 0x000fc400078e00ffULL,
0x000000ffff167224ULL, 0x000fe200028e06ffULL, 0x0000000014197faeULL, 0x0005e2000e101c46ULL,
0x000000ffff237224ULL, 0x000fe200030e06ffULL, 0x00005e0018257a11ULL, 0x040fe200078c40ffULL,
0x0000000111117824ULL, 0x000fe200078e022dULL, 0xfffffff821217812ULL, 0x000fe200078ee200ULL,
0x000000101b1b7824ULL, 0x100fe200078e0210ULL, 0x00005f0018187a11ULL, 0x000fe200030f4423ULL,
0x000000101d1d7824ULL, 0x100fe200078e0210ULL, 0x00005e0029237a11ULL, 0x000fe200078a40ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0210ULL, 0x0000002b042b7210ULL, 0x000fe20007f9e0ffULL,
0x0000001021217824ULL, 0x000fe200078e0210ULL, 0x00005f0029167a11ULL, 0x000fc400028f4416ULL,
0x0000001104007210ULL, 0x000fe20007fde0ffULL, 0x000000ffff047224ULL, 0x000fe200020e06ffULL,
0x0000002506107210ULL, 0x000fe40007fbe0ffULL, 0x00005e002b157a11ULL, 0x044fe200078840ffULL,
0x000000ffff137224ULL, 0x002fe200030e06ffULL, 0x00005e0000177a11ULL, 0x000fe200078c40ffULL,
0x000000ffff117224ULL, 0x000fe200028e0618ULL, 0x0000002306127210ULL, 0x000fe40007fbe0ffULL,
0x00005f002b047a11ULL, 0x000fc400020f4404ULL, 0x00005f0000007a11ULL, 0x000fe200030f4413ULL,
0x000000ffff137224ULL, 0x000fe200028e0616ULL, 0x0000001506147210ULL, 0x040fe20007f9e0ffULL,
0x00000000101b7faeULL, 0x0003e2000d901c46ULL, 0x0000001706167210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200020e0604ULL, 0x00000000121d7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff177224ULL, 0x000fc600028e0600ULL, 0x00000000141f7faeULL, 0x0003e8000c901c46ULL,
0x0000000016217faeULL, 0x0003e2000c101c46ULL, 0x00000d4000007947ULL, 0x000fea0003800000ULL,
0x0000000400177811ULL, 0x042fe400078fe8ffULL, 0x00000008001b7811ULL, 0x040fe400078fe8ffULL,
0x0000000c001d7811ULL, 0x040fe200078fe8ffULL, 0x0000000117277824ULL, 0x140fe200078e0200ULL,
0x00000010001f7811ULL, 0x040fe200078fe8ffULL, 0x0000000817107824ULL, 0x000fe200078e00ffULL,
0x0000001800297811ULL, 0x040fe200078fe8ffULL, 0x000000011b247824ULL, 0x140fe200078e0200ULL,
0x0000001400217811ULL, 0x000fe200078fe8ffULL, 0x000000081b137824ULL, 0x000fe200078e00ffULL,
0xfffffff810277812ULL, 0x000fe200078ee227ULL, 0x000000011d267824ULL, 0x140fe200078e0200ULL,
0x0000002000107811ULL, 0x040fe200078fe8ffULL, 0x000000081d157824ULL, 0x000fe200078e00ffULL,
0x0000001c002b7811ULL, 0x040fe200078fe8ffULL, 0x000000011f257824ULL, 0x000fe200078e0200ULL,
0xfffffff813247812ULL, 0x000fe200078ee224ULL, 0x000000081f127824ULL, 0x000fe200078e00ffULL,
0xfffffff815267812ULL, 0x000fe200078ee226ULL, 0x0000000129237824ULL, 0x140fe200078e0200ULL,
0x0000002c00187811ULL, 0x000fe200078fe8ffULL, 0x0000000829147824ULL, 0x000fe200078e00ffULL,
0xfffffff812257812ULL, 0x000fe200078ee225ULL, 0x0000000110197824ULL, 0x100fe200078e0200ULL,
0x0000003000207811ULL, 0x000fe200078fe8ffULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0xfffffff814237812ULL, 0x000fe200078ee223ULL, 0x0000000121287824ULL, 0x140fe200078e0200ULL,
0x0000002400147811ULL, 0x000fe200078fe8ffULL, 0x0000000821137824ULL, 0x000fe200078e00ffULL,
0xfffffff816197812ULL, 0x000fe200078ee219ULL, 0x000000012b127824ULL, 0x040fe200078e0200ULL,
0x0000002800167811ULL, 0x000fe200078fe8ffULL, 0x000000082b157824ULL, 0x000fe200078e00ffULL,
0xfffffff813287812ULL, 0x000fe200078ee228ULL, 0x00000001141a7824ULL, 0x000fe200078e0200ULL,
0x00000034002a7811ULL, 0x000fe200078fe8ffULL, 0x0000000814137824ULL, 0x000fe200078e00ffULL,
0xfffffff815127812ULL, 0x000fe200078ee212ULL, 0x00000001161c7824ULL, 0x000fe200078e0200ULL,
0x00000038002c7811ULL, 0x000fe200078fe8ffULL, 0x0000000816157824ULL, 0x000fe200078e00ffULL,
0xfffffff8131a7812ULL, 0x000fe200078ee21aULL, 0x00000001181e7824ULL, 0x000fe200078e0200ULL,
0x0000001100137211ULL, 0x000fe200078fe8ffULL, 0x00000008182d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8151c7812ULL, 0x000fe200078ee21cULL, 0x0000000120227824ULL, 0x000fe200078e0200ULL,
0x0000000000157211ULL, 0x000fe200078fe8ffULL, 0x00000008202f7824ULL, 0x000fe200078e00ffULL,
0x0000003c002e7811ULL, 0x000fe200078fe8ffULL, 0x0000000111317824ULL, 0x000fe200078e0220ULL,
0x0000001304307210ULL, 0x040fe20007f1e0ffULL, 0x0000000117137824ULL, 0x100fe200078e0211ULL,
0x0000000715397812ULL, 0x000fe200078ec0ffULL, 0x000000011b157824ULL, 0x100fe200078e0211ULL,
0xfffffff82d1e7812ULL, 0x000fe200078ee21eULL, 0x000000011d177824ULL, 0x100fe200078e0211ULL,
0xfffffff82f227812ULL, 0x000fe200078ee222ULL, 0x000000011f1b7824ULL, 0x100fe200078e0211ULL,
0x0ffffff839397812ULL, 0x000fe200078ef800ULL, 0x00000001211d7824ULL, 0x100fe200078e0211ULL,
0x0000001504157210ULL, 0x040fe20007f3e0ffULL, 0x00000001291f7824ULL, 0x100fe200078e0211ULL,
0x0000001704177210ULL, 0x040fe20007f5e0ffULL, 0x000000012b217824ULL, 0x000fe200078e0211ULL,
0x0000001b041b7210ULL, 0x000fe20007f7e0ffULL, 0x0000000111297824ULL, 0x040fe200078e0210ULL,
0x000010000e477811ULL, 0x000fe200078e70ffULL, 0x00000001112b7824ULL, 0x040fe200078e0214ULL,
0x0000007006497812ULL, 0x000fe200078ec0ffULL, 0x00000001112d7824ULL, 0x000fc400078e0216ULL,
0x00000001112f7824ULL, 0x040fe400078e0218ULL, 0x0000000111337824ULL, 0x040fe400078e022aULL,
0x0000000111357824ULL, 0x040fe400078e022cULL, 0x0000000111377824ULL, 0x000fe400078e022eULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005e0030107a11ULL, 0x000fe200078040ffULL,
0x000000012a147824ULL, 0x000fc400078e0200ULL, 0x000000082a3b7824ULL, 0x000fe200078e00ffULL,
0x00005f0030117a11ULL, 0x000fe200000f4411ULL, 0x000000012c167824ULL, 0x000fe200078e0200ULL,
0x0000001304137210ULL, 0x000fe20007f1e0ffULL, 0x000000082c3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b2a7812ULL, 0x000fe200078ee214ULL, 0x000000012e007824ULL, 0x040fe400078e0200ULL,
0x000000082e3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83d2c7812ULL, 0x000fe200078ee216ULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x00005e0013447a11ULL, 0x000fe200078040ffULL,
0x000000ffff307224ULL, 0x000fe200008e06ffULL, 0xfffffff83f2e7812ULL, 0x000fe200078ee200ULL,
0x000000ffff207224ULL, 0x000fe200010e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078240ffULL,
0x000000ffff007224ULL, 0x000fe200018e06ffULL, 0x00005e0017167a11ULL, 0x000fe200078440ffULL,
0x000000102a437824ULL, 0x100fe200078e0247ULL, 0x00005e001b187a11ULL, 0x000fe200078640ffULL,
0x000000101a3b7824ULL, 0x100fe200078e0247ULL, 0x00005f0013137a11ULL, 0x000fe200000f4432ULL,
0x000000101c3d7824ULL, 0x100fe200078e0247ULL, 0x00005f0015157a11ULL, 0x000fe200008f4430ULL,
0x000000101e3f7824ULL, 0x100fe200078e0247ULL, 0x0000001d041d7210ULL, 0x000fe20007f1e0ffULL,
0x0000001022417824ULL, 0x100fe200078e0247ULL, 0x00005f0017177a11ULL, 0x000fe200010f4420ULL,
0x000000102c457824ULL, 0x000fe200078e0247ULL, 0x0000001f041f7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff367224ULL, 0x000fe200000e06ffULL, 0x00005f001b007a11ULL, 0x000fc400018f4400ULL,
0x0000002104217210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x0000002904297210ULL, 0x000fe40007f7e0ffULL, 0x00005e001d427a11ULL, 0x000fe200078040ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x00005e001f407a11ULL, 0x000fe200078240ffULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x00005e00213e7a11ULL, 0x000fe400078440ffULL,
0x00005e0029207a11ULL, 0x000fc400078640ffULL, 0x00005f001d1b7a11ULL, 0x000fe400000f4436ULL,
0x00005f001f1d7a11ULL, 0x000fe400008f4434ULL, 0x00005f00211f7a11ULL, 0x000fe400010f4432ULL,
0x00005f0029217a11ULL, 0x000fe200018f4430ULL, 0x0000001039297824ULL, 0x100fe200078e0247ULL,
0x0000002b042b7210ULL, 0x040fe20007f7e0ffULL, 0x0000001019397824ULL, 0x100fe200078e0247ULL,
0x0000002d04387210ULL, 0x000fe20007f5e0ffULL, 0x00000010242d7824ULL, 0x100fe200078e0247ULL,
0x0000003104347210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x00005e002b3a7a11ULL, 0x000fe200078c40ffULL, 0x0000001025317824ULL, 0x100fe200078e0247ULL,
0x0000003504307210ULL, 0x040fe20007f9e0ffULL, 0x0000001023357824ULL, 0x100fe200078e0247ULL,
0x0000002f04367210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x0000003304327210ULL, 0x000fe20007f7e0ffULL, 0x0000001028337824ULL, 0x100fe200078e0247ULL,
0x00005e0038247a11ULL, 0x000fe200078440ffULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x00005e0034287a11ULL, 0x000fe200078240ffULL, 0x00000010262f7824ULL, 0x100fe200078e0247ULL,
0x0000003704047210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x00005f002b3c7a11ULL, 0x000fe200030f443cULL, 0x00000010272b7824ULL, 0x000fe200078e0247ULL,
0x00005f0038387a11ULL, 0x000fe200010f4423ULL, 0x000000ffff277224ULL, 0x000fe200000e06ffULL,
0x00005e0036267a11ULL, 0x000fe200078040ffULL, 0x0000001012377824ULL, 0x000fe200078e0247ULL,
0x00005f0034347a11ULL, 0x000fe200008f4419ULL, 0x000000ffff237224ULL, 0x000fe200020e06ffULL,
0x00005e00322a7a11ULL, 0x000fe200078240ffULL, 0x000000102e477824ULL, 0x000fe200078e0247ULL,
0x00005e00302c7a11ULL, 0x000fe200078440ffULL, 0x000000ffff197224ULL, 0x000fe200028e06ffULL,
0x00005e00042e7a11ULL, 0x000fc400078640ffULL, 0x00005f0036277a11ULL, 0x000fe400000f4427ULL,
0x0000001049107210ULL, 0x040fe40007f1e0ffULL, 0x00005f0032327a11ULL, 0x000fe400008f4425ULL,
0x00005f0030067a11ULL, 0x000fe200010f4423ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000004449127210ULL, 0x000fe40007f3e0ffULL, 0x00005f0004047a11ULL, 0x000fc400018f4419ULL,
0x0000001449147210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x0000001649167210ULL, 0x040fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010297faeULL, 0x0003e2000b901c46ULL, 0x0000001849187210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x00000042491a7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff177224ULL, 0x000fe200018e0617ULL, 0x00000040491c7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff197224ULL, 0x000fe200028e0600ULL, 0x0000003e491e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e061bULL, 0x0000002049207210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000003a49227210ULL, 0x040fe20007f7e0ffULL,
0x00000000122b7faeULL, 0x0005e2000b901c46ULL, 0x0000002449247210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e061fULL, 0x0000002649267210ULL, 0x040fe20007f9e0ffULL,
0x00000000142d7faeULL, 0x0007e2000b901c46ULL, 0x0000002849287210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200010e0621ULL, 0x0000002a492a7210ULL, 0x040fe20007f3e0ffULL,
0x00000000162f7faeULL, 0x0009e2000b901c46ULL, 0x0000002c492c7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff237224ULL, 0x000fe200018e063cULL, 0x0000002e492e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000018317faeULL, 0x0009e2000b901c46ULL, 0x000000ffff257224ULL, 0x000fc400028e0638ULL,
0x000000ffff277224ULL, 0x000fe200020e0627ULL, 0x000000001a337faeULL, 0x0009e2000b901c46ULL,
0x000000ffff297224ULL, 0x002fe400000e0634ULL, 0x000000ffff2b7224ULL, 0x004fe200008e0632ULL,
0x000000001c357faeULL, 0x0003e2000b901c46ULL, 0x000000ffff2d7224ULL, 0x008fe400010e0606ULL,
0x000000ffff2f7224ULL, 0x010fe200018e0604ULL, 0x000000001e377faeULL, 0x0003e8000b901c46ULL,
0x0000000020397faeULL, 0x0003e8000b901c46ULL, 0x00000000223b7faeULL, 0x0003e8000b901c46ULL,
0x00000000243d7faeULL, 0x0003e8000b901c46ULL, 0x00000000263f7faeULL, 0x0003e8000b901c46ULL,
0x0000000028417faeULL, 0x0003e8000b901c46ULL, 0x000000002a437faeULL, 0x0003e8000b901c46ULL,
0x000000002c457faeULL, 0x0003e8000b901c46ULL, 0x000000002e477faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x01b60400ff137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fc40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011413ULL,
0x0000001500007211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000200007819ULL, 0x000fc80000001213ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000104047810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60400ff137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b5800720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0x0000640005057a24ULL, 0x000fe200078e02ffULL,
0x0001b6880e047811ULL, 0x040fe200078e18ffULL, 0x000000200e027824ULL, 0x000fe200078e00ffULL,
0xffffffff0b037810ULL, 0x000fc40007ffe0ffULL, 0x0000010058007824ULL, 0x000fe200078e0209ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000000f00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x0000000158107810ULL, 0x000fe20007ffe0ffULL,
0x0000000a070a7224ULL, 0x000fe200078e02ffULL, 0x00000040002f7812ULL, 0x000fe400078ec0ffULL,
0x0000000b1000720cULL, 0x000fc60003f06070ULL, 0x00000001082f7824ULL, 0x000fd400078e022fULL,
0x00000d8000008947ULL, 0x000fea0003800000ULL, 0x00000003ff477819ULL, 0x102fe40000011606ULL,
0x0ffffff8066a7812ULL, 0x000fe400078ec0ffULL, 0x0000000447137810ULL, 0x040fe20007ffe0ffULL,
0x0000000147117824ULL, 0x040fe200078e022fULL, 0x0000000847157810ULL, 0x040fe40007ffe0ffULL,
0x0000000c47437810ULL, 0x000fe20007ffe0ffULL, 0x00000001133d7824ULL, 0x140fe200078e0206ULL,
0x000000110a117210ULL, 0x000fe20007f1e0ffULL, 0x0000000813107824ULL, 0x000fe200078e00ffULL,
0x0000001047497810ULL, 0x000fe20007ffe0ffULL, 0x00000001153f7824ULL, 0x000fe200078e0206ULL,
0x00000014474d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0xfffffff8103d7812ULL, 0x000fe200078ee23dULL, 0x000000010f107824ULL, 0x000fe200078e0a00ULL,
0x00005e00111c7a11ULL, 0x000fe200078040ffULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0x0000001c47517810ULL, 0x000fe20007ffe0ffULL, 0x0000000149177824ULL, 0x100fe200078e022fULL,
0x00005f00111d7a11ULL, 0x000fe200000f4412ULL, 0x0000000113117824ULL, 0x140fe200078e022fULL,
0x000000101300720cULL, 0x080fe20003f26070ULL, 0x0000000115137824ULL, 0x140fe200078e022fULL,
0x000000101500720cULL, 0x000fe20003f06070ULL, 0x0000000143157824ULL, 0x000fe200078e022fULL,
0x000000110a117210ULL, 0x040fe20007f9e0ffULL, 0x0000000149347824ULL, 0x040fe200078e0206ULL,
0x000000130a137210ULL, 0x040fe20007fbe0ffULL, 0x00000008494b7824ULL, 0x000fe200078e00ffULL,
0x000000150a157210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x000000170a177210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff167224ULL, 0x000fe200028e06ffULL,
0xfffffff8143f7812ULL, 0x000fe200078ee23fULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x00005e00112c7a11ULL, 0x000fe200078840ffULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x00005e0015287a11ULL, 0x000fc400078440ffULL, 0x00005e00132a7a11ULL, 0x000fe400078a40ffULL,
0x00000018474f7810ULL, 0x000fe40007ffe0ffULL, 0x00005e0017207a11ULL, 0x000fe400078640ffULL,
0x0000002047417810ULL, 0x000fe40007ffe0ffULL, 0x00005f00112d7a11ULL, 0x000fe200020f4418ULL,
0x000000014d117824ULL, 0x100fe200078e022fULL, 0x00005f0015297a11ULL, 0x000fe200010f4414ULL,
0x0000000151157824ULL, 0x100fe200078e022fULL, 0x00005f00132b7a11ULL, 0x000fe200028f4416ULL,
0x000000014f137824ULL, 0x100fe200078e022fULL, 0x00005f0017217a11ULL, 0x000fe200018f4412ULL,
0x0000000141177824ULL, 0x000fe200078e022fULL, 0x000000110a117210ULL, 0x000fc40007f9e0ffULL,
0x000000150a157210ULL, 0x040fe40007f5e0ffULL, 0x000000130a137210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0x000000170a177210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005e0011267a11ULL, 0x000fe400078840ffULL,
0x000000ffff167210ULL, 0x000fe20002ffe4ffULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x0000002447397810ULL, 0x000fc40007ffe0ffULL, 0x00005e0013247a11ULL, 0x000fe400078a40ffULL,
0x00005e0015227a11ULL, 0x000fe400078440ffULL, 0x0000002847377810ULL, 0x040fe40007ffe0ffULL,
0x0000002c47357810ULL, 0x000fe40007ffe0ffULL, 0x00005e00171e7a11ULL, 0x000fe400078640ffULL,
0x0000003047337810ULL, 0x000fc40007ffe0ffULL, 0x00005f0011277a11ULL, 0x000fe200020f4418ULL,
0x0000000139117824ULL, 0x100fe200078e022fULL, 0x00005f0013257a11ULL, 0x000fe200028f4416ULL,
0x0000000137137824ULL, 0x100fe200078e022fULL, 0x00005f0015237a11ULL, 0x000fe200010f4414ULL,
0x0000000135157824ULL, 0x100fe200078e022fULL, 0x00005f00171f7a11ULL, 0x000fe200018f4412ULL,
0x0000000133177824ULL, 0x000fe200078e022fULL, 0x000000110a197210ULL, 0x040fe40007f9e0ffULL,
0x000000130a137210ULL, 0x000fc40007fbe0ffULL, 0x000000150a157210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff327224ULL, 0x000fe200020e06ffULL, 0x000000170a117210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff307224ULL, 0x000fe200028e06ffULL, 0x00005e00191a7a11ULL, 0x000fe200078840ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005e0013187a11ULL, 0x000fe200078a40ffULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x00005e0015167a11ULL, 0x000fe400078440ffULL,
0x00005e0011147a11ULL, 0x000fc400078640ffULL, 0x00005f00191b7a11ULL, 0x000fe200020f4432ULL,
0x0000000143327824ULL, 0x000fe200078e0206ULL, 0x00005f0013197a11ULL, 0x000fe200028f4430ULL,
0x0000000147137824ULL, 0x000fe200078e0206ULL, 0x00005f0015177a11ULL, 0x000fe400010f442eULL,
0x000000104300720cULL, 0x040fe20003f46070ULL, 0x0000000843437824ULL, 0x000fe200078e00ffULL,
0x00005f0011157a11ULL, 0x000fe400018f4412ULL, 0x00000034473b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000706117812ULL, 0x000fe400078ec0ffULL, 0x000000104700720cULL, 0x080fe40003f66070ULL,
0x000000076a457812ULL, 0x000fe200078ef813ULL, 0x000000013b137824ULL, 0x000fe200078e022fULL,
0x000000104900720cULL, 0x000fe40003fa6070ULL, 0x000030000e2e7811ULL, 0x000fe400078e70ffULL,
0x0000000811317812ULL, 0x000fc400078efcffULL, 0xfffffff843497812ULL, 0x000fe200078ee232ULL,
0x0000001045457824ULL, 0x000fe200078e022eULL, 0x0000003847437810ULL, 0x000fe20007ffe0ffULL,
0x00000010311c7825ULL, 0x000fe200078e001cULL, 0x000000130a137210ULL, 0x040fe40007f9e0ffULL,
0x0000003c47537810ULL, 0x000fe20007ffe0ffULL, 0x0000000143477824ULL, 0x100fe200078e022fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c457faeULL, 0x0003e2000d901c46ULL,
0x000000ffff307224ULL, 0x000fe200020e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078840ffULL,
0x00000001532f7824ULL, 0x000fe200078e022fULL, 0x000000470a477210ULL, 0x040fe20007f7e0ffULL,
0x000000014d327824ULL, 0x000fe200078e0206ULL, 0x00005f0013137a11ULL, 0x000fe200020f4430ULL,
0x000000103d3d7824ULL, 0x000fe200078e022eULL, 0x000000104d00720cULL, 0x000fe20003f86070ULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x0000002f0a2f7210ULL, 0x000fe20007f7e0ffULL,
0x00000010312c7825ULL, 0x000fe200078e002cULL, 0x00005e00471c7a11ULL, 0x002fc400078c40ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee234ULL, 0x000000084d4d7824ULL, 0x000fe200078e00ffULL,
0x00005f00471d7a11ULL, 0x000fe200030f4430ULL, 0x000000103f3f7824ULL, 0x000fe200078e022eULL,
0x000000002c3d7faeULL, 0x0003e2000c901c46ULL, 0x00000010312a7825ULL, 0x000fe200078e002aULL,
0xfffffff84d457812ULL, 0x000fe400078ee232ULL, 0x000000104f00720cULL, 0x0c0fe20003f26070ULL,
0x000000014f307824ULL, 0x140fe200078e0206ULL, 0x000000002a3f7faeULL, 0x0005e2000c101c46ULL,
0x000000084f4f7824ULL, 0x000fe200078e00ffULL, 0x000000105100720cULL, 0x040fe20003f06070ULL,
0x0000000151327824ULL, 0x000fc400078e0206ULL, 0x0000000851517824ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x000000104100720cULL, 0x040fe20003f66070ULL,
0x0000000141347824ULL, 0x040fe400078e0206ULL, 0x0000000841477824ULL, 0x000fe200078e00ffULL,
0x00005e002f2a7a11ULL, 0x004fe200078c40ffULL, 0x00000010492d7824ULL, 0x002fe200078e022eULL,
0xfffffff84f3f7812ULL, 0x000fe200078ee230ULL, 0x0000001031287825ULL, 0x000fe200078e0028ULL,
0xfffffff851417812ULL, 0x000fc400078ee232ULL, 0x00005f002f2b7a11ULL, 0x000fe200030f440aULL,
0x000000104b2f7824ULL, 0x000fe200078e022eULL, 0xfffffff847477812ULL, 0x000fe200078ee234ULL,
0x0000001031207825ULL, 0x000fe200078e0020ULL, 0x00000000282d7faeULL, 0x0003e2000d101c46ULL,
0x000000103500720cULL, 0x080fe40003f46070ULL, 0x00000010453d7824ULL, 0x000fe200078e022eULL,
0x00000000202f7faeULL, 0x0005e2000e901c46ULL, 0x0000001031267825ULL, 0x000fe200078e0026ULL,
0x000000104300720cULL, 0x000fc40003fa6070ULL, 0x000000105300720cULL, 0x080fe20003fc6070ULL,
0x000000103f3f7824ULL, 0x000fe200078e022eULL, 0x00000000263d7faeULL, 0x0007e2000e101c46ULL,
0x0000001031247825ULL, 0x000fe200078e0024ULL, 0x000000103b00720cULL, 0x000fc60003f86070ULL,
0x0000001041417824ULL, 0x000fe200078e022eULL, 0x00000000243f7faeULL, 0x0009e2000c901c46ULL,
0x0000001031227825ULL, 0x000fe200078e0022ULL, 0x000000103700720cULL, 0x000fc60003f26070ULL,
0x0000001047457824ULL, 0x000fe200078e022eULL, 0x0000000022417faeULL, 0x0007e2000c101c46ULL,
0x00000010311e7825ULL, 0x000fe200078e001eULL, 0x000000103900720cULL, 0x000fc60003f06070ULL,
0x00000001390a7824ULL, 0x140fe200078e0206ULL, 0x000000001e457faeULL, 0x0007e2000d901c46ULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x000000103300720cULL, 0x000fe20003f66070ULL,
0x0000000135207824ULL, 0x104fe400078e0206ULL, 0x0000000137287824ULL, 0x002fe400078e0206ULL,
0x0000000835357824ULL, 0x000fe400078e00ffULL, 0x0000000837377824ULL, 0x000fc400078e00ffULL,
0x0000000833257824ULL, 0x010fe200078e00ffULL, 0xfffffff8391f7812ULL, 0x008fe200078ee20aULL,
0x00000001330a7824ULL, 0x000fe200078e0206ULL, 0xfffffff835237812ULL, 0x000fe200078ee220ULL,
0x000000013b107824ULL, 0x000fe200078e0206ULL, 0xfffffff837217812ULL, 0x000fe200078ee228ULL,
0x000000083b277824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee20aULL,
0x00000001431e7824ULL, 0x040fe400078e0206ULL, 0x0000000843297824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee210ULL, 0x0000000153207824ULL, 0x000fc400078e0206ULL,
0x00000008532d7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee21eULL,
0x000000101f1f7824ULL, 0x000fe400078e022eULL, 0x00000010311a7825ULL, 0x000fe200078e001aULL,
0xfffffff82d2d7812ULL, 0x000fc600078ee220ULL, 0x0000001021217824ULL, 0x000fe200078e022eULL,
0x000000001a1f7faeULL, 0x0003e2000c101c46ULL, 0x0000001031187825ULL, 0x000fc800078e0018ULL,
0x0000001023237824ULL, 0x000fe200078e022eULL, 0x0000000018217faeULL, 0x0003e2000c901c46ULL,
0x0000001031167825ULL, 0x000fc800078e0016ULL, 0x0000001025257824ULL, 0x000fe200078e022eULL,
0x0000000016237faeULL, 0x0003e2000d101c46ULL, 0x0000001031147825ULL, 0x000fc800078e0014ULL,
0x0000001027277824ULL, 0x000fe200078e022eULL, 0x0000000014257faeULL, 0x0003e2000d901c46ULL,
0x0000001031127825ULL, 0x000fc800078e0012ULL, 0x0000001029297824ULL, 0x000fe200078e022eULL,
0x0000000012277faeULL, 0x0003e2000e101c46ULL, 0x00000010311c7825ULL, 0x000fc800078e001cULL,
0x000000102d2d7824ULL, 0x000fe200078e022eULL, 0x000000001c297faeULL, 0x0003e2000e901c46ULL,
0x00000010312a7825ULL, 0x000fca00078e002aULL, 0x000000002a2d7faeULL, 0x0003e2000f101c46ULL,
0x00000c5000007947ULL, 0x000fea0003800000ULL, 0x0000000806147811ULL, 0x042fe400078fe8ffULL,
0x0000000406137811ULL, 0x040fe400078fe8ffULL, 0x0000002806377811ULL, 0x000fe200078fe8ffULL,
0x0000000114267824ULL, 0x100fe200078e0206ULL, 0x00000014061d7811ULL, 0x000fe200078fe8ffULL,
0x0000000814177824ULL, 0x000fe200078e00ffULL, 0x0000002406357811ULL, 0x040fe200078fe8ffULL,
0x00000001132a7824ULL, 0x040fe200078e0206ULL, 0x0000000c06157811ULL, 0x040fe200078fe8ffULL,
0x0000000813117824ULL, 0x000fe200078e00ffULL, 0xfffffff817267812ULL, 0x000fe200078ee226ULL,
0x0000000137287824ULL, 0x100fe200078e0206ULL, 0x0000001006177811ULL, 0x040fe200078fe8ffULL,
0x000000011d2e7824ULL, 0x000fe200078e0206ULL, 0xfffffff8112a7812ULL, 0x000fe200078ee22aULL,
0x000000081d197824ULL, 0x000fe200078e00ffULL, 0x00000034063b7811ULL, 0x040fe200078fe8ffULL,
0x0000000117307824ULL, 0x040fe200078e0206ULL, 0x0000001806227811ULL, 0x040fe200078fe8ffULL,
0x0000000817117824ULL, 0x000fe200078e00ffULL, 0xfffffff8192e7812ULL, 0x000fe200078ee22eULL,
0x0000000135297824ULL, 0x040fe200078e0206ULL, 0x0000002c06397811ULL, 0x040fe200078fe8ffULL,
0x0000000835127824ULL, 0x000fe200078e00ffULL, 0xfffffff811307812ULL, 0x000fe200078ee230ULL,
0x0000000837117824ULL, 0x000fe200078e00ffULL, 0x0000001c06237811ULL, 0x000fe200078fe8ffULL,
0x0000000115317824ULL, 0x040fe200078e0206ULL, 0xfffffff812297812ULL, 0x000fe200078ee229ULL,
0x0000000815107824ULL, 0x000fe200078e00ffULL, 0xfffffff811287812ULL, 0x000fe200078ee228ULL,
0x000000013b327824ULL, 0x140fe200078e0206ULL, 0x0000002f06117211ULL, 0x000fe200078fe8ffULL,
0x000000083b197824ULL, 0x000fe200078e00ffULL, 0xfffffff810317812ULL, 0x000fe200078ee231ULL,
0x00000001222d7824ULL, 0x000fe200078e0206ULL, 0x000000110a117210ULL, 0x000fe20007f1e0ffULL,
0x0000000822107824ULL, 0x000fe200078e00ffULL, 0xfffffff819327812ULL, 0x000fe200078ee232ULL,
0x0000000139277824ULL, 0x000fe200078e0206ULL, 0x0000002006347811ULL, 0x040fe200078fe8ffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x00005e0011187a11ULL, 0x000fe200078040ffULL,
0x0000000839167824ULL, 0x000fe200078e00ffULL, 0x00000030063a7811ULL, 0x000fe200078fe8ffULL,
0x0000000117177824ULL, 0x100fe200078e022fULL, 0x00005f0011197a11ULL, 0x000fe200000f4412ULL,
0x0000000113117824ULL, 0x000fe200078e022fULL, 0xfffffff8102d7812ULL, 0x000fe200078ee22dULL,
0x0000000114137824ULL, 0x000fe200078e022fULL, 0xfffffff816277812ULL, 0x000fe200078ee227ULL,
0x00000001232c7824ULL, 0x140fe200078e0206ULL, 0x000000110a117210ULL, 0x000fe20007f1e0ffULL,
0x00000008231b7824ULL, 0x000fe200078e00ffULL, 0x00000038063c7811ULL, 0x000fe200078fe8ffULL,
0x00000001342b7824ULL, 0x100fe200078e0206ULL, 0x000000130a137210ULL, 0x000fe20007f3e0ffULL,
0x0000000834107824ULL, 0x000fe200078e00ffULL, 0x000000170a177210ULL, 0x000fe20007f7e0ffULL,
0x000000013a337824ULL, 0x040fe200078e0206ULL, 0xfffffff81b2c7812ULL, 0x000fe200078ee22cULL,
0x000000083a167824ULL, 0x000fe200078e00ffULL, 0xfffffff8102b7812ULL, 0x000fe200078ee22bULL,
0x0000000115157824ULL, 0x000fe200078e022fULL, 0x0ffffff8066a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0xfffffff816337812ULL, 0x000fe200078ee233ULL,
0x000000013c107824ULL, 0x000fe200078e0206ULL, 0x000000150a157210ULL, 0x000fe20007f5e0ffULL,
0x000000083c1b7824ULL, 0x000fe200078e00ffULL, 0x00005e0011247a11ULL, 0x000fe200078040ffULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x00005e0013207a11ULL, 0x000fe200078240ffULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x00005e00171a7a11ULL, 0x000fe200078640ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005f0011257a11ULL, 0x000fe200000f441cULL,
0x000000011d117824ULL, 0x000fe200078e022fULL, 0xfffffff81b107812ULL, 0x000fc400078ee210ULL,
0x00005e00151e7a11ULL, 0x000fe400078440ffULL, 0x00005f0013217a11ULL, 0x000fe200008f4416ULL,
0x0000000122137824ULL, 0x100fe200078e022fULL, 0x00005f00171b7a11ULL, 0x000fe200018f4412ULL,
0x0000000134177824ULL, 0x100fe200078e022fULL, 0x00005f00151f7a11ULL, 0x000fe200010f4414ULL,
0x0000000123157824ULL, 0x000fe200078e022fULL, 0x000000110a1d7210ULL, 0x040fe40007f1e0ffULL,
0x000000130a137210ULL, 0x000fc40007f3e0ffULL, 0x000000170a117210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x000000150a157210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff367224ULL, 0x000fe200008e06ffULL, 0x00005e001d227a11ULL, 0x000fe200078040ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x00005e00131c7a11ULL, 0x000fe200078240ffULL,
0x000000ffff347224ULL, 0x000fe200010e06ffULL, 0x00005e0011127a11ULL, 0x000fe400078640ffULL,
0x00005f001d237a11ULL, 0x000fc400000f4438ULL, 0x00005e0015167a11ULL, 0x000fe400078440ffULL,
0x00005f00131d7a11ULL, 0x000fe400008f4436ULL, 0x00005f0011137a11ULL, 0x000fe200018f4414ULL,
0x0000000135117824ULL, 0x100fe200078e022fULL, 0x0000003c06147811ULL, 0x000fe200078fe8ffULL,
0x0000000139357824ULL, 0x100fe200078e022fULL, 0x00005f0015177a11ULL, 0x000fe200010f4434ULL,
0x0000000137157824ULL, 0x100fe200078e022fULL, 0x000000110a117210ULL, 0x000fe20007fde0ffULL,
0x000000013b397824ULL, 0x100fe200078e022fULL, 0x000030000e517811ULL, 0x000fe200078e70ffULL,
0x000000013a377824ULL, 0x100fe200078e022fULL, 0x000000350a3a7210ULL, 0x000fe20007f9e0ffULL,
0x000000013c3b7824ULL, 0x100fe200078e022fULL, 0x000000150a3c7210ULL, 0x000fe20007fbe0ffULL,
0x00000001142f7824ULL, 0x000fe200078e022fULL, 0x000000370a387210ULL, 0x000fe20007f7e0ffULL,
0x0000000814407824ULL, 0x000fe200078e00ffULL, 0x000000390a367210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200030e06ffULL, 0x0000003b0a347210ULL, 0x040fe20007f5e0ffULL,
0x0000001029477824ULL, 0x100fe200078e0251ULL, 0x0000002f0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00000001142f7824ULL, 0x000fe200078e0206ULL, 0x0000000606157211ULL, 0x000fe200078fe8ffULL,
0x00000010303d7824ULL, 0x100fe200078e0251ULL, 0x00005e0011147a11ULL, 0x000fe200078c40ffULL,
0x00000010274b7824ULL, 0x000fe200078e0251ULL, 0x000000076a357812ULL, 0x000fe200078ef815ULL,
0x000000ffff297224ULL, 0x000fe200028e06ffULL, 0x00005f0011157a11ULL, 0x000fe200030f443eULL,
0x000000102e3f7824ULL, 0x100fe200078e0251ULL, 0x0000000706117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff277224ULL, 0x000fe200020e06ffULL, 0x00005e003c307a11ULL, 0x000fe200078a40ffULL,
0x0000001035357824ULL, 0x100fe200078e0251ULL, 0x0000000811537812ULL, 0x000fe200078efcffULL,
0x000000102a377824ULL, 0x100fe200078e0251ULL, 0x00005e003a2e7a11ULL, 0x000fe200078840ffULL,
0x000000102d417824ULL, 0x000fe200078e0251ULL, 0xfffffff840407812ULL, 0x000fe200078ee22fULL,
0x0000001053187825ULL, 0x000fe200078e0018ULL, 0x00005f003a2f7a11ULL, 0x000fc600020f4427ULL,
0x0000001053247825ULL, 0x000fe200078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018357faeULL, 0x0003e6000b901c46ULL, 0x0000001026397824ULL, 0x100fe200078e0251ULL,
0x0000000024377faeULL, 0x0003e2000b901c46ULL, 0x00000010313b7824ULL, 0x000fe200078e0251ULL,
0x00005f003c317a11ULL, 0x000fe200028f4429ULL, 0x000000102c437824ULL, 0x100fe400078e0251ULL,
0x000000102b457824ULL, 0x000fc400078e0251ULL, 0x000000ffff2d7224ULL, 0x000fe200018e06ffULL,
0x00005e00382c7a11ULL, 0x000fe200078640ffULL, 0x0000001053207825ULL, 0x000fc600078e0020ULL,
0x00005f00382d7a11ULL, 0x000fe200018f442dULL, 0x000000ffff2b7224ULL, 0x000fe200000e06ffULL,
0x00005e00362a7a11ULL, 0x040fe200078040ffULL, 0x00000010531e7825ULL, 0x040fe200078e001eULL,
0x0000000020397faeULL, 0x0003e4000b901c46ULL, 0x00005f00362b7a11ULL, 0x000fe200000f442bULL,
0x0000001028497824ULL, 0x000fe200078e0251ULL, 0x000000001e3b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x00005e0034287a11ULL, 0x000fe200078440ffULL,
0x00000010531a7825ULL, 0x000fc600078e001aULL, 0x00005f0034297a11ULL, 0x000fe200010f4429ULL,
0x000000ffff277224ULL, 0x000fe200008e06ffULL, 0x00005e000a267a11ULL, 0x040fe200078240ffULL,
0x0000001053227825ULL, 0x040fe200078e0022ULL, 0x000000001a3d7faeULL, 0x0003e4000b901c46ULL,
0x00005f000a277a11ULL, 0x000fe200008f4427ULL, 0x00000010531c7825ULL, 0x040fe200078e001cULL,
0x00000000223f7faeULL, 0x0003e6000b901c46ULL, 0x0000001053167825ULL, 0x040fe200078e0016ULL,
0x000000001c417faeULL, 0x0003e6000b901c46ULL, 0x0000001053127825ULL, 0x040fe200078e0012ULL,
0x0000000016437faeULL, 0x0003e6000b901c46ULL, 0x0000001053147825ULL, 0x040fe200078e0014ULL,
0x0000000012457faeULL, 0x0003e6000b901c46ULL, 0x0000001053307825ULL, 0x040fe200078e0030ULL,
0x0000000014477faeULL, 0x0003e6000b901c46ULL, 0x00000010532e7825ULL, 0x000fe200078e002eULL,
0x0000000030497faeULL, 0x0003e6000b901c46ULL, 0x0000001033337824ULL, 0x000fe200078e0251ULL,
0x000000002e4b7faeULL, 0x0003e2000b901c46ULL, 0x00000010532c7825ULL, 0x000fc800078e002cULL,
0x00000010324d7824ULL, 0x000fe200078e0251ULL, 0x000000002c337faeULL, 0x0003e2000b901c46ULL,
0x00000010532a7825ULL, 0x000fc800078e002aULL, 0x00000010104f7824ULL, 0x000fe200078e0251ULL,
0x000000002a4d7faeULL, 0x0003e2000b901c46ULL, 0x0000001053287825ULL, 0x000fc800078e0028ULL,
0x0000001040517824ULL, 0x000fe200078e0251ULL, 0x00000000284f7faeULL, 0x0003e2000b901c46ULL,
0x0000001053267825ULL, 0x000fca00078e0026ULL, 0x0000000026517faeULL, 0x0003e4000b901c46ULL,
0x00000300ff137624ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff0a7424ULL, 0x000fe400078e00ffULL, 0x00000002130c7824ULL, 0x000fca00078e020cULL,
0x0000000d0c00720cULL, 0x000fda0003f06070ULL, 0x0000000205128824ULL, 0x000fe400078e020cULL,
0x00000004ff138424ULL, 0x000fe200078e00ffULL, 0x00000004ff157819ULL, 0x000fe20000011606ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600012128625ULL, 0x000fca00078e0013ULL,
0x00000006120a8981ULL, 0x000322000c1e1900ULL, 0x00000008115e7812ULL, 0x000fe200078ef806ULL,
0xffffffff00007948ULL, 0x000fe80003800000ULL, 0x00000001155f7824ULL, 0x000fe400078e025eULL,
0x000000105e107824ULL, 0x000fca00078e00ffULL, 0xfffffff010107812ULL, 0x000fca00078ee25fULL,
0x0000001010107824ULL, 0x000fc400078e00ffULL, 0x00000008153c7824ULL, 0x002fe200078e00ffULL,
0x00000003ff6b7819ULL, 0x000fe20000011606ULL, 0x000040000e6d7824ULL, 0x000fe200078e00ffULL,
0x00000000102c783bULL, 0x0003e20000000200ULL, 0x000000105e137824ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee211ULL, 0x000000016b117812ULL, 0x000fe400078ec0ffULL,
0x000010006d6c7810ULL, 0x000fe20007ffe0ffULL, 0x000000083c127824ULL, 0x040fe200078e00ffULL,
0x000000103c3a7810ULL, 0x040fe20007ffe0ffULL, 0x00000001113b7824ULL, 0x040fe200078e023cULL,
0x000000203c397810ULL, 0x040fe20007ffe0ffULL, 0x000000083c157824ULL, 0x040fe200078e00ffULL,
0x000000303c387810ULL, 0x000fe20007ffe0ffULL, 0x0000000111697824ULL, 0x000fe200078e023aULL,
0xfffffff8126f7812ULL, 0x000fe200078ee23bULL, 0x000000083a147824ULL, 0x000fe200078e00ffULL,
0x000000023b667810ULL, 0x000fe20007ffe0ffULL, 0x0000000111687824ULL, 0x000fe200078e0239ULL,
0x000000025f127810ULL, 0x000fe20007ffe0ffULL, 0x000000106f1c7824ULL, 0x000fe200078e026cULL,
0xfffffff815667812ULL, 0x000fe200078ee266ULL, 0x0000000111677824ULL, 0x000fe200078e0238ULL,
0xfffffff013127812ULL, 0x000fe200078ee212ULL, 0x0000000838107824ULL, 0x002fe200078e00ffULL,
0xfffffff814697812ULL, 0x000fe200078ee269ULL, 0x000000001c1c783bULL, 0x000e620000000200ULL,
0x0000000839117824ULL, 0x000fe200078e00ffULL, 0x000000123b657810ULL, 0x000fe20007ffe0ffULL,
0x0000001066507824ULL, 0x000fe200078e026cULL, 0xfffffff810677812ULL, 0x000fe200078ee267ULL,
0x0000001012127824ULL, 0x000fe200078e00ffULL, 0xfffffff811687812ULL, 0x000fe200078ee268ULL,
0x0000001069347824ULL, 0x100fe200078e026cULL, 0x000000223b647810ULL, 0x000fe20007ffe0ffULL,
0x0000001067307824ULL, 0x100fe200078e026cULL, 0x000000001228783bULL, 0x000fe20000000200ULL,
0x0000001068107824ULL, 0x000fe200078e026cULL, 0xfffffff814657812ULL, 0x000fe200078ee265ULL,
0x0000000839157824ULL, 0x000fe200078e00ffULL, 0x000000005050783bULL, 0x000fe20000000200ULL,
0x000000323b627810ULL, 0x040fe20007ffe0ffULL, 0x00000008383e7824ULL, 0x000fe200078e00ffULL,
0x000000043b637810ULL, 0x000fe20007ffe0ffULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0xfffffff815647812ULL, 0x000fe200078ee264ULL, 0x0000001065187824ULL, 0x100fe200078e026cULL,
0x000000143b617810ULL, 0x040fe20007ffe0ffULL, 0x000000003030783bULL, 0x000ee20000000200ULL,
0x000000243b607810ULL, 0x040fe20007ffe0ffULL, 0x0000001064207824ULL, 0x000fe200078e026cULL,
0x000000343b5d7810ULL, 0x040fe20007ffe0ffULL, 0x000000001010783bULL, 0x000ee20000000200ULL,
0x000000063b5c7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff83e5d7812ULL, 0x000fe200078ee25dULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x000000163b5b7810ULL, 0x040fe40007ffe0ffULL,
0x000000263b5a7810ULL, 0x000fe20007ffe0ffULL, 0x000000002020783bULL, 0x000ee20000000200ULL,
0x000000105d447824ULL, 0x000fe200078e026cULL, 0x000000363b597810ULL, 0x000fe20007ffe0ffULL,
0x0000001c2c54723cULL, 0x042f6800000418ffULL, 0x000000004444783bULL, 0x000fe80000000200ULL,
0x0000001e2c1c723cULL, 0x040f7000000418ffULL, 0x000000342c14723cULL, 0x004f7000000418ffULL,
0x000000502854723cULL, 0x060ff00000041854ULL, 0x000000522850723cULL, 0x000ff0000004181cULL,
0x000000302c24723cULL, 0x048bee00000418ffULL, 0x0000000838317824ULL, 0x060fe200078e00ffULL,
0x000000362c34723cULL, 0x000f6200000418ffULL, 0x0000000838387824ULL, 0x000fc600078e00ffULL,
0xfffffff831627812ULL, 0x000fe400078ee262ULL, 0xfffffff838597812ULL, 0x000fe400078ee259ULL,
0x000000102c1c723cULL, 0x000f6200000418ffULL, 0x0000001062307824ULL, 0x000fce00078e026cULL,
0x000000122c10723cULL, 0x040f7000000418ffULL, 0x000000322c2c723cULL, 0x000b6400000418ffULL,
0x000000003030783bULL, 0x020e6c0000000200ULL, 0x000000182814723cULL, 0x040f700000041814ULL,
0x0000001a2818723cULL, 0x040b6e0000041834ULL, 0x000000083a367824ULL, 0x020fe200078e00ffULL,
0x00000020281c723cULL, 0x040b62000004181cULL, 0x000000105e357824ULL, 0x000fe200078e00ffULL,
0x000000045f347810ULL, 0x000fe20007ffe0ffULL, 0x000000083c377824ULL, 0x000fe200078e00ffULL,
0xfffffff836617812ULL, 0x000fe200078ee261ULL, 0x000000083a3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff035347812ULL, 0x000fe200078ee234ULL, 0x000000083c207824ULL, 0x020fe200078e00ffULL,
0x000000065f357810ULL, 0x000fe20007ffe0ffULL, 0x0000000839217824ULL, 0x000fe200078e00ffULL,
0xfffffff8375c7812ULL, 0x000fe200078ee25cULL, 0x00000010614c7824ULL, 0x000fe200078e026cULL,
0xfffffff820637812ULL, 0x000fe200078ee263ULL, 0x0000001034347824ULL, 0x000fe200078e00ffULL,
0xfffffff821607812ULL, 0x000fe200078ee260ULL, 0x0000000839397824ULL, 0x000fe200078e00ffULL,
0x000000222820723cULL, 0x040b620000041810ULL, 0x000000004c4c783bULL, 0x000fe20000000200ULL,
0x000000105e367824ULL, 0x000fe200078e00ffULL, 0xfffffff83a5b7812ULL, 0x000fe200078ee25bULL,
0x0000001060487824ULL, 0x000fe200078e026cULL, 0x000000003440783bULL, 0x0004e20000000200ULL,
0xfffffff8395a7812ULL, 0x000fe200078ee25aULL, 0x0000001063107824ULL, 0x120fe200078e026cULL,
0xfffffff036357812ULL, 0x000fe200078ee235ULL, 0x000000302824723cULL, 0x002b620000041824ULL,
0x000000004848783bULL, 0x000fe20000000200ULL, 0x000000105c3c7824ULL, 0x000fc400078e026cULL,
0x000000105b387824ULL, 0x100fe200078e026cULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x000000105a347824ULL, 0x104fe400078e026cULL, 0x000000322828723cULL, 0x000b64000004182cULL,
0x0000001059307824ULL, 0x020fe200078e026cULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x00000010356e7824ULL, 0x000fc600078e00ffULL, 0x000000003838783bULL, 0x000fe80000000200ULL,
0x000000006e2c783bULL, 0x000ea80000000200ULL, 0x000000003434783bULL, 0x000ea80000000200ULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x0000004c4014723cULL, 0x048bee0000041814ULL,
0x00000300584c7a10ULL, 0x020fe20007ffe0ffULL, 0x0000004e4018723cULL, 0x040ff00000041818ULL,
0x000000104054723cULL, 0x042b6e0000041854ULL, 0x000000014c107810ULL, 0x020fe20007ffe0ffULL,
0x000000124050723cULL, 0x000b660000041850ULL, 0x0000000b1000720cULL, 0x000fc80003f06070ULL,
0x000001004c127824ULL, 0x020fe200078e0209ULL, 0x00000048401c723cULL, 0x000f68000004181cULL,
0x0000004012117812ULL, 0x000fc800078ec0ffULL, 0x0000004a4020723cULL, 0x040f700000041820ULL,
0x000000444024723cULL, 0x040f700000041824ULL, 0x000000464028723cULL, 0x000f700000041828ULL,
0x0000003c2c54723cULL, 0x044f700000041854ULL, 0x0000003e2c50723cULL, 0x040f700000041850ULL,
0x000000382c14723cULL, 0x040f700000041814ULL, 0x0000003a2c18723cULL, 0x040f700000041818ULL,
0x000000342c1c723cULL, 0x060b6e000004181cULL, 0x0000000108347824ULL, 0x020fe200078e0211ULL,
0x000000362c20723cULL, 0x040f700000041820ULL, 0x000000302c24723cULL, 0x040f700000041824ULL,
0x000000322c28723cULL, 0x000b6e0000041828ULL, 0x000000070a2f7224ULL, 0x030fe200078e02ffULL,
0x00000e6000008947ULL, 0x000fca0003800000ULL, 0x000000016b117824ULL, 0x000fe200078e0206ULL,
0x000000120f367217ULL, 0x000fe20007800000ULL, 0x00000010062e7824ULL, 0x000fe200078e00ffULL,
0x000000046b137810ULL, 0x000fc40007ffe0ffULL, 0x000000076a337812ULL, 0x000fe200078ef811ULL,
0x0000000136367824ULL, 0x000fe200078e0a12ULL, 0x000000086b117810ULL, 0x000fe20007ffe0ffULL,
0x00000001133d7824ULL, 0x100fe200078e0206ULL, 0x0000000c6b357810ULL, 0x000fe20007ffe0ffULL,
0x0000000813107824ULL, 0x040fe200078e00ffULL, 0x000000361300720cULL, 0x080fe20003f66070ULL,
0x0000000111397824ULL, 0x140fe200078e0206ULL, 0x000000361100720cULL, 0x0c0fe20003f86070ULL,
0x0000000811127824ULL, 0x000fe200078e00ffULL, 0xfffffff8103d7812ULL, 0x000fe200078ee23dULL,
0x0000000135317824ULL, 0x040fe200078e0206ULL, 0x000000363500720cULL, 0x040fe20003fa6070ULL,
0x00000008352c7824ULL, 0x000fe200078e00ffULL, 0xfffffff812397812ULL, 0x000fe200078ee239ULL,
0x000000016b107824ULL, 0x140fe200078e0234ULL, 0x000000106b417810ULL, 0x000fe20007ffe0ffULL,
0x0000000113127824ULL, 0x000fe200078e0234ULL, 0xfffffff82c317812ULL, 0x000fe200078ee231ULL,
0x0000001033337824ULL, 0x000fe200078e026cULL, 0x000000102f307210ULL, 0x000fe20007f1e0ffULL,
0x0000000111107824ULL, 0x100fe200078e0234ULL, 0x000000122f2c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000135127824ULL, 0x000fe200078e0234ULL, 0x000000702e2e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e0030137a11ULL, 0x000fe200078040ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x00005e002c3b7a11ULL, 0x000fe200078240ffULL,
0x0000000141327824ULL, 0x040fe200078e0206ULL, 0x00005f0030307a11ULL, 0x000fe200000f442dULL,
0x0000000841437824ULL, 0x000fe200078e00ffULL, 0x000000102f107210ULL, 0x000fe20007f1e0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e026cULL, 0x00005f002c2c7a11ULL, 0x000fe200008f4411ULL,
0x0000001039397824ULL, 0x000fe200078e026cULL, 0x000000122f127210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff377224ULL, 0x000fe200000e06ffULL, 0x00005e00102d7a11ULL, 0x000fc400078040ffULL,
0x000000186b457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00005e0012357a11ULL, 0x000fe400078240ffULL, 0x00005f0010377a11ULL, 0x000fe200000f4437ULL,
0x0000000141107824ULL, 0x000fe200078e0234ULL, 0x00005f00123a7a11ULL, 0x000fe200008f4411ULL,
0x00000001453c7824ULL, 0x000fe200078e0206ULL, 0x000000132e127210ULL, 0x000fe40007f1e0ffULL,
0x000000102f107210ULL, 0x000fc40007f5e0ffULL, 0x000000366b00720cULL, 0x080fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200000e0630ULL, 0x000000364100720cULL, 0x000fe20003f06070ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0xfffffff843417812ULL, 0x000fe400078ee232ULL,
0x000000146b437810ULL, 0x000fe40007ffe0ffULL, 0x00005e00103f7a11ULL, 0x040fe200078440ffULL,
0x0000001041417824ULL, 0x000fe200078e026cULL, 0x000000206b4b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000143307824ULL, 0x040fe200078e0234ULL, 0x00005f0010327a11ULL, 0x000fe200010f4411ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012337faeULL, 0x0003e2000c901c46ULL,
0x0000003b2e107210ULL, 0x040fe20007f5e0ffULL, 0x00000001433b7824ULL, 0x000fe200078e0206ULL,
0x000000302f387210ULL, 0x000fe20007fde0ffULL, 0x0000000145307824ULL, 0x000fe200078e0234ULL,
0x000000364300720cULL, 0x040fe20003f26070ULL, 0x000000ffff117224ULL, 0x000fe200010e062cULL,
0x0000002d2e2c7210ULL, 0x000fe20007f5e0ffULL, 0x00000008433e7824ULL, 0x000fe200078e00ffULL,
0x0000001c6b497810ULL, 0x000fe20007ffe0ffULL, 0x0000000845437824ULL, 0x000fe200078e00ffULL,
0x00000000103d7faeULL, 0x0005e2000d901c46ULL, 0x000000ffff337224ULL, 0x002fe200030e06ffULL,
0x00005e0038477a11ULL, 0x000fe200078c40ffULL, 0x000000ffff2d7224ULL, 0x000fe200010e0637ULL,
0x000000352e127210ULL, 0x000fe20007f5e0ffULL, 0x0000000149357824ULL, 0x100fe200078e0206ULL,
0x00005f0038387a11ULL, 0x000fe200030f4433ULL, 0x000000014b337824ULL, 0x000fe200078e0206ULL,
0x000000302f307210ULL, 0x000fe20007fde0ffULL, 0x000000ffff137224ULL, 0x000fe200010e063aULL,
0x000000364500720cULL, 0x080fe20003f46070ULL, 0x00000008493a7824ULL, 0x000fe200078e00ffULL,
0xfffffff843377812ULL, 0x000fe200078ee23cULL, 0x000000ffff457224ULL, 0x000fe200030e06ffULL,
0x00005e0030437a11ULL, 0x000fe200078c40ffULL, 0x000000084b3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3b7812ULL, 0x000fe200078ee23bULL, 0x000000002c397faeULL, 0x0003e2000e101c46ULL,
0x00005f00303e7a11ULL, 0x000fe200030f4445ULL, 0x0000001031457824ULL, 0x000fe200078e026cULL,
0xfffffff83c337812ULL, 0x000fe200078ee233ULL, 0x0000000149307824ULL, 0x100fe200078e0234ULL,
0xfffffff83a357812ULL, 0x000fe200078ee235ULL, 0x000000014b3a7824ULL, 0x000fe200078e0234ULL,
0x0000000012457faeULL, 0x0007e2000e901c46ULL, 0x000000364900720cULL, 0x000fe20003f66070ULL,
0x0000001037377824ULL, 0x100fe200078e026cULL, 0x000000302f3c7210ULL, 0x000fe20007fde0ffULL,
0x0000001035357824ULL, 0x000fe200078e026cULL, 0x000000246b497810ULL, 0x000fc40007ffe0ffULL,
0x0000003f2e307210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2d7224ULL, 0x002fe200030e06ffULL,
0x0000003a2f3a7210ULL, 0x000fe20007fde0ffULL, 0x00000001493f7824ULL, 0x000fe200078e0206ULL,
0x000000286b3d7810ULL, 0x004fe20007ffe0ffULL, 0x0000000849107824ULL, 0x000fe200078e00ffULL,
0x000000364b00720cULL, 0x000fe20003f86070ULL, 0x000000ffff317224ULL, 0x000fe200028e0632ULL,
0x00005e003c117a11ULL, 0x000fe200078a40ffULL, 0x000000ffff137224ULL, 0x008fe200030e06ffULL,
0xfffffff810397812ULL, 0x000fe200078ee23fULL, 0x0000000149107824ULL, 0x000fe200078e0234ULL,
0x0000000030417faeULL, 0x0003e2000c101c46ULL, 0x00005e003a3f7a11ULL, 0x000fc400078c40ffULL,
0x000000472e127210ULL, 0x000fe20007f1e0ffULL, 0x0000001039397824ULL, 0x000fe200078e026cULL,
0x00005f003a3a7a11ULL, 0x000fe400030f4413ULL, 0x0000002c6b477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0638ULL, 0x000000102f387210ULL, 0x000fe20007fde0ffULL,
0x000000013d107824ULL, 0x040fe200078e0234ULL, 0x000000432e2c7210ULL, 0x000fe40007f1e0ffULL,
0x00005f003c327a11ULL, 0x000fe200028f442dULL, 0x000000ffff317224ULL, 0x002fe200030e06ffULL,
0x00005e0038457a11ULL, 0x040fe200078c40ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e063eULL,
0x000000363d00720cULL, 0x040fe20003f06070ULL, 0x000000013d3c7824ULL, 0x040fe200078e0206ULL,
0x00005f0038307a11ULL, 0x000fe200030f4431ULL, 0x000000083d3d7824ULL, 0x000fe200078e00ffULL,
0x000000102f107210ULL, 0x000fe20007fde0ffULL, 0x000000103b317824ULL, 0x000fe200078e026cULL,
0x000000364900720cULL, 0x080fe20003fa6070ULL, 0x0000000147387824ULL, 0x000fe200078e0206ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee23cULL, 0x000000ffff417224ULL, 0x000fe200030e06ffULL,
0x00005e0010437a11ULL, 0x040fe200078c40ffULL, 0x0000000012317faeULL, 0x0003e2000c901c46ULL,
0x0000000847497824ULL, 0x040fe200078e00ffULL, 0x000000364700720cULL, 0x000fe20003f26070ULL,
0x000000103d3d7824ULL, 0x000fe200078e026cULL, 0x00005f00103e7a11ULL, 0x000fe200030f4441ULL,
0x0000000147107824ULL, 0x000fe200078e0234ULL, 0x000000002c377faeULL, 0x0005e2000d101c46ULL,
0xfffffff8493b7812ULL, 0x000fc400078ee238ULL, 0x000000306b497810ULL, 0x000fe40007ffe0ffULL,
0x000000102f3c7210ULL, 0x000fe20007fde0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e026cULL,
0x000000112e107210ULL, 0x000fe20007f5e0ffULL, 0x0000000149387824ULL, 0x000fe200078e0206ULL,
0x000000346b477810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x002fe200030e06ffULL,
0x00005e003c317a11ULL, 0x000fe200078c40ffULL, 0x000000ffff117224ULL, 0x000fe200010e0632ULL,
0x0000003f2e127210ULL, 0x000fe20007f5e0ffULL, 0x0000000849417824ULL, 0x040fe200078e00ffULL,
0x00005f003c3c7a11ULL, 0x000fe200030f4413ULL, 0x0000000149327824ULL, 0x000fe200078e0234ULL,
0x0000000010357faeULL, 0x0003e2000d901c46ULL, 0x000000ffff137224ULL, 0x000fe200010e063aULL,
0x000000452e2c7210ULL, 0x044fe20007f5e0ffULL, 0x00000008474b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8413f7812ULL, 0x000fe200078ee238ULL, 0x0000001033417824ULL, 0x000fe200078e026cULL,
0x000000386b457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200010e0630ULL,
0x000000322f387210ULL, 0x000fe20007f5e0ffULL, 0x000000103f3f7824ULL, 0x000fe200078e026cULL,
0x000000432e307210ULL, 0x040fe20007f7e0ffULL, 0x0000000012417faeULL, 0x0005e2000e101c46ULL,
0x000000312e327210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x002fe200010e06ffULL,
0x0000003c6b6b7810ULL, 0x000fe20007ffe0ffULL, 0x000000002c397faeULL, 0x0003e2000e901c46ULL,
0x000000ffff317224ULL, 0x000fe200018e063eULL, 0x000000364900720cULL, 0x080fe20003fa6070ULL,
0x000000ffff337224ULL, 0x000fe200030e063cULL, 0x000000364700720cULL, 0x0c0fe20003f86070ULL,
0x0000000147107824ULL, 0x100fe200078e0234ULL, 0x00000000303d7faeULL, 0x0007e2000c101c46ULL,
0x000000364500720cULL, 0x0c0fe20003f66070ULL, 0x0000000145127824ULL, 0x004fe200078e0234ULL,
0x000000366b00720cULL, 0x000fe20003f46070ULL, 0x00000000323b7faeULL, 0x0005e2000c901c46ULL,
0x000000102f367210ULL, 0x000fe20007f3e0ffULL, 0x00000008452c7824ULL, 0x002fe200078e00ffULL,
0x00005e00382d7a11ULL, 0x040fe200078c40ffULL, 0x000000016b137824ULL, 0x100fe200078e0206ULL,
0x000000122f107210ULL, 0x000fe20007f1e0ffULL, 0x000000086b3a7824ULL, 0x000fe200078e00ffULL,
0x00005f0038387a11ULL, 0x000fe200030f4411ULL, 0x0000000145117824ULL, 0x000fe200078e0206ULL,
0x0000000647407210ULL, 0x000fe20007ffe0ffULL, 0x000000016b347824ULL, 0x000fe200078e0234ULL,
0xfffffff83a137812ULL, 0x000fe200078ee213ULL, 0x000000ffff357224ULL, 0x000fe200000e06ffULL,
0xfffffff82c317812ULL, 0x008fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00005e0036397a11ULL, 0x040fe200078240ffULL, 0x0000001013337824ULL, 0x104fe200078e026cULL,
0x000000342f347210ULL, 0x000fe20007fde0ffULL, 0x0000001031317824ULL, 0x000fe200078e026cULL,
0x00005f0036367a11ULL, 0x000fc400008f4411ULL, 0x0000002d2e2c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200030e06ffULL, 0x00005e0010137a11ULL, 0x000fe400078040ffULL,
0x00005e00342f7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff2d7224ULL, 0x000fe200008e0638ULL,
0x000000392e127210ULL, 0x000fe40007f3e0ffULL, 0x00005f0010327a11ULL, 0x000fe400000f4435ULL,
0xfffffff84b377812ULL, 0x000fe200078ee240ULL, 0x000000002c3f7faeULL, 0x0003e2000e901c46ULL,
0x000000132e107210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0636ULL,
0x00005f0034307a11ULL, 0x000fe200030f4411ULL, 0x0000001037377824ULL, 0x000fe200078e026cULL,
0x0000002f2e2e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff117224ULL, 0x000fc600000e0632ULL,
0x0000000012377faeULL, 0x0003e2000e101c46ULL, 0x000000ffff2f7224ULL, 0x000fc600008e0630ULL,
0x0000000010317faeULL, 0x0003e8000d901c46ULL, 0x000000002e337faeULL, 0x0003e2000d101c46ULL,
0x00000d3000007947ULL, 0x000fea0003800000ULL, 0x000000046b457810ULL, 0x040fe20007ffe0ffULL,
0x000000016b7b7824ULL, 0x140fe200078e0206ULL, 0x000000086b437810ULL, 0x040fe40007ffe0ffULL,
0x0000000c6b2c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000145797824ULL, 0x100fe200078e0206ULL,
0x0000001c6b417810ULL, 0x000fe20007ffe0ffULL, 0x0000000845107824ULL, 0x000fe200078e00ffULL,
0x000000146b117810ULL, 0x000fe20007ffe0ffULL, 0x0000000143357824ULL, 0x100fe200078e0206ULL,
0x000000186b137810ULL, 0x000fe20007ffe0ffULL, 0x0000000843127824ULL, 0x000fe200078e00ffULL,
0xfffffff810797812ULL, 0x000fe200078ee279ULL, 0x000000012c777824ULL, 0x140fe200078e0206ULL,
0x000000206b2d7810ULL, 0x000fe20007ffe0ffULL, 0x000000082c107824ULL, 0x000fe200078e00ffULL,
0xfffffff812357812ULL, 0x000fe200078ee235ULL, 0x0000000141757824ULL, 0x100fe200078e0206ULL,
0x000000106b127810ULL, 0x000fe20007ffe0ffULL, 0x0000000111397824ULL, 0x100fe200078e0206ULL,
0xfffffff810777812ULL, 0x000fe200078ee277ULL, 0x0000000841107824ULL, 0x000fe200078e00ffULL,
0x000000246b337810ULL, 0x040fe20007ffe0ffULL, 0x0000000112377824ULL, 0x040fe200078e0206ULL,
0x000000286b497810ULL, 0x000fe20007ffe0ffULL, 0x00000008122e7824ULL, 0x000fe200078e00ffULL,
0xfffffff810757812ULL, 0x000fe200078ee275ULL, 0x0000000811307824ULL, 0x000fe200078e00ffULL,
0x0000002c6b3f7810ULL, 0x040fe20007ffe0ffULL, 0x000000016b107824ULL, 0x000fe200078e0234ULL,
0xfffffff82e377812ULL, 0x000fe200078ee237ULL, 0x00000001133b7824ULL, 0x140fe200078e0206ULL,
0xfffffff830397812ULL, 0x000fe200078ee239ULL, 0x0000000813327824ULL, 0x000fe200078e00ffULL,
0x000000102f107210ULL, 0x000fe20007f1e0ffULL, 0x000000012d737824ULL, 0x100fe200078e0206ULL,
0x000000306b317810ULL, 0x000fe20007ffe0ffULL, 0x000000082d2e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8323b7812ULL, 0x000fe200078ee23bULL, 0x0000000133717824ULL, 0x100fe200078e0206ULL,
0x000000346b7d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000833307824ULL, 0x000fe200078e00ffULL,
0xfffffff82e737812ULL, 0x000fe200078ee273ULL, 0x00000001493d7824ULL, 0x140fe200078e0206ULL,
0x000000076a7b7812ULL, 0x000fe200078ef87bULL, 0x0000000849327824ULL, 0x000fe200078e00ffULL,
0xfffffff830717812ULL, 0x000fe200078ee271ULL, 0x000000ffff2e7224ULL, 0x000fe200000e06ffULL,
0x00005e0010477a11ULL, 0x000fe200078040ffULL, 0x000000013f4f7824ULL, 0x040fe200078e0206ULL,
0xfffffff8323d7812ULL, 0x000fe200078ee23dULL, 0x000000083f307824ULL, 0x000fe200078e00ffULL,
0x00005f0010107a11ULL, 0x000fe200000f442eULL, 0x00000001314d7824ULL, 0x000fc400078e0206ULL,
0x0000000831327824ULL, 0x000fe200078e00ffULL, 0xfffffff8304f7812ULL, 0x000fe200078ee24fULL,
0x00000001452e7824ULL, 0x100fe400078e0234ULL, 0x000000012c2c7824ULL, 0x100fe200078e0234ULL,
0xfffffff8324d7812ULL, 0x000fe200078ee24dULL, 0x0000000143307824ULL, 0x100fe200078e0234ULL,
0x0000002e2f2e7210ULL, 0x040fe20007f1e0ffULL, 0x0000000112127824ULL, 0x000fe200078e0234ULL,
0x0000002c2f327210ULL, 0x000fe20007f5e0ffULL, 0x000000017d4b7824ULL, 0x000fe200078e0206ULL,
0x000000302f307210ULL, 0x000fe20007f3e0ffULL, 0x000000087d367824ULL, 0x000fe200078e00ffULL,
0x000000122f387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e06ffULL,
0x00005e002e447a11ULL, 0x000fe200078040ffULL, 0x000000ffff457224ULL, 0x000fe200008e06ffULL,
0xfffffff8364b7812ULL, 0x000fe200078ee24bULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e0032407a11ULL, 0x000fe200078440ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x00005e0030427a11ULL, 0x000fe200078240ffULL, 0x0000000131487824ULL, 0x100fe200078e0234ULL,
0x00005e00383e7a11ULL, 0x000fe200078640ffULL, 0x000000017d4a7824ULL, 0x000fe200078e0234ULL,
0x00005f002e127a11ULL, 0x000fe200000f4443ULL, 0x000000107b7b7824ULL, 0x000fe200078e026cULL,
0x00005f00322e7a11ULL, 0x000fe200010f4436ULL, 0x0000000111327824ULL, 0x100fe200078e0234ULL,
0x00005f00302c7a11ULL, 0x000fe200008f4445ULL, 0x0000000113367824ULL, 0x000fe200078e0234ULL,
0x00005f0038307a11ULL, 0x000fe200018f443aULL, 0x0000000141387824ULL, 0x100fe200078e0234ULL,
0x000000322f327210ULL, 0x000fe20007f1e0ffULL, 0x000000012d3a7824ULL, 0x000fe200078e0234ULL,
0x000000362f367210ULL, 0x000fe20007f3e0ffULL, 0x0000001079797824ULL, 0x100fe200078e026cULL,
0x000000382f387210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x0000003a2f3a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x00005e00323c7a11ULL, 0x000fe200078040ffULL, 0x000000ffff2d7224ULL, 0x000fe200010e06ffULL,
0x00005e0036457a11ULL, 0x000fe200078240ffULL, 0x000000ffff467224ULL, 0x000fe200018e06ffULL,
0x00005e0038437a11ULL, 0x000fe200078440ffULL, 0x0000001035357824ULL, 0x100fe200078e026cULL,
0x00005e003a417a11ULL, 0x000fe200078640ffULL, 0x0000001077777824ULL, 0x100fe200078e026cULL,
0x00005f0032327a11ULL, 0x000fe200000f4411ULL, 0x0000001037377824ULL, 0x000fe200078e026cULL,
0x00005f0036117a11ULL, 0x000fe200008f4413ULL, 0x0000000133367824ULL, 0x100fe200078e0234ULL,
0x00005f0038137a11ULL, 0x000fe200010f442dULL, 0x0000000149387824ULL, 0x000fe200078e0234ULL,
0x00005f003a2d7a11ULL, 0x000fe200018f4446ULL, 0x000000013f3a7824ULL, 0x000fe200078e0234ULL,
0x000000386b467810ULL, 0x000fe20007ffe0ffULL, 0x0000001039397824ULL, 0x100fe200078e026cULL,
0x0000003c6b6b7810ULL, 0x000fe20007ffe0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e026cULL,
0x000000382f317210ULL, 0x040fe20007fbe0ffULL, 0x00000001464e7824ULL, 0x140fe200078e0234ULL,
0x0000003a2f337210ULL, 0x000fe20007f1e0ffULL, 0x000000016b6a7824ULL, 0x000fe200078e0234ULL,
0x000000362f347210ULL, 0x040fe20007fde0ffULL, 0x0000000146497824ULL, 0x140fe200078e0206ULL,
0x000000482f487210ULL, 0x040fe20007f3e0ffULL, 0x0000000846467824ULL, 0x000fe200078e00ffULL,
0x0000004a2f4a7210ULL, 0x000fe20007f5e0ffULL, 0x000000016b7d7824ULL, 0x000fe200078e0206ULL,
0x0000004e2f4e7210ULL, 0x000fe20007f7e0ffULL, 0x000000086b6e7824ULL, 0x000fe200078e00ffULL,
0x0000006a2f6a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200030e06ffULL,
0x00005e00343f7a11ULL, 0x000fe200078c40ffULL, 0x000000103d6b7824ULL, 0x000fe200078e026cULL,
0xfffffff846497812ULL, 0x000fe200078ee249ULL, 0x000000ffff367224ULL, 0x000fe200028e06ffULL,
0x00005f00342f7a11ULL, 0x000fe200030f442fULL, 0x000000ffff467224ULL, 0x000fe200008e06ffULL,
0x00005e00313d7a11ULL, 0x000fe200078a40ffULL, 0x00000010063a7824ULL, 0x000fe200078e00ffULL,
0x00005e0048347a11ULL, 0x000fe200078240ffULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0xfffffff86e7d7812ULL, 0x000fe200078ee27dULL, 0x000000ffff707224ULL, 0x000fe200010e06ffULL,
0x00005e00336e7a11ULL, 0x000fe200078040ffULL, 0x000000ffff727224ULL, 0x000fe200018e06ffULL,
0x00005f0031317a11ULL, 0x000fe200028f4436ULL, 0x0000001075757824ULL, 0x000fe200078e026cULL,
0x00005f0048487a11ULL, 0x000fe200008f4446ULL, 0x0000001073737824ULL, 0x100fe200078e026cULL,
0x000000703a3a7812ULL, 0x000fe200078ec0ffULL, 0x0000001071717824ULL, 0x100fe200078e026cULL,
0x00005e004a367a11ULL, 0x000fe200078240ffULL, 0x000000104f4f7824ULL, 0x000fe200078e026cULL,
0x00005f0033337a11ULL, 0x000fe200000f4438ULL, 0x000000104d4d7824ULL, 0x100fe200078e026cULL,
0x00005e004e387a11ULL, 0x000fe200078440ffULL, 0x000000104b4b7824ULL, 0x100fe200078e026cULL,
0x000000473a467210ULL, 0x000fe20007f1e0ffULL, 0x0000001049497824ULL, 0x000fe200078e026cULL,
0x00005f004a4a7a11ULL, 0x000fe200008f4470ULL, 0x000000107d7d7824ULL, 0x000fe200078e026cULL,
0x00005e006a6c7a11ULL, 0x000fe200078640ffULL, 0x000000ffff747224ULL, 0x000fe200020e06ffULL,
0x000000443a447210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff477224ULL, 0x000fe200000e0610ULL,
0x00005f004e4e7a11ULL, 0x000fc400010f4472ULL, 0x000000423a427210ULL, 0x000fe40007f5e0ffULL,
0x00005f006a6a7a11ULL, 0x000fe200018f4474ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000467b7faeULL, 0x0003e2000b901c46ULL, 0x000000403a407210ULL, 0x040fe40007f7e0ffULL,
0x000000453a107210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff457224ULL, 0x000fe200008e0612ULL,
0x0000003e3a3e7210ULL, 0x040fe40007fbe0ffULL, 0x000000433a127210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff437224ULL, 0x000fe200010e062cULL, 0x0000003c3a3c7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x000000413a2c7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff417224ULL, 0x000fe200018e062eULL, 0x0000003f3a2e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200028e0630ULL, 0x0000003d3a307210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200020e0632ULL, 0x0000006e3a327210ULL, 0x040fe20007f9e0ffULL,
0x0000000044797faeULL, 0x0003e2000b901c46ULL, 0x000000343a347210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x000000363a367210ULL, 0x040fe20007f3e0ffULL,
0x0000000042357faeULL, 0x0005e2000b901c46ULL, 0x000000ffff2d7224ULL, 0x000fe200010e062dULL,
0x000000383a387210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200018e062fULL,
0x0000000040777faeULL, 0x0003e2000b901c46ULL, 0x0000006c3a3a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fc400028e0631ULL, 0x000000003e377faeULL, 0x0007e2000b901c46ULL,
0x000000ffff337224ULL, 0x000fc600020e0633ULL, 0x000000003c397faeULL, 0x0009e2000b901c46ULL,
0x000000ffff357224ULL, 0x004fc600000e0648ULL, 0x00000000103b7faeULL, 0x0005e8000b901c46ULL,
0x0000000012757faeULL, 0x0003e2000b901c46ULL, 0x000000ffff377224ULL, 0x008fc600008e064aULL,
0x000000002c737faeULL, 0x0003e2000b901c46ULL, 0x000000ffff397224ULL, 0x010fc600010e064eULL,
0x000000002e717faeULL, 0x0003e2000b901c46ULL, 0x000000ffff3b7224ULL, 0x004fc600018e066aULL,
0x00000000306b7faeULL, 0x0003e8000b901c46ULL, 0x00000000324f7faeULL, 0x0003e8000b901c46ULL,
0x00000000344d7faeULL, 0x0003e8000b901c46ULL, 0x00000000364b7faeULL, 0x0003e8000b901c46ULL,
0x0000000038497faeULL, 0x0003e8000b901c46ULL, 0x000000003a7d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000105e117824ULL, 0x042fe200078e00ffULL,
0x000000085f107810ULL, 0x000fe20007ffe0ffULL, 0x000000105e127824ULL, 0x000fe200078e00ffULL,
0x000030006d487810ULL, 0x000fc40007ffe0ffULL, 0xfffffff011107812ULL, 0x000fe400078ee210ULL,
0x0000000a5f117810ULL, 0x000fe20007ffe0ffULL, 0x0000001068387824ULL, 0x100fe400078e0248ULL,
0x000000106f407824ULL, 0x100fe200078e0248ULL, 0xfffffff012117812ULL, 0x000fe200078ee211ULL,
0x0000001010107824ULL, 0x000fe400078e00ffULL, 0x00000010693c7824ULL, 0x100fe400078e0248ULL,
0x0000001067347824ULL, 0x000fc400078e0248ULL, 0x00000010662c7824ULL, 0x100fe400078e0248ULL,
0x0000001011117824ULL, 0x000fe400078e00ffULL, 0x0000001065447824ULL, 0x000fe200078e0248ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001030783bULL, 0x000fe80000000200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000004040783bULL, 0x000ea80000000200ULL,
0x000000003c3c783bULL, 0x000ee80000000200ULL, 0x000000003434783bULL, 0x000f280000000200ULL,
0x000000002c2c783bULL, 0x000fe80000000200ULL, 0x000000001110783bULL, 0x000ee80000000200ULL,
0x000000004444783bULL, 0x000fe20000000200ULL, 0x00000038301c723cULL, 0x042bee000004181cULL,
0x0000001064387824ULL, 0x120fe200078e0248ULL, 0x000000403054723cULL, 0x044b6e0000041854ULL,
0x000000105d407824ULL, 0x120fe200078e0248ULL, 0x0000003a3020723cULL, 0x040be40000041820ULL,
0x000000003838783bULL, 0x020e6c0000000200ULL, 0x000000423050723cULL, 0x040b640000041850ULL,
0x000000004040783bULL, 0x020fec0000000200ULL, 0x0000003c3014723cULL, 0x048b6e0000041814ULL,
0x00000010613c7824ULL, 0x020fe200078e0248ULL, 0x0000003e3018723cULL, 0x040b6a0000041818ULL,
0x000000003c3c783bULL, 0x020fe60000000200ULL, 0x000000343024723cULL, 0x050ff00000041824ULL,
0x000000363028723cULL, 0x000bee0000041828ULL, 0x000000105e317824ULL, 0x060fe200078e00ffULL,
0x0000000c5f307810ULL, 0x040fe20007ffe0ffULL, 0x0000002c1054723cULL, 0x000b620000041854ULL,
0x000000105e5e7824ULL, 0x000fe200078e00ffULL, 0x0000000e5f5f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff031307812ULL, 0x000fe200078ee230ULL, 0x0000001063317824ULL, 0x100fe200078e0248ULL,
0xfffffff05e5f7812ULL, 0x000fe200078ee25fULL, 0x00000010622c7824ULL, 0x020fe200078e0248ULL,
0x0000002e1050723cULL, 0x000b620000041850ULL, 0x0000001030347824ULL, 0x000fe400078e00ffULL,
0x000000003130783bULL, 0x000fe20000000200ULL, 0x000000105f5f7824ULL, 0x000fc600078e00ffULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x00000038101c723cULL, 0x042b66000004181cULL,
0x000000002c2c783bULL, 0x020e680000000200ULL, 0x0000001060387824ULL, 0x100fe200078e0248ULL,
0x0000003a1020723cULL, 0x040b6a0000041820ULL, 0x000000003838783bULL, 0x020ee60000000200ULL,
0x000000441014723cULL, 0x040b6e0000041814ULL, 0x000000105b447824ULL, 0x120fe200078e0248ULL,
0x000000461018723cULL, 0x000b6a0000041818ULL, 0x000000004444783bULL, 0x020fe60000000200ULL,
0x000000303454723cULL, 0x004bee0000041854ULL, 0x000000105a307824ULL, 0x120fe200078e0248ULL,
0x0000002c1024723cULL, 0x042b6e0000041824ULL, 0x000000105c2c7824ULL, 0x120fe200078e0248ULL,
0x0000002e1028723cULL, 0x000b620000041828ULL, 0x0000001059487824ULL, 0x000fe200078e0248ULL,
0x000000005f10783bULL, 0x020fe80000000200ULL, 0x000000002c2c783bULL, 0x000fe40000000200ULL,
0x000000323450723cULL, 0x040be40000041850ULL, 0x000000003030783bULL, 0x020e680000000200ULL,
0x000000004848783bULL, 0x000ea40000000200ULL, 0x00000038341c723cULL, 0x048f70000004181cULL,
0x0000003a3420723cULL, 0x040f700000041820ULL, 0x0000003c3414723cULL, 0x040ff00000041814ULL,
0x0000003e3418723cULL, 0x040ff00000041818ULL, 0x000000403424723cULL, 0x040ff00000041824ULL,
0x000000423428723cULL, 0x000ff00000041828ULL, 0x00000030101c723cULL, 0x062f70000004181cULL,
0x000000321020723cULL, 0x040f700000041820ULL, 0x0000002c1054723cULL, 0x040b700000041854ULL,
0x0000002e1050723cULL, 0x000f640000041850ULL, 0x3db504f31e307820ULL, 0x020fc40000410000ULL,
0x3db504f31f317820ULL, 0x000fe40000410000ULL, 0x3db504f31c1c7820ULL, 0x000fe40000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe20000410000ULL, 0x000000441014723cULL, 0x000f620000041814ULL,
0x3db504f3201e7820ULL, 0x000fe40000410000ULL, 0x3db504f3211f7820ULL, 0x000fe40000410000ULL,
0x3db504f3232d7820ULL, 0x000fc40000410000ULL, 0x3db504f322227820ULL, 0x000fe20000410000ULL,
0x000000461018723cULL, 0x040f620000041818ULL, 0x3db504f354547820ULL, 0x000fe40000410000ULL,
0x3db504f355557820ULL, 0x000fe40000410000ULL, 0x3db504f356567820ULL, 0x000fe40000410000ULL,
0x3db504f3572c7820ULL, 0x000fe20000410000ULL, 0x000000481024723cULL, 0x004f620000041824ULL,
0x3db504f350507820ULL, 0x000fc40000410000ULL, 0x3db504f351517820ULL, 0x000fe40000410000ULL,
0x3db504f3522e7820ULL, 0x000fe40000410000ULL, 0x3db504f3532f7820ULL, 0x000fe20000410000ULL,
0x0000004a1028723cULL, 0x000b640000041828ULL, 0x3db504f316327820ULL, 0x020fe40000410000ULL,
0x3db504f317337820ULL, 0x000fc60000410000ULL, 0x3db504f314107820ULL, 0x000fe40000410000ULL,
0x3db504f315117820ULL, 0x000fe40000410000ULL, 0x3db504f318127820ULL, 0x000fe40000410000ULL,
0x3db504f319137820ULL, 0x000fe40000410000ULL, 0x3db504f31a347820ULL, 0x000fe40000410000ULL,
0x3db504f31b357820ULL, 0x000fc40000410000ULL, 0x3db504f324247820ULL, 0x000fe40000410000ULL,
0x3db504f325257820ULL, 0x000fe40000410000ULL, 0x3db504f326267820ULL, 0x000fe40000410000ULL,
0x3db504f327237820ULL, 0x000fe40000410000ULL, 0x3db504f328207820ULL, 0x000fe40000410000ULL,
0x3db504f329217820ULL, 0x000fc40000410000ULL, 0x3db504f32a367820ULL, 0x000fe40000410000ULL,
0x3db504f32b377820ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ffff187224ULL, 0x000fe400078e0010ULL, 0x000000ffff197224ULL, 0x000fe400078e0011ULL,
0x0000000004107f8cULL, 0x0002a2000c80043fULL, 0x000000ffff297224ULL, 0x000fe400078e0020ULL,
0x000000ffff207224ULL, 0x000fc400078e0021ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0022ULL,
0x000000ffff217224ULL, 0x000fe400078e0026ULL, 0x000000ffff227224ULL, 0x000fe400078e0023ULL,
0x000000ffff157224ULL, 0x000fe400078e0054ULL, 0x000000ffff147224ULL, 0x000fe400078e0055ULL,
0x000000ffff167224ULL, 0x000fc400078e0050ULL, 0x000000ffff177224ULL, 0x000fe400078e0051ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0013ULL,
0x000000ffff277224ULL, 0x000fe400078e0024ULL, 0x000000ffff287224ULL, 0x000fe400078e0025ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0056ULL, 0x000000ffff237224ULL, 0x000fe400078e0036ULL,
0x000000ffff267224ULL, 0x000fc400078e0037ULL, 0x0000000000127805ULL, 0x006fca0000015200ULL,
0x0000040004257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x0000002412377210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011425ULL,
0x0000003724247211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x0000000224247819ULL, 0x000fc80000001225ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000406257824ULL, 0x000fe200078e00ffULL, 0x000000035800720cULL, 0x000fc80003f05270ULL,
0xfffffff025117812ULL, 0x000fca00078ec0ffULL, 0x000000800e247824ULL, 0x000fca00078e0211ULL,
0x01b4000024107984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000206367824ULL, 0x000fe400078e00ffULL, 0x000000010f397824ULL, 0x000fc600078e0a00ULL,
0x0000000636367812ULL, 0x000fc800078ec0ffULL, 0x0000000136007812ULL, 0x040fe400078efcffULL,
0x0000000836377812ULL, 0x000fe400078efcffULL, 0x000000390000720cULL, 0x080fe40003f26070ULL,
0x0000001036007812ULL, 0x000fe400078efcffULL, 0x000000393700720cULL, 0x080fe40003f06070ULL,
0x000000390000720cULL, 0x000fc40003fc6070ULL, 0x0000001136377812ULL, 0x040fe400078efcffULL,
0x0000001836007812ULL, 0x040fe400078efcffULL, 0x000000393600720cULL, 0x080fe40003f46070ULL,
0x000000393700720cULL, 0x080fe40003fa6070ULL, 0x000000390000720cULL, 0x000fe40003f66070ULL,
0x0000000936387812ULL, 0x000fc400078efcffULL, 0x0000001936377812ULL, 0x040fe400078efcffULL,
0x0000002036007812ULL, 0x000fe400078efcffULL, 0xff8000002a2a7808ULL, 0x000fe40005000000ULL,
0xff80000015157808ULL, 0x000fe40005000000ULL, 0xff8000002c2c7808ULL, 0x000fe40004800000ULL,
0xff80000014147808ULL, 0x000fc40004800000ULL, 0x000000393800720cULL, 0x080fe40003f86070ULL,
0x000000393700720cULL, 0x080fe40003f46070ULL, 0x000000390000720cULL, 0x000fe40003f26070ULL,
0x0000002136377812ULL, 0x040fe400078efcffULL, 0x0000002836007812ULL, 0x000fe400078efcffULL,
0xff8000002e2e7808ULL, 0x000fc40004000000ULL, 0xff80000016167808ULL, 0x000fe40004000000ULL,
0xff8000002f2f7808ULL, 0x000fe40006000000ULL, 0xff80000017177808ULL, 0x000fe40006000000ULL,
0x000000393700720cULL, 0x080fe40003f06070ULL, 0x000000390000720cULL, 0x000fe40003f86070ULL,
0x0000002936377812ULL, 0x000fc400078efcffULL, 0x0000003036007812ULL, 0x000fe400078efcffULL,
0xff80000032327808ULL, 0x000fe40007000000ULL, 0xff80000018187808ULL, 0x000fe40007000000ULL,
0xff80000033337808ULL, 0x000fe40006800000ULL, 0xff80000019197808ULL, 0x000fe40006800000ULL,
0x000000393700720cULL, 0x000fc40003fc6070ULL, 0x000000390000720cULL, 0x000fe40003fa6070ULL,
0x0000003136377812ULL, 0x040fe400078efcffULL, 0x0000003836007812ULL, 0x040fe400078efcffULL,
0x0000003936367812ULL, 0x000fe400078efcffULL, 0xff80000034347808ULL, 0x000fe40005800000ULL,
0xff8000001a1a7808ULL, 0x000fc40005800000ULL, 0xff80000035357808ULL, 0x000fe40005000000ULL,
0xff8000001b1b7808ULL, 0x000fe40005000000ULL, 0xff80000030307808ULL, 0x000fe40004800000ULL,
0xff8000001c1c7808ULL, 0x000fe40004800000ULL, 0x000000393700720cULL, 0x080fe40003f66070ULL,
0x000000390000720cULL, 0x000fc40003f46070ULL, 0x000000393600720cULL, 0x000fe40003f26070ULL,
0xff80000031317808ULL, 0x000fe40004000000ULL, 0xff8000001d1d7808ULL, 0x000fe40004000000ULL,
0xff8000002b2b7808ULL, 0x000fe40006000000ULL, 0xff8000001e1e7808ULL, 0x000fe40006000000ULL,
0xff8000002d2d7808ULL, 0x000fc40007000000ULL, 0xff8000001f1f7808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff80000027277808ULL, 0x000fe40006800000ULL,
0xff80000022227808ULL, 0x000fe40005800000ULL, 0xff80000028287808ULL, 0x000fe40005800000ULL,
0xff80000023237808ULL, 0x000fc40005000000ULL, 0xff80000029297808ULL, 0x000fe40005000000ULL,
0xff80000026267808ULL, 0x000fe40004800000ULL, 0xff80000020207808ULL, 0x000fc40004800000ULL,
0x000000151000720bULL, 0x004fe40003f1e000ULL, 0x0000002a1100720bULL, 0x000fe40003f3e000ULL,
0x0000001015377208ULL, 0x000fe40004000000ULL, 0x000000112a117208ULL, 0x000fc40004800000ULL,
0x000000143700720bULL, 0x000fe40003f1e000ULL, 0x0000002c1100720bULL, 0x000fe40003f3e000ULL,
0x0000003714377208ULL, 0x000fe40004000000ULL, 0x000000112c117208ULL, 0x000fe40004800000ULL,
0x000000163700720bULL, 0x000fe40003f1e000ULL, 0x0000002e1100720bULL, 0x000fc40003f3e000ULL,
0x0000003716007208ULL, 0x000fe40004000000ULL, 0x000000112e107208ULL, 0x000fe40004800000ULL,
0x000000170000720bULL, 0x000fe40003f1e000ULL, 0x0000002f1000720bULL, 0x000fe40003f3e000ULL,
0x0000000017117208ULL, 0x000fe40004000000ULL, 0x000000102f377208ULL, 0x000fc40004800000ULL,
0x000000181100720bULL, 0x000fe40003f1e000ULL, 0x000000323700720bULL, 0x000fe40003f3e000ULL,
0x0000001118007208ULL, 0x000fe40004000000ULL, 0x0000003732107208ULL, 0x000fe40004800000ULL,
0x000000190000720bULL, 0x000fe40003f1e000ULL, 0x000000331000720bULL, 0x000fc40003f3e000ULL,
0x0000000019117208ULL, 0x000fe40004000000ULL, 0x0000001033377208ULL, 0x000fe40004800000ULL,
0x0000001a1100720bULL, 0x000fe40003f1e000ULL, 0x000000343700720bULL, 0x000fe40003f3e000ULL,
0x000000111a007208ULL, 0x000fe40004000000ULL, 0x0000003734107208ULL, 0x000fc40004800000ULL,
0x0000001b0000720bULL, 0x000fe40003f1e000ULL, 0x000000351000720bULL, 0x000fe40003f3e000ULL,
0x000000001b117208ULL, 0x000fe40004000000ULL, 0x0000001035377208ULL, 0x000fe40004800000ULL,
0x0000001c1100720bULL, 0x000fe40003f1e000ULL, 0x000000303700720bULL, 0x000fc40003f3e000ULL,
0x000000111c007208ULL, 0x000fe40004000000ULL, 0x0000003730107208ULL, 0x000fe40004800000ULL,
0x0000001d0000720bULL, 0x000fe40003f1e000ULL, 0x000000311000720bULL, 0x000fe40003f3e000ULL,
0x000000001d117208ULL, 0x000fe40004000000ULL, 0x0000001031107208ULL, 0x000fc40004800000ULL,
0x0000001e1100720bULL, 0x000fe40003f1e000ULL, 0x0000002b1000720bULL, 0x000fe40003f3e000ULL,
0x000000111e007208ULL, 0x000fe40004000000ULL, 0x000000102b107208ULL, 0x000fe40004800000ULL,
0x0000001f0000720bULL, 0x000fe40003f1e000ULL, 0x0000002d1000720bULL, 0x000fc40003f3e000ULL,
0x000000001f007208ULL, 0x000fe40004000000ULL, 0x000000102d107208ULL, 0x000fe40004800000ULL,
0x000000270000720bULL, 0x000fe40003f1e000ULL, 0x000000211000720bULL, 0x000fe40003f3e000ULL,
0x0000000027117208ULL, 0x000fe40004000000ULL, 0x0000001021377208ULL, 0x000fc40004800000ULL,
0x000000281100720bULL, 0x000fe40003f1e000ULL, 0x000000223700720bULL, 0x000fe40003f3e000ULL,
0x0000001128007208ULL, 0x000fe40004000000ULL, 0x0000003722107208ULL, 0x000fe40004800000ULL,
0x000000290000720bULL, 0x000fe40003f1e000ULL, 0x000000231000720bULL, 0x000fc40003f3e000ULL,
0x0000000029117208ULL, 0x000fe40004000000ULL, 0x0000001023377208ULL, 0x000fe40004800000ULL,
0x000000201100720bULL, 0x000fe40003f1e000ULL, 0x000000263700720bULL, 0x000fe40003f3e000ULL,
0x0000001120397208ULL, 0x000fe40004000000ULL, 0x00000037263d7208ULL, 0x000fe20004800000ULL,
0x000017b27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0039007f89ULL, 0x0004e400000e0000ULL,
0x000000003900720bULL, 0x008fc80003f1e000ULL, 0x00000039003c7208ULL, 0x000fe20004000000ULL,
0x000017e27f007947ULL, 0x000fea000b800000ULL, 0x0c401f003d007f89ULL, 0x000ee800000e0000ULL,
0x0c401f0012117f89ULL, 0x000f2800000e0000ULL, 0x0c401f0013107f89ULL, 0x000e6200000e0000ULL,
0x000000003d00720bULL, 0x008fc40003f1e000ULL, 0x000000111200720bULL, 0x010fe40003f3e000ULL,
0x0000003d00367208ULL, 0x000fe40004000000ULL, 0x0000001211387208ULL, 0x000fe40004800000ULL,
0x0c201f003c117f89ULL, 0x000ee200000e0000ULL, 0x000000101300720bULL, 0x002fc60003f1e000ULL,
0x0c201f0036397f89ULL, 0x004e6200000e0000ULL, 0x0000001310007208ULL, 0x000fc60004000000ULL,
0x0c201f00383b7f89ULL, 0x000ea800000e0000ULL, 0x0c201f0000377f89ULL, 0x0002a200000e0000ULL,
0x000000113c00720bULL, 0x008fe40003f1e000ULL, 0x000000393600720bULL, 0x002fe40003f3e000ULL,
0x0000003c11107208ULL, 0x000fe40004000000ULL, 0x0000003b3800720bULL, 0x004fc40003f5e000ULL,
0x0000003639117208ULL, 0x000fe40004800000ULL, 0x000000383b127208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b10387820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b11417820ULL, 0x000fe20000410000ULL, 0x0000000306ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010838ULL, 0x000000370000720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b14147823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b16167823ULL, 0x000fc40000010838ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010838ULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19197823ULL, 0x000fe40000010838ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe40000010841ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe40000010841ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010841ULL,
0x0000001400147308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x000fc40000010841ULL,
0x3fb8aa3b28367823ULL, 0x100fe40000010838ULL, 0x00000004ff287e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b27137823ULL, 0x100fe20000010838ULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29277823ULL, 0x100fe20000010838ULL,
0x3f8000002828783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b18187823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b1a1a7823ULL, 0x000fc40000010838ULL, 0x000000ffff297224ULL, 0x000fe200078e0028ULL,
0x0000001700177308ULL, 0x000ee20000000800ULL, 0x000000151414723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b1f1f7823ULL, 0x000fe40000010838ULL, 0x00000019003a7308ULL, 0x002fe20000000800ULL,
0x3fb8aa3b32327823ULL, 0x000fc40000010841ULL, 0x3fb8aa3b33337823ULL, 0x100fe40000010841ULL,
0x3fb8aa3b34347823ULL, 0x100fe40000010841ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010841ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000161716723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b1e1e7823ULL, 0x000fe40000010838ULL,
0x3fb8aa3b30307823ULL, 0x000fc40000010841ULL, 0x0000002c00197308ULL, 0x000e620000000800ULL,
0x3fb8aa3b31317823ULL, 0x100fe40000010841ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe40000010841ULL,
0x3fb8aa3b2d2d7823ULL, 0x000fe40000010841ULL, 0x3fb8aa3b20207823ULL, 0x000fe20000010838ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000ffff467224ULL, 0x100fe400078e0028ULL,
0x000000ffff477224ULL, 0x000fca00078e0028ULL, 0x0000002f002f7308ULL, 0x000ea20000000800ULL,
0x0000002a1915723eULL, 0x002fce00000010ffULL, 0x0000001800397308ULL, 0x000fe20000000800ULL,
0x0000002e2f17723eULL, 0x004fce00000010ffULL, 0x0000001a003b7308ULL, 0x000ff00000000800ULL,
0x0000001b003c7308ULL, 0x0003f00000000800ULL, 0x0000001d003e7308ULL, 0x000fe20000000800ULL,
0x000000281418723cULL, 0x002f6e00000418ffULL, 0x0000001f00407308ULL, 0x000ff00000000800ULL,
0x00000032001d7308ULL, 0x0003f00000000800ULL, 0x0000003300427308ULL, 0x0004e20000000800ULL,
0x00000002ff327819ULL, 0x002fce0000011606ULL, 0x00000034001f7308ULL, 0x0003e20000000800ULL,
0x0000000832337824ULL, 0x004fce00078e00ffULL, 0x00000035002c7308ULL, 0x0005220000000800ULL,
0x0000001d421d723eULL, 0x008fe200000010ffULL, 0x0000000832347824ULL, 0x042fe400078e00ffULL,
0x0000000832427824ULL, 0x000fc800078e00ffULL, 0x0000001c003d7308ULL, 0x0003e20000000800ULL,
0x0000000832357824ULL, 0x004fce00078e00ffULL, 0x0000001e003f7308ULL, 0x0004e20000000800ULL,
0x000000393a1c723eULL, 0x002fe200000010ffULL, 0x00000008323a7824ULL, 0x000fe200078e00ffULL,
0x0000001f2c1f723eULL, 0x010fe200000010ffULL, 0x3fb8aa3b222c7823ULL, 0x000fc80000010841ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x0000003b3c1e723eULL, 0x004fce00000010ffULL,
0x000000281c18723cULL, 0x020b620000041818ULL, 0x0000003100317308ULL, 0x000e620000000800ULL,
0x0000003f4022723eULL, 0x008fe200000010ffULL, 0x000000ffff3f7224ULL, 0x000fc800078e0028ULL,
0x3fb8aa3b21297823ULL, 0x020fe20000010841ULL, 0x0000000132217810ULL, 0x000fe20007ffe0ffULL,
0x0000002b002b7308ULL, 0x000fe60000000800ULL, 0xfffffff834347812ULL, 0x000fca00078ee221ULL,
0x0000002d002a7308ULL, 0x0004e20000000800ULL, 0x000000303121723eULL, 0x002fe200000010ffULL,
0x0000000832317824ULL, 0x040fe200078e00ffULL, 0x0000000432307810ULL, 0x000fc80007ffe0ffULL,
0xfffffff8333c7812ULL, 0x000fe200078ee230ULL, 0x00000020002e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b232d7823ULL, 0x104fe20000010841ULL, 0xfffffff833307812ULL, 0x000fe200078ee232ULL,
0x3fb8aa3b26417823ULL, 0x000fe20000010841ULL, 0x0000002b2a23723eULL, 0x008fc800000010ffULL,
0x0000001300137308ULL, 0x000fe20000000800ULL, 0x0000003d3e20723eULL, 0x002fe200000010ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0028ULL, 0x00000002322a7810ULL, 0x040fe40007ffe0ffULL,
0x00000003322b7810ULL, 0x040fe40007ffe0ffULL, 0xfffffff831387812ULL, 0x000fe200078ee22aULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x0000003e2018723cULL, 0x000b620000041818ULL,
0x0000000832317810ULL, 0x000fc40007ffe0ffULL, 0xfffffff83a3a7812ULL, 0x000fe400078ee22bULL,
0x00000005322b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000831447824ULL, 0x000fe200078e00ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x00000008323e7824ULL, 0x020fc600078e00ffULL,
0xfffffff844447812ULL, 0x000fe400078ee231ULL, 0xfffffff83e3e7812ULL, 0x000fe400078ee22bULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002c00267308ULL, 0x0004e20000000800ULL,
0x000000272e2e723eULL, 0x002fce00000010ffULL, 0x0000002d002f7308ULL, 0x0003e20000000800ULL,
0x00000006322c7810ULL, 0x004fc80007ffe0ffULL, 0xfffffff835407812ULL, 0x000fe400078ee22cULL,
0x00000013362c723eULL, 0x000fe200000010ffULL, 0x00000041002a7308ULL, 0x000ea20000000800ULL,
0xffffffff322d7810ULL, 0x002fe40007ffe0ffULL, 0x000110000e137811ULL, 0x000fe400078e58ffULL,
0xfffffff842427812ULL, 0x000fe400078ee22dULL, 0x00000029262d723eULL, 0x008fe200000010ffULL,
0x0000001034267824ULL, 0x100fe200078e0213ULL, 0x0000000c25327812ULL, 0x000fe200078ec0ffULL,
0x0000001030257824ULL, 0x000fc400078e0213ULL, 0x0000001038277824ULL, 0x100fe400078e0213ULL,
0x000000103a287824ULL, 0x100fe200078e0213ULL, 0x0000002f2a2f723eULL, 0x004fe200000010ffULL,
0x000000103c297824ULL, 0x000fe400078e0213ULL, 0x0000000132257824ULL, 0x000fe400078e0225ULL,
0x000000103e2a7824ULL, 0x100fe400078e0213ULL, 0x000000462c18723cULL, 0x000f620000041818ULL,
0x0000000132267824ULL, 0x000fe200078e0226ULL, 0x0000001425007388ULL, 0x0003e20000000800ULL,
0x00000010402b7824ULL, 0x000fc400078e0213ULL, 0x0000000132277824ULL, 0x000fe200078e0227ULL,
0x0000001626007388ULL, 0x0003e20000000800ULL, 0x0000001042307824ULL, 0x100fe400078e0213ULL,
0x0000000132287824ULL, 0x000fe200078e0228ULL, 0x0000001c27007388ULL, 0x0003e20000000800ULL,
0x0000001044137824ULL, 0x000fe400078e0213ULL, 0x0000000132297824ULL, 0x040fe200078e0229ULL,
0x0000001e28007388ULL, 0x0003e20000000800ULL, 0x00000001322a7824ULL, 0x000fc400078e022aULL,
0x00000001322b7824ULL, 0x040fe200078e022bULL, 0x0000002029007388ULL, 0x0003e20000000800ULL,
0x0000000132307824ULL, 0x040fe400078e0230ULL, 0x0000000132327824ULL, 0x000fe200078e0213ULL,
0x000000222a007388ULL, 0x0003e20000000800ULL, 0x0000000037137208ULL, 0x000fe20004800000ULL,
0x000000ffff197224ULL, 0x020fe400078e001aULL, 0x0000002c2b007388ULL, 0x0003e80000000800ULL,
0x0000002e30007388ULL, 0x0003e80000000800ULL, 0x0000001532007388ULL, 0x0003e80000000800ULL,
0x0004001726007388ULL, 0x0003e80000000800ULL, 0x0004001d27007388ULL, 0x0003e80000000800ULL,
0x0004001f28007388ULL, 0x0003e80000000800ULL, 0x0004002129007388ULL, 0x0003e80000000800ULL,
0x000400232a007388ULL, 0x0003e80000000800ULL, 0x0004002d2b007388ULL, 0x0003e80000000800ULL,
0x0004002f30007388ULL, 0x0003e80000000800ULL, 0x01b0001024008388ULL, 0x0003e80000000c00ULL,
0x01b2001824008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6080002ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6100002ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6180002ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000b4c00720cULL, 0x000fe20003f06070ULL, 0x01b6200002ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff587224ULL, 0x000fd600078e004cULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff9ee000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff107807ULL, 0x008fe20004000000ULL, 0xffffffffff197424ULL, 0x000fe200078e00ffULL,
0x00014340001a7802ULL, 0x000fc40000000f00ULL, 0x00000ff000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0019ULL, 0xfffee67000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20005000000ULL, 0xffffffffff197424ULL, 0x000fe200078e00ffULL,
0x000143a0001a7802ULL, 0x000fc40000000f00ULL, 0x00000f9000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff137224ULL, 0x000fe200078e0019ULL, 0xfffee6b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1b7224ULL, 0x008fe200078e0019ULL, 0x00014410001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000ed000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001bULL,
0xfffee75000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1b7224ULL, 0x000fe200078e0019ULL,
0x00014480001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000e6000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001bULL, 0xfffee85000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1b7224ULL, 0x000fe200078e0013ULL, 0x00014500001d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe400078e0012ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000de000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e001bULL, 0xfffee9e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0004ULL, 0x00014580001d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0013ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000d6000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e001bULL, 0xfffee99000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x008fe20004000000ULL, 0xffffffffff197424ULL, 0x000fe200078e00ffULL,
0x000145e0001a7802ULL, 0x000fc40000000f00ULL, 0x00000d5000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0019ULL, 0xffff029000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20005000000ULL, 0xffffffffff197424ULL, 0x000fe200078e00ffULL,
0x00014640001a7802ULL, 0x000fc40000000f00ULL, 0x00000cf000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0019ULL, 0xffff02d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1b7224ULL, 0x000fe200078e001aULL, 0x000146b0001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000c3000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001bULL,
0xffff038000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1b7224ULL, 0x000fe200078e001aULL,
0x00014720001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000bc000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001bULL, 0xffff047000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1b7224ULL, 0x000fe200078e0012ULL, 0x000147a0001d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe400078e0013ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000b4000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e001bULL, 0xffff060000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1b7224ULL, 0x000fe200078e0012ULL, 0x00014810001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000ad000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e001bULL,
0xffff05c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00014870001a7802ULL, 0x000fc40000000f00ULL,
0x00000ac000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff137224ULL, 0x000fe200078e0019ULL,
0xffff1cb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004800000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x000148d0001a7802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0019ULL,
0xffff1cf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1b7224ULL, 0x000fe200078e001eULL,
0x00014940001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x000009a000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001bULL, 0xffff1db000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1b7224ULL, 0x000fe200078e001eULL, 0x000149b0001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000093000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001bULL,
0xffff1ea000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1b7224ULL, 0x000fe200078e0012ULL,
0x00014a30001d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e0013ULL,
0x0000001fff1c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000008b000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e001bULL,
0xffff203000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1b7224ULL, 0x000fe200078e0012ULL,
0x00014aa0001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000084000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e001bULL, 0xffff1ff000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x008fe20004000000ULL, 0xffffffffff197424ULL, 0x000fe200078e00ffULL,
0x00014b00001a7802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0019ULL, 0xffff361000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004800000ULL, 0xffffffffff197424ULL, 0x000fe200078e00ffULL,
0x00014b60001a7802ULL, 0x000fc40000000f00ULL, 0x000007d000007944ULL, 0x002fea0003c00000ULL,
0xffff366000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1b7224ULL, 0x000fe200078e001aULL,
0x00014bc0001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000072000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001bULL, 0xffff371000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1b7224ULL, 0x000fe200078e001aULL, 0x00014c30001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000006b000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001bULL,
0xffff380000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1b7224ULL, 0x000fe200078e0012ULL,
0x00014cb0001d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e0013ULL,
0x0000001fff1c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e001bULL,
0xffff398000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1b7224ULL, 0x000fe200078e0012ULL,
0x00014d20001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e001bULL, 0xffff394000007947ULL, 0x000fea000383ffffULL,
0x00000002ff3a7424ULL, 0x000fe200078e00ffULL, 0x00014d9000367802ULL, 0x000fe20000000f00ULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0038ULL,
0xffffe7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff397224ULL, 0x006fe200078e003dULL,
0x00014e1000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff3a7424ULL, 0x000fc400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000383d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e0012ULL, 0x00014e9000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000003d38117208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000381200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e0013ULL, 0x00014f1000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff3a7424ULL, 0x000fe200078e00ffULL, 0x00000012383b7208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fc400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000381300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e003cULL, 0x00014f9000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000001338007208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000383c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e0011ULL, 0x0001501000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000003c38107208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fc400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000381100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e003bULL, 0x0001509000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000001138117208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000383b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff397224ULL, 0x002fe200078e0000ULL, 0x0001511000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000003b38127208ULL, 0x000fe20004000000ULL,
0x0000001fff387424ULL, 0x000fc400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e0038ULL,
0xffffe5d000007947ULL, 0x000fea000383ffffULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000700008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000007037812ULL, 0x000fd600078ec0ffULL, 0x0080000003000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff0b7424ULL, 0x000fc800078e00ffULL, 0xfffead600a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff377424ULL, 0x000fe200078e00ffULL, 0x0000003f00007348ULL, 0x000fe80003800000ULL,
0x0c00003a39387389ULL, 0x0002a200000e0038ULL, 0xfffead2036007950ULL, 0x000fea0003c3ffffULL,
0x0000002100007348ULL, 0x000fe80003800000ULL, 0x000000101b1b7389ULL, 0x0002a200000e001cULL,
0x00000000ff117424ULL, 0x000fc400078e00ffULL, 0x000000ffff107224ULL, 0x002fc800078e001dULL,
0xfffeacd010007950ULL, 0x000fea0003c3ffffULL, 0x000000011000780cULL, 0x000fe20003f45070ULL,
0x0000001900007348ULL, 0x000fe80003800000ULL, 0x00000000ff117424ULL, 0x000fd000078e00ffULL,
0x0000000000107806ULL, 0x000fc800050e0100ULL, 0x0000001910197212ULL, 0x000fe200078ec0ffULL,
0x000000ffff107224ULL, 0x000fc800078e001aULL, 0xfffeac6010007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000054aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a8ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000900ULL,
0x00000000000003b0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000cb0ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d70ULL,
0x0000000000000584ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012f8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001308ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001398ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000139cULL,
0x00000000000001b0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x0000000000015480ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016a00ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016a40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000016dc0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001398ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000015668ULL,
0x0000000000015668ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000016a00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000016dc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 93856;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
