/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014cb0ULL, 0x0000000000014930ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL,
0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL,
0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x30624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x0000000000676e69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x6c65722e00687461ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x74736e6f632e766eULL,
0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0001000000beULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000fcULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0001000001c6ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b00010000020cULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000299ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000002e7ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000335ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a0022000003d6ULL, 0x0000000000013650ULL, 0x0000000000000230ULL, 0x000400030000044cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000013880ULL, 0x000d00030000047cULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001365000000000ULL, 0x0001080400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808c0828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808c92ULL, 0x0000001cffffffffULL, 0x0000006000000000ULL, 0x0001365000000000ULL,
0x0000023000000000ULL, 0x0000000000000000ULL, 0x0000001400082f04ULL, 0x0008230400000080ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b42904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000f000b42804ULL, 0x000007c000000270ULL, 0x00002d6000001d90ULL,
0x00002eb000002de0ULL, 0x000033a000002ff0ULL, 0x000038a0000033b0ULL, 0x00004810000047a0ULL,
0x00004a5000004910ULL, 0x00004c6000004c50ULL, 0x00005f5000005060ULL, 0x000060c000005fc0ULL,
0x0000640000006200ULL, 0x000067c000006410ULL, 0x000077e000007770ULL, 0x00007a20000078e0ULL,
0x00007c9000007c80ULL, 0x000081f0000081e0ULL, 0x0000a4500000a410ULL, 0x0000ab100000aae0ULL,
0x00012b1000012a60ULL, 0x00012dc000012d40ULL, 0x0001308000013010ULL, 0x0001335000013320ULL,
0x0000047001f03904ULL, 0x0001b600000000ffULL, 0x0000055000040100ULL, 0x0001b60800000000ULL,
0x00000660003f0100ULL, 0x0001b68800000004ULL, 0x00000bd0003f0100ULL, 0x0001b60000000007ULL,
0x00000d80003f0107ULL, 0x0001b68800000000ULL, 0x00002af0003f0101ULL, 0x0001b60800000023ULL,
0x00002b10003f0101ULL, 0x0001b60800000023ULL, 0x00002c80003f0109ULL, 0x0001b60800000023ULL,
0x00003830003f0109ULL, 0x0001b68800000021ULL, 0x00004590003f0101ULL, 0x0001b62800000023ULL,
0x000045b0003f0101ULL, 0x0001b62800000023ULL, 0x00004720003f0109ULL, 0x0001b62800000023ULL,
0x00004fe0003f0109ULL, 0x0001b69000000021ULL, 0x00005d40003f0101ULL, 0x0001b64800000021ULL,
0x00005d60003f0101ULL, 0x0001b64800000021ULL, 0x00005ed0003f0109ULL, 0x0001b64800000021ULL,
0x00006790003f0109ULL, 0x0001b69800000021ULL, 0x00007560003f0101ULL, 0x0001b66800000023ULL,
0x00007580003f0101ULL, 0x0001b66800000023ULL, 0x000076f0003f0109ULL, 0x0001b66800000023ULL,
0x00007fa0003f0109ULL, 0x0001b6a000000018ULL, 0x0000b790003f0101ULL, 0x0001b60000000007ULL,
0x0000d070003f0101ULL, 0x0001b60000000007ULL, 0x0000d1e0003f0109ULL, 0x0001b60000000007ULL,
0x00011000003f0109ULL, 0x0001b6880000004bULL, 0x00011270003f0101ULL, 0x0001b6880000004bULL,
0x000113e0003f0109ULL, 0x0001b6880000004bULL, 0x000135f0003f0109ULL, 0x0001b6080000000eULL,
0x00013600003f0101ULL, 0x0001b6100000000eULL, 0x00013610003f0101ULL, 0x0001b6180000000eULL,
0x00013620003f0101ULL, 0x0001b6200000000eULL, 0x00033803003f0101ULL, 0x0000b13000201c04ULL,
0x0000b3400000b180ULL, 0x0000b6300000b4a0ULL, 0x0000d2100000b730ULL, 0x000c050400013640ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001500080a04ULL,
0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001400000002ULL, 0x0000000000013650ULL,
0x0000000000000044ULL, 0x0000001400000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001400000002ULL, 0x0000000000000000ULL, 0x000000000001b700ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x00000000000f7919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000000004c7919ULL, 0x000f2a0000002600ULL, 0x00000300ff0a7b82ULL, 0x000f620000000800ULL,
0x0000000000097919ULL, 0x000ea20000002100ULL, 0x00000000000d7919ULL, 0x000f6c0000002700ULL,
0x00000400ff067b82ULL, 0x000ee20000000800ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000000300007306ULL, 0x004ea20000209000ULL, 0x000000ff0300720cULL, 0x000fca0003f45070ULL,
0x00008600ff117b82ULL, 0x000f640000000800ULL, 0x0000000000007308ULL, 0x004ea20000001000ULL,
0x00000005ff4a7819ULL, 0x002fcc0000011609ULL, 0x00001fff4a4a7589ULL, 0x000f6200000e0000ULL,
0x0ffffffe00047836ULL, 0x004fc80000000000ULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff087224ULL, 0x004fc800078e0a05ULL,
0x0000000308077224ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000e640000002200ULL,
0x0000000705057227ULL, 0x000fcc00078e0004ULL, 0x0000000605077227ULL, 0x008fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a07ULL, 0x0000000003007224ULL, 0x000fca00078e0206ULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x8000000300000210ULL, 0x000fe20007ffe0ffULL,
0x0000000107070836ULL, 0x000fc60000000000ULL, 0x000000030000720cULL, 0x000fda0003f26070ULL,
0x0000000107071836ULL, 0x000fe20000000000ULL, 0x00000003ff07a212ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000ea20000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f65070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00047836ULL, 0x004fe40000000000ULL,
0x000000040f007c24ULL, 0x002fe2000f8e0208ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x0002a2000021f000ULL, 0x00001fff0f0f7589ULL, 0x000f6200000e0000ULL,
0x000000ff00047202ULL, 0x002fe20000000f00ULL, 0x0000000507067224ULL, 0x004fc800078e02ffULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a06ULL, 0x0000000b05057227ULL, 0x000fc800078e0004ULL,
0x0000000400047c24ULL, 0x000fe4000f8e0209ULL, 0x0000004c054d7227ULL, 0x010fc600078e00ffULL,
0x0000007f0400780cULL, 0x000fe20003f44070ULL, 0x000000ffff057224ULL, 0x000fc800078e0a4dULL,
0x0000000507007224ULL, 0x000fca00078e024cULL, 0x000000070000720cULL, 0x000fc60003f06070ULL,
0x000000000006a919ULL, 0x000e620000008800ULL, 0x000004000005a802ULL, 0x000fd20000000f00ULL,
0x0000000100000824ULL, 0x000fe400078e0a07ULL, 0x000000014d4d0836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x000000070000720cULL, 0x000fda0003f26070ULL,
0x000000014d4d1836ULL, 0x000fe20000000000ULL, 0x00000007ff4db212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x000fe40003f24070ULL, 0x000000ff4d007210ULL, 0x000fe40007ffe1ffULL,
0x000006540605a816ULL, 0x002fe40000000005ULL, 0x000000030400780cULL, 0x000fe20003f64070ULL,
0x00000000074c7224ULL, 0x000fc400078e024cULL, 0xff317217ff07a424ULL, 0x000fe400078e00ffULL,
0x000000040406a824ULL, 0x000fe200078e0205ULL, 0x0000000000240947ULL, 0x020fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01b60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01b60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01b68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000104c007824ULL, 0x000fe200078e00ffULL, 0x0000001102057219ULL, 0x080fe200000006ffULL,
0x00000000004e7919ULL, 0x000e620000002500ULL, 0x0000001103097219ULL, 0x080fe200000006ffULL,
0x000000ffff047224ULL, 0x000fe200078e0a00ULL, 0x000000000500720cULL, 0x000fe20003f06070ULL,
0x01b400070600a388ULL, 0x0003e20000000800ULL, 0x000000020d027224ULL, 0x000fe200078e02ffULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x00000010054b7446ULL, 0x000fe40003800004ULL,
0x000000114d047219ULL, 0x000fc400000006ffULL, 0x000000ff4b4b7207ULL, 0x000fe40000000000ULL,
0x0000004a0f057211ULL, 0x000fe200078e10ffULL, 0x0000000902027224ULL, 0x000fe200078e0204ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000104b00780cULL, 0x000fe20003f05270ULL,
0x0000000205057824ULL, 0x000fd800078e00ffULL, 0x0000000000808947ULL, 0x002fea0003800000ULL,
0x0000000000087919ULL, 0x000e620000000000ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000137919ULL, 0x000ea60000008800ULL,
0x00000011040b7219ULL, 0x000fe400000006ffULL, 0x00000004ff067819ULL, 0x002fca0000011608ULL,
0x0000000105077824ULL, 0x000fc800078e0206ULL, 0x0000000100047824ULL, 0x000fe400078e0207ULL,
0x0000001007157824ULL, 0x000fc600078e00ffULL, 0x0000000b040b7212ULL, 0x000fe400078e30ffULL,
0x00000011ff047219ULL, 0x000fe40000011604ULL, 0x0000000b020b7210ULL, 0x000fe40007ffe0ffULL,
0x000000054b027248ULL, 0x000fc60007fe0000ULL, 0x0000000904047224ULL, 0x000fe400078e020bULL,
0x00000010080b7824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe400078e0a05ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f00b117812ULL, 0x000fe400078ec0ffULL,
0x000000020600720cULL, 0x000fe20003f06070ULL, 0x0000000107027824ULL, 0x000fe200078e0208ULL,
0x0000040000067802ULL, 0x000fc40000000f00ULL, 0x0000001104117212ULL, 0x000fe400078efcffULL,
0x0000065413077816ULL, 0x004fe40000000006ULL, 0x0000000411047c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff015027812ULL, 0x000fe400078ee202ULL, 0x0000000505057c10ULL, 0x000fe40008ffe4ffULL,
0x0000000702117211ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e2000c101c46ULL, 0x00000000006c7947ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x000e620000000000ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x0000040000067802ULL, 0x000fe20000000f00ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000137919ULL, 0x000ea20000008800ULL, 0x0000000508077211ULL, 0x042fe200078fe0ffULL,
0x00000010080b7824ULL, 0x000fe200078e00ffULL, 0x0000001104057219ULL, 0x000fc600000006ffULL,
0x0000000100047824ULL, 0x000fca00078e0207ULL, 0x0000000504057212ULL, 0x000fe400078e30ffULL,
0x00000011ff047219ULL, 0x000fe40000011604ULL, 0x000000f00b117812ULL, 0x000fe200078ec0ffULL,
0x0000000102057824ULL, 0x000fe200078e0205ULL, 0x0000000807027210ULL, 0x000fc60007ffe0ffULL,
0x0000000904047224ULL, 0x000fc800078e0205ULL, 0x0000010004047825ULL, 0x000fc600078e00ffULL,
0x0000001104047212ULL, 0x000fe200078efcffULL, 0x0000001007117824ULL, 0x000fe200078e00ffULL,
0x0000065413077816ULL, 0x004fe40000000006ULL, 0x0000000404047c10ULL, 0x000fe4000ff1e0ffULL,
0xfffffff011027812ULL, 0x000fe400078ee202ULL, 0x0000000505057c10ULL, 0x000fc600087fe4ffULL,
0x0000001002117824ULL, 0x000fca00078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e4000b901c46ULL, 0x00000000070472caULL, 0x000fe200000e0000ULL,
0x00009200ff047b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001b60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x000000040d047825ULL, 0x002fe200078e0004ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000604497981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x0000003f49487836ULL, 0x004fe40000000000ULL,
0x000000ff490f7836ULL, 0x000fc60000000000ULL, 0x00000006ff487819ULL, 0x000fe40000011648ULL,
0x00000008ff0f7819ULL, 0x000fca000001160fULL, 0x000000a800a88947ULL, 0x000fea0003800000ULL,
0x00000002ff067819ULL, 0x000fe2000001164aULL, 0x00000004ff177424ULL, 0x000fe200078e00ffULL,
0xffffffff00027802ULL, 0x000fe40000000f00ULL, 0x03ffffff06137812ULL, 0x000fc800078ec0ffULL,
0x000000134e137211ULL, 0x000fc800078e10ffULL, 0x000000481300720cULL, 0x000fda0003f06070ULL,
0x00009400ff058b82ULL, 0x000e620000000800ULL, 0x000000020d008824ULL, 0x000fce00078e00ffULL,
0x00009000ff148b82ULL, 0x000ea20000000a00ULL, 0x0000000500008224ULL, 0x002fe400078e0205ULL,
0x000000084a057824ULL, 0x000fe400078e00ffULL, 0x0000000113118824ULL, 0x000fe400078e0200ULL,
0x0000000107007824ULL, 0x000fe400078e0205ULL, 0x0000000411148825ULL, 0x004fe400078e0014ULL,
0x01b6881700ff79a7ULL, 0x0003e6000850003fULL, 0x0000000614028981ULL, 0x000ea2000c1e1900ULL,
0x00000001ff577819ULL, 0x000fca000001164aULL, 0x0000002057047824ULL, 0x000fe400078e00ffULL,
0x000000014e007836ULL, 0x002fe40000000000ULL, 0x000001004e0c7824ULL, 0x000fe200078e0204ULL,
0x00008e00ff107b82ULL, 0x000e640000000a00ULL, 0x0000000f0000720cULL, 0x000fe20003f06070ULL,
0x0000000302027224ULL, 0x004fe200078e02ffULL, 0x000000064d037819ULL, 0x000fc600000006ffULL,
0x0000004002177824ULL, 0x000fe200078e00ffULL, 0x000000014a027812ULL, 0x000fe400078ec0ffULL,
0x00000020031b7812ULL, 0x000fe200078ef80cULL, 0x0000010017107825ULL, 0x002fc800078e0010ULL,
0x0000000400948947ULL, 0x000fea0003800000ULL, 0x000000700b157812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1d7224ULL, 0x000fe200078e0a0cULL, 0x00000003ff0b7819ULL, 0x000fe40000011608ULL,
0x0000000c49007248ULL, 0x000fe20007fe0000ULL, 0x0000008002147824ULL, 0x000fe200078e0215ULL,
0x000000ff00157202ULL, 0x000fe20000000f00ULL, 0x000000011b177824ULL, 0x000fe200078e020bULL,
0x0000002000007446ULL, 0x000fe2000380001dULL, 0x000000040b197836ULL, 0x000fe20000000000ULL,
0x000000140b2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x000000001900720cULL, 0x0c0fe20003f26070ULL, 0x00000001190c7824ULL, 0x040fe200078e0208ULL,
0x00000016101e7210ULL, 0x000fe20007f1e0ffULL, 0x00000008191f7824ULL, 0x000fe400078e00ffULL,
0x000000011b197824ULL, 0x000fe400078e0219ULL, 0x000000080b297836ULL, 0x000fe20000000000ULL,
0xfffffff81f127812ULL, 0x000fe200078ee20cULL, 0x00000001111f7824ULL, 0x000fe200000e0617ULL,
0x0000000757177211ULL, 0x000fe200078e70ffULL, 0x0000000c0b2b7836ULL, 0x000fe20000000000ULL,
0x000000080b0c7210ULL, 0x000fe20007ffe0ffULL, 0x000000011b1d7824ULL, 0x000fe200078e0229ULL,
0x000000000b00720cULL, 0x080fe20003f06070ULL, 0x00002000020e7824ULL, 0x000fe200078e0217ULL,
0x000000070c217812ULL, 0x000fe200078ec0ffULL, 0x0000010019167825ULL, 0x000fe200078e0014ULL,
0x000000002900720cULL, 0x000fc40003fa6070ULL, 0x0ffffff8210c7812ULL, 0x000fe200078ef808ULL,
0x000000011b237824ULL, 0x000fe200078e022bULL, 0x0000001610207210ULL, 0x000fe20007f5e0ffULL,
0x000001001d187825ULL, 0x000fe200078e0014ULL, 0x000000002b00720cULL, 0x000fc60003f86070ULL,
0x00000100231c7825ULL, 0x000fe200078e0014ULL, 0x0000001810167210ULL, 0x000fc60007f7e0ffULL,
0x0000000111217824ULL, 0x000fe200010e0617ULL, 0x0000001c10187210ULL, 0x000fe20007f5e0ffULL,
0x000130000e237836ULL, 0x000fe20000000000ULL, 0x00000003290e7819ULL, 0x000fe200000006ffULL,
0x000000100b2d7836ULL, 0x000fe40000000000ULL, 0x0000000111177824ULL, 0x040fe200018e0619ULL,
0x000000230c257211ULL, 0x000fe200078e20ffULL, 0x0000000111197824ULL, 0x000fe200010e061dULL,
0x000000002d00720cULL, 0x080fe20003f66070ULL, 0x000000011b1d7824ULL, 0x000fe200078e022dULL,
0x000000002f00720cULL, 0x000fe20003f46070ULL, 0x0000001012277824ULL, 0x000fe200078e0223ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e257faeULL, 0x0003e2000c101c46ULL,
0x000001001d1c7825ULL, 0x000fc600078e0014ULL, 0x0000000020277faeULL, 0x0005e2000c901c46ULL,
0x000000180b317836ULL, 0x000fe20000000000ULL, 0x0000001c101c7210ULL, 0x000fe20007fde0ffULL,
0x0000001c0b337836ULL, 0x000fe40000000000ULL, 0x00000001290b7824ULL, 0x000fe200078e0208ULL,
0x000000003100720cULL, 0x080fe20003f26070ULL, 0x00000001111d7824ULL, 0x000fe200030e061dULL,
0x000000003300720cULL, 0x000fe20003f06070ULL, 0x000000011b1f7824ULL, 0x002fe200078e022fULL,
0xfffffff80e007812ULL, 0x000fe200078ee20bULL, 0x000000082d0e7824ULL, 0x000fe200078e00ffULL,
0x000000082d0b7210ULL, 0x000fe20007ffe0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0014ULL,
0x0000000333227819ULL, 0x000fc400000006ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL,
0x000000011b217824ULL, 0x044fe200078e0231ULL, 0x0000001e101e7210ULL, 0x000fe20007fde0ffULL,
0x000000011b257824ULL, 0x000fe400078e0233ULL, 0x00000100211a7825ULL, 0x000fe200078e0014ULL,
0x0000001f111f7210ULL, 0x000fc600037fe4ffULL, 0x000000012b0c7824ULL, 0x140fe200078e0208ULL,
0x0000001a101a7210ULL, 0x000fe20007fde0ffULL, 0x000000082b2b7824ULL, 0x000fe400078e00ffULL,
0x000000012f127824ULL, 0x140fe400078e0208ULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b0c7812ULL, 0x000fe200078ee20cULL, 0x00000001310b7824ULL, 0x140fe400078e0208ULL,
0x0000000831207824ULL, 0x000fe200078e00ffULL, 0xfffffff82f127812ULL, 0x000fe200078ee212ULL,
0x0000000133217824ULL, 0x000fc400078e0208ULL, 0x0000010025147825ULL, 0x000fe200078e0014ULL,
0xfffffff820207812ULL, 0x000fe400078ee20bULL, 0xfffffff822227812ULL, 0x000fe200078ee221ULL,
0x00000001111b7824ULL, 0x000fe200030e061bULL, 0x0000001410107210ULL, 0x000fe20007fde0ffULL,
0x00000010000b7824ULL, 0x100fe200078e0223ULL, 0x0000002312277211ULL, 0x000fe200078e20ffULL,
0x000000100c217824ULL, 0x100fe400078e0223ULL, 0x000000100e257824ULL, 0x100fe200078e0223ULL,
0x00000000160b7faeULL, 0x0003e2000e901c46ULL, 0x0000001020297824ULL, 0x000fc400078e0223ULL,
0x0000001022237824ULL, 0x000fe200078e0223ULL, 0x0000000018217faeULL, 0x0003e2000e101c46ULL,
0x0000000111117824ULL, 0x000fc600030e0615ULL, 0x000000001c257faeULL, 0x0003e8000d901c46ULL,
0x000000001e277faeULL, 0x0003e8000d101c46ULL, 0x000000001a297faeULL, 0x0003e8000c901c46ULL,
0x0000000010237faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x00000004080c7811ULL, 0x040fe400078fe8ffULL, 0x0000000808127811ULL, 0x000fe400078fe8ffULL,
0x000000030c157819ULL, 0x040fe200000006ffULL, 0x000000010c007824ULL, 0x100fe200078e0208ULL,
0x0000001408187811ULL, 0x000fe200078fe8ffULL, 0x0000000112147824ULL, 0x140fe200078e0208ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000812177824ULL, 0x000fe200078e00ffULL,
0xfffffff8150e7812ULL, 0x000fe200078ee200ULL, 0x00000008182a7824ULL, 0x000fe200078e00ffULL,
0x0000000c08157811ULL, 0x000fe200078fe8ffULL, 0x0000008002227824ULL, 0x000fe200078e020bULL,
0xfffffff817247812ULL, 0x000fe200078ee214ULL, 0x0000000118177824ULL, 0x100fe200078e0208ULL,
0x0000001008147811ULL, 0x040fe200078fe8ffULL, 0x0000000115007824ULL, 0x140fe200078e0208ULL,
0x00000018081a7811ULL, 0x000fe200078fe8ffULL, 0x00000008151d7824ULL, 0x000fe200078e00ffULL,
0x0000000814167210ULL, 0x000fe20007ffe0ffULL, 0x00000008141f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee217ULL, 0x000000011a197824ULL, 0x000fe200078e0208ULL,
0xfffffff81d267812ULL, 0x000fe200078ee200ULL, 0x0000400057177824ULL, 0x000fe200078e0207ULL,
0xfffffff81f287812ULL, 0x000fe200078ee216ULL, 0x000000011b1d7824ULL, 0x040fe200078e0215ULL,
0x0000000808007211ULL, 0x000fe200078fe8ffULL, 0x00002000021c7824ULL, 0x000fe200078e0217ULL,
0x0000001c08167811ULL, 0x000fe200078fe8ffULL, 0x000000011b177824ULL, 0x040fe200078e020cULL,
0x00000007000b7812ULL, 0x000fe200078ec0ffULL, 0x000000011b1f7824ULL, 0x040fe200078e0214ULL,
0x0000000316237819ULL, 0x040fe200000006ffULL, 0x0000000116007824ULL, 0x000fe200078e0208ULL,
0x000000031a2c7819ULL, 0x000fe200000006ffULL, 0x000000011b277824ULL, 0x040fe200078e0216ULL,
0x0000001b08157211ULL, 0x000fe200078fe8ffULL, 0x000000011b217824ULL, 0x040fe200078e0218ULL,
0xfffffff823007812ULL, 0x000fe200078ee200ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee219ULL, 0x000000011b257824ULL, 0x000fe200078e021aULL,
0x000000121b197210ULL, 0x000fe20007ffe0ffULL, 0x0000010015147825ULL, 0x000fe200078e0022ULL,
0x0ffffff80b0b7812ULL, 0x000fc600078ef808ULL, 0x0000010017167825ULL, 0x000fe200078e0022ULL,
0x0000001410147210ULL, 0x000fc60007f1e0ffULL, 0x0000010019187825ULL, 0x000fe200078e0022ULL,
0x0000001610167210ULL, 0x000fc60007f3e0ffULL, 0x000001001d1a7825ULL, 0x000fe200078e0022ULL,
0x0000001810187210ULL, 0x000fc60007f5e0ffULL, 0x000130001c317836ULL, 0x000fe20000000000ULL,
0x0000001a101a7210ULL, 0x000fe20007f7e0ffULL, 0x000001001f1c7825ULL, 0x100fe200078e0022ULL,
0x0000001911197210ULL, 0x000fe400017fe4ffULL, 0x000000310b0b7211ULL, 0x080fe200078e20ffULL,
0x00000100211e7825ULL, 0x000fe200078e0022ULL, 0x000000312a2d7211ULL, 0x000fc600078e20ffULL,
0x0000010025207825ULL, 0x000fc800078e0022ULL, 0x0000010027227825ULL, 0x000fe200078e0022ULL,
0x0000002010207210ULL, 0x000fc60007f5e0ffULL, 0x0000000111157824ULL, 0x040fe200000e0615ULL,
0x0000001c101c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000111177824ULL, 0x040fe200008e0617ULL,
0x0000001e101e7210ULL, 0x000fe20007f3e0ffULL, 0x000000100e257824ULL, 0x100fe200078e0231ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140b7faeULL, 0x0003e2000b901c46ULL,
0x0000001024277824ULL, 0x000fe400078e0231ULL, 0x00000001111b7824ULL, 0x000fe200018e061bULL,
0x0000002210107210ULL, 0x000fe20007f7e0ffULL, 0x0000001026297824ULL, 0x100fe200078e0231ULL,
0x0000000016257faeULL, 0x0003e2000b901c46ULL, 0x00000010282b7824ULL, 0x000fc400078e0231ULL,
0x00000001111d7824ULL, 0x040fe200000e061dULL, 0x0000000018277faeULL, 0x0003e2000b901c46ULL,
0x00000001111f7824ULL, 0x040fe400008e061fULL, 0x000000102c2f7824ULL, 0x000fe200078e0231ULL,
0x000000001a297faeULL, 0x0003e2000b901c46ULL, 0x0000000111217824ULL, 0x000fe200010e0621ULL,
0x0000002311117210ULL, 0x000fe20001ffe4ffULL, 0x0000001000317824ULL, 0x000fe200078e0231ULL,
0x000000001c2b7faeULL, 0x0003e8000b901c46ULL, 0x000000001e2d7faeULL, 0x0003e8000b901c46ULL,
0x00000000202f7faeULL, 0x0003e8000b901c46ULL, 0x0000000010317faeULL, 0x0003e4000b901c46ULL,
0x00000003130b7812ULL, 0x002fe200078ec0ffULL, 0xffffffffff597424ULL, 0x000fe200078e00ffULL,
0xfffffffd0a007811ULL, 0x000fe200078e10ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000030b00780cULL, 0x000fc80003f05270ULL, 0x00000001005a7807ULL, 0x000fca0004000000ULL,
0x00000001135a7824ULL, 0x000fca00078e025aULL, 0x000000485a00720cULL, 0x000fda0003f06070ULL,
0x00009400ff0c8b82ULL, 0x000e620000000800ULL, 0x000000020d0b8824ULL, 0x000fce00078e00ffULL,
0x00009000ff108b82ULL, 0x000ea20000000a00ULL, 0x0000000c0b0b8224ULL, 0x002fc800078e020cULL,
0x000000010b0b8824ULL, 0x000fc800078e025aULL, 0x000000040b108825ULL, 0x004fca00078e0010ULL,
0x0000000610598981ULL, 0x000322000c1e1900ULL, 0x0000000f4e00720cULL, 0x000fe20003f06070ULL,
0x000000ffff5b7224ULL, 0x000fe200078e00ffULL, 0xff31721700587802ULL, 0x000fe40000000f00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fc4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x002fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000006000ec0947ULL, 0x000fec0003800000ULL, 0x00009400ff0c7b82ULL, 0x000e620000000800ULL,
0x000000020d0b7824ULL, 0x000fe400078e00ffULL, 0xff317217ff587424ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x0000000c0b0b7224ULL, 0x002fce00078e020cULL,
0x00008e00ff187b82ULL, 0x000e620000000a00ULL, 0x000000044a1a7819ULL, 0x000fe200000006ffULL,
0x000000014e207836ULL, 0x000fe20000000000ULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0xffffffe01a1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000459597c24ULL, 0x010fe2000f8e02ffULL,
0x0000000f2000720cULL, 0x000fc60003f06070ULL, 0x000001004e1b7824ULL, 0x000fe400078e021bULL,
0x0000004059597824ULL, 0x000fe400078e00ffULL, 0x000000401b227836ULL, 0x000fca0000000000ULL,
0x00000020221a7812ULL, 0x000fc800078ec0ffULL, 0x0000001a03277210ULL, 0x000fe20007ffe0ffULL,
0x0000010059187825ULL, 0x002fe200078e0018ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400a08947ULL, 0x000fea0003800000ULL, 0x0000001008207824ULL, 0x000fe200078e00ffULL,
0x00000022491a7248ULL, 0x000fe20007fe0000ULL, 0x000000ffff217224ULL, 0x000fe200078e0a22ULL,
0x00000003ff297819ULL, 0x100fe20000011608ULL, 0x000000804a1b7824ULL, 0x000fe200078e00ffULL,
0x0000007020207812ULL, 0x000fe200078ec0ffULL, 0x0000400057577824ULL, 0x000fe200078e0207ULL,
0x000000201a247446ULL, 0x000fe20003800021ULL, 0x0000000129217824ULL, 0x040fe200078e0227ULL,
0x00000080201a7812ULL, 0x000fe200078ef81bULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0x0000000d4a227819ULL, 0x000fe200000006ffULL, 0x0000000129257824ULL, 0x040fe200078e0208ULL,
0x000000242900720cULL, 0x000fe20003f26070ULL, 0x0000010021207825ULL, 0x000fe200078e001aULL,
0x0000200022227812ULL, 0x000fc400078ec0ffULL, 0x0000000725257812ULL, 0x000fe200078ec0ffULL,
0x00000004292b7836ULL, 0x000fe20000000000ULL, 0x0000002018207210ULL, 0x000fe20007f1e0ffULL,
0x0000000c29457836ULL, 0x000fe20000000000ULL, 0x0001400057267810ULL, 0x000fe20007ffe022ULL,
0x000000012b287824ULL, 0x040fe200078e0208ULL, 0x0ffffff825257812ULL, 0x000fe200078ef808ULL,
0x000000082b417824ULL, 0x000fe200078e00ffULL, 0x000000272b237210ULL, 0x000fe20007ffe0ffULL,
0x0000000119217824ULL, 0x000fe200000e0621ULL, 0x000000242b00720cULL, 0x000fe20003f06070ULL,
0x0000001025257824ULL, 0x000fe200078e0226ULL, 0xfffffff8412b7812ULL, 0x000fe200078ee228ULL,
0x0000010023227825ULL, 0x000fe200078e001aULL, 0x0000001829517810ULL, 0x000fc40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e2000c901c46ULL,
0x0000000829417836ULL, 0x000fe20000000000ULL, 0x0000002218227210ULL, 0x000fe20007f5e0ffULL,
0x0000001029477836ULL, 0x000fe20000000000ULL, 0x000000244500720cULL, 0x080fe20003fa6070ULL,
0x0000000841437824ULL, 0x040fe200078e00ffULL, 0x0000002319237210ULL, 0x000fe200017fe4ffULL,
0x00000014294f7836ULL, 0x000fe20000000000ULL, 0x000000244100720cULL, 0x080fe20003fc6070ULL,
0x0000001c29537836ULL, 0x000fe20000000000ULL, 0x000000244700720cULL, 0x080fe20003f86070ULL,
0x000000102b297824ULL, 0x000fe200078e0226ULL, 0x0000002741217210ULL, 0x002fe20007ffe0ffULL,
0x0000000141207824ULL, 0x100fe200078e0208ULL, 0x000000244f00720cULL, 0x080fe20003f66070ULL,
0x0000000145257824ULL, 0x000fe200078e0227ULL, 0x0000000022297faeULL, 0x0003e2000c101c46ULL,
0x000000245100720cULL, 0x080fe20003f46070ULL, 0x0000000145287824ULL, 0x000fe200078e0208ULL,
0xfffffff843437812ULL, 0x000fe200078ee220ULL, 0x0000010021207825ULL, 0x000fe200078e001aULL,
0x000000245300720cULL, 0x000fc40003f26070ULL, 0x00000008472a7210ULL, 0x000fe20007ffe0ffULL,
0x00000001472b7824ULL, 0x000fe200078e0227ULL, 0x0000002018207210ULL, 0x000fe20007f1e0ffULL,
0x0000000845457824ULL, 0x000fe200078e00ffULL, 0x0000000851407210ULL, 0x000fe20007ffe0ffULL,
0x0000000847477824ULL, 0x000fe200078e00ffULL, 0x000000274f297210ULL, 0x002fe20007ffe0ffULL,
0x0000010025247825ULL, 0x000fe200078e001aULL, 0xfffffff845457812ULL, 0x000fe400078ee228ULL,
0xfffffff847477812ULL, 0x000fe200078ee22aULL, 0x0000000119217824ULL, 0x000fe200000e0621ULL,
0x0000002418227210ULL, 0x000fe20007f1e0ffULL, 0x000001002b2a7825ULL, 0x000fc800078e001aULL,
0x000000014f287824ULL, 0x040fe400078e0208ULL, 0x000000084f417824ULL, 0x000fe400078e00ffULL,
0x0000000119237824ULL, 0x000fe200000e0625ULL, 0x0000002a18247210ULL, 0x000fe20007f1e0ffULL,
0x0000000853427824ULL, 0x000fe200078e00ffULL, 0xfffffff8414f7812ULL, 0x000fe200078ee228ULL,
0x0000010029287825ULL, 0x000fc800078e001aULL, 0x0000000151417824ULL, 0x000fe400078e0227ULL,
0x0000000119257824ULL, 0x000fe200000e062bULL, 0x0000002818287210ULL, 0x000fe20007f1e0ffULL,
0x00000100412a7825ULL, 0x000fc800078e001aULL, 0x0000000153277824ULL, 0x000fe400078e0227ULL,
0x0000000119297824ULL, 0x000fe200000e0629ULL, 0x0000002a182a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000851517824ULL, 0x000fe400078e00ffULL, 0x0000000153417824ULL, 0x000fe200078e0208ULL,
0x0000002b192b7210ULL, 0x000fe200007fe4ffULL, 0x00000100271a7825ULL, 0x000fe200078e001aULL,
0xfffffff851517812ULL, 0x000fe400078ee240ULL, 0xfffffff842537812ULL, 0x000fe200078ee241ULL,
0x0000001043277824ULL, 0x100fe200078e0226ULL, 0x0000001a18187210ULL, 0x000fe20007f1e0ffULL,
0x0000001045417824ULL, 0x000fc400078e0226ULL, 0x0000001047437824ULL, 0x100fe200078e0226ULL,
0x0000002651477211ULL, 0x000fe200078e20ffULL, 0x000000104f457824ULL, 0x100fe200078e0226ULL,
0x0000000020277faeULL, 0x0003e2000f101c46ULL, 0x00000010534f7824ULL, 0x000fe400078e0226ULL,
0x0000000119197824ULL, 0x000fe200000e061bULL, 0x0000000022417faeULL, 0x0003e8000e901c46ULL,
0x0000000024437faeULL, 0x0003e8000e101c46ULL, 0x0000000028457faeULL, 0x0003e8000d901c46ULL,
0x000000002a477faeULL, 0x0003e8000d101c46ULL, 0x00000000184f7faeULL, 0x0003e2000c901c46ULL,
0x00000004006c7947ULL, 0x000fea0003800000ULL, 0x00000010081a7824ULL, 0x040fe200078e00ffULL,
0x0000000408257811ULL, 0x000fe200078fe8ffULL, 0x000000804a1b7824ULL, 0x000fe200078e00ffULL,
0x0000000808227811ULL, 0x000fe200078fe8ffULL, 0x0000400057577824ULL, 0x000fe200078e0207ULL,
0x000000701a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000125217824ULL, 0x140fe200078e0208ULL,
0x00000010082b7811ULL, 0x000fe200078fe8ffULL, 0x0000000825247824ULL, 0x000fe200078e00ffULL,
0x000000801a1a7812ULL, 0x000fe200078ef81bULL, 0x00000001221b7824ULL, 0x100fe200078e0208ULL,
0x0000000c08297811ULL, 0x000fe200078fe8ffULL, 0x000000012b237824ULL, 0x140fe200078e0208ULL,
0xfffffff824457812ULL, 0x000fe200078ee221ULL, 0x000000082b287824ULL, 0x000fe200078e00ffULL,
0x0000000322247819ULL, 0x000fe200000006ffULL, 0x0000000129217824ULL, 0x040fe200078e0208ULL,
0x0000000d4a207819ULL, 0x000fe200000006ffULL, 0x0000000829267824ULL, 0x000fe200078e00ffULL,
0xfffffff824477812ULL, 0x000fe200078ee21bULL, 0x0000000125257824ULL, 0x100fe200078e0227ULL,
0x00000008081b7211ULL, 0x040fe200078fe8ffULL, 0x0000000129297824ULL, 0x100fe200078e0227ULL,
0x0000001808557811ULL, 0x000fe200078fe8ffULL, 0x000000012b2b7824ULL, 0x000fe200078e0227ULL,
0x0000200020207812ULL, 0x000fc400078ec0ffULL, 0x000000071b1b7812ULL, 0x000fe400078ec0ffULL,
0x0000001408417811ULL, 0x040fe400078fe8ffULL, 0xfffffff828517812ULL, 0x000fe200078ee223ULL,
0x0000000155237824ULL, 0x000fe200078e0208ULL, 0x0001400057207810ULL, 0x000fe20007ffe020ULL,
0x0000000855287824ULL, 0x040fe200078e00ffULL, 0x0000001c08597811ULL, 0x040fe200078fe8ffULL,
0x0000000155557824ULL, 0x100fe200078e0227ULL, 0x0ffffff81b1b7812ULL, 0x000fe200078ef808ULL,
0x0000001045457824ULL, 0x000fe200078e0220ULL, 0xfffffff8264f7812ULL, 0x000fe200078ee221ULL,
0x0000000841267824ULL, 0x000fe200078e00ffULL, 0x0000000841217210ULL, 0x000fe20007ffe0ffULL,
0x0000000159247824ULL, 0x000fe200078e0208ULL, 0xfffffff828577812ULL, 0x000fe200078ee223ULL,
0x000000101b437824ULL, 0x000fe200078e0220ULL, 0x0000002708237211ULL, 0x000fe200078fe8ffULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x00000003595d7819ULL, 0x040fe200000006ffULL,
0x0000000159597824ULL, 0x100fe200078e0227ULL, 0xfffffff826537812ULL, 0x000fe200078ee221ULL,
0x0000000122217824ULL, 0x000fe200078e0227ULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee224ULL,
0x0000010023227825ULL, 0x000fe200078e001aULL, 0x0000002741417210ULL, 0x000fc40007ffe0ffULL,
0x0000002047477211ULL, 0x080fe200078e20ffULL, 0x0000010025247825ULL, 0x100fe200078e001aULL,
0x0000002218227210ULL, 0x000fe40007f1e0ffULL, 0x000000205d5d7211ULL, 0x000fe200078e20ffULL,
0x0000010021267825ULL, 0x000fe200078e001aULL, 0x0000002418247210ULL, 0x000fc60007f3e0ffULL,
0x0000010029287825ULL, 0x000fe200078e001aULL, 0x0000002618267210ULL, 0x000fc60007f5e0ffULL,
0x000001002b2a7825ULL, 0x000fe200078e001aULL, 0x0000002818287210ULL, 0x000fc60007f7e0ffULL,
0x000000104f4f7824ULL, 0x100fe200078e0220ULL, 0x0000002919297210ULL, 0x000fe20001ffe4ffULL,
0x0000001051517824ULL, 0x100fe400078e0220ULL, 0x0000001053537824ULL, 0x100fe400078e0220ULL,
0x0000001057577824ULL, 0x000fe400078e0220ULL, 0x0000010041407825ULL, 0x000fc800078e001aULL,
0x0000010055207825ULL, 0x000fc800078e001aULL, 0x00000100591a7825ULL, 0x000fc800078e001aULL,
0x0000000119237824ULL, 0x040fe200000e0623ULL, 0x0000002a182a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000119257824ULL, 0x040fe200008e0625ULL, 0x0000004018407210ULL, 0x000fe20007f3e0ffULL,
0x0000000119277824ULL, 0x040fe200010e0627ULL, 0x0000002018207210ULL, 0x000fe20007f5e0ffULL,
0x00000001192b7824ULL, 0x040fe200000e062bULL, 0x0000001a18187210ULL, 0x000fe20007f7e0ffULL,
0x0000000119417824ULL, 0x040fe200008e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022437faeULL, 0x0003e2000b901c46ULL, 0x0000000119217824ULL, 0x000fc400010e0621ULL,
0x0000000119197824ULL, 0x000fe200018e061bULL, 0x0000000024457faeULL, 0x0003e8000b901c46ULL,
0x0000000026477faeULL, 0x0003e8000b901c46ULL, 0x00000000284f7faeULL, 0x0003e8000b901c46ULL,
0x000000002a517faeULL, 0x0003e8000b901c46ULL, 0x0000000040537faeULL, 0x0003e8000b901c46ULL,
0x0000000020577faeULL, 0x0003e8000b901c46ULL, 0x00000000185d7faeULL, 0x0003e4000b901c46ULL,
0x000000035a187812ULL, 0x002fe200078ec0ffULL, 0xffffffffff5d7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000031800780cULL, 0x000fc80003f05270ULL,
0x0000000100197807ULL, 0x000fc80004000000ULL, 0x0000005a195c7210ULL, 0x000fc80007ffe0ffULL,
0x000000485c00720cULL, 0x000fda0003f06070ULL, 0x00009000ff188b82ULL, 0x000e620000000a00ULL,
0x000000010b1b8824ULL, 0x000fe200078e025cULL, 0xffffffe0051a7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff207424ULL, 0x000fe400078e00ffULL, 0x000000041b188825ULL, 0x002fe200078e0018ULL,
0x00000010051b7812ULL, 0x000fc800078ec0ffULL, 0x000000071b1a7210ULL, 0x000fe20007ffe01aULL,
0x00000006185d8981ULL, 0x000322000c1e1900ULL, 0x00000008051b7812ULL, 0x000fca00078ec0ffULL,
0x000000011a237824ULL, 0x000fc800078e021bULL, 0x01b60820232079a7ULL, 0x0002a6000850003fULL,
0x0000000000187805ULL, 0x002fce0000015200ULL, 0x01b60821230075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ff00227202ULL, 0x000fce0000000f00ULL,
0x000000102200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a18257210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x000000251a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000122227836ULL, 0x000fce0000000000ULL,
0x01b60821230075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000204a187824ULL, 0x000fe200078e00ffULL, 0x0000000408447819ULL, 0x000fe200000006ffULL,
0x000000ffff5f7224ULL, 0x000fe200078e0058ULL, 0x00000001ff557819ULL, 0x000fe40000011608ULL,
0xffffff8018187812ULL, 0x000fe400078ec0ffULL, 0x0000007044447812ULL, 0x000fe400078ec0ffULL,
0x0000000c55557812ULL, 0x000fe200078ec0ffULL, 0x0000000107567824ULL, 0x000fca00078e0218ULL,
0x0000005655187210ULL, 0x000fca0007ffe044ULL, 0x01b0000018197984ULL, 0x000e680000000800ULL,
0x01b20000185e7984ULL, 0x0004a20000000800ULL, 0x000000581900720bULL, 0x002fda0003f1d000ULL,
0x00000000001a7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1a1b7812ULL, 0x000fda000782c0ffULL, 0x0000000000ec9947ULL, 0x004fea0003800000ULL,
0x0000004a0600720cULL, 0x000fe40003f25270ULL, 0x000000581900720bULL, 0x0c0fe40003f14000ULL,
0x00000058195f7209ULL, 0x000fd20007810000ULL, 0x000000804a189824ULL, 0x000fe400078e0207ULL,
0x0000000000207806ULL, 0x000fc600000e0100ULL, 0x0000001855189210ULL, 0x000fe40007ffe044ULL,
0x00009910201a7816ULL, 0x000fc600000000ffULL, 0x01b4005f18009388ULL, 0x0003e20000000800ULL,
0x000000ff1a00720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x000000585f187221ULL, 0x000fe20000010100ULL, 0x000000ff20ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0020ff7812ULL, 0x000fe2000782c0ffULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x0000001800217308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff187819ULL, 0x002fcc0000011608ULL, 0x00001f1821187589ULL, 0x004e6400000e0000ULL,
0x000000182c2c7220ULL, 0x082fe20000410000ULL, 0x000000182d2d7220ULL, 0x080fe20000410000ULL,
0x0000001830307220ULL, 0x080fe20000410000ULL, 0x0000001831317220ULL, 0x080fe20000410000ULL,
0x0000001834347220ULL, 0x080fe20000410000ULL, 0x0000001835357220ULL, 0x080fe20000410000ULL,
0x0000001838387220ULL, 0x080fe20000410000ULL, 0x0000001839397220ULL, 0x080fe20000410000ULL,
0x000000183c3c7220ULL, 0x080fe20000410000ULL, 0x000000183d3d7220ULL, 0x080fe20000410000ULL,
0x0000001810107220ULL, 0x080fe20000410000ULL, 0x0000001811117220ULL, 0x080fe20000410000ULL,
0x0000001814147220ULL, 0x080fe20000410000ULL, 0x0000001815157220ULL, 0x080fe20000410000ULL,
0x000000181c1c7220ULL, 0x080fe20000410000ULL, 0x000000181d1d7220ULL, 0x000fce0000410000ULL,
0x000000215b5b7220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000808187811ULL, 0x002fcc00078ff0ffULL, 0x00001f1821187589ULL, 0x000e6400000e0000ULL,
0x000000182e2e7220ULL, 0x082fe20000410000ULL, 0x000000182f2f7220ULL, 0x080fe20000410000ULL,
0x0000001832327220ULL, 0x080fe20000410000ULL, 0x0000001833337220ULL, 0x080fe20000410000ULL,
0x0000001836367220ULL, 0x080fe20000410000ULL, 0x0000001837377220ULL, 0x080fe20000410000ULL,
0x000000183a3a7220ULL, 0x080fe20000410000ULL, 0x000000183b3b7220ULL, 0x080fe20000410000ULL,
0x000000183e3e7220ULL, 0x080fe20000410000ULL, 0x000000183f3f7220ULL, 0x080fe20000410000ULL,
0x0000001812127220ULL, 0x080fe20000410000ULL, 0x0000001813137220ULL, 0x080fe20000410000ULL,
0x0000001816167220ULL, 0x080fe20000410000ULL, 0x0000001817177220ULL, 0x080fe20000410000ULL,
0x000000181e1e7220ULL, 0x080fe20000410000ULL, 0x000000181f1f7220ULL, 0x000fce0000410000ULL,
0x0000ffff1bff7812ULL, 0x000fda0007806020ULL, 0x8000005f19190221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b19190820ULL, 0x000fc80000410000ULL, 0x00000019000c0308ULL, 0x000ea40000000800ULL,
0x0000000c5e5e0220ULL, 0x004fce0000410000ULL, 0x0000000708537812ULL, 0x000fe200078ec0ffULL,
0x000000024a607824ULL, 0x000fe200078e00ffULL, 0x0000000808507812ULL, 0x000fe200078ec0ffULL,
0x000002004a187824ULL, 0x002fe200078e00ffULL, 0x00000004ff627819ULL, 0x000fe20000011608ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000053501b7212ULL, 0x000fe400078efcffULL,
0x00000008534f7812ULL, 0x000fe400078ef808ULL, 0x000000031b197819ULL, 0x040fe200000006ffULL,
0x00000001621a7824ULL, 0x000fe200078e021bULL, 0x00000001ff597819ULL, 0x000fe2000001164aULL,
0x000000081b477824ULL, 0x000fe200078e00ffULL, 0xfffff80018187812ULL, 0x000fe200078ec0ffULL,
0x000000021a467836ULL, 0x000fe40000000000ULL, 0x00004000595a7824ULL, 0x000fe200078e0207ULL,
0x0000001807517210ULL, 0x000fe20007ffe0ffULL, 0x000000081b187824ULL, 0x040fe200078e00ffULL,
0xfffffff819467812ULL, 0x000fe200078ee246ULL, 0x000000081b1b7824ULL, 0x000fe200078e00ffULL,
0x0000000460197812ULL, 0x000fe200078ec0ffULL, 0x000000041a457836ULL, 0x000fe20000000000ULL,
0xfffffff847477812ULL, 0x000fe200078ee21aULL, 0x000000061a527836ULL, 0x000fe20000000000ULL,
0x0000001908547211ULL, 0x000fe200078fe0ffULL, 0x000000084f197824ULL, 0x000fe200078e00ffULL,
0xfffffff818457812ULL, 0x000fe200078ee245ULL, 0x0000200002617824ULL, 0x000fe200078e025aULL,
0x000000544f547210ULL, 0x000fc40007ffe0ffULL, 0xfffffff81b527812ULL, 0x000fe200078ee252ULL,
0x0001300061617836ULL, 0x000fe20000000000ULL, 0xfffffff819587812ULL, 0x000fc800078ee254ULL,
0x0000005158587211ULL, 0x000fe200078e20ffULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff1b7819ULL, 0x000fe40000011608ULL, 0x0000000cff0d723eULL, 0x000fc600000010ffULL,
0x000000081b197836ULL, 0x000fe20000000000ULL, 0x000054100d187816ULL, 0x000fca000000000dULL,
0x00001f1b180d7589ULL, 0x0002a800000e0000ULL, 0x00001f19180e7589ULL, 0x0002e400000e0000ULL,
0x011000005818783bULL, 0x0022e20000000200ULL, 0x0000001047577824ULL, 0x100fe400078e0261ULL,
0x0000001046407824ULL, 0x100fe400078e0261ULL, 0x0000001045287824ULL, 0x000fe200078e0261ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000d18187232ULL, 0x08cfe40000200000ULL,
0x0000000d1a1a7232ULL, 0x000fe40000200000ULL, 0x0000000e19197232ULL, 0x080fe40000200000ULL,
0x0000000e1b1b7232ULL, 0x000fce0000200000ULL, 0x0000006152207211ULL, 0x000fe200078e20ffULL,
0x000000002828783bULL, 0x000f620000004200ULL, 0x0000000459627824ULL, 0x000fc600078e0262ULL,
0x000000005724783bULL, 0x000be80000004200ULL, 0x000000002020783bULL, 0x000f680000004200ULL,
0x000000004040783bULL, 0x000f640000004200ULL, 0x0000000262577810ULL, 0x028fe20007ffe04fULL,
0x00000028183c723cULL, 0x002fec000004183cULL, 0x0000002a1810723cULL, 0x000fe20000041810ULL,
0x0000001050297812ULL, 0x000fe200078efe53ULL, 0x000000084f287824ULL, 0x000fc800078e00ffULL,
0x000000201814723cULL, 0x004fe20000041814ULL, 0xfffffff828577812ULL, 0x000fe200078ee257ULL,
0x00000008292a7824ULL, 0x040fe400078e00ffULL, 0x0000000829537824ULL, 0x040fe400078e00ffULL,
0x00000024182c723cULL, 0x000fe2000004182cULL, 0x0000002908207211ULL, 0x000fe200078fe0ffULL,
0x0000000829217824ULL, 0x000fc600078e00ffULL, 0x0000000220507810ULL, 0x000fe20007ffe0ffULL,
0x000000401834723cULL, 0x000fe20000041834ULL, 0x00000004204f7836ULL, 0x000fe20000000000ULL,
0xfffffff853537812ULL, 0x000fe400078ee220ULL, 0xfffffff821507812ULL, 0x000fe400078ee250ULL,
0x000000421838723cULL, 0x000fe20000041838ULL, 0xfffffff82a4f7812ULL, 0x000fe200078ee24fULL,
0x00000010532a7824ULL, 0x100fe400078e0261ULL, 0x0000001050407824ULL, 0x000fc400078e0261ULL,
0x000000261824723cULL, 0x000fec0000041830ULL, 0x00000022181c723cULL, 0x000fe2000004181cULL,
0x000000104f307824ULL, 0x000fcc00078e0261ULL, 0x0000001057187824ULL, 0x000fe200078e0251ULL,
0x0000000620517810ULL, 0x000fe20007ffe0ffULL, 0x0000000829227824ULL, 0x000fc800078e00ffULL,
0x011000001818783bULL, 0x000e620000000200ULL, 0x0000000000108947ULL, 0x000ff40003800000ULL,
0x0000000d18187232ULL, 0x082fe40000200000ULL, 0x0000000d1a1a7232ULL, 0x000fe40000200000ULL,
0x0000000e19197232ULL, 0x080fe40000200000ULL, 0x0000000e1b1b7232ULL, 0x000fce0000200000ULL,
0xfffffff822517812ULL, 0x000fe200078ee251ULL, 0x000000002a28783bULL, 0x000ea20000004200ULL,
0xfffffff860607812ULL, 0x000fe200078ec0ffULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000005b5e5e7221ULL, 0x000fe20000010000ULL, 0x0000001051207824ULL, 0x000fe200078e0261ULL,
0x000000004040783bULL, 0x000ee20000004200ULL, 0x000000045d5d7c24ULL, 0x010fc6000f8e02ffULL,
0x000000003030783bULL, 0x000fe20000004200ULL, 0x000000405d5d7824ULL, 0x000fc600078e00ffULL,
0x000000002020783bULL, 0x000f220000004200ULL, 0x00000028182c723cULL, 0x006fe2000004182cULL,
0x00008e00ff287b82ULL, 0x000e6a0000000a00ULL, 0x000000401834723cULL, 0x008fec0000041834ULL,
0x000000421838723cULL, 0x000fec0000041838ULL, 0x000000201814723cULL, 0x010fe20000041814ULL,
0x0000000100427802ULL, 0x000fca0000000f00ULL, 0x00000030183c723cULL, 0x000fe2000004183cULL,
0x000000014e207836ULL, 0x000fe40000000000ULL, 0x0000000107217824ULL, 0x000fe400078e0260ULL,
0x000001005d287825ULL, 0x002fe200078e0028ULL, 0x000000321810723cULL, 0x000fe20000041810ULL,
0x0000000f2000720cULL, 0x000fe20003f06070ULL, 0x01b6884221ff79a7ULL, 0x0003e8000850003fULL,
0x0000002a1824723cULL, 0x000fec0000041824ULL, 0x000000221818723cULL, 0x000fee000004181cULL,
0x000000084e1c7824ULL, 0x000fca00078e0259ULL, 0x000000801c1e7811ULL, 0x000fc800078e28ffULL,
0x000000201e1c7812ULL, 0x000fc800078ec0ffULL, 0x0000001c03337210ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400948947ULL, 0x002fea0003800000ULL,
0x00000003ff5b7819ULL, 0x000fe20000011608ULL, 0x000020004a1c7824ULL, 0x000fe200078e00ffULL,
0x0000001e49327248ULL, 0x000fe20007fe0000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0a1eULL,
0x0000000c5b617810ULL, 0x000fe20007ffe0ffULL, 0x000000045b237836ULL, 0x000fe20000000000ULL,
0x000020001c217812ULL, 0x000fe200078ec0ffULL, 0x000000804a1f7824ULL, 0x000fe200078e00ffULL,
0x0000002032327446ULL, 0x000fe2000380001dULL, 0x00000001231c7824ULL, 0x140fe200078e0208ULL,
0x0000000323437819ULL, 0x000fe200000006ffULL, 0x000000015b1d7824ULL, 0x040fe200078e0208ULL,
0x000130005a5a7810ULL, 0x000fe20007ffe021ULL, 0x000000015b217824ULL, 0x100fe200078e0233ULL,
0xfffffff843437812ULL, 0x000fe200078ee21cULL, 0x000000085b5d7836ULL, 0x000fe20000000000ULL,
0x00000080441c7812ULL, 0x000fe200078ef81fULL, 0x00000001231f7824ULL, 0x100fe200078e0233ULL,
0x000000071d317812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x000000322300720cULL, 0x080fe20003f26070ULL, 0x000000015d2b7824ULL, 0x000fe200078e0233ULL,
0x000000325b00720cULL, 0x000fe20003f06070ULL, 0x0000010021207825ULL, 0x000fe200078e001cULL,
0x0ffffff831317812ULL, 0x000fc400078ef808ULL, 0x000000325d00720cULL, 0x080fe20003fa6070ULL,
0x000001001f1e7825ULL, 0x000fe200078e001cULL, 0x0000002028207210ULL, 0x000fe40007f5e0ffULL,
0x000000326100720cULL, 0x040fe20003f86070ULL, 0x0000000161237824ULL, 0x000fe200078e0233ULL,
0x0000001e281e7210ULL, 0x000fe20007f7e0ffULL, 0x000001002b2a7825ULL, 0x000fe200078e001cULL,
0x0000002129217210ULL, 0x000fc600017fe4ffULL, 0x0000010023227825ULL, 0x000fe200078e001cULL,
0x0000002a28307210ULL, 0x000fc60007f5e0ffULL, 0x00000001291f7824ULL, 0x000fe200018e061fULL,
0x00000022282a7210ULL, 0x000fe20007f7e0ffULL, 0x000000105b637836ULL, 0x000fe20000000000ULL,
0x000000085d227210ULL, 0x000fe20007ffe0ffULL, 0x0000001031417824ULL, 0x100fe400078e025aULL,
0x0000000129317824ULL, 0x000fe200010e062bULL, 0x00000023292b7210ULL, 0x000fe20001ffe4ffULL,
0x0000001043437824ULL, 0x000fe200078e025aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020417faeULL, 0x0003e2000c101c46ULL, 0x000000145b657836ULL, 0x000fe20000000000ULL,
0x000000326300720cULL, 0x0c0fe20003f66070ULL, 0x0000000163237824ULL, 0x000fe200078e0233ULL,
0x000000001e437faeULL, 0x0005e2000c901c46ULL, 0x000000085d5d7824ULL, 0x000fe200078e00ffULL,
0x000000326500720cULL, 0x000fe20003f46070ULL, 0x000000185b677836ULL, 0x000fc40000000000ULL,
0x0000001c5b697836ULL, 0x000fe40000000000ULL, 0x00000008635b7824ULL, 0x000fe200078e00ffULL,
0x0000003365217210ULL, 0x002fe20007ffe0ffULL, 0x0000000161207824ULL, 0x100fe200078e0208ULL,
0xfffffff85d417812ULL, 0x000fe200078ee222ULL, 0x0000000163227824ULL, 0x000fe200078e0208ULL,
0x000000326700720cULL, 0x080fe20003f26070ULL, 0x0000000861437824ULL, 0x004fe200078e00ffULL,
0x000000326900720cULL, 0x000fe20003f06070ULL, 0x00000100231e7825ULL, 0x000fe200078e001cULL,
0x00000003655d7819ULL, 0x000fc400000006ffULL, 0xfffffff843437812ULL, 0x000fe200078ee220ULL,
0x0000010021207825ULL, 0x000fe200078e001cULL, 0x0000001e281e7210ULL, 0x000fe40007fde0ffULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee222ULL, 0x0000000167237824ULL, 0x040fe200078e0233ULL,
0x0000000367617819ULL, 0x000fe200000006ffULL, 0x00000001291f7824ULL, 0x000fe200030e061fULL,
0x0000002028207210ULL, 0x000fe20007fde0ffULL, 0x0000000165327824ULL, 0x000fe400078e0208ULL,
0x0000010023227825ULL, 0x000fc600078e001cULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee232ULL,
0x0000000169337824ULL, 0x000fe400078e0233ULL, 0x0000000129217824ULL, 0x000fe200030e0621ULL,
0x0000002228227210ULL, 0x000fe20007fde0ffULL, 0x0000000167327824ULL, 0x100fe400078e0208ULL,
0x0000000169407824ULL, 0x040fe400078e0208ULL, 0x0000000869637824ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fe200078ee232ULL, 0x00000100331c7825ULL, 0x000fc600078e001cULL,
0xfffffff863637812ULL, 0x000fe200078ee240ULL, 0x0000000129237824ULL, 0x000fe200030e0623ULL,
0x0000001c281c7210ULL, 0x000fe20007fde0ffULL, 0x0000001041337824ULL, 0x100fe200078e025aULL,
0x0000005a43417211ULL, 0x000fe200078e20ffULL, 0x000000105b437824ULL, 0x100fe200078e025aULL,
0x0000001d291d7210ULL, 0x000fe200037fe4ffULL, 0x000000105d5b7824ULL, 0x100fe200078e025aULL,
0x0000000030337faeULL, 0x0003e2000e901c46ULL, 0x00000010615d7824ULL, 0x100fe400078e025aULL,
0x0000001063617824ULL, 0x000fe200078e025aULL, 0x000000002a417faeULL, 0x0003e8000e101c46ULL,
0x000000001e437faeULL, 0x0003e8000d901c46ULL, 0x00000000205b7faeULL, 0x0003e8000d101c46ULL,
0x00000000225d7faeULL, 0x0003e8000c901c46ULL, 0x000000001c617faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x000020004a1c7824ULL, 0x000fe200078e00ffULL,
0x00000004081f7811ULL, 0x040fe400078fe8ffULL, 0x0000000808317811ULL, 0x000fe400078fe8ffULL,
0x000020001c1d7812ULL, 0x000fe200078ec0ffULL, 0x000000011f637824ULL, 0x140fe200078e0208ULL,
0x0000000c08217811ULL, 0x040fe200078fe8ffULL, 0x000000081f1c7824ULL, 0x000fe200078e00ffULL,
0x0000001008237811ULL, 0x000fe200078fe8ffULL, 0x0000000131617824ULL, 0x100fe200078e0208ULL,
0x000130005a5a7810ULL, 0x000fe20007ffe01dULL, 0x00000001215d7824ULL, 0x140fe200078e0208ULL,
0xfffffff81c637812ULL, 0x000fe200078ee263ULL, 0x00000008211e7824ULL, 0x000fe200078e00ffULL,
0x00000003311c7819ULL, 0x000fe200000006ffULL, 0x000000804a1d7824ULL, 0x000fe200078e00ffULL,
0x0000001c08677811ULL, 0x040fe200078fe8ffULL, 0x00000001235b7824ULL, 0x140fe200078e0208ULL,
0xfffffff81c617812ULL, 0x000fe200078ee261ULL, 0x0000000823207824ULL, 0x000fe200078e00ffULL,
0xfffffff81e5d7812ULL, 0x000fe200078ee25dULL, 0x000000011f1f7824ULL, 0x100fe200078e0233ULL,
0x00000008081c7211ULL, 0x040fe200078fe8ffULL, 0x00000008676d7824ULL, 0x000fe200078e00ffULL,
0x00000018081e7811ULL, 0x000fe200078fe8ffULL, 0x0000000131317824ULL, 0x100fe200078e0233ULL,
0x000000071c697812ULL, 0x000fe200078ec0ffULL, 0x0000000123237824ULL, 0x100fe200078e0233ULL,
0x00000080441c7812ULL, 0x000fe200078ef81dULL, 0x000000011e1d7824ULL, 0x140fe200078e0208ULL,
0xfffffff8205b7812ULL, 0x000fe200078ee25bULL, 0x000000011e657824ULL, 0x140fe200078e0233ULL,
0x000000031e207819ULL, 0x000fe200000006ffULL, 0x00000001671e7824ULL, 0x040fe200078e0208ULL,
0x00000014082b7811ULL, 0x040fe200078fe8ffULL, 0x0000000167677824ULL, 0x100fe200078e0233ULL,
0x0000003308417211ULL, 0x000fe200078fe8ffULL, 0x0000001063637824ULL, 0x000fe200078e025aULL,
0xfffffff8206b7812ULL, 0x000fe200078ee21dULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x000000082b437210ULL, 0x000fe20007ffe0ffULL, 0x000000082b227824ULL, 0x040fe200078e00ffULL,
0x0000003321217210ULL, 0x000fe20007ffe0ffULL, 0x000000012b2b7824ULL, 0x000fe200078e0233ULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee21eULL, 0x0000010041407825ULL, 0x000fe200078e001cULL,
0xfffffff822437812ULL, 0x000fc400078ee243ULL, 0x0ffffff869697812ULL, 0x000fe200078ef808ULL,
0x000001001f327825ULL, 0x100fe200078e001cULL, 0x0000004028407210ULL, 0x000fe40007f1e0ffULL,
0x0000005a43437211ULL, 0x000fe200078e20ffULL, 0x0000010031307825ULL, 0x000fe200078e001cULL,
0x0000003228327210ULL, 0x000fc60007f3e0ffULL, 0x00000100211e7825ULL, 0x000fe200078e001cULL,
0x0000003028307210ULL, 0x000fc60007f5e0ffULL, 0x0000010023207825ULL, 0x100fe200078e001cULL,
0x0000001e281e7210ULL, 0x000fe40007f7e0ffULL, 0x0000003129317210ULL, 0x000fe200017fe4ffULL,
0x000001002b227825ULL, 0x000fc800078e001cULL, 0x00000100652a7825ULL, 0x000fe200078e001cULL,
0x0000005a69657211ULL, 0x000fc600078e20ffULL, 0x00000100671c7825ULL, 0x000fe200078e001cULL,
0x0000002a282a7210ULL, 0x000fc60007f5e0ffULL, 0x0000000129417824ULL, 0x040fe200000e0641ULL,
0x0000002028207210ULL, 0x000fe20007f1e0ffULL, 0x0000000129337824ULL, 0x000fe200008e0633ULL,
0x0000002228227210ULL, 0x000fe20007f3e0ffULL, 0x0000001061617824ULL, 0x100fe200078e025aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040657faeULL, 0x0003e2000b901c46ULL,
0x00000001291f7824ULL, 0x000fe200018e061fULL, 0x0000001c281c7210ULL, 0x000fe20007f7e0ffULL,
0x000000105d5d7824ULL, 0x100fe200078e025aULL, 0x0000000032637faeULL, 0x0003e2000b901c46ULL,
0x000000105b5b7824ULL, 0x000fe200078e025aULL, 0x0000001d291d7210ULL, 0x000fe20001ffe4ffULL,
0x0000000129217824ULL, 0x040fe200000e0621ULL, 0x0000000030617faeULL, 0x0003e2000b901c46ULL,
0x0000000129237824ULL, 0x000fc400008e0623ULL, 0x000000106b677824ULL, 0x100fe200078e025aULL,
0x000000001e5d7faeULL, 0x0003e2000b901c46ULL, 0x00000001292b7824ULL, 0x000fe400010e062bULL,
0x000000106d697824ULL, 0x000fe200078e025aULL, 0x00000000205b7faeULL, 0x0003e8000b901c46ULL,
0x0000000022437faeULL, 0x0003e8000b901c46ULL, 0x000000002a677faeULL, 0x0003e8000b901c46ULL,
0x000000001c697faeULL, 0x0003e4000b901c46ULL, 0x000000035c1c7812ULL, 0x002fe200078ec0ffULL,
0xffffffffff5d7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000031c00780cULL, 0x000fc80003f05270ULL, 0x00000001001d7807ULL, 0x000fca0004000000ULL,
0x000000015c5a7824ULL, 0x000fca00078e021dULL, 0x000000485a00720cULL, 0x000fda0003f06070ULL,
0x00009000ff1c8b82ULL, 0x000e620000000a00ULL, 0x000000010b1f8824ULL, 0x000fe200078e025aULL,
0xffffffe0051e7812ULL, 0x000fc600078ec0ffULL, 0x000000041f1c8825ULL, 0x002fe200078e001cULL,
0x00000010051f7812ULL, 0x000fc800078ec0ffULL, 0x000000071f1f7210ULL, 0x000fe20007ffe01eULL,
0x000000061c5d8981ULL, 0x000322000c1e1900ULL, 0x00000008051e7812ULL, 0x000fca00078ec0ffULL,
0x000000011f237824ULL, 0x000fc800078e021eULL, 0x01b62842234279a7ULL, 0x0002a6000850003fULL,
0x00000000001c7805ULL, 0x002fce0000015200ULL, 0x01b62843230075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ff00207202ULL, 0x000fce0000000f00ULL,
0x000000102000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fce0000015200ULL, 0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000211e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000120207836ULL, 0x000fce0000000000ULL,
0x01b62843230075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000080441c7810ULL, 0x000fe40007ffe056ULL, 0x0000005f005b7202ULL, 0x000fc60000000f00ULL,
0x00000001551c7824ULL, 0x000fca00078e021cULL, 0x01b000001c1e7984ULL, 0x000e680000000800ULL,
0x01b200001c5c7984ULL, 0x0004a20000000800ULL, 0x0000005f1e00720bULL, 0x002fda0003f1d000ULL,
0x00000000001d7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1d1f7812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x004fea0003800000ULL,
0x00000001061d7836ULL, 0x000fe20000000000ULL, 0x0000005f1e00720bULL, 0x000fc80003f14000ULL,
0x0000004a1d00720cULL, 0x000fd20003f25270ULL, 0x0000000000207806ULL, 0x000fc800000e0100ULL,
0x000000804a1d9824ULL, 0x000fe200078e0207ULL, 0x0000005f1e1c9209ULL, 0x000fc80007810000ULL,
0x0000001d55219210ULL, 0x000fe40007ffe044ULL, 0x00009910201d7816ULL, 0x000fc600000000ffULL,
0x01b4001c21009388ULL, 0x0003e20000000800ULL, 0x000000ff1d00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005f1e1c7209ULL, 0x000fe40007810000ULL,
0x000000ff20ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0020ff7812ULL, 0x000fe2000782c0ffULL,
0x0000005f1c1c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL,
0x0000001c001d7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff1c7819ULL, 0x002fcc0000011608ULL, 0x00001f1c1d1c7589ULL, 0x004e6400000e0000ULL,
0x0000002c1c2c7220ULL, 0x042fe20000410000ULL, 0x0000002d1c2d7220ULL, 0x040fe20000410000ULL,
0x000000241c247220ULL, 0x040fe20000410000ULL, 0x000000251c257220ULL, 0x040fe20000410000ULL,
0x000000341c347220ULL, 0x040fe20000410000ULL, 0x000000351c357220ULL, 0x040fe20000410000ULL,
0x000000381c387220ULL, 0x040fe20000410000ULL, 0x000000391c397220ULL, 0x040fe20000410000ULL,
0x0000003c1c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d1c3d7220ULL, 0x040fe20000410000ULL,
0x000000101c107220ULL, 0x040fe20000410000ULL, 0x000000111c117220ULL, 0x040fe20000410000ULL,
0x000000141c147220ULL, 0x040fe20000410000ULL, 0x000000151c157220ULL, 0x040fe20000410000ULL,
0x000000181c187220ULL, 0x040fe20000410000ULL, 0x000000191c197220ULL, 0x000fce0000410000ULL,
0x0000001d5e5e7220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x00000008081c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f1c1d1c7589ULL, 0x000e6400000e0000ULL,
0x0000002e1c2e7220ULL, 0x042fe20000410000ULL, 0x0000002f1c2f7220ULL, 0x040fe20000410000ULL,
0x000000261c267220ULL, 0x040fe20000410000ULL, 0x000000271c277220ULL, 0x040fe20000410000ULL,
0x000000361c367220ULL, 0x040fe20000410000ULL, 0x000000371c377220ULL, 0x040fe20000410000ULL,
0x0000003a1c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b1c3b7220ULL, 0x040fe20000410000ULL,
0x0000003e1c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f1c3f7220ULL, 0x040fe20000410000ULL,
0x000000121c127220ULL, 0x040fe20000410000ULL, 0x000000131c137220ULL, 0x040fe20000410000ULL,
0x000000161c167220ULL, 0x040fe20000410000ULL, 0x000000171c177220ULL, 0x040fe20000410000ULL,
0x0000001a1c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b1c1b7220ULL, 0x000fce0000410000ULL,
0x0000ffff1fff7812ULL, 0x000fe40007806020ULL, 0x0000005f1e5b7209ULL, 0x000fd60007810000ULL,
0x8000005b1e1e0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1e1e0820ULL, 0x000fc80000410000ULL,
0x0000001e000c0308ULL, 0x000ea40000000800ULL, 0x0000000c5c5c0220ULL, 0x004fce0000410000ULL,
0x0000400059597824ULL, 0x000fe200078e0207ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00002000025f7824ULL, 0x000fca00078e0259ULL, 0x000140005f5f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff1d7819ULL, 0x000fe40000011608ULL,
0x0000000cff0d723eULL, 0x000fc600000010ffULL, 0x000000081d1f7836ULL, 0x000fe20000000000ULL,
0x000054100d1c7816ULL, 0x002fca000000000dULL, 0x00001f1d1c0d7589ULL, 0x0002a800000e0000ULL,
0x00001f1f1c0e7589ULL, 0x0002e400000e0000ULL, 0x01180000581c783bULL, 0x0022e20000000200ULL,
0x0000001047607824ULL, 0x100fe400078e025fULL, 0x0000001046407824ULL, 0x100fe400078e025fULL,
0x0000001045287824ULL, 0x000fe200078e025fULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000d1c1c7232ULL, 0x08cfe40000200000ULL, 0x0000000d1e1e7232ULL, 0x000fe40000200000ULL,
0x0000000e1d1d7232ULL, 0x080fe40000200000ULL, 0x0000000e1f1f7232ULL, 0x000fce0000200000ULL,
0x000000006030783bULL, 0x000f620000004200ULL, 0x0000005f52207211ULL, 0x000fc600078e20ffULL,
0x000000004040783bULL, 0x000f680000004200ULL, 0x000000002828783bULL, 0x000f680000004200ULL,
0x000000002020783bULL, 0x000f640000004200ULL, 0x000000301c2c723cULL, 0x02afec000004182cULL,
0x000000321c30723cULL, 0x000fec0000041824ULL, 0x000000401c34723cULL, 0x000fe20000041834ULL,
0x0000080006247824ULL, 0x000fe200078e0207ULL, 0x0000005f4f267211ULL, 0x000fc600078e20ffULL,
0x0000001057247824ULL, 0x000fe200078e0224ULL, 0x000000421c38723cULL, 0x000fe20000041838ULL,
0x0000001053407824ULL, 0x000fca00078e025fULL, 0x000000281c3c723cULL, 0x004fec000004183cULL,
0x0000002a1c10723cULL, 0x000fe20000041810ULL, 0x0000001050287824ULL, 0x000fca00078e025fULL,
0x000000201c14723cULL, 0x000fec0000041814ULL, 0x000000221c18723cULL, 0x000fe20000041818ULL,
0x01180000241c783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000d1c1c7232ULL, 0x084fe40000200000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000200000ULL, 0x0000000e1d1d7232ULL, 0x080fe40000200000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000200000ULL, 0x0000001051207824ULL, 0x000fe200078e025fULL,
0x000000002624783bULL, 0x002e620000004200ULL, 0x00000001ff577819ULL, 0x000fe2000001164aULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000005e5c5c7221ULL, 0x000fe20000010000ULL,
0x000000004040783bULL, 0x000ee20000004200ULL, 0x000000045d5d7c24ULL, 0x010fc6000f8e02ffULL,
0x000000002020783bULL, 0x000f220000004200ULL, 0x000000405d5d7824ULL, 0x000fc600078e00ffULL,
0x000000002828783bULL, 0x000f620000004200ULL, 0x000000241c3c723cULL, 0x006fe2000004183cULL,
0x00008e00ff247b82ULL, 0x000e6a0000000a00ULL, 0x000000401c2c723cULL, 0x008fec000004182cULL,
0x000000201c14723cULL, 0x010fec0000041814ULL, 0x000000421c30723cULL, 0x000fe20000041830ULL,
0x000000014e207810ULL, 0x000fe20007ffe0ffULL, 0x0000000806217824ULL, 0x000fc600078e0207ULL,
0x0000000f2000720cULL, 0x000fe20003f06070ULL, 0x000000281c34723cULL, 0x020fe20000041834ULL,
0x00000001ff427424ULL, 0x000fe400078e00ffULL, 0x000001005d247825ULL, 0x002fe400078e0024ULL,
0x01b6904221ff79a7ULL, 0x0003e2000850003fULL, 0x0000002a1c38723cULL, 0x000fec0000041838ULL,
0x000000261c10723cULL, 0x000fec0000041810ULL, 0x000000221c18723cULL, 0x000fee0000041818ULL,
0x000000084e1e7824ULL, 0x000fca00078e0257ULL, 0x000000c01e1e7811ULL, 0x000fc800078e28ffULL,
0x000000201e1c7812ULL, 0x000fca00078ec0ffULL, 0x00000001032b7824ULL, 0x000fe200078e021cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400948947ULL, 0x002fea0003800000ULL,
0x00000003ff417819ULL, 0x100fe20000011608ULL, 0x000020004a1c7824ULL, 0x040fe200078e00ffULL,
0x0000001e492a7248ULL, 0x000fe20007fe0000ULL, 0x000000804a1f7824ULL, 0x000fe200078e00ffULL,
0x000000ff1e1d7210ULL, 0x000fe20007ffe1ffULL, 0x0000000441237836ULL, 0x000fe20000000000ULL,
0x000020001c1c7812ULL, 0x000fe200078ec0ffULL, 0x00000008415f7836ULL, 0x000fe20000000000ULL,
0x000000202a2a7446ULL, 0x000fe2000380001dULL, 0x00000001231e7824ULL, 0x000fe200078e0208ULL,
0x0001400059597810ULL, 0x000fe20007ffe01cULL, 0x0000000823217824ULL, 0x000fe200078e00ffULL,
0x00000080441c7812ULL, 0x000fe200078ef81fULL, 0x00000001411d7824ULL, 0x000fe200078e0208ULL,
0x0000002a2300720cULL, 0x0c0fe20003f26070ULL, 0x0000000123237824ULL, 0x100fe200078e022bULL,
0xfffffff8215e7812ULL, 0x000fe200078ee21eULL, 0x0000000c41617836ULL, 0x000fe20000000000ULL,
0x0000002b41217210ULL, 0x000fe20007ffe0ffULL, 0x0000001041637836ULL, 0x000fe20000000000ULL,
0x000000071d297812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x0000002b5f277210ULL, 0x000fe20007ffe0ffULL, 0x00000001611f7824ULL, 0x000fe200078e022bULL,
0x0000002a4100720cULL, 0x000fe20003f06070ULL, 0x0000010021207825ULL, 0x000fe200078e001cULL,
0x0ffffff829407812ULL, 0x000fc400078ef808ULL, 0x0000002a5f00720cULL, 0x080fe20003fa6070ULL,
0x0000010023227825ULL, 0x100fe200078e001cULL, 0x0000002024207210ULL, 0x000fe40007f5e0ffULL,
0x0000001841677810ULL, 0x000fe20007ffe0ffULL, 0x0000010027267825ULL, 0x000fe200078e001cULL,
0x0000002224227210ULL, 0x000fe40007f7e0ffULL, 0x0000002a6100720cULL, 0x000fe20003f86070ULL,
0x0000000125217824ULL, 0x000fe200010e0621ULL, 0x0000002624287210ULL, 0x000fe20007f5e0ffULL,
0x000001001f1e7825ULL, 0x000fc600078e001cULL, 0x0000002725297210ULL, 0x000fe200017fe4ffULL,
0x0000001040437824ULL, 0x000fe200078e0259ULL, 0x0000000861407210ULL, 0x000fe20007ffe0ffULL,
0x0000000125237824ULL, 0x000fe200018e0623ULL, 0x0000001e241e7210ULL, 0x000fe20007f7e0ffULL,
0x000000105e5d7824ULL, 0x000fe200078e0259ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020437faeULL, 0x0003e2000c101c46ULL, 0x0000000163277824ULL, 0x000fe400078e022bULL,
0x0000001441657836ULL, 0x000fe20000000000ULL, 0x00000000225d7faeULL, 0x0005e2000c901c46ULL,
0x0000001c41697836ULL, 0x000fe20000000000ULL, 0x0000002a6700720cULL, 0x080fe20003f26070ULL,
0x000000015f267824ULL, 0x000fe200078e0208ULL, 0x0000002a6500720cULL, 0x080fe20003f46070ULL,
0x000000085f5f7824ULL, 0x000fe200078e00ffULL, 0x0000002a6900720cULL, 0x080fe20003f06070ULL,
0x00000001251f7824ULL, 0x000fe200018e061fULL, 0x0000002a6300720cULL, 0x000fe20003f66070ULL,
0x0000010027207825ULL, 0x002fe200078e001cULL, 0xfffffff85f2a7812ULL, 0x000fc600078ee226ULL,
0x0000000165237824ULL, 0x004fe200078e022bULL, 0x0000002024207210ULL, 0x000fe20007fde0ffULL,
0x0000000163267824ULL, 0x040fe200078e0208ULL, 0x0000000363637819ULL, 0x000fe200000006ffULL,
0x0000010023227825ULL, 0x000fc600078e001cULL, 0xfffffff8635e7812ULL, 0x000fe200078ee226ULL,
0x0000000167277824ULL, 0x000fe200078e022bULL, 0x0000002b692b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000125217824ULL, 0x000fe200030e0621ULL, 0x0000002224227210ULL, 0x000fe20007fde0ffULL,
0x0000000165417824ULL, 0x040fe400078e0208ULL, 0x0000000865607824ULL, 0x000fe400078e00ffULL,
0x0000010027267825ULL, 0x000fc600078e001cULL, 0xfffffff860607812ULL, 0x000fe200078ee241ULL,
0x0000000861617824ULL, 0x000fe400078e00ffULL, 0x0000000125237824ULL, 0x000fe200030e0623ULL,
0x0000002624267210ULL, 0x000fe20007fde0ffULL, 0x0000000167417824ULL, 0x140fe200078e0208ULL,
0xfffffff861407812ULL, 0x000fe200078ee240ULL, 0x0000000867627824ULL, 0x000fe200078e00ffULL,
0x0000002725277210ULL, 0x000fe200037fe4ffULL, 0x0000000169437824ULL, 0x040fe400078e0208ULL,
0x0000000869647824ULL, 0x000fe200078e00ffULL, 0xfffffff862627812ULL, 0x000fe200078ee241ULL,
0x000001002b1c7825ULL, 0x000fc600078e001cULL, 0xfffffff864647812ULL, 0x000fe200078ee243ULL,
0x000000102a2b7824ULL, 0x100fe200078e0259ULL, 0x0000001c241c7210ULL, 0x000fe20007fde0ffULL,
0x0000001040417824ULL, 0x100fe200078e0259ULL, 0x00000059625f7211ULL, 0x000fe200078e20ffULL,
0x000000105e437824ULL, 0x100fe200078e0259ULL, 0x00000000282b7faeULL, 0x0003e2000e901c46ULL,
0x00000010605d7824ULL, 0x100fe400078e0259ULL, 0x0000001064597824ULL, 0x000fe200078e0259ULL,
0x000000001e417faeULL, 0x0003e2000e101c46ULL, 0x00000001251d7824ULL, 0x000fc600030e061dULL,
0x0000000020437faeULL, 0x0003e8000d901c46ULL, 0x00000000225d7faeULL, 0x0003e8000d101c46ULL,
0x00000000265f7faeULL, 0x0003e8000c901c46ULL, 0x000000001c597faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x00000004081f7811ULL, 0x000fe200078fe8ffULL,
0x000020004a1c7824ULL, 0x000fe200078e00ffULL, 0x0000000808217811ULL, 0x000fe400078fe8ffULL,
0x000000031f1d7819ULL, 0x040fe200000006ffULL, 0x000000011f667824ULL, 0x100fe200078e0208ULL,
0x000020001c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000121647824ULL, 0x040fe200078e0208ULL,
0x0000001408297811ULL, 0x040fe400078fe8ffULL, 0xfffffff81d667812ULL, 0x000fe200078ee266ULL,
0x00000008211d7824ULL, 0x000fe200078e00ffULL, 0x0001400059597810ULL, 0x000fe20007ffe01cULL,
0x00000001295e7824ULL, 0x140fe200078e0208ULL, 0x0000001008277811ULL, 0x000fe200078fe8ffULL,
0x00000008295d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d647812ULL, 0x000fe200078ee264ULL,
0x000000804a1d7824ULL, 0x000fe200078e00ffULL, 0x0000000c08237811ULL, 0x040fe200078fe8ffULL,
0x0000000827437824ULL, 0x000fe200078e00ffULL, 0x00000008081c7211ULL, 0x040fe200078fe8ffULL,
0x0000000121217824ULL, 0x100fe200078e022bULL, 0x00000018081e7811ULL, 0x000fe200078fe8ffULL,
0x0000000123627824ULL, 0x140fe200078e0208ULL, 0x000000071c5f7812ULL, 0x000fe200078ec0ffULL,
0x0000000823417824ULL, 0x040fe200078e00ffULL, 0x0000000827607210ULL, 0x000fe20007ffe0ffULL,
0x000000081e6a7824ULL, 0x040fe200078e00ffULL, 0xfffffff85d5e7812ULL, 0x000fe200078ee25eULL,
0x0000000123237824ULL, 0x100fe200078e022bULL, 0x00000080441c7812ULL, 0x000fe200078ef81dULL,
0x000000011e1d7824ULL, 0x100fe200078e0208ULL, 0x0000001c085d7811ULL, 0x000fe200078fe8ffULL,
0x0000000127277824ULL, 0x100fe200078e022bULL, 0xfffffff843607812ULL, 0x000fe200078ee260ULL,
0x0000000129297824ULL, 0x000fe200078e022bULL, 0xfffffff841627812ULL, 0x000fe200078ee262ULL,
0x000000085d617824ULL, 0x040fe200078e00ffULL, 0x0000002b1e437210ULL, 0x000fe20007ffe0ffULL,
0x000000015d1e7824ULL, 0x000fe200078e0208ULL, 0x0000002b1f1f7210ULL, 0x000fe20007ffe0ffULL,
0x0000001060637824ULL, 0x100fe200078e0259ULL, 0x0000002b08417211ULL, 0x000fe200078fe8ffULL,
0x000000105e657824ULL, 0x000fe200078e0259ULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee21dULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000002b5d5d7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff8616c7812ULL, 0x000fe200078ee21eULL, 0x0000010041407825ULL, 0x100fe200078e001cULL,
0x0ffffff85f687812ULL, 0x000fe400078ef808ULL, 0x0000005962617211ULL, 0x000fe200078e20ffULL,
0x000001001f2a7825ULL, 0x000fe200078e001cULL, 0x0000004024407210ULL, 0x000fc60007f1e0ffULL,
0x00000100211e7825ULL, 0x100fe200078e001cULL, 0x0000002a242a7210ULL, 0x000fe40007f3e0ffULL,
0x0000004125417210ULL, 0x000fe200007fe4ffULL, 0x0000010023207825ULL, 0x000fe200078e001cULL,
0x0000001e241e7210ULL, 0x000fc60007f5e0ffULL, 0x0000010027227825ULL, 0x000fe200078e001cULL,
0x0000002024207210ULL, 0x000fc60007f7e0ffULL, 0x0000010029267825ULL, 0x000fe200078e001cULL,
0x0000002224227210ULL, 0x000fc60007f1e0ffULL, 0x0000010043287825ULL, 0x000fc800078e001cULL,
0x000001005d1c7825ULL, 0x000fc800078e001cULL, 0x0000001068437824ULL, 0x000fe400078e0259ULL,
0x00000001252b7824ULL, 0x040fe200008e062bULL, 0x0000002624267210ULL, 0x000fe20007f3e0ffULL,
0x00000001251f7824ULL, 0x040fe200010e061fULL, 0x0000002824287210ULL, 0x000fe20007f5e0ffULL,
0x00000010665d7824ULL, 0x000fe200078e0259ULL, 0x0000002725277210ULL, 0x000fe20000ffe4ffULL,
0x0000000125217824ULL, 0x040fe200018e0621ULL, 0x0000001c241c7210ULL, 0x000fe20007f7e0ffULL,
0x00000010645f7824ULL, 0x000fe200078e0259ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040437faeULL, 0x0003e2000b901c46ULL, 0x0000000125237824ULL, 0x000fc400000e0623ULL,
0x000000106a677824ULL, 0x000fe200078e0259ULL, 0x000000002a5d7faeULL, 0x0003e2000b901c46ULL,
0x0000000125297824ULL, 0x040fe400010e0629ULL, 0x000000106c597824ULL, 0x000fe200078e0259ULL,
0x000000001e5f7faeULL, 0x0003e2000b901c46ULL, 0x00000001251d7824ULL, 0x000fc600018e061dULL,
0x0000000020617faeULL, 0x0003e8000b901c46ULL, 0x0000000022637faeULL, 0x0003e8000b901c46ULL,
0x0000000026657faeULL, 0x0003e8000b901c46ULL, 0x0000000028677faeULL, 0x0003e8000b901c46ULL,
0x000000001c597faeULL, 0x0003e4000b901c46ULL, 0x000000035a1c7812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff00597802ULL, 0x000fe40000000f00ULL,
0x000000031c00780cULL, 0x000fc80003f05270ULL, 0x00000001001d7807ULL, 0x000fca0004000000ULL,
0x000000015a5a7824ULL, 0x000fca00078e021dULL, 0x000000485a00720cULL, 0x000fda0003f06070ULL,
0x00009000ff1c8b82ULL, 0x000e620000000a00ULL, 0x000000010b1f8824ULL, 0x000fe200078e025aULL,
0x0000000805217812ULL, 0x000fe200078ec0ffULL, 0x00000020061e7824ULL, 0x000fe400078e0207ULL,
0x000000041f1c8825ULL, 0x002fe200078e001cULL, 0x00000010051f7812ULL, 0x000fc800078ec0ffULL,
0x0000001e21217210ULL, 0x000fe20007ffe01fULL, 0x000000061c598981ULL, 0x000326000c1e1900ULL,
0x01b64842214279a7ULL, 0x0002a6000850003fULL, 0x00000000001c7805ULL, 0x002fce0000015200ULL,
0x01b64843210075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff207224ULL, 0x000fce00078e00ffULL, 0x000000102000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fce0000015200ULL,
0x0000001e1c237210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000231e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fce0007ffe0ffULL, 0x01b64843210075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000100441c7810ULL, 0x000fe20007ffe056ULL,
0x000000ffff5e7224ULL, 0x000fc800078e005bULL, 0x00000001551c7824ULL, 0x000fca00078e021cULL,
0x01b000001c1e7984ULL, 0x000e680000000800ULL, 0x01b200001c5d7984ULL, 0x0004a20000000800ULL,
0x0000005b1e00720bULL, 0x002fda0003f1d000ULL, 0x00000000001d7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff1d1f7812ULL, 0x000fda000782c0ffULL,
0x0000000000f89947ULL, 0x004fea0003800000ULL, 0x00000002061d7836ULL, 0x000fe20000000000ULL,
0x0000005b1e00720bULL, 0x000fc80003f14000ULL, 0x0000004a1d00720cULL, 0x000fd20003f25270ULL,
0x0000000000207806ULL, 0x000fc800000e0100ULL, 0x000000804a1d9824ULL, 0x000fe200078e0207ULL,
0x0000005b1e1c9209ULL, 0x000fc80007810000ULL, 0x0000001d55219210ULL, 0x000fe40007ffe044ULL,
0x00009910201d7816ULL, 0x000fc600000000ffULL, 0x01b4001c21009388ULL, 0x0003e20000000800ULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005b1e1c7209ULL, 0x000fe40007810000ULL, 0x000000ff20ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0020ff7812ULL, 0x000fe2000782c0ffULL, 0x0000005b1c1c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL, 0x0000001c001d7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff1c7819ULL, 0x002fcc0000011608ULL,
0x00001f1c1d1c7589ULL, 0x004e6400000e0000ULL, 0x0000002c1c2c7220ULL, 0x042fe20000410000ULL,
0x0000002d1c2d7220ULL, 0x040fe20000410000ULL, 0x000000301c307220ULL, 0x040fe20000410000ULL,
0x000000311c317220ULL, 0x040fe20000410000ULL, 0x000000341c347220ULL, 0x040fe20000410000ULL,
0x000000351c357220ULL, 0x040fe20000410000ULL, 0x000000381c387220ULL, 0x040fe20000410000ULL,
0x000000391c397220ULL, 0x040fe20000410000ULL, 0x0000003c1c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d1c3d7220ULL, 0x040fe20000410000ULL, 0x000000101c107220ULL, 0x040fe20000410000ULL,
0x000000111c117220ULL, 0x040fe20000410000ULL, 0x000000141c147220ULL, 0x040fe20000410000ULL,
0x000000151c157220ULL, 0x040fe20000410000ULL, 0x000000181c187220ULL, 0x040fe20000410000ULL,
0x000000191c197220ULL, 0x000fce0000410000ULL, 0x0000001d5c5c7220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000008081c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f1c1d1c7589ULL, 0x000e6400000e0000ULL, 0x0000002e1c2e7220ULL, 0x042fe20000410000ULL,
0x0000002f1c2f7220ULL, 0x040fe20000410000ULL, 0x000000321c327220ULL, 0x040fe20000410000ULL,
0x000000331c337220ULL, 0x040fe20000410000ULL, 0x000000361c367220ULL, 0x040fe20000410000ULL,
0x000000371c377220ULL, 0x040fe20000410000ULL, 0x0000003a1c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b1c3b7220ULL, 0x040fe20000410000ULL, 0x0000003e1c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f1c3f7220ULL, 0x040fe20000410000ULL, 0x000000121c127220ULL, 0x040fe20000410000ULL,
0x000000131c137220ULL, 0x040fe20000410000ULL, 0x000000161c167220ULL, 0x040fe20000410000ULL,
0x000000171c177220ULL, 0x040fe20000410000ULL, 0x0000001a1c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b1c1b7220ULL, 0x000fce0000410000ULL, 0x0000ffff1fff7812ULL, 0x000fe40007806020ULL,
0x0000005b1e5e7209ULL, 0x000fd60007810000ULL, 0x8000005e1e1e0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1e1e0820ULL, 0x000fc80000410000ULL, 0x0000001e000c0308ULL, 0x000ea40000000800ULL,
0x0000000c5d5d0220ULL, 0x004fce0000410000ULL, 0x00000007575b7211ULL, 0x000fe200078e70ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000200002607824ULL, 0x000fc800078e025bULL,
0x0001300060607836ULL, 0x000fe20000000000ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff1d7819ULL, 0x000fe40000011608ULL, 0x0000000cff0d723eULL, 0x000fc600000010ffULL,
0x000000081d1f7836ULL, 0x000fe20000000000ULL, 0x000054100d1c7816ULL, 0x002fca000000000dULL,
0x00001f1d1c0d7589ULL, 0x0002a800000e0000ULL, 0x00001f1f1c0e7589ULL, 0x0002e400000e0000ULL,
0x01200000581c783bULL, 0x0022e20000000200ULL, 0x0000001047407824ULL, 0x100fe200078e0260ULL,
0x0000006046287211ULL, 0x000fe200078e20ffULL, 0x0000001045247824ULL, 0x000fe200078e0260ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000d1c1c7232ULL, 0x08cfe40000200000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000200000ULL, 0x0000000e1d1d7232ULL, 0x080fe40000200000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000200000ULL, 0x000000002424783bULL, 0x000f620000004200ULL,
0x0000001052207824ULL, 0x000fe400078e0260ULL, 0x00000002545f7836ULL, 0x000fe20000000000ULL,
0x000000004040783bULL, 0x000f680000004200ULL, 0x000000002020783bULL, 0x000f680000004200ULL,
0x000000002828783bULL, 0x000f640000004200ULL, 0x000000241c3c723cULL, 0x02afec000004183cULL,
0x000000401c2c723cULL, 0x000fe2000004182cULL, 0x0000000708257812ULL, 0x000fc800078ec0ffULL,
0x0000000825257812ULL, 0x000fe200078ef808ULL, 0x000000201c14723cULL, 0x004fe20000041814ULL,
0x0000001053407824ULL, 0x000fc600078e0260ULL, 0x0000000825247824ULL, 0x000fe400078e00ffULL,
0x000000421c30723cULL, 0x000fe20000041830ULL, 0x0000000706207211ULL, 0x000fe400078e58ffULL,
0xfffffff8245f7812ULL, 0x000fe200078ee25fULL, 0x000000104f247824ULL, 0x000fe400078e0260ULL,
0x000000281c34723cULL, 0x000fe40000041834ULL, 0x000000105f207824ULL, 0x000fc800078e0220ULL,
0x0000002a1c38723cULL, 0x000fe20000041838ULL, 0x0000001050287824ULL, 0x000fca00078e0260ULL,
0x000000261c10723cULL, 0x000fec0000041810ULL, 0x000000221c18723cULL, 0x000fe20000041818ULL,
0x01200000201c783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000d1c1c7232ULL, 0x084fe40000200000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000200000ULL, 0x0000000e1d1d7232ULL, 0x080fe40000200000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000200000ULL, 0x0000006051207211ULL, 0x002fe200078e20ffULL,
0x000000004040783bULL, 0x000e620000004200ULL, 0x0000005c5d5c7221ULL, 0x000fc60000010000ULL,
0x000000002828783bULL, 0x000ee80000004200ULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x000000002020783bULL, 0x000ee20000004200ULL, 0x000000401c2c723cULL, 0x006fec000004182cULL,
0x000000421c30723cULL, 0x000fec0000041830ULL, 0x000000281c34723cULL, 0x008fe20000041834ULL,
0x00000001ff427424ULL, 0x000fca00078e00ffULL, 0x0000002a1c38723cULL, 0x000fec0000041838ULL,
0x000000241c3c723cULL, 0x020fec000004183cULL, 0x000000261c10723cULL, 0x000fec0000041810ULL,
0x000000201c14723cULL, 0x000fec0000041814ULL, 0x000000221c18723cULL, 0x000fe20000041818ULL,
0x0000000806217824ULL, 0x000fc800078e0207ULL, 0x01b6984221ff79a7ULL, 0x0003e4000850003fULL,
0x000000010a1e7824ULL, 0x000fca00078e024eULL, 0x0000000f1e00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000c004c0947ULL, 0x002fea0003800000ULL,
0x00008e00ff1c7b82ULL, 0x000e620000000a00ULL, 0x000001001e207824ULL, 0x000fe200078e0204ULL,
0x000000011e1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x0000000459597c24ULL, 0x010fe2000f8e02ffULL, 0x0000000f1e00720cULL, 0x000fe40003f06070ULL,
0x00000020201e7812ULL, 0x000fe200078ec0ffULL, 0x0000004059597824ULL, 0x000fc800078e00ffULL,
0x00000001032b7824ULL, 0x000fe400078e021eULL, 0x00000100591c7825ULL, 0x002fc800078e001cULL,
0x0000000400948947ULL, 0x000fea0003800000ULL, 0x00000003ff417819ULL, 0x100fe20000011608ULL,
0x000020004a1e7824ULL, 0x040fe200078e00ffULL, 0x00000020492a7248ULL, 0x000fe20007fe0000ULL,
0x000000804a217824ULL, 0x000fe200078e00ffULL, 0x000000ff201f7210ULL, 0x000fe20007ffe1ffULL,
0x0000000441257836ULL, 0x000fe20000000000ULL, 0x000020001e1e7812ULL, 0x000fe200078ec0ffULL,
0x00000008415d7836ULL, 0x000fe20000000000ULL, 0x000000202a2a7446ULL, 0x000fe2000380001fULL,
0x0000000125207824ULL, 0x000fe200078e0208ULL, 0x000130005b5b7810ULL, 0x000fe20007ffe01eULL,
0x0000000825237824ULL, 0x000fe200078e00ffULL, 0x00000080441e7812ULL, 0x000fe200078ef821ULL,
0x00000001411f7824ULL, 0x000fe200078e0208ULL, 0x0000002a2500720cULL, 0x0c0fe20003f26070ULL,
0x0000000125257824ULL, 0x100fe200078e022bULL, 0xfffffff823587812ULL, 0x000fe200078ee220ULL,
0x0000000c41617836ULL, 0x000fe20000000000ULL, 0x0000002b41237210ULL, 0x000fe20007ffe0ffULL,
0x0000001041637836ULL, 0x000fe20000000000ULL, 0x000000071f297812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x0000002b5d277210ULL, 0x000fe20007ffe0ffULL,
0x0000000161217824ULL, 0x000fe200078e022bULL, 0x0000002a4100720cULL, 0x000fe20003f06070ULL,
0x0000010023227825ULL, 0x000fe200078e001eULL, 0x0ffffff829407812ULL, 0x000fc400078ef808ULL,
0x0000002a5d00720cULL, 0x080fe20003fa6070ULL, 0x0000010025247825ULL, 0x100fe200078e001eULL,
0x000000221c227210ULL, 0x000fe40007f5e0ffULL, 0x0000001841677810ULL, 0x000fe20007ffe0ffULL,
0x0000010027267825ULL, 0x000fe200078e001eULL, 0x000000241c247210ULL, 0x000fe40007f7e0ffULL,
0x0000002a6100720cULL, 0x000fe20003f86070ULL, 0x000000011d237824ULL, 0x000fe200010e0623ULL,
0x000000261c287210ULL, 0x000fe20007f5e0ffULL, 0x0000010021207825ULL, 0x000fc600078e001eULL,
0x000000271d297210ULL, 0x000fe200017fe4ffULL, 0x0000001040437824ULL, 0x000fe200078e025bULL,
0x0000000861407210ULL, 0x000fe20007ffe0ffULL, 0x000000011d257824ULL, 0x000fe200018e0625ULL,
0x000000201c207210ULL, 0x000fe20007f7e0ffULL, 0x0000001058597824ULL, 0x000fe200078e025bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022437faeULL, 0x0003e2000c101c46ULL,
0x0000000163277824ULL, 0x000fe400078e022bULL, 0x0000001441657836ULL, 0x000fe20000000000ULL,
0x0000000024597faeULL, 0x0005e2000c901c46ULL, 0x0000001c41697836ULL, 0x000fe20000000000ULL,
0x0000002a6700720cULL, 0x080fe20003f26070ULL, 0x000000015d267824ULL, 0x000fe200078e0208ULL,
0x0000002a6500720cULL, 0x080fe20003f46070ULL, 0x000000085d5d7824ULL, 0x000fe200078e00ffULL,
0x0000002a6900720cULL, 0x080fe20003f06070ULL, 0x000000011d217824ULL, 0x000fe200018e0621ULL,
0x0000002a6300720cULL, 0x000fe20003f66070ULL, 0x0000010027227825ULL, 0x002fe200078e001eULL,
0xfffffff85d2a7812ULL, 0x000fc600078ee226ULL, 0x0000000165257824ULL, 0x004fe200078e022bULL,
0x000000221c227210ULL, 0x000fe20007fde0ffULL, 0x0000000163267824ULL, 0x040fe200078e0208ULL,
0x0000000363637819ULL, 0x000fe200000006ffULL, 0x0000010025247825ULL, 0x000fc600078e001eULL,
0xfffffff863587812ULL, 0x000fe200078ee226ULL, 0x0000000167277824ULL, 0x000fe200078e022bULL,
0x0000002b692b7210ULL, 0x000fe20007ffe0ffULL, 0x000000011d237824ULL, 0x000fe200030e0623ULL,
0x000000241c247210ULL, 0x000fe20007fde0ffULL, 0x0000000165417824ULL, 0x040fe400078e0208ULL,
0x0000000865607824ULL, 0x000fe400078e00ffULL, 0x0000010027267825ULL, 0x000fc600078e001eULL,
0xfffffff860607812ULL, 0x000fe200078ee241ULL, 0x0000000861617824ULL, 0x000fe400078e00ffULL,
0x000000011d257824ULL, 0x000fe200030e0625ULL, 0x000000261c267210ULL, 0x000fe20007fde0ffULL,
0x0000000167417824ULL, 0x140fe200078e0208ULL, 0xfffffff861407812ULL, 0x000fe200078ee240ULL,
0x0000000867627824ULL, 0x000fe200078e00ffULL, 0x000000271d277210ULL, 0x000fe200037fe4ffULL,
0x0000000169437824ULL, 0x040fe400078e0208ULL, 0x0000000869647824ULL, 0x000fe200078e00ffULL,
0xfffffff862627812ULL, 0x000fe200078ee241ULL, 0x000001002b1e7825ULL, 0x000fc600078e001eULL,
0xfffffff864647812ULL, 0x000fe200078ee243ULL, 0x000000102a2b7824ULL, 0x100fe200078e025bULL,
0x0000001e1c1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001040417824ULL, 0x100fe200078e025bULL,
0x0000005b625d7211ULL, 0x000fe200078e20ffULL, 0x0000001058437824ULL, 0x100fe200078e025bULL,
0x00000000282b7faeULL, 0x0003e2000e901c46ULL, 0x0000001060597824ULL, 0x100fe400078e025bULL,
0x00000010645b7824ULL, 0x000fe200078e025bULL, 0x0000000020417faeULL, 0x0003e2000e101c46ULL,
0x000000011d1d7824ULL, 0x000fc600030e061fULL, 0x0000000022437faeULL, 0x0003e8000d901c46ULL,
0x0000000024597faeULL, 0x0003e8000d101c46ULL, 0x00000000265d7faeULL, 0x0003e8000c901c46ULL,
0x000000001c5b7faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x0000000408217811ULL, 0x000fe200078fe8ffULL, 0x000020004a1e7824ULL, 0x000fe200078e00ffULL,
0x0000000808237811ULL, 0x000fe400078fe8ffULL, 0x00000003211f7819ULL, 0x040fe200000006ffULL,
0x0000000121667824ULL, 0x100fe200078e0208ULL, 0x000020001e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000123647824ULL, 0x040fe200078e0208ULL, 0x0000001408297811ULL, 0x040fe400078fe8ffULL,
0xfffffff81f667812ULL, 0x000fe200078ee266ULL, 0x00000008231f7824ULL, 0x000fe200078e00ffULL,
0x000130005b5b7810ULL, 0x000fe20007ffe01eULL, 0x0000000129587824ULL, 0x140fe200078e0208ULL,
0x0000001008277811ULL, 0x000fe200078fe8ffULL, 0x0000000829597824ULL, 0x000fe200078e00ffULL,
0xfffffff81f647812ULL, 0x000fe200078ee264ULL, 0x000000804a1f7824ULL, 0x000fe200078e00ffULL,
0x0000000c08257811ULL, 0x040fe200078fe8ffULL, 0x0000000827437824ULL, 0x000fe200078e00ffULL,
0x00000008081e7211ULL, 0x040fe200078fe8ffULL, 0x0000000123237824ULL, 0x100fe200078e022bULL,
0x0000001808207811ULL, 0x000fe200078fe8ffULL, 0x0000000125627824ULL, 0x140fe200078e0208ULL,
0x000000071e5d7812ULL, 0x000fe200078ec0ffULL, 0x0000000825417824ULL, 0x040fe200078e00ffULL,
0x0000000827607210ULL, 0x000fe20007ffe0ffULL, 0x00000008206a7824ULL, 0x040fe200078e00ffULL,
0xfffffff859587812ULL, 0x000fe200078ee258ULL, 0x0000000125257824ULL, 0x100fe200078e022bULL,
0x00000080441e7812ULL, 0x000fe200078ef81fULL, 0x00000001201f7824ULL, 0x100fe200078e0208ULL,
0x0000001c08597811ULL, 0x000fe200078fe8ffULL, 0x0000000127277824ULL, 0x100fe200078e022bULL,
0xfffffff843607812ULL, 0x000fe200078ee260ULL, 0x0000000129297824ULL, 0x000fe200078e022bULL,
0xfffffff841627812ULL, 0x000fe200078ee262ULL, 0x0000000859617824ULL, 0x040fe200078e00ffULL,
0x0000002b20437210ULL, 0x000fe20007ffe0ffULL, 0x0000000159207824ULL, 0x000fe200078e0208ULL,
0x0000002b21217210ULL, 0x000fe20007ffe0ffULL, 0x0000001060637824ULL, 0x100fe200078e025bULL,
0x0000002b08417211ULL, 0x000fe200078fe8ffULL, 0x0000001058657824ULL, 0x000fe200078e025bULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee21fULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x0000002b59597210ULL, 0x000fc40007ffe0ffULL, 0xfffffff8616c7812ULL, 0x000fe200078ee220ULL,
0x0000010041407825ULL, 0x100fe200078e001eULL, 0x0ffffff85d687812ULL, 0x000fe400078ef808ULL,
0x0000005b62617211ULL, 0x000fe200078e20ffULL, 0x00000100212a7825ULL, 0x000fe200078e001eULL,
0x000000401c407210ULL, 0x000fc60007f1e0ffULL, 0x0000010023207825ULL, 0x100fe200078e001eULL,
0x0000002a1c2a7210ULL, 0x000fe40007f3e0ffULL, 0x000000411d417210ULL, 0x000fe200007fe4ffULL,
0x0000010025227825ULL, 0x000fe200078e001eULL, 0x000000201c207210ULL, 0x000fc60007f5e0ffULL,
0x0000010027247825ULL, 0x000fe200078e001eULL, 0x000000221c227210ULL, 0x000fc60007f7e0ffULL,
0x0000010029267825ULL, 0x000fe200078e001eULL, 0x000000241c247210ULL, 0x000fc60007f1e0ffULL,
0x0000010043287825ULL, 0x000fc800078e001eULL, 0x00000100591e7825ULL, 0x000fc800078e001eULL,
0x0000001068437824ULL, 0x000fe400078e025bULL, 0x000000011d2b7824ULL, 0x040fe200008e062bULL,
0x000000261c267210ULL, 0x000fe20007f3e0ffULL, 0x000000011d217824ULL, 0x040fe200010e0621ULL,
0x000000281c287210ULL, 0x000fe20007f5e0ffULL, 0x0000001066597824ULL, 0x000fe200078e025bULL,
0x000000271d277210ULL, 0x000fe20000ffe4ffULL, 0x000000011d237824ULL, 0x040fe200018e0623ULL,
0x0000001e1c1c7210ULL, 0x000fe20007f7e0ffULL, 0x00000010645d7824ULL, 0x000fe200078e025bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040437faeULL, 0x0003e2000b901c46ULL,
0x000000011d257824ULL, 0x000fc400000e0625ULL, 0x000000106a677824ULL, 0x000fe200078e025bULL,
0x000000002a597faeULL, 0x0003e2000b901c46ULL, 0x000000011d297824ULL, 0x040fe400010e0629ULL,
0x000000106c5b7824ULL, 0x000fe200078e025bULL, 0x00000000205d7faeULL, 0x0003e2000b901c46ULL,
0x000000011d1d7824ULL, 0x000fc600018e061fULL, 0x0000000022617faeULL, 0x0003e8000b901c46ULL,
0x0000000024637faeULL, 0x0003e8000b901c46ULL, 0x0000000026657faeULL, 0x0003e8000b901c46ULL,
0x0000000028677faeULL, 0x0003e8000b901c46ULL, 0x000000001c5b7faeULL, 0x0003e4000b901c46ULL,
0x000000035a1c7812ULL, 0x002fe200078ec0ffULL, 0xffffffffff597424ULL, 0x000fc600078e00ffULL,
0x000000031c00780cULL, 0x000fc80003f05270ULL, 0x00000001001d7807ULL, 0x000fca0004000000ULL,
0x000000015a5a7824ULL, 0x000fca00078e021dULL, 0x000000485a00720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009000ff1c7b82ULL, 0x000e620000000a00ULL,
0x0000005a0b1f7210ULL, 0x000fca0007ffe0ffULL, 0x000000041f1c7825ULL, 0x002fca00078e001cULL,
0x000000061c597981ULL, 0x000324000c1e1900ULL, 0x00000020061d7824ULL, 0x002fe200078e0207ULL,
0x00000010051c7812ULL, 0x040fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008051e7812ULL, 0x000fc800078ec0ffULL, 0x0000001d1e237210ULL, 0x000fc80007ffe01cULL,
0x01b66842234279a7ULL, 0x0002a6000850003fULL, 0x00000000001c7805ULL, 0x000fce0000015200ULL,
0x01b66843230075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff207224ULL, 0x000fce00078e00ffULL, 0x000000102000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fce0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000211e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fce0007ffe0ffULL, 0x01b66843230075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000018044567810ULL, 0x000fe20007ffe056ULL,
0x000000ffff587224ULL, 0x000fc800078e005eULL, 0x0000000155567824ULL, 0x000fca00078e0256ULL,
0x01b00000561d7984ULL, 0x000ea80000000800ULL, 0x01b20000565b7984ULL, 0x0006e20000000800ULL,
0x0000005e1d00720bULL, 0x004fda0003f1d000ULL, 0x00000000001c7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff1c207812ULL, 0x000fda000782c0ffULL,
0x0000000000f89947ULL, 0x00afea0003800000ULL, 0x00000003061f7836ULL, 0x000fe20000000000ULL,
0x0000005e1d00720bULL, 0x000fc80003f14000ULL, 0x0000004a1f00720cULL, 0x000fd20003f25270ULL,
0x00000000001f7806ULL, 0x000fc800000e0100ULL, 0x000000804a1e9824ULL, 0x000fe200078e0207ULL,
0x0000005e1d1c9209ULL, 0x000fc80007810000ULL, 0x0000001e55559210ULL, 0x000fe40007ffe044ULL,
0x000099101f1e7816ULL, 0x000fc600000000ffULL, 0x01b4001c55009388ULL, 0x0003e20000000800ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005e1d217209ULL, 0x000fe40007810000ULL, 0x000000ff1fff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff001fff7812ULL, 0x000fe2000782c0ffULL, 0x0000005e211c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL, 0x0000001c00217308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff1c7819ULL, 0x002fcc0000011608ULL,
0x00001f1c211c7589ULL, 0x004e6400000e0000ULL, 0x0000002c1c2c7220ULL, 0x042fe20000410000ULL,
0x0000002d1c2d7220ULL, 0x040fe20000410000ULL, 0x000000301c307220ULL, 0x040fe20000410000ULL,
0x000000311c317220ULL, 0x040fe20000410000ULL, 0x000000341c347220ULL, 0x040fe20000410000ULL,
0x000000351c357220ULL, 0x040fe20000410000ULL, 0x000000381c387220ULL, 0x040fe20000410000ULL,
0x000000391c397220ULL, 0x040fe20000410000ULL, 0x0000003c1c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d1c3d7220ULL, 0x040fe20000410000ULL, 0x000000101c107220ULL, 0x040fe20000410000ULL,
0x000000111c117220ULL, 0x040fe20000410000ULL, 0x000000141c147220ULL, 0x040fe20000410000ULL,
0x000000151c157220ULL, 0x040fe20000410000ULL, 0x000000181c187220ULL, 0x040fe20000410000ULL,
0x000000191c197220ULL, 0x000fce0000410000ULL, 0x000000215c5c7220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000008081c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f1c211c7589ULL, 0x000e6400000e0000ULL, 0x0000002e1c2e7220ULL, 0x042fe20000410000ULL,
0x0000002f1c2f7220ULL, 0x040fe20000410000ULL, 0x000000321c327220ULL, 0x040fe20000410000ULL,
0x000000331c337220ULL, 0x040fe20000410000ULL, 0x000000361c367220ULL, 0x040fe20000410000ULL,
0x000000371c377220ULL, 0x040fe20000410000ULL, 0x0000003a1c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b1c3b7220ULL, 0x040fe20000410000ULL, 0x0000003e1c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f1c3f7220ULL, 0x040fe20000410000ULL, 0x000000121c127220ULL, 0x040fe20000410000ULL,
0x000000131c137220ULL, 0x040fe20000410000ULL, 0x000000161c167220ULL, 0x040fe20000410000ULL,
0x000000171c177220ULL, 0x040fe20000410000ULL, 0x0000001a1c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b1c1b7220ULL, 0x000fce0000410000ULL, 0x0000ffff20ff7812ULL, 0x000fe4000780601fULL,
0x0000005e1d587209ULL, 0x000fd60007810000ULL, 0x800000581d1d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL, 0x0000001d000c0308ULL, 0x000ea40000000800ULL,
0x0000000c5b5b0220ULL, 0x004fce0000410000ULL, 0x00000007081d7812ULL, 0x000fe200078ec0ffULL,
0x00000800061c7824ULL, 0x002fe200078e0207ULL, 0x00000007571f7211ULL, 0x000fe200078e70ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000081d1d7812ULL, 0x000fe200078ef808ULL,
0x00002000021f7824ULL, 0x000fc800078e021fULL, 0x000000081d1d7824ULL, 0x000fca00078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee254ULL, 0x000140001f547836ULL, 0x000fc60000000000ULL,
0x0000001c1d1c7211ULL, 0x000fe200078e20ffULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe40000011608ULL, 0x0000000cff0d723eULL, 0x000fc600000010ffULL,
0x000000081e0e7836ULL, 0x000fe20000000000ULL, 0x000054100d1d7816ULL, 0x000fca000000000dULL,
0x00001f1e1d0d7589ULL, 0x0002a800000e0000ULL, 0x00001f0e1d0e7589ULL, 0x0002e400000e0000ULL,
0x012800001c1c783bULL, 0x002e620000000200ULL, 0x0000001047477824ULL, 0x100fe400078e0254ULL,
0x0000001046407824ULL, 0x100fe400078e0254ULL, 0x0000001045247824ULL, 0x000fe200078e0254ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000d1c1c7232ULL, 0x086fe40000200000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000200000ULL, 0x0000000e1d1d7232ULL, 0x088fe40000200000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000200000ULL, 0x0000005452287211ULL, 0x000fe200078e20ffULL,
0x000000004744783bULL, 0x000f620000004200ULL, 0x0000000306207836ULL, 0x000fe40000000000ULL,
0x0000005c5b5b7221ULL, 0x000fe20000010000ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x0000080020207824ULL, 0x000fc600078e0207ULL, 0x000000002424783bULL, 0x000f620000004200ULL,
0x000000105f207824ULL, 0x000fc600078e0220ULL, 0x000000002828783bULL, 0x000f680000004200ULL,
0x011000002020783bULL, 0x000f640000000200ULL, 0x000000441c2c723cULL, 0x02afec000004182cULL,
0x000000461c30723cULL, 0x000fec0000041830ULL, 0x000000401c34723cULL, 0x004fec0000041834ULL,
0x000000421c38723cULL, 0x000fec0000041838ULL, 0x000000241c3c723cULL, 0x000fec000004183cULL,
0x000000261c10723cULL, 0x000fec0000041810ULL, 0x000000281c14723cULL, 0x000fec0000041814ULL,
0x0000002a1c1c723cULL, 0x000fe20000041818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000d20207232ULL, 0x080fe40000200000ULL,
0x0000000d22227232ULL, 0x000fe40000200000ULL, 0x0000000e21217232ULL, 0x080fe40000200000ULL,
0x0000000e23237232ULL, 0x000fce0000200000ULL, 0x000000104f247824ULL, 0x100fe200078e0254ULL,
0x0000005450287211ULL, 0x000fe200078e20ffULL, 0x0000001051197824ULL, 0x100fe200078e0254ULL,
0x0000004e0a4e7210ULL, 0x000fe20007ffe0ffULL, 0x0000001053407824ULL, 0x000fe400078e0254ULL,
0x000000002424783bULL, 0x000e620000004200ULL, 0x0000000f4e00720cULL, 0x000fc60003f06070ULL,
0x000000001918783bULL, 0x000ea80000004200ULL, 0x000000004040783bULL, 0x000ee80000004200ULL,
0x000000002828783bULL, 0x000f620000004200ULL, 0x00000024203c723cULL, 0x002fec000004183cULL,
0x000000182014723cULL, 0x004fe20000041814ULL, 0x00000001ff257424ULL, 0x000fca00078e00ffULL,
0x00000040202c723cULL, 0x008fe2000004182cULL, 0x0000000806187824ULL, 0x000fc800078e0207ULL,
0x01b6a02518ff79a7ULL, 0x0003e2000850003fULL, 0x000000422030723cULL, 0x000fec0000041830ULL,
0x000000282034723cULL, 0x020fec0000041834ULL, 0x0000002a2038723cULL, 0x000fec0000041838ULL,
0x000000262010723cULL, 0x000fec0000041810ULL, 0x0000001a201c723cULL, 0x000fe2000004181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff9c00288947ULL, 0x002fde000383ffffULL,
0x00000000000b7919ULL, 0x000e620000002500ULL, 0x000000ffff007224ULL, 0x000fe400078e001eULL,
0x000000ffff207224ULL, 0x000fe200078e001dULL, 0x00000016001d7202ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e001cULL, 0x000000ffff0e7224ULL, 0x000fe400078e0017ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0012ULL, 0x0000001000127202ULL, 0x000fe20000000f00ULL,
0x000000ffff177224ULL, 0x000fc400078e0015ULL, 0x000000ffff167224ULL, 0x000fe400078e0014ULL,
0x000000ffff087224ULL, 0x000fe200078e0013ULL, 0x0000000f0b00720cULL, 0x002fda0003f06070ULL,
0x0000000000c40947ULL, 0x000fea0003800000ULL, 0x018000005b037836ULL, 0x000fca0000000000ULL,
0x7f80000003037812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x00008150000c7802ULL, 0x000fce0000000f00ULL,
0x000000b400407944ULL, 0x010fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005b00067308ULL, 0x000e640000001000ULL, 0xbf80000006037423ULL, 0x002fc8000000005bULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000306037223ULL, 0x000fce0000000006ULL,
0x0000000000067919ULL, 0x000f640000000000ULL, 0x00000002ff0c7819ULL, 0x022fe40000011606ULL,
0x0000000806067811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x00cfea0003800000ULL,
0x00001f0c03057589ULL, 0x000e6800000e0000ULL, 0x00001f06030d7589ULL, 0x000ea200000e0000ULL,
0x0000002c052c7220ULL, 0x042fe20000410000ULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000003405347220ULL, 0x040fe20000410000ULL, 0x0000003505357220ULL, 0x040fe20000410000ULL,
0x0000003805387220ULL, 0x040fe20000410000ULL, 0x0000003905397220ULL, 0x040fe20000410000ULL,
0x0000003c053c7220ULL, 0x040fe20000410000ULL, 0x0000003d053d7220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001705177220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x000fe20000410000ULL,
0x0000002e0d2e7220ULL, 0x044fe20000410000ULL, 0x0000002f0d2f7220ULL, 0x040fe20000410000ULL,
0x000000320d327220ULL, 0x040fe20000410000ULL, 0x000000330d337220ULL, 0x040fe20000410000ULL,
0x000000360d367220ULL, 0x040fe20000410000ULL, 0x000000370d377220ULL, 0x040fe20000410000ULL,
0x0000003a0d3a7220ULL, 0x040fe20000410000ULL, 0x0000003b0d3b7220ULL, 0x040fe20000410000ULL,
0x0000003e0d3e7220ULL, 0x040fe20000410000ULL, 0x0000003f0d3f7220ULL, 0x040fe20000410000ULL,
0x0000001c0d1c7220ULL, 0x040fe20000410000ULL, 0x000000080d087220ULL, 0x040fe20000410000ULL,
0x0000001d0d1d7220ULL, 0x040fe20000410000ULL, 0x0000000e0d0e7220ULL, 0x040fe20000410000ULL,
0x000000000d007220ULL, 0x040fe20000410000ULL, 0x0000001f0d1f7220ULL, 0x000fce0000410000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000161716723eULL, 0x000fe400000010ffULL,
0x0000001e2017723eULL, 0x000fe200000010ffULL, 0x00000800571e7824ULL, 0x000fe200078e00ffULL,
0x000000303119723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000034351a723eULL, 0x000fc400000010ffULL, 0x00000038391b723eULL, 0x000fe400000010ffULL,
0x000000121115723eULL, 0x000fe400000010ffULL, 0x000000323311723eULL, 0x000fe400000010ffULL,
0x000000363712723eULL, 0x000fe400000010ffULL, 0x0000003a3b13723eULL, 0x000fe400000010ffULL,
0x0000001d0e0e723eULL, 0x000fc400000010ffULL, 0x000000010a00780cULL, 0x000fe40003f05270ULL,
0x00000003ff067819ULL, 0x102fe20000011603ULL, 0x0000000104287824ULL, 0x000fe200078e0203ULL,
0xfffffff8ff0c7812ULL, 0x000fe400078ee203ULL, 0x0000000306057812ULL, 0x000fc600078ec0ffULL,
0x000000080c107836ULL, 0x000fe40000000000ULL, 0x000000080c217824ULL, 0x040fe400078e00ffULL,
0x000000080c147824ULL, 0x000fe200078e00ffULL, 0x0000000c050c7210ULL, 0x000fe20007ffe0ffULL,
0x00000001050d7824ULL, 0x000fe400078e0210ULL, 0x0000000810187824ULL, 0x040fe200078e00ffULL,
0x0000000c0c0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000040c057836ULL, 0x000fe20000000000ULL,
0xfffffff821217812ULL, 0x000fe200078ee20cULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0xfffffff818257812ULL, 0x000fc400078ee20dULL, 0xfffffff814237812ULL, 0x000fe200078ee205ULL,
0x0000100002057824ULL, 0x000fe200078e0207ULL, 0xfffffff810277812ULL, 0x000fe400078ee20fULL,
0x000000001f0f723eULL, 0x000fe200000010ffULL, 0x0000000105007824ULL, 0x000fe200078e021eULL,
0x0000002c2d18723eULL, 0x000fe200000010ffULL, 0x0000001028297824ULL, 0x000fe200078e0205ULL,
0x0000001c080d723eULL, 0x000fe200000010ffULL, 0x0000001021077824ULL, 0x100fe200078e0200ULL,
0x0000003c3d14723eULL, 0x000fe200000010ffULL, 0x00000010251c7824ULL, 0x100fe200078e0200ULL,
0x0000000023087211ULL, 0x000fe200078e20ffULL, 0x00000010271d7824ULL, 0x000fe200078e0200ULL,
0x0000002e2f10723eULL, 0x000fe200000010ffULL, 0x0000001807007844ULL, 0x000fe20000000200ULL,
0x0000003e3f0c723eULL, 0x000fe200000010ffULL, 0x000000ff001f7306ULL, 0x000e640000202400ULL,
0x0000001408007844ULL, 0x000fe80000000200ULL, 0x000000101c007844ULL, 0x000fe80000000200ULL,
0x0000000c1d007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000292c7984ULL, 0x000e680000000c00ULL, 0x0004000029247984ULL, 0x000ea80000000c00ULL,
0x0008000029307984ULL, 0x000ee80000000c00ULL, 0x000c000029207984ULL, 0x000f620000000c00ULL,
0x0000002f1f2f7230ULL, 0x002fc40000200800ULL, 0x0000002e1f2e7230ULL, 0x040fe40000200800ULL,
0x0000002d1f2d7230ULL, 0x040fe40000200800ULL, 0x0000002c1f2c7230ULL, 0x040fe40000200800ULL,
0x000000271f277230ULL, 0x044fe40000200800ULL, 0x000000261f117230ULL, 0x040fe40000200800ULL,
0x000000251f257230ULL, 0x000fc40000200800ULL, 0x000000241f107230ULL, 0x000fe40000200800ULL,
0x000000332f0f7230ULL, 0x008fe40000200000ULL, 0x000000322e0e7230ULL, 0x000fe40000200000ULL,
0x000000312d0d7230ULL, 0x000fe40000200000ULL, 0x000000302c0c7230ULL, 0x000fe40000200000ULL,
0x0000002327237230ULL, 0x020fc40000200000ULL, 0x0000002211227230ULL, 0x000fe20000200000ULL,
0x0000000c29007388ULL, 0x0003e20000000c00ULL, 0x0000002125217230ULL, 0x000fe40000200000ULL,
0x0000002010207230ULL, 0x000fca0000200000ULL, 0x0004002029007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002800208947ULL, 0x000fea0003800000ULL,
0x00000400ff237b82ULL, 0x002e620000000800ULL, 0x0000000000167919ULL, 0x000ea20000002600ULL,
0x00000040281b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000177919ULL, 0x000eaa0000002700ULL,
0x00009600ff087b82ULL, 0x000e620000000800ULL, 0x00000000290c7984ULL, 0x0006e80000000c00ULL,
0x0004000029107984ULL, 0x0006e60000000c00ULL, 0x00009a00ff147b82ULL, 0x000f620000000a00ULL,
0x0000000823077224ULL, 0x002fc800078e02ffULL, 0x0000000a07087224ULL, 0x040fe200078e02ffULL,
0x0000000f071f7811ULL, 0x000fe200078e10ffULL, 0x0000002317237224ULL, 0x004fc600078e0216ULL,
0xfffffff01f1f7812ULL, 0x000fc800078ec0ffULL, 0x0000001f081d7211ULL, 0x000fca00078e38ffULL,
0x0000008008087824ULL, 0x000fc800078e021dULL, 0x0000007f08077836ULL, 0x000fe40000000000ULL,
0x0000000a23087224ULL, 0x000fc600078e02ffULL, 0xffffff8007077812ULL, 0x000fe200078ec0ffULL,
0x00000001080b7824ULL, 0x000fc600078e020bULL, 0x0000001407167210ULL, 0x020fc80007f1e0ffULL,
0x000000160b167211ULL, 0x000fe200078260ffULL, 0x000000ffff187224ULL, 0x000fe200000e0615ULL,
0x0000000157ff7812ULL, 0x000fc8000780f84aULL, 0x000000180b177211ULL, 0x000fe400008f64ffULL,
0x000000141f257210ULL, 0x000fe20007f3e0ffULL, 0x0000080002167825ULL, 0x000fc800078e0016ULL,
0x000000ffff277224ULL, 0x000fe400008e0615ULL, 0x0000001028187825ULL, 0x000fc800078e0016ULL,
0x000000101b167825ULL, 0x000fe200078e0016ULL, 0x0000000000400947ULL, 0x008fec0003800000ULL,
0x00000010031b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff1c7819ULL, 0x000fe20000011603ULL,
0x000000800b1a7824ULL, 0x000fc600078e00ffULL, 0x000000701b1b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1c217812ULL, 0x000fe400078ec0ffULL, 0x000000141a207210ULL, 0x000fe40007ebe01dULL,
0x00000019ff1c7819ULL, 0x000fe4000001160bULL, 0x000000251b1a7210ULL, 0x000fe40007a3e01aULL,
0x000000151c0b7210ULL, 0x000fc40002fec4ffULL, 0x0000001a211a7210ULL, 0x000fe40007fbe0ffULL,
0x00000027ff1c7210ULL, 0x000fe40000fe441cULL, 0x0000002021207210ULL, 0x000fc60007c7e01bULL,
0x000000ffff1b7224ULL, 0x000fe200028e061cULL, 0x0000000bff217210ULL, 0x000fc80001fe84ffULL,
0x000000581a007986ULL, 0x0003e8000c101906ULL, 0x0000005b20007986ULL, 0x0003e4000c101906ULL,
0x000000ff0300720cULL, 0x000fe20000705670ULL, 0x0000000c18007986ULL, 0x0005e8000c101d06ULL,
0x0000001016007986ULL, 0x0005e2000c101d06ULL, 0x0000000000007b1dULL, 0x000fee0000000000ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x00009a00ff0c7b82ULL, 0x004ea20000000a00ULL,
0xffffffff0a0b7810ULL, 0x000fe20007ffe0ffULL, 0x00000004230c7825ULL, 0x004fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x0000000b0c0c79a8ULL, 0x00052200099ee1c6ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000b0c00720cULL, 0x010fc80003f05270ULL,
0x00000001ff0b7807ULL, 0x004fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x0000000bff007988ULL, 0x0005e60008000004ULL, 0x00000000000b7919ULL, 0x004ea20000008800ULL,
0x00000400001c7802ULL, 0x000fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000006540b1c7816ULL, 0x004fca000000001cULL,
0x000000001c0b7984ULL, 0x000ea40000000000ULL, 0x000000ff0b00720cULL, 0x004fda0003f05270ULL,
0x0000002000c48947ULL, 0x000fea0003800000ULL, 0x000000ff4a00720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe40000011603ULL, 0x00000025080c7211ULL, 0x000fe400078038ffULL,
0x00000070060d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000002708067211ULL, 0x000fe400000f3cffULL, 0x0000000c0b0c7210ULL, 0x000fc8000791e00dULL,
0x00000006ff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c067981ULL, 0x000528000c1e1900ULL,
0x000080060c0b7981ULL, 0x000522000c1e1900ULL, 0x000000020a00780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x004fea0003800000ULL, 0x000100060c0f7981ULL, 0x000522000c1e1900ULL,
0x000000040a00780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x004fea0003800000ULL,
0x000180060c117981ULL, 0x000522000c1e1900ULL, 0x000000040a00780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x004fea0003800000ULL, 0x000200060c137981ULL, 0x000522000c1e1900ULL,
0x000000060a00780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x004fea0003800000ULL,
0x000280060c177981ULL, 0x000522000c1e1900ULL, 0x000000060a00780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x004fea0003800000ULL, 0x000000080a00780cULL, 0x000fe20003f06070ULL,
0x000300060c197981ULL, 0x000518000c1e1900ULL, 0x000380060c1b0981ULL, 0x002524000c1e1900ULL,
0x000000070a0c7836ULL, 0x004fca0000000000ULL, 0x00000003ff0e7819ULL, 0x000fc8000001160cULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x0000001f080d7211ULL, 0x040fe200078038ffULL, 0x000000ffff217224ULL, 0x012fe200078e0006ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x000000140d147210ULL, 0x000fe40007f3e0ffULL, 0x000000ff080c7211ULL, 0x000fe400000f3cffULL,
0x0000078014237810ULL, 0x000fc80007f5e0ffULL, 0x0000000cff157210ULL, 0x000fd200017e2415ULL,
0x000000040a007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050e007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000002106067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011603ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c230c7210ULL, 0x000fc80007f3e0ffULL, 0x00000015ff0d7210ULL, 0x000fca0000ffe4ffULL,
0xfffc80060c217981ULL, 0x000328000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000000b06067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x002fc80000011603ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0b0c7812ULL, 0x000fc800078ef80cULL,
0x0000000c230c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0615ULL,
0xfffd00060c0b7981ULL, 0x000326000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000000f06067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011603ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c230c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0615ULL,
0xfffd80060c0f7981ULL, 0x000326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000001106067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x00000004030c7819ULL, 0x002fe400000006ffULL, 0x00000001ff0d7819ULL, 0x000fe40000011603ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c230c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0615ULL,
0xfffe00060c117981ULL, 0x000326000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x0000001306067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011603ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c230c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0615ULL,
0xfffe80060c137981ULL, 0x000326000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x0000001706067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011603ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c230c7210ULL, 0x000fc80007f3e0ffULL, 0x00000015ff0d7210ULL, 0x000fca0000ffe4ffULL,
0xffff00060c177981ULL, 0x000328000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001906067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011603ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c230c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0615ULL,
0xffff80060c197981ULL, 0x000326000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000001b06067209ULL, 0x000fca0007810000ULL,
0x000000080a007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011603ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c230c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0615ULL,
0x000000060c1b7981ULL, 0x000326000c1e1900ULL, 0x0000040023237810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc6000fffe03fULL, 0x00000015ff157210ULL, 0x000fe20000ffe4ffULL,
0xfffffff8002c8947ULL, 0x000ff0000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x00000010030b7824ULL, 0x014fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x002fc80000011603ULL,
0x000000700b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000001c0c0b7210ULL, 0x000fca0007ffe00bULL, 0x000000060b007388ULL, 0x0003e40000000800ULL,
0x00009a00ff147b82ULL, 0x000ea20000000a00ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x000008004a4a7824ULL, 0x000fe200078e00ffULL, 0x0000000857177210ULL, 0x000fe20007ffe0ffULL,
0x0000001003217824ULL, 0x002fe200078e00ffULL, 0x00000001570e7812ULL, 0x000fe200078ec0ffULL,
0x0000006003137836ULL, 0x000fe20000000000ULL, 0x00000001ff207819ULL, 0x000fe20000011603ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x0000007021217812ULL, 0x000fe400078ec0ffULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000c20207812ULL, 0x000fe400078ec0ffULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000200570b8824ULL, 0x140fe200078e021cULL, 0x0000001c20237210ULL, 0x000fe20007ffe021ULL,
0x0000020057118824ULL, 0x140fe200078e021cULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000100020f8824ULL, 0x040fe200078e020bULL, 0x0000001407067210ULL, 0x004fe20007f3e0ffULL,
0x0000010002118824ULL, 0x000fe200078e0211ULL, 0x000008004a0b7812ULL, 0x000fe200078ee2ffULL,
0x000000800e188824ULL, 0x040fe200078e020fULL, 0x000000141f1f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0615ULL, 0x000000110e1a8211ULL, 0x000fe200078e38ffULL,
0x00002000570f7824ULL, 0x000fe200078e021cULL, 0x000000141d1d7210ULL, 0x000fe20007f3e0ffULL,
0x00001000170c7825ULL, 0x040fe200078e0006ULL, 0x000008001e117812ULL, 0x000fe200078ec0ffULL,
0x0000000023237984ULL, 0x000e620000000800ULL, 0x00000015ff227210ULL, 0x000fe20000ffe4ffULL,
0x00001000021e7824ULL, 0x000fe200078e020fULL, 0x0000000b0c0c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff247224ULL, 0x000fe200018e0615ULL, 0x00000020030f7810ULL, 0x000fe20007ffe0ffULL,
0x000000011e0e7824ULL, 0x000fe200078e0211ULL, 0x0000001d17148211ULL, 0x040fe200078238ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x0000001f17168211ULL, 0x040fe200078438ffULL,
0x0000004003117836ULL, 0x000fe20000000000ULL, 0x0000002217158211ULL, 0x000fe200008f3cffULL,
0x0000001003197824ULL, 0x000fe200078e020eULL, 0x0000000a5700720cULL, 0x000fe20003f26070ULL,
0x000000100f0e7825ULL, 0x000fe200078e000cULL, 0x0000002417178211ULL, 0x000fc400010f3cffULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000001011107825ULL, 0x100fe200078e000cULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x000000ff00447202ULL, 0x000fe20000000f00ULL,
0x0000001013127825ULL, 0x000fe200078e000cULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000010030c7825ULL, 0x040fe200078e000cULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000010031b8824ULL, 0x040fe200078e0218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c197faeULL, 0x000fe2000b901c46ULL, 0x0000001003148825ULL, 0x000fe200078e0014ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x003800000e197faeULL, 0x000fe2000b901c46ULL,
0x0000001003298824ULL, 0x040fe400078e021aULL, 0x0000001003168825ULL, 0x000fe200078e0016ULL,
0x0058000010197faeULL, 0x000fe6000b901c46ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x0078000012197faeULL, 0x000fe8000b901c46ULL, 0x04580000141b8faeULL, 0x000fe8000b901c46ULL,
0x0418000016298faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000287805ULL, 0x004fe2000001ff00ULL, 0x0000000800b81947ULL, 0x002fec0003800000ULL,
0x00000003ff0c7819ULL, 0x000fe20000011603ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0xfffffff8ff0d7812ULL, 0x000fe200078ee203ULL, 0x000000ffff477224ULL, 0x000fe200078e0057ULL,
0x000000030c0c7812ULL, 0x000fe400078ec0ffULL, 0x00000002ff4f7819ULL, 0x000fe20000011603ULL,
0x000000080d0f7836ULL, 0x000fe40000000000ULL, 0x000000080d117824ULL, 0x040fe200078e00ffULL,
0x000000084f457810ULL, 0x000fe20007ffe0ffULL, 0x000000080d487824ULL, 0x000fe200078e00ffULL,
0x0000000d0c0d7210ULL, 0x000fe20007ffe0ffULL, 0x000000010c497824ULL, 0x000fc400078e020fULL,
0x000000080f0c7824ULL, 0x040fe200078e00ffULL, 0x0000000c0d4e7810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff848487812ULL, 0x000fe200078ee20dULL,
0x000000040d4a7836ULL, 0x000fe20000000000ULL, 0xfffffff80c497812ULL, 0x000fe200078ee249ULL,
0x00000200570d7824ULL, 0x000fe200078e021cULL, 0xfffffff80f4e7812ULL, 0x000fe400078ee24eULL,
0xfffffff8114a7812ULL, 0x000fe200078ee24aULL, 0x0000010002507824ULL, 0x000fce00078e020dULL,
0x00000001470f7836ULL, 0x000fca0000000000ULL, 0x0000000a0f00720cULL, 0x000fda0003f06070ULL,
0x0000000000a00947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x000fe20003f44070ULL,
0x0000000108117824ULL, 0x000fe200078e020fULL, 0x000000010f1b7812ULL, 0x040fe200078ec0ffULL,
0x000008000f0e7824ULL, 0x000fe400078e00ffULL, 0x00001000110c7825ULL, 0x000fc800078e0006ULL,
0x0000004003517836ULL, 0x000fe20000000000ULL, 0x0000000b0c127210ULL, 0x000fe20007f1e0ffULL,
0x0000006003537836ULL, 0x000fe40000000000ULL, 0x000002005713a824ULL, 0x100fe200078e021cULL,
0x0000001f1110a211ULL, 0x000fe200078238ffULL, 0x00000200570fa824ULL, 0x000fc600078e021cULL,
0x000000130250a211ULL, 0x000fe200078e40ffULL, 0x000000ffff137224ULL, 0x000fe200000e060dULL,
0x000008000e0d7812ULL, 0x000fe400078ec0ffULL, 0x0000001d1114a211ULL, 0x000fe200078038ffULL,
0x000000801b18a824ULL, 0x000fe400078e0250ULL, 0x000001000250a824ULL, 0x000fe200078e020fULL,
0x00000020030f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011e0c7824ULL, 0x000fe200078e020dULL,
0x000000221115a211ULL, 0x000fe200000f3cffULL, 0x0000001003167825ULL, 0x000fe200078e0012ULL,
0x000000241111a211ULL, 0x000fc400008f3cffULL, 0x000000501b1aa211ULL, 0x000fe200078e38ffULL,
0x0000001003197824ULL, 0x000fe400078e020cULL, 0x000000100f0c7825ULL, 0x000fc600078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000016197faeULL, 0x0003e2000b901c46ULL,
0x00000010510e7825ULL, 0x000fc600078e0012ULL, 0x003800000c197faeULL, 0x0003e2000b901c46ULL,
0x0000001053127825ULL, 0x000fc600078e0012ULL, 0x005800000e197faeULL, 0x0003e2000b901c46ULL,
0x000000100314a825ULL, 0x000fc600078e0014ULL, 0x0078000012197faeULL, 0x0003e2000b901c46ULL,
0x00000010031ba824ULL, 0x040fe400078e0218ULL, 0x000000100310a825ULL, 0x000fc600078e0010ULL,
0x04580000141bafaeULL, 0x0003e2000b901c46ULL, 0x000000100351a824ULL, 0x000fca00078e021aULL,
0x041800001051afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000080470c7824ULL, 0x002fca00078e00ffULL, 0x000000800c0c7812ULL, 0x000fc800078ec0ffULL,
0x00000050210d7210ULL, 0x000fe40007ffe00cULL, 0x0000000b470c7819ULL, 0x000fe200000006ffULL,
0x0000000247477836ULL, 0x000fe40000000000ULL, 0x0000000120517824ULL, 0x000fe200078e020dULL,
0x000008000c0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000a4700720cULL, 0x000fe40003f06070ULL,
0x000001801e197810ULL, 0x000fe20007ffe00dULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800051167984ULL, 0x000e620000000800ULL, 0x00000010480c7824ULL, 0x100fe400078e0219ULL,
0x000000104a107824ULL, 0x100fe200078e0219ULL, 0x0045800051527984ULL, 0x000fe20000000800ULL,
0x0000001049147824ULL, 0x100fe400078e0219ULL, 0x000000104e197824ULL, 0x000fe200078e0219ULL,
0x000000000c0c783bULL, 0x000ea80000000200ULL, 0x000000001010783bULL, 0x000ee20000000200ULL,
0x0000001623187221ULL, 0x002fc60000010100ULL, 0x000000001414783bULL, 0x000e620000000200ULL,
0x3fb8aa3b18557820ULL, 0x000fc60000410000ULL, 0x000000001918783bULL, 0x000f620000000200ULL,
0x000000100c517819ULL, 0x044fe400000006ffULL, 0x0000005500557308ULL, 0x000ea20000000800ULL,
0x000076320c0c7816ULL, 0x000fe2000000000cULL, 0x00010000135a7824ULL, 0x048fe200078e00ffULL,
0x0000763213587816ULL, 0x000fe20000000058ULL, 0x0001000010597824ULL, 0x010fe200078e00ffULL,
0x000076320e537816ULL, 0x000fe20000000053ULL, 0x000100000c0c7824ULL, 0x000fe200078e00ffULL,
0x000076320f547816ULL, 0x040fe20000000054ULL, 0x000100000e0e7824ULL, 0x000fe200078e00ffULL,
0x0000763212567816ULL, 0x000fe20000000056ULL, 0x000100000f0f7824ULL, 0x000fc400078e00ffULL,
0x0001000012127824ULL, 0x000fe400078e00ffULL, 0x0001000053537824ULL, 0x000fe400078e00ffULL,
0x0000005255627220ULL, 0x004fe20000410000ULL, 0x000076320d527816ULL, 0x040fe20000000052ULL,
0x000100000d0d7824ULL, 0x000fe200078e00ffULL, 0x0000763210557816ULL, 0x000fe20000000055ULL,
0x0000004662467221ULL, 0x000fe20000010000ULL, 0x00001f4f62637589ULL, 0x000ea200000e0000ULL,
0x0000763211107816ULL, 0x040fe20000000010ULL, 0x0001000052527824ULL, 0x000fe200078e00ffULL,
0x0000001011117819ULL, 0x000fe200000006ffULL, 0x00001f4562627589ULL, 0x000ee200000e0000ULL,
0x0000001055557819ULL, 0x000fe200000006ffULL, 0x0001000054547824ULL, 0x000fc400078e00ffULL,
0x0001000010107824ULL, 0x000fe400078e00ffULL, 0x0001000058587824ULL, 0x000fe200078e00ffULL,
0x0000763214137816ULL, 0x042fe20000000013ULL, 0x00010000145b7824ULL, 0x000fe200078e00ffULL,
0x0000763215147816ULL, 0x040fe20000000014ULL, 0x00010000155c7824ULL, 0x000fe200078e00ffULL,
0x0000763216157816ULL, 0x000fe20000000015ULL, 0x00010000185f7824ULL, 0x020fe200078e00ffULL,
0x00000010165d7819ULL, 0x000fe200000006ffULL, 0x000100001a617824ULL, 0x000fe200078e00ffULL,
0x00007632185e7816ULL, 0x000fe2000000005eULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x000076321a607816ULL, 0x000fc40000000060ULL, 0x0000763217167816ULL, 0x000fe20000000016ULL,
0x000000630c377223ULL, 0x084fe20000010037ULL, 0x0000763219187816ULL, 0x000fe20000000018ULL,
0x000000630d367223ULL, 0x000fe20000010036ULL, 0x000076321b1a7816ULL, 0x000fe2000000001aULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x000000101b1b7819ULL, 0x000fe200000006ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x0000001014147819ULL, 0x000fe200000006ffULL,
0x00010000560d7824ULL, 0x000fe200078e00ffULL, 0x0000001018187819ULL, 0x000fe200000006ffULL,
0x00010000150c7824ULL, 0x000fc400078e00ffULL, 0x0000006351387223ULL, 0x080fe20000010038ULL,
0x0001000016167824ULL, 0x000fe400078e00ffULL, 0x0000006352357223ULL, 0x080fe20000010035ULL,
0x000100005e5e7824ULL, 0x000fe400078e00ffULL, 0x000000630e437223ULL, 0x080fe20000010043ULL,
0x0001000060607824ULL, 0x000fe400078e00ffULL, 0x00000063533e7223ULL, 0x000fe2000001003eULL,
0x000100001a1a7824ULL, 0x000fc400078e00ffULL, 0x000000630f427223ULL, 0x080fe20000010042ULL,
0x00000063543d7223ULL, 0x080fe2000001003dULL, 0x0000006359407223ULL, 0x080fe20000010040ULL,
0x00000063553c7223ULL, 0x080fe2000001003cULL, 0x0000006311447223ULL, 0x080fe20000010044ULL,
0x00000063103b7223ULL, 0x080fe2000001003bULL, 0x0000006312417223ULL, 0x080fe20000010041ULL,
0x000000630d3a7223ULL, 0x080fe2000001003aULL, 0x000000635a3f7223ULL, 0x080fe2000001003fULL,
0x0000006358397223ULL, 0x000fe20000010039ULL, 0x000000625b347223ULL, 0x088fe20000010034ULL,
0x00000062132e7223ULL, 0x080fe2000001002eULL, 0x000000625c2d7223ULL, 0x080fe2000001002dULL,
0x0000006214337223ULL, 0x080fe20000010033ULL, 0x000000625d327223ULL, 0x080fe20000010032ULL,
0x000000620c317223ULL, 0x080fe20000010031ULL, 0x00000062172c7223ULL, 0x080fe2000001002cULL,
0x00000062162b7223ULL, 0x080fe2000001002bULL, 0x000000625f2a7223ULL, 0x080fe2000001002aULL,
0x000000625e297223ULL, 0x080fe20000010029ULL, 0x0000006219307223ULL, 0x080fe20000010030ULL,
0x00000062182f7223ULL, 0x080fe2000001002fULL, 0x0000006261287223ULL, 0x080fe20000010028ULL,
0x0000006260277223ULL, 0x080fe20000010027ULL, 0x000000621b267223ULL, 0x080fe20000010026ULL,
0x000000621a257223ULL, 0x000fe20000010025ULL, 0xfffffff400a08947ULL, 0x000fec000383ffffULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000ff0200720cULL, 0x000fe20003f05270ULL,
0x000049801c067836ULL, 0x000fe40000000000ULL, 0x0000001003077824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x00000070070b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c030a7812ULL, 0x000fc600078ec0ffULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00000080571c7824ULL, 0x000fe200078e021cULL,
0x0000000403077819ULL, 0x002fe400000006ffULL, 0x00000001ff087819ULL, 0x000fe40000011603ULL,
0x0000007007037812ULL, 0x000fe400078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ec0ffULL,
0x0000001c08037210ULL, 0x000fca0007ffe003ULL, 0x0049804603007388ULL, 0x0003e40000000800ULL,
0x000000060a067210ULL, 0x000fe20007ffe00bULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000006037984ULL, 0x002e680000000800ULL, 0x0000800006087984ULL, 0x000ea20000000800ULL,
0x00000003ff037221ULL, 0x002fc80000010000ULL, 0x0000000803037221ULL, 0x004fc80000010000ULL,
0x0180000003077836ULL, 0x000fca0000000000ULL, 0x7f80000007077812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0700780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0003ULL,
0x0000aa20000c7802ULL, 0x000fce0000000f00ULL, 0x0000008c000c7944ULL, 0x010fea0003c00000ULL,
0x000000ffff067224ULL, 0x00cfe200078e0003ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000300067308ULL, 0x000e640000001000ULL, 0xbf80000003077423ULL, 0x002fc80000000006ULL,
0x800000ff07077221ULL, 0x000fc80000010100ULL, 0x0000000706067223ULL, 0x000fce0000000006ULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x00000002ff077819ULL, 0x104fe20000011603ULL,
0x0000000104047824ULL, 0x000fe200078e0203ULL, 0x0000000803157811ULL, 0x000fe400078ff0ffULL,
0xfffffff8ff1a7812ULL, 0x000fe200078ee203ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0706077589ULL, 0x000ea200000e0000ULL, 0x000000081a1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000081a1d7824ULL, 0x000fc400078e00ffULL, 0x00001f1506157589ULL, 0x00076200000e0000ULL,
0x000000081a1e7824ULL, 0x000fe200078e00ffULL, 0x000000031c207819ULL, 0x040fe200000006ffULL,
0x000000081c1f7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000003ff067819ULL, 0x008fe20000011603ULL, 0x00000038070c7220ULL, 0x044fe20000410000ULL,
0x0000003707377220ULL, 0x040fe20000410000ULL, 0x00000036070d7220ULL, 0x040fe20000410000ULL,
0x0000003507087220ULL, 0x040fe20000410000ULL, 0x00000043070e7220ULL, 0x040fe20000410000ULL,
0x0000003e070b7220ULL, 0x040fe20000410000ULL, 0x00000042070f7220ULL, 0x040fe20000410000ULL,
0x0000003d070a7220ULL, 0x040fe20000410000ULL, 0x0000004007107220ULL, 0x040fe20000410000ULL,
0x0000003c07117220ULL, 0x040fe20000410000ULL, 0x0000004407447220ULL, 0x040fe20000410000ULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x0000004107127220ULL, 0x040fe20000410000ULL,
0x0000003a07137220ULL, 0x040fe20000410000ULL, 0x0000003f073f7220ULL, 0x040fe20000410000ULL,
0x0000003907147220ULL, 0x000fe20000410000ULL, 0x0000003415347220ULL, 0x062fe20000410000ULL,
0x0000002e15077220ULL, 0x040fe20000410000ULL, 0x0000002d152d7220ULL, 0x040fe20000410000ULL,
0x0000003315167220ULL, 0x040fe20000410000ULL, 0x0000003215327220ULL, 0x040fe20000410000ULL,
0x0000003115317220ULL, 0x040fe20000410000ULL, 0x0000002c15177220ULL, 0x040fe20000410000ULL,
0x0000002b15187220ULL, 0x040fe20000410000ULL, 0x0000002a152a7220ULL, 0x040fe20000410000ULL,
0x0000002915297220ULL, 0x040fe20000410000ULL, 0x0000003015307220ULL, 0x040fe20000410000ULL,
0x0000002f152f7220ULL, 0x040fe20000410000ULL, 0x0000002815287220ULL, 0x040fe20000410000ULL,
0x0000002715277220ULL, 0x040fe20000410000ULL, 0x0000002615267220ULL, 0x040fe20000410000ULL,
0x0000002515257220ULL, 0x000fe20000410000ULL, 0x0000000306157812ULL, 0x000fc400078ec0ffULL,
0x0000000c370c723eULL, 0x000fe400000010ffULL, 0x0000000d080d723eULL, 0x000fe200000010ffULL,
0x00000001151a7824ULL, 0x000fe200078e021aULL, 0x0000000e0b0e723eULL, 0x000fe200000010ffULL,
0x00000001151b7824ULL, 0x000fe200078e021cULL, 0x0000000f0a0f723eULL, 0x000fe200000010ffULL,
0x000000041a197836ULL, 0x000fe20000000000ULL, 0xfffffff81d157812ULL, 0x000fe200078ee21aULL,
0x0000000c1a1c7836ULL, 0x000fe20000000000ULL, 0xfffffff8201b7812ULL, 0x000fc400078ee21bULL,
0xfffffff81e197812ULL, 0x000fe200078ee219ULL, 0x00000010152c7824ULL, 0x100fe200078e0200ULL,
0xfffffff81f1d7812ULL, 0x000fe400078ee21cULL, 0x000000101110723eULL, 0x000fe200000010ffULL,
0x00000010192e7824ULL, 0x000fe200078e0200ULL, 0x000000121312723eULL, 0x000fe200000010ffULL,
0x0000000c2c007844ULL, 0x000fe20000000200ULL, 0x000000443b11723eULL, 0x000fe400000010ffULL,
0x0000003f1413723eULL, 0x000fc400000010ffULL, 0x0000002d1615723eULL, 0x000fe400000010ffULL,
0x000000001b337211ULL, 0x000fe200078e20ffULL, 0x000000101d007824ULL, 0x000fe200078e0200ULL,
0x000000340714723eULL, 0x000fe200000010ffULL, 0x0000001004077824ULL, 0x000fe200078e0205ULL,
0x000000323116723eULL, 0x000fe200000010ffULL, 0x000000102e007844ULL, 0x000fe20000000200ULL,
0x000000171817723eULL, 0x000fe200000010ffULL, 0x000000ff00047306ULL, 0x000e620000202400ULL,
0x0000002a2918723eULL, 0x000fc400000010ffULL, 0x000000302f19723eULL, 0x000fe200000010ffULL,
0x0000001433007844ULL, 0x000fe20000000200ULL, 0x00000028271a723eULL, 0x000fe400000010ffULL,
0x00000026251b723eULL, 0x000fca00000010ffULL, 0x0000001800007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000071c7984ULL, 0x000e680000000c00ULL,
0x0004000007247984ULL, 0x000ea80000000c00ULL, 0x0008000007207984ULL, 0x000ee80000000c00ULL,
0x000c000007287984ULL, 0x000f620000000c00ULL, 0x0000001f041f7230ULL, 0x002fc40000200800ULL,
0x0000001e041e7230ULL, 0x040fe40000200800ULL, 0x0000001d041d7230ULL, 0x040fe40000200800ULL,
0x0000001c041c7230ULL, 0x040fe40000200800ULL, 0x0000002704277230ULL, 0x044fe40000200800ULL,
0x0000002604267230ULL, 0x040fe40000200800ULL, 0x0000002504257230ULL, 0x000fc40000200800ULL,
0x0000002404247230ULL, 0x000fe40000200800ULL, 0x000000231f1f7230ULL, 0x008fe40000200000ULL,
0x000000221e1e7230ULL, 0x000fe40000200000ULL, 0x000000211d1d7230ULL, 0x000fe40000200000ULL,
0x000000201c1c7230ULL, 0x000fe40000200000ULL, 0x0000002b27277230ULL, 0x020fc40000200000ULL,
0x0000002a26267230ULL, 0x000fe20000200000ULL, 0x0000001c07007388ULL, 0x0003e20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000200000ULL, 0x0000002824247230ULL, 0x000fca0000200000ULL,
0x0004002407007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff5700720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x0000004b0600720cULL, 0x000fe20003f06070ULL,
0x0000840000057ab9ULL, 0x000fe40000000800ULL, 0x00000005040472a4ULL, 0x004fd4000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00008600ff117b82ULL, 0x000ea20000000800ULL,
0x0000000306007210ULL, 0x000fe20007ffe0ffULL, 0x000000104c067824ULL, 0x000fe200078e0206ULL,
0x0000880000087ab9ULL, 0x000fe20000000a00ULL, 0x0000002003157836ULL, 0x000fe20000000000ULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x00000007030b7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff800007812ULL, 0x000fc600078ef803ULL, 0x00000008020b7824ULL, 0x000fe400078e020bULL,
0x0000001000047824ULL, 0x000fe400078e0205ULL, 0xffffffffff007424ULL, 0x000fc600078e00ffULL,
0x00000000040c7984ULL, 0x0022e40000000c00ULL, 0x0000001100137219ULL, 0x084fe400000006ffULL,
0x000000114d4d7219ULL, 0x000fe400000006ffULL, 0x0000001306007212ULL, 0x000fe400078e30ffULL,
0x00000011ff067219ULL, 0x000fe40000011606ULL, 0x00000003ff047819ULL, 0x002fe20000011615ULL,
0x000000014d077824ULL, 0x000fc400078e0200ULL, 0x0000000409007c24ULL, 0x000fe4000f8e02ffULL,
0x0000000906077224ULL, 0x000fca00078e0207ULL, 0x0000000700077210ULL, 0x000fc80007f1e0ffULL,
0x000000ffff087210ULL, 0x000fe400007fe4ffULL, 0x0000000807067c11ULL, 0x000fc8000f8040ffULL,
0x0000000907077c11ULL, 0x000fe400080f4408ULL, 0x0000004b0400720cULL, 0x000fe20003f06070ULL,
0x000000100b067825ULL, 0x000fca00078e0006ULL, 0x0000000c06007986ULL, 0x0083ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000115067824ULL, 0x042fe200078e0204ULL,
0x000000044c047211ULL, 0x000fe200078e20ffULL, 0x0000004003177836ULL, 0x000fe20000000000ULL,
0x00000007150b7812ULL, 0x000fe400078ec0ffULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x00000008020b7824ULL, 0x000fe200078e020bULL, 0x0ffffff806067812ULL, 0x000fca00078ef815ULL,
0x0000001006087824ULL, 0x000fe200078e0205ULL, 0x0000001304067212ULL, 0x000fe400078e30ffULL,
0x00000011ff047219ULL, 0x000fe40000011604ULL, 0x00000000080c7984ULL, 0x000e620000000c00ULL,
0x000000014d067824ULL, 0x000fc800078e0206ULL, 0x0000000904077224ULL, 0x000fca00078e0206ULL,
0x0000000700077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000000807067c11ULL, 0x000fc8000f8040ffULL, 0x0000000907077c11ULL, 0x000fe400080f4404ULL,
0x00000003ff047819ULL, 0x000fe20000011617ULL, 0x000000100b067825ULL, 0x000fc600078e0006ULL,
0x0000004b0400720cULL, 0x000fe40003f06070ULL, 0x0000000c06007986ULL, 0x0023f6000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000417067210ULL, 0x002fe20007ffe0ffULL,
0x000000104c047824ULL, 0x000fe400078e0204ULL, 0x00000060030b7836ULL, 0x000fe20000000000ULL,
0x0000000706067812ULL, 0x000fe400078ec0ffULL, 0x0000000717037812ULL, 0x000fe400078ec0ffULL,
0x0ffffff806067812ULL, 0x000fc600078ef817ULL, 0x0000000802037824ULL, 0x000fe400078e0203ULL,
0x0000001006087824ULL, 0x000fe200078e0205ULL, 0x0000001304067212ULL, 0x000fe400078e30ffULL,
0x00000011ff047219ULL, 0x000fe40000011604ULL, 0x00000000080c7984ULL, 0x0002a20000000c00ULL,
0x000000014d067824ULL, 0x000fc800078e0206ULL, 0x0000000904077224ULL, 0x000fe200078e0206ULL,
0x00000003ff047819ULL, 0x000fc8000001160bULL, 0x0000000700077210ULL, 0x000fe20007f1e0ffULL,
0x000000010b087824ULL, 0x002fc600078e0204ULL, 0x000000ffff0a7210ULL, 0x000fe400007fe4ffULL,
0x0000000807067c11ULL, 0x040fe4000f8040ffULL, 0x0000000708087812ULL, 0x000fe400078ec0ffULL,
0x0000000907077c11ULL, 0x000fe400080f440aULL, 0x0000004b0400720cULL, 0x000fe40003f06070ULL,
0xfffffff808087812ULL, 0x000fe200078ef80bULL, 0x0000001003067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0043ea000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001008087824ULL, 0x000fe400078e0205ULL, 0x000000104c047824ULL, 0x000fc600078e0204ULL,
0x00000000080c7984ULL, 0x002e640000000c00ULL, 0x0000001304037212ULL, 0x000fe400078e30ffULL,
0x00000011ff047219ULL, 0x000fe40000011604ULL, 0x000000034d037210ULL, 0x000fca0007ffe0ffULL,
0x0000000904037224ULL, 0x000fca00078e0203ULL, 0x0000000300007210ULL, 0x000fe40007f1e0ffULL,
0x000000070b037812ULL, 0x000fc600078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x0000000800047c11ULL, 0x000fe2000f8040ffULL, 0x0000000802037824ULL, 0x000fc600078e0203ULL,
0x0000000900057c11ULL, 0x000fc600080f4405ULL, 0x0000001003027825ULL, 0x000fca00078e0004ULL,
0x0000000c02007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000044e067824ULL, 0x000fe200078e024aULL, 0x0000000100107802ULL, 0x000fe20000000f00ULL,
0xffffffffff057424ULL, 0x000fe200078e00ffULL, 0x00008e00ff127b82ULL, 0x000e640000000a00ULL,
0x000000480600720cULL, 0x000fe40003f06070ULL, 0x01b60010071079a7ULL, 0x0004b6000850003fULL,
0x000000020d098824ULL, 0x000fe200078e00ffULL, 0x00009400ff028b82ULL, 0x000ef00000000800ULL,
0x00009000ff148b82ULL, 0x000f220000000a00ULL, 0x0000000209098224ULL, 0x008fc800078e0206ULL,
0x0000000409148825ULL, 0x010fca00078e0014ULL, 0x0000000614058981ULL, 0x000ee2000c1e1900ULL,
0x000000014e027836ULL, 0x000fe40000000000ULL, 0x0000004003047824ULL, 0x000fe400078e00ffULL,
0x000000404a037824ULL, 0x000fe200078e00ffULL, 0x0000000f0200720cULL, 0x000fe40003f06070ULL,
0x000000064d027819ULL, 0x000fe200000006ffULL, 0x0000000405097224ULL, 0x008fc800078e02ffULL,
0x0000010009127825ULL, 0x002fcc00078e0012ULL, 0x0000000c00248947ULL, 0x004fea0003800000ULL,
0x000001004e0c7824ULL, 0x000fe200078e0203ULL, 0x00000003ff1b7819ULL, 0x000fc80000011608ULL,
0x0000000c49097248ULL, 0x000fe20007fe0000ULL, 0x000000041b157836ULL, 0x000fe20000000000ULL,
0x000000381b2f7810ULL, 0x000fe20007ffe0ffULL, 0x000000081b177836ULL, 0x000fe40000000000ULL,
0x00000001090c7824ULL, 0x000fe200078e0a0cULL, 0x00000003151a7819ULL, 0x040fe200000006ffULL,
0x0000000115097824ULL, 0x100fe400078e0208ULL, 0x00000008171e7824ULL, 0x000fe200078e00ffULL,
0x0000000c1500720cULL, 0x080fe20003f46070ULL, 0x0000000c1b157836ULL, 0x000fe20000000000ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL, 0x0000000117097824ULL, 0x140fe200078e0208ULL,
0x0000000c1700720cULL, 0x080fe20003f66070ULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0x00000008150e7210ULL, 0x000fe20007ffe0ffULL, 0x000000101b177836ULL, 0x000fe20000000000ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL, 0x000000404d4d7824ULL, 0x000fe200078e021bULL,
0xfffffff819247812ULL, 0x000fe200078ee20eULL, 0x0000000117097824ULL, 0x140fe200078e0208ULL,
0x000000141b197810ULL, 0x000fe20007ffe0ffULL, 0x0000000817267824ULL, 0x000fe200078e00ffULL,
0x0000000c1500720cULL, 0x080fe20003f86070ULL, 0x000000011b0e7824ULL, 0x100fe200078e0208ULL,
0x0000000c1700720cULL, 0x080fe20003fa6070ULL, 0x00000008192a7824ULL, 0x040fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee209ULL, 0x0000000119097824ULL, 0x000fe200078e0208ULL,
0x000000070e177812ULL, 0x000fe200078ec0ffULL, 0x000001004d147825ULL, 0x000fe200078e00ffULL,
0x0000000c1900720cULL, 0x000fc40003f06070ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL,
0x000000044d167836ULL, 0x000fe20000000000ULL, 0x000000074a097211ULL, 0x000fe200078e70ffULL,
0x000000181b237836ULL, 0x000fe20000000000ULL, 0x0000007014197812ULL, 0x000fe200078ef80bULL,
0x000000084d147836ULL, 0x000fe20000000000ULL, 0x0000000c1b00720cULL, 0x000fe20003f26070ULL,
0x0000100009097836ULL, 0x000fe20000000000ULL, 0x0ffffff8170e7812ULL, 0x000fe200078ef808ULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000001912187210ULL, 0x000fc40007fde0ffULL,
0x000000090e1f7211ULL, 0x000fe200078e20ffULL, 0x00000001230e7824ULL, 0x000fe200078e0208ULL,
0x00000070161d7812ULL, 0x000fe200078ef80bULL, 0x0000000113197824ULL, 0x000fe400030e0615ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000001d121c7210ULL, 0x000fe40007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181f7faeULL, 0x0003e2000c901c46ULL,
0x0000000c4d167836ULL, 0x000fe20000000000ULL, 0x0000000c2300720cULL, 0x040fe20003f26070ULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0x0000007014217812ULL, 0x000fe200078ef80bULL,
0x0000001c1b257836ULL, 0x000fe20000000000ULL, 0x00000017131d7210ULL, 0x000fe200037fe4ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000002112207210ULL, 0x000fc40007fde0ffULL,
0xfffffff8232c7812ULL, 0x000fe200078ee20eULL, 0x000000104d147836ULL, 0x000fe20000000000ULL,
0x0000007016237812ULL, 0x000fe200078ef80bULL, 0x000000101a197824ULL, 0x002fe200078e0209ULL,
0x00000008250e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000113217824ULL, 0x000fe200030e0615ULL,
0x0000002312227210ULL, 0x000fe20007fde0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x000000001c197faeULL, 0x0003e2000d101c46ULL, 0x0000000c2500720cULL, 0x040fe40003f46070ULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x00000070141f7812ULL, 0x000fe200078ef80bULL,
0x000000144d167836ULL, 0x000fc40000000000ULL, 0x0000000113237824ULL, 0x000fe200030e0617ULL,
0xfffffff8252e7812ULL, 0x000fe200078ee20eULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000001f12147210ULL, 0x000fc60007fde0ffULL, 0x000000184d0e7836ULL, 0x000fe20000000000ULL,
0x00000070161f7812ULL, 0x000fe200078ef80bULL, 0x000000101e257824ULL, 0x000fe200078e0209ULL,
0x0000001513157210ULL, 0x000fe200037fe4ffULL, 0x000001000e1c7825ULL, 0x002fe200078e00ffULL,
0x0000001f12187210ULL, 0x000fe40007fde0ffULL, 0x0000000020257faeULL, 0x0003e2000d901c46ULL,
0x000000201b197836ULL, 0x000fe20000000000ULL, 0x000000701c1f7812ULL, 0x000fe200078ef80bULL,
0x0000001c4d167836ULL, 0x000fc40000000000ULL, 0x00000001190e7824ULL, 0x040fe200078e0208ULL,
0x0000000c1900720cULL, 0x040fe20003f66070ULL, 0x0000001026297824ULL, 0x000fe200078e0209ULL,
0x0000000319277819ULL, 0x000fe200000006ffULL, 0x0000000113197824ULL, 0x000fe200030e0617ULL,
0x0000001f121e7210ULL, 0x000fe20007fde0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0xfffffff8270e7812ULL, 0x000fc600078ee20eULL, 0x00000001131f7824ULL, 0x000fe200030e061dULL,
0x0000007016257812ULL, 0x002fe200078ef80bULL, 0x000000241b1d7836ULL, 0x000fe40000000000ULL,
0x0000001024217824ULL, 0x000fe200078e0209ULL, 0x00000025121c7210ULL, 0x000fe20007fde0ffULL,
0x000000081d277824ULL, 0x040fe200078e00ffULL, 0x000000081d1a7210ULL, 0x000fe20007ffe0ffULL,
0x000000204d167836ULL, 0x000fe20000000000ULL, 0x0000000022217faeULL, 0x0003e2000e101c46ULL,
0x0000000c1d00720cULL, 0x080fe20003f86070ULL, 0x00000001131d7824ULL, 0x000fe200030e0617ULL,
0xfffffff827287812ULL, 0x000fe200078ee21aULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000281b277810ULL, 0x000fe20007ffe0ffULL, 0x0000000014297faeULL, 0x0005e4000e901c46ULL,
0x000000244d1a7836ULL, 0x000fe20000000000ULL, 0x0000000c2700720cULL, 0x000fe20003fa6070ULL,
0x000000284d247836ULL, 0x000fc40000000000ULL, 0x000001001a227825ULL, 0x002fe200078e00ffULL,
0x0000007016217812ULL, 0x000fc600078ef80bULL, 0x0000000127167824ULL, 0x040fe200078e0208ULL,
0x0000002112207210ULL, 0x000fe20007fde0ffULL, 0x0000010024247825ULL, 0x000fe200078e00ffULL,
0x00000070222b7812ULL, 0x000fe400078ef80bULL, 0x0000001713217210ULL, 0x000fe200037fe4ffULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x0000002b12267210ULL, 0x000fe20007fde0ffULL,
0x000000102a297824ULL, 0x004fe200078e0209ULL, 0x0000007024177812ULL, 0x000fe200078ef80bULL,
0x000000304d227836ULL, 0x000fe20000000000ULL, 0xfffffff827247812ULL, 0x000fe200078ee216ULL,
0x0000002c4d167836ULL, 0x000fe20000000000ULL, 0x0000000018297faeULL, 0x0003e2000c101c46ULL,
0x0000000113277824ULL, 0x000fe200030e0623ULL, 0x0000001712147210ULL, 0x000fe20007fde0ffULL,
0x0000002c1b237836ULL, 0x000fc40000000000ULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000002513157210ULL, 0x000fe400037fe4ffULL, 0x0000000c2300720cULL, 0x0c0fe20003f06070ULL,
0x00000001231a7824ULL, 0x140fe200078e0208ULL, 0x0000007016257812ULL, 0x000fe200078ef80bULL,
0x00000008232d7824ULL, 0x000fe400078e00ffULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x0000002512167210ULL, 0x000fe40007fde0ffULL, 0xfffffff82d2a7812ULL, 0x000fe200078ee21aULL,
0x000000301b2b7836ULL, 0x000fe20000000000ULL, 0x0000007022297812ULL, 0x002fe200078ef80bULL,
0x000000102c257824ULL, 0x100fe200078e0209ULL, 0x0000001713177210ULL, 0x000fe200037fe4ffULL,
0x000000012b197824ULL, 0x040fe200078e0208ULL, 0x0000002912187210ULL, 0x000fe20007fde0ffULL,
0x000000082b2c7824ULL, 0x040fe200078e00ffULL, 0x000000001e257faeULL, 0x0003e2000c901c46ULL,
0x000000344d227836ULL, 0x000fe20000000000ULL, 0x0000000c2b00720cULL, 0x000fe20003f26070ULL,
0x000000102e297824ULL, 0x100fe200078e0209ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee219ULL,
0x000000384d1a7836ULL, 0x000fe20000000000ULL, 0x0000002313197210ULL, 0x000fe200037fe4ffULL,
0x0000010022227825ULL, 0x000fe200078e00ffULL, 0x000000001c297faeULL, 0x0005e6000d101c46ULL,
0x000000100e2b7824ULL, 0x100fe200078e0209ULL, 0x00000070221f7812ULL, 0x002fe200078ef80bULL,
0x00000010282d7824ULL, 0x000fc400078e0209ULL, 0x000000341b257836ULL, 0x000fe20000000000ULL,
0x00000000202b7faeULL, 0x0003e2000d901c46ULL, 0x0000003c1b317836ULL, 0x000fe20000000000ULL,
0x0000001f121e7210ULL, 0x000fe20007fde0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x00000000262d7faeULL, 0x0007e2000e101c46ULL, 0x0000000c2500720cULL, 0x080fe40003f86070ULL,
0x0000003c4d1c7836ULL, 0x004fe20000000000ULL, 0x0000000c2f00720cULL, 0x080fe20003f66070ULL,
0x00000001131f7824ULL, 0x000fe200030e0623ULL, 0x0000000c3100720cULL, 0x000fe20003f46070ULL,
0x00000001250c7824ULL, 0x040fe200078e0208ULL, 0x000000701a217812ULL, 0x002fe200078ef80bULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000325257819ULL, 0x000fc400000006ffULL,
0x00000021121a7210ULL, 0x000fe20007fde0ffULL, 0x000000012f0e7824ULL, 0x140fe200078e0208ULL,
0xfffffff8250c7812ULL, 0x000fe200078ee20cULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x000000701c257812ULL, 0x000fe200078ef80bULL, 0x0000000131087824ULL, 0x040fe200078e0208ULL,
0x0000000331317819ULL, 0x000fe200000006ffULL, 0x00000001131b7824ULL, 0x000fe200030e061bULL,
0xfffffff82f0e7812ULL, 0x000fe200078ee20eULL, 0x00000010240b7824ULL, 0x100fe200078e0209ULL,
0xfffffff831207812ULL, 0x000fe200078ee208ULL, 0x000000102a217824ULL, 0x100fe200078e0209ULL,
0x0000002512087210ULL, 0x000fe20007fde0ffULL, 0x000000102c237824ULL, 0x100fe200078e0209ULL,
0x000000090c257211ULL, 0x000fe200078e20ffULL, 0x000000100e277824ULL, 0x108fe200078e0209ULL,
0x00000000140b7faeULL, 0x0003e2000e901c46ULL, 0x0000001020297824ULL, 0x000fc400078e0209ULL,
0x0000000113097824ULL, 0x000fe200030e061dULL, 0x0000000016217faeULL, 0x0003e8000c101c46ULL,
0x0000000018237faeULL, 0x0003e8000c901c46ULL, 0x000000001e257faeULL, 0x0003e8000e101c46ULL,
0x000000001a277faeULL, 0x0003e8000d901c46ULL, 0x0000000008297faeULL, 0x0003e2000d101c46ULL,
0x0000000800d07947ULL, 0x000fea0003800000ULL, 0x0000000408177811ULL, 0x040fe400078fe8ffULL,
0x00000008081f7811ULL, 0x040fe400078fe8ffULL, 0x00000003171c7819ULL, 0x040fe200000006ffULL,
0x0000000117097824ULL, 0x100fe200078e0208ULL, 0x0000001008477811ULL, 0x040fe200078fe8ffULL,
0x000000081f1e7824ULL, 0x000fe200078e00ffULL, 0x0000000c08457811ULL, 0x040fe400078fe8ffULL,
0x00000014084b7811ULL, 0x040fe200078fe8ffULL, 0x0000000847197824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x000000011f097824ULL, 0x100fe200078e0208ULL,
0x00000008470e7210ULL, 0x000fe20007ffe0ffULL, 0x00000001450c7824ULL, 0x140fe200078e0208ULL,
0x00000018084d7811ULL, 0x040fe200078fe8ffULL, 0x0000000845157824ULL, 0x000fe200078e00ffULL,
0x0000002008357811ULL, 0x040fe200078fe8ffULL, 0x000000014b147824ULL, 0x140fe200078e0208ULL,
0x0000001c081d7811ULL, 0x040fe200078fe8ffULL, 0x000000084b1b7824ULL, 0x000fe200078e00ffULL,
0x0000002408237811ULL, 0x040fe200078fe8ffULL, 0x0000000835167824ULL, 0x040fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL, 0x0000000135097824ULL, 0x100fe200078e0208ULL,
0xfffffff819227812ULL, 0x000fe200078ee20eULL, 0x000000014d0e7824ULL, 0x100fe200078e0208ULL,
0xfffffff815207812ULL, 0x000fe200078ee20cULL, 0x000000081d197824ULL, 0x040fe200078e00ffULL,
0xfffffff81b2c7812ULL, 0x000fe200078ee214ULL, 0x000000011d147824ULL, 0x100fe200078e0208ULL,
0x000000034d157819ULL, 0x000fe200000006ffULL, 0x00000008231b7824ULL, 0x000fe200078e00ffULL,
0x0000003008417811ULL, 0x000fe200078fe8ffULL, 0x0000000102447824ULL, 0x000fe200078e024bULL,
0x00000034083d7811ULL, 0x000fe200078fe8ffULL, 0x00000001023a7824ULL, 0x000fe200078e0223ULL,
0x0000002c08217811ULL, 0x040fe200078fe8ffULL, 0x0000000841247824ULL, 0x000fe200078e00ffULL,
0x00000008230c7210ULL, 0x000fe20007ffe0ffULL, 0x000000083d257824ULL, 0x000fe200078e00ffULL,
0xfffffff8152e7812ULL, 0x000fe200078ee20eULL, 0x0000000141157824ULL, 0x100fe200078e0208ULL,
0xfffffff816097812ULL, 0x000fe200078ee209ULL, 0x000000013d167824ULL, 0x100fe200078e0208ULL,
0x00000028083b7811ULL, 0x000fe200078fe8ffULL, 0x0000000102467824ULL, 0x000fe200078e0221ULL,
0xfffffff819307812ULL, 0x000fe200078ee214ULL, 0x0000000121147824ULL, 0x100fe200078e0208ULL,
0xfffffff81b0c7812ULL, 0x000fe200078ee20cULL, 0x000000013b0e7824ULL, 0x000fe200078e0208ULL,
0x00000003211b7819ULL, 0x000fe200000006ffULL, 0x000000083b197824ULL, 0x000fe200078e00ffULL,
0x0000003808437811ULL, 0x000fe200078fe8ffULL, 0x00000001023c7824ULL, 0x000fe200078e0241ULL,
0xfffffff824247812ULL, 0x000fc400078ee215ULL, 0xfffffff825267812ULL, 0x000fe200078ee216ULL,
0x0000000102167824ULL, 0x000fe200078e0217ULL, 0xfffffff81b187812ULL, 0x000fe200078ee214ULL,
0x0000000143177824ULL, 0x040fe200078e0208ULL, 0x0000000808157211ULL, 0x040fe200078fe8ffULL,
0x0000000843287824ULL, 0x000fe200078e00ffULL, 0x0000000208147211ULL, 0x000fe200078fe8ffULL,
0x0000000102407824ULL, 0x000fe200078e0243ULL, 0x000000074a1a7211ULL, 0x000fe400078e70ffULL,
0xfffffff8190e7812ULL, 0x000fe200078ee20eULL, 0x0000010040407825ULL, 0x000fe200078e00ffULL,
0x0000003c083f7811ULL, 0x000fc400078fe8ffULL, 0x0000000715197812ULL, 0x000fe200078ec0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe400078ee217ULL,
0x0ffffff819257812ULL, 0x000fe200078ef808ULL, 0x000010001a1b7836ULL, 0x000fe20000000000ULL,
0x000000033f277819ULL, 0x000fe200000006ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000007014197812ULL, 0x000fe400078ef80bULL, 0x0000001b09377211ULL, 0x080fe200078e20ffULL,
0x000000013f087824ULL, 0x000fe200078e0208ULL, 0x0000007016097812ULL, 0x000fe200078ef80bULL,
0x000000100c397824ULL, 0x100fe200078e021bULL, 0x0000003502357210ULL, 0x000fe20007ffe0ffULL,
0x000000100e0c7824ULL, 0x100fe200078e021bULL, 0xfffffff8272a7812ULL, 0x000fe200078ee208ULL,
0x00000010180e7824ULL, 0x000fe200078e021bULL, 0x0000001912087210ULL, 0x000fe20007f1e0ffULL,
0x0000000102167824ULL, 0x000fe200078e021fULL, 0x0000000912147210ULL, 0x000fe20007f3e0ffULL,
0x000000101e297824ULL, 0x000fe200078e021bULL, 0x0000004502187210ULL, 0x000fe20007ffe0ffULL,
0x0000000113097824ULL, 0x040fe200000e0615ULL, 0x0000001b202b7211ULL, 0x080fe200078e20ffULL,
0x0000000113157824ULL, 0x000fe200008e0617ULL, 0x0000001b26267211ULL, 0x000fe200078e20ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000003d023e7210ULL, 0x000fc60007ffe0ffULL,
0x0000010018187825ULL, 0x000fc800078e00ffULL, 0x00000001021a7824ULL, 0x040fe200078e0247ULL,
0x0000007018477812ULL, 0x000fe200078ef80bULL, 0x00000001021e7824ULL, 0x000fe200078e024dULL,
0x00000070164d7812ULL, 0x000fe200078ef80bULL, 0x0000010044447825ULL, 0x000fe200078e00ffULL,
0x0000004712187210ULL, 0x000fe40007f3e0ffULL, 0x0000004d12167210ULL, 0x000fe20007f1e0ffULL,
0x000001001e1e7825ULL, 0x000fe200078e00ffULL, 0x0000007044477812ULL, 0x000fe400078ef80bULL,
0x0000001713177210ULL, 0x000fe200007fe4ffULL, 0x00000010222d7824ULL, 0x000fc400078e021bULL,
0x000000101c277824ULL, 0x000fe200078e021bULL, 0x00000047121c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000102227824ULL, 0x000fe200078e021dULL, 0x000000701e477812ULL, 0x000fe200078ef80bULL,
0x0000001025257824ULL, 0x100fe400078e021bULL, 0x000000102c2f7824ULL, 0x100fe400078e021bULL,
0x000000102e317824ULL, 0x100fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008257faeULL, 0x0003e2000b901c46ULL, 0x0000001030337824ULL, 0x000fc400078e021bULL,
0x0000001024247824ULL, 0x100fe200078e021bULL, 0x0000000014277faeULL, 0x0003e2000b901c46ULL,
0x0000001028287824ULL, 0x100fe400078e021bULL, 0x000000102a2a7824ULL, 0x000fe200078e021bULL,
0x0000000016297faeULL, 0x0003e2000b901c46ULL, 0x000001001a1a7825ULL, 0x000fc800078e00ffULL,
0x0000010022227825ULL, 0x000fe200078e00ffULL, 0x000000701a4b7812ULL, 0x000fc600078ef80bULL,
0x00000001131d7824ULL, 0x000fe200000e0645ULL, 0x00000047121e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000102447824ULL, 0x000fe200078e023bULL, 0x0000007022477812ULL, 0x000fe200078ef80bULL,
0x0000010035347825ULL, 0x000fe200078e00ffULL, 0x0000004b121a7210ULL, 0x000fc60007f5e0ffULL,
0x000001003a3a7825ULL, 0x000fe200078e00ffULL, 0x0000007034217812ULL, 0x000fc600078ef80bULL,
0x0000010044447825ULL, 0x000fe200078e00ffULL, 0x000000703a4b7812ULL, 0x000fc600078ef80bULL,
0x00000001131f7824ULL, 0x040fe200000e061fULL, 0x0000004712207210ULL, 0x000fe20007f1e0ffULL,
0x0000000113197824ULL, 0x040fe200008e0619ULL, 0x0000007044477812ULL, 0x000fe200078ef80bULL,
0x00000001131b7824ULL, 0x040fe200010e061bULL, 0x0000002112227210ULL, 0x000fe20007f3e0ffULL,
0x0000000102427824ULL, 0x000fe200078e023fULL, 0x0000002313217210ULL, 0x000fe200007fe4ffULL,
0x000001003c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004b12347210ULL, 0x000fe20007f1e0ffULL,
0x00000000182b7faeULL, 0x0003e2000b901c46ULL, 0x00000047123a7210ULL, 0x000fe20007f5e0ffULL,
0x0000010046467825ULL, 0x000fe200078e00ffULL, 0x000000703c4d7812ULL, 0x000fe200078ef80bULL,
0x000000001a2d7faeULL, 0x0003e4000b901c46ULL, 0x0000000113237824ULL, 0x000fc400008e0635ULL,
0x0000000113357824ULL, 0x040fe200000e063bULL, 0x000000001c2f7faeULL, 0x0003e2000b901c46ULL,
0x00000001133b7824ULL, 0x040fe200010e0645ULL, 0x0000007046457812ULL, 0x000fe200078ef80bULL,
0x000001003e3e7825ULL, 0x000fe200078e00ffULL, 0x000000001e317faeULL, 0x0003e4000b901c46ULL,
0x0000004512447210ULL, 0x000fe20007f1e0ffULL, 0x0000010042427825ULL, 0x000fe200078e00ffULL,
0x000000703e4b7812ULL, 0x000fe200078ef80bULL, 0x0000000020337faeULL, 0x0003e4000b901c46ULL,
0x0000000113457824ULL, 0x000fe200000e0647ULL, 0x0000007040477812ULL, 0x000fe200078ef80bULL,
0x0000000022377faeULL, 0x0003e2000b901c46ULL, 0x00000070420b7812ULL, 0x000fc400078ef80bULL,
0x0000004d123c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000034397faeULL, 0x0003e2000b901c46ULL,
0x0000004b123e7210ULL, 0x000fe40007f3e0ffULL, 0x0000004712407210ULL, 0x000fe20007f5e0ffULL,
0x00000001133d7824ULL, 0x040fe200000e063dULL, 0x0000000b12127210ULL, 0x000fe20007f7e0ffULL,
0x000000003a0c7faeULL, 0x0003e2000b901c46ULL, 0x0000003f133f7210ULL, 0x000fe20000ffe4ffULL,
0x0000000113417824ULL, 0x040fe400010e0641ULL, 0x0000000113137824ULL, 0x000fe200018e0643ULL,
0x00000000440e7faeULL, 0x0003e8000b901c46ULL, 0x000000003c247faeULL, 0x0003e8000b901c46ULL,
0x000000003e267faeULL, 0x0003e8000b901c46ULL, 0x0000000040287faeULL, 0x0003e8000b901c46ULL,
0x00000000122a7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000087805ULL, 0x002fe20000015200ULL, 0x01b60011070075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000012080c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e09ULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011412ULL,
0x0000000c0b0b7211ULL, 0x000fc800078110ffULL, 0x00000012ff0c7210ULL, 0x000fc800007fe4ffULL,
0x000000020b0b7819ULL, 0x000fc8000000120cULL, 0x0000000b0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x01b60011070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000f4e00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00009400ff4c7b82ULL, 0x000e620000000800ULL, 0x00000000000b7919ULL, 0x000ea20000000000ULL,
0x0000840000097ab9ULL, 0x000fe20000000800ULL, 0x000000084a4b7824ULL, 0x140fe200078e0207ULL,
0x0000001f09047890ULL, 0x000fe4000fffe03fULL, 0x8000000949087c36ULL, 0x000fe20008000000ULL,
0xffffffff09057890ULL, 0x000fe2000fffe03fULL, 0x000000204a0e7824ULL, 0x000fe200078e0207ULL,
0x000000043f047899ULL, 0x000fe40008011604ULL, 0x0000000909087890ULL, 0x000fc4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL, 0x0000004c0d4c7224ULL, 0x002fe200078e02ffULL,
0x00000008ff0d7819ULL, 0x000fd40000011608ULL, 0x00008e00ff767b82ULL, 0x002e620000000a00ULL,
0x000000014e087810ULL, 0x000fe20007ffe0ffULL, 0x0000000504097224ULL, 0x000fe400078e02ffULL,
0x000001004e0c7824ULL, 0x000fe200078e0203ULL, 0x0000000f0800720cULL, 0x000fe20003f06070ULL,
0x0000010009087825ULL, 0x002fd800078e0076ULL, 0x0000000800f08947ULL, 0x000fea0003800000ULL,
0x00000003ff1e7819ULL, 0x004fe2000001160bULL, 0x000000100b737824ULL, 0x040fe200078e00ffULL,
0x0ffffff80b727812ULL, 0x000fe200078ec0ffULL, 0x000040004a717824ULL, 0x000fe200078e0207ULL,
0x0000000c1e187810ULL, 0x000fe20007ffe0ffULL, 0x000000041e147836ULL, 0x000fe20000000000ULL,
0x0000007073737812ULL, 0x000fe200078ec0ffULL, 0x000000081e167836ULL, 0x000fe20000000000ULL,
0x000000201e327810ULL, 0x000fe20007ffe0ffULL, 0x0000000814227824ULL, 0x000fe200078e00ffULL,
0x0000000b14057210ULL, 0x000fe20007ffe0ffULL, 0x0000000116117824ULL, 0x140fe200078e020bULL,
0x0000008073107812ULL, 0x000fe200078efcffULL, 0x0000000816267824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee205ULL, 0x000000101e1a7836ULL, 0x000fe20000000000ULL,
0x0000000c49057248ULL, 0x000fe20007fe0000ULL, 0x0000000118157824ULL, 0x040fe200078e020bULL,
0xfffffff826267812ULL, 0x000fe200078ee211ULL, 0x0000000818287824ULL, 0x000fe200078e00ffULL,
0x0000000b1a177210ULL, 0x000fe20007ffe0ffULL, 0x0000000102137824ULL, 0x000fc400078e021eULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee215ULL,
0x000000081a2a7824ULL, 0x000fe200078e00ffULL, 0x0000001402157210ULL, 0x000fe20007ffe0ffULL,
0x0000000105057824ULL, 0x000fe400078e0a0cULL, 0x0000010013127825ULL, 0x000fe200078e0010ULL,
0xfffffff82a2a7812ULL, 0x000fe400078ee217ULL, 0x000000051400720cULL, 0x080fe20003f86070ULL,
0x0000000102177824ULL, 0x000fe200078e0216ULL, 0x0000001208127210ULL, 0x000fe20007f1e0ffULL,
0x0000010015147825ULL, 0x000fe200078e0010ULL, 0x000000051600720cULL, 0x000fc40003f26070ULL,
0x000000051800720cULL, 0x000fe20003f46070ULL, 0x0000010017167825ULL, 0x000fe200078e0010ULL,
0x0000001408247210ULL, 0x000fc60007f7e0ffULL, 0x000000141e2c7836ULL, 0x000fe20000000000ULL,
0x0000001509257210ULL, 0x000fe20001ffe4ffULL, 0x00000001021b7824ULL, 0x040fe200078e0218ULL,
0x0000001608187210ULL, 0x000fe20007fbe0ffULL, 0x0000000102217824ULL, 0x000fe400078e021aULL,
0x0000000109137824ULL, 0x000fe200000e0613ULL, 0x000000051a00720cULL, 0x000fe20003f06070ULL,
0x0000000102197824ULL, 0x000fe400078e022cULL, 0x000001001b1a7825ULL, 0x000fc800078e0010ULL,
0x0000010021207825ULL, 0x000fe200078e0010ULL, 0x0000001a081c7210ULL, 0x000fc60007f7e0ffULL,
0x0000010019147825ULL, 0x000fc800078e0010ULL, 0x0000000109197824ULL, 0x040fe200028e0617ULL,
0x0000002008167210ULL, 0x000fe20007fbe0ffULL, 0x000000181e2e7836ULL, 0x000fe20000000000ULL,
0x0000001408147210ULL, 0x000fe20007fde0ffULL, 0x000000011e1f7824ULL, 0x040fe400078e020bULL,
0x00000001091d7824ULL, 0x040fe200018e061bULL, 0x0000002e021b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000109177824ULL, 0x000fe200028e0621ULL, 0x000000051e00720cULL, 0x080fe20003fa6070ULL,
0x000000012c217824ULL, 0x040fe200078e020bULL, 0x000000052c00720cULL, 0x040fe20003f66070ULL,
0x0000001c1e307836ULL, 0x000fe20000000000ULL, 0x000000032c2c7819ULL, 0x000fe200000006ffULL,
0x00003000714d7836ULL, 0x000fe20000000000ULL, 0x0000000772207812ULL, 0x000fe200078ef81fULL,
0x000001001b1a7825ULL, 0x000fe200078e0010ULL, 0xfffffff82c2c7812ULL, 0x000fc600078ee221ULL,
0x0000000102217824ULL, 0x000fe400078e0230ULL, 0x00000010201f7824ULL, 0x000fe400078e024dULL,
0x0000000109157824ULL, 0x000fe200030e0615ULL, 0x0000001a081a7210ULL, 0x000fe20007fde0ffULL,
0x0000001022277824ULL, 0x000fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121f7faeULL, 0x000fe2000e901c46ULL, 0x0000010021207825ULL, 0x000fe200078e0010ULL,
0x000000052e00720cULL, 0x080fe40003fa6070ULL, 0x0000000024277faeULL, 0x0003e2000e101c46ULL,
0x0000000102237824ULL, 0x000fe200078e0232ULL, 0x000000053000720cULL, 0x000fe20003f86070ULL,
0x00000001091b7824ULL, 0x000fe200030e061bULL, 0x0000002008207210ULL, 0x000fe20007fde0ffULL,
0x000000012e297824ULL, 0x140fe200078e020bULL, 0x000000032e2e7819ULL, 0x000fe200000006ffULL,
0x00000001302b7824ULL, 0x000fc400078e020bULL, 0x0000000830307824ULL, 0x000fe400078e00ffULL,
0x0000010023227825ULL, 0x000fe200078e0010ULL, 0xfffffff82e247812ULL, 0x002fe400078ee229ULL,
0xfffffff8302e7812ULL, 0x000fe200078ee22bULL, 0x00000010261f7824ULL, 0x000fe200078e024dULL,
0x0000000332297819ULL, 0x000fe200000006ffULL, 0x0000000109217824ULL, 0x000fe200030e0621ULL,
0x0000002208127210ULL, 0x000fe20007fde0ffULL, 0x0000001028257824ULL, 0x000fe200078e024dULL,
0x00000000181f7faeULL, 0x0003e2000c901c46ULL, 0x000000241e307836ULL, 0x000fe20000000000ULL,
0x0000002309137210ULL, 0x000fe200037fe4ffULL, 0x0000000132267824ULL, 0x100fe200078e020bULL,
0x000000001c257faeULL, 0x0005e2000d101c46ULL, 0x0000000102237824ULL, 0x000fe200078e0230ULL,
0x000000053000720cULL, 0x0c0fe20003f46070ULL, 0x0000000130277824ULL, 0x000fe200078e020bULL,
0x000000053200720cULL, 0x000fe20003f26070ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0xfffffff829267812ULL, 0x000fe200078ee226ULL, 0x0000010023227825ULL, 0x000fc600078e0010ULL,
0xfffffff830187812ULL, 0x002fe200078ee227ULL, 0x000000102a197824ULL, 0x100fe200078e024dULL,
0x0000004d2c1d7211ULL, 0x004fe200078e20ffULL, 0x00000010241f7824ULL, 0x100fe200078e024dULL,
0x0000002208227210ULL, 0x000fe20007fde0ffULL, 0x0000001018297824ULL, 0x100fe200078e024dULL,
0x000000281e187810ULL, 0x000fe20007ffe0ffULL, 0x000000102e257824ULL, 0x100fe200078e024dULL,
0x0000000016197faeULL, 0x0003e2000c101c46ULL, 0x0000001026277824ULL, 0x000fe200078e024dULL,
0x0000003c1e2c7810ULL, 0x000fe20007ffe0ffULL, 0x0000002c1e247836ULL, 0x000fe20000000000ULL,
0x00000000141d7faeULL, 0x0005e2000d901c46ULL, 0x000000301e267836ULL, 0x000fe20000000000ULL,
0x000000052c00720cULL, 0x080fe20003f06070ULL, 0x0000000109237824ULL, 0x000fe200030e0623ULL,
0x000000001a1f7faeULL, 0x0007e2000e901c46ULL, 0x000000341e287836ULL, 0x000fe20000000000ULL,
0x000000051800720cULL, 0x0c0fe20003fa6070ULL, 0x000000381e2a7836ULL, 0x000fe20000000000ULL,
0x0000000020257faeULL, 0x000fe2000e101c46ULL, 0x0000000118167824ULL, 0x042fe200078e020bULL,
0x0000002602177210ULL, 0x000fe20007ffe0ffULL, 0x0000000818197824ULL, 0x000fe200078e00ffULL,
0x0000000012277faeULL, 0x0003e2000c901c46ULL, 0x0000000102157824ULL, 0x004fe200078e0218ULL,
0x000000052400720cULL, 0x080fe20003f86070ULL, 0x00000001021d7824ULL, 0x000fe200078e022aULL,
0xfffffff8191c7812ULL, 0x000fe200078ee216ULL, 0x0000000022297faeULL, 0x0005e2000d101c46ULL,
0x0000010017167825ULL, 0x000fe200078e0010ULL, 0x000000052600720cULL, 0x000fc40003f66070ULL,
0x000000052800720cULL, 0x080fe20003f46070ULL, 0x00000008241b7824ULL, 0x008fe200078e00ffULL,
0x000000052a00720cULL, 0x000fe20003f26070ULL, 0x0000010015127825ULL, 0x002fc800078e0010ULL,
0x0000000102157824ULL, 0x040fe200078e0224ULL, 0x0000001208127210ULL, 0x000fe20007fde0ffULL,
0x0000000102057824ULL, 0x000fe400078e0228ULL, 0x0000010015147825ULL, 0x000fc800078e0010ULL,
0x0000000109137824ULL, 0x000fe200030e0613ULL, 0x0000001408187210ULL, 0x000fe20007fde0ffULL,
0x0000000124147824ULL, 0x100fe400078e020bULL, 0x0000000828227824ULL, 0x004fe200078e00ffULL,
0x0000001509197210ULL, 0x000fe200037fe4ffULL, 0x00000001261f7824ULL, 0x040fe200078e020bULL,
0x00000016081a7210ULL, 0x000fe20007fde0ffULL, 0x0000000826207824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1e7812ULL, 0x000fe200078ee214ULL, 0x0000010005147825ULL, 0x000fc600078e0010ULL,
0xfffffff820207812ULL, 0x000fe200078ee21fULL, 0x00000001091b7824ULL, 0x000fe200030e0617ULL,
0x0000001408147210ULL, 0x000fe20007fde0ffULL, 0x000001001d167825ULL, 0x000fe200078e0010ULL,
0x0000000b281d7210ULL, 0x000fc60007ffe0ffULL, 0x0000000102057824ULL, 0x000fe200078e022cULL,
0xfffffff822227812ULL, 0x000fe200078ee21dULL, 0x0000000109157824ULL, 0x000fe200030e0615ULL,
0x0000001608167210ULL, 0x000fe20007fde0ffULL, 0x0000010005107825ULL, 0x000fe200078e0010ULL,
0x0000000b2a057210ULL, 0x000fc60007ffe0ffULL, 0x000000082a2a7824ULL, 0x000fe400078e00ffULL,
0x0000000109177824ULL, 0x000fe200030e0617ULL, 0x0000001008087210ULL, 0x000fe20007fde0ffULL,
0x000000012c1d7824ULL, 0x040fe200078e020bULL, 0xfffffff82a107812ULL, 0x000fe200078ee205ULL,
0x000000082c2c7824ULL, 0x000fe200078e00ffULL, 0x0000001109097210ULL, 0x000fe200037fe4ffULL,
0x000000101c057824ULL, 0x100fe400078e024dULL, 0x000000101e117824ULL, 0x100fe200078e024dULL,
0xfffffff82c1c7812ULL, 0x000fe200078ee21dULL, 0x00000010201d7824ULL, 0x100fe200078e024dULL,
0x0000000012057faeULL, 0x0003e2000e901c46ULL, 0x00000010221f7824ULL, 0x100fe200078e024dULL,
0x0000004d1c237211ULL, 0x000fe200078e20ffULL, 0x0000001010217824ULL, 0x000fe200078e024dULL,
0x0000000018117faeULL, 0x0003e8000e101c46ULL, 0x000000001a1d7faeULL, 0x0003e8000d901c46ULL,
0x00000000141f7faeULL, 0x0003e8000d101c46ULL, 0x0000000016217faeULL, 0x0003e8000c901c46ULL,
0x0000000008237faeULL, 0x0003e2000c101c46ULL, 0x0000000800a07947ULL, 0x000fea0003800000ULL,
0x000000080b107811ULL, 0x044fe200078fe8ffULL, 0x000000100b737824ULL, 0x040fe200078e00ffULL,
0x000000040b057811ULL, 0x040fe400078fe8ffULL, 0x0000000c0b127811ULL, 0x040fe200078fe8ffULL,
0x0000000110527824ULL, 0x140fe200078e020bULL, 0x000000140b147811ULL, 0x040fe200078fe8ffULL,
0x0000000810137824ULL, 0x000fe200078e00ffULL, 0x000000180b167811ULL, 0x000fe200078fe8ffULL,
0x0000000105507824ULL, 0x140fe200078e020bULL, 0x0000000b12467210ULL, 0x000fe20007ffe0ffULL,
0x0000000805117824ULL, 0x000fe200078e00ffULL, 0xfffffff813527812ULL, 0x000fe200078ee252ULL,
0x0000000812157824ULL, 0x000fe200078e00ffULL, 0x000000100b137811ULL, 0x000fe200078fe8ffULL,
0x0000000114447824ULL, 0x100fe200078e020bULL, 0xfffffff811507812ULL, 0x000fe200078ee250ULL,
0x0000000116427824ULL, 0x140fe200078e020bULL, 0xfffffff815467812ULL, 0x000fe200078ee246ULL,
0x0000000816197824ULL, 0x000fe200078e00ffULL, 0x0000000314157819ULL, 0x000fe200000006ffULL,
0x0000000113547824ULL, 0x100fe200078e020bULL, 0x000000200b187811ULL, 0x000fe200078fe8ffULL,
0x0000000813117824ULL, 0x000fe200078e00ffULL, 0x0000001c0b177811ULL, 0x000fe200078fe8ffULL,
0x0000000102277824ULL, 0x000fe200078e0216ULL, 0xfffffff815447812ULL, 0x000fe200078ee244ULL,
0x0000000818157824ULL, 0x000fe200078e00ffULL, 0xfffffff819427812ULL, 0x000fe200078ee242ULL,
0x0000000117407824ULL, 0x040fe200078e020bULL, 0xfffffff811547812ULL, 0x000fe200078ee254ULL,
0x0000000817117824ULL, 0x000fe200078e00ffULL, 0x000000240b197811ULL, 0x040fe200078fe8ffULL,
0x00000001022b7824ULL, 0x000fe200078e0217ULL, 0x0000000b183e7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0x000000280b1a7811ULL, 0x000fe200078fe8ffULL,
0x00000001193c7824ULL, 0x100fe200078e020bULL, 0x0000002c0b1c7811ULL, 0x000fe200078fe8ffULL,
0x00000008191b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8153e7812ULL, 0x000fe200078ee23eULL,
0x000000011a3a7824ULL, 0x100fe200078e020bULL, 0xfffffff811407812ULL, 0x000fe200078ee240ULL,
0x000000011c387824ULL, 0x140fe200078e020bULL, 0x000000300b1d7811ULL, 0x040fe200078fe8ffULL,
0x000000081c157824ULL, 0x000fe200078e00ffULL, 0x000000031a117819ULL, 0x000fe200000006ffULL,
0x0000000102257824ULL, 0x040fe200078e0214ULL, 0x000000340b1e7811ULL, 0x000fe200078fe8ffULL,
0x000000011d367824ULL, 0x100fe200078e020bULL, 0x000000380b207811ULL, 0x000fe200078fe8ffULL,
0x00000001021f7824ULL, 0x000fe200078e0212ULL, 0xfffffff81b3c7812ULL, 0x000fe200078ee23cULL,
0x000000081d1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8113a7812ULL, 0x000fe200078ee23aULL,
0x000000081e117824ULL, 0x000fe200078e00ffULL, 0xfffffff815387812ULL, 0x000fe200078ee238ULL,
0x0000000120327824ULL, 0x140fe200078e020bULL, 0x0000003c0b227811ULL, 0x000fe200078fe8ffULL,
0x0000000820157824ULL, 0x000fe200078e00ffULL, 0x0000000b1e347210ULL, 0x000fe20007ffe0ffULL,
0x0000000102297824ULL, 0x000fe200078e021aULL, 0x0000007073737812ULL, 0x000fe200078ec0ffULL,
0x0000000122307824ULL, 0x000fe200078e020bULL, 0xfffffff81b367812ULL, 0x000fe200078ee236ULL,
0x00000001022d7824ULL, 0x000fe200078e0218ULL, 0x00000003221b7819ULL, 0x000fe200000006ffULL,
0x0000000102237824ULL, 0x040fe200078e021cULL, 0xfffffff811347812ULL, 0x000fe200078ee234ULL,
0x00000001021d7824ULL, 0x040fe200078e021dULL, 0xfffffff815327812ULL, 0x000fe200078ee232ULL,
0x0000000102157824ULL, 0x040fe200078e0205ULL, 0x0000008073167812ULL, 0x000fe200078efcffULL,
0x0000000102057824ULL, 0x000fe200078e0222ULL, 0x000000020b117211ULL, 0x000fc400078fe8ffULL,
0xfffffff81b307812ULL, 0x000fe200078ee230ULL, 0x00000001021b7824ULL, 0x040fe200078e0210ULL,
0x0000001302217210ULL, 0x000fe20007ffe0ffULL, 0x0000010015147825ULL, 0x100fe200078e0016ULL,
0x00000019022f7210ULL, 0x000fe40007ffe0ffULL, 0x0000002002137210ULL, 0x000fe20007ffe0ffULL,
0x0000010011107825ULL, 0x000fe200078e0016ULL, 0x0000001408147210ULL, 0x000fe40007f3e0ffULL,
0x0ffffff80b727812ULL, 0x000fe200078ec0ffULL, 0x0000000102197824ULL, 0x000fe200078e021eULL,
0x0000001008107210ULL, 0x000fe20007f1e0ffULL, 0x0000010021207825ULL, 0x000fe200078e0016ULL,
0x000000074a717211ULL, 0x000fc600078e70ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0016ULL,
0x000001001b1a7825ULL, 0x000fc800078e0016ULL, 0x0000000109157824ULL, 0x040fe200008e0615ULL,
0x0000002008207210ULL, 0x000fe20007f3e0ffULL, 0x0000000109117824ULL, 0x000fe200000e0611ULL,
0x0000001e081e7210ULL, 0x000fe20007f1e0ffULL, 0x000001002d2c7825ULL, 0x000fe200078e0016ULL,
0x0000001a081a7210ULL, 0x000fc60007f5e0ffULL, 0x0000010025247825ULL, 0x000fe200078e0016ULL,
0x0000001b091b7210ULL, 0x000fc600017fe4ffULL, 0x000001002b2a7825ULL, 0x000fe200078e0016ULL,
0x0000002408247210ULL, 0x000fc60007f5e0ffULL, 0x0000000109217824ULL, 0x040fe200008e0621ULL,
0x0000002c082c7210ULL, 0x000fe20007f3e0ffULL, 0x00000001091f7824ULL, 0x000fe200000e061fULL,
0x0000002a082a7210ULL, 0x000fe20007f1e0ffULL, 0x0000010027267825ULL, 0x000fc600078e0016ULL,
0x0000002b092b7210ULL, 0x000fe200007fe4ffULL, 0x0000010023227825ULL, 0x000fe200078e0016ULL,
0x0000002608267210ULL, 0x000fc60007f7e0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0016ULL,
0x0000002208227210ULL, 0x000fc60007f1e0ffULL, 0x000001002f2e7825ULL, 0x000fc800078e0016ULL,
0x00000001092d7824ULL, 0x040fe200008e062dULL, 0x0000001c081c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000109257824ULL, 0x000fe200010e0625ULL, 0x0000002e082e7210ULL, 0x000fe20007f5e0ffULL,
0x0000010029287825ULL, 0x000fc800078e0016ULL, 0x0000010019187825ULL, 0x000fc800078e0016ULL,
0x0000010013127825ULL, 0x000fc800078e0016ULL, 0x0000010005167825ULL, 0x000fe200078e0016ULL,
0x0000000b0b057211ULL, 0x000fc600078fe8ffULL, 0x0000000109277824ULL, 0x040fe200018e0627ULL,
0x0000002808287210ULL, 0x000fe20007f7e0ffULL, 0x0000000109237824ULL, 0x040fe200000e0623ULL,
0x0000001808187210ULL, 0x000fe20007f1e0ffULL, 0x00000001091d7824ULL, 0x040fe200008e061dULL,
0x0000001208127210ULL, 0x000fe20007f3e0ffULL, 0x00000001092f7824ULL, 0x040fe200010e062fULL,
0x0000000772567812ULL, 0x000fe200078ef805ULL, 0x00003000714d7836ULL, 0x000fe20000000000ULL,
0x0000001608087210ULL, 0x000fe20007f5e0ffULL, 0x0000000109297824ULL, 0x040fe200018e0629ULL,
0x0000001309137210ULL, 0x000fe20000ffe4ffULL, 0x0000000109197824ULL, 0x000fe200000e0619ULL,
0x0000004d54357211ULL, 0x000fe200078e20ffULL, 0x0000001056057824ULL, 0x000fc400078e024dULL,
0x0000000109097824ULL, 0x000fe400010e0617ULL, 0x0000001050177824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010057faeULL, 0x0003e2000b901c46ULL,
0x0000001052317824ULL, 0x100fe400078e024dULL, 0x0000001046337824ULL, 0x100fe200078e024dULL,
0x0000000014177faeULL, 0x0005e2000b901c46ULL, 0x0000001044377824ULL, 0x100fe400078e024dULL,
0x0000001042397824ULL, 0x100fe200078e024dULL, 0x000000001a317faeULL, 0x0007e2000b901c46ULL,
0x0000001040057824ULL, 0x002fc600078e024dULL, 0x000000001e337faeULL, 0x0003e2000b901c46ULL,
0x000000103e117824ULL, 0x100fe200078e024dULL, 0x0000004d3c157211ULL, 0x004fe400078e20ffULL,
0x0000000020357faeULL, 0x0005e2000b901c46ULL, 0x000000103a177824ULL, 0x100fe400078e024dULL,
0x00000010381b7824ULL, 0x108fe200078e024dULL, 0x0000000024377faeULL, 0x0007e8000b901c46ULL,
0x0000000026397faeULL, 0x000fe2000b901c46ULL, 0x00000010361f7824ULL, 0x002fc600078e024dULL,
0x000000002a057faeULL, 0x0003e2000b901c46ULL, 0x0000001034217824ULL, 0x004fc600078e024dULL,
0x000000002c117faeULL, 0x0005e2000b901c46ULL, 0x0000001030257824ULL, 0x008fc600078e024dULL,
0x000000002e157faeULL, 0x0005e2000b901c46ULL, 0x0000004d32057211ULL, 0x002fc600078e20ffULL,
0x0000000028177faeULL, 0x0005e8000b901c46ULL, 0x00000000221b7faeULL, 0x0005e8000b901c46ULL,
0x000000001c1f7faeULL, 0x0005e8000b901c46ULL, 0x0000000018217faeULL, 0x0005e8000b901c46ULL,
0x0000000012057faeULL, 0x0005e8000b901c46ULL, 0x0000000008257faeULL, 0x0005e4000b901c46ULL,
0x0000000406067836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff057424ULL, 0x006fc600078e00ffULL, 0x000000480600720cULL, 0x000fda0003f06070ULL,
0x00009000ff108b82ULL, 0x000e620000000a00ULL, 0x000000024c098824ULL, 0x000fe200078e0206ULL,
0x00000004ff607819ULL, 0x100fe4000001160bULL, 0x00000003ff087819ULL, 0x000fe4000001160bULL,
0x0000100071717810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000409108825ULL, 0x002fca00078e0010ULL, 0x0000000610058981ULL, 0x0002a2000c1e1900ULL,
0x000000070b097812ULL, 0x000fe400078ec0ffULL, 0x00000003603c7819ULL, 0x000fe400000006ffULL,
0x0000000108137812ULL, 0x000fe400078ec0ffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee209ULL,
0x00000008094f7812ULL, 0x000fe400078ef80bULL, 0x000000303c387810ULL, 0x000fe20007ffe0ffULL,
0x00000001133b7824ULL, 0x000fc400078e023cULL, 0x000000083c747824ULL, 0x000fe400078e00ffULL,
0x0000000160607824ULL, 0x000fe200078e024fULL, 0x000000343b647810ULL, 0x000fe20007ffe0ffULL,
0x000000104f157824ULL, 0x040fe200078e00ffULL, 0xfffffff874747812ULL, 0x000fe200078ee23bULL,
0x000000103c3a7836ULL, 0x000fe20000000000ULL, 0x0000000260117810ULL, 0x002fe20007ffe0ffULL,
0x000000104f127824ULL, 0x000fe200078e00ffULL, 0xfffffff015107812ULL, 0x000fe200078ee260ULL,
0x0000000113707824ULL, 0x040fe200078e023aULL, 0x000000143b677810ULL, 0x000fe20007ffe0ffULL,
0x000000083a197824ULL, 0x000fe200078e00ffULL, 0xfffffff012127812ULL, 0x000fe200078ee211ULL,
0x0000001074147824ULL, 0x000fe200078e0271ULL, 0x0000000338117819ULL, 0x000fe200000006ffULL,
0x0000001010107824ULL, 0x000fe200078e0207ULL, 0xfffffff819707812ULL, 0x000fe200078ee270ULL,
0x00000001136e7824ULL, 0x000fe200078e0238ULL, 0x0000000712127211ULL, 0x000fe200078e20ffULL,
0x000000001414783bULL, 0x000fe20000000200ULL, 0x000000203c397836ULL, 0x000fc40000000000ULL,
0x0000001070347824ULL, 0x100fe200078e0271ULL, 0x000000001028783bULL, 0x0002e20000000200ULL,
0xfffffff8116e7812ULL, 0x000fe200078ee26eULL, 0x000000083c187824ULL, 0x000fe200078e00ffULL,
0x000000033a117819ULL, 0x000fe200000006ffULL, 0x000000023b6d7836ULL, 0x000fe20000000000ULL,
0x000000003434783bULL, 0x000f220000000200ULL, 0x000000106e2c7824ULL, 0x000fe400078e0271ULL,
0x00000001136f7824ULL, 0x000fe200078e0239ULL, 0xfffffff8186d7812ULL, 0x000fe200078ee26dULL,
0x0000000839107824ULL, 0x002fe200078e00ffULL, 0x000000001220783bULL, 0x000fe20000000200ULL,
0x000000123b6a7836ULL, 0x000fc40000000000ULL, 0x000000106d587824ULL, 0x100fe200078e0271ULL,
0x000000002c2c783bULL, 0x000e620000000200ULL, 0xfffffff8106f7812ULL, 0x000fe200078ee26fULL,
0x000000223b687836ULL, 0x000fe20000000000ULL, 0xfffffff8116a7812ULL, 0x000fe200078ee26aULL,
0x0000000839197824ULL, 0x000fe200078e00ffULL, 0x000000005858783bULL, 0x000f620000000200ULL,
0x000000106f307824ULL, 0x100fe400078e0271ULL, 0x000000106a107824ULL, 0x000fe200078e0271ULL,
0xfffffff819687812ULL, 0x000fe200078ee268ULL, 0x000000323b697836ULL, 0x000fc40000000000ULL,
0x000000003030783bULL, 0x000f620000000200ULL, 0x0000007168187211ULL, 0x000fe200078e20ffULL,
0x000000043b6c7836ULL, 0x000fe40000000000ULL, 0x000000001010783bULL, 0x000f620000000200ULL,
0x000000243b657836ULL, 0x000fe40000000000ULL, 0x000000363b617836ULL, 0x000fe20000000000ULL,
0x000000001818783bULL, 0x000f620000000200ULL, 0x000000063b667836ULL, 0x000fe40000000000ULL,
0x000000163b637836ULL, 0x000fe20000000000ULL, 0x000000142824723cULL, 0x008fe200000418ffULL,
0x000000263b627836ULL, 0x000fca0000000000ULL, 0x000000162814723cULL, 0x000fec00000418ffULL,
0x000000342854723cULL, 0x010fec00000418ffULL, 0x000000362834723cULL, 0x000fec00000418ffULL,
0x0000002c281c723cULL, 0x002fec00000418ffULL, 0x000000582024723cULL, 0x020fe20000041824ULL,
0x00000008382c7824ULL, 0x000fca00078e00ffULL, 0xfffffff82c697812ULL, 0x000fe200078ee269ULL,
0x0000005a2058723cULL, 0x000fe80000041814ULL, 0x00000010692c7824ULL, 0x000fe400078e0271ULL,
0x000000302814723cULL, 0x000fec00000418ffULL, 0x000000322830723cULL, 0x000fec00000418ffULL,
0x0000002e2828723cULL, 0x000fe200000418ffULL, 0x000000002c2c783bULL, 0x000e6a0000000200ULL,
0x000000102054723cULL, 0x000fec0000041854ULL, 0x000000182014723cULL, 0x000fe20000041814ULL,
0x0000000460107836ULL, 0x000fe20000000000ULL, 0x000000044f117819ULL, 0x000fc800000006ffULL,
0xfffffff0113e7812ULL, 0x000fe200078ee210ULL, 0x000000104f197824ULL, 0x000fe200078e00ffULL,
0x000000122010723cULL, 0x000fe40000041834ULL, 0x000000073e3e7211ULL, 0x000fca00078e20ffULL,
0x0000000838377824ULL, 0x040fe200078e00ffULL, 0x0000000338387819ULL, 0x000fe200000006ffULL,
0x000000083c357824ULL, 0x000fe400078e00ffULL, 0x000000003e3c783bULL, 0x000fe20000000200ULL,
0xfffffff837647812ULL, 0x000fe200078ee264ULL, 0x000000083a347824ULL, 0x000fe200078e00ffULL,
0xfffffff8356c7812ULL, 0x000fe200078ee26cULL, 0x0000000839367824ULL, 0x000fe200078e00ffULL,
0xfffffff838617812ULL, 0x000fe200078ee261ULL, 0x0000001064407824ULL, 0x100fe200078e0271ULL,
0xfffffff834677812ULL, 0x000fe200078ee267ULL, 0x0000000660347836ULL, 0x000fe20000000000ULL,
0xfffffff836657812ULL, 0x000fe200078ee265ULL, 0x000000106c5c7824ULL, 0x100fe200078e0271ULL,
0x0000002c201c723cULL, 0x002fe2000004181cULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000001067507824ULL, 0x000fe200078e0271ULL, 0x0000007165447211ULL, 0x080fe200078e20ffULL,
0x000000083a3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff019347812ULL, 0x000fe200078ee234ULL,
0x000000005c5c783bULL, 0x000ee20000000200ULL, 0x0000001a2018723cULL, 0x000fe20000041830ULL,
0x00000071612c7211ULL, 0x000fe200078e20ffULL, 0x0000000839397824ULL, 0x000fe200078e00ffULL,
0x000000005050783bULL, 0x000f220000000200ULL, 0x00000007346b7211ULL, 0x000fc400078e20ffULL,
0x0000002e2020723cULL, 0x000fe20000041828ULL, 0x000000004444783bULL, 0x000f620000000200ULL,
0xfffffff835667812ULL, 0x000fe400078ee266ULL, 0xfffffff83a637812ULL, 0x000fe200078ee263ULL,
0x000000006b28783bULL, 0x0003e20000000200ULL, 0xfffffff839627812ULL, 0x000fe200078ee262ULL,
0x0000001066387824ULL, 0x100fe400078e0271ULL, 0x000000002c2c783bULL, 0x000f220000000200ULL,
0x0000001063347824ULL, 0x000fc400078e0271ULL, 0x0000001062307824ULL, 0x000fe200078e0271ULL,
0x000000003838783bULL, 0x000f620000000200ULL, 0x000000010a6b7824ULL, 0x002fc600078e024eULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x000000403c1c723cULL, 0x000fec000004181cULL, 0x000000423c20723cULL, 0x000fec0000041820ULL,
0x0000005c3c24723cULL, 0x008fec0000041824ULL, 0x0000005e3c58723cULL, 0x000fec0000041858ULL,
0x000000503c54723cULL, 0x010fec0000041854ULL, 0x000000523c10723cULL, 0x000fec0000041810ULL,
0x000000443c14723cULL, 0x020fec0000041814ULL, 0x000000463c18723cULL, 0x000fec0000041818ULL,
0x0000002c281c723cULL, 0x000fec000004181cULL, 0x0000002e282c723cULL, 0x000fec0000041820ULL,
0x000000382824723cULL, 0x000fe20000041824ULL, 0x000000016b207836ULL, 0x000fca0000000000ULL,
0x0000000f2000720cULL, 0x000fe20003f06070ULL, 0x0000003a2858723cULL, 0x000fec0000041858ULL,
0x000000342854723cULL, 0x002fec0000041854ULL, 0x000000362810723cULL, 0x000fe20000041810ULL,
0x0000000405217224ULL, 0x004fca00078e02ffULL, 0x000000302814723cULL, 0x000fe20000041814ULL,
0x0000010021767825ULL, 0x000fca00078e0076ULL, 0x000000322818723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000c00148947ULL, 0x000fde0003800000ULL,
0x0000000108237824ULL, 0x100fe200078e020bULL, 0x00000008082b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000c08297836ULL, 0x000fe20000000000ULL, 0x000000036b407211ULL, 0x000fe200078e40ffULL,
0x0000001008337836ULL, 0x000fe20000000000ULL, 0x0000000772727812ULL, 0x000fe200078ef823ULL,
0x000000012b3d7824ULL, 0x140fe200078e020bULL, 0x0000004049237248ULL, 0x000fe20007fe0000ULL,
0x0000001808517836ULL, 0x000fe20000000000ULL, 0x000000032b207819ULL, 0x000fe200000006ffULL,
0x0000000129437824ULL, 0x140fe200078e020bULL, 0x0000001408537810ULL, 0x000fe20007ffe0ffULL,
0x0000000829227824ULL, 0x000fe200078e00ffULL, 0xfffffff8203d7812ULL, 0x000fe200078ee23dULL,
0x0000000123407824ULL, 0x000fe200078e0a40ULL, 0x0000002408427810ULL, 0x000fe20007ffe0ffULL,
0x00000001333f7824ULL, 0x100fe200078e020bULL, 0x0000000351237819ULL, 0x000fe200000006ffULL,
0x0000000833207824ULL, 0x000fe200078e00ffULL, 0xfffffff822437812ULL, 0x000fe200078ee243ULL,
0x0000000151347824ULL, 0x100fe200078e020bULL, 0x0000000353227819ULL, 0x040fe200000006ffULL,
0x0000000408217836ULL, 0x000fe20000000000ULL, 0xfffffff8203f7812ULL, 0x000fe200078ee23fULL,
0x0000000153477824ULL, 0x100fe200078e020bULL, 0xfffffff823347812ULL, 0x000fe200078ee234ULL,
0x0000002008467836ULL, 0x000fe20000000000ULL, 0x0000000342207819ULL, 0x040fe200000006ffULL,
0x0000000121507824ULL, 0x140fe200078e020bULL, 0xfffffff822477812ULL, 0x000fe200078ee247ULL,
0x0000000821317824ULL, 0x040fe200078e00ffULL, 0x0000003008447810ULL, 0x000fe20007ffe0ffULL,
0x0000000142417824ULL, 0x100fe200078e020bULL, 0x000000402100720cULL, 0x080fe20003f66070ULL,
0x0000000146387824ULL, 0x140fe200078e020bULL, 0xfffffff831507812ULL, 0x000fe200078ee250ULL,
0x0000000846237824ULL, 0x000fe200078e00ffULL, 0xfffffff820417812ULL, 0x000fe200078ee241ULL,
0x00000028083a7836ULL, 0x000fe20000000000ULL, 0x000000402b00720cULL, 0x080fe20003f06070ULL,
0x0000001c083c7836ULL, 0x000fe20000000000ULL, 0xfffffff823387812ULL, 0x000fe200078ee238ULL,
0x0000000102227824ULL, 0x000fe200078e0208ULL, 0x000000033a207819ULL, 0x040fe200000006ffULL,
0x0000003408367836ULL, 0x000fe20000000000ULL, 0x000000402900720cULL, 0x080fe20003f46070ULL,
0x000000013a377824ULL, 0x100fe200078e020bULL, 0x000000400800720cULL, 0x000fe20003f86070ULL,
0x000000013c3e7824ULL, 0x040fe200078e020bULL, 0x0000000b36357210ULL, 0x000fe20007ffe0ffULL,
0x000000083c317824ULL, 0x000fe200078e00ffULL, 0xfffffff820377812ULL, 0x000fe200078ee237ULL,
0x0000010022227825ULL, 0x000fe200078e00ffULL, 0x000000713d3d7211ULL, 0x000fc400078e20ffULL,
0xfffffff8313e7812ULL, 0x000fe200078ee23eULL, 0x00000008362a7824ULL, 0x000fe200078e00ffULL,
0x0000007322317212ULL, 0x000fe200078efcffULL, 0x0000002c08457836ULL, 0x000fe20000000000ULL,
0x0000003c08527810ULL, 0x000fe20007ffe0ffULL, 0x0000000102207824ULL, 0x040fe200078e0221ULL,
0xfffffff82a357812ULL, 0x000fe200078ee235ULL, 0x00000001453b7824ULL, 0x040fe200078e020bULL,
0x00000029022a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000845287824ULL, 0x000fe200078e00ffULL,
0x0000003176227210ULL, 0x000fe20007f3e0ffULL, 0x0000000102307824ULL, 0x000fe200078e022bULL,
0x0000007147477211ULL, 0x000fe200078e20ffULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0xfffffff8283b7812ULL, 0x000fc400078ee23bULL, 0x0000007137377211ULL, 0x000fe200078e20ffULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x0000007320297212ULL, 0x000fc600078efcffULL,
0x0000000144397824ULL, 0x000fe200078e020bULL, 0x00000073305f7212ULL, 0x080fe200078efcffULL,
0x0000000844287824ULL, 0x000fe400078e00ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000005f76327210ULL, 0x000fe40007fbe0ffULL, 0xfffffff828397812ULL, 0x000fe200078ee239ULL,
0x0000000177237824ULL, 0x000fe200008e0623ULL, 0x000000732a5d7212ULL, 0x000fe200078efcffULL,
0x0000000102287824ULL, 0x000fe200078e0233ULL, 0x0000002976207210ULL, 0x000fe20007f3e0ffULL,
0x0000001043437824ULL, 0x000fe200078e0271ULL, 0x0000005d76307210ULL, 0x000fe20007fde0ffULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x00000071725d7211ULL, 0x000fc600078e20ffULL,
0x0000000177217824ULL, 0x000fe200008e0621ULL, 0x000000403300720cULL, 0x080fe20003f26070ULL,
0x0000000177337824ULL, 0x000fe200028e0631ULL, 0x000000405100720cULL, 0x080fe20003fa6070ULL,
0x0000000177317824ULL, 0x000fe200030e062bULL, 0x00000073282b7212ULL, 0x000fe200078efcffULL,
0x0000000102287824ULL, 0x040fe200078e0253ULL, 0x000000405300720cULL, 0x000fe20003fc6070ULL,
0x0000000102517824ULL, 0x000fe200078e0251ULL, 0x0000007150537211ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000225d7faeULL, 0x0003e2000e101c46ULL,
0x0000002b762a7210ULL, 0x000fe20007f9e0ffULL, 0x0000003808507836ULL, 0x000fc40000000000ULL,
0x0000000020537faeULL, 0x0005e2000d901c46ULL, 0x000000103f3f7824ULL, 0x000fe400078e0271ULL,
0x00000001772b7824ULL, 0x000fe200020e0629ULL, 0x00000000323d7faeULL, 0x000fe2000c101c46ULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x000000403a00720cULL, 0x080fe40003f06070ULL,
0x0000000030437faeULL, 0x0007e2000d101c46ULL, 0x0000000102227824ULL, 0x002fe200078e023cULL,
0x000000404600720cULL, 0x000fe20003f46070ULL, 0x00000001505c7824ULL, 0x000fe200078e020bULL,
0x000000002a3f7faeULL, 0x000fe2000c901c46ULL, 0x0000010051207825ULL, 0x004fe200078e00ffULL,
0x0000007328517212ULL, 0x000fc400078efcffULL, 0x000000404500720cULL, 0x000fe20003f26070ULL,
0x00000008505d7824ULL, 0x000fe200078e00ffULL, 0x0000007320237212ULL, 0x080fe200078efcffULL,
0x0000000102467824ULL, 0x040fe200078e0246ULL, 0x0000005176287210ULL, 0x000fe20007f7e0ffULL,
0x00000001023a7824ULL, 0x000fe200078e023aULL, 0x0000002376207210ULL, 0x000fe20007f9e0ffULL,
0x0000010022227825ULL, 0x000fe200078e00ffULL, 0x0000002977297210ULL, 0x000fe40001ffe4ffULL,
0xfffffff85d517812ULL, 0x000fe200078ee25cULL, 0x00000001525c7824ULL, 0x000fe200078e020bULL,
0x0000007322537212ULL, 0x000fe200078efcffULL, 0x00000008525d7824ULL, 0x000fe200078e00ffULL,
0x0000000028477faeULL, 0x0003e2000f101c46ULL, 0x0000000177217824ULL, 0x000fe200020e0621ULL,
0x0000005376227210ULL, 0x000fe20007f7e0ffULL, 0x0000000102457824ULL, 0x000fe200078e0245ULL,
0xfffffff85d537812ULL, 0x000fe200078ee25cULL, 0x000001003a307825ULL, 0x008fe200078e00ffULL,
0x00000071345d7211ULL, 0x000fc400078e20ffULL, 0x000000403c00720cULL, 0x080fe20003f86070ULL,
0x0000000177237824ULL, 0x000fe200018e0623ULL, 0x000000404200720cULL, 0x000fe20003f66070ULL,
0x0000000102427824ULL, 0x000fe200078e0242ULL, 0x00000000205d7faeULL, 0x0005e2000e901c46ULL,
0x0000010046287825ULL, 0x002fe200078e00ffULL, 0x00000036023c7210ULL, 0x000fe40007ffe0ffULL,
0x0000007151517211ULL, 0x000fe200078e20ffULL, 0x00000100422a7825ULL, 0x000fe200078e00ffULL,
0x0000007328337212ULL, 0x000fc600078efcffULL, 0x0000000102327824ULL, 0x000fe200078e0244ULL,
0x0000003376287210ULL, 0x000fe20007fde0ffULL, 0x000000103e3f7824ULL, 0x000fe200078e0271ULL,
0x000000732a3d7212ULL, 0x080fe200078efcffULL, 0x0000010045207825ULL, 0x004fe200078e00ffULL,
0x0000007330337212ULL, 0x080fe400078efcffULL, 0x0000003d762a7210ULL, 0x000fe20007fbe0ffULL,
0x0000000177297824ULL, 0x000fe200030e0629ULL, 0x00000073203d7212ULL, 0x000fe200078efcffULL,
0x00000000223f7faeULL, 0x0003e2000e101c46ULL, 0x0000003376307210ULL, 0x000fe20007fde0ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x0000002b772b7210ULL, 0x000fc40002ffe4ffULL,
0x0000003d76207210ULL, 0x000fe20007fbe0ffULL, 0x0000001038437824ULL, 0x000fe200078e0271ULL,
0x00000073323d7212ULL, 0x000fe200078efcffULL, 0x0000000102327824ULL, 0x000fe200078e0250ULL,
0x0000007141457211ULL, 0x000fe200078e20ffULL, 0x0000000177217824ULL, 0x040fe200028e0621ULL,
0x0000000028437faeULL, 0x0005e2000d101c46ULL, 0x0000003d76227210ULL, 0x002fe20007fbe0ffULL,
0x000001003c3c7825ULL, 0x000fe200078e00ffULL, 0x000000403600720cULL, 0x080fe20003f86070ULL,
0x000000002a457faeULL, 0x0003e2000d901c46ULL, 0x000000405000720cULL, 0x000fe20003f66070ULL,
0x0000000177237824ULL, 0x000fe200028e0633ULL, 0x000000733c417212ULL, 0x000fe200078efcffULL,
0x0000010032327825ULL, 0x000fc800078e00ffULL, 0x0000000102347824ULL, 0x000fe200078e0252ULL,
0x00000073323f7212ULL, 0x080fe200078efcffULL, 0x0000000177317824ULL, 0x000fe200030e0631ULL,
0x000000404400720cULL, 0x080fe20003fc6070ULL, 0x0000010034287825ULL, 0x004fe200078e00ffULL,
0x00000041762a7210ULL, 0x002fe40007fbe0ffULL, 0x0000003f76327210ULL, 0x000fe20007f5e0ffULL,
0x000000103b3b7824ULL, 0x000fe200078e0271ULL, 0x0000007328737212ULL, 0x000fe200078efcffULL,
0x00000001772b7824ULL, 0x040fe200028e063dULL, 0x000000405200720cULL, 0x000fe20003fa6070ULL,
0x0000000177337824ULL, 0x000fe200010e0633ULL, 0x0000007376287210ULL, 0x000fe20007f5e0ffULL,
0x0000001039397824ULL, 0x100fe200078e0271ULL, 0x0000000030377faeULL, 0x0003e2000c101c46ULL,
0x0000001035357824ULL, 0x000fc400078e0271ULL, 0x0000001053537824ULL, 0x000fe200078e0271ULL,
0x00000000203b7faeULL, 0x0003e2000c901c46ULL, 0x0000000177297824ULL, 0x000fc600010e0629ULL,
0x0000000022397faeULL, 0x0003e8000f101c46ULL, 0x000000002a357faeULL, 0x0003e8000e101c46ULL,
0x0000000032517faeULL, 0x0003e8000d901c46ULL, 0x0000000028537faeULL, 0x0003e2000e901c46ULL,
0x0000000800c47947ULL, 0x000fea0003800000ULL, 0x0000000808467836ULL, 0x000fe20000000000ULL,
0x0000001c085e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000408227836ULL, 0x000fe20000000000ULL,
0x0000000802207210ULL, 0x000fe20007ffe0ffULL, 0x00000001082b7824ULL, 0x100fe200078e020bULL,
0x0000004602237210ULL, 0x000fe20007ffe0ffULL, 0x0000000102287824ULL, 0x000fe200078e0222ULL,
0x0000001008757810ULL, 0x000fe20007ffe0ffULL, 0x0000000122797824ULL, 0x040fe200078e020bULL,
0x0000000772347812ULL, 0x000fe200078ef82bULL, 0x00000008222a7824ULL, 0x000fe200078e00ffULL,
0x00000024085c7810ULL, 0x000fe20007ffe0ffULL, 0x0000010023227825ULL, 0x000fe200078e00ffULL,
0x0000002c08527810ULL, 0x000fc40007ffe0ffULL, 0xfffffff82a797812ULL, 0x000fe200078ee279ULL,
0x0000000c08787836ULL, 0x000fe20000000000ULL, 0x0000007322437212ULL, 0x000fe200078efcffULL,
0x0000000102227824ULL, 0x000fe400078e025eULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x0000004376427210ULL, 0x000fc60007f5e0ffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x00000073202b7212ULL, 0x000fc600078efcffULL, 0x0000000177437824ULL, 0x000fe200010e0623ULL,
0x0000007328457212ULL, 0x080fe200078efcffULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x0000002b76207210ULL, 0x000fe40007f1e0ffULL, 0x0000004576447210ULL, 0x000fe20007f3e0ffULL,
0x0000000102327824ULL, 0x000fe200078e0278ULL, 0x0000007322397212ULL, 0x000fe200078efcffULL,
0x0000001408727836ULL, 0x000fe20000000000ULL, 0x0000002177217210ULL, 0x000fe200007fe4ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x0000003976387210ULL, 0x000fc60007f5e0ffULL,
0x0000000102307824ULL, 0x000fe200078e0275ULL, 0x0000007332417212ULL, 0x000fe200078efcffULL,
0x00000001022a7824ULL, 0x000fe400078e0272ULL, 0x00000018085f7836ULL, 0x000fe20000000000ULL,
0x0000004176407210ULL, 0x000fe20007f1e0ffULL, 0x0000010030307825ULL, 0x000fc600078e00ffULL,
0x0000003377417210ULL, 0x000fe200007fe4ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x00000073303f7212ULL, 0x000fc600078efcffULL, 0x0000000102287824ULL, 0x000fe200078e025fULL,
0x000000732a3d7212ULL, 0x000fe200078efcffULL, 0x00000020085d7836ULL, 0x000fe20000000000ULL,
0x0000003f763e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000177397824ULL, 0x040fe400010e0623ULL,
0x0000000177457824ULL, 0x000fe200008e0629ULL, 0x0000003d763c7210ULL, 0x000fe20007f3e0ffULL,
0x0000001034237824ULL, 0x000fe400078e0271ULL, 0x0000010028287825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e2000b901c46ULL,
0x0000000102227824ULL, 0x000fe200078e025dULL, 0x00000073283b7212ULL, 0x000fe200078efcffULL,
0x00000001022a7824ULL, 0x000fe400078e025cULL, 0x00000001773f7824ULL, 0x040fe200000e0631ULL,
0x0000003b763a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001773d7824ULL, 0x000fe400008e062bULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x00000029773b7210ULL, 0x000fc600007fe4ffULL,
0x0000010022207825ULL, 0x002fe200078e00ffULL, 0x000000732a357212ULL, 0x000fc600078efcffULL,
0x0000000102227824ULL, 0x000fe200078e0252ULL, 0x0000007320377212ULL, 0x000fe200078efcffULL,
0x0000002808537836ULL, 0x000fe40000000000ULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x0000003776367210ULL, 0x000fc60007f1e0ffULL, 0x0000000102287824ULL, 0x000fe200078e0253ULL,
0x0000002177377210ULL, 0x000fe200007fe4ffULL, 0x0000003008517836ULL, 0x000fe20000000000ULL,
0x0000003576347210ULL, 0x000fe20007f1e0ffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x0000007322317212ULL, 0x080fe400078efcffULL, 0x0000000b517c7210ULL, 0x000fe20007ffe0ffULL,
0x0000003408507836ULL, 0x000fe20000000000ULL, 0x0000007328337212ULL, 0x000fe200078efcffULL,
0x0000000177357824ULL, 0x000fe200000e062bULL, 0x0000003176307210ULL, 0x000fe20007f1e0ffULL,
0x0000000102207824ULL, 0x040fe200078e0251ULL, 0x0000003376327210ULL, 0x000fe20007f3e0ffULL,
0x0000000102227824ULL, 0x000fc400078e0250ULL, 0x0000000177317824ULL, 0x000fe400000e0623ULL,
0x0000010020207825ULL, 0x000fc800078e00ffULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x00000073202b7212ULL, 0x000fc600078efcffULL, 0x0000000177337824ULL, 0x000fe200008e0629ULL,
0x0000007322297212ULL, 0x080fe200078efcffULL, 0x0000003808477836ULL, 0x000fe20000000000ULL,
0x0000002b762a7210ULL, 0x000fe20007f3e0ffULL, 0x0000003c087a7836ULL, 0x000fe20000000000ULL,
0x0000002976287210ULL, 0x000fe20007f1e0ffULL, 0x0000001079797824ULL, 0x000fe200078e0271ULL,
0x0000004702207210ULL, 0x000fe20007ffe0ffULL, 0x000000087a7d7824ULL, 0x000fe200078e00ffULL,
0x0000007a02227210ULL, 0x000fe20007ffe0ffULL, 0x0000000177297824ULL, 0x000fe200000e0623ULL,
0x00000021772b7210ULL, 0x000fe20000ffe4ffULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x0000000044797faeULL, 0x0003e6000b901c46ULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x00000073207b7212ULL, 0x000fc600078efcffULL, 0x0000000851517824ULL, 0x000fe200078e00ffULL,
0x0000007322737212ULL, 0x000fe400078efcffULL, 0x0000007b76207210ULL, 0x000fe40007f3e0ffULL,
0x0000007376227210ULL, 0x000fe20007f1e0ffULL, 0x0000000146737824ULL, 0x140fe200078e020bULL,
0x0000000346467819ULL, 0x000fe200000006ffULL, 0x0000000172447824ULL, 0x042fe200078e020bULL,
0x0000000b75767210ULL, 0x000fe20007ffe0ffULL, 0x0000000875757824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee273ULL, 0x0000000872457824ULL, 0x000fe200078e00ffULL,
0xfffffff8517c7812ULL, 0x000fe200078ee27cULL, 0x0000000177217824ULL, 0x000fe200008e0621ULL,
0xfffffff875727812ULL, 0x000fe200078ee276ULL, 0x0000001046737824ULL, 0x000fe200078e0271ULL,
0xfffffff845447812ULL, 0x000fe200078ee244ULL, 0x000000085f767824ULL, 0x000fe200078e00ffULL,
0x0000000b5f457210ULL, 0x000fe20007ffe0ffULL, 0x0000000177237824ULL, 0x000fe200000e0623ULL,
0x0000000042737faeULL, 0x0003e2000b901c46ULL, 0x0000000178467824ULL, 0x000fc400078e020bULL,
0x0000000878777824ULL, 0x000fe200078e00ffULL, 0x0000000b53787210ULL, 0x000fe20007ffe0ffULL,
0x0000000853537824ULL, 0x000fc600078e00ffULL, 0xfffffff877467812ULL, 0x000fe200078ee246ULL,
0x000000107c777824ULL, 0x000fe200078e0271ULL, 0xfffffff853787812ULL, 0x000fe200078ee278ULL,
0x000000015e427824ULL, 0x142fe400078e020bULL, 0x000000085e437824ULL, 0x000fe200078e00ffULL,
0xfffffff8765e7812ULL, 0x000fe200078ee245ULL, 0x000000017a457824ULL, 0x100fe200078e020bULL,
0x0000000b5d767210ULL, 0x000fe20007ffe0ffULL, 0x000000085d5d7824ULL, 0x000fe200078e00ffULL,
0xfffffff843427812ULL, 0x000fe200078ee242ULL, 0x000000015c437824ULL, 0x040fe200078e020bULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee245ULL, 0x000000085c5c7824ULL, 0x000fe200078e00ffULL,
0xfffffff85d767812ULL, 0x000fe200078ee276ULL, 0x0000001072457824ULL, 0x100fe200078e0271ULL,
0x0000007142537211ULL, 0x080fe200078e20ffULL, 0x000000105e517824ULL, 0x000fe200078e0271ULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee243ULL, 0x0000000152437824ULL, 0x040fe200078e020bULL,
0x000000717d7d7211ULL, 0x000fe200078e20ffULL, 0x0000000852527824ULL, 0x000fc400078e00ffULL,
0x00000010765d7824ULL, 0x100fe400078e0271ULL, 0x000000105c5f7824ULL, 0x000fe200078e0271ULL,
0xfffffff852527812ULL, 0x000fe200078ee243ULL, 0x0000000150437824ULL, 0x040fe400078e020bULL,
0x0000000850507824ULL, 0x000fe200078e00ffULL, 0x0000007152757211ULL, 0x000fe200078e20ffULL,
0x0000001078737824ULL, 0x000fc600078e0271ULL, 0xfffffff850507812ULL, 0x000fe400078ee243ULL,
0x0000000b47437210ULL, 0x000fe20007ffe0ffULL, 0x0000000847477824ULL, 0x000fe400078e00ffULL,
0x0000001050797824ULL, 0x000fc600078e0271ULL, 0xfffffff8477a7812ULL, 0x000fe200078ee243ULL,
0x0000001044477824ULL, 0x000fe200078e0271ULL, 0x0000007146437211ULL, 0x000fc600078e20ffULL,
0x000000107a7b7824ULL, 0x000fe400078e0271ULL, 0x0000000040437faeULL, 0x0003e8000b901c46ULL,
0x000000003e457faeULL, 0x0003e8000b901c46ULL, 0x000000003c477faeULL, 0x0003e8000b901c46ULL,
0x000000003a517faeULL, 0x0003e8000b901c46ULL, 0x0000000038537faeULL, 0x0003e8000b901c46ULL,
0x00000000365d7faeULL, 0x0003e8000b901c46ULL, 0x00000000345f7faeULL, 0x0003e8000b901c46ULL,
0x0000000032737faeULL, 0x0003e8000b901c46ULL, 0x0000000030757faeULL, 0x0003e8000b901c46ULL,
0x000000002a777faeULL, 0x0003e8000b901c46ULL, 0x0000000028797faeULL, 0x0003e8000b901c46ULL,
0x00000000207b7faeULL, 0x0003e8000b901c46ULL, 0x00000000227d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000860207836ULL, 0x002fe20000000000ULL,
0x0000000a60287810ULL, 0x000fe20007ffe0ffULL, 0x000000104f217824ULL, 0x040fe200078e00ffULL,
0x0000004d66507211ULL, 0x000fe200078e20ffULL, 0x00000010743c7824ULL, 0x100fe400078e024dULL,
0x0000001070407824ULL, 0x100fe200078e024dULL, 0xfffffff021207812ULL, 0x000fe200078ee220ULL,
0x000000106e307824ULL, 0x100fe400078e024dULL, 0x000000104f297824ULL, 0x000fe200078e00ffULL,
0x0000000720387211ULL, 0x000fe200078e20ffULL, 0x000000106f207824ULL, 0x000fc400078e024dULL,
0x000000106d347824ULL, 0x100fe200078e024dULL, 0xfffffff029287812ULL, 0x000fe200078ee228ULL,
0x0000001068687824ULL, 0x100fe400078e024dULL, 0x000000106c6c7824ULL, 0x000fe400078e024dULL,
0x0000001028287824ULL, 0x000fe400078e0207ULL, 0x00000010645c7824ULL, 0x000fe200078e024dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003c3c783bULL, 0x000fe80000000200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000004040783bULL, 0x000ea80000000200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000002020783bULL, 0x000f280000000200ULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000f680000000200ULL,
0x000000005c5c783bULL, 0x000fe80000000200ULL, 0x000000005050783bULL, 0x000fe20000000200ULL,
0x0000003c3824723cULL, 0x002fec0000041824ULL, 0x0000003e3858723cULL, 0x000fe20000041858ULL,
0x0000004d6a3c7211ULL, 0x000fca00078e20ffULL, 0x000000403854723cULL, 0x004fe20000041854ULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x00000030381c723cULL, 0x008fe2000004181cULL,
0x000000104f407824ULL, 0x040fe400078e00ffULL, 0x000000104f4f7824ULL, 0x000fc600078e00ffULL,
0x000000203814723cULL, 0x010fe20000041814ULL, 0x0000000c60317836ULL, 0x000fe20000000000ULL,
0x0000004d69307211ULL, 0x000fe400078e20ffULL, 0x0000000e60607810ULL, 0x000fe40007ffe0ffULL,
0xfffffff040407812ULL, 0x000fe200078ee231ULL, 0x000000223820723cULL, 0x000fe20000041818ULL,
0xfffffff04f607812ULL, 0x000fe200078ee260ULL, 0x000000006818783bULL, 0x000ea40000000200ULL,
0x0000001040407824ULL, 0x000fc400078e0207ULL, 0x000000423810723cULL, 0x000fe20000041810ULL,
0x0000001060447824ULL, 0x000fc600078e0207ULL, 0x000000004040783bULL, 0x000fe40000000200ULL,
0x00000032382c723cULL, 0x000fe4000004182cULL, 0x000000003030783bULL, 0x000ee80000000200ULL,
0x000000342838723cULL, 0x020fe20000041824ULL, 0x000000004444783bULL, 0x000fe80000000200ULL,
0x000000006c24783bULL, 0x000f220000000200ULL, 0x0000003c2854723cULL, 0x002fe20000041854ULL,
0x0000001067347824ULL, 0x000fca00078e024dULL, 0x000000362858723cULL, 0x000fe20000041858ULL,
0x00000010653c7824ULL, 0x100fe200078e024dULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x0000003e2810723cULL, 0x000fe20000041810ULL, 0x000000003c3c783bULL, 0x000f6a0000000200ULL,
0x000000182814723cULL, 0x004fec0000041814ULL, 0x0000001a2820723cULL, 0x000fe20000041820ULL,
0x0000001063187824ULL, 0x000fca00078e024dULL, 0x00000030281c723cULL, 0x008fe2000004181cULL,
0x000000001818783bULL, 0x000eaa0000000200ULL, 0x00000032282c723cULL, 0x000fec000004182cULL,
0x000000244038723cULL, 0x010fe20000041838ULL, 0x0000001062287824ULL, 0x000fca00078e024dULL,
0x000000264058723cULL, 0x000fe20000041858ULL, 0x0000004d61247211ULL, 0x000fe200078e20ffULL,
0x000000002828783bULL, 0x000ee80000000200ULL, 0x000000344054723cULL, 0x002fe20000041854ULL,
0x000000002424783bULL, 0x000e6a0000000200ULL, 0x0000003e4020723cULL, 0x020fec0000041820ULL,
0x000000364010723cULL, 0x000fec0000041810ULL, 0x0000003c4014723cULL, 0x000fec0000041814ULL,
0x0000005c401c723cULL, 0x000fec000004181cULL, 0x0000005e402c723cULL, 0x000fec000004182cULL,
0x000000184454723cULL, 0x004fec0000041854ULL, 0x0000002a4420723cULL, 0x008fe20000041820ULL,
0x00000001ff187424ULL, 0x000fca00078e00ffULL, 0x000000504438723cULL, 0x000fe20000041838ULL,
0x01b688184b1879a7ULL, 0x000eaa000850003fULL, 0x000000524458723cULL, 0x000fec0000041858ULL,
0x0000001a4410723cULL, 0x000fe20000041810ULL, 0x3db504f354547820ULL, 0x000fe20000410000ULL,
0x3db504f355557820ULL, 0x000fe20000410000ULL, 0x3db504f356567820ULL, 0x000fe20000410000ULL,
0x3db504f357577820ULL, 0x000fc40000410000ULL, 0x000000284414723cULL, 0x000fe20000041814ULL,
0x3db504f320307820ULL, 0x000fe20000410000ULL, 0x3db504f321317820ULL, 0x000fe20000410000ULL,
0x3db504f322227820ULL, 0x000fe20000410000ULL, 0x3db504f323237820ULL, 0x000fe40000410000ULL,
0x00000024441c723cULL, 0x002fe2000004181cULL, 0x3db504f3381b7820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fc40000410000ULL, 0x00000026442c723cULL, 0x000fe2000004182cULL,
0x3db504f358587820ULL, 0x000fe20000410000ULL, 0x3db504f359597820ULL, 0x000fe20000410000ULL,
0x3db504f35a5a7820ULL, 0x000fe20000410000ULL, 0x3db504f35b5b7820ULL, 0x000fe40000410000ULL,
0x3db504f3101a7820ULL, 0x000fe20000410000ULL, 0x3db504f311257820ULL, 0x000fe20000410000ULL,
0x3db504f312247820ULL, 0x000fe20000410000ULL, 0x3db504f313277820ULL, 0x000fc60000410000ULL,
0x3db504f314297820ULL, 0x000fe20000410000ULL, 0x3db504f3152a7820ULL, 0x000fe20000410000ULL,
0x3db504f316287820ULL, 0x000fe20000410000ULL, 0x3db504f317267820ULL, 0x000fc60000410000ULL,
0x3db504f31c327820ULL, 0x000fe20000410000ULL, 0x3db504f31d337820ULL, 0x000fe20000410000ULL,
0x3db504f31e207820ULL, 0x000fe20000410000ULL, 0x3db504f31f217820ULL, 0x000fc60000410000ULL,
0x3db504f32c2c7820ULL, 0x000fe20000410000ULL, 0x3db504f32d2d7820ULL, 0x000fe20000410000ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fe20000410000ULL,
0x0000000000107805ULL, 0x000fe20000015200ULL, 0x01b688194b0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff147224ULL, 0x000fce00078e00ffULL,
0x000000101400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fc800078110ffULL, 0x00000013ff137210ULL, 0x000fc800007fe4ffULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000114147836ULL, 0x000fce0000000000ULL,
0x01b688194b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000040b107824ULL, 0x000fe200078e00ffULL, 0x0000000d4e00720cULL, 0x000fe20003f06070ULL,
0x000000804a2b7824ULL, 0x000fc600078e0207ULL, 0xfffffff010107812ULL, 0x000fc800078ec0ffULL,
0x000000102b2b7210ULL, 0x000fca0007ffe0ffULL, 0x01b400002b107984ULL, 0x0002a20000000c00ULL,
0x0000001000c08947ULL, 0x000fea0003800000ULL, 0x000000020b357824ULL, 0x040fe200078e00ffULL,
0x0000000c49157248ULL, 0x000fe20007fe0000ULL, 0x0000860000097ab9ULL, 0x000fe20000000800ULL,
0x000000000b167211ULL, 0x000fe200078ff0ffULL, 0x00008400000a7ab9ULL, 0x000fe20000000800ULL,
0x0000000635357812ULL, 0x000fe200078ec0ffULL, 0x00000001150c7824ULL, 0x000fe200078e0a0cULL,
0x00000009ff177c19ULL, 0x000fe20008011616ULL, 0x00008c00ff147b82ULL, 0x000ee20000000a00ULL,
0x0000000816167836ULL, 0x000fe40000000000ULL, 0x0000000835197c36ULL, 0x000fe20008000000ULL,
0x000000ff0c467210ULL, 0x000fe20007ffe1ffULL, 0x0000000a35377c36ULL, 0x000fe20008000000ULL,
0x0000000517177c48ULL, 0x000fc4000bfe0000ULL, 0x0000000c1900720cULL, 0x080fe40003f26070ULL,
0x0000000519197e46ULL, 0x000fe2000b800046ULL, 0x00000004175f7c24ULL, 0x000fe2000f8e02ffULL,
0x0000000c3700720cULL, 0x000fe40003f06070ULL, 0x0000000537427e46ULL, 0x000fe4000b800046ULL,
0x00000004ff197819ULL, 0x000fe40000011619ULL, 0x000000ff42427207ULL, 0x000fc40000000000ULL,
0x000000ff191c7207ULL, 0x000fe40000800000ULL, 0x00000009ff167c19ULL, 0x000fe40008011616ULL,
0x0000005f421f7211ULL, 0x000fe200078fe0ffULL, 0x000000015f197824ULL, 0x000fe200078e021cULL,
0x0000000516167c48ULL, 0x000fe4000bfe0000ULL, 0x00000010353d7812ULL, 0x000fe200078efcffULL,
0x000000021f1e7825ULL, 0x008fc800078e0014ULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x000000061e4e7981ULL, 0x000726000c1e9500ULL, 0x0000000416617c24ULL, 0x000fe2000f8e02ffULL,
0x00000006185d7981ULL, 0x000b22000c1e9500ULL, 0x0000000a3d3f7c36ULL, 0x000fc60008000000ULL,
0x000000611c177210ULL, 0x000fe20007ffe0ffULL, 0x000000083d1f7c36ULL, 0x008fe20008000000ULL,
0x0000000c3f00720cULL, 0x080fe40003f06070ULL, 0x000000053f347e46ULL, 0x000fe2000b800046ULL,
0x0000000217167825ULL, 0x100fe200078e0014ULL, 0x0000002035437812ULL, 0x000fe400078efcffULL,
0x00000061421d7211ULL, 0x000fe400078fe0ffULL, 0x000000ff34347207ULL, 0x000fe20000000000ULL,
0x0000000a43457c36ULL, 0x000fe20008000000ULL, 0x000000051f187e46ULL, 0x022fe2000b800046ULL,
0x000000021d1c7825ULL, 0x000fe200078e0014ULL, 0x0000000616537981ULL, 0x0002e2000c1e9500ULL,
0x0000000c1f00720cULL, 0x000fc40003f26070ULL, 0x00000004ff187819ULL, 0x000fe20000011618ULL,
0x000000061c447981ULL, 0x000ae2000c1e9500ULL, 0x0000000c4500720cULL, 0x000fe20003f06070ULL,
0x00000008434d7c36ULL, 0x000fe20008000000ULL, 0x00000005453c7e46ULL, 0x000fe4000b800046ULL,
0x0000005f34177211ULL, 0x002fe400078fe0ffULL, 0x000000ff3c3c7207ULL, 0x000fe40000000000ULL,
0x000000ff181c7207ULL, 0x024fe20000800000ULL, 0x0000000217167825ULL, 0x000fe200078e0014ULL,
0x00000061341d7211ULL, 0x000fc400078fe0ffULL, 0x000000611c1f7210ULL, 0x000fe20007ffe0ffULL,
0x000000015f197824ULL, 0x000fe200078e021cULL, 0x000000054d3e7e46ULL, 0x000fe2000b800046ULL,
0x0000000616367981ULL, 0x0002a2000c1e9500ULL, 0x0000000c4d00720cULL, 0x000fe40003f26070ULL,
0x00000030354d7812ULL, 0x000fe200078efcffULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x00000004ff3e7819ULL, 0x000fe4000001163eULL, 0x0000005f3c177211ULL, 0x002fe200078fe0ffULL,
0x000000021d1c7825ULL, 0x100fe200078e0014ULL, 0x000000ff3e407207ULL, 0x000fe20000800000ULL,
0x0000000618417981ULL, 0x000ea4000c1e9500ULL, 0x000000021f1e7825ULL, 0x000fc400078e0014ULL,
0x000000061c387981ULL, 0x000364000c1e9500ULL, 0x0000000217167825ULL, 0x000fe400078e0014ULL,
0x000000061e477981ULL, 0x000364000c1e9500ULL, 0x000000084d637c36ULL, 0x000fe40008000000ULL,
0x00000006163e7981ULL, 0x000362000c1e9500ULL, 0x0000000a4d4f7c36ULL, 0x000fe20008000000ULL,
0x000000613c1d7211ULL, 0x002fe200078fe0ffULL, 0x000000015f197824ULL, 0x000fe200078e0240ULL,
0x00000061401f7210ULL, 0x000fc40007ffe0ffULL, 0x0000000563167e46ULL, 0x000fc6000b800046ULL,
0x000000021f1e7825ULL, 0x100fe200078e0014ULL, 0x0000000c4f00720cULL, 0x080fe40003f06070ULL,
0x000000054f467e46ULL, 0x000fe2000b800046ULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x0000000c6300720cULL, 0x000fe20003f26070ULL, 0x000000061e1f7981ULL, 0x000f62000c1e9500ULL,
0x00000004ff167819ULL, 0x000fe20000011616ULL, 0x000000021d1c7825ULL, 0x000fe200078e0014ULL,
0x000000ff46467207ULL, 0x000fe20000000000ULL, 0x0000000618517981ULL, 0x000362000c1e9500ULL,
0x000000ff16507207ULL, 0x000fc60000800000ULL, 0x000000061c407981ULL, 0x000362000c1e9500ULL,
0x0000005f46177211ULL, 0x000fe200078fe0ffULL, 0x000000015f197824ULL, 0x002fc800078e0250ULL,
0x0000000217167825ULL, 0x000fc800078e0014ULL, 0x0000000219187825ULL, 0x000fe200078e0014ULL,
0x00000061461d7211ULL, 0x000fe200078fe0ffULL, 0x0000000616167981ULL, 0x000362000c1e9500ULL,
0x00000061505f7210ULL, 0x000fc60007ffe0ffULL, 0x0000000618197981ULL, 0x000f62000c1e9500ULL,
0x000000021d1c7825ULL, 0x000fc800078e0014ULL, 0x000000025f147825ULL, 0x000fe400078e0014ULL,
0x000000061c1c7981ULL, 0x000368000c1e9500ULL, 0x0000000614157981ULL, 0x000362000c1e9500ULL,
0xfffffff0425f7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff1e7424ULL, 0x000fc800078e00ffULL,
0x000000010c427824ULL, 0x000fe200078e025fULL, 0x0000000135177812ULL, 0x042fe400078efcffULL,
0x0000000935617812ULL, 0x000fe400078efcffULL, 0x8000004237657210ULL, 0x000fe20007ffe0ffULL,
0x0000000a17637c36ULL, 0x000fc60008000000ULL, 0x000000651e657219ULL, 0x040fe200000006ffULL,
0x0000000a611d7c36ULL, 0x000fe40008000000ULL, 0x0000000163677824ULL, 0x100fe400078e0a42ULL,
0x000000011d6d7824ULL, 0x000fe200078e0a42ULL, 0x00000018357d7812ULL, 0x000fe400078efcffULL,
0x000000671e677219ULL, 0x040fe400000006ffULL, 0x0000006d1e6d7219ULL, 0x000fc400000006ffULL,
0xfffffff034347812ULL, 0x000fe400078ec0ffULL, 0xfffffff046467812ULL, 0x000fca00078ec0ffULL,
0x000000010c5e7824ULL, 0x000fe200078e0246ULL, 0x00000019357b7812ULL, 0x040fe400078efcffULL,
0x0000001135147812ULL, 0x040fe400078efcffULL, 0x00000028356f7812ULL, 0x040fe400078efcffULL,
0x0000002135717812ULL, 0x000fe400078efcffULL, 0x0000000a7b187c10ULL, 0x000fe2000fffe0ffULL,
0x0000000a6f757c36ULL, 0x000fc40008000000ULL, 0x0000000a71777c36ULL, 0x000fe40008000000ULL,
0x000000014f687824ULL, 0x000fca00078e0a5eULL, 0x000000681e687219ULL, 0x000fe400000006ffULL,
0x000054104e4e7816ULL, 0x010fe4000000005dULL, 0x00000008355d7812ULL, 0x000fe400078efcffULL,
0x0000004e65ff7212ULL, 0x000fc6000780c0ffULL, 0x0000000a5d5f7c36ULL, 0x000fe20008000000ULL,
0x0000000c3700720cULL, 0x000fc80000701470ULL, 0x0000005f42697210ULL, 0x000fe40007ffe1ffULL,
0x0000000c3500720cULL, 0x000fe40000701070ULL, 0x000000691e697219ULL, 0x000fe400000006ffULL,
0x0000004e67ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004e69ff7212ULL, 0x000fe4000784c0ffULL,
0x0000541044447816ULL, 0x008fc40000000053ULL, 0x0000004e6dff7212ULL, 0x000fe2000782c0ffULL,
0x0000000a7d427c36ULL, 0x000fe20008000000ULL, 0xff8000001b1b7808ULL, 0x000fe40000000000ULL,
0xfffffff03c4e7812ULL, 0x000fe200078ec0ffULL, 0x000000010c3c7824ULL, 0x000fe200078e0234ULL,
0x0000004465ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004469ff7212ULL, 0x080fe400078cc0ffULL,
0x000000446dff7212ULL, 0x000fe2000780c0ffULL, 0x000000013f467824ULL, 0x000fe200078e0a3cULL,
0x0000000c3700720cULL, 0x000fc40002781470ULL, 0x0000000c5f00720cULL, 0x080fe400037c1470ULL,
0x0000000c1d00720cULL, 0x080fe40000701470ULL, 0x000000423c527210ULL, 0x000fe40007ffe1ffULL,
0x0000000c3500720cULL, 0x080fe40002781070ULL, 0x0000000c5d00720cULL, 0x080fe400037c1070ULL,
0x0000000c6100720cULL, 0x000fc40000701070ULL, 0x000000461e467219ULL, 0x040fe400000006ffULL,
0x000000521e527219ULL, 0x000fe400000006ffULL, 0x0000541036417816ULL, 0x004fe40000000041ULL,
0x0000004467ff7212ULL, 0x000fe400078ac0ffULL, 0x00000029356d7812ULL, 0x000fe400078efcffULL,
0x0000541038477816ULL, 0x020fc40000000047ULL, 0x0000003835657812ULL, 0x040fe400078efcffULL,
0x0000003135677812ULL, 0x040fe400078efcffULL, 0x0000003935537812ULL, 0x000fe200078efcffULL,
0x0000000a14447c36ULL, 0x000fe20008000000ULL, 0x0000004e0c4e7210ULL, 0x000fe40007ffe0ffULL,
0x0000000c1d00720cULL, 0x000fe40000f21470ULL, 0xff8000003a3a7808ULL, 0x000fc40002000000ULL,
0xff8000005a5a7808ULL, 0x000fe40003000000ULL, 0xff8000005b5b7808ULL, 0x000fe40000000000ULL,
0x0000004146ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004746ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004752ff7212ULL, 0x000fe2000780c0ffULL, 0x0000000a6d737c36ULL, 0x000fe20008000000ULL,
0x0000000a67697c10ULL, 0x000fe2000fffe0ffULL, 0x0000000a65797c36ULL, 0x000fe20008000000ULL,
0x0000000c6100720cULL, 0x080fe20000f21070ULL, 0x0000000a53347c36ULL, 0x000fe20008000000ULL,
0x0000000c6300720cULL, 0x0c0fe20001f61470ULL, 0x00000001185c7824ULL, 0x100fe200078e0a3cULL,
0x0000000c6300720cULL, 0x080fe20002fa1470ULL, 0x0000000144507824ULL, 0x000fe200078e0a3cULL,
0x0000000c5f00720cULL, 0x080fe20001741470ULL, 0x0000000145607824ULL, 0x000fe200078e0a4eULL,
0x0000000c3f00720cULL, 0x000fc40002781470ULL, 0x0000000c3f00720cULL, 0x080fe400037c1470ULL,
0x0000000c4200720cULL, 0x000fe20000701470ULL, 0x0000000177627824ULL, 0x100fe200078e0a4eULL,
0x000000754e647210ULL, 0x000fe20007ffe1ffULL, 0x0000000173667824ULL, 0x000fe200078e0a4eULL,
0x000000795e3c7210ULL, 0x000fe20007ffe1ffULL, 0x00000001696a7824ULL, 0x100fe200078e0a5eULL,
0xff80000059597808ULL, 0x000fe20000800000ULL, 0x00000001344e7824ULL, 0x000fe200078e0a5eULL,
0x0000005c1e5e7219ULL, 0x000fc400000006ffULL, 0x0000000c1700720cULL, 0x0c0fe40001f61070ULL,
0x0000000c1700720cULL, 0x080fe40002fa1070ULL, 0x0000000c5d00720cULL, 0x080fe40001741070ULL,
0x0000000c3d00720cULL, 0x0c0fe40002721070ULL, 0x0000000c3d00720cULL, 0x080fe400037c1070ULL,
0x0000000c7d00720cULL, 0x000fc40000701070ULL, 0x000000501e507219ULL, 0x040fe400000006ffULL,
0x000000601e5c7219ULL, 0x000fe400000006ffULL, 0x000054103e517816ULL, 0x000fe40000000051ULL,
0x00005410401f7816ULL, 0x000fe4000000001fULL, 0xff80000039397808ULL, 0x000fe40001800000ULL,
0xff8000003b3b7808ULL, 0x000fc40002800000ULL, 0xff80000058587808ULL, 0x000fe40001000000ULL,
0xff80000054547808ULL, 0x000fe40000800000ULL, 0xff80000056567808ULL, 0x000fe40003000000ULL,
0xff80000024247808ULL, 0x000fe40000000000ULL, 0x0000004150ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004152ff7212ULL, 0x000fc400078ac0ffULL, 0x000000415eff7212ULL, 0x000fe4000784c0ffULL,
0x0000004750ff7212ULL, 0x080fe4000788c0ffULL, 0x000000475eff7212ULL, 0x000fe4000782c0ffULL,
0x000000515cff7212ULL, 0x040fe400078cc0ffULL, 0x0000001f5cff7212ULL, 0x000fe4000780c0ffULL,
0x0000000c4400720cULL, 0x000fc40001f61470ULL, 0x0000000c4400720cULL, 0x080fe40002781470ULL,
0x0000000c4200720cULL, 0x080fe40002fa1470ULL, 0x0000000c1800720cULL, 0x0c0fe40001741470ULL,
0x0000000c1800720cULL, 0x080fe40000f21470ULL, 0x0000000c4500720cULL, 0x0c0fe400037c1470ULL,
0x0000000c4500720cULL, 0x000fc40000701470ULL, 0x0000000c1400720cULL, 0x0c0fe40001f61070ULL,
0x0000000c1400720cULL, 0x080fe40002781070ULL, 0x0000000c7d00720cULL, 0x080fe40002fa1070ULL,
0x0000000c7b00720cULL, 0x0c0fe40001741070ULL, 0x0000000c7b00720cULL, 0x080fe40000f21070ULL,
0x0000000c4300720cULL, 0x000fc400037c1070ULL, 0x0000000c4300720cULL, 0x000fe40000701070ULL,
0x000000621e627219ULL, 0x040fe400000006ffULL, 0x000000641e647219ULL, 0x040fe400000006ffULL,
0x000000661e667219ULL, 0x000fe400000006ffULL, 0x0000541016167816ULL, 0x000fe40000000019ULL,
0xff80000055557808ULL, 0x000fc40001800000ULL, 0xff80000057577808ULL, 0x000fe40002000000ULL,
0xff8000001a1a7808ULL, 0x000fe40002800000ULL, 0xff80000025257808ULL, 0x000fe40001000000ULL,
0xff80000027277808ULL, 0x000fe40000800000ULL, 0xff80000029297808ULL, 0x000fe40003000000ULL,
0xff80000028287808ULL, 0x000fc40000000000ULL, 0x0000005162ff7212ULL, 0x080fe4000786c0ffULL,
0x0000005164ff7212ULL, 0x080fe4000788c0ffULL, 0x0000005166ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001f62ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001f64ff7212ULL, 0x080fe4000782c0ffULL,
0x0000001f66ff7212ULL, 0x000fc400078cc0ffULL, 0x0000001668ff7212ULL, 0x000fe4000780c0ffULL,
0x0000000c7700720cULL, 0x0c0fe40001f61470ULL, 0x0000000c7700720cULL, 0x080fe40001741470ULL,
0x0000000c7500720cULL, 0x0c0fe40002781470ULL, 0x0000000c7500720cULL, 0x080fe40000f21470ULL,
0x0000000c7300720cULL, 0x000fc40002fa1470ULL, 0x0000000c7300720cULL, 0x080fe400037c1470ULL,
0x0000000c4f00720cULL, 0x080fe40000701470ULL, 0x0000000c7100720cULL, 0x0c0fe40001f61070ULL,
0x0000000c7100720cULL, 0x080fe40001741070ULL, 0x0000000c6f00720cULL, 0x0c0fe40002781070ULL,
0x0000000c6f00720cULL, 0x000fc40000f21070ULL, 0x0000000c6d00720cULL, 0x0c0fe40002fa1070ULL,
0x0000000c6d00720cULL, 0x080fe400037c1070ULL, 0x0000000c4d00720cULL, 0x000fe40000701070ULL,
0x0000006a1e6a7219ULL, 0x040fe400000006ffULL, 0x0000003c1e3c7219ULL, 0x040fe400000006ffULL,
0x0000004e1e4e7219ULL, 0x000fc400000006ffULL, 0x000054101c157816ULL, 0x000fe40000000015ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff80000026267808ULL, 0x000fe40001000000ULL,
0xff80000030307808ULL, 0x000fe40002000000ULL, 0xff80000022227808ULL, 0x000fe40000800000ULL,
0xff80000031317808ULL, 0x000fc40002800000ULL, 0xff80000023237808ULL, 0x000fe40003000000ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0x000000166aff7212ULL, 0x080fe4000786c0ffULL,
0x000000163cff7212ULL, 0x080fe4000784c0ffULL, 0x000000164eff7212ULL, 0x000fe4000788c0ffULL,
0x0000001568ff7212ULL, 0x000fc4000782c0ffULL, 0x000000156aff7212ULL, 0x080fe400078ac0ffULL,
0x000000153cff7212ULL, 0x080fe400078cc0ffULL, 0x000000154eff7212ULL, 0x000fe4000780c0ffULL,
0x0000000c4f00720cULL, 0x080fe40000f21470ULL, 0x0000000c6900720cULL, 0x0c0fe40001f61470ULL,
0x0000000c6900720cULL, 0x000fc40002fa1470ULL, 0x0000000c7900720cULL, 0x0c0fe40001741470ULL,
0x0000000c7900720cULL, 0x080fe400037c1470ULL, 0x0000000c3400720cULL, 0x0c0fe40002781470ULL,
0x0000000c3400720cULL, 0x080fe40000701470ULL, 0x0000000c4d00720cULL, 0x080fe40000f21070ULL,
0x0000000c6700720cULL, 0x000fc40001f61070ULL, 0x0000000c6700720cULL, 0x080fe40002fa1070ULL,
0x0000000c6500720cULL, 0x0c0fe40001741070ULL, 0x0000000c6500720cULL, 0x080fe400037c1070ULL,
0x0000000c5300720cULL, 0x0c0fe40002781070ULL, 0x0000000c5300720cULL, 0x000fe40000701070ULL,
0xff80000033337808ULL, 0x000fc40001800000ULL, 0xff8000002c2c7808ULL, 0x000fe40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40002000000ULL, 0xff80000020207808ULL, 0x000fe40000800000ULL,
0xff80000021217808ULL, 0x000fe40002800000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fce0000000000ULL, 0x0000001b1000720bULL, 0x004fe20003f1e000ULL,
0x3f80000000097882ULL, 0x000fe20000000000ULL, 0x0000000308087812ULL, 0x000fe200078ec0ffULL,
0x00000009ff197e24ULL, 0x000fe2000f8e00ffULL, 0x000000101b107208ULL, 0x000fe20004000000ULL,
0x000000ffff4e7224ULL, 0x000fe200078e006bULL, 0xfffffff8ff097812ULL, 0x000fe400078ee209ULL,
0x000000391000720bULL, 0x000fc80003f1e000ULL, 0x0000001039157208ULL, 0x000fc80004000000ULL,
0x000000581500720bULL, 0x000fc80003f1e000ULL, 0x00000015580c7208ULL, 0x000fc80004000000ULL,
0x000000590c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c59157208ULL, 0x000fc80004000000ULL,
0x000000541500720bULL, 0x000fc80003f1e000ULL, 0x00000015540c7208ULL, 0x000fc80004000000ULL,
0x000000550c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c55157208ULL, 0x000fc80004000000ULL,
0x0000001a1500720bULL, 0x000fc80003f1e000ULL, 0x000000151a0c7208ULL, 0x000fc80004000000ULL,
0x000000250c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c250c7208ULL, 0x000fc80004000000ULL,
0x000000290c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c29157208ULL, 0x000fc80004000000ULL,
0x0000002a1500720bULL, 0x000fc80003f1e000ULL, 0x000000152a157208ULL, 0x000fc80004000000ULL,
0x000000301500720bULL, 0x000fc80003f1e000ULL, 0x00000015300c7208ULL, 0x000fe40004000000ULL,
0x0000003a1100720bULL, 0x000fe40003f1e000ULL, 0x000000310c00720bULL, 0x000fc80003f3e000ULL,
0x0000000c31157208ULL, 0x000fe40004800000ULL, 0x000000113a0c7208ULL, 0x000fe40004000000ULL,
0x000000321500720bULL, 0x000fe40003f3e000ULL, 0x0000003b0c00720bULL, 0x000fe40003f1e000ULL,
0x0000001532107208ULL, 0x000fe40004800000ULL, 0x0000000c3b117208ULL, 0x000fc40004000000ULL,
0x000000331000720bULL, 0x000fe40003f3e000ULL, 0x0000005a1100720bULL, 0x000fe40003f1e000ULL,
0x0000001033157208ULL, 0x000fe40004800000ULL, 0x000000115a0c7208ULL, 0x000fe40004000000ULL,
0x0000002c1500720bULL, 0x000fe40003f3e000ULL, 0x0000005b0c00720bULL, 0x000fc40003f1e000ULL,
0x000000152c107208ULL, 0x000fe40004800000ULL, 0x0000000c5b117208ULL, 0x000fe40004000000ULL,
0x0000002d1000720bULL, 0x000fe40003f3e000ULL, 0x000000561100720bULL, 0x000fe40003f1e000ULL,
0x000000102d107208ULL, 0x000fe40004800000ULL, 0x00000011560c7208ULL, 0x000fc60004000000ULL,
0x0c401f0010157f89ULL, 0x000ea200000e0000ULL, 0x000000570c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c57117208ULL, 0x000fc80004000000ULL, 0x000000241100720bULL, 0x000fc80003f1e000ULL,
0x00000011240c7208ULL, 0x000fc80004000000ULL, 0x000000270c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c27117208ULL, 0x000fe40004000000ULL, 0x000000151000720bULL, 0x004fe40003f3e000ULL,
0x000000281100720bULL, 0x000fe40003f1e000ULL, 0x0000001015157208ULL, 0x000fe40004800000ULL,
0x0000001128117208ULL, 0x000fc60004000000ULL, 0x0c201f0015107f89ULL, 0x000ea200000e0000ULL,
0x000000261100720bULL, 0x000fc80003f1e000ULL, 0x0000001126117208ULL, 0x000fc80004000000ULL,
0x000000221100720bULL, 0x000fc80003f1e000ULL, 0x00000011220c7208ULL, 0x000fc80004000000ULL,
0x000000230c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c23117208ULL, 0x000fe40004000000ULL,
0x000000101500720bULL, 0x004fe40003f3e000ULL, 0x000000201100720bULL, 0x000fe40003f1e000ULL,
0x0000001510107208ULL, 0x000fe40004800000ULL, 0x00000011200c7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b10167820ULL, 0x000fe20000410000ULL, 0x000000210c00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b31157823ULL, 0x100fe20000010816ULL, 0x0000000c21117208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b33317823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b58587823ULL, 0x100fe20000010816ULL, 0x0000002e1100720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b59597823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010816ULL, 0x000000112e0c7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2a357823ULL, 0x100fe20000010816ULL, 0x0000001a001e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c2a7823ULL, 0x100fe20000010816ULL, 0x0000002f0c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b30347823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010816ULL, 0x0000000c2f0c7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010816ULL, 0x0000001500377308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b32307823ULL, 0x100fe20000010816ULL,
0x0c401f000c117f89ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b2d2d7823ULL, 0x000fc80000010816ULL,
0x0000001b001b7308ULL, 0x000ff00000000800ULL, 0x0000003900187308ULL, 0x000ff00000000800ULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0x000000110c00720bULL, 0x004fc80003f1e000ULL,
0x0000000c11117208ULL, 0x000fc60004000000ULL, 0x0000005900597308ULL, 0x000ea40000000800ULL,
0x0c201f0011147f89ULL, 0x000eec00000e0000ULL, 0x00000029000c7308ULL, 0x000fe20000000800ULL,
0x000000585916723eULL, 0x004fce00000010ffULL, 0x00000054001c7308ULL, 0x000ff00000000800ULL,
0x0000005500557308ULL, 0x000ea20000000800ULL, 0x000000141100720bULL, 0x008fc80003f1e000ULL,
0x0000001114117208ULL, 0x000fc60004000000ULL, 0x0000002500257308ULL, 0x000ee20000000800ULL,
0x0000001b1814723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b11337820ULL, 0x000fe20000410000ULL,
0x0000001c551c723eULL, 0x004fc600000010ffULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b5b5b7823ULL, 0x100fe20000010833ULL, 0x0000003a00157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b28387823ULL, 0x100fe20000010833ULL, 0x3f8000001928783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b56567823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010833ULL,
0x000000ffff297224ULL, 0x000fe200078e0028ULL, 0x0000003b001a7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010833ULL, 0x0000001e251e723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b20207823ULL, 0x000fc40000010833ULL,
0x0000005a00177308ULL, 0x000fe20000000800ULL, 0x000000151a15723eULL, 0x004fce00000010ffULL,
0x0000005b002c7308ULL, 0x000eb00000000800ULL, 0x00000056001d7308ULL, 0x000fe20000000800ULL,
0x000000172c17723eULL, 0x004fce00000010ffULL, 0x0000005700327308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b232c7823ULL, 0x000fe40000010833ULL, 0x0c401f0012237f89ULL, 0x000ee200000e0000ULL,
0x000000281418723cULL, 0x000fe800000418ffULL, 0x00000024001f7308ULL, 0x0009e20000000800ULL,
0x0000001d321d723eULL, 0x004fce00000010ffULL, 0x0000002700367308ULL, 0x0005620000000800ULL,
0x3fb8aa3b22247823ULL, 0x010fe20000010833ULL, 0x0000002800337202ULL, 0x000fe20000000f00ULL,
0x0c401f0013227f89ULL, 0x000f2a00000e0000ULL, 0x0000002600397308ULL, 0x000be20000000800ULL,
0x000000ffff277224ULL, 0x004fe200078e0028ULL, 0x000000231200720bULL, 0x008fc40003f1e000ULL,
0x0000001f361f723eULL, 0x022fc800000010ffULL, 0x0000002400297308ULL, 0x0003e20000000800ULL,
0x0000002800267202ULL, 0x000fe40000000f00ULL, 0x0000001223127208ULL, 0x000fca0004000000ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x000000261c24723cULL, 0x002fe20000041818ULL,
0x000000221300720bULL, 0x010fc80003f3e000ULL, 0x0000001322137208ULL, 0x000fe40004800000ULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x000000292c1b723eULL, 0x004fce00000010ffULL,
0x0000003400347308ULL, 0x000ea20000000800ULL, 0x000000ffff297224ULL, 0x000fe200078e0028ULL,
0x0000000c3518723eULL, 0x002fcc00000010ffULL, 0x0000003800387308ULL, 0x000e620000000800ULL,
0x00000001080c7824ULL, 0x000fc800078e0209ULL, 0x000000040c2c7836ULL, 0x000fe20000000000ULL,
0x00000034371a723eULL, 0x004fe400000010ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x000000383919723eULL, 0x002fce00000010ffULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x000000281824723cULL, 0x000fee0000041824ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x0000000309297819ULL, 0x000fe400000006ffULL, 0x0000002a2d22723eULL, 0x002fca00000010ffULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x00000008092d7836ULL, 0x000fe20000000000ULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x000008004a2a7824ULL, 0x000fe400078e0207ULL,
0x000000082d357824ULL, 0x000fe400078e00ffULL, 0x0000000c0c0c7836ULL, 0x000fe20000000000ULL,
0x0000002000327308ULL, 0x000fe20000000800ULL, 0x000110002a2a7836ULL, 0x000fc60000000000ULL,
0xfffffff835357812ULL, 0x000fe400078ee20cULL, 0x0000002a29297211ULL, 0x000fe400078e20ffULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x0000002e2f23723eULL, 0x002fe200000010ffULL,
0x00000008092f7824ULL, 0x000fe200078e00ffULL, 0x0000002d082e7210ULL, 0x000fe20007ffe0ffULL,
0x0c201f0012097f89ULL, 0x000e6200000e0000ULL, 0x0000001035357824ULL, 0x000fc600078e022aULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x0c201f0013087f89ULL, 0x000ee200000e0000ULL,
0x000000322121723eULL, 0x004fcc00000010ffULL, 0x0000003100317308ULL, 0x000ea20000000800ULL,
0x000000ffff327224ULL, 0x000fe200078e0028ULL, 0x000000091200720bULL, 0x002fe40003f1e000ULL,
0x000000303120723eULL, 0x004fe200000010ffULL, 0x000000082d317824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2d7812ULL, 0x000fe200078ee22cULL, 0x000000ffff2c7224ULL, 0x000fe200078e0014ULL,
0x0000001209127208ULL, 0x000fe20004000000ULL, 0x000000ffff307224ULL, 0x000fe200078e0018ULL,
0xfffffff8312f7812ULL, 0x000fe200078ee22eULL, 0x000000322024723cULL, 0x000fe20000041824ULL,
0x000000030bff7812ULL, 0x000fe2000780c0ffULL, 0x000000102d0c7824ULL, 0x000fe200078e022aULL,
0x00000016002d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff2e7224ULL, 0x000fe200078e001cULL,
0x000000081300720bULL, 0x008fe20003f3e000ULL, 0x000000ffff167224ULL, 0x000fe200078e001dULL,
0x0000001500147202ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe200078e0020ULL,
0x0000001a00317202ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fe200078e0022ULL,
0x0000001900187202ULL, 0x000fe20000000f00ULL, 0x000000ffff157224ULL, 0x000fe200078e0017ULL,
0x0000001308137208ULL, 0x000fe20004800000ULL, 0x000000ffff177224ULL, 0x000fc400078e001fULL,
0x000000ffff197224ULL, 0x000fe400078e001bULL, 0x000000ffff1a7224ULL, 0x000fe400078e0021ULL,
0x000000102f257824ULL, 0x000fe400078e022aULL, 0x000000ffff2f7224ULL, 0x000fe400078e001eULL,
0x000000ffff1b7224ULL, 0x000fe200078e0023ULL, 0x00000024001c7202ULL, 0x000fe20000000f00ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0026ULL, 0x0000002c29007844ULL, 0x0003e20000000200ULL,
0x00000001ff097424ULL, 0x000fc600078e00ffULL, 0x000000300c007844ULL, 0x0003e80000000200ULL,
0x0000001425007844ULL, 0x0003e80000000200ULL, 0x0000001835007844ULL, 0x0003e80000000200ULL,
0x01b000102b008388ULL, 0x0003e80000000c00ULL, 0x01b2001c2b008388ULL, 0x0003e20000000a00ULL,
0x0000000f6b00720cULL, 0x000fe20003f06070ULL, 0x01b608090eff79a7ULL, 0x0003e2000850003fULL,
0x01b610090eff79a7ULL, 0x0003e2000850003fULL, 0x01b618090eff79a7ULL, 0x0003e2000850003fULL,
0x01b620090eff79a7ULL, 0x0003f2000850003fULL, 0xffffff9c002c8947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x018000005b037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000007945ULL, 0x000fe60003800000ULL, 0x7f800000030d7812ULL, 0x000fc800078ec0ffULL,
0x018000000d00780cULL, 0x000fda0003f05070ULL, 0x0000005b00038308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0d00720cULL, 0x040fe40003f25070ULL,
0x008000000d00780cULL, 0x000fe40003f02070ULL, 0x00000001ff107807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000310ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff5bff7812ULL, 0x040fe4000780c0ffULL,
0x800000005b0d7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000310ff7212ULL, 0x000fda000780c0ffULL, 0x008000000d030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e000dULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000005b00037308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000ff0d7424ULL, 0x000fc800078e00ffULL, 0xfffffec80c107950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000495ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000210ULL, 0x0000001400000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000820ULL, 0x00000000000000d0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000008f0ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000944ULL, 0x0000000000000460ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000da8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000da8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000df0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000e00ULL, 0x0000000000013880ULL, 0x0000001400000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014680ULL, 0x000000000000003cULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000146c0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000146c0ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000014cb0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000014cb0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000df0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000e00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013880ULL,
0x0000000000013880ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014680ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000146c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_0_m_16_sm_90_cubin_len = 85504;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
