/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016e40ULL, 0x0000000000016ac0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x4545386a4c45386aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c00010000036aULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000003afULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0022000003f5ULL, 0x0000000000015290ULL, 0x0000000000000170ULL, 0x000b002200000428ULL,
0x0000000000015400ULL, 0x0000000000000040ULL, 0x000b002200000453ULL, 0x0000000000015440ULL,
0x0000000000000050ULL, 0x000b00220000047dULL, 0x0000000000015490ULL, 0x0000000000000170ULL,
0x000a0003000004ebULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000400030000050bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000700030000053bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015600ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001529000000000ULL, 0x0000040400000000ULL, 0x810c000001200400ULL,
0x0053740400288080ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080890828808081ULL,
0x90082880808c0828ULL, 0x2880809608288080ULL, 0x80c2082880809808ULL, 0x1628808088082880ULL,
0x0000031028808280ULL, 0x8892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001529000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c08288080890828ULL, 0x2880809008288080ULL,
0x80b4082880809808ULL, 0x08288080c2082880ULL, 0x80828016288080b2ULL, 0x0000000000031028ULL,
0x288080b292000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000010000000000ULL,
0x0001540000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8c08288080890828ULL, 0x2880809008288080ULL, 0x80c2082880809608ULL,
0x1628808098082880ULL, 0x0000031028808280ULL, 0x9892000000000000ULL, 0x0000002200288080ULL,
0x0000002cffffffffULL, 0x0000019800000000ULL, 0x0001544000000000ULL, 0x0000005000000000ULL,
0x0000100400000000ULL, 0x808c288080980900ULL, 0x0000000000002880ULL, 0x0000005cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8c08288080890828ULL, 0x2880809008288080ULL, 0x80c2082880809808ULL,
0x1628808096082880ULL, 0x0000031028808280ULL, 0x9692000000000000ULL, 0x0000002200288080ULL,
0x0000002cffffffffULL, 0x0000023800000000ULL, 0x0001549000000000ULL, 0x0000017000000000ULL,
0x0000180400000000ULL, 0x808c288080960900ULL, 0x0000000000002880ULL, 0x0000001800082f04ULL,
0x0008230400000080ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001100082304ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008230400000000ULL, 0x0000000000000018ULL,
0x0000001800081204ULL, 0x0008110400000000ULL, 0x0000000000000018ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0050016000000015ULL, 0x000c170400501903ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000002000043104ULL, 0xffffffff01542904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000f001542804ULL, 0x0000033000000120ULL, 0x00002a7000001760ULL,
0x00002c1000002b00ULL, 0x00002f9000002d80ULL, 0x0000303000002fc0ULL, 0x00003770000030a0ULL,
0x00004a70000049d0ULL, 0x00004cf000004b90ULL, 0x00004f3000004f00ULL, 0x0000501000004fa0ULL,
0x0000667000005410ULL, 0x0000684000006710ULL, 0x00006bb0000069a0ULL, 0x00006c5000006be0ULL,
0x000070e000006cc0ULL, 0x000083b000008310ULL, 0x00008630000084d0ULL, 0x0000886000008830ULL,
0x00008940000088d0ULL, 0x00008dc000008db0ULL, 0x0000b1000000b090ULL, 0x0000b8f00000b8c0ULL,
0x00013730000136f0ULL, 0x0001375000013740ULL, 0x000137c0000137a0ULL, 0x000137f0000137e0ULL,
0x00014500000144a0ULL, 0x000145e000014570ULL, 0x000146e000014660ULL, 0x000147a000014740ULL,
0x0001488000014810ULL, 0x0001497000014900ULL, 0x00014a30000149d0ULL, 0x00014b0000014a90ULL,
0x00014bf000014b80ULL, 0x00014cb000014c50ULL, 0x00014d8000014d10ULL, 0x00014e7000014e00ULL,
0x00014f6000014ee0ULL, 0x0001506000014fe0ULL, 0x00015160000150e0ULL, 0x00015260000151e0ULL,
0x000001f002003904ULL, 0x0001b600000000ffULL, 0x00000270003f0100ULL, 0x0001b60800000009ULL,
0x00000310003f0120ULL, 0x0001b68800000009ULL, 0x00000410003f0120ULL, 0x0001b600000000ffULL,
0x000005c0003f0107ULL, 0x0001b68c00000056ULL, 0x00000670003f0102ULL, 0x0001b68800000056ULL,
0x00002780003f0101ULL, 0x0001b60800000076ULL, 0x000027a0003f0101ULL, 0x0001b60c00000076ULL,
0x00002970003f0105ULL, 0x0001b60c00000076ULL, 0x00003710003f0105ULL, 0x0001b68800000060ULL,
0x00004730003f0101ULL, 0x0001b62800000076ULL, 0x00004750003f0101ULL, 0x0001b62c00000076ULL,
0x00004920003f0105ULL, 0x0001b62c00000076ULL, 0x000053c0003f0105ULL, 0x0001b69000000060ULL,
0x00006390003f0101ULL, 0x0001b64800000076ULL, 0x000063f0003f0101ULL, 0x0001b64c00000076ULL,
0x000065c0003f0105ULL, 0x0001b64c00000076ULL, 0x00007070003f0105ULL, 0x0001b69800000060ULL,
0x00008070003f0101ULL, 0x0001b66800000076ULL, 0x00008090003f0101ULL, 0x0001b66c00000076ULL,
0x00008260003f0105ULL, 0x0001b66c00000076ULL, 0x00008be0003f0105ULL, 0x0001b6a000000060ULL,
0x0000c4c0003f0101ULL, 0x0001b600000000ffULL, 0x0000e110003f0101ULL, 0x0001b604000000ffULL,
0x0000e2e0003f0105ULL, 0x0001b604000000ffULL, 0x00012b50003f0105ULL, 0x0000000000000008ULL,
0x00012c40003f0101ULL, 0x0000000400000008ULL, 0x00012e10003f0105ULL, 0x0000000400000008ULL,
0x000142f0003f0105ULL, 0x0001b60800000000ULL, 0x00014350003f0101ULL, 0x0001b61000000000ULL,
0x000143b0003f0101ULL, 0x0001b61800000000ULL, 0x00014420003f0101ULL, 0x0001b62000000000ULL,
0x00033803003f0101ULL, 0x0000c16000141c04ULL, 0x0000e3400000c3d0ULL, 0x000144600000e3d0ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002b4ULL, 0x0000001800000002ULL,
0x0000000000000214ULL, 0x0000001800000002ULL, 0x0000000000000184ULL, 0x0000001800000002ULL,
0x00000000000000ecULL, 0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL,
0x000000000000028eULL, 0x0000001800000002ULL, 0x00000000000001eeULL, 0x0000001800000002ULL,
0x000000000000015bULL, 0x0000001800000002ULL, 0x00000000000000c6ULL, 0x0000001800000002ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000097919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x00005800ff117624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000ea20000002300ULL,
0x0000001300067300ULL, 0x000ee200000e0000ULL, 0x0000000811047824ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x0000000000007919ULL, 0x000ea80000002200ULL,
0x0000000000107919ULL, 0x000ee20000002600ULL, 0x0000001300137309ULL, 0x000ea60000000000ULL,
0x00000000000b7919ULL, 0x000ee80000000000ULL, 0x0000000000087919ULL, 0x000ee20000002700ULL,
0x00000005ff5c7819ULL, 0x002fcc0000011609ULL, 0x00001fff5c5c7589ULL, 0x000fe200000e0000ULL,
0x00000004ff5e7e24ULL, 0x010fe4000f8e00ffULL, 0x0000010007007a24ULL, 0x004fe400078e0200ULL,
0x00001fff07077589ULL, 0x000e6200000e0000ULL, 0x0000000810057824ULL, 0x008fe400078e00ffULL,
0x0000000000097a24ULL, 0x000fe400078e0209ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000b0600720cULL, 0x000fc40003f62070ULL, 0x000000ff0900720cULL, 0x040fe20003f05270ULL,
0x0000000804067224ULL, 0x000fe200078e0205ULL, 0x0000000f0900780cULL, 0x040fe40003f24070ULL,
0x0000007f0900780cULL, 0x000fd20003f44070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x00000004070a7824ULL, 0x002fe400078e025cULL,
0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL, 0x01b60002ff008388ULL, 0x0003e20000000a00ULL,
0x000000030900780cULL, 0x000fe20003f04070ULL, 0x000000020a0a7824ULL, 0x000fe200078e00ffULL,
0x00000004ff0e7819ULL, 0x004fe20000011600ULL, 0x7fffffc0ff059424ULL, 0x000fc400078e00ffULL,
0xff317217ff12a424ULL, 0x000fe200078e00ffULL, 0x000000080a0b7817ULL, 0x040fe20007800000ULL,
0x000000010a0f7824ULL, 0x000fe200078e020eULL, 0x01b6080409009388ULL, 0x0005e20000008a00ULL,
0x00000100ff037424ULL, 0x002fe400078e00ffULL, 0x0000000106027824ULL, 0x000fe200078e020fULL,
0x01b400120900a388ULL, 0x000fe20000004800ULL, 0x0000001000067824ULL, 0x000fe400078e00ffULL,
0x3fffff60ff0c8424ULL, 0x000fc400078e00ffULL, 0x7fffff60ff0d8424ULL, 0x000fe400078e00ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0a0aULL, 0x000000f006057812ULL, 0x004fe200078ec0ffULL,
0x000000010f047824ULL, 0x000fe200078e0200ULL, 0x01b6880c09008388ULL, 0x000fe20000008a00ULL,
0x00005c0002027625ULL, 0x000fc600078e0003ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000b0e00720cULL, 0x000fe20003f06070ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0a13ULL, 0x00000005020a7210ULL, 0x000fe20007f3e0ffULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0xfffffff00f047812ULL, 0x000fc600078ee204ULL,
0x000000ffff0b7224ULL, 0x000fe400008e0603ULL, 0x00000010040f7824ULL, 0x000fe400078e00ffULL,
0x0000620008027625ULL, 0x000fc600078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x01b6040effff338cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000006025a7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0700720cULL, 0x000fc40003f05270ULL, 0x0000003f5a5b7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff5a597810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff5b7819ULL, 0x000fe4000001165bULL,
0x00000008ff597819ULL, 0x000fca0000011659ULL, 0x0000bee000008947ULL, 0x000fea0003800000ULL,
0x00000002ff557819ULL, 0x000fe2000001165cULL, 0x000000085c567824ULL, 0x000fe400078e00ffULL,
0x00000003ff097424ULL, 0x000fe200078e00ffULL, 0x03ffffff55037812ULL, 0x000fca00078ec0ffULL,
0x000000045e027824ULL, 0x000fca00078e0203ULL, 0x0000005b0200720cULL, 0x000fda0003f06070ULL,
0x0000000208038824ULL, 0x000fe400078e00ffULL, 0x00006400ff048624ULL, 0x000fc800078e00ffULL,
0x0000640003078624ULL, 0x000fe400078e0204ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x0000000102068824ULL, 0x000fe200078e0207ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b68c0956ff738cULL, 0x0005e20000000000ULL, 0x0000600006068625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606038981ULL, 0x000ee2000c1e1900ULL,
0x000000015e047810ULL, 0x000fe20007ffe0ffULL, 0x00000040100b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff577819ULL, 0x000fe2000001165cULL, 0x01b6880056ff7f8cULL, 0x0003e2000c80043fULL,
0x000000590400720cULL, 0x000fc40003f06070ULL, 0x000000015c587812ULL, 0x000fe200078ec0ffULL,
0x0000002057547824ULL, 0x000fc800078e00ffULL, 0x000001005e0a7824ULL, 0x000fca00078e0254ULL,
0x000000200b187812ULL, 0x000fe200078ef80aULL, 0x0000580003037a24ULL, 0x008fc800078e02ffULL,
0x0000004003227824ULL, 0x000fe200078e00ffULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x002fe20000011600ULL, 0x00000002571b7824ULL, 0x000fe200078e0258ULL,
0x0000000a5a037217ULL, 0x000fe40007800000ULL, 0x0000000404077810ULL, 0x040fe40007ffe0ffULL,
0x0000000804097810ULL, 0x044fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a0aULL,
0x0000000c04177810ULL, 0x040fe20007ffe0ffULL, 0x0000000107067824ULL, 0x140fe200078e0200ULL,
0x00000010041c7810ULL, 0x040fe20007ffe0ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x0000002003037817ULL, 0x000fe20003800000ULL, 0x00000001090c7824ULL, 0x040fe200078e0200ULL,
0x00000014041e7810ULL, 0x000fe20007ffe0ffULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0a7812ULL, 0x000fe200078ee206ULL, 0x0000000118067824ULL, 0x040fe200078e0204ULL,
0x000000030700720cULL, 0x080fe20003f06070ULL, 0x0000000118077824ULL, 0x000fe200078e0207ULL,
0xfffffff80f1a7812ULL, 0x000fe200078ee20cULL, 0x0000000817267824ULL, 0x000fe200078e00ffULL,
0x00000006220c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000118067824ULL, 0x040fe200078e0217ULL,
0x000000030900720cULL, 0x000fe20003f26070ULL, 0x0000000118097824ULL, 0x000fe200078e0209ULL,
0x00000007220d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x00005e000c147a11ULL, 0x000fc400078440ffULL, 0x0000000922097210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x0000000622067210ULL, 0x000fe40007fbe0ffULL,
0x00005f000c157a11ULL, 0x000fe200010f440fULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x00005e000d107a11ULL, 0x040fe200078440ffULL, 0x000000ffff077224ULL, 0x000fe200028e06ffULL,
0x00005e00060c7a11ULL, 0x000fe400078840ffULL, 0x00005f000d117a11ULL, 0x000fc400010f4416ULL,
0x00005f00060d7a11ULL, 0x000fe200020f4407ULL, 0x0000000118067824ULL, 0x040fe200078e021cULL,
0x00005e00090e7a11ULL, 0x040fe200078640ffULL, 0x0000000118077824ULL, 0x000fe200078e021eULL,
0x00000018041f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000622167210ULL, 0x000fe40007f5e0ffULL,
0x00005f00090f7a11ULL, 0x000fe200018f4412ULL, 0x0000000118097824ULL, 0x000fe200078e021fULL,
0x00005e0016067a11ULL, 0x000fe200078640ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x0000000722137210ULL, 0x000fc40007fbe0ffULL, 0x0000001c04207810ULL, 0x000fe40007ffe0ffULL,
0x00005f0016077a11ULL, 0x000fe200018f4419ULL, 0x0000000858197824ULL, 0x000fe200078e00ffULL,
0x000000030400720cULL, 0x040fe20003f66070ULL, 0x0000000104047824ULL, 0x000fe200078e0200ULL,
0x0000000922237210ULL, 0x000fe20007f9e0ffULL, 0x0000000118127824ULL, 0x000fe200078e0220ULL,
0x000130001b1b7811ULL, 0x000fe200078e68ffULL, 0x000000ffff167224ULL, 0x000fe200028e06ffULL,
0x0000000704097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x0000001222217210ULL, 0x000fc40007f5e0ffULL, 0x0ffffff809047812ULL, 0x100fe400078ef800ULL,
0xfffffff819097812ULL, 0x100fe200078ee200ULL, 0x0000000117197824ULL, 0x000fe200078e0200ULL,
0x00005e0013127a11ULL, 0x000fe200078a40ffULL, 0x00000010041d7824ULL, 0x000fe200078e021bULL,
0x00005e0023187a11ULL, 0x000fe200078840ffULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0x00005f0013137a11ULL, 0x000fe200028f4416ULL, 0x0000001009147825ULL, 0x000fe200078e0014ULL,
0x00005e0021167a11ULL, 0x000fc400078a40ffULL, 0x000000031700720cULL, 0x080fe20003f46070ULL,
0x0000001009107825ULL, 0x000fe200078e0010ULL, 0xfffffff826047812ULL, 0x000fe200078ee219ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e2000d901c46ULL,
0x00005f0023197a11ULL, 0x000fe200020f4424ULL, 0x00000010090e7825ULL, 0x000fe200078e000eULL,
0x00005f0021177a11ULL, 0x000fe400028f4422ULL, 0x000000031c00720cULL, 0x0c0fe20003f66070ULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0x000000031e00720cULL, 0x0c0fe20003f86070ULL,
0x000000081e217824ULL, 0x000fe200078e00ffULL, 0x000000031f00720cULL, 0x080fe20003fa6070ULL,
0x00000010090c7825ULL, 0x000fe200078e000cULL, 0x000000032000720cULL, 0x000fc60003fc6070ULL,
0x000000011c037824ULL, 0x100fe400078e0200ULL, 0x000000011e1c7824ULL, 0x100fe400078e0200ULL,
0x000000011f1e7824ULL, 0x100fe200078e0200ULL, 0xfffffff822147812ULL, 0x002fe200078ee203ULL,
0x0000000120157824ULL, 0x040fe200078e0200ULL, 0xfffffff8211c7812ULL, 0x000fe200078ee21cULL,
0x000000081f1f7824ULL, 0x000fe400078e00ffULL, 0x0000000820207824ULL, 0x000fc400078e00ffULL,
0x000000100a037824ULL, 0x100fe200078e021bULL, 0xfffffff81f1e7812ULL, 0x000fe200078ee21eULL,
0x00000010041d7824ULL, 0x000fe200078e021bULL, 0xfffffff820207812ULL, 0x000fe200078ee215ULL,
0x000000101a157824ULL, 0x100fe200078e021bULL, 0x0000000010037faeULL, 0x0003e2000c101c46ULL,
0x00000010141f7824ULL, 0x000fe400078e021bULL, 0x0000001009067825ULL, 0x040fe200078e0006ULL,
0x000000000e157faeULL, 0x0003e6000c901c46ULL, 0x000000101c217824ULL, 0x000fe200078e021bULL,
0x000000000c1d7faeULL, 0x0003e2000d101c46ULL, 0x0000001009127825ULL, 0x000fc600078e0012ULL,
0x00000000061f7faeULL, 0x0003e2000d901c46ULL, 0x000000101e237824ULL, 0x000fe400078e021bULL,
0x0000001009187825ULL, 0x040fe200078e0018ULL, 0x0000000012217faeULL, 0x0003e6000e101c46ULL,
0x00000010201b7824ULL, 0x000fe200078e021bULL, 0x0000000018237faeULL, 0x0003e2000e901c46ULL,
0x0000001009167825ULL, 0x000fca00078e0016ULL, 0x00000000161b7faeULL, 0x0003e2000f101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x0000000400097811ULL, 0x006fe200078fe8ffULL,
0x0000000858277824ULL, 0x000fe200078e00ffULL, 0x0000000c000f7811ULL, 0x040fe400078fe8ffULL,
0x00000008000d7811ULL, 0x040fe200078fe8ffULL, 0x0000000109037824ULL, 0x140fe200078e0200ULL,
0x0000001400137811ULL, 0x040fe200078fe8ffULL, 0x0000000809047824ULL, 0x000fe200078e00ffULL,
0x0000001800157811ULL, 0x000fe200078fe8ffULL, 0x000000010f077824ULL, 0x100fe200078e0200ULL,
0xfffffff827277812ULL, 0x100fe200078ee200ULL, 0x000000080f0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff804047812ULL, 0x000fe200078ee203ULL, 0x000000010d067824ULL, 0x140fe200078e0200ULL,
0x0000001800037211ULL, 0x000fe200078fe8ffULL, 0x000000080d117824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x0000000113077824ULL, 0x040fe200078e0200ULL,
0x0000000322167210ULL, 0x000fe20007f1e0ffULL, 0x0000000813127824ULL, 0x000fe200078e00ffULL,
0xfffffff8110a7812ULL, 0x000fe200078ee206ULL, 0x00000001150c7824ULL, 0x140fe200078e0200ULL,
0x0000001000117811ULL, 0x000fe200078fe8ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x00005e0016067a11ULL, 0x000fe200078040ffULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x0000000111037824ULL, 0x040fe200078e0200ULL,
0x00005f0016077a11ULL, 0x000fe200000f4417ULL, 0x0000000811107824ULL, 0x000fe200078e00ffULL,
0x0000001c00177811ULL, 0x000fe200078fe8ffULL, 0x00000001180d7824ULL, 0x040fe200078e020dULL,
0xfffffff819147812ULL, 0x000fe200078ee20cULL, 0x0000000118097824ULL, 0x000fe200078e0209ULL,
0xfffffff810107812ULL, 0x000fe200078ee203ULL, 0x00000001180f7824ULL, 0x000fe200078e020fULL,
0x0000000000037211ULL, 0x000fe200078fe8ffULL, 0x0000000118117824ULL, 0x000fe200078e0211ULL,
0x00000009221b7210ULL, 0x000fe20007fde0ffULL, 0x0000000118137824ULL, 0x000fe200078e0213ULL,
0x0000000f22167210ULL, 0x000fe20007f9e0ffULL, 0x0000000118157824ULL, 0x000fe200078e0215ULL,
0x00000011221e7210ULL, 0x000fe20007f7e0ffULL, 0x00000001180c7824ULL, 0x000fe200078e0217ULL,
0x0000000d22187210ULL, 0x040fe20007fbe0ffULL, 0x00000002570d7824ULL, 0x000fe200078e0258ULL,
0x00000013221c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000117097824ULL, 0x140fe200078e0200ULL,
0x00000015221a7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x0000000c22197210ULL, 0x000fe20007f3e0ffULL, 0x0000000817227824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0x000130000d257811ULL, 0x000fe200078e68ffULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x00005e001b0c7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x0ffffff803037812ULL, 0x000fe200078ef800ULL, 0x000000100e1d7824ULL, 0x000fe200078e0225ULL,
0xfffffff8220f7812ULL, 0x000fe200078ee209ULL, 0x0000001004097824ULL, 0x100fe200078e0225ULL,
0x00005e00180e7a11ULL, 0x000fe200078a40ffULL, 0x0000001003037824ULL, 0x100fe200078e0225ULL,
0x00005f001b0d7a11ULL, 0x000fe200030f4420ULL, 0x000000100a1b7824ULL, 0x000fc400078e0225ULL,
0x00000010101f7824ULL, 0x100fe200078e0225ULL, 0x00005e0016107a11ULL, 0x000fe200078840ffULL,
0x0000001012217824ULL, 0x100fe400078e0225ULL, 0x0000001014237824ULL, 0x000fe200078e0225ULL,
0x00005f0016117a11ULL, 0x000fe200020f4411ULL, 0x000000100f257824ULL, 0x000fe200078e0225ULL,
0x00005f00180f7a11ULL, 0x000fe200028f4413ULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x00005e001e127a11ULL, 0x000fe200078640ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x00005e001c147a11ULL, 0x000fe200078040ffULL, 0x000000ffff047224ULL, 0x000fe200008e06ffULL,
0x00005e001a167a11ULL, 0x000fe200078440ffULL, 0x0000001027067825ULL, 0x000fe200078e0006ULL,
0x00005e0019187a11ULL, 0x000fc400078240ffULL, 0x00005f001e137a11ULL, 0x000fe200018f4413ULL,
0x00000010270c7825ULL, 0x040fe200078e000cULL, 0x00005f001c157a11ULL, 0x000fe200000f4415ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e2000b901c46ULL,
0x00005f001a177a11ULL, 0x000fe200010f4417ULL, 0x00000010270e7825ULL, 0x000fe200078e000eULL,
0x00005f0019197a11ULL, 0x000fe200008f4404ULL, 0x000000000c097faeULL, 0x0003e4000b901c46ULL,
0x0000001027107825ULL, 0x040fe400078e0010ULL, 0x000000000e1b7faeULL, 0x0003e4000b901c46ULL,
0x0000001027127825ULL, 0x000fc400078e0012ULL, 0x00000000101d7faeULL, 0x0003e4000b901c46ULL,
0x0000001027147825ULL, 0x040fe400078e0014ULL, 0x00000000121f7faeULL, 0x0003e4000b901c46ULL,
0x0000001027167825ULL, 0x040fe400078e0016ULL, 0x0000000014217faeULL, 0x0003e4000b901c46ULL,
0x0000001027187825ULL, 0x000fc400078e0018ULL, 0x0000000016237faeULL, 0x0003e8000b901c46ULL,
0x0000000018257faeULL, 0x0003e4000b901c46ULL, 0x00000003ff0a7424ULL, 0x000fe200078e00ffULL,
0x0000000302037812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000300050a7a24ULL, 0x000fe200078e0a0aULL, 0x000000030300780cULL, 0x000fc80003f05270ULL,
0x000000010a037807ULL, 0x000fca0004000000ULL, 0x0000000102027824ULL, 0x000fca00078e0203ULL,
0x0000005b0200720cULL, 0x000fda0003f06070ULL, 0x0000000208038824ULL, 0x000fe400078e00ffULL,
0x00006400ff048624ULL, 0x000fc800078e00ffULL, 0x0000640003038624ULL, 0x000fc800078e0204ULL,
0x0000000103068824ULL, 0x000fe400078e0202ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x0000600006068625ULL, 0x000fca00078e0005ULL, 0x0000000606038981ULL, 0x000322000c1e1900ULL,
0x000000595e00720cULL, 0x000fe20003f06070ULL, 0xff317217ff777424ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000758000000947ULL, 0x000fea0003800000ULL,
0x0000000208057824ULL, 0x002fe400078e00ffULL, 0x00006400ff067624ULL, 0x000fc400078e00ffULL,
0xff317217ff777424ULL, 0x000fe400078e00ffULL, 0x000000ffff797224ULL, 0x000fe400078e00ffULL,
0x0000640005057624ULL, 0x000fe400078e0206ULL, 0x000000ffff137224ULL, 0x000fc400078e00ffULL,
0x000001005e0d7824ULL, 0x020fca00078e00ffULL, 0x0000005a0d00720cULL, 0x000fda0003f06070ULL,
0x000074b000000947ULL, 0x000fea0003800000ULL, 0x000000105c067824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe0060d7812ULL, 0x000fe200078ec0ffULL,
0x00005800030e7a24ULL, 0x010fe200078e02ffULL, 0x000000015e067810ULL, 0x000fc60007ffe0ffULL,
0x000001005e0d7824ULL, 0x000fe200078e020dULL, 0x000000590600720cULL, 0x000fe20003f06070ULL,
0x000000ffff067224ULL, 0x000fe400078e0079ULL, 0x000000400e0e7824ULL, 0x000fe200078e00ffULL,
0x000000400d0c7810ULL, 0x000fc80007ffe0ffULL, 0x000000200b0f7812ULL, 0x000fca00078ef80cULL,
0x0000078000008947ULL, 0x000fea0003800000ULL, 0x000020005c0d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff1d7819ULL, 0x000fe20000011600ULL, 0x0000000858167824ULL, 0x000fe200078e00ffULL,
0x0000000c5a037217ULL, 0x000fe40007800000ULL, 0x000020000d147812ULL, 0x000fe200078ec0ffULL,
0x00001000790d7824ULL, 0x000fe200078e00ffULL, 0x000000041d177810ULL, 0x000fe20007ffe0ffULL,
0x00000001030c7824ULL, 0x000fe200078e0a0cULL, 0x000000081d197810ULL, 0x000fe20007ffe0ffULL,
0x0000400057147824ULL, 0x000fe200078e0214ULL, 0x000010000d157812ULL, 0x000fe200078e0cffULL,
0x000000011d0d7824ULL, 0x000fe200078e020fULL, 0x000000200c227817ULL, 0x000fe20003800000ULL,
0x0000000119237824ULL, 0x140fe200078e0200ULL, 0x0001300014207810ULL, 0x000fe20007ffe015ULL,
0x00000008190c7824ULL, 0x000fe200078e00ffULL, 0x0000000d0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001170d7824ULL, 0x000fe200078e020fULL, 0x0000000c1d297810ULL, 0x000fe20007ffe0ffULL,
0x0000000117217824ULL, 0x100fe200078e0200ULL, 0x0000000700037812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e00141e7a11ULL, 0x040fe200078040ffULL,
0x0000000129287824ULL, 0x000fe200078e0200ULL, 0x000000101d2b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008294f7824ULL, 0x040fe200078e00ffULL, 0x00005f00141f7a11ULL, 0x000fe200000f4415ULL,
0x0000000129157824ULL, 0x100fe200078e020fULL, 0x0000000d0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001190d7824ULL, 0x040fe200078e020fULL, 0x000000221900720cULL, 0x000fc40003f26070ULL,
0xfffffff80c237812ULL, 0x000fe200078ee223ULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x00005e00140c7a11ULL, 0x000fe400078040ffULL, 0x0000000816037812ULL, 0x000fe200078ee203ULL,
0x0000000817167824ULL, 0x040fe200078e00ffULL, 0x000000221700720cULL, 0x000fe20003f46070ULL,
0x000000012b177824ULL, 0x000fe200078e020fULL, 0x0000000d0e1b7210ULL, 0x000fe20007f7e0ffULL,
0x00000010031e7825ULL, 0x000fe200078e001eULL, 0x00005f00140d7a11ULL, 0x000fc400000f4419ULL,
0x000000150e197210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x000000170e157210ULL, 0x000fe20007fbe0ffULL, 0x00000010030c7825ULL, 0x000fe200078e000cULL,
0xfffffff816217812ULL, 0x000fe400078ee221ULL, 0x00005e0019167a11ULL, 0x000fe200078640ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x000000141d497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200028e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078840ffULL,
0x0000001021217824ULL, 0x000fe200078e0220ULL, 0x00005f0019177a11ULL, 0x000fe200018f441cULL,
0x0000000149197824ULL, 0x000fe200078e020fULL, 0x00005e001b1a7a11ULL, 0x000fe200078040ffULL,
0x0000001023237824ULL, 0x000fe200078e0220ULL, 0x000000181d4b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001003167825ULL, 0x000fe200078e0016ULL, 0x00005f0015157a11ULL, 0x000fc400020f4418ULL,
0x0000001c1d4d7810ULL, 0x040fe20007ffe0ffULL, 0x000000011d187824ULL, 0x000fe200078e0200ULL,
0x00005f001b1b7a11ULL, 0x000fe200000f4424ULL, 0x0000001003147825ULL, 0x000fe200078e0014ULL,
0x000000190e1c7210ULL, 0x000fe40007f1e0ffULL, 0x0000000718277812ULL, 0x000fe200078ec0ffULL,
0x000000014b197824ULL, 0x100fe200078e020fULL, 0x000000221d00720cULL, 0x000fe20003f66070ULL,
0x000000014d0f7824ULL, 0x000fe200078e020fULL, 0x0ffffff827277812ULL, 0x000fe200078ef800ULL,
0x000000ffff257224ULL, 0x000fe200000e06ffULL, 0x00005e001c187a11ULL, 0x000fe200078040ffULL,
0x00000010031a7825ULL, 0x000fe200078e001aULL, 0x000000190e1d7210ULL, 0x000fc40007f9e0ffULL,
0x0000000f0e0f7210ULL, 0x000fe40007fbe0ffULL, 0x00005f001c197a11ULL, 0x000fe200000f4425ULL,
0x0000001027257824ULL, 0x000fe200078e0220ULL, 0x000000222900720cULL, 0x080fe20003f06070ULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078840ffULL,
0x000000ffff247224ULL, 0x000fe200028e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078a40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e257faeULL, 0x0003e2000d901c46ULL,
0x00005f001d1d7a11ULL, 0x000fe200020f4426ULL, 0x0000000849297824ULL, 0x000fe200078e00ffULL,
0x00005f000f0f7a11ULL, 0x000fe200028f4424ULL, 0x0000000149247824ULL, 0x100fe200078e0200ULL,
0x000000222b00720cULL, 0x080fe20003f66070ULL, 0x000000014b267824ULL, 0x100fe200078e0200ULL,
0x000000224900720cULL, 0x080fe20003f86070ULL, 0x000000084d497824ULL, 0x000fe200078e00ffULL,
0x000000224b00720cULL, 0x0c0fe20003fa6070ULL, 0x000000084b4b7824ULL, 0x000fe200078e00ffULL,
0x000000224d00720cULL, 0x000fe20003fc6070ULL, 0x000000012b227824ULL, 0x000fe200078e0200ULL,
0xfffffff84f277812ULL, 0x000fe200078ee228ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee224ULL, 0x000000014d1e7824ULL, 0x002fe200078e0200ULL,
0x000000000c217faeULL, 0x0003e2000d101c46ULL, 0x00000010271f7824ULL, 0x000fe200078e0220ULL,
0xfffffff82b257812ULL, 0x000fe200078ee222ULL, 0x0000001029277824ULL, 0x000fe200078e0220ULL,
0xfffffff84b2b7812ULL, 0x000fe200078ee226ULL, 0x0000001003187825ULL, 0x000fe200078e0018ULL,
0xfffffff849497812ULL, 0x000fe200078ee21eULL, 0x000000001a237faeULL, 0x0003e4000c901c46ULL,
0x0000001025257824ULL, 0x000fc400078e0220ULL, 0x000000102b297824ULL, 0x000fe200078e0220ULL,
0x00000000161f7faeULL, 0x0003e2000c101c46ULL, 0x00000010031c7825ULL, 0x000fc600078e001cULL,
0x0000000014257faeULL, 0x0003e2000d901c46ULL, 0x00000010492b7824ULL, 0x000fe400078e0220ULL,
0x00000010030e7825ULL, 0x000fe200078e000eULL, 0x0000000018277faeULL, 0x0003e8000e101c46ULL,
0x000000001c297faeULL, 0x0003e8000e901c46ULL, 0x000000000e2b7faeULL, 0x0003e2000f101c46ULL,
0x000006b000007947ULL, 0x000fea0003800000ULL, 0x0000000800197811ULL, 0x000fe200078fe8ffULL,
0x0000000858147824ULL, 0x000fe200078e00ffULL, 0x0000000700037812ULL, 0x000fe200078ec0ffULL,
0x000020005c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000400177811ULL, 0x040fe200078fe8ffULL,
0x0000000119207824ULL, 0x140fe200078e0200ULL, 0x0000000c001b7811ULL, 0x000fe200078fe8ffULL,
0x0000000819157824ULL, 0x000fe200078e00ffULL, 0x0000000814037812ULL, 0x000fe200078ee203ULL,
0x00000001170d7824ULL, 0x040fe200078e0200ULL, 0x000020000c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000817147824ULL, 0x000fe200078e00ffULL, 0xfffffff815207812ULL, 0x000fe200078ee220ULL,
0x000000011b217824ULL, 0x040fe200078e0200ULL, 0x0000000f00157211ULL, 0x040fe200078fe8ffULL,
0x000000081b167824ULL, 0x000fe200078e00ffULL, 0x0000001800257811ULL, 0x000fe200078fe8ffULL,
0x0000000117177824ULL, 0x000fe200078e020fULL, 0x000000150e157210ULL, 0x000fe20007f1e0ffULL,
0x0000400057577824ULL, 0x000fe200078e020cULL, 0xfffffff8140d7812ULL, 0x000fe200078ee20dULL,
0x000000011b1b7824ULL, 0x000fe200078e020fULL, 0xfffffff816217812ULL, 0x000fe200078ee221ULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00000010001d7811ULL, 0x040fe200078fe8ffULL,
0x0000000125237824ULL, 0x140fe200078e0200ULL, 0x00000014001f7811ULL, 0x000fe200078fe8ffULL,
0x0000000825167824ULL, 0x000fe200078e00ffULL, 0x00005e0015147a11ULL, 0x000fe200078040ffULL,
0x0000000119197824ULL, 0x000fe200078e020fULL, 0x000000170e187210ULL, 0x000fe20007f7e0ffULL,
0x000000011d247824ULL, 0x040fe200078e0200ULL, 0x0000001c001e7811ULL, 0x000fe200078fe8ffULL,
0x000000081d277824ULL, 0x000fe200078e00ffULL, 0x00005f0015157a11ULL, 0x000fe200000f440cULL,
0x000000011f227824ULL, 0x140fe200078e0200ULL, 0x0000001b0e0c7210ULL, 0x000fe20007f1e0ffULL,
0x000000081f297824ULL, 0x000fe200078e00ffULL, 0xfffffff816237812ULL, 0x000fe200078ee223ULL,
0x000000011d1d7824ULL, 0x100fe200078e020fULL, 0x000000190e167210ULL, 0x000fe20007f3e0ffULL,
0x000000011f1f7824ULL, 0x100fe200078e020fULL, 0x00005e00181a7a11ULL, 0x000fe200078c40ffULL,
0x0000000125257824ULL, 0x100fe200078e020fULL, 0x0000001d0e197210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e06ffULL, 0x0000001f0e177210ULL, 0x000fe20007f9e0ffULL,
0x000000011e0f7824ULL, 0x000fe200078e020fULL, 0x000000250e257210ULL, 0x000fe20007fbe0ffULL,
0x00001000791c7824ULL, 0x000fe200078e00ffULL, 0x00005f00181b7a11ULL, 0x000fe200030f441bULL,
0x000000011e187824ULL, 0x000fe200078e0200ULL, 0x0000000f0e267210ULL, 0x000fe20007f7e0ffULL,
0x000000081e4b7824ULL, 0x000fe200078e00ffULL, 0x000010001c0e7812ULL, 0x000fe200078e0cffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0x00005e00161e7a11ULL, 0x000fe200078240ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e000c1c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x00005f00161f7a11ULL, 0x000fe200008f441dULL,
0x000000ffff287224ULL, 0x000fe200020e06ffULL, 0x00005f000c1d7a11ULL, 0x000fe200000f440fULL,
0x000000ffff0c7224ULL, 0x000fe200028e06ffULL, 0x00000000000f7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff4d7224ULL, 0x000fe200018e06ffULL, 0x0001300057487810ULL, 0x000fe20007ffe00eULL,
0x0000001003147825ULL, 0x000fe200078e0014ULL, 0xfffffff827247812ULL, 0x000fc400078ee224ULL,
0x00005e00250e7a11ULL, 0x000fe200078440ffULL, 0x00000010031a7825ULL, 0x000fe200078e001aULL,
0x000000070f277812ULL, 0x000fe400078ec0ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee218ULL,
0x00000010031e7825ULL, 0x000fe200078e001eULL, 0x00005e0019187a11ULL, 0x000fe400078040ffULL,
0x00005f00250f7a11ULL, 0x000fe200010f440cULL, 0x0000001021217824ULL, 0x000fe200078e0248ULL,
0x0ffffff827257812ULL, 0x000fe200078ef800ULL, 0x000000100d277824ULL, 0x000fe200078e0248ULL,
0x00005e0017167a11ULL, 0x000fe200078240ffULL, 0x00000010031c7825ULL, 0x000fe200078e001cULL,
0x00005f0019197a11ULL, 0x000fc400000f442aULL, 0x00005e00260c7a11ULL, 0x000fe200078040ffULL,
0x0000001025257824ULL, 0x000fe200078e0248ULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x0000001020297824ULL, 0x000fe200078e0248ULL, 0x00005f0017177a11ULL, 0x000fe200008f4428ULL,
0x00000010242b7824ULL, 0x000fe200078e0248ULL, 0x00005f00260d7a11ULL, 0x000fe200000f444dULL,
0x0000001003187825ULL, 0x040fe200078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014257faeULL, 0x0003e6000b901c46ULL, 0x0000001022497824ULL, 0x000fe200078e0248ULL,
0x000000001a277faeULL, 0x0003e2000b901c46ULL, 0x0000001003167825ULL, 0x000fc600078e0016ULL,
0x000000001e297faeULL, 0x0003e2000b901c46ULL, 0x0000001023237824ULL, 0x000fe400078e0248ULL,
0x00000010030e7825ULL, 0x000fe200078e000eULL, 0x000000001c217faeULL, 0x0003e6000b901c46ULL,
0x000000104b4b7824ULL, 0x000fe200078e0248ULL, 0x00000000182b7faeULL, 0x0003e2000b901c46ULL,
0x00000010030c7825ULL, 0x000fc600078e000cULL, 0x0000000016497faeULL, 0x0003e8000b901c46ULL,
0x000000000e237faeULL, 0x0003e8000b901c46ULL, 0x000000000c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000302037812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000030300780cULL, 0x000fc80003f05270ULL, 0x000000010a037807ULL, 0x000fca0004000000ULL,
0x0000000102027824ULL, 0x000fe400078e0203ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x0000005b0200720cULL, 0x000fda0003f06070ULL, 0x00000001050c8824ULL, 0x002fe400078e0202ULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000060000c0c8625ULL, 0x000fca00078e000dULL,
0x000000060c038981ULL, 0x000322000c1e1900ULL, 0xffffffe056767812ULL, 0x040fe400078ec0ffULL,
0x00000010560f7812ULL, 0x040fe400078ec0ffULL, 0x00000008560e7812ULL, 0x000fc800078ec0ffULL,
0x000000760e767210ULL, 0x000fe20007ffe00fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6080076147f8cULL, 0x0022a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01b60c00760f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c177210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60c00760f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000657824ULL, 0x000fe200078e00ffULL, 0x00000001ff627819ULL, 0x000fe20000011600ULL,
0x000000205c637824ULL, 0x000fc600078e00ffULL, 0x0000007065657812ULL, 0x000fe400078ec0ffULL,
0xffffff8063637812ULL, 0x000fe400078ec0ffULL, 0x0000000c62627812ULL, 0x000fc800078ec0ffULL,
0x00000063620c7210ULL, 0x000fca0007ffe065ULL, 0x01b000000c0e7984ULL, 0x000ea80000000800ULL,
0x01b200000c0f7984ULL, 0x0006620000000800ULL, 0x000000770e00720bULL, 0x004fe20003f1d000ULL,
0x00011a027f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c197812ULL, 0x000fe2000782c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff647224ULL, 0x000fd400078e0077ULL,
0x0000043000009947ULL, 0x000fea0003800000ULL, 0x0000005c5500720cULL, 0x000fe40003f25270ULL,
0x000000770e00720bULL, 0x000fe20003f54000ULL, 0x000119d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x000fc400010e0100ULL, 0x000000805c0d9824ULL, 0x000fe200078e0265ULL,
0x0000000e77647209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910140c7816ULL, 0x000fe200000000ffULL, 0x00000001620d9824ULL, 0x000fca00078e020dULL,
0x01b400640d009388ULL, 0x0005e20000000800ULL, 0x000000ff0c00720cULL, 0x000fda0003f25270ULL,
0x0000030000009947ULL, 0x000fea0003800000ULL, 0x80000064770c7221ULL, 0x004fe20000010000ULL,
0x000000ff14ff7812ULL, 0x000fe2000782c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00157308ULL, 0x0004ec0000000800ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x004fe20000011600ULL,
0x000119227f007947ULL, 0x000fea000b800000ULL, 0x00001f0c150c7589ULL, 0x0084e400000e0000ULL,
0x0000000c44447220ULL, 0x088fe40000410000ULL, 0x0000000c45457220ULL, 0x080fe40000410000ULL,
0x0000000c40407220ULL, 0x000fc40000410000ULL, 0x0000000c41417220ULL, 0x080fe40000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000c38387220ULL, 0x080fe40000410000ULL, 0x0000000c39397220ULL, 0x080fe40000410000ULL,
0x0000000c34347220ULL, 0x000fc40000410000ULL, 0x0000000c35357220ULL, 0x080fe40000410000ULL,
0x0000000c30307220ULL, 0x080fe40000410000ULL, 0x0000000c31317220ULL, 0x080fe40000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c10107220ULL, 0x000fc40000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0014ff7812ULL, 0x000fe2000782c0ffULL,
0x0000001504047220ULL, 0x008fd80000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000008000c7811ULL, 0x004fe200078ff0ffULL, 0x000118227f007947ULL, 0x000fea000b800000ULL,
0x00001f0c150c7589ULL, 0x0004e400000e0000ULL, 0x0000000c46467220ULL, 0x088fe40000410000ULL,
0x0000000c47477220ULL, 0x080fe40000410000ULL, 0x0000000c42427220ULL, 0x080fe40000410000ULL,
0x0000000c43437220ULL, 0x080fe40000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000c3f3f7220ULL, 0x000fc40000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe40000410000ULL, 0x0000000c36367220ULL, 0x080fe40000410000ULL,
0x0000000c37377220ULL, 0x080fe40000410000ULL, 0x0000000c32327220ULL, 0x080fe40000410000ULL,
0x0000000c33337220ULL, 0x000fc40000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000c12127220ULL, 0x080fe40000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff19ff7812ULL, 0x000fda0007826014ULL, 0x800000640e0e1221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b0e0e1820ULL, 0x000fc80000410000ULL,
0x0000000e00071308ULL, 0x000ea40000000800ULL, 0x000000070f0f1220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000000040f047221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x00005410080e7816ULL, 0x000fe20000000008ULL,
0x000116827f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e087589ULL, 0x0002a400000e0000ULL,
0x000000080f097810ULL, 0x000fe20007ffe0ffULL, 0x000116d27f007947ULL, 0x000fea000b800000ULL,
0x00001f090e097589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100f0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0000304000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fc400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x0001240000007944ULL, 0x01efea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180f0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x004fe200078e000eULL, 0x000030b000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff177424ULL, 0x000fe400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x0001239000007944ULL, 0x01afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000007005f7812ULL, 0x000fe200078ec0ffULL, 0x000000025c607824ULL, 0x040fe200078e00ffULL,
0x00000004ff6c7819ULL, 0x100fe20000011600ULL, 0x000002005c0e7824ULL, 0x00afe200078e00ffULL,
0x000000085f0c7812ULL, 0x000fe200078ef800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004600d7812ULL, 0x000fc400078ec0ffULL, 0xfffff8000e147812ULL, 0x000fe200078ec0ffULL,
0x000000080c167824ULL, 0x044fe200078e00ffULL, 0x0000000d0c0d7210ULL, 0x000fc80007ffe06cULL,
0xfffffff816617812ULL, 0x000fe400078ee20dULL, 0x00000008000d7812ULL, 0x000fc600078ec0ffULL,
0x0000001061617824ULL, 0x000fc800078e0214ULL, 0x000000070d0d7812ULL, 0x000fe200078ef800ULL,
0x011000006128783bULL, 0x000e620000000200ULL, 0x00000001ff577819ULL, 0x000fe2000001165cULL,
0x00002000586e7824ULL, 0x000fe200078e00ffULL, 0xfffffff860607812ULL, 0x000fe200078ec0ffULL,
0x000000016c0e7824ULL, 0x000fe400078e020dULL, 0x000000080d0f7824ULL, 0x000fe400078e00ffULL,
0x0000000257167824ULL, 0x000fe200078e0258ULL, 0x000000020e747810ULL, 0x040fe20007ffe0ffULL,
0x000000080d757824ULL, 0x040fe200078e00ffULL, 0x000000040e737810ULL, 0x040fe20007ffe0ffULL,
0x000000080d187824ULL, 0x000fe200078e00ffULL, 0xfffffff80f747812ULL, 0x000fe200078ee274ULL,
0x00000004570f7824ULL, 0x000fe200078e026cULL, 0x000000060e717810ULL, 0x000fe20007ffe0ffULL,
0x0000000216157824ULL, 0x000fe200078e0279ULL, 0xfffffff875757812ULL, 0x000fe200078ee20eULL,
0x000000080d1a7824ULL, 0x000fe200078e00ffULL, 0x000000020f0f7810ULL, 0x000fe20007ffe00cULL,
0x000000080c0e7824ULL, 0x000fe200078e00ffULL, 0x00013000150c7811ULL, 0x000fe200078e60ffULL,
0x0000400057167824ULL, 0x000fe200078e026eULL, 0xfffffff818737812ULL, 0x000fc400078ee273ULL,
0xfffffff81a717812ULL, 0x000fe200078ee271ULL, 0x0000001075507824ULL, 0x100fe200078e020cULL,
0x000000100d157812ULL, 0x000fe200078efcffULL, 0x00000010744c7824ULL, 0x100fe200078e020cULL,
0xfffffff80e5d7812ULL, 0x000fe200078ee20fULL, 0x0000001073487824ULL, 0x100fe400078e020cULL,
0x00000010710c7824ULL, 0x000fe200078e020cULL, 0x000000005050783bULL, 0x000ea20000004200ULL,
0x000000016c6c7824ULL, 0x000fe400078e0215ULL, 0x0000000815187824ULL, 0x040fe200078e00ffULL,
0x000000004c4c783bULL, 0x000ee20000004200ULL, 0x00000008151d7824ULL, 0x040fe200078e00ffULL,
0x000000026c6b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008151b7824ULL, 0x040fe200078e00ffULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x00000008151f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8186b7812ULL, 0x000fe200078ee26bULL, 0x0000100079187824ULL, 0x000fe200078e0216ULL,
0x000000000c0c783bULL, 0x000fe20000004200ULL, 0x000000046c6a7810ULL, 0x040fe20007ffe0ffULL,
0x000000105d5d7824ULL, 0x000fe200078e0214ULL, 0x000000066c687810ULL, 0x000fe20007ffe0ffULL,
0x0000000828280231ULL, 0x082fe200003400ffULL, 0x0001300018197810ULL, 0x000fe20007ffe0ffULL,
0x000000082a2a0231ULL, 0x080fe200003400ffULL, 0xfffffff81d6a7812ULL, 0x000fe200078ee26aULL,
0x011000005d14783bULL, 0x000e620000000200ULL, 0xfffffff81b6c7812ULL, 0x000fe200078ee26cULL,
0x000000106b247824ULL, 0x100fe200078e0219ULL, 0xfffffff81f687812ULL, 0x000fe200078ee268ULL,
0x000000106a207824ULL, 0x100fe200078e0219ULL, 0x0000000929290231ULL, 0x080fe200003400ffULL,
0x000000106c1c7824ULL, 0x100fe200078e0219ULL, 0x000000092b2b0231ULL, 0x000fe200003400ffULL,
0x0000001068197824ULL, 0x000fe200078e0219ULL, 0x000000002424783bULL, 0x000e680000004200ULL,
0x000000002020783bULL, 0x000e680000004200ULL, 0x000000001c1c783bULL, 0x000e620000004200ULL,
0x000000502844723cULL, 0x044fe60000041844ULL, 0x000000001918783bULL, 0x000eaa0000004200ULL,
0x000000522840723cULL, 0x040ff00000041840ULL, 0x0000004c283c723cULL, 0x008f62000004183cULL,
0x0000000814140231ULL, 0x002fc400003400ffULL, 0x0000000816160231ULL, 0x000fca00003400ffULL,
0x0000004e2838723cULL, 0x000f620000041838ULL, 0x0000000915150231ULL, 0x080fe400003400ffULL,
0x0000000917170231ULL, 0x000fca00003400ffULL, 0x000000482834723cULL, 0x040f700000041834ULL,
0x0000004a2830723cULL, 0x040f700000041830ULL, 0x0000000c282c723cULL, 0x040f70000004182cULL,
0x0000000e2810723cULL, 0x000f700000041810ULL, 0x00000024143c723cULL, 0x060b70000004183cULL,
0x000000261438723cULL, 0x040b700000041838ULL, 0x000000201434723cULL, 0x040b700000041834ULL,
0x000000221430723cULL, 0x040b700000041830ULL, 0x0000001c1444723cULL, 0x040b700000041844ULL,
0x0000001e1440723cULL, 0x040b700000041840ULL, 0x00000018142c723cULL, 0x044b70000004182cULL,
0x0000001a1410723cULL, 0x000b620000041810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000405e0d7811ULL, 0x000fe200078e40ffULL, 0x01b6880060ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff777224ULL, 0x000fe200078e0064ULL, 0x0000000179797812ULL, 0x000fc400078e0cffULL,
0x0000005a0d00720cULL, 0x000fda0003f06070ULL, 0x000054a000000947ULL, 0x000fea0003800000ULL,
0x000000105c0c7824ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe00c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000580003037a24ULL, 0x010fe200078e02ffULL,
0x000000015e0c7810ULL, 0x000fc60007ffe0ffULL, 0x000001005e0d7824ULL, 0x000fe200078e020dULL,
0x000000590c00720cULL, 0x000fe20003f06070ULL, 0x0000004003037824ULL, 0x000fc600078e00ffULL,
0x000000800d0e7810ULL, 0x000fc80007ffe0ffULL, 0x000000200b0f7812ULL, 0x000fca00078ef80eULL,
0x0000077000008947ULL, 0x000fea0003800000ULL, 0x000020005c0c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff277819ULL, 0x020fe20000011600ULL, 0x0000000858287824ULL, 0x000fe200078e00ffULL,
0x0000000e5a0d7217ULL, 0x000fe40007800000ULL, 0x000020000c147812ULL, 0x000fe200078ec0ffULL,
0x00001000060c7824ULL, 0x000fe200078e00ffULL, 0x0000000427157810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a0eULL, 0x0000000827177810ULL, 0x000fe20007ffe0ffULL,
0x0000400057577824ULL, 0x000fe200078e0214ULL, 0x000010000c207812ULL, 0x000fe200078ec0ffULL,
0x0000000115217824ULL, 0x100fe200078e0200ULL, 0x000000200d227817ULL, 0x000fe20003800000ULL,
0x00000008150e7824ULL, 0x000fe200078e00ffULL, 0x0000001027257810ULL, 0x040fe20007ffe0ffULL,
0x00000001270c7824ULL, 0x000fe200078e020fULL, 0x000000221500720cULL, 0x000fe20003f46070ULL,
0x0000000117237824ULL, 0x040fe200078e0200ULL, 0xfffffff80e217812ULL, 0x000fe200078ee221ULL,
0x0000000817147824ULL, 0x000fe200078e00ffULL, 0x0000000c030e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001150c7824ULL, 0x100fe200078e020fULL, 0x0000000c27157810ULL, 0x000fe20007ffe0ffULL,
0x0000000125167824ULL, 0x000fe200078e020fULL, 0xfffffff814237812ULL, 0x000fe200078ee223ULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005e000e1e7a11ULL, 0x040fe200078040ffULL,
0x0000000115147824ULL, 0x000fe200078e020fULL, 0x0000001603167210ULL, 0x000fe20007fbe0ffULL,
0x00000008152b7824ULL, 0x000fe200078e00ffULL, 0x00005f000e1f7a11ULL, 0x000fe200000f440dULL,
0x00000001170e7824ULL, 0x000fe200078e020fULL, 0x0000000c030d7210ULL, 0x000fc40007f1e0ffULL,
0x0000001403147210ULL, 0x040fe40007f9e0ffULL, 0x0000000e030e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff197224ULL, 0x000fe200020e06ffULL, 0x0000001427497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e06ffULL, 0x00005f000d0d7a11ULL, 0x000fe400000f4418ULL,
0x00005e000e1c7a11ULL, 0x000fc400078040ffULL, 0x00005e00141a7a11ULL, 0x000fe400078640ffULL,
0x000000221700720cULL, 0x000fe20003f26070ULL, 0x000000ffff177224ULL, 0x000fe200028e06ffULL,
0x00005f000e1d7a11ULL, 0x000fe200000f441bULL, 0x00000001490e7824ULL, 0x000fe200078e020fULL,
0x00005e0016187a11ULL, 0x000fe400078840ffULL, 0x00005f00141b7a11ULL, 0x000fe400018f4419ULL,
0x00000018274b7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c274d7810ULL, 0x040fe40007ffe0ffULL,
0x000000222700720cULL, 0x040fe20003f66070ULL, 0x0000000127277824ULL, 0x000fe200078e0200ULL,
0x00005f0016197a11ULL, 0x000fe200020f4417ULL, 0x000000014d147824ULL, 0x100fe200078e020fULL,
0x0000000e03177210ULL, 0x000fe20007f1e0ffULL, 0x000000014b0e7824ULL, 0x000fe200078e020fULL,
0x0000000727277812ULL, 0x000fe400078ec0ffULL, 0x00000014030f7210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x0000000e03267210ULL, 0x000fc40007f9e0ffULL,
0x0001300057207810ULL, 0x000fe40007ffe020ULL, 0x00005e0017167a11ULL, 0x000fe200078040ffULL,
0x000000ffff297224ULL, 0x000fe200020e06ffULL, 0x0ffffff827277812ULL, 0x000fe200078ef800ULL,
0x0000001021217824ULL, 0x000fe200078e0220ULL, 0x0000000828037812ULL, 0x000fe200078ee25fULL,
0x0000000115287824ULL, 0x000fe200078e0200ULL, 0x00005f0017177a11ULL, 0x000fe200000f4424ULL,
0x0000001027277824ULL, 0x000fe200078e0220ULL, 0x00005e0026147a11ULL, 0x000fe200078840ffULL,
0x000000ffff247224ULL, 0x000fe200028e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078a40ffULL,
0x00000010031e7825ULL, 0x000fe200078e001eULL, 0x000000221500720cULL, 0x000fc40003f06070ULL,
0x00005f0026157a11ULL, 0x000fe200020f4429ULL, 0x000000014b267824ULL, 0x000fe200078e0200ULL,
0x00005f000f0f7a11ULL, 0x000fe200028f4424ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e277faeULL, 0x0003e2000d901c46ULL, 0x000000222500720cULL, 0x080fe20003f66070ULL,
0x0000000149247824ULL, 0x140fe200078e0200ULL, 0x000000224900720cULL, 0x0c0fe20003f86070ULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x000000224b00720cULL, 0x0c0fe20003fa6070ULL,
0x000000084b297824ULL, 0x000fe200078e00ffULL, 0x000000224d00720cULL, 0x000fe20003fc6070ULL,
0x0000000125227824ULL, 0x000fe200078e0200ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee228ULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee226ULL,
0x000000014d1e7824ULL, 0x002fe200078e0200ULL, 0xfffffff849277812ULL, 0x000fe200078ee224ULL,
0x000000084d4d7824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee222ULL,
0x00000010030c7825ULL, 0x000fc600078e000cULL, 0xfffffff84d497812ULL, 0x000fe200078ee21eULL,
0x0000001023237824ULL, 0x000fe200078e0220ULL, 0x000000000c217faeULL, 0x0003e2000d101c46ULL,
0x00000010031c7825ULL, 0x000fc800078e001cULL, 0x000000102b1f7824ULL, 0x000fe200078e0220ULL,
0x000000001c237faeULL, 0x0003e2000c901c46ULL, 0x00000010031a7825ULL, 0x000fc800078e001aULL,
0x0000001025257824ULL, 0x000fe200078e0220ULL, 0x000000001a1f7faeULL, 0x0003e2000c101c46ULL,
0x0000001003187825ULL, 0x000fc800078e0018ULL, 0x0000001027277824ULL, 0x000fe200078e0220ULL,
0x0000000018257faeULL, 0x0003e2000d901c46ULL, 0x0000001003167825ULL, 0x000fc800078e0016ULL,
0x0000001029297824ULL, 0x000fe200078e0220ULL, 0x0000000016277faeULL, 0x0003e2000e101c46ULL,
0x0000001003147825ULL, 0x000fc800078e0014ULL, 0x00000010492b7824ULL, 0x000fe200078e0220ULL,
0x0000000014297faeULL, 0x0003e2000e901c46ULL, 0x00000010030e7825ULL, 0x000fca00078e000eULL,
0x000000000e2b7faeULL, 0x0003e2000f101c46ULL, 0x000006a000007947ULL, 0x000fea0003800000ULL,
0x000020005c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000800147811ULL, 0x020fe200078fe8ffULL,
0x00000008582a7824ULL, 0x000fe200078e00ffULL, 0x0000000c00157811ULL, 0x000fe400078fe8ffULL,
0x000020000c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000114247824ULL, 0x000fe200078e0200ULL,
0x00000004000e7811ULL, 0x000fe200078fe8ffULL, 0x00000008140d7824ULL, 0x000fe200078e00ffULL,
0x00000018001a7811ULL, 0x040fe200078fe8ffULL, 0x0000400057577824ULL, 0x000fe200078e020cULL,
0x0000000f000c7211ULL, 0x000fe200078fe8ffULL, 0x0000000115237824ULL, 0x000fe200078e0200ULL,
0xfffffff80d247812ULL, 0x000fe200078ee224ULL, 0x0000000815187824ULL, 0x000fe200078e00ffULL,
0x0000000c030c7210ULL, 0x000fe20007f1e0ffULL, 0x000000010e257824ULL, 0x100fe200078e0200ULL,
0x000000082a4d7812ULL, 0x000fe200078ee25fULL, 0x000000080e167824ULL, 0x000fe200078e00ffULL,
0xfffffff818237812ULL, 0x000fe200078ee223ULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x0000001400187811ULL, 0x000fe200078fe8ffULL, 0x000000011a207824ULL, 0x100fe200078e0200ULL,
0xfffffff816257812ULL, 0x000fe200078ee225ULL, 0x000000081a197824ULL, 0x000fe200078e00ffULL,
0x00005e000c1e7a11ULL, 0x000fe200078040ffULL, 0x0000000118217824ULL, 0x100fe200078e0200ULL,
0x0000001000167811ULL, 0x000fe200078fe8ffULL, 0x00000008181c7824ULL, 0x000fe200078e00ffULL,
0x00005f000c1f7a11ULL, 0x000fe200000f440dULL, 0x000000010e0c7824ULL, 0x000fe200078e020fULL,
0x0000001c000d7811ULL, 0x000fe200078fe8ffULL, 0x0000000116227824ULL, 0x000fe200078e0200ULL,
0xfffffff81c217812ULL, 0x000fe200078ee221ULL, 0x0000000816177824ULL, 0x000fe200078e00ffULL,
0xfffffff819207812ULL, 0x000fe200078ee220ULL, 0x00000001140e7824ULL, 0x000fc400078e020fULL,
0x0000000115147824ULL, 0x100fe200078e020fULL, 0xfffffff817227812ULL, 0x000fe200078ee222ULL,
0x0000000116167824ULL, 0x100fe200078e020fULL, 0x0000000e03197210ULL, 0x040fe20007f7e0ffULL,
0x0000000118187824ULL, 0x100fe200078e020fULL, 0x0000001403147210ULL, 0x040fe20007f1e0ffULL,
0x000000011a1a7824ULL, 0x100fe200078e020fULL, 0x0000001603167210ULL, 0x000fe20007f3e0ffULL,
0x000000010d1c7824ULL, 0x000fe200078e020fULL, 0x0000001803157210ULL, 0x000fe20007f5e0ffULL,
0x000000010d0f7824ULL, 0x000fc400078e0200ULL, 0x000000080d267824ULL, 0x000fe200078e00ffULL,
0x0000000c030d7210ULL, 0x000fe20007f9e0ffULL, 0x0000100006177824ULL, 0x000fe400078e00ffULL,
0x000000104d1e7825ULL, 0x000fe200078e001eULL, 0x00005e000d0c7a11ULL, 0x000fe400078c40ffULL,
0x0000100017287812ULL, 0x000fe200078ec0ffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x0000001a030e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x00005e00141a7a11ULL, 0x000fc400078040ffULL, 0xfffffff8264b7812ULL, 0x000fe200078ee20fULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x0000001c03037210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0x00005f000d0d7a11ULL, 0x000fe400030f4418ULL,
0x00005e00191c7a11ULL, 0x000fe400078640ffULL, 0x00005f00141b7a11ULL, 0x000fe200000f4417ULL,
0x000000104d0c7825ULL, 0x000fe200078e000cULL, 0x00005e0016187a11ULL, 0x000fc400078240ffULL,
0x0000000000177211ULL, 0x000fe200078fe8ffULL, 0x000000104d1a7825ULL, 0x000fe200078e001aULL,
0x00005f00191d7a11ULL, 0x000fe400018f4426ULL, 0x00005f0016197a11ULL, 0x000fe200008f440fULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x0000000717277812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e06ffULL, 0x00005e0015167a11ULL, 0x000fe200078040ffULL,
0x000000104d1c7825ULL, 0x000fe200078e001cULL, 0x00005e000e147a11ULL, 0x000fc400078240ffULL,
0x0001300057287810ULL, 0x000fe20007ffe028ULL, 0x000000104d187825ULL, 0x000fe200078e0018ULL,
0x0ffffff827277812ULL, 0x000fe400078ef800ULL, 0x00005f0015177a11ULL, 0x000fe200000f4426ULL,
0x000000ffff267224ULL, 0x000fe200028e06ffULL, 0x00005f000e157a11ULL, 0x000fe200008f440fULL,
0x0000001027277824ULL, 0x100fe200078e0228ULL, 0x00005e00030e7a11ULL, 0x000fe200078040ffULL,
0x0000001025257824ULL, 0x100fe400078e0228ULL, 0x0000001024297824ULL, 0x000fe200078e0228ULL,
0x00005f00030f7a11ULL, 0x000fe200000f4426ULL, 0x0000001023237824ULL, 0x100fe200078e0228ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e277faeULL, 0x0003e2000b901c46ULL,
0x00000010222b7824ULL, 0x000fc400078e0228ULL, 0x0000001021217824ULL, 0x000fe200078e0228ULL,
0x000000000c257faeULL, 0x0003e2000b901c46ULL, 0x000000104d167825ULL, 0x000fc600078e0016ULL,
0x000000001c297faeULL, 0x0003e2000b901c46ULL, 0x0000001020497824ULL, 0x000fe400078e0228ULL,
0x000000104d147825ULL, 0x000fe200078e0014ULL, 0x000000001a237faeULL, 0x0003e6000b901c46ULL,
0x000000104b4b7824ULL, 0x000fe200078e0228ULL, 0x00000000182b7faeULL, 0x0003e2000b901c46ULL,
0x000000104d0e7825ULL, 0x000fc600078e000eULL, 0x0000000016217faeULL, 0x0003e8000b901c46ULL,
0x0000000014497faeULL, 0x0003e8000b901c46ULL, 0x000000000e4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000302037812ULL, 0x000fc800078ec0ffULL, 0x000000030300780cULL, 0x000fc80003f05270ULL,
0x000000010a037807ULL, 0x000fca0004000000ULL, 0x0000000102027824ULL, 0x000fe400078e0203ULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x0000005b0200720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00000001050c7824ULL, 0x002fe400078e0202ULL,
0x00000004ff0d7424ULL, 0x000fc800078e00ffULL, 0x000060000c0c7625ULL, 0x000fca00078e000dULL,
0x000000060c037981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b62800760c7f8cULL, 0x0022a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01b62c0076157984ULL, 0x000ee40000000800ULL,
0x8000000015ff7812ULL, 0x00cfe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140e177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0fULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b62c0076157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000080650d7810ULL, 0x000fca0007ffe063ULL,
0x00000001620d7824ULL, 0x000fca00078e020dULL, 0x01b000000d0f7984ULL, 0x000ea80000000800ULL,
0x01b200000d0e7984ULL, 0x0006620000000800ULL, 0x000000640f00720bULL, 0x004fe20003f1d000ULL,
0x0000fd427f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c197812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff777224ULL, 0x000fd400078e0064ULL,
0x0000044000009947ULL, 0x000fea0003800000ULL, 0x00000001550d7810ULL, 0x000fe40007ffe0ffULL,
0x000000640f00720bULL, 0x000fe40003f54000ULL, 0x0000005c0d00720cULL, 0x000fe20003f25270ULL,
0x0000fd027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000147806ULL, 0x000fc400010e0100ULL,
0x000000805c0d9824ULL, 0x000fe200078e0265ULL, 0x000000640f777209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910140c7816ULL, 0x000fe200000000ffULL,
0x0000000162169824ULL, 0x000fca00078e020dULL, 0x01b4007716009388ULL, 0x0005e20000000800ULL,
0x000000ff0c00720cULL, 0x000fda0003f25270ULL, 0x0000030000009947ULL, 0x000fea0003800000ULL,
0x00000064770c7221ULL, 0x004fe20000010100ULL, 0x000000ff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00157308ULL, 0x000ea40000000800ULL, 0x0000001504047220ULL, 0x004fc80000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011600ULL,
0x0000fc427f007947ULL, 0x000fea000b800000ULL, 0x00001f0c150c7589ULL, 0x0004e400000e0000ULL,
0x0000000c44447220ULL, 0x088fe40000410000ULL, 0x0000000c45457220ULL, 0x080fe40000410000ULL,
0x0000000c40407220ULL, 0x080fe40000410000ULL, 0x0000000c41417220ULL, 0x080fe40000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000c3d3d7220ULL, 0x000fc40000410000ULL,
0x0000000c38387220ULL, 0x080fe40000410000ULL, 0x0000000c39397220ULL, 0x080fe40000410000ULL,
0x0000000c34347220ULL, 0x080fe40000410000ULL, 0x0000000c35357220ULL, 0x080fe40000410000ULL,
0x0000000c30307220ULL, 0x080fe40000410000ULL, 0x0000000c31317220ULL, 0x000fc40000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c10107220ULL, 0x080fe40000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0014ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x000fe200078ff0ffULL,
0x0000fb527f007947ULL, 0x000fea000b800000ULL, 0x00001f0c150c7589ULL, 0x0006a400000e0000ULL,
0x0000000c46467220ULL, 0x084fe40000410000ULL, 0x0000000c47477220ULL, 0x080fe40000410000ULL,
0x0000000c42427220ULL, 0x080fe40000410000ULL, 0x0000000c43437220ULL, 0x080fe40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe40000410000ULL,
0x0000000c36367220ULL, 0x080fe40000410000ULL, 0x0000000c37377220ULL, 0x080fe40000410000ULL,
0x0000000c32327220ULL, 0x080fe40000410000ULL, 0x0000000c33337220ULL, 0x000fc40000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000c12127220ULL, 0x080fe40000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff19ff7812ULL, 0x000fda0007826014ULL,
0x0000000f770f1221ULL, 0x000fe20000010100ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0f0f1820ULL, 0x000fc80000410000ULL, 0x0000000f00071308ULL, 0x000ea40000000800ULL,
0x000000070e0e1220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000040e047221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000010ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00005410080e7816ULL, 0x000fe20000000008ULL, 0x0000f9b27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e087589ULL, 0x0002a400000e0000ULL, 0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000fa027f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0e097589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200078e000eULL, 0x00004fb000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff177424ULL, 0x000fc400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x0001049000007944ULL, 0x01cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x004fe200078e000eULL,
0x0000502000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fe400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x0001042000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000100006787824ULL, 0x000fe200078e00ffULL, 0x00000001ff577819ULL, 0x000fe2000001165cULL,
0x011800006124783bULL, 0x000e660000000200ULL, 0x0000100078787812ULL, 0x000fe200078e0cffULL,
0x00000002570d7824ULL, 0x000fc400078e0258ULL, 0x0000400057157824ULL, 0x008fe400078e026eULL,
0x000020000d0c7824ULL, 0x002fc600078e0078ULL, 0x0001300015157810ULL, 0x000fe40007ffe078ULL,
0x000130000c0c7810ULL, 0x000fc60007ffe0ffULL, 0x000000106c697824ULL, 0x100fe400078e0215ULL,
0x0000001075727824ULL, 0x100fe400078e020cULL, 0x0000001074707824ULL, 0x100fe200078e020cULL,
0x000000006920783bULL, 0x000fe20000004200ULL, 0x00000010736f7824ULL, 0x100fe400078e020cULL,
0x00000010716d7824ULL, 0x000fe200078e020cULL, 0x000000007250783bULL, 0x000e620000004200ULL,
0x000000106b677824ULL, 0x000fc400078e0215ULL, 0x000000106a667824ULL, 0x100fe200078e0215ULL,
0x00000000704c783bULL, 0x000ee20000004200ULL, 0x0000001068647824ULL, 0x000fc600078e0215ULL,
0x000000006f48783bULL, 0x000fe80000004200ULL, 0x000000006d28783bULL, 0x000fe20000004200ULL,
0x0000000824240231ULL, 0x004fc600003400ffULL, 0x011800005d0c783bULL, 0x000ea20000000200ULL,
0x0000000826260231ULL, 0x000fe400003400ffULL, 0x0000000925250231ULL, 0x080fe200003400ffULL,
0x00000000671c783bULL, 0x000ea20000004200ULL, 0x0000000927270231ULL, 0x000fc600003400ffULL,
0x000000006618783bULL, 0x000ea80000004200ULL, 0x000000006414783bULL, 0x000ea20000004200ULL,
0x000000502444723cULL, 0x042f700000041844ULL, 0x000000522440723cULL, 0x040f700000041840ULL,
0x0000004c243c723cULL, 0x008f62000004183cULL, 0x000000080c0c0231ULL, 0x004fc400003400ffULL,
0x000000080e0e0231ULL, 0x000fe400003400ffULL, 0x000000090d0d0231ULL, 0x080fe400003400ffULL,
0x000000090f0f0231ULL, 0x000fe200003400ffULL, 0x0000004e2438723cULL, 0x040f700000041838ULL,
0x000000482434723cULL, 0x040f700000041834ULL, 0x0000004a2430723cULL, 0x040f700000041830ULL,
0x00000028242c723cULL, 0x040f70000004182cULL, 0x0000002a2410723cULL, 0x000f700000041810ULL,
0x000000200c44723cULL, 0x060b700000041844ULL, 0x000000220c40723cULL, 0x040b700000041840ULL,
0x0000001c0c3c723cULL, 0x040b70000004183cULL, 0x0000001e0c38723cULL, 0x040b700000041838ULL,
0x000000180c34723cULL, 0x040b700000041834ULL, 0x0000001a0c30723cULL, 0x040b700000041830ULL,
0x000000140c2c723cULL, 0x040b70000004182cULL, 0x000000160c10723cULL, 0x000b620000041810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000805e0d7811ULL, 0x020fe200078e40ffULL,
0x01b6900060ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000106797812ULL, 0x000fc400078ec0ffULL,
0x0000005a0d00720cULL, 0x000fda0003f06070ULL, 0x0000380000000947ULL, 0x000fea0003800000ULL,
0x000000105c0c7824ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe00c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000580003037a24ULL, 0x010fe200078e02ffULL,
0x000000015e0c7810ULL, 0x000fc60007ffe0ffULL, 0x000001005e0d7824ULL, 0x000fe200078e020dULL,
0x000000590c00720cULL, 0x000fe20003f06070ULL, 0x0000004003037824ULL, 0x000fc600078e00ffULL,
0x000000c00d0f7810ULL, 0x000fc80007ffe0ffULL, 0x000000200b0d7812ULL, 0x000fca00078ef80fULL,
0x0000075000008947ULL, 0x000fea0003800000ULL, 0x000020005c0e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff157819ULL, 0x100fe20000011600ULL, 0x0000000858267824ULL, 0x000fe200078e00ffULL,
0x0000000f5a0c7217ULL, 0x000fe40007800000ULL, 0x000020000e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000115247824ULL, 0x040fe200078e0200ULL, 0x0000000415177810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0fULL, 0x0000000815197810ULL, 0x000fe20007ffe0ffULL,
0x0000400057577824ULL, 0x000fe200078e020eULL, 0x0000001015257810ULL, 0x040fe20007ffe0ffULL,
0x00000001150e7824ULL, 0x100fe200078e020dULL, 0x000000200c207817ULL, 0x000fe20003800000ULL,
0x00000001170c7824ULL, 0x000fe200078e020dULL, 0x0000001415277810ULL, 0x000fe20007ffe0ffULL,
0x0000000117217824ULL, 0x100fe200078e0200ULL, 0x0000000e030e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000817147824ULL, 0x040fe200078e00ffULL, 0x000000201700720cULL, 0x080fe20003f46070ULL,
0x0000000119237824ULL, 0x040fe200078e0200ULL, 0x000000201900720cULL, 0x000fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e000e1e7a11ULL, 0x000fc400078040ffULL,
0xfffffff814217812ULL, 0x000fe200078ee221ULL, 0x0000000819147824ULL, 0x000fe200078e00ffULL,
0x00005f000e1f7a11ULL, 0x000fe400000f440fULL, 0x0000000c03167210ULL, 0x000fe20007f1e0ffULL,
0x00000001190c7824ULL, 0x000fe200078e020dULL, 0x0000000c150f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff814237812ULL, 0x000fe200078ee223ULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x0000000c030c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010f0e7824ULL, 0x100fe200078e020dULL,
0x00005e00161c7a11ULL, 0x040fe200078040ffULL, 0x0000000125147824ULL, 0x000fe200078e020dULL,
0x00000018152b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e06ffULL,
0x00005f00161d7a11ULL, 0x000fe200000f4417ULL, 0x000000080f4d7824ULL, 0x000fe200078e00ffULL,
0x0000000e030e7210ULL, 0x000fc40007f9e0ffULL, 0x00005e000c1a7a11ULL, 0x040fe400078040ffULL,
0x0000001403147210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff197224ULL, 0x000fe200020e06ffULL,
0x00005f000c1b7a11ULL, 0x000fe200000f441bULL, 0x00000001270c7824ULL, 0x000fe200078e020dULL,
0x00005e000e187a11ULL, 0x040fe200078640ffULL, 0x000000ffff177224ULL, 0x000fe200028e06ffULL,
0x0000001c15297810ULL, 0x000fe40007ffe0ffULL, 0x00005f000e197a11ULL, 0x000fc400018f4419ULL,
0x0000000c03227210ULL, 0x000fe20007f1e0ffULL, 0x000000012b0c7824ULL, 0x100fe200078e020dULL,
0x00005e0014167a11ULL, 0x000fe200078840ffULL, 0x00000001290e7824ULL, 0x000fe200078e020dULL,
0x0000000724497812ULL, 0x000fe400078ec0ffULL, 0x000000201500720cULL, 0x000fe20003f66070ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005f0014177a11ULL, 0x000fe400020f4417ULL,
0x0000000c03247210ULL, 0x000fc40007f9e0ffULL, 0x0000000e030d7210ULL, 0x000fe40007fbe0ffULL,
0x0001300057787810ULL, 0x000fe20007ffe078ULL, 0x000000ffff4b7224ULL, 0x000fe200020e06ffULL,
0x00005e0022147a11ULL, 0x000fe400078040ffULL, 0x0ffffff849497812ULL, 0x000fe200078ef800ULL,
0x0000001021217824ULL, 0x000fe200078e0278ULL, 0x0000000826037812ULL, 0x000fe200078ee25fULL,
0x000000010f267824ULL, 0x000fe200078e0200ULL, 0x00005f0022157a11ULL, 0x000fe200000f4415ULL,
0x0000001049497824ULL, 0x000fe200078e0278ULL, 0x00005e00240e7a11ULL, 0x000fe200078840ffULL,
0x000000ffff227224ULL, 0x000fe200028e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078a40ffULL,
0x00000010031e7825ULL, 0x000fe200078e001eULL, 0x000000200f00720cULL, 0x000fc40003f06070ULL,
0x00005f00240f7a11ULL, 0x000fe200020f444bULL, 0x000000012b247824ULL, 0x000fe200078e0200ULL,
0x00005f000d0d7a11ULL, 0x000fe200028f4422ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e497faeULL, 0x0003e2000d901c46ULL, 0x000000202500720cULL, 0x080fe20003f66070ULL,
0x0000000127227824ULL, 0x140fe200078e0200ULL, 0x000000202700720cULL, 0x0c0fe20003f86070ULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x000000202b00720cULL, 0x0c0fe20003fa6070ULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x000000202900720cULL, 0x000fe20003fc6070ULL,
0x0000000125207824ULL, 0x000fe200078e0200ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee226ULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee222ULL,
0x00000001291e7824ULL, 0x002fc400078e0200ULL, 0x00000008291f7824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee220ULL, 0x00000010031c7825ULL, 0x000fe200078e001cULL,
0xfffffff82b297812ULL, 0x000fe400078ee224ULL, 0xfffffff81f2b7812ULL, 0x000fe200078ee21eULL,
0x0000001023237824ULL, 0x000fe200078e0278ULL, 0x000000001c217faeULL, 0x0003e2000d101c46ULL,
0x00000010031a7825ULL, 0x000fc800078e001aULL, 0x000000104d1f7824ULL, 0x000fe200078e0278ULL,
0x000000001a237faeULL, 0x0003e2000c901c46ULL, 0x0000001003187825ULL, 0x000fc800078e0018ULL,
0x0000001025257824ULL, 0x000fe200078e0278ULL, 0x00000000181f7faeULL, 0x0003e2000c101c46ULL,
0x0000001003167825ULL, 0x000fc800078e0016ULL, 0x0000001027277824ULL, 0x000fe200078e0278ULL,
0x0000000016257faeULL, 0x0003e2000d901c46ULL, 0x0000001003147825ULL, 0x000fc800078e0014ULL,
0x0000001029297824ULL, 0x000fe200078e0278ULL, 0x0000000014277faeULL, 0x0003e2000e101c46ULL,
0x00000010030e7825ULL, 0x000fc800078e000eULL, 0x000000102b2b7824ULL, 0x000fe200078e0278ULL,
0x000000000e297faeULL, 0x0003e2000e901c46ULL, 0x00000010030c7825ULL, 0x000fca00078e000cULL,
0x000000000c2b7faeULL, 0x0003e2000f101c46ULL, 0x0000068000007947ULL, 0x000fea0003800000ULL,
0x000020005c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000c00157811ULL, 0x000fe200078fe8ffULL,
0x00000008582a7824ULL, 0x000fe200078e00ffULL, 0x0000000800147811ULL, 0x000fe400078fe8ffULL,
0x000020000c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000115247824ULL, 0x040fe200078e0200ULL,
0x00000004000e7811ULL, 0x040fe200078fe8ffULL, 0x00000008150f7824ULL, 0x000fe200078e00ffULL,
0x00000014001a7811ULL, 0x040fe200078fe8ffULL, 0x0000400057577824ULL, 0x000fe200078e020cULL,
0x0000000d000c7211ULL, 0x000fe200078fe8ffULL, 0x0000000114237824ULL, 0x040fe200078e0200ULL,
0xfffffff80f247812ULL, 0x000fe200078ee224ULL, 0x0000000814187824ULL, 0x000fe200078e00ffULL,
0x0000000c030c7210ULL, 0x000fe20007f1e0ffULL, 0x000000010e257824ULL, 0x100fe200078e0200ULL,
0x00000018001c7811ULL, 0x000fe200078fe8ffULL, 0x000000080e167824ULL, 0x000fe200078e00ffULL,
0xfffffff818237812ULL, 0x000fe200078ee223ULL, 0x000000011a207824ULL, 0x100fe200078e0200ULL,
0x00000000001f7211ULL, 0x000fe200078fe8ffULL, 0x000000081a197824ULL, 0x000fe200078e00ffULL,
0xfffffff816257812ULL, 0x000fe200078ee225ULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e000c187a11ULL, 0x000fe200078040ffULL, 0x000000011c1b7824ULL, 0x040fe200078e0200ULL,
0xfffffff819207812ULL, 0x000fe200078ee220ULL, 0x000000081c1e7824ULL, 0x000fe200078e00ffULL,
0x0000001000167811ULL, 0x000fe200078fe8ffULL, 0x000000011a1a7824ULL, 0x000fe200078e020dULL,
0x00005f000c197a11ULL, 0x000fe200000f440fULL, 0x000000010e0c7824ULL, 0x100fe200078e020dULL,
0x0000001c000f7811ULL, 0x000fe200078fe8ffULL, 0x00000001140e7824ULL, 0x000fe200078e020dULL,
0xfffffff81e1b7812ULL, 0x000fe200078ee21bULL, 0x0000000116227824ULL, 0x040fe200078e0200ULL,
0x0000000c030c7210ULL, 0x040fe20007f9e0ffULL, 0x0000000816177824ULL, 0x040fe200078e00ffULL,
0x0000001a031d7210ULL, 0x000fe20007f5e0ffULL, 0x0000000115147824ULL, 0x100fe200078e020dULL,
0x0000000e03157210ULL, 0x000fe20007f7e0ffULL, 0x0000000116167824ULL, 0x100fe200078e020dULL,
0xfffffff817227812ULL, 0x000fe200078ee222ULL, 0x000000010f267824ULL, 0x100fe200078e020dULL,
0x000000071f297812ULL, 0x000fe200078ec0ffULL, 0x000000010f277824ULL, 0x000fe200078e0200ULL,
0x0001300057787810ULL, 0x000fe20007ffe078ULL, 0x000000080f1e7824ULL, 0x000fe200078e00ffULL,
0x00000014030f7210ULL, 0x040fe20007f1e0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e020dULL,
0x00000016030d7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e06ffULL,
0x00005e000c167a11ULL, 0x000fe200078c40ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0xfffffff81e277812ULL, 0x000fe200078ee227ULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0x0000001c031a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078640ffULL, 0x000000101b4b7824ULL, 0x100fe200078e0278ULL,
0x00005f000c177a11ULL, 0x000fe200030f4417ULL, 0x0000001023237824ULL, 0x100fe200078e0278ULL,
0x00005e000f0e7a11ULL, 0x000fe200078040ffULL, 0x00000010222b7824ULL, 0x100fe200078e0278ULL,
0x00005e000d0c7a11ULL, 0x000fe200078240ffULL, 0x0000001020497824ULL, 0x000fe200078e0278ULL,
0x00005f0015157a11ULL, 0x000fe200018f4428ULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x0000002603267210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff037224ULL, 0x000fe200020e06ffULL,
0x00005f000f0f7a11ULL, 0x000fe200000f441eULL, 0x0000001027277824ULL, 0x000fe200078e0278ULL,
0x00005f000d0d7a11ULL, 0x000fe200008f441cULL, 0x000000ffff4d7224ULL, 0x000fe200028e06ffULL,
0x00005e001d1e7a11ULL, 0x000fc400078040ffULL, 0x00005e001a1c7a11ULL, 0x000fe400078240ffULL,
0x000000082a217812ULL, 0x000fe400078ee25fULL, 0x0ffffff829297812ULL, 0x000fe400078ef800ULL,
0x00005f001d1f7a11ULL, 0x000fe200000f4428ULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x00005f001a1d7a11ULL, 0x000fe400008f4403ULL, 0x00005e00261a7a11ULL, 0x000fe200078040ffULL,
0x0000001029297824ULL, 0x000fc400078e0278ULL, 0x0000001025037824ULL, 0x000fe200078e0278ULL,
0x00005f00261b7a11ULL, 0x000fe200000f444dULL, 0x0000001021167825ULL, 0x040fe200078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018297faeULL, 0x0003e6000b901c46ULL,
0x0000001021147825ULL, 0x040fe200078e0014ULL, 0x0000000016037faeULL, 0x0003e6000b901c46ULL,
0x0000001024257824ULL, 0x000fe200078e0278ULL, 0x0000000014237faeULL, 0x0003e2000b901c46ULL,
0x00000010210e7825ULL, 0x000fc800078e000eULL, 0x00000010210c7825ULL, 0x040fe200078e000cULL,
0x000000000e257faeULL, 0x0003e6000b901c46ULL, 0x00000010211e7825ULL, 0x040fe200078e001eULL,
0x000000000c2b7faeULL, 0x0003e6000b901c46ULL, 0x00000010211c7825ULL, 0x040fe200078e001cULL,
0x000000001e497faeULL, 0x0003e6000b901c46ULL, 0x00000010211a7825ULL, 0x000fe200078e001aULL,
0x000000001c4b7faeULL, 0x0003e8000b901c46ULL, 0x000000001a277faeULL, 0x0003e4000b901c46ULL,
0x0000000302037812ULL, 0x002fc800078ec0ffULL, 0x000000030300780cULL, 0x000fc80003f05270ULL,
0x000000010a037807ULL, 0x000fca0004000000ULL, 0x0000000102027824ULL, 0x000fe400078e0203ULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x0000005b0200720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00000001050c7824ULL, 0x000fe400078e0202ULL,
0x00000004ff0d7424ULL, 0x000fc800078e00ffULL, 0x000060000c0c7625ULL, 0x000fca00078e000dULL,
0x000000060c037981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b64800760c7f8cULL, 0x0022a4000c80043fULL,
0x0000000000147805ULL, 0x000fc40000015200ULL, 0xffffffe056767812ULL, 0x042fe400078ec0ffULL,
0x00000010560f7812ULL, 0x040fe400078ec0ffULL, 0x00000008560e7812ULL, 0x000fc800078ec0ffULL,
0x000000760e767210ULL, 0x000fca0007ffe00fULL, 0x01b64c00760f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x006fe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e14177210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e15ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000170e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b64c00760f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000100650d7810ULL, 0x000fca0007ffe063ULL,
0x00000001620d7824ULL, 0x000fca00078e020dULL, 0x01b000000d0e7984ULL, 0x000e680000000800ULL,
0x01b200000d0f7984ULL, 0x0004e20000000800ULL, 0x000000770e00720bULL, 0x002fe20003f1d000ULL,
0x0000e3327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x004fc800000e0100ULL,
0x0000ffff14ff7812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff787224ULL, 0x000fd400078e0077ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x00000002550d7810ULL, 0x000fe40007ffe0ffULL,
0x000000770e00720bULL, 0x000fe40003f34000ULL, 0x0000005c0d00720cULL, 0x000fe20003f05270ULL,
0x0000e2f27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000157806ULL, 0x000fc400008e0100ULL,
0x000000805c0d8824ULL, 0x000fe200078e0265ULL, 0x0000000e770c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000162178824ULL, 0x000fe200078e020dULL,
0x00009910150d7816ULL, 0x000fc800000000ffULL, 0x01b4000c17008388ULL, 0x0003e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000e770c7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL, 0x8000000c770c7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00197308ULL, 0x000e640000000800ULL,
0x0000001904047220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011600ULL, 0x0000e2127f007947ULL, 0x000fea000b800000ULL,
0x00001f0c190c7589ULL, 0x0002a400000e0000ULL, 0x0000000c44447220ULL, 0x084fe40000410000ULL,
0x0000000c45457220ULL, 0x080fe40000410000ULL, 0x0000000c40407220ULL, 0x080fe40000410000ULL,
0x0000000c41417220ULL, 0x000fc40000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe40000410000ULL, 0x0000000c38387220ULL, 0x080fe40000410000ULL,
0x0000000c39397220ULL, 0x080fe40000410000ULL, 0x0000000c34347220ULL, 0x080fe40000410000ULL,
0x0000000c35357220ULL, 0x000fc40000410000ULL, 0x0000000c30307220ULL, 0x080fe40000410000ULL,
0x0000000c31317220ULL, 0x080fe40000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000000c10107220ULL, 0x080fe40000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008000c7811ULL, 0x000fe200078ff0ffULL, 0x0000e1227f007947ULL, 0x000fea000b800000ULL,
0x00001f0c190c7589ULL, 0x00046400000e0000ULL, 0x0000000c46467220ULL, 0x082fe40000410000ULL,
0x0000000c47477220ULL, 0x080fe40000410000ULL, 0x0000000c42427220ULL, 0x080fe40000410000ULL,
0x0000000c43437220ULL, 0x080fe40000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000c3f3f7220ULL, 0x000fc40000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe40000410000ULL, 0x0000000c36367220ULL, 0x080fe40000410000ULL,
0x0000000c37377220ULL, 0x080fe40000410000ULL, 0x0000000c32327220ULL, 0x080fe40000410000ULL,
0x0000000c33337220ULL, 0x000fc40000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000c12127220ULL, 0x080fe40000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff15ff7812ULL, 0x000fe40007800814ULL, 0x0000000e77787209ULL, 0x000fd60007810000ULL,
0x800000780e0e0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL,
0x0000000e00070308ULL, 0x000e640000000800ULL, 0x000000070f0f0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000000040f047221ULL, 0x008fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x00005410080e7816ULL, 0x000fe20000000008ULL,
0x0000df827f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e087589ULL, 0x0002e400000e0000ULL,
0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000dfd27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0e097589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x00006c6000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fc400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x0000e7e000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x004fe200078e000eULL, 0x00006cd000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff177424ULL, 0x000fe400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x0000e77000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00001000060c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff577819ULL, 0x000fe2000001165cULL, 0x012000006124783bULL, 0x000e660000000200ULL,
0x000010000c157812ULL, 0x000fe200078ec0ffULL, 0x00000002570c7824ULL, 0x000fc400078e0258ULL,
0x00004000576e7824ULL, 0x000fe400078e026eULL, 0x000020000c0c7824ULL, 0x000fc600078e0015ULL,
0x000130006e157810ULL, 0x000fe40007ffe015ULL, 0x000130000c0c7810ULL, 0x000fc60007ffe0ffULL,
0x000000106c207824ULL, 0x100fe400078e0215ULL, 0x0000001075507824ULL, 0x100fe400078e020cULL,
0x00000010744c7824ULL, 0x100fe400078e020cULL, 0x0000001073487824ULL, 0x100fe200078e020cULL,
0x000000002020783bULL, 0x000fe20000004200ULL, 0x0000001071287824ULL, 0x000fe400078e020cULL,
0x000000106b1c7824ULL, 0x100fe200078e0215ULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x000000106a187824ULL, 0x000fc400078e0215ULL, 0x0000001068157824ULL, 0x000fe200078e0215ULL,
0x000000004c4c783bULL, 0x000ea80000004200ULL, 0x000000004848783bULL, 0x000fe80000004200ULL,
0x000000002828783bULL, 0x000fe20000004200ULL, 0x0000000824240231ULL, 0x00afc400003400ffULL,
0x0000000826260231ULL, 0x080fe200003400ffULL, 0x012000005d0c783bULL, 0x000e620000000200ULL,
0x0000000925250231ULL, 0x084fe400003400ffULL, 0x0000000927270231ULL, 0x000fe200003400ffULL,
0x000000001c1c783bULL, 0x000ea80000004200ULL, 0x000000001818783bULL, 0x000ee80000004200ULL,
0x000000001514783bULL, 0x000ea20000004200ULL, 0x000000502444723cULL, 0x040f700000041844ULL,
0x000000522440723cULL, 0x040f700000041840ULL, 0x0000004c243c723cULL, 0x000f62000004183cULL,
0x000000080c0c0231ULL, 0x002fc400003400ffULL, 0x000000080e0e0231ULL, 0x000fe400003400ffULL,
0x000000090d0d0231ULL, 0x080fe400003400ffULL, 0x000000090f0f0231ULL, 0x000fe200003400ffULL,
0x0000004e2438723cULL, 0x040f700000041838ULL, 0x000000482434723cULL, 0x040f700000041834ULL,
0x0000004a2430723cULL, 0x040f700000041830ULL, 0x00000028242c723cULL, 0x040f70000004182cULL,
0x0000002a2410723cULL, 0x000f700000041810ULL, 0x000000200c44723cULL, 0x060b700000041844ULL,
0x000000220c40723cULL, 0x040b700000041840ULL, 0x0000001c0c3c723cULL, 0x044b70000004183cULL,
0x0000001e0c38723cULL, 0x040b700000041838ULL, 0x000000180c34723cULL, 0x048b700000041834ULL,
0x0000001a0c30723cULL, 0x040b700000041830ULL, 0x000000140c2c723cULL, 0x040b70000004182cULL,
0x000000160c10723cULL, 0x000b620000041810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000c05e0d7811ULL, 0x020fe200078e40ffULL, 0x01b6980060ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000106797812ULL, 0x000fe200078e0cffULL, 0x000000ffff777224ULL, 0x000fe200078e0078ULL,
0x0000005a0d00720cULL, 0x000fda0003f06070ULL, 0x00001b4000000947ULL, 0x000fea0003800000ULL,
0x000003005e0d7a10ULL, 0x002fe20007ffe0ffULL, 0x0000580003037a24ULL, 0x010fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000010d0c7810ULL, 0x040fe20007ffe0ffULL,
0x000001000d0f7824ULL, 0x000fe400078e0254ULL, 0x0000004003037824ULL, 0x000fe200078e00ffULL,
0x000000590c00720cULL, 0x000fe40003f06070ULL, 0x000000200b0d7812ULL, 0x000fd600078ef80fULL,
0x0000077000008947ULL, 0x000fea0003800000ULL, 0x000020005c147824ULL, 0x000fe200078e00ffULL,
0x00000003ff277819ULL, 0x000fe20000011600ULL, 0x00001000060e7824ULL, 0x000fe200078e00ffULL,
0x0000000f5a0c7217ULL, 0x000fe20007800000ULL, 0x0000000858167824ULL, 0x000fe200078e00ffULL,
0x0000200014147812ULL, 0x000fe400078ec0ffULL, 0x000010000e207812ULL, 0x000fe200078ec0ffULL,
0x00000001270e7824ULL, 0x040fe200078e020dULL, 0x0000000427157810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0fULL, 0x0000000827177810ULL, 0x000fe20007ffe0ffULL,
0x00004000570f7824ULL, 0x000fe200078e0214ULL, 0x0000000e030e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000115217824ULL, 0x040fe200078e0200ULL, 0x000000200c227817ULL, 0x000fe20003800000ULL,
0x0000000815147824ULL, 0x000fe200078e00ffULL, 0x000130000f207810ULL, 0x000fe20007ffe020ULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e000e1e7a11ULL, 0x000fe200078040ffULL,
0x00000001150c7824ULL, 0x000fe200078e020dULL, 0xfffffff814217812ULL, 0x000fe200078ee221ULL,
0x0000000117237824ULL, 0x040fe200078e0200ULL, 0x00005f000e1f7a11ULL, 0x000fe200000f440fULL,
0x0000000817147824ULL, 0x000fe200078e00ffULL, 0x0000000c270f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001021217824ULL, 0x000fe200078e0220ULL, 0x000000221500720cULL, 0x000fc40003f46070ULL,
0x0000000c03157210ULL, 0x000fe20007f1e0ffULL, 0x00000001170c7824ULL, 0x100fe200078e020dULL,
0x0000001027257810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0e7824ULL, 0x000fe200078e020dULL,
0x00000008165f7812ULL, 0x000fe200078ee25fULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0xfffffff814237812ULL, 0x000fe200078ee223ULL, 0x0000000125147824ULL, 0x000fe200078e020dULL,
0x0000000c030c7210ULL, 0x000fe20007f7e0ffULL, 0x000000105f1e7825ULL, 0x000fe200078e001eULL,
0x00005e00151c7a11ULL, 0x000fc400078040ffULL, 0x0000000e030e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff197224ULL, 0x000fe200018e06ffULL, 0x000000221700720cULL, 0x000fe20003f26070ULL,
0x000000010f287824ULL, 0x000fe200078e0200ULL, 0x00005f00151d7a11ULL, 0x000fe200000f4416ULL,
0x000000ffff177224ULL, 0x000fe200020e06ffULL, 0x0000001403147210ULL, 0x000fe20007fbe0ffULL,
0x000000080f297824ULL, 0x000fe200078e00ffULL, 0x00005e000c1a7a11ULL, 0x000fe200078040ffULL,
0x000000105f1c7825ULL, 0x000fe200078e001cULL, 0x00000014272b7810ULL, 0x000fc40007ffe0ffULL,
0x00005e000e187a11ULL, 0x000fe200078640ffULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0x00005f000c1b7a11ULL, 0x000fe200000f4419ULL, 0x000000012b0c7824ULL, 0x000fe200078e020dULL,
0x00005e0014167a11ULL, 0x000fe200078840ffULL, 0x0000001023237824ULL, 0x000fe200078e0220ULL,
0x00005f000e197a11ULL, 0x000fe200018f4417ULL, 0x00000001270e7824ULL, 0x040fe200078e0200ULL,
0x0000001827497810ULL, 0x000fe20007ffe0ffULL, 0x000000105f1a7825ULL, 0x000fe200078e001aULL,
0x0000001c274b7810ULL, 0x000fc40007ffe0ffULL, 0x00005f0014177a11ULL, 0x000fe200020f4415ULL,
0x000000105f187825ULL, 0x000fe200078e0018ULL, 0x000000222700720cULL, 0x000fe40003f66070ULL,
0x0000000c03157210ULL, 0x000fe20007f1e0ffULL, 0x00000001490c7824ULL, 0x100fe200078e020dULL,
0x000000070e277812ULL, 0x000fe200078ec0ffULL, 0x000000014b0e7824ULL, 0x040fe200078e020dULL,
0x000000224b00720cULL, 0x000fe20003fc6070ULL, 0x000000ffff247224ULL, 0x000fe200000e06ffULL,
0x0000000c030d7210ULL, 0x000fe20007f9e0ffULL, 0x000000105f167825ULL, 0x000fe200078e0016ULL,
0x00005e0015147a11ULL, 0x000fc400078040ffULL, 0x0000000e03037210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x0ffffff827277812ULL, 0x000fe400078ef800ULL,
0x00005f0015157a11ULL, 0x000fe200000f4424ULL, 0x000000ffff247224ULL, 0x000fe200028e06ffULL,
0x00005e000d0e7a11ULL, 0x000fe200078840ffULL, 0x0000001027277824ULL, 0x000fe200078e0220ULL,
0x00005e00030c7a11ULL, 0x000fe200078a40ffULL, 0x000000105f147825ULL, 0x000fe200078e0014ULL,
0x000000220f00720cULL, 0x000fc40003f06070ULL, 0x00005f000d0f7a11ULL, 0x000fe200020f4426ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e277faeULL, 0x0003e2000d901c46ULL,
0x00005f00030d7a11ULL, 0x000fe200028f4424ULL, 0x0000000125037824ULL, 0x140fe200078e0200ULL,
0x000000222500720cULL, 0x0c0fe20003f66070ULL, 0x0000000825267824ULL, 0x000fe200078e00ffULL,
0x000000222b00720cULL, 0x080fe20003f86070ULL, 0x0000000149247824ULL, 0x140fe200078e0200ULL,
0x000000224900720cULL, 0x000fe20003fa6070ULL, 0x000000012b227824ULL, 0x000fe200078e0200ULL,
0xfffffff829297812ULL, 0x000fe200078ee228ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff826037812ULL, 0x000fe200078ee203ULL, 0x0000000849257824ULL, 0x000fe200078e00ffULL,
0x000000001c217faeULL, 0x0005e2000d101c46ULL, 0x000000014b1e7824ULL, 0x002fe200078e0200ULL,
0xfffffff82b1f7812ULL, 0x000fe200078ee222ULL, 0x000000084b277824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee224ULL, 0x0000001029297824ULL, 0x100fe200078e0220ULL,
0x000000001a237faeULL, 0x0005e2000c901c46ULL, 0x0000001003037824ULL, 0x000fe200078e0220ULL,
0xfffffff827277812ULL, 0x000fe200078ee21eULL, 0x000000101f1f7824ULL, 0x100fe200078e0220ULL,
0x0000000018297faeULL, 0x0005e2000c101c46ULL, 0x0000001025257824ULL, 0x000fc400078e0220ULL,
0x000000105f0e7825ULL, 0x000fe200078e000eULL, 0x0000000016037faeULL, 0x0005e6000d901c46ULL,
0x0000001027277824ULL, 0x000fe200078e0220ULL, 0x00000000141f7faeULL, 0x0005e2000e101c46ULL,
0x000000105f0c7825ULL, 0x000fc600078e000cULL, 0x000000000e257faeULL, 0x0005e8000e901c46ULL,
0x000000000c277faeULL, 0x0005e2000f101c46ULL, 0x000006a000007947ULL, 0x000fea0003800000ULL,
0x00000008580c7824ULL, 0x000fe200078e00ffULL, 0x00000004000e7811ULL, 0x000fe200078fe8ffULL,
0x000020005c197824ULL, 0x000fe200078e00ffULL, 0x0000000800147811ULL, 0x000fe400078fe8ffULL,
0x000000080c5f7812ULL, 0x000fe200078ee25fULL, 0x000000010e247824ULL, 0x100fe200078e0200ULL,
0x0000000d000c7211ULL, 0x000fe200078fe8ffULL, 0x000000080e0f7824ULL, 0x000fe200078e00ffULL,
0x0000000c00157811ULL, 0x000fe200078fe8ffULL, 0x0000000114237824ULL, 0x040fe200078e0200ULL,
0x0000000c030c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0xfffffff80f247812ULL, 0x000fe200078ee224ULL, 0x0000000115227824ULL, 0x140fe200078e0200ULL,
0x0000001400187811ULL, 0x000fe200078fe8ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e000c1e7a11ULL, 0x000fe200078040ffULL, 0x0000000815177824ULL, 0x000fe200078e00ffULL,
0xfffffff816237812ULL, 0x000fe200078ee223ULL, 0x0000000118217824ULL, 0x100fe200078e0200ULL,
0x0000001000167811ULL, 0x000fe200078fe8ffULL, 0x0000000818267824ULL, 0x000fe200078e00ffULL,
0x00000018001c7811ULL, 0x000fe200078fe8ffULL, 0x0000000118187824ULL, 0x000fe200078e020dULL,
0x00005f000c1f7a11ULL, 0x000fe200000f440fULL, 0x000000010e0c7824ULL, 0x000fe200078e020dULL,
0x0000001c001d7811ULL, 0x000fe200078fe8ffULL, 0x0000000116257824ULL, 0x040fe200078e0200ULL,
0xfffffff817227812ULL, 0x000fe200078ee222ULL, 0x00000008161a7824ULL, 0x000fe200078e00ffULL,
0xfffffff826217812ULL, 0x000fe200078ee221ULL, 0x000000011c207824ULL, 0x040fe200078e0200ULL,
0x00000018030f7210ULL, 0x000fe20007f9e0ffULL, 0x000000081c177824ULL, 0x000fe200078e00ffULL,
0xfffffff81a257812ULL, 0x000fe200078ee225ULL, 0x00000001140e7824ULL, 0x100fe200078e020dULL,
0x0000200019187812ULL, 0x000fe200078ec0ffULL, 0x0000000115147824ULL, 0x100fe200078e020dULL,
0xfffffff817207812ULL, 0x000fe200078ee220ULL, 0x0000000116167824ULL, 0x100fe200078e020dULL,
0x0000000e030e7210ULL, 0x040fe20007f3e0ffULL, 0x000000011c1c7824ULL, 0x100fe200078e020dULL,
0x0000001403147210ULL, 0x000fe20007f1e0ffULL, 0x000000011d267824ULL, 0x000fe200078e020dULL,
0x0000000c030d7210ULL, 0x040fe20007f7e0ffULL, 0x0000100006177824ULL, 0x000fe200078e00ffULL,
0x0000001603157210ULL, 0x000fe20007f5e0ffULL, 0x0000400057197824ULL, 0x000fe200078e0218ULL,
0x00005e000d1a7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000001c030c7210ULL, 0x000fe20007fbe0ffULL, 0x000000081d4b7824ULL, 0x000fe200078e00ffULL,
0x0000002603037210ULL, 0x000fe20007f7e0ffULL, 0x000000011d267824ULL, 0x000fe200078e0200ULL,
0x00005f000d1b7a11ULL, 0x000fe200030f4416ULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x0000100017167812ULL, 0x000fe200078ec0ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x00005e000e1c7a11ULL, 0x000fe200078240ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e0014187a11ULL, 0x000fe200078040ffULL, 0x000000105f1e7825ULL, 0x000fe200078e001eULL,
0x00005f000e1d7a11ULL, 0x000fc400008f4417ULL, 0x0000000000177211ULL, 0x000fe200078fe8ffULL,
0x000000105f1a7825ULL, 0x000fe200078e001aULL, 0x00013000192a7810ULL, 0x000fe40007ffe016ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee226ULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x00005f0014197a11ULL, 0x000fe200000f440dULL, 0x000000ffff0d7224ULL, 0x000fe200028e06ffULL,
0x00005e0015167a11ULL, 0x000fe200078040ffULL, 0x0000001024297824ULL, 0x100fe200078e022aULL,
0x0000000717277812ULL, 0x000fe200078ec0ffULL, 0x0000001023237824ULL, 0x000fe200078e022aULL,
0x00005e000f147a11ULL, 0x000fe200078240ffULL, 0x000000105f1c7825ULL, 0x000fe200078e001cULL,
0x00005e000c0e7a11ULL, 0x000fc400078440ffULL, 0x00005f0015177a11ULL, 0x000fe200000f4428ULL,
0x00000010222b7824ULL, 0x000fe200078e022aULL, 0x0ffffff827277812ULL, 0x000fe200078ef800ULL,
0x000000105f187825ULL, 0x000fe200078e0018ULL, 0x00005f000f157a11ULL, 0x000fe400008f4426ULL,
0x00005f000c0f7a11ULL, 0x000fe200010f440dULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x00005e00030c7a11ULL, 0x000fe200078040ffULL, 0x0000001027277824ULL, 0x100fe400078e022aULL,
0x0000001025257824ULL, 0x000fe200078e022aULL, 0x00005f00030d7a11ULL, 0x000fe200000f4426ULL,
0x000000105f167825ULL, 0x000fe200078e0016ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e277faeULL, 0x0003e6000b901c46ULL, 0x0000001021217824ULL, 0x000fe200078e022aULL,
0x000000001a297faeULL, 0x0003e2000b901c46ULL, 0x000000105f147825ULL, 0x000fc600078e0014ULL,
0x000000001c237faeULL, 0x0003e2000b901c46ULL, 0x0000001020497824ULL, 0x000fe400078e022aULL,
0x000000105f0e7825ULL, 0x000fe200078e000eULL, 0x00000000182b7faeULL, 0x0003e6000b901c46ULL,
0x000000104b4b7824ULL, 0x000fe200078e022aULL, 0x0000000016257faeULL, 0x0003e2000b901c46ULL,
0x000000105f0c7825ULL, 0x000fc600078e000cULL, 0x0000000014217faeULL, 0x0003e8000b901c46ULL,
0x000000000e497faeULL, 0x0003e8000b901c46ULL, 0x000000000c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000302037812ULL, 0x004fc800078ec0ffULL, 0x000000030300780cULL, 0x000fc80003f05270ULL,
0x000000010a037807ULL, 0x000fca0004000000ULL, 0x0000000102027824ULL, 0x000fe400078e0203ULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x0000005b0200720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00000001050c7824ULL, 0x002fe400078e0202ULL,
0x00000004ff0d7424ULL, 0x000fc800078e00ffULL, 0x000060000c0c7625ULL, 0x000fca00078e000dULL,
0x000000060c037981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b66800760e7f8cULL, 0x0022a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01b66c0076157984ULL, 0x000ee40000000800ULL,
0x8000000015ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140c177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0dULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b66c0076157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018065637810ULL, 0x000fca0007ffe063ULL,
0x0000000162637824ULL, 0x000fca00078e0263ULL, 0x01b00000630f7984ULL, 0x000ea80000000800ULL,
0x01b20000630e7984ULL, 0x0006620000000800ULL, 0x000000780f00720bULL, 0x004fe20003f1d000ULL,
0x0000c9127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x008fc800000e0100ULL,
0x0000ffff14ff7812ULL, 0x000fe2000782c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff777224ULL, 0x000fd400078e0078ULL,
0x0000043000009947ULL, 0x000fea0003800000ULL, 0x00000003550d7810ULL, 0x000fe40007ffe0ffULL,
0x000000780f00720bULL, 0x000fe40003f34000ULL, 0x0000005c0d00720cULL, 0x000fe20003f05270ULL,
0x0000c8d27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000157806ULL, 0x000fc400008e0100ULL,
0x000000805c658824ULL, 0x000fe200078e0265ULL, 0x000000780f777209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910150c7816ULL, 0x000fe200000000ffULL,
0x0000000162628824ULL, 0x000fca00078e0265ULL, 0x01b4007762008388ULL, 0x0005e20000000800ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x00000078770c7221ULL, 0x004fe20000010100ULL, 0x000000ff15ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00197308ULL, 0x000ea40000000800ULL, 0x0000001904047220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011600ULL,
0x0000c8027f007947ULL, 0x000fea000b800000ULL, 0x00001f0c190c7589ULL, 0x0004e400000e0000ULL,
0x0000000c44447220ULL, 0x088fe40000410000ULL, 0x0000000c45457220ULL, 0x080fe40000410000ULL,
0x0000000c40407220ULL, 0x080fe40000410000ULL, 0x0000000c41417220ULL, 0x080fe40000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000c3d3d7220ULL, 0x000fc40000410000ULL,
0x0000000c38387220ULL, 0x080fe40000410000ULL, 0x0000000c39397220ULL, 0x080fe40000410000ULL,
0x0000000c34347220ULL, 0x080fe40000410000ULL, 0x0000000c35357220ULL, 0x080fe40000410000ULL,
0x0000000c30307220ULL, 0x080fe40000410000ULL, 0x0000000c31317220ULL, 0x000fc40000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c10107220ULL, 0x080fe40000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x000fe200078ff0ffULL,
0x0000c7127f007947ULL, 0x000fea000b800000ULL, 0x00001f0c190c7589ULL, 0x0006a400000e0000ULL,
0x0000000c46467220ULL, 0x084fe40000410000ULL, 0x0000000c47477220ULL, 0x080fe40000410000ULL,
0x0000000c42427220ULL, 0x080fe40000410000ULL, 0x0000000c43437220ULL, 0x080fe40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe40000410000ULL,
0x0000000c36367220ULL, 0x080fe40000410000ULL, 0x0000000c37377220ULL, 0x080fe40000410000ULL,
0x0000000c32327220ULL, 0x080fe40000410000ULL, 0x0000000c33337220ULL, 0x000fc40000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000c12127220ULL, 0x080fe40000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fda0007800814ULL,
0x0000000f770f0221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f00070308ULL, 0x000ea40000000800ULL, 0x000000070e0e0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000000040e047221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x00005410080e7816ULL, 0x000fe20000000008ULL,
0x0000c5827f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e087589ULL, 0x0002a400000e0000ULL,
0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000c5d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0e097589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x000088e000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fc400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x0000cb6000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x004fe200078e000eULL, 0x0000895000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff177424ULL, 0x000fe400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x0000caf000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x012800006124783bULL, 0x000e680000000200ULL,
0x000000007250783bULL, 0x000ee80000004200ULL, 0x00000000704c783bULL, 0x000fe80000004200ULL,
0x000000006f48783bULL, 0x000fe80000004200ULL, 0x000000006d28783bULL, 0x000fe80000004200ULL,
0x012800005d0c783bULL, 0x002e680000000200ULL, 0x000000006920783bULL, 0x000ea80000004200ULL,
0x00000000671c783bULL, 0x000ea80000004200ULL, 0x000000006618783bULL, 0x008ee80000004200ULL,
0x000000006414783bULL, 0x004ea20000004200ULL, 0x0000000824240231ULL, 0x000fc400003400ffULL,
0x0000000826260231ULL, 0x000fe400003400ffULL, 0x0000000925250231ULL, 0x080fe400003400ffULL,
0x0000000927270231ULL, 0x000fce00003400ffULL, 0x000000502444723cULL, 0x000f620000041844ULL,
0x000000080c0c0231ULL, 0x002fce00003400ffULL, 0x000000522440723cULL, 0x000f620000041840ULL,
0x000000080e0e0231ULL, 0x000fe400003400ffULL, 0x000000090d0d0231ULL, 0x080fe400003400ffULL,
0x000000090f0f0231ULL, 0x000fc600003400ffULL, 0x0000004c243c723cULL, 0x040f70000004183cULL,
0x0000004e2438723cULL, 0x040f700000041838ULL, 0x000000482434723cULL, 0x040f700000041834ULL,
0x0000004a2430723cULL, 0x040f700000041830ULL, 0x00000028242c723cULL, 0x040f70000004182cULL,
0x0000002a2410723cULL, 0x000f700000041810ULL, 0x000000200c44723cULL, 0x060b700000041844ULL,
0x000000220c40723cULL, 0x040b700000041840ULL, 0x0000001c0c3c723cULL, 0x040b70000004183cULL,
0x0000001e0c38723cULL, 0x040b700000041838ULL, 0x000000180c34723cULL, 0x048b700000041834ULL,
0x0000001a0c30723cULL, 0x040b700000041830ULL, 0x000000140c2c723cULL, 0x044b70000004182cULL,
0x000000160c10723cULL, 0x000b620000041810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01b6a00060ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000106797812ULL, 0x000fce00078ec0ffULL,
0x000003005e5e7a10ULL, 0x002fc80007ffe0ffULL, 0x000000595e00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff8ae000007947ULL, 0x000fea000383ffffULL,
0x0000000000027919ULL, 0x002e620000002500ULL, 0x000000ffff177224ULL, 0x020fe400078e0013ULL,
0x000000ffff167224ULL, 0x000fe200078e0012ULL, 0x000000590200720cULL, 0x002fda0003f06070ULL,
0x0000034000000947ULL, 0x000fea0003800000ULL, 0x0180000004007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00008d0000087802ULL, 0x000fc40000000f00ULL, 0x0000c59000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000400037308ULL, 0x010e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000004ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000057919ULL, 0x000ee20000000000ULL, 0x00000002ff037819ULL, 0x004fe40000011603ULL,
0x0000000805057811ULL, 0x008fc800078ff0ffULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0500057589ULL, 0x000ee200000e0000ULL, 0x0000004403447220ULL, 0x044fe40000410000ULL,
0x0000004503457220ULL, 0x040fe40000410000ULL, 0x0000004003407220ULL, 0x040fe40000410000ULL,
0x0000004103417220ULL, 0x000fc40000410000ULL, 0x0000003c033c7220ULL, 0x040fe40000410000ULL,
0x0000003d033d7220ULL, 0x040fe40000410000ULL, 0x0000003803387220ULL, 0x040fe40000410000ULL,
0x0000003903397220ULL, 0x040fe40000410000ULL, 0x0000003403347220ULL, 0x040fe40000410000ULL,
0x0000003503357220ULL, 0x000fc40000410000ULL, 0x0000003003307220ULL, 0x040fe40000410000ULL,
0x0000003103317220ULL, 0x040fe40000410000ULL, 0x0000002c032c7220ULL, 0x040fe40000410000ULL,
0x0000002d032d7220ULL, 0x040fe40000410000ULL, 0x0000001003107220ULL, 0x040fe40000410000ULL,
0x0000001103117220ULL, 0x000fc40000410000ULL, 0x0000004605467220ULL, 0x048fe40000410000ULL,
0x0000004705477220ULL, 0x040fe40000410000ULL, 0x0000004205427220ULL, 0x040fe40000410000ULL,
0x0000004305437220ULL, 0x040fe40000410000ULL, 0x0000003e053e7220ULL, 0x040fe40000410000ULL,
0x0000003f053f7220ULL, 0x000fc40000410000ULL, 0x0000003a053a7220ULL, 0x040fe40000410000ULL,
0x0000003b053b7220ULL, 0x040fe40000410000ULL, 0x0000003605367220ULL, 0x040fe40000410000ULL,
0x0000003705377220ULL, 0x040fe40000410000ULL, 0x0000003205327220ULL, 0x040fe40000410000ULL,
0x0000003305337220ULL, 0x000fc40000410000ULL, 0x0000002e052e7220ULL, 0x040fe40000410000ULL,
0x0000002f052f7220ULL, 0x040fe40000410000ULL, 0x0000001605167220ULL, 0x040fe40000410000ULL,
0x0000001705177220ULL, 0x000fc80000410000ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x000000161716723eULL, 0x000fe400000010ffULL, 0x000000444503723eULL, 0x010fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000404107723eULL, 0x000fc400000010ffULL,
0x0000003c3d08723eULL, 0x000fe400000010ffULL, 0x00000038390a723eULL, 0x000fe400000010ffULL,
0x00000034350b723eULL, 0x000fe400000010ffULL, 0x00000030310c723eULL, 0x000fe400000010ffULL,
0x0000002c2d0d723eULL, 0x000fe400000010ffULL, 0x00000010110e723eULL, 0x000fc400000010ffULL,
0x00000002ff187819ULL, 0x004fe40000011605ULL, 0x0000000805277811ULL, 0x000fe400078ff0ffULL,
0x0000000118007810ULL, 0x040fe20007ffe0ffULL, 0x0000000818197824ULL, 0x040fe200078e00ffULL,
0x0000000618177810ULL, 0x040fe20007ffe0ffULL, 0x00000008181c7824ULL, 0x040fe200078e00ffULL,
0x0000000218067810ULL, 0x040fe20007ffe0ffULL, 0x00000008181b7824ULL, 0x040fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee200ULL, 0x00000008181d7824ULL, 0x040fe200078e00ffULL,
0x0000000318007810ULL, 0x040fe20007ffe0ffULL, 0x00000008181a7824ULL, 0x040fe200078e00ffULL,
0x0000000518097810ULL, 0x040fe20007ffe0ffULL, 0x00000008181f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c237812ULL, 0x000fe200078ee217ULL, 0x0000000818177824ULL, 0x040fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL, 0x0000000818257824ULL, 0x040fe200078e00ffULL,
0x0000000418067810ULL, 0x000fe20007ffe0ffULL, 0x00000008271c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee200ULL, 0x0000100058007824ULL, 0x000fe200078e00ffULL,
0xfffffff81a217812ULL, 0x000fe200078ee209ULL, 0x0000080057097824ULL, 0x000fe200078e00ffULL,
0xffffffff181a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff817177812ULL, 0x000fe200078ee218ULL,
0x0000000405187824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL,
0x0000000100067824ULL, 0x000fe200078e0209ULL, 0xfffffff825257812ULL, 0x000fe400078ee21aULL,
0x0000000c18187812ULL, 0x000fe200078ec0ffULL, 0x0000001017177824ULL, 0x100fe200078e0206ULL,
0xfffffff81c277812ULL, 0x000fe200078ee227ULL, 0x0000001019197824ULL, 0x100fe200078e0206ULL,
0x00000046470f723eULL, 0x000fe200000010ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0206ULL,
0x000000424310723eULL, 0x000fe200000010ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0206ULL,
0x0000003e3f11723eULL, 0x000fe200000010ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0206ULL,
0x0000003a3b12723eULL, 0x000fe200000010ffULL, 0x00000001171a7824ULL, 0x000fe200078e0218ULL,
0x000000363713723eULL, 0x000fe200000010ffULL, 0x0000001021217824ULL, 0x100fe200078e0206ULL,
0x000000323314723eULL, 0x000fe200000010ffULL, 0x0000000118197824ULL, 0x040fe200078e0219ULL,
0x000000031a007388ULL, 0x0005e20000000800ULL, 0x0000001023237824ULL, 0x100fe200078e0206ULL,
0x0000002e2f15723eULL, 0x000fe200000010ffULL, 0x00000001181b7824ULL, 0x000fe200078e021bULL,
0x0000000719007388ULL, 0x000fe20000000800ULL, 0x0000001025257824ULL, 0x000fc400078e0206ULL,
0x00000001181d7824ULL, 0x040fe200078e021dULL, 0x000000081b007388ULL, 0x0007e20000000800ULL,
0x0000001027277824ULL, 0x000fe200078e0206ULL, 0x000000ff00037306ULL, 0x004fe20000205400ULL,
0x00000001181c7824ULL, 0x040fe200078e021fULL, 0x0000000a1d007388ULL, 0x000fe20000000800ULL,
0x0000000118217824ULL, 0x040fe400078e0221ULL, 0x00000001181e7824ULL, 0x040fe200078e0223ULL,
0x0000000b1c007388ULL, 0x000fe20000000800ULL, 0x0000000118257824ULL, 0x040fe200078e0225ULL,
0x000000ff00087306ULL, 0x008ea20000209400ULL, 0x0000000118187824ULL, 0x000fe200078e0227ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x0000000154177824ULL, 0x000fc600078e0205ULL,
0x0000000d1e007388ULL, 0x000fe40000000800ULL, 0x000000ff00077306ULL, 0x000e64000020d400ULL,
0x0000000e25007388ULL, 0x000fe20000000800ULL, 0x00000010170c7824ULL, 0x008fc600078e0200ULL,
0x0000000f18007388ULL, 0x000fe20000000800ULL, 0x000000030800720bULL, 0x004fc60003f1d000ULL,
0x0004001019007388ULL, 0x000fe80000000800ULL, 0x000400111b007388ULL, 0x000fe80000000800ULL,
0x000400121d007388ULL, 0x000fe40000000800ULL, 0x0000000107070812ULL, 0x002fc400078efcffULL,
0x000400131c007388ULL, 0x000fe40000000800ULL, 0x000000070708723eULL, 0x000fe400000010ffULL,
0x0004001421007388ULL, 0x000fe80000000800ULL, 0x000400151e007388ULL, 0x000fe80000000800ULL,
0x0004001625007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000c287984ULL, 0x000e680000000c00ULL, 0x000800000c187984ULL, 0x000ea80000000c00ULL,
0x000400000c107984ULL, 0x000ee80000000c00ULL, 0x000c00000c2c7984ULL, 0x000ee20000000c00ULL,
0x3f803f80082a7831ULL, 0x002fc4000020002aULL, 0x3f803f80082b7831ULL, 0x000fe4000020002bULL,
0x3f803f802a2a7831ULL, 0x004fe2000020001aULL, 0x00000300ff1a7624ULL, 0x000fe200078e00ffULL,
0x3f803f8008297831ULL, 0x040fe40000200029ULL, 0x3f803f8008287831ULL, 0x040fe40000200028ULL,
0x000000011a00780cULL, 0x000fe20003f05270ULL, 0x3f803f8008137831ULL, 0x048fe40000200013ULL,
0x3f803f8008127831ULL, 0x000fc40000200012ULL, 0x3f803f8008117831ULL, 0x040fe40000200011ULL,
0x3f803f8008107831ULL, 0x000fe40000200010ULL, 0x3f803f802b2b7831ULL, 0x000fe4000020001bULL,
0x3f803f8029297831ULL, 0x000fe40000200019ULL, 0x3f803f8028287831ULL, 0x000fe40000200018ULL,
0x3f803f8013137831ULL, 0x000fc4000020002fULL, 0x3f803f8012127831ULL, 0x000fe2000020002eULL,
0x000000280c007388ULL, 0x000fe20000000c00ULL, 0x3f803f8011117831ULL, 0x000fe4000020002dULL,
0x3f803f8010107831ULL, 0x000fca000020002cULL, 0x000400100c007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a1000008947ULL, 0x000fea0003800000ULL,
0x00005800ff037624ULL, 0x000fe200078e00ffULL, 0x0000000000167919ULL, 0x000e660000002700ULL,
0x0000660003037a24ULL, 0x000fe200078e02ffULL, 0x0000000000117919ULL, 0x000e680000002600ULL,
0x0000000f030b7811ULL, 0x040fe200078e10ffULL, 0x0000030003037a24ULL, 0x000fe200078e02ffULL,
0x000000000c0c7984ULL, 0x000ea40000000c00ULL, 0xfffffff00b0b7812ULL, 0x000fca00078ec0ffULL,
0x00000080030a7824ULL, 0x000fc800078e020bULL, 0x0000008003037824ULL, 0x000fca00078e020aULL,
0x0000007f03037810ULL, 0x000fe20007ffe0ffULL, 0x0000580016167a24ULL, 0x002fc600078e0211ULL,
0xffffff8003037812ULL, 0x000fe200078ec0ffULL, 0x0000030016087a24ULL, 0x000fc600078e02ffULL,
0x00006a0003117a10ULL, 0x000fe20007f1e0ffULL, 0x0000000108027824ULL, 0x000fca00078e0202ULL,
0x0000001102107211ULL, 0x000fe200078258ffULL, 0x00006b00ff117624ULL, 0x000fe200000e06ffULL,
0x0000000157ff7812ULL, 0x000fc8000780f85cULL, 0x0000001102117211ULL, 0x000fe400008f5cffULL,
0x00006a000b187a10ULL, 0x000fc60007f3e0ffULL, 0x0000040058107825ULL, 0x000fcc00078e0010ULL,
0x0000001017107825ULL, 0x000fc800078e0010ULL, 0x00006b00ff177624ULL, 0x000fe200008e06ffULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x0000001005127824ULL, 0x004fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011605ULL, 0x0000008002137824ULL, 0x000fe200078e00ffULL,
0x00000019ff027819ULL, 0x000fe40000011602ULL, 0x0000007012157812ULL, 0x000fe400078ec0ffULL,
0x0000000c14127812ULL, 0x000fe400078ec0ffULL, 0x00006a0013147a10ULL, 0x000fc40007ebe00aULL,
0x0000001815137210ULL, 0x000fe40007a3e013ULL, 0x0000001412147210ULL, 0x000fe40007c7e015ULL,
0x00006b0002157a10ULL, 0x000fe40002fec4ffULL, 0x0000001312127210ULL, 0x000fe40007fbe0ffULL,
0x00000017ff027210ULL, 0x000fe40000fe4402ULL, 0x00000015ff157210ULL, 0x000fc60001fe84ffULL,
0x000000ffff137224ULL, 0x000fca00028e0602ULL, 0x0000007712007986ULL, 0x0003e8000c101906ULL,
0x0000000414007986ULL, 0x0003e4000c101906ULL, 0x000000ff0500720cULL, 0x004fe20000705670ULL,
0x0000000c10007986ULL, 0x000fe2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000ff00000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff0d7424ULL, 0x000fe200078e00ffULL, 0xffffffff1a0f7810ULL, 0x000fc60007ffe0ffULL,
0x00006a00160c7625ULL, 0x000fe200078e000dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000f0c0c79a8ULL, 0x000ea400099ee1c6ULL, 0x0000000f0c00720cULL, 0x004fc80003f05270ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000002ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x004ea40000000000ULL,
0x000000ff0200720cULL, 0x004fda0003f05270ULL, 0x000025d000008947ULL, 0x000fea0003800000ULL,
0x000000ff5c00720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001005027824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x002fe40000011605ULL,
0x00000018080c7211ULL, 0x000fe400078038ffULL, 0x00000070020d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fe400078ec0ffULL, 0x0000001708027211ULL, 0x000fe400000f3cffULL,
0x0000000c040c7210ULL, 0x000fc8000791e00dULL, 0x00000002ff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c027981ULL, 0x000328000c1e1900ULL, 0x000080060c0f7981ULL, 0x000322000c1e1900ULL,
0x000000021a00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x000100060c117981ULL, 0x002322000c1e1900ULL, 0x000000041a00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x000180060c137981ULL, 0x002322000c1e1900ULL,
0x000000041a00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x000200060c157981ULL, 0x002322000c1e1900ULL, 0x000000061a00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x000280060c177981ULL, 0x002322000c1e1900ULL,
0x000000061a00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081a00780cULL, 0x002fe20003f06070ULL, 0x000300060c197981ULL, 0x000318000c1e1900ULL,
0x000380060c1b0981ULL, 0x000324000c1e1900ULL, 0x000000071a047810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff047819ULL, 0x000fc80000011604ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000b081f7211ULL, 0x040fe200078038ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1d7224ULL, 0x010fe200078e0002ULL, 0x00006a001f1f7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff080e7211ULL, 0x000fe400000f3cffULL, 0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL,
0x00006b00ff0e7a10ULL, 0x000fc400017e240eULL, 0x0000030010007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000404007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x00000008100c7810ULL, 0x040fe40007ffe0ffULL,
0x00000001100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001d02027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011605ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffc80060c1d7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x00000009100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000002100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000000f02027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011605ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffd00060c0f7981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000003100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001102027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011605ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffd80060c117981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000004100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001302027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011605ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffe00060c137981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000005100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001502027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011605ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffe80060c157981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000006100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001702027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011605ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xffff00060c177981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000007100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001902027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011605ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xffff80060c197981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f100c7810ULL, 0x002fe40007ffe0ffULL,
0x0000001b02027209ULL, 0x000fe40007810000ULL, 0x000003000c007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011605ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0x000000060c1b7981ULL, 0x000326000c1e1900ULL,
0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL, 0x0000000810107810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e060eULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x000ea40000000000ULL, 0x0000001005047824ULL, 0x004fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x002fc80000011605ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c0c0d7812ULL, 0x000fca00078ec0ffULL, 0x00000001040d7824ULL, 0x000fca00078e020dULL,
0x000000020d007388ULL, 0x0103e40000000800ULL, 0x00006a0003027a10ULL, 0x002fe20007f3e0ffULL,
0x0000000157117824ULL, 0x000fe200078e0208ULL, 0x000000070500780cULL, 0x040fe20003f04070ULL,
0x00000010050e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011605ULL,
0x00006b00ff037624ULL, 0x000fe200008e06ffULL, 0x00000001570f7812ULL, 0x000fe200078ec0ffULL,
0x0000040058047824ULL, 0x000fe200078e00ffULL, 0x000000700e107812ULL, 0x000fe200078ec0ffULL,
0x00000800110c7825ULL, 0x000fe200078e0002ULL, 0x0000000c12137812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000257188824ULL, 0x140fe200078e0258ULL,
0x000000040c0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000257128824ULL, 0x000fe200078e0258ULL,
0x00000800090c7812ULL, 0x000fe200078ec0ffULL, 0x0000000218188824ULL, 0x100fe200078e020fULL,
0x00006a000b0b7a10ULL, 0x000fe20007f5e0ffULL, 0x00000002121a8824ULL, 0x000fe200078e020fULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0f7224ULL, 0x000fe200008e060dULL,
0x00006a000a0a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000200057097824ULL, 0x000fe200078e0200ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000001102e7824ULL, 0x000fe200078e0213ULL,
0x0000002005137810ULL, 0x000fe20007ffe0ffULL, 0x0000000109107824ULL, 0x000fe200078e020cULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00006b00ff0c7624ULL, 0x000fe200008e06ffULL,
0x0000000a11148211ULL, 0x040fe200078238ffULL, 0x00006b00ff2d7624ULL, 0x000fe200010e06ffULL,
0x0000000b11168211ULL, 0x040fe200078438ffULL, 0x0000000818188824ULL, 0x100fe200078e0205ULL,
0x0000000c11158211ULL, 0x000fe200008f3cffULL, 0x000000081a1a8824ULL, 0x000fe200078e0205ULL,
0x0000030057007a0cULL, 0x000fe20003f26070ULL, 0x0000001013127825ULL, 0x000fe200078e000eULL,
0x0000002d11178211ULL, 0x000fe200010f3cffULL, 0x000000002e2e7984ULL, 0x000e620000000800ULL,
0x00004580181d8811ULL, 0x000fe200078e20ffULL, 0x0000001005197824ULL, 0x040fe200078e0210ULL,
0x000041801a1f8811ULL, 0x000fe200078e20ffULL, 0x00000010050e7825ULL, 0x040fe200078e000eULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000001005148825ULL, 0x040fe200078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e197faeULL, 0x0005e2000b901c46ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000001005168825ULL, 0x000fe200078e0016ULL, 0x0038000012197faeULL, 0x0007e6000b901c46ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x00000000141d8faeULL, 0x0009e2000b901c46ULL,
0x000000ffff2c7224ULL, 0x000fc400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fe200078e00ffULL,
0x00000000161f8faeULL, 0x0009e2000b901c46ULL, 0x00000000000e7805ULL, 0x004fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000127805ULL, 0x008fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000bf000001947ULL, 0x000fea0003800000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fca00078e0057ULL,
0x0000000132337810ULL, 0x000fc80007ffe0ffULL, 0x0000030033007a0cULL, 0x000fda0003f06070ULL,
0x0000022000000947ULL, 0x000fea0003800000ULL, 0x000000070500780cULL, 0x000fe20003f64070ULL,
0x0000000108397824ULL, 0x000fe200078e0233ULL, 0x0000000133347812ULL, 0x040fe200078ec0ffULL,
0x0000080033337824ULL, 0x000fe200078e00ffULL, 0x00000020053b7810ULL, 0x000fe20007ffe0ffULL,
0x0000080039307825ULL, 0x000fc600078e0002ULL, 0x0000080033387812ULL, 0x000fca00078ec0ffULL,
0x000000025735b824ULL, 0x100fe200078e0258ULL, 0x0000000a3936b211ULL, 0x000fe200078238ffULL,
0x000000025737b824ULL, 0x000fe400078e0258ULL, 0x00000002353ab824ULL, 0x100fe400078e0234ULL,
0x00000002373cb824ULL, 0x000fe200078e0234ULL, 0x0000000430347210ULL, 0x000fe20007f1e0ffULL,
0x0000000109387824ULL, 0x000fe200078e0238ULL, 0x0000000b3930b211ULL, 0x040fe200078438ffULL,
0x000000083a3ab824ULL, 0x000fe200078e0205ULL, 0x0000000c3937b211ULL, 0x040fe200008f3cffULL,
0x000000ffff357224ULL, 0x000fe200000e0631ULL, 0x0000002d3931b211ULL, 0x000fe200010f3cffULL,
0x0000001005337824ULL, 0x000fc400078e0238ULL, 0x000000083c3cb824ULL, 0x000fe400078e0205ULL,
0x000000100538b825ULL, 0x000fc600078e0036ULL, 0x000041803c3db811ULL, 0x000fe200078e20ffULL,
0x000000103b367825ULL, 0x000fe200078e0034ULL, 0x000045803a3bb811ULL, 0x000fc600078e20ffULL,
0x0000001005347825ULL, 0x000fc800078e0034ULL, 0x000000100530b825ULL, 0x000fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000034337faeULL, 0x0005e8000b901c46ULL,
0x0038000036337faeULL, 0x0005e8000b901c46ULL, 0x00000000383bbfaeULL, 0x0005e8000b901c46ULL,
0x00000000303dbfaeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000008032307824ULL, 0x004fe200078e00ffULL, 0x00000001ff347819ULL, 0x100fe20000011605ULL,
0x0000000257337824ULL, 0x000fe200078e0258ULL, 0x00000002ff417819ULL, 0x000fe20000011605ULL,
0x0000001005317824ULL, 0x000fe200078e00ffULL, 0x0000008030307812ULL, 0x000fc400078ec0ffULL,
0x0000000c34347812ULL, 0x000fe200078ec0ffULL, 0x0000000841367824ULL, 0x000fe200078e00ffULL,
0x0000007031317812ULL, 0x000fe200078ec0ffULL, 0x0000010033307824ULL, 0x000fe200078e0030ULL,
0x00000008414b7810ULL, 0x040fe20007ffe0ffULL, 0x00000008413d7824ULL, 0x040fe200078e00ffULL,
0x0000000141357810ULL, 0x040fe20007ffe0ffULL, 0x0000000841437824ULL, 0x000fe200078e00ffULL,
0x0000003034317210ULL, 0x000fe20007ffe031ULL, 0x0000000405347824ULL, 0x000fe200078e00ffULL,
0xfffffff8363b7812ULL, 0x000fe200078ee235ULL, 0x0000080032307824ULL, 0x000fe200078e00ffULL,
0x0000000241357810ULL, 0x000fe20007ffe0ffULL, 0x000000084b387824ULL, 0x000fe200078e00ffULL,
0x0000000c34447812ULL, 0x000fe200078ec0ffULL, 0x0000000841347824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800031337984ULL, 0x000ea20000000800ULL,
0x0000080030307812ULL, 0x000fe200078ec0ffULL, 0x0000000841457824ULL, 0x000fe200078e00ffULL,
0xfffffff8363f7812ULL, 0x000fe200078ee235ULL, 0x0045800031377984ULL, 0x0007220000000800ULL,
0x0000018009307810ULL, 0x000fe20007ffe030ULL, 0x00000008413c7824ULL, 0x040fe200078e00ffULL,
0x00000004413a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000841477824ULL, 0x000fe200078e00ffULL,
0x0000000232327810ULL, 0x000fe40007ffe0ffULL, 0xfffffff843437812ULL, 0x000fc400078ee23aULL,
0xfffffff834317812ULL, 0x008fe400078ee241ULL, 0x0000030032007a0cULL, 0x000fc60003f06070ULL,
0x0000001031317824ULL, 0x000fc800078e0230ULL, 0x0000000144317824ULL, 0x000fca00078e0231ULL,
0x0000000031397984ULL, 0x0006640000000800ULL, 0x000000332e347221ULL, 0x006fe20000010100ULL,
0xfffffff838337812ULL, 0x000fe400078ee24bULL, 0x0000000341387810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe40000410000ULL, 0x0000001033337824ULL, 0x000fe400078e0230ULL,
0x0000003400367308ULL, 0x0003240000000800ULL, 0x0000000144357824ULL, 0x000fc400078e0233ULL,
0x000000103b337824ULL, 0x000fe200078e0230ULL, 0xfffffff83d3b7812ULL, 0x000fe400078ee238ULL,
0x00000000353d7984ULL, 0x0005e20000000800ULL, 0x0000000144337824ULL, 0x040fe200078e0233ULL,
0x0000000541387810ULL, 0x000fe20007ffe0ffULL, 0x000000103f347824ULL, 0x102fe400078e0230ULL,
0x000000103b317824ULL, 0x008fe200078e0230ULL, 0x00040000333e7984ULL, 0x000fe20000000800ULL,
0x0000000144347824ULL, 0x000fe200078e0234ULL, 0xfffffff845457812ULL, 0x000fe200078ee238ULL,
0x0000003736427220ULL, 0x010fe20000410000ULL, 0x00000000333a7984ULL, 0x0003e20000000800ULL,
0xffffffff41357810ULL, 0x044fe20007ffe0ffULL, 0x0000000144317824ULL, 0x000fe200078e0231ULL,
0x0000000641367810ULL, 0x000fe20007ffe0ffULL, 0x00001f4142377589ULL, 0x000ea200000e0000ULL,
0xfffffff83c497812ULL, 0x000fe200078ee235ULL, 0x0000001045357824ULL, 0x000fe200078e0230ULL,
0xfffffff847477812ULL, 0x000fe200078ee236ULL, 0x00000000343b7984ULL, 0x000fe20000000800ULL,
0x0000001043337824ULL, 0x002fc400078e0230ULL, 0x0000000144357824ULL, 0x040fe200078e0235ULL,
0x00001f4b42387589ULL, 0x0002e200000e0000ULL, 0x0000000144337824ULL, 0x000fe400078e0233ULL,
0x0000002f422f7221ULL, 0x000fe20000010000ULL, 0x00000000313c7984ULL, 0x000fe20000000800ULL,
0x0000001047367824ULL, 0x100fe400078e0230ULL, 0x0000001049307824ULL, 0x000fe200078e0230ULL,
0x0004000031407984ULL, 0x0008e20000000800ULL, 0x0000000144367824ULL, 0x040fe200078e0236ULL,
0x00007610ff427816ULL, 0x102fe20000000039ULL, 0x0000000144307824ULL, 0x000fe200078e0230ULL,
0x00040000343f7984ULL, 0x000e620000000800ULL, 0x00005410ff317816ULL, 0x010fc60000000039ULL,
0x0000000033347984ULL, 0x000fe20000000800ULL, 0x00000037422b7223ULL, 0x084fe4000001002bULL,
0x00000037312c7223ULL, 0x000fe2000001002cULL, 0x00005410ff317816ULL, 0x100fe2000000003dULL,
0x0004000035397984ULL, 0x000fe20000000800ULL, 0x00007610ff3d7816ULL, 0x000fc6000000003dULL,
0x00000038311a7223ULL, 0x088fe2000001001aULL, 0x0004000033417984ULL, 0x0004e20000000800ULL,
0x000000383d257223ULL, 0x000fc60000010025ULL, 0x0000000035317984ULL, 0x0008e20000000800ULL,
0x00005410ff337816ULL, 0x104fe4000000003aULL, 0x00007610ff3a7816ULL, 0x000fe4000000003aULL,
0x00005410ff357816ULL, 0x010fe2000000003eULL, 0x00000037332a7223ULL, 0x080fe4000001002aULL,
0x0000000036337984ULL, 0x000fe20000000800ULL, 0x000000373a297223ULL, 0x000fe40000010029ULL,
0x0000003835197223ULL, 0x000fe20000010019ULL, 0x00007610ff357816ULL, 0x000fe2000000003eULL,
0x00040000363a7984ULL, 0x0005220000000800ULL, 0x00007610ff3d7816ULL, 0x000fc60000000040ULL,
0x0000003835247223ULL, 0x080fe20000010024ULL, 0x00005410ff357816ULL, 0x100fe2000000003bULL,
0x000000383d227223ULL, 0x000fe20000010022ULL, 0x00007610ff367816ULL, 0x004fc6000000003bULL,
0x0000003735287223ULL, 0x080fe20000010028ULL, 0x00040000303b7984ULL, 0x000fe20000000800ULL,
0x0000003736277223ULL, 0x000fe20000010027ULL, 0x00005410ff367816ULL, 0x102fe4000000003fULL,
0x0000000030357984ULL, 0x0002a20000000800ULL, 0x00007610ff3f7816ULL, 0x000fe4000000003fULL,
0x0000003836177223ULL, 0x080fe20000010017ULL, 0x00005410ff3d7816ULL, 0x008fe40000000041ULL,
0x000000383f237223ULL, 0x000fe20000010023ULL, 0x00007610ff417816ULL, 0x000fc40000000041ULL,
0x00005410ff307816ULL, 0x002fe2000000003cULL, 0x000000383d147223ULL, 0x080fe20000010014ULL,
0x00007610ff3c7816ULL, 0x000fe2000000003cULL, 0x0000003841217223ULL, 0x000fe40000010021ULL,
0x00000037301f7223ULL, 0x080fe2000001001fULL, 0x00005410ff307816ULL, 0x000fe20000000040ULL,
0x000000373c0f7223ULL, 0x000fc8000001000fULL, 0x0000003830157223ULL, 0x000fe20000010015ULL,
0x00005410ff307816ULL, 0x100fe40000000034ULL, 0x00007610ff347816ULL, 0x000fc60000000034ULL,
0x00000037301e7223ULL, 0x080fe2000001001eULL, 0x00005410ff307816ULL, 0x100fe20000000031ULL,
0x0000003734167223ULL, 0x000fe20000010016ULL, 0x00007610ff317816ULL, 0x000fc60000000031ULL,
0x00000037301d7223ULL, 0x080fe2000001001dULL, 0x00005410ff307816ULL, 0x100fe20000000039ULL,
0x0000003731187223ULL, 0x080fe20000010018ULL, 0x00005410ff317816ULL, 0x010fe4000000003aULL,
0x00007610ff397816ULL, 0x000fe20000000039ULL, 0x0000003830137223ULL, 0x080fe20000010013ULL,
0x00005410ff307816ULL, 0x100fe20000000033ULL, 0x00000038310e7223ULL, 0x080fe2000001000eULL,
0x00007610ff337816ULL, 0x000fe20000000033ULL, 0x0000003839127223ULL, 0x080fe20000010012ULL,
0x00007610ff317816ULL, 0x000fe2000000003aULL, 0x00000037301c7223ULL, 0x080fe2000001001cULL,
0x00005410ff307816ULL, 0x104fe20000000035ULL, 0x0000003733107223ULL, 0x000fe20000010010ULL,
0x00007610ff357816ULL, 0x000fe20000000035ULL, 0x0000003831207223ULL, 0x000fc40000010020ULL,
0x00000037301b7223ULL, 0x080fe2000001001bULL, 0x00005410ff307816ULL, 0x100fe2000000003bULL,
0x0000003735267223ULL, 0x000fe20000010026ULL, 0x00007610ff3b7816ULL, 0x000fc6000000003bULL,
0x0000003830117223ULL, 0x080fe40000010011ULL, 0x000000383b0d7223ULL, 0x000fe2000001000dULL,
0xfffff43000008947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x000000ff5800720cULL, 0x000fe20003f05270ULL, 0x0000001002037824ULL, 0x004fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003057812ULL, 0x000fe400078ec0ffULL,
0x0000000c02087812ULL, 0x000fca00078ec0ffULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x0000001002037824ULL, 0x004fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fc80000011602ULL, 0x0000007003027812ULL, 0x000fe400078ec0ffULL,
0x0000000c04037812ULL, 0x000fc600078ec0ffULL, 0x0000008057027824ULL, 0x000fc800078e0202ULL,
0x0000000103027824ULL, 0x000fca00078e0202ULL, 0x0049802f02007388ULL, 0x0005e40000000800ULL,
0x0000000105057824ULL, 0x000fe200078e0208ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0049800005027984ULL, 0x004ea20000000800ULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x004a000005037984ULL, 0x000ee20000000800ULL, 0x00000002ff027221ULL, 0x004fc80000010000ULL,
0x0000000302027221ULL, 0x008fca0000010000ULL, 0x0180000002037810ULL, 0x000fc80007ffe0ffULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0002ULL, 0x0000b81000087802ULL, 0x000fc40000000f00ULL,
0x00009a8000007944ULL, 0x002fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200037308ULL, 0x000ea40000001000ULL, 0xbf80000002047423ULL, 0x004fc80000000003ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403037223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000f220000000000ULL,
0x000000070707723eULL, 0x000fc600000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff0a7819ULL, 0x010fe40000011605ULL, 0x00000008050c7811ULL, 0x000fc600078ff0ffULL,
0x00001f0a03097589ULL, 0x00cea200000e0000ULL, 0x000000080a2e7824ULL, 0x042fe400078e00ffULL,
0x000000080a2d7824ULL, 0x040fe200078e00ffULL, 0x00001f0c03047589ULL, 0x0002e200000e0000ULL,
0x000000080a2f7824ULL, 0x040fe400078e00ffULL, 0x000000080a317824ULL, 0x040fe400078e00ffULL,
0x000000080a337824ULL, 0x040fe400078e00ffULL, 0x000000080a357824ULL, 0x000fc400078e00ffULL,
0x000000080c377824ULL, 0x000fca00078e00ffULL, 0xfffffff837377812ULL, 0x000fca00078ee20cULL,
0x0000001037377824ULL, 0x000fe400078e0206ULL, 0x0000002c092c7220ULL, 0x044fe40000410000ULL,
0x0000002b092b7220ULL, 0x040fe40000410000ULL, 0x0000002a092a7220ULL, 0x040fe40000410000ULL,
0x0000002909297220ULL, 0x000fe20000410000ULL, 0x0000002c2b2b723eULL, 0x000fe200000010ffULL,
0x0000002809287220ULL, 0x000fc40000410000ULL, 0x0000002709277220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000010ffULL, 0x0000001f091f7220ULL, 0x040fe40000410000ULL,
0x0000000f09027220ULL, 0x000fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x0000001e091e7220ULL, 0x040fe40000410000ULL, 0x00000016090b7220ULL, 0x040fe20000410000ULL,
0x000000030a167810ULL, 0x000fe20007ffe0ffULL, 0x0000001d091d7220ULL, 0x040fe20000410000ULL,
0x0000001f0202723eULL, 0x000fe200000010ffULL, 0x0000001809187220ULL, 0x000fe20000410000ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee216ULL, 0x0000001c091c7220ULL, 0x040fe20000410000ULL,
0x000000060a167810ULL, 0x040fe20007ffe0ffULL, 0x0000001009037220ULL, 0x042fe20000410000ULL,
0x000000020a107810ULL, 0x000fe20007ffe0ffULL, 0x0000001b091b7220ULL, 0x000fe20000410000ULL,
0xfffffff833337812ULL, 0x000fe200078ee216ULL, 0x0000002609267220ULL, 0x000fe20000410000ULL,
0x0000001e0b0b723eULL, 0x000fe200000010ffULL, 0x0000001a041a7220ULL, 0x008fe20000410000ULL,
0x0000001d1818723eULL, 0x000fe200000010ffULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000001c0303723eULL, 0x000fe200000010ffULL, 0x0000001904197220ULL, 0x000fe20000410000ULL,
0x0000001b261b723eULL, 0x000fe200000010ffULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000001a251a723eULL, 0x000fe200000010ffULL, 0x0000001704177220ULL, 0x000fc40000410000ULL,
0x0000002304087220ULL, 0x000fe20000410000ULL, 0x000000192419723eULL, 0x000fe200000010ffULL,
0x0000001504157220ULL, 0x040fe40000410000ULL, 0x0000002204227220ULL, 0x000fe20000410000ULL,
0x000000170808723eULL, 0x000fe200000010ffULL, 0x0000001404147220ULL, 0x040fe40000410000ULL,
0x0000002104217220ULL, 0x000fe20000410000ULL, 0x000000152215723eULL, 0x000fe200000010ffULL,
0x0000001304137220ULL, 0x000fc40000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x000000142114723eULL, 0x000fe200000010ffULL, 0x0000000e040e7220ULL, 0x040fe40000410000ULL,
0x0000002004097220ULL, 0x000fe20000410000ULL, 0x000000040a207810ULL, 0x000fe20007ffe0ffULL,
0x0000001104117220ULL, 0x000fe20000410000ULL, 0x000000131212723eULL, 0x000fe200000010ffULL,
0x0000000d04047220ULL, 0x000fe20000410000ULL, 0x000000010a0d7810ULL, 0x040fe20007ffe0ffULL,
0x000000080a237824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee220ULL,
0x000000102d2d7824ULL, 0x000fe200078e0206ULL, 0xfffffff82e0f7812ULL, 0x000fe200078ee20dULL,
0x000000080a0d7824ULL, 0x040fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee210ULL,
0x000000102f2f7824ULL, 0x100fe200078e0206ULL, 0x000000050a107810ULL, 0x040fe20007ffe0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0206ULL, 0xffffffff0a207810ULL, 0x000fe20007ffe0ffULL,
0x0000001023237824ULL, 0x000fe200078e0206ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20aULL,
0x00000004050a7824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee210ULL,
0x0000001033337824ULL, 0x000fe200078e0206ULL, 0xfffffff835357812ULL, 0x000fe200078ee220ULL,
0x000000100d0d7824ULL, 0x100fe200078e0206ULL, 0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001031317824ULL, 0x100fe200078e0206ULL, 0x0000000e0909723eULL, 0x000fe200000010ffULL,
0x0000001035357824ULL, 0x000fe200078e0206ULL, 0x000000110404723eULL, 0x000fe200000010ffULL,
0x000000010d067824ULL, 0x000fc400078e020aULL, 0x000000010a107824ULL, 0x040fe400078e020fULL,
0x000000010a237824ULL, 0x040fe200078e0223ULL, 0x0000002b06007388ULL, 0x000fe20000000800ULL,
0x000000010a2d7824ULL, 0x040fe400078e022dULL, 0x000000010a2f7824ULL, 0x040fe200078e022fULL,
0x0000002910007388ULL, 0x000fe20000000800ULL, 0x000000010a317824ULL, 0x040fe400078e0231ULL,
0x000000010a167824ULL, 0x040fe200078e0233ULL, 0x0000002723007388ULL, 0x000fe20000000800ULL,
0x000000010a357824ULL, 0x000fc400078e0235ULL, 0x000000010a377824ULL, 0x000fe200078e0237ULL,
0x000000022d007388ULL, 0x0003e20000000800ULL, 0x00000001540d7824ULL, 0x000fc600078e0205ULL,
0x0000000b2f007388ULL, 0x000fe80000000800ULL, 0x0000001831007388ULL, 0x000fe20000000800ULL,
0x000000100d027824ULL, 0x002fc600078e0200ULL, 0x0000000316007388ULL, 0x000fe80000000800ULL,
0x0000001b35007388ULL, 0x000fe80000000800ULL, 0x0000001a37007388ULL, 0x000fe80000000800ULL,
0x0004001910007388ULL, 0x000fe80000000800ULL, 0x0004000823007388ULL, 0x000fe80000000800ULL,
0x000400152d007388ULL, 0x000fe80000000800ULL, 0x000400142f007388ULL, 0x000fe80000000800ULL,
0x0004001231007388ULL, 0x000fe80000000800ULL, 0x0004000916007388ULL, 0x000fe80000000800ULL,
0x0004000435007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000020c7984ULL, 0x000e680000000c00ULL, 0x00040000021c7984ULL, 0x000ea80000000c00ULL,
0x0008000002187984ULL, 0x000ee80000000c00ULL, 0x000c000002207984ULL, 0x000f220000000c00ULL,
0x3f803f80070f7831ULL, 0x002fc4000020000fULL, 0x3f803f80070e7831ULL, 0x040fe4000020000eULL,
0x3f803f80070d7831ULL, 0x040fe4000020000dULL, 0x3f803f80070c7831ULL, 0x040fe4000020000cULL,
0x3f803f80071f7831ULL, 0x044fe4000020001fULL, 0x3f803f80071e7831ULL, 0x040fe4000020001eULL,
0x3f803f80071d7831ULL, 0x000fc4000020001dULL, 0x3f803f80071c7831ULL, 0x000fe4000020001cULL,
0x3f803f800f0f7831ULL, 0x008fe4000020001bULL, 0x3f803f800e0e7831ULL, 0x000fe4000020001aULL,
0x3f803f800d0d7831ULL, 0x000fe40000200019ULL, 0x3f803f800c0c7831ULL, 0x000fe40000200018ULL,
0x3f803f801f1f7831ULL, 0x010fc40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x0000000c02007388ULL, 0x000fe20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fe40000200021ULL,
0x3f803f801c1c7831ULL, 0x000fca0000200020ULL, 0x0004001c02007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff5700720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002005107810ULL, 0x000fe20007ffe0ffULL,
0x0000000000047919ULL, 0x002e620000002600ULL, 0x00000003ff067819ULL, 0x100fe20000011605ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff037819ULL, 0x000fe20000011610ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000858127824ULL, 0x000fe200078e00ffULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000106077824ULL, 0x000fe400078e0205ULL,
0x0000000110027824ULL, 0x000fc400078e0203ULL, 0x0000000858137824ULL, 0x000fe200078e00ffULL,
0x0000000707087812ULL, 0x000fe400078ec0ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0ffffff808097812ULL, 0x000fe400078ef805ULL, 0x0ffffff802077812ULL, 0x000fc600078ef810ULL,
0x0000001009027824ULL, 0x100fe400078e0200ULL, 0x0000001007077824ULL, 0x000fe400078e0200ULL,
0x0000000804117824ULL, 0x042fe200078e00ffULL, 0x0000000002087984ULL, 0x0002e20000000c00ULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0x00000000070c7984ULL, 0x0005220000000c00ULL, 0xfffffff811007812ULL, 0x000fc400078ee206ULL,
0xfffffff804037812ULL, 0x000fe400078ee203ULL, 0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000403007c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff812117812ULL, 0x000fe200078ee205ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0006027a11ULL, 0x002fe200078040ffULL,
0x000000ffff077224ULL, 0x004fe200008e06ffULL, 0x00005a0000047a11ULL, 0x000fc400078240ffULL,
0x00005b0006037a11ULL, 0x000fe400000f4403ULL, 0x00005b0000057a11ULL, 0x000fe400008f4407ULL,
0xfffffff813077812ULL, 0x000fe200078ee210ULL, 0x0000001011027825ULL, 0x000fc800078e0002ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x008fe8000c101d06ULL,
0x0000000c04007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000045e047824ULL, 0x000fe400078e025cULL, 0xffffffffff077424ULL, 0x000fc600078e00ffULL,
0x0000005b0400720cULL, 0x000fda0003f06070ULL, 0x0000000208038824ULL, 0x000fc800078e00ffULL,
0x00006400030c8a24ULL, 0x000fc800078e0204ULL, 0x000060000c0c8625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060c078981ULL, 0x000ea2000c1e1900ULL,
0x000000015e027810ULL, 0x000fe20007ffe0ffULL, 0x000000405c057824ULL, 0x000fe400078e00ffULL,
0x01b60000ff0a7f8cULL, 0x002e62000c80043fULL, 0x000000590200720cULL, 0x000fe20003f06070ULL,
0x0000004011027824ULL, 0x000fe400078e00ffULL, 0x0000004010037824ULL, 0x000fe400078e00ffULL,
0x0000000207097224ULL, 0x004fd000078e02ffULL, 0x00000e9000008947ULL, 0x000fea0003800000ULL,
0x000001005e0d7824ULL, 0x002fe200078e0205ULL, 0x00000003ff0f7819ULL, 0x100fe40000011600ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000d5a0c7217ULL, 0x000fe40007800000ULL,
0x000000040f0e7810ULL, 0x040fe40007ffe0ffULL, 0x000000080f117810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0d7824ULL, 0x000fe200078e0a0dULL, 0x000000100f127810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0c7824ULL, 0x140fe200078e0200ULL, 0x000000140f1a7810ULL, 0x000fe20007ffe0ffULL,
0x000000080e1b7824ULL, 0x040fe200078e00ffULL, 0x0000000d0e00720cULL, 0x080fe20003f86070ULL,
0x00000001110e7824ULL, 0x040fe200078e0200ULL, 0x0000000d1100720cULL, 0x0c0fe20003f66070ULL,
0x00000008111d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20cULL,
0x0000000812217824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000011a1c7824ULL, 0x000fe200078e0200ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20eULL,
0x00000040100e7824ULL, 0x000fe200078e020fULL, 0x0000000d0c00720cULL, 0x040fe20003f46070ULL,
0x000000010c107824ULL, 0x000fc400078e0200ULL, 0x000000080c1f7824ULL, 0x000fe200078e00ffULL,
0x000000040e0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000081a237824ULL, 0x000fe200078e00ffULL,
0x0000000e09167210ULL, 0x000fe40007f1e0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL,
0x0000000112107824ULL, 0x000fe200078e0200ULL, 0x0000000c090c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x00005e0016157a11ULL, 0x000fe400078240ffULL,
0xfffffff821217812ULL, 0x000fe200078ee210ULL, 0x000000010f107824ULL, 0x000fe200078e0200ULL,
0x0000000d1200720cULL, 0x000fe20003f06070ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x000000080e127810ULL, 0x000fc40007ffe0ffULL, 0x00005e000c137a11ULL, 0x000fe400078a40ffULL,
0x00005f0016167a11ULL, 0x000fe400008f4417ULL, 0x0000000710177812ULL, 0x000fe400078ec0ffULL,
0x0000001506107210ULL, 0x000fe40007f3e0ffULL, 0x0000001209187210ULL, 0x000fe40007fde0ffULL,
0x00005f000c147a11ULL, 0x000fe200028f4411ULL, 0x000000ffff117224ULL, 0x000fe200008e0616ULL,
0x0000000d0f00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff197224ULL, 0x000fe200030e06ffULL,
0x000010005c0c7811ULL, 0x000fc400078e70ffULL, 0x0ffffff817177812ULL, 0x000fe400078ef800ULL,
0x0000001306127210ULL, 0x000fe40007f3e0ffULL, 0x00005e0018157a11ULL, 0x040fe200078c40ffULL,
0x0000001017177824ULL, 0x000fe200078e020cULL, 0x000000180f167810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0614ULL, 0x00005f0018187a11ULL, 0x000fe200030f4419ULL,
0x000000101b197824ULL, 0x000fe200078e020cULL, 0x0000000c0e147810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e2000e901c46ULL,
0x0000000d1a00720cULL, 0x080fe20003f26070ULL, 0x00000001161a7824ULL, 0x040fe200078e0200ULL,
0x0000001c0f1b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000012197faeULL, 0x0005e2000e101c46ULL,
0x0000000d1600720cULL, 0x040fe20003f86070ULL, 0x0000000816257824ULL, 0x000fe200078e00ffULL,
0x0000001409167210ULL, 0x000fe20007fde0ffULL, 0x000000081b277824ULL, 0x000fe200078e00ffULL,
0x0000001506147210ULL, 0x000fc40007fbe0ffULL, 0xfffffff825257812ULL, 0x000fe200078ee21aULL,
0x000000ffff177224ULL, 0x002fe200030e06ffULL, 0x00005e0016117a11ULL, 0x000fe200078c40ffULL,
0x000000ffff157224ULL, 0x000fe200028e0618ULL, 0xfffffff823237812ULL, 0x000fe200078ee21cULL,
0x000000101d137824ULL, 0x004fe200078e020cULL, 0x000000100e127810ULL, 0x000fe20007ffe0ffULL,
0x000000011b1c7824ULL, 0x000fe200078e0200ULL, 0x00005f0016167a11ULL, 0x000fe200030f4417ULL,
0x000000101f177824ULL, 0x000fe200078e020cULL, 0x0000001106107210ULL, 0x000fe20007fde0ffULL,
0x0000000014137faeULL, 0x0003e2000d901c46ULL, 0x00000012091a7210ULL, 0x000fc40007f7e0ffULL,
0x000000140e127810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200030e0616ULL,
0x0000000d1b00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff1b7224ULL, 0x000fe200018e06ffULL,
0x000000200f167810ULL, 0x000fe40007ffe0ffULL, 0x0000001209197210ULL, 0x000fe20007fde0ffULL,
0x0000000010177faeULL, 0x0005e2000d101c46ULL, 0x00005e001a1d7a11ULL, 0x000fe200078640ffULL,
0x0000000116187824ULL, 0x040fe200078e0200ULL, 0x0000000d1600720cULL, 0x040fe20003f46070ULL,
0x00000008161f7824ULL, 0x000fe200078e00ffULL, 0x00005f001a157a11ULL, 0x002fe200018f441bULL,
0x000000ffff167224ULL, 0x000fe200030e06ffULL, 0x00005e0019137a11ULL, 0x000fc400078c40ffULL,
0x000000180e127810ULL, 0x000fe40007ffe0ffULL, 0x00005f0019167a11ULL, 0x000fe200030f4416ULL,
0x0000001021177824ULL, 0x004fe200078e020cULL, 0x0000001d06107210ULL, 0x040fe40007f7e0ffULL,
0x000000240f147810ULL, 0x000fe40007ffe0ffULL, 0x00000012091e7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff117224ULL, 0x000fe200018e0615ULL, 0x0000001306127210ULL, 0x000fe20007f7e0ffULL,
0x0000000114157824ULL, 0x040fe200078e0200ULL, 0xfffffff81f1b7812ULL, 0x000fe200078ee218ULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee21cULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0x00005e001e1f7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff137224ULL, 0x000fe200018e0616ULL, 0x0000000d1400720cULL, 0x000fe20003f66070ULL,
0x0000000010177faeULL, 0x0003e2000c101c46ULL, 0x0000001c0e147810ULL, 0x000fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e020cULL, 0xfffffff8181d7812ULL, 0x000fc400078ee215ULL,
0x00005f001e1e7a11ULL, 0x000fe200030f4419ULL, 0x0000001023197824ULL, 0x100fe200078e020cULL,
0x000000280f157810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e020cULL,
0x00000014091c7210ULL, 0x000fe40007fde0ffULL, 0x0000001f06147210ULL, 0x000fe20007f1e0ffULL,
0x0000000115167824ULL, 0x040fe200078e0200ULL, 0x0000000012197faeULL, 0x0005e2000c901c46ULL,
0x0000000815217824ULL, 0x040fe200078e00ffULL, 0x0000000d1500720cULL, 0x000fe20003f26070ULL,
0x000000ffff177224ULL, 0x002fe200030e06ffULL, 0x00005e001c117a11ULL, 0x000fe200078c40ffULL,
0x000000ffff157224ULL, 0x000fe200000e061eULL, 0x0000002c0f187810ULL, 0x000fc80007ffe0ffULL,
0x0000000d1800720cULL, 0x040fe20003f06070ULL, 0x00000001181a7824ULL, 0x000fe200078e0200ULL,
0xfffffff821197812ULL, 0x004fe200078ee216ULL, 0x0000001025137824ULL, 0x100fe200078e020cULL,
0x000000200e127810ULL, 0x000fe20007ffe0ffULL, 0x00000008181f7824ULL, 0x000fe200078e00ffULL,
0x00005f001c167a11ULL, 0x000fe200030f4417ULL, 0x0000001027177824ULL, 0x100fe200078e020cULL,
0x0000001106107210ULL, 0x000fe20007fde0ffULL, 0x0000000014137faeULL, 0x0003e2000e101c46ULL,
0x00000012091c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001019197824ULL, 0x000fe200078e020cULL,
0x000000240e127810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200030e0616ULL,
0x000000300f167810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200020e06ffULL,
0xfffffff81f1f7812ULL, 0x000fc400078ee21aULL, 0x00005e001c217a11ULL, 0x000fe200078840ffULL,
0x0000000010177faeULL, 0x0005e2000e901c46ULL, 0x00000012091a7210ULL, 0x000fe20007fde0ffULL,
0x0000000116187824ULL, 0x040fe200078e0200ULL, 0x0000000d1600720cULL, 0x040fe20003fa6070ULL,
0x0000000816257824ULL, 0x000fe200078e00ffULL, 0x00005f001c167a11ULL, 0x000fe200020f4423ULL,
0x000000ffff157224ULL, 0x002fe200030e06ffULL, 0x00005e001a137a11ULL, 0x000fe200078c40ffULL,
0x000000101f1f7824ULL, 0x000fe200078e020cULL, 0x000000280e127810ULL, 0x000fc40007ffe0ffULL,
0x000000340f147810ULL, 0x000fe40007ffe0ffULL, 0x0000002106107210ULL, 0x004fe40007f9e0ffULL,
0xfffffff825177812ULL, 0x000fe400078ee218ULL, 0x00005f001a187a11ULL, 0x000fe200030f4415ULL,
0x000000ffff117224ULL, 0x000fe200020e0616ULL, 0x0000001209167210ULL, 0x000fe20007fde0ffULL,
0x0000000114157824ULL, 0x000fe200078e0200ULL, 0x0000001306127210ULL, 0x000fe20007f9e0ffULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0x00000000101b7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff257224ULL, 0x000fe200030e06ffULL, 0x00005e0016237a11ULL, 0x000fe200078c40ffULL,
0x000000ffff137224ULL, 0x000fe200020e0618ULL, 0x0000000d1400720cULL, 0x000fe20003f86070ULL,
0x0000001017177824ULL, 0x000fe200078e020cULL, 0x0000002c0e147810ULL, 0x000fc40007ffe0ffULL,
0x00000000121d7faeULL, 0x0005e2000d901c46ULL, 0xfffffff81a217812ULL, 0x000fe400078ee215ULL,
0x0000001409187210ULL, 0x000fe40007f7e0ffULL, 0x00005f0016157a11ULL, 0x000fe200030f4425ULL,
0x0000001021217824ULL, 0x000fe200078e020cULL, 0x0000002306147210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff257224ULL, 0x000fe200018e06ffULL, 0x000000380f167810ULL, 0x040fe40007ffe0ffULL,
0x0000003c0f0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0x000000300e107810ULL, 0x002fc40007ffe0ffULL, 0x0000000d1600720cULL, 0x0c0fe40003f66070ULL,
0x0000000d0f00720cULL, 0x000fe20003f46070ULL, 0x0000000014197faeULL, 0x0003e2000c901c46ULL,
0x00000001160d7824ULL, 0x100fe200078e0200ULL, 0x0000001009117210ULL, 0x000fe20007f3e0ffULL,
0x000000010f007824ULL, 0x040fe200078e0200ULL, 0x00005e0018237a11ULL, 0x040fe200078c40ffULL,
0x000000080f0f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff127224ULL, 0x004fe200008e06ffULL,
0x00005f0018137a11ULL, 0x000fe200030f4425ULL, 0x0000000816167824ULL, 0x000fe200078e00ffULL,
0x00005e00111d7a11ULL, 0x000fc400078c40ffULL, 0x0000002306107210ULL, 0x000fe40007f3e0ffULL,
0xfffffff80f0f7812ULL, 0x000fe400078ee200ULL, 0x000000340e007810ULL, 0x000fe40007ffe0ffULL,
0x00005f0011147a11ULL, 0x002fe200030f4412ULL, 0x000000ffff117224ULL, 0x000fe200008e0613ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000100f157824ULL, 0x000fe200078e020cULL,
0x0000000009167210ULL, 0x000fc40007f3e0ffULL, 0x000000380e127810ULL, 0x040fe20007ffe0ffULL,
0x00000000101f7faeULL, 0x0003e2000c101c46ULL, 0x0000003c0e0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x00005e00161b7a11ULL, 0x040fe400078240ffULL,
0x0000001209127210ULL, 0x040fe40007f1e0ffULL, 0x0000000e09007210ULL, 0x000fe20007fde0ffULL,
0x000000100d097824ULL, 0x000fe200078e020cULL, 0x00005f0016167a11ULL, 0x000fe200008f4413ULL,
0x000000ffff197224ULL, 0x000fe200000e06ffULL, 0x0000001d060c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x00005e0012117a11ULL, 0x002fc400078040ffULL,
0x00005e0000137a11ULL, 0x000fe200078c40ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e0614ULL,
0x0000001b060e7210ULL, 0x000fe40007f3e0ffULL, 0x00005f0012147a11ULL, 0x000fe400000f4419ULL,
0x00005f0000007a11ULL, 0x000fe200030f440fULL, 0x000000ffff0f7224ULL, 0x000fe200008e0616ULL,
0x0000001106107210ULL, 0x040fe20007f1e0ffULL, 0x000000000c177faeULL, 0x0003e2000e901c46ULL,
0x0000001306127210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0614ULL,
0x000000000e217faeULL, 0x0003e2000e101c46ULL, 0x000000ffff137224ULL, 0x000fc600008e0600ULL,
0x0000000010097faeULL, 0x0003e8000d901c46ULL, 0x0000000012157faeULL, 0x0003e2000d101c46ULL,
0x00000d4000007947ULL, 0x000fea0003800000ULL, 0x0000000800137811ULL, 0x042fe400078fe8ffULL,
0x00000004000e7811ULL, 0x040fe400078fe8ffULL, 0x0000001800197811ULL, 0x040fe200078fe8ffULL,
0x0000000113257824ULL, 0x140fe200078e0200ULL, 0x0000001000157811ULL, 0x040fe200078fe8ffULL,
0x00000008130c7824ULL, 0x000fe200078e00ffULL, 0x0000000c00147811ULL, 0x000fe200078fe8ffULL,
0x000000010e247824ULL, 0x100fe200078e0200ULL, 0x0000001c002c7811ULL, 0x000fe200078fe8ffULL,
0x000000080e0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c257812ULL, 0x000fe200078ee225ULL,
0x0000000119297824ULL, 0x040fe200078e0200ULL, 0x00000024002b7811ULL, 0x040fe200078fe8ffULL,
0x00000008190c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d247812ULL, 0x000fe200078ee224ULL,
0x0000000115267824ULL, 0x140fe200078e0200ULL, 0x0000002000177811ULL, 0x000fe200078fe8ffULL,
0x00000008150d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c297812ULL, 0x000fe200078ee229ULL,
0x0000000114277824ULL, 0x000fe200078e0200ULL, 0x00000028002d7811ULL, 0x000fe200078fe8ffULL,
0x0000000814107824ULL, 0x000fe200078e00ffULL, 0xfffffff80d267812ULL, 0x000fe200078ee226ULL,
0x000000012c1d7824ULL, 0x100fe200078e0200ULL, 0x0000002c002f7811ULL, 0x000fe200078fe8ffULL,
0x000000082c0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff810277812ULL, 0x000fe200078ee227ULL,
0x000000012b207824ULL, 0x140fe200078e0200ULL, 0x0000003000317811ULL, 0x000fe200078fe8ffULL,
0x000000082b0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c1d7812ULL, 0x000fe200078ee21dULL,
0x00000001171f7824ULL, 0x040fe200078e0200ULL, 0x0000003400337811ULL, 0x040fe200078fe8ffULL,
0x0000000817107824ULL, 0x000fe200078e00ffULL, 0xfffffff80d207812ULL, 0x000fe200078ee220ULL,
0x000000012d217824ULL, 0x140fe200078e0200ULL, 0x0000001400167811ULL, 0x000fe200078fe8ffULL,
0x000000082d0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8101f7812ULL, 0x000fe200078ee21fULL,
0x000000012f227824ULL, 0x140fe200078e0200ULL, 0x0000003800357811ULL, 0x000fe200078fe8ffULL,
0x000000082f0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c217812ULL, 0x000fe200078ee221ULL,
0x0000000131237824ULL, 0x040fe200078e0200ULL, 0x00000003000c7211ULL, 0x000fe200078fe8ffULL,
0x0000000831107824ULL, 0x000fe200078e00ffULL, 0xfffffff80d227812ULL, 0x000fe200078ee222ULL,
0x00000001332a7824ULL, 0x140fe200078e0200ULL, 0x000010005c477811ULL, 0x000fe200078e70ffULL,
0x00000008330d7824ULL, 0x000fe200078e00ffULL, 0xfffffff810237812ULL, 0x000fe200078ee223ULL,
0x0000000116287824ULL, 0x040fe200078e0200ULL, 0x0000000c09107210ULL, 0x000fe20007f1e0ffULL,
0x00000008160f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d2a7812ULL, 0x000fe200078ee22aULL,
0x00000001030e7824ULL, 0x000fe200078e020eULL, 0x0000007006497812ULL, 0x000fe200078ec0ffULL,
0x00000001350d7824ULL, 0x000fe200078e0200ULL, 0xfffffff80f287812ULL, 0x000fe200078ee228ULL,
0x0000000835387824ULL, 0x000fe200078e00ffULL, 0x0000000e090f7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005e00100c7a11ULL, 0x000fe200078040ffULL,
0x0000000103167824ULL, 0x040fe200078e0216ULL, 0xfffffff838387812ULL, 0x000fe200078ee20dULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x00005f00100d7a11ULL, 0x000fe200000f4411ULL,
0x0000000103107824ULL, 0x000fe200078e0213ULL, 0x00005e000f0e7a11ULL, 0x000fe200078240ffULL,
0x0000000103327824ULL, 0x000fc400078e0231ULL, 0x0000000103307824ULL, 0x000fe200078e022fULL,
0x00005f000f0f7a11ULL, 0x000fe200008f4412ULL, 0x0000000103127824ULL, 0x000fe200078e0214ULL,
0x0000001009117210ULL, 0x000fe20007f1e0ffULL, 0x0000000103147824ULL, 0x040fe400078e0215ULL,
0x0000000103347824ULL, 0x000fe200078e0233ULL, 0x0000001209137210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x0000001409157210ULL, 0x000fe20007f5e0ffULL,
0x0000000103367824ULL, 0x000fe200078e0235ULL, 0x00005e0011107a11ULL, 0x000fe200078040ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078240ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005f0011117a11ULL, 0x000fe200000f441cULL,
0x00000001031c7824ULL, 0x000fe200078e0217ULL, 0x00000016091b7210ULL, 0x000fe20007f1e0ffULL,
0x00000010272f7824ULL, 0x100fe200078e0247ULL, 0x00005e0015147a11ULL, 0x000fe200078440ffULL,
0x0000001026317824ULL, 0x000fe200078e0247ULL, 0x00005f0013137a11ULL, 0x000fe200008f441aULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x00005f0015157a11ULL, 0x000fe200010f4418ULL,
0x0000000103187824ULL, 0x000fe200078e0219ULL, 0x00005e001b167a11ULL, 0x000fe200078040ffULL,
0x00000001031a7824ULL, 0x000fc400078e022cULL, 0x0000001023417824ULL, 0x100fe200078e0247ULL,
0x00005f001b177a11ULL, 0x000fe200000f441eULL, 0x00000010223f7824ULL, 0x100fe200078e0247ULL,
0x0000001809197210ULL, 0x000fe20007f3e0ffULL, 0x0000001029357824ULL, 0x100fe200078e0247ULL,
0x0000001a091b7210ULL, 0x040fe20007f5e0ffULL, 0x0000001028337824ULL, 0x100fe200078e0247ULL,
0x0000001c091a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e001b1c7a11ULL, 0x000fe200078240ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005e001a1e7a11ULL, 0x000fe200078440ffULL, 0x000000ffff377224ULL, 0x000fe200018e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078040ffULL, 0x000000102a437824ULL, 0x100fe200078e0247ULL,
0x00005f001b1b7a11ULL, 0x000fe200008f442cULL, 0x00000010203b7824ULL, 0x100fe200078e0247ULL,
0x00000000002c7211ULL, 0x000fe200078fe8ffULL, 0x00000010213d7824ULL, 0x000fe200078e0247ULL,
0x00005f001a1a7a11ULL, 0x000fe200010f4437ULL, 0x0000001038457824ULL, 0x000fe200078e0247ULL,
0x000000072c397812ULL, 0x000fe200078ec0ffULL, 0x00000001032c7824ULL, 0x000fe200078e022bULL,
0x00005f0019197a11ULL, 0x000fe200000f442eULL, 0x00000001032e7824ULL, 0x000fe200078e022dULL,
0x0000003c00377811ULL, 0x000fc400078fe8ffULL, 0x0000002c093c7210ULL, 0x040fe40007f9e0ffULL,
0x0000003209327210ULL, 0x000fe20007f3e0ffULL, 0x00000001372b7824ULL, 0x100fe200078e0200ULL,
0x0ffffff839397812ULL, 0x000fe200078ef800ULL, 0x0000000103007824ULL, 0x000fe200078e0237ULL,
0x0000002e092e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200020e06ffULL,
0x00005e003c3a7a11ULL, 0x000fe200078c40ffULL, 0x00000008373e7824ULL, 0x000fe200078e00ffULL,
0x0000003009307210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x0000003409347210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff237224ULL, 0x000fe200018e06ffULL,
0x0000003609367210ULL, 0x000fe20007f9e0ffULL, 0x000000101d377824ULL, 0x100fe200078e0247ULL,
0x00005e0032267a11ULL, 0x000fe200078240ffULL, 0x000000ffff297224ULL, 0x000fe200010e06ffULL,
0x00000000092c7210ULL, 0x000fe20007fbe0ffULL, 0x0000001039097824ULL, 0x000fe200078e0247ULL,
0x00005f003c3c7a11ULL, 0x000fe200030f442dULL, 0x00000010252d7824ULL, 0x000fe200078e0247ULL,
0xfffffff83e007812ULL, 0x000fe200078ee22bULL, 0x00000010242b7824ULL, 0x100fe200078e0247ULL,
0x00005e002e227a11ULL, 0x000fe200078640ffULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x00005e0030247a11ULL, 0x000fe200078040ffULL, 0x000000101f397824ULL, 0x000fe200078e0247ULL,
0x00005f0032277a11ULL, 0x000fe200008f4427ULL, 0x000000ffff1f7224ULL, 0x000fe200020e06ffULL,
0x00005e0034287a11ULL, 0x000fe200078240ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e06ffULL,
0x00005f002e237a11ULL, 0x000fe200018f4423ULL, 0x0000001000477824ULL, 0x000fe200078e0247ULL,
0x00005e0036067a11ULL, 0x000fc400078440ffULL, 0x00005e002c2a7a11ULL, 0x000fe400078640ffULL,
0x00005f0030257a11ULL, 0x000fe400000f4425ULL, 0x0000000c490c7210ULL, 0x040fe40007f1e0ffULL,
0x00005f0034297a11ULL, 0x000fe400008f4429ULL, 0x00005f00362e7a11ULL, 0x000fe200010f441fULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000000e490e7210ULL, 0x000fc40007f3e0ffULL,
0x00005f002c007a11ULL, 0x000fe400018f441dULL, 0x0000001049107210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x0000001249127210ULL, 0x040fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000b901c46ULL,
0x0000001449147210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x0000001649167210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff137224ULL, 0x000fe200018e0613ULL,
0x0000001849187210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e0615ULL,
0x0000001c491c7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e0617ULL,
0x0000001e491e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x0000003a49207210ULL, 0x040fe20007f7e0ffULL, 0x000000000e2b7faeULL, 0x0005e2000b901c46ULL,
0x0000002249227210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e061bULL,
0x0000002449247210ULL, 0x040fe20007f9e0ffULL, 0x00000000102d7faeULL, 0x0003e2000b901c46ULL,
0x0000002649267210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e061aULL,
0x0000002849287210ULL, 0x040fe20007f3e0ffULL, 0x00000000122f7faeULL, 0x0003e2000b901c46ULL,
0x00000006491a7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff217224ULL, 0x000fe200018e063cULL,
0x0000002a492a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000014317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x000fc400028e0623ULL, 0x000000ffff257224ULL, 0x000fe200020e0625ULL,
0x0000000016337faeULL, 0x0003e2000b901c46ULL, 0x000000ffff277224ULL, 0x000fe400000e0627ULL,
0x000000ffff297224ULL, 0x000fe200008e0629ULL, 0x0000000018357faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fe400010e062eULL, 0x000000ffff2b7224ULL, 0x004fe200018e0600ULL,
0x000000001c377faeULL, 0x0003e8000b901c46ULL, 0x000000001e397faeULL, 0x0003e8000b901c46ULL,
0x00000000203b7faeULL, 0x0003e8000b901c46ULL, 0x00000000223d7faeULL, 0x0003e8000b901c46ULL,
0x00000000243f7faeULL, 0x0003e8000b901c46ULL, 0x0000000026417faeULL, 0x0003e8000b901c46ULL,
0x0000000028437faeULL, 0x0003e8000b901c46ULL, 0x000000001a457faeULL, 0x0003e8000b901c46ULL,
0x000000002a477faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000c7805ULL, 0x002fc40000015200ULL, 0x01b60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c097210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0e7824ULL, 0x000fe200000e0e0dULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140eULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e060eULL, 0x0000000200007819ULL, 0x000fc80000001209ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000595e00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e620000000000ULL,
0x0000640008557a24ULL, 0x000fe200078e02ffULL, 0x0001b6885c087811ULL, 0x040fe200078e18ffULL,
0x000000205c007824ULL, 0x000fe200078e00ffULL, 0xffffffff590b7810ULL, 0x000fc40007ffe0ffULL,
0x000001005e097824ULL, 0x000fe200078e0205ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000095a00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x000000015e0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000702077224ULL, 0x000fc600078e02ffULL,
0x000000590a00720cULL, 0x000fda0003f06070ULL, 0x00000d8000008947ULL, 0x000fea0003800000ULL,
0x00000003ff3d7819ULL, 0x102fe40000011606ULL, 0x0ffffff8066b7812ULL, 0x000fe400078ec0ffULL,
0x000000043d0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001030a7824ULL, 0x000fe200078e023dULL,
0x000000083d117810ULL, 0x040fe40007ffe0ffULL, 0x0000000c3d397810ULL, 0x000fe20007ffe0ffULL,
0x000000010f357824ULL, 0x100fe200078e0206ULL, 0x0000000a070c7210ULL, 0x000fe20007f1e0ffULL,
0x000000080f0e7824ULL, 0x000fe200078e00ffULL, 0x000000103d417810ULL, 0x000fe20007ffe0ffULL,
0x00000001110a7824ULL, 0x000fe200078e0206ULL, 0x000000143d457810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005e000c147a11ULL, 0x000fe200078040ffULL,
0x00000008113f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e357812ULL, 0x000fe200078ee235ULL,
0x00000001030e7824ULL, 0x040fe200078e0211ULL, 0x00005f000c157a11ULL, 0x000fe200000f440dULL,
0x00000001030c7824ULL, 0x000fe200078e020fULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee20aULL,
0x0000000103107824ULL, 0x000fe200078e0239ULL, 0x0000000e070e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000103127824ULL, 0x000fe200078e0241ULL, 0x0000000c070c7210ULL, 0x040fe20007f9e0ffULL,
0x000000015a0a7824ULL, 0x000fe200078e0a09ULL, 0x0000001007107210ULL, 0x000fe20007f5e0ffULL,
0x00000001412e7824ULL, 0x000fe200078e0206ULL, 0x0000001207127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x0000000a1100720cULL, 0x080fe20003f26070ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x0000000a0f00720cULL, 0x000fe20003f06070ULL,
0x000000ffff0f7224ULL, 0x000fe200010e06ffULL, 0x00005e000c267a11ULL, 0x000fe200078840ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x00005e000e227a11ULL, 0x000fe200078a40ffULL,
0x0000000841437824ULL, 0x000fe200078e00ffULL, 0x000000183d477810ULL, 0x000fc40007ffe0ffULL,
0x00005e0010247a11ULL, 0x000fe400078440ffULL, 0x0000001c3d497810ULL, 0x040fe40007ffe0ffULL,
0x00005e0012187a11ULL, 0x000fe400078640ffULL, 0x000000203d4b7810ULL, 0x000fe40007ffe0ffULL,
0x00005f000c277a11ULL, 0x000fe200020f4413ULL, 0x00000001030c7824ULL, 0x040fe200078e0245ULL,
0x00005f000e237a11ULL, 0x000fe200028f4411ULL, 0x00000001030e7824ULL, 0x040fe200078e0247ULL,
0x00005f0010257a11ULL, 0x000fe200010f440fULL, 0x0000000103107824ULL, 0x040fe200078e0249ULL,
0x00005f0012197a11ULL, 0x000fe200018f440dULL, 0x0000000103127824ULL, 0x000fe200078e024bULL,
0x0000000c070c7210ULL, 0x000fe20007f9e0ffULL, 0x000000014b307824ULL, 0x000fe200078e0206ULL,
0x0000000e070e7210ULL, 0x000fc40007fbe0ffULL, 0x0000001007107210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x0000001207127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00005e000c207a11ULL, 0x000fe200078840ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e06ffULL, 0x000000243d317810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x00005e000e1e7a11ULL, 0x000fe400078a40ffULL,
0x000000283d2f7810ULL, 0x000fc40007ffe0ffULL, 0x00005e00101c7a11ULL, 0x000fe400078440ffULL,
0x0000002c3d2d7810ULL, 0x040fe40007ffe0ffULL, 0x00005e00121a7a11ULL, 0x000fe400078640ffULL,
0x000000303d2b7810ULL, 0x000fe40007ffe0ffULL, 0x00005f000c217a11ULL, 0x000fe200020f4413ULL,
0x00000001030c7824ULL, 0x040fe200078e0231ULL, 0x00005f000e1f7a11ULL, 0x000fe200028f4411ULL,
0x00000001030e7824ULL, 0x040fe200078e022fULL, 0x00005f00101d7a11ULL, 0x000fe200010f440fULL,
0x0000000103107824ULL, 0x040fe200078e022dULL, 0x00005f00121b7a11ULL, 0x000fe200018f440dULL,
0x0000000103127824ULL, 0x000fe200078e022bULL, 0x0000000c07137210ULL, 0x000fc40007f9e0ffULL,
0x0000000e07117210ULL, 0x040fe40007fbe0ffULL, 0x00000010070f7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x00000012070c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200028e06ffULL, 0x00005e0013167a11ULL, 0x000fe200078840ffULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x00005e0011127a11ULL, 0x000fe200078a40ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x00005e000f107a11ULL, 0x000fc400078440ffULL,
0x00005e000c0e7a11ULL, 0x040fe400078640ffULL, 0x00005f0013177a11ULL, 0x000fe200020f442cULL,
0x00000001392c7824ULL, 0x000fe200078e0206ULL, 0x00005f0011137a11ULL, 0x000fe400028f442aULL,
0x00005f000f117a11ULL, 0x000fe400010f4428ULL, 0x00005f000c0f7a11ULL, 0x000fe200018f440dULL,
0x000000013d0c7824ULL, 0x040fe200078e0206ULL, 0x000000343d337810ULL, 0x000fc40007ffe0ffULL,
0x0000000a3900720cULL, 0x0c0fe20003fa6070ULL, 0x0000000839397824ULL, 0x000fe200078e00ffULL,
0x000000076b3b7812ULL, 0x000fe200078ef80cULL, 0x00000001030c7824ULL, 0x000fe200078e0233ULL,
0x0000000706377812ULL, 0x000fe400078ec0ffULL, 0x0000000a3d00720cULL, 0x000fe40003f46070ULL,
0x0000000c070d7210ULL, 0x000fe40007f7e0ffULL, 0x0000000a4100720cULL, 0x000fc40003f86070ULL,
0x000030005c287811ULL, 0x000fe200078e70ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x0000000837297812ULL, 0x000fe400078efcffULL, 0xfffffff839417812ULL, 0x000fe200078ee22cULL,
0x000000103b3b7824ULL, 0x000fe200078e0228ULL, 0x00005e000d0c7a11ULL, 0x000fe200078640ffULL,
0x0000001029147825ULL, 0x000fe200078e0014ULL, 0x000000383d397810ULL, 0x000fe40007ffe0ffULL,
0x00005f000d0d7a11ULL, 0x000fe200018f442aULL, 0x0000001035357824ULL, 0x100fe200078e0228ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143b7faeULL, 0x0003e2000d101c46ULL,
0x00000001032a7824ULL, 0x000fe200078e0239ULL, 0x0000003c3d4d7810ULL, 0x000fe20007ffe0ffULL,
0x000000103f3d7824ULL, 0x000fe200078e0228ULL, 0xfffffff843437812ULL, 0x000fe200078ee22eULL,
0x00000001452e7824ULL, 0x000fe200078e0206ULL, 0x0000002a072c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001029267825ULL, 0x000fe200078e0026ULL, 0x0000000a4500720cULL, 0x000fc60003f66070ULL,
0x000000ffff3f7224ULL, 0x000fe200010e06ffULL, 0x00005e002c147a11ULL, 0x042fe200078c40ffULL,
0x0000000845457824ULL, 0x000fe200078e00ffULL, 0x0000000026357faeULL, 0x0003e2000c101c46ULL,
0x0000001029227825ULL, 0x000fe200078e0022ULL, 0x00005f002c157a11ULL, 0x000fe400030f443fULL,
0x0000000a4700720cULL, 0x080fe20003fc6070ULL, 0x00000001032a7824ULL, 0x000fe200078e024dULL,
0xfffffff8453b7812ULL, 0x000fe200078ee22eULL, 0x00000001472c7824ULL, 0x140fe200078e0206ULL,
0x00000000223d7faeULL, 0x0005e2000c901c46ULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0x0000000a4b00720cULL, 0x000fe20003f06070ULL, 0x00000001492e7824ULL, 0x000fe200078e0206ULL,
0x0000002a072a7210ULL, 0x000fe20007f5e0ffULL, 0x00000008493f7824ULL, 0x040fe200078e00ffULL,
0x0000000a4900720cULL, 0x000fe20003f26070ULL, 0x000000084b4b7824ULL, 0x000fc400078e00ffULL,
0x0000001041077824ULL, 0x000fe200078e0228ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee22eULL,
0x0000001029247825ULL, 0x000fe200078e0024ULL, 0xfffffff8473d7812ULL, 0x004fe400078ee22cULL,
0xfffffff84b417812ULL, 0x000fe200078ee230ULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x00005e002a227a11ULL, 0x040fe200078440ffULL, 0x0000001043277824ULL, 0x002fe200078e0228ULL,
0x0000000024077faeULL, 0x0003e2000e901c46ULL, 0x0000001029187825ULL, 0x000fe200078e0018ULL,
0x00005f002a237a11ULL, 0x000fc400010f4423ULL, 0x0000000a2d00720cULL, 0x080fe20003f46070ULL,
0x000000103b357824ULL, 0x000fe200078e0228ULL, 0x0000000018277faeULL, 0x0005e2000e101c46ULL,
0x0000001029207825ULL, 0x000fe200078e0020ULL, 0x0000000a3300720cULL, 0x080fe40003f86070ULL,
0x0000000a3900720cULL, 0x080fe20003fa6070ULL, 0x000000103d3b7824ULL, 0x000fe200078e0228ULL,
0x0000000020357faeULL, 0x0007e2000d901c46ULL, 0x00000010291e7825ULL, 0x000fe200078e001eULL,
0x0000000a2b00720cULL, 0x000fc60003f66070ULL, 0x000000103f3d7824ULL, 0x000fe200078e0228ULL,
0x000000001e3b7faeULL, 0x0009e2000f101c46ULL, 0x00000010291c7825ULL, 0x000fe200078e001cULL,
0x0000000a4d00720cULL, 0x000fc60003fc6070ULL, 0x00000010413f7824ULL, 0x000fe200078e0228ULL,
0x000000001c3d7faeULL, 0x0007e2000c901c46ULL, 0x00000010291a7825ULL, 0x000fe200078e001aULL,
0x0000000a2f00720cULL, 0x000fc60003f26070ULL, 0x000000012d187824ULL, 0x144fe200078e0206ULL,
0x000000001a3f7faeULL, 0x0005e2000c101c46ULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x0000000a3100720cULL, 0x040fe20003f06070ULL, 0x0000000131077824ULL, 0x142fe400078e0206ULL,
0x0000000831267824ULL, 0x000fe400078e00ffULL, 0x000000012f247824ULL, 0x140fe400078e0206ULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff826077812ULL, 0x000fe200078ee207ULL,
0x000000012b0a7824ULL, 0x000fe200078e0206ULL, 0xfffffff82d1b7812ULL, 0x004fe200078ee218ULL,
0x000000082b1d7824ULL, 0x008fe200078e00ffULL, 0xfffffff82f197812ULL, 0x000fe200078ee224ULL,
0x0000000133187824ULL, 0x000fc400078e0206ULL, 0x00000008331f7824ULL, 0x010fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20aULL, 0x00000001391a7824ULL, 0x040fe400078e0206ULL,
0x0000000839217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee218ULL,
0x000000014d1c7824ULL, 0x040fe400078e0206ULL, 0x000000084d257824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee21aULL, 0x0000001007077824ULL, 0x000fc400078e0228ULL,
0x0000001029167825ULL, 0x000fe200078e0016ULL, 0xfffffff825257812ULL, 0x000fc600078ee21cULL,
0x0000001019197824ULL, 0x000fe200078e0228ULL, 0x0000000016077faeULL, 0x0003e2000c101c46ULL,
0x0000001029127825ULL, 0x000fc800078e0012ULL, 0x000000101b1b7824ULL, 0x000fe200078e0228ULL,
0x0000000012197faeULL, 0x0003e2000c901c46ULL, 0x0000001029107825ULL, 0x000fc800078e0010ULL,
0x000000101d1d7824ULL, 0x000fe200078e0228ULL, 0x00000000101b7faeULL, 0x0003e2000d101c46ULL,
0x00000010290e7825ULL, 0x000fc800078e000eULL, 0x000000101f1f7824ULL, 0x000fe200078e0228ULL,
0x000000000e1d7faeULL, 0x0003e2000d901c46ULL, 0x00000010290c7825ULL, 0x000fc800078e000cULL,
0x0000001021217824ULL, 0x000fe200078e0228ULL, 0x000000000c1f7faeULL, 0x0003e2000e101c46ULL,
0x0000001029147825ULL, 0x000fc800078e0014ULL, 0x0000001025257824ULL, 0x000fe200078e0228ULL,
0x0000000014217faeULL, 0x0003e2000e901c46ULL, 0x0000001029227825ULL, 0x000fca00078e0022ULL,
0x0000000022257faeULL, 0x0003e2000f101c46ULL, 0x00000c5000007947ULL, 0x000fea0003800000ULL,
0x0000000c06117811ULL, 0x042fe400078fe8ffULL, 0x00000004060e7811ULL, 0x040fe400078fe8ffULL,
0x00000024062f7811ULL, 0x040fe200078fe8ffULL, 0x00000001112a7824ULL, 0x140fe200078e0206ULL,
0x0000001406147811ULL, 0x040fe200078fe8ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x00000008060f7811ULL, 0x000fe200078fe8ffULL, 0x000000010e247824ULL, 0x000fe200078e0206ULL,
0x0000002806317811ULL, 0x000fe200078fe8ffULL, 0x000000080e0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8152a7812ULL, 0x000fe200078ee22aULL, 0x000000012f237824ULL, 0x100fe200078e0206ULL,
0x0000001806157811ULL, 0x000fe200078fe8ffULL, 0x0000000114287824ULL, 0x040fe200078e0206ULL,
0xfffffff80d247812ULL, 0x000fe200078ee224ULL, 0x00000008140d7824ULL, 0x000fe200078e00ffULL,
0x0000002c06337811ULL, 0x040fe200078fe8ffULL, 0x0000000115277824ULL, 0x040fe200078e0206ULL,
0x0000003406357811ULL, 0x040fe200078fe8ffULL, 0x00000008150c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d287812ULL, 0x000fe200078ee228ULL, 0x000000010f207824ULL, 0x140fe200078e0206ULL,
0x0000001c062d7811ULL, 0x000fe200078fe8ffULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0xfffffff80c277812ULL, 0x000fe200078ee227ULL, 0x000000082f0c7824ULL, 0x000fe200078e00ffULL,
0x00000020062e7811ULL, 0x000fe200078fe8ffULL, 0x0000000131227824ULL, 0x000fe200078e0206ULL,
0xfffffff813207812ULL, 0x000fe200078ee220ULL, 0x00000008310d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c237812ULL, 0x000fe200078ee223ULL, 0x0000000133217824ULL, 0x140fe200078e0206ULL,
0x00000003060c7211ULL, 0x040fe200078fe8ffULL, 0x0000000833107824ULL, 0x000fe200078e00ffULL,
0x0000001006137811ULL, 0x000fe200078fe8ffULL, 0x00000001352b7824ULL, 0x000fe200078e0206ULL,
0x000000070c0c7210ULL, 0x080fe20007f1e0ffULL, 0x0000000103127824ULL, 0x000fe200078e020eULL,
0xfffffff80d227812ULL, 0x000fe200078ee222ULL, 0x0000000113297824ULL, 0x140fe200078e0206ULL,
0xfffffff810217812ULL, 0x000fe200078ee221ULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e000c1e7a11ULL, 0x000fe200078040ffULL, 0x00000008130a7824ULL, 0x000fe200078e00ffULL,
0x0000003006347811ULL, 0x000fe200078fe8ffULL, 0x0000000835107824ULL, 0x000fe200078e00ffULL,
0x00005f000c1f7a11ULL, 0x000fe200000f440dULL, 0x00000001030c7824ULL, 0x040fe200078e0213ULL,
0xfffffff80a297812ULL, 0x000fe200078ee229ULL, 0x00000001030e7824ULL, 0x000fe200078e0211ULL,
0xfffffff8102b7812ULL, 0x000fe200078ee22bULL, 0x000000012d267824ULL, 0x140fe200078e0206ULL,
0x0000003806377811ULL, 0x000fe200078fe8ffULL, 0x000000082d177824ULL, 0x000fe200078e00ffULL,
0x000000070c0c7210ULL, 0x080fe20007f7e0ffULL, 0x000000012e257824ULL, 0x000fe200078e0206ULL,
0x000000070e0e7210ULL, 0x080fe20007f5e0ffULL, 0x000000082e0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff817267812ULL, 0x000fe200078ee226ULL, 0x0000000103107824ULL, 0x000fe200078e020fULL,
0x0000000712127210ULL, 0x080fe20007f1e0ffULL, 0x00000001342c7824ULL, 0x100fe200078e0206ULL,
0xfffffff80a257812ULL, 0x000fe200078ee225ULL, 0x0000000834177824ULL, 0x000fe200078e00ffULL,
0x0000000710107210ULL, 0x080fe20007f3e0ffULL, 0x00000001370a7824ULL, 0x040fe200078e0206ULL,
0x00000006063c7211ULL, 0x000fe200078fe8ffULL, 0x0000000837197824ULL, 0x000fe200078e00ffULL,
0xfffffff8172c7812ULL, 0x000fe200078ee22cULL, 0x000000ffff0d7224ULL, 0x000fe200018e06ffULL,
0x00005e000c167a11ULL, 0x000fe200078640ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x00005e000e187a11ULL, 0x000fe200078440ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0xfffffff8190a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00005e00121c7a11ULL, 0x000fe200078040ffULL, 0x0000000103147824ULL, 0x040fe200078e0214ULL,
0x00005f000c177a11ULL, 0x000fe200018f440dULL, 0x00000001030c7824ULL, 0x040fe200078e0215ULL,
0x00005e00101a7a11ULL, 0x000fe200078240ffULL, 0x00000001032e7824ULL, 0x040fe200078e022eULL,
0x00005f000e197a11ULL, 0x000fe200010f440fULL, 0x00000001030e7824ULL, 0x040fe200078e022dULL,
0x00005f00121d7a11ULL, 0x000fe200000f4413ULL, 0x0000000103387824ULL, 0x040fe200078e0231ULL,
0x00005f00101b7a11ULL, 0x000fe200008f4411ULL, 0x0000000103367824ULL, 0x040fe200078e0233ULL,
0x0000000714137210ULL, 0x080fe20007f1e0ffULL, 0x0000000103347824ULL, 0x000fe200078e0234ULL,
0x000000070c117210ULL, 0x000fc40007f3e0ffULL, 0x000000070e0f7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x000000072e0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff307224ULL, 0x000fe200008e06ffULL, 0x00005e0013147a11ULL, 0x000fe200078040ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005e0011127a11ULL, 0x000fe200078240ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x00005e000f107a11ULL, 0x000fe400078440ffULL,
0x00005e000c0e7a11ULL, 0x000fc400078640ffULL, 0x0000003c062d7811ULL, 0x000fe400078fe8ffULL,
0x00005f0013157a11ULL, 0x000fe200000f4432ULL, 0x0000000103327824ULL, 0x000fe200078e0235ULL,
0x00005f0011137a11ULL, 0x000fe200008f4430ULL, 0x0000000103307824ULL, 0x000fe200078e0237ULL,
0x00005f000f117a11ULL, 0x000fe200010f442eULL, 0x00000001032e7824ULL, 0x040fe200078e022dULL,
0x00005f000c0f7a11ULL, 0x000fe200018f440dULL, 0x00000001030c7824ULL, 0x000fe200078e022fULL,
0x0ffffff8066b7812ULL, 0x040fe200078ec0ffULL, 0x000000012d2f7824ULL, 0x040fe200078e0206ULL,
0x0000000706377812ULL, 0x000fe200078ec0ffULL, 0x000000082d3e7824ULL, 0x000fe200078e00ffULL,
0x000030005c4b7811ULL, 0x000fc400078e70ffULL, 0x0000000738387210ULL, 0x080fe40007fbe0ffULL,
0x000000070c0d7210ULL, 0x080fe20007fde0ffULL, 0x00000010233f7824ULL, 0x100fe200078e024bULL,
0x0000000736367210ULL, 0x080fe20007f9e0ffULL, 0x000000102a317824ULL, 0x100fe200078e024bULL,
0x0000000734347210ULL, 0x080fe20007f7e0ffULL, 0x0000001021437824ULL, 0x100fe200078e024bULL,
0x0000000732327210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff237224ULL, 0x000fe200028e06ffULL,
0x0000000730307210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200030e06ffULL,
0x000000072e2e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001028357824ULL, 0x100fe200078e024bULL,
0x000000076b077812ULL, 0x000fe200078ef83cULL, 0x000000ffff217224ULL, 0x000fe200020e06ffULL,
0x00000008374d7812ULL, 0x000fe200078efcffULL, 0x00000010242d7824ULL, 0x100fe200078e024bULL,
0x00005e00382a7a11ULL, 0x000fe200078a40ffULL, 0x0000001007077824ULL, 0x000fe200078e024bULL,
0x00005e000d0c7a11ULL, 0x000fe200078c40ffULL, 0x000000104d1e7825ULL, 0x000fe200078e001eULL,
0x00005e0036287a11ULL, 0x000fc400078840ffULL, 0xfffffff83e3c7812ULL, 0x000fe200078ee22fULL,
0x0000001027397824ULL, 0x000fe200078e024bULL, 0x00005f000d0d7a11ULL, 0x000fe200030f443aULL,
0x000000104d1c7825ULL, 0x000fe200078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e077faeULL, 0x0003e6000b901c46ULL, 0x00000010202f7824ULL, 0x100fe200078e024bULL,
0x000000001c2d7faeULL, 0x0003e2000b901c46ULL, 0x00000010263b7824ULL, 0x100fe400078e024bULL,
0x00000010253d7824ULL, 0x000fc400078e024bULL, 0x000000102b477824ULL, 0x000fe200078e024bULL,
0x00005f00382b7a11ULL, 0x000fe200028f4423ULL, 0x000000ffff277224ULL, 0x000fe200018e06ffULL,
0x00005e0034267a11ULL, 0x000fe200078640ffULL, 0x000000104d1a7825ULL, 0x000fc600078e001aULL,
0x00005f0034277a11ULL, 0x000fe200018f4427ULL, 0x0000001029337824ULL, 0x000fe200078e024bULL,
0x00005f0036297a11ULL, 0x000fe200020f4421ULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x00005e0032247a11ULL, 0x040fe200078040ffULL, 0x000000104d187825ULL, 0x040fe200078e0018ULL,
0x000000001a2f7faeULL, 0x0003e4000b901c46ULL, 0x00005f0032257a11ULL, 0x000fe200000f4425ULL,
0x0000001022417824ULL, 0x000fe200078e024bULL, 0x0000000018317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x000fe200010e06ffULL, 0x00005e0030227a11ULL, 0x000fe200078440ffULL,
0x000000104d167825ULL, 0x000fc600078e0016ULL, 0x00005f0030237a11ULL, 0x000fe200010f4423ULL,
0x000000ffff217224ULL, 0x000fe200008e06ffULL, 0x00005e002e207a11ULL, 0x040fe200078240ffULL,
0x000000104d147825ULL, 0x040fe200078e0014ULL, 0x0000000016337faeULL, 0x0003e4000b901c46ULL,
0x00005f002e217a11ULL, 0x000fe200008f4421ULL, 0x000000104d127825ULL, 0x040fe200078e0012ULL,
0x0000000014357faeULL, 0x0003e6000b901c46ULL, 0x000000104d107825ULL, 0x040fe200078e0010ULL,
0x0000000012397faeULL, 0x0003e6000b901c46ULL, 0x000000104d0e7825ULL, 0x040fe200078e000eULL,
0x00000000103b7faeULL, 0x0003e6000b901c46ULL, 0x000000104d0c7825ULL, 0x040fe200078e000cULL,
0x000000000e3d7faeULL, 0x0003e6000b901c46ULL, 0x000000104d2a7825ULL, 0x040fe200078e002aULL,
0x000000000c3f7faeULL, 0x0003e6000b901c46ULL, 0x000000104d287825ULL, 0x040fe200078e0028ULL,
0x000000002a417faeULL, 0x0003e6000b901c46ULL, 0x000000102c457824ULL, 0x000fe200078e024bULL,
0x0000000028437faeULL, 0x0003e2000b901c46ULL, 0x000000104d267825ULL, 0x000fc800078e0026ULL,
0x000000104d247825ULL, 0x040fe200078e0024ULL, 0x0000000026457faeULL, 0x0003e6000b901c46ULL,
0x000000100a497824ULL, 0x000fe200078e024bULL, 0x0000000024477faeULL, 0x0003e2000b901c46ULL,
0x000000104d227825ULL, 0x000fc800078e0022ULL, 0x000000103c4b7824ULL, 0x000fe200078e024bULL,
0x0000000022497faeULL, 0x0003e2000b901c46ULL, 0x000000104d207825ULL, 0x000fca00078e0020ULL,
0x00000000204b7faeULL, 0x0003e4000b901c46ULL, 0x00000004ff0d7424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff077424ULL, 0x000fe400078e00ffULL,
0x000003000d047a24ULL, 0x000fca00078e0204ULL, 0x0000005b0400720cULL, 0x000fda0003f06070ULL,
0x00000002550c8824ULL, 0x000fe200078e0204ULL, 0x00000004ff0e7819ULL, 0x100fe40000011606ULL,
0x00000008375d7812ULL, 0x000fe200078ef806ULL, 0x000060000c0c8625ULL, 0x000fe200078e000dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000060c078981ULL, 0x000322000c1e1900ULL,
0x000000010e5f7824ULL, 0x000fe200078e025dULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000105d0a7824ULL, 0x000fca00078e00ffULL, 0xfffffff00a0a7812ULL, 0x000fca00078ee25fULL,
0x000000100a0a7824ULL, 0x000fc400078e00ffULL, 0x000000080e0e7824ULL, 0x002fe200078e00ffULL,
0x00000003ff6a7819ULL, 0x000fe20000011606ULL, 0x000040005c6c7824ULL, 0x000fe200078e00ffULL,
0x000000000a28783bULL, 0x0003e40000000200ULL, 0xfffffff80e377812ULL, 0x000fe200078ee237ULL,
0x000000105d0e7824ULL, 0x000fe200078e00ffULL, 0x000000016a0c7812ULL, 0x000fe400078ec0ffULL,
0x000010006c6d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008370d7824ULL, 0x040fe200078e00ffULL,
0x0000001037357810ULL, 0x040fe20007ffe0ffULL, 0x000000010c367824ULL, 0x040fe200078e0237ULL,
0x0000002037347810ULL, 0x040fe20007ffe0ffULL, 0x00000008370f7824ULL, 0x040fe200078e00ffULL,
0x00000030370a7810ULL, 0x002fe20007ffe0ffULL, 0x000000010c697824ULL, 0x040fe200078e0235ULL,
0xfffffff80d6e7812ULL, 0x000fe200078ee236ULL, 0x000000010c687824ULL, 0x040fe200078e0234ULL,
0x000000025f0d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010c677824ULL, 0x000fe200078e020aULL,
0x0000000236667810ULL, 0x000fe20007ffe0ffULL, 0x000000106e187824ULL, 0x000fe200078e026dULL,
0xfffffff00e0d7812ULL, 0x000fe200078ee20dULL, 0x000000080a0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f667812ULL, 0x000fe200078ee266ULL, 0x00000008350e7824ULL, 0x000fe200078e00ffULL,
0x0000001236657810ULL, 0x000fe20007ffe0ffULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0xfffffff80c677812ULL, 0x000fe200078ee267ULL, 0x00000008340f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e697812ULL, 0x000fe200078ee269ULL, 0x00000010664c7824ULL, 0x100fe200078e026dULL,
0x0000002236647810ULL, 0x040fe20007ffe0ffULL, 0x00000010672c7824ULL, 0x100fe200078e026dULL,
0xfffffff80f687812ULL, 0x000fe200078ee268ULL, 0x0000001069307824ULL, 0x100fe200078e026dULL,
0x0000003236627810ULL, 0x000fe20007ffe0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000fe20000000200ULL, 0x00000010680c7824ULL, 0x000fe200078e026dULL,
0x0000000436637810ULL, 0x000fe20007ffe0ffULL, 0x0000000835107824ULL, 0x000fe200078e00ffULL,
0x000000002c2c783bULL, 0x000ea20000000200ULL, 0x0000000834117824ULL, 0x000fe200078e00ffULL,
0x0000001436617810ULL, 0x000fe20007ffe0ffULL, 0x0000000837387824ULL, 0x000fe200078e00ffULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0xfffffff810657812ULL, 0x000fc400078ee265ULL,
0xfffffff811647812ULL, 0x000fe200078ee264ULL, 0x000000000d24783bULL, 0x000ee20000000200ULL,
0x0000002436607810ULL, 0x040fe20007ffe0ffULL, 0x0000001065147824ULL, 0x100fe200078e026dULL,
0x0000003436587810ULL, 0x000fe20007ffe0ffULL, 0x000000000c0c783bULL, 0x000ee20000000200ULL,
0x00000010641c7824ULL, 0x000fe200078e026dULL, 0x0000000636577810ULL, 0x040fe40007ffe0ffULL,
0x000000001414783bULL, 0x000ee20000000200ULL, 0x0000001636567810ULL, 0x000fc40007ffe0ffULL,
0x0000002636547810ULL, 0x040fe20007ffe0ffULL, 0x000000001c1c783bULL, 0x000ee20000000200ULL,
0x0000003636367810ULL, 0x000fe40007ffe0ffULL, 0xfffffff838577812ULL, 0x000fe200078ee257ULL,
0x000000182850723cULL, 0x002f6800000418ffULL, 0x0000001057387824ULL, 0x000fc800078e026dULL,
0x0000001a2818723cULL, 0x040f6400000418ffULL, 0x000000003838783bULL, 0x000fec0000000200ULL,
0x0000002c2820723cULL, 0x044bee00000418ffULL, 0x000000080a2d7824ULL, 0x020fe200078e00ffULL,
0x000000302810723cULL, 0x008f6800000418ffULL, 0xfffffff82d627812ULL, 0x000fc800078ee262ULL,
0x000000322830723cULL, 0x000f6200000418ffULL, 0x00000010622c7824ULL, 0x000fce00078e026dULL,
0x0000004c2450723cULL, 0x040ff00000041850ULL, 0x0000004e244c723cULL, 0x000ff00000041818ULL,
0x0000000c2818723cULL, 0x040f7000000418ffULL, 0x0000000e280c723cULL, 0x040f7000000418ffULL,
0x0000002e2828723cULL, 0x000b6400000418ffULL, 0x000000002c2c783bULL, 0x020e6c0000000200ULL,
0x000000142410723cULL, 0x040f700000041810ULL, 0x000000162414723cULL, 0x040b6e0000041830ULL,
0x000000105d317824ULL, 0x020fe200078e00ffULL, 0x000000045f307810ULL, 0x000fe20007ffe0ffULL,
0x0000001c2418723cULL, 0x000b620000041818ULL, 0x0000000835327824ULL, 0x000fc400078e00ffULL,
0xfffffff031307812ULL, 0x000fe200078ee230ULL, 0x000000080a317824ULL, 0x000fe400078e00ffULL,
0xfffffff832617812ULL, 0x000fe200078ee261ULL, 0x00000008371c7824ULL, 0x020fe400078e00ffULL,
0x00000008341d7824ULL, 0x000fe200078e00ffULL, 0xfffffff831587812ULL, 0x000fe200078ee258ULL,
0x0000001061487824ULL, 0x000fe200078e026dULL, 0xfffffff81c637812ULL, 0x000fe200078ee263ULL,
0x0000001030307824ULL, 0x000fe200078e00ffULL, 0xfffffff81d607812ULL, 0x000fe200078ee260ULL,
0x0000001058407824ULL, 0x100fe200078e026dULL, 0x0000001e241c723cULL, 0x040b62000004180cULL,
0x000000004848783bULL, 0x000fe20000000200ULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x000000065f317810ULL, 0x000fe20007ffe0ffULL, 0x0000001060447824ULL, 0x100fe200078e026dULL,
0x00000000303c783bULL, 0x0004e20000000200ULL, 0x000000080a337824ULL, 0x000fe200078e00ffULL,
0xfffffff835567812ULL, 0x000fe200078ee256ULL, 0x00000010630c7824ULL, 0x020fe200078e026dULL,
0x000000004040783bULL, 0x000fe20000000200ULL, 0x0000002c2420723cULL, 0x042b620000041820ULL,
0x000000105d327824ULL, 0x000fe200078e00ffULL, 0xfffffff8330a7812ULL, 0x000fe200078ee236ULL,
0x000000004444783bULL, 0x000fe60000000200ULL, 0xfffffff032317812ULL, 0x000fe200078ee231ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x00000008342d7824ULL, 0x020fe200078e00ffULL,
0x0000002e2424723cULL, 0x000b620000041828ULL, 0x0000001056347824ULL, 0x000fc400078e026dULL,
0x000000100a2c7824ULL, 0x100fe200078e026dULL, 0xfffffff82d547812ULL, 0x000fe200078ee254ULL,
0x00000010316f7824ULL, 0x000fe400078e00ffULL, 0x000000003434783bULL, 0x000fe40000000200ULL,
0x0000001054307824ULL, 0x004fe400078e026dULL, 0x000000006f28783bULL, 0x020ea80000000200ULL,
0x000000003030783bULL, 0x000ea80000000200ULL, 0x000000002c2c783bULL, 0x000ea20000000200ULL,
0x000000483c10723cULL, 0x048bee0000041810ULL, 0x000003005e487a10ULL, 0x020fe20007ffe0ffULL,
0x0000004a3c14723cULL, 0x040ff00000041814ULL, 0x0000000c3c50723cULL, 0x042b6e0000041850ULL,
0x00000001480c7810ULL, 0x020fe20007ffe0ffULL, 0x0000000e3c4c723cULL, 0x000f66000004184cULL,
0x000000590c00720cULL, 0x000fca0003f06070ULL, 0x000000443c18723cULL, 0x040f700000041818ULL,
0x000000463c1c723cULL, 0x040f70000004181cULL, 0x000000403c20723cULL, 0x040f700000041820ULL,
0x000000423c24723cULL, 0x000f700000041824ULL, 0x000000382850723cULL, 0x044f700000041850ULL,
0x0000003a284c723cULL, 0x060f70000004184cULL, 0x000000342810723cULL, 0x040f700000041810ULL,
0x000000362814723cULL, 0x040f700000041814ULL, 0x000000302818723cULL, 0x040f700000041818ULL,
0x00000032281c723cULL, 0x040f70000004181cULL, 0x0000002c2820723cULL, 0x040f700000041820ULL,
0x0000002e2824723cULL, 0x000b6e0000041824ULL, 0x00000002072f7224ULL, 0x030fe200078e02ffULL,
0x00000e7000008947ULL, 0x000fca0003800000ULL, 0x0000010048317824ULL, 0x000fe200078e0205ULL,
0x000000046a2e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000103307824ULL, 0x000fe200078e026aULL,
0x000000086a0d7810ULL, 0x040fe20007ffe0ffULL, 0x000000016a0c7824ULL, 0x100fe200078e0206ULL,
0x000000315a0e7217ULL, 0x000fe20007800000ULL, 0x000000012e337824ULL, 0x100fe200078e0206ULL,
0x0000000c6a287810ULL, 0x040fe20007ffe0ffULL, 0x000000010d7a7824ULL, 0x140fe200078e0206ULL,
0x000000146a7c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010e317824ULL, 0x000fe200078e0a31ULL,
0x0000001c6a787810ULL, 0x000fe20007ffe0ffULL, 0x000000082e0e7824ULL, 0x000fe200078e00ffULL,
0x000000206a727810ULL, 0x040fe20007ffe0ffULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0x000000286a447810ULL, 0x000fe20007ffe0ffULL, 0x00000001282c7824ULL, 0x100fe200078e0206ULL,
0xfffffff80e337812ULL, 0x000fe200078ee233ULL, 0x0000000828297824ULL, 0x000fe200078e00ffULL,
0x000000106a0e7810ULL, 0x000fe20007ffe0ffULL, 0x000000017c707824ULL, 0x000fe200078e0206ULL,
0xfffffff80f7a7812ULL, 0x000fe200078ee27aULL, 0x0000000178467824ULL, 0x000fe200078e0206ULL,
0xfffffff8292c7812ULL, 0x000fe200078ee22cULL, 0x000000010e767824ULL, 0x100fe200078e0206ULL,
0x000000186a3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080e0f7824ULL, 0x000fe200078e00ffULL,
0x0000002c6a3a7810ULL, 0x000fe20007ffe0ffULL, 0x000000087c297824ULL, 0x000fe200078e00ffULL,
0x000000306a3c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001724a7824ULL, 0x000fe200078e0206ULL,
0xfffffff80f767812ULL, 0x000fe200078ee276ULL, 0x00000008780f7824ULL, 0x000fe200078e00ffULL,
0xfffffff829707812ULL, 0x000fe200078ee270ULL, 0x0000000872297824ULL, 0x000fe200078e00ffULL,
0x000000246a747810ULL, 0x000fe20007ffe0ffULL, 0x00000001443e7824ULL, 0x040fe200078e0206ULL,
0xfffffff80f467812ULL, 0x000fe200078ee246ULL, 0x00000008440f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8294a7812ULL, 0x000fe200078ee24aULL, 0x000000013f2a7824ULL, 0x040fe200078e0206ULL,
0x000000386a367810ULL, 0x000fe20007ffe0ffULL, 0x000000083f2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f3e7812ULL, 0x000fe200078ee23eULL, 0x000000013a387824ULL, 0x000fe200078e0206ULL,
0x000000346a407810ULL, 0x000fe20007ffe0ffULL, 0x000000083a297824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2a7812ULL, 0x000fe200078ee22aULL, 0x000000013c347824ULL, 0x000fe200078e0206ULL,
0x000000312e00720cULL, 0x000fe20003fa6070ULL, 0x000000083c0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff829387812ULL, 0x000fe200078ee238ULL, 0x0000000174427824ULL, 0x000fe200078e0206ULL,
0x0000002f30297210ULL, 0x000fe20007f1e0ffULL, 0x00000008742b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f347812ULL, 0x000fe200078ee234ULL, 0x00000001032d7824ULL, 0x000fe200078e022eULL,
0x000000310d00720cULL, 0x080fe20003f86070ULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0xfffffff82b427812ULL, 0x000fe200078ee242ULL, 0x0000000136307824ULL, 0x040fe200078e0206ULL,
0x00005e00292b7a11ULL, 0x000fe200078040ffULL, 0x0000000836377824ULL, 0x000fe200078e00ffULL,
0x000000312800720cULL, 0x000fe20003f66070ULL, 0x00000001033b7824ULL, 0x000fe200078e0228ULL,
0x00005f0029297a11ULL, 0x000fe200000f440fULL, 0x00000001030f7824ULL, 0x000fe200078e020dULL,
0x0000002f2d2d7210ULL, 0x080fe20007f1e0ffULL, 0x0000000140327824ULL, 0x040fe200078e0206ULL,
0xfffffff837307812ULL, 0x000fe200078ee230ULL, 0x0000000840357824ULL, 0x000fe200078e00ffULL,
0x0000002f0f0f7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200000e06ffULL,
0x00005e002d377a11ULL, 0x000fe200078040ffULL, 0x0000000103397824ULL, 0x000fe200078e027cULL,
0x0000002f3b3b7210ULL, 0x000fc40007f5e0ffULL, 0x00005f002d0d7a11ULL, 0x000fe200000f442eULL,
0x00000010062e7824ULL, 0x000fe200078e00ffULL, 0xfffffff835327812ULL, 0x000fe200078ee232ULL,
0x000000ffff2d7224ULL, 0x000fe200008e06ffULL, 0x00005e000f417a11ULL, 0x000fe200078040ffULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x00005e003b3d7a11ULL, 0x000fe200078240ffULL,
0x0000000103357824ULL, 0x000fe200078e020eULL, 0x000000702e2e7812ULL, 0x000fe400078ec0ffULL,
0x000000316a00720cULL, 0x000fc40003f46070ULL, 0x00005f000f0f7a11ULL, 0x000fe400000f442dULL,
0x00005f003b3b7a11ULL, 0x000fe400008f4428ULL, 0x000000076b0c7812ULL, 0x000fe400078ef80cULL,
0x0000002f35357210ULL, 0x000fe40007f3e0ffULL, 0x0000002b2e287210ULL, 0x000fe20007f1e0ffULL,
0x000000100c437824ULL, 0x000fe200078e026dULL, 0x0000002f39397210ULL, 0x000fe20007fde0ffULL,
0x000000ffff2b7224ULL, 0x000fe200008e06ffULL, 0x00005e00352d7a11ULL, 0x000fe200078240ffULL,
0x000000ffff297224ULL, 0x000fe200000e0629ULL, 0x000000310e00720cULL, 0x000fe20003f06070ULL,
0x00000001030c7824ULL, 0x000fe200078e023fULL, 0x00005f00352b7a11ULL, 0x000fe200008f442bULL,
0x000000ffff0e7224ULL, 0x000fe200030e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028437faeULL, 0x0003e2000d101c46ULL, 0x00005e0039357a11ULL, 0x000fc400078240ffULL,
0x0000002f0c457210ULL, 0x000fe40007f5e0ffULL, 0x000000372e0c7210ULL, 0x040fe40007fde0ffULL,
0x00005f0039397a11ULL, 0x000fe400008f440eULL, 0x000000412e0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff417224ULL, 0x000fe200010e06ffULL, 0x000000313f00720cULL, 0x000fe20003f46070ULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x00005e0045377a11ULL, 0x000fe200078c40ffULL,
0x00000010333f7824ULL, 0x000fc400078e026dULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x00005f0045337a11ULL, 0x000fe200030f4441ULL, 0x0000000103287824ULL, 0x042fe200078e0278ULL,
0x000000317c00720cULL, 0x000fe20003f26070ULL, 0x000000107a417824ULL, 0x000fe200078e026dULL,
0x000000000c3f7faeULL, 0x0003e2000e901c46ULL, 0x00000001037c7824ULL, 0x000fe200078e0272ULL,
0x0000002f28437210ULL, 0x000fe40007fbe0ffULL, 0x000000000e417faeULL, 0x0005e2000e101c46ULL,
0x0000003d2e287210ULL, 0x000fc40007f9e0ffULL, 0x000000ffff7a7224ULL, 0x000fe200028e06ffULL,
0x0000002f7c457210ULL, 0x000fe40007fde0ffULL, 0x00005e00433d7a11ULL, 0x040fe200078a40ffULL,
0x000000ffff297224ULL, 0x000fe200020e063bULL, 0x000000317800720cULL, 0x000fe20003f86070ULL,
0x000000102c0d7824ULL, 0x102fe200078e026dULL, 0x00005f00433b7a11ULL, 0x000fe200028f447aULL,
0x00000001030c7824ULL, 0x000fe200078e0274ULL, 0x00005e0045437a11ULL, 0x000fe200078a40ffULL,
0x000000ffff0e7224ULL, 0x004fe200030e06ffULL, 0x00000000280d7faeULL, 0x0003e2000d901c46ULL,
0x0000002d2e2c7210ULL, 0x000fe20007f7e0ffULL, 0x00000010763f7824ULL, 0x000fe200078e026dULL,
0x0000002f0c0c7210ULL, 0x000fc40007fde0ffULL, 0x00005f0045457a11ULL, 0x000fe200028f440eULL,
0x000000ffff2d7224ULL, 0x000fe200018e062bULL, 0x000000352e0e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff417224ULL, 0x000fe200030e06ffULL, 0x00005e000c357a11ULL, 0x040fe400078640ffULL,
0x000000002c3f7faeULL, 0x0005e2000c101c46ULL, 0x000000ffff0f7224ULL, 0x000fe200028e0639ULL,
0x00005f000c397a11ULL, 0x000fe200018f4441ULL, 0x0000001070417824ULL, 0x100fe200078e026dULL,
0x000000372e0c7210ULL, 0x000fe20007f1e0ffULL, 0x000000102a377824ULL, 0x000fe200078e026dULL,
0x000000317200720cULL, 0x000fc40003fc6070ULL, 0x000000000e417faeULL, 0x0007e2000c901c46ULL,
0x0000003d2e287210ULL, 0x042fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0633ULL,
0x000000432e2a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001046337824ULL, 0x000fe200078e026dULL,
0x000000317400720cULL, 0x000fe20003fa6070ULL, 0x000000ffff297224ULL, 0x000fe200008e063bULL,
0x000000000c377faeULL, 0x0003e2000d101c46ULL, 0x000000104a3b7824ULL, 0x000fe200078e026dULL,
0x0000003c6a707810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e0645ULL,
0x0000000028337faeULL, 0x0009e2000e101c46ULL, 0x00000001030e7824ULL, 0x008fc400078e0244ULL,
0x00000001032c7824ULL, 0x044fe200078e023aULL, 0x000000002a3b7faeULL, 0x0005e2000f101c46ULL,
0x0000000103467824ULL, 0x040fe200078e023cULL, 0x0000002f0e0e7210ULL, 0x000fe20007fde0ffULL,
0x00000001702d7824ULL, 0x000fe200078e0206ULL, 0x000000352e0c7210ULL, 0x002fe20007f7e0ffULL,
0x0000000870747824ULL, 0x000fe400078e00ffULL, 0x00000001034a7824ULL, 0x000fe400078e0240ULL,
0x000000ffff0d7224ULL, 0x000fc400018e0639ULL, 0x0000001042297824ULL, 0x010fe200078e026dULL,
0x0000002f2c3b7210ULL, 0x004fe20007f9e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200030e06ffULL,
0x00005e000e0f7a11ULL, 0x000fe200078c40ffULL, 0x00000001036a7824ULL, 0x040fe200078e0236ULL,
0x000000000c297faeULL, 0x0003e2000e901c46ULL, 0x000000314400720cULL, 0x000fe20003fa6070ULL,
0x000000ffff427224ULL, 0x000fe200020e06ffULL, 0x00005f000e2b7a11ULL, 0x000fe200030f442bULL,
0x0000000103727824ULL, 0x000fe200078e0270ULL, 0x0000000f2e0e7210ULL, 0x000fc40007fde0ffULL,
0x00005e003b337a11ULL, 0x040fe400078840ffULL, 0x0000002f462c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e062bULL, 0x00005f003b3b7a11ULL, 0x000fe200020f4442ULL,
0x000000103e2b7824ULL, 0x000fe200078e026dULL, 0xfffffff874467812ULL, 0x000fe200078ee22dULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x000000313a00720cULL, 0x000fe40003f86070ULL,
0x0000002f4a2a7210ULL, 0x000fe20007f3e0ffULL, 0x000000000e2b7faeULL, 0x0005e2000e901c46ULL,
0x00005e002c357a11ULL, 0x000fc400078040ffULL, 0x000000332e0c7210ULL, 0x002fe20007fbe0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x0000002f6a287210ULL, 0x080fe40007f5e0ffULL,
0x00005f002c3a7a11ULL, 0x000fe200000f442dULL, 0x000000ffff0d7224ULL, 0x000fe200028e063bULL,
0x00005e002a377a11ULL, 0x000fe200078040ffULL, 0x00000010382d7824ULL, 0x000fe200078e026dULL,
0x0000002f722f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff337224ULL, 0x000fe200010e06ffULL,
0x00005f002a397a11ULL, 0x000fc400000f4439ULL, 0x00005e0028297a11ULL, 0x000fe200078040ffULL,
0x000000000c2d7faeULL, 0x0003e2000e101c46ULL, 0x000000352e0e7210ULL, 0x004fe20007f9e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200018e06ffULL, 0x000000313600720cULL, 0x080fe20003fa6070ULL,
0x0000001030357824ULL, 0x000fe200078e026dULL, 0x000000313c00720cULL, 0x080fe20003fc6070ULL,
0x000000ffff0f7224ULL, 0x000fe200020e063aULL, 0x00005f0028367a11ULL, 0x000fe200000f4433ULL,
0x0000001032337824ULL, 0x000fe200078e026dULL, 0x000000314000720cULL, 0x000fc40003f26070ULL,
0x00005e002f2b7a11ULL, 0x040fe400078040ffULL, 0x000000317000720cULL, 0x000fe20003f46070ULL,
0x0000001034317824ULL, 0x100fe200078e026dULL, 0x000000372e287210ULL, 0x000fe20007f9e0ffULL,
0x00000010466d7824ULL, 0x000fe200078e026dULL, 0x000000292e2a7210ULL, 0x040fe40007f7e0ffULL,
0x00005f002f2f7a11ULL, 0x000fe200000f442cULL, 0x000000ffff297224ULL, 0x000fe200020e0639ULL,
0x0000002b2e2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e0636ULL,
0x000000000e317faeULL, 0x0003e6000f101c46ULL, 0x000000ffff2f7224ULL, 0x000fe200000e062fULL,
0x0000000028337faeULL, 0x0003e8000c901c46ULL, 0x000000002a357faeULL, 0x0003e8000e901c46ULL,
0x000000002e6d7faeULL, 0x0003e2000d101c46ULL, 0x00000d3000007947ULL, 0x000fea0003800000ULL,
0x000000046a2a7810ULL, 0x040fe20007ffe0ffULL, 0x000000016a0c7824ULL, 0x040fe200078e0206ULL,
0x0000001c6a0d7810ULL, 0x000fc40007ffe0ffULL, 0x000000086a287810ULL, 0x000fe20007ffe0ffULL,
0x000000012a777824ULL, 0x040fe200078e0206ULL, 0x000000076b797812ULL, 0x000fe200078ef80cULL,
0x000000082a2c7824ULL, 0x000fe200078e00ffULL, 0x000000286a327810ULL, 0x040fe20007ffe0ffULL,
0x000000010d787824ULL, 0x140fe200078e0206ULL, 0x000000146a0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d357824ULL, 0x000fe200078e00ffULL, 0xfffffff82c777812ULL, 0x000fe200078ee277ULL,
0x0000000128317824ULL, 0x000fe200078e0206ULL, 0x000000106a2c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008282e7824ULL, 0x000fe200078e00ffULL, 0xfffffff835787812ULL, 0x000fe200078ee278ULL,
0x0000000132727824ULL, 0x100fe200078e0206ULL, 0x000000246a357810ULL, 0x000fe20007ffe0ffULL,
0x000000012c337824ULL, 0x100fe200078e0206ULL, 0x000000186a297810ULL, 0x000fe20007ffe0ffULL,
0x000000082c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000c6a0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000832397824ULL, 0x000fe200078e00ffULL, 0xfffffff82e317812ULL, 0x000fe200078ee231ULL,
0x0000000135747824ULL, 0x000fe200078e0206ULL, 0xfffffff80c337812ULL, 0x000fe200078ee233ULL,
0x00000001030c7824ULL, 0x000fe200078e026aULL, 0x000000206a2e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000835377824ULL, 0x000fe200078e00ffULL, 0xfffffff839727812ULL, 0x000fe200078ee272ULL,
0x000000010f7c7824ULL, 0x040fe200078e0206ULL, 0x0000002f0c0c7210ULL, 0x080fe20007f1e0ffULL,
0x000000080f2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff837747812ULL, 0x000fe200078ee274ULL,
0x00000001297a7824ULL, 0x040fe200078e0206ULL, 0x000000346a377810ULL, 0x000fe20007ffe0ffULL,
0x00000008292d7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b7c7812ULL, 0x000fe200078ee27cULL,
0x000000ffff397224ULL, 0x000fe200000e06ffULL, 0x00005e000c437a11ULL, 0x000fe200078040ffULL,
0x000000010e757824ULL, 0x040fe200078e0206ULL, 0xfffffff82d7a7812ULL, 0x000fe200078ee27aULL,
0x000000080e307824ULL, 0x000fe200078e00ffULL, 0x0000002c6a2d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001032a7824ULL, 0x040fe200078e022aULL, 0x000000386a367810ULL, 0x000fe20007ffe0ffULL,
0x000000012e767824ULL, 0x000fe200078e0206ULL, 0x00005f000c0c7a11ULL, 0x000fe200000f4439ULL,
0x000000082e2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff830757812ULL, 0x000fe200078ee275ULL,
0x00000001030e7824ULL, 0x040fe200078e020eULL, 0x0000002f2a2a7210ULL, 0x080fe20007f1e0ffULL,
0x0000000103387824ULL, 0x000fe200078e022cULL, 0xfffffff82b767812ULL, 0x000fe200078ee276ULL,
0x0000000137347824ULL, 0x140fe200078e0206ULL, 0x0000002f0e2c7210ULL, 0x080fe20007f5e0ffULL,
0x00000008373d7824ULL, 0x000fe200078e00ffULL, 0x000000306a2b7810ULL, 0x000fe20007ffe0ffULL,
0x000000012d707824ULL, 0x040fe200078e0206ULL, 0x0000002f38387210ULL, 0x000fe20007f7e0ffULL,
0x000000082d3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff83d347812ULL, 0x000fe200078ee234ULL,
0x0000000136307824ULL, 0x000fc400078e0206ULL, 0x00000008363f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b707812ULL, 0x000fe200078ee270ULL, 0x0000000103287824ULL, 0x000fe400078e0228ULL,
0x000000ffff397224ULL, 0x000fe200000e06ffULL, 0xfffffff83f307812ULL, 0x000fe200078ee230ULL,
0x000000ffff3d7224ULL, 0x000fe200010e06ffULL, 0x00005e002a407a11ULL, 0x000fe200078040ffULL,
0x000000012b427824ULL, 0x040fe200078e0206ULL, 0x00005e002c3c7a11ULL, 0x000fe200078440ffULL,
0x000000082b3b7824ULL, 0x000fe200078e00ffULL, 0x0000002f28287210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0x00005e00383a7a11ULL, 0x000fe200078640ffULL,
0x0000000103447824ULL, 0x040fe200078e0229ULL, 0x00005f002a0e7a11ULL, 0x000fe200000f4439ULL,
0x0000000103467824ULL, 0x040fe200078e020dULL, 0x00005f002c2a7a11ULL, 0x000fe200010f443dULL,
0x00000001034a7824ULL, 0x000fe200078e022eULL, 0xfffffff83b427812ULL, 0x000fe200078ee242ULL,
0x000000ffff3b7224ULL, 0x000fe200008e06ffULL, 0x00005f00382c7a11ULL, 0x000fe200018f443fULL,
0x0000000103387824ULL, 0x040fe200078e020fULL, 0x00005e00283e7a11ULL, 0x000fe200078240ffULL,
0x0000000103367824ULL, 0x040fe200078e0236ULL, 0x0000002f46467210ULL, 0x080fe20007f5e0ffULL,
0x0000000103327824ULL, 0x000fe200078e0232ULL, 0x00005f0028287a11ULL, 0x000fe200008f443bULL,
0x0000001042497824ULL, 0x100fe200078e026dULL, 0x0000002f382e7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x0000002f44447210ULL, 0x080fe20007f3e0ffULL,
0x0000001079797824ULL, 0x100fe200078e026dULL, 0x0000002f4a4a7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005e002e387a11ULL, 0x000fe200078040ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0x00005e0044417a11ULL, 0x000fe200078240ffULL,
0x000000ffff397224ULL, 0x000fe200018e06ffULL, 0x00005e00463f7a11ULL, 0x000fe200078440ffULL,
0x0000001077777824ULL, 0x100fe200078e026dULL, 0x00005e004a3d7a11ULL, 0x000fe200078640ffULL,
0x0000001031317824ULL, 0x000fe200078e026dULL, 0x00005f002e2e7a11ULL, 0x000fe200000f440dULL,
0x0000001075757824ULL, 0x000fe200078e026dULL, 0x00005f00440d7a11ULL, 0x000fe200008f440fULL,
0x0000000103447824ULL, 0x040fe200078e0235ULL, 0x00005f00460f7a11ULL, 0x000fe200010f4429ULL,
0x0000000103467824ULL, 0x040fe200078e022dULL, 0x00005f004a297a11ULL, 0x000fe200018f4439ULL,
0x00000001034a7824ULL, 0x040fe200078e022bULL, 0x0000003c6a397810ULL, 0x000fe20007ffe0ffULL,
0x00000001036a7824ULL, 0x000fe200078e0237ULL, 0x0000002f442b7210ULL, 0x080fe20007fde0ffULL,
0x0000001033337824ULL, 0x000fe200078e026dULL, 0x0000002f4a447210ULL, 0x080fe20007f3e0ffULL,
0x0000000103357824ULL, 0x000fe200078e0239ULL, 0x0000002f364a7210ULL, 0x080fe20007f7e0ffULL,
0x0000000139377824ULL, 0x040fe200078e0206ULL, 0x0000002f322d7210ULL, 0x080fe20007fbe0ffULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x0000002f46327210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff427224ULL, 0x000fe200030e06ffULL, 0x0000002f6a467210ULL, 0x080fe20007f5e0ffULL,
0x0000001078737824ULL, 0x000fe200078e026dULL, 0xfffffff839367812ULL, 0x000fe200078ee237ULL,
0x000000107a377824ULL, 0x100fe200078e026dULL, 0x0000002f356a7210ULL, 0x000fe20007f9e0ffULL,
0x000000107c357824ULL, 0x100fe200078e026dULL, 0x00005e002b3b7a11ULL, 0x000fe200078c40ffULL,
0x0000001076717824ULL, 0x000fc400078e026dULL, 0x00000010746f7824ULL, 0x100fe200078e026dULL,
0x00005f002b2b7a11ULL, 0x000fe200030f4442ULL, 0x00000010726b7824ULL, 0x100fe400078e026dULL,
0x00000010704b7824ULL, 0x100fe400078e026dULL, 0x0000001034477824ULL, 0x100fe400078e026dULL,
0x0000001030457824ULL, 0x100fe400078e026dULL, 0x00000010366d7824ULL, 0x000fc400078e026dULL,
0x000000ffff2f7224ULL, 0x000fe200000e06ffULL, 0x00005e0032347a11ULL, 0x000fe200078040ffULL,
0x000000ffff7b7224ULL, 0x000fe200008e06ffULL, 0x00005e0044307a11ULL, 0x000fe200078240ffULL,
0x0000001006367824ULL, 0x000fe200078e00ffULL, 0x00005f00322f7a11ULL, 0x000fe200000f442fULL,
0x000000ffff427224ULL, 0x000fe200028e06ffULL, 0x00005e002d397a11ULL, 0x000fe200078a40ffULL,
0x000000ffff707224ULL, 0x000fe200010e06ffULL, 0x00005f0044447a11ULL, 0x000fe200008f447bULL,
0x000000ffff727224ULL, 0x000fe200018e06ffULL, 0x0000007036367812ULL, 0x000fe200078ec0ffULL,
0x000000ffff747224ULL, 0x000fe200020e06ffULL, 0x00005e0046327a11ULL, 0x000fc400078240ffULL,
0x00005f002d2d7a11ULL, 0x000fe400028f4442ULL, 0x00005e004a7d7a11ULL, 0x000fe400078440ffULL,
0x0000004336427210ULL, 0x000fe40007f1e0ffULL, 0x00005e006a7b7a11ULL, 0x000fe400078640ffULL,
0x00005f0046467a11ULL, 0x000fe200008f4470ULL, 0x000000ffff437224ULL, 0x000fe200000e060cULL,
0x0000004036407210ULL, 0x000fc40007f3e0ffULL, 0x00005f004a4a7a11ULL, 0x000fe400010f4472ULL,
0x0000003e363e7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000042797faeULL, 0x0003e2000b901c46ULL, 0x00005f006a6a7a11ULL, 0x000fe400018f4474ULL,
0x0000003c363c7210ULL, 0x040fe40007f7e0ffULL, 0x00000041360c7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff417224ULL, 0x000fe200008e060eULL, 0x0000003a363a7210ULL, 0x000fc40007fbe0ffULL,
0x0000003f360e7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e0628ULL,
0x0000003836387210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000003d36287210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e062aULL,
0x0000003b362a7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200028e062cULL,
0x00000039362c7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff397224ULL, 0x000fe200020e062eULL,
0x00000034362e7210ULL, 0x040fe20007f9e0ffULL, 0x0000000040777faeULL, 0x0003e2000b901c46ULL,
0x0000003036307210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000003236327210ULL, 0x040fe20007f3e0ffULL, 0x000000003e317faeULL, 0x0005e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fe200010e0629ULL, 0x0000007d36347210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e062bULL, 0x000000003c757faeULL, 0x0003e2000b901c46ULL,
0x0000007b36367210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2d7224ULL, 0x000fc400028e062dULL,
0x000000003a337faeULL, 0x0007e2000b901c46ULL, 0x000000ffff2f7224ULL, 0x000fc600020e062fULL,
0x0000000038357faeULL, 0x0009e2000b901c46ULL, 0x000000ffff317224ULL, 0x004fc600000e0644ULL,
0x000000000c377faeULL, 0x0005e8000b901c46ULL, 0x000000000e737faeULL, 0x0003e2000b901c46ULL,
0x000000ffff337224ULL, 0x008fc600008e0646ULL, 0x0000000028717faeULL, 0x0003e2000b901c46ULL,
0x000000ffff357224ULL, 0x010fc600010e064aULL, 0x000000002a6f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff377224ULL, 0x004fc600018e066aULL, 0x000000002c6b7faeULL, 0x0003e8000b901c46ULL,
0x000000002e4b7faeULL, 0x0003e8000b901c46ULL, 0x0000000030497faeULL, 0x0003e8000b901c46ULL,
0x0000000032477faeULL, 0x0003e8000b901c46ULL, 0x0000000034457faeULL, 0x0003e8000b901c46ULL,
0x00000000366d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000105d0d7824ULL, 0x002fe200078e00ffULL, 0x000000085f0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000105d0e7824ULL, 0x000fe200078e00ffULL, 0x000030006c457810ULL, 0x000fc40007ffe0ffULL,
0xfffffff00d0c7812ULL, 0x000fe400078ee20cULL, 0x0000000a5f0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001068347824ULL, 0x100fe400078e0245ULL, 0x000000106e3c7824ULL, 0x000fe200078e0245ULL,
0xfffffff00e0d7812ULL, 0x000fe200078ee20dULL, 0x000000100c0c7824ULL, 0x000fe400078e00ffULL,
0x0000001069387824ULL, 0x100fe400078e0245ULL, 0x0000001067307824ULL, 0x000fc400078e0245ULL,
0x0000001066287824ULL, 0x100fe400078e0245ULL, 0x000000100d0d7824ULL, 0x000fe400078e00ffULL,
0x0000001065407824ULL, 0x000fe200078e0245ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000c2c783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x000000003c3c783bULL, 0x000ea80000000200ULL, 0x000000003838783bULL, 0x000ee80000000200ULL,
0x000000003030783bULL, 0x000f280000000200ULL, 0x000000002828783bULL, 0x000fe80000000200ULL,
0x000000000d0c783bULL, 0x000ee80000000200ULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x000000342c18723cULL, 0x042bee0000041818ULL, 0x0000001064347824ULL, 0x120fe200078e0245ULL,
0x0000003c2c50723cULL, 0x044b6e0000041850ULL, 0x00000010583c7824ULL, 0x120fe200078e0245ULL,
0x000000362c1c723cULL, 0x040be4000004181cULL, 0x000000003434783bULL, 0x020e6c0000000200ULL,
0x0000003e2c4c723cULL, 0x040b64000004184cULL, 0x000000003c3c783bULL, 0x020fec0000000200ULL,
0x000000382c10723cULL, 0x048b6e0000041810ULL, 0x0000001061387824ULL, 0x020fe200078e0245ULL,
0x0000003a2c14723cULL, 0x040b6a0000041814ULL, 0x000000003838783bULL, 0x020fe60000000200ULL,
0x000000302c20723cULL, 0x050ff00000041820ULL, 0x000000322c24723cULL, 0x000bee0000041824ULL,
0x000000105d2d7824ULL, 0x020fe200078e00ffULL, 0x0000000c5f2c7810ULL, 0x040fe20007ffe0ffULL,
0x000000280c50723cULL, 0x000b620000041850ULL, 0x0000000e5f5f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff02d2c7812ULL, 0x000fe200078ee22cULL, 0x00000010632d7824ULL, 0x000fc600078e0245ULL,
0x0000001062287824ULL, 0x120fe200078e0245ULL, 0x0000002a0c4c723cULL, 0x040b62000004184cULL,
0x000000102c307824ULL, 0x000fe400078e00ffULL, 0x000000002d2c783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x000000340c18723cULL, 0x042b660000041818ULL,
0x000000002828783bULL, 0x020e680000000200ULL, 0x0000001060347824ULL, 0x000fe200078e0245ULL,
0x000000360c1c723cULL, 0x040b6e000004181cULL, 0x000000105d367824ULL, 0x020fe200078e00ffULL,
0x000000400c10723cULL, 0x000b680000041810ULL, 0xfffffff0365f7812ULL, 0x000fc400078ee25fULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x0000001056407824ULL, 0x020fe200078e0245ULL,
0x000000420c14723cULL, 0x000b620000041814ULL, 0x000000105f5f7824ULL, 0x000fc800078e00ffULL,
0x000000004040783bULL, 0x020fe60000000200ULL, 0x0000002c3050723cULL, 0x004bee0000041850ULL,
0x00000010542c7824ULL, 0x120fe200078e0245ULL, 0x000000280c20723cULL, 0x042b6e0000041820ULL,
0x0000001057287824ULL, 0x120fe200078e0245ULL, 0x0000002a0c24723cULL, 0x000b620000041824ULL,
0x000000100a457824ULL, 0x000fe200078e0245ULL, 0x000000005f0c783bULL, 0x020fe80000000200ULL,
0x000000002828783bULL, 0x000fe40000000200ULL, 0x0000002e304c723cULL, 0x040be4000004184cULL,
0x000000002c2c783bULL, 0x020e680000000200ULL, 0x000000004544783bULL, 0x000ea40000000200ULL,
0x000000343018723cULL, 0x048f700000041818ULL, 0x00000036301c723cULL, 0x040f70000004181cULL,
0x000000383010723cULL, 0x040ff00000041810ULL, 0x0000003a3014723cULL, 0x040ff00000041814ULL,
0x0000003c3020723cULL, 0x040ff00000041820ULL, 0x0000003e3024723cULL, 0x000ff00000041824ULL,
0x0000002c0c18723cULL, 0x062f700000041818ULL, 0x0000002e0c1c723cULL, 0x040f70000004181cULL,
0x000000280c50723cULL, 0x040f700000041850ULL, 0x0000002a0c4c723cULL, 0x000b64000004184cULL,
0x3db504f31b2c7820ULL, 0x020fc40000410000ULL, 0x3db504f318187820ULL, 0x000fe40000410000ULL,
0x3db504f319197820ULL, 0x000fe40000410000ULL, 0x3db504f31a2b7820ULL, 0x000fe20000410000ULL,
0x000000400c10723cULL, 0x000f620000041810ULL, 0x3db504f31c1a7820ULL, 0x000fe40000410000ULL,
0x3db504f31d1b7820ULL, 0x000fe40000410000ULL, 0x3db504f31f287820ULL, 0x000fc40000410000ULL,
0x3db504f31e1e7820ULL, 0x000fe20000410000ULL, 0x000000420c14723cULL, 0x040f620000041814ULL,
0x3db504f350507820ULL, 0x000fe40000410000ULL, 0x3db504f351517820ULL, 0x000fe40000410000ULL,
0x3db504f352527820ULL, 0x000fe40000410000ULL, 0x3db504f353537820ULL, 0x000fe20000410000ULL,
0x000000440c20723cULL, 0x004f620000041820ULL, 0x3db504f34c4c7820ULL, 0x000fc40000410000ULL,
0x3db504f34d4d7820ULL, 0x000fe40000410000ULL, 0x3db504f34e297820ULL, 0x000fe40000410000ULL,
0x3db504f34f2a7820ULL, 0x000fe20000410000ULL, 0x000000460c24723cULL, 0x000b640000041824ULL,
0x3db504f3100a7820ULL, 0x020fe40000410000ULL, 0x3db504f3122d7820ULL, 0x000fe40000410000ULL,
0x3db504f3132e7820ULL, 0x000fc40000410000ULL, 0x3db504f3110c7820ULL, 0x000fe40000410000ULL,
0x3db504f3140d7820ULL, 0x000fe40000410000ULL, 0x3db504f3150e7820ULL, 0x000fe40000410000ULL,
0x3db504f3162f7820ULL, 0x000fe40000410000ULL, 0x3db504f317307820ULL, 0x000fe40000410000ULL,
0x3db504f320207820ULL, 0x000fc40000410000ULL, 0x3db504f321217820ULL, 0x000fe40000410000ULL,
0x3db504f3221c7820ULL, 0x000fe40000410000ULL, 0x3db504f3231d7820ULL, 0x000fe40000410000ULL,
0x3db504f324247820ULL, 0x000fe40000410000ULL, 0x3db504f325257820ULL, 0x000fe40000410000ULL,
0x3db504f3260f7820ULL, 0x000fc40000410000ULL, 0x3db504f3271f7820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ffff157224ULL, 0x000fe400078e000cULL,
0x000000ffff167224ULL, 0x000fe400078e000dULL, 0x00000000080c7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff147224ULL, 0x000fe400078e000aULL, 0x000000ffff0a7224ULL, 0x000fe400078e0025ULL,
0x000000ffff257224ULL, 0x000fc400078e001eULL, 0x000000ffff117224ULL, 0x000fe400078e0050ULL,
0x000000ffff107224ULL, 0x000fe400078e0051ULL, 0x000000ffff127224ULL, 0x000fe400078e004cULL,
0x000000ffff137224ULL, 0x000fe400078e004dULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff227224ULL, 0x000fc400078e0020ULL, 0x000000ffff237224ULL, 0x000fe400078e0021ULL,
0x000000ffff267224ULL, 0x000fe400078e0052ULL, 0x000000ffff277224ULL, 0x000fe400078e0053ULL,
0x000000ffff1e7224ULL, 0x000fc400078e000fULL, 0x00000000000e7805ULL, 0x006fca0000015200ULL,
0x0000040008217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000200e317210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e0fULL, 0x003d09003100780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403100780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff207819ULL, 0x000fc80000011421ULL,
0x0000003120207211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x0000000220207819ULL, 0x000fc80000001221ULL, 0x000000200000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040008217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000406217824ULL, 0x000fe200078e00ffULL, 0x0000000b5e00720cULL, 0x000fc80003f05270ULL,
0xfffffff0210d7812ULL, 0x000fca00078ec0ffULL, 0x000000805c207824ULL, 0x000fca00078e020dULL,
0x01b40000200c7984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000206317824ULL, 0x000fe400078e00ffULL, 0x000000015a347824ULL, 0x000fc600078e0a09ULL,
0x0000000631317812ULL, 0x000fc800078ec0ffULL, 0x0000000131097812ULL, 0x040fe400078efcffULL,
0x0000000831327812ULL, 0x000fe400078efcffULL, 0x000000340900720cULL, 0x080fe40003f26070ULL,
0x0000001031097812ULL, 0x000fe400078efcffULL, 0x000000343200720cULL, 0x080fe40003f06070ULL,
0x000000340900720cULL, 0x000fc40003fc6070ULL, 0x0000001131327812ULL, 0x040fe400078efcffULL,
0x0000001831097812ULL, 0x040fe400078efcffULL, 0x000000343100720cULL, 0x080fe40003f46070ULL,
0x000000343200720cULL, 0x080fe40003fa6070ULL, 0x000000340900720cULL, 0x000fe40003f66070ULL,
0x0000000931337812ULL, 0x000fc400078efcffULL, 0x0000001931327812ULL, 0x040fe400078efcffULL,
0x0000002031097812ULL, 0x000fe400078efcffULL, 0xff80000026267808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff80000027277808ULL, 0x000fe40004800000ULL,
0xff80000010107808ULL, 0x000fc40004800000ULL, 0x000000343300720cULL, 0x080fe40003f86070ULL,
0x000000343200720cULL, 0x080fe40003f46070ULL, 0x000000340900720cULL, 0x000fe40003f26070ULL,
0x0000002131327812ULL, 0x040fe400078efcffULL, 0x0000002831097812ULL, 0x000fe400078efcffULL,
0xff80000029297808ULL, 0x000fc40004000000ULL, 0xff80000012127808ULL, 0x000fe40004000000ULL,
0xff8000002a2a7808ULL, 0x000fe40006000000ULL, 0xff80000013137808ULL, 0x000fe40006000000ULL,
0x000000343200720cULL, 0x080fe40003f06070ULL, 0x000000340900720cULL, 0x000fe40003f86070ULL,
0x0000002931327812ULL, 0x000fc400078efcffULL, 0x0000003031097812ULL, 0x000fe400078efcffULL,
0xff8000002d2d7808ULL, 0x000fe40007000000ULL, 0xff80000014147808ULL, 0x000fe40007000000ULL,
0xff8000002e2e7808ULL, 0x000fe40006800000ULL, 0xff80000015157808ULL, 0x000fe40006800000ULL,
0x000000343200720cULL, 0x000fc40003fc6070ULL, 0x000000340900720cULL, 0x000fe40003fa6070ULL,
0x0000003131327812ULL, 0x040fe400078efcffULL, 0x0000003831097812ULL, 0x040fe400078efcffULL,
0x0000003931317812ULL, 0x000fe400078efcffULL, 0xff8000002f2f7808ULL, 0x000fe40005800000ULL,
0xff80000016167808ULL, 0x000fc40005800000ULL, 0xff80000030307808ULL, 0x000fe40005000000ULL,
0xff80000017177808ULL, 0x000fe40005000000ULL, 0xff8000002b2b7808ULL, 0x000fe40004800000ULL,
0xff80000018187808ULL, 0x000fe40004800000ULL, 0x000000343200720cULL, 0x080fe40003f66070ULL,
0x000000340900720cULL, 0x000fc40003f46070ULL, 0x000000343100720cULL, 0x000fe40003f26070ULL,
0xff8000002c2c7808ULL, 0x000fe40004000000ULL, 0xff80000019197808ULL, 0x000fe40004000000ULL,
0xff80000025257808ULL, 0x000fe40006000000ULL, 0xff8000001a1a7808ULL, 0x000fe40006000000ULL,
0xff80000028287808ULL, 0x000fc40007000000ULL, 0xff8000001b1b7808ULL, 0x000fe40007000000ULL,
0xff8000001c1c7808ULL, 0x000fe40006800000ULL, 0xff80000022227808ULL, 0x000fe40006800000ULL,
0xff8000001d1d7808ULL, 0x000fe40005800000ULL, 0xff80000023237808ULL, 0x000fe40005800000ULL,
0xff8000001e1e7808ULL, 0x000fc40005000000ULL, 0xff80000024247808ULL, 0x000fe40005000000ULL,
0xff8000001f1f7808ULL, 0x000fe40004800000ULL, 0xff8000000a0a7808ULL, 0x000fc40004800000ULL,
0x000000110c00720bULL, 0x004fe40003f1e000ULL, 0x000000260d00720bULL, 0x000fe40003f3e000ULL,
0x0000000c11097208ULL, 0x000fe40004000000ULL, 0x0000000d260c7208ULL, 0x000fc40004800000ULL,
0x000000100900720bULL, 0x000fe40003f1e000ULL, 0x000000270c00720bULL, 0x000fe40003f3e000ULL,
0x0000000910097208ULL, 0x000fe40004000000ULL, 0x0000000c270c7208ULL, 0x000fe40004800000ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x000000290c00720bULL, 0x000fc40003f3e000ULL,
0x0000000912327208ULL, 0x000fe40004000000ULL, 0x0000000c29097208ULL, 0x000fe40004800000ULL,
0x000000133200720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fe40003f3e000ULL,
0x00000032130d7208ULL, 0x000fe40004000000ULL, 0x000000092a0c7208ULL, 0x000fc40004800000ULL,
0x000000140d00720bULL, 0x000fe40003f1e000ULL, 0x0000002d0c00720bULL, 0x000fe40003f3e000ULL,
0x0000000d14327208ULL, 0x000fe40004000000ULL, 0x0000000c2d097208ULL, 0x000fe40004800000ULL,
0x000000153200720bULL, 0x000fe40003f1e000ULL, 0x0000002e0900720bULL, 0x000fc40003f3e000ULL,
0x00000032150d7208ULL, 0x000fe40004000000ULL, 0x000000092e0c7208ULL, 0x000fe40004800000ULL,
0x000000160d00720bULL, 0x000fe40003f1e000ULL, 0x0000002f0c00720bULL, 0x000fe40003f3e000ULL,
0x0000000d16327208ULL, 0x000fe40004000000ULL, 0x0000000c2f097208ULL, 0x000fc40004800000ULL,
0x000000173200720bULL, 0x000fe40003f1e000ULL, 0x000000300900720bULL, 0x000fe40003f3e000ULL,
0x00000032170d7208ULL, 0x000fe40004000000ULL, 0x00000009300c7208ULL, 0x000fe40004800000ULL,
0x000000180d00720bULL, 0x000fe40003f1e000ULL, 0x0000002b0c00720bULL, 0x000fc40003f3e000ULL,
0x0000000d18327208ULL, 0x000fe40004000000ULL, 0x0000000c2b097208ULL, 0x000fe40004800000ULL,
0x000000193200720bULL, 0x000fe40003f1e000ULL, 0x0000002c0900720bULL, 0x000fe40003f3e000ULL,
0x00000032190d7208ULL, 0x000fe40004000000ULL, 0x000000092c0c7208ULL, 0x000fc40004800000ULL,
0x0000001a0d00720bULL, 0x000fe40003f1e000ULL, 0x000000250c00720bULL, 0x000fe40003f3e000ULL,
0x0000000d1a327208ULL, 0x000fe40004000000ULL, 0x0000000c25097208ULL, 0x000fe40004800000ULL,
0x0000001b3200720bULL, 0x000fe40003f1e000ULL, 0x000000280900720bULL, 0x000fc40003f3e000ULL,
0x000000321b0d7208ULL, 0x000fe40004000000ULL, 0x0000000928097208ULL, 0x000fe40004800000ULL,
0x000000220d00720bULL, 0x000fe40003f1e000ULL, 0x0000001c0900720bULL, 0x000fe40003f3e000ULL,
0x0000000d220c7208ULL, 0x000fe40004000000ULL, 0x000000091c327208ULL, 0x000fc40004800000ULL,
0x000000230c00720bULL, 0x000fe40003f1e000ULL, 0x0000001d3200720bULL, 0x000fe40003f3e000ULL,
0x0000000c23097208ULL, 0x000fe40004000000ULL, 0x000000321d0d7208ULL, 0x000fe40004800000ULL,
0x000000240900720bULL, 0x000fe40003f1e000ULL, 0x0000001e0d00720bULL, 0x000fc40003f3e000ULL,
0x0000000924097208ULL, 0x000fe40004000000ULL, 0x0000000d1e0c7208ULL, 0x000fe40004800000ULL,
0x0000000a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001f0c00720bULL, 0x000fe40003f3e000ULL,
0x000000090a347208ULL, 0x000fe40004000000ULL, 0x0000000c1f387208ULL, 0x000fe20004800000ULL,
0x000017b27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0034097f89ULL, 0x0004e400000e0000ULL,
0x000000093400720bULL, 0x008fc80003f1e000ULL, 0x00000034093a7208ULL, 0x000fe20004000000ULL,
0x000017e27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0038097f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL, 0x0c401f000f0c7f89ULL, 0x000e6200000e0000ULL,
0x000000093800720bULL, 0x008fc40003f1e000ULL, 0x0000000d0e00720bULL, 0x010fe40003f3e000ULL,
0x0000003809317208ULL, 0x000fe40004000000ULL, 0x0000000e0d337208ULL, 0x000fe40004800000ULL,
0x0c201f003a0d7f89ULL, 0x000ee200000e0000ULL, 0x0000000c0f00720bULL, 0x002fc60003f1e000ULL,
0x0c201f0031347f89ULL, 0x004e6200000e0000ULL, 0x0000000f0c097208ULL, 0x000fc60004000000ULL,
0x0c201f0033367f89ULL, 0x000ea800000e0000ULL, 0x0c201f0009327f89ULL, 0x0002a200000e0000ULL,
0x0000000d3a00720bULL, 0x008fe40003f1e000ULL, 0x000000343100720bULL, 0x002fe40003f3e000ULL,
0x0000003a0d0c7208ULL, 0x000fe40004000000ULL, 0x000000363300720bULL, 0x004fc40003f5e000ULL,
0x00000031340d7208ULL, 0x000fe40004800000ULL, 0x00000033360e7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b0c337820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000306ff7812ULL, 0x000fe4000780c0ffULL, 0x3fb8aa3b24317823ULL, 0x100fe20000010833ULL,
0x000000320900720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b0d247820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b11117823ULL, 0x000fc40000010833ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010833ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12127823ULL, 0x100fe40000010833ULL,
0x3fb8aa3b13137823ULL, 0x000fe40000010833ULL, 0x3fb8aa3b26267823ULL, 0x100fe40000010824ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010824ULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b29297823ULL, 0x000fc40000010824ULL, 0x3fb8aa3b2a2a7823ULL, 0x000fe40000010824ULL,
0x3fb8aa3b220f7823ULL, 0x100fe40000010833ULL, 0x00000004ff227e24ULL, 0x000fe2000f8e00ffULL,
0x0000001000107308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b23347823ULL, 0x102fe20000010833ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010833ULL,
0x3f8000002222783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b15157823ULL, 0x000fc40000010833ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010833ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x000000ffff237224ULL, 0x000fe400078e0022ULL, 0x3fb8aa3b17177823ULL, 0x100fe40000010833ULL,
0x3fb8aa3b19197823ULL, 0x100fe40000010833ULL, 0x3fb8aa3b1b1b7823ULL, 0x000fe20000010833ULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x000000111010723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b2e2e7823ULL, 0x000fc40000010824ULL, 0x3fb8aa3b30307823ULL, 0x100fe40000010824ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe40000010824ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe40000010824ULL, 0x3fb8aa3b18187823ULL, 0x100fe40000010833ULL,
0x3fb8aa3b1a1a7823ULL, 0x000fe40000010833ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010824ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x000000121312723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b2c2c7823ULL, 0x000fc40000010824ULL, 0x3fb8aa3b25257823ULL, 0x100fe40000010824ULL,
0x3fb8aa3b28287823ULL, 0x000fe40000010824ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0a0a7823ULL, 0x000fce0000010833ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x000000262711723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b1d267823ULL, 0x100fe40000010824ULL,
0x3fb8aa3b1e277823ULL, 0x000fc80000010824ULL, 0x0000001400357308ULL, 0x000fe20000000800ULL,
0x000000292a13723eULL, 0x002fce00000010ffULL, 0x0000001500367308ULL, 0x000fe20000000800ULL,
0x00000002ff297819ULL, 0x000fc80000011606ULL, 0x00000003292a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000829337824ULL, 0x000fe400078e00ffULL, 0x0000001600377308ULL, 0x000fe60000000800ULL,
0xfffffff833337812ULL, 0x000fca00078ee22aULL, 0x0000001700387308ULL, 0x0003f00000000800ULL,
0x00000019003a7308ULL, 0x000fe20000000800ULL, 0x000000221014723cULL, 0x002f6e00000418ffULL,
0x0000001b003c7308ULL, 0x000ff00000000800ULL, 0x0000002d00197308ULL, 0x0003f00000000800ULL,
0x0000002e002e7308ULL, 0x000ea20000000800ULL, 0x00000008292d7824ULL, 0x002fce00078e00ffULL,
0x0000002f001b7308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000e620000000800ULL,
0x000000192e19723eULL, 0x004fe200000010ffULL, 0x00000008292e7824ULL, 0x000fcc00078e00ffULL,
0x0000001800397308ULL, 0x0005f00000000800ULL, 0x0000001a003b7308ULL, 0x0007220000000800ULL,
0x000000353618723eULL, 0x004fe200000010ffULL, 0x000000ffff367224ULL, 0x000fe200078e0022ULL,
0x0000001b301b723eULL, 0x002fe200000010ffULL, 0x0000000829307824ULL, 0x000fc800078e00ffULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x00000037381a723eULL, 0x008fe200000010ffULL,
0x000000ffff377224ULL, 0x000fcc00078e0022ULL, 0x000000221814723cULL, 0x020b620000041814ULL,
0x0000002c002c7308ULL, 0x000e620000000800ULL, 0x0000003b3c1e723eULL, 0x010fca00000010ffULL,
0x3fb8aa3b1c237823ULL, 0x120fe20000010824ULL, 0x00000001291c7810ULL, 0x000fe20007ffe0ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1f247823ULL, 0x000fe40000010824ULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee21cULL, 0x000000393a1c723eULL, 0x000fe200000010ffULL,
0x0000000829397824ULL, 0x040fe400078e00ffULL, 0x0000002800287308ULL, 0x000ea20000000800ULL,
0x0000002b2c1d723eULL, 0x002fe200000010ffULL, 0x00000008292c7824ULL, 0x040fe200078e00ffULL,
0x00000004292b7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff82e357812ULL, 0x000fe200078ee22bULL,
0x0000000a000a7308ULL, 0x000e620000000800ULL, 0x00000008292e7810ULL, 0x040fe40007ffe0ffULL,
0xfffffff8302b7812ULL, 0x000fe200078ee229ULL, 0x000000ffff307224ULL, 0x000fe400078e0022ULL,
0x000000082e3b7824ULL, 0x000fe200078e00ffULL, 0x00000025281f723eULL, 0x004fe200000010ffULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x0000000229257810ULL, 0x000fc40007ffe0ffULL,
0xfffffff83b3b7812ULL, 0x000fe400078ee22eULL, 0xfffffff82c2f7812ULL, 0x000fe200078ee225ULL,
0x000000361c14723cULL, 0x000b620000041814ULL, 0x0000000529257810ULL, 0x040fe20007ffe0ffULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0xffffffff292c7810ULL, 0x000fc80007ffe0ffULL,
0x0000000829377824ULL, 0x020fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee22cULL,
0x0000000829367824ULL, 0x000fe200078e00ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x0000000c212c7812ULL, 0x000fce00078ec0ffULL, 0x0000002600287308ULL, 0x0004f00000000800ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x0000000629267810ULL, 0x004fe40007ffe0ffULL,
0xfffffff836297812ULL, 0x000fc400078ee225ULL, 0xfffffff837377812ULL, 0x000fe400078ee226ULL,
0x000000310a26723eULL, 0x002fe200000010ffULL, 0x00000024002a7308ULL, 0x0002a20000000800ULL,
0x000000232825723eULL, 0x008fe200000010ffULL, 0x000000ffff317224ULL, 0x000fe200078e0022ULL,
0x000110005c0a7811ULL, 0x000fca00078e58ffULL, 0x000000102d217824ULL, 0x100fe200078e020aULL,
0x0000000f3424723eULL, 0x002fe200000010ffULL, 0x000000102b0f7824ULL, 0x100fe400078e020aULL,
0x000000102f227824ULL, 0x100fe400078e020aULL, 0x0000001033237824ULL, 0x100fe200078e020aULL,
0x000000272a27723eULL, 0x004fe200000010ffULL, 0x0000001035287824ULL, 0x000fe400078e020aULL,
0x000000012c0f7824ULL, 0x000fc400078e020fULL, 0x0000001029297824ULL, 0x100fe400078e020aULL,
0x000000302414723cULL, 0x000f620000041814ULL, 0x000000012c217824ULL, 0x040fe200078e0221ULL,
0x000000100f007388ULL, 0x0003e20000000800ULL, 0x00000010372a7824ULL, 0x000fe400078e020aULL,
0x000000012c227824ULL, 0x040fe200078e0222ULL, 0x0000001221007388ULL, 0x0005e20000000800ULL,
0x00000010392b7824ULL, 0x100fe400078e020aULL, 0x000000012c237824ULL, 0x000fe200078e0223ULL,
0x0000001822007388ULL, 0x0005e20000000800ULL, 0x000000103b0a7824ULL, 0x000fe200078e020aULL,
0x00000009320f7208ULL, 0x002fe20004800000ULL, 0x000000012c287824ULL, 0x040fe200078e0228ULL,
0x0000001a23007388ULL, 0x0005e20000000800ULL, 0x000000012c297824ULL, 0x000fc400078e0229ULL,
0x000000012c2a7824ULL, 0x040fe200078e022aULL, 0x0000001c28007388ULL, 0x0005e20000000800ULL,
0x000000012c2b7824ULL, 0x040fe400078e022bULL, 0x000000012c0a7824ULL, 0x000fe200078e020aULL,
0x0000001e29007388ULL, 0x0005e40000000800ULL, 0x000000ffff157224ULL, 0x020fe400078e0016ULL,
0x000000242a007388ULL, 0x0005e80000000800ULL, 0x000000262b007388ULL, 0x0005e80000000800ULL,
0x000000110a007388ULL, 0x0005e80000000800ULL, 0x0004001321007388ULL, 0x0005e80000000800ULL,
0x0004001922007388ULL, 0x0005e80000000800ULL, 0x0004001b23007388ULL, 0x0005e80000000800ULL,
0x0004001d28007388ULL, 0x0005e80000000800ULL, 0x0004001f29007388ULL, 0x0005e80000000800ULL,
0x000400252a007388ULL, 0x0005e80000000800ULL, 0x000400272b007388ULL, 0x0005e80000000800ULL,
0x01b0000c20008388ULL, 0x0005e80000000c00ULL, 0x01b2001420008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080000ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6100000ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6180000ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000594800720cULL, 0x000fe20003f06070ULL,
0x01b6200000ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff5e7224ULL, 0x000fd600078e0048ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff9f4000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0c7807ULL, 0x008fe20004000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x000144b000167802ULL, 0x000fc40000000f00ULL,
0x00000fe000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0015ULL,
0xfffee5b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe20005000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x0001451000167802ULL, 0x000fc40000000f00ULL,
0x00000f8000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xfffee5e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x008fe200078e0015ULL,
0x0001458000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fe400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x00000ec000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xfffee68000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0015ULL, 0x000145f000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff177424ULL, 0x000fc400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x00000e5000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xfffee78000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001467000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fe400078e000fULL,
0x0000001fff177424ULL, 0x000fe400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x00000dd000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0016ULL,
0xfffee91000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0009ULL,
0x000146f000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff167224ULL, 0x000fc400078e000eULL,
0x0000001fff177424ULL, 0x000fe400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x00000d5000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0016ULL,
0xfffee8c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe20004000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x0001475000167802ULL, 0x000fc40000000f00ULL,
0x00000d4000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0015ULL,
0xffff027000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe20005000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x000147b000167802ULL, 0x000fc40000000f00ULL,
0x00000ce000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xffff02b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e0015ULL,
0x0001482000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fc400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x00000c2000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xffff036000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0015ULL, 0x0001489000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff177424ULL, 0x000fe400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x00000bb000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xffff045000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001491000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fe400078e000fULL,
0x0000001fff177424ULL, 0x000fc400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x00000b3000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0016ULL,
0xffff05e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001498000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fe400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x00000ac000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0016ULL, 0xffff05a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x004fe20004000000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x000149e000167802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0xffff1c8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20004800000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x00014a4000167802ULL, 0x000fc40000000f00ULL, 0x00000a5000007944ULL, 0x018fea0003c00000ULL,
0xffff1cd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e0019ULL,
0x00014aa000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fc400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x000009a000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xffff1d9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x00014b1000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff177424ULL, 0x000fe400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x0000093000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xffff1e8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x00014b9000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fe400078e000fULL,
0x0000001fff177424ULL, 0x000fc400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x000008b000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0016ULL,
0xffff201000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x00014c0000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fe400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x0000084000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0016ULL, 0xffff1fd000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe20004000000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x00014c6000167802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0xffff36a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20004800000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x00014cc000167802ULL, 0x000fc40000000f00ULL, 0x000007d000007944ULL, 0x012fea0003c00000ULL,
0xffff36f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e0019ULL,
0x00014d2000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fc400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x0000072000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xffff37a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x00014d9000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff177424ULL, 0x000fe400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x000006b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xffff389000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x00014e1000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fe400078e000fULL,
0x0000001fff177424ULL, 0x000fc400078e00ffULL, 0xffffffffff1b7424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0016ULL,
0xffff3a1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x00014e8000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff177424ULL, 0x000fe400078e00ffULL,
0xffffffffff1b7424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0016ULL, 0xffff39d000007947ULL, 0x000fea000383ffffULL,
0x00000002ff357424ULL, 0x000fe200078e00ffULL, 0x00014ef000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0031ULL,
0xffffe7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x006fe200078e0038ULL,
0x00014f7000327802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fc400078e00ffULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000313800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e000eULL, 0x00014ff000327802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fe200078e00ffULL, 0x0000003831367208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000310e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e000fULL, 0x0001507000327802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fe200078e00ffULL, 0x0000000e310e7208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000310f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e003aULL, 0x000150f000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000000f31097208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000313a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e0036ULL, 0x0001517000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000003a310c7208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000313600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e000eULL, 0x000151f000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x00000036310d7208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000310e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e0009ULL, 0x0001527000327802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000000e310e7208ULL, 0x000fe20004000000ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff327224ULL, 0x004fe200078e0031ULL,
0xffffe5d000007947ULL, 0x000fea000383ffffULL, 0x0180000004037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000400038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff0a7807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x000000030aff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff04ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000004057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x000000030aff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000400037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffeac0008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff337424ULL, 0x000fe200078e00ffULL, 0x0000003c00007348ULL, 0x000fe80003800000ULL,
0x0c00003534317389ULL, 0x0002a200000e0031ULL, 0xfffeabc032007950ULL, 0x000fea0003c3ffffULL,
0x0000001b00007348ULL, 0x000fe80003800000ULL, 0x0000000c16167389ULL, 0x0002a200000e0017ULL,
0x00000000ff0d7424ULL, 0x000fc400078e00ffULL, 0x000000ffff0c7224ULL, 0x002fc800078e0018ULL,
0xfffeab700c007950ULL, 0x000fea0003c3ffffULL, 0x000000010c00780cULL, 0x000fe20003f45070ULL,
0x0000001500007348ULL, 0x000fe80003800000ULL, 0x00000000ff0d7424ULL, 0x000fd000078e00ffULL,
0x00000000000c7806ULL, 0x000fc800050e0100ULL, 0x000000150c157212ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0016ULL, 0xfffeab000c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000054aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a8ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000900ULL,
0x00000000000002d8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bd8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c98ULL,
0x0000000000000584ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001220ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001230ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012c0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012c4ULL,
0x00000000000001b0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001480ULL,
0x0000000000015600ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016a80ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016ac0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000016e40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000157c0ULL,
0x00000000000157c0ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000016a80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000016e40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 93984;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
