/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016e50ULL, 0x0000000000016ad0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000014f20ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x00000000000150a0ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x00000000000150e0ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000015130ULL, 0x0000000000000150ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015280ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00014f2000000000ULL, 0x0000040400000000ULL, 0x810c000001640400ULL, 0x0052580400288080ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9808288080820828ULL,
0x288080a308288080ULL, 0x80ad08288080a408ULL, 0x1628808084082880ULL, 0x0000031028808280ULL,
0x8492000000000000ULL, 0x0000002200288080ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x00014f2000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880809608288080ULL, 0x8099082880809808ULL, 0x08288080a3082880ULL,
0x8080ad08288080a4ULL, 0x8016288080940828ULL, 0x0000000310288082ULL, 0x8094920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000011800000000ULL, 0x000150a000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880809808288080ULL, 0x80a408288080a308ULL, 0x08288080ad082880ULL,
0x8082801628808099ULL, 0x0000000000031028ULL, 0x2880809992000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x000001b800000000ULL, 0x000150e000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8098288080990900ULL, 0x0000000000002880ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809908288080ULL, 0x80a408288080a308ULL,
0x08288080ad082880ULL, 0x8082801628808098ULL, 0x0000000000031028ULL, 0x2880809892000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000026000000000ULL, 0x0001513000000000ULL,
0x0000015000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL,
0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL, 0x0000001800080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500009ULL, 0x00000000000c1704ULL,
0x0021f00000480008ULL, 0x00000000000c1704ULL, 0x0011f00000400007ULL, 0x00000000000c1704ULL,
0x0061f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL,
0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL,
0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0004310400801b03ULL, 0x0134290400000900ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01342804ffffffffULL, 0x000002e000000110ULL, 0x000023c000000530ULL,
0x0000259000002470ULL, 0x00002b60000026f0ULL, 0x00002be000002b90ULL, 0x0000529000002c30ULL,
0x0000544000005320ULL, 0x00005a20000055a0ULL, 0x00005aa000005a50ULL, 0x0000810000005af0ULL,
0x000082d0000081a0ULL, 0x000088b000008430ULL, 0x00008930000088e0ULL, 0x0000aec000008980ULL,
0x0000b0800000af60ULL, 0x0000b6a00000b1e0ULL, 0x0000b7200000b6d0ULL, 0x0000d1500000b770ULL,
0x000137b00000d160ULL, 0x00013800000137f0ULL, 0x0001382000013810ULL, 0x000138a000013880ULL,
0x00014560000138c0ULL, 0x000145f0000145a0ULL, 0x0001468000014630ULL, 0x00014720000146d0ULL,
0x000147b000014760ULL, 0x00014840000147f0ULL, 0x000148e000014890ULL, 0x0001497000014920ULL,
0x00014a00000149b0ULL, 0x00014aa000014a50ULL, 0x00014b3000014ae0ULL, 0x00014bc000014b70ULL,
0x00014c6000014c10ULL, 0x00014d2000014cc0ULL, 0x00014de000014d80ULL, 0x00014ea000014e40ULL,
0x0440390400014f00ULL, 0x000000ff000003b0ULL, 0x003f01000000f600ULL, 0x0000000b00000430ULL,
0x003f01200000f608ULL, 0x0000000b00000480ULL, 0x003f01200000f688ULL, 0x0000000b000004f0ULL,
0x003f01200000f6a8ULL, 0x0000000b00000520ULL, 0x003f01200000f6c8ULL, 0x000000ff00000910ULL,
0x003f01070000f600ULL, 0x0000000800000a70ULL, 0x003f01020000f68cULL, 0x0000000800000b00ULL,
0x003f01010000f688ULL, 0x000000ff00001330ULL, 0x0004010700000000ULL, 0x000000ff000013b0ULL,
0x0004010100000000ULL, 0x0000000200001410ULL, 0x003f010100000020ULL, 0x0000000500001570ULL,
0x003f01050000f6ccULL, 0x0000000500001740ULL, 0x003f01050000f6ccULL, 0x0000001a00001f80ULL,
0x003f01070000f6b0ULL, 0x0000001a00002020ULL, 0x003f01010000f6b0ULL, 0x0000003600002080ULL,
0x003f01010000f608ULL, 0x00000005000020c0ULL, 0x003f01050000f60cULL, 0x00000005000022a0ULL,
0x003f01050000f60cULL, 0x00000034000028c0ULL, 0x003f01050000f6acULL, 0x0000003400002a90ULL,
0x003f01050000f6acULL, 0x0000001800004500ULL, 0x003f010100000000ULL, 0x0000000f00004560ULL,
0x003f01010000f688ULL, 0x0000000600004590ULL, 0x003f010500000004ULL, 0x0000000600004750ULL,
0x003f010500000004ULL, 0x000000ff00004ea0ULL, 0x0004010700000000ULL, 0x000000ff00004f70ULL,
0x0004010100000000ULL, 0x0000000f00004fd0ULL, 0x003f01010000f628ULL, 0x0000000500004ff0ULL,
0x003f01050000f62cULL, 0x00000005000051c0ULL, 0x003f01050000f62cULL, 0x0000003a00005780ULL,
0x003f01050000f6b4ULL, 0x0000003a00005950ULL, 0x003f01050000f6b4ULL, 0x0000001800007360ULL,
0x003f010100000000ULL, 0x0000001a000073c0ULL, 0x003f01010000f690ULL, 0x00000006000073f0ULL,
0x003f010500000004ULL, 0x00000006000075b0ULL, 0x003f010500000004ULL, 0x000000ff00007d10ULL,
0x0004010700000008ULL, 0x0000001a00007da0ULL, 0x003f01010000f6b0ULL, 0x0000000500007e00ULL,
0x003f01010000f648ULL, 0x0000000500007e60ULL, 0x003f01050000f64cULL, 0x0000000500008030ULL,
0x003f01050000f64cULL, 0x0000003700008610ULL, 0x003f01050000f6acULL, 0x00000037000087e0ULL,
0x003f01050000f6acULL, 0x000000060000a0f0ULL, 0x003f010100000000ULL, 0x000000120000a150ULL,
0x003f010100000000ULL, 0x000000060000a180ULL, 0x003f010500000004ULL, 0x000000060000a340ULL,
0x003f010500000004ULL, 0x000000ff0000aae0ULL, 0x0004010700000000ULL, 0x000000ff0000abb0ULL,
0x0004010100000000ULL, 0x0000003a0000ac10ULL, 0x003f01010000f668ULL, 0x0000003a0000ac40ULL,
0x003f01050000f66cULL, 0x0000003a0000ae10ULL, 0x003f01050000f66cULL, 0x0000003a0000b3c0ULL,
0x003f01050000f6b4ULL, 0x0000003a0000b5c0ULL, 0x003f01050000f6b4ULL, 0x000000060000cf20ULL,
0x003f010100000000ULL, 0x000000050000cfa0ULL, 0x003f010100000000ULL, 0x000000ff0000e0c0ULL,
0x003f01010000f600ULL, 0x000000ff0000ec70ULL, 0x003f01050000f604ULL, 0x000000ff0000ee40ULL,
0x003f01050000f604ULL, 0x000000ff0000f070ULL, 0x003f01010000f600ULL, 0x000000ff0000f0a0ULL,
0x003f01050000f604ULL, 0x000000ff0000f260ULL, 0x003f01050000f604ULL, 0x0000007500011cb0ULL,
0x003f010100000000ULL, 0x0000007500011da0ULL, 0x003f010500000004ULL, 0x0000007500011f70ULL,
0x003f010500000004ULL, 0x00000077000143c0ULL, 0x003f010100000000ULL, 0x0000007700014420ULL,
0x003f010100000008ULL, 0x0000007700014480ULL, 0x003f010100000010ULL, 0x00000077000144f0ULL,
0x003f010100000018ULL, 0x00201c0400053803ULL, 0x0000da400000da10ULL, 0x0000dd800000dc20ULL,
0x0000e0100000df10ULL, 0x000145300000f2c0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000002e4ULL, 0x0000001b00000002ULL, 0x000000000000023cULL, 0x0000001b00000002ULL,
0x00000000000001a4ULL, 0x0000001b00000002ULL, 0x00000000000000ecULL, 0x0000001b00000002ULL,
0x0000000000000044ULL, 0x0000001b00000002ULL, 0x00000000000002bbULL, 0x0000001b00000002ULL,
0x0000000000000213ULL, 0x0000001b00000002ULL, 0x000000000000017dULL, 0x0000001b00000002ULL,
0x00000000000000c6ULL, 0x0000001b00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0f7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000f7a7a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f280000002100ULL,
0x00000000000e7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff0c7819ULL, 0x010fc80000011607ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x00001fff0c0c7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003757a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a75ULL,
0x0000040003007624ULL, 0x000fca00078e020fULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000175750810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000175751810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff75aa12ULL, 0x000fc800078e33ffULL, 0x0000007500007306ULL, 0x000e620000209000ULL,
0x000000ff7500720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000375047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603717227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a71ULL, 0x0000000075007224ULL, 0x000fca00078e0206ULL,
0x000000750000720cULL, 0x000fe20003f66070ULL, 0x0000010009027a24ULL, 0x008fe400078e0204ULL,
0x00001fff09097589ULL, 0x000e6400000e0000ULL, 0x00000000020b7a24ULL, 0x000fca00078e0207ULL,
0x000000ff0b00720cULL, 0x000fc60003f45270ULL, 0x0000000100003824ULL, 0x000fe200078e0a75ULL,
0x0000000171713810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x000000750000720cULL, 0x000fe40003f86070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fe20003f64070ULL, 0x3fffff80ff02a424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03a424ULL, 0x000fc800078e00ffULL, 0xff317217ff088424ULL, 0x000fe400078e00ffULL,
0x0000000171714810ULL, 0x000fe20007ffe0ffULL, 0x00f60002ff00a388ULL, 0x0005e20000000a00ULL,
0x00000075ff71d212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x00f400080b008388ULL, 0x0007e20000004800ULL,
0x7fffffc0ff059424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fc400078e0a71ULL,
0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL, 0x00f608040b009388ULL, 0x0009e20000008a00ULL,
0x0000000075757224ULL, 0x000fe400078e0206ULL, 0x3fffff60ff06b424ULL, 0x000fe400078e00ffULL,
0x0000001075007824ULL, 0x000fe400078e00ffULL, 0x3fffff80ff02b424ULL, 0x004fe200078e00ffULL,
0x00f688060b00b388ULL, 0x000fe20000008a00ULL, 0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL,
0x0000000400087c10ULL, 0x008fc4000fffe1ffULL, 0x0000000400007c0cULL, 0x000fe2000bf03070ULL,
0x3fffffc0ff04c424ULL, 0x010fe200078e00ffULL, 0x0000001008087817ULL, 0x000fe20003800000ULL,
0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL, 0x00f6a8020b00b388ULL, 0x000fe40000008a00ULL,
0x000000ff08727207ULL, 0x000fe40000000000ULL, 0x00005a0071087a19ULL, 0x000fe200000006ffULL,
0x00f6c8040b00c388ULL, 0x000fe80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000107200780cULL, 0x000fe20003f05270ULL, 0x000058000e077a24ULL, 0x000fc400078e02ffULL,
0x0000000409027824ULL, 0x002fe400078e020cULL, 0x0000007a07077224ULL, 0x000fe400078e0208ULL,
0x0000000202027824ULL, 0x000fcc00078e00ffULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000272057217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff0d7819ULL, 0x002fca000001160bULL,
0x0000000102067824ULL, 0x000fe400078e020dULL, 0x0000000105027824ULL, 0x000fe400078e0a02ULL,
0x0000000100037824ULL, 0x000fc600078e0206ULL, 0x000000020d00720cULL, 0x000fe20003f06070ULL,
0x0000000106027824ULL, 0x040fe200078e020bULL, 0x0000000403047c12ULL, 0x000fe2000f8e30ffULL,
0x00000010060d7824ULL, 0x000fe200078e00ffULL, 0x00005a00ff037a19ULL, 0x000fc60000011603ULL,
0x0000000107047824ULL, 0x000fe200078e0204ULL, 0xfffffff00d027812ULL, 0x000fc600078ee202ULL,
0x0000007a03047224ULL, 0x000fe400078e0204ULL, 0x000000100b037824ULL, 0x000fe400078e00ffULL,
0x0000010004047825ULL, 0x000fc600078e00ffULL, 0x000000f003077812ULL, 0x000fc800078ec0ffULL,
0x0000000704077212ULL, 0x000fc800078efcffULL, 0x00005e0007047a10ULL, 0x000fe20007f3e0ffULL,
0x0000001002077824ULL, 0x000fc600078e00ffULL, 0x00005f0005057a10ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x00000000000b7919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x000000020b027211ULL, 0x002fca00078fe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0202ULL, 0x0000000102067824ULL, 0x000fc600078e020bULL,
0x0000000403047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff037a19ULL, 0x000fc60000011603ULL,
0x0000000107047824ULL, 0x000fc800078e0204ULL, 0x0000007a03047224ULL, 0x000fe400078e0204ULL,
0x000000100b037824ULL, 0x000fe400078e00ffULL, 0x0000010004047825ULL, 0x000fc600078e00ffULL,
0x000000f003077812ULL, 0x000fc800078ec0ffULL, 0x0000000704047212ULL, 0x000fe200078efcffULL,
0x0000001002077824ULL, 0x000fc600078e00ffULL, 0x00005e0004047a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff007067812ULL, 0x000fe400078ee206ULL, 0x00005f0005057a10ULL, 0x000fc600007fe4ffULL,
0x0000001006077824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000027806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000200047300ULL, 0x000e7000000e0000ULL, 0x0000000200067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x00000004ff057424ULL, 0x000fc400078e00ffULL,
0x000000ffff067224ULL, 0x004fe400078e0a06ULL, 0x000064000e047625ULL, 0x000fd000078e0005ULL,
0x00f60406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008040a7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x000000ff0a027810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff097819ULL, 0x000fce0000011602ULL, 0x0000d5e000008947ULL, 0x000fea0003800000ULL,
0x000000080c087824ULL, 0x000fe400078e00ffULL, 0x00000003ff057424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0508ff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0200780cULL, 0x000fe20003f04070ULL,
0x000000020e007824ULL, 0x000fe200078e00ffULL, 0x00000001ff4d7819ULL, 0x000fe2000001160cULL,
0x00f6880008ff7f8cULL, 0x0007e2000c80043fULL, 0x000000010c4f7812ULL, 0x000fe200078ec0ffULL,
0x0000590000007624ULL, 0x000fe400078e020fULL, 0x000000204d767824ULL, 0x000fc400078e00ffULL,
0x0000000171507824ULL, 0x000fc800078e0200ULL, 0x0000660050007a24ULL, 0x000fe200078e0276ULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x000000760a057217ULL, 0x00cfe20007800000ULL,
0x000000104f027824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc6000001160bULL,
0x0000000105057824ULL, 0x000fe200078e0a76ULL, 0x00000004040e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000102067824ULL, 0x002fe200078e0204ULL, 0x0000000c040f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000205057217ULL, 0x000fe20007800000ULL, 0x0000000106077824ULL, 0x040fe400078e020bULL,
0x0000000806107824ULL, 0x000fe400078e00ffULL, 0x0000000105057824ULL, 0x000fc600078e0a02ULL,
0xfffffff8100d7812ULL, 0x000fe200078ee207ULL, 0x0000000102107824ULL, 0x000fe200078e020fULL,
0x0000000804077810ULL, 0x040fe40007ffe0ffULL, 0x000000050400720cULL, 0x080fe20003f66070ULL,
0x0000000100047824ULL, 0x000fe200078e0206ULL, 0x000000050e00720cULL, 0x080fe20003f46070ULL,
0x00000001020e7824ULL, 0x040fe200078e020eULL, 0x000000050700720cULL, 0x080fe20003f26070ULL,
0x0000000102077824ULL, 0x000fe200078e0207ULL, 0x000000050f00720cULL, 0x000fe20003f06070ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x00000001000f7824ULL, 0x000fe200078e0210ULL,
0x0000007004117812ULL, 0x000fe200078ef803ULL, 0x0000000110047824ULL, 0x140fe400078e020bULL,
0x0000000810177824ULL, 0x000fe200078e00ffULL, 0x0000620011107a10ULL, 0x000fe20007f9e0ffULL,
0x000000010e067824ULL, 0x040fe400078e020bULL, 0x000000080e137824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee204ULL, 0x0000000100027824ULL, 0x040fe200078e020eULL,
0x0000630005117a10ULL, 0x000fe200027fe4ffULL, 0x00000001000e7824ULL, 0x000fe200078e0207ULL,
0xfffffff813137812ULL, 0x000fe200078ee206ULL, 0x0000000107007824ULL, 0x000fc400078e020bULL,
0x0000000807157824ULL, 0x000fe400078e00ffULL, 0x0000008002047825ULL, 0x000fc600078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee200ULL, 0x000000800e067825ULL, 0x000fe200078e00ffULL,
0x0000007004027812ULL, 0x100fe400078ef803ULL, 0x0000b0004d007811ULL, 0x000fe200078e68ffULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x0000007006047812ULL, 0x100fe400078ef803ULL,
0x0000620002027a10ULL, 0x000fe20007f9e0ffULL, 0x000000100d0d7824ULL, 0x100fe200078e0200ULL,
0x000000700e037812ULL, 0x000fe200078ef803ULL, 0x0000001013137824ULL, 0x100fe200078e0200ULL,
0x0000620004047a10ULL, 0x000fe20007fbe0ffULL, 0x0000001015157824ULL, 0x100fe200078e0200ULL,
0x0000620003067a10ULL, 0x000fe20007fde0ffULL, 0x0000001017177824ULL, 0x000fe200078e0200ULL,
0x0000630005037a10ULL, 0x000fe200027fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100d7faeULL, 0x0003e2000d901c48ULL, 0x0000630007057a10ULL, 0x000fc40002ffe4ffULL,
0x000063000f077a10ULL, 0x000fe200037fe4ffULL, 0x0000000002137faeULL, 0x0003e8000d101c48ULL,
0x0000000004157faeULL, 0x0003e8000c901c48ULL, 0x0000000006177faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x000000104f027824ULL, 0x008fe200078e00ffULL,
0x0000b0004d177811ULL, 0x000fc800078e68ffULL, 0x000000020b027211ULL, 0x000fc800078fe8ffULL,
0x0000000402067810ULL, 0x042fe20007ffe0ffULL, 0x0000000102057824ULL, 0x144fe200078e020bULL,
0x0000000c02107810ULL, 0x040fe20007ffe0ffULL, 0x00000008020e7824ULL, 0x000fe400078e00ffULL,
0x0000000100047824ULL, 0x000fe400078e0202ULL, 0x0000000106077824ULL, 0x000fe200078e020bULL,
0xfffffff80e0d7812ULL, 0x000fe200078ee205ULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x00000008020e7810ULL, 0x000fc60007ffe0ffULL, 0x0000000100027824ULL, 0x000fe200078e0206ULL,
0x0000007004117812ULL, 0x000fe200078ef803ULL, 0x0000000806127824ULL, 0x000fe400078e00ffULL,
0x0000000100137824ULL, 0x000fe400078e0210ULL, 0x0000000110047824ULL, 0x040fe400078e020bULL,
0x0000000810157824ULL, 0x000fe200078e00ffULL, 0x0000620011107a10ULL, 0x000fe20007f1e0ffULL,
0x0000000100067824ULL, 0x000fe200078e020eULL, 0xfffffff812007812ULL, 0x000fe200078ee207ULL,
0x000000010e0f7824ULL, 0x040fe200078e020bULL, 0xfffffff815147812ULL, 0x000fe200078ee204ULL,
0x000000080e0e7824ULL, 0x000fe200078e00ffULL, 0x0000630005117a10ULL, 0x000fe200007fe4ffULL,
0x0000008002047825ULL, 0x000fc600078e00ffULL, 0xfffffff80e127812ULL, 0x000fe200078ee20fULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000007004027812ULL, 0x000fc600078ef803ULL,
0x00000080130e7825ULL, 0x000fe200078e00ffULL, 0x0000007006047812ULL, 0x000fe400078ef803ULL,
0x0000620002027a10ULL, 0x000fe20007f1e0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0217ULL,
0x000000700e037812ULL, 0x000fe200078ef803ULL, 0x0000001000137824ULL, 0x100fe200078e0217ULL,
0x0000620004047a10ULL, 0x000fe20007f3e0ffULL, 0x0000001012157824ULL, 0x100fe200078e0217ULL,
0x0000620003067a10ULL, 0x000fe20007f5e0ffULL, 0x0000001014177824ULL, 0x000fe200078e0217ULL,
0x0000630005037a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100d7faeULL, 0x0003e2000b901c48ULL, 0x0000630007057a10ULL, 0x000fc40000ffe4ffULL,
0x000063000f077a10ULL, 0x000fe200017fe4ffULL, 0x0000000002137faeULL, 0x0003e8000b901c48ULL,
0x0000000004157faeULL, 0x0003e8000b901c48ULL, 0x0000000006177faeULL, 0x0003e4000b901c48ULL,
0x000000004d0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff0900720cULL, 0x000fe20003f05270ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x0000f6a84d027811ULL, 0x002fe200078e18ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000f6a804047891ULL, 0x004fd2000f8e203fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff107f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200002027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000bb2000008947ULL, 0x000fea0003800000ULL,
0x000000ffff107224ULL, 0x002fe200078e0011ULL, 0x00000002ff667819ULL, 0x000fe2000001160cULL,
0x000000ffff007224ULL, 0x004fc400078e0003ULL, 0xff317217ff127424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff177224ULL, 0x000fc400078e00ffULL,
0x000000ffff0f7224ULL, 0x00afca00078e00ffULL, 0x0000000000187805ULL, 0x000fc40000015200ULL,
0x000000040c057824ULL, 0x000fca00078e00ffULL, 0xfffffff805057812ULL, 0x000fc800078ec0ffULL,
0x0000f6c805067810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc00050d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a181a7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09001a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc8000001141bULL, 0x0000001a0d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff1a7224ULL, 0x000fca00000e061bULL, 0x000000020d0d7819ULL, 0x000fc8000000121aULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6cc00050d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000107007810ULL, 0x040fe20007ffe0ffULL, 0x0000010007447824ULL, 0x000fc600078e0276ULL,
0x000000090000720cULL, 0x000fe40003f26070ULL, 0x0000004044057810ULL, 0x000fca0007ffe0ffULL,
0x0000660050367a24ULL, 0x000fcc00078e0205ULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x000000050a007217ULL, 0x000fe20007800000ULL, 0x000000104f0d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0f7819ULL, 0x000fc6000001160bULL, 0x0000000100007824ULL, 0x000fe200078e0a05ULL,
0x000000040f137810ULL, 0x000fe20007ffe0ffULL, 0x000000010d187824ULL, 0x000fe200078e020fULL,
0x000000080f197810ULL, 0x000fe40007ffe0ffULL, 0x000000000d007217ULL, 0x000fe20007800000ULL,
0x0000000118057824ULL, 0x040fe400078e020bULL, 0x00000008181a7824ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fc400078e0a0dULL, 0x000000010d1b7824ULL, 0x000fe200078e0219ULL,
0xfffffff81a117812ULL, 0x000fe200078ee205ULL, 0x000000100b057824ULL, 0x000fe200078e00ffULL,
0x000000001300720cULL, 0x080fe20003f66070ULL, 0x000000010d137824ULL, 0x000fe200078e0213ULL,
0x0000000c0f1a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000118187824ULL, 0x000fe200078e0236ULL,
0x000000000f00720cULL, 0x080fe20003f86070ULL, 0x00000001130f7824ULL, 0x040fe200078e020bULL,
0x000000001a00720cULL, 0x080fe20003f06070ULL, 0x0000000813347824ULL, 0x000fe200078e00ffULL,
0x000000001900720cULL, 0x000fe20003f46070ULL, 0x000000010d357824ULL, 0x000fe200078e021aULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x00000001131a7824ULL, 0x100fe200078e0236ULL,
0xfffffff8340d7812ULL, 0x000fe200078ee20fULL, 0x000000011b347824ULL, 0x000fc400078e0236ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x000000011b007824ULL, 0x140fe200078e020bULL,
0x0000000518187212ULL, 0x080fe200078efcffULL, 0x000000081b0f7824ULL, 0x000fe400078e00ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000620018187a10ULL, 0x000fe40007fbe0ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee200ULL, 0x0000000135367824ULL, 0x040fe200078e0236ULL,
0x000000051a1a7212ULL, 0x000fe200078efcffULL, 0x0000000135137824ULL, 0x000fe200078e020bULL,
0x0000c0004d007811ULL, 0x000fe200078e68ffULL, 0x00000008353c7824ULL, 0x000fe200078e00ffULL,
0x000062001a1a7a10ULL, 0x000fe20007fde0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000630019197a10ULL, 0x000fc40002ffe4ffULL, 0xfffffff83c137812ULL, 0x000fe200078ee213ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000000534347212ULL, 0x080fe400078efcffULL,
0x000063001b1b7a10ULL, 0x000fe200037fe4ffULL, 0x000000100d0d7824ULL, 0x100fe200078e0200ULL,
0x0000000536367212ULL, 0x000fe200078efcffULL, 0x0000001011057824ULL, 0x100fe200078e0200ULL,
0x0000620034347a10ULL, 0x000fe20007fbe0ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0200ULL,
0x0000620036367a10ULL, 0x000fe20007fde0ffULL, 0x0000001013117824ULL, 0x000fe200078e0200ULL,
0x0000630035357a10ULL, 0x000fe20002ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018057faeULL, 0x0003e2000e101c48ULL, 0x0000630037377a10ULL, 0x000fc600037fe4ffULL,
0x000000001a0d7faeULL, 0x0003e8000d901c48ULL, 0x00000000340f7faeULL, 0x0003e8000d101c48ULL,
0x0000000036117faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x000000104f007824ULL, 0x000fe400078e00ffULL, 0x000000100b057824ULL, 0x000fc600078e00ffULL,
0x000000000b007211ULL, 0x000fe400078fe8ffULL, 0x00000070050f7812ULL, 0x000fe400078ec0ffULL,
0x0000000800117810ULL, 0x040fe20007ffe0ffULL, 0x00000001000d7824ULL, 0x040fe200078e020bULL,
0x0000000c001b7810ULL, 0x040fe20007ffe0ffULL, 0x00000008001a7824ULL, 0x040fe400078e00ffULL,
0x0000000100187824ULL, 0x100fe400078e0236ULL, 0x0000000111347824ULL, 0x000fe200078e0236ULL,
0xfffffff81a057812ULL, 0x000fe200078ee20dULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x00000004000d7810ULL, 0x000fc60007ffe0ffULL, 0x0000000111137824ULL, 0x100fe200078e020bULL,
0x0000000f18187212ULL, 0x000fe200078efcffULL, 0x000000010d1a7824ULL, 0x100fe400078e0236ULL,
0x000000011b367824ULL, 0x000fe200078e0236ULL, 0x0000620018187a10ULL, 0x000fe20007f1e0ffULL,
0x00000008113c7824ULL, 0x000fe400078e00ffULL, 0x000000011b117824ULL, 0x000fe200078e020bULL,
0x0000630019197a10ULL, 0x000fe200007fe4ffULL, 0x000000081b3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c137812ULL, 0x000fe200078ee213ULL, 0x000000010d007824ULL, 0x000fc400078e020bULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0xfffffff83e117812ULL, 0x000fc600078ee211ULL,
0x000000080d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000f1a1a7212ULL, 0x000fe200078efcffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee200ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000000f34347212ULL, 0x080fe400078efcffULL,
0x0000c0004d007811ULL, 0x000fe400078e68ffULL, 0x0000000f36367212ULL, 0x000fe400078efcffULL,
0x000062001a1a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000001005057824ULL, 0x100fe200078e0200ULL,
0x0000620034347a10ULL, 0x000fe20007f5e0ffULL, 0x000000100d0d7824ULL, 0x100fe200078e0200ULL,
0x0000620036367a10ULL, 0x000fe20007f7e0ffULL, 0x00000010130f7824ULL, 0x100fe200078e0200ULL,
0x000063001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x0000001011117824ULL, 0x000fe200078e0200ULL,
0x0000630035357a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018057faeULL, 0x0003e2000b901c48ULL, 0x0000630037377a10ULL, 0x000fc60001ffe4ffULL,
0x000000001a0d7faeULL, 0x0003e8000b901c48ULL, 0x00000000340f7faeULL, 0x0003e8000b901c48ULL,
0x0000000036117faeULL, 0x0003e4000b901c48ULL, 0xfffffff0081a7812ULL, 0x042fe400078ec0ffULL,
0xffffffe008007812ULL, 0x000fc400078ec0ffULL, 0x000000001a0573c2ULL, 0x000e6200000e0000ULL,
0x0000001008057812ULL, 0x000fca00078ec0ffULL, 0x0000000100007824ULL, 0x000fe400078e0205ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000084f367824ULL, 0x000fe200078e0200ULL,
0x0000f6b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b0001a1a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080036367f8cULL, 0x000ea4000c80043fULL, 0x0000000000187805ULL, 0x000fc40000015200ULL,
0x0000000808057812ULL, 0x000fca00078ec0ffULL, 0x0000000100057824ULL, 0x000fca00078e0205ULL,
0x00f60c00050d7984ULL, 0x000ee40000000800ULL, 0x800000000dff7812ULL, 0x00cfe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x00000034180d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000135347824ULL, 0x000fe200000e0e19ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011434ULL, 0x0000000d00007211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e0634ULL, 0x0000000200007819ULL, 0x000fc8000000120dULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f60c00050d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100b4e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff677819ULL, 0x000fe2000001160bULL,
0x000000200c007824ULL, 0x000fe400078e00ffULL, 0xffffffffff777424ULL, 0x000fe200078e00ffULL,
0x000000704e4e7812ULL, 0x000fc400078ec0ffULL, 0xffffff8000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c67677812ULL, 0x000fc800078ec0ffULL, 0x0000000067007210ULL, 0x000fca0007ffe04eULL,
0x00f00000000f7984ULL, 0x000ea80000000800ULL, 0x00f2000000137984ULL, 0x0006620000000800ULL,
0x000000120f00720bULL, 0x004fe20003f1d000ULL, 0x000121827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000117806ULL, 0x008fc800000e0100ULL, 0x0000ffff11357812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff007424ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc400078e0012ULL, 0x0000001fff797424ULL, 0x000fe400078e00ffULL,
0xffffffffff787424ULL, 0x000fca00078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x0000000c6600720cULL, 0x000fe40003f05270ULL, 0x000000120f00720bULL, 0x000fe20003f54000ULL,
0x000121127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fc400010e0100ULL,
0x000000800c188824ULL, 0x000fe200078e024eULL, 0x000000120f0d7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991000117816ULL, 0x000fe200000000ffULL,
0x0000000167188824ULL, 0x000fca00078e0218ULL, 0x00f4000d18008388ULL, 0x0005e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x000000120d117221ULL, 0x004fe20000010100ULL, 0x000000ff00ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x0000001100127308ULL, 0x000ea40000000800ULL, 0x000000120e0e7220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fe2000001160bULL,
0x000120427f007947ULL, 0x000fea000b800000ULL, 0x00001f1112117589ULL, 0x0004e400000e0000ULL,
0x0000001138387220ULL, 0x08cfe20000410000ULL, 0x0000001139397220ULL, 0x080fe20000410000ULL,
0x000000111c1c7220ULL, 0x080fe20000410000ULL, 0x000000111d1d7220ULL, 0x080fe20000410000ULL,
0x0000001120207220ULL, 0x080fe20000410000ULL, 0x0000001121217220ULL, 0x080fe20000410000ULL,
0x0000001124247220ULL, 0x080fe20000410000ULL, 0x0000001125257220ULL, 0x080fe20000410000ULL,
0x0000001128287220ULL, 0x080fe20000410000ULL, 0x0000001129297220ULL, 0x080fe20000410000ULL,
0x000000112c2c7220ULL, 0x080fe20000410000ULL, 0x000000112d2d7220ULL, 0x080fe20000410000ULL,
0x0000001130307220ULL, 0x080fe20000410000ULL, 0x0000001131317220ULL, 0x080fe20000410000ULL,
0x0000001114147220ULL, 0x080fe20000410000ULL, 0x0000001115157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0000ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080b117811ULL, 0x000fe200078ff0ffULL,
0x00011f227f007947ULL, 0x000fea000b800000ULL, 0x00001f1112117589ULL, 0x0004e400000e0000ULL,
0x000000113a3a7220ULL, 0x08cfe20000410000ULL, 0x000000113b3b7220ULL, 0x080fe20000410000ULL,
0x000000111e1e7220ULL, 0x080fe20000410000ULL, 0x000000111f1f7220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x0000001126267220ULL, 0x080fe20000410000ULL, 0x0000001127277220ULL, 0x080fe20000410000ULL,
0x000000112a2a7220ULL, 0x080fe20000410000ULL, 0x000000112b2b7220ULL, 0x080fe20000410000ULL,
0x000000112e2e7220ULL, 0x080fe20000410000ULL, 0x000000112f2f7220ULL, 0x080fe20000410000ULL,
0x0000001132327220ULL, 0x080fe20000410000ULL, 0x0000001133337220ULL, 0x080fe20000410000ULL,
0x0000001116167220ULL, 0x080fe20000410000ULL, 0x0000001117177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806000ULL,
0x00000001ff007424ULL, 0x000fd800078e00ffULL, 0x8000000d0f0f0221ULL, 0x000fe20000010000ULL,
0x00007610ff000816ULL, 0x000fc60000000000ULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f00040308ULL, 0x000ea40000000800ULL, 0x0000000413130220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000e130e7221ULL, 0x002fc40000010000ULL,
0x0000000000127805ULL, 0x000fca0000015200ULL, 0xfffffff008347812ULL, 0x000fca00078ec0ffULL,
0x00f6ac00340f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804810ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x0000001812187210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e13ULL, 0x003d09001800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011419ULL,
0x000000180f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff187224ULL, 0x000fca00000e0619ULL,
0x000000020f0f7819ULL, 0x000fc80000001218ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00340f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991000007816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000004ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff0f7819ULL, 0x000fe4000001160bULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x00011af27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f00037589ULL, 0x0002a400000e0000ULL, 0x000000080f117810ULL, 0x000fe20007ffe0ffULL,
0x00011b227f007947ULL, 0x000fea000b800000ULL, 0x00001f1100027589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f117810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e0000ULL, 0x00002bf000197802ULL, 0x000fc40000000f00ULL,
0x000124f000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f117810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e0000ULL,
0x00002c4000197802ULL, 0x000fc40000000f00ULL, 0x000124a000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000070b0f7812ULL, 0x002fe200078ec0ffULL,
0x000002000c457824ULL, 0x000fe200078e00ffULL, 0x00000004ff107819ULL, 0x100fe2000001160bULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000080f187812ULL, 0x000fc400078ef80bULL,
0xfffff80045457812ULL, 0x000fe200078ec0ffULL, 0x000000044d117824ULL, 0x00cfe200078e0210ULL,
0x000000080b007812ULL, 0x000fe200078ec0ffULL, 0x0000000818487824ULL, 0x040fe400078e00ffULL,
0x0000000118197824ULL, 0x000fca00078e0211ULL, 0xfffffff848487812ULL, 0x000fca00078ee219ULL,
0x0000001048487824ULL, 0x000fc400078e0245ULL, 0x000000044f3d7824ULL, 0x000fe200078e0210ULL,
0x0000000f00107212ULL, 0x000fe200078efcffULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0x0000b0004d527811ULL, 0x000fe400078e68ffULL, 0x0000001000007812ULL, 0x000fe200078efe0fULL,
0x0000000110117824ULL, 0x040fe200078e023dULL, 0x0000000219497810ULL, 0x000fe20007ffe0ffULL,
0x0000000810127824ULL, 0x040fe400078e00ffULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0xfffffff818497812ULL, 0x000fe200078ee249ULL, 0x000000013d3d7824ULL, 0x000fe200078e0200ULL,
0xfffffff812137812ULL, 0x000fe200078ee211ULL, 0x00000008003c7824ULL, 0x040fe200078e00ffULL,
0x0000000211117810ULL, 0x000fe20007ffe0ffULL, 0x00000008003e7824ULL, 0x000fe200078e00ffULL,
0x000000023d197810ULL, 0x000fe20007ffe0ffULL, 0x0000001013347824ULL, 0x000fe200078e0252ULL,
0xfffffff810117812ULL, 0x000fe200078ee211ULL, 0x0000001049497824ULL, 0x000fe200078e0245ULL,
0xfffffff83c3d7812ULL, 0x000fc400078ee23dULL, 0xfffffff83e197812ULL, 0x000fe200078ee219ULL,
0x000000003434783bULL, 0x000e620000004200ULL, 0x0000001011117824ULL, 0x100fe400078e0252ULL,
0x000000103d3f7824ULL, 0x000fc800078e0252ULL, 0x000000001110783bULL, 0x000ea20000004200ULL,
0x00000010ff187819ULL, 0x102fe40000011634ULL, 0x000000ff340f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe40000011634ULL, 0x0000ffff34537812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x000fe40000011635ULL, 0x000000ff35517812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011635ULL, 0x0000ffff35697812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6b7819ULL, 0x100fe40000011636ULL, 0x000000ff36707812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011636ULL, 0x0000ffff36627812ULL, 0x000fc400078ec0ffULL,
0x00000010ff6a7819ULL, 0x100fe40000011637ULL, 0x000000ff376d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011637ULL, 0x0000ffff37647812ULL, 0x000fe400078ec0ffULL,
0x000000003f34783bULL, 0x0002e20000004200ULL, 0x00000010ff5a7819ULL, 0x004fe40000011610ULL,
0x000000ff10597812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe40000011610ULL,
0x0000ffff103c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff107819ULL, 0x000fe40000011653ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x00000010ff10723eULL, 0x000fc400020006ffULL, 0x0000000fff43723eULL, 0x000fe200020006ffULL,
0x2000004cff567230ULL, 0x000fe20000004100ULL, 0x000000ff18187812ULL, 0x000fe200078ec0ffULL,
0x20000010ff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x100fe20000011611ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x000000ff11617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe40000011611ULL, 0x0000ffff113e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff0f7819ULL, 0x100fe40000011612ULL, 0x000000ff12467812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3f7819ULL, 0x002fe40000011612ULL, 0x0000ffff12547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff557819ULL, 0x000fe40000011613ULL, 0x000000ff13477812ULL, 0x000fc400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011613ULL, 0x0000ffff134b7812ULL, 0x000fe400078ec0ffULL,
0x009000004810783bULL, 0x000e620000000200ULL, 0x00000018ff18723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x00000010ff567819ULL, 0x000fe20000011656ULL,
0x20000051ff537230ULL, 0x000fe20000004100ULL, 0x00000008ff697819ULL, 0x000fe20000011669ULL,
0x20000042ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff427819ULL, 0x000fc40000011643ULL,
0x00000010ff437819ULL, 0x000fe40000011618ULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x0000105443427816ULL, 0x000fe40000000042ULL, 0x0000105456437816ULL, 0x000fe40000000053ULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff187819ULL, 0x000fc4000001164cULL,
0x00000010ff567819ULL, 0x108fe40000011635ULL, 0x000000ff35687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe40000011635ULL, 0x0000ffff35587812ULL, 0x000fe400078ec0ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000069ff35723eULL, 0x000fc400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x0000105451187816ULL, 0x000fe20000000018ULL, 0x0000000310108231ULL, 0x082fe200003400ffULL,
0x00000010ff577819ULL, 0x100fe20000011636ULL, 0x0000000312128231ULL, 0x000fe200003400ffULL,
0x000000ff365b7812ULL, 0x040fe200078ec0ffULL, 0x0000000211118231ULL, 0x080fe200003400ffULL,
0x00000018ff4c7819ULL, 0x000fe20000011636ULL, 0x0000000213138231ULL, 0x000fe200003400ffULL,
0x0000ffff365e7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5d7819ULL, 0x100fe40000011637ULL,
0x000000ff375c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff517819ULL, 0x000fe20000011637ULL,
0x000000421038723cULL, 0x000b620000041838ULL, 0x0000ffff37637812ULL, 0x000fe400078ec0ffULL,
0x000000ff6a377812ULL, 0x000fe200078ec0ffULL, 0x2000006dff6a7230ULL, 0x000fe20000004100ULL,
0x00000008ff367819ULL, 0x000fe20000011662ULL, 0x2000006eff627230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x000fc40000011634ULL, 0x000000ff345f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe40000011634ULL, 0x0000ffff34537812ULL, 0x000fe400078ec0ffULL,
0x00000037ff6d723eULL, 0x000fe200020006ffULL, 0x0000001019377824ULL, 0x000fe200078e0252ULL,
0x00000036ff6e723eULL, 0x000fe400020006ffULL, 0x0000006cff34723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe2000001166fULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc40000011635ULL,
0x000000ff6b6c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6b7819ULL, 0x000fe20000011664ULL,
0x20000034ff647230ULL, 0x000fe20000004100ULL, 0x0000105436197816ULL, 0x000fe40000000035ULL,
0x000000003734783bULL, 0x000e620000004200ULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x00000018101c723cULL, 0x000be2000004181cULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000070ff697230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff437819ULL, 0x020fc4000001166aULL,
0x000000ff3d187812ULL, 0x000fe200078ec0ffULL, 0x20000059ff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fe20000011669ULL, 0x20000061ff597230ULL, 0x000fe20000004100ULL,
0x00000018ff61723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff197819ULL, 0x000fe4000001166cULL, 0x00000010ff187819ULL, 0x000fe2000001166dULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000105419427816ULL, 0x000fc40000000042ULL,
0x0000105418437816ULL, 0x000fe40000000043ULL, 0x00000010ff197819ULL, 0x000fe40000011662ULL,
0x00000010ff187819ULL, 0x000fe4000001166eULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x000000421020723cULL, 0x000b620000041820ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x0000105419187816ULL, 0x000fe40000000018ULL,
0x0000005cff6a723eULL, 0x000fe400020006ffULL, 0x0000105464197816ULL, 0x000fe4000000006bULL,
0x0000005bff69723eULL, 0x000fe200020006ffULL, 0x20000060ff5b7230ULL, 0x000fe20000004100ULL,
0x0000004cff6b723eULL, 0x000fe200020006ffULL, 0x20000068ff607230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x000000181024723cULL, 0x000b620000041824ULL,
0x00000051ff68723eULL, 0x000fe200020006ffULL, 0x2000006aff517230ULL, 0x000fe20000004100ULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000046ff6a723eULL, 0x000fe200020006ffULL, 0x2000006bff467230ULL, 0x000fe20000004100ULL,
0x00000008ff587819ULL, 0x000fe20000011658ULL, 0x20000069ff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x020fc40000011661ULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000047ff6b723eULL, 0x000fe200020006ffULL, 0x20000068ff477230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x2000003fff687230ULL, 0x000fe20000004100ULL,
0x00000058ff3f723eULL, 0x000fe200020006ffULL, 0x20000065ff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff5e7819ULL, 0x000fe2000001165eULL, 0x20000040ff697230ULL, 0x000fe20000004100ULL,
0x0000105442197816ULL, 0x000fe20000000059ULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fc4000001163dULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000018ff6c7819ULL, 0x002fe40000011634ULL, 0x00000010ff627819ULL, 0x100fe40000011635ULL,
0x000000ff35707812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011635ULL,
0x0000ffff35597812ULL, 0x000fc400078ec0ffULL, 0x000000ff366e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff357819ULL, 0x000fe40000011636ULL, 0x000000ff48657812ULL, 0x000fe400078ec0ffULL,
0x000000ff56487812ULL, 0x000fe400078ec0ffULL, 0x0000005eff40723eULL, 0x000fe200020006ffULL,
0x2000003fff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff3c7819ULL, 0x000fc4000001163cULL,
0x00000008ff567819ULL, 0x000fe4000001163eULL, 0x000010545a187816ULL, 0x000fe4000000003dULL,
0x0000006cff3f723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000010ff647819ULL, 0x000fe20000011634ULL, 0x2000003fff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff346f7812ULL, 0x040fe200078ec0ffULL, 0x000000181028723cULL, 0x000b620000041828ULL,
0x0000ffff34617812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5a7819ULL, 0x000fe40000011636ULL,
0x0000ffff36437812ULL, 0x000fe400078ec0ffULL, 0x00000035ff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff427819ULL, 0x100fe40000011637ULL, 0x000000ff37367812ULL, 0x000fe400078ec0ffULL,
0x00000018ff347819ULL, 0x000fc40000011637ULL, 0x0000ffff373d7812ULL, 0x000fe400078ec0ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x0000003cff35723eULL, 0x000fe200020006ffULL,
0x2000006eff3c7230ULL, 0x000fe20000004100ULL, 0x0000004aff37723eULL, 0x000fe200020006ffULL,
0x20000041ff737230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x000000ff0f0f7812ULL, 0x000fe200078ec0ffULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x000000ff556e7812ULL, 0x000fe400078ec0ffULL, 0x0000000fff55723eULL, 0x000fe200020006ffULL,
0x20000056ff0f7230ULL, 0x000fe20000004100ULL, 0x00000008ff417819ULL, 0x000fe20000011653ULL,
0x2000006dff3f7230ULL, 0x000fe20000004100ULL, 0x00000034ff6d723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x000000ff57537812ULL, 0x000fe400078ec0ffULL,
0x00000036ff36723eULL, 0x000fc400020006ffULL, 0x00000010ff347819ULL, 0x000fe40000011673ULL,
0x00000010ff357819ULL, 0x000fe40000011635ULL, 0x00000010ff567819ULL, 0x000fe40000011637ULL,
0x00000010ff577819ULL, 0x000fe2000001160fULL, 0x20000036ff0f7230ULL, 0x000fe20000004100ULL,
0x0000105456567816ULL, 0x000fe40000000035ULL, 0x0000105434577816ULL, 0x000fc40000000057ULL,
0x009000004934783bULL, 0x000e620000000200ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000008ff187819ULL, 0x020fe4000001164bULL, 0x000000ff64197812ULL, 0x000fe200078ec0ffULL,
0x00000056102c723cULL, 0x000b62000004182cULL, 0x00000008ff547819ULL, 0x000fe40000011654ULL,
0x00000018ff64723eULL, 0x000fe200020006ffULL, 0x2000006eff187230ULL, 0x000fe20000004100ULL,
0x00000054ff4b723eULL, 0x000fc400020006ffULL, 0x00000019ff6e723eULL, 0x000fe200020006ffULL,
0x2000006cff197230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fe2000001166aULL,
0x2000004bff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fe20000011655ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x2000006eff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fe20000011618ULL,
0x2000006dff187230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fc400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000105455547816ULL, 0x000fe20000000054ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x000010546c557816ULL, 0x000fe4000000006bULL,
0x00000008ff4a7819ULL, 0x000fe20000011663ULL, 0x20000048ff637230ULL, 0x000fe20000004100ULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x20000040ff487230ULL, 0x000fe20000004100ULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x000000541030723cULL, 0x000b640000041830ULL,
0x00000010ff577819ULL, 0x020fe20000011668ULL, 0x0000000334348231ULL, 0x082fe200003400ffULL,
0x00000010ff567819ULL, 0x000fe2000001166aULL, 0x0000000336368231ULL, 0x000fe200003400ffULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x0000000235358231ULL, 0x080fe200003400ffULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x0000000237378231ULL, 0x000fe200003400ffULL,
0x00000062ff68723eULL, 0x000fc400020006ffULL, 0x00000010ff547819ULL, 0x000fe4000001165fULL,
0x00000010ff557819ULL, 0x000fe20000011660ULL, 0x20000068ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff627819ULL, 0x000fe40000011663ULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x0000005dff58723eULL, 0x000fc400020006ffULL,
0x0000105457567816ULL, 0x000fe20000000056ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x0000105469577816ULL, 0x000fe40000000064ULL, 0x0000105465547816ULL, 0x000fe20000000054ULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x0000105462557816ULL, 0x000fe40000000055ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x000000561010723cULL, 0x000f620000041814ULL,
0x00000008ff617819ULL, 0x000fc40000011661ULL, 0x00000008ff597819ULL, 0x000fe20000011659ULL,
0x20000041ff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff587819ULL, 0x000fe20000011658ULL, 0x000000543414723cULL, 0x000b620000041838ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x00000010ff387819ULL, 0x020fe4000001164cULL,
0x00000010ff397819ULL, 0x000fe20000011651ULL, 0x2000006fff407230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe40000011646ULL, 0x00000010ff3a7819ULL, 0x000fe40000011648ULL,
0x00000070ff41723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fc400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x0000105453387816ULL, 0x000fe20000000038ULL, 0x20000061ff5f7230ULL, 0x000fe20000004100ULL,
0x0000105458397816ULL, 0x000fe20000000039ULL, 0x20000059ff517230ULL, 0x000fe20000004100ULL,
0x000010543b3a7816ULL, 0x000fe4000000003aULL, 0x00001054473b7816ULL, 0x000fe4000000004aULL,
0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL, 0x000000383420723cULL, 0x000b620000041820ULL,
0x000000ff42427812ULL, 0x000fc400078ec0ffULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff387819ULL, 0x020fe20000011640ULL,
0x0000003a3424723cULL, 0x000b620000041824ULL, 0x00000010ff397819ULL, 0x000fe40000011641ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000008ff3d7819ULL, 0x000fc4000001163dULL,
0x00000010ff3b7819ULL, 0x020fe4000001163eULL, 0x00000010ff3a7819ULL, 0x000fe4000001165fULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff3e7819ULL, 0x000fe4000001163fULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x2000005aff4c7230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x000010544b387816ULL, 0x000fe20000000038ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000105460397816ULL, 0x000fe20000000039ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x000010543b3a7816ULL, 0x000fe4000000003aULL,
0x000010543e3b7816ULL, 0x000fe20000000051ULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x000000383428723cULL, 0x000b620000041828ULL, 0x00000010ff5b7819ULL, 0x000fc4000001165bULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff567819ULL, 0x000fe4000001165dULL,
0x00000010ff387819ULL, 0x020fe2000001163cULL, 0x0000003a342c723cULL, 0x000b62000004182cULL,
0x00000010ff397819ULL, 0x000fe4000001164cULL, 0x00000010ff577819ULL, 0x000fe4000001165eULL,
0x00000010ff0f7819ULL, 0x000fc4000001160fULL, 0x00000010ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff3a7819ULL, 0x020fe40000011619ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff187819ULL, 0x000fe40000011618ULL, 0x00000010ff3b7819ULL, 0x000fe4000001163dULL,
0x0000105439387816ULL, 0x000fc40000000038ULL, 0x000010545b567816ULL, 0x000fe40000000056ULL,
0x000010545c577816ULL, 0x000fe40000000057ULL, 0x0000105442397816ULL, 0x000fe2000000000fULL,
0x000000020c0f7824ULL, 0x000fe200078e00ffULL, 0x000010543a3a7816ULL, 0x000fe40000000043ULL,
0x00001054183b7816ULL, 0x000fe2000000003bULL, 0x00000056341c723cULL, 0x000b62000004181cULL,
0x0000f6c84d187811ULL, 0x000fc400078e18ffULL, 0xfffffff80f0f7812ULL, 0x000fca00078ec0ffULL,
0x000000383430723cULL, 0x040b700000041830ULL, 0x0000003a3434723cULL, 0x000b620000041810ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000018187f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f688000fff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff387224ULL, 0x020fc600078e00ffULL,
0x0000000000107805ULL, 0x000fc80000015200ULL, 0x00000400060f7984ULL, 0x004ea40000000800ULL,
0x800000000fff7812ULL, 0x006fc40007804819ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011413ULL,
0x000000120f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x000000020f0f7819ULL, 0x000fc80000001212ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400060f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008044117810ULL, 0x000fca0007ffe0ffULL, 0x0000660050197a24ULL, 0x000fe200078e0211ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x000000110a0f7217ULL, 0x000fe20007800000ULL,
0x000000104f127824ULL, 0x000fe200078e00ffULL, 0x00000003ff107819ULL, 0x000fc6000001160bULL,
0x000000010f0f7824ULL, 0x000fe200078e0a11ULL, 0x0000000410137810ULL, 0x000fe20007ffe0ffULL,
0x0000000112187824ULL, 0x000fe200078e0210ULL, 0x0000000810397810ULL, 0x000fe40007ffe0ffULL,
0x0000000f120f7217ULL, 0x000fe20007800000ULL, 0x0000000118117824ULL, 0x040fe400078e020bULL,
0x0000000818387824ULL, 0x000fe400078e00ffULL, 0x000000010f0f7824ULL, 0x000fc400078e0a12ULL,
0x00000001123a7824ULL, 0x000fe200078e0239ULL, 0xfffffff8383b7812ULL, 0x000fe200078ee211ULL,
0x0000000112387824ULL, 0x000fe200078e0213ULL, 0x0000000f1300720cULL, 0x080fe40003f66070ULL,
0x0000000f1000720cULL, 0x080fe20003f86070ULL, 0x0000000138117824ULL, 0x000fe200078e020bULL,
0x0000000c10137810ULL, 0x000fe20007ffe0ffULL, 0x0000000118107824ULL, 0x000fe200078e0219ULL,
0x0000000f3900720cULL, 0x080fe20003f46070ULL, 0x0000000838187824ULL, 0x000fe200078e00ffULL,
0x0000000f1300720cULL, 0x000fe20003f06070ULL, 0x00000001123c7824ULL, 0x000fc400078e0213ULL,
0x0000000138127824ULL, 0x000fe200078e0219ULL, 0xfffffff8180f7812ULL, 0x000fe200078ee211ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x000000013a187824ULL, 0x000fe200078e0219ULL,
0x0000004e10107212ULL, 0x000fe200078efcffULL, 0x000000013a397824ULL, 0x040fe400078e020bULL,
0x000000083a3a7824ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fe20007fbe0ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff83a3d7812ULL, 0x000fe200078ee239ULL,
0x000000013c387824ULL, 0x000fe200078e0219ULL, 0x0000004e12127212ULL, 0x080fe200078efcffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000630011117a10ULL, 0x000fe40002ffe4ffULL,
0x0000620012127a10ULL, 0x000fe20007fbe0ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000004e18187212ULL, 0x080fe400078efcffULL, 0x0000630013137a10ULL, 0x000fe20002ffe4ffULL,
0x000000013c3a7824ULL, 0x000fe200078e020bULL, 0x0000004e38387212ULL, 0x000fe200078efcffULL,
0x000000083c3f7824ULL, 0x000fe200078e00ffULL, 0x0000620018187a10ULL, 0x000fe20007fbe0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0252ULL, 0x0000620038387a10ULL, 0x000fe20007fde0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0252ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee23aULL,
0x000000103d3d7824ULL, 0x100fe200078e0252ULL, 0x0000630019197a10ULL, 0x000fe20002ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103b7faeULL, 0x0003e2000e101c48ULL,
0x0000630039397a10ULL, 0x000fe200037fe4ffULL, 0x000000103f3f7824ULL, 0x000fc400078e0252ULL,
0x00000000120f7faeULL, 0x0003e8000d901c48ULL, 0x00000000183d7faeULL, 0x0003e8000d101c48ULL,
0x00000000383f7faeULL, 0x0003e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x000000104f107824ULL, 0x000fca00078e00ffULL, 0x000000100b127211ULL, 0x000fc800078fe8ffULL,
0x0000000412387810ULL, 0x040fe20007ffe0ffULL, 0x00000001120f7824ULL, 0x140fe200078e020bULL,
0x0000000812187810ULL, 0x040fe20007ffe0ffULL, 0x00000008123a7824ULL, 0x000fe400078e00ffULL,
0x0000000138107824ULL, 0x040fe400078e020bULL, 0x00000008383b7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a0f7812ULL, 0x000fe200078ee20fULL, 0x0000000118117824ULL, 0x000fe200078e020bULL,
0x0000000c123a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008183c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL, 0x0000000112107824ULL, 0x000fc400078e0219ULL,
0x0000000138387824ULL, 0x000fe200078e0219ULL, 0xfffffff83c3d7812ULL, 0x000fe200078ee211ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000118127824ULL, 0x100fe200078e0219ULL,
0x0000004e10107212ULL, 0x000fe200078efcffULL, 0x000000013a187824ULL, 0x000fe400078e0219ULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fc60007f1e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000004e38387212ULL, 0x080fe400078efcffULL,
0x0000630011117a10ULL, 0x000fe200007fe4ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000004e12127212ULL, 0x080fe400078efcffULL, 0x0000620038387a10ULL, 0x000fe20007f5e0ffULL,
0x000000013a3c7824ULL, 0x000fe200078e020bULL, 0x0000004e18187212ULL, 0x000fe200078efcffULL,
0x000000083a3f7824ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0252ULL, 0x0000620018187a10ULL, 0x000fe20007f7e0ffULL,
0x000000103b3b7824ULL, 0x000fe200078e0252ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee23cULL,
0x000000103d3d7824ULL, 0x100fe200078e0252ULL, 0x0000630039397a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100f7faeULL, 0x0003e2000b901c48ULL,
0x0000630013137a10ULL, 0x000fe200007fe4ffULL, 0x000000103f3f7824ULL, 0x000fe200078e0252ULL,
0x0000630019197a10ULL, 0x000fe20001ffe4ffULL, 0x00000000383b7faeULL, 0x0003e8000b901c48ULL,
0x00000000123d7faeULL, 0x0003e8000b901c48ULL, 0x00000000183f7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000104d0f7824ULL, 0x000fe200078e00ffULL,
0xffffffe008107812ULL, 0x000fc400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000808117812ULL, 0x000fe400078ec0ffULL, 0x000000100f0f7812ULL, 0x000fc800078ec0ffULL,
0x00000010110f7210ULL, 0x000fe20007ffe00fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff127f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f628000f387f8cULL, 0x0004e4000c80043fULL,
0x0000000000107805ULL, 0x000fc40000015200ULL, 0x00f62c00050f7984ULL, 0x004ea40000000800ULL,
0x800000000fff7812ULL, 0x00cfe40007804839ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001810187210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e11ULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011419ULL, 0x000000180f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff187224ULL, 0x000fca00000e0619ULL, 0x000000020f0f7819ULL, 0x000fc80000001218ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c00050f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fe40007804839ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000200c0f7824ULL, 0x000fca00078e00ffULL,
0xffffff800f0f7812ULL, 0x000fc800078ec0ffULL, 0x000000804e107810ULL, 0x000fca0007ffe00fULL,
0x0000000167107824ULL, 0x000fca00078e0210ULL, 0x00f0000010387984ULL, 0x000ea80000000800ULL,
0x00f20000100f7984ULL, 0x0006620000000800ULL, 0x0000000d3800720bULL, 0x004fe20003f1d000ULL,
0x0000f4727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000117806ULL, 0x008fc800000e0100ULL,
0x0000ffff113b7812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff397424ULL, 0x000fd600078e00ffULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x0000000166117810ULL, 0x000fe40007ffe0ffULL, 0x0000000d3800720bULL, 0x000fe40003f54000ULL,
0x0000000c1100720cULL, 0x000fe20003f05270ULL, 0x0000f4227f007947ULL, 0x000fd4000b800000ULL,
0x0000000000107806ULL, 0x000fc400010e0100ULL, 0x000000800c3a8824ULL, 0x000fe200078e024eULL,
0x0000000d38187209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991010117816ULL, 0x000fe200000000ffULL, 0x0000000167198824ULL, 0x000fca00078e023aULL,
0x00f4001819008388ULL, 0x0005e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000180d117221ULL, 0x004fe20000010000ULL,
0x000000ff10ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x0000001100397308ULL, 0x000ea40000000800ULL,
0x000000390e0e7220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fe2000001160bULL, 0x0000f3527f007947ULL, 0x000fea000b800000ULL,
0x00001f1139117589ULL, 0x0004e400000e0000ULL, 0x0000001114147220ULL, 0x08cfe20000410000ULL,
0x0000001115157220ULL, 0x080fe20000410000ULL, 0x000000111c1c7220ULL, 0x080fe20000410000ULL,
0x000000111d1d7220ULL, 0x080fe20000410000ULL, 0x0000001120207220ULL, 0x080fe20000410000ULL,
0x0000001121217220ULL, 0x080fe20000410000ULL, 0x0000001124247220ULL, 0x080fe20000410000ULL,
0x0000001125257220ULL, 0x080fe20000410000ULL, 0x0000001128287220ULL, 0x080fe20000410000ULL,
0x0000001129297220ULL, 0x080fe20000410000ULL, 0x000000112c2c7220ULL, 0x080fe20000410000ULL,
0x000000112d2d7220ULL, 0x080fe20000410000ULL, 0x0000001130307220ULL, 0x080fe20000410000ULL,
0x0000001131317220ULL, 0x080fe20000410000ULL, 0x0000001134347220ULL, 0x080fe20000410000ULL,
0x0000001135357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0010ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080b117811ULL, 0x000fe200078ff0ffULL, 0x0000f2327f007947ULL, 0x000fea000b800000ULL,
0x00001f1139117589ULL, 0x0004e400000e0000ULL, 0x0000001116167220ULL, 0x08cfe20000410000ULL,
0x0000001117177220ULL, 0x080fe20000410000ULL, 0x000000111e1e7220ULL, 0x080fe20000410000ULL,
0x000000111f1f7220ULL, 0x080fe20000410000ULL, 0x0000001122227220ULL, 0x080fe20000410000ULL,
0x0000001123237220ULL, 0x080fe20000410000ULL, 0x0000001126267220ULL, 0x080fe20000410000ULL,
0x0000001127277220ULL, 0x080fe20000410000ULL, 0x000000112a2a7220ULL, 0x080fe20000410000ULL,
0x000000112b2b7220ULL, 0x080fe20000410000ULL, 0x000000112e2e7220ULL, 0x080fe20000410000ULL,
0x000000112f2f7220ULL, 0x080fe20000410000ULL, 0x0000001132327220ULL, 0x080fe20000410000ULL,
0x0000001133337220ULL, 0x080fe20000410000ULL, 0x0000001136367220ULL, 0x080fe20000410000ULL,
0x0000001137377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff3bff7812ULL, 0x000fe20007806010ULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x0000000d380d7209ULL, 0x000fd60007810000ULL, 0x8000000d38380221ULL, 0x000fe20000010000ULL,
0x00007610ff390816ULL, 0x000fc60000000039ULL, 0x3fb8aa3b38380820ULL, 0x000fc80000410000ULL,
0x0000003800040308ULL, 0x000ea40000000800ULL, 0x000000040f0f0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000e0f0e7221ULL, 0x002fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0xfffffff0083a7812ULL, 0x000fca00078ec0ffULL,
0x00f6b4003a0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780481bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x0000001810187210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e11ULL, 0x003d09001800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011419ULL,
0x000000180f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff187224ULL, 0x000fca00000e0619ULL,
0x000000020f0f7819ULL, 0x000fc80000001218ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b4003a0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910390f7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000004ff02723eULL, 0x000fe400000010ffULL, 0x00000002ff107819ULL, 0x000fe4000001160bULL,
0x00005410020f7816ULL, 0x000fe20000000002ULL, 0x0000edf27f007947ULL, 0x000fea000b800000ULL,
0x00001f100f037589ULL, 0x0002a400000e0000ULL, 0x0000000810117810ULL, 0x000fe20007ffe0ffULL,
0x0000ee227f007947ULL, 0x000fea000b800000ULL, 0x00001f110f027589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001010117810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e000fULL, 0x00005ab000197802ULL, 0x000fc40000000f00ULL,
0x0000f63000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001810117810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e000fULL,
0x00005b0000197802ULL, 0x000fc40000000f00ULL, 0x0000f5e000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000020c117824ULL, 0x00cfe200078e00ffULL,
0x000000070b197812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x0000000411107812ULL, 0x002fc400078ec0ffULL, 0x0000000819187812ULL, 0x000fe400078ef80bULL,
0x000000100b0f7211ULL, 0x000fc600078fe0ffULL, 0x0000000818487824ULL, 0x040fe400078e00ffULL,
0x00000001180f7824ULL, 0x000fe200078e020fULL, 0x000000080b187812ULL, 0x000fc800078ec0ffULL,
0xfffffff848487812ULL, 0x000fca00078ee20fULL, 0x0000001048487824ULL, 0x000fc400078e0245ULL,
0x000000040c107824ULL, 0x000fe200078e00ffULL, 0x00000019183d7212ULL, 0x000fe200078efcffULL,
0x00000008004c7824ULL, 0x000fe200078e00ffULL, 0x0000100052537810ULL, 0x000fe20007ffe0ffULL,
0x00000008003f7824ULL, 0x000fe200078e00ffULL, 0x0000000410107812ULL, 0x000fe200078ec0ffULL,
0x000000083d197824ULL, 0x040fe400078e00ffULL, 0x000000083d3c7824ULL, 0x000fe200078e00ffULL,
0x000000100b107211ULL, 0x000fca00078fe0ffULL, 0x000000013d387824ULL, 0x100fe400078e0210ULL,
0x00000001003b7824ULL, 0x000fc600078e0210ULL, 0xfffffff819187812ULL, 0x000fe400078ee238ULL,
0x0000000238477810ULL, 0x000fe40007ffe0ffULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee23bULL,
0x0000001018517824ULL, 0x000fe200078e0253ULL, 0x000000023b467810ULL, 0x000fe40007ffe0ffULL,
0xfffffff83c477812ULL, 0x000fe400078ee247ULL, 0x000000005140783bULL, 0x000e620000004200ULL,
0xfffffff83f467812ULL, 0x000fc400078ee246ULL, 0x00000018ff387819ULL, 0x102fe40000011640ULL,
0x000000ff413a7812ULL, 0x000fe400078ec0ffULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000003aff3b723eULL, 0x000fe400020006ffULL, 0x00000018ff3a7819ULL, 0x000fe20000011641ULL,
0x20000038ff4b7230ULL, 0x000fe20000004100ULL, 0x000000ff40187812ULL, 0x000fe200078ec0ffULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fc40000011640ULL,
0x0000003aff55723eULL, 0x000fe400020006ffULL, 0x00000010ff3a7819ULL, 0x000fe40000011641ULL,
0x000000ff38387812ULL, 0x000fe200078ec0ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000018ff39723eULL, 0x000fe400020006ffULL, 0x009800004818783bULL, 0x000e620000000200ULL,
0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL, 0x00000038ff38723eULL, 0x000fe200020006ffULL,
0x20000039ff397230ULL, 0x000fe20000004100ULL, 0x0000003aff3a723eULL, 0x000fc400020006ffULL,
0x0000ffff40567812ULL, 0x000fe200078ec0ffULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x000000ff423c7812ULL, 0x000fe200078ec0ffULL, 0x2000003aff407230ULL, 0x000fe20000004100ULL,
0x0000ffff41417812ULL, 0x000fe400078ec0ffULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000010ff387819ULL, 0x000fe40000011638ULL, 0x00000008ff3a7819ULL, 0x000fc40000011656ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000008ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff567819ULL, 0x000fe20000011640ULL, 0x2000003cff547230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe2000001163bULL, 0x00000010473c7824ULL, 0x000fe200078e0253ULL,
0x0000105438407816ULL, 0x000fe40000000039ULL, 0x000000ff433d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff387819ULL, 0x100fe40000011642ULL, 0x00000010ff397819ULL, 0x000fe40000011643ULL,
0x00000041ff57723eULL, 0x000fe400020006ffULL, 0x0000105456417816ULL, 0x000fe2000000003bULL,
0x000000104c3b7824ULL, 0x000fe200078e0253ULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x0000000318188231ULL, 0x082fe200003400ffULL, 0x0000003aff3a723eULL, 0x000fe200020006ffULL,
0x000000031a1a8231ULL, 0x000fe200003400ffULL, 0x000000ff38387812ULL, 0x000fe200078ec0ffULL,
0x2000003dff4a7230ULL, 0x000fe20000004100ULL, 0x000000ff39397812ULL, 0x000fe200078ec0ffULL,
0x2000003aff567230ULL, 0x000fe20000004100ULL, 0x00000038ff59723eULL, 0x000fe200020006ffULL,
0x000000003c3c783bULL, 0x000e620000004200ULL, 0x00000039ff5a723eULL, 0x000fe200020006ffULL,
0x0000000219198231ULL, 0x080fe200003400ffULL, 0x00000010ff4b7819ULL, 0x000fe2000001164bULL,
0x000000003b38783bULL, 0x000ea20000004200ULL, 0x000000021b1b8231ULL, 0x000fe200003400ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000018ff6f7819ULL, 0x000fe20000011642ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff587819ULL, 0x000fe20000011655ULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fe20000011659ULL,
0x000000401814723cULL, 0x000be20000041814ULL, 0x00000010ff557819ULL, 0x000fc4000001165aULL,
0x00000018ff6e7819ULL, 0x000fe40000011643ULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000010ff407819ULL, 0x020fe40000011656ULL, 0x00000010ff417819ULL, 0x000fe20000011657ULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x000010544b407816ULL, 0x000fe40000000040ULL,
0x0000ffff424b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff427819ULL, 0x000fe40000011654ULL,
0x00000010ff547819ULL, 0x000fe4000001164aULL, 0x0000ffff434a7812ULL, 0x000fe400078ec0ffULL,
0x0000105459427816ULL, 0x000fe40000000042ULL, 0x0000105455437816ULL, 0x000fe40000000054ULL,
0x00000008ff4b7819ULL, 0x000fc4000001164bULL, 0x00000008ff4a7819ULL, 0x000fe4000001164aULL,
0x0000105458417816ULL, 0x000fe20000000041ULL, 0x000000421820723cULL, 0x040be20000041820ULL,
0x000000ff3d6a7812ULL, 0x002fe400078ec0ffULL, 0x00000010ff587819ULL, 0x104fe40000011638ULL,
0x000000ff38687812ULL, 0x040fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe20000011638ULL,
0x00000040181c723cULL, 0x000f64000004181cULL, 0x0000ffff38437812ULL, 0x020fc400078ec0ffULL,
0x00000010ff577819ULL, 0x100fe40000011639ULL, 0x000000ff39697812ULL, 0x040fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011639ULL, 0x0000ffff39427812ULL, 0x000fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe4000001163dULL, 0x0000006eff6e723eULL, 0x000fc400020006ffULL,
0x0000004bff38723eULL, 0x000fe400020006ffULL, 0x0000004aff39723eULL, 0x000fe200020006ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fe2000001163cULL,
0x20000038ff387230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x100fe2000001163aULL,
0x20000039ff397230ULL, 0x000fe20000004100ULL, 0x000000ff3a5e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fc4000001163aULL, 0x0000ffff3a597812ULL, 0x000fe400078ec0ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x00000065ff3a723eULL, 0x000fe400020006ffULL,
0x000000ff55557812ULL, 0x000fe200078ec0ffULL, 0x2000006aff657230ULL, 0x000fe20000004100ULL,
0x000000ff3c567812ULL, 0x000fe200078ec0ffULL, 0x2000003aff6a7230ULL, 0x000fe20000004100ULL,
0x00000018ff6b7819ULL, 0x000fc4000001163eULL, 0x00000010ff617819ULL, 0x000fe4000001163dULL,
0x0000ffff3c607812ULL, 0x000fe400078ec0ffULL, 0x00000055ff3a723eULL, 0x000fe400020006ffULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff387819ULL, 0x000fe40000011638ULL,
0x00000010ff6e7819ULL, 0x000fc4000001166eULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000056ff4b723eULL, 0x000fe400020006ffULL, 0x0000006bff56723eULL, 0x000fe400020006ffULL,
0x000000ff616b7812ULL, 0x000fe200078ec0ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x000010546f387816ULL, 0x000fe20000000038ULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x000010546e397816ULL, 0x000fc40000000039ULL, 0x00000008ff617819ULL, 0x000fe20000011660ULL,
0x2000003aff607230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fe2000001163bULL,
0x00000010463a7824ULL, 0x000fe200078e0253ULL, 0x000000ff3b5f7812ULL, 0x040fe200078ec0ffULL,
0x000000381824723cULL, 0x000b620000041824ULL, 0x00000018ff5c7819ULL, 0x000fe4000001163bULL,
0x0000ffff3b5b7812ULL, 0x000fe400078ec0ffULL, 0x000000003a38783bULL, 0x020e620000004200ULL,
0x00000018ff407819ULL, 0x000fc4000001163cULL, 0x000000ff3e6c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f6d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3d627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3c7819ULL, 0x000fe4000001163eULL, 0x00000010ff3d7819ULL, 0x000fe4000001163fULL,
0x00000040ff40723eULL, 0x000fc400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000040ff4a7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x2000006cff407230ULL, 0x000fe20000004100ULL,
0x00000008ff627819ULL, 0x000fe20000011662ULL, 0x2000006dff557230ULL, 0x000fe20000004100ULL,
0x000000ff3c3c7812ULL, 0x000fe200078ec0ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x000000ff3d3d7812ULL, 0x000fc400078ec0ffULL, 0x00000062ff6c723eULL, 0x000fe400020006ffULL,
0x0000003cff6d723eULL, 0x000fe400020006ffULL, 0x0000003dff6e723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000010ff3c7819ULL, 0x000fe2000001164bULL,
0x2000006cff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x000fe20000011660ULL,
0x20000061ff627230ULL, 0x000fe20000004100ULL, 0x0000ffff3e3e7812ULL, 0x000fe200078ec0ffULL,
0x2000006eff607230ULL, 0x000fe20000004100ULL, 0x000010543d3c7816ULL, 0x000fc4000000003cULL,
0x00000010ff3d7819ULL, 0x000fe40000011665ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166bULL,
0x00000008ff3e7819ULL, 0x000fe4000001163eULL, 0x000010546c3d7816ULL, 0x000fe4000000003dULL,
0x00000010ff657819ULL, 0x000fe4000001164aULL, 0x00000010ff6a7819ULL, 0x000fc4000001166aULL,
0x00000010ff4a7819ULL, 0x000fe20000011662ULL, 0x0000003c1828723cULL, 0x000b620000041828ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x0000003eff61723eULL, 0x000fe200020006ffULL,
0x2000006dff3e7230ULL, 0x000fe20000004100ULL, 0x00001054654a7816ULL, 0x000fe4000000004aULL,
0x000010546a4b7816ULL, 0x000fe2000000004bULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000018ff417819ULL, 0x000fc4000001163fULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3c7819ULL, 0x020fe20000011640ULL, 0x0000004a182c723cULL, 0x000b62000004182cULL,
0x00000010ff3d7819ULL, 0x000fe4000001163eULL, 0x00000010ff407819ULL, 0x000fe40000011655ULL,
0x00000010ff657819ULL, 0x000fe40000011660ULL, 0x00000008ff3f7819ULL, 0x000fc4000001163fULL,
0x00000010ff3e7819ULL, 0x000fe40000011661ULL, 0x000010543d3c7816ULL, 0x000fe4000000003cULL,
0x00001054653d7816ULL, 0x000fe40000000040ULL, 0x00000010ff4b7819ULL, 0x122fe40000011639ULL,
0x000000ff39707812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fc40000011639ULL,
0x0000ffff39617812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4a7819ULL, 0x100fe40000011638ULL,
0x000000ff386f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe40000011638ULL,
0x0000ffff38657812ULL, 0x000fe400078ec0ffULL, 0x0000005cff39723eULL, 0x000fc400020006ffULL,
0x000000ff58387812ULL, 0x000fe400078ec0ffULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000039ff587230ULL, 0x000fe20000004100ULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x00000010ff557819ULL, 0x000fe20000011656ULL, 0x20000041ff397230ULL, 0x000fe20000004100ULL,
0x00000038ff38723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x000000ff54547812ULL, 0x000fc400078ec0ffULL, 0x00001054553e7816ULL, 0x000fe4000000003eULL,
0x00000010ff627819ULL, 0x100fe4000001163aULL, 0x000000ff3a6d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001163aULL, 0x0000ffff3a567812ULL, 0x000fe400078ec0ffULL,
0x00000010ff557819ULL, 0x000fc4000001163bULL, 0x000000ff3b6e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001163bULL, 0x0000ffff3b407812ULL, 0x000fe400078ec0ffULL,
0x00000054ff41723eULL, 0x000fe200020006ffULL, 0x20000038ff547230ULL, 0x000fe20000004100ULL,
0x0000005eff3b723eULL, 0x000fe400020006ffULL, 0x0000005dff3a723eULL, 0x000fc400020006ffULL,
0x00000010ff387819ULL, 0x000fe20000011639ULL, 0x2000003bff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x000000ff575c7812ULL, 0x000fe200078ec0ffULL,
0x2000003aff577230ULL, 0x000fe20000004100ULL, 0x00001054383f7816ULL, 0x000fe4000000003fULL,
0x0000003c1838723cULL, 0x000b620000041830ULL, 0x00000008ff737819ULL, 0x000fe20000011643ULL,
0x009800004930783bULL, 0x020e620000000200ULL, 0x00000008ff747819ULL, 0x000fc40000011642ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x0000003e1818723cULL, 0x000b620000041834ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000005fff5e723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000000ff5a427812ULL, 0x000fe200078ec0ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000008ff5f7819ULL, 0x000fe20000011659ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fc4000001165bULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x020fe40000011673ULL, 0x00000010ff357819ULL, 0x000fe40000011674ULL,
0x00000069ff69723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000105463347816ULL, 0x000fe20000000034ULL,
0x0000000330308231ULL, 0x082fe200003400ffULL, 0x0000105464357816ULL, 0x000fe20000000035ULL,
0x0000000332328231ULL, 0x000fe200003400ffULL, 0x0000006fff59723eULL, 0x000fe200020006ffULL,
0x0000000231318231ULL, 0x080fe200003400ffULL, 0x00000070ff5a723eULL, 0x000fe200020006ffULL,
0x0000000233338231ULL, 0x000fe200003400ffULL, 0x20000041ff6f7230ULL, 0x000fe20000004100ULL,
0x00000060ff43723eULL, 0x000fe200020006ffULL, 0x20000042ff707230ULL, 0x000fe20000004100ULL,
0x0000006aff3c723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff4b6a7812ULL, 0x000fe200078ec0ffULL, 0x2000005bff607230ULL, 0x000fe20000004100ULL,
0x000000ff4a5b7812ULL, 0x000fe200078ec0ffULL, 0x00000034301c723cULL, 0x000b62000004181cULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe20000011668ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff4b7819ULL, 0x000fe20000011654ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fc40000011669ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff367819ULL, 0x000fe4000001165dULL, 0x00000010ff377819ULL, 0x000fe4000001165eULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff577819ULL, 0x000fc40000011657ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff347819ULL, 0x020fe4000001165fULL, 0x00000010ff357819ULL, 0x000fe40000011660ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x000010544b4a7816ULL, 0x000fe2000000004aULL,
0x2000006cff497230ULL, 0x000fe20000004100ULL, 0x00000061ff3f723eULL, 0x000fe200020006ffULL,
0x20000065ff547230ULL, 0x000fe20000004100ULL, 0x000010545c4b7816ULL, 0x000fe20000000069ULL,
0x2000006aff5c7230ULL, 0x000fe20000004100ULL, 0x000010546f367816ULL, 0x000fe20000000036ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x0000105470377816ULL, 0x000fe40000000037ULL,
0x0000105457347816ULL, 0x000fe20000000034ULL, 0x0000004a3014723cULL, 0x000b620000041814ULL,
0x0000105458357816ULL, 0x000fc40000000035ULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x000000ff55557812ULL, 0x000fe400078ec0ffULL, 0x00000008ff567819ULL, 0x000fe20000011656ULL,
0x000000363020723cULL, 0x000b620000041820ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000008ff4b7819ULL, 0x020fc40000011640ULL,
0x00000010ff367819ULL, 0x000fe20000011659ULL, 0x000000343024723cULL, 0x000b620000041824ULL,
0x00000010ff377819ULL, 0x000fe4000001165aULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff407819ULL, 0x000fe40000011649ULL, 0x00000010ff347819ULL, 0x020fe40000011654ULL,
0x00000010ff357819ULL, 0x000fc4000001163fULL, 0x0000006dff42723eULL, 0x000fe400020006ffULL,
0x00000062ff3e723eULL, 0x000fe400020006ffULL, 0x0000006eff41723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000056ff4a723eULL, 0x000fe200020006ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x0000006bff3d723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x000010545b367816ULL, 0x000fe20000000036ULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x000010545c377816ULL, 0x000fe20000000037ULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fc400020006ffULL,
0x0000105443347816ULL, 0x000fe40000000034ULL, 0x0000105440357816ULL, 0x000fe20000000035ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x000000363028723cULL, 0x000b620000041828ULL,
0x00000010ff417819ULL, 0x000fc60000011641ULL, 0x00000010ff4b7819ULL, 0x000fc6000001164bULL,
0x00000010ff367819ULL, 0x020fe20000011642ULL, 0x00000034302c723cULL, 0x000b62000004182cULL,
0x00000010ff377819ULL, 0x000fe4000001163eULL, 0x00000010ff3e7819ULL, 0x000fe40000011655ULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x00000010ff357819ULL, 0x020fe4000001163cULL,
0x00000010ff347819ULL, 0x000fc4000001164aULL, 0x00000010ff3c7819ULL, 0x000fe4000001163dULL,
0x000010543e377816ULL, 0x000fe40000000041ULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010543c357816ULL, 0x000fc6000000004bULL, 0x000000363038723cULL, 0x040f700000041838ULL,
0x000000343030723cULL, 0x000b6e0000041818ULL, 0xfffffff8111a7812ULL, 0x020fc400078ec0ffULL,
0x0000f6c84d187811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000000018187f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f690001aff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff117224ULL, 0x000fc600078e00ffULL,
0x00000000001a7805ULL, 0x004fc80000015200ULL, 0x0000040006357984ULL, 0x000ea40000000800ULL,
0x8000000035ff7812ULL, 0x006fe40007804819ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x000000341a377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e1bULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040006357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c044197810ULL, 0x000fca0007ffe0ffULL, 0x0000660050377a24ULL, 0x000fe200078e0219ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x000000190a117217ULL, 0x000fe20007800000ULL,
0x000000104f1a7824ULL, 0x000fe200078e00ffULL, 0x00000003ff187819ULL, 0x000fc6000001160bULL,
0x0000000111117824ULL, 0x000fe200078e0a19ULL, 0x00000004181b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011a347824ULL, 0x000fe200078e0218ULL, 0x0000000818357810ULL, 0x000fe40007ffe0ffULL,
0x000000111a117217ULL, 0x000fe20007800000ULL, 0x0000000134197824ULL, 0x040fe400078e020bULL,
0x00000008343c7824ULL, 0x000fe400078e00ffULL, 0x0000000111117824ULL, 0x000fc400078e0a1aULL,
0x000000011a367824ULL, 0x000fe200078e021bULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee219ULL,
0x000000011a407824ULL, 0x000fe200078e0235ULL, 0x000000111b00720cULL, 0x080fe20003f66070ULL,
0x0000000136197824ULL, 0x000fe200078e020bULL, 0x000000111800720cULL, 0x080fe20003f86070ULL,
0x00000008363e7824ULL, 0x000fe200078e00ffULL, 0x0000000c181b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000134187824ULL, 0x100fe200078e0237ULL, 0x000000113500720cULL, 0x080fe20003f46070ULL,
0x0000000136347824ULL, 0x000fe200078e0237ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee219ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000111b00720cULL, 0x000fc60003f06070ULL,
0x000000011a427824ULL, 0x000fe200078e021bULL, 0x0000004e18187212ULL, 0x000fe200078efcffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0x0000620018187a10ULL, 0x000fe20007fbe0ffULL,
0x0000000140367824ULL, 0x000fe200078e0237ULL, 0x0000004e34347212ULL, 0x000fe200078efcffULL,
0x0000000140117824ULL, 0x040fe200078e020bULL, 0x0000630019197a10ULL, 0x000fe20002ffe4ffULL,
0x0000000840407824ULL, 0x000fe200078e00ffULL, 0x0000620034347a10ULL, 0x000fe20007fbe0ffULL,
0x00000001421a7824ULL, 0x000fe400078e0237ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fc400078ee211ULL, 0x0000630035357a10ULL, 0x000fe20002ffe4ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000004e36367212ULL, 0x000fc600078efcffULL,
0x0000000142117824ULL, 0x000fe200078e020bULL, 0x0000004e1a1a7212ULL, 0x000fe200078efcffULL,
0x0000000842427824ULL, 0x000fe200078e00ffULL, 0x0000620036367a10ULL, 0x000fe20007fbe0ffULL,
0x000000103e3d7824ULL, 0x100fe200078e0253ULL, 0x000062001a1a7a10ULL, 0x000fe20007fde0ffULL,
0x00000010403f7824ULL, 0x000fe200078e0253ULL, 0xfffffff842427812ULL, 0x000fe200078ee211ULL,
0x000000103c117824ULL, 0x100fe200078e0253ULL, 0x0000630037377a10ULL, 0x000fe40002ffe4ffULL,
0x000063001b1b7a10ULL, 0x000fe200037fe4ffULL, 0x0000001042417824ULL, 0x000fe200078e0253ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018117faeULL, 0x0003e8000e101c48ULL,
0x00000000343d7faeULL, 0x0003e8000d901c48ULL, 0x00000000363f7faeULL, 0x0003e8000d101c48ULL,
0x000000001a417faeULL, 0x0003e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x000000104f187824ULL, 0x000fca00078e00ffULL, 0x000000180b187211ULL, 0x000fc800078fe8ffULL,
0x0000000818367810ULL, 0x040fe20007ffe0ffULL, 0x00000001181a7824ULL, 0x040fe200078e0237ULL,
0x0000000418347810ULL, 0x040fe20007ffe0ffULL, 0x0000000118117824ULL, 0x140fe200078e020bULL,
0x0000000c18427810ULL, 0x000fe20007ffe0ffULL, 0x00000001361b7824ULL, 0x140fe400078e020bULL,
0x0000000836407824ULL, 0x000fe400078e00ffULL, 0x0000000134197824ULL, 0x040fe400078e020bULL,
0x00000008343e7824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee21bULL,
0x0000000134347824ULL, 0x000fc400078e0237ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fc600078ee219ULL, 0x00000008183c7824ULL, 0x000fe200078e00ffULL,
0x0000004e1a1a7212ULL, 0x000fe200078efcffULL, 0x0000000136367824ULL, 0x100fe400078e0237ULL,
0x0000000142187824ULL, 0x000fe200078e0237ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000062001a1a7a10ULL, 0x000fc60007f1e0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004e34347212ULL, 0x080fe400078efcffULL,
0x000063001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000004e36367212ULL, 0x080fe400078efcffULL, 0x0000620034347a10ULL, 0x000fe20007f5e0ffULL,
0x0000000142117824ULL, 0x000fe200078e020bULL, 0x0000004e18187212ULL, 0x000fe200078efcffULL,
0x0000000842427824ULL, 0x000fe200078e00ffULL, 0x0000620036367a10ULL, 0x000fe20007f1e0ffULL,
0x000000103e3d7824ULL, 0x100fe200078e0253ULL, 0x0000620018187a10ULL, 0x000fe20007f7e0ffULL,
0x00000010403f7824ULL, 0x000fe200078e0253ULL, 0xfffffff842427812ULL, 0x000fe200078ee211ULL,
0x000000103c117824ULL, 0x000fe200078e0253ULL, 0x0000630035357a10ULL, 0x000fc400017fe4ffULL,
0x0000630037377a10ULL, 0x000fe200007fe4ffULL, 0x0000001042417824ULL, 0x000fe200078e0253ULL,
0x0000630019197a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a117faeULL, 0x0003e8000b901c48ULL, 0x00000000343d7faeULL, 0x0003e8000b901c48ULL,
0x00000000363f7faeULL, 0x0003e8000b901c48ULL, 0x0000000018417faeULL, 0x0003e4000b901c48ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0xfffffff0081a7812ULL, 0x000fce00078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b0001a1a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480005187f8cULL, 0x0004e4000c80043fULL, 0x0000000000347805ULL, 0x000fc40000015200ULL,
0xffffffe008057812ULL, 0x044fe400078ec0ffULL, 0x0000001008367812ULL, 0x040fe400078ec0ffULL,
0x0000000808117812ULL, 0x000fc800078ec0ffULL, 0x0000000511057210ULL, 0x000fca0007ffe036ULL,
0x00f64c0005117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x00cfe40007804819ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634367210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff117819ULL, 0x000fc80000011437ULL,
0x0000003611117211ULL, 0x000fca00078110ffULL, 0x000000ffff367224ULL, 0x000fca00000e0637ULL,
0x0000000211117819ULL, 0x000fc80000001236ULL, 0x000000110000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c0005117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x004fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000200c057824ULL, 0x000fca00078e00ffULL, 0xffffff8005057812ULL, 0x000fc800078ec0ffULL,
0x000001004e187810ULL, 0x000fca0007ffe005ULL, 0x0000000167187824ULL, 0x000fca00078e0218ULL,
0x00f0000018347984ULL, 0x000ea80000000800ULL, 0x00f2000018357984ULL, 0x0006620000000800ULL,
0x0000000d3400720bULL, 0x004fe20003f1d000ULL, 0x0000c7c27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000117806ULL, 0x008fc800000e0100ULL, 0x0000ffff11367812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff117424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fd200078e000dULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000266057810ULL, 0x000fe40007ffe0ffULL, 0x0000000d3400720bULL, 0x000fe40003f54000ULL,
0x0000000c0500720cULL, 0x000fe20003f05270ULL, 0x0000c7627f007947ULL, 0x000fd4000b800000ULL,
0x0000000000057806ULL, 0x000fc400010e0100ULL, 0x000000800c188824ULL, 0x000fe200078e024eULL,
0x0000000d34118209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001673c8824ULL, 0x000fe200078e0218ULL, 0x0000991005187816ULL, 0x000fc800000000ffULL,
0x00f400113c008388ULL, 0x0005e20000000800ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000d34187209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff05ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000d18117221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x0000001100377308ULL, 0x000ea40000000800ULL, 0x000000370e0e7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fe2000001160bULL,
0x0000c6827f007947ULL, 0x000fea000b800000ULL, 0x00001f1137117589ULL, 0x0004e400000e0000ULL,
0x0000001114147220ULL, 0x08cfe20000410000ULL, 0x0000001115157220ULL, 0x080fe20000410000ULL,
0x000000111c1c7220ULL, 0x080fe20000410000ULL, 0x000000111d1d7220ULL, 0x080fe20000410000ULL,
0x0000001120207220ULL, 0x080fe20000410000ULL, 0x0000001121217220ULL, 0x080fe20000410000ULL,
0x0000001124247220ULL, 0x080fe20000410000ULL, 0x0000001125257220ULL, 0x080fe20000410000ULL,
0x0000001128287220ULL, 0x080fe20000410000ULL, 0x0000001129297220ULL, 0x080fe20000410000ULL,
0x000000112c2c7220ULL, 0x080fe20000410000ULL, 0x000000112d2d7220ULL, 0x080fe20000410000ULL,
0x0000001138387220ULL, 0x080fe20000410000ULL, 0x0000001139397220ULL, 0x080fe20000410000ULL,
0x0000001130307220ULL, 0x080fe20000410000ULL, 0x0000001131317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0005ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080b117811ULL, 0x000fe200078ff0ffULL,
0x0000c5627f007947ULL, 0x000fea000b800000ULL, 0x00001f1137117589ULL, 0x0004e400000e0000ULL,
0x0000001116167220ULL, 0x08cfe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x000000111e1e7220ULL, 0x080fe20000410000ULL, 0x000000111f1f7220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x0000001126267220ULL, 0x080fe20000410000ULL, 0x0000001127277220ULL, 0x080fe20000410000ULL,
0x000000112a2a7220ULL, 0x080fe20000410000ULL, 0x000000112b2b7220ULL, 0x080fe20000410000ULL,
0x000000112e2e7220ULL, 0x080fe20000410000ULL, 0x000000112f2f7220ULL, 0x080fe20000410000ULL,
0x000000113a3a7220ULL, 0x080fe20000410000ULL, 0x000000113b3b7220ULL, 0x080fe20000410000ULL,
0x0000001132327220ULL, 0x080fe20000410000ULL, 0x0000001133337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff36ff7812ULL, 0x000fe20007806005ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000000d34057209ULL, 0x000fd60007810000ULL,
0x8000000534340221ULL, 0x000fe20000010000ULL, 0x00007610ff110816ULL, 0x000fc60000000011ULL,
0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL, 0x0000003400040308ULL, 0x000ea40000000800ULL,
0x0000000435350220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000e350e7221ULL, 0x002fc20000010000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0xfffffff008377812ULL, 0x000fca00078ec0ffULL, 0x00f6ac00370d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003418347210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e19ULL,
0x003d09003400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011435ULL, 0x000000340d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff347224ULL, 0x000fca00000e0635ULL, 0x000000020d0d7819ULL, 0x000fc80000001234ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac00370d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910110d7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000004ff02723eULL, 0x000fe400000010ffULL,
0x00000002ff127819ULL, 0x000fe4000001160bULL, 0x00005410020d7816ULL, 0x000fe20000000002ULL,
0x0000c1227f007947ULL, 0x000fea000b800000ULL, 0x00001f120d037589ULL, 0x0002a400000e0000ULL,
0x0000000812117810ULL, 0x000fe20007ffe0ffULL, 0x0000c1527f007947ULL, 0x000fea000b800000ULL,
0x00001f110d027589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001012117810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e000dULL,
0x0000894000197802ULL, 0x000fc40000000f00ULL, 0x0000c7a000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001812117810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e000dULL, 0x0000899000197802ULL, 0x000fc40000000f00ULL,
0x0000c75000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001047347824ULL, 0x100fe200078e0252ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000010463c7824ULL, 0x000fe200078e0252ULL, 0x000000080b127812ULL, 0x002fc400078ec0ffULL,
0x000000070b187812ULL, 0x000fe200078ec0ffULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x0000000712597812ULL, 0x100fe400078ef80bULL, 0x0000000818437812ULL, 0x000fe200078ef80bULL,
0x000000003c3c783bULL, 0x000f220000004200ULL, 0x000000020f0d7810ULL, 0x008fe20007ffe0ffULL,
0x0000000159107824ULL, 0x000fe200078e0210ULL, 0x00000010ff477819ULL, 0x002fe40000011634ULL,
0x000000ff34587812ULL, 0x000fc400078ec0ffULL, 0x00000018ff137819ULL, 0x000fe40000011634ULL,
0x0000ffff345c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x100fe40000011635ULL,
0x000000ff355d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011635ULL,
0x0000ffff355f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff347819ULL, 0x100fe40000011636ULL,
0x000000ff36617812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011636ULL,
0x0000ffff36427812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x000fe40000011637ULL,
0x000000ff37557812ULL, 0x000fc400078ec0ffULL, 0x00000018ff367819ULL, 0x000fe40000011637ULL,
0x0000ffff375a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3c377812ULL, 0x010fe400078ec0ffULL,
0x000000ff3d577812ULL, 0x000fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe4000001163cULL,
0x00000010ff197819ULL, 0x000fc4000001163dULL, 0x00000018ff497819ULL, 0x000fe4000001163dULL,
0x0000ffff3d117812ULL, 0x004fe200078ec0ffULL, 0x00000008593d7824ULL, 0x000fe200078e00ffULL,
0x000000ff3e4b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001163eULL,
0x00000036ff36723eULL, 0x000fe400020006ffULL, 0x00000037ff37723eULL, 0x000fc400020006ffULL,
0x00000010ff127819ULL, 0x000fe4000001163eULL, 0x0000ffff3e567812ULL, 0x000fe400078ec0ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000010ff3e7819ULL, 0x100fe4000001163fULL,
0x000000ff3f547812ULL, 0x000fe400078ec0ffULL, 0x00000018ff607819ULL, 0x000fc4000001163fULL,
0x0000ffff3f597812ULL, 0x000fe400078ec0ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x00000010ff417819ULL, 0x000fe4000001163cULL,
0x0000ffff3c187812ULL, 0x000fe200078ec0ffULL, 0x00000008433c7824ULL, 0x000fe200078e00ffULL,
0x00000040ff3f723eULL, 0x000fe200020006ffULL, 0x20000036ff407230ULL, 0x000fe20000004100ULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x20000037ff367230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x20000057ff377230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x20000046ff577230ULL, 0x000fe20000004100ULL,
0xfffffff83d437812ULL, 0x000fe200078ee210ULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x0000005bff10723eULL, 0x000fe200020006ffULL, 0x20000058ff5b7230ULL, 0x000fe20000004100ULL,
0x00000055ff3d723eULL, 0x000fe200020006ffULL, 0x20000049ff587230ULL, 0x000fe20000004100ULL,
0x00000054ff55723eULL, 0x000fe200020006ffULL, 0x2000004bff547230ULL, 0x000fe20000004100ULL,
0x00000008ff5f7819ULL, 0x000fe2000001165fULL, 0x2000004aff467230ULL, 0x000fe20000004100ULL,
0x000000ff34347812ULL, 0x000fe200078ec0ffULL, 0x00a000004848783bULL, 0x000e620000000200ULL,
0x000000ff47477812ULL, 0x000fe200078ec0ffULL, 0x20000010ff107230ULL, 0x000fe20000004100ULL,
0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x000000ff35357812ULL, 0x000fe200078ec0ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000034ff34723eULL, 0x000fe400020006ffULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0xfffffff83c0d7812ULL, 0x000fc400078ee20dULL,
0x00000047ff62723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0x000000ff41417812ULL, 0x000fe200078ec0ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000061ff3c723eULL, 0x000fe200020006ffULL,
0x2000005fff617230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x20000034ff5f7230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x2000005eff637230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe200020006ffULL,
0x20000060ff477230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x2000005cff607230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000035ff5e7230ULL, 0x000fe20000004100ULL, 0x00000041ff34723eULL, 0x000fe200020006ffULL,
0x20000042ff417230ULL, 0x000fe20000004100ULL, 0x00000013ff13723eULL, 0x000fe200020006ffULL,
0x2000005aff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff19197812ULL, 0x000fe200078ec0ffULL,
0x20000034ff427230ULL, 0x000fe20000004100ULL, 0x00000008ff187819ULL, 0x000fe20000011618ULL,
0x20000013ff137230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe2000001165dULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000019ff64723eULL, 0x000fe200020006ffULL,
0x0000000348488231ULL, 0x082fe200003400ffULL, 0x00000018ff5a723eULL, 0x000fe200020006ffULL,
0x000000034a4a8231ULL, 0x000fe200003400ffULL, 0x00000008ff5d7819ULL, 0x000fe20000011611ULL,
0x0000000249498231ULL, 0x080fe200003400ffULL, 0x00000010ff347819ULL, 0x000fe2000001165bULL,
0x000000024b4b8231ULL, 0x000fe200003400ffULL, 0x00000010ff197819ULL, 0x000fe20000011662ULL,
0x20000064ff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x000fe20000011663ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x0000a00045117810ULL, 0x000fc40007ffe00dULL,
0x0000105419347816ULL, 0x000fe40000000034ULL, 0x0000105418357816ULL, 0x000fe40000000035ULL,
0x000000ff12637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff197819ULL, 0x000fe40000011613ULL,
0x00000010ff627819ULL, 0x000fe20000011610ULL, 0x000000344828723cULL, 0x000b620000041828ULL,
0x00000010ff187819ULL, 0x000fe20000011660ULL, 0x000000001110783bULL, 0x000e620000000200ULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x0000105419187816ULL, 0x000fe40000000018ULL,
0x0000105462197816ULL, 0x000fe20000000061ULL, 0x0000001043347824ULL, 0x020fe200078e0252ULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x00000018482c723cULL, 0x000b62000004182cULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x000010545f3c7816ULL, 0x000fe4000000003cULL,
0x000010545e3d7816ULL, 0x000fe4000000003dULL, 0x00000010ff187819ULL, 0x020fe40000011640ULL,
0x00000010ff407819ULL, 0x000fe40000011641ULL, 0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3f7819ULL, 0x000fc4000001163fULL, 0x00000010ff417819ULL, 0x000fe2000001165cULL,
0x000000104c5c7824ULL, 0x000fe200078e0252ULL, 0x0000003eff35723eULL, 0x000fe400020006ffULL,
0x000010543f407816ULL, 0x000fe40000000040ULL, 0x0000003c483c723cULL, 0x000b620000041838ULL,
0x00000010ff197819ULL, 0x000fe20000011642ULL, 0x000000005c38783bULL, 0x020fe20000004200ULL,
0x0000105418417816ULL, 0x000fe40000000041ULL, 0x00000010ff427819ULL, 0x000fe2000001165bULL,
0x20000035ff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x000fe20000011636ULL,
0x0000000310108231ULL, 0x082fe200003400ffULL, 0x00000010ff437819ULL, 0x000fe20000011637ULL,
0x0000000312128231ULL, 0x000fe200003400ffULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x0000000211118231ULL, 0x080fe200003400ffULL,
0x00000063ff45723eULL, 0x000fe200020006ffULL, 0x0000000213138231ULL, 0x000fe200003400ffULL,
0x0000105419187816ULL, 0x000fe20000000018ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000008ff567819ULL, 0x000fe20000011656ULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x0000105442197816ULL, 0x000fc40000000043ULL, 0x00000008ff597819ULL, 0x000fe20000011659ULL,
0x000000404840723cULL, 0x000b620000041830ULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000010ff307819ULL, 0x020fe2000001165aULL, 0x000000181028723cULL, 0x000be20000041828ULL,
0x00000010ff317819ULL, 0x000fe2000001165dULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x0000105457307816ULL, 0x000fe40000000030ULL,
0x0000105458317816ULL, 0x000fe20000000031ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff327819ULL, 0x000fe40000011654ULL, 0x00000010ff337819ULL, 0x000fe40000011655ULL,
0x00000010ff457819ULL, 0x000fe20000011645ULL, 0x00000030102c723cULL, 0x000be4000004182cULL,
0x00000010ff187819ULL, 0x020fc4000001165bULL, 0x0000105445327816ULL, 0x000fe40000000032ULL,
0x0000105418337816ULL, 0x000fe40000000033ULL, 0x00000010ff197819ULL, 0x000fe40000011646ULL,
0x00000010ff187819ULL, 0x000fe40000011656ULL, 0x00000010ff307819ULL, 0x000fe40000011647ULL,
0x00000010ff597819ULL, 0x000fc40000011659ULL, 0x0000105419187816ULL, 0x000fe40000000018ULL,
0x0000105430197816ULL, 0x000fe40000000059ULL, 0x000000321030723cULL, 0x000be2000004183cULL,
0x00000010ff5a7819ULL, 0x102fe40000011634ULL, 0x000000ff34457812ULL, 0x000fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe40000011634ULL, 0x000000ff393d7812ULL, 0x020fc400078ec0ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001163bULL, 0x000000ff383c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff345c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x100fe40000011635ULL,
0x000000ff35697812ULL, 0x000fe400078ec0ffULL, 0x00000018ff657819ULL, 0x000fc40000011635ULL,
0x0000ffff355f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x100fe40000011636ULL,
0x000000ff36647812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe40000011636ULL,
0x0000ffff36597812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x000fc40000011637ULL,
0x000000ff37687812ULL, 0x040fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe40000011637ULL,
0x0000ffff375b7812ULL, 0x000fe400078ec0ffULL, 0x0000003dff54723eULL, 0x000fe200020006ffULL,
0x000000181034723cULL, 0x000be20000041840ULL, 0x0000003eff3d723eULL, 0x000fe400020006ffULL,
0x00000018ff3e7819ULL, 0x000fe20000011639ULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x0000003cff47723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff197819ULL, 0x020fc40000011638ULL, 0x00000010ff407819ULL, 0x000fe20000011639ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x0000ffff39397812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fe40000011638ULL, 0x000000ff3a427812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b437812ULL, 0x000fe400078ec0ffULL, 0x000000ff19197812ULL, 0x000fc400078ec0ffULL,
0x00000010ff187819ULL, 0x100fe4000001163aULL, 0x00000018ff3f7819ULL, 0x000fe4000001163aULL,
0x0000ffff3a587812ULL, 0x000fe400078ec0ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x00000008ff397819ULL, 0x000fe40000011639ULL, 0x0000003cff3c723eULL, 0x000fc400020006ffULL,
0x00000042ff3a723eULL, 0x000fe400020006ffULL, 0x0000ffff38387812ULL, 0x000fe200078ec0ffULL,
0x2000003cff427230ULL, 0x000fe20000004100ULL, 0x00000010ff577819ULL, 0x000fe4000001163bULL,
0x0000ffff3b417812ULL, 0x000fe400078ec0ffULL, 0x00000043ff3b723eULL, 0x000fe200020006ffULL,
0x2000003eff437230ULL, 0x000fe20000004100ULL, 0x00000019ff19723eULL, 0x000fe200020006ffULL,
0x2000003aff3e7230ULL, 0x000fe20000004100ULL, 0x00000039ff39723eULL, 0x000fc400020006ffULL,
0x00000008ff387819ULL, 0x000fe20000011638ULL, 0x20000019ff557230ULL, 0x000fe20000004100ULL,
0x0000003fff3c723eULL, 0x000fe200020006ffULL, 0x2000003bff3f7230ULL, 0x000fe20000004100ULL,
0x000000ff5a3a7812ULL, 0x000fe200078ec0ffULL, 0x20000039ff467230ULL, 0x000fe20000004100ULL,
0x000000ff40407812ULL, 0x000fe200078ec0ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff18197812ULL, 0x000fc400078ec0ffULL,
0x00000062ff3b723eULL, 0x000fe400020006ffULL, 0x00000038ff18723eULL, 0x000fe400020006ffULL,
0x00000069ff39723eULL, 0x000fe200020006ffULL, 0x2000003bff5a7230ULL, 0x000fe20000004100ULL,
0x00000008ff5f7819ULL, 0x000fe4000001165fULL, 0x00000045ff38723eULL, 0x000fe200020006ffULL,
0x20000039ff397230ULL, 0x000fe20000004100ULL, 0x0000003aff3a723eULL, 0x000fe200020006ffULL,
0x20000018ff457230ULL, 0x000fe20000004100ULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x20000038ff387230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x2000003aff3a7230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x20000040ff567230ULL, 0x000fe20000004100ULL, 0x00000019ff19723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff3b7819ULL, 0x000fe2000001165cULL, 0x20000061ff5c7230ULL, 0x000fe20000004100ULL,
0x00000065ff18723eULL, 0x000fe200020006ffULL, 0x20000019ff407230ULL, 0x000fe20000004100ULL,
0x000000ff60617812ULL, 0x000fe200078ec0ffULL, 0x2000005fff607230ULL, 0x000fe20000004100ULL,
0x00000063ff19723eULL, 0x000fe200020006ffULL, 0x20000018ff187230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x00000010ff5f7819ULL, 0x000fe20000011639ULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fe20000011638ULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe4000001163aULL,
0x00000010ff3a7819ULL, 0x000fe4000001165eULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x000010543a397816ULL, 0x000fc4000000005fULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3a7819ULL, 0x000fe40000011659ULL, 0x00000008ff5f7819ULL, 0x000fe4000001165bULL,
0x00000010ff597819ULL, 0x000fe40000011618ULL, 0x00000010ff197819ULL, 0x000fe40000011619ULL,
0x00000010ff187819ULL, 0x000fc4000001163bULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000064ff63723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x2000005dff5e7230ULL, 0x000fe20000004100ULL,
0x0000003aff5b723eULL, 0x000fe200020006ffULL, 0x20000068ff627230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000061ff5d7230ULL, 0x000fe20000004100ULL,
0x0000105419187816ULL, 0x000fe20000000018ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000105459197816ULL, 0x000fe20000000060ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000384838723cULL, 0x000b620000041814ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff147819ULL, 0x020fe20000011663ULL, 0x00000018481c723cULL, 0x000b62000004181cULL,
0x00000010ff157819ULL, 0x000fe4000001165eULL, 0x00000010ff177819ULL, 0x000fe4000001165aULL,
0x0000105415147816ULL, 0x000fc40000000014ULL, 0x00000010ff187819ULL, 0x020fe4000001165bULL,
0x00000010ff197819ULL, 0x000fe4000001165fULL, 0x000010545d157816ULL, 0x000fe40000000062ULL,
0x0000105417187816ULL, 0x000fe40000000018ULL, 0x000010545c197816ULL, 0x000fe40000000019ULL,
0x000000ff57577812ULL, 0x000fe200078ec0ffULL, 0x000000144814723cULL, 0x000b620000041820ULL,
0x00000008ff587819ULL, 0x000fc40000011658ULL, 0x00000008ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x00000010ff207819ULL, 0x020fe20000011647ULL,
0x000000184824723cULL, 0x000b620000041824ULL, 0x00000010ff217819ULL, 0x000fe40000011654ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff437819ULL, 0x000fc40000011643ULL,
0x00000010ff197819ULL, 0x020fe40000011642ULL, 0x00000010ff187819ULL, 0x000fe40000011645ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000105455207816ULL, 0x000fe20000000020ULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x0000105456217816ULL, 0x000fe20000000021ULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x0000105419187816ULL, 0x000fc40000000018ULL,
0x0000105443197816ULL, 0x000fe40000000046ULL, 0x00000010ff3f7819ULL, 0x000fe2000001163fULL,
0x000000201020723cULL, 0x000b620000041838ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff417819ULL, 0x000fc80000011641ULL, 0x00000010ff387819ULL, 0x020fe2000001163eULL,
0x00000018101c723cULL, 0x000b62000004181cULL, 0x00000010ff397819ULL, 0x000fe40000011640ULL,
0x00000010ff3a7819ULL, 0x000fe40000011657ULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x00000010ff197819ULL, 0x020fe4000001163cULL, 0x00000010ff187819ULL, 0x000fc4000001163dULL,
0x000010543a397816ULL, 0x000fe4000000003fULL, 0x0000105419587816ULL, 0x000fe40000000058ULL,
0x0000105418597816ULL, 0x000fc60000000041ULL, 0x000000381014723cULL, 0x040f700000041814ULL,
0x000000581024723cULL, 0x000b6e0000041824ULL, 0x0000f69866127811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000006107f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000012ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff387224ULL, 0x000fc600078e00ffULL, 0x0000000000127805ULL, 0x008fc80000015200ULL,
0x0000040006197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x00cfc40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001812397210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e13ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011419ULL, 0x0000003918187211ULL, 0x000fca00078110ffULL,
0x000000ffff197224ULL, 0x000fca00000e0619ULL, 0x0000000218187819ULL, 0x000fc80000001219ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040006197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000107107810ULL, 0x000fc80007ffe0ffULL,
0x000000091000720cULL, 0x000fda0003f06070ULL, 0x0000072000000947ULL, 0x000fea0003800000ULL,
0x0000000207107810ULL, 0x000fe40007ffe0ffULL, 0x0000010044117810ULL, 0x000fe40007ffe0ffULL,
0x000000091000720cULL, 0x000fc60003f06070ULL, 0x0000660050197a24ULL, 0x000fd400078e0211ULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x000000110a107217ULL, 0x000fe20007800000ULL,
0x000000104f137824ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fc6000001160bULL,
0x0000000110107824ULL, 0x000fe200078e0a11ULL, 0x0000000412387810ULL, 0x040fe20007ffe0ffULL,
0x0000000113187824ULL, 0x040fe200078e0212ULL, 0x0000000812397810ULL, 0x000fe40007ffe0ffULL,
0x0000001013107217ULL, 0x000fe20007800000ULL, 0x0000000118117824ULL, 0x000fe200078e020bULL,
0x0000000c123c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008183a7824ULL, 0x000fe400078e00ffULL,
0x0000000110107824ULL, 0x000fc400078e0a13ULL, 0x00000001133e7824ULL, 0x040fe200078e023cULL,
0xfffffff83a3b7812ULL, 0x000fe200078ee211ULL, 0x00000001133a7824ULL, 0x040fe200078e0239ULL,
0x000000103800720cULL, 0x080fe20003f66070ULL, 0x0000000113387824ULL, 0x000fe200078e0238ULL,
0x000000101200720cULL, 0x080fe20003f86070ULL, 0x0000000118127824ULL, 0x000fe200078e0219ULL,
0x000000103900720cULL, 0x080fe20003f46070ULL, 0x0000000138117824ULL, 0x000fe200078e020bULL,
0x000000103c00720cULL, 0x000fe20003f06070ULL, 0x0000000838187824ULL, 0x000fc400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff8183d7812ULL, 0x000fe200078ee211ULL,
0x0000000138107824ULL, 0x100fe200078e0219ULL, 0x0000004e12127212ULL, 0x000fe200078efcffULL,
0x000000013a187824ULL, 0x040fe400078e0219ULL, 0x000000013a397824ULL, 0x000fe200078e020bULL,
0x0000620012127a10ULL, 0x000fe20007fbe0ffULL, 0x000000083a3a7824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000630013137a10ULL, 0x000fc40002ffe4ffULL,
0xfffffff83a3f7812ULL, 0x000fe200078ee239ULL, 0x000000013e387824ULL, 0x000fe200078e0219ULL,
0x0000004e10107212ULL, 0x000fe200078efcffULL, 0x0000008018187825ULL, 0x000fc600078e00ffULL,
0x0000620010107a10ULL, 0x000fe20007fbe0ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000004e18187212ULL, 0x080fe400078efcffULL, 0x0000630011117a10ULL, 0x000fe20002ffe4ffULL,
0x000000013e3a7824ULL, 0x000fe200078e020bULL, 0x0000004e38387212ULL, 0x000fe200078efcffULL,
0x000000083e417824ULL, 0x000fe200078e00ffULL, 0x0000620018187a10ULL, 0x000fe20007fbe0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0252ULL, 0x0000620038387a10ULL, 0x000fe20007fde0ffULL,
0x000000103d3d7824ULL, 0x000fe200078e0252ULL, 0xfffffff841417812ULL, 0x000fe200078ee23aULL,
0x000000103f3f7824ULL, 0x100fe200078e0252ULL, 0x0000630019197a10ULL, 0x000fe20002ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123b7faeULL, 0x0005e2000e101c48ULL,
0x0000630039397a10ULL, 0x000fe200037fe4ffULL, 0x0000001041417824ULL, 0x000fc400078e0252ULL,
0x00000000103d7faeULL, 0x0005e8000d901c48ULL, 0x00000000183f7faeULL, 0x0005e8000d101c48ULL,
0x0000000038417faeULL, 0x0005e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x000000104f107824ULL, 0x000fca00078e00ffULL, 0x000000100b127211ULL, 0x000fc800078fe8ffULL,
0x0000000412387810ULL, 0x040fe20007ffe0ffULL, 0x0000000112107824ULL, 0x140fe200078e020bULL,
0x0000000812187810ULL, 0x040fe20007ffe0ffULL, 0x00000008123b7824ULL, 0x000fe400078e00ffULL,
0x0000000138117824ULL, 0x040fe400078e020bULL, 0x00000008383a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL, 0x0000000112107824ULL, 0x000fe400078e0219ULL,
0x0000000118137824ULL, 0x000fe200078e020bULL, 0xfffffff83a3d7812ULL, 0x000fe200078ee211ULL,
0x00000008183c7824ULL, 0x000fe200078e00ffULL, 0x0000000c123a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000138387824ULL, 0x000fc400078e0219ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff83c3f7812ULL, 0x000fc600078ee213ULL, 0x0000000118187824ULL, 0x100fe200078e0219ULL,
0x0000004e10107212ULL, 0x000fe200078efcffULL, 0x000000013a127824ULL, 0x000fe400078e0219ULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fc60007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004e38387212ULL, 0x080fe400078efcffULL,
0x0000630011117a10ULL, 0x000fe200007fe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004e18187212ULL, 0x080fe400078efcffULL, 0x0000620038387a10ULL, 0x000fe20007f5e0ffULL,
0x000000013a3c7824ULL, 0x000fe200078e020bULL, 0x0000004e12127212ULL, 0x000fe200078efcffULL,
0x000000083a417824ULL, 0x000fe200078e00ffULL, 0x0000620018187a10ULL, 0x000fe20007f1e0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0252ULL, 0x0000620012127a10ULL, 0x000fe20007f7e0ffULL,
0x000000103d3d7824ULL, 0x000fe200078e0252ULL, 0xfffffff841417812ULL, 0x000fe200078ee23cULL,
0x000000103f3f7824ULL, 0x100fe200078e0252ULL, 0x0000630039397a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103b7faeULL, 0x0005e2000b901c48ULL,
0x0000630019197a10ULL, 0x000fe200007fe4ffULL, 0x0000001041417824ULL, 0x000fe200078e0252ULL,
0x0000630013137a10ULL, 0x000fe20001ffe4ffULL, 0x00000000383d7faeULL, 0x0005e8000b901c48ULL,
0x00000000183f7faeULL, 0x0005e8000b901c48ULL, 0x0000000012417faeULL, 0x0005e4000b901c48ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x000000104d117824ULL, 0x000fe200078e00ffULL,
0x00000008083a7812ULL, 0x000fc400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x0000001011117812ULL, 0x000fca00078ee2ffULL, 0x0000002066117824ULL, 0x000fc800078e0211ULL,
0x000000013a3a7824ULL, 0x000fe200078e0211ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff107f8cULL, 0x000ea2000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f668003a127f8cULL, 0x000662000c80043fULL,
0x000000ffff107224ULL, 0x004fc600078e0011ULL, 0x0000000000187805ULL, 0x000fc80000015200ULL,
0x00f66c003a117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x006fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x0000003818387210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e19ULL, 0x003d09003800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff117819ULL, 0x000fc80000011439ULL,
0x0000003811117211ULL, 0x000fca00078110ffULL, 0x000000ffff387224ULL, 0x000fca00000e0639ULL,
0x0000000211117819ULL, 0x000fc80000001238ULL, 0x000000110000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c003a117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018066117811ULL, 0x000fc800078e38ffULL, 0x0000001167117210ULL, 0x000fca0007ffe04eULL,
0x00f0000011387984ULL, 0x000e680000000800ULL, 0x00f2000011137984ULL, 0x0004e20000000800ULL,
0x000000053800720bULL, 0x002fe20003f1d000ULL, 0x00009bc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000117806ULL, 0x004fc800000e0100ULL, 0x0000ffff113a7812ULL, 0x008fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff117424ULL, 0x000fe400078e00ffULL,
0x000000ffff127224ULL, 0x000fd200078e0005ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000366117810ULL, 0x000fe40007ffe0ffULL, 0x000000053800720bULL, 0x000fe40003f54000ULL,
0x0000000c1100720cULL, 0x000fe20003f05270ULL, 0x00009b627f007947ULL, 0x000fd4000b800000ULL,
0x0000000000397806ULL, 0x000fc400010e0100ULL, 0x000000800c4e8824ULL, 0x000fe200078e024eULL,
0x0000000538127209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991039117816ULL, 0x000fe200000000ffULL, 0x0000000167678824ULL, 0x000fca00078e024eULL,
0x00f4001267008388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000512057221ULL, 0x002fe20000010100ULL,
0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b05057820ULL, 0x000fcc0000410000ULL, 0x0000000500057308ULL, 0x000e640000000800ULL,
0x000000050e0e7220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fe2000001160bULL, 0x00009a927f007947ULL, 0x000fea000b800000ULL,
0x00001f1105117589ULL, 0x0002a400000e0000ULL, 0x0000001120207220ULL, 0x084fe20000410000ULL,
0x0000001121217220ULL, 0x080fe20000410000ULL, 0x000000111c1c7220ULL, 0x080fe20000410000ULL,
0x000000111d1d7220ULL, 0x080fe20000410000ULL, 0x0000001114147220ULL, 0x080fe20000410000ULL,
0x0000001115157220ULL, 0x080fe20000410000ULL, 0x0000001124247220ULL, 0x080fe20000410000ULL,
0x0000001125257220ULL, 0x080fe20000410000ULL, 0x0000001128287220ULL, 0x080fe20000410000ULL,
0x0000001129297220ULL, 0x080fe20000410000ULL, 0x000000112c2c7220ULL, 0x080fe20000410000ULL,
0x000000112d2d7220ULL, 0x080fe20000410000ULL, 0x0000001130307220ULL, 0x080fe20000410000ULL,
0x0000001131317220ULL, 0x080fe20000410000ULL, 0x0000001134347220ULL, 0x080fe20000410000ULL,
0x0000001135357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080b117811ULL, 0x000fe200078ff0ffULL, 0x000099727f007947ULL, 0x000fea000b800000ULL,
0x00001f1105117589ULL, 0x0004e400000e0000ULL, 0x0000001122227220ULL, 0x08cfe20000410000ULL,
0x0000001123237220ULL, 0x080fe20000410000ULL, 0x000000111e1e7220ULL, 0x080fe20000410000ULL,
0x000000111f1f7220ULL, 0x080fe20000410000ULL, 0x0000001116167220ULL, 0x080fe20000410000ULL,
0x0000001117177220ULL, 0x080fe20000410000ULL, 0x0000001126267220ULL, 0x080fe20000410000ULL,
0x0000001127277220ULL, 0x080fe20000410000ULL, 0x000000112a2a7220ULL, 0x080fe20000410000ULL,
0x000000112b2b7220ULL, 0x080fe20000410000ULL, 0x000000112e2e7220ULL, 0x080fe20000410000ULL,
0x000000112f2f7220ULL, 0x080fe20000410000ULL, 0x0000001132327220ULL, 0x080fe20000410000ULL,
0x0000001133337220ULL, 0x080fe20000410000ULL, 0x0000001136367220ULL, 0x080fe20000410000ULL,
0x0000001137377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff3aff7812ULL, 0x000fe20007806039ULL, 0x00000001ff117424ULL, 0x000fd800078e00ffULL,
0x0000003812380221ULL, 0x000fe20000010100ULL, 0x00007610ff110816ULL, 0x000fc60000000011ULL,
0x3fb8aa3b38380820ULL, 0x000fc80000410000ULL, 0x0000003800040308ULL, 0x000e640000000800ULL,
0x0000000413130220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000e130e7221ULL, 0x000fc20000010000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0xfffffff0083a7812ULL, 0x000fe200078ec0ffULL, 0x000000040c137824ULL, 0x000fc800078e00ffULL,
0x00f6b4003a057984ULL, 0x000e620000000800ULL, 0x0000000413137812ULL, 0x000fe400078ec0ffULL,
0x8000000005ff7812ULL, 0x002fe4000780481bULL, 0x0000000213057812ULL, 0x000fe200078efcffULL,
0x0000000000007918ULL, 0x000ff00000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000103b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x0000003818387210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e19ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011439ULL, 0x0000003813137211ULL, 0x000fca00078110ffULL,
0x000000ffff387224ULL, 0x000fca00000e0639ULL, 0x0000000213137819ULL, 0x000fc80000001238ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6b4003a137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991011117816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000004ff02723eULL, 0x000fe400000010ffULL, 0x00000002ff1a7819ULL, 0x000fe4000001160bULL,
0x0000541002137816ULL, 0x000fe20000000002ULL, 0x000094f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1a13037589ULL, 0x0002a400000e0000ULL, 0x000000081a117810ULL, 0x000fe20007ffe0ffULL,
0x000095227f007947ULL, 0x000fea000b800000ULL, 0x00001f1113027589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101a117810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e0013ULL, 0x0000b73000197802ULL, 0x000fc40000000f00ULL,
0x000099b000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181a117810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e0013ULL,
0x0000b78000197802ULL, 0x000fc40000000f00ULL, 0x0000996000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000070b3c7812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000366407810ULL, 0x000fc40007ffe0ffULL,
0x000000083c117812ULL, 0x00cfca00078ef80bULL, 0x0000000811187824ULL, 0x000fca00078e00ffULL,
0xfffffff818497812ULL, 0x000fe400078ee20fULL, 0x000000080b0f7812ULL, 0x000fc600078ec0ffULL,
0x0000008066497824ULL, 0x000fca00078e0249ULL, 0x0000a80049497811ULL, 0x000fc400078e20ffULL,
0x000000050b057211ULL, 0x000fe200078fe0ffULL, 0x0000000800137824ULL, 0x002fe200078e00ffULL,
0x0000100052117810ULL, 0x000fe20007ffe0ffULL, 0x000000005118783bULL, 0x000e620000004200ULL,
0x0000003c0f427212ULL, 0x000fe200078efcffULL, 0x0000000100007824ULL, 0x000fe400078e0205ULL,
0x000000104c387824ULL, 0x000fe400078e0211ULL, 0x00000800400d7824ULL, 0x000fe200078e020dULL,
0xfffffff813007812ULL, 0x000fc600078ee200ULL, 0x000000003838783bULL, 0x000fe40000004200ULL,
0x00000010003c7824ULL, 0x000fe400078e0211ULL, 0x0000000142007824ULL, 0x040fe400078e0205ULL,
0x0000000842057824ULL, 0x000fe400078e00ffULL, 0x000000003c3c783bULL, 0x000ea60000004200ULL,
0xfffffff805007812ULL, 0x000fca00078ee200ULL, 0x00000010005b7824ULL, 0x000fe200078e0253ULL,
0x000000ff18057812ULL, 0x002fe400078ec0ffULL, 0x00000010ff447819ULL, 0x000fe40000011618ULL,
0x00000005ff53723eULL, 0x000fe400020006ffULL, 0x000000ff1b6a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff547819ULL, 0x000fe2000001161aULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fc400020006ffULL, 0x00000018ff647819ULL, 0x000fe4000001161aULL,
0x00000010ff5d7819ULL, 0x000fe4000001161bULL, 0x0000ffff18427812ULL, 0x000fe400078ec0ffULL,
0x00000010ff557819ULL, 0x104fe4000001163cULL, 0x000000ff3c057812ULL, 0x000fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fc4000001163cULL, 0x0000ffff3c4c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff443c7812ULL, 0x000fe200078ec0ffULL, 0x2000006aff447230ULL, 0x000fe20000004100ULL,
0x00000010ff0f7819ULL, 0x000fe40000011619ULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x2000003cff6a7230ULL, 0x000fe20000004100ULL, 0x000000ff543c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff38597812ULL, 0x000fe400078ec0ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000010ff4b7819ULL, 0x100fe4000001163dULL, 0x000000ff3d677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe4000001163dULL, 0x0000ffff3d477812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4a7819ULL, 0x100fe4000001163eULL, 0x000000ff3e637812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e137812ULL, 0x000fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011638ULL, 0x000000ff0f3e7812ULL, 0x000fe200078ec0ffULL,
0x20000064ff0f7230ULL, 0x000fe20000004100ULL, 0x00000008ff3d7819ULL, 0x000fe20000011642ULL,
0x2000003cff647230ULL, 0x000fe20000004100ULL, 0x00000018ff657819ULL, 0x000fc40000011619ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000018ff417819ULL, 0x000fe40000011618ULL, 0x00000018ff607819ULL, 0x000fe4000001161bULL,
0x0000ffff1b5a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1b7819ULL, 0x000fc40000011639ULL,
0x000000ff395e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe40000011639ULL,
0x0000ffff39187812ULL, 0x000fe400078ec0ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000045ff3c723eULL, 0x000fe200020006ffULL,
0x2000003eff6b7230ULL, 0x000fe20000004100ULL, 0x00000065ff39723eULL, 0x000fe200020006ffULL,
0x2000005dff657230ULL, 0x000fe20000004100ULL, 0x00000010ff117819ULL, 0x100fe2000001163fULL,
0x20000059ff5d7230ULL, 0x000fe20000004100ULL, 0x00000046ff59723eULL, 0x000fe200020006ffULL,
0x2000003dff547230ULL, 0x000fe20000004100ULL, 0x000000ff3f617812ULL, 0x040fe200078ec0ffULL,
0x2000003cff467230ULL, 0x000fe20000004100ULL, 0x00000018ff567819ULL, 0x000fe2000001163fULL,
0x20000039ff397230ULL, 0x000fe20000004100ULL, 0x0000ffff3f007812ULL, 0x000fc400078ec0ffULL,
0x00000000493c783bULL, 0x000e620000000200ULL, 0x0000ffff195f7812ULL, 0x040fe400078ec0ffULL,
0x000000ff19687812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x000000ff1a697812ULL, 0x000fe400078ec0ffULL,
0x00000068ff68723eULL, 0x000fc400020006ffULL, 0x0000ffff1a437812ULL, 0x000fe400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000010ff517819ULL, 0x000fe40000011638ULL, 0x0000ffff381a7812ULL, 0x000fe200078ec0ffULL,
0x2000005aff457230ULL, 0x000fe20000004100ULL, 0x00000010ff197819ULL, 0x000fc4000001163aULL,
0x000000ff3a487812ULL, 0x040fe400078ec0ffULL, 0x000000ff3b587812ULL, 0x000fe400078ec0ffULL,
0x00000041ff38723eULL, 0x000fe400020006ffULL, 0x00000069ff41723eULL, 0x000fe200020006ffULL,
0x20000068ff697230ULL, 0x000fe20000004100ULL, 0x00000018ff577819ULL, 0x000fe2000001163aULL,
0x2000005fff687230ULL, 0x000fe20000004100ULL, 0x00000010ff4e7819ULL, 0x000fe2000001163bULL,
0x20000038ff387230ULL, 0x000fe20000004100ULL, 0x00000008ff1a7819ULL, 0x000fe2000001161aULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000008ff187819ULL, 0x000fe20000011618ULL,
0x000000033c3c8231ULL, 0x082fe200003400ffULL, 0x000000ff19197812ULL, 0x000fe200078ec0ffULL,
0x000000033e3e8231ULL, 0x000fe200003400ffULL, 0x00000048ff5a723eULL, 0x000fe200020006ffULL,
0x20000059ff487230ULL, 0x000fe20000004100ULL, 0x00000058ff5f723eULL, 0x000fe200020006ffULL,
0x000000023d3d8231ULL, 0x080fe200003400ffULL, 0x0000ffff3a3a7812ULL, 0x000fe200078ec0ffULL,
0x2000005aff587230ULL, 0x000fe20000004100ULL, 0x00000057ff59723eULL, 0x000fe200020006ffULL,
0x2000005fff577230ULL, 0x000fe20000004100ULL, 0x000000ff51517812ULL, 0x000fe200078ec0ffULL,
0x000000023f3f8231ULL, 0x000fe200003400ffULL, 0x0000001aff1a723eULL, 0x000fc400020006ffULL,
0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff18723eULL, 0x000fe200020006ffULL,
0x2000001aff497230ULL, 0x000fe20000004100ULL, 0x00000019ff19723eULL, 0x000fe400020006ffULL,
0x00000018ff527819ULL, 0x000fe4000001163bULL, 0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff1b1b7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fe4000001163aULL,
0x00000051ff5f723eULL, 0x000fe200020006ffULL, 0x20000059ff517230ULL, 0x000fe20000004100ULL,
0x0000004eff5a723eULL, 0x000fe200020006ffULL, 0x20000018ff4e7230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000019ff597230ULL, 0x000fe20000004100ULL,
0x0000001bff1b723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000003aff1a723eULL, 0x000fe200020006ffULL, 0x20000060ff427230ULL, 0x000fe20000004100ULL,
0x00000008ff3b7819ULL, 0x000fe2000001163bULL, 0x2000001bff607230ULL, 0x000fe20000004100ULL,
0x00000010ff197819ULL, 0x000fe2000001166aULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff187819ULL, 0x000fc4000001166bULL, 0x00000010ff3a7819ULL, 0x000fe20000011653ULL,
0x2000001aff537230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x0000003bff6b723eULL, 0x000fe400020006ffULL, 0x00001054193a7816ULL, 0x000fe4000000003aULL,
0x00001054183b7816ULL, 0x000fe40000000069ULL, 0x009000000d18783bULL, 0x0002a20000000200ULL,
0x00000010ff6a7819ULL, 0x000fc40000011639ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff397819ULL, 0x000fe20000011668ULL, 0x0000003a3c20723cULL, 0x000b620000041820ULL,
0x00000010ff697819ULL, 0x000fe40000011638ULL, 0x00000067ff68723eULL, 0x000fe400020006ffULL,
0x00000010ff387819ULL, 0x000fe20000011654ULL, 0x2000006bff547230ULL, 0x000fe20000004100ULL,
0x00000040ff67723eULL, 0x000fc400020006ffULL, 0x00000010ff407819ULL, 0x000fe40000011641ULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x20000067ff0d7230ULL, 0x002fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe20000011644ULL, 0x20000068ff447230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x020fe20000011664ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff3a7819ULL, 0x000fe40000011665ULL, 0x0000105469387816ULL, 0x000fc40000000038ULL,
0x000010546a397816ULL, 0x000fe40000000039ULL, 0x000010543b407816ULL, 0x000fe40000000040ULL,
0x000010543a417816ULL, 0x000fe40000000041ULL, 0x00000010ff3b7819ULL, 0x000fe20000011642ULL,
0x000000383c1c723cULL, 0x000b62000004181cULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000010ff3a7819ULL, 0x000fc40000011645ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x020fe20000011643ULL,
0x0000000318188231ULL, 0x084fe200003400ffULL, 0x000000403c40723cULL, 0x000b620000041814ULL,
0x00000010ff397819ULL, 0x000fe2000001160fULL, 0x000000005b14783bULL, 0x020e620000004200ULL,
0x00000010ff5e7819ULL, 0x000fe2000001165eULL, 0x000000031a1a8231ULL, 0x000fe200003400ffULL,
0x0000105439387816ULL, 0x000fe20000000038ULL, 0x0000000219198231ULL, 0x080fe200003400ffULL,
0x000010543b397816ULL, 0x000fe2000000003aULL, 0x000000021b1b8231ULL, 0x000fe200003400ffULL,
0x00000010ff3a7819ULL, 0x000fc4000001165fULL, 0x00000010ff3b7819ULL, 0x000fe40000011660ULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x000000383c24723cULL, 0x000b620000041824ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff5a7819ULL, 0x000fe2000001165aULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x000000ff55557812ULL, 0x000fe400078ec0ffULL,
0x000010543a387816ULL, 0x020fc4000000005dULL, 0x000010543b397816ULL, 0x000fe4000000005eULL,
0x00000010ff3a7819ULL, 0x000fe40000011648ULL, 0x00000010ff487819ULL, 0x000fe40000011649ULL,
0x00000010ff3b7819ULL, 0x000fe40000011646ULL, 0x00000010ff497819ULL, 0x000fe4000001164eULL,
0x000010543b487816ULL, 0x000fc40000000048ULL, 0x000010543a497816ULL, 0x000fe40000000049ULL,
0x000000381838723cULL, 0x040be20000041820ULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff207819ULL, 0x020fe20000011658ULL, 0x00000048181c723cULL, 0x000be2000004181cULL,
0x00000010ff217819ULL, 0x000fc40000011657ULL, 0x0000105459207816ULL, 0x000fe40000000020ULL,
0x000010545a217816ULL, 0x000fe40000000021ULL, 0x00000010ff237819ULL, 0x000fe20000011651ULL,
0x20000056ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff227819ULL, 0x000fe20000011652ULL,
0x20000055ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff487819ULL, 0x020fe40000011653ULL,
0x00000010ff497819ULL, 0x000fc40000011654ULL, 0x0000105423487816ULL, 0x000fe40000000048ULL,
0x0000105422497816ULL, 0x000fe40000000049ULL, 0x000000201820723cULL, 0x040be20000041840ULL,
0x0000ffff14567812ULL, 0x042fe400078ec0ffULL, 0x00000018ff537819ULL, 0x100fe40000011616ULL,
0x00000010ff577819ULL, 0x000fe40000011616ULL, 0x000000ff14407812ULL, 0x020fe200078ec0ffULL,
0x000000481824723cULL, 0x000be20000041824ULL, 0x00000018ff417819ULL, 0x000fc40000011617ULL,
0x000000ff4b427812ULL, 0x000fe400078ec0ffULL, 0x00000040ff4b723eULL, 0x000fe400020006ffULL,
0x00000010ff407819ULL, 0x100fe40000011614ULL, 0x00000018ff437819ULL, 0x000fe40000011614ULL,
0x00000041ff55723eULL, 0x000fe400020006ffULL, 0x000000ff15147812ULL, 0x000fc400078ec0ffULL,
0x0000004cff41723eULL, 0x000fe400020006ffULL, 0x00000010ff4c7819ULL, 0x000fe40000011615ULL,
0x000000ff16497812ULL, 0x060fe200078ec0ffULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x0000ffff165a7812ULL, 0x000fe200078ec0ffULL, 0x2000004bff167230ULL, 0x000fe20000004100ULL,
0x00000010ff587819ULL, 0x000fe40000011617ULL, 0x000000ff17547812ULL, 0x000fc400078ec0ffULL,
0x0000ffff175b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe40000011615ULL,
0x00000014ff17723eULL, 0x000fe400020006ffULL, 0x00000053ff4b723eULL, 0x000fe400020006ffULL,
0x00000043ff14723eULL, 0x000fe200020006ffULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x0000ffff15597812ULL, 0x000fc400078ec0ffULL, 0x000000ff40437812ULL, 0x000fe200078ec0ffULL,
0x2000004bff407230ULL, 0x000fe20000004100ULL, 0x000000ff4c537812ULL, 0x000fe200078ec0ffULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00000048ff15723eULL, 0x000fe400020006ffULL,
0x00000054ff48723eULL, 0x000fe400020006ffULL, 0x00000008ff4c7819ULL, 0x000fe20000011656ULL,
0x20000015ff157230ULL, 0x000fe20000004100ULL, 0x00000043ff4b723eULL, 0x000fe200020006ffULL,
0x20000055ff437230ULL, 0x000fe20000004100ULL, 0x00000053ff54723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000008ff567819ULL, 0x000fe20000011659ULL,
0x2000004bff537230ULL, 0x000fe20000004100ULL, 0x000000ff57577812ULL, 0x000fe200078ec0ffULL,
0x20000054ff557230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fc400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000057ff4b723eULL, 0x000fe200020006ffULL,
0x20000056ff577230ULL, 0x000fe20000004100ULL, 0x000000ff58587812ULL, 0x000fe200078ec0ffULL,
0x2000004cff547230ULL, 0x000fe20000004100ULL, 0x00000010ff167819ULL, 0x000fe40000011616ULL,
0x00000010ff177819ULL, 0x000fe40000011617ULL, 0x00000010ff537819ULL, 0x000fc40000011653ULL,
0x00000010ff567819ULL, 0x000fe40000011655ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000058ff59723eULL, 0x000fe200020006ffULL, 0x2000004bff587230ULL, 0x000fe20000004100ULL,
0x0000105453167816ULL, 0x000fe20000000016ULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x0000105456177816ULL, 0x000fe20000000017ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000008ff4c7819ULL, 0x000fc4000001165aULL, 0x00000008ff5a7819ULL, 0x000fe4000001165bULL,
0x00000008ff537819ULL, 0x000fe20000011647ULL, 0x000000163c28723cULL, 0x000b620000041828ULL,
0x000000ff4a557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff477819ULL, 0x000fe40000011614ULL,
0x00000010ff4a7819ULL, 0x000fe40000011615ULL, 0x00000010ff147819ULL, 0x000fc40000011654ULL,
0x00000010ff157819ULL, 0x000fe40000011657ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x0000105447147816ULL, 0x000fe20000000014ULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x000010544a157816ULL, 0x000fe20000000015ULL,
0x2000005aff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff167819ULL, 0x020fc40000011649ULL,
0x00000010ff177819ULL, 0x000fe40000011658ULL, 0x00000010ff487819ULL, 0x000fe20000011648ULL,
0x000000143c2c723cULL, 0x000b62000004182cULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000005ff05723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x0000105417167816ULL, 0x000fe20000000016ULL, 0x20000005ff057230ULL, 0x000fe20000004100ULL,
0x0000105459177816ULL, 0x000fe20000000048ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000000ff11487812ULL, 0x000fc400078ec0ffULL, 0x00000010ff117819ULL, 0x000fe40000011640ULL,
0x00000010ff407819ULL, 0x000fe20000011643ULL, 0x000000163c30723cULL, 0x000b640000041830ULL,
0x00000010ff147819ULL, 0x020fe4000001164cULL, 0x00000010ff157819ULL, 0x000fe4000001164bULL,
0x0000105411147816ULL, 0x000fe40000000014ULL, 0x0000105440157816ULL, 0x000fc40000000015ULL,
0x00000010ff057819ULL, 0x000fe40000011605ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff437819ULL, 0x000fe40000011644ULL, 0x00000010ff167819ULL, 0x000fe40000011642ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000062ff457230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000105452427816ULL, 0x000fe20000000005ULL, 0x20000063ff0f7230ULL, 0x000fe20000004100ULL,
0x00000008ff137819ULL, 0x000fe20000011613ULL, 0x20000055ff477230ULL, 0x000fe20000004100ULL,
0x0000105416437816ULL, 0x000fe40000000043ULL, 0x00000008ff057819ULL, 0x000fe20000011600ULL,
0x000000143c14723cULL, 0x000b620000041834ULL, 0x00000061ff61723eULL, 0x000fc400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x20000061ff4e7230ULL, 0x000fe20000004100ULL, 0x00000013ff13723eULL, 0x000fe200020006ffULL,
0x2000005cff467230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe2000001160dULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fe20000011641ULL,
0x20000013ff137230ULL, 0x000fe20000004100ULL, 0x00000005ff05723eULL, 0x000fe200020006ffULL,
0x000000421828723cULL, 0x000b640000041828ULL, 0x00000010ff367819ULL, 0x020fc40000011645ULL,
0x00000010ff357819ULL, 0x000fe20000011653ULL, 0x20000005ff057230ULL, 0x000fe20000004100ULL,
0x0000105400347816ULL, 0x000fe40000000041ULL, 0x00000010ff0f7819ULL, 0x000fe4000001160fULL,
0x00000010ff007819ULL, 0x000fe40000011647ULL, 0x0000105436357816ULL, 0x000fe40000000035ULL,
0x0000105400367816ULL, 0x000fc4000000000fULL, 0x00000010ff377819ULL, 0x000fe4000001164eULL,
0x00000010ff487819ULL, 0x000fe20000011648ULL, 0x00000034182c723cULL, 0x000b62000004182cULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff137819ULL, 0x000fe40000011613ULL,
0x00000010ff007819ULL, 0x000fe40000011651ULL, 0x00000010ff057819ULL, 0x000fc40000011605ULL,
0x0000105448377816ULL, 0x000fe40000000037ULL, 0x0000105446467816ULL, 0x000fe40000000013ULL,
0x0000105400477816ULL, 0x000fc60000000005ULL, 0x000000361830723cULL, 0x040b700000041830ULL,
0x000000461814723cULL, 0x000b620000041814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000006187f8cULL, 0x0202a2000c80043fULL, 0x0000000107077810ULL, 0x000fc40007ffe0ffULL,
0x0000f6a066057811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000005ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x004fe200078e0019ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff454000007947ULL, 0x000fea000383ffffULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000000e007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000d07000047802ULL, 0x000fc40000000f00ULL,
0x00007eb000007944ULL, 0x00efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000e00037308ULL, 0x004ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc8000000000eULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006b00ff037624ULL, 0x000fe400078e00ffULL,
0x00006a00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x000ee80000000000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x00000002ff067819ULL, 0x00afe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x010fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000003800387220ULL, 0x042fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001500157220ULL, 0x000fe20000410000ULL, 0x0000003a043a7220ULL, 0x044fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x000fc20000410000ULL, 0x0000000000037919ULL, 0x004ea20000000000ULL,
0x0000002c2d2c723eULL, 0x000fc400000010ffULL, 0x000000303130723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000141518723eULL, 0x000fe400000010ffULL,
0x000000222322723eULL, 0x000fe400000010ffULL, 0x0000002a2b2a723eULL, 0x000fc400000010ffULL,
0x0000002e2f15723eULL, 0x000fe400000010ffULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x000000161719723eULL, 0x000fe400000010ffULL, 0x0000000203007812ULL, 0x044fe400078ec0ffULL,
0x0000000803077811ULL, 0x000fe400078ff0ffULL, 0x00000002ff057819ULL, 0x008fc40000011603ULL,
0x0000000700047211ULL, 0x040fe200078ff8ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x0000000500027211ULL, 0x000fe200078ff8ffULL, 0x0000000805097824ULL, 0x040fe400078e00ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000202007810ULL, 0x040fe40007ffe0ffULL,
0xfffffff8070e7812ULL, 0x000fe200078ee204ULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x000fe200078ee200ULL, 0x000010004f007824ULL, 0x000fe200078e00ffULL,
0x0000000402067810ULL, 0x002fc40007ffe0ffULL, 0xfffffff807047812ULL, 0x000fe200078ee202ULL,
0x000008004d057824ULL, 0x000fe200078e0200ULL, 0x0000000602077810ULL, 0x000fe20007ffe0ffULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x0000001004067824ULL, 0x000fe200078e0205ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x000000100e0e7824ULL, 0x100fe200078e0205ULL, 0x0000000802077812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x000000383902723eULL, 0x000fe200000010ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x0000001c1d04723eULL, 0x000fe200000010ffULL,
0x0000000106067824ULL, 0x000fc400078e0207ULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0x0000541002107816ULL, 0x040fe20000000004ULL, 0x00000001070e7824ULL, 0x040fe200078e020eULL,
0x0000763202117816ULL, 0x000fe20000000004ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x000000202102723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x000000242504723eULL, 0x000fe200000010ffULL, 0x0000001006007388ULL, 0x0003e20000000a00ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000282905723eULL, 0x000fc400000010ffULL,
0x0000763202077816ULL, 0x140fe40000000004ULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x0000003a3b02723eULL, 0x000fe400000010ffULL, 0x0000001e1f04723eULL, 0x000fe200000010ffULL,
0x0000000608007388ULL, 0x0003e20000000a00ULL, 0x000000262711723eULL, 0x000fc800000010ffULL,
0x0000541022107816ULL, 0x140fe40000000011ULL, 0x0000763222117816ULL, 0x000fe40000000011ULL,
0x0000541005067816ULL, 0x142fe4000000002cULL, 0x0000763205077816ULL, 0x000fe2000000002cULL,
0x0000000176057824ULL, 0x000fc800078e0203ULL, 0x000000060a007388ULL, 0x0003e40000000a00ULL,
0x0000541030067816ULL, 0x142fe40000000018ULL, 0x0000763230077816ULL, 0x000fca0000000018ULL,
0x000000060c007388ULL, 0x0003e40000000a00ULL, 0x0000541002067816ULL, 0x142fe40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x0000001005047824ULL, 0x000fe200078e0200ULL,
0x000000ff00027306ULL, 0x000fe60000205400ULL, 0x000000060e007388ULL, 0x0003e80000000a00ULL,
0x0004001008007388ULL, 0x000fe20000000a00ULL, 0x000000ff00057306ULL, 0x000ea20000209400ULL,
0x000054102a067816ULL, 0x002fc40000000015ULL, 0x000076322a077816ULL, 0x000fca0000000015ULL,
0x000400060a007388ULL, 0x0003e20000000a00ULL, 0x000000020500720bULL, 0x004fe40003f1d000ULL,
0x000000ff00027245ULL, 0x000fe4000020d400ULL, 0x0000541032067816ULL, 0x142fe40000000019ULL,
0x0000763232077816ULL, 0x000fce0000000019ULL, 0x0000000102020812ULL, 0x000fe400078efcffULL,
0x000000ff4d00720cULL, 0x000fe20003f05270ULL, 0x000400060c007388ULL, 0x000fe20000000a00ULL,
0x000000020205723eULL, 0x000fc600000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000004107984ULL, 0x000e680000000c00ULL, 0x0004000004087984ULL, 0x000ea80000000c00ULL,
0x0008000004147984ULL, 0x000ee80000000c00ULL, 0x000c000004187984ULL, 0x000f220000000c00ULL,
0x3f803f8005137831ULL, 0x002fc40000200013ULL, 0x3f803f8005127831ULL, 0x040fe40000200012ULL,
0x3f803f8005117831ULL, 0x040fe40000200011ULL, 0x3f803f8005107831ULL, 0x040fe40000200010ULL,
0x3f803f80050b7831ULL, 0x044fe4000020000bULL, 0x3f803f80050a7831ULL, 0x040fe4000020000aULL,
0x3f803f8005097831ULL, 0x000fc40000200009ULL, 0x3f803f8005087831ULL, 0x000fe40000200008ULL,
0x3f803f8013137831ULL, 0x008fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fe40000200014ULL,
0x3f803f800b0b7831ULL, 0x010fc4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe2000020001aULL,
0x0000001004007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fca0000200018ULL, 0x0004000804007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x000fc80000011603ULL, 0x000000720400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000104027824ULL, 0x100fe200078e0203ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005a0071717a19ULL, 0x000fe200000006ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00000007030e7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff802057812ULL, 0x000fe200078ef803ULL,
0x0000001075027824ULL, 0x000fe200078e0204ULL, 0x0000580000067ab9ULL, 0x000fc60000000800ULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0x0000000502047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fe40000011602ULL, 0x0000000005087984ULL, 0x0004e20000000c00ULL,
0x0000000171047824ULL, 0x000fe200078e0204ULL, 0x0000002003027810ULL, 0x000fc60007ffe0ffULL,
0x0000007a07077224ULL, 0x000fe200078e0204ULL, 0x00000006040472a4ULL, 0x002fe2000f8e023fULL,
0x00000003ff0d7819ULL, 0x000fca0000011602ULL, 0x000000047a067c24ULL, 0x000fca000f8e02ffULL,
0x0000000706077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0007047a11ULL, 0x000fc800078040ffULL, 0x00005d0007057a11ULL, 0x004fe200000f440cULL,
0x000000084f077824ULL, 0x000fe200078e020eULL, 0x000000720d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000102047824ULL, 0x102fe200078e020dULL,
0x00000040030c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010750d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fe400078ec0ffULL, 0x000000050d047c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef802ULL, 0x00005a00ff0d7a19ULL, 0x000fe2000001160dULL,
0x0000000171047824ULL, 0x000fe200078e0204ULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x0000001005077824ULL, 0x000fe400078e0200ULL, 0x0000007a0d0d7224ULL, 0x000fc600078e0204ULL,
0x0000000007087984ULL, 0x0002a40000000c00ULL, 0x0000000d060d7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000d047a11ULL, 0x000fe200078040ffULL,
0x000000084f077824ULL, 0x002fc600078e0202ULL, 0x00005d000d057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0d7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000720d00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c027824ULL, 0x100fe200078e020dULL,
0x0000006003047810ULL, 0x002fe20007ffe0ffULL, 0x00000010750d7824ULL, 0x000fc600078e020dULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x000000050d027c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef80cULL, 0x00005a00ff0d7a19ULL, 0x000fe2000001160dULL,
0x0000000171027824ULL, 0x000fe200078e0202ULL, 0x00000003ff077819ULL, 0x000fe20000011604ULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000007a0d0d7224ULL, 0x000fc600078e0202ULL, 0x0000000005087984ULL, 0x0002a40000000c00ULL,
0x0000000d060d7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000d027a11ULL, 0x000fe200078040ffULL, 0x000000084f057824ULL, 0x002fe400078e020cULL,
0x00000001040c7824ULL, 0x000fe200078e0207ULL, 0x00005d000d037a11ULL, 0x000fe400000f440eULL,
0x000000720700720cULL, 0x000fc60003f06070ULL, 0x0000001005027825ULL, 0x000fe200078e0002ULL,
0x000000070c057812ULL, 0x000fc800078ec0ffULL, 0xfffffff805057812ULL, 0x000fe200078ef804ULL,
0x0000000802007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x0000001075077824ULL, 0x000fc600078e0207ULL, 0x0000000005087984ULL, 0x002e620000000c00ULL,
0x000000084f4f7824ULL, 0x000fe200078e0204ULL, 0x0000000507007c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fc60000011607ULL, 0x0000000171007824ULL, 0x000fc800078e0200ULL,
0x0000007a07077224ULL, 0x000fca00078e0200ULL, 0x0000000706077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fc800078040ffULL,
0x00005d0007037a11ULL, 0x000fca00000f4400ULL, 0x000000104f027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006a00ff067624ULL, 0x002fe400078e00ffULL, 0x00006b00ff077624ULL, 0x000fca00078e00ffULL,
0x0000000806067981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x000000020e0e7824ULL, 0x000fe200078e00ffULL,
0x00f60000ff047f8cULL, 0x000ea2000c80043fULL, 0x000000400c767824ULL, 0x000fe400078e00ffULL,
0x000059000e027a24ULL, 0x000fc800078e0271ULL, 0x0000660002087a24ULL, 0x000fc800078e0276ULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff217819ULL, 0x000fe4000001160bULL,
0x000000760a077217ULL, 0x002fe40007800000ULL, 0x00000008211b7810ULL, 0x040fe20007ffe0ffULL,
0x00000001080e7824ULL, 0x040fe200078e0221ULL, 0x0000001821237810ULL, 0x000fe20007ffe0ffULL,
0x0000000107077824ULL, 0x000fe200078e0a76ULL, 0x0000001021227810ULL, 0x000fe20007ffe0ffULL,
0x0000000108107824ULL, 0x000fe200078e021bULL, 0x0000000b0b0d7211ULL, 0x000fe200078fe8ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000010000c207811ULL, 0x000fc400078e68ffULL,
0x000000030d1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000108147824ULL, 0x000fe200078e0223ULL,
0x000000300e167812ULL, 0x000fe200078ef803ULL, 0x0000000108127824ULL, 0x000fe200078e0222ULL,
0x0ffffffc1e0b7812ULL, 0x000fe200078ef80bULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000620016167a10ULL, 0x000fe40007f1e0ffULL, 0x00000030211f7810ULL, 0x000fe20007ffe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003010187812ULL, 0x000fc400078ef803ULL,
0x000063000f177a10ULL, 0x000fe200007fe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000003014107812ULL, 0x100fe400078ef803ULL, 0x0000002021147810ULL, 0x000fe20007ffe0ffULL,
0x000000041b0d7824ULL, 0x000fe200078e00ffULL, 0x00000030120e7812ULL, 0x000fe200078ef803ULL,
0x000000100b0b7824ULL, 0x000fe200078e0220ULL, 0x0000620018187a10ULL, 0x000fe20007f3e0ffULL,
0x0000000108127824ULL, 0x000fe200078e0214ULL, 0x000062000e0e7a10ULL, 0x000fc40007f1e0ffULL,
0x0000630011197a10ULL, 0x000fe40000ffe4ffULL, 0x00006300130f7a10ULL, 0x000fe200007fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fe40007f3e0ffULL,
0x000000072100720cULL, 0x000fe40003f06070ULL, 0x0000630015117a10ULL, 0x000fe40000ffe4ffULL,
0x00000030121a7812ULL, 0x000fc400078ef803ULL, 0x0000002821157810ULL, 0x000fe40007ffe0ffULL,
0x000062001a1a7a10ULL, 0x000fe40007f5e0ffULL, 0x000000071b00720cULL, 0x000fe20003f26070ULL,
0x0000000108127824ULL, 0x000fe200078e0215ULL, 0x00006300131b7a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000160b7faeULL, 0x0003e2000c101c48ULL,
0xfffffffc0d0d7812ULL, 0x000fe200078ee21eULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000003821217810ULL, 0x000fc40007ffe0ffULL, 0x000000071400720cULL, 0x080fe20003f66070ULL,
0x000000100d0d7824ULL, 0x000fe200078e0220ULL, 0x00000030121c7812ULL, 0x000fe200078ef803ULL,
0x0000000108127824ULL, 0x000fe200078e021fULL, 0x000000072200720cULL, 0x080fe40003fa6070ULL,
0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x00000000180d7faeULL, 0x0007e2000c901c48ULL,
0x000000072300720cULL, 0x0c0fe20003f86070ULL, 0x00000004230b7824ULL, 0x002fe200078e00ffULL,
0x00006300131d7a10ULL, 0x000fe200037fe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000071500720cULL, 0x000fc40003f46070ULL, 0x000000071f00720cULL, 0x080fe20003f26070ULL,
0x0000000415177824ULL, 0x000fe200078e00ffULL, 0x000000072100720cULL, 0x000fe20003f06070ULL,
0x0000000422077824ULL, 0x000fe200078e00ffULL, 0x0000003012127812ULL, 0x000fe200078ef803ULL,
0x00000004140d7824ULL, 0x008fe200078e00ffULL, 0xfffffffc0b0b7812ULL, 0x100fe200078ee21eULL,
0x0000000108147824ULL, 0x000fe200078e0221ULL, 0xfffffffc07077812ULL, 0x100fe200078ee21eULL,
0x000000041f197824ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffffc0d0d7812ULL, 0x000fc400078ee21eULL,
0xfffffffc17177812ULL, 0x000fe200078ee21eULL, 0x00000004211f7824ULL, 0x000fe200078e00ffULL,
0x0000003014037812ULL, 0x000fe200078ef803ULL, 0x0000001007077824ULL, 0x000fe200078e0220ULL,
0xfffffffc19197812ULL, 0x000fe200078ee21eULL, 0x000000100b0b7824ULL, 0x000fe200078e0220ULL,
0xfffffffc1f1f7812ULL, 0x000fe200078ee21eULL, 0x000000100d0d7824ULL, 0x100fe200078e0220ULL,
0x0000630013137a10ULL, 0x000fe200037fe4ffULL, 0x0000001017177824ULL, 0x100fe200078e0220ULL,
0x0000620003147a10ULL, 0x000fe20007fde0ffULL, 0x0000001019197824ULL, 0x100fe200078e0220ULL,
0x000000000e077faeULL, 0x0003e2000e901c48ULL, 0x000000101f1f7824ULL, 0x000fe200078e0220ULL,
0x0000630015157a10ULL, 0x000fc400037fe4ffULL, 0x00000000100b7faeULL, 0x0003e8000e101c48ULL,
0x000000001a0d7faeULL, 0x0003e8000d901c48ULL, 0x000000001c177faeULL, 0x0003e8000d101c48ULL,
0x0000000012197faeULL, 0x0003e8000c901c48ULL, 0x00000000141f7faeULL, 0x0003e2000c101c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x000000100b077811ULL, 0x042fe400078ff0ffULL,
0x000000280b117811ULL, 0x000fc400078ff0ffULL, 0x000000300b137811ULL, 0x000fe200078ff0ffULL,
0x0000000407197824ULL, 0x000fe200078e00ffULL, 0x0000000b0b107211ULL, 0x040fe200078fe8ffULL,
0x00000001081e7824ULL, 0x040fe200078e0211ULL, 0x000000080b177811ULL, 0x000fe200078ff0ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0x000000180b0d7811ULL, 0x040fe200078ff0ffULL,
0x0000000108207824ULL, 0x040fe200078e0213ULL, 0x000000200b0f7811ULL, 0x000fe200078ff0ffULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0x000000380b157811ULL, 0x040fe200078ff0ffULL,
0x0000000108127824ULL, 0x040fe200078e0207ULL, 0x000000080b0e7211ULL, 0x000fe200078ff0ffULL,
0x0000000108147824ULL, 0x000fe200078e020dULL, 0x0000000310187812ULL, 0x000fe200078ec0ffULL,
0x0000000108107824ULL, 0x000fe200078e0217ULL, 0x000010000c247811ULL, 0x000fe200078e68ffULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0x0ffffffc180b7812ULL, 0x000fe200078ef80bULL,
0x0000000108167824ULL, 0x040fe200078e020fULL, 0xfffffffc131a7812ULL, 0x100fe200078ee218ULL,
0x000000040f1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc17077812ULL, 0x100fe200078ee218ULL,
0x0000000108227824ULL, 0x000fe200078e0215ULL, 0xfffffffc19087812ULL, 0x100fe200078ee218ULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc11197812ULL, 0x100fe200078ee218ULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b177812ULL, 0x100fe200078ee218ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffffc0d0d7812ULL, 0x000fc400078ee218ULL,
0xfffffffc151b7812ULL, 0x000fe200078ee218ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000300e187812ULL, 0x000fc600078ef803ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000620018187a10ULL, 0x000fc60007f1e0ffULL, 0x000000100b277824ULL, 0x100fe200078e0224ULL,
0x00000030121c7812ULL, 0x100fe200078ef803ULL, 0x00000010080b7824ULL, 0x000fe200078e0224ULL,
0x0000003010087812ULL, 0x000fe200078ef803ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000062001c1c7a10ULL, 0x000fc60007f5e0ffULL, 0x000000101a237824ULL, 0x100fe200078e0224ULL,
0x00006200081a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000001019217824ULL, 0x100fe200078e0224ULL,
0x000063000f197a10ULL, 0x000fe200007fe4ffULL, 0x000000101b257824ULL, 0x000fe200078e0224ULL,
0x0000003014147812ULL, 0x000fe200078ef803ULL, 0x00000080160e7825ULL, 0x000fe200078e00ffULL,
0x00006300111b7a10ULL, 0x000fe20000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018277faeULL, 0x0003e2000b901c48ULL, 0x00006300131d7a10ULL, 0x000fe200017fe4ffULL,
0x000000801e107825ULL, 0x000fe200078e00ffULL, 0x0000620014147a10ULL, 0x000fc40007f1e0ffULL,
0x000000300e0e7812ULL, 0x100fe200078ef803ULL, 0x00000010171f7824ULL, 0x100fe200078e0224ULL,
0x0000003010107812ULL, 0x100fe200078ef803ULL, 0x0000008020127825ULL, 0x000fe200078e00ffULL,
0x0000630015157a10ULL, 0x000fe400007fe4ffULL, 0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000008022167825ULL, 0x000fe200078e00ffULL, 0x0000003012127812ULL, 0x100fe400078ef803ULL,
0x0000620010107a10ULL, 0x000fe20007f3e0ffULL, 0x0000001007077824ULL, 0x100fe200078e0224ULL,
0x0000003016037812ULL, 0x000fe200078ef803ULL, 0x000000100d0d7824ULL, 0x000fe200078e0224ULL,
0x0000620012127a10ULL, 0x000fc40007f5e0ffULL, 0x0000620003167a10ULL, 0x000fe20007f7e0ffULL,
0x000000001a077faeULL, 0x0003e2000b901c48ULL, 0x000063000f0f7a10ULL, 0x000fe400007fe4ffULL,
0x0000630011117a10ULL, 0x000fe20000ffe4ffULL, 0x000000001c0b7faeULL, 0x0003e2000b901c48ULL,
0x0000630013137a10ULL, 0x000fe400017fe4ffULL, 0x0000630017177a10ULL, 0x000fe20001ffe4ffULL,
0x00000000140d7faeULL, 0x0003e8000b901c48ULL, 0x000000000e1f7faeULL, 0x0003e8000b901c48ULL,
0x0000000010217faeULL, 0x0003e8000b901c48ULL, 0x0000000012237faeULL, 0x0003e8000b901c48ULL,
0x0000000016257faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000e7805ULL, 0x002fc40000015200ULL, 0x00f60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x006fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e087210ULL, 0x000fca0007f1e1ffULL, 0x0000000111107824ULL, 0x000fe200000e0e0fULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011410ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0610ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000107077810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x000000200c037824ULL, 0x002fca00078e0203ULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x1ffffffe04087812ULL, 0x000fe400078ec0ffULL, 0x0000000f03047812ULL, 0x000fc600078ec0ffULL,
0x0000000103087824ULL, 0x000fe400078e0208ULL, 0x00000010040e7824ULL, 0x040fe400078e00ffULL,
0x0000001004057824ULL, 0x000fe200078e00ffULL, 0x0000000f08037812ULL, 0x040fe400078ec0ffULL,
0x0000000108087810ULL, 0x000fe40007ffe0ffULL, 0x000000f00e037812ULL, 0x000fe400078ee203ULL,
0x0000000f08087812ULL, 0x000fc600078ec0ffULL, 0x0000000003147984ULL, 0x000e62000000cc00ULL,
0x000000f005087812ULL, 0x000fca00078ee208ULL, 0x0000000008107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff197224ULL, 0x000fe400078e0016ULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0012ULL,
0x000000ffff167224ULL, 0x000fe400078e0011ULL, 0x000000ffff177224ULL, 0x000fe200078e0013ULL,
0x0000001803007388ULL, 0x0003e8000000cc00ULL, 0x0000001408007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff107f8cULL, 0x000ea2000c80043fULL,
0x000000ffff077224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x00f60400ff037984ULL, 0x002e640000000800ULL, 0x8000000003ff7812ULL, 0x006fc40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e04087210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0e7824ULL, 0x000fe200000e0e05ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140eULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e060eULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000107077810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000001fff077424ULL, 0x000fe200078e00ffULL, 0x800058000a087a10ULL, 0x000fe20007ffe0ffULL,
0x00000001ff747424ULL, 0x000fe200078e00ffULL, 0x3db504f306047820ULL, 0x010fe20000410000ULL,
0x00005800ff0d7624ULL, 0x000fe200078e00ffULL, 0x0000580007077a10ULL, 0x000fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x0000f6880c757811ULL, 0x000fe200078e18ffULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00000004ff0b7819ULL, 0x000fc40000011607ULL,
0x0000f6080c777811ULL, 0x000fe400078e28ffULL, 0x0000580074747a10ULL, 0x000fe40007ffe1ffULL,
0x000000090d077810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff087819ULL, 0x000fe40000011608ULL,
0x0ffffffe0b0b7812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0006ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x008fc4000001ff00ULL,
0x000000010e00780cULL, 0x000fe20003f25270ULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x00000001050f7810ULL, 0x000fc40007ffe0ffULL, 0x000000010e147810ULL, 0x020fc80007ffe0ffULL,
0x000000021400780cULL, 0x040fe40003f06070ULL, 0x000000ff14157207ULL, 0x000fc60000800000ULL,
0x000000ffff0f1224ULL, 0x000fc800078e0205ULL, 0x000001000f3d7824ULL, 0x040fe200078e0276ULL,
0x000000010f067810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e000eULL,
0x000000ffff0e7224ULL, 0x000fe200078e0014ULL, 0x000000090600720cULL, 0x000fe20003f46070ULL,
0x00006600023c7a24ULL, 0x000fe200078e023dULL, 0x000000010d067812ULL, 0x000fd600078e0cffULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x0000001003147824ULL, 0x002fe200078e00ffULL,
0x00000002ff427819ULL, 0x000fe20000011603ULL, 0x000000020c407824ULL, 0x000fe200078e0206ULL,
0x0000003d0a1a7217ULL, 0x000fe40007800000ULL, 0x0000003014147812ULL, 0x000fe200078ec0ffULL,
0x0000000142177824ULL, 0x040fe200078e023cULL, 0x0000000842417810ULL, 0x000fe20007ffe0ffULL,
0x000000011a3d7824ULL, 0x000fe200078e0a3dULL, 0x0000001842467810ULL, 0x040fe20007ffe0ffULL,
0x0000004015147824ULL, 0x000fe200078e0214ULL, 0x0000001042437810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000002042477810ULL, 0x040fe20007ffe0ffULL,
0x0000000141197824ULL, 0x000fe200078e023cULL, 0x0000002842487810ULL, 0x000fe20007ffe0ffULL,
0x0000008017167825ULL, 0x000fe200078e0014ULL, 0x0000100040407811ULL, 0x000fc400078e60ffULL,
0x0000003042497810ULL, 0x000fe20007ffe0ffULL, 0x00000001463f7824ULL, 0x100fe200078e023cULL,
0x0000620016387a10ULL, 0x000fe20007f3e0ffULL, 0x00000001433b7824ULL, 0x000fe200078e023cULL,
0x0000003d4600720cULL, 0x000fe20003fa6070ULL, 0x0000008019187825ULL, 0x000fe200078e0014ULL,
0x0000630017397a10ULL, 0x000fc60000ffe4ffULL, 0x000000803f3e7825ULL, 0x100fe200078e0014ULL,
0x00006200181a7a10ULL, 0x000fe40007f5e0ffULL, 0x0000000303187211ULL, 0x000fe200078fe8ffULL,
0x000000803b3a7825ULL, 0x000fe200078e0014ULL, 0x000062003e167a10ULL, 0x000fe40007f3e0ffULL,
0x0000000318447812ULL, 0x000fe200078ec0ffULL, 0x0000000443457824ULL, 0x000fe200078e00ffULL,
0x000062003a3a7a10ULL, 0x000fe40007f7e0ffULL, 0x000063003f177a10ULL, 0x000fe20000ffe4ffULL,
0x00000004413f7824ULL, 0x000fe200078e00ffULL, 0x00006300191b7a10ULL, 0x000fe200017fe4ffULL,
0x0000000147197824ULL, 0x000fe200078e023cULL, 0x0000003d4200720cULL, 0x000fc40003f26070ULL,
0x0000003d4100720cULL, 0x080fe20003f46070ULL, 0x0000008019187825ULL, 0x000fe200078e0014ULL,
0x000063003b3b7a10ULL, 0x000fe40001ffe4ffULL, 0x0000003d4300720cULL, 0x080fe40003f66070ULL,
0x0ffffffc44417812ULL, 0x000fe400078ef803ULL, 0xfffffffc3f437812ULL, 0x000fe200078ee244ULL,
0x00000001483f7824ULL, 0x000fe200078e023cULL, 0xfffffffc45457812ULL, 0x000fe200078ee244ULL,
0x0000001041417824ULL, 0x100fe200078e0240ULL, 0x0000003842427810ULL, 0x000fe20007ffe0ffULL,
0x0000001043437824ULL, 0x000fe200078e0240ULL, 0x0000620018187a10ULL, 0x000fe20007f9e0ffULL,
0x000000803f3e7825ULL, 0x000fe200078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038417faeULL, 0x0003e2000c901c48ULL, 0x0000003d4200720cULL, 0x000fc40003f26070ULL,
0x0000001045457824ULL, 0x000fe200078e0240ULL, 0x000000001a437faeULL, 0x0005e2000d101c48ULL,
0x0000630019197a10ULL, 0x000fe400027fe4ffULL, 0x0000003d4700720cULL, 0x080fe20003f86070ULL,
0x000000003a457faeULL, 0x0007e2000d901c48ULL, 0x0000003d4800720cULL, 0x080fe40003f66070ULL,
0x0000003d4900720cULL, 0x040fe20003f46070ULL, 0x0000000149397824ULL, 0x102fe400078e023cULL,
0x0000000142417824ULL, 0x000fe200078e023cULL, 0x000062003e1a7a10ULL, 0x004fe20007fde0ffULL,
0x0000008039387825ULL, 0x000fc600078e0014ULL, 0x000063003f1b7a10ULL, 0x000fe200037fe4ffULL,
0x00000004463b7824ULL, 0x008fe200078e00ffULL, 0x0000620038387a10ULL, 0x000fe20007fde0ffULL,
0x00000004473d7824ULL, 0x000fe400078e00ffULL, 0x0000008041147825ULL, 0x000fe200078e0014ULL,
0xfffffffc3b3b7812ULL, 0x100fe400078ee244ULL, 0xfffffffc3d3d7812ULL, 0x100fe200078ee244ULL,
0x00000004483f7824ULL, 0x000fe200078e00ffULL, 0x0000630039397a10ULL, 0x000fe200037fe4ffULL,
0x0000000449417824ULL, 0x000fe200078e00ffULL, 0x0000620014147a10ULL, 0x000fe20007fde0ffULL,
0x0000000442437824ULL, 0x000fe200078e00ffULL, 0xfffffffc3f3f7812ULL, 0x000fe200078ee244ULL,
0x000000103b3b7824ULL, 0x000fe200078e0240ULL, 0xfffffffc41417812ULL, 0x000fe200078ee244ULL,
0x000000103d3d7824ULL, 0x000fe200078e0240ULL, 0xfffffffc43437812ULL, 0x000fe200078ee244ULL,
0x000000103f3f7824ULL, 0x100fe200078e0240ULL, 0x0000630015157a10ULL, 0x000fe200037fe4ffULL,
0x0000001041417824ULL, 0x100fe200078e0240ULL, 0x00000000163b7faeULL, 0x0003e2000e901c48ULL,
0x0000001043437824ULL, 0x000fc600078e0240ULL, 0x00000000183d7faeULL, 0x0003e8000e101c48ULL,
0x000000001a3f7faeULL, 0x0003e8000d901c48ULL, 0x0000000038417faeULL, 0x0003e8000d101c48ULL,
0x0000000014437faeULL, 0x0003e2000c901c48ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0000001003147824ULL, 0x042fe200078e00ffULL, 0x0000001003397811ULL, 0x040fe200078ff0ffULL,
0x000000020c177824ULL, 0x000fe200078e0206ULL, 0x00000018033b7811ULL, 0x000fc400078ff0ffULL,
0x0000003014147812ULL, 0x000fe200078ec0ffULL, 0x00000001391b7824ULL, 0x000fe200078e023cULL,
0x00000020033d7811ULL, 0x000fe200078ff0ffULL, 0x000000043b437824ULL, 0x000fe200078e00ffULL,
0x00000028033f7811ULL, 0x000fe200078ff0ffULL, 0x0000004015147824ULL, 0x000fe200078e0214ULL,
0x0000000803157811ULL, 0x000fe200078ff0ffULL, 0x000000043d457824ULL, 0x000fe200078e00ffULL,
0x0000003003417811ULL, 0x040fe400078ff0ffULL, 0x00000038034d7811ULL, 0x000fe200078ff0ffULL,
0x0000000115197824ULL, 0x100fe200078e023cULL, 0x00001000174f7811ULL, 0x000fe200078e60ffULL,
0x0000000439177824ULL, 0x000fe200078e00ffULL, 0x0000000303167211ULL, 0x000fe200078fe8ffULL,
0x000000013b397824ULL, 0x000fc400078e023cULL, 0x000000013d3b7824ULL, 0x100fe200078e023cULL,
0x0000000316167812ULL, 0x000fe200078ec0ffULL, 0x000000013f3d7824ULL, 0x000fe400078e023cULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0xfffffffc171a7812ULL, 0x100fe200078ee216ULL,
0x000000043f3f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc43387812ULL, 0x100fe200078ee216ULL,
0x0000000441477824ULL, 0x000fe200078e00ffULL, 0xfffffffc15187812ULL, 0x100fe200078ee216ULL,
0x000000044d497824ULL, 0x000fe200078e00ffULL, 0xfffffffc453a7812ULL, 0x100fe200078ee216ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0xfffffffc3f3e7812ULL, 0x000fe200078ee216ULL,
0x00000001413f7824ULL, 0x000fe200078e023cULL, 0xfffffffc47407812ULL, 0x100fe200078ee216ULL,
0x0000001018417824ULL, 0x100fe200078e024fULL, 0xfffffffc49427812ULL, 0x000fe200078ee216ULL,
0x000000101a437824ULL, 0x000fe200078e024fULL, 0x0ffffffc16167812ULL, 0x000fe200078ef803ULL,
0x0000008019187825ULL, 0x000fe200078e0014ULL, 0x0000003c03177211ULL, 0x000fc600078ff0ffULL,
0x0000001016517824ULL, 0x000fe200078e024fULL, 0x0000620018187a10ULL, 0x000fe20007f5e0ffULL,
0x0000008017167825ULL, 0x000fc600078e0014ULL, 0x0000630019197a10ULL, 0x000fe200017fe4ffULL,
0x0000001038457824ULL, 0x000fe200078e024fULL, 0x0000620016167a10ULL, 0x000fe20007f3e0ffULL,
0x000000801b1a7825ULL, 0x000fc600078e0014ULL, 0x0000630017177a10ULL, 0x000fe20000ffe4ffULL,
0x0000008039387825ULL, 0x000fe200078e0014ULL, 0x000062001a1a7a10ULL, 0x000fc60007f7e0ffULL,
0x000000014d4d7824ULL, 0x000fe200078e023cULL, 0x0000620038387a10ULL, 0x000fe20007f9e0ffULL,
0x000000103a477824ULL, 0x000fe200078e024fULL, 0x000063001b1b7a10ULL, 0x000fe20001ffe4ffULL,
0x000000803b3a7825ULL, 0x000fe200078e0014ULL, 0x0000630039397a10ULL, 0x000fe200027fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016517faeULL, 0x0003e4000b901c48ULL,
0x000000103e497824ULL, 0x000fe200078e024fULL, 0x000062003a3a7a10ULL, 0x000fe20007f3e0ffULL,
0x000000803d3c7825ULL, 0x100fe200078e0014ULL, 0x0000000018417faeULL, 0x0003e4000b901c48ULL,
0x000063003b3b7a10ULL, 0x000fe20000ffe4ffULL, 0x000000803f3e7825ULL, 0x100fe200078e0014ULL,
0x000062003c3c7a10ULL, 0x000fe20007f5e0ffULL, 0x000000001a437faeULL, 0x0003e4000b901c48ULL,
0x000000804d147825ULL, 0x000fe200078e0014ULL, 0x000062003e3e7a10ULL, 0x000fe20007f7e0ffULL,
0x0000000038457faeULL, 0x0003e2000b901c48ULL, 0x000063003d3d7a10ULL, 0x000fe200017fe4ffULL,
0x00000010404b7824ULL, 0x100fe200078e024fULL, 0x0000620014147a10ULL, 0x000fe20007f9e0ffULL,
0x00000010424f7824ULL, 0x000fe200078e024fULL, 0x000063003f3f7a10ULL, 0x000fe20001ffe4ffULL,
0x000000003a477faeULL, 0x0003e2000b901c48ULL, 0x0000630015157a10ULL, 0x000fc600027fe4ffULL,
0x000000003c497faeULL, 0x0003e8000b901c48ULL, 0x000000003e4b7faeULL, 0x0003e8000b901c48ULL,
0x00000000144f7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff387224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff803147812ULL, 0x020fe200078ec0ffULL,
0x000000020c397824ULL, 0x000fe200078e020dULL, 0x0000000138187810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000714147812ULL, 0x000fc400078ef803ULL,
0x0000100039397811ULL, 0x000fe400078e60ffULL, 0x00000001ff157819ULL, 0x000fe20000011614ULL,
0x0000000414177824ULL, 0x040fe200078e00ffULL, 0x00000007031a7812ULL, 0x000fe200078ec0ffULL,
0x0000000414147824ULL, 0x000fe400078e00ffULL, 0x0000000115167824ULL, 0x040fe200078e0238ULL,
0x000000081a3e7812ULL, 0x000fe200078ef803ULL, 0x0000000115157824ULL, 0x000fc600078e0218ULL,
0xfffffffc17167812ULL, 0x000fe200078ee216ULL, 0x000000103e3f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc14147812ULL, 0x000fe400078ee215ULL, 0x0000002003157810ULL, 0x000fe20007ffe0ffULL,
0x0000001016167824ULL, 0x100fe400078e0239ULL, 0x0000001014407824ULL, 0x000fe400078e0239ULL,
0x000000040f147824ULL, 0x000fe200078e0238ULL, 0x000000001648783bULL, 0x0002a60000000200ULL,
0x0000000214147824ULL, 0x000fe200078e00ffULL, 0x000000004040783bULL, 0x000ee20000000200ULL,
0xfffffff815167812ULL, 0x002fc600078ec0ffULL, 0x0000001403157211ULL, 0x040fe400078fe0ffULL,
0x00000007163a7812ULL, 0x000fe200078ef803ULL, 0x000000103e167824ULL, 0x000fe200078e00ffULL,
0x0000000214147810ULL, 0x000fe20007ffe0ffULL, 0x000000013e157824ULL, 0x000fe200078e0215ULL,
0x00000001ff177819ULL, 0x000fe2000001163aULL, 0x000000043a1b7824ULL, 0x040fe200078e00ffULL,
0x0000001403197211ULL, 0x000fe200078fe0ffULL, 0x000000043a4f7824ULL, 0x000fe200078e00ffULL,
0xfffffff016157812ULL, 0x000fe200078ee215ULL, 0x0000000117147824ULL, 0x040fe200078e0238ULL,
0x0000000238387810ULL, 0x000fe20007ffe0ffULL, 0x00000001174c7824ULL, 0x000fc400078e0218ULL,
0x0000001015157824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b147812ULL, 0x000fe200078ee214ULL,
0x000000013e3c7824ULL, 0x000fe200078e0219ULL, 0xfffffffc4f4c7812ULL, 0x000fe400078ee24cULL,
0x000000001518783bULL, 0x0006620000000200ULL, 0x0000001014447824ULL, 0x000fe200078e0239ULL,
0xfffffff03f3f7812ULL, 0x000fe400078ee23cULL, 0x000000043800780cULL, 0x000fc60003f25270ULL,
0x000000103f147824ULL, 0x000fe200078e00ffULL, 0x000000004444783bULL, 0x000fe20000000200ULL,
0x00000018ff167819ULL, 0x104fe4000001164bULL, 0x000000ff4b177812ULL, 0x040fe400078ec0ffULL,
0x00000016ff3d723eULL, 0x000fe400020006ffULL, 0x00000010ff167819ULL, 0x000fe4000001164bULL,
0x0000ffff4b4b7812ULL, 0x000fe200078ec0ffULL, 0x2000003dff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff163b7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff167819ULL, 0x000fe4000001164bULL,
0x0000003bff3c723eULL, 0x000fe400020006ffULL, 0x00000017ff17723eULL, 0x000fe400020006ffULL,
0x00000016ff16723eULL, 0x000fe200020006ffULL, 0x2000003cff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x108fe20000011643ULL, 0x20000017ff3b7230ULL, 0x000fe20000004100ULL,
0x00000018ff177819ULL, 0x000fe20000011643ULL, 0x20000016ff3c7230ULL, 0x000fe20000004100ULL,
0x000000ff15157812ULL, 0x000fc400078ec0ffULL, 0x000000ff43167812ULL, 0x040fe400078ec0ffULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff3c7819ULL, 0x000fc4000001163cULL, 0x00000017ff4d723eULL, 0x000fe400020006ffULL,
0x00000015ff4b723eULL, 0x000fe400020006ffULL, 0x00000008ff437819ULL, 0x000fe20000011643ULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x000010543e3d7816ULL, 0x000fe2000000003dULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x000010543c3c7816ULL, 0x000fe4000000003bULL,
0x00000016ff3f723eULL, 0x000fc400020006ffULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x00000010ff4b7819ULL, 0x000fe2000001164bULL,
0x0000003c1810723cULL, 0x002b620000041810ULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x0000ffff48687812ULL, 0x000fe200078ec0ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x000000ff416c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3f7819ULL, 0x000fe2000001163fULL,
0x000000104c3d7824ULL, 0x020fe200078e0239ULL, 0x00000010ff3c7819ULL, 0x000fc4000001164dULL,
0x00000010ff3a7819ULL, 0x000fe40000011643ULL, 0x000010543c4d7816ULL, 0x000fe4000000004bULL,
0x00000010ff3c7819ULL, 0x100fe40000011648ULL, 0x00000018ff437819ULL, 0x000fe40000011648ULL,
0x000000ff48397812ULL, 0x000fe400078ec0ffULL, 0x000010543a4c7816ULL, 0x000fc4000000003fULL,
0x000000ff3c487812ULL, 0x000fe400078ec0ffULL, 0x000000003d3c783bULL, 0x000e620000000200ULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000018ff3a7819ULL, 0x000fe20000011649ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x100fe2000001164aULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000018ff557819ULL, 0x000fc4000001164aULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff487819ULL, 0x000fe20000011648ULL, 0x0000004c1410723cULL, 0x004be20000041810ULL,
0x000000ff4a4b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4a647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3b7819ULL, 0x000fe40000011649ULL, 0x000000ff424a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff617819ULL, 0x100fe40000011644ULL, 0x00000018ff737819ULL, 0x000fe40000011644ULL,
0x000000ff44697812ULL, 0x040fe400078ec0ffULL, 0x0000ffff445d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x100fe40000011640ULL, 0x00000018ff667819ULL, 0x000fc40000011640ULL,
0x000000ff40677812ULL, 0x040fe400078ec0ffULL, 0x0000ffff40707812ULL, 0x000fe400078ec0ffULL,
0x0000105443517816ULL, 0x000fe40000000048ULL, 0x000000ff49547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff49637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff507819ULL, 0x000fc40000011646ULL,
0x00000018ff717819ULL, 0x000fe40000011646ULL, 0x000000ff46567812ULL, 0x040fe400078ec0ffULL,
0x0000ffff46537812ULL, 0x000fe400078ec0ffULL, 0x0000003aff6a723eULL, 0x000fe400020006ffULL,
0x00000010ff5a7819ULL, 0x102fe4000001163dULL, 0x00000018ff447819ULL, 0x000fe2000001163dULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x000000ff3d407812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3d487812ULL, 0x000fe400078ec0ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff497819ULL, 0x100fe4000001163eULL, 0x00000018ff467819ULL, 0x000fe4000001163eULL,
0x000000ff3e3d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3e3a7812ULL, 0x000fc400078ec0ffULL,
0x0000004aff3e723eULL, 0x000fe200020006ffULL, 0x2000006cff4a7230ULL, 0x000fe20000004100ULL,
0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x0000003bff6c723eULL, 0x000fe200020006ffULL, 0x2000003eff3b7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000018ff5b7819ULL, 0x100fe20000011647ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000069ff3e723eULL, 0x000fe200020006ffULL,
0x20000064ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fc40000011647ULL,
0x000000ff474c7812ULL, 0x060fe200078ec0ffULL, 0x2000003eff647230ULL, 0x000fe20000004100ULL,
0x0000ffff47657812ULL, 0x000fe400078ec0ffULL, 0x00000010ff587819ULL, 0x100fe40000011645ULL,
0x00000018ff727819ULL, 0x000fe40000011645ULL, 0x000000ff455f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff45607812ULL, 0x000fc400078ec0ffULL, 0x00000010ff4d7819ULL, 0x100fe40000011641ULL,
0x00000018ff6f7819ULL, 0x000fe40000011641ULL, 0x0000ffff414f7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff6e723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x100fe4000001163cULL,
0x00000018ff477819ULL, 0x000fe2000001163cULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff3c437812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3c597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x100fe4000001163fULL, 0x00000018ff457819ULL, 0x000fe4000001163fULL,
0x000000ff3f3c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3f417812ULL, 0x000fe400078ec0ffULL,
0x0000005bff3f723eULL, 0x000fc400020006ffULL, 0x00000008ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff4e7819ULL, 0x000fe40000011642ULL, 0x0000004cff3e723eULL, 0x000fe200020006ffULL,
0x2000003fff4c7230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x0000ffff42577812ULL, 0x000fe400078ec0ffULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000071ff5b7230ULL, 0x000fe20000004100ULL, 0x000000ff4d3f7812ULL, 0x000fe200078ec0ffULL,
0x2000003eff4d7230ULL, 0x000fe20000004100ULL, 0x000000ff4e4e7812ULL, 0x000fc400078ec0ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000008ff3e7819ULL, 0x000fe20000011657ULL,
0x20000070ff577230ULL, 0x000fe20000004100ULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x000000ff5c717812ULL, 0x000fe200078ec0ffULL, 0x20000056ff5c7230ULL, 0x000fe20000004100ULL,
0x0000004eff70723eULL, 0x000fe200020006ffULL, 0x20000054ff6b7230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fc400020006ffULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x00000071ff56723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x000000ff61617812ULL, 0x000fe200078ec0ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x2000003fff4e7230ULL, 0x000fe20000004100ULL, 0x00000047ff71723eULL, 0x000fe200020006ffULL,
0x20000070ff477230ULL, 0x000fe20000004100ULL, 0x00000066ff54723eULL, 0x000fe200020006ffULL,
0x20000055ff667230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000003eff3f7230ULL, 0x000fe20000004100ULL, 0x00000044ff70723eULL, 0x000fe200020006ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000067ff55723eULL, 0x000fe200020006ffULL,
0x2000004bff677230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000071ff447230ULL, 0x000fe20000004100ULL, 0x0000006fff4b723eULL, 0x000fe200020006ffULL,
0x20000068ff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff607819ULL, 0x000fe20000011660ULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000040ff3e723eULL, 0x000fe200020006ffULL,
0x20000070ff407230ULL, 0x000fe20000004100ULL, 0x00000008ff637819ULL, 0x000fe20000011663ULL,
0x20000061ff707230ULL, 0x000fe20000004100ULL, 0x00000060ff61723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000008ff5d7819ULL, 0x000fe2000001165dULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x000000ff50607812ULL, 0x000fe200078ec0ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fc4000001166eULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x000000ff58587812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011642ULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x000010546f507816ULL, 0x000fe40000000050ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x2000005dff6e7230ULL, 0x000fe20000004100ULL, 0x0000006dff42723eULL, 0x000fe200020006ffULL,
0x20000063ff6d7230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x000000501820723cULL, 0x000be20000041820ULL, 0x00000008ff537819ULL, 0x000fe20000011653ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x000000ff52527812ULL, 0x000fe200078ec0ffULL,
0x2000005eff687230ULL, 0x000fe20000004100ULL, 0x00000060ff5d723eULL, 0x000fe200020006ffULL,
0x20000058ff607230ULL, 0x000fe20000004100ULL, 0x00000053ff58723eULL, 0x000fc400020006ffULL,
0x00000052ff6f723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x020fe2000001166aULL, 0x20000058ff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fe2000001166cULL, 0x2000006fff587230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe4000001166bULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000073ff63723eULL, 0x000fc400020006ffULL, 0x0000105450537816ULL, 0x000fe40000000053ULL,
0x000010546d527816ULL, 0x000fe20000000052ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff517819ULL, 0x000fe40000011668ULL,
0x00000010ff507819ULL, 0x000fe20000011667ULL, 0x000000521824723cULL, 0x000be20000041824ULL,
0x00000010ff697819ULL, 0x000fc40000011669ULL, 0x0000105466517816ULL, 0x000fe40000000051ULL,
0x0000105469507816ULL, 0x000fe40000000050ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x000000501828723cULL, 0x000b620000041828ULL, 0x00000010ff707819ULL, 0x000fe20000011670ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x020fc4000001166eULL,
0x00000008ff657819ULL, 0x000fe40000011665ULL, 0x0000105463517816ULL, 0x000fe40000000070ULL,
0x0000105453507816ULL, 0x000fe40000000064ULL, 0x00000010ff527819ULL, 0x000fe4000001165fULL,
0x00000010ff537819ULL, 0x000fe40000011660ULL, 0x00000008ff5f7819ULL, 0x000fe20000011659ULL,
0x00000050182c723cULL, 0x000b62000004182cULL, 0x000000ff5a607812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5a7819ULL, 0x000fe4000001165bULL, 0x00000010ff597819ULL, 0x000fe4000001166aULL,
0x00000010ff507819ULL, 0x020fe4000001165cULL, 0x00000010ff517819ULL, 0x000fe4000001165dULL,
0x00000072ff5e723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x000010545a517816ULL, 0x000fe20000000051ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000105459507816ULL, 0x000fe20000000050ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000062ff66723eULL, 0x000fe200020006ffULL, 0x000000501834723cULL, 0x000be20000041834ULL,
0x00000010ff627819ULL, 0x000fc4000001165eULL, 0x00000010ff4c7819ULL, 0x000fe2000001164cULL,
0x20000066ff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000008ff507819ULL, 0x020fe40000011648ULL, 0x000000ff49517812ULL, 0x000fe400078ec0ffULL,
0x00000010ff487819ULL, 0x000fe4000001164dULL, 0x00000010ff497819ULL, 0x000fc40000011658ULL,
0x0000105462537816ULL, 0x000fe40000000053ULL, 0x0000105461527816ULL, 0x000fe40000000052ULL,
0x000010544c497816ULL, 0x000fe40000000049ULL, 0x0000105465487816ULL, 0x000fe40000000048ULL,
0x00000008ff3a7819ULL, 0x000fe2000001163aULL, 0x000000521830723cULL, 0x000f620000041830ULL,
0x00000008ff4f7819ULL, 0x000fc4000001164fULL, 0x000000ff39397812ULL, 0x000fe400078ec0ffULL,
0x00000008ff417819ULL, 0x000fe40000011641ULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x00000048181c723cULL, 0x000b62000004181cULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fc400020006ffULL,
0x00000010ff187819ULL, 0x020fe2000001163bULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff197819ULL, 0x000fe20000011647ULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000050ff4d723eULL, 0x000fc400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000051ff4c7230ULL, 0x000fe20000004100ULL,
0x0000105442197816ULL, 0x000fe20000000019ULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x000010543f187816ULL, 0x000fe20000000018ULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe20000011654ULL, 0x20000060ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe20000011655ULL, 0x2000005fff557230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fe2000001164bULL, 0x000000181428723cULL, 0x000b620000041828ULL,
0x00000010ff3d7819ULL, 0x000fc4000001163dULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000010ff537819ULL, 0x000fe40000011656ULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff4b7819ULL, 0x000fe4000001164eULL,
0x00000010ff4f7819ULL, 0x000fc4000001164fULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff1a7819ULL, 0x000fe40000011643ULL, 0x00000010ff1b7819ULL, 0x000fe4000001165eULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff3f7819ULL, 0x000fc40000011654ULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff3b7819ULL, 0x000fe4000001164cULL, 0x00000010ff187819ULL, 0x020fe40000011645ULL,
0x00000010ff397819ULL, 0x000fc40000011639ULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff417819ULL, 0x000fe40000011641ULL, 0x000010543a3a7816ULL, 0x000fe4000000003dULL,
0x000010545a537816ULL, 0x000fe40000000053ULL, 0x0000105457527816ULL, 0x000fe40000000052ULL,
0x00001054504b7816ULL, 0x000fc4000000004bULL, 0x000010544f4a7816ULL, 0x000fe4000000004aULL,
0x00001054441b7816ULL, 0x000fe2000000001bULL, 0x000000521420723cULL, 0x040b620000041820ULL,
0x00001054551a7816ULL, 0x000fe4000000001aULL, 0x00001054403f7816ULL, 0x000fe4000000003fULL,
0x000010544d3e7816ULL, 0x000fe4000000003eULL, 0x00001054463b7816ULL, 0x000fe2000000003bULL,
0x0000004a1424723cULL, 0x000b620000041824ULL, 0x00001054183d7816ULL, 0x000fc40000000039ULL,
0x00001054413c7816ULL, 0x000fca000000003cULL, 0x0000001a142c723cULL, 0x040b70000004182cULL,
0x0000003e1430723cULL, 0x040b700000041830ULL, 0x0000003a1434723cULL, 0x040b700000041834ULL,
0x0000003c141c723cULL, 0x000b62000004181cULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe7c000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0006ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdb7000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000004113a7220ULL, 0x0a0fe20000410000ULL, 0x0000000412177220ULL, 0x080fe20000410000ULL,
0x0000000434347220ULL, 0x080fe20000410000ULL, 0x0000000420207220ULL, 0x080fe20000410000ULL,
0x0000000421217220ULL, 0x080fe20000410000ULL, 0x0000000424247220ULL, 0x080fe20000410000ULL,
0x00000004250d7220ULL, 0x080fe20000410000ULL, 0x0000000428287220ULL, 0x080fe20000410000ULL,
0x0000000429297220ULL, 0x080fe20000410000ULL, 0x0000000410107220ULL, 0x080fe20000410000ULL,
0x000000042d0e7220ULL, 0x080fe20000410000ULL, 0x00000004300f7220ULL, 0x080fe20000410000ULL,
0x0000000431117220ULL, 0x080fe20000410000ULL, 0x0000000435127220ULL, 0x080fe20000410000ULL,
0x0000000413397220ULL, 0x080fe20000410000ULL, 0x0000000436197220ULL, 0x080fe20000410000ULL,
0x000000042b167220ULL, 0x080fe20000410000ULL, 0x000000042c387220ULL, 0x080fe20000410000ULL,
0x000000042e1b7220ULL, 0x080fe20000410000ULL, 0x000000042f1a7220ULL, 0x080fe20000410000ULL,
0x0000000432137220ULL, 0x080fe20000410000ULL, 0x00000004373b7220ULL, 0x080fe20000410000ULL,
0x000000ffff367224ULL, 0x000fe200078e0034ULL, 0x0000000422227220ULL, 0x080fe20000410000ULL,
0x0000000423237220ULL, 0x080fe20000410000ULL, 0x0000000426147220ULL, 0x080fe20000410000ULL,
0x0000000427157220ULL, 0x080fe20000410000ULL, 0x000000042a2a7220ULL, 0x080fe20000410000ULL,
0x0000000433187220ULL, 0x080fe20000410000ULL, 0x000000041c2b7220ULL, 0x080fe20000410000ULL,
0x000000041d1d7220ULL, 0x080fe20000410000ULL, 0x000000041e3c7220ULL, 0x080fe20000410000ULL,
0x000000041f3d7220ULL, 0x000fe20000410000ULL, 0x000000ffff257224ULL, 0x000fc400078e0020ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0021ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0024ULL,
0x000000ffff357224ULL, 0x000fe400078e000dULL, 0x000000ffff2e7224ULL, 0x000fe400078e0028ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0029ULL, 0x000000ffff307224ULL, 0x000fc400078e0010ULL,
0x000000ffff317224ULL, 0x000fe400078e000eULL, 0x000000ffff327224ULL, 0x000fe400078e000fULL,
0x000000ffff377224ULL, 0x000fe400078e0011ULL, 0x000000ffff347224ULL, 0x000fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000750e7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff247224ULL, 0x000fe400078e0023ULL, 0x000000ffff297224ULL, 0x000fc400078e002aULL,
0x000000ffff267224ULL, 0x000fe400078e0022ULL, 0x000000ffff277224ULL, 0x000fe400078e0014ULL,
0x000000ffff337224ULL, 0x000fe400078e0015ULL, 0x000000ffff287224ULL, 0x000fe400078e0016ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0017ULL, 0x000000ffff1c7224ULL, 0x000fc400078e0013ULL,
0x000000ffff237224ULL, 0x000fe400078e0018ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0019ULL,
0x000000ffff1f7224ULL, 0x000fe400078e003bULL, 0x000000ffff207224ULL, 0x000fe400078e003cULL,
0x000000ffff217224ULL, 0x000fc400078e003dULL, 0x0000000000107805ULL, 0x006fca0000015200ULL,
0x00000400750d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011413ULL,
0x000000120d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x000000020d0d7819ULL, 0x000fc80000001212ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400750d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000403227824ULL, 0x000fe200078e00ffULL, 0x000000080500720cULL, 0x000fc80003f06070ULL,
0xfffffff0220d7812ULL, 0x000fca00078ec0ffULL, 0x000000800c0d7824ULL, 0x000fca00078e020dULL,
0x00f400000d107984ULL, 0x0002a20000000c00ULL, 0x0000136000008947ULL, 0x000fea0003800000ULL,
0x00000100050f7824ULL, 0x000fe200078e0276ULL, 0x00000000030e7211ULL, 0x040fe200078ff0ffULL,
0x00000002033c7824ULL, 0x000fe400078e00ffULL, 0x00000002ff4e7424ULL, 0x000fe200078e00ffULL,
0x0000000f0a3e7217ULL, 0x000fe40007800000ULL, 0x000000063c3c7812ULL, 0x000fe400078ec0ffULL,
0x000000080e147810ULL, 0x000fe20007ffe0ffULL, 0x000000013e3e7824ULL, 0x000fe200078e0a0fULL,
0x00005a00ff0f7a19ULL, 0x000fe2000001160eULL, 0x0000000107157824ULL, 0x000fe200078e023cULL,
0x000058003c3b7a10ULL, 0x000fc40007ffe0ffULL, 0x0000000f740e7217ULL, 0x000fe40003800000ULL,
0x0000003e1500720cULL, 0x040fe20003f26070ULL, 0x0000000115157824ULL, 0x100fe200078e0a3eULL,
0x000000103c3f7812ULL, 0x000fe200078efcffULL, 0x000000013b0f7824ULL, 0x000fe200078e0a3eULL,
0x00005a00ff177a19ULL, 0x000fe20000011614ULL, 0x0000000e0b597224ULL, 0x000fe200078e02ffULL,
0x0000001574157217ULL, 0x000fe40003800000ULL, 0x0000003e3b00720cULL, 0x000fc40003f06070ULL,
0x0000000f740f7217ULL, 0x040fe40003800000ULL, 0x00000004ff157819ULL, 0x000fe40000011615ULL,
0x000058003f437a10ULL, 0x000fe40007ffe0ffULL, 0x0000001774147217ULL, 0x000fe40003800000ULL,
0x000000ff0f417207ULL, 0x000fe40000000000ULL, 0x000000ff150e7207ULL, 0x000fe20000800000ULL,
0x0000000107497824ULL, 0x000fe200078e023fULL, 0x0000005941197211ULL, 0x000fe200078fe0ffULL,
0x0000000143477824ULL, 0x000fc400078e0a3eULL, 0x000000140b577224ULL, 0x000fe400078e02ffULL,
0x0000000159177824ULL, 0x000fe200078e020eULL, 0x0000004774447217ULL, 0x000fe20003800000ULL,
0x00000001494b7824ULL, 0x000fe200078e0a3eULL, 0x0000005741157211ULL, 0x000fe200078fe0ffULL,
0x0000600019187625ULL, 0x000fe200078e004eULL, 0x000000203c477812ULL, 0x000fc600078efcffULL,
0x0000600017167625ULL, 0x000fe200078e004eULL, 0x0000004b744b7217ULL, 0x000fe20003800000ULL,
0x0000000818407981ULL, 0x000722000c1e9500ULL, 0x0000003e4300720cULL, 0x080fe40003f06070ULL,
0x0000003e4900720cULL, 0x000fe20003f26070ULL, 0x00000008163d7981ULL, 0x000322000c1e9500ULL,
0x0000580047497a10ULL, 0x000fe20007ffe0ffULL, 0x0000600015147625ULL, 0x000fe200078e004eULL,
0x00000004ff4b7819ULL, 0x000fe4000001164bULL, 0x000000ff44447207ULL, 0x000fe20000000000ULL,
0x000000010e0f7824ULL, 0x000fe200078e0257ULL, 0x0000000814427981ULL, 0x000522000c1e9500ULL,
0x00000001494f7824ULL, 0x000fc400078e0a3eULL, 0x000060000f0e7625ULL, 0x000fe200078e004eULL,
0x000000ff4b167207ULL, 0x002fe40000800000ULL, 0x0000003e4900720cULL, 0x000fe20003f06070ULL,
0x0000000107517824ULL, 0x000fe200078e0247ULL, 0x0000005944157211ULL, 0x004fe200078fe0ffULL,
0x000000080e457981ULL, 0x0002a2000c1e9500ULL, 0x0000004f744f7217ULL, 0x000fe20003800000ULL,
0x0000000159177824ULL, 0x000fe400078e0216ULL, 0x0000000151537824ULL, 0x000fe200078e0a3eULL,
0x000000ff4f507207ULL, 0x000fe20000000000ULL, 0x00006000150e7625ULL, 0x002fe200078e004eULL,
0x000000303c4f7812ULL, 0x000fc600078efcffULL, 0x0000600017147625ULL, 0x000fe200078e004eULL,
0x0000005744177211ULL, 0x000fe200078fe0ffULL, 0x000000080e467981ULL, 0x0002a2000c1e9500ULL,
0x0000005374537217ULL, 0x000fe20003800000ULL, 0x0000000116197824ULL, 0x008fe200078e0257ULL,
0x0000003e5100720cULL, 0x000fe20003f26070ULL, 0x00000001075b7824ULL, 0x000fe200078e024fULL,
0x00000004ff537819ULL, 0x000fe20000011653ULL, 0x0000600017167625ULL, 0x000fe200078e004eULL,
0x00000008144b7981ULL, 0x0006a2000c1e9500ULL, 0x00000059500f7211ULL, 0x002fc400078fe0ffULL,
0x0000600019187625ULL, 0x080fe200078e004eULL, 0x000058004f517a10ULL, 0x000fe20007ffe0ffULL,
0x0000000816487981ULL, 0x0002a4000c1e9500ULL, 0x000060000f0e7625ULL, 0x000fe200078e004eULL,
0x000000ff534c7207ULL, 0x000fe20000800000ULL, 0x00000008184d7981ULL, 0x0002a4000c1e9500ULL,
0x000000015b5d7824ULL, 0x000fe400078e0a3eULL, 0x000000080e4a7981ULL, 0x0002a2000c1e9500ULL,
0x0000000159157824ULL, 0x008fe200078e024cULL, 0x0000005750177211ULL, 0x002fc400078fe0ffULL,
0x0000005d745d7217ULL, 0x000fe20003800000ULL, 0x000000014c197824ULL, 0x000fe400078e0257ULL,
0x00000001510f7824ULL, 0x040fe200078e0a3eULL, 0x0000003e5100720cULL, 0x000fe20003f06070ULL,
0x0000600015147625ULL, 0x000fe200078e004eULL, 0x0000003e5b00720cULL, 0x000fe40003f26070ULL,
0x0000000f740f7217ULL, 0x000fe20003800000ULL, 0x0000600017167625ULL, 0x080fe200078e004eULL,
0x00000004ff5d7819ULL, 0x000fe2000001165dULL, 0x0000000814537981ULL, 0x0002e4000c1e9500ULL,
0x0000600019187625ULL, 0x000fe200078e004eULL, 0x000000ff0f527207ULL, 0x000fe20000000000ULL,
0x00000008164c7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff5d547207ULL, 0x000fc60000800000ULL,
0x0000000818557981ULL, 0x0002e2000c1e9500ULL, 0x00000059520f7211ULL, 0x000fe200078fe0ffULL,
0x0000000159157824ULL, 0x002fc800078e0254ULL, 0x000060000f0e7625ULL, 0x000fc800078e004eULL,
0x0000600015147625ULL, 0x000fe400078e004eULL, 0x000000080e0e7981ULL, 0x0002e2000c1e9500ULL,
0x0000005752177211ULL, 0x000fc600078fe0ffULL, 0x0000000814157981ULL, 0x0002e2000c1e9500ULL,
0x0000000154197824ULL, 0x000fe400078e0257ULL, 0x0000600017167625ULL, 0x000fc800078e004eULL,
0x0000600019187625ULL, 0x000fe400078e004eULL, 0x0000000816167981ULL, 0x0002e8000c1e9500ULL,
0x0000000818577981ULL, 0x0002e4000c1e9500ULL, 0xfffffff041147812ULL, 0x002fe400078ec0ffULL,
0x000000013c6f7812ULL, 0x000fc400078efcffULL, 0x000000083c6d7812ULL, 0x000fe200078efcffULL,
0x000000013e147824ULL, 0x000fe200078e0214ULL, 0x000000093c6b7812ULL, 0x000fe200078efcffULL,
0x00000001ff4e7424ULL, 0x000fe200078e00ffULL, 0x000058006f797a10ULL, 0x000fe20007ffe0ffULL,
0x000000013b187824ULL, 0x100fe200078e0a14ULL, 0x000058006d737a10ULL, 0x000fe40007ffe0ffULL,
0x000058006b717a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff044547812ULL, 0x000fe200078ec0ffULL,
0x0000000179447824ULL, 0x100fe200078e0a14ULL, 0xfffffff050567812ULL, 0x000fe200078ec0ffULL,
0x0000000173507824ULL, 0x100fe200078e0a14ULL, 0xfffffff052627812ULL, 0x000fe200078ec0ffULL,
0x0000000171527824ULL, 0x000fe200078e0a14ULL, 0x000000184e147219ULL, 0x000fc400000006ffULL,
0x000000183c617812ULL, 0x000fe400078efcffULL, 0x000000504e187219ULL, 0x040fe400000006ffULL,
0x000000524e507219ULL, 0x000fe200000006ffULL, 0x000000013e547824ULL, 0x000fe200078e0254ULL,
0x0000580061677a10ULL, 0x000fc60007ffe0ffULL, 0x00000001435e7824ULL, 0x100fe400078e0a54ULL,
0x0000000167607824ULL, 0x000fe200078e0a54ULL, 0x000000113c637812ULL, 0x040fe400078efcffULL,
0x000000193c5f7812ULL, 0x000fe400078efcffULL, 0x000000444e447219ULL, 0x040fe400000006ffULL,
0x0000005e4e5e7219ULL, 0x040fe400000006ffULL, 0x000000604e607219ULL, 0x000fe200000006ffULL,
0x000000013e567824ULL, 0x000fe200078e0256ULL, 0x0000580063697a10ULL, 0x000fc40007ffe0ffULL,
0x000058005f657a10ULL, 0x000fe20007ffe0ffULL, 0x0000000149667824ULL, 0x000fe400078e0a56ULL,
0x00000001695c7824ULL, 0x100fe400078e0a54ULL, 0x0000000165647824ULL, 0x000fe200078e0a54ULL,
0x000000213c5d7812ULL, 0x040fe400078efcffULL, 0x000000283c5b7812ULL, 0x040fe400078efcffULL,
0x000000293c597812ULL, 0x000fc400078efcffULL, 0x0000005c4e5c7219ULL, 0x040fe400000006ffULL,
0x000000644e647219ULL, 0x040fe400000006ffULL, 0x000000664e667219ULL, 0x000fe200000006ffULL,
0x000000013e627824ULL, 0x000fe200078e0262ULL, 0x000058005d7d7a10ULL, 0x000fe40007ffe0ffULL,
0x000058005b7b7a10ULL, 0x000fe40007ffe0ffULL, 0x0000580059417a10ULL, 0x000fe20007ffe0ffULL,
0x000000017d687824ULL, 0x000fc400078e0a56ULL, 0x000000017b6a7824ULL, 0x100fe400078e0a56ULL,
0x00000001416c7824ULL, 0x000fe400078e0a56ULL, 0x00000001516e7824ULL, 0x000fe200078e0a62ULL,
0x000000313c197812ULL, 0x040fe400078efcffULL, 0x000000383c177812ULL, 0x040fe400078efcffULL,
0x000000393c0f7812ULL, 0x000fe400078efcffULL, 0x000000684e687219ULL, 0x000fc400000006ffULL,
0x0000006a4e6a7219ULL, 0x040fe400000006ffULL, 0x0000006c4e6c7219ULL, 0x040fe400000006ffULL,
0x0000006e4e6e7219ULL, 0x000fe400000006ffULL, 0x0000580019527a10ULL, 0x000fe40007ffe0ffULL,
0x0000580017547a10ULL, 0x000fe40007ffe0ffULL, 0x000058000f567a10ULL, 0x000fe20007ffe0ffULL,
0x0000000152587824ULL, 0x000fc400078e0a62ULL, 0x00000001545a7824ULL, 0x100fe400078e0a62ULL,
0x0000000156627824ULL, 0x000fe200078e0a62ULL, 0x000000584e587219ULL, 0x040fe400000006ffULL,
0x0000005a4e5a7219ULL, 0x040fe400000006ffULL, 0x000000624e627219ULL, 0x000fe400000006ffULL,
0x00005410403d7816ULL, 0x010fc8000000003dULL, 0x0000003d14ff7212ULL, 0x000fc8000780c0ffULL,
0x0000003e3b00720cULL, 0x000fc80000701470ULL, 0x0000003e3c00720cULL, 0x000fe40000701070ULL,
0x0000541042457816ULL, 0x004fe40000000045ULL, 0xff80000025257808ULL, 0x000fe40000000000ULL,
0x0000004514ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004518ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004550ff7212ULL, 0x000fc4000780c0ffULL, 0x0000003e3b00720cULL, 0x080fe40002781470ULL,
0x0000003e7300720cULL, 0x080fe400037c1470ULL, 0x0000003e7100720cULL, 0x080fe40000701470ULL,
0x0000003d50ff7212ULL, 0x000fe4000782c0ffULL, 0x0000003e3c00720cULL, 0x080fe40002781070ULL,
0x0000003e6d00720cULL, 0x000fc400037c1070ULL, 0x0000003e6b00720cULL, 0x080fe40000701070ULL,
0x00005410464b7816ULL, 0x000fe4000000004bULL, 0x0000003e7100720cULL, 0x000fe40000f21470ULL,
0xff80000026267808ULL, 0x000fe40002000000ULL, 0xff80000027277808ULL, 0x000fe40003000000ULL,
0x00005410484d7816ULL, 0x000fc4000000004dULL, 0xff80000033337808ULL, 0x000fe40000000000ULL,
0x0000003d44ff7212ULL, 0x080fe4000786c0ffULL, 0x0000003d18ff7212ULL, 0x000fe4000784c0ffULL,
0x0000004544ff7212ULL, 0x000fe400078ac0ffULL, 0x0000004b5eff7212ULL, 0x040fe4000788c0ffULL,
0x0000004d5eff7212ULL, 0x000fc400078cc0ffULL, 0x0000004d60ff7212ULL, 0x000fe4000780c0ffULL,
0x0000003e6b00720cULL, 0x080fe40000f21070ULL, 0x0000003e7900720cULL, 0x0c0fe40001f61470ULL,
0x0000003e7900720cULL, 0x080fe40002fa1470ULL, 0x0000003e7300720cULL, 0x080fe40001741470ULL,
0x0000003e4300720cULL, 0x000fc40002781470ULL, 0x0000003e4300720cULL, 0x080fe400037c1470ULL,
0x0000003e6700720cULL, 0x080fe40000701470ULL, 0xff80000035357808ULL, 0x000fe40000800000ULL,
0x0000003e6f00720cULL, 0x0c0fe40001f61070ULL, 0x0000003e6f00720cULL, 0x080fe40002fa1070ULL,
0x0000003e6d00720cULL, 0x000fc40001741070ULL, 0x0000003e3f00720cULL, 0x0c0fe40002721070ULL,
0x0000003e3f00720cULL, 0x080fe400037c1070ULL, 0x0000003e6100720cULL, 0x000fe40000701070ULL,
0x000054104a537816ULL, 0x008fe40000000053ULL, 0x000054104c557816ULL, 0x000fe40000000055ULL,
0xff8000002c2c7808ULL, 0x000fc40001800000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0xff8000002d2d7808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40000800000ULL,
0xff80000029297808ULL, 0x000fe40003000000ULL, 0xff8000002a2a7808ULL, 0x000fe40000000000ULL,
0x0000004b5cff7212ULL, 0x000fc4000786c0ffULL, 0x0000004b60ff7212ULL, 0x080fe400078ac0ffULL,
0x0000004b64ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004d5cff7212ULL, 0x080fe4000788c0ffULL,
0x0000004d64ff7212ULL, 0x000fe4000782c0ffULL, 0x0000005366ff7212ULL, 0x040fe400078cc0ffULL,
0x0000005566ff7212ULL, 0x000fc4000780c0ffULL, 0x0000003e6900720cULL, 0x0c0fe40001f61470ULL,
0x0000003e6900720cULL, 0x080fe40002781470ULL, 0x0000003e6700720cULL, 0x080fe40002fa1470ULL,
0x0000003e6500720cULL, 0x0c0fe40001741470ULL, 0x0000003e6500720cULL, 0x080fe40000f21470ULL,
0x0000003e4900720cULL, 0x000fc400037c1470ULL, 0x0000003e4900720cULL, 0x080fe40000701470ULL,
0x0000003e6300720cULL, 0x0c0fe40001f61070ULL, 0x0000003e6300720cULL, 0x080fe40002781070ULL,
0x0000003e6100720cULL, 0x080fe40002fa1070ULL, 0x0000003e5f00720cULL, 0x0c0fe40001741070ULL,
0x0000003e5f00720cULL, 0x000fc40000f21070ULL, 0x0000003e4700720cULL, 0x0c0fe400037c1070ULL,
0x0000003e4700720cULL, 0x000fe40000701070ULL, 0x000054100e157816ULL, 0x000fe40000000015ULL,
0xff8000002f2f7808ULL, 0x000fe40001800000ULL, 0xff80000028287808ULL, 0x000fe40002000000ULL,
0xff80000030307808ULL, 0x000fc40002800000ULL, 0xff8000003a3a7808ULL, 0x000fe40001000000ULL,
0xff80000039397808ULL, 0x000fe40000800000ULL, 0xff80000038387808ULL, 0x000fe40003000000ULL,
0xff8000001b1b7808ULL, 0x000fe40000000000ULL, 0x0000005368ff7212ULL, 0x080fe4000786c0ffULL,
0x000000536aff7212ULL, 0x000fc4000788c0ffULL, 0x000000536cff7212ULL, 0x000fe400078ac0ffULL,
0x0000005568ff7212ULL, 0x080fe4000784c0ffULL, 0x000000556aff7212ULL, 0x080fe4000782c0ffULL,
0x000000556cff7212ULL, 0x000fe400078cc0ffULL, 0x000000156eff7212ULL, 0x000fe4000780c0ffULL,
0x0000003e7d00720cULL, 0x000fc40001f61470ULL, 0x0000003e7d00720cULL, 0x080fe40001741470ULL,
0x0000003e7b00720cULL, 0x0c0fe40002781470ULL, 0x0000003e7b00720cULL, 0x080fe40000f21470ULL,
0x0000003e4100720cULL, 0x0c0fe40002fa1470ULL, 0x0000003e4100720cULL, 0x080fe400037c1470ULL,
0x0000003e5100720cULL, 0x000fc40000701470ULL, 0x0000003e5d00720cULL, 0x0c0fe40001f61070ULL,
0x0000003e5d00720cULL, 0x080fe40001741070ULL, 0x0000003e5b00720cULL, 0x0c0fe40002781070ULL,
0x0000003e5b00720cULL, 0x080fe40000f21070ULL, 0x0000003e5900720cULL, 0x0c0fe40002fa1070ULL,
0x0000003e5900720cULL, 0x000fc400037c1070ULL, 0x0000003e4f00720cULL, 0x000fe40000701070ULL,
0x0000541016577816ULL, 0x000fe40000000057ULL, 0xff80000031317808ULL, 0x000fe40001800000ULL,
0xff8000001a1a7808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40002000000ULL,
0xff8000001c1c7808ULL, 0x000fc40000800000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0xff80000023237808ULL, 0x000fe40003000000ULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0x0000001558ff7212ULL, 0x080fe4000786c0ffULL, 0x000000155aff7212ULL, 0x080fe4000784c0ffULL,
0x0000001562ff7212ULL, 0x000fc4000788c0ffULL, 0x000000576eff7212ULL, 0x080fe4000782c0ffULL,
0x0000005758ff7212ULL, 0x080fe400078ac0ffULL, 0x000000575aff7212ULL, 0x080fe400078cc0ffULL,
0x0000005762ff7212ULL, 0x000fe4000780c0ffULL, 0x0000003e5100720cULL, 0x080fe40000f21470ULL,
0x0000003e5200720cULL, 0x000fc40001f61470ULL, 0x0000003e5200720cULL, 0x080fe40002fa1470ULL,
0x0000003e5400720cULL, 0x0c0fe40001741470ULL, 0x0000003e5400720cULL, 0x080fe400037c1470ULL,
0x0000003e5600720cULL, 0x0c0fe40002781470ULL, 0x0000003e5600720cULL, 0x080fe40000701470ULL,
0x0000003e4f00720cULL, 0x000fc40000f21070ULL, 0x0000003e1900720cULL, 0x0c0fe40001f61070ULL,
0x0000003e1900720cULL, 0x080fe40002fa1070ULL, 0x0000003e1700720cULL, 0x0c0fe40001741070ULL,
0x0000003e1700720cULL, 0x080fe400037c1070ULL, 0x0000003e0f00720cULL, 0x0c0fe40002781070ULL,
0x0000003e0f00720cULL, 0x000fc40000701070ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff8000001d1d7808ULL, 0x000fe40002000000ULL,
0xff8000001e1e7808ULL, 0x000fe40000800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002800000ULL,
0xff80000020207808ULL, 0x000fc40003000000ULL, 0xff80000021217808ULL, 0x000fc40000000000ULL,
0x000000251000720bULL, 0x004fe20003f1e000ULL, 0x0000001fff197424ULL, 0x000fe200078e00ffULL,
0x000000261100720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x00000010250f7208ULL, 0x000fe40004000000ULL, 0x0000001126117208ULL, 0x000fe40004800000ULL,
0x0000002c0f00720bULL, 0x000fe40003f1e000ULL, 0x000000241100720bULL, 0x000fc40003f3e000ULL,
0x0000000f2c0e7208ULL, 0x000fe40004000000ULL, 0x0000001124107208ULL, 0x000fe40004800000ULL,
0x0000002d0e00720bULL, 0x000fe40003f1e000ULL, 0x000000271000720bULL, 0x000fe40003f3e000ULL,
0x0000000e2d0e7208ULL, 0x000fe40004000000ULL, 0x0000001027107208ULL, 0x000fc40004800000ULL,
0x000000350e00720bULL, 0x000fe40003f1e000ULL, 0x000000331000720bULL, 0x000fe40003f3e000ULL,
0x0000000e350f7208ULL, 0x000fe40004000000ULL, 0x0000001033107208ULL, 0x000fe40004800000ULL,
0x0000002e0f00720bULL, 0x000fe40003f1e000ULL, 0x000000291000720bULL, 0x000fc40003f3e000ULL,
0x0000000f2e0e7208ULL, 0x000fe40004000000ULL, 0x00000010290f7208ULL, 0x000fe40004800000ULL,
0x0000002f0e00720bULL, 0x000fe40003f1e000ULL, 0x000000280f00720bULL, 0x000fe40003f3e000ULL,
0x0000000e2f117208ULL, 0x000fe40004000000ULL, 0x0000000f280f7208ULL, 0x000fc40004800000ULL,
0x000000301100720bULL, 0x000fe40003f1e000ULL, 0x0000002a0f00720bULL, 0x000fe40003f3e000ULL,
0x0000001130117208ULL, 0x000fe40004000000ULL, 0x0000000f2a0e7208ULL, 0x000fe40004800000ULL,
0x0000003a1100720bULL, 0x000fe40003f1e000ULL, 0x000000390e00720bULL, 0x000fc40003f3e000ULL,
0x000000113a117208ULL, 0x000fe40004000000ULL, 0x0000000e390e7208ULL, 0x000fe40004800000ULL,
0x000000381100720bULL, 0x000fe40003f1e000ULL, 0x0000001b0e00720bULL, 0x000fe40003f3e000ULL,
0x0000001138107208ULL, 0x000fe40004000000ULL, 0x0000000e1b0f7208ULL, 0x000fc40004800000ULL,
0x000000311000720bULL, 0x000fe40003f1e000ULL, 0x0000001a0f00720bULL, 0x000fe40003f3e000ULL,
0x0000001031117208ULL, 0x000fe40004000000ULL, 0x0000000f1a0f7208ULL, 0x000fe40004800000ULL,
0x000000321100720bULL, 0x000fe40003f1e000ULL, 0x0000001c0f00720bULL, 0x000fc40003f3e000ULL,
0x00000011320e7208ULL, 0x000fe40004000000ULL, 0x0000000f1c107208ULL, 0x000fe40004800000ULL,
0x000000370e00720bULL, 0x000fe40003f1e000ULL, 0x000000231000720bULL, 0x000fe40003f3e000ULL,
0x0000000e370f7208ULL, 0x000fe40004000000ULL, 0x0000001023117208ULL, 0x000fc40004800000ULL,
0x000000360f00720bULL, 0x000fe40003f1e000ULL, 0x0000001e1100720bULL, 0x000fe40003f3e000ULL,
0x0000000f360f7208ULL, 0x000fe40004000000ULL, 0x000000111e0e7208ULL, 0x000fe40004800000ULL,
0x000000340f00720bULL, 0x000fe40003f1e000ULL, 0x0000001f0e00720bULL, 0x000fc40003f3e000ULL,
0x0000000f34107208ULL, 0x000fe40004000000ULL, 0x0000000e1f0f7208ULL, 0x000fe40004800000ULL,
0x0000002b1000720bULL, 0x000fe40003f1e000ULL, 0x000000200f00720bULL, 0x000fe40003f3e000ULL,
0x000000102b107208ULL, 0x000fe40004000000ULL, 0x0000000f200e7208ULL, 0x000fc40004800000ULL,
0x0000001d1000720bULL, 0x000fe40003f1e000ULL, 0x000000210e00720bULL, 0x000fe40003f3e000ULL,
0x000000101d167208ULL, 0x000fe40004000000ULL, 0x0000000e21187208ULL, 0x000fe20004800000ULL,
0x000014927f007947ULL, 0x000fec000b800000ULL, 0x0c401f00160e7f89ULL, 0x0004e400000e0000ULL,
0x0000000e1600720bULL, 0x008fc80003f1e000ULL, 0x000000160e3c7208ULL, 0x000fe20004000000ULL,
0x000014a27f007947ULL, 0x000fea000b800000ULL, 0x0c401f00180e7f89ULL, 0x000ee800000e0000ULL,
0x0c401f00120f7f89ULL, 0x000f2800000e0000ULL, 0x0c401f0013107f89ULL, 0x000e6800000e0000ULL,
0x0c201f003c117f89ULL, 0x000ea200000e0000ULL, 0x0000000e1800720bULL, 0x008fc40003f1e000ULL,
0x0000000f1200720bULL, 0x010fe40003f3e000ULL, 0x000000180e147208ULL, 0x000fe40004000000ULL,
0x000000120f157208ULL, 0x000fe40004800000ULL, 0x000000101300720bULL, 0x002fe20003f1e000ULL,
0x0c201f0014177f89ULL, 0x000e6600000e0000ULL, 0x00000013100e7208ULL, 0x000fe20004000000ULL,
0x0c201f0015167f89ULL, 0x004ea200000e0000ULL, 0x000000113c00720bULL, 0x000fc60003f1e000ULL,
0x0c201f000e0f7f89ULL, 0x0006e200000e0000ULL, 0x0000003c11107208ULL, 0x000fe40004000000ULL,
0x000000171400720bULL, 0x002fe40003f3e000ULL, 0x000000161500720bULL, 0x004fe40003f5e000ULL,
0x0000001417117208ULL, 0x000fe40004800000ULL, 0x0000001516127208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b103b7820ULL, 0x008fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000c22227812ULL, 0x000fc400078ec0ffULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001083bULL, 0x0000002e003c7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b34137823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001083bULL, 0x0000002500147308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b2e7823ULL, 0x108fe2000001083bULL, 0x3fb8aa3b112b7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001083bULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001083bULL,
0x3fb8aa3b1d1d7823ULL, 0x000fe2000001083bULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001082bULL, 0x0000002c00157308ULL, 0x0007220000000800ULL,
0x3fb8aa3b28197823ULL, 0x102fe2000001082bULL, 0x00000004ff287e24ULL, 0x000fe2000f8e00ffULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001082bULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3f8000002828783eULL, 0x000fe200000010ffULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x000fe2000001082bULL, 0x3fb8aa3b362c7823ULL, 0x008fe2000001083bULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001082bULL, 0x000000ffff3d7224ULL, 0x000fe200078e0028ULL,
0x3fb8aa3b21217823ULL, 0x000fe2000001082bULL, 0x0000000303ff7812ULL, 0x000fc4000780c0ffULL,
0x0000002400177308ULL, 0x000e620000000800ULL, 0x000000141514723eULL, 0x010fe400000010ffULL,
0x0000000f0e00720bULL, 0x004fca0003f3e000ULL, 0x0000002d00167308ULL, 0x000ff00000000800ULL,
0x0000003500357308ULL, 0x000ea20000000800ULL, 0x000000261715723eULL, 0x002fce00000010ffULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000003300187308ULL, 0x000e620000000800ULL,
0x000000163516723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b1a357823ULL, 0x000fcc000001082bULL,
0x00000029002d7308ULL, 0x0005e20000000800ULL, 0x000000271817723eULL, 0x002fe200000010ffULL,
0x000000ffff297224ULL, 0x004fcc00078e0028ULL, 0x0000001900347308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b1b277823ULL, 0x000fce000001082bULL, 0x0000002f002f7308ULL, 0x000ea20000000800ULL,
0x000000281418723cULL, 0x002f6e00000418ffULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000003a00257308ULL, 0x0002e20000000800ULL, 0x0000003c2f24723eULL, 0x004fe200000010ffULL,
0x000000ffff3c7224ULL, 0x000fcc00078e0028ULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b233a7823ULL, 0x002fce000001082bULL, 0x0000003900397308ULL, 0x000e620000000800ULL,
0x000000302526723eULL, 0x008fe400000010ffULL, 0x0000002d3425723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b1f2d7823ULL, 0x000fe2000001082bULL, 0x00000002ff347819ULL, 0x000fc60000011603ULL,
0x0000002700337308ULL, 0x0003e20000000800ULL, 0x00000003342f7810ULL, 0x040fe20007ffe0ffULL,
0x00000008341f7824ULL, 0x040fe200078e00ffULL, 0x0000000434307810ULL, 0x040fe20007ffe0ffULL,
0x00000008343b7824ULL, 0x000fc800078e00ffULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x0000002a3927723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b1e2a7823ULL, 0x000fe2000001082bULL,
0x000000ffff397224ULL, 0x000fca00078e0028ULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x0000003c2418723cULL, 0x020b6e0000041818ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x00000008343d7810ULL, 0x020fce0007ffe0ffULL, 0x0000003700377308ULL, 0x000e700000000800ULL,
0x0000003500367308ULL, 0x0005f00000000800ULL, 0x0000001c00297308ULL, 0x0007e20000000800ULL,
0x00000032371e723eULL, 0x002fe200000010ffULL, 0x0000000834327824ULL, 0x000fc400078e00ffULL,
0x0000000834357824ULL, 0x004fc800078e00ffULL, 0x0000003a003a7308ULL, 0x000e620000000800ULL,
0x00000001341c7810ULL, 0x048fe40007ffe0ffULL, 0xfffffff835357812ULL, 0x000fe400078ee230ULL,
0xfffffff81f2b7812ULL, 0x000fe400078ee21cULL, 0x00000038311c723eULL, 0x000fe200000010ffULL,
0x0000001d00237308ULL, 0x0005e20000000800ULL, 0x000000ffff387224ULL, 0x000fe200078e0028ULL,
0x0000000634307810ULL, 0x000fc40007ffe0ffULL, 0x000000293a1f723eULL, 0x002fc800000010ffULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x00000033361d723eULL, 0x004fe200000010ffULL,
0x0000000834367824ULL, 0x040fe200078e00ffULL, 0x0000000234297810ULL, 0x000fc80007ffe0ffULL,
0xfffffff836337812ULL, 0x000fe200078ee22fULL, 0x000000381c18723cULL, 0x000b620000041818ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x00000005342f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff832317812ULL, 0x000fe200078ee229ULL, 0x0000000834297824ULL, 0x000fe200078e00ffULL,
0xfffffff836377812ULL, 0x000fe200078ee22fULL, 0x0000000834397824ULL, 0x060fe200078e00ffULL,
0xffffffff34327810ULL, 0x000fe20007ffe0ffULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0xfffffff829297812ULL, 0x000fe200078ee234ULL, 0x000000083d347824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fc400078ee230ULL, 0x000090000c307811ULL, 0x000fe400078e58ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee232ULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x00000020212f723eULL, 0x002fe200000010ffULL, 0x000000ffff207224ULL, 0x100fe200078e0028ULL,
0xfffffff8343d7812ULL, 0x000fe200078ee23dULL, 0x000000ffff217224ULL, 0x000fe400078e0028ULL,
0x0000001029297824ULL, 0x100fe400078e0230ULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x000000102b2b7824ULL, 0x000fc400078e0230ULL, 0x0000001031317824ULL, 0x100fe400078e0230ULL,
0x0000001033337824ULL, 0x100fe400078e0230ULL, 0x0000001035357824ULL, 0x000fe200078e0230ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x0000002c132c723eULL, 0x004fe200000010ffULL,
0x0000000129297824ULL, 0x000fe200078e0222ULL, 0x0000000e0f137208ULL, 0x000fe20004800000ULL,
0x0000001037377824ULL, 0x100fe400078e0230ULL, 0x00000001222b7824ULL, 0x040fe200078e022bULL,
0x0000001429007388ULL, 0x0005e20000000800ULL, 0x0000002d002d7308ULL, 0x000ee20000000800ULL,
0x0000002e232e723eULL, 0x002fe200000010ffULL, 0x0000001039397824ULL, 0x000fe200078e0230ULL,
0x000000162b007388ULL, 0x0005e20000000800ULL, 0x0000000122317824ULL, 0x000fc400078e0231ULL,
0x000000103b3b7824ULL, 0x100fe400078e0230ULL, 0x0000000122337824ULL, 0x040fe200078e0233ULL,
0x0000002431007388ULL, 0x0005e20000000800ULL, 0x000000103d3d7824ULL, 0x000fe400078e0230ULL,
0x0000000122357824ULL, 0x040fe200078e0235ULL, 0x0000002633007388ULL, 0x0005e20000000800ULL,
0x0000000122377824ULL, 0x040fe200078e0237ULL, 0x0000002a2d2d723eULL, 0x008fe200000010ffULL,
0x0000000122397824ULL, 0x040fe200078e0239ULL, 0x0000001c35007388ULL, 0x0005e20000000800ULL,
0x00000001223b7824ULL, 0x000fc400078e023bULL, 0x0000000122227824ULL, 0x000fe200078e023dULL,
0x0000001e37007388ULL, 0x0005e20000000800ULL, 0x000000202c18723cULL, 0x000f660000041818ULL,
0x0000002c39007388ULL, 0x0005e80000000800ULL, 0x0000002e3b007388ULL, 0x0005e80000000800ULL,
0x0000001522007388ULL, 0x0005e80000000800ULL, 0x000400172b007388ULL, 0x0005e80000000800ULL,
0x0004002531007388ULL, 0x0005e80000000800ULL, 0x0004002733007388ULL, 0x0005e20000000800ULL,
0x000000ffff197224ULL, 0x020fc600078e001aULL, 0x0004001d35007388ULL, 0x0005e80000000800ULL,
0x0004001f37007388ULL, 0x0005e80000000800ULL, 0x0004002d39007388ULL, 0x0005e80000000800ULL,
0x0004002f3b007388ULL, 0x0005e80000000800ULL, 0x00f000100d008388ULL, 0x0005e80000000c00ULL,
0x00f200180d008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000077ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080077ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100077ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000105057810ULL, 0x000fe20007ffe0ffULL, 0x0000180077ff7f8cULL, 0x0003e6000c80043fULL,
0x000000090500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffaea000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff117807ULL, 0x008fe40004000000ULL, 0x0001457000187802ULL, 0x000fc40000000f00ULL,
0x00000bc000007944ULL, 0x002fea0003c00000ULL, 0xfffede5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40005000000ULL, 0x000145b000187802ULL, 0x000fc40000000f00ULL,
0x00000b8000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0011ULL,
0xfffedeb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0012ULL,
0x0001460000197802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x002fea0003c00000ULL,
0xfffedf9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0012ULL,
0x0001464000197802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x002fea0003c00000ULL,
0xfffee0b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0000ULL,
0x0001469000197802ULL, 0x000fe20000000f00ULL, 0x000000ffff117224ULL, 0x000fc400078e000fULL,
0x00000a5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e0011ULL,
0xfffee4c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0000ULL,
0x000146e000197802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0011ULL, 0xfffee4a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x008fe40004000000ULL, 0x0001473000187802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x002fea0003c00000ULL, 0xffff0b6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40005000000ULL, 0x0001477000187802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0011ULL,
0xffff0ba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0039ULL,
0x000147c000197802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x002fea0003c00000ULL,
0xffff0c8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0039ULL,
0x0001480000197802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x002fea0003c00000ULL,
0xffff0da000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e000fULL,
0x0001485000197802ULL, 0x000fe20000000f00ULL, 0x000000ffff117224ULL, 0x000fc400078e0010ULL,
0x0000089000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e0011ULL,
0xffff11c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e000fULL,
0x000148a000197802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0011ULL, 0xffff11a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x008fe40004000000ULL, 0x000148f000187802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x002fea0003c00000ULL, 0xffff381000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40005000000ULL, 0x0001493000187802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x000fe200078e0011ULL,
0xffff386000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0037ULL,
0x0001498000197802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x002fea0003c00000ULL,
0xffff395000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0037ULL,
0x000149c000197802ULL, 0x000fc40000000f00ULL, 0x0000072000007944ULL, 0x002fea0003c00000ULL,
0xffff3a7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e000dULL,
0x00014a1000197802ULL, 0x000fe20000000f00ULL, 0x000000ffff117224ULL, 0x000fc400078e0012ULL,
0x000006d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e0011ULL,
0xffff3e9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e000dULL,
0x00014a6000197802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0011ULL, 0xffff3e7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x004fe40004000000ULL, 0x00014ab000187802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x008fea0003c00000ULL, 0xffff641000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40005000000ULL, 0x00014af000187802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff397224ULL, 0x000fe200078e0011ULL,
0xffff646000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0005ULL,
0x00014b4000197802ULL, 0x000fc40000000f00ULL, 0x000005a000007944ULL, 0x000fea0003c00000ULL,
0xffff654000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0005ULL,
0x00014b8000197802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x002fea0003c00000ULL,
0xffff666000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0013ULL,
0x00014bd000197802ULL, 0x000fe20000000f00ULL, 0x000000ffff117224ULL, 0x000fc400078e001aULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e0011ULL,
0xffff6ac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff187224ULL, 0x000fe200078e0013ULL,
0x00014c2000197802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0011ULL, 0xffff6aa000007947ULL, 0x000fea000383ffffULL,
0x00000002ff177424ULL, 0x000fe200078e00ffULL, 0x00014c7000147802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e000fULL,
0xffffeb3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x006fe200078e0018ULL,
0x00014cd000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x0000000f1800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e0012ULL, 0x00014d3000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff177424ULL, 0x000fe200078e00ffULL, 0x000000180f187208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000000f1200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e0013ULL, 0x00014d9000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff177424ULL, 0x000fe200078e00ffULL, 0x000000120f127208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000000f1300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e003cULL, 0x00014df000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x000000130f0e7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000000f3c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e0018ULL, 0x00014e5000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x0000003c0f107208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000000f1800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e0012ULL, 0x00014eb000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x000000180f117208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000000f1200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff167224ULL, 0x002fe200078e000eULL, 0x00014f1000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x000000120f127208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffea0000007947ULL, 0x000fea000383ffffULL,
0x018000000e007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000e00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0eff7812ULL, 0x040fe4000780c0ffULL, 0x800000000e027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000e00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffeaf6002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff157424ULL, 0x000fe200078e00ffULL, 0x0000003e00007348ULL, 0x000fe80003800000ULL,
0x0c000017160f7389ULL, 0x0002a200000e0019ULL, 0xfffeaf2014007950ULL, 0x000fea0003c3ffffULL,
0x0000007800007348ULL, 0x000fe80003800000ULL, 0x0000001118117389ULL, 0x0002a400000e0079ULL,
0x000000ffff187224ULL, 0x002fc400078e0019ULL, 0x00000000ff197424ULL, 0x000fc800078e00ffULL,
0xfffeaed018007950ULL, 0x000fea0003c3ffffULL, 0x000000011100780cULL, 0x000fe20003f45070ULL,
0x00000000ff197424ULL, 0x000fe200078e00ffULL, 0x0000007700007348ULL, 0x000ff60003800000ULL,
0x0000000000117806ULL, 0x000fc800050e0100ULL, 0x0000007711117212ULL, 0x000fe200078ec0ffULL,
0xfffeae7018007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x00000000000002f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cf0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db0ULL, 0x00000000000007bcULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001570ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001610ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001614ULL, 0x00000000000001b8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000015280ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016a80ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016ad0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016e50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001610ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015470ULL, 0x0000000000015470ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016a80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016e50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_89_cubin_len = 94000;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
