/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016538ULL, 0x00000000000161b8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000020cULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b000100000253ULL, 0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000299ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b000100000383ULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003d1ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000417ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000465ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004c0ULL,
0x0000000000014b30ULL, 0x0000000000000250ULL, 0x0004000300000536ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000014d80ULL,
0x000d000300000566ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00014b3000000000ULL, 0x00010c0400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL,
0x0000002cffffffffULL, 0x0000006000000000ULL, 0x00014b3000000000ULL, 0x0000025000000000ULL,
0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL,
0x0008230400000080ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL,
0x0000001700081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0050000900000000ULL,
0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040021f000ULL, 0x0040000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040061f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000023000942804ULL, 0x00000960000002e0ULL,
0x000026a000002620ULL, 0x000028b000002770ULL, 0x00002dc000002db0ULL, 0x000051c000005150ULL,
0x000053e0000052a0ULL, 0x00005900000058f0ULL, 0x00007ca000007c40ULL, 0x00007ee000007da0ULL,
0x0000832000008310ULL, 0x0000a6a00000a630ULL, 0x0000a8c00000a780ULL, 0x0000ad400000ad30ULL,
0x0000c6200000c610ULL, 0x00013fe000013f30ULL, 0x0001428000014210ULL, 0x0001454000014490ULL,
0x000147c000014660ULL, 0x0000048004303904ULL, 0x00017600000000ffULL, 0x0000056000040100ULL,
0x0001760800000005ULL, 0x00000670003f0100ULL, 0x0001768800000005ULL, 0x00000790003f0100ULL,
0x000176a800000003ULL, 0x000008a0003f0100ULL, 0x000176c800000002ULL, 0x00000e00003f0100ULL,
0x00017600000000ffULL, 0x00000ef000080107ULL, 0x000176880000000dULL, 0x000017b000080101ULL,
0x00000000000000ffULL, 0x000017e000040107ULL, 0x00000000000000ffULL, 0x0000186000040101ULL,
0x0000002000000004ULL, 0x00001930003f0101ULL, 0x000176c800000017ULL, 0x00001ac000080109ULL,
0x000176c800000035ULL, 0x00002310003f0109ULL, 0x000176b000000004ULL, 0x0000238000080107ULL,
0x000176b000000048ULL, 0x00002390003f0101ULL, 0x0001760800000034ULL, 0x000023d0003f0101ULL,
0x000176080000004bULL, 0x00002540003f0109ULL, 0x000176080000004bULL, 0x00002a60003f0109ULL,
0x000176a800000004ULL, 0x00002be000080109ULL, 0x000176a800000034ULL, 0x00004530003f0109ULL,
0x000176c800000035ULL, 0x00004540003f0101ULL, 0x0001768800000036ULL, 0x0000457000080101ULL,
0x0000000000000006ULL, 0x000046e0003f0109ULL, 0x0000000000000006ULL, 0x00004e80003f0109ULL,
0x000176a800000014ULL, 0x00004f0000080107ULL, 0x000176a800000054ULL, 0x00004f10003f0101ULL,
0x0001762800000015ULL, 0x00004f30003f0101ULL, 0x000176280000004bULL, 0x000050a0003f0109ULL,
0x000176280000004bULL, 0x000055b0003f0109ULL, 0x000176b000000017ULL, 0x0000573000080109ULL,
0x000176b000000037ULL, 0x00007020003f0109ULL, 0x000176c800000036ULL, 0x00007030003f0101ULL,
0x0001769000000052ULL, 0x0000706000080101ULL, 0x0000000000000006ULL, 0x000071d0003f0109ULL,
0x0000000000000006ULL, 0x00007930003f0109ULL, 0x00000008000000ffULL, 0x000079a000040107ULL,
0x0000000800000052ULL, 0x000079b0003f0101ULL, 0x000176480000004bULL, 0x00007a20003f0101ULL,
0x000176480000003dULL, 0x00007b90003f0109ULL, 0x000176480000003dULL, 0x000080a0003f0109ULL,
0x000176a800000017ULL, 0x0000822000080109ULL, 0x000176a800000037ULL, 0x000099e0003f0109ULL,
0x0000000000000006ULL, 0x00009a00003f0101ULL, 0x0001769800000036ULL, 0x00009a30003f0101ULL,
0x0000000000000006ULL, 0x00009ba0003f0109ULL, 0x0000000000000006ULL, 0x0000a340003f0109ULL,
0x00000000000000ffULL, 0x0000a3d000040107ULL, 0x000176a800000014ULL, 0x0000a3f0003f0101ULL,
0x0001766800000037ULL, 0x0000a420003f0101ULL, 0x0001766800000037ULL, 0x0000a590003f0109ULL,
0x0001766800000037ULL, 0x0000aa80003f0109ULL, 0x000176b000000017ULL, 0x0000ac2000080109ULL,
0x000176b00000003dULL, 0x0000c390003f0109ULL, 0x0000000000000006ULL, 0x0000c470003f0101ULL,
0x000176a000000000ULL, 0x0000d520003f0101ULL, 0x00017600000000ffULL, 0x0000ed5000080101ULL,
0x00017600000000ffULL, 0x0000eec000080109ULL, 0x00017600000000ffULL, 0x0000f0a000080109ULL,
0x00017600000000ffULL, 0x0000f0c000080101ULL, 0x00017600000000ffULL, 0x0000f23000080109ULL,
0x00017600000000ffULL, 0x0001258000080109ULL, 0x0001768800000005ULL, 0x00012750003f0101ULL,
0x0001768800000005ULL, 0x000128c0003f0109ULL, 0x0001768800000005ULL, 0x00014ad0003f0109ULL,
0x0001760800000006ULL, 0x00014ae0003f0101ULL, 0x0001761000000006ULL, 0x00014af0003f0101ULL,
0x0001761800000006ULL, 0x00014b00003f0101ULL, 0x0001762000000006ULL, 0x00053803003f0101ULL,
0x0000ce8000201c04ULL, 0x0000d0a00000cee0ULL, 0x0000d3900000d200ULL, 0x0000f2600000d490ULL,
0x000c050400014b20ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0058190300000000ULL,
0x0000001800080a04ULL, 0x0000000000580210ULL, 0x00000000000000bcULL, 0x0000001700000002ULL,
0x0000000000014b30ULL, 0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff087b82ULL, 0x000ea20000000a00ULL,
0x0000040000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000067919ULL, 0x000ee20000002300ULL,
0x0000010000057ab9ULL, 0x000fe20000000800ULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x0000000000077919ULL, 0x000ee20000002200ULL, 0x0000000000397919ULL, 0x000f220000002100ULL,
0x0000000000117919ULL, 0x000f620000002700ULL, 0x0000000900007306ULL, 0x004ea20000209000ULL,
0x000000ff0900720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00027836ULL, 0x004fcc0000000000ULL, 0x0000000200037305ULL, 0x0004e4000021f000ULL,
0x000000ffff027224ULL, 0x004fe400078e00ffULL, 0x000000ffff047224ULL, 0x00afc800078e0a03ULL,
0x0000000904057224ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000000403057c27ULL, 0x000fc8000f8e00ffULL, 0x000000ffff047224ULL, 0x000fc800078e0a05ULL,
0x0000000409007e24ULL, 0x000fe2000f8e0204ULL, 0x00000000000479c3ULL, 0x000e680000002600ULL,
0x000000090000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe400078e0a09ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x000000090000720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000009ff05a212ULL, 0x000fc800078e33ffULL,
0x0000000500007306ULL, 0x000ea20000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00027836ULL, 0x004fe40000000000ULL,
0x0000000506007c24ULL, 0x000fe2000f8e0207ULL, 0x0000000000057ab9ULL, 0x000fc60000000800ULL,
0x0000000200037305ULL, 0x0004e2000021f000ULL, 0x00001fff06067589ULL, 0x000f6200000e0000ULL,
0x000000ffff027224ULL, 0x004fe400078e00ffULL, 0x0000000305047224ULL, 0x008fc800078e02ffULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a04ULL, 0x0000000b03037227ULL, 0x000fe400078e0002ULL,
0x00008600ff0b7b82ULL, 0x000f640000000800ULL, 0x0000000500027c24ULL, 0x110fe2000f8e0239ULL,
0x00000005ff397819ULL, 0x000fe20000011639ULL, 0x0000000403427c27ULL, 0x002fc6000f8e00ffULL,
0x0000007f0200780cULL, 0x040fe20003f64070ULL, 0x000000ffff007224ULL, 0x000fe200078e0a42ULL,
0x00001fff39397589ULL, 0x000f6200000e0000ULL, 0x000000030200780cULL, 0x000fe40003f84070ULL,
0x0000000405007e24ULL, 0x000fca000f8e0200ULL, 0x000000050000720cULL, 0x000fc60003f06070ULL,
0x000000000003b919ULL, 0x000e620000008800ULL, 0xff317217ff04b424ULL, 0x000fd200078e00ffULL,
0x0000000100000824ULL, 0x000fe400078e0a05ULL, 0x0000000142420836ULL, 0x000fe20000000000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x000000050000720cULL, 0x000fe40003f26070ULL,
0x000004000000b802ULL, 0x000fd60000000f00ULL, 0x0000000142421836ULL, 0x000fe20000000000ULL,
0x00000005ff42a212ULL, 0x000fe400078e33ffULL, 0x0000000f0200780cULL, 0x040fe40003f24070ULL,
0x000006540303b816ULL, 0x002fe20000000000ULL, 0x000000ffff407224ULL, 0x000fe200078e0a42ULL,
0x000000010200780cULL, 0x000fc60003f44070ULL, 0x0000000405407e24ULL, 0x000fe4000f8e0240ULL,
0x000000040203b824ULL, 0x000fe400078e0203ULL, 0x0000001040007824ULL, 0x000fe200078e00ffULL,
0x0000000000240947ULL, 0x020fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01760006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402057c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000050612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01760804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402057c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01768804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x017400040300b388ULL, 0x0003e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000402037c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000030612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0176a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe200078e0a00ULL, 0x0000000b08037219ULL, 0x082fe200000006ffULL,
0x0000000811087224ULL, 0x000fe200078e02ffULL, 0x0000000b090f7219ULL, 0x080fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x00000010033b7446ULL, 0x000fe20003800002ULL,
0x0000000406037824ULL, 0x000fe200078e0239ULL, 0x0000000b42027219ULL, 0x000fc400000006ffULL,
0x000000ff3b3b7207ULL, 0x000fe20000000000ULL, 0x0000000203037824ULL, 0x000fe400078e00ffULL,
0x0000000f08027224ULL, 0x000fe200078e0202ULL, 0x000000103b00780cULL, 0x000fda0003f05270ULL,
0x0000000000848947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000e620000000000ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x00000400000a7802ULL, 0x000fe20000000f00ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea40000008800ULL,
0x0000000b04057219ULL, 0x000fe400000006ffULL, 0x00000004ff087819ULL, 0x002fe4000001160eULL,
0x000006540d0d7816ULL, 0x004fc6000000000aULL, 0x0000000103077824ULL, 0x000fe200078e0208ULL,
0x000000000d0872caULL, 0x000fc600000e0000ULL, 0x0000000100047824ULL, 0x000fca00078e0207ULL,
0x0000000504057212ULL, 0x000fe400078e30ffULL, 0x0000000bff047219ULL, 0x000fc60000011604ULL,
0x0000000102057824ULL, 0x000fe200078e0205ULL, 0x000000033b027248ULL, 0x000fc60007fe0000ULL,
0x0000000f040a7224ULL, 0x000fe400078e0205ULL, 0x000000100e047824ULL, 0x000fe400078e00ffULL,
0x0000000102057824ULL, 0x000fe400078e0a03ULL, 0x000001000a027825ULL, 0x000fe200078e00ffULL,
0x000000f0040b7812ULL, 0x000fe400078ec0ffULL, 0x000000050800720cULL, 0x000fe20003f06070ULL,
0x0000000107057824ULL, 0x040fe200078e020eULL, 0x0000000b020b7212ULL, 0x000fe200078efcffULL,
0x0000001007087824ULL, 0x000fc600078e00ffULL, 0x000000040b027c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff008057812ULL, 0x000fe400078ee205ULL, 0x0000000503037c10ULL, 0x000fe40008ffe4ffULL,
0x0000000805057c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c46ULL, 0x0000000000707947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea60000008800ULL,
0x0000000b04047219ULL, 0x000fe400000006ffULL, 0x000000030e057211ULL, 0x002fca00078fe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0205ULL, 0x0000001005087824ULL, 0x000fc600078e00ffULL,
0x0000000403077212ULL, 0x000fe400078e30ffULL, 0x0000000bff047219ULL, 0x000fc60000011603ULL,
0x0000000102077824ULL, 0x000fe200078e0207ULL, 0x0000040000027802ULL, 0x000fc80000000f00ULL,
0x000006540d0d7816ULL, 0x004fe20000000002ULL, 0x0000000f04027224ULL, 0x000fe400078e0207ULL,
0x000000100e047824ULL, 0x000fe200078e00ffULL, 0x000000000d0872caULL, 0x000fe200000e0000ULL,
0x0000010002027825ULL, 0x000fc600078e00ffULL, 0x000000f0040b7812ULL, 0x000fe200078ec0ffULL,
0x0000000105077824ULL, 0x000fc600078e020eULL, 0x0000000b02027212ULL, 0x000fe400078efcffULL,
0xfffffff008077812ULL, 0x000fe400078ee207ULL, 0x0000000402027c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000807077c11ULL, 0x000fe4000f8e20ffULL, 0x0000000503037c10ULL, 0x000fca00087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000b901c46ULL,
0x0001760008047890ULL, 0x000fe2000fffe03fULL, 0x00009000ff027b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000411027825ULL, 0x002fe200078e0002ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000006023a7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x000000ff3a067836ULL, 0x004fca0000000000ULL,
0x00000008ff387819ULL, 0x000fce0000011606ULL, 0x000000c400808947ULL, 0x000fea0003800000ULL,
0x00000008390d7824ULL, 0x000fe200078e00ffULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x00000004ff007424ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011639ULL,
0x0000920000047ab9ULL, 0x000fe40000000800ULL, 0x017688000dff79a7ULL, 0x0003e40008500008ULL,
0x000000200c0b7824ULL, 0x000fe400078e00ffULL, 0x0000000211007824ULL, 0x002fc800078e00ffULL,
0x0000000900097224ULL, 0x000fc800078e0209ULL, 0x00000001420a7824ULL, 0x000fe200078e0209ULL,
0x0000000139097812ULL, 0x000fc600078ec0ffULL, 0x000000040a007c24ULL, 0x000fe2000f8e020bULL,
0x0000000400000947ULL, 0x000fec0003800000ULL, 0x0000000b3a027248ULL, 0x000fe20007fe0000ULL,
0x0000001009037824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x100fe2000001160eULL,
0x00008e0000047ab9ULL, 0x000fe40000000a00ULL, 0x0000000102027824ULL, 0x000fe400078e0a0bULL,
0x0000000103077824ULL, 0x000fe400078e0205ULL, 0x0000000405107836ULL, 0x000fe20000000000ULL,
0x0000000302027248ULL, 0x000fe20007fe0000ULL, 0x0000000107067824ULL, 0x000fc400078e020eULL,
0x0000000807117824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe400078e0a03ULL,
0x0000000100077824ULL, 0x000fe200078e0207ULL, 0xfffffff811087812ULL, 0x000fe200078ee206ULL,
0x0000000103117824ULL, 0x000fe200078e0210ULL, 0x000000021000720cULL, 0x080fe20003f46070ULL,
0x0000000805067836ULL, 0x000fe20000000000ULL, 0x000000020500720cULL, 0x000fe20003f66070ULL,
0x0000000c05107836ULL, 0x000fc40000000000ULL, 0x0000000103137824ULL, 0x040fe200078e0206ULL,
0x000000020600720cULL, 0x080fe20003f26070ULL, 0x0000000103157824ULL, 0x000fe200078e0210ULL,
0x000000021000720cULL, 0x000fe20003f06070ULL, 0x0000008007027825ULL, 0x000fc800078e00ffULL,
0x0000000111057824ULL, 0x140fe200078e020eULL, 0x0000007002127812ULL, 0x000fe200078ef804ULL,
0x0000000811147824ULL, 0x000fe400078e00ffULL, 0x0000000100107824ULL, 0x040fe200078e0215ULL,
0x0000000412127c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000115027824ULL, 0x040fe200078e020eULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x0000000815157824ULL, 0x000fe400078e00ffULL,
0x0000000100117824ULL, 0x000fc400078e0211ULL, 0x0000000100067824ULL, 0x000fe200078e0213ULL,
0xfffffff815187812ULL, 0x000fe200078ee202ULL, 0x0000000113057824ULL, 0x040fe200078e020eULL,
0x000000080c007c11ULL, 0x000fe2000f8e68ffULL, 0x0000000813167824ULL, 0x000fe200078e00ffULL,
0x0000000503137c10ULL, 0x000fe2000a7fe4ffULL, 0x0000008011027825ULL, 0x000fc600078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee205ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000007002027812ULL, 0x000fc600078ef804ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000402027c10ULL, 0x000fc6000ff9e0ffULL, 0x0001300000057836ULL, 0x000fe20000000000ULL,
0x0000007006007812ULL, 0x000fe400078ef804ULL, 0x0000007010067812ULL, 0x000fe200078ef804ULL,
0x0000001008157824ULL, 0x100fe200078e0205ULL, 0x0000000400047c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001014177824ULL, 0x100fe200078e0205ULL, 0x0000000406067c10ULL, 0x000fe2000ffde0ffULL,
0x0000001016197824ULL, 0x100fe200078e0205ULL, 0x0000000503037c10ULL, 0x000fe2000a7fe4ffULL,
0x00000010181b7824ULL, 0x000fe200078e0205ULL, 0x0000000507057c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012157faeULL, 0x0003e2000d901c46ULL,
0x0000000511077c10ULL, 0x000fc6000b7fe4ffULL, 0x0000000002177faeULL, 0x0003e8000d101c46ULL,
0x0000000004197faeULL, 0x0003e8000c901c46ULL, 0x00000000061b7faeULL, 0x0003e2000c101c46ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000001009037824ULL, 0x000fe200078e00ffULL,
0x00008e0000047ab9ULL, 0x000fc80000000a00ULL, 0x000000030e037211ULL, 0x000fca00078fe8ffULL,
0x0000000403077836ULL, 0x000fe40000000000ULL, 0x0000000103027824ULL, 0x140fe400078e020eULL,
0x0000000803057824ULL, 0x000fe400078e00ffULL, 0x0000000107067824ULL, 0x040fe400078e020eULL,
0x0000000807117824ULL, 0x000fe200078e00ffULL, 0xfffffff805057812ULL, 0x000fe200078ee202ULL,
0x0000000100027824ULL, 0x000fc400078e0203ULL, 0x0000000c03137836ULL, 0x000fe20000000000ULL,
0xfffffff811087812ULL, 0x000fe200078ee206ULL, 0x0000000803117836ULL, 0x000fe40000000000ULL,
0x0000008002027825ULL, 0x000fc800078e00ffULL, 0x0000000100107824ULL, 0x040fe200078e0213ULL,
0x0000007002127812ULL, 0x000fe200078ef804ULL, 0x0000000113027824ULL, 0x140fe400078e020eULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0x0000000412127c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000100077824ULL, 0x040fe400078e0207ULL, 0x0000000100067824ULL, 0x000fe200078e0211ULL,
0xfffffff813147812ULL, 0x000fe200078ee202ULL, 0x0000000111007824ULL, 0x040fe200078e020eULL,
0x0000000503137c10ULL, 0x000fe200087fe4ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x000000080c117c11ULL, 0x000fe2000f8e68ffULL, 0x0000008007027825ULL, 0x000fc600078e00ffULL,
0xfffffff815007812ULL, 0x000fe200078ee200ULL, 0x00013000111b7836ULL, 0x000fe20000000000ULL,
0x0000007002027812ULL, 0x000fe200078ef804ULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0x0000000402027c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x0000000503037c10ULL, 0x000fe200087fe4ffULL, 0x0000001005157824ULL, 0x100fe200078e021bULL,
0x0000007006057812ULL, 0x000fe200078ef804ULL, 0x0000001008177824ULL, 0x100fe200078e021bULL,
0x0000007010067812ULL, 0x000fe200078ef804ULL, 0x0000001000197824ULL, 0x100fe200078e021bULL,
0x0000000405047c10ULL, 0x000fe2000ff3e0ffULL, 0x00000010141b7824ULL, 0x000fe200078e021bULL,
0x0000000406067c10ULL, 0x000fe2000ff5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000b901c46ULL, 0x0000000507057c10ULL, 0x000fc40008ffe4ffULL,
0x0000000511077c10ULL, 0x000fe200097fe4ffULL, 0x0000000002177faeULL, 0x0003e8000b901c46ULL,
0x0000000004197faeULL, 0x0003e8000b901c46ULL, 0x00000000061b7faeULL, 0x0003e4000b901c46ULL,
0x00000008ff037e24ULL, 0x002fe2000f8e00ffULL, 0x000000000c0472caULL, 0x000fe200000e0000ULL,
0x00000001ff057424ULL, 0x000fe200078e00ffULL, 0x000000ff3800720cULL, 0x000fe20003f05270ULL,
0x000176a803037836ULL, 0x000fe20000000000ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff507224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000030572caULL, 0x000fc400000e0000ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe400078e00ffULL, 0x000000080c047824ULL, 0x000fe400078e0203ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000005ff0279a7ULL, 0x0002a20008500004ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00002005040479a7ULL, 0x002e62000850003fULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000ac00088947ULL, 0x000fec0003800000ULL,
0x000000ffff417224ULL, 0x004fe200078e0003ULL, 0x00000002ff087819ULL, 0x000fe20000011639ULL,
0x000000ffff007224ULL, 0x002fe400078e0005ULL, 0xff317217ff4c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fce00078e00ffULL,
0x0000000000147805ULL, 0x004fe20000015200ULL, 0x0000000439047824ULL, 0x000fca00078e00ffULL,
0xfffffff804177812ULL, 0x000fc800078ec0ffULL, 0x0176c800170075a7ULL, 0x000e620008000148ULL,
0x0000000817357c36ULL, 0x000fc80008000000ULL, 0x000176c835067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff347224ULL, 0x000fce00078e00ffULL,
0x000000103400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011417ULL,
0x0000003704047211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000204047819ULL, 0x000fc80000001217ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000134347836ULL, 0x000fce0000000000ULL,
0x0176c800350075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000107157836ULL, 0x000fe20000000000ULL, 0x0000920000057ab9ULL, 0x000fe20000000800ULL,
0x0000010007447824ULL, 0x000fc600078e020bULL, 0x000000381500720cULL, 0x000fe20003f26070ULL,
0x0000004044157836ULL, 0x000fc80000000000ULL, 0x000000050a367c24ULL, 0x000fd0000f8e0215ULL,
0x0000000400089947ULL, 0x000fea0003800000ULL, 0x000000153a007248ULL, 0x000fe20007fe0000ULL,
0x0000001009177824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fe2000001160eULL,
0x00008e00000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000100007824ULL, 0x000fe400078e0a15ULL,
0x0000000117157824ULL, 0x000fe400078e0204ULL, 0x0000000404167836ULL, 0x000fe20000000000ULL,
0x0000000017007248ULL, 0x000fe20007fe0000ULL, 0x0000000115147824ULL, 0x000fc400078e020eULL,
0x00000008153f7824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fe400078e0a17ULL,
0x0000000117357824ULL, 0x040fe200078e0216ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee214ULL,
0x0000000804147836ULL, 0x000fe20000000000ULL, 0x000000001600720cULL, 0x080fe20003f66070ULL,
0x0000000c04167836ULL, 0x000fe20000000000ULL, 0x000000000400720cULL, 0x080fe20003f86070ULL,
0x0000000117377824ULL, 0x040fe200078e0214ULL, 0x000000001400720cULL, 0x080fe20003f46070ULL,
0x0000000117177824ULL, 0x000fe200078e0216ULL, 0x000000001600720cULL, 0x000fe20003f06070ULL,
0x000000100e007824ULL, 0x000fc400078e00ffULL, 0x0000000115147824ULL, 0x100fe400078e0236ULL,
0x0000000135167824ULL, 0x040fe200078e0236ULL, 0x00000070003d7812ULL, 0x000fe200078ec0ffULL,
0x0000000135047824ULL, 0x040fe200078e020eULL, 0x000000080c007c11ULL, 0x000fe2000f8e68ffULL,
0x0000000835437824ULL, 0x000fe400078e00ffULL, 0x0000000137347824ULL, 0x000fe400078e0236ULL,
0x0000000117357824ULL, 0x040fe200078e020eULL, 0xfffffff843437812ULL, 0x000fe200078ee204ULL,
0x00000008173c7824ULL, 0x000fc400078e00ffULL, 0x0000000117367824ULL, 0x000fe400078e0236ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff83c477812ULL, 0x000fc600078ee235ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003d14147212ULL, 0x000fc600078efcffULL,
0x0000000137047824ULL, 0x040fe200078e020eULL, 0x0000003d16167212ULL, 0x080fe200078efcffULL,
0x0000000837457824ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000000a16167c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff845457812ULL, 0x000fe200078ee204ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000003d34347212ULL, 0x080fe400078efcffULL, 0x0000000b15157c10ULL, 0x000fe2000affe4ffULL,
0x0001400000007836ULL, 0x000fe20000000000ULL, 0x0000003d36367212ULL, 0x000fc400078efcffULL,
0x0000000b17177c10ULL, 0x000fe2000b7fe4ffULL, 0x000000103f3d7824ULL, 0x100fe200078e0200ULL,
0x0000000a34347c10ULL, 0x000fe2000ffbe0ffULL, 0x00000010433f7824ULL, 0x100fe200078e0200ULL,
0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL, 0x0000001045437824ULL, 0x100fe200078e0200ULL,
0x0000000b35357c10ULL, 0x000fe2000affe4ffULL, 0x0000001047457824ULL, 0x000fe200078e0200ULL,
0x0000000b37377c10ULL, 0x000fe2000b7fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e8000e101c46ULL, 0x00000000163f7faeULL, 0x0003e8000d901c46ULL,
0x0000000034437faeULL, 0x0003e8000d101c46ULL, 0x0000000036457faeULL, 0x0003e2000c101c46ULL,
0x0000000000d47947ULL, 0x000fea0003800000ULL, 0x0000001009157824ULL, 0x000fe200078e00ffULL,
0x00008e00000a7ab9ULL, 0x000fc80000000a00ULL, 0x000000150e157211ULL, 0x000fca00078fe8ffULL,
0x0000000115007824ULL, 0x040fe400078e020eULL, 0x00000008153d7824ULL, 0x040fe400078e00ffULL,
0x0000000415177836ULL, 0x000fe40000000000ULL, 0x0000000c15377836ULL, 0x000fe20000000000ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee200ULL, 0x000000100e007824ULL, 0x000fe400078e00ffULL,
0x0000000115147824ULL, 0x000fc400078e0236ULL, 0x0000000117047824ULL, 0x040fe200078e020eULL,
0x0000007000437812ULL, 0x000fe200078ec0ffULL, 0x00000008173f7824ULL, 0x040fe200078e00ffULL,
0x000000080c007c11ULL, 0x000fe2000f8e68ffULL, 0x0000000815357836ULL, 0x000fe40000000000ULL,
0x0000000117167824ULL, 0x000fe200078e0236ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee204ULL,
0x0000000137177824ULL, 0x040fe400078e020eULL, 0x00000008373c7824ULL, 0x000fc400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83c477812ULL, 0x000fe200078ee217ULL,
0x0000000135347824ULL, 0x100fe200078e0236ULL, 0x0000004314147212ULL, 0x000fe200078efcffULL,
0x0000000137367824ULL, 0x000fe400078e0236ULL, 0x0000000135047824ULL, 0x040fe200078e020eULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000835457824ULL, 0x000fe400078e00ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000b15157c10ULL, 0x000fc400087fe4ffULL,
0xfffffff845457812ULL, 0x000fe200078ee204ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004316167212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004334347212ULL, 0x080fe400078efcffULL, 0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL,
0x0001400000007836ULL, 0x000fe20000000000ULL, 0x0000004336367212ULL, 0x000fe400078efcffULL,
0x0000000a34347c10ULL, 0x000fe2000ff5e0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0200ULL,
0x0000000a36367c10ULL, 0x000fe2000ff7e0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0200ULL,
0x0000000b17177c10ULL, 0x000fe200087fe4ffULL, 0x0000001045437824ULL, 0x100fe200078e0200ULL,
0x0000000b35357c10ULL, 0x000fe200097fe4ffULL, 0x0000001047457824ULL, 0x000fe200078e0200ULL,
0x0000000b37377c10ULL, 0x000fe20009ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e8000b901c46ULL, 0x00000000163f7faeULL, 0x0003e8000b901c46ULL,
0x0000000034437faeULL, 0x0003e8000b901c46ULL, 0x0000000036457faeULL, 0x0003e4000b901c46ULL,
0xfffffff00d047812ULL, 0x040fe200078ec0ffULL, 0x00000001ff357424ULL, 0x002fe200078e00ffULL,
0xffffffe00d007812ULL, 0x040fe400078ec0ffULL, 0x000000100d157812ULL, 0x000fe200078ec0ffULL,
0x0000000804487c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000815007c10ULL, 0x000fe4000fffe000ULL, 0x00000000480572caULL, 0x000fc600000e0000ULL,
0x0000000809347824ULL, 0x000fd400078e0200ULL, 0x000176b005057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0176b035484879a7ULL, 0x0002a4000850003fULL, 0x01760835343479a7ULL, 0x002e64000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x000000080d177812ULL, 0x000fca00078ec0ffULL,
0x00000001004b7824ULL, 0x000fc800078e0217ULL, 0x017608354b0075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff047224ULL, 0x000fce00078e00ffULL,
0x000000100400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011417ULL,
0x0000003700007211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000200007819ULL, 0x000fc80000001217ULL, 0x000000000000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000104047836ULL, 0x000fce0000000000ULL,
0x017608354b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000100e437824ULL, 0x000fe200078e00ffULL, 0x00000001ff467819ULL, 0x000fe2000001160eULL,
0x0000002039007824ULL, 0x000fe400078e00ffULL, 0x000000ffff517224ULL, 0x000fe200078e004cULL,
0x0000007043437812ULL, 0x000fe400078ec0ffULL, 0xffffff8000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c46467812ULL, 0x000fe400078ec0ffULL, 0x0000000843157c10ULL, 0x000fca000fffe000ULL,
0x0000000115157824ULL, 0x000fca00078e0246ULL, 0x0170000015177984ULL, 0x000e680000000800ULL,
0x0172000015047984ULL, 0x0006e20000000800ULL, 0x0000004c1700720bULL, 0x002fda0003f1d000ULL,
0x0000000000007806ULL, 0x000fc800000e0100ULL, 0x0000ffff00167812ULL, 0x000fe2000780c0ffULL,
0x00000001ff007424ULL, 0x000fd800078e00ffULL, 0x0000000000f48947ULL, 0x00cfea0003800000ULL,
0x000000390800720cULL, 0x000fe40003f45270ULL, 0x0000004c1700720bULL, 0x0c0fe40003f14000ULL,
0x0000004c17517209ULL, 0x000fd20007810000ULL, 0x000000083900ac11ULL, 0x000fe4000f8e38ffULL,
0x0000000000157806ULL, 0x000fe400000e0100ULL, 0x000000004600a210ULL, 0x000fe40007ffe043ULL,
0x0000991015147816ULL, 0x000fc600000000ffULL, 0x017400510000a388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000004c51007221ULL, 0x000fe20000010100ULL, 0x000000ff15ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0015ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x0000000000357308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x002fcc000001160eULL, 0x00001f0035007589ULL, 0x004e6400000e0000ULL,
0x0000000018187220ULL, 0x082fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x080fe20000410000ULL,
0x0000000030307220ULL, 0x080fe20000410000ULL, 0x0000000031317220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x000fce0000410000ULL,
0x0000003550507220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080e007811ULL, 0x002fcc00078ff0ffULL, 0x00001f0035007589ULL, 0x000e6400000e0000ULL,
0x000000001a1a7220ULL, 0x082fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000002a2a7220ULL, 0x080fe20000410000ULL, 0x000000002b2b7220ULL, 0x080fe20000410000ULL,
0x000000002e2e7220ULL, 0x080fe20000410000ULL, 0x000000002f2f7220ULL, 0x080fe20000410000ULL,
0x0000000032327220ULL, 0x080fe20000410000ULL, 0x0000000033337220ULL, 0x080fe20000410000ULL,
0x0000000026267220ULL, 0x080fe20000410000ULL, 0x0000000027277220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x000fce0000410000ULL,
0x0000ffff16ff7812ULL, 0x000fe20007806015ULL, 0x00000001ff007424ULL, 0x002fd800078e00ffULL,
0x8000005117170221ULL, 0x000fe20000010000ULL, 0x00007610ff000816ULL, 0x000fc60000000000ULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x0000001700050308ULL, 0x000e640000000800ULL,
0x0000000504040220ULL, 0x002fce0000410000ULL, 0x0000005004507221ULL, 0x000fe20000010000ULL,
0x0000000000147805ULL, 0x000fe40000015200ULL, 0xfffffff00d047812ULL, 0x000fc800078ec0ffULL,
0x0176a841040075a7ULL, 0x000e620008000148ULL, 0x0000000804347c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011417ULL,
0x0000003504047211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000204047819ULL, 0x000fc80000001217ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176a841340075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000070e4d7812ULL, 0x000fe400078ec0ffULL, 0x00000004ff477819ULL, 0x000fe4000001160eULL,
0x0000991000047816ULL, 0x000fe200000000ffULL, 0x0000020039007824ULL, 0x000fe200078e00ffULL,
0x000000080e4a7812ULL, 0x000fe200078ec0ffULL, 0x000000040c157824ULL, 0x100fe200078e0247ULL,
0x000000084d4c7812ULL, 0x000fe200078ef80eULL, 0x0000000409477824ULL, 0x000fe200078e0247ULL,
0x000000ff0400720cULL, 0x000fc40003f05270ULL, 0x0000004d4a3c7212ULL, 0x000fe200078efcffULL,
0x000000014c4e7824ULL, 0x000fe200078e0215ULL, 0xfffff80000007812ULL, 0x000fe200078ec0ffULL,
0x000000084c157824ULL, 0x000fe200078e00ffULL, 0x000000080c047c11ULL, 0x000fe2000f8e68ffULL,
0x000000013c3d7824ULL, 0x040fe400078e0247ULL, 0x000000083c167824ULL, 0x000fe400078e00ffULL,
0x0000000800457c36ULL, 0x000fe20008000000ULL, 0xfffffff815007812ULL, 0x000fe200078ee24eULL,
0x0001300004417836ULL, 0x000fe20000000000ULL, 0xfffffff816167812ULL, 0x000fc600078ee23dULL,
0x0000001000147824ULL, 0x000fe400078e0245ULL, 0x0000001016347824ULL, 0x000fe200078e0241ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000005ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000007816ULL, 0x000fca0000000000ULL, 0x00001f0300037589ULL, 0x0002a800000e0000ULL,
0x00001f1500027589ULL, 0x0002e400000e0000ULL, 0x011000001414783bULL, 0x002e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x086fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000215157232ULL, 0x088fe40000200000ULL,
0x0000000217177232ULL, 0x000fce0000200000ULL, 0x000000083c007824ULL, 0x000fe200078e00ffULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x000000023d3d7836ULL, 0x000fe40000000000ULL,
0x000000084c4f7824ULL, 0x000fe400078e00ffULL, 0x000000024e4c7836ULL, 0x000fe20000000000ULL,
0xfffffff800007812ULL, 0x000fc800078ee23dULL, 0xfffffff84f4c7812ULL, 0x000fe200078ee24cULL,
0x00000010003c7824ULL, 0x000fe200078e0241ULL, 0x000000104a007812ULL, 0x000fc600078efe4dULL,
0x000000104c4c7824ULL, 0x000fe400078e0245ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x0000000147477824ULL, 0x000fe200078e0200ULL, 0x00000010ff647819ULL, 0x010fe40000011635ULL,
0x0000ffff34637812ULL, 0x000fe400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x000fc40000011636ULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x000000ff344d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff36527812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011636ULL, 0x0000ffff36547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff367819ULL, 0x000fc40000011637ULL, 0x00000010ff657819ULL, 0x100fe40000011634ULL,
0x00000018ff667819ULL, 0x000fe40000011637ULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000018ff4a7819ULL, 0x000fe40000011634ULL, 0x000000ff37537812ULL, 0x040fe400078ec0ffULL,
0x0000ffff37557812ULL, 0x000fc400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff354f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff347819ULL, 0x000fe40000011635ULL, 0x0000ffff355d7812ULL, 0x000fe400078ec0ffULL,
0x0000004dff60723eULL, 0x000fc400020006ffULL, 0x00000010ff5f7819ULL, 0x128fe4000001163cULL,
0x000000ff3c577812ULL, 0x040fe200078ec0ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000018ff567819ULL, 0x000fe4000001163cULL, 0x0000ffff3c377812ULL, 0x000fe400078ec0ffULL,
0x00000010ff627819ULL, 0x000fe4000001163dULL, 0x00000010ff357819ULL, 0x000fc4000001163fULL,
0x000000ff3f6a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001163fULL,
0x0000ffff3f4d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff36367812ULL, 0x000fe400078ec0ffULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x00000066ff3f723eULL, 0x000fe200020006ffULL,
0x20000064ff667230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000063ff647230ULL, 0x000fe20000004100ULL, 0x00000008ff5d7819ULL, 0x000fe2000001165dULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fc400020006ffULL,
0x000000ff62637812ULL, 0x000fe200078ec0ffULL, 0x2000005cff627230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000ffff3d5e7812ULL, 0x000fe200078ec0ffULL, 0x2000004fff617230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000018ff677819ULL, 0x000fc4000001163dULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000053ff597230ULL, 0x000fe20000004100ULL, 0x00000063ff5c723eULL, 0x000fe200020006ffULL,
0x20000036ff637230ULL, 0x000fe20000004100ULL, 0x00000008ff377819ULL, 0x000fe40000011637ULL,
0x00000008ff367819ULL, 0x000fe2000001165eULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x00000067ff53723eULL, 0x000fe200020006ffULL, 0x2000005dff677230ULL, 0x000fe20000004100ULL,
0x00000034ff5a723eULL, 0x000fc400020006ffULL, 0x00000037ff5c723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000036ff5d723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011660ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011661ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x000000ff3d587812ULL, 0x000fe400078ec0ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x0000004aff5b723eULL, 0x000fe400020006ffULL,
0x0000105465367816ULL, 0x000fe40000000036ULL, 0x0000105466377816ULL, 0x000fe20000000037ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fc4000001163eULL,
0x000000ff3e697812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe2000001163eULL,
0x000000361418723cULL, 0x002fe20000041818ULL, 0x0000ffff3e4a7812ULL, 0x000fe400078ec0ffULL,
0x00000058ff3e723eULL, 0x000fe200020006ffULL, 0x20000052ff587230ULL, 0x000fe20000004100ULL,
0x000000ff35617812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5a7819ULL, 0x000fc4000001165aULL,
0x00000010ff357819ULL, 0x000fe40000011667ULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x000010545a357816ULL, 0x000fe40000000035ULL, 0x00000010ff367819ULL, 0x000fe40000011658ULL,
0x00000010ff377819ULL, 0x000fe40000011662ULL, 0x000000ff34607812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5a7819ULL, 0x000fe40000011659ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff347819ULL, 0x000fe40000011664ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000056ff3d723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000057ff567230ULL, 0x000fe20000004100ULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x2000003dff527230ULL, 0x000fe20000004100ULL,
0x0000105463377816ULL, 0x000fe2000000005aULL, 0x2000003eff577230ULL, 0x000fe20000004100ULL,
0x000010545b347816ULL, 0x000fe20000000034ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff5f7819ULL, 0x000fc4000001165fULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x0000006aff4f723eULL, 0x000fe200020006ffULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000010ff377819ULL, 0x000fe40000011652ULL,
0x00000010ff367819ULL, 0x000fe2000001165cULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe40000011653ULL, 0x00000010ff347819ULL, 0x000fc40000011656ULL,
0x00000010ff357819ULL, 0x000fe40000011657ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x20000060ff597230ULL, 0x000fe20000004100ULL, 0x000010545f347816ULL, 0x000fe20000000034ULL,
0x20000061ff587230ULL, 0x000fe20000004100ULL, 0x000010545e357816ULL, 0x000fc40000000035ULL,
0x0000105452377816ULL, 0x000fe4000000005dULL, 0x00000008ff547819ULL, 0x000fe40000011654ULL,
0x00000008ff557819ULL, 0x000fe20000011655ULL, 0x000000341424723cULL, 0x000fe20000041824ULL,
0x00000008ff4a7819ULL, 0x000fe4000001164aULL, 0x00000008ff527819ULL, 0x000fe4000001164dULL,
0x0000004eff3d723eULL, 0x000fe200020006ffULL, 0x20000069ff4e7230ULL, 0x000fe20000004100ULL,
0x00000068ff3e723eULL, 0x000fe200020006ffULL, 0x000000361420723cULL, 0x000fe20000041820ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000004aff4d723eULL, 0x000fe200020006ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe2000001164eULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe2000001164fULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x000fc40000011659ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x0000105459347816ULL, 0x000fe40000000034ULL, 0x0000105458357816ULL, 0x000fe40000000035ULL,
0x00000010ff4a7819ULL, 0x000fe4000001163fULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff367819ULL, 0x000fe20000011654ULL, 0x00000034141c723cULL, 0x000fe2000004181cULL,
0x00000010ff377819ULL, 0x000fc40000011655ULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff3c7819ULL, 0x000fe2000001163cULL,
0x0000000800347824ULL, 0x000fe200078e00ffULL, 0x00000010ff3f7819ULL, 0x000fe40000011652ULL,
0x000010543d367816ULL, 0x000fe40000000036ULL, 0x000010544a377816ULL, 0x000fc40000000037ULL,
0x000010543e3e7816ULL, 0x000fe4000000004dULL, 0x000010543c3f7816ULL, 0x000fe4000000003fULL,
0xfffffff834347812ULL, 0x000fe200078ee247ULL, 0x000000361430723cULL, 0x000fe80000041830ULL,
0x0000001034347824ULL, 0x000fe400078e0241ULL, 0x0000003e1410723cULL, 0x000fe20000041810ULL,
0x011000004c14783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000215157232ULL, 0x080fe40000200000ULL,
0x0000000217177232ULL, 0x000fce0000200000ULL, 0x00000008003c7824ULL, 0x000fe200078e00ffULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x0000000247477836ULL, 0x000fca0000000000ULL,
0xfffffff83c3c7812ULL, 0x000fca00078ee247ULL, 0x000000103c3c7824ULL, 0x000fcc00078e0241ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x00000010ff647819ULL, 0x010fe40000011634ULL,
0x0000ffff34627812ULL, 0x000fe400078ec0ffULL, 0x000000ff354d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5b7819ULL, 0x000fe40000011636ULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000008ff627819ULL, 0x000fc40000011662ULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x000fe20000011635ULL,
0x2000004dff607230ULL, 0x000fe20000004100ULL, 0x00000018ff657819ULL, 0x022fe4000001163cULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x000000ff344a7812ULL, 0x000fe400078ec0ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000ffff355c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff36527812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011636ULL, 0x00000010ff5d7819ULL, 0x000fc40000011637ULL,
0x000000ff37567812ULL, 0x040fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe40000011637ULL,
0x0000ffff36367812ULL, 0x000fe400078ec0ffULL, 0x0000ffff37377812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x000fe4000001163cULL, 0x00000065ff4d723eULL, 0x000fe200020006ffULL,
0x20000064ff657230ULL, 0x000fe20000004100ULL, 0x000000ff63637812ULL, 0x000fe200078ec0ffULL,
0x20000062ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff477819ULL, 0x000fe20000011634ULL,
0x2000005bff627230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe2000001163dULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000018ff347819ULL, 0x000fc40000011635ULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x2000004aff617230ULL, 0x000fe20000004100ULL,
0x00000018ff667819ULL, 0x000fe4000001163dULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000008ff367819ULL, 0x000fc40000011636ULL, 0x00000008ff377819ULL, 0x000fe40000011637ULL,
0x000000ff5e5b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3c577812ULL, 0x000fe400078ec0ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x00000047ff5a723eULL, 0x000fc400020006ffULL, 0x00000034ff59723eULL, 0x000fe400020006ffULL,
0x0000ffff3c347812ULL, 0x000fe200078ec0ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x000000ff3d677812ULL, 0x000fe200078ec0ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x000fc4000001163eULL, 0x000000ff3e687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e477812ULL, 0x000fe400078ec0ffULL,
0x00000066ff4a723eULL, 0x000fe200020006ffULL, 0x20000063ff667230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe200020006ffULL, 0x2000005dff637230ULL, 0x000fe20000004100ULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000036ff5d7230ULL, 0x000fe20000004100ULL,
0x00000057ff3e723eULL, 0x000fe200020006ffULL, 0x20000052ff577230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000037ff5e7230ULL, 0x000fe20000004100ULL,
0x0000ffff3d357812ULL, 0x000fc400078ec0ffULL, 0x00000067ff52723eULL, 0x000fe200020006ffULL,
0x2000005cff677230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011661ULL,
0x2000005bff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011660ULL,
0x2000005fff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000008ff5f7819ULL, 0x000fc40000011634ULL, 0x00000008ff607819ULL, 0x000fe40000011635ULL,
0x00000010ff357819ULL, 0x000fe4000001165aULL, 0x00000010ff347819ULL, 0x000fe40000011664ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000010ff5a7819ULL, 0x000fe40000011659ULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x20000056ff587230ULL, 0x000fe20000004100ULL,
0x0000105465367816ULL, 0x000fc40000000036ULL, 0x0000105466377816ULL, 0x000fe40000000037ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x2000004fff567230ULL, 0x000fe20000004100ULL,
0x000010545a357816ULL, 0x000fe20000000067ULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x000000361418723cULL, 0x008fe20000041818ULL, 0x00000010ff597819ULL, 0x000fe20000011658ULL,
0x2000003eff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fc40000011663ULL,
0x00000010ff557819ULL, 0x000fe20000011655ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff367819ULL, 0x000fe40000011657ULL, 0x00000010ff377819ULL, 0x000fe40000011662ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff357819ULL, 0x000fe40000011656ULL,
0x00000010ff347819ULL, 0x000fc4000001165dULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x000010545a377816ULL, 0x000fe40000000059ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000105435347816ULL, 0x000fe20000000034ULL,
0x2000005fff577230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fe2000001163fULL,
0x20000060ff587230ULL, 0x000fe20000004100ULL, 0x0000105455357816ULL, 0x000fe2000000005eULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x0000ffff3f4e7812ULL, 0x000fc400078ec0ffULL,
0x000000ff3f697812ULL, 0x000fe400078ec0ffULL, 0x000000ff53537812ULL, 0x000fe200078ec0ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff367819ULL, 0x000fe4000001164fULL, 0x00000010ff377819ULL, 0x000fe4000001165cULL,
0x00000018ff3d7819ULL, 0x000fc4000001163fULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000008ff4e7819ULL, 0x000fe4000001164eULL,
0x00000068ff3e723eULL, 0x000fe400020006ffULL, 0x00000069ff3f723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fe2000001164dULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe2000001164aULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fc40000011657ULL, 0x00000010ff357819ULL, 0x000fe40000011658ULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x000010545b377816ULL, 0x000fe40000000052ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x00000008ff477819ULL, 0x000fc40000011647ULL,
0x000010544d347816ULL, 0x000fe20000000034ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000010544a357816ULL, 0x000fe20000000035ULL, 0x000000361424723cULL, 0x000fe20000041824ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x000000341420723cULL, 0x000fe20000041820ULL,
0x00000010ff367819ULL, 0x000fe2000001163eULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe2000001163fULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff547819ULL, 0x000fc40000011654ULL, 0x00000010ff347819ULL, 0x000fe4000001163dULL,
0x00000010ff3d7819ULL, 0x000fe4000001164eULL, 0x0000105453367816ULL, 0x000fe40000000036ULL,
0x0000105454377816ULL, 0x000fe40000000037ULL, 0x00001054343d7816ULL, 0x000fe2000000003dULL,
0x0000000239347824ULL, 0x000fe200078e00ffULL, 0x00000010ff3c7819ULL, 0x000fc4000001163cULL,
0x00000010ff477819ULL, 0x000fe20000011647ULL, 0x00000036141c723cULL, 0x000fe2000004181cULL,
0x000000080c357c11ULL, 0x000fe4000f8e18ffULL, 0x000010543c3c7816ULL, 0x000fc80000000047ULL,
0x00000001ff377424ULL, 0x000fe200078e00ffULL, 0xfffffff834367812ULL, 0x000fe400078ec0ffULL,
0x0000003c1410723cULL, 0x000fe20000041810ULL, 0x0176c837353479a7ULL, 0x0002e2000850003fULL,
0x0176883736ff79a7ULL, 0x0003de0008500008ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x002fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000008044157836ULL, 0x000fe20000000000ULL, 0x0000920000057ab9ULL, 0x000fc60000000800ULL,
0x000000050a357c24ULL, 0x000fe2000f8e0215ULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x000000153a147248ULL, 0x000fe20007fe0000ULL, 0x0000001009177824ULL, 0x000fe200078e00ffULL,
0x00000003ff167819ULL, 0x000fe2000001160eULL, 0x00008e00000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000114147824ULL, 0x000fe400078e0a15ULL, 0x0000000117157824ULL, 0x000fe400078e0216ULL,
0x0000000416367836ULL, 0x002fe20000000000ULL, 0x0000001417147248ULL, 0x000fe20007fe0000ULL,
0x0000000115347824ULL, 0x000fc400078e020eULL, 0x0000000815377824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x000fe400078e0a17ULL, 0x0000000c163d7836ULL, 0x000fe20000000000ULL,
0xfffffff8373c7812ULL, 0x000fe200078ee234ULL, 0x0000000816347836ULL, 0x000fe20000000000ULL,
0x000000143600720cULL, 0x080fe20003f66070ULL, 0x0000000117367824ULL, 0x000fe200078e0236ULL,
0x000000141600720cULL, 0x080fe20003f86070ULL, 0x0000000115157824ULL, 0x000fe200078e0235ULL,
0x000000143400720cULL, 0x080fe20003f46070ULL, 0x0000000136167824ULL, 0x040fe200078e020eULL,
0x000000143d00720cULL, 0x000fe20003f06070ULL, 0x0000000836477824ULL, 0x000fc400078e00ffULL,
0x0000008015147825ULL, 0x000fc600078e00ffULL, 0xfffffff8473e7812ULL, 0x000fe200078ee216ULL,
0x0000000136167824ULL, 0x000fe200078e0235ULL, 0x0000004314147212ULL, 0x000fe200078efcffULL,
0x0000000117377824ULL, 0x040fe400078e0234ULL, 0x00000001173f7824ULL, 0x000fe200078e023dULL,
0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0x0000000b15157c10ULL, 0x000fe2000affe4ffULL, 0x0000000137347824ULL, 0x100fe200078e0235ULL,
0x0000004316167212ULL, 0x000fe200078efcffULL, 0x000000013f367824ULL, 0x000fe400078e0235ULL,
0x00000001373d7824ULL, 0x040fe200078e020eULL, 0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL,
0x00000008374a7824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000000b17177c10ULL, 0x000fc4000affe4ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee23dULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004334347212ULL, 0x000fc600078efcffULL,
0x000000013f3d7824ULL, 0x040fe200078e020eULL, 0x0000004336367212ULL, 0x000fe200078efcffULL,
0x000000083f4e7824ULL, 0x000fe200078e00ffULL, 0x0000000a34347c10ULL, 0x000fe2000ffbe0ffULL,
0x000000103e3f7824ULL, 0x100fe200078e0241ULL, 0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL,
0x000000104a477824ULL, 0x100fe200078e0241ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee23dULL,
0x000000103c3d7824ULL, 0x100fe200078e0241ULL, 0x0000000b35357c10ULL, 0x000fe4000affe4ffULL,
0x0000000b37377c10ULL, 0x000fe2000b7fe4ffULL, 0x000000104e4d7824ULL, 0x000fe200078e0241ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e8000e101c46ULL,
0x00000000163f7faeULL, 0x0003e8000d901c46ULL, 0x0000000034477faeULL, 0x0003e8000d101c46ULL,
0x00000000364d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001009157824ULL, 0x000fe200078e00ffULL, 0x00008e00000a7ab9ULL, 0x000fc80000000a00ULL,
0x000000150e157211ULL, 0x000fca00078fe8ffULL, 0x0000000115167824ULL, 0x040fe400078e020eULL,
0x0000000815377824ULL, 0x042fe400078e00ffULL, 0x0000000115147824ULL, 0x000fe400078e0235ULL,
0x0000000415177836ULL, 0x000fe20000000000ULL, 0xfffffff8373c7812ULL, 0x000fe200078ee216ULL,
0x00000008153d7836ULL, 0x000fe40000000000ULL, 0x0000000c15157836ULL, 0x000fc40000000000ULL,
0x0000000117367824ULL, 0x140fe400078e0235ULL, 0x0000000117377824ULL, 0x140fe400078e020eULL,
0x00000008173e7824ULL, 0x000fe400078e00ffULL, 0x000000013d167824ULL, 0x100fe400078e0235ULL,
0x0000000115347824ULL, 0x000fe200078e0235ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee237ULL,
0x000000013d177824ULL, 0x000fc400078e020eULL, 0x000000083d4a7824ULL, 0x000fe400078e00ffULL,
0x0000000115357824ULL, 0x040fe400078e020eULL, 0x00000008154e7824ULL, 0x000fe200078e00ffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee217ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee235ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004314147212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004336367212ULL, 0x080fe400078efcffULL, 0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004316167212ULL, 0x080fe400078efcffULL,
0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL, 0x000000103c3d7824ULL, 0x100fe200078e0241ULL,
0x0000004334347212ULL, 0x000fe200078efcffULL, 0x000000103e3f7824ULL, 0x100fe200078e0241ULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x000000104a477824ULL, 0x100fe200078e0241ULL,
0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL, 0x000000104e4d7824ULL, 0x000fe200078e0241ULL,
0x0000000a34347c10ULL, 0x000fe2000ff7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000b901c46ULL, 0x0000000b37377c10ULL, 0x000fc400097fe4ffULL,
0x0000000b17177c10ULL, 0x000fe400087fe4ffULL, 0x0000000b35357c10ULL, 0x000fe20009ffe4ffULL,
0x00000000363f7faeULL, 0x0003e8000b901c46ULL, 0x0000000016477faeULL, 0x0003e8000b901c46ULL,
0x00000000344d7faeULL, 0x0003e4000b901c46ULL, 0x000000100c147824ULL, 0x002fe200078e00ffULL,
0xffffffe00d167812ULL, 0x000fe200078ec0ffULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x0000000814547c36ULL, 0x000fe20008000000ULL, 0x0000001014157812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000540572caULL, 0x000fe400000e0000ULL,
0x0000000815157c10ULL, 0x000fe4000fffe016ULL, 0x000000080d167812ULL, 0x000fca00078ec0ffULL,
0x0000000116157824ULL, 0x000fc800078e0215ULL, 0x000176a805057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176a834545479a7ULL, 0x0002e4000850003fULL, 0x01762834153479a7ULL, 0x0022a4000850003fULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x017628354b0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x017628354b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002039147824ULL, 0x000fe400078e00ffULL, 0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x0000008015147810ULL, 0x000fc80007ffe014ULL, 0x0000001446147210ULL, 0x000fca0007ffe043ULL,
0x0170000014167984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0004a20000000800ULL,
0x000000511600720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15157812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x0000000108147836ULL, 0x000fe20000000000ULL, 0x000000511600720bULL, 0x0c0fe40003f14000ULL,
0x0000005116357209ULL, 0x000fe40007810000ULL, 0x000000391400720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000083914ac11ULL, 0x000fc8000f8e38ffULL,
0x000000144636a210ULL, 0x000fe40007ffe043ULL, 0x0000991034147816ULL, 0x000fc600000000ffULL,
0x017400353600a388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x8000003551517221ULL, 0x000fe20000010000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b51517820ULL, 0x000fcc0000410000ULL, 0x0000005100517308ULL, 0x000e680000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fcc000001160eULL,
0x00001f1451147589ULL, 0x002e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000005150507220ULL, 0x002fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e147811ULL, 0x000fcc00078ff0ffULL,
0x00001f1451147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff15ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff517224ULL, 0x000fd400078e0035ULL,
0x8000003516160221ULL, 0x100fe20000010000ULL, 0x000000ffff510224ULL, 0x000fe200078e0035ULL,
0x00007610ff340816ULL, 0x000fe40000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600050308ULL, 0x000e640000000800ULL, 0x0000000517170220ULL, 0x002fce0000410000ULL,
0x0000005017507221ULL, 0x000fe20000010000ULL, 0x0000000000147805ULL, 0x000fe40000015200ULL,
0xfffffff00d177812ULL, 0x000fc800078ec0ffULL, 0x0176b049170075a7ULL, 0x000e620008000148ULL,
0x0000000817377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176b049370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000239527824ULL, 0x040fe200078e00ffULL,
0x0000991034347816ULL, 0x000fe200000000ffULL, 0x00000004394d7824ULL, 0x000fe200078e00ffULL,
0x000000070e177812ULL, 0x040fe200078ec0ffULL, 0x0001400004477836ULL, 0x000fe20000000000ULL,
0x000000080e147812ULL, 0x000fe400078ec0ffULL, 0x0000000452157812ULL, 0x000fe400078ec0ffULL,
0x00000017143e7212ULL, 0x000fe200078efcffULL, 0x000000ffff147224ULL, 0x000fe200078e0034ULL,
0x0000000817167812ULL, 0x000fc400078ef80eULL, 0x000000150e157211ULL, 0x000fe200078fe0ffULL,
0x000000083e177824ULL, 0x000fe200078e00ffULL, 0x000000ff1400720cULL, 0x000fe40003f05270ULL,
0x000000044d4d7812ULL, 0x000fe200078ec0ffULL, 0x00000001164a7824ULL, 0x040fe400078e0215ULL,
0x0000000816157824ULL, 0x000fe200078e00ffULL, 0x0000004d0e4d7211ULL, 0x000fc800078fe0ffULL,
0xfffffff815147812ULL, 0x000fe200078ee24aULL, 0x000000013e3c7824ULL, 0x000fc800078e024dULL,
0x00000010144f7824ULL, 0x000fe200078e0245ULL, 0xfffffff817167812ULL, 0x000fe200078ee23cULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000005ff02723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541002147816ULL, 0x000fca0000000002ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514027589ULL, 0x0002e400000e0000ULL, 0x0000001016497824ULL, 0x000fe400078e0247ULL,
0x011800004f14783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000215157232ULL, 0x080fe40000200000ULL, 0x0000000217177232ULL, 0x000fce0000200000ULL,
0x000000083e3d7824ULL, 0x000fe200078e00ffULL, 0x000000004934783bULL, 0x000f220000004200ULL,
0x000000023c4e7836ULL, 0x000fca0000000000ULL, 0xfffffff83d4e7812ULL, 0x000fca00078ee24eULL,
0x000000104e3c7824ULL, 0x000fcc00078e0247ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x000000ff34537812ULL, 0x010fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe40000011637ULL,
0x000000ff376e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011637ULL,
0x0000ffff375c7812ULL, 0x000fe400078ec0ffULL, 0x00000053ff66723eULL, 0x000fc400020006ffULL,
0x00000010ff697819ULL, 0x100fe40000011634ULL, 0x00000018ff597819ULL, 0x000fe20000011634ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000ffff34487812ULL, 0x000fe400078ec0ffULL,
0x000000ff3e6c7812ULL, 0x022fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe4000001163eULL,
0x0000006cff6c723eULL, 0x000fc400020006ffULL, 0x00000010ff607819ULL, 0x100fe4000001163cULL,
0x000000ff3c6f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff537819ULL, 0x000fe4000001163cULL,
0x0000ffff3c377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff347819ULL, 0x000fe4000001163eULL,
0x0000ffff3e3c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001163fULL,
0x00000010ff6a7819ULL, 0x000fe40000011635ULL, 0x00000010ff5d7819ULL, 0x000fe4000001163fULL,
0x000000ff3f3e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3f587812ULL, 0x000fe400078ec0ffULL,
0x00000057ff3f723eULL, 0x000fe200020006ffULL, 0x2000006cff577230ULL, 0x000fe20000004100ULL,
0x000000ff355b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff35687812ULL, 0x000fe200078ec0ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x0000006bff6c723eULL, 0x000fe400020006ffULL,
0x0000ffff36617812ULL, 0x000fe400078ec0ffULL, 0x000000ff69697812ULL, 0x000fe400078ec0ffULL,
0x000000ff6a6b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff657819ULL, 0x000fc4000001163dULL,
0x00000008ff6a7819ULL, 0x000fe20000011648ULL, 0x2000006cff487230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x000000ff64647812ULL, 0x000fe200078ec0ffULL, 0x2000005bff637230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000008ff617819ULL, 0x000fc40000011661ULL,
0x00000018ff5a7819ULL, 0x000fe40000011635ULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000008ff5c7819ULL, 0x000fc4000001165cULL,
0x00000059ff35723eULL, 0x000fe400020006ffULL, 0x0000006dff5b723eULL, 0x000fe400020006ffULL,
0x0000006bff6c723eULL, 0x000fe200020006ffULL, 0x20000069ff6b7230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x2000006aff697230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x20000068ff6a7230ULL, 0x000fe20000004100ULL,
0x00000065ff6d723eULL, 0x000fe200020006ffULL, 0x20000064ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x100fe20000011636ULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x000000ff365e7812ULL, 0x000fe200078ec0ffULL, 0x20000061ff647230ULL, 0x000fe20000004100ULL,
0x00000018ff5f7819ULL, 0x000fe20000011636ULL, 0x2000005aff627230ULL, 0x000fe20000004100ULL,
0x0000ffff3d367812ULL, 0x000fe200078ec0ffULL, 0x2000006dff617230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff377819ULL, 0x000fe20000011637ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe20000011636ULL, 0x2000005cff657230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fc40000011666ULL, 0x00000037ff5c723eULL, 0x000fe400020006ffULL,
0x000000ff34667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff377819ULL, 0x000fe20000011663ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x00000010ff347819ULL, 0x000fe40000011669ULL, 0x00000010ff637819ULL, 0x000fc40000011662ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x000000ff3d707812ULL, 0x000fe400078ec0ffULL,
0x00000018ff567819ULL, 0x000fe4000001163dULL, 0x0000005fff3d723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x0000105463357816ULL, 0x000fe2000000006aULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x000000ff67677812ULL, 0x000fc400078ec0ffULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000341428723cULL, 0x008fe20000041828ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x0000006fff59723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000006eff5f7230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x000010546b367816ULL, 0x000fe20000000036ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x000010546c377816ULL, 0x000fe20000000037ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000070ff5a723eULL, 0x000fc400020006ffULL, 0x00000008ff357819ULL, 0x000fe4000001163cULL,
0x00000010ff3d7819ULL, 0x000fe2000001163dULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fe20000011664ULL, 0x000000361418723cULL, 0x000fe20000041818ULL,
0x00000010ff347819ULL, 0x000fe4000001165bULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000053ff53723eULL, 0x000fc400020006ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x000010543d3c7816ULL, 0x000fe2000000003cULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe2000001165eULL, 0x2000006dff627230ULL, 0x000fe20000004100ULL,
0x00001054343d7816ULL, 0x000fe40000000065ULL, 0x000000ff5d637812ULL, 0x000fc400078ec0ffULL,
0x00000035ff5e723eULL, 0x000fe400020006ffULL, 0x00000008ff587819ULL, 0x000fe20000011658ULL,
0x0000003c1430723cULL, 0x000fe20000041830ULL, 0x00000010ff377819ULL, 0x000fe2000001165fULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff347819ULL, 0x000fc40000011659ULL,
0x00000010ff357819ULL, 0x000fe40000011660ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000066ff5d7230ULL, 0x000fe20000004100ULL, 0x0000105467367816ULL, 0x000fe20000000036ULL,
0x20000063ff5b7230ULL, 0x000fe20000004100ULL, 0x0000105468377816ULL, 0x000fe20000000037ULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x0000105435347816ULL, 0x000fc40000000034ULL,
0x0000105461357816ULL, 0x000fe4000000005aULL, 0x00000010ff537819ULL, 0x000fe20000011653ULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff3c7819ULL, 0x000fe4000001165cULL, 0x00000010ff3d7819ULL, 0x000fe20000011662ULL,
0x000000341424723cULL, 0x000fe20000041824ULL, 0x00001054533c7816ULL, 0x000fc4000000003cULL,
0x00001054563d7816ULL, 0x000fe4000000003dULL, 0x00000010ff377819ULL, 0x000fe4000001163eULL,
0x00000010ff367819ULL, 0x000fe40000011657ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x0000003c1420723cULL, 0x000fe20000041820ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x00000010ff3e7819ULL, 0x000fc4000001165bULL, 0x00000010ff347819ULL, 0x000fe4000001165eULL,
0x00000010ff487819ULL, 0x000fe20000011648ULL, 0x00000008003d7824ULL, 0x040fe200078e00ffULL,
0x00000010ff357819ULL, 0x000fe20000011658ULL, 0x00000001003c7824ULL, 0x000fe200078e024dULL,
0x000010545d367816ULL, 0x000fe40000000036ULL, 0x000010543e377816ULL, 0x000fe40000000037ULL,
0x000010543f347816ULL, 0x000fc40000000034ULL, 0x0000105448357816ULL, 0x000fe40000000035ULL,
0xfffffff83d487812ULL, 0x000fe200078ee23cULL, 0x00000036141c723cULL, 0x000fec000004181cULL,
0x000000341410723cULL, 0x000fe20000041810ULL, 0x011800004c14783bULL, 0x0002ec0000000200ULL,
0x0000001048347824ULL, 0x000fe200078e0247ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000215157232ULL, 0x080fe40000200000ULL,
0x0000000217177232ULL, 0x000fce0000200000ULL, 0x00000008003d7824ULL, 0x000fe200078e00ffULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x000000023c4c7836ULL, 0x002fe20000000000ULL,
0xfffffff852527812ULL, 0x000fc800078ec0ffULL, 0xfffffff83d4c7812ULL, 0x000fca00078ee24cULL,
0x000000104c3c7824ULL, 0x000fcc00078e0247ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x00000010ff6c7819ULL, 0x110fe40000011634ULL, 0x000000ff34567812ULL, 0x040fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fe40000011634ULL, 0x0000ffff346a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff365d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff35577812ULL, 0x000fc400078ec0ffULL,
0x00000018ff347819ULL, 0x100fe40000011635ULL, 0x00000018ff597819ULL, 0x000fe40000011636ULL,
0x000000ff375f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3c6d7812ULL, 0x002fe400078ec0ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000010ff6b7819ULL, 0x000fc40000011635ULL,
0x00000010ff627819ULL, 0x000fe40000011636ULL, 0x0000ffff36617812ULL, 0x000fe400078ec0ffULL,
0x00000057ff68723eULL, 0x000fe400020006ffULL, 0x00000034ff64723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x0000ffff35657812ULL, 0x000fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000053ff63723eULL, 0x000fc400020006ffULL, 0x00000010ff367819ULL, 0x100fe4000001163cULL,
0x00000018ff577819ULL, 0x000fe2000001163cULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x0000ffff3c347812ULL, 0x000fe400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000010ff5b7819ULL, 0x000fe4000001163eULL, 0x000000ff3e5a7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e537812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x100fe40000011637ULL, 0x00000018ff5e7819ULL, 0x000fe40000011637ULL,
0x0000ffff37667812ULL, 0x000fe400078ec0ffULL, 0x000000ff3f3e7812ULL, 0x000fc400078ec0ffULL,
0x0000005fff60723eULL, 0x000fe200020006ffULL, 0x2000005dff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x20000059ff5d7230ULL, 0x000fe20000004100ULL,
0x00000056ff69723eULL, 0x000fe200020006ffULL, 0x2000006dff597230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x100fe2000001163dULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x000000ff3d6e7812ULL, 0x000fe200078ec0ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000018ff587819ULL, 0x000fc4000001163dULL, 0x0000ffff3d357812ULL, 0x000fe400078ec0ffULL,
0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x100fe4000001163fULL,
0x00000018ff3d7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f567812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6a7819ULL, 0x000fc4000001166aULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x0000005aff3f723eULL, 0x000fe400020006ffULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x0000003eff6d723eULL, 0x000fe200020006ffULL,
0x2000003fff3e7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fc400020006ffULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000006dff3f7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x2000006eff5a7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000006bff6d7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000006aff6b7230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000065ff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff36367812ULL, 0x000fe200078ec0ffULL, 0x20000062ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff37377812ULL, 0x000fe200078ec0ffULL, 0x20000061ff657230ULL, 0x000fe20000004100ULL,
0x00000036ff62723eULL, 0x000fc400020006ffULL, 0x00000037ff61723eULL, 0x000fe400020006ffULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011669ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe4000001166cULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff6d7819ULL, 0x000fc4000001166dULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x000010546d377816ULL, 0x000fe20000000068ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000008ff687819ULL, 0x000fe40000011634ULL,
0x00000008ff697819ULL, 0x000fe40000011635ULL, 0x00000008ff667819ULL, 0x000fe20000011666ULL,
0x000000361418723cULL, 0x008fe20000041818ULL, 0x00000010ff637819ULL, 0x000fc40000011663ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff347819ULL, 0x000fe4000001166bULL,
0x00000010ff357819ULL, 0x000fe4000001166eULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000105463347816ULL, 0x000fe20000000034ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x0000105464357816ULL, 0x000fe20000000035ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fc4000001165fULL,
0x00000010ff377819ULL, 0x000fe4000001166aULL, 0x00000010ff637819ULL, 0x000fe20000011660ULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000010ff647819ULL, 0x000fe40000011667ULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x0000105464377816ULL, 0x000fe40000000063ULL,
0x00000010ff5d7819ULL, 0x000fc4000001165dULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff347819ULL, 0x000fe20000011665ULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x00000010ff357819ULL, 0x000fe40000011666ULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL,
0x20000068ff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff5c5c7812ULL, 0x000fe200078ec0ffULL,
0x20000069ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fc40000011659ULL,
0x00000010ff377819ULL, 0x000fe40000011662ULL, 0x000010545d347816ULL, 0x000fe40000000034ULL,
0x000010545e357816ULL, 0x000fe40000000035ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x0000005cff5c723eULL, 0x000fc400020006ffULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000105461377816ULL, 0x000fe2000000005aULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff537819ULL, 0x000fe40000011653ULL, 0x00000008ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff577819ULL, 0x000fe20000011657ULL, 0x000000361424723cULL, 0x000fe20000041824ULL,
0x00000010ff587819ULL, 0x000fc40000011658ULL, 0x00000010ff347819ULL, 0x000fe4000001165fULL,
0x00000010ff357819ULL, 0x000fe40000011660ULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000105457347816ULL, 0x000fe20000000034ULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000105458357816ULL, 0x000fe20000000035ULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fc4000001163eULL,
0x00000010ff377819ULL, 0x000fe4000001163fULL, 0x00000010ff5b7819ULL, 0x000fe2000001165bULL,
0x000000341420723cULL, 0x000fe20000041820ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x000010545b367816ULL, 0x000fe40000000036ULL, 0x000010545c377816ULL, 0x000fe40000000037ULL,
0x00000010ff357819ULL, 0x000fc4000001163cULL, 0x00000010ff347819ULL, 0x000fe40000011653ULL,
0x00000010ff3d7819ULL, 0x000fe2000001163dULL, 0x00000036141c723cULL, 0x000fe2000004181cULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010543d357816ULL, 0x000fe20000000056ULL, 0x00000001ff3d7424ULL, 0x000fe200078e00ffULL,
0x000000080c367c11ULL, 0x000fca000f8e18ffULL, 0x000000341410723cULL, 0x000fe20000041810ULL,
0x0176c83d363679a7ULL, 0x0002e2000850003fULL, 0x0176903d52ff79a7ULL, 0x0003de0008500008ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000037060075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff347224ULL, 0x000fce00078e00ffULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x00000037060075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000c044157836ULL, 0x000fe20000000000ULL,
0x0000920000057ab9ULL, 0x000fc60000000800ULL, 0x000000050a177c24ULL, 0x000fe2000f8e0215ULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x000000153a147248ULL, 0x000fe20007fe0000ULL,
0x0000001009357824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe2000001160eULL,
0x00008e00000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000114147824ULL, 0x000fe400078e0a15ULL,
0x0000000135157824ULL, 0x000fe400078e0216ULL, 0x0000000416367836ULL, 0x000fe20000000000ULL,
0x0000001435147248ULL, 0x000fe20007fe0000ULL, 0x0000000115347824ULL, 0x000fc400078e020eULL,
0x0000000815377824ULL, 0x040fe400078e00ffULL, 0x0000000114147824ULL, 0x000fe400078e0a35ULL,
0x0000000115157824ULL, 0x000fe200078e0217ULL, 0xfffffff8373c7812ULL, 0x000fe200078ee234ULL,
0x0000000816347836ULL, 0x000fe20000000000ULL, 0x000000143600720cULL, 0x080fe20003f66070ULL,
0x0000000c16377836ULL, 0x000fe20000000000ULL, 0x000000141600720cULL, 0x080fe20003f86070ULL,
0x0000000135367824ULL, 0x040fe200078e0236ULL, 0x000000143400720cULL, 0x080fe20003f46070ULL,
0x0000000135347824ULL, 0x000fe200078e0234ULL, 0x000000143700720cULL, 0x000fe20003f06070ULL,
0x0000000136167824ULL, 0x000fc400078e020eULL, 0x00000008363f7824ULL, 0x000fe400078e00ffULL,
0x0000008015147825ULL, 0x000fc600078e00ffULL, 0xfffffff83f3e7812ULL, 0x000fe200078ee216ULL,
0x0000000136367824ULL, 0x000fe200078e0217ULL, 0x0000004314147212ULL, 0x000fe200078efcffULL,
0x00000001353d7824ULL, 0x002fe400078e0237ULL, 0x0000000134357824ULL, 0x040fe200078e020eULL,
0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL, 0x0000000834527824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000000b15157c10ULL, 0x000fc4000affe4ffULL,
0xfffffff852527812ULL, 0x000fe200078ee235ULL, 0x0000000134167824ULL, 0x100fe200078e0217ULL,
0x0000004336367212ULL, 0x000fe200078efcffULL, 0x000000013d347824ULL, 0x000fe400078e0217ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000a36367c10ULL, 0x000fc6000ffbe0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004316167212ULL, 0x080fe400078efcffULL,
0x0000000b37377c10ULL, 0x000fe2000affe4ffULL, 0x000000013d3f7824ULL, 0x040fe200078e020eULL,
0x0000004334347212ULL, 0x000fe200078efcffULL, 0x000000083d567824ULL, 0x000fe200078e00ffULL,
0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL, 0x000000103c3d7824ULL, 0x100fe200078e0247ULL,
0x0000000a34347c10ULL, 0x000fe2000ffde0ffULL, 0x0000001052537824ULL, 0x100fe200078e0247ULL,
0xfffffff856567812ULL, 0x000fe200078ee23fULL, 0x000000103e3f7824ULL, 0x100fe200078e0247ULL,
0x0000000b17177c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000e101c46ULL, 0x0000000b35357c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001056577824ULL, 0x000fc400078e0247ULL, 0x00000000363f7faeULL, 0x0003e8000d901c46ULL,
0x0000000016537faeULL, 0x0003e8000d101c46ULL, 0x0000000034577faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001009157824ULL, 0x000fe200078e00ffULL,
0x00008e00000a7ab9ULL, 0x000fc80000000a00ULL, 0x000000150e157211ULL, 0x000fca00078fe8ffULL,
0x0000000115167824ULL, 0x040fe400078e020eULL, 0x0000000815357824ULL, 0x040fe400078e00ffULL,
0x0000000115147824ULL, 0x000fe400078e0217ULL, 0x0000000415347836ULL, 0x000fe20000000000ULL,
0xfffffff8353c7812ULL, 0x000fe200078ee216ULL, 0x0000000815377836ULL, 0x000fe40000000000ULL,
0x0000000c15157836ULL, 0x000fc40000000000ULL, 0x0000000134167824ULL, 0x140fe400078e0217ULL,
0x0000000134357824ULL, 0x140fe400078e020eULL, 0x00000008343e7824ULL, 0x000fe400078e00ffULL,
0x0000000137347824ULL, 0x100fe400078e0217ULL, 0x0000000115367824ULL, 0x000fe200078e0217ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee235ULL, 0x0000000137177824ULL, 0x000fc400078e020eULL,
0x0000000837527824ULL, 0x002fe400078e00ffULL, 0x0000000115377824ULL, 0x040fe400078e020eULL,
0x0000000815567824ULL, 0x000fe200078e00ffULL, 0xfffffff852527812ULL, 0x000fe200078ee217ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff856567812ULL, 0x000fe200078ee237ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004314147212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004316167212ULL, 0x080fe400078efcffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004334347212ULL, 0x080fe400078efcffULL, 0x0000000a16167c10ULL, 0x000fe2000ff5e0ffULL,
0x000000103c3d7824ULL, 0x100fe200078e0247ULL, 0x0000004336367212ULL, 0x000fe200078efcffULL,
0x000000103e3f7824ULL, 0x100fe200078e0247ULL, 0x0000000b15157c10ULL, 0x000fe200087fe4ffULL,
0x0000001052537824ULL, 0x100fe200078e0247ULL, 0x0000000a34347c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001056577824ULL, 0x000fe200078e0247ULL, 0x0000000a36367c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b17177c10ULL, 0x000fc400097fe4ffULL, 0x0000000b35357c10ULL, 0x000fe400087fe4ffULL,
0x0000000b37377c10ULL, 0x000fe20009ffe4ffULL, 0x00000000163f7faeULL, 0x0003e8000b901c46ULL,
0x0000000034537faeULL, 0x0003e8000b901c46ULL, 0x0000000036577faeULL, 0x0003e4000b901c46ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000008ff157e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff00d527812ULL, 0x000fe200078ec0ffULL,
0x00000001ff167424ULL, 0x000fc600078e00ffULL, 0x000176a852527810ULL, 0x000fe40007ffe015ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000816525279a7ULL, 0x0002e4000850003fULL, 0x017648164b1679a7ULL, 0x0022a4000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0xffffffe00d347812ULL, 0x040fe400078ec0ffULL,
0x000000100d357812ULL, 0x040fe400078ec0ffULL, 0x000000080d367812ULL, 0x000fe400078ec0ffULL,
0x0000000835357c10ULL, 0x000fca000fffe034ULL, 0x00000001353d7824ULL, 0x000fc800078e0236ULL,
0x017648173d0075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003414377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017648173d0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000002039147824ULL, 0x000fe400078e00ffULL,
0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000010015147810ULL, 0x000fc80007ffe014ULL,
0x0000001446147210ULL, 0x000fca0007ffe043ULL, 0x0170000014167984ULL, 0x000ea80000000800ULL,
0x0172000014177984ULL, 0x0009220000000800ULL, 0x000000511600720bULL, 0x004fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x01afea0003800000ULL, 0x0000000208147836ULL, 0x000fe20000000000ULL,
0x000000511600720bULL, 0x000fc80003f14000ULL, 0x000000391400720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000083915ac11ULL, 0x000fe4000f8e38ffULL,
0x000000511614a209ULL, 0x000fe40007810000ULL, 0x000000154637a210ULL, 0x000fe40007ffe043ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005116147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005114147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160eULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001550507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005116517209ULL, 0x000fd60007810000ULL,
0x8000005116160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600050308ULL, 0x000ea40000000800ULL,
0x0000000517170220ULL, 0x004fce0000410000ULL, 0x0000005017507221ULL, 0x000fe20000010000ULL,
0x0000000000147805ULL, 0x002fe40000015200ULL, 0xfffffff00d177812ULL, 0x000fc800078ec0ffULL,
0x0176a855170075a7ULL, 0x000ea20008000148ULL, 0x0000000817377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176a855370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000080e157812ULL, 0x000fe400078ec0ffULL, 0x0000991034147816ULL, 0x000fe400000000ffULL,
0x0000000715167812ULL, 0x000fe400078ef80eULL, 0x000000ff1400720cULL, 0x000fc60003f05270ULL,
0x00000001164d7824ULL, 0x040fe400078e024dULL, 0x0000000816347824ULL, 0x000fca00078e00ffULL,
0xfffffff834347812ULL, 0x000fca00078ee24dULL, 0x0000001034347824ULL, 0x000fe200078e0241ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160eULL,
0x00000005ff02723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541002147816ULL, 0x000fca0000000002ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514027589ULL, 0x0002e400000e0000ULL, 0x012000004f14783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000215157232ULL, 0x080fe40000200000ULL,
0x0000000217177232ULL, 0x000fce0000200000ULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x000000104e3c7824ULL, 0x000fcc00078e0241ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x00000018ff4f7819ULL, 0x012fe40000011635ULL, 0x000000ff344e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff35547812ULL, 0x000fe400078ec0ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x000000ff3c697812ULL, 0x020fe400078ec0ffULL, 0x000000ff3e677812ULL, 0x000fe200078ec0ffULL,
0x2000004fff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fc40000011637ULL,
0x000000ff375a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe40000011637ULL,
0x0000ffff375b7812ULL, 0x000fe400078ec0ffULL, 0x0000004eff5f723eULL, 0x000fe400020006ffULL,
0x000000ff3f687812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4d7819ULL, 0x000fe20000011634ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000054ff37723eULL, 0x000fc400020006ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001163eULL, 0x00000010ff627819ULL, 0x100fe20000011636ULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x000000ff36577812ULL, 0x040fe400078ec0ffULL,
0x00000018ff557819ULL, 0x000fe40000011636ULL, 0x0000ffff36597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x000fc4000001163cULL, 0x00000018ff547819ULL, 0x000fe4000001163cULL,
0x0000ffff3c617812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4b7819ULL, 0x000fe40000011634ULL,
0x0000ffff34647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff367819ULL, 0x000fe4000001163eULL,
0x0000ffff3e3c7812ULL, 0x000fc400078ec0ffULL, 0x00000069ff4f723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001163dULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x100fe4000001163fULL,
0x00000018ff3e7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f567812ULL, 0x000fc400078ec0ffULL,
0x00000068ff69723eULL, 0x000fe400020006ffULL, 0x0000004eff68723eULL, 0x000fe400020006ffULL,
0x000000ff4d3f7812ULL, 0x000fe200078ec0ffULL, 0x20000067ff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe20000011635ULL, 0x20000069ff4e7230ULL, 0x000fe20000004100ULL,
0x0000ffff35657812ULL, 0x000fe400078ec0ffULL, 0x0000004bff35723eULL, 0x000fc400020006ffULL,
0x0000006aff4b723eULL, 0x000fe400020006ffULL, 0x0000003eff6a723eULL, 0x000fe200020006ffULL,
0x20000068ff3e7230ULL, 0x000fe20000004100ULL, 0x0000003fff67723eULL, 0x000fe200020006ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x000000ff66687812ULL, 0x000fe200078ec0ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x000000ff62627812ULL, 0x000fe200078ec0ffULL,
0x2000006aff3f7230ULL, 0x000fe20000004100ULL, 0x000000ff63637812ULL, 0x000fc400078ec0ffULL,
0x00000008ff667819ULL, 0x000fe20000011664ULL, 0x20000067ff647230ULL, 0x000fe20000004100ULL,
0x00000068ff67723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000063ff68723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fe2000001163dULL, 0x20000062ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x20000068ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff5b7819ULL, 0x000fc4000001165bULL, 0x000000ff60687812ULL, 0x000fe400078ec0ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x20000059ff607230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000008ff697819ULL, 0x000fc40000011665ULL,
0x00000061ff59723eULL, 0x000fe200020006ffULL, 0x2000005bff617230ULL, 0x000fe20000004100ULL,
0x00000066ff65723eULL, 0x000fe200020006ffULL, 0x20000068ff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff36687812ULL, 0x000fe400078ec0ffULL, 0x00000069ff66723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe4000001165fULL,
0x00000010ff5f7819ULL, 0x000fe20000011637ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fc40000011664ULL, 0x00000010ff647819ULL, 0x000fe40000011667ULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x000000ff3d6b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3d5d7812ULL, 0x000fe400078ec0ffULL, 0x0000105464377816ULL, 0x000fe4000000005fULL,
0x00000057ff3d723eULL, 0x000fc400020006ffULL, 0x000000ff34647812ULL, 0x000fe400078ec0ffULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe20000011635ULL, 0x000000361418723cULL, 0x008fe20000041818ULL,
0x00000010ff347819ULL, 0x000fe20000011665ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165eULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x20000055ff577230ULL, 0x000fe20000004100ULL,
0x000010545f357816ULL, 0x000fe40000000066ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000054ff55723eULL, 0x000fc400020006ffULL, 0x00000008ff367819ULL, 0x000fe2000001163cULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe4000001163dULL,
0x00000010ff3d7819ULL, 0x000fe2000001165aULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000008ff697819ULL, 0x000fe2000001165dULL, 0x2000005cff5d7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000059ff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff347819ULL, 0x000fe40000011656ULL, 0x00001054633c7816ULL, 0x000fe2000000003cULL,
0x2000006bff547230ULL, 0x000fe20000004100ULL, 0x00001054623d7816ULL, 0x000fe4000000003dULL,
0x00000034ff35723eULL, 0x000fc400020006ffULL, 0x00000036ff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff557819ULL, 0x000fe20000011655ULL, 0x0000003c142c723cULL, 0x000fe2000004182cULL,
0x00000010ff347819ULL, 0x000fe2000001165cULL, 0x2000005fff567230ULL, 0x000fe20000004100ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff367819ULL, 0x000fc40000011660ULL, 0x00000010ff377819ULL, 0x000fe40000011661ULL,
0x00000010ff3d7819ULL, 0x000fe40000011654ULL, 0x0000105455347816ULL, 0x000fe40000000034ULL,
0x0000105457367816ULL, 0x000fe40000000036ULL, 0x0000105458377816ULL, 0x000fe40000000037ULL,
0x00000010ff3c7819ULL, 0x000fe2000001164fULL, 0x20000035ff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fc4000001165dULL, 0x00000010ff547819ULL, 0x000fe2000001165bULL,
0x000000361430723cULL, 0x000fe20000041830ULL, 0x000000070e557812ULL, 0x000fe400078ec0ffULL,
0x00000069ff59723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x000010545d3c7816ULL, 0x000fe2000000003cULL, 0x20000068ff5e7230ULL, 0x000fe20000004100ULL,
0x00001054543d7816ULL, 0x000fe2000000003dULL, 0x20000064ff5a7230ULL, 0x000fe20000004100ULL,
0x0000000855557812ULL, 0x000fc400078ef80eULL, 0x00000010ff377819ULL, 0x000fe2000001164eULL,
0x000000024a4e7836ULL, 0x000fe20000000000ULL, 0x00000010ff367819ULL, 0x000fe2000001164bULL,
0x0000000855557824ULL, 0x000fe200078e00ffULL, 0x00000010ff357819ULL, 0x000fe20000011659ULL,
0x0000003c1424723cULL, 0x000fe20000041824ULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff5a7819ULL, 0x000fc4000001165aULL,
0x00000010ff3d7819ULL, 0x000fe4000001163eULL, 0x00000010ff3c7819ULL, 0x000fe4000001163fULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0xfffffff8554e7812ULL, 0x000fe400078ee24eULL, 0x0000105436357816ULL, 0x000fc40000000035ULL,
0x000010545e367816ULL, 0x000fe2000000004dULL, 0x000000104e457824ULL, 0x000fe200078e0245ULL,
0x000010545a377816ULL, 0x000fe40000000037ULL, 0x000010543d567816ULL, 0x000fe20000000056ULL,
0x000000341420723cULL, 0x000fe20000041820ULL, 0x000010543c577816ULL, 0x000fca000000004fULL,
0x00000036141c723cULL, 0x000fe2000004181cULL, 0x0000001048347824ULL, 0x000fca00078e0241ULL,
0x000000561410723cULL, 0x000fe20000041810ULL, 0x012000004514783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000215157232ULL, 0x080fe40000200000ULL, 0x0000000217177232ULL, 0x000fce0000200000ULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x000000104c3c7824ULL, 0x000fcc00078e0241ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x00000010ff667819ULL, 0x010fe40000011634ULL,
0x00000010ff657819ULL, 0x100fe40000011635ULL, 0x0000ffff34647812ULL, 0x040fe400078ec0ffULL,
0x000000ff344b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011635ULL,
0x00000010ff5d7819ULL, 0x000fc40000011636ULL, 0x000000ff36547812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011636ULL, 0x00000010ff5f7819ULL, 0x100fe40000011637ULL,
0x000000ff37587812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe40000011637ULL,
0x000000ff354d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff36367812ULL, 0x000fe400078ec0ffULL,
0x0000ffff37377812ULL, 0x000fe400078ec0ffULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x0000004bff4b723eULL, 0x000fc400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x2000004bff637230ULL, 0x000fe20000004100ULL,
0x0000ffff355e7812ULL, 0x000fe200078ec0ffULL, 0x2000004cff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x0000004dff62723eULL, 0x000fe400020006ffULL,
0x00000018ff677819ULL, 0x022fc4000001163cULL, 0x00000018ff687819ULL, 0x000fe2000001163dULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000008ff367819ULL, 0x000fe40000011636ULL,
0x00000008ff377819ULL, 0x000fe40000011637ULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x00000018ff457819ULL, 0x000fe40000011634ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000008ff5e7819ULL, 0x000fe4000001165eULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff607819ULL, 0x000fe4000001163cULL, 0x00000067ff4c723eULL, 0x000fe200020006ffULL,
0x20000066ff677230ULL, 0x000fe20000004100ULL, 0x00000068ff4b723eULL, 0x000fe200020006ffULL,
0x20000065ff687230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x20000064ff667230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fe200020006ffULL,
0x2000005dff647230ULL, 0x000fe20000004100ULL, 0x000000ff3c597812ULL, 0x000fe200078ec0ffULL,
0x2000005fff657230ULL, 0x000fe20000004100ULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x20000036ff5f7230ULL, 0x000fe20000004100ULL, 0x00000045ff5c723eULL, 0x000fe200020006ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe2000001163dULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x000000ff3d697812ULL, 0x040fe200078ec0ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000ffff3d357812ULL, 0x000fc400078ec0ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000010ff567819ULL, 0x100fe4000001163fULL,
0x000000ff3f6b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001163fULL,
0x0000ffff3f4d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff605d7812ULL, 0x000fe200078ec0ffULL,
0x20000037ff607230ULL, 0x000fe20000004100ULL, 0x00000059ff3f723eULL, 0x000fe200020006ffULL,
0x20000054ff597230ULL, 0x000fe20000004100ULL, 0x000000ff61617812ULL, 0x000fc400078ec0ffULL,
0x00000010ff367819ULL, 0x000fe40000011663ULL, 0x00000010ff377819ULL, 0x000fe40000011662ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x0000ffff3c347812ULL, 0x000fe400078ec0ffULL, 0x00000069ff54723eULL, 0x000fe200020006ffULL,
0x2000005eff697230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fc400020006ffULL,
0x00000061ff5e723eULL, 0x000fe200020006ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x0000105467367816ULL, 0x000fe20000000036ULL, 0x20000058ff5a7230ULL, 0x000fe20000004100ULL,
0x0000105468377816ULL, 0x000fe20000000037ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff617819ULL, 0x000fe40000011634ULL, 0x00000008ff627819ULL, 0x000fe40000011635ULL,
0x00000010ff357819ULL, 0x000fe2000001165cULL, 0x000000361418723cULL, 0x008fe20000041818ULL,
0x00000010ff347819ULL, 0x000fc40000011666ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165bULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff557819ULL, 0x100fe4000001163eULL,
0x000000ff3e6a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e457812ULL, 0x000fc400078ec0ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x00000057ff3e723eULL, 0x000fe400020006ffULL, 0x0000105435347816ULL, 0x000fe20000000034ULL,
0x2000004fff577230ULL, 0x000fe20000004100ULL, 0x000010545c357816ULL, 0x000fe20000000069ULL,
0x2000003eff587230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011659ULL,
0x2000003fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fc40000011664ULL,
0x00000010ff5b7819ULL, 0x000fe2000001165aULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff5c7819ULL, 0x000fe40000011665ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x000010545c377816ULL, 0x000fe2000000005bULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff577819ULL, 0x000fc40000011657ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff347819ULL, 0x000fe2000001165fULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff357819ULL, 0x000fe40000011660ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x000000ff55557812ULL, 0x000fe200078ec0ffULL, 0x20000061ff597230ULL, 0x000fe20000004100ULL,
0x000000ff56567812ULL, 0x000fe200078ec0ffULL, 0x20000062ff5a7230ULL, 0x000fe20000004100ULL,
0x0000105457347816ULL, 0x000fc40000000034ULL, 0x0000105458357816ULL, 0x000fe40000000035ULL,
0x00000010ff367819ULL, 0x000fe4000001164fULL, 0x00000010ff377819ULL, 0x000fe40000011654ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x0000006aff3e723eULL, 0x000fc400020006ffULL,
0x0000006bff3f723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000010545d367816ULL, 0x000fe20000000036ULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x000010545e377816ULL, 0x000fe20000000037ULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000008ff457819ULL, 0x000fc40000011645ULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff357819ULL, 0x000fe2000001164cULL,
0x000000361424723cULL, 0x000fe20000041824ULL, 0x00000010ff347819ULL, 0x000fe40000011659ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x0000003dff3d723eULL, 0x000fc400020006ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x000010544b357816ULL, 0x000fe2000000005aULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fc4000001163eULL, 0x00000010ff377819ULL, 0x000fe4000001163fULL,
0x00000010ff557819ULL, 0x000fe20000011655ULL, 0x000000341420723cULL, 0x000fe20000041820ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x0000105455367816ULL, 0x000fe40000000036ULL,
0x0000105456377816ULL, 0x000fe40000000037ULL, 0x00000010ff347819ULL, 0x000fc4000001163dULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff457819ULL, 0x000fe20000011645ULL,
0x00000036141c723cULL, 0x000fe2000004181cULL, 0x00000010ff3d7819ULL, 0x000fe4000001164dULL,
0x000010543c3c7816ULL, 0x000fe40000000045ULL, 0x00001054343d7816ULL, 0x000fe4000000003dULL,
0x00000001ff377424ULL, 0x000fe200078e00ffULL, 0x0000000808367c11ULL, 0x000fc6000f8e18ffULL,
0x00000037063479a7ULL, 0x0002e2000850003fULL, 0x0000003c1410723cULL, 0x000fe20000041810ULL,
0x0176983736ff79a7ULL, 0x0003de000850003fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x002fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000107157836ULL, 0x000fca0000000000ULL, 0x000000381500720cULL, 0x000fda0003f06070ULL,
0x0000000400d40947ULL, 0x000fea0003800000ULL, 0x0000000207157836ULL, 0x000fe20000000000ULL,
0x0000920000057ab9ULL, 0x000fc80000000800ULL, 0x000000381500720cULL, 0x000fe20003f06070ULL,
0x0000010044157836ULL, 0x000fc80000000000ULL, 0x000000050a377c24ULL, 0x002fd0000f8e0215ULL,
0x0000000000f88947ULL, 0x000fea0003800000ULL, 0x000000153a147248ULL, 0x000fe20007fe0000ULL,
0x0000001009177824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe2000001160eULL,
0x00008e00000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000114147824ULL, 0x000fe400078e0a15ULL,
0x0000000117157824ULL, 0x000fe400078e0216ULL, 0x0000000816367836ULL, 0x000fe20000000000ULL,
0x0000001417147248ULL, 0x000fe20007fe0000ULL, 0x0000000115347824ULL, 0x000fc400078e020eULL,
0x00000008153d7824ULL, 0x000fe400078e00ffULL, 0x0000000114147824ULL, 0x000fe400078e0a17ULL,
0x0000000416357836ULL, 0x000fe20000000000ULL, 0xfffffff83d3c7812ULL, 0x000fe400078ee234ULL,
0x000000141600720cULL, 0x080fe20003f86070ULL, 0x0000000c16167836ULL, 0x000fe20000000000ULL,
0x000000143600720cULL, 0x080fe20003f46070ULL, 0x0000000117367824ULL, 0x000fe200078e0236ULL,
0x000000143500720cULL, 0x080fe20003f66070ULL, 0x0000000117347824ULL, 0x040fe200078e0235ULL,
0x000000141600720cULL, 0x000fe20003f06070ULL, 0x00000001173d7824ULL, 0x000fc400078e0216ULL,
0x0000000136177824ULL, 0x140fe400078e020eULL, 0x0000000836447824ULL, 0x000fe400078e00ffULL,
0x0000000134147824ULL, 0x040fe400078e020eULL, 0x0000000834357824ULL, 0x040fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee217ULL, 0x0000000115167824ULL, 0x100fe400078e0237ULL,
0x0000000134347824ULL, 0x000fe200078e0237ULL, 0xfffffff8353e7812ULL, 0x000fe200078ee214ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004316167212ULL, 0x000fc600078efcffULL, 0x0000000136147824ULL, 0x100fe200078e0237ULL,
0x0000004334347212ULL, 0x080fe200078efcffULL, 0x000000013d367824ULL, 0x040fe200078e0237ULL,
0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000a34347c10ULL, 0x000fe4000ffde0ffULL, 0x0000000b17177c10ULL, 0x000fe2000affe4ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004314147212ULL, 0x080fe400078efcffULL,
0x0000000b35357c10ULL, 0x000fe2000b7fe4ffULL, 0x000000013d3f7824ULL, 0x040fe200078e020eULL,
0x0000004336367212ULL, 0x000fe200078efcffULL, 0x000000083d4c7824ULL, 0x000fe200078e00ffULL,
0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL, 0x000000103c3d7824ULL, 0x100fe200078e0241ULL,
0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL, 0x0000001044457824ULL, 0x100fe200078e0241ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee23fULL, 0x000000103e3f7824ULL, 0x100fe200078e0241ULL,
0x0000000b15157c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000163d7faeULL, 0x0003e2000e101c46ULL, 0x0000000b37377c10ULL, 0x000fe2000b7fe4ffULL,
0x000000104c417824ULL, 0x000fc400078e0241ULL, 0x00000000343f7faeULL, 0x0003e8000d901c46ULL,
0x0000000014457faeULL, 0x0003e8000d101c46ULL, 0x0000000036417faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001009157824ULL, 0x000fe200078e00ffULL,
0x00008e00000a7ab9ULL, 0x000fc80000000a00ULL, 0x000000150e157211ULL, 0x000fca00078fe8ffULL,
0x0000000115167824ULL, 0x040fe400078e020eULL, 0x0000000815177824ULL, 0x040fe400078e00ffULL,
0x00000008153d7836ULL, 0x000fe40000000000ULL, 0x0000000c153e7836ULL, 0x000fe20000000000ULL,
0xfffffff8173c7812ULL, 0x000fe200078ee216ULL, 0x0000000415177836ULL, 0x000fe40000000000ULL,
0x0000000115147824ULL, 0x000fc400078e0237ULL, 0x0000000117167824ULL, 0x140fe400078e0237ULL,
0x0000000117357824ULL, 0x140fe400078e020eULL, 0x0000000817447824ULL, 0x000fe400078e00ffULL,
0x000000013d367824ULL, 0x140fe400078e0237ULL, 0x000000013e347824ULL, 0x000fe400078e0237ULL,
0x000000013d177824ULL, 0x000fc400078e020eULL, 0x000000083d4c7824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x000000013e377824ULL, 0x000fe200078e020eULL,
0x0000004314147212ULL, 0x080fe200078efcffULL, 0x000000083e547824ULL, 0x000fe200078e00ffULL,
0xfffffff8443e7812ULL, 0x000fe200078ee235ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff84c447812ULL, 0x000fe400078ee217ULL, 0xfffffff8544c7812ULL, 0x000fe200078ee237ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe4000ff1e0ffULL,
0x0000004334347212ULL, 0x080fe200078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004316167212ULL, 0x000fc400078efcffULL, 0x0000000b15157c10ULL, 0x000fe200087fe4ffULL,
0x000000103c3d7824ULL, 0x100fe200078e0241ULL, 0x0000004336367212ULL, 0x000fe200078efcffULL,
0x000000103e3f7824ULL, 0x100fe200078e0241ULL, 0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001044457824ULL, 0x100fe200078e0241ULL, 0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL,
0x000000104c417824ULL, 0x000fe200078e0241ULL, 0x0000000a34347c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b17177c10ULL, 0x000fc400087fe4ffULL, 0x0000000b37377c10ULL, 0x000fe400097fe4ffULL,
0x0000000b35357c10ULL, 0x000fe20009ffe4ffULL, 0x00000000163f7faeULL, 0x0003e8000b901c46ULL,
0x0000000036457faeULL, 0x0003e8000b901c46ULL, 0x0000000034417faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000010c147812ULL, 0x000fe200078ec0ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000000808157c11ULL, 0x000fe2000f8e28ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x000000080d377812ULL, 0x000fc600078ec0ffULL,
0x0000001014167824ULL, 0x000fe200078e0215ULL, 0x000000080c147c11ULL, 0x000fe2000f8e20ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0176a834141479a7ULL, 0x0002e2000850003fULL,
0x0000000137377824ULL, 0x000fc800078e0216ULL, 0x01766834373479a7ULL, 0x0022a4000850003fULL,
0x000000ffff417224ULL, 0x00afce00078e0015ULL, 0x0000000000147805ULL, 0x000fe20000015200ULL,
0x01766835370075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x00000016143d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003d16167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01766835370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000808147c11ULL, 0x000fe2000f8e38ffULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0051ULL,
0x0000018043157810ULL, 0x000fca0007ffe014ULL, 0x0000000146157824ULL, 0x000fca00078e0215ULL,
0x0170000015147984ULL, 0x000e680000000800ULL, 0x0172000015177984ULL, 0x0004a20000000800ULL,
0x000000511400720bULL, 0x002fda0003f1d000ULL, 0x0000000000167806ULL, 0x000fc800000e0100ULL,
0x0000ffff16357812ULL, 0x000fda000780c0ffULL, 0x0000000000f88947ULL, 0x004fea0003800000ULL,
0x0000000308167836ULL, 0x000fe20000000000ULL, 0x000000511400720bULL, 0x0c0fe40003f14000ULL,
0x00000051144c7209ULL, 0x000fe40007810000ULL, 0x000000391600720cULL, 0x000fd20003f45270ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x000000083915ac11ULL, 0x000fc8000f8e38ffULL,
0x000000154643a210ULL, 0x000fe40007ffe043ULL, 0x0000991016157816ULL, 0x000fc600000000ffULL,
0x0174004c4300a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x000000514c157221ULL, 0x000fe20000010100ULL,
0x000000ff16ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0016ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b15157820ULL, 0x000fc80000410000ULL, 0x0000001500377308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff347819ULL, 0x000fca000001160eULL,
0x00001f3437157589ULL, 0x006e6400000e0000ULL, 0x0000001815187220ULL, 0x042fe20000410000ULL,
0x0000001915197220ULL, 0x040fe20000410000ULL, 0x0000002815287220ULL, 0x040fe20000410000ULL,
0x0000002915297220ULL, 0x040fe20000410000ULL, 0x0000002c152c7220ULL, 0x040fe20000410000ULL,
0x0000002d152d7220ULL, 0x040fe20000410000ULL, 0x0000003015307220ULL, 0x040fe20000410000ULL,
0x0000003115317220ULL, 0x040fe20000410000ULL, 0x0000002415247220ULL, 0x040fe20000410000ULL,
0x0000002515257220ULL, 0x040fe20000410000ULL, 0x0000002015207220ULL, 0x040fe20000410000ULL,
0x0000002115217220ULL, 0x040fe20000410000ULL, 0x0000001c151c7220ULL, 0x040fe20000410000ULL,
0x0000001d151d7220ULL, 0x040fe20000410000ULL, 0x0000001015107220ULL, 0x040fe20000410000ULL,
0x0000001115117220ULL, 0x000fce0000410000ULL, 0x0000003750507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080e347811ULL, 0x000fca00078ff0ffULL,
0x00001f3437157589ULL, 0x002e6400000e0000ULL, 0x0000001a151a7220ULL, 0x042fe20000410000ULL,
0x0000001b151b7220ULL, 0x040fe20000410000ULL, 0x0000002a152a7220ULL, 0x040fe20000410000ULL,
0x0000002b152b7220ULL, 0x040fe20000410000ULL, 0x0000002e152e7220ULL, 0x040fe20000410000ULL,
0x0000002f152f7220ULL, 0x040fe20000410000ULL, 0x0000003215327220ULL, 0x040fe20000410000ULL,
0x0000003315337220ULL, 0x040fe20000410000ULL, 0x0000002615267220ULL, 0x040fe20000410000ULL,
0x0000002715277220ULL, 0x040fe20000410000ULL, 0x0000002215227220ULL, 0x040fe20000410000ULL,
0x0000002315237220ULL, 0x040fe20000410000ULL, 0x0000001e151e7220ULL, 0x040fe20000410000ULL,
0x0000001f151f7220ULL, 0x040fe20000410000ULL, 0x0000001215127220ULL, 0x040fe20000410000ULL,
0x0000001315137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806016ULL,
0x00000001ff347424ULL, 0x000fd800078e00ffULL, 0x000000144c140221ULL, 0x000fe20000010100ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL,
0x0000001400050308ULL, 0x000ea40000000800ULL, 0x0000000517170220ULL, 0x004fce0000410000ULL,
0x0000005017507221ULL, 0x000fe20000010000ULL, 0x0000000000147805ULL, 0x002fe40000015200ULL,
0xfffffff00d177812ULL, 0x000fe200078ec0ffULL, 0x0000000439167824ULL, 0x000fc600078e00ffULL,
0x0176b053170075a7ULL, 0x000ea20008000148ULL, 0x00000008173d7c36ULL, 0x000fe20008000000ULL,
0x0000000416167812ULL, 0x000fc800078ec0ffULL, 0x0000000216357812ULL, 0x000fe200078efcffULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176b0533d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000070e3d7812ULL, 0x000fe400078ec0ffULL, 0x0000991034147816ULL, 0x000fe400000000ffULL,
0x000000083d157812ULL, 0x000fe400078ef80eULL, 0x000000ff1400720cULL, 0x000fe40003f05270ULL,
0x0000000808147c11ULL, 0x000fe2000f8e58ffULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0x000000350e437211ULL, 0x000fc400078fe0ffULL, 0x000000080e3c7812ULL, 0x000fe400078ec0ffULL,
0xfffffff815157812ULL, 0x000fca00078ee24aULL, 0x0000001015147824ULL, 0x000fe200078e0214ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff167819ULL, 0x000fe4000001160eULL,
0x00000005ff02723eULL, 0x000fc600000010ffULL, 0x0000000816347836ULL, 0x000fe20000000000ULL,
0x0000541002157816ULL, 0x000fca0000000002ULL, 0x00001f1615037589ULL, 0x0002a800000e0000ULL,
0x00001f3415027589ULL, 0x0002e400000e0000ULL, 0x012800001414783bULL, 0x002e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x086fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000215157232ULL, 0x088fe40000200000ULL,
0x0000000217177232ULL, 0x000fce0000200000ULL, 0x0000003d3c3e7212ULL, 0x000fe200078efcffULL,
0x000000004934783bULL, 0x000f220000004200ULL, 0x0000000308457836ULL, 0x000fc60000000000ULL,
0x000000013e3c7824ULL, 0x040fe400078e0243ULL, 0x000000083e3d7824ULL, 0x000fe200078e00ffULL,
0x0000000845457c11ULL, 0x000fc8000f8e58ffULL, 0xfffffff83d3c7812ULL, 0x000fe200078ee23cULL,
0x000000104e4e7824ULL, 0x000fc800078e0245ULL, 0x000000103c3c7824ULL, 0x000fcc00078e0247ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x00000010ff5e7819ULL, 0x110fe40000011634ULL,
0x000000ff34467812ULL, 0x040fe400078ec0ffULL, 0x00000018ff457819ULL, 0x000fe40000011634ULL,
0x0000ffff345c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff35347812ULL, 0x000fe400078ec0ffULL,
0x000000ff364a7812ULL, 0x000fc400078ec0ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000034ff56723eULL, 0x000fe400020006ffULL, 0x000000ff374f7812ULL, 0x000fe200078ec0ffULL,
0x20000046ff557230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x0000ffff355d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff607819ULL, 0x028fc4000001163dULL, 0x00000010ff517819ULL, 0x100fe4000001163eULL,
0x000000ff3e637812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe4000001163eULL,
0x0000ffff3e347812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001163fULL,
0x000000ff3c5f7812ULL, 0x000fc400078ec0ffULL, 0x00000060ff46723eULL, 0x000fe400020006ffULL,
0x00000010ff447819ULL, 0x000fe40000011635ULL, 0x00000010ff527819ULL, 0x000fe2000001163dULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x000000ff3d617812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3d587812ULL, 0x000fe400078ec0ffULL, 0x0000003eff60723eULL, 0x000fc400020006ffULL,
0x0000004fff3d723eULL, 0x000fe200020006ffULL, 0x2000004aff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff5b7819ULL, 0x000fe40000011636ULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x0000005fff4a723eULL, 0x000fe400020006ffULL, 0x00000008ff5d7819ULL, 0x000fe4000001165dULL,
0x000000ff445f7812ULL, 0x000fe200078ec0ffULL, 0x20000060ff447230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x000fe20000011637ULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000ffff365a7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5b607812ULL, 0x000fe400078ec0ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005dff5b723eULL, 0x000fe400020006ffULL,
0x000000ff59597812ULL, 0x000fe200078ec0ffULL, 0x2000005cff5d7230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x2000005bff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff5a7819ULL, 0x000fc4000001165aULL, 0x00000018ff4d7819ULL, 0x000fe40000011637ULL,
0x0000ffff37377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff577819ULL, 0x000fe4000001163cULL,
0x00000059ff5b723eULL, 0x000fe400020006ffULL, 0x0000005aff59723eULL, 0x000fe200020006ffULL,
0x20000060ff5a7230ULL, 0x000fe20000004100ULL, 0x00000008ff377819ULL, 0x000fe20000011637ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x000000ff57607812ULL, 0x000fe200078ec0ffULL,
0x20000059ff577230ULL, 0x000fe20000004100ULL, 0x0000ffff3c537812ULL, 0x000fc400078ec0ffULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x00000060ff59723eULL, 0x000fe400020006ffULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x00000008ff607819ULL, 0x000fe20000011658ULL, 0x20000037ff587230ULL, 0x000fe20000004100ULL,
0x00000018ff497819ULL, 0x000fe20000011636ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x00000008ff537819ULL, 0x000fe40000011653ULL,
0x00000018ff477819ULL, 0x000fe20000011635ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000045ff35723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000018ff457819ULL, 0x000fe2000001163cULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000049ff3c723eULL, 0x000fe400020006ffULL,
0x00000053ff37723eULL, 0x000fe200020006ffULL, 0x20000052ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe2000001163fULL, 0x20000060ff527230ULL, 0x000fe20000004100ULL,
0x0000004dff49723eULL, 0x000fe200020006ffULL, 0x2000003dff4d7230ULL, 0x000fe20000004100ULL,
0x00000061ff3d723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x000000ff51617812ULL, 0x000fe200078ec0ffULL, 0x20000037ff517230ULL, 0x000fe20000004100ULL,
0x000000ff36607812ULL, 0x000fe200078ec0ffULL, 0x20000047ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011655ULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fc4000001165eULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x000010545f377816ULL, 0x000fe40000000056ULL, 0x00000008ff567819ULL, 0x000fe40000011634ULL,
0x00000010ff357819ULL, 0x000fc40000011635ULL, 0x00000010ff347819ULL, 0x000fe2000001165dULL,
0x000000361418723cULL, 0x002fe20000041818ULL, 0x00000010ff5f7819ULL, 0x000fe40000011654ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x0000ffff3f4b7812ULL, 0x000fe400078ec0ffULL, 0x000010545f357816ULL, 0x000fc4000000005cULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x000000ff3f647812ULL, 0x000fe400078ec0ffULL,
0x00000056ff5d723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe2000001164fULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff377819ULL, 0x000fe4000001165aULL, 0x00000008ff5c7819ULL, 0x000fe2000001164bULL,
0x2000005dff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff4d7819ULL, 0x000fc4000001164dULL,
0x00000010ff567819ULL, 0x000fe4000001165bULL, 0x00000063ff47723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000062ff3f723eULL, 0x000fe200020006ffULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x20000064ff3e7230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000061ff557230ULL, 0x000fe20000004100ULL,
0x0000105456377816ULL, 0x000fe2000000004dULL, 0x20000060ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe2000001163cULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fe4000001164aULL, 0x00000010ff4a7819ULL, 0x000fe20000011646ULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff457819ULL, 0x000fc40000011645ULL,
0x00000010ff467819ULL, 0x000fe40000011651ULL, 0x00000010ff347819ULL, 0x000fe40000011657ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x0000105445467816ULL, 0x000fe40000000046ULL, 0x0000105435347816ULL, 0x000fc40000000034ULL,
0x00000010ff377819ULL, 0x000fe40000011647ULL, 0x00000010ff457819ULL, 0x000fe4000001163eULL,
0x0000105449357816ULL, 0x000fe40000000058ULL, 0x00000010ff477819ULL, 0x000fe40000011652ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff3e7819ULL, 0x000fe2000001164bULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000010ff597819ULL, 0x000fc40000011659ULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff367819ULL, 0x000fe40000011653ULL,
0x00000010ff527819ULL, 0x000fe40000011655ULL, 0x00000010ff547819ULL, 0x000fe40000011654ULL,
0x00000010ff497819ULL, 0x000fe40000011644ULL, 0x00000010ff5c7819ULL, 0x000fc4000001165cULL,
0x000010544a477816ULL, 0x000fe40000000047ULL, 0x000010543f3e7816ULL, 0x000fe4000000003eULL,
0x00001054593c7816ULL, 0x000fe4000000003cULL, 0x00001054363d7816ULL, 0x000fe2000000003dULL,
0x000000461420723cULL, 0x000fe20000041820ULL, 0x00001054524a7816ULL, 0x000fe40000000037ULL,
0x00001054544b7816ULL, 0x000fe20000000045ULL, 0x011000004e34783bULL, 0x0002e20000000200ULL,
0x00001054493f7816ULL, 0x000fe2000000005cULL, 0x0000003c1424723cULL, 0x000fec0000041824ULL,
0x0000004a141c723cULL, 0x000fec000004181cULL, 0x0000003e1410723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000100947ULL, 0x002fde0003800000ULL,
0x0000000334347232ULL, 0x08cfe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000235357232ULL, 0x080fe40000200000ULL, 0x0000000237377232ULL, 0x000fce0000200000ULL,
0x0001400004047836ULL, 0x000fe40000000000ULL, 0x0000000100437824ULL, 0x000fe400078e0243ULL,
0x0000001048147824ULL, 0x000fe400078e0204ULL, 0x0000000800007824ULL, 0x000fe400078e00ffULL,
0x0000000107077836ULL, 0x000fe40000000000ULL, 0x000000001414783bULL, 0x000e620000004200ULL,
0xfffffff800437812ULL, 0x000fca00078ee243ULL, 0x00000010433c7824ULL, 0x000fcc00078e0204ULL,
0x000000003c3c783bULL, 0x000f220000004200ULL, 0x000000ff16517812ULL, 0x002fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe40000011614ULL, 0x00000018ff4d7819ULL, 0x000fe40000011615ULL,
0x00000018ff4e7819ULL, 0x000fe40000011616ULL, 0x000000ff17527812ULL, 0x000fe400078ec0ffULL,
0x00000051ff54723eULL, 0x000fc400020006ffULL, 0x00000010ff4b7819ULL, 0x000fe40000011614ULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000ffff14587812ULL, 0x000fe200078ec0ffULL, 0x20000046ff517230ULL, 0x000fe20000004100ULL,
0x00000052ff57723eULL, 0x000fe200020006ffULL, 0x2000004dff527230ULL, 0x000fe20000004100ULL,
0x0000004eff55723eULL, 0x000fe200020006ffULL, 0x20000054ff4e7230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fe20000011615ULL, 0x20000057ff4d7230ULL, 0x000fe20000004100ULL,
0x00000018ff567819ULL, 0x000fe20000011617ULL, 0x20000055ff467230ULL, 0x000fe20000004100ULL,
0x0000ffff15597812ULL, 0x000fc400078ec0ffULL, 0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff547819ULL, 0x000fe40000011658ULL, 0x00000056ff57723eULL, 0x000fe400020006ffULL,
0x000000ff53557812ULL, 0x000fe400078ec0ffULL, 0x00000008ff567819ULL, 0x000fe40000011659ULL,
0x0000004bff53723eULL, 0x000fe200020006ffULL, 0x20000057ff4b7230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x00000010ff5b7819ULL, 0x000fe20000011616ULL,
0x20000053ff597230ULL, 0x000fe20000004100ULL, 0x0000ffff165d7812ULL, 0x000fe200078ec0ffULL,
0x20000054ff587230ULL, 0x000fe20000004100ULL, 0x0000ffff175e7812ULL, 0x000fe400078ec0ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff537819ULL, 0x000fe2000001165dULL, 0x20000056ff577230ULL, 0x000fe20000004100ULL,
0x00000008ff547819ULL, 0x000fc4000001165eULL, 0x00000010ff5c7819ULL, 0x000fe40000011617ULL,
0x000000ff14007812ULL, 0x000fe400078ec0ffULL, 0x000000ff15047812ULL, 0x000fe400078ec0ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x0000005bff56723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000055ff5a7230ULL, 0x000fe20000004100ULL,
0x000000ff3d497812ULL, 0x010fe200078ec0ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000054ff5b723eULL, 0x000fe200020006ffULL, 0x20000053ff547230ULL, 0x000fe20000004100ULL,
0x00000018ff437819ULL, 0x000fc4000001163cULL, 0x00000018ff447819ULL, 0x000fe2000001163dULL,
0x2000005bff537230ULL, 0x000fe20000004100ULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3e4a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3f4f7812ULL, 0x000fe400078ec0ffULL,
0x00000000ff48723eULL, 0x000fe400020006ffULL, 0x00000004ff47723eULL, 0x000fc400020006ffULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x0000005cff55723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x0000004aff5b723eULL, 0x000fe400020006ffULL,
0x0000004fff5c723eULL, 0x000fe200020006ffULL, 0x20000049ff4f7230ULL, 0x000fe20000004100ULL,
0x00000018ff167819ULL, 0x000fe2000001163eULL, 0x20000043ff497230ULL, 0x000fe20000004100ULL,
0x00000018ff177819ULL, 0x000fe2000001163fULL, 0x20000044ff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x2000005bff447230ULL, 0x000fe20000004100ULL,
0x00000016ff5b723eULL, 0x000fe200020006ffULL, 0x2000005cff437230ULL, 0x000fe20000004100ULL,
0x00000017ff5c723eULL, 0x000fc400020006ffULL, 0x00000010ff167819ULL, 0x000fe40000011648ULL,
0x00000010ff177819ULL, 0x000fe20000011647ULL, 0x2000005bff477230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe2000001165aULL, 0x2000005cff487230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe4000001163cULL, 0x00000010ff157819ULL, 0x000fe4000001163dULL,
0x0000105459167816ULL, 0x000fc40000000016ULL, 0x000010545a177816ULL, 0x000fe40000000017ULL,
0x000000ff14597812ULL, 0x000fe400078ec0ffULL, 0x000000ff155a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x000000163418723cULL, 0x008fe20000041818ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff147819ULL, 0x000fc40000011658ULL,
0x00000010ff157819ULL, 0x000fe40000011657ULL, 0x0000105451147816ULL, 0x000fe40000000014ULL,
0x0000105452157816ULL, 0x000fe40000000015ULL, 0x00000010ff167819ULL, 0x000fe4000001164eULL,
0x00000010ff177819ULL, 0x000fe40000011656ULL, 0x000000ff3c457812ULL, 0x000fe200078ec0ffULL,
0x000000143428723cULL, 0x000fe20000041828ULL, 0x00000010ff4d7819ULL, 0x000fc4000001164dULL,
0x00000010ff4e7819ULL, 0x000fe40000011655ULL, 0x0000ffff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x0000105417167816ULL, 0x000fe40000000016ULL,
0x000010544e177816ULL, 0x000fe4000000004dULL, 0x00000008ff4d7819ULL, 0x000fc4000001163cULL,
0x00000010ff157819ULL, 0x000fe40000011646ULL, 0x00000010ff147819ULL, 0x000fe20000011654ULL,
0x00000016342c723cULL, 0x000fe2000004182cULL, 0x00000010ff007819ULL, 0x000fe4000001163eULL,
0x00000008ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff3c7819ULL, 0x000fe4000001164bULL,
0x00000010ff537819ULL, 0x000fc40000011653ULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x0000105415147816ULL, 0x000fe20000000014ULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff047819ULL, 0x000fe2000001163fULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fc400020006ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x000010543c157816ULL, 0x000fe20000000053ULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x000000ff00007812ULL, 0x000fe200078ec0ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x000000ff04047812ULL, 0x000fe400078ec0ffULL,
0x00000000ff00723eULL, 0x000fe200020006ffULL, 0x000000143430723cULL, 0x000fe20000041830ULL,
0x00000004ff16723eULL, 0x000fc400020006ffULL, 0x00000010ff597819ULL, 0x000fe20000011659ULL,
0x20000000ff047230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fe2000001165aULL,
0x20000016ff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff147819ULL, 0x000fe40000011645ULL,
0x00000010ff157819ULL, 0x000fe4000001164fULL, 0x00000010ff007819ULL, 0x000fe40000011649ULL,
0x00000010ff4a7819ULL, 0x000fc4000001164aULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff177819ULL, 0x000fe4000001163dULL, 0x0000105459147816ULL, 0x000fe40000000014ULL,
0x000010545a157816ULL, 0x000fe40000000015ULL, 0x0000105400167816ULL, 0x000fe4000000004dULL,
0x000010544a177816ULL, 0x000fc40000000017ULL, 0x0000ffff3e3e7812ULL, 0x000fe200078ec0ffULL,
0x000000143424723cULL, 0x000fe20000041824ULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff447819ULL, 0x000fe40000011644ULL, 0x00000008ff3e7819ULL, 0x000fe2000001163eULL,
0x000000163420723cULL, 0x000fe20000041820ULL, 0x00000010ff157819ULL, 0x000fe40000011604ULL,
0x00000008ff3f7819ULL, 0x000fc4000001163fULL, 0x0000105415447816ULL, 0x000fe40000000044ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x00000017061479a7ULL, 0x000e62000850003fULL,
0x00000010ff437819ULL, 0x000fe20000011643ULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fe2000001163cULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fc40000011647ULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x000010543c457816ULL, 0x000fe40000000043ULL, 0x00001054473e7816ULL, 0x000fe4000000003eULL,
0x00001054483f7816ULL, 0x000fc4000000003fULL, 0x0000000808007c11ULL, 0x000fe2000f8e18ffULL,
0x00000044341c723cULL, 0x000fe6000004181cULL, 0x0176a01700ff79a7ULL, 0x0003e6000850003fULL,
0x0000003e3410723cULL, 0x000fe20000041810ULL, 0x000000ffff007224ULL, 0x002fe200078e0015ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0xffffff5400109947ULL, 0x000fde000383ffffULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000050007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000c55000047802ULL, 0x002fce0000000f00ULL,
0x0000008400787944ULL, 0x004fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005000037308ULL, 0x004ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc80000000050ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009600ff027b82ULL, 0x000f240000000a00ULL,
0x0000000602037981ULL, 0x010f22000c1e9900ULL, 0x0000000000057919ULL, 0x002e640000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x01cfca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000001804187220ULL, 0x042fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x000fe20000410000ULL, 0x0000001a051a7220ULL, 0x044fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x000000202120723eULL, 0x000fe400000010ffULL, 0x0000001c1d1c723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002e2f2e723eULL, 0x000fc400000010ffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x000000121312723eULL, 0x000fe400000010ffULL,
0x0000763226217816ULL, 0x000fe40000000022ULL, 0x000076321e237816ULL, 0x000fc40000000012ULL,
0x000000ff0c00720cULL, 0x000fe40003f05270ULL, 0x00000002ff057819ULL, 0x00afe40000011600ULL,
0x0000000200027812ULL, 0x044fe400078ec0ffULL, 0x0000000800077811ULL, 0x000fe200078ff0ffULL,
0x00000008050d7824ULL, 0x040fe200078e00ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x00000008050e7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x000fe200078ff8ffULL,
0x0000000807147824ULL, 0x000fc400078e00ffULL, 0x0000000204027836ULL, 0x000fe40000000000ULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee203ULL,
0x0000000404067836ULL, 0x000fe20000000000ULL, 0x0000000809037c11ULL, 0x000fe4000f8e60ffULL,
0xfffffff80d087812ULL, 0x000fe400078ee202ULL, 0xfffffff807027812ULL, 0x000fe200078ee204ULL,
0x0000000604077836ULL, 0x000fe20000000000ULL, 0xfffffff80d0a7812ULL, 0x000fe200078ee206ULL,
0x0000000800047824ULL, 0x000fc400078e00ffULL, 0x000008000c057824ULL, 0x000fe200078e0203ULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee207ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x0000001002067824ULL, 0x100fe200078e0205ULL, 0x000000181902723eULL, 0x000fe200000010ffULL,
0x0000001014147824ULL, 0x100fe200078e0205ULL, 0x000000282904723eULL, 0x000fe200000010ffULL,
0x0000001008087824ULL, 0x100fe400078e0205ULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x0000541002167816ULL, 0x100fe20000000004ULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x0000763202177816ULL, 0x000fe20000000004ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x0000002c2d02723eULL, 0x000fe200000010ffULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x000000303104723eULL, 0x000fe200000010ffULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x000000242505723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x0000001606007388ULL, 0x0003e20000000a00ULL, 0x0000000107077824ULL, 0x000fe200078e020eULL,
0x00000010110e723eULL, 0x000fc400000010ffULL, 0x0000541005107816ULL, 0x140fe40000000020ULL,
0x0000763205117816ULL, 0x000fe40000000020ULL, 0x0000541026207816ULL, 0x000fe40000000022ULL,
0x000054101e227816ULL, 0x000fe40000000012ULL, 0x0000541002167816ULL, 0x142fe40000000004ULL,
0x0000763202177816ULL, 0x000fc40000000004ULL, 0x0000001a1b02723eULL, 0x000fe400000010ffULL,
0x0000002a2b04723eULL, 0x000fe200000010ffULL, 0x0000001608007388ULL, 0x0003e80000000a00ULL,
0x000000100a007388ULL, 0x0005e20000000a00ULL, 0x000000323317723eULL, 0x002fe400000010ffULL,
0x000054101c107816ULL, 0x004fc4000000000eULL, 0x000076321c117816ULL, 0x000fe4000000000eULL,
0x000054102e167816ULL, 0x140fe40000000017ULL, 0x000076322e177816ULL, 0x000fe20000000017ULL,
0x0000001007007388ULL, 0x0003e40000000a00ULL, 0x0000541002107816ULL, 0x142fe40000000004ULL,
0x0000763202117816ULL, 0x000fe20000000004ULL, 0x000000010b027824ULL, 0x000fc800078e0200ULL,
0x0000001014007388ULL, 0x000fe20000000a00ULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x000000ff00027306ULL, 0x000e620000202400ULL, 0x0004001608007388ULL, 0x000fe80000000a00ULL,
0x000400200a007388ULL, 0x000fe80000000a00ULL, 0x0004002207007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000004107984ULL, 0x000e680000000c00ULL,
0x0004000004187984ULL, 0x000ea80000000c00ULL, 0x0008000004147984ULL, 0x000ee80000000c00ULL,
0x000c0000041c7984ULL, 0x000f220000000c00ULL, 0x0000001302137230ULL, 0x002fc40000200800ULL,
0x0000001202127230ULL, 0x040fe40000200800ULL, 0x0000001102117230ULL, 0x040fe40000200800ULL,
0x0000001002107230ULL, 0x040fe40000200800ULL, 0x0000001b021b7230ULL, 0x044fe40000200800ULL,
0x0000001a021a7230ULL, 0x040fe40000200800ULL, 0x0000001902197230ULL, 0x000fc40000200800ULL,
0x0000001802027230ULL, 0x000fe40000200800ULL, 0x0000001713137230ULL, 0x008fe40000200000ULL,
0x0000001612127230ULL, 0x000fe40000200000ULL, 0x0000001511117230ULL, 0x000fe40000200000ULL,
0x0000001410107230ULL, 0x000fe40000200000ULL, 0x0000001f1b1b7230ULL, 0x010fc40000200000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000200000ULL, 0x0000001004007388ULL, 0x0003e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000200000ULL, 0x0000001c02187230ULL, 0x000fca0000200000ULL,
0x0004001804007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff077819ULL, 0x000fe20000011600ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x0000003b0700720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00008600ff0c7b82ULL, 0x000ea20000000800ULL,
0x0000000107027824ULL, 0x000fe200078e0200ULL, 0x0000880000087ab9ULL, 0x000fe20000000a00ULL,
0x00000007000a7812ULL, 0x000fc600078ec0ffULL, 0x0000000702057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805027812ULL, 0x000fe200078ef800ULL, 0xffffffffff057424ULL, 0x000fc800078e00ffULL,
0x0000001002047824ULL, 0x002fe400078e0203ULL, 0x0000001040027824ULL, 0x000fe400078e0207ULL,
0x0000000809077824ULL, 0x000fe200078e020aULL, 0x0000000004107984ULL, 0x0002e20000000c00ULL,
0x0000000c050e7219ULL, 0x084fe400000006ffULL, 0x0000000c42427219ULL, 0x000fe400000006ffULL,
0x0000000e02057212ULL, 0x000fc400078e30ffULL, 0x0000000cff067219ULL, 0x000fe20000011602ULL,
0x000000040f027c24ULL, 0x000fe4000f8e02ffULL, 0x0000000142057824ULL, 0x000fc800078e0205ULL,
0x0000000f06057224ULL, 0x000fe400078e0205ULL, 0x0000002000067836ULL, 0x000fc60000000000ULL,
0x0000000502057210ULL, 0x000fe40007f1e0ffULL, 0x00000003ff0b7819ULL, 0x000fc60000011606ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x002fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x0000003b0b00720cULL, 0x000fe20003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000001004007986ULL, 0x0083ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe400078e020bULL,
0x00000010400b7824ULL, 0x000fe400078e020bULL, 0x0000004000087836ULL, 0x000fe20000000000ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000000e0b057212ULL, 0x000fe400078e30ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x0000000cff047219ULL, 0x000fe2000001160bULL,
0x0000000142057824ULL, 0x000fe200078e0205ULL, 0x00000003ff0b7819ULL, 0x000fe40000011608ULL,
0x0000000007107984ULL, 0x0002a20000000c00ULL, 0x0000000f04057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000809077824ULL, 0x002fc800078e0206ULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f440aULL, 0x0000003b0b00720cULL, 0x000fe20003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000001004007986ULL, 0x0043ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000108047824ULL, 0x102fe400078e020bULL,
0x00000010400b7824ULL, 0x000fe400078e020bULL, 0x0000006000007836ULL, 0x000fe20000000000ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef808ULL,
0x0000000e0b057212ULL, 0x000fe400078e30ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x0000000cff047219ULL, 0x000fe2000001160bULL,
0x0000000142057824ULL, 0x000fe200078e0205ULL, 0x00000003ff0b7819ULL, 0x000fe20000011600ULL,
0x0000000809077824ULL, 0x000fe200078e0208ULL, 0x0000000006107984ULL, 0x0002a20000000c00ULL,
0x0000000f04057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000100067824ULL, 0x002fc800078e020bULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe400080f440aULL,
0x0000003b0b00720cULL, 0x000fe20003f06070ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000706077812ULL, 0x000fc800078ec0ffULL, 0xfffffff807067812ULL, 0x000fe200078ef800ULL,
0x0000001004007986ULL, 0x0043ec000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x00000010400b7824ULL, 0x000fc800078e020bULL, 0x0000000006047984ULL, 0x002e620000000c00ULL,
0x0000000e0b037212ULL, 0x000fe200078e30ffULL, 0x0000000809097824ULL, 0x000fe200078e0200ULL,
0x0000000cff087219ULL, 0x000fc6000001160bULL, 0x0000000142037824ULL, 0x000fc800078e0203ULL,
0x0000000f08037224ULL, 0x000fca00078e0203ULL, 0x0000000302037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fc600080f4408ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009600ff0a7b82ULL, 0x000e620000000a00ULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x0000000211117824ULL, 0x000fe200078e00ffULL, 0x0000920000047ab9ULL, 0x000fe20000000800ULL,
0x000000060a057981ULL, 0x002322000c1e9900ULL, 0x00000001ff027424ULL, 0x000fe400078e00ffULL,
0x0000004039077824ULL, 0x000fe400078e00ffULL, 0x0000000911427224ULL, 0x000fe400078e0242ULL,
0x01760002ff0279a7ULL, 0x000ea40008500008ULL, 0x0000000442097c24ULL, 0x000fe2000f8e0207ULL,
0x0000000c00240947ULL, 0x002fec0003800000ULL, 0x00000003ff0f7819ULL, 0x000fe2000001160eULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x000000073a087248ULL, 0x000fc60007fe0000ULL,
0x000000040f0d7836ULL, 0x000fe40000000000ULL, 0x000000080f137836ULL, 0x000fe40000000000ULL,
0x000000010d067824ULL, 0x140fe400078e020eULL, 0x000000080d237824ULL, 0x000fe400078e00ffULL,
0x0000000108087824ULL, 0x000fe400078e0a07ULL, 0x00000001130b7824ULL, 0x040fe200078e020eULL,
0xfffffff823237812ULL, 0x000fe200078ee206ULL, 0x0000000813067824ULL, 0x000fe200078e00ffULL,
0x000000080d00720cULL, 0x000fe20003fa6070ULL, 0x00000001090c7824ULL, 0x000fc400078e020dULL,
0x00000001090a7824ULL, 0x000fe200078e020fULL, 0xfffffff806257812ULL, 0x000fe200078ee20bULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000700c167812ULL, 0x000fc600078ef804ULL, 0x000000100f117836ULL, 0x000fe20000000000ULL,
0x000000700a147812ULL, 0x000fe200078ef804ULL, 0x0000000c0f197836ULL, 0x000fe20000000000ULL,
0x0000000416167c10ULL, 0x000fe2000ff3e0ffULL, 0x00000001110a7824ULL, 0x040fe200078e020eULL,
0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000811297824ULL, 0x000fe200078e00ffULL,
0x000000050d177c10ULL, 0x000fe20008ffe4ffULL, 0x00000001090c7824ULL, 0x040fe200078e0219ULL,
0x000000050b157c10ULL, 0x000fe200087fe4ffULL, 0x000000180f2d7836ULL, 0x000fe20000000000ULL,
0xfffffff829297812ULL, 0x000fe200078ee20aULL, 0x00000001090a7824ULL, 0x000fe200078e0213ULL,
0x000000081100720cULL, 0x080fe20003f06070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000081900720cULL, 0x000fc40003f46070ULL, 0x000000081300720cULL, 0x000fe20003f26070ULL,
0x00000001091c7824ULL, 0x000fe200078e022dULL, 0x000000700c187812ULL, 0x000fe200078ef804ULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x0000000418187c10ULL, 0x000fe2000ff9e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000700a1a7812ULL, 0x000fc600078ef804ULL,
0x0000000109117824ULL, 0x000fe200078e0211ULL, 0x000000701c0a7812ULL, 0x000fe200078ef804ULL,
0x000000140f1f7836ULL, 0x000fe20000000000ULL, 0x000000041a1a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000008011107825ULL, 0x000fc600078e00ffULL, 0x000000050b1b7c10ULL, 0x000fe20009ffe4ffULL,
0x0000000119067824ULL, 0x140fe200078e020eULL, 0x0000007010107812ULL, 0x000fe200078ef804ULL,
0x0000000819277824ULL, 0x000fe200078e00ffULL, 0x000000050d197c10ULL, 0x000fe2000a7fe4ffULL,
0x0000000109127824ULL, 0x000fe200078e021fULL, 0x000000040a0a7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000010f1c7824ULL, 0x000fe200078e020eULL, 0xfffffff827277812ULL, 0x000fe200078ee206ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000051d0b7c10ULL, 0x000fc4000a7fe4ffULL,
0x0000000839067c11ULL, 0x000fe2000f8e70ffULL, 0x0000001c0f2f7836ULL, 0x000fe20000000000ULL,
0x000000071c1d7812ULL, 0x000fe200078ec0ffULL, 0x000000200f317836ULL, 0x000fe20000000000ULL,
0x0000000410107c10ULL, 0x000fe2000ff7e0ffULL, 0x0000100006067836ULL, 0x000fe20000000000ULL,
0x000000080f00720cULL, 0x080fe20003f86070ULL, 0x000000011f1c7824ULL, 0x000fe200078e020eULL,
0x00000070120c7812ULL, 0x000fe200078ef804ULL, 0x0000000109127824ULL, 0x000fe200078e022fULL,
0x0ffffff81d217812ULL, 0x000fe200078ef80eULL, 0x000000081f2b7824ULL, 0x000fe200078e00ffULL,
0x0000000511117c10ULL, 0x000fe20009ffe4ffULL, 0x00000001091d7824ULL, 0x000fe200078e0231ULL,
0x000000040c0c7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001021217824ULL, 0x000fe200078e0206ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21cULL, 0x000000240f337836ULL, 0x000fe20000000000ULL,
0x00000005130d7c10ULL, 0x000fe20009ffe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014217faeULL, 0x0003e2000e101c46ULL,
0x000000082d00720cULL, 0x000fc40003f86070ULL, 0x000000012d207824ULL, 0x000fe200078e020eULL,
0x0000007012127812ULL, 0x000fe200078ef804ULL, 0x000000801d1c7825ULL, 0x000fe200078e00ffULL,
0x000000081f00720cULL, 0x080fe40003f66070ULL, 0x0000000412127c10ULL, 0x000fe2000ffde0ffULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x000000701c1c7812ULL, 0x000fe200078ef804ULL,
0x0000001023237824ULL, 0x000fe200078e0206ULL, 0x0000000513137c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001091e7824ULL, 0x000fe200078e0233ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee220ULL,
0x000000280f357836ULL, 0x000fe20000000000ULL, 0x0000000016237faeULL, 0x0007e2000e901c46ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000082f00720cULL, 0x000fc40003fa6070ULL,
0x000000041c1c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000109227824ULL, 0x000fe200078e0235ULL,
0x000000701e1e7812ULL, 0x000fe200078ef804ULL, 0x000000012f207824ULL, 0x040fe200078e020eULL,
0x000000051d1d7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000082f217824ULL, 0x002fe200078e00ffULL,
0x000000041e1e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000002c0f2f7836ULL, 0x000fe40000000000ULL,
0x0000001025257824ULL, 0x100fe200078e0206ULL, 0xfffffff821217812ULL, 0x000fe200078ee220ULL,
0x0000001027277824ULL, 0x000fe200078e0206ULL, 0x000000051f1f7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000008022147825ULL, 0x000fe200078e00ffULL, 0x000000001a257faeULL, 0x0003e2000c901c46ULL,
0x000000083100720cULL, 0x000fc40003f26070ULL, 0x0000001029297824ULL, 0x100fe200078e0206ULL,
0x0000000018277faeULL, 0x000fe2000d101c46ULL, 0x0000000109167824ULL, 0x008fe200078e022fULL,
0x0000007014147812ULL, 0x000fe200078ef804ULL, 0x000000300f237836ULL, 0x000fe20000000000ULL,
0x000000083300720cULL, 0x000fe20003f46070ULL, 0x000000102b2b7824ULL, 0x000fe200078e0206ULL,
0x0000000010297faeULL, 0x0007e2000c101c46ULL, 0x0000000131207824ULL, 0x000fe200078e020eULL,
0x0000000414147c10ULL, 0x000fe2000ffde0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0206ULL,
0x000000000c2b7faeULL, 0x000fe2000d901c46ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000515157c10ULL, 0x000fc4000b7fe4ffULL, 0x000000000a2d7faeULL, 0x000be2000e101c46ULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x0000007016167812ULL, 0x000fe200078ef804ULL,
0x0000000133227824ULL, 0x000fe200078e020eULL, 0x000000082f00720cULL, 0x080fe20003f86070ULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0xfffffff8311b7812ULL, 0x002fe200078ee220ULL,
0x0000000109107824ULL, 0x008fe200078e0223ULL, 0x0000000416167c10ULL, 0x000fe2000ffde0ffULL,
0x0000001021217824ULL, 0x100fe200078e0206ULL, 0xfffffff833197812ULL, 0x004fe200078ee222ULL,
0x000000101b1b7824ULL, 0x000fe200078e0206ULL, 0x0000000517177c10ULL, 0x000fe2000b7fe4ffULL,
0x00000080100a7825ULL, 0x020fe200078e00ffULL, 0x0000000012217faeULL, 0x000fe2000e901c46ULL,
0x000000083500720cULL, 0x000fc40003fa6070ULL, 0x000000340f257836ULL, 0x000fe20000000000ULL,
0x000000700a107812ULL, 0x000fe200078ef804ULL, 0x0000001019197824ULL, 0x000fe200078e0206ULL,
0x000000001c1b7faeULL, 0x000fe2000c901c46ULL, 0x00000001090c7824ULL, 0x000fe200078e0225ULL,
0x0000000410107c10ULL, 0x000fe2000ffde0ffULL, 0x000000380f277836ULL, 0x000fe20000000000ULL,
0x000000001e197faeULL, 0x0003e2000d101c46ULL, 0x0000003c0f297836ULL, 0x000fe20000000000ULL,
0x000000050b117c10ULL, 0x000fe2000b7fe4ffULL, 0x00000001230a7824ULL, 0x040fe200078e020eULL,
0x000000082300720cULL, 0x080fe20003f66070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000082500720cULL, 0x000fc40003f46070ULL, 0x000000082700720cULL, 0x080fe20003f26070ULL,
0x00000001090b7824ULL, 0x000fe200078e0227ULL, 0x000000082900720cULL, 0x000fe20003f06070ULL,
0x000000012f087824ULL, 0x100fe200078e020eULL, 0x000000700c0c7812ULL, 0x000fe200078ef804ULL,
0x0000000823197824ULL, 0x002fe400078e00ffULL, 0x000000082f137824ULL, 0x000fe200078e00ffULL,
0x000000040c0c7c10ULL, 0x000fe2000ffde0ffULL, 0x00000001350f7824ULL, 0x040fe200078e020eULL,
0xfffffff819197812ULL, 0x000fe200078ee20aULL, 0x0000000835127824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee208ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x000000050d0d7c10ULL, 0x000fc4000b7fe4ffULL, 0xfffffff8120f7812ULL, 0x000fe200078ee20fULL,
0x0000000109097824ULL, 0x000fe200078e0229ULL, 0x000000700a0a7812ULL, 0x000fe200078ef804ULL,
0x0000000125127824ULL, 0x000fe400078e020eULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0x000000040a0a7c10ULL, 0x000fc6000ffde0ffULL, 0x00000008251b7824ULL, 0x000fe200078e00ffULL,
0x0000007008047812ULL, 0x000fe200078ef804ULL, 0x0000000127187824ULL, 0x140fe200078e020eULL,
0x000000050b0b7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000008271d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee212ULL, 0x00000001290e7824ULL, 0x040fe200078e020eULL,
0x0000000404087c10ULL, 0x000fe2000ffde0ffULL, 0x00000008291f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee218ULL, 0x000000100f0f7824ULL, 0x100fe200078e0206ULL,
0x0000000509097c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001013137824ULL, 0x100fe200078e0206ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20eULL, 0x0000001019197824ULL, 0x100fe200078e0206ULL,
0x00000000140f7faeULL, 0x0003e2000e901c46ULL, 0x000000101b1b7824ULL, 0x000fc400078e0206ULL,
0x000000101d1d7824ULL, 0x100fe200078e0206ULL, 0x0000000016137faeULL, 0x0003e2000e101c46ULL,
0x000000101f1f7824ULL, 0x000fc600078e0206ULL, 0x0000000010197faeULL, 0x0003e8000d901c46ULL,
0x000000000c1b7faeULL, 0x0003e8000d101c46ULL, 0x000000000a1d7faeULL, 0x0003e8000c901c46ULL,
0x00000000081f7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d47947ULL, 0x000fea0003800000ULL,
0x000000040e0a7811ULL, 0x040fe200078fe8ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x000000080e0c7811ULL, 0x040fe400078fe8ffULL, 0x0000000c0e0d7811ULL, 0x000fe200078fe8ffULL,
0x000000010a067824ULL, 0x100fe200078e020eULL, 0x000000140e117811ULL, 0x000fe200078fe8ffULL,
0x000000080a197824ULL, 0x000fe200078e00ffULL, 0x000000100e107811ULL, 0x000fe200078fe8ffULL,
0x000000080c1b7824ULL, 0x000fe200078e00ffULL, 0x000000180e137811ULL, 0x000fe200078fe8ffULL,
0x000000010d087824ULL, 0x140fe200078e020eULL, 0xfffffff819197812ULL, 0x000fe200078ee206ULL,
0x000000010c067824ULL, 0x100fe200078e020eULL, 0x0000001c0e157811ULL, 0x040fe200078fe8ffULL,
0x000000080d1d7824ULL, 0x000fe200078e00ffULL, 0x000000240e177811ULL, 0x000fe200078fe8ffULL,
0x00000001110f7824ULL, 0x140fe200078e020eULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL,
0x0000000811147824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee208ULL,
0x00000001100b7824ULL, 0x100fe200078e020eULL, 0x000000200e167811ULL, 0x000fe200078fe8ffULL,
0x0000000810127824ULL, 0x000fe200078e00ffULL, 0x000000280e187811ULL, 0x040fe200078fe8ffULL,
0x0000000113067824ULL, 0x140fe200078e020eULL, 0xfffffff814217812ULL, 0x000fe200078ee20fULL,
0x0000000813237824ULL, 0x000fe200078e00ffULL, 0xfffffff8121f7812ULL, 0x000fe200078ee20bULL,
0x0000000115087824ULL, 0x140fe200078e020eULL, 0x0000002c0e1c7811ULL, 0x040fe200078fe8ffULL,
0x0000000815257824ULL, 0x000fe200078e00ffULL, 0x000000340e2b7811ULL, 0x000fe200078fe8ffULL,
0x00000001170f7824ULL, 0x140fe200078e020eULL, 0xfffffff823237812ULL, 0x000fe200078ee206ULL,
0x0000000817207824ULL, 0x000fe200078e00ffULL, 0xfffffff8251a7812ULL, 0x000fe200078ee208ULL,
0x00000001160b7824ULL, 0x100fe200078e020eULL, 0x000000300e277811ULL, 0x000fe200078fe8ffULL,
0x00000008161e7824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20fULL,
0x0000000118067824ULL, 0x100fe200078e020eULL, 0x000000380e2e7811ULL, 0x000fe200078fe8ffULL,
0x0000000818257824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL,
0x000000011c087824ULL, 0x100fe200078e020eULL, 0x0000003c0e2f7811ULL, 0x000fe200078fe8ffULL,
0x000000081c297824ULL, 0x000fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fe200078ee206ULL,
0x000000012b0f7824ULL, 0x140fe200078e020eULL, 0x0000000e0e067211ULL, 0x040fe200078fe8ffULL,
0x000000082b147824ULL, 0x000fe200078e00ffULL, 0xfffffff829257812ULL, 0x000fe200078ee208ULL,
0x00000001270b7824ULL, 0x040fe200078e020eULL, 0x000000090e087211ULL, 0x000fe200078fe8ffULL,
0x0000000827127824ULL, 0x000fe200078e00ffULL, 0xfffffff8142d7812ULL, 0x000fe200078ee20fULL,
0x00000001090f7824ULL, 0x000fc400078e020dULL, 0x0000000109267824ULL, 0x040fe200078e0216ULL,
0xfffffff812297812ULL, 0x000fe200078ee20bULL, 0x0000000109167824ULL, 0x040fe200078e022eULL,
0x00000007060b7812ULL, 0x000fe200078ec0ffULL, 0x000000012e0d7824ULL, 0x140fe400078e020eULL,
0x000000082e2e7824ULL, 0x000fe400078e00ffULL, 0x0000000109287824ULL, 0x000fe200078e0217ULL,
0x0ffffff80b177812ULL, 0x000fe200078ef80eULL, 0x000000012f0b7824ULL, 0x000fe200078e020eULL,
0xfffffff82e0e7812ULL, 0x000fe200078ee20dULL, 0x00000001092a7824ULL, 0x000fe200078e0218ULL,
0x00000008390d7c11ULL, 0x000fe2000f8e70ffULL, 0x00000001092c7824ULL, 0x000fc400078e021cULL,
0x00000001090a7824ULL, 0x040fe400078e020aULL, 0x00000001090c7824ULL, 0x040fe400078e020cULL,
0x0000000109107824ULL, 0x040fe400078e0210ULL, 0x0000000109127824ULL, 0x040fe400078e0211ULL,
0x0000000109147824ULL, 0x040fe400078e0213ULL, 0x0000000109247824ULL, 0x000fc400078e0215ULL,
0x00000001091c7824ULL, 0x040fe400078e0227ULL, 0x0000000109187824ULL, 0x040fe400078e022bULL,
0x0000000109067824ULL, 0x000fe400078e022fULL, 0x0000008008087825ULL, 0x000fc800078e00ffULL,
0x000010000d2e7836ULL, 0x000fe20000000000ULL, 0x0000007008087812ULL, 0x000fe200078ef804ULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0x0000000408087c10ULL, 0x000fe2000ff1e0ffULL,
0x000000082f307824ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fe200078ef804ULL,
0x000000100e437824ULL, 0x000fe200078e022eULL, 0x0000000509097c10ULL, 0x000fe200087fe4ffULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff830117812ULL, 0x000fe400078ee20bULL,
0x000000040c0c7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fc400078ef804ULL, 0x000000050d0d7c10ULL, 0x000fe200087fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe400078ef804ULL,
0x000000040e0e7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001011457824ULL, 0x100fe200078e022eULL,
0x0000007012127812ULL, 0x000fe200078ef804ULL, 0x00000010253d7824ULL, 0x000fe200078e022eULL,
0x000000040a0a7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000050f0f7c10ULL, 0x000fc400087fe4ffULL, 0x0000000412127c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x000fe400078ef804ULL,
0x000000050b0b7c10ULL, 0x000fe20008ffe4ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000410107c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000513137c10ULL, 0x000fe200087fe4ffULL,
0x0000001017177824ULL, 0x100fe200078e022eULL, 0x0000007014147812ULL, 0x000fe200078ef804ULL,
0x0000001019197824ULL, 0x100fe200078e022eULL, 0x0000000511117c10ULL, 0x000fe20008ffe4ffULL,
0x000000101b1b7824ULL, 0x100fe200078e022eULL, 0x0000000414147c10ULL, 0x000fe2000ff5e0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e022eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008177faeULL, 0x0003e2000b901c46ULL, 0x000000101f1f7824ULL, 0x100fe200078e022eULL,
0x0000000515157c10ULL, 0x000fe200097fe4ffULL, 0x0000001021217824ULL, 0x100fe200078e022eULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x0000001023237824ULL, 0x000fc400078e022eULL,
0x000000101a1a7824ULL, 0x100fe200078e022eULL, 0x000000000c1b7faeULL, 0x0003e2000b901c46ULL,
0x000000101e1e7824ULL, 0x100fe400078e022eULL, 0x0000001020377824ULL, 0x100fe200078e022eULL,
0x000000000e1d7faeULL, 0x0003e2000b901c46ULL, 0x00000010223b7824ULL, 0x100fe400078e022eULL,
0x00000010293f7824ULL, 0x100fe200078e022eULL, 0x00000000101f7faeULL, 0x0003e2000b901c46ULL,
0x000000102d417824ULL, 0x000fe200078e022eULL, 0x00000070242e7812ULL, 0x000fe200078ef804ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000012217faeULL, 0x0003e4000b901c46ULL,
0x000000042e2e7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000007026307812ULL, 0x000fe200078ef804ULL, 0x0000000014237faeULL, 0x0003e2000b901c46ULL,
0x00000005252f7c10ULL, 0x000fe200087fe4ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000007028327812ULL, 0x000fc400078ef804ULL, 0x0000000430307c10ULL, 0x000fe2000ff3e0ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x000000702a347812ULL, 0x000fe200078ef804ULL,
0x000000002e1a7faeULL, 0x0003e2000b901c46ULL, 0x0000000432327c10ULL, 0x000fe2000ff1e0ffULL,
0x000000801c247825ULL, 0x000fe200078e00ffULL, 0x0000000434347c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000527317c10ULL, 0x000fe20008ffe4ffULL, 0x0000008018267825ULL, 0x000fe200078e00ffULL,
0x000000702c2c7812ULL, 0x000fc400078ef804ULL, 0x0000000529337c10ULL, 0x000fe200087fe4ffULL,
0x0000008016287825ULL, 0x000fe200078e00ffULL, 0x000000052b357c10ULL, 0x000fe200097fe4ffULL,
0x00000000301e7faeULL, 0x0003e2000b901c46ULL, 0x000000042c2c7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000080062a7825ULL, 0x000fe200078e00ffULL, 0x0000007024247812ULL, 0x000fe200078ef804ULL,
0x0000000032377faeULL, 0x0003e2000b901c46ULL, 0x0000007026267812ULL, 0x000fe400078ef804ULL,
0x0000007028287812ULL, 0x000fe200078ef804ULL, 0x00000000343b7faeULL, 0x0003e2000b901c46ULL,
0x000000052d2d7c10ULL, 0x000fc400087fe4ffULL, 0x000000702a047812ULL, 0x000fe400078ef804ULL,
0x0000000424247c10ULL, 0x000fe2000ff1e0ffULL, 0x000000002c3d7faeULL, 0x0003e2000b901c46ULL,
0x0000000426267c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000428287c10ULL, 0x000fe4000ff5e0ffULL,
0x00000004042a7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000525257c10ULL, 0x000fc400087fe4ffULL,
0x0000000527277c10ULL, 0x000fe40008ffe4ffULL, 0x0000000529297c10ULL, 0x000fe200097fe4ffULL,
0x00000000243f7faeULL, 0x0003e2000b901c46ULL, 0x000000052b2b7c10ULL, 0x000fc60009ffe4ffULL,
0x0000000026417faeULL, 0x0003e8000b901c46ULL, 0x0000000028437faeULL, 0x0003e8000b901c46ULL,
0x000000002a457faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fce0000015200ULL, 0x01760003ff0075a7ULL, 0x004e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff067224ULL, 0x000fce00078e00ffULL,
0x000000100600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc8000001140bULL,
0x0000000d04047211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000204047819ULL, 0x000fc8000000120bULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000106067836ULL, 0x000fce0000000000ULL,
0x01760003ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x00000001ff0a7424ULL, 0x000fe400078e00ffULL,
0x0000002039027824ULL, 0x002fca00078e0202ULL, 0x00000003ff037819ULL, 0x000fc80000011602ULL,
0x1ffffffe03097812ULL, 0x000fe400078ec0ffULL, 0x0000000f02037812ULL, 0x000fc600078ec0ffULL,
0x0000000102097824ULL, 0x000fe400078e0209ULL, 0x0000001003047824ULL, 0x000fe400078e00ffULL,
0x0000000109027836ULL, 0x000fe20000000000ULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x0000001003037824ULL, 0x000fc600078e00ffULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x000000f004097812ULL, 0x000fe400078ee209ULL, 0x000000f003027812ULL, 0x000fe400078ee202ULL,
0x0000000809097c11ULL, 0x000fe4000f8e20ffULL, 0x0000000802027c11ULL, 0x000fc6000f8e20ffULL,
0x0000000009107984ULL, 0x000e680000000c00ULL, 0x00000000020c7984ULL, 0x000ea20000000c00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fc400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001409007388ULL, 0x0003e80000000c00ULL, 0x0000001002007388ULL, 0x0003e20000000c00ULL,
0x0176000aff0a79a7ULL, 0x000ea40008500008ULL, 0x0000000000027805ULL, 0x002fce0000015200ULL,
0x0176000bff0075a7ULL, 0x004e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fce0000015200ULL,
0x00000008020d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e03ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011409ULL, 0x0000000d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000204047819ULL, 0x000fc80000001209ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x0176000bff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff3800720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x0000010007027836ULL, 0x000fe20000000000ULL,
0x0000001f0a047890ULL, 0x000fe4000fffe03fULL, 0x8000000a3a087c36ULL, 0x000fe40008000000ULL,
0x3db504f305047820ULL, 0x010fe20000410000ULL, 0x0000000839057c11ULL, 0x040fe2000f8e18ffULL,
0x000000043f047899ULL, 0x000fe20008011604ULL, 0x0000000839067c11ULL, 0x000fe2000f8e28ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x00000008ff087819ULL, 0x000fe20000011608ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0xffffffff0a057890ULL, 0x000fc4000fffe03fULL,
0x000000090a097890ULL, 0x000fe4000fffe03fULL, 0x0ffffffe04047892ULL, 0x000fd8000f8ec03fULL,
0x0000000207097836ULL, 0x008fe20000000000ULL, 0x00009200000a7ab9ULL, 0x000fe20000000800ULL,
0x000000010b0a7812ULL, 0x000fc600078e0cffULL, 0x000000380900720cULL, 0x000fe20003f06070ULL,
0x0000010007097824ULL, 0x000fc800078e0202ULL, 0x0000000a420c7c24ULL, 0x000fd0000f8e0209ULL,
0x0000000c00308947ULL, 0x000fea0003800000ULL, 0x00000003ff1e7819ULL, 0x002fe20000011603ULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x000000093a0e7248ULL, 0x000fe20007fe0000ULL,
0x00008e00000a7ab9ULL, 0x000fe40000000a00ULL, 0x000000041e127836ULL, 0x000fe20000000000ULL,
0x0000007010107812ULL, 0x000fe200078ec0ffULL, 0x000000010e117824ULL, 0x000fe400078e0a09ULL,
0x000000081e147836ULL, 0x000fe40000000000ULL, 0x00000001120d7824ULL, 0x040fe200078e0203ULL,
0x000000111200720cULL, 0x040fe20003fa6070ULL, 0x0000000812287824ULL, 0x000fc400078e00ffULL,
0x0000000112127824ULL, 0x000fe400078e020cULL, 0x00000001140f7824ULL, 0x040fe200078e0203ULL,
0xfffffff828287812ULL, 0x000fe200078ee20dULL, 0x00000008142a7824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee20fULL,
0x000000011e0e7824ULL, 0x000fe200078e020cULL, 0x0000001012127212ULL, 0x000fe200078efcffULL,
0x000000101e187836ULL, 0x000fe40000000000ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000a12127c10ULL, 0x000fc6000ff3e0ffULL, 0x0000000c1e167836ULL, 0x000fe20000000000ULL,
0x000000100e0e7212ULL, 0x000fe200078efcffULL, 0x0000000118157824ULL, 0x140fe200078e0203ULL,
0x0000000b13137c10ULL, 0x000fe20008ffe4ffULL, 0x00000008182e7824ULL, 0x000fe200078e00ffULL,
0x0000000a0e0e7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000001160d7824ULL, 0x000fe200078e0203ULL,
0x000000111400720cULL, 0x0c0fe20003f26070ULL, 0x0000000114147824ULL, 0x100fe200078e020cULL,
0x000000111600720cULL, 0x0c0fe20003f46070ULL, 0x00000008162c7824ULL, 0x040fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee215ULL, 0x0000000116167824ULL, 0x000fe200078e020cULL,
0x0000000b0f0f7c10ULL, 0x000fe200087fe4ffULL, 0x000000141e247836ULL, 0x000fe20000000000ULL,
0x000000111800720cULL, 0x000fe20003f06070ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fc400078ee20dULL, 0x00000008390d7c11ULL, 0x000fe2000f8e70ffULL,
0x0000000118187824ULL, 0x000fe200078e020cULL, 0x0000001014147212ULL, 0x000fe200078efcffULL,
0x000000181e267836ULL, 0x000fe40000000000ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000a14147c10ULL, 0x000fc6000ff7e0ffULL, 0x00000001241c7824ULL, 0x100fe200078e020cULL,
0x00000010161a7212ULL, 0x080fe200078efcffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000000b15157c10ULL, 0x000fe40009ffe4ffULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000000126207824ULL, 0x000fe200078e020cULL, 0x0000001018167212ULL, 0x080fe200078efcffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000b171b7c10ULL, 0x000fe4000a7fe4ffULL,
0x0000000a16167c10ULL, 0x000fe2000ff7e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000101c187212ULL, 0x000fc400078efcffULL, 0x0000000b19177c10ULL, 0x000fe20009ffe4ffULL,
0x000000011e227824ULL, 0x000fe200078e0203ULL, 0x00000010201c7212ULL, 0x000fe200078efcffULL,
0x000020000a1f7824ULL, 0x000fe200078e020dULL, 0x0000000a18187c10ULL, 0x000fe2000ff9e0ffULL,
0x0000000124237824ULL, 0x140fe200078e0203ULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000824307824ULL, 0x000fe200078e00ffULL, 0x0000000b1d197c10ULL, 0x000fe2000a7fe4ffULL,
0x000010001f1f7836ULL, 0x000fe20000000000ULL, 0x0000000722227812ULL, 0x000fe200078ec0ffULL,
0x0000001c1e347836ULL, 0x000fe20000000000ULL, 0x000000111e00720cULL, 0x080fe20003f86070ULL,
0x000000281e3e7836ULL, 0x000fe20000000000ULL, 0x0000000b211d7c10ULL, 0x000fe20009ffe4ffULL,
0x0000000134207824ULL, 0x000fe200078e020cULL, 0x000000112400720cULL, 0x000fe20003f66070ULL,
0x000000201e367836ULL, 0x000fe20000000000ULL, 0x0ffffff822247812ULL, 0x000fe200078ef803ULL,
0x0000000126297824ULL, 0x040fe200078e0203ULL, 0xfffffff830307812ULL, 0x000fe200078ee223ULL,
0x0000000826327824ULL, 0x000fc400078e00ffULL, 0x0000001024277824ULL, 0x000fe400078e021fULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee229ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e277faeULL, 0x0003e2000e101c46ULL,
0x000000112600720cULL, 0x000fe20003f86070ULL, 0x000000013e267824ULL, 0x100fe200078e020cULL,
0x0000001020207212ULL, 0x000fe200078efcffULL, 0x0000000136227824ULL, 0x000fe400078e020cULL,
0x000000241e3c7836ULL, 0x000fe20000000000ULL, 0x0000000a20207c10ULL, 0x000fe2000ffde0ffULL,
0x0000000834297824ULL, 0x000fc400078e00ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000000b21217c10ULL, 0x000fc6000b7fe4ffULL, 0x00000080260e7825ULL, 0x002fe200078e00ffULL,
0x0000001022227212ULL, 0x000fc600078efcffULL, 0x0000000134267824ULL, 0x000fe200078e0203ULL,
0x0000000a22227c10ULL, 0x000fe2000ffde0ffULL, 0x0000001028277824ULL, 0x100fe200078e021fULL,
0x000000100e0e7212ULL, 0x080fe200078efcffULL, 0x000000013c247824ULL, 0x100fe200078e020cULL,
0xfffffff829267812ULL, 0x000fe200078ee226ULL, 0x000000102a297824ULL, 0x000fe200078e021fULL,
0x0000000012277faeULL, 0x0003e2000e901c46ULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x000000113400720cULL, 0x080fe40003fa6070ULL, 0x0000000014297faeULL, 0x0005e2000c901c46ULL,
0x0000000136287824ULL, 0x100fe200078e0203ULL, 0x0000001024247212ULL, 0x000fe200078efcffULL,
0x00000008362b7824ULL, 0x000fe200078e00ffULL, 0x0000000b23237c10ULL, 0x000fe2000b7fe4ffULL,
0x0000002c1e347836ULL, 0x000fe20000000000ULL, 0x0000000a24247c10ULL, 0x000fe2000ffde0ffULL,
0x000000013c2a7824ULL, 0x000fe200078e0203ULL, 0xfffffff82b287812ULL, 0x000fe200078ee228ULL,
0x0000000134127824ULL, 0x002fe200078e020cULL, 0x0000000b25257c10ULL, 0x000fe2000b7fe4ffULL,
0x000000102c277824ULL, 0x100fe200078e021fULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ffde0ffULL,
0x0000001026297824ULL, 0x104fe200078e021fULL, 0x000000113600720cULL, 0x080fe20003f26070ULL,
0x000000301e267836ULL, 0x000fe20000000000ULL, 0x000000001a277faeULL, 0x0003e2000d101c46ULL,
0x000000102e157824ULL, 0x000fe200078e021fULL, 0x0000000b0f0f7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000113c00720cULL, 0x000fc40003f46070ULL,
0x0000000016157faeULL, 0x0005e2000c101c46ULL, 0x00000010282b7824ULL, 0x100fe200078e021fULL,
0x0000001012127212ULL, 0x000fe200078efcffULL, 0x0000000126147824ULL, 0x000fe400078e020cULL,
0x000000341e287836ULL, 0x000fe20000000000ULL, 0x0000000a12127c10ULL, 0x000fe2000ffde0ffULL,
0x000000083c2d7824ULL, 0x000fe400078e00ffULL, 0x00000010301b7824ULL, 0x102fe200078e021fULL,
0x0000000b13137c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001032277824ULL, 0x000fe200078e021fULL,
0xfffffff82d2a7812ULL, 0x000fe200078ee22aULL, 0x0000008014147825ULL, 0x004fe200078e00ffULL,
0x00000000181b7faeULL, 0x0003e2000d901c46ULL, 0x000000112600720cULL, 0x000fc40003f66070ULL,
0x0000000128167824ULL, 0x100fe200078e020cULL, 0x0000001014147212ULL, 0x080fe200078efcffULL,
0x000000102a2d7824ULL, 0x000fe200078e021fULL, 0x000000001c277faeULL, 0x0005e2000e101c46ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe4000ffde0ffULL,
0x0000000020297faeULL, 0x0007e2000e901c46ULL, 0x000000381e2a7836ULL, 0x000fe20000000000ULL,
0x00000010161a7212ULL, 0x000fe200078efcffULL, 0x000000013e187824ULL, 0x142fe200078e0203ULL,
0x0000000b15157c10ULL, 0x000fe2000b7fe4ffULL, 0x000000083e197824ULL, 0x000fe200078e00ffULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x0000003c1e2c7836ULL, 0x000fe20000000000ULL,
0x00000000222b7faeULL, 0x0003e2000c901c46ULL, 0x000000012a167824ULL, 0x000fe200078e020cULL,
0xfffffff8191c7812ULL, 0x004fe200078ee218ULL, 0x0000000126187824ULL, 0x140fe200078e0203ULL,
0x00000000242d7faeULL, 0x0005e2000d101c46ULL, 0x0000000826197824ULL, 0x000fe200078e00ffULL,
0x000000113e00720cULL, 0x080fe20003fa6070ULL, 0x00000008341e7824ULL, 0x040fe200078e00ffULL,
0x000000113400720cULL, 0x080fe20003f86070ULL, 0x000000012a1d7824ULL, 0x100fe200078e0203ULL,
0x000000112800720cULL, 0x080fe20003f46070ULL, 0x000000012c217824ULL, 0x108fe200078e0203ULL,
0x000000112a00720cULL, 0x0c0fe20003f26070ULL, 0x000000082a227824ULL, 0x002fe200078e00ffULL,
0x000000112c00720cULL, 0x000fe20003f06070ULL, 0x0000000134117824ULL, 0x000fe200078e0203ULL,
0x0000000b171b7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffff819207812ULL, 0x000fc400078ee218ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee211ULL,
0x000000012c187824ULL, 0x000fe200078e020cULL, 0x0000001016167212ULL, 0x000fe200078efcffULL,
0x0000000128117824ULL, 0x000fe200078e0203ULL, 0xfffffff822227812ULL, 0x000fe200078ee21dULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000a16167c10ULL, 0x000fc6000ffde0ffULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x0000001018107212ULL, 0x000fe200078efcffULL,
0x000000082c247824ULL, 0x004fe200078e00ffULL, 0x0000000b17177c10ULL, 0x000fe2000b7fe4ffULL,
0x000000101c1d7824ULL, 0x100fe200078e021fULL, 0xfffffff8280c7812ULL, 0x000fe200078ee211ULL,
0x0000001020237824ULL, 0x100fe200078e021fULL, 0xfffffff824247812ULL, 0x000fe200078ee221ULL,
0x000000101e217824ULL, 0x100fe200078e021fULL, 0x0000000a10107c10ULL, 0x000fe2000ffde0ffULL,
0x000000100c257824ULL, 0x100fe200078e021fULL, 0x000000000e1d7faeULL, 0x0003e2000e901c46ULL,
0x0000001022277824ULL, 0x100fe200078e021fULL, 0x0000000b19117c10ULL, 0x000fe2000b7fe4ffULL,
0x00000010241f7824ULL, 0x000fe200078e021fULL, 0x0000000012217faeULL, 0x0003e8000e101c46ULL,
0x0000000014237faeULL, 0x0003e8000d901c46ULL, 0x000000001a257faeULL, 0x0003e8000d101c46ULL,
0x0000000016277faeULL, 0x0003e8000c901c46ULL, 0x00000000101f7faeULL, 0x0003e2000c101c46ULL,
0x0000000800e07947ULL, 0x000fea0003800000ULL, 0x0000000803127811ULL, 0x042fe200078fe8ffULL,
0x00000010033d7824ULL, 0x040fe200078e00ffULL, 0x0000001003167811ULL, 0x040fe200078fe8ffULL,
0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000000403107811ULL, 0x040fe200078fe8ffULL,
0x00000001120e7824ULL, 0x140fe200078e0203ULL, 0x0000001403187811ULL, 0x040fe200078fe8ffULL,
0x00000008120f7824ULL, 0x000fe200078e00ffULL, 0x00000020031e7811ULL, 0x040fe200078fe8ffULL,
0x0000000816137824ULL, 0x000fe200078e00ffULL, 0x0000000c03147811ULL, 0x040fe200078fe8ffULL,
0x00000001100d7824ULL, 0x100fe200078e0203ULL, 0xfffffff80f267812ULL, 0x000fe200078ee20eULL,
0x00000001160e7824ULL, 0x100fe200078e0203ULL, 0x0000002403207811ULL, 0x040fe200078fe8ffULL,
0x0000000810247824ULL, 0x000fe200078e00ffULL, 0x0000003003307811ULL, 0x040fe200078fe8ffULL,
0x00000001180f7824ULL, 0x140fe200078e0203ULL, 0xfffffff813327812ULL, 0x000fe200078ee20eULL,
0x0000000818347824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee20dULL,
0x000000011e0e7824ULL, 0x140fe200078e0203ULL, 0x0000001c031c7811ULL, 0x040fe200078fe8ffULL,
0x000000081e137824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee20fULL,
0x00000001140d7824ULL, 0x140fe200078e0203ULL, 0x00000034032e7811ULL, 0x040fe200078fe8ffULL,
0x0000000814287824ULL, 0x000fe200078e00ffULL, 0xfffffff813407812ULL, 0x000fe200078ee20eULL,
0x00000001200f7824ULL, 0x140fe200078e0203ULL, 0x00000018031a7811ULL, 0x040fe200078fe8ffULL,
0x0000000820447824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20dULL,
0x00000001300e7824ULL, 0x140fe200078e0203ULL, 0x0000002c033e7811ULL, 0x040fe200078fe8ffULL,
0x0000000830137824ULL, 0x000fe200078e00ffULL, 0xfffffff844447812ULL, 0x000fe200078ee20fULL,
0x000000011c0d7824ULL, 0x140fe200078e0203ULL, 0x0000002803227811ULL, 0x040fe200078fe8ffULL,
0x000000081c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8134a7812ULL, 0x000fe200078ee20eULL,
0x000000012e0f7824ULL, 0x140fe200078e0203ULL, 0x0000000c030e7211ULL, 0x040fe200078fe8ffULL,
0x000000082e4c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20dULL,
0x000000011a117824ULL, 0x140fe200078e0203ULL, 0x0000003c032a7811ULL, 0x000fe200078fe8ffULL,
0x000000081a367824ULL, 0x000fe200078e00ffULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee20fULL,
0x000000013e0d7824ULL, 0x040fe200078e0203ULL, 0x000000703d3d7812ULL, 0x000fe200078ec0ffULL,
0x000000083e487824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee211ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000038032c7811ULL, 0x000fc400078fe8ffULL,
0xfffffff848487812ULL, 0x000fe200078ee20dULL, 0x0000000112127824ULL, 0x000fe200078e020cULL,
0x0000003d0e0e7212ULL, 0x000fe200078efcffULL, 0x0000000122117824ULL, 0x140fe400078e0203ULL,
0x0000000822467824ULL, 0x000fe200078e00ffULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000012a0d7824ULL, 0x040fe400078e0203ULL, 0x000000082a507824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee211ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b0f0f7c10ULL, 0x000fc400087fe4ffULL, 0xfffffff850507812ULL, 0x000fe200078ee20dULL,
0x0000000114147824ULL, 0x000fe200078e020cULL, 0x0000003d12127212ULL, 0x000fe200078efcffULL,
0x000000012c117824ULL, 0x040fe200078e0203ULL, 0x00000008390d7c11ULL, 0x000fe2000f8e70ffULL,
0x000000082c4e7824ULL, 0x000fe200078e00ffULL, 0x0000000a12127c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee211ULL,
0x0000000118187824ULL, 0x100fe200078e020cULL, 0x0000003d14147212ULL, 0x000fe200078efcffULL,
0x000000011c1c7824ULL, 0x000fe200078e020cULL, 0x0000000b13137c10ULL, 0x000fe200087fe4ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fc6000ff1e0ffULL,
0x000020000a117824ULL, 0x000fe200078e020dULL, 0x0000003d18187212ULL, 0x000fe200078efcffULL,
0x0000000110107824ULL, 0x000fe200078e020cULL, 0x0000000b15157c10ULL, 0x000fe200087fe4ffULL,
0x0000100011437836ULL, 0x000fe20000000000ULL, 0x0000000a18187c10ULL, 0x000fe2000ff1e0ffULL,
0x000000801c1c7825ULL, 0x000fc600078e00ffULL, 0x0000000b19197c10ULL, 0x000fe200087fe4ffULL,
0x0000000120207824ULL, 0x000fe200078e020cULL, 0x0000003d1c1c7212ULL, 0x000fe200078efcffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000116167824ULL, 0x100fe200078e020cULL, 0x0000003d10107212ULL, 0x000fe200078efcffULL,
0x000000011a1a7824ULL, 0x100fe200078e020cULL, 0x0000000b1d1d7c10ULL, 0x000fe200087fe4ffULL,
0x000000011e1e7824ULL, 0x100fe200078e020cULL, 0x0000000a10107c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000122227824ULL, 0x100fe400078e020cULL, 0x000000013e3e7824ULL, 0x100fe200078e020cULL,
0x0000000b11117c10ULL, 0x000fe20008ffe4ffULL, 0x0000000130307824ULL, 0x000fc400078e020cULL,
0x000000012e2e7824ULL, 0x100fe400078e020cULL, 0x000000012c2c7824ULL, 0x100fe400078e020cULL,
0x000000012a2a7824ULL, 0x000fe200078e020cULL, 0x00000003030c7211ULL, 0x000fe200078fe8ffULL,
0x0000008020207825ULL, 0x000fc600078e00ffULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003d20207212ULL, 0x080fe400078efcffULL,
0x0ffffff80c0c7812ULL, 0x000fe200078ef803ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000003d16167212ULL, 0x080fe400078efcffULL, 0x0000000a20207c10ULL, 0x000fe2000ff1e0ffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000003d1a1a7212ULL, 0x000fc400078efcffULL,
0x0000000a16167c10ULL, 0x000fe2000ff3e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000003d3e3e7212ULL, 0x080fe400078efcffULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000003d1e1e7212ULL, 0x080fe400078efcffULL,
0x0000000b21217c10ULL, 0x000fe200087fe4ffULL, 0x0000001040357824ULL, 0x100fe200078e0243ULL,
0x0000003d22227212ULL, 0x000fe200078efcffULL, 0x0000001044377824ULL, 0x000fe200078e0243ULL,
0x0000000b17177c10ULL, 0x000fe20008ffe4ffULL, 0x0000008030407825ULL, 0x000fe200078e00ffULL,
0x0000000a3e3e7c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000b1b1b7c10ULL, 0x000fe200097fe4ffULL,
0x000000100c257824ULL, 0x100fe200078e0243ULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000010463b7824ULL, 0x100fe200078e0243ULL, 0x0000000a22227c10ULL, 0x000fe2000ff5e0ffULL,
0x000000802e447825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e257faeULL, 0x0003e2000b901c46ULL, 0x0000000b3f3f7c10ULL, 0x000fe400087fe4ffULL,
0x0000001024277824ULL, 0x100fe200078e0243ULL, 0x0000000b1f1f7c10ULL, 0x000fe20008ffe4ffULL,
0x00000010480c7824ULL, 0x100fe200078e0243ULL, 0x0000000b23237c10ULL, 0x000fe200097fe4ffULL,
0x000000802c467825ULL, 0x000fe200078e00ffULL, 0x0000000010277faeULL, 0x0003e6000b901c46ULL,
0x0000001026297824ULL, 0x000fc400078e0243ULL, 0x000000802a487825ULL, 0x000fc600078e00ffULL,
0x0000000012297faeULL, 0x0003e2000b901c46ULL, 0x00000010282b7824ULL, 0x100fe400078e0243ULL,
0x000000103c337824ULL, 0x100fe200078e0243ULL, 0x0000003d403c7212ULL, 0x080fe200078efcffULL,
0x00000010322d7824ULL, 0x100fe200078e0243ULL, 0x0000003d44407212ULL, 0x080fe200078efcffULL,
0x00000010342f7824ULL, 0x100fe200078e0243ULL, 0x0000003d46447212ULL, 0x080fe200078efcffULL,
0x0000001036317824ULL, 0x100fe200078e0243ULL, 0x0000003d483d7212ULL, 0x000fe200078efcffULL,
0x00000000142b7faeULL, 0x0003e2000b901c46ULL, 0x0000000a3c3c7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000104a247824ULL, 0x100fe200078e0243ULL, 0x0000000a40407c10ULL, 0x000fe2000ff3e0ffULL,
0x00000000162d7faeULL, 0x0003e2000b901c46ULL, 0x0000000a44447c10ULL, 0x000fe2000ff5e0ffULL,
0x000000104c267824ULL, 0x100fe200078e0243ULL, 0x0000000a3d467c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000182f7faeULL, 0x0003e2000b901c46ULL, 0x0000000b413d7c10ULL, 0x000fe200087fe4ffULL,
0x000000104e287824ULL, 0x100fe200078e0243ULL, 0x0000000b45417c10ULL, 0x000fe20008ffe4ffULL,
0x000000001a317faeULL, 0x0003e2000b901c46ULL, 0x0000000b47457c10ULL, 0x000fe200097fe4ffULL,
0x0000001050437824ULL, 0x000fe200078e0243ULL, 0x0000000b49477c10ULL, 0x000fe20009ffe4ffULL,
0x000000001c337faeULL, 0x0003e8000b901c46ULL, 0x000000001e357faeULL, 0x0003e8000b901c46ULL,
0x0000000020377faeULL, 0x0003e8000b901c46ULL, 0x00000000223b7faeULL, 0x0003e8000b901c46ULL,
0x000000003e0c7faeULL, 0x0003e8000b901c46ULL, 0x000000003c247faeULL, 0x0003e8000b901c46ULL,
0x0000000040267faeULL, 0x0003e8000b901c46ULL, 0x0000000044287faeULL, 0x0003e8000b901c46ULL,
0x0000000046437faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002003127836ULL, 0x002fe20000000000ULL, 0xfffffff803107812ULL, 0x000fe200078ec0ffULL,
0x000020000b357824ULL, 0x000fe200078e020dULL, 0x0000000703367812ULL, 0x000fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe400078ec0ffULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000004ff347819ULL, 0x000fc40000011603ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000100035357836ULL, 0x000fe20000000000ULL,
0x0000000710377812ULL, 0x000fe200078ef803ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000008363b7812ULL, 0x000fe400078ef803ULL, 0x00000007120b7812ULL, 0x000fce00078ef803ULL,
0x0000000137107824ULL, 0x140fe400078e0240ULL, 0x0000000837117824ULL, 0x000fe400078e00ffULL,
0x000000010b147824ULL, 0x040fe400078e0240ULL, 0x000000080b157824ULL, 0x000fe200078e00ffULL,
0xfffffff811107812ULL, 0x000fe200078ee210ULL, 0x0000000140467836ULL, 0x000fe40000000000ULL,
0x00000008373d7824ULL, 0x000fe200078e00ffULL, 0xfffffff815147812ULL, 0x000fe200078ee214ULL,
0x0000001010107824ULL, 0x000fc400078e0235ULL, 0x00000001373c7824ULL, 0x000fe400078e0246ULL,
0x0000001014147824ULL, 0x100fe400078e0235ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0xfffffff83d3c7812ULL, 0x000fe200078ee23cULL, 0x0000000240447824ULL, 0x000fe400078e0234ULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x000000103b527824ULL, 0x040fe400078e00ffULL,
0x000000103c3c7824ULL, 0x000fe200078e0235ULL, 0x000000023b597810ULL, 0x000fe20007ffe044ULL,
0x000000080b437824ULL, 0x000fc400078e00ffULL, 0x000000013b417824ULL, 0x000fe400078e0244ULL,
0x000000003c3c783bULL, 0x000ee20000000200ULL, 0x000000010b467824ULL, 0x000fe400078e0246ULL,
0xfffffff052527812ULL, 0x000fe200078ee241ULL, 0x000000103b487824ULL, 0x000fe400078e00ffULL,
0xfffffff8435e7812ULL, 0x000fe200078ee246ULL, 0x0000000240407836ULL, 0x000fe40000000000ULL,
0xfffffff048597812ULL, 0x000fc600078ee259ULL, 0x000000084000780cULL, 0x000fe40003f05270ULL,
0x00000010ff517819ULL, 0x102fe40000011610ULL, 0x00000018ff537819ULL, 0x000fe40000011610ULL,
0x000000ff10547812ULL, 0x040fe400078ec0ffULL, 0x0000ffff10467812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6d7819ULL, 0x004fc40000011614ULL, 0x00000018ff757819ULL, 0x000fe40000011614ULL,
0x000000ff14737812ULL, 0x040fe400078ec0ffULL, 0x0000ffff146a7812ULL, 0x000fe200078ec0ffULL,
0x000000105e147824ULL, 0x000fe200078e0235ULL, 0x0000000852107c11ULL, 0x000fe4000f8e20ffULL,
0x00000010ff457819ULL, 0x100fe40000011611ULL, 0x00000018ff577819ULL, 0x000fc40000011611ULL,
0x000000ff115b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff114f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff477819ULL, 0x100fe40000011612ULL, 0x00000018ff507819ULL, 0x000fe40000011612ULL,
0x000000ff12777812ULL, 0x040fe400078ec0ffULL, 0x0000ffff12697812ULL, 0x000fc400078ec0ffULL,
0x00000010ff607819ULL, 0x100fe40000011613ULL, 0x00000018ff767819ULL, 0x000fe40000011613ULL,
0x000000ff13727812ULL, 0x040fe400078ec0ffULL, 0x0000ffff13637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff687819ULL, 0x100fe20000011615ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x00000018ff6b7819ULL, 0x000fc40000011615ULL, 0x000000ff156c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff15677812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x100fe40000011616ULL,
0x00000018ff707819ULL, 0x000fe40000011616ULL, 0x000000ff166f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff165a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5f7819ULL, 0x100fe40000011617ULL,
0x00000018ff667819ULL, 0x000fe40000011617ULL, 0x000000ff176e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff17617812ULL, 0x000fe400078ec0ffULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x00000010ff487819ULL, 0x108fe4000001163cULL, 0x00000018ff5c7819ULL, 0x000fc4000001163cULL,
0x000000ff3c587812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3c497812ULL, 0x000fe400078ec0ffULL,
0x00000053ff3c723eULL, 0x000fe400020006ffULL, 0x000000ff51517812ULL, 0x000fe400078ec0ffULL,
0x00000008ff467819ULL, 0x000fe20000011646ULL, 0x2000003cff527230ULL, 0x000fe20000004100ULL,
0x00000054ff53723eULL, 0x000fc400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000050ff54723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x000000ff45507812ULL, 0x000fe200078ec0ffULL, 0x20000057ff3c7230ULL, 0x000fe20000004100ULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x20000054ff457230ULL, 0x000fe20000004100ULL,
0x00000008ff4f7819ULL, 0x000fe4000001164fULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x000000ff47577812ULL, 0x000fe200078ec0ffULL,
0x20000046ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe20000011652ULL,
0x20000050ff547230ULL, 0x000fe20000004100ULL, 0x00000010ff467819ULL, 0x000fe20000011653ULL,
0x2000004fff507230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff4f7819ULL, 0x000fc40000011647ULL, 0x0000105452477816ULL, 0x000fe40000000051ULL,
0x000010544f467816ULL, 0x000fe40000000046ULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000010ff4a7819ULL, 0x100fe4000001163dULL, 0x00000018ff557819ULL, 0x000fe2000001163dULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x000000ff3d437812ULL, 0x040fe200078ec0ffULL,
0x000000461030723cULL, 0x002fe20000041830ULL, 0x0000ffff3d567812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4d7819ULL, 0x100fe4000001163eULL, 0x00000018ff447819ULL, 0x000fe4000001163eULL,
0x000000ff3e417812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3e4c7812ULL, 0x000fe400078ec0ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff4b7819ULL, 0x000fc4000001163fULL,
0x00000018ff3d7819ULL, 0x000fe4000001163fULL, 0x000000ff3f3e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3f4e7812ULL, 0x000fe400078ec0ffULL, 0x0000005bff3f723eULL, 0x000fe400020006ffULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff517819ULL, 0x000fe20000011654ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x004fc40000011616ULL,
0x00000018ff5d7819ULL, 0x000fe40000011616ULL, 0x000000ff16467812ULL, 0x040fe400078ec0ffULL,
0x0000ffff165b7812ULL, 0x000fe400078ec0ffULL, 0x0000006cff16723eULL, 0x000fe200020006ffULL,
0x20000073ff6c7230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000070ff73723eULL, 0x000fe200020006ffULL, 0x20000016ff167230ULL, 0x000fe20000004100ULL,
0x00000010ff4f7819ULL, 0x000fc40000011657ULL, 0x000010543c517816ULL, 0x000fe40000000051ULL,
0x0000006fff70723eULL, 0x000fe400020006ffULL, 0x00000010ff547819ULL, 0x100fe40000011617ULL,
0x00000018ff477819ULL, 0x000fe40000011617ULL, 0x000000ff17577812ULL, 0x040fe400078ec0ffULL,
0x0000ffff173c7812ULL, 0x000fc400078ec0ffULL, 0x0000006bff17723eULL, 0x000fe200020006ffULL,
0x20000075ff6b7230ULL, 0x000fe20000004100ULL, 0x00000066ff75723eULL, 0x000fe200020006ffULL,
0x20000073ff667230ULL, 0x000fe20000004100ULL, 0x00000008ff6f7819ULL, 0x000fe20000011669ULL,
0x20000070ff697230ULL, 0x000fe20000004100ULL, 0x0000006eff73723eULL, 0x000fe200020006ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x000000ff60707812ULL, 0x000fe200078ec0ffULL,
0x20000075ff607230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fe20000011663ULL,
0x20000073ff637230ULL, 0x000fe20000004100ULL, 0x00000008ff6a7819ULL, 0x000fc4000001166aULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x2000006fff737230ULL, 0x000fe20000004100ULL,
0x000000ff62757812ULL, 0x000fe400078ec0ffULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000070ff6f7230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fc400020006ffULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000006eff707230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x2000006aff6e7230ULL, 0x000fe20000004100ULL,
0x00000044ff44723eULL, 0x000fe200020006ffULL, 0x20000067ff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fe2000001163fULL, 0x20000075ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe40000011645ULL, 0x00000010ff507819ULL, 0x000fc40000011650ULL,
0x00000018ff747819ULL, 0x000fe40000011615ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x000000ff145e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff15457812ULL, 0x000fe400078ec0ffULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x0000003dff75723eULL, 0x000fe200020006ffULL,
0x20000044ff3d7230ULL, 0x000fe20000004100ULL, 0x0000105450507816ULL, 0x000fc4000000003fULL,
0x00001054524f7816ULL, 0x000fe4000000004fULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x100fe20000011614ULL, 0x00000050102c723cULL, 0x000fe2000004182cULL,
0x00000018ff3f7819ULL, 0x000fe40000011614ULL, 0x0000ffff14527812ULL, 0x000fe200078ec0ffULL,
0x20000076ff147230ULL, 0x000fe20000004100ULL, 0x0000005eff44723eULL, 0x000fc400020006ffULL,
0x00000045ff5e723eULL, 0x000fe200020006ffULL, 0x20000074ff457230ULL, 0x000fe20000004100ULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x0000005fff76723eULL, 0x000fe400020006ffULL, 0x00000046ff74723eULL, 0x000fe200020006ffULL,
0x2000005eff467230ULL, 0x000fe20000004100ULL, 0x00000061ff5f723eULL, 0x000fe200020006ffULL,
0x20000076ff617230ULL, 0x000fe20000004100ULL, 0x00000047ff5e723eULL, 0x000fc400020006ffULL,
0x0000003fff76723eULL, 0x000fe200020006ffULL, 0x20000075ff3f7230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000057ff75723eULL, 0x000fe400020006ffULL,
0x00000008ff577819ULL, 0x000fe20000011649ULL, 0x2000005eff497230ULL, 0x000fe20000004100ULL,
0x000000ff4a5e7812ULL, 0x000fe200078ec0ffULL, 0x2000005dff477230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000075ff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fc40000011615ULL, 0x0000ffff15647812ULL, 0x000fe400078ec0ffULL,
0x000000ff485d7812ULL, 0x000fe200078ec0ffULL, 0x20000074ff487230ULL, 0x000fe20000004100ULL,
0x00000072ff15723eULL, 0x000fe200020006ffULL, 0x20000077ff727230ULL, 0x000fe20000004100ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x0000005eff74723eULL, 0x000fe200020006ffULL,
0x20000015ff157230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x20000057ff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL,
0x20000074ff577230ULL, 0x000fe20000004100ULL, 0x00000008ff747819ULL, 0x000fc4000001164eULL,
0x00000010ff4e7819ULL, 0x000fe40000011672ULL, 0x00000010ff727819ULL, 0x000fe40000011614ULL,
0x00000010ff147819ULL, 0x000fe40000011615ULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x00000010ff157819ULL, 0x000fe4000001166fULL, 0x00001054734e7816ULL, 0x000fc4000000004eULL,
0x00000010ff6f7819ULL, 0x000fe40000011670ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x0000004e1028723cULL, 0x000fe20000041828ULL,
0x0000105472157816ULL, 0x000fe20000000015ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x000010546f147816ULL, 0x000fe40000000014ULL, 0x00000008ff627819ULL, 0x000fe2000001165aULL,
0x20000068ff5a7230ULL, 0x000fe20000004100ULL, 0x00000008ff6f7819ULL, 0x000fc40000011652ULL,
0x00000010ff527819ULL, 0x000fe2000001166cULL, 0x000000141024723cULL, 0x000fe20000041824ULL,
0x00000010ff4f7819ULL, 0x000fe4000001166eULL, 0x000000ff53707812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001166bULL, 0x00000010ff537819ULL, 0x000fe4000001166dULL,
0x000010544f527816ULL, 0x000fc40000000052ULL, 0x00000010ff147819ULL, 0x000fe40000011617ULL,
0x00000010ff167819ULL, 0x000fe40000011616ULL, 0x00000010ff157819ULL, 0x000fe4000001166aULL,
0x00000008596b7c11ULL, 0x000fe4000f8e20ffULL, 0x00000010ff4f7819ULL, 0x000fe4000001165aULL,
0x000010544e537816ULL, 0x000fc40000000053ULL, 0x00001054144f7816ULL, 0x000fe4000000004fULL,
0x00001054154e7816ULL, 0x000fe40000000016ULL, 0x000000006b14783bULL, 0x000e620000000200ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x000000521020723cULL, 0x000fe20000041820ULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000062ff687230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x2000005fff627230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x0000004e101c723cULL, 0x000fe2000004181cULL, 0x00000010ff537819ULL, 0x000fe20000011667ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff567819ULL, 0x000fe20000011656ULL,
0x20000058ff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff656a7812ULL, 0x000fe200078ec0ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000064ff67723eULL, 0x000fc400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe40000011663ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff527819ULL, 0x000fe40000011669ULL, 0x00000010ff657819ULL, 0x000fe40000011668ULL,
0x00000010ff647819ULL, 0x000fe40000011660ULL, 0x00000010ff4f7819ULL, 0x000fe20000011661ULL,
0x20000067ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fc40000011662ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x0000105466537816ULL, 0x000fe20000000053ULL, 0x20000043ff587230ULL, 0x000fe20000004100ULL,
0x0000105465527816ULL, 0x000fe20000000052ULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00001054644f7816ULL, 0x000fc4000000004fULL, 0x00001054634e7816ULL, 0x000fe4000000004eULL,
0x000000ff4d4d7812ULL, 0x000fe200078ec0ffULL, 0x000000521018723cULL, 0x000fe20000041818ULL,
0x00000008ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x0000004e100c723cULL, 0x000fe2000004180cULL,
0x00000010ff5d7819ULL, 0x000fc4000001165dULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x000010545c117816ULL, 0x000fc4000000005dULL, 0x000010545e107816ULL, 0x000fe2000000005fULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe40000011655ULL,
0x00000010ff127819ULL, 0x000fe40000011658ULL, 0x00000010ff137819ULL, 0x000fe20000011657ULL,
0x000000101430723cULL, 0x002fe20000041830ULL, 0x00000010ff4f7819ULL, 0x000fe40000011656ULL,
0x0000003eff43723eULL, 0x000fe200020006ffULL, 0x20000041ff3e7230ULL, 0x000fe20000004100ULL,
0x0000004bff75723eULL, 0x000fe200020006ffULL, 0x2000004dff4b7230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000043ff417230ULL, 0x000fe20000004100ULL,
0x000000ff71717812ULL, 0x000fe200078ec0ffULL, 0x20000075ff4d7230ULL, 0x000fe20000004100ULL,
0x0000105452137816ULL, 0x000fe20000000013ULL, 0x20000074ff507230ULL, 0x000fe20000004100ULL,
0x000010544f127816ULL, 0x000fe20000000012ULL, 0x20000076ff437230ULL, 0x000fe20000004100ULL,
0x00000008ff4f7819ULL, 0x000fc4000001163cULL, 0x00000010ff3c7819ULL, 0x000fe4000001163dULL,
0x00000010ff107819ULL, 0x000fe2000001163eULL, 0x00000012142c723cULL, 0x000fe2000004182cULL,
0x00000010ff117819ULL, 0x000fe4000001164bULL, 0x00000010ff3d7819ULL, 0x000fe4000001164cULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000008ff5b7819ULL, 0x000fc4000001165bULL,
0x000000ff54547812ULL, 0x000fe200078ec0ffULL, 0x20000071ff517230ULL, 0x000fe20000004100ULL,
0x000010543c117816ULL, 0x000fe40000000011ULL, 0x000010543d107816ULL, 0x000fe40000000010ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000010ff3c7819ULL, 0x000fe4000001163fULL,
0x00000010ff127819ULL, 0x000fe20000011641ULL, 0x2000006fff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff137819ULL, 0x000fe2000001164dULL, 0x000000101428723cULL, 0x000fe20000041828ULL,
0x00000010ff3d7819ULL, 0x000fc40000011650ULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x20000070ff597230ULL, 0x000fe20000004100ULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x2000006aff607230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x2000005bff4e7230ULL, 0x000fe20000004100ULL, 0x000010543c137816ULL, 0x000fe20000000013ULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x000010543d127816ULL, 0x000fe20000000012ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff3e7819ULL, 0x000fc40000011643ULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff3c7819ULL, 0x000fe20000011644ULL,
0x000000121424723cULL, 0x000fe20000041824ULL, 0x000010543e3d7816ULL, 0x000fe40000000051ULL,
0x00000010ff117819ULL, 0x000fe4000001165aULL, 0x00000010ff3e7819ULL, 0x000fe40000011645ULL,
0x00000010ff597819ULL, 0x000fc40000011659ULL, 0x00000010ff107819ULL, 0x000fe40000011646ULL,
0x00000010ff447819ULL, 0x000fe40000011647ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff3f7819ULL, 0x000fe40000011660ULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff127819ULL, 0x000fc40000011649ULL, 0x00000010ff137819ULL, 0x000fe4000001164eULL,
0x00000010ff4b7819ULL, 0x000fe40000011654ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00001054113c7816ULL, 0x000fe4000000003cULL,
0x000010543e117816ULL, 0x000fc40000000059ULL, 0x0000105461107816ULL, 0x000fe40000000010ULL,
0x00001054443f7816ULL, 0x000fe2000000003fULL, 0x0000003c1420723cULL, 0x000fe20000041820ULL,
0x00001054133e7816ULL, 0x000fe40000000048ULL, 0x00001054124b7816ULL, 0x000fe4000000004bULL,
0x000010544f4a7816ULL, 0x000fe2000000004aULL, 0x00000010141c723cULL, 0x000fec000004181cULL,
0x0000003e1418723cULL, 0x000fec0000041818ULL, 0x0000004a140c723cULL, 0x000fe2000004180cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffffe800300947ULL, 0x000fde000383ffffULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x00000004300b7220ULL, 0x080fe20000410000ULL,
0x0000000431317220ULL, 0x080fe20000410000ULL, 0x0000000432327220ULL, 0x080fe20000410000ULL,
0x0000000433337220ULL, 0x080fe20000410000ULL, 0x000000042c2c7220ULL, 0x080fe20000410000ULL,
0x01768810051079a7ULL, 0x000e62000850003fULL, 0x000000042d2d7220ULL, 0x080fe20000410000ULL,
0x000000042e2e7220ULL, 0x080fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000428287220ULL, 0x080fe20000410000ULL, 0x0000000429297220ULL, 0x080fe20000410000ULL,
0x000000042a2a7220ULL, 0x080fe20000410000ULL, 0x000000042b2b7220ULL, 0x080fe20000410000ULL,
0x0000000424247220ULL, 0x080fe20000410000ULL, 0x0000000425257220ULL, 0x080fe20000410000ULL,
0x0000000426267220ULL, 0x080fe20000410000ULL, 0x0000000427277220ULL, 0x080fe20000410000ULL,
0x0000000420207220ULL, 0x080fe20000410000ULL, 0x0000000421217220ULL, 0x080fe20000410000ULL,
0x0000000422227220ULL, 0x080fe20000410000ULL, 0x0000000423237220ULL, 0x080fe20000410000ULL,
0x000000041c1c7220ULL, 0x080fe20000410000ULL, 0x000000041d1d7220ULL, 0x080fe20000410000ULL,
0x000000041e1e7220ULL, 0x080fe20000410000ULL, 0x000000041f1f7220ULL, 0x080fe20000410000ULL,
0x0000000418307220ULL, 0x080fe20000410000ULL, 0x0000000419347220ULL, 0x080fe20000410000ULL,
0x000000041a1a7220ULL, 0x080fe20000410000ULL, 0x000000041b1b7220ULL, 0x080fe20000410000ULL,
0x000000040c357220ULL, 0x080fe20000410000ULL, 0x000000040d377220ULL, 0x080fe20000410000ULL,
0x000000040e3c7220ULL, 0x080fe20000410000ULL, 0x000000040f3d7220ULL, 0x000fe20000410000ULL,
0x00000000000c7805ULL, 0x000fe20000015200ULL, 0x01768811050075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff127224ULL, 0x000fce00078e00ffULL,
0x000000101200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000130e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000112127836ULL, 0x000fce0000000000ULL,
0x01768811050075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000004030c7824ULL, 0x000fe200078e00ffULL, 0x00000008393b7c11ULL, 0x000fe4000f8e38ffULL,
0x000000080700720cULL, 0x000fe40003f06070ULL, 0xfffffff00c0c7812ULL, 0x000fca00078ec0ffULL,
0x000000013b3b7824ULL, 0x000fca00078e020cULL, 0x017400003b0c7984ULL, 0x0002a20000000c00ULL,
0x0000001000c48947ULL, 0x000fea0003800000ULL, 0xffffff0009097836ULL, 0x000fe20000000000ULL,
0x00008c00ff107b82ULL, 0x000ee20000000a00ULL, 0x0000000203417824ULL, 0x000fe200078e00ffULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0x00008400000b7ab9ULL, 0x000fe20000000800ULL,
0x000000093a3e7248ULL, 0x000fe40007fe0000ULL, 0x0000000641417812ULL, 0x000fc600078ec0ffULL,
0x000000013e3e7824ULL, 0x000fe200078e0a09ULL, 0x0000000003097211ULL, 0x000fe200078ff0ffULL,
0x0000000941137c36ULL, 0x000fe40008000000ULL, 0x000000ffff507224ULL, 0x000fe200078e0a3eULL,
0x0000000aff127c19ULL, 0x000fe20008011609ULL, 0x0000000809147836ULL, 0x000fe20000000000ULL,
0x0000003e1300720cULL, 0x000fe20003f26070ULL, 0x0000000b41097c36ULL, 0x000fe20008000000ULL,
0x0000000513137e46ULL, 0x000fe4000b800050ULL, 0x0000000512127c48ULL, 0x000fc4000bfe0000ULL,
0x0000003e0900720cULL, 0x000fe40003f06070ULL, 0x00000005093f7e46ULL, 0x000fe2000b800050ULL,
0x00000004125b7c24ULL, 0x000fe2000f8e02ffULL, 0x00000004ff137819ULL, 0x000fe40000011613ULL,
0x000000ff3f3f7207ULL, 0x000fe40000000000ULL, 0x000000ff13127207ULL, 0x000fe40000800000ULL,
0x0000000aff147c19ULL, 0x000fc40008011614ULL, 0x0000001041457812ULL, 0x000fe200078efcffULL,
0x000000015b177824ULL, 0x000fe200078e0212ULL, 0x0000005b3f197211ULL, 0x000fe400078fe0ffULL,
0x0000000514147c48ULL, 0x000fe2000bfe0000ULL, 0x00000009454b7c36ULL, 0x000fe40008000000ULL,
0x0000000b45477c36ULL, 0x000fe40008000000ULL, 0x0000000219187825ULL, 0x008fc800078e0010ULL,
0x0000000217167825ULL, 0x000fe200078e0010ULL, 0x000000054b487e46ULL, 0x000fe2000b800050ULL,
0x0000000618437981ULL, 0x000ee4000c1e9500ULL, 0x0000000414597c24ULL, 0x000fe2000f8e02ffULL,
0x0000003e4700720cULL, 0x080fe20003f06070ULL, 0x0000000616407981ULL, 0x0008e2000c1e9500ULL,
0x0000000547467e46ULL, 0x000fe2000b800050ULL, 0x0000000112157824ULL, 0x000fe200078e0259ULL,
0x0000003e4b00720cULL, 0x000fe40003f26070ULL, 0x00000020414b7812ULL, 0x000fc400078efcffULL,
0x000000593f137211ULL, 0x000fe400078fe0ffULL, 0x00000004ff487819ULL, 0x000fe40000011648ULL,
0x000000ff46467207ULL, 0x000fe20000000000ULL, 0x0000000b4b4f7c36ULL, 0x000fe20008000000ULL,
0x000000ff48167207ULL, 0x012fe20000800000ULL, 0x0000000213127825ULL, 0x000fe200078e0010ULL,
0x0000005b46177211ULL, 0x000fc600078fe0ffULL, 0x0000000215147825ULL, 0x000fe200078e0010ULL,
0x0000003e4f00720cULL, 0x000fe20003f06070ULL, 0x0000000612447981ULL, 0x0042a2000c1e9500ULL,
0x000000054f527e46ULL, 0x000fe2000b800050ULL, 0x000000094b537c36ULL, 0x000fe40008000000ULL,
0x000000015b197824ULL, 0x000fe200078e0216ULL, 0x0000000614497981ULL, 0x0008a2000c1e9500ULL,
0x000000ff52527207ULL, 0x000fe20000000000ULL, 0x0000000217127825ULL, 0x002fe200078e0010ULL,
0x0000005946177211ULL, 0x000fc400078fe0ffULL, 0x00000005534c7e46ULL, 0x000fe2000b800050ULL,
0x0000000219147825ULL, 0x010fe200078e0010ULL, 0x0000000612487981ULL, 0x000322000c1e9500ULL,
0x0000003e5300720cULL, 0x000fe40003f26070ULL, 0x0000000116197824ULL, 0x000fe200078e0259ULL,
0x0000003041537812ULL, 0x000fe200078efcffULL, 0x0000000217167825ULL, 0x000fe200078e0010ULL,
0x00000004ff4c7819ULL, 0x000fe2000001164cULL, 0x00000006144d7981ULL, 0x000f22000c1e9500ULL,
0x0000005b52137211ULL, 0x002fe200078fe0ffULL, 0x0000000219187825ULL, 0x100fe200078e0010ULL,
0x000000ff4c4e7207ULL, 0x000fe20000800000ULL, 0x00000006164a7981ULL, 0x000364000c1e9500ULL,
0x0000000213127825ULL, 0x000fc400078e0010ULL, 0x0000000618517981ULL, 0x000364000c1e9500ULL,
0x00000009535d7c36ULL, 0x000fe40008000000ULL, 0x00000006124c7981ULL, 0x000362000c1e9500ULL,
0x0000000b53557c36ULL, 0x000fe20008000000ULL, 0x0000005952177211ULL, 0x002fe200078fe0ffULL,
0x000000015b157824ULL, 0x000fe400078e024eULL, 0x000000014e197824ULL, 0x000fe200078e0259ULL,
0x000000055d127e46ULL, 0x000fc6000b800050ULL, 0x0000000219187825ULL, 0x100fe200078e0010ULL,
0x0000003e5500720cULL, 0x080fe40003f06070ULL, 0x0000000555547e46ULL, 0x000fe2000b800050ULL,
0x0000000215147825ULL, 0x000fe200078e0010ULL, 0x0000003e5d00720cULL, 0x000fe20003f26070ULL,
0x0000000618197981ULL, 0x000f62000c1e9500ULL, 0x00000004ff127819ULL, 0x000fe20000011612ULL,
0x0000000217167825ULL, 0x000fe200078e0010ULL, 0x000000ff54547207ULL, 0x000fe20000000000ULL,
0x0000000614577981ULL, 0x000362000c1e9500ULL, 0x000000ff12507207ULL, 0x000fc60000800000ULL,
0x00000006164e7981ULL, 0x000362000c1e9500ULL, 0x0000005b54137211ULL, 0x000fe200078fe0ffULL,
0x000000015b157824ULL, 0x002fc800078e0250ULL, 0x0000000213127825ULL, 0x000fc800078e0010ULL,
0x0000000215147825ULL, 0x000fe400078e0010ULL, 0x0000000612127981ULL, 0x000f62000c1e9500ULL,
0x0000005954177211ULL, 0x000fc600078fe0ffULL, 0x0000000614157981ULL, 0x000362000c1e9500ULL,
0x00000001505b7824ULL, 0x000fe400078e0259ULL, 0x0000000217167825ULL, 0x000fc800078e0010ULL,
0x000000025b107825ULL, 0x000fe400078e0010ULL, 0x0000000616167981ULL, 0x000f68000c1e9500ULL,
0x00000006105f7981ULL, 0x000362000c1e9500ULL, 0xfffffff03f3f7812ULL, 0x000fe400078ec0ffULL,
0xfffffff046467812ULL, 0x000fe400078ec0ffULL, 0x00000001417d7812ULL, 0x040fe200078efcffULL,
0x000000013e3f7824ULL, 0x000fe200078e023fULL, 0x00000008417b7812ULL, 0x000fc400078efcffULL,
0x0000000941797812ULL, 0x000fe200078efcffULL, 0x000000013e667824ULL, 0x000fe200078e0246ULL,
0xfffffff054547812ULL, 0x000fe200078ec0ffULL, 0x00000001ff507424ULL, 0x000fe400078e00ffULL,
0x0000000b7d187c36ULL, 0x000fe40008000000ULL, 0x0000000b7b147c36ULL, 0x002fe40008000000ULL,
0x0000000b79107c36ULL, 0x000fe40008000000ULL, 0x0000000109467824ULL, 0x000fc400078e0a3fULL,
0x000000013e5a7824ULL, 0x000fe400078e0254ULL, 0x0000000118587824ULL, 0x100fe400078e0a3fULL,
0x0000000114567824ULL, 0x100fe400078e0a3fULL, 0x0000000110547824ULL, 0x000fe200078e0a3fULL,
0x00000046503f7219ULL, 0x040fe400000006ffULL, 0x00000018416f7812ULL, 0x000fe400078efcffULL,
0x0000005650567219ULL, 0x000fc400000006ffULL, 0x0000005450547219ULL, 0x000fe400000006ffULL,
0xfffffff052527812ULL, 0x000fe200078ec0ffULL, 0x0000000b6f757c36ULL, 0x000fc80008000000ULL,
0x000000013e647824ULL, 0x000fe400078e0252ULL, 0x0000000147527824ULL, 0x100fe400078e0a66ULL,
0x00000001755c7824ULL, 0x000fe200078e0a66ULL, 0x0000001141717812ULL, 0x040fe400078efcffULL,
0x00000019416d7812ULL, 0x000fe400078efcffULL, 0x0000005850587219ULL, 0x040fe400000006ffULL,
0x0000005250527219ULL, 0x000fc400000006ffULL, 0x0000005c505c7219ULL, 0x000fe200000006ffULL,
0x0000000b71777c36ULL, 0x000fe40008000000ULL, 0x0000000b6d737c36ULL, 0x000fe40008000000ULL,
0x00000001776e7824ULL, 0x100fe400078e0a66ULL, 0x0000000173667824ULL, 0x000fe400078e0a66ULL,
0x000000014f6c7824ULL, 0x000fe200078e0a64ULL, 0x0000002141657812ULL, 0x000fc400078efcffULL,
0x0000002841637812ULL, 0x040fe400078efcffULL, 0x0000002941617812ULL, 0x000fe400078efcffULL,
0x0000006e50467219ULL, 0x040fe400000006ffULL, 0x0000006650667219ULL, 0x040fe400000006ffULL,
0x0000006c506c7219ULL, 0x000fe200000006ffULL, 0x0000000b656b7c36ULL, 0x000fe40008000000ULL,
0x0000000b63697c36ULL, 0x000fc40008000000ULL, 0x0000000b61677c36ULL, 0x000fe40008000000ULL,
0x000000016b6a7824ULL, 0x100fe400078e0a64ULL, 0x0000000169687824ULL, 0x100fe400078e0a64ULL,
0x0000000167647824ULL, 0x000fe400078e0a64ULL, 0x0000000155627824ULL, 0x000fe200078e0a5aULL,
0x0000003141177812ULL, 0x040fe400078efcffULL, 0x0000003841137812ULL, 0x000fc400078efcffULL,
0x0000003941117812ULL, 0x000fe400078efcffULL, 0x0000006a506a7219ULL, 0x040fe400000006ffULL,
0x0000006850687219ULL, 0x040fe400000006ffULL, 0x0000006450647219ULL, 0x040fe400000006ffULL,
0x0000006250627219ULL, 0x000fe200000006ffULL, 0x0000000b175d7c36ULL, 0x000fe40008000000ULL,
0x0000000b135b7c36ULL, 0x000fc40008000000ULL, 0x0000000b11597c36ULL, 0x000fe40008000000ULL,
0x000000015d607824ULL, 0x100fe400078e0a5aULL, 0x000000015b5e7824ULL, 0x100fe400078e0a5aULL,
0x00000001595a7824ULL, 0x000fe200078e0a5aULL, 0x0000006050607219ULL, 0x040fe400000006ffULL,
0x0000005e505e7219ULL, 0x040fe400000006ffULL, 0x0000005a505a7219ULL, 0x000fc400000006ffULL,
0x0000541043437816ULL, 0x008fc80000000040ULL, 0x000000433fff7212ULL, 0x000fc8000780c0ffULL,
0x0000003e0900720cULL, 0x000fc80000701470ULL, 0x0000003e4100720cULL, 0x000fc800007a1070ULL,
0xff8000000b0b7808ULL, 0x000fe40002800000ULL, 0x0000541044497816ULL, 0x004fc80000000049ULL,
0x000000493fff7212ULL, 0x080fe4000784c0ffULL, 0x0000004956ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004954ff7212ULL, 0x000fe400078ac0ffULL, 0x0000003e0900720cULL, 0x080fe40001741470ULL,
0x0000003e1400720cULL, 0x080fe400037c1470ULL, 0x0000003e1000720cULL, 0x000fc40002fa1470ULL,
0x0000003e4100720cULL, 0x080fe40001741070ULL, 0x0000003e7b00720cULL, 0x080fe400037c1070ULL,
0x0000003e7900720cULL, 0x000fe40002fa1070ULL, 0x00005410484d7816ULL, 0x010fe4000000004dULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0x000054104a517816ULL, 0x020fc40000000051ULL,
0xff8000002e2e7808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x0000004358ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004356ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004354ff7212ULL, 0x000fe4000788c0ffULL, 0x0000004958ff7212ULL, 0x000fc4000780c0ffULL,
0x0000004d52ff7212ULL, 0x040fe4000784c0ffULL, 0x0000005152ff7212ULL, 0x080fe400078cc0ffULL,
0x000000515cff7212ULL, 0x000fe400078ac0ffULL, 0x0000003e1800720cULL, 0x0c0fe40000f21470ULL,
0x0000003e1800720cULL, 0x080fe40000701470ULL, 0x0000003e1400720cULL, 0x000fc40001f61470ULL,
0x0000003e1000720cULL, 0x080fe40002781470ULL, 0x0000003e4700720cULL, 0x0c0fe40001741470ULL,
0x0000003e4700720cULL, 0x080fe400037c1470ULL, 0x0000003e7500720cULL, 0x080fe40002fa1470ULL,
0x0000003e7d00720cULL, 0x0c0fe40000f21070ULL, 0x0000003e7d00720cULL, 0x000fc40000701070ULL,
0x0000003e7b00720cULL, 0x080fe40001f61070ULL, 0x0000003e7900720cULL, 0x080fe40002781070ULL,
0x0000003e4500720cULL, 0x0c0fe40001741070ULL, 0x0000003e4500720cULL, 0x080fe400037c1070ULL,
0x0000003e6f00720cULL, 0x000fe40002fa1070ULL, 0x000054104c577816ULL, 0x000fc40000000057ULL,
0x000054104e197816ULL, 0x000fe40000000019ULL, 0xff80000031317808ULL, 0x000fe40000800000ULL,
0xff80000033337808ULL, 0x000fe40000000000ULL, 0xff8000002c2c7808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fc40001000000ULL,
0xff8000002a2a7808ULL, 0x000fe40003000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0x0000004d46ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004d5cff7212ULL, 0x080fe4000780c0ffULL,
0x0000004d66ff7212ULL, 0x000fe4000786c0ffULL, 0x0000005146ff7212ULL, 0x000fc4000788c0ffULL,
0x0000005166ff7212ULL, 0x000fe4000784c0ffULL, 0x000000576cff7212ULL, 0x040fe400078cc0ffULL,
0x000000196cff7212ULL, 0x000fe400078ac0ffULL, 0x0000003e7700720cULL, 0x0c0fe40000f21470ULL,
0x0000003e7700720cULL, 0x080fe40002781470ULL, 0x0000003e7500720cULL, 0x000fc40000701470ULL,
0x0000003e7300720cULL, 0x0c0fe40001f61470ULL, 0x0000003e7300720cULL, 0x080fe40001741470ULL,
0x0000003e4f00720cULL, 0x0c0fe400037c1470ULL, 0x0000003e4f00720cULL, 0x080fe40002fa1470ULL,
0x0000003e7100720cULL, 0x0c0fe40000f21070ULL, 0x0000003e7100720cULL, 0x000fc40002781070ULL,
0x0000003e6f00720cULL, 0x080fe40000701070ULL, 0x0000003e6d00720cULL, 0x0c0fe40001f61070ULL,
0x0000003e6d00720cULL, 0x080fe40001741070ULL, 0x0000003e4b00720cULL, 0x0c0fe400037c1070ULL,
0x0000003e4b00720cULL, 0x000fe40002fa1070ULL, 0x0000541012157816ULL, 0x000fc40000000015ULL,
0xff80000029297808ULL, 0x000fe40000800000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff80000024247808ULL, 0x000fe40000000000ULL, 0xff80000025257808ULL, 0x000fe40001800000ULL,
0xff80000027277808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fc40003000000ULL,
0xff80000022227808ULL, 0x000fe40002800000ULL, 0x000000576aff7212ULL, 0x080fe4000782c0ffULL,
0x0000005768ff7212ULL, 0x080fe4000788c0ffULL, 0x0000005764ff7212ULL, 0x000fe4000780c0ffULL,
0x000000196aff7212ULL, 0x080fe4000786c0ffULL, 0x0000001968ff7212ULL, 0x000fc4000784c0ffULL,
0x0000001964ff7212ULL, 0x000fe400078cc0ffULL, 0x0000001562ff7212ULL, 0x000fe400078ac0ffULL,
0x0000003e6b00720cULL, 0x0c0fe40000f21470ULL, 0x0000003e6b00720cULL, 0x080fe40001f61470ULL,
0x0000003e6900720cULL, 0x0c0fe40002781470ULL, 0x0000003e6900720cULL, 0x000fc40001741470ULL,
0x0000003e6700720cULL, 0x0c0fe40000701470ULL, 0x0000003e6700720cULL, 0x080fe400037c1470ULL,
0x0000003e5500720cULL, 0x080fe40002fa1470ULL, 0x0000003e6500720cULL, 0x0c0fe40000f21070ULL,
0x0000003e6500720cULL, 0x080fe40001f61070ULL, 0x0000003e6300720cULL, 0x000fc40002781070ULL,
0x0000003e6300720cULL, 0x080fe40001741070ULL, 0x0000003e6100720cULL, 0x0c0fe40000701070ULL,
0x0000003e6100720cULL, 0x080fe400037c1070ULL, 0x0000003e5300720cULL, 0x000fe40002fa1070ULL,
0x00005410165f7816ULL, 0x000fe4000000005fULL, 0xff80000021217808ULL, 0x000fc40000800000ULL,
0xff80000023237808ULL, 0x000fe40001800000ULL, 0xff8000001c1c7808ULL, 0x000fe40002000000ULL,
0xff8000001e1e7808ULL, 0x000fe40001000000ULL, 0xff8000001d1d7808ULL, 0x000fe40000000000ULL,
0xff8000001f1f7808ULL, 0x000fe40003000000ULL, 0xff80000030307808ULL, 0x000fc40002800000ULL,
0x0000001560ff7212ULL, 0x080fe4000782c0ffULL, 0x000000155eff7212ULL, 0x080fe4000786c0ffULL,
0x000000155aff7212ULL, 0x000fe4000788c0ffULL, 0x0000005f62ff7212ULL, 0x080fe4000784c0ffULL,
0x0000005f60ff7212ULL, 0x080fe4000780c0ffULL, 0x0000005f5eff7212ULL, 0x000fc400078cc0ffULL,
0x0000005f5aff7212ULL, 0x000fe400078ac0ffULL, 0x0000003e5500720cULL, 0x080fe40001741470ULL,
0x0000003e5d00720cULL, 0x0c0fe40000f21470ULL, 0x0000003e5d00720cULL, 0x080fe40000701470ULL,
0x0000003e5b00720cULL, 0x0c0fe40001f61470ULL, 0x0000003e5b00720cULL, 0x000fc400037c1470ULL,
0x0000003e5900720cULL, 0x0c0fe40002781470ULL, 0x0000003e5900720cULL, 0x080fe40002fa1470ULL,
0x0000003e5300720cULL, 0x080fe40001741070ULL, 0x0000003e1700720cULL, 0x0c0fe40000f21070ULL,
0x0000003e1700720cULL, 0x080fe40000701070ULL, 0x0000003e1300720cULL, 0x000fc40001f61070ULL,
0x0000003e1300720cULL, 0x080fe400037c1070ULL, 0x0000003e1100720cULL, 0x0c0fe40002781070ULL,
0x0000003e1100720cULL, 0x000fe40002fa1070ULL, 0xff80000034347808ULL, 0x000fe40000800000ULL,
0xff80000035357808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fc40002000000ULL,
0xff8000001a1a7808ULL, 0x000fe40001000000ULL, 0xff8000001b1b7808ULL, 0x000fe40000000000ULL,
0xff8000003c3c7808ULL, 0x000fe40003000000ULL, 0xff8000003d3d7808ULL, 0x000fce0002800000ULL,
0x0000000b0c00720bULL, 0x004fe20003f1e000ULL, 0x3f800000000a7882ULL, 0x000fe20000000000ULL,
0xfffffff8ff367812ULL, 0x000fe200078ee236ULL, 0x0000000107077836ULL, 0x000fe20000000000ULL,
0x0000000c0b0c7208ULL, 0x000fc80004000000ULL, 0x000000310c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c31097208ULL, 0x000fc80004000000ULL, 0x0000002c0900720bULL, 0x000fc80003f1e000ULL,
0x000000092c0c7208ULL, 0x000fc80004000000ULL, 0x0000002d0c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c2d097208ULL, 0x000fc80004000000ULL, 0x000000280900720bULL, 0x000fc80003f1e000ULL,
0x00000009280c7208ULL, 0x000fc80004000000ULL, 0x000000290c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c29097208ULL, 0x000fc80004000000ULL, 0x000000240900720bULL, 0x000fc80003f1e000ULL,
0x00000009240c7208ULL, 0x000fc80004000000ULL, 0x000000250c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c25097208ULL, 0x000fc80004000000ULL, 0x000000200900720bULL, 0x000fc80003f1e000ULL,
0x00000009200c7208ULL, 0x000fc80004000000ULL, 0x000000210c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c21097208ULL, 0x000fc80004000000ULL, 0x0000001c0900720bULL, 0x000fc80003f1e000ULL,
0x000000091c0c7208ULL, 0x000fe40004000000ULL, 0x000000320d00720bULL, 0x000fe40003f1e000ULL,
0x0000001d0c00720bULL, 0x000fc80003f3e000ULL, 0x0000000c1d097208ULL, 0x000fe40004800000ULL,
0x0000000d320c7208ULL, 0x000fe40004000000ULL, 0x000000300900720bULL, 0x000fe40003f3e000ULL,
0x000000330c00720bULL, 0x000fe40003f1e000ULL, 0x00000009300d7208ULL, 0x000fe40004800000ULL,
0x0000000c33097208ULL, 0x000fc40004000000ULL, 0x000000340d00720bULL, 0x000fe40003f3e000ULL,
0x0000002e0900720bULL, 0x000fe40003f1e000ULL, 0x0000000d34107208ULL, 0x000fe40004800000ULL,
0x000000092e0c7208ULL, 0x000fe40004000000ULL, 0x000000351000720bULL, 0x000fe40003f3e000ULL,
0x0000002f0c00720bULL, 0x000fc40003f1e000ULL, 0x0000001035107208ULL, 0x000fe40004800000ULL,
0x0000000c2f097208ULL, 0x000fe40004000000ULL, 0x000000371000720bULL, 0x000fe40003f3e000ULL,
0x0000002a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001037107208ULL, 0x000fe40004800000ULL,
0x000000092a0c7208ULL, 0x000fc60004000000ULL, 0x0c401f00100d7f89ULL, 0x000ea200000e0000ULL,
0x0000002b0c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c2b097208ULL, 0x000fc80004000000ULL,
0x000000260900720bULL, 0x000fc80003f1e000ULL, 0x00000009260c7208ULL, 0x000fc80004000000ULL,
0x000000270c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c27097208ULL, 0x000fe40004000000ULL,
0x0000000d1000720bULL, 0x004fe40003f3e000ULL, 0x000000220900720bULL, 0x000fe40003f1e000ULL,
0x000000100d0d7208ULL, 0x000fe40004800000ULL, 0x00000009220c7208ULL, 0x000fc60004000000ULL,
0x0c201f000d107f89ULL, 0x000ea200000e0000ULL, 0x000000230c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c23097208ULL, 0x000fc80004000000ULL, 0x0000001e0900720bULL, 0x000fc80003f1e000ULL,
0x000000091e0c7208ULL, 0x000fc80004000000ULL, 0x0000001f0c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c1f097208ULL, 0x000fe40004000000ULL, 0x000000100d00720bULL, 0x004fe40003f3e000ULL,
0x0000001a0900720bULL, 0x000fe40003f1e000ULL, 0x0000000d100c7208ULL, 0x000fe40004800000ULL,
0x000000091a107208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b0c127820ULL, 0x000fe20000410000ULL,
0x0000001b1000720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010812ULL,
0x000000101b097208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010812ULL,
0x0000003c0900720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010812ULL,
0x000000093c107208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010812ULL,
0x0000003d1000720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010812ULL,
0x000000103d107208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b37127823ULL, 0x000fe20000010812ULL,
0x0000003100147308ULL, 0x000fe20000000800ULL, 0x0c401f0010097f89ULL, 0x000eae00000e0000ULL,
0x0000002000187308ULL, 0x000ff00000000800ULL, 0x0000001c00317308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000ee20000000800ULL, 0x000000091000720bULL, 0x004fc80003f1e000ULL,
0x0000001009097208ULL, 0x000fc60004000000ULL, 0x0000002c002c7308ULL, 0x000fe40000000800ULL,
0x0c201f0009107f89ULL, 0x000eac00000e0000ULL, 0x0000002d002d7308ULL, 0x000f300000000800ULL,
0x0000002400167308ULL, 0x000bf00000000800ULL, 0x0000002500157308ULL, 0x0007220000000800ULL,
0x0000000aff247e24ULL, 0x022fe2000f8e00ffULL, 0x000000100900720bULL, 0x004fc80003f1e000ULL,
0x00000009100d7208ULL, 0x000fe40004000000ULL, 0x3f8000002424783eULL, 0x000fe200000010ffULL,
0x0000001200407308ULL, 0x0009e20000000800ULL, 0x0000000b1410723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b0d377820ULL, 0x000fe40000410000ULL, 0x000000ffff257224ULL, 0x000fe400078e0024ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010837ULL,
0x0000003200117308ULL, 0x000fe20000000800ULL, 0x0000002c2d12723eULL, 0x010fe200000010ffULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b23097823ULL, 0x100fe20000010837ULL,
0x00000033001c7308ULL, 0x000e620000000800ULL, 0x000000161516723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b1a0b7823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b3c3c7823ULL, 0x000fc60000010837ULL,
0x0000002e00137308ULL, 0x000fe20000000800ULL, 0x000000111c11723eULL, 0x002fce00000010ffULL,
0x0000002f00207308ULL, 0x000e620000000800ULL, 0x0c401f000f1c7f89ULL, 0x000eae00000e0000ULL,
0x0000001d003e7308ULL, 0x000ee20000000800ULL, 0x000000132013723eULL, 0x002fce00000010ffULL,
0x0000002100197308ULL, 0x000e620000000800ULL, 0x000000313e1a723eULL, 0x008fce00000010ffULL,
0x00000022001d7308ULL, 0x0007e20000000800ULL, 0x0000001c0f00720bULL, 0x004fc80003f3e000ULL,
0x0000000f1c0f7208ULL, 0x000fe40004800000ULL, 0x000000181918723eULL, 0x002fe200000010ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000241020723cULL, 0x008fe200000418ffULL,
0x0c201f000f2c7f89ULL, 0x000e6c00000e0000ULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b1b257823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b3d377823ULL, 0x000fcc0000010837ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000002a2b15723eULL, 0x004fce00000010ffULL,
0x0000002900297308ULL, 0x000ea20000000800ULL, 0x000000ffff2a7224ULL, 0x100fe200078e0024ULL,
0x0000002c0f00720bULL, 0x002fe20003f3e000ULL, 0x000000ffff2b7224ULL, 0x000fc600078e0024ULL,
0x0000000f2c0f7208ULL, 0x000fe40004800000ULL, 0x0000002600177308ULL, 0x000fe20000000800ULL,
0x000000282914723eULL, 0x004fce00000010ffULL, 0x0000002700327308ULL, 0x000e620000000800ULL,
0x0000000836297824ULL, 0x000fce00078e00ffULL, 0x0000000900267308ULL, 0x0004e20000000800ULL,
0x000000173217723eULL, 0x002fce00000010ffULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x0c401f000e097f89ULL, 0x004e6200000e0000ULL, 0x0000002a1420723cULL, 0x000fe20000041820ULL,
0x0000001d2619723eULL, 0x008fca00000010ffULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x0000000836267836ULL, 0x000fc80000000000ULL, 0x00000008262d7824ULL, 0x000fc600078e00ffULL,
0x0000002500287308ULL, 0x0007e20000000800ULL, 0x0000001e1f1b723eULL, 0x004fce00000010ffULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x000000ffff257224ULL, 0x008fe200078e0024ULL,
0x000000090e00720bULL, 0x002fc80003f1e000ULL, 0x0000000e090e7208ULL, 0x000fe40004000000ULL,
0x000000241820723cULL, 0x000fe20000041820ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x00000003ff097819ULL, 0x000fc80000011603ULL, 0x0000000309097812ULL, 0x000fe400078ec0ffULL,
0x0000000b281d723eULL, 0x004fe200000010ffULL, 0x00000034003f7308ULL, 0x000e620000000800ULL,
0x00000008360b7824ULL, 0x000fe200078e00ffULL, 0x0000000839257c11ULL, 0x000fe2000f8e58ffULL,
0x0000000109367824ULL, 0x040fe400078e0236ULL, 0x0000000109277824ULL, 0x000fe400078e0226ULL,
0x0c201f000e097f89ULL, 0x000ea200000e0000ULL, 0x0000003500357308ULL, 0x000ee20000000800ULL,
0x0000000826287824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee236ULL,
0x0000000436247836ULL, 0x000fc40000000000ULL, 0x00011000252e7836ULL, 0x000fe20000000000ULL,
0xfffffff828277812ULL, 0x000fe200078ee227ULL, 0x0000000c36367836ULL, 0x000fe20000000000ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000303f1c723eULL, 0x002fe200000010ffULL,
0x000000100b0b7824ULL, 0x000fe200078e022eULL, 0xfffffff829257812ULL, 0x000fe200078ee224ULL,
0x000000ffff247224ULL, 0x000fe200078e0010ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee236ULL,
0x000000ffff267224ULL, 0x000fe200078e0014ULL, 0x00000035401e723eULL, 0x008fe200000010ffULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fc400078e0018ULL,
0x000000ffff297224ULL, 0x000fe400078e001aULL, 0x000000ffff107224ULL, 0x000fe200078e0011ULL,
0x000000090e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff137224ULL, 0x000fe200078e0017ULL, 0x0000000e090e7208ULL, 0x000fe20004000000ULL,
0x000000102d2d7824ULL, 0x000fe200078e022eULL, 0x0000000303ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff147224ULL, 0x000fe200078e0019ULL, 0x0000003c371f723eULL, 0x002fe200000010ffULL,
0x00000001ff097424ULL, 0x000fc800078e00ffULL, 0x000000ffff177224ULL, 0x000fe400078e001fULL,
0x0000002a1c20723cULL, 0x000fee0000041820ULL, 0x000000ffff2a7224ULL, 0x000fe400078e001cULL,
0x000000ffff2b7224ULL, 0x000fd600078e001eULL, 0x0000001027237824ULL, 0x100fe400078e022eULL,
0x0000001025217824ULL, 0x000fe400078e022eULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff277224ULL, 0x000fe400078e0016ULL, 0x000000ffff127224ULL, 0x000fe400078e0015ULL,
0x000000ffff157224ULL, 0x000fe200078e001bULL, 0x000000240b007844ULL, 0x0003e20000000200ULL,
0x000000ffff167224ULL, 0x000fc600078e001dULL, 0x0000002821007844ULL, 0x0005e80000000200ULL,
0x0000001023007844ULL, 0x0007e80000000200ULL, 0x000000142d007844ULL, 0x0007e80000000200ULL,
0x0170000c3b008388ULL, 0x0007e20000000c00ULL, 0x000000ffff0b7224ULL, 0x002fc400078e000aULL,
0x000000ffff217224ULL, 0x004fca00078e0022ULL, 0x017200203b008388ULL, 0x0007e20000000a00ULL,
0x000000380700720cULL, 0x000fe20003f06070ULL, 0x0176080906ff79a7ULL, 0x0007e2000850003fULL,
0x0176100906ff79a7ULL, 0x0007e2000850003fULL, 0x0176180906ff79a7ULL, 0x0007e2000850003fULL,
0x0176200906ff79a7ULL, 0x0007f2000850003fULL, 0xffffffa800108947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000050007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000005000008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff50ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000050027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000005000007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffeb002d47950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x000000000000057fULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000700ULL, 0x0000000000000258ULL,
0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000958ULL, 0x00000000000000e0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a38ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a8cULL, 0x0000000000000660ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001138ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000014d80ULL,
0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015f00ULL, 0x0000000000000048ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015f50ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000015f50ULL, 0x0000000000000268ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000016538ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016538ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001138ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000014d80ULL, 0x0000000000014d80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000015f00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000050ULL,
0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015f50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_90_cubin_len = 91784;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
